import type { IHsl, IParticle, Particle } from "tsparticles-engine";
import type { IImageShape } from "./IImageShape";
export interface IImage {
    element?: HTMLImageElement;
    error: boolean;
    loading: boolean;
    source: string;
    svgData?: string;
    type: string;
}
export interface IParticleImage {
    data: IImage;
    element?: HTMLImageElement;
    loaded?: boolean;
    ratio: number;
    replaceColor: boolean;
    source: string;
}
export interface ContainerImage {
    id: string;
    images: IImage[];
}
export declare type IImageParticle = IParticle & {
    image?: IParticleImage;
};
export declare function loadImage(image: IImage): Promise<void>;
export declare function downloadSvgImage(image: IImage): Promise<void>;
export declare function replaceImageColor(image: IImage, imageData: IImageShape, color: IHsl, particle: Particle): IParticleImage;
