import type { ICoordinates, IParticle, IShapeDrawer } from "tsparticles-engine";
export interface ISideCount {
    denominator: number;
    numerator: number;
}
export interface ISide {
    count: ISideCount;
    length: number;
}
export declare abstract class PolygonDrawerBase implements IShapeDrawer {
    draw(context: CanvasRenderingContext2D, particle: IParticle, radius: number): void;
    getSidesCount(particle: IParticle): number;
    abstract getCenter(particle: IParticle, radius: number): ICoordinates;
    abstract getSidesData(particle: IParticle, radius: number): ISide;
}
