(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "tsparticles-particles.js", "tsparticles-updater-angle", "tsparticles-move-base", "tsparticles-shape-circle", "tsparticles-updater-color", "tsparticles-interaction-external-attract", "tsparticles-interaction-external-bounce", "tsparticles-interaction-external-bubble", "tsparticles-interaction-external-connect", "tsparticles-interaction-external-grab", "tsparticles-interaction-external-pause", "tsparticles-interaction-external-push", "tsparticles-interaction-external-remove", "tsparticles-interaction-external-repulse", "tsparticles-shape-image", "tsparticles-updater-life", "tsparticles-shape-line", "tsparticles-updater-opacity", "tsparticles-updater-out-modes", "tsparticles-move-parallax", "tsparticles-interaction-particles-attract", "tsparticles-interaction-particles-collisions", "tsparticles-interaction-particles-links", "tsparticles-shape-polygon", "tsparticles-updater-size", "tsparticles-shape-square", "tsparticles-shape-star", "tsparticles-updater-stroke-color", "tsparticles-shape-text"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.loadSlim = void 0;
    const tsparticles_particles_js_1 = require("tsparticles-particles.js");
    const tsparticles_updater_angle_1 = require("tsparticles-updater-angle");
    const tsparticles_move_base_1 = require("tsparticles-move-base");
    const tsparticles_shape_circle_1 = require("tsparticles-shape-circle");
    const tsparticles_updater_color_1 = require("tsparticles-updater-color");
    const tsparticles_interaction_external_attract_1 = require("tsparticles-interaction-external-attract");
    const tsparticles_interaction_external_bounce_1 = require("tsparticles-interaction-external-bounce");
    const tsparticles_interaction_external_bubble_1 = require("tsparticles-interaction-external-bubble");
    const tsparticles_interaction_external_connect_1 = require("tsparticles-interaction-external-connect");
    const tsparticles_interaction_external_grab_1 = require("tsparticles-interaction-external-grab");
    const tsparticles_interaction_external_pause_1 = require("tsparticles-interaction-external-pause");
    const tsparticles_interaction_external_push_1 = require("tsparticles-interaction-external-push");
    const tsparticles_interaction_external_remove_1 = require("tsparticles-interaction-external-remove");
    const tsparticles_interaction_external_repulse_1 = require("tsparticles-interaction-external-repulse");
    const tsparticles_shape_image_1 = require("tsparticles-shape-image");
    const tsparticles_updater_life_1 = require("tsparticles-updater-life");
    const tsparticles_shape_line_1 = require("tsparticles-shape-line");
    const tsparticles_updater_opacity_1 = require("tsparticles-updater-opacity");
    const tsparticles_updater_out_modes_1 = require("tsparticles-updater-out-modes");
    const tsparticles_move_parallax_1 = require("tsparticles-move-parallax");
    const tsparticles_interaction_particles_attract_1 = require("tsparticles-interaction-particles-attract");
    const tsparticles_interaction_particles_collisions_1 = require("tsparticles-interaction-particles-collisions");
    const tsparticles_interaction_particles_links_1 = require("tsparticles-interaction-particles-links");
    const tsparticles_shape_polygon_1 = require("tsparticles-shape-polygon");
    const tsparticles_updater_size_1 = require("tsparticles-updater-size");
    const tsparticles_shape_square_1 = require("tsparticles-shape-square");
    const tsparticles_shape_star_1 = require("tsparticles-shape-star");
    const tsparticles_updater_stroke_color_1 = require("tsparticles-updater-stroke-color");
    const tsparticles_shape_text_1 = require("tsparticles-shape-text");
    async function loadSlim(engine) {
        await (0, tsparticles_move_base_1.loadBaseMover)(engine);
        await (0, tsparticles_move_parallax_1.loadParallaxMover)(engine);
        await (0, tsparticles_interaction_external_attract_1.loadExternalAttractInteraction)(engine);
        await (0, tsparticles_interaction_external_bounce_1.loadExternalBounceInteraction)(engine);
        await (0, tsparticles_interaction_external_bubble_1.loadExternalBubbleInteraction)(engine);
        await (0, tsparticles_interaction_external_connect_1.loadExternalConnectInteraction)(engine);
        await (0, tsparticles_interaction_external_grab_1.loadExternalGrabInteraction)(engine);
        await (0, tsparticles_interaction_external_pause_1.loadExternalPauseInteraction)(engine);
        await (0, tsparticles_interaction_external_push_1.loadExternalPushInteraction)(engine);
        await (0, tsparticles_interaction_external_remove_1.loadExternalRemoveInteraction)(engine);
        await (0, tsparticles_interaction_external_repulse_1.loadExternalRepulseInteraction)(engine);
        await (0, tsparticles_interaction_particles_attract_1.loadParticlesAttractInteraction)(engine);
        await (0, tsparticles_interaction_particles_collisions_1.loadParticlesCollisionsInteraction)(engine);
        await (0, tsparticles_interaction_particles_links_1.loadParticlesLinksInteraction)(engine);
        await (0, tsparticles_shape_circle_1.loadCircleShape)(engine);
        await (0, tsparticles_shape_image_1.loadImageShape)(engine);
        await (0, tsparticles_shape_line_1.loadLineShape)(engine);
        await (0, tsparticles_shape_polygon_1.loadPolygonShape)(engine);
        await (0, tsparticles_shape_square_1.loadSquareShape)(engine);
        await (0, tsparticles_shape_star_1.loadStarShape)(engine);
        await (0, tsparticles_shape_text_1.loadTextShape)(engine);
        await (0, tsparticles_updater_life_1.loadLifeUpdater)(engine);
        await (0, tsparticles_updater_opacity_1.loadOpacityUpdater)(engine);
        await (0, tsparticles_updater_size_1.loadSizeUpdater)(engine);
        await (0, tsparticles_updater_angle_1.loadAngleUpdater)(engine);
        await (0, tsparticles_updater_color_1.loadColorUpdater)(engine);
        await (0, tsparticles_updater_stroke_color_1.loadStrokeColorUpdater)(engine);
        await (0, tsparticles_updater_out_modes_1.loadOutModesUpdater)(engine);
        await (0, tsparticles_particles_js_1.initPjs)(engine);
    }
    exports.loadSlim = loadSlim;
});
