"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BounceOutMode = void 0;
const tsparticles_engine_1 = require("tsparticles-engine");
const Utils_1 = require("./Utils");
class BounceOutMode {
    constructor(container) {
        this.container = container;
        this.modes = [
            "bounce",
            "bounce-vertical",
            "bounce-horizontal",
            "bounceVertical",
            "bounceHorizontal",
            "split",
        ];
    }
    update(particle, direction, delta, outMode) {
        if (!this.modes.includes(outMode)) {
            return;
        }
        const container = this.container;
        let handled = false;
        for (const [, plugin] of container.plugins) {
            if (plugin.particleBounce !== undefined) {
                handled = plugin.particleBounce(particle, delta, direction);
            }
            if (handled) {
                break;
            }
        }
        if (handled) {
            return;
        }
        const pos = particle.getPosition(), offset = particle.offset, size = particle.getRadius(), bounds = (0, tsparticles_engine_1.calculateBounds)(pos, size), canvasSize = container.canvas.size;
        (0, Utils_1.bounceHorizontal)({ particle, outMode, direction, bounds, canvasSize, offset, size });
        (0, Utils_1.bounceVertical)({ particle, outMode, direction, bounds, canvasSize, offset, size });
    }
}
exports.BounceOutMode = BounceOutMode;
