"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DestroyOutMode = void 0;
const tsparticles_engine_1 = require("tsparticles-engine");
class DestroyOutMode {
    constructor(container) {
        this.container = container;
        this.modes = ["destroy"];
    }
    update(particle, direction, delta, outMode) {
        if (!this.modes.includes(outMode)) {
            return;
        }
        const container = this.container;
        switch (particle.outType) {
            case "normal":
            case "outside":
                if ((0, tsparticles_engine_1.isPointInside)(particle.position, container.canvas.size, tsparticles_engine_1.Vector.origin, particle.getRadius(), direction)) {
                    return;
                }
                break;
            case "inside": {
                const { dx, dy } = (0, tsparticles_engine_1.getDistances)(particle.position, particle.moveCenter);
                const { x: vx, y: vy } = particle.velocity;
                if ((vx < 0 && dx > particle.moveCenter.radius) ||
                    (vy < 0 && dy > particle.moveCenter.radius) ||
                    (vx >= 0 && dx < -particle.moveCenter.radius) ||
                    (vy >= 0 && dy < -particle.moveCenter.radius)) {
                    return;
                }
                break;
            }
        }
        container.particles.remove(particle, undefined, true);
    }
}
exports.DestroyOutMode = DestroyOutMode;
