"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OutOfCanvasUpdater = void 0;
const BounceOutMode_1 = require("./BounceOutMode");
const DestroyOutMode_1 = require("./DestroyOutMode");
const NoneOutMode_1 = require("./NoneOutMode");
const OutOutMode_1 = require("./OutOutMode");
class OutOfCanvasUpdater {
    constructor(container) {
        this.container = container;
        this.updaters = [
            new BounceOutMode_1.BounceOutMode(container),
            new DestroyOutMode_1.DestroyOutMode(container),
            new OutOutMode_1.OutOutMode(container),
            new NoneOutMode_1.NoneOutMode(container),
        ];
    }
    init() {
    }
    isEnabled(particle) {
        return !particle.destroyed && !particle.spawning;
    }
    update(particle, delta) {
        var _a, _b, _c, _d;
        const outModes = particle.options.move.outModes;
        this.updateOutMode(particle, delta, (_a = outModes.bottom) !== null && _a !== void 0 ? _a : outModes.default, "bottom");
        this.updateOutMode(particle, delta, (_b = outModes.left) !== null && _b !== void 0 ? _b : outModes.default, "left");
        this.updateOutMode(particle, delta, (_c = outModes.right) !== null && _c !== void 0 ? _c : outModes.default, "right");
        this.updateOutMode(particle, delta, (_d = outModes.top) !== null && _d !== void 0 ? _d : outModes.default, "top");
    }
    updateOutMode(particle, delta, outMode, direction) {
        for (const updater of this.updaters) {
            updater.update(particle, direction, delta, outMode);
        }
    }
}
exports.OutOfCanvasUpdater = OutOfCanvasUpdater;
