(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "tsparticles-engine"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.OutOutMode = void 0;
    const tsparticles_engine_1 = require("tsparticles-engine");
    class OutOutMode {
        constructor(container) {
            this.container = container;
            this.modes = ["out"];
        }
        update(particle, direction, delta, outMode) {
            if (!this.modes.includes(outMode)) {
                return;
            }
            const container = this.container;
            switch (particle.outType) {
                case "inside": {
                    const { x: vx, y: vy } = particle.velocity;
                    const circVec = tsparticles_engine_1.Vector.origin;
                    circVec.length = particle.moveCenter.radius;
                    circVec.angle = particle.velocity.angle + Math.PI;
                    circVec.addTo(tsparticles_engine_1.Vector.create(particle.moveCenter));
                    const { dx, dy } = (0, tsparticles_engine_1.getDistances)(particle.position, circVec);
                    if ((vx <= 0 && dx >= 0) || (vy <= 0 && dy >= 0) || (vx >= 0 && dx <= 0) || (vy >= 0 && dy <= 0)) {
                        return;
                    }
                    particle.position.x = Math.floor((0, tsparticles_engine_1.randomInRange)({
                        min: 0,
                        max: container.canvas.size.width,
                    }));
                    particle.position.y = Math.floor((0, tsparticles_engine_1.randomInRange)({
                        min: 0,
                        max: container.canvas.size.height,
                    }));
                    const { dx: newDx, dy: newDy } = (0, tsparticles_engine_1.getDistances)(particle.position, particle.moveCenter);
                    particle.direction = Math.atan2(-newDy, -newDx);
                    particle.velocity.angle = particle.direction;
                    break;
                }
                default: {
                    if ((0, tsparticles_engine_1.isPointInside)(particle.position, container.canvas.size, tsparticles_engine_1.Vector.origin, particle.getRadius(), direction)) {
                        return;
                    }
                    switch (particle.outType) {
                        case "outside": {
                            particle.position.x =
                                Math.floor((0, tsparticles_engine_1.randomInRange)({
                                    min: -particle.moveCenter.radius,
                                    max: particle.moveCenter.radius,
                                })) + particle.moveCenter.x;
                            particle.position.y =
                                Math.floor((0, tsparticles_engine_1.randomInRange)({
                                    min: -particle.moveCenter.radius,
                                    max: particle.moveCenter.radius,
                                })) + particle.moveCenter.y;
                            const { dx, dy } = (0, tsparticles_engine_1.getDistances)(particle.position, particle.moveCenter);
                            if (particle.moveCenter.radius) {
                                particle.direction = Math.atan2(dy, dx);
                                particle.velocity.angle = particle.direction;
                            }
                            break;
                        }
                        case "normal": {
                            const wrap = particle.options.move.warp, canvasSize = container.canvas.size, newPos = {
                                bottom: canvasSize.height + particle.getRadius() + particle.offset.y,
                                left: -particle.getRadius() - particle.offset.x,
                                right: canvasSize.width + particle.getRadius() + particle.offset.x,
                                top: -particle.getRadius() - particle.offset.y,
                            }, sizeValue = particle.getRadius(), nextBounds = (0, tsparticles_engine_1.calculateBounds)(particle.position, sizeValue);
                            if (direction === "right" &&
                                nextBounds.left > canvasSize.width + particle.offset.x) {
                                particle.position.x = newPos.left;
                                particle.initialPosition.x = particle.position.x;
                                if (!wrap) {
                                    particle.position.y = Math.random() * canvasSize.height;
                                    particle.initialPosition.y = particle.position.y;
                                }
                            }
                            else if (direction === "left" && nextBounds.right < -particle.offset.x) {
                                particle.position.x = newPos.right;
                                particle.initialPosition.x = particle.position.x;
                                if (!wrap) {
                                    particle.position.y = Math.random() * canvasSize.height;
                                    particle.initialPosition.y = particle.position.y;
                                }
                            }
                            if (direction === "bottom" &&
                                nextBounds.top > canvasSize.height + particle.offset.y) {
                                if (!wrap) {
                                    particle.position.x = Math.random() * canvasSize.width;
                                    particle.initialPosition.x = particle.position.x;
                                }
                                particle.position.y = newPos.top;
                                particle.initialPosition.y = particle.position.y;
                            }
                            else if (direction === "top" && nextBounds.bottom < -particle.offset.y) {
                                if (!wrap) {
                                    particle.position.x = Math.random() * canvasSize.width;
                                    particle.initialPosition.x = particle.position.x;
                                }
                                particle.position.y = newPos.bottom;
                                particle.initialPosition.y = particle.position.y;
                            }
                            break;
                        }
                    }
                    break;
                }
            }
        }
    }
    exports.OutOutMode = OutOutMode;
});
