import type { IDelta, IParticleTransformValues, IParticleUpdater, IParticlesOptions, Particle, ParticlesOptions, RecursivePartial } from "tsparticles-engine";
import type { IRoll } from "./Options/Interfaces/IRoll";
import { Roll } from "./Options/Classes/Roll";
declare type RollParticle = Particle & {
    options: RollParticlesOptions;
};
declare type RollParticlesOptions = ParticlesOptions & {
    roll?: Roll;
};
declare type IRollParticlesOptions = IParticlesOptions & {
    roll?: IRoll;
};
export declare class RollUpdater implements IParticleUpdater {
    getTransformValues(particle: Particle): IParticleTransformValues;
    init(particle: RollParticle): void;
    isEnabled(particle: RollParticle): boolean;
    loadOptions(options: RollParticlesOptions, ...sources: (RecursivePartial<IRollParticlesOptions> | undefined)[]): void;
    update(particle: Particle, delta: IDelta): void;
}
export {};
