import type { Container, IDelta, IParticleTransformValues, IParticleUpdater, IParticleValueAnimation, IParticlesOptions, Particle, ParticlesOptions, RecursivePartial } from "tsparticles-engine";
import type { ITilt } from "./Options/Interfaces/ITilt";
import { Tilt } from "./Options/Classes/Tilt";
export interface IParticleTiltValueAnimation extends IParticleValueAnimation<number> {
    cosDirection: number;
    sinDirection: number;
}
declare type TiltParticle = Particle & {
    options: TiltParticlesOptions;
    tilt?: IParticleTiltValueAnimation;
};
declare type ITiltParticlesOptions = IParticlesOptions & {
    tilt?: ITilt;
};
declare type TiltParticlesOptions = ParticlesOptions & {
    tilt?: Tilt;
};
export declare class TiltUpdater implements IParticleUpdater {
    private readonly container;
    constructor(container: Container);
    getTransformValues(particle: TiltParticle): IParticleTransformValues;
    init(particle: TiltParticle): void;
    isEnabled(particle: TiltParticle): boolean;
    loadOptions(options: TiltParticlesOptions, ...sources: (RecursivePartial<ITiltParticlesOptions> | undefined)[]): void;
    update(particle: Particle, delta: IDelta): void;
}
export {};
