(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "./TiltAnimation", "tsparticles-engine"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Tilt = void 0;
    const TiltAnimation_1 = require("./TiltAnimation");
    const tsparticles_engine_1 = require("tsparticles-engine");
    class Tilt extends tsparticles_engine_1.ValueWithRandom {
        constructor() {
            super();
            this.animation = new TiltAnimation_1.TiltAnimation();
            this.direction = "clockwise";
            this.enable = false;
            this.value = 0;
        }
        load(data) {
            super.load(data);
            if (!data) {
                return;
            }
            this.animation.load(data.animation);
            if (data.direction !== undefined) {
                this.direction = data.direction;
            }
            if (data.enable !== undefined) {
                this.enable = data.enable;
            }
        }
    }
    exports.Tilt = Tilt;
});
