import type { IParticleColorStyle, IParticleUpdater, IParticlesOptions, Particle, ParticlesOptions, RecursivePartial } from "tsparticles-engine";
import type { ITwinkle } from "./Options/Interfaces/ITwinkle";
import { Twinkle } from "./Options/Classes/Twinkle";
declare type TwinkeParticle = Particle & {
    options: TwinkleParticlesOptions;
};
declare type ITwinkleParticlesOptions = IParticlesOptions & {
    twinkle?: ITwinkle;
};
declare type TwinkleParticlesOptions = ParticlesOptions & {
    twinkle?: Twinkle;
};
export declare class TwinkleUpdater implements IParticleUpdater {
    getColorStyles(particle: Particle, context: CanvasRenderingContext2D, radius: number, opacity: number): IParticleColorStyle;
    init(): void;
    isEnabled(particle: TwinkeParticle): boolean;
    loadOptions(options: TwinkleParticlesOptions, ...sources: (RecursivePartial<ITwinkleParticlesOptions> | undefined)[]): void;
    update(): void;
}
export {};
