(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "tsparticles-engine"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.TwinkleValues = void 0;
    const tsparticles_engine_1 = require("tsparticles-engine");
    class TwinkleValues {
        constructor() {
            this.enable = false;
            this.frequency = 0.05;
            this.opacity = 1;
        }
        load(data) {
            if (!data) {
                return;
            }
            if (data.color !== undefined) {
                this.color = tsparticles_engine_1.OptionsColor.create(this.color, data.color);
            }
            if (data.enable !== undefined) {
                this.enable = data.enable;
            }
            if (data.frequency !== undefined) {
                this.frequency = data.frequency;
            }
            if (data.opacity !== undefined) {
                this.opacity = (0, tsparticles_engine_1.setRangeValue)(data.opacity);
            }
        }
    }
    exports.TwinkleValues = TwinkleValues;
});
