(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "tsparticles-engine", "./Options/Classes/Twinkle"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.TwinkleUpdater = void 0;
    const tsparticles_engine_1 = require("tsparticles-engine");
    const Twinkle_1 = require("./Options/Classes/Twinkle");
    class TwinkleUpdater {
        getColorStyles(particle, context, radius, opacity) {
            const pOptions = particle.options, twinkleOptions = pOptions.twinkle;
            if (!twinkleOptions) {
                return {};
            }
            const twinkle = twinkleOptions.particles, twinkling = twinkle.enable && Math.random() < twinkle.frequency, zIndexOptions = particle.options.zIndex, zOpacityFactor = (1 - particle.zIndexFactor) ** zIndexOptions.opacityRate, twinklingOpacity = twinkling ? (0, tsparticles_engine_1.getRangeValue)(twinkle.opacity) * zOpacityFactor : opacity, twinkleRgb = (0, tsparticles_engine_1.rangeColorToHsl)(twinkle.color), twinkleStyle = twinkleRgb ? (0, tsparticles_engine_1.getStyleFromHsl)(twinkleRgb, twinklingOpacity) : undefined, res = {}, needsTwinkle = twinkling && twinkleStyle;
            res.fill = needsTwinkle ? twinkleStyle : undefined;
            res.stroke = needsTwinkle ? twinkleStyle : undefined;
            return res;
        }
        init() {
        }
        isEnabled(particle) {
            const pOptions = particle.options, twinkleOptions = pOptions.twinkle;
            if (!twinkleOptions) {
                return false;
            }
            return twinkleOptions.particles.enable;
        }
        loadOptions(options, ...sources) {
            for (const source of sources) {
                if (!(source === null || source === void 0 ? void 0 : source.twinkle)) {
                    continue;
                }
                if (!options.twinkle) {
                    options.twinkle = new Twinkle_1.Twinkle();
                }
                options.twinkle.load(source.twinkle);
            }
        }
        update() {
        }
    }
    exports.TwinkleUpdater = TwinkleUpdater;
});
