import { Bubbler } from "./Particle/Bubbler";
import type { Container } from "./Container";
import { Drawer } from "./Particle/Drawer";
import { Grabber } from "./Particle/Grabber";
import type { IVelocity } from "../Interfaces/IVelocity";
import type { ISize } from "../Interfaces/ISize";
import type { IOpacity } from "../Interfaces/IOpacity";
import type { ICoordinates } from "../Interfaces/ICoordinates";
import type { IParticleImage } from "../Interfaces/IParticleImage";
import { Repulser } from "./Particle/Repulser";
import { ShapeType } from "../Enums/ShapeType";
import { Updater } from "./Particle/Updater";
import { Connecter } from "./Particle/Connecter";
import type { IRgb } from "../Interfaces/IRgb";
import { InteractionManager } from "./Particle/InteractionManager";
import { RotateDirection } from "../Enums/RotateDirection";
import type { ICharacterShape } from "../Interfaces/Options/Particles/Shape/ICharacterShape";
import type { IPolygonShape } from "../Interfaces/Options/Particles/Shape/IPolygonShape";
import type { IStroke } from "../Interfaces/Options/Particles/IStroke";
import { IParticle } from "../Interfaces/IParticle";
import { IShapeValues } from "../Interfaces/Options/Particles/Shape/IShapeValues";
export declare class Particle implements IParticle {
    angle: number;
    rotateDirection: RotateDirection;
    radius: number;
    readonly fill: boolean;
    readonly close: boolean;
    readonly stroke: IStroke;
    readonly polygon?: IPolygonShape;
    readonly text?: string;
    readonly size: ISize;
    readonly initialPosition?: ICoordinates;
    readonly position: ICoordinates;
    readonly offset: ICoordinates;
    readonly color: IRgb | undefined;
    readonly strokeColor: IRgb | undefined;
    readonly shadowColor: IRgb | undefined;
    readonly opacity: IOpacity;
    readonly velocity: IVelocity;
    readonly shape?: ShapeType | string;
    readonly image?: IParticleImage;
    readonly character?: ICharacterShape;
    readonly initialVelocity: IVelocity;
    readonly shapeData?: IShapeValues;
    readonly updater: Updater;
    readonly bubbler: Bubbler;
    readonly repulser: Repulser;
    readonly connecter: Connecter;
    readonly drawer: Drawer;
    readonly grabber: Grabber;
    readonly interactionManager: InteractionManager;
    readonly container: Container;
    constructor(container: Container, position?: ICoordinates);
    private static calculateVelocity;
    resetVelocity(): void;
    update(index: number, delta: number): void;
    interact(p2: Particle): void;
    draw(): void;
    isOverlapping(): {
        collisionFound: boolean;
        iterations: number;
    };
    checkOverlap(position?: ICoordinates): void;
    private calcPosition;
}
