"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isConstructorToken = exports.isTransformDescriptor = exports.isTokenDescriptor = exports.isNormalToken = void 0;
const lazy_helpers_1 = require("../lazy-helpers");
function isNormalToken(token) {
    return typeof token === "string" || typeof token === "symbol";
}
exports.isNormalToken = isNormalToken;
function isTokenDescriptor(descriptor) {
    return (typeof descriptor === "object" &&
        "token" in descriptor &&
        "multiple" in descriptor);
}
exports.isTokenDescriptor = isTokenDescriptor;
function isTransformDescriptor(descriptor) {
    return (typeof descriptor === "object" &&
        "token" in descriptor &&
        "transform" in descriptor);
}
exports.isTransformDescriptor = isTransformDescriptor;
function isConstructorToken(token) {
    return typeof token === "function" || token instanceof lazy_helpers_1.DelayedConstructor;
}
exports.isConstructorToken = isConstructorToken;
