// Copyright 2015 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Hash table on the 4-byte prefixes of static dictionary words.

#ifndef BROTLI_ENC_DICTIONARY_HASH_H_
#define BROTLI_ENC_DICTIONARY_HASH_H_

#include <stdint.h>

namespace brotli {

static const uint16_t kStaticDictionaryHash[] = {
  0x7d48, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5564, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x9e26, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb2e6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x114b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1364, 0x1aac, 0x1ea4, 0x0000, 0x4e04,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x46a9, 0x4b65, 0x0000, 0x0000,
  0x0000, 0x3d84, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6867, 0x08cd, 0x0000, 0x0000, 0x4364, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e26,
  0x0000, 0x0000, 0x0000, 0x0000, 0x59c8, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xbc26, 0x0000, 0x85c7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xbd66, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x09cf, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4c4c, 0x0000, 0x0000, 0x5dc4,
  0x0000, 0x0000, 0x0000, 0x2664, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7885, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ce6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x50aa, 0x0964,
  0x0000, 0x5125, 0x3968, 0x2286, 0x0000, 0x1904, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xcaa7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1a69, 0x1c26, 0x0000, 0x0000, 0x55e8, 0x59c7, 0x0000, 0x0000,
  0x0dc9, 0x0000, 0x0748, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2b26, 0x0000, 0x0000, 0x5fe8, 0x0000, 0x0000, 0x0000,
  0x196b, 0x0000, 0x0000, 0x9046, 0x5448, 0xf3a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2066,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9f67,
  0x0000, 0x0000, 0x0000, 0x99e6, 0x1fc8, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x22ab, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1f05, 0x0000, 0x0000, 0x6409, 0x0000, 0x0000, 0x0000,
  0x03a8, 0x0e84, 0x0c8d, 0x3d47, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xcd27, 0x0000, 0x43e5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0528, 0x16a5, 0x0000, 0x5225, 0x0000, 0x0000, 0x1948, 0x0327,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x34e9, 0x0000, 0x0000, 0x0000, 0x0e28, 0x0000,
  0x0000, 0x0000, 0x73ea, 0x7864, 0x0000, 0x7a05, 0x0000, 0x19c4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xfa46, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5706, 0x0000, 0x9246,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1c48, 0x01a7, 0x0000, 0x6024,
  0x54c9, 0x44e4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0729, 0x0000, 0x0000, 0x0000, 0x0148, 0x1785, 0x0000, 0x0000,
  0x0000, 0x4e06, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xf2a7, 0x1052, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2f44, 0x21a9, 0x0000, 0x0000, 0x4204, 0x0000, 0x8f46,
  0x0000, 0x0000, 0x0000, 0x8a26, 0x0000, 0xca06, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5206, 0x0000, 0xf286,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0d05, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3925, 0x1148, 0x6547, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4d89, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x78e8, 0x0be6, 0x332a, 0x32c6, 0x0000, 0x0000, 0x0000, 0x3ba4,
  0x0000, 0x9e86, 0x7608, 0xf2a6, 0x0000, 0x0000, 0x0000, 0x4ea4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ec4, 0x0000, 0x0000,
  0x0000, 0xcc86, 0x0000, 0x0000, 0x0000, 0x0000, 0x0629, 0x0000,
  0x31cb, 0x2344, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6704,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ec5, 0x0000, 0x0000,
  0x4608, 0x2507, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7e29, 0x6fc5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xb846, 0x2dcb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x09e8, 0xc7e7, 0x0000, 0x0000,
  0x190a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xdbe6, 0x2e8a, 0x0000, 0x0211, 0x0000, 0x75e8, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2045, 0x0000, 0x0000, 0x7088, 0xe0c6, 0x10c8, 0x03c5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xf387, 0x0000, 0x0000, 0x26e8, 0x0e64,
  0x0000, 0x0645, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x410a, 0x0025, 0x0000, 0x5c46,
  0x0c48, 0x3c45, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1fa8, 0x0045, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x45a8, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2b69, 0x0000, 0x0000, 0x0000, 0x0000, 0x4785, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6806,
  0x0000, 0x0000, 0x63a8, 0x0184, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4205,
  0x0000, 0x0000, 0x0000, 0x6ba6, 0x0000, 0x0000, 0x24ca, 0x0000,
  0x0000, 0x0000, 0x0db4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x9466, 0x2449, 0x2145, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0f29, 0x0644, 0x5d88, 0x0000, 0x0000, 0x3a44,
  0x31ed, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2f49, 0x0000, 0x40e9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5364,
  0x2be8, 0x70c6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x168c, 0x0000, 0x0000, 0x6ca4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2084,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x32e8, 0x04e4, 0x0000, 0x0000, 0x496a, 0x3fc4,
  0x3cea, 0x03a7, 0x208d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4746, 0x0000, 0x46a6, 0x0000, 0xb706,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2e89, 0x0000,
  0x0000, 0x6264, 0x31ec, 0x2f86, 0x1909, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4084, 0x0000, 0x6984, 0x6eeb, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x66a8, 0x0000, 0x0000, 0x0000,
  0x2628, 0xcee7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x624b, 0x0144, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7f04, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5585, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7fa6,
  0x0000, 0x0000, 0x0000, 0x0366, 0x0000, 0x0000, 0x0000, 0x3166,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x65a4, 0x3fe8, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0711, 0x0000, 0x0000, 0x0000,
  0x2268, 0x2ac6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x71a4,
  0x0000, 0x6f64, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x55e4, 0x0000, 0x0000, 0x0000, 0xa7c6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x140d, 0x0526, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xd6c6,
  0x6148, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xc946, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0e65, 0x0000, 0x0000, 0x0000, 0x0000, 0x274e, 0x24c4,
  0x0000, 0x0000, 0x0000, 0x7ae4, 0x164c, 0x1825, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7c46,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6a08, 0xe086, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1bac, 0x0000, 0x46e8, 0x0f44, 0x0000, 0x0000,
  0x0000, 0x0000, 0x48eb, 0x0000, 0x0000, 0x1665, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0844, 0x0000, 0x60a6, 0x0000, 0x2c07,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x046d, 0x0000, 0x1309, 0x0000, 0x0000, 0x95a6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4a0a, 0x0000, 0x0000, 0x4685, 0x0000, 0x0000,
  0x0000, 0x63a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4586, 0x0000, 0x6666, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x59e8, 0x4407, 0x4fa8, 0x00a4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x73e5, 0x0000, 0x9026, 0x0000, 0x0000,
  0x0000, 0x6fa4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1dc5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xa206, 0x0000, 0x0000, 0x7928, 0xd826,
  0x2748, 0x0784, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8f06,
  0x0000, 0x8f67, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3468, 0xe7a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6785, 0x0000, 0x64c5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3649, 0x0664,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x13e7, 0x0000, 0x0000,
  0x0000, 0x70c5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x21c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6429, 0x4584, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3404, 0x448a, 0x1305, 0x2e2b, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0388, 0x0447,
  0x0000, 0x5ea5, 0x0000, 0x0000, 0x7048, 0xc227, 0x0000, 0x5a25,
  0x0000, 0x0000, 0x0000, 0x0000, 0x7e88, 0x0000, 0x0000, 0x0000,
  0x0000, 0x62a4, 0x0000, 0x7044, 0x16ea, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1109, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1eed, 0x22a5, 0x0000, 0x0000, 0x0000, 0x3664, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xa3e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1a6e, 0x36a5, 0x0000, 0x0000, 0x0000, 0x2125,
  0x0000, 0x0000, 0x5dca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xfb86,
  0x0000, 0x57c4, 0x0000, 0x6505, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5c68, 0x14c5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ca9, 0x0ee4, 0x3e89, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6526, 0x28e9, 0x0000, 0x0000, 0x3844,
  0x0000, 0x0000, 0x0000, 0x4aa6, 0x0000, 0x0000, 0x0000, 0xc846,
  0x0000, 0x0000, 0x296a, 0x5e44, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xab06, 0x0000, 0x0000, 0x45aa, 0x0000, 0x0000, 0x0000,
  0x63e8, 0x6a45, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x718a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0272, 0x07c4, 0x396c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xe146,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xaea6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f08, 0x1dc7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xa4c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4b48, 0x1924, 0x0000, 0x0000,
  0x1488, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4ce5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9b67, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7908, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6e46, 0x0000, 0x0000, 0x0000, 0x7164, 0x292a, 0x0c85,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1604, 0x0348, 0x4f85, 0x0000, 0x0000,
  0x2128, 0x2006, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5064, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fea, 0x4c46,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0ee8, 0xf966, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x414c, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x452a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc5c6,
  0x0000, 0xc547, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6366, 0x0000, 0x0000,
  0x0000, 0x3607, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0a88, 0x0fc7, 0x0000, 0x0000, 0x0000, 0x0000, 0x62c8, 0x0000,
  0x2f2c, 0x0806, 0x0000, 0xbf26, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4249, 0x2826, 0x21ab, 0x8a07, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7a2b, 0x0000, 0x0000, 0x0000, 0x0449, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0308, 0xd486, 0x0000, 0x0000, 0x72ca, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1608, 0x2f66, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6305, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf007,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6066, 0x0000, 0x0000, 0x0000, 0xf767, 0x0000, 0x70a4,
  0x1fce, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x118e, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3708, 0x04a4, 0x0000, 0x3f84, 0x0000, 0x0000,
  0x0000, 0x5004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1ecc, 0x0000, 0x0000, 0x42a4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5e0c, 0x7305,
  0x0000, 0x8307, 0x0000, 0x1325, 0x0000, 0x0000, 0x30ea, 0x0000,
  0x0000, 0xf407, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0fce, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5006, 0x0000, 0x3c64, 0x08a9, 0xca07, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5bc7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3c0a, 0x0000, 0x3de9, 0x0000, 0x3b09, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6d44,
  0x1ca9, 0x0000, 0x0000, 0x0000, 0x0000, 0x7686, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7e2b, 0x5d84,
  0x0000, 0x4566, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1828, 0x0000, 0x3b08, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7b04, 0x0000, 0x0000,
  0x0000, 0x1585, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0a6d, 0xc406, 0x0000, 0x0000, 0x300b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1489, 0x2085,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2de6, 0x0f32, 0x0000, 0x0000, 0x6784,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc0a6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2ae5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x14e8, 0x3704, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x73c6, 0x0000, 0x0000, 0x0000, 0x0000, 0x6769, 0x0000,
  0x1848, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6504, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x700b, 0x4fe5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc9c6,
  0x0000, 0x0000, 0x0000, 0x6b87, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x788b, 0x0cc4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7064, 0x0000, 0x4724,
  0x0000, 0x0000, 0x0000, 0x0000, 0x6368, 0xffa6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0d09, 0x0686, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x25a4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6168, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0413, 0x0000, 0x0000, 0x0000, 0x0000, 0x3dc6, 0x0000, 0x54a6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3f87,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7ec6, 0x0000, 0x77a6, 0x0000, 0x0000, 0x0908, 0x26c6,
  0x0000, 0x0000, 0x0000, 0x4747, 0x0000, 0x0000, 0x3828, 0x0000,
  0x0808, 0x16a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1e84, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x57ca, 0xce46, 0x39ed, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2a49, 0x0000, 0x0000, 0x0000, 0x0000, 0x9fe6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7005, 0x0000, 0x0000,
  0x1652, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6509, 0x56e6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4368, 0x8ba7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x202c, 0x0000,
  0x7d6c, 0x0000, 0x0000, 0x0000, 0x1e88, 0x19e4, 0x0000, 0x4085,
  0x0000, 0x0000, 0x780c, 0x0000, 0x1288, 0x0085, 0x0000, 0x9e87,
  0x03cb, 0x5d86, 0x0000, 0x0000, 0x43cb, 0x0000, 0x0000, 0x0000,
  0x00cc, 0x0000, 0x0000, 0x6a04, 0x48cb, 0xad27, 0x6bc8, 0x7624,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5748, 0x73a4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4c44, 0x7c0b, 0x0000,
  0x0000, 0x6dc6, 0x0000, 0xe6e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2fe5, 0x0000, 0xaf86, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7b48, 0x0000, 0x5289, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4a09, 0x4787, 0x0000, 0xb067, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x080b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4bc7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xe4a6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x578b, 0x5d87, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0ae9, 0x0000, 0x0000, 0x0fe5, 0x0000, 0x0000,
  0x0a6c, 0x18c6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6c0a, 0x2285, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ac8, 0xdb06,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8547, 0x0000, 0x5f85,
  0x0000, 0x0000, 0x0000, 0x0000, 0x556b, 0x0000, 0x44ca, 0x26a6,
  0x0000, 0x0000, 0x6d48, 0x9786, 0x0000, 0x0000, 0x0000, 0xaa86,
  0x0000, 0x7b47, 0x2faa, 0x5a66, 0x0000, 0x0000, 0x0000, 0xc4a7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8026, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xc2e7, 0x0000, 0x0000, 0x0000, 0x0000, 0x3daa, 0x1846,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3508, 0x0305, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4328, 0x01c5, 0x43ab, 0x0000,
  0x4f68, 0x0fc4, 0x0000, 0x0000, 0x0000, 0x2784, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6ba9, 0x7cc4, 0x7e28, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2ceb, 0x0804, 0x0000, 0x0000,
  0x0000, 0x0000, 0x260a, 0xc527, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8a66, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7426,
  0x0000, 0x0000, 0x0000, 0x8ec7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2429, 0x15e6, 0x0000, 0x3605, 0x0000, 0x22e6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6227, 0x0000, 0x0000, 0x4a6b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0a0c, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7465, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa566,
  0x0000, 0x0000, 0x0000, 0x0000, 0x41cb, 0x0000, 0x45e8, 0x60c5,
  0x0fed, 0x0000, 0x0000, 0x0000, 0x74cb, 0x91e7, 0x0000, 0x7867,
  0x0000, 0x2086, 0x0000, 0x0000, 0x0000, 0x47a6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4889, 0x2484,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x9186, 0x0000, 0x0000, 0x7ac9, 0xf046, 0x0000, 0x07e6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6325, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0865, 0x62c9, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x30e4,
  0x3769, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x21e4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8e86, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2a89, 0x1fa4, 0x0000, 0x7027, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6f4a, 0x0000, 0x0000, 0x0000, 0x0000, 0x6645, 0x6288, 0x7304,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3a84, 0x0000, 0x1e67, 0x0000, 0x6cc6, 0x0000, 0x0000,
  0x0000, 0xdca6, 0x6aaa, 0x0000, 0x0000, 0x0000, 0x168a, 0x4ba4,
  0x0000, 0x66c5, 0x728b, 0x4f44, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7046, 0x0000, 0x0000,
  0x0000, 0x0000, 0x38c8, 0x0486, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x64c9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa5c6, 0x0000, 0x0d04,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xa666, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x43c9, 0x05a7,
  0x0000, 0x0000, 0x20eb, 0xbd86, 0x124e, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3a8a, 0x0000, 0x7da8, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x240e, 0x0ae7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0809, 0x7b87, 0x10ad, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x11a7, 0x0000, 0x0000, 0x6d08, 0xe646, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x20a9, 0x4d64,
  0x0000, 0x0000, 0x0000, 0x0000, 0x17a8, 0x1ec5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x54c5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x23a8, 0x0465,
  0x0000, 0x40a4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x438c, 0x1ac6, 0x5368, 0x0000,
  0x094c, 0x0000, 0x0000, 0x0fa7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5f25, 0x106a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x29a8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa747, 0x0bce, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x3825, 0x0000, 0x50c5, 0x0ce8, 0x0ac7,
  0x502a, 0xfd87, 0x0000, 0x0000, 0x0000, 0x0026, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6ca6, 0x0af2, 0x22a6, 0x2f88, 0x1766, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x754b, 0x6224,
  0x0000, 0x0000, 0x0000, 0x0000, 0x45c8, 0x3a07, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6da8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc906,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb2a6,
  0x0000, 0x0000, 0x5bab, 0x7e47, 0x0000, 0x0000, 0x2e29, 0xcf07,
  0x0000, 0x0000, 0x0000, 0x81c6, 0x7a68, 0xfb46, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7da6, 0x0000, 0x0000,
  0x0f33, 0x0000, 0x0000, 0x0000, 0x1b69, 0x0285, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x6acb, 0xb407, 0x0000, 0x0000,
  0x0000, 0x3d45, 0x0000, 0x85c6, 0x0000, 0x0000, 0x414b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x36e4, 0x53a8, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5fc6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5386, 0x0000, 0x0000, 0x4468, 0x1d24,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3c44, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6ec4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6365, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2e67,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4dc7, 0x0000, 0x4e27,
  0x0000, 0x0000, 0x0000, 0x1964, 0x03af, 0x0000, 0x0000, 0x2a45,
  0x0000, 0x0000, 0x0000, 0x0000, 0x104a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x54cb, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xff87, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2689, 0x6046, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x9e47, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x3204, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x564b, 0x5c67, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7bc6, 0x0000, 0x0000,
  0x0000, 0x6106, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4ca4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5f65, 0x0000, 0x6dc4,
  0x0000, 0x0000, 0x0000, 0x7a24, 0x0000, 0x0c84, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x39e6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4deb, 0x2d45, 0x0000, 0x0000,
  0x2508, 0x39e5, 0x112e, 0x0000, 0x0000, 0x38c4, 0x0000, 0x0000,
  0x0000, 0xbee7, 0x0751, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4aa8, 0x0605, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5b25, 0x0000, 0x0000, 0x0000, 0x3745, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0510, 0x3826, 0x0000, 0x6aa4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1c6c, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xba66, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x142c, 0x06e5,
  0x0000, 0x3845, 0x0000, 0x92c6, 0x07ca, 0x0000, 0x19ec, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6ca7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0a08, 0x1aa4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2c48, 0x2fa7, 0x0000, 0x0000, 0x5d68, 0x0000, 0x0000, 0x0000,
  0x7748, 0x0000, 0x0000, 0x8626, 0x0000, 0x4587, 0x0000, 0x0000,
  0x0000, 0x5685, 0x0000, 0x17e6, 0x0000, 0x6484, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x67e8, 0x5844,
  0x0000, 0x0000, 0x354a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x9a67, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x9a46, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0c0d, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x12b2, 0x0000, 0x0000, 0x0000,
  0x70c9, 0x1984, 0x0000, 0x0000, 0x6828, 0x0000, 0x23e9, 0x2dc7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7c08, 0xfc86,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2c85, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6206, 0x0000, 0x0000, 0x46e9, 0x4ec7,
  0x0000, 0x0000, 0x0000, 0x4366, 0x0000, 0x0000, 0x036e, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5e66, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x65cb, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x7b68, 0x0000, 0x0000, 0x1d64,
  0x5f2a, 0x1844, 0x0000, 0x87c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7f08, 0x0000, 0x0000, 0xae87, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4645, 0x21e9, 0x17e5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x57aa, 0x3ac4, 0x05ac, 0x3b67,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5926,
  0x0000, 0x28e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4b89, 0x4506, 0x006b, 0x1be4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3908, 0x0a05, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xfc06, 0x00c8, 0x38a4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x79e8, 0x0000, 0x782a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7289, 0xec66, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2ba8, 0x0ca5,
  0x6369, 0x26c4, 0x0000, 0x0000, 0x0000, 0x4965, 0x7ae8, 0xf2c6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x50a6, 0x0000, 0x0000, 0x0000, 0x6a66,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e44, 0x1188, 0x1b27,
  0x0000, 0x0000, 0x0000, 0xb506, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7125, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5068, 0x3904, 0x0000, 0x6306,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0716, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e65,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xda87,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4365, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0b71, 0x0000, 0x0000, 0xc3a6, 0x0000, 0x0b66,
  0x630c, 0x7564, 0x14c8, 0x0204, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0bf0, 0x0000, 0x0000, 0x0000, 0x0000, 0x44e7, 0x446a, 0x7ce4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6e86, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x53e7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6f04, 0x2e0a, 0x12a4,
  0x0000, 0x0000, 0x0d28, 0x1344, 0x0000, 0x7ae7, 0x0000, 0x0000,
  0x3949, 0x03e4, 0x0000, 0x5066, 0x0000, 0x0000, 0x0000, 0x2704,
  0x0000, 0x5c85, 0x0000, 0x0000, 0x0000, 0xcd47, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1d84, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6885, 0x088a, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x6c6b, 0x0a24, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5148, 0x7d24, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x8f86, 0x0000, 0x60e4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7948, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x532a, 0x08e4, 0x0000, 0x0000, 0x0000, 0x0000, 0x676b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3be4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0c68, 0x4be7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xf506, 0x0000, 0x0000, 0x0000, 0x6324,
  0x0000, 0x0000, 0x6ceb, 0x0524, 0x0000, 0x0000, 0x292b, 0x0bc7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1a29, 0x0000, 0x0000, 0xbb26,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0c45, 0x0000, 0x0000, 0x0000, 0x39e4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x246e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7b05, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x16c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x19a9, 0x0544, 0x0000, 0x6426, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4f64, 0x0000, 0x0000, 0x42ab, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2204, 0x0000, 0xa046,
  0x0000, 0x0000, 0x0000, 0x6725, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2ca7, 0x6de9, 0x3a66,
  0x0000, 0x27a7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7386, 0x0000, 0x0000, 0x0000, 0x0000, 0x6988, 0xe066,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2669, 0x7604, 0x056b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xe387, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x41a5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0dc6,
  0x0000, 0x3da5, 0x0000, 0x15c4, 0x3428, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x48e9, 0x5ba7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x020a, 0x0404, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ba8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2685, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2528, 0x0fc5, 0x0000, 0x0000, 0x2d2b, 0xc1e7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6ce8, 0x7644,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x15e4, 0x0000, 0x55a4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x63a5,
  0x0000, 0x5d26, 0x0000, 0x46a5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x364a, 0x1f84, 0x6749, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x62e4, 0x0000, 0x0000, 0x0000, 0x0000, 0x3faa, 0x1ce5,
  0x22a9, 0x4b27, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0570, 0xc6e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xd267, 0x0000, 0x0000, 0x0000, 0x0000, 0x2428, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8c07, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4589, 0x31e4, 0x0000, 0x31c4,
  0x0000, 0x0000, 0x0000, 0x80c7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x150d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x79a7, 0x0000, 0x5044,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xc9e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3369, 0x4a47, 0x0000, 0x88a7, 0x0000, 0x54e4,
  0x7228, 0x0000, 0x0000, 0x0000, 0x0000, 0xba86, 0x4388, 0xabc7,
  0x5949, 0xb9c7, 0x0000, 0x0000, 0x0000, 0x0000, 0x6728, 0xbce6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7706, 0x0000, 0x0000,
  0x5c08, 0x11e5, 0x0000, 0x5784, 0x0000, 0xc086, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xc2a7, 0x0000, 0x0000, 0x0000, 0x6b85, 0x4ba9, 0x34c6,
  0x0000, 0x0000, 0x64eb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1069, 0x4065, 0x0000, 0x50c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0ea9, 0x3184, 0x1448, 0x0f26, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2caa, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1da5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xdf07, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5924,
  0x2b8a, 0xc006, 0x0000, 0x4166, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x3645, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2dca, 0x4767, 0x4029, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4884, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6d29, 0x0000, 0x0000, 0x0000, 0x0000, 0x1567,
  0x0000, 0x4e26, 0x44c8, 0x0d67, 0x498b, 0x75e4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6005, 0x0ceb, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x63e4, 0x0000, 0x0000,
  0x0000, 0x6fc4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xd127, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8386,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2206,
  0x0000, 0x3724, 0x0000, 0x0000, 0x3c0b, 0x0124, 0x0000, 0x0000,
  0x0000, 0x93c7, 0x0000, 0xa846, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5548, 0x0000, 0x0000, 0x7d86,
  0x030f, 0x0000, 0x0000, 0x7906, 0x0000, 0x0000, 0x0000, 0x0044,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6029, 0x0000,
  0x0000, 0x0000, 0x4849, 0x3b47, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0e2e, 0x4245, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4585, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0208, 0xa4a6, 0x0000, 0x0000, 0x0c32, 0x0000, 0x0000, 0x0000,
  0x57ea, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6f86, 0x0000, 0x0000, 0x0000, 0xc466, 0x0000, 0x0000,
  0x3549, 0x1746, 0x0000, 0x89a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x7529, 0x4924, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x44c9, 0x0ba4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5da9, 0x0000, 0x1449, 0x0000,
  0x0000, 0x2fa4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5f46, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4e89, 0x6b24, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x72eb, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4f2a, 0x0000, 0x0000, 0x0000, 0x0000, 0x2987, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xba27,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6804, 0x31c8, 0x0000, 0x50a8, 0x0000, 0x0000, 0x0000,
  0x62e9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0286, 0x0000, 0x6404, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xf926, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6028, 0x0000, 0x0000, 0x0000, 0x244b, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb246,
  0x0000, 0x0000, 0x0000, 0x0000, 0x078b, 0x0000, 0x0000, 0x0000,
  0x5029, 0xea47, 0x0000, 0x5086, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xdba7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7527, 0x0000, 0xce87, 0x0000, 0x51c6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x41e7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4864, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xb9c6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x28a6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa826, 0x0000, 0x0000,
  0x0b72, 0x0000, 0x3288, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x79a5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x10e6,
  0x0000, 0x44a4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x7a08, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x02b0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0670, 0x0000, 0x0000, 0x0000, 0x0000, 0x2747, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0092, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2348, 0x2326, 0x0000, 0x88a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xde07, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xbf06,
  0x0000, 0x3464, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0989, 0x1144, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4fcc, 0x03a5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xb147, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xd5c6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2feb, 0x0224, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6bc5, 0x0000, 0x0000, 0x764a, 0x4a06,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x08c8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x6589, 0x0000, 0x0000, 0x0000,
  0x1d2a, 0x0000, 0x0000, 0x7b86, 0x0000, 0x3746, 0x0000, 0x0000,
  0x0000, 0x7007, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3c68, 0x0000, 0x0000, 0x0000, 0x0000, 0xd5a6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0ef3, 0x0000, 0x0000, 0x0000,
  0x08ab, 0x0000, 0x26a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1249, 0x4c07, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6004, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x40c4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5628, 0x0000,
  0x0000, 0x0000, 0x0628, 0x0244, 0x7f8c, 0x0000, 0x0000, 0x7ca4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5246,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x746a, 0xe466, 0x0000, 0x7e45, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1a0a, 0x0ae5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2164,
  0x0000, 0x0000, 0x0000, 0x57e5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3e09, 0x0000, 0x0000, 0x0000, 0x0000, 0x8c27,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1f2a, 0x4624, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5f04, 0x0000, 0x0000, 0x1349, 0x0000,
  0x0000, 0x0000, 0x1fe8, 0x0000, 0x346c, 0x2864, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2e04, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4148, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x44e8, 0x4647,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0b89, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x64c8, 0x41a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x77cb, 0x0000, 0x0000, 0x4a45,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00cd, 0x3be6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07b1, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6688, 0xcd26,
  0x0000, 0xc286, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x25c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1286,
  0x0000, 0x0000, 0x5489, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xd146, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x164b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x11c9, 0x30a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0b68, 0x0106,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0e09, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5d66, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xda47, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0307, 0x0000, 0xa906, 0x13ca, 0xbf47,
  0x0000, 0x0000, 0x4c49, 0x3ee4, 0x12aa, 0xaf26, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xf347, 0x52e8, 0x0000, 0x0000, 0x0000,
  0x0000, 0xc8e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6e4a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3425, 0x0000, 0x0000,
  0x0000, 0x3104, 0x4f29, 0x3625, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0249, 0x1d46,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5508, 0x1187, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f2b, 0x00a6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x9806, 0x0000, 0x7865, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3fa8, 0x1687, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7d44, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7464, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4ccb, 0x75e7, 0x0000, 0xe5a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5026, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2309, 0x0000, 0x0000, 0x0000, 0x02d6, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1749, 0x0b44, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5cc4,
  0x0000, 0x0000, 0x2929, 0x12e7, 0x6aa8, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7326, 0x0000, 0x0000, 0x40a8, 0x6827, 0x0000, 0x3f44,
  0x0000, 0x0000, 0x3688, 0x1f67, 0x4908, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5609, 0x1ac4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1872, 0xdde6, 0x4048, 0x30a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ce4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x248b, 0x0000, 0x0000, 0x0000,
  0x1c69, 0xa067, 0x60cc, 0x7724, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x06a8, 0x0a25,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7229, 0xeec6,
  0x0000, 0x0000, 0x0000, 0xe447, 0x3d4b, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9146, 0x0ac8, 0x03c7,
  0x0000, 0x0000, 0x0000, 0x5a26, 0x68ea, 0x0000, 0x0000, 0x0000,
  0x4d29, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1528, 0x3586, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xce06, 0x4faa, 0x96a7, 0x0000, 0x0000, 0x0000, 0xc787,
  0x0000, 0x0000, 0x0088, 0x2144, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6bc4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0213, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x22e8, 0x13a7, 0x30e8, 0x4b86,
  0x0000, 0x0000, 0x592b, 0x7627, 0x6daa, 0x79a4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x6b69, 0x46e4, 0x4e88, 0xe6c7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5f45, 0x0000, 0x0000, 0x620a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2545, 0x0000, 0x0000, 0x5fe9, 0x4f27, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6364, 0x0000, 0x0000,
  0x25ab, 0x0000, 0x0000, 0xf647, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9a86, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x508c, 0x2e27, 0x01f3, 0x0000,
  0x1408, 0x08e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb4e6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5bea, 0x9ce6, 0x0988, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b46, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x692a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6886, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xcac7, 0x0000, 0x0000, 0x5bec, 0x0000, 0x0000, 0x0000,
  0x0000, 0xc826, 0x6489, 0xadc6, 0x314e, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0c06, 0x0000, 0x5164, 0x0000, 0x0000,
  0x0468, 0x5607, 0x0000, 0x0000, 0x0000, 0x5366, 0x0000, 0x4024,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xfe46,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5804, 0x0000, 0xbe86,
  0x0000, 0x86c7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5a04, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x35e5, 0x0000, 0x9587, 0x0000, 0x0000, 0x06ca, 0x0000,
  0x01e9, 0x3a05, 0x0000, 0xb146, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7166, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x184c, 0xdce6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6905, 0x0000, 0x7086, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xb386, 0x0000, 0x0000, 0x0000, 0x0000, 0x5049, 0x5466,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2228, 0x0884,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x67cb, 0x0be4, 0x0000, 0x0000, 0x028d, 0x5b67,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6a4a, 0x0000, 0x0000, 0x52c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6ba4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6ce6, 0x510a, 0x6c05,
  0x0000, 0x7405, 0x0b4b, 0x0000, 0x2988, 0x0000, 0x0000, 0x0000,
  0x0000, 0x83e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7b4b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0588, 0x0987,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x258b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2a8a, 0x40c5, 0x67e9, 0x8a86, 0x0000, 0x0000,
  0x0000, 0x6884, 0x0000, 0xe787, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6948, 0x77a4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1eca, 0x0000, 0x0000, 0x0000, 0x4c48, 0x74c4, 0x0000, 0x0000,
  0x0c08, 0x0000, 0x0000, 0x0000, 0x1e08, 0x51c7, 0x01a9, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x30e7,
  0x0000, 0x3266, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x096b, 0x0000, 0x2dcd, 0x65e6,
  0x0000, 0x0000, 0x4ee9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2b25, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7707, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5425,
  0x6a49, 0x52c6, 0x0000, 0x23e4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5a8a, 0x6e84, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x12ea, 0x0000, 0x3568, 0x0000,
  0x0000, 0x2fc6, 0x0000, 0x0000, 0x0000, 0x2924, 0x0000, 0x0000,
  0x22e9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7144, 0x0000, 0x0000, 0x2dc8, 0x6966,
  0x0000, 0xb466, 0x0000, 0xab87, 0x7c0a, 0x0000, 0x0488, 0x0f64,
  0x0000, 0x5124, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5fe5,
  0x0000, 0x7f46, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2224, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0906, 0x3c6a, 0x0000, 0x0000, 0xa827,
  0x0000, 0x0000, 0x0000, 0x49a5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf886, 0x0000, 0x0000,
  0x1b88, 0x0ea5, 0x0000, 0x0000, 0x0000, 0x55c5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5faa, 0x1887,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2fa5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb586,
  0x0000, 0x0000, 0x2de8, 0x4d07, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x99a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x23c8, 0x0f06, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8f47, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2c04, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1804, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x74e6, 0x0000, 0x8346, 0x0000, 0x1264, 0x184b, 0x0000,
  0x0000, 0x2a66, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x74c5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1a6d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2aa8, 0x1bc7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x24a8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4fa4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x90e6, 0x0000, 0x0000,
  0x0000, 0x69e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5569, 0x0000, 0x6c69, 0x7606, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xe227, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3168, 0x1546, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4d48, 0x42e4, 0x0000, 0xcb27, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x02f6, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6144,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x05c4, 0x0000, 0x6565,
  0x0000, 0x0000, 0x32e9, 0xb647, 0x0000, 0x7547, 0x5888, 0x0446,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3728, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6f27, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x39c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x41a8, 0x0000,
  0x0000, 0x0925, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5484, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3e48, 0x5aa7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x02ac, 0x0000, 0x0000, 0x0000, 0x0000, 0x60a7, 0x0000, 0x0000,
  0x0000, 0x1484, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7509, 0x48e4, 0x526b, 0xb6c7, 0x0000, 0x1b85,
  0x0000, 0x0000, 0x0000, 0x0000, 0x646b, 0x0000, 0x0000, 0x4404,
  0x0c50, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x16ab, 0x1605, 0x0000, 0x9507,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xeac7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0355, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7607, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x62c4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6ae6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ca8, 0x10e4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5e09, 0x1cc6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0888, 0x1445,
  0x0000, 0x51c4, 0x0609, 0x1384, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e04, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x18a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x77c8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4bc4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5488, 0xf747,
  0x0000, 0x0000, 0x0ccb, 0x7987, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2d24, 0x0000, 0x39a4, 0x0000, 0x0000,
  0x0000, 0x3b04, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5d6a, 0x7126, 0x0000, 0x0000, 0x0000, 0x1365, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x27e8, 0x3b65, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6a06, 0x0000, 0x0000, 0x68c9, 0x4ee6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7605, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1204, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2e2e, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4569, 0x1ee6,
  0x0000, 0x0000, 0x7c88, 0x0000, 0x0000, 0x17a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x230a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x41c8, 0x5d47, 0x0000, 0x0000,
  0x2b2b, 0x0000, 0x0000, 0x0000, 0x7f28, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x516a, 0x3585, 0x0000, 0x0000,
  0x0000, 0x9147, 0x1ccd, 0x28e7, 0x444a, 0x6304, 0x0000, 0x0000,
  0x0000, 0x9666, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5405, 0x17aa, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0c65, 0x0000, 0x0000, 0x0000, 0x83a6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4568, 0x31a4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x90a6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x31cc, 0x3ca4, 0x0000, 0x2dc6, 0x0000, 0x0000, 0x626a, 0x0000,
  0x0000, 0x0000, 0x2349, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x13a4, 0x0000, 0x75a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xa707, 0x0000, 0x0000, 0x0e88, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6266, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x154a, 0x1405,
  0x0000, 0xe2e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6c44,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5624, 0x0000, 0x0000, 0x0000, 0x0000, 0x6689, 0x0000,
  0x3e4b, 0x0d84, 0x0000, 0x0000, 0x0000, 0x8be6, 0x0000, 0x0000,
  0x0000, 0x1e85, 0x4c2c, 0x7da7, 0x0000, 0x3384, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6fe4, 0x0000, 0x0000, 0x0000, 0xed47,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x73c4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4344, 0x4e08, 0x24c6, 0x25aa, 0x0000,
  0x0000, 0x0000, 0x2549, 0x0000, 0x0000, 0x5ea4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x9de6, 0x0000, 0x6684, 0x0000, 0x5a45,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7be4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0f8b, 0xea67, 0x0000, 0x0000, 0x0000, 0x2885, 0x0000, 0x0000,
  0x0000, 0xa886, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x71e6, 0x0000, 0x7744, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2928, 0x0000, 0x0000, 0x0000, 0x0000, 0x40a5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6604, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5929, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0429, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4b68, 0x12c5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5d85, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0d8c, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3487, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xde27, 0x0000, 0x0000,
  0x06f0, 0x3da4, 0x0000, 0x0000, 0x0a2b, 0x0000, 0x2828, 0x7a86,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2d48, 0x4706,
  0x0000, 0x0944, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4e24, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2288, 0x0206, 0x0000, 0x0000, 0x07a8, 0x0024, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x18e8, 0x24e4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0669, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1a6c, 0x26a5, 0x09a8, 0x0fa5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x62aa, 0x15a5, 0x0000, 0x36e5, 0x148b, 0x5107, 0x0000, 0x0000,
  0x0dec, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ec9, 0x0104, 0x0000, 0x8967, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x47e5, 0x0000, 0x0000, 0x0000, 0x40c6,
  0x0000, 0x0000, 0x0000, 0x57c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0ae8, 0x0000, 0x0000, 0x0000, 0x36ca, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5209, 0x08a4, 0x0000, 0x0000, 0x0000, 0xe147, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3e6b, 0x0000, 0x0000, 0x0000,
  0x0aea, 0x3b87, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6904, 0x236e, 0x0000, 0x0000, 0x0000, 0x0000, 0xca86,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0d68, 0x6b65,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4b05,
  0x286e, 0x0ea4, 0x0000, 0x0000, 0x0000, 0x0000, 0x3aeb, 0x5a44,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3baa, 0x4044, 0x0000, 0xddc6,
  0x0000, 0x0000, 0x0b09, 0x0000, 0x36c9, 0x0185, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2369, 0x2d46,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4fe8, 0x2044,
  0x0000, 0x0000, 0x61c8, 0x5525, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7eab, 0x5304,
  0x0000, 0x75c6, 0x0000, 0xa8a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2c8b, 0x0000, 0x0000, 0x0405, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1aec, 0x2424, 0x0000, 0xf6e6, 0x0da8, 0x3846,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5828, 0x0000, 0x0000, 0x5305, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9ac7, 0x0000, 0x0000,
  0x27cd, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x74c9, 0xea06,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ce9, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1cac, 0x6127, 0x0000, 0x0346, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x51c9, 0x33c4, 0x0000, 0x0227, 0x0000, 0x0000, 0x0000, 0xa8c7,
  0x0000, 0x7767, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6eea, 0x7804, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3589, 0x1b24,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x72e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x3eca, 0x2306,
  0x380b, 0x05a5, 0x0000, 0x0000, 0x0000, 0x0000, 0x6128, 0x0000,
  0x0000, 0x0000, 0x0000, 0x3344, 0x0000, 0x8ac7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x33cb, 0x2aa5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6267, 0x0000, 0x0000, 0x0000, 0x3684, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc667, 0x4ca9, 0x2f26,
  0x0c0b, 0x0000, 0x0000, 0x0000, 0x0000, 0x3864, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5506, 0x0000, 0x3c67, 0x728a, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7526, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5c65,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0a53, 0x0000, 0x0000, 0x52e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1012, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x87e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3ee7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x73a8, 0x0e24, 0x0d0a, 0x2884, 0x0000, 0x3987, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x74e4, 0x2a68, 0x21a5,
  0x3ca9, 0xd626, 0x76aa, 0x34e4, 0x0000, 0x7087, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xfc46, 0x47cc, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7886, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1aae, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7fc6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x11ee, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xfda7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4168, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4e25, 0x0000, 0x0000, 0x3528, 0x04a7,
  0x0000, 0x0000, 0x0000, 0xf2e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5fa4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x44eb, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1504, 0x0000, 0x0000, 0x7e48, 0x0000, 0x0000, 0xf946,
  0x0000, 0x0000, 0x0000, 0x0b67, 0x0000, 0x0000, 0x0000, 0x0000,
  0x428a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xeb87,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1e0a, 0x01e6, 0x0000, 0x0000, 0x0000, 0x9966, 0x0000, 0xbfc6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x310b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x51e7, 0x4649, 0x1224, 0x0000, 0x0000,
  0x0000, 0x3ea4, 0x7f68, 0x0000, 0x0000, 0x0000, 0x0000, 0x3fa6,
  0x216b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8966, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x768a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3d89, 0x0e44, 0x0000, 0x0000,
  0x22eb, 0x09a4, 0x0000, 0xd6a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0a48, 0x6087, 0x0000, 0x5a87, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8da6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7c2a, 0x6926, 0x0000, 0x7fa4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x29e8, 0x2ea7,
  0x04b6, 0x0000, 0x0000, 0x0000, 0x0000, 0x4684, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4026, 0x0000, 0x0000, 0x0000, 0x6724,
  0x0000, 0x0000, 0x7069, 0x0000, 0x0000, 0x6146, 0x0000, 0x0000,
  0x2fcc, 0xb127, 0x0000, 0x8b87, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0e4a, 0x4426, 0x0000, 0x00a5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x57a6, 0x0000, 0x0000,
  0x5f68, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5e6a, 0x5ee5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2e47, 0x0000, 0x9aa7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x254d, 0x0ae4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0d6c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x65c7, 0x7bec, 0x0000, 0x5ea9, 0x0724, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4384,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4c08, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7ec4, 0x0000, 0x0000,
  0x0000, 0x1a24, 0x0000, 0x0000, 0x0000, 0x0000, 0x4528, 0x25e6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x45e4, 0x41e8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3fea, 0x0000, 0x0000, 0x5465, 0x0000, 0x0000, 0x138b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x58a5, 0x0000, 0x5746,
  0x0000, 0x0000, 0x0000, 0xda26, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5945, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x19c8, 0x0107,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6104,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x9f07, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8466,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x32c8, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7664, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x15e8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6cc4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x454c, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6205, 0x7188, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3188, 0x2cc6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x604a, 0x1c87,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x69a4, 0x01c9, 0x0000, 0x598c, 0x78e4,
  0x4a48, 0x0000, 0x1529, 0xb287, 0x0000, 0x1425, 0x0000, 0x61c4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0811, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7cca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8266,
  0x0000, 0xbb06, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x61ac, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6629, 0x4fe6, 0x0000, 0xe2c7, 0x7caa, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6584, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1168, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1d88, 0x5067, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9286, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa746,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x06c5, 0x0000, 0x0000, 0x0000, 0x2004,
  0x0000, 0x0000, 0x2be9, 0x0000, 0x776c, 0xeba6, 0x0000, 0x5944,
  0x0000, 0x0000, 0x0000, 0x9ec6, 0x0000, 0x5d04, 0x0000, 0x2726,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x324a, 0x7927, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0648, 0x0000, 0x0000, 0x0000, 0x0000, 0x4784, 0x0000, 0x0000,
  0x0000, 0x0000, 0x69ea, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1f08, 0x0566, 0x0000, 0x2e25, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5fc5, 0x0000, 0x2d65, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x54c6, 0x0000, 0x0000, 0x332c, 0x2046, 0x0a54, 0x1f25,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0409, 0x3125, 0x0000, 0x6285,
  0x0000, 0x0000, 0x0000, 0xa026, 0x3fad, 0xa1e6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x416b, 0x07a4, 0x0000, 0x0000, 0x0000, 0x49a6,
  0x0000, 0x0000, 0x06cd, 0x8467, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6709, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x72a4, 0x0000, 0xc7c7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x72e4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x068a, 0x1fe4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2906, 0x0000, 0x0000,
  0x0000, 0x0000, 0x15a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0833, 0xb066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x374d, 0x0000, 0x694b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x42c8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x69aa, 0x1a46,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6f8a, 0x0000, 0x0000, 0x2384, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4228, 0x0000, 0x0000, 0x0000, 0x64e9, 0x0000, 0x112f, 0x1b44,
  0x0000, 0xb486, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x21c4,
  0x52ac, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4aab, 0xbda7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3445, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3c28, 0x2f67,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7d65, 0x20c8, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5cc7,
  0x2608, 0x11c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x63e9, 0x73a7, 0x3c88, 0x3ae4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5608, 0x0000, 0x0000, 0x0000, 0x0000, 0x5724, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9226, 0x5dec, 0x0000,
  0x0000, 0x0000, 0x388a, 0x7427, 0x0000, 0x1ba5, 0x0000, 0xb3a6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x7768, 0x7b84, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1806, 0x0000, 0x1084, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0de4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5fe4, 0x1068, 0x0546, 0x0000, 0x0000,
  0x0000, 0x8347, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2e08, 0x0586, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4744, 0x03ac, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1c66, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4145, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xbf27, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5c6c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xd066, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x108c, 0x3fe6, 0x0000, 0x4705, 0x2048, 0x7f84, 0x0000, 0x0000,
  0x02e8, 0x46a4, 0x0000, 0x2b06, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7344, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1e06, 0x0000, 0x0000, 0x33e9, 0x1566, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3248, 0x0000, 0x0000, 0x5e46, 0x03ed, 0x5984, 0x0000, 0x7ac5,
  0x5668, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6f08, 0x0000, 0x0000, 0x0000, 0x6909, 0x69e5, 0x0000, 0x0000,
  0x66e9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6226,
  0x0000, 0x0000, 0x1308, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4288, 0x0000, 0x0000, 0x5527, 0x0000, 0x0000,
  0x274c, 0x0000, 0x3008, 0x5584, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2448, 0x0dc7,
  0x0000, 0xe346, 0x7de8, 0x0000, 0x282a, 0x0000, 0x0849, 0x2d07,
  0x0000, 0x0000, 0x0000, 0x3025, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7084, 0x0928, 0x1fc5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5568, 0xf4e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0ad3, 0x0000, 0x0000, 0x5aa4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1886, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x67e5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5a68, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7c48, 0x7c04, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5f88, 0x6a05,
  0x0000, 0x0000, 0x0000, 0x0000, 0x19aa, 0x0484, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x76c6, 0x0000, 0x0000,
  0x0000, 0x6ee4, 0x384e, 0x0000, 0x0000, 0x4d87, 0x308a, 0x14a6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x59e4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x618a, 0x42a5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5329, 0x2c24, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x05a4, 0x00ec, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4be4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x6608, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0b0b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4da9, 0x4b04, 0x0000, 0x2de5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4626,
  0x0000, 0x45e6, 0x0000, 0x4926, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x47a5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5406,
  0x13a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x5947, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x3906, 0x0000, 0x73a5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0269, 0x0000,
  0x0000, 0x0000, 0x0000, 0x66c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e2b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x08b1, 0x39e7, 0x0000, 0x0000,
  0x066a, 0x1826, 0x336b, 0x3ae6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4f28, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8f87,
  0x102c, 0x4546, 0x43c8, 0x6467, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x36c8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6d64,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1da4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3106, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x466c, 0x0000, 0x0000, 0x0000, 0x124a, 0x3784, 0x0000, 0x0000,
  0x1bc9, 0x9d87, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5f29, 0x0000, 0x0000, 0x5766, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8b86, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x67a4,
  0x1e4c, 0x0000, 0x0000, 0x4a26, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1928, 0x0487, 0x1c0c, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb2c6, 0x0000, 0xe1c6,
  0x0000, 0x4164, 0x0000, 0x0000, 0x77c9, 0xec26, 0x0000, 0x0000,
  0x0000, 0x6766, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xff66,
  0x0d08, 0x1e46, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2388, 0x1287, 0x014e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x9c26, 0x0000, 0x0000, 0x0000, 0x64e4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0bd3, 0x0000, 0x0000, 0x0000, 0x3dc8, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xbcc7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3f28, 0xa347, 0x0000, 0x0000, 0x5f8a, 0x2185, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x3004, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xd4e7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x13e9, 0x7884, 0x48e8, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4064, 0x0000, 0x0000, 0x4f08, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x8c66, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1104, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xdec6, 0x0000, 0x0000, 0x0589, 0xa0e7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5b85, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2728, 0x54e7, 0x0000, 0x0000, 0x2d2a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4a66, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5e29, 0x1266, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x112a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x33c5, 0x0000, 0xdc47, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4ae6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xdaa6, 0x0000, 0x0000, 0x0000, 0xcb66, 0x0000, 0x3d04,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0a64, 0x0000, 0x0000,
  0x0000, 0x0000, 0x548c, 0x0000, 0x0000, 0xcce7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x22c6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c2c, 0x0000,
  0x01d0, 0x87a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x61ab, 0x3087, 0x0000, 0x6a24, 0x0768, 0x1ca7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x8b66, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0bd0, 0x0000, 0x0000, 0x0000, 0x0000, 0x5786, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb0c6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5284, 0x5c2a, 0x8167,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1b29, 0x5647,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x220a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7e64,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1849, 0x5ba4,
  0x0000, 0x0000, 0x072a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2b8b, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7508, 0xf7a6, 0x0435, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x60e6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2647,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7a65,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4c65, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1645, 0x0000, 0x0000, 0x0000, 0x7e44,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5306,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x30c4,
  0x0000, 0x0000, 0x0000, 0xbcc6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3da7,
  0x0000, 0x0000, 0x04b2, 0x0000, 0x0000, 0x0000, 0x0000, 0x5a86,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c0e, 0xc027,
  0x0000, 0x0000, 0x150b, 0x3b25, 0x0000, 0x0000, 0x0000, 0x0d25,
  0x0000, 0x0000, 0x0000, 0x0000, 0x56c9, 0x36c5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0178, 0x9d06, 0x0000, 0x0000, 0x0000, 0xcb47, 0x0000, 0x6164,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0328, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2684, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5ca7, 0x0000, 0x53e4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5128, 0x12c7, 0x0000, 0x0000, 0x0c69, 0x4126, 0x0000, 0x0000,
  0x006e, 0x2a65, 0x0000, 0x0000, 0x0000, 0x43e6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa9c6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1d4c, 0x1366,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xcb86,
  0x0000, 0x5fc4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x67a7,
  0x0000, 0x0000, 0x0000, 0xb4a7, 0x0000, 0x0000, 0x0000, 0x3cc5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0228, 0xcc67, 0x0000, 0x0000,
  0x0000, 0x0000, 0x45ca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xaa46, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4ae5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xac06, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0ba9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x37e6,
  0x0000, 0x0000, 0x3b69, 0x4827, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x266e, 0x0000, 0x4409, 0x4c24, 0x0000, 0x0000,
  0x0000, 0x7444, 0x0000, 0x0000, 0x0000, 0x0000, 0x02ae, 0x7565,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7845, 0x1548, 0x5165,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3d8c, 0x32c4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4aa7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7aa4, 0x0000, 0x0000, 0x0000, 0x4424, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc2c6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x6ec9, 0x0226, 0x0000, 0x0000,
  0x0231, 0x0000, 0x716a, 0x0000, 0x0000, 0x0000, 0x0dc8, 0x0000,
  0x0000, 0x0000, 0x06b3, 0x3945, 0x0008, 0xf7e7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x24e9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x738a, 0xe686, 0x0000, 0x9a06,
  0x0000, 0x0000, 0x0000, 0x0000, 0x08ca, 0x40e4, 0x0000, 0x7c24,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4a08, 0x03e6,
  0x0000, 0x7165, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ba6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x06e8, 0x0000, 0x3308, 0x1a04, 0x070c, 0x0000, 0x0000, 0xd3a6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x372c, 0x0000, 0x3829, 0x7406, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1e24, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xbea7, 0x0000, 0x2064,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x15a4, 0x172d, 0x0000, 0x3a09, 0xc867,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x8b27, 0x1428, 0x3884, 0x0000, 0x0000,
  0x5a48, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01b6, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x072c, 0x2426,
  0x056e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xd3c7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3488, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3327, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x268a, 0x0000,
  0x0000, 0xe8e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x62c6, 0x0000, 0x0000, 0x5d28, 0x7d45,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2427, 0x088b, 0x1de4, 0x01b5, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4c25,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2de4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4206,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x56c4, 0x0749, 0x4487, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x55ec, 0x0000, 0x0000, 0x0000, 0x0000, 0xdaa7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7d8a, 0x52a4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x37a9, 0x0000, 0x0000, 0x0000, 0x0954, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1aa7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5f06,
  0x0000, 0x0000, 0x17ab, 0xd107, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xc186, 0x7909, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x30cb, 0x5de4, 0x0000, 0x3324, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x202a, 0xc847, 0x0d31, 0x3b26,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x138f, 0xf3a6,
  0x0000, 0xde67, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5f66, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03ae, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6e67, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3d06, 0x0000, 0x4d25, 0x0000, 0x0000, 0x064b, 0x0000,
  0x56cb, 0xbdc7, 0x6229, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4444,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x02d1, 0x0000, 0x0000, 0x0000, 0x0000, 0x7f06,
  0x0000, 0x0000, 0x0000, 0x2724, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1708, 0x74e7, 0x0e49, 0x5a06, 0x0000, 0x0000,
  0x174c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x324b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0be8, 0x6ec5, 0x0000, 0x7924, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5ae6, 0x0000, 0x7fa5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x94c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1324, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x63c5, 0x0000, 0x4964, 0x0000, 0x0000,
  0x56e8, 0x4ac6, 0x0000, 0xf126, 0x4829, 0x77a5, 0x0000, 0x1024,
  0x5e69, 0x3ac7, 0x0000, 0x0000, 0x3848, 0x1285, 0x0000, 0x0000,
  0x0000, 0x91c6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1faa, 0x0000,
  0x7d6b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x05c9, 0x0000, 0x0000, 0x6de4,
  0x0000, 0x64c6, 0x0000, 0xe987, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xe5a6, 0x0000, 0x0000, 0x0000, 0x5b46, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x78a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3f48, 0x0000, 0x0000, 0x0000, 0x014f, 0x0000,
  0x0000, 0x0000, 0x02ca, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7408, 0x2506, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6ac4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4f8b, 0x0000, 0x0000, 0x0000, 0x040a, 0x7ac7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x75a8, 0x0000, 0x0000, 0x0000, 0x0000, 0x3665,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08e8, 0x0aa5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x560c, 0x5c87,
  0x0bc9, 0x5665, 0x0000, 0x0000, 0x54ea, 0x16e5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7626, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4369, 0x0000, 0x5588, 0xf927, 0x0000, 0x0000,
  0x0000, 0x5266, 0x0000, 0x48e6, 0x0000, 0x6464, 0x0000, 0x5805,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1664, 0x16a8, 0x2b67,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1e64, 0x32aa, 0x1965, 0x0000, 0x0000,
  0x0c6b, 0x6746, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3d86, 0x0000, 0x10c5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x008e, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5324, 0x2ba9, 0x1f04, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4c8b, 0x9ec7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2e65, 0x0000, 0x0000, 0x0000, 0x6747, 0x0000, 0x0000,
  0x0000, 0x0000, 0x02b7, 0xbfe6, 0x6b4b, 0x2ec4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x26e9, 0x0000, 0x0000, 0x0000,
  0x7bea, 0xf606, 0x0000, 0x0000, 0x0000, 0x0000, 0x3dc9, 0xcde6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6026, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5046, 0x0000, 0x0000, 0x5b09, 0x0f66, 0x0000, 0x0000,
  0x0000, 0xb367, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x09f4, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xb226, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0d4d, 0x5864, 0x3ccb, 0x1a66, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5e8a, 0x1764, 0x0000, 0x0000, 0x0000, 0xacc6,
  0x0000, 0x0000, 0x0000, 0x15e5, 0x0000, 0xbaa6, 0x0000, 0x7de6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1b66, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4068, 0x48c5, 0x0000, 0x6a65, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x9fc6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7d04, 0x7aca, 0x0000, 0x5f48, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6b68, 0x0c44,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x714a, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xd846, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9426, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x050a, 0x0000,
  0x0000, 0x0000, 0x1269, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x514c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x070b, 0x1a25, 0x0000, 0x4524, 0x0000, 0x0000, 0x028e, 0x4aa5,
  0x0000, 0xc9c7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x12c4,
  0x0630, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1808, 0x0000, 0x0000, 0x6247, 0x10cf, 0x0000, 0x0000, 0x0000,
  0x1149, 0xccc6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0548, 0x1987, 0x0000, 0x4cc4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1272, 0x0064,
  0x0000, 0x0000, 0x0000, 0x0000, 0x75c8, 0x0000, 0x0000, 0x7f64,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0869, 0x23a5,
  0x0000, 0x0000, 0x0117, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa3a6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2bc9, 0x03a4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xd387,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4529, 0x3ea5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7b88, 0x0000, 0x0000, 0x0000, 0x1bee, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3f8c, 0x8c67,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xdc87, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xfbe6,
  0x0000, 0x0000, 0x0000, 0xc7e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1026, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x42c4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x000c, 0x0324, 0x4dab, 0x9c07, 0x2829, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2f64, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x372d, 0x0ec4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6929, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x56ac, 0x0000,
  0x514a, 0x2745, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7224,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6e0a, 0x0000,
  0x3b68, 0x0000, 0x0000, 0x7f05, 0x1668, 0x4b47, 0x0dea, 0x2926,
  0x0000, 0x0000, 0x0000, 0xe907, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7729, 0xec06, 0x0000, 0x0000, 0x6189, 0x0000, 0x0000, 0x0000,
  0x0a4c, 0x0000, 0x0000, 0x0000, 0x0000, 0x66a5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7784, 0x0e0a, 0x0000, 0x0000, 0x0000, 0x5809, 0x4264,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2a29, 0x3026,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7269, 0xe926,
  0x0000, 0x0000, 0x2028, 0x0205, 0x0000, 0x3cc4, 0x0000, 0x0000,
  0x0000, 0x0904, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4da5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1d49, 0x0000,
  0x0000, 0x65e5, 0x0000, 0x0000, 0x5ce8, 0xf867, 0x19a8, 0x18a6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2746, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1b6a, 0x3886, 0x49aa, 0x0000, 0x1609, 0x29a4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8ac6, 0x05eb, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6be8, 0x0000, 0x0000, 0x2586, 0x0000, 0x9aa6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xd2a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x00e8, 0x10e7, 0x3169, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4ee7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x686a, 0x0000, 0x0000, 0x0000, 0x4bc8, 0x32c7, 0x0000, 0x7a66,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4c85, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x13c8, 0x2e84,
  0x0000, 0x6ac5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xba87, 0x0000, 0x0000, 0x0000, 0x6826, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5dc6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1865, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5b48, 0xf9a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x39ee, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2148, 0x5de5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x66a7,
  0x0000, 0x0000, 0x0000, 0x5966, 0x0000, 0x0000, 0x0000, 0x6c86,
  0x0000, 0x77e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x83a7, 0x0000, 0x0000,
  0x0000, 0x76c5, 0x0000, 0x8726, 0x0000, 0xc767, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0774, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x05e7, 0x5589, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc8c6, 0x0000, 0x6126,
  0x0000, 0x7f87, 0x0000, 0x0000, 0x0000, 0x88c7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2bc4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x206d, 0xe287, 0x0000, 0x0000,
  0x0000, 0x78e5, 0x0000, 0x0000, 0x6508, 0x3b24, 0x23ca, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x63c4, 0x4ea8, 0x1bc4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x402b, 0x2a25, 0x264d, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1248, 0x0000,
  0x0000, 0xcdc7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3a24,
  0x0000, 0x0000, 0x0000, 0x41a4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x256a, 0x14a7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x8506, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4a84, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1dcb, 0x0a46, 0x0000, 0x9a27, 0x6fc8, 0x7844, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5ba9, 0x3de5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x9686, 0x0000, 0x0000, 0x0000, 0x45e5, 0x3e69, 0x0000,
  0x1c08, 0x02a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0c29, 0xb4c7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5b26, 0x0000, 0x0000, 0x46a8, 0x5ae4,
  0x0000, 0xf386, 0x0000, 0x0000, 0x0000, 0x40e5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9526,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x62cc, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2868, 0x3244, 0x488b, 0x0000, 0x0000, 0x0765, 0x0000, 0x0000,
  0x0452, 0x0000, 0x7008, 0x7824, 0x0000, 0xa0a6, 0x0000, 0x0000,
  0x05d4, 0x0000, 0x3bed, 0x0000, 0x0000, 0x0000, 0x0000, 0x0aa4,
  0x0000, 0x52e4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x61e4,
  0x0828, 0x5544, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0166,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4144, 0x0000, 0x0000,
  0x0000, 0x0684, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2fe4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2aeb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x31a9, 0x2324,
  0x0000, 0x0000, 0x4f69, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x79e4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0e94, 0x0000, 0x066e, 0x0000, 0x0000, 0x6b44, 0x0000, 0x8666,
  0x42e8, 0x3805, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4c47,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x17e8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2167,
  0x542a, 0x27e4, 0x38a8, 0x2a06, 0x0000, 0x44e6, 0x0000, 0x0000,
  0x1b49, 0xafc7, 0x08aa, 0x2005, 0x0000, 0x0000, 0x7708, 0xf786,
  0x0000, 0x6824, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x04f1, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0a32, 0x0000,
  0x0000, 0x0000, 0x2c0e, 0x4f47, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4d44, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0931, 0x2a64, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x152d, 0x5ee4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8667,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3c48, 0x5126,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3048, 0x2a05, 0x0000, 0x0000, 0x0000, 0x8166, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7385, 0x0000, 0x0927, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xf667, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xb646, 0x0000, 0x3185, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x05c8, 0x7424,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2287,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6f84,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x13c7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xb306, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0337, 0x0000,
  0x0000, 0xfa27, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3bc4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0b6c, 0xb6a7,
  0x1a68, 0x4b44, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x8586, 0x0000, 0x0000, 0x0f89, 0x01a4,
  0x0000, 0x0000, 0x0000, 0x7dc7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5be4, 0x658a, 0x0000,
  0x0000, 0x1544, 0x0000, 0x0000, 0x0000, 0x2605, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1284,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4165, 0x0000, 0x0000, 0x1212, 0x5b47, 0x0000, 0x0000,
  0x7aa8, 0x0000, 0x0000, 0x0de5, 0x0000, 0x0000, 0x108a, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6f46, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x3785, 0x0000, 0xdf67, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0f68, 0x0000, 0x0000, 0x0000, 0x0000, 0xff26, 0x7488, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7525, 0x0000, 0x7c66, 0x0000, 0x0000, 0x1fea, 0x0000,
  0x0000, 0x1145, 0x6bea, 0x78a4, 0x0000, 0x0000, 0x4eec, 0x0000,
  0x0000, 0x0000, 0x0000, 0xae46, 0x2808, 0x5184, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7026, 0x0000, 0x5684, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7347, 0x0000, 0x4d65, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x77a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x72a5, 0x0000, 0x8987, 0x0000, 0x0000, 0x0000, 0x92a6,
  0x0000, 0xf146, 0x2188, 0x1f65, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x30c8, 0x2b45,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5d06, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4e05,
  0x0000, 0x0000, 0x0000, 0x61e5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8ca6,
  0x0000, 0x0000, 0x0000, 0x4a44, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2184,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4665,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x52c8, 0x04a5, 0x0000, 0x0000, 0x0000, 0xa686, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3f86, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2968, 0x38a7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x41e9, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0c46, 0x0000, 0x0000, 0x480b, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0a8d, 0x0000, 0x1868, 0x04a6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x50a5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2444, 0x0000, 0x0000, 0x5f4a, 0x08c6, 0x0000, 0x0000,
  0x0000, 0xa467, 0x0000, 0xf466, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1a48, 0x1067,
  0x0000, 0x0000, 0x0000, 0x0000, 0x63ab, 0x0000, 0x04cf, 0x0000,
  0x166e, 0x3d07, 0x0000, 0x7504, 0x0000, 0x38a5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4a67, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7be6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x51a4,
  0x0000, 0x3f27, 0x0000, 0x0000, 0x0000, 0x70e6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0a12, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x360e, 0x0000, 0x0000, 0x2744,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1d08, 0xab07, 0x42c9, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0369, 0x0000, 0x0000, 0x0000,
  0x018e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x210b, 0x5c07, 0x0000, 0xcf26, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6986, 0x0000, 0x0fe7,
  0x0000, 0x0000, 0x0000, 0x9406, 0x0000, 0xa1c6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2d88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0fab, 0xb0e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6309, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6a29, 0x4ec4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7904,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xb4c6, 0x0f88, 0x19c7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x20c4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0fe8, 0x0c64, 0x0000, 0x0000,
  0x40a9, 0x7264, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0a6e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x80e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xb7c6, 0x0000, 0x7745, 0x0000, 0x0000, 0x3448, 0x2606,
  0x3349, 0x0000, 0x0000, 0x0000, 0x0000, 0x5bc6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xe3c6, 0x0000, 0x0000, 0x0000, 0xe0c7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01c6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x142b, 0x0e25, 0x08ac, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2244, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x43a4, 0x0000, 0x4e65, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x14c7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6a26,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x59a5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4b08, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x51c5, 0x0000, 0x0000,
  0x178a, 0x2226, 0x0000, 0x0000, 0x0000, 0x43e4, 0x0000, 0x3347,
  0x0c4b, 0x0000, 0x0000, 0x75a4, 0x0000, 0x0000, 0x174b, 0x1f44,
  0x0000, 0xdf26, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa766,
  0x39c8, 0x7827, 0x0000, 0x6184, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4225, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3b48, 0x9f87, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3a8c, 0x7685, 0x0000, 0x0000,
  0x0000, 0x0000, 0x522c, 0x5e26, 0x0000, 0x0000, 0x0000, 0x0000,
  0x75ab, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4284, 0x7b2b, 0x68a5, 0x0000, 0xe8a7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2488, 0x2944,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5fe7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5024, 0x0000, 0x0000, 0x0000, 0x9a26, 0x1e49, 0x0000,
  0x6e69, 0x0000, 0x224a, 0xfb06, 0x0000, 0x57e4, 0x23ac, 0x0000,
  0x0000, 0x4764, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x66e8, 0x6d25, 0x3e4a, 0x4d27,
  0x0000, 0x35e4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x236b, 0x0000, 0x3229, 0x0000,
  0x10c9, 0x61a6, 0x350b, 0x0425, 0x0000, 0xfac7, 0x0000, 0x0000,
  0x2248, 0x0000, 0x0000, 0xeb47, 0x0000, 0x6344, 0x0000, 0x0000,
  0x0000, 0xe707, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3808, 0x05e6, 0x0000, 0x0000, 0x0000, 0x95e6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3429, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x24e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7f65, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4d84,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3a0b, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1a06, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x374a, 0x0000, 0x744a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3748, 0x0886, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8d06, 0x698b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6265, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3d68, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x58e6, 0x0000, 0x0000, 0x0130, 0x0000,
  0x690a, 0x3264, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x140a, 0x3187, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x54e5, 0x28c9, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8d07,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5c26, 0x0000, 0xe087,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2a48, 0x47c4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x8906, 0x3d6a, 0x32a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x8727, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xd187, 0x0000, 0x96e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7609, 0x2c45, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4ac8, 0x0000, 0x2529, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xdd87, 0x5dea, 0x0000, 0x04ad, 0x0000,
  0x0000, 0xe486, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2026, 0x17e9, 0x48c4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x62ca, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3aa8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x10a8, 0x2646, 0x7e6b, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2569, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x68a4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2088, 0x2925, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa506,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x13d2, 0x5224,
  0x0000, 0x94e7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x00f8, 0x0000, 0x79c8, 0xf266, 0x0000, 0xd027, 0x0000, 0x0000,
  0x0000, 0x0000, 0x010f, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2408, 0x0845, 0x0000, 0x0000, 0x0000, 0x0000, 0x3dca, 0x15e7,
  0x0000, 0xcd66, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4748, 0x02a4, 0x284a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0fa8, 0x0000, 0x0000, 0x9be6, 0x0000, 0x0000,
  0x06c8, 0xd286, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x69c8, 0x76e4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3364, 0x0000, 0x0a04,
  0x03ef, 0x0000, 0x0000, 0x0000, 0x0000, 0x53a7, 0x0000, 0x5427,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xa2e6, 0x580a, 0x2565, 0x0000, 0x0000, 0x0000, 0x2266,
  0x0000, 0x0000, 0x1b08, 0x1b64, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa4e7,
  0x0000, 0x0000, 0x358c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4045, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x062e, 0x06e4, 0x0cd2, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2d85, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2f6b, 0x0000, 0x2649, 0x0984, 0x0689, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9d46, 0x0000, 0x0000,
  0x0000, 0x8446, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5204,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1207, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xaba7, 0x014d, 0x4547, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x68c5, 0x0000, 0x7e85, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1348, 0x1f66, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2a85,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6546, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3deb, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x20a8, 0x0000,
  0x4449, 0x1f06, 0x0000, 0x2cc4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x46e6, 0x37a8, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5726, 0x0000, 0x0000, 0x0000, 0x4824, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x72aa, 0x15c6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6dc5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2be4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x23c4, 0x0000, 0x0000, 0x0508, 0x36c7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf3c6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5c44, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x792a, 0xffe6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6646, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6c45, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xb766, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7984,
  0x0000, 0x2c66, 0x0000, 0x0000, 0x0000, 0x3924, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2168, 0x41e5, 0x0d0b, 0x0000,
  0x0000, 0x0000, 0x0000, 0xc9a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0e86, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6ec6, 0x0000, 0x0ac4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x05b6, 0x0000, 0x0000, 0x6be6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xf426, 0x384a, 0x09e4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2fae, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8ec6, 0x0000, 0x94a6, 0x0000, 0x0000, 0x0000, 0x52e5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x69c5,
  0x0000, 0x0000, 0x420a, 0x0000, 0x3a28, 0x2f45, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x28ae, 0x7067, 0x5509, 0xeb07,
  0x0000, 0xdd46, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5104,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6708, 0x7625,
  0x0000, 0xffc6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2c08, 0xcda7, 0x0000, 0x1304, 0x0000, 0x0000, 0x0000, 0x4c66,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7dc5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x3485, 0x0000, 0x0000, 0x0000, 0x6807,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2be5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x09c8, 0x0505, 0x0000, 0x0000, 0x0788, 0x0000,
  0x0000, 0x0000, 0x0000, 0xa946, 0x5d29, 0x5a84, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5fa8, 0xf3e7,
  0x1b68, 0x0d87, 0x4fe9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3e88, 0x01e5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xebc6, 0x58e9, 0x19a5, 0x0000, 0x0000, 0x78a8, 0x6c26,
  0x0000, 0x0000, 0x0000, 0x42c5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5669, 0x0000, 0x0000, 0x0000, 0x1da9, 0x3766, 0x0000, 0xc266,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb046, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7c64, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4844, 0x0000, 0x0000, 0x0000, 0x0000, 0x6e2a, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x66c4,
  0x0000, 0x7365, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7384, 0x0000, 0x0000,
  0x0000, 0x5325, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xeda7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2124, 0x216c, 0x0ba5,
  0x0000, 0x0000, 0x0000, 0xb567, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5d67, 0x6789, 0x6286, 0x266b, 0x1707, 0x0000, 0x18c7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7c47, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x24e8, 0x1d25, 0x0000, 0x0000,
  0x0000, 0x7a45, 0x6969, 0x7124, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x6a48, 0x79c4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x00d8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3fa4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa366,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1926, 0x0000, 0x0000,
  0x0000, 0x8227, 0x0000, 0x0000, 0x0000, 0x8206, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x56a5,
  0x1d4b, 0x60c6, 0x0000, 0x2a04, 0x0000, 0xaee7, 0x02d4, 0x0000,
  0x64a8, 0x6445, 0x6129, 0x14e5, 0x62a9, 0x0000, 0x0000, 0xd526,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0147, 0x48c9, 0x0165, 0x0000, 0x0000,
  0x1988, 0x2104, 0x0000, 0x0000, 0x070a, 0x0000, 0x0000, 0xefa6,
  0x0000, 0x3ac5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x95c7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7eeb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5965,
  0x0000, 0x0000, 0x72e9, 0x0000, 0x0000, 0x0000, 0x6348, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6c64,
  0x0000, 0x0000, 0x5a88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x17c6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8546, 0x0000, 0x0000,
  0x0000, 0x0000, 0x086e, 0x0000, 0x15d2, 0x7684, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5f84, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0969, 0x1126, 0x0000, 0x5e84, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7e08, 0x6944, 0x506b, 0x0000, 0x0000, 0x0000,
  0x086b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x10e8, 0x66a4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5c0c, 0x0000,
  0x30aa, 0x27e7, 0x0000, 0x0000, 0x624a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xff86, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x80c6, 0x0000, 0x0000, 0x0000, 0x8766, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x9946, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2c88, 0x0744, 0x16a9, 0x30a4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b45,
  0x0000, 0x0000, 0x0000, 0x3564, 0x0000, 0x33a6, 0x0000, 0x5b44,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2ea5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x63e7,
  0x0000, 0x0000, 0x0000, 0xe027, 0x0000, 0x0000, 0x0000, 0x2844,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0b31, 0x2447, 0x004b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5404, 0x7128, 0xe886, 0x0000, 0x0000, 0x0000, 0x5c25,
  0x0000, 0x0000, 0x0000, 0x5d46, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1225,
  0x0f8c, 0x6e87, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3064,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x54e6, 0x0000, 0x44c7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa327, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4804, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x55c6, 0x0000, 0x72e5,
  0x0000, 0x0000, 0x04b4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0ca8, 0x0a44, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x77c4, 0x0000, 0x0000, 0x0000, 0x70e5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x126c, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2dea, 0x0000, 0x0000, 0x0000, 0x0000, 0x5646, 0x0000, 0x5824,
  0x5169, 0x0000, 0x0000, 0x6ee7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0b46,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7186,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9da6,
  0x0000, 0x0000, 0x3e2c, 0x9a66, 0x0000, 0x35a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x710a, 0x0000, 0x6089, 0x0fa6, 0x0000, 0x0000,
  0x0000, 0x6924, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6b86,
  0x7648, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x600a, 0x0000, 0x6049, 0x1406, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x21ec, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x59eb, 0x0000, 0x5089, 0x48a7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x50c9, 0x2607,
  0x0000, 0x4ee4, 0x0000, 0x0000, 0x0000, 0x0000, 0x6e08, 0xbd27,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7aa7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3644, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x44c6, 0x0000, 0x0000, 0x3b8a, 0x7447,
  0x670a, 0x4525, 0x0000, 0x0000, 0x3888, 0x0000, 0x12e8, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6084, 0x0000, 0x2485,
  0x10ea, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3f09, 0x0000, 0x0000, 0x8826, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x61e7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4b6a, 0x3067,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1d09, 0x7204, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7a26,
  0x0000, 0x0000, 0x5988, 0x0c47, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5ba5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x026a, 0x0000, 0x0000, 0x0000, 0x0000, 0x5385,
  0x0000, 0x2d04, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x520c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0138, 0x5ac7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0909, 0x0000,
  0x0000, 0x9ea6, 0x0000, 0x0000, 0x39e9, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xb5c7, 0x0000, 0xa0e6, 0x4b0b, 0x0000,
  0x7ba8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0d69, 0x1487, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x84a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0048, 0x0364, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8ce6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3984, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7484,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4986,
  0x4e28, 0x0000, 0x0000, 0x0000, 0x0000, 0x0986, 0x0b88, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x012d, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5f64, 0x0000, 0x4dc4, 0x0000, 0x0000,
  0x0000, 0x1fa5, 0x0000, 0x4447, 0x0000, 0x0000, 0x0929, 0x0000,
  0x200a, 0x4e07, 0x0000, 0x0000, 0x046c, 0x1a85, 0x0000, 0x0000,
  0x5d49, 0x0000, 0x0000, 0x0000, 0x12ca, 0x0000, 0x0000, 0xb746,
  0x0000, 0x0000, 0x0000, 0xa266, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xbdc6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x99a6, 0x0000, 0x0000, 0x0000, 0x6605,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x13ec, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5bc8, 0x6ca5, 0x0708, 0x43c4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1949, 0x1d04,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1a88, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0de8, 0x0d86, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xd606,
  0x0000, 0x0000, 0x1b0e, 0x0000, 0x0000, 0x0000, 0x0000, 0x10a4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5146, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0731, 0x0c66, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6329, 0x1ec6, 0x0000, 0x0000, 0x0000, 0x0000, 0x7fe8, 0x0000,
  0x0000, 0x25c7, 0x0000, 0xe9e7, 0x0000, 0x5b04, 0x1f89, 0x0000,
  0x0000, 0x39a6, 0x0000, 0x0000, 0x0000, 0x2866, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x60e8, 0x39a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x158b, 0x0000, 0x0000, 0x3a04,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0932, 0x5ae7, 0x0000, 0x7fe4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4828, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x81a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3608, 0x33a4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x63e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x13e8, 0x0000,
  0x37cb, 0x50c7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x3164, 0x0000, 0x0000, 0x0000, 0x0000,
  0x122b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x15c9, 0x0000, 0x0000, 0x3546, 0x4c0a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7a29, 0x0000, 0x1f4a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0c8b, 0x0000, 0x0000, 0x0000, 0x0000, 0xf7c6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b85, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5249, 0x0985, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x37e8, 0x0000, 0x0000, 0x0000, 0x0000, 0x41c4, 0x0000, 0x0000,
  0x7ce9, 0x4f84, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1787, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2d49, 0x22e4,
  0x0000, 0x0000, 0x0000, 0xd9e7, 0x0000, 0x1644, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6d04,
  0x0000, 0x67e6, 0x0000, 0x0000, 0x6809, 0x1946, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf446, 0x0000, 0x0000,
  0x0000, 0x0000, 0x408a, 0x6d07, 0x0000, 0x0000, 0x2729, 0x1c04,
  0x0000, 0x0000, 0x030b, 0x0000, 0x0168, 0x4445, 0x0000, 0x0000,
  0x0000, 0xf227, 0x1e48, 0x1e25, 0x05d6, 0x0000, 0x0000, 0x0000,
  0x67c9, 0x9f26, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6726, 0x28ea, 0x7dc4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xc587, 0x4089, 0x2dc4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xd906, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf1e6, 0x0000, 0x6744,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4de8, 0x2966, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2407, 0x0000, 0x7286, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xec07, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xb7e6, 0x0000, 0xc446, 0x0000, 0x3144, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf167, 0x0000, 0x47c7,
  0x0000, 0x5244, 0x61a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2ec8, 0x0000, 0x0000, 0x0000, 0x0000, 0x5be7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x286b, 0x2b04, 0x0000, 0x4947,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1369, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7145, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8e66, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0d8a, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4d04, 0x6b28, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5688, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x66e6,
  0x0000, 0x0000, 0x0000, 0x2624, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5526, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4c68, 0x1ac5, 0x7d88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x02ee, 0x0000, 0x0000, 0xd4e6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb467,
  0x0000, 0x0000, 0x0271, 0x5946, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0c4a, 0x5c24, 0x0000, 0x0000, 0x4108, 0xdbc6, 0x0000, 0x0000,
  0x1e4a, 0x05e5, 0x0000, 0x0000, 0x436a, 0x1165, 0x0000, 0x0000,
  0x0000, 0x0000, 0x308d, 0x0000, 0x0000, 0x0000, 0x0000, 0x1fa6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f8a, 0x0000,
  0x5d2c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x36e8, 0x0d64, 0x0000, 0x6ce4,
  0x0000, 0x0000, 0x0000, 0x1ca4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x70e4, 0x0000, 0x0000, 0x08ec, 0x0000, 0x0000, 0x44a5,
  0x00c9, 0x05e4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7a85, 0x6c28, 0x5825, 0x0000, 0x0000,
  0x0000, 0x1427, 0x0000, 0x0000, 0x0000, 0x0000, 0x11e8, 0x4307,
  0x0000, 0x0000, 0x0000, 0xad86, 0x262a, 0x5a85, 0x0000, 0x0000,
  0x0000, 0x0265, 0x0000, 0x0000, 0x0000, 0x3165, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x69c4, 0x094a, 0x0000, 0x0000, 0x0000,
  0x2e88, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x56e4, 0x7528, 0x3e27, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x59c6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xc5a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0248, 0x2385, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4aa4, 0x0000, 0x0000, 0x0000, 0x7e04,
  0x0000, 0x0000, 0x0000, 0x6564, 0x718b, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb7e7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2888, 0xf1e7, 0x0000, 0x0000, 0x0000, 0xfbc7,
  0x0ca9, 0xfae7, 0x0000, 0x0000, 0x494b, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x038b, 0x86a7,
  0x0000, 0x0000, 0x0000, 0x98a6, 0x0000, 0x0000, 0x07cb, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xdcc6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x53cb, 0x0000,
  0x3e6a, 0xd026, 0x0000, 0x0000, 0x0c28, 0x02c4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x3c25, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x04a9, 0x10c6,
  0x1368, 0x3cc7, 0x0000, 0xade6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x49e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x26c8, 0x2f85, 0x0000, 0x0000, 0x0000, 0x0000, 0x3329, 0x2d84,
  0x0000, 0x0000, 0x0000, 0x3c46, 0x0000, 0x0000, 0x20e8, 0x61a4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6486, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0bc4, 0x0000, 0x33e4, 0x0000, 0x2b85,
  0x0000, 0x0000, 0x0000, 0x7e84, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x14b2, 0xe166, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3304, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2029, 0xa526, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8e46,
  0x0000, 0x0000, 0x0000, 0x1f24, 0x0000, 0x0000, 0x0000, 0x4805,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1cee, 0x0000, 0x0000, 0x0000,
  0x2409, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3629, 0x7ba6, 0x762b, 0x9e07, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0aec, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x616c, 0x4347, 0x0000, 0x0000, 0x0000, 0x33a5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3de8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2708, 0x06c7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4248, 0x3a86, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xb986, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x65e9, 0x4c26, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3c86,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7089, 0x0000, 0x0000, 0x0000, 0x0000, 0xa6e7,
  0x0000, 0xd786, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5005, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xe4e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b44,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x89e6, 0x0000, 0xbc07, 0x51ec, 0x7826, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2625, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9a87, 0x0000, 0x0000,
  0x35a8, 0x3c04, 0x0000, 0x0000, 0x0000, 0x0000, 0x5c6a, 0x22c7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5886,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xe606, 0x1d2c, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xfc26,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xba06, 0x0000, 0x0000,
  0x0000, 0xc6c6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9d66,
  0x0390, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x05a9, 0x0000, 0x0491, 0x0000, 0x02ce, 0xb447,
  0x2f48, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xbc66,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x04eb, 0x0000, 0x0000, 0x83c6, 0x5aa8, 0x2d66,
  0x0000, 0xfe86, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x74e9, 0xe9e6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x64a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x65a5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x022b, 0x5905, 0x0000, 0x4d24, 0x06e9, 0x2806,
  0x21e8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x37aa, 0x0000, 0x170b, 0x0ce7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5269, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5486, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2a2b, 0x0000, 0x0000, 0x0000,
  0x3f4c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x696a, 0x09a5,
  0x0000, 0x3944, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb187,
  0x2fca, 0x0da6, 0x11cb, 0x2946, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0b70, 0x0000, 0x0000, 0x0000, 0x3d8b, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9ae6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1a6b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8326, 0x0000, 0x2827, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xf827, 0x0000, 0x0000, 0x0f48, 0x0000,
  0x0000, 0x1d44, 0x0000, 0x0000, 0x0000, 0x7a06, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x44a8, 0x1fa7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4149, 0x35c5,
  0x0000, 0x0000, 0x12ae, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3f64, 0x0000, 0x0000, 0x0000, 0x0000, 0x6569, 0x4ec6,
  0x0000, 0x0000, 0x0000, 0x2ae4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3804, 0x49ea, 0x38e7, 0x0000, 0xaca7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x47e6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x92e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x51a6, 0x0000, 0x0000,
  0x0000, 0xdc26, 0x0000, 0x95c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x252a, 0x8ce7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x54c4, 0x0000, 0x0000, 0x0c70, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x046e, 0x0000, 0x05ad, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0f2a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0fa4, 0x0000, 0x0000, 0x0000, 0xcac6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5a24, 0x1228, 0x0000,
  0x0000, 0x0000, 0x1268, 0x6307, 0x0000, 0x0000, 0x0000, 0x5964,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf9e7, 0x0000, 0x0000,
  0x0948, 0x1505, 0x0000, 0x0000, 0x0830, 0x0000, 0x0000, 0x0000,
  0x0d2d, 0x1b86, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7806, 0x0000, 0x0000, 0x0000, 0x0000, 0x0014, 0x0000,
  0x358b, 0x7da4, 0x0000, 0x0000, 0x3228, 0x0c07, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xc766, 0x0e91, 0x0000, 0x7fa8, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x12c8, 0xf527, 0x0000, 0x0000,
  0x6408, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x256d, 0x0000,
  0x0000, 0xace6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6169, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4ac4, 0x0000, 0x4465, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x98c6, 0x0000, 0x0000, 0x0000, 0x6d84,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x10a5, 0x0000, 0x0000, 0x0000, 0x0000, 0x1768, 0x0000,
  0x0108, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x35ab, 0x0000, 0x55a8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1088, 0x3b06,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7546, 0x0000, 0x0000, 0x6d49, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x60c8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0b92, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x67c4,
  0x57a9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3548, 0x0fe4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4b69, 0x0766,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x24ad, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3727, 0x1468, 0x0de6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x64c4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1d2e, 0x0000, 0x0000, 0x0000,
  0x0000, 0xf947, 0x0000, 0xd966, 0x0000, 0x0000, 0x3128, 0x0000,
  0x2cee, 0x2525, 0x0000, 0x0000, 0x0000, 0x26a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2d68, 0x0000, 0x0000, 0x0000,
  0x15ee, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5348, 0x0000, 0x0000, 0xd167, 0x0000, 0x51e6, 0x0000, 0x0000,
  0x0000, 0x6507, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2304, 0x06cc, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x34a4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1f27, 0x0000, 0x0000, 0x0da9, 0x1fc6,
  0x0000, 0x20c5, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x64a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xcbc6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x53e5, 0x7988, 0x7ba4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6f24, 0x0000, 0x0000,
  0x0000, 0xacc7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4e64, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2d4b, 0x1947, 0x0000, 0x0000,
  0x0000, 0x0000, 0x30a8, 0x4606, 0x0000, 0x0000, 0x0000, 0x6927,
  0x0000, 0x0000, 0x46c8, 0x0000, 0x0000, 0x0000, 0x7548, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7205, 0x0000, 0x0000, 0x0000, 0xaa27, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3d88, 0x1d85, 0x0000, 0xe7c6,
  0x0000, 0x0000, 0x27c8, 0x17c5, 0x0000, 0xac07, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2ba7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x76e8, 0xf686, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2b09, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6a44, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x71c6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x026e, 0x0000,
  0x4928, 0x0aa7, 0x0000, 0x3ce4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x122a, 0x0000, 0x0a73, 0x0000, 0x0000, 0x7ea4,
  0x0000, 0x0000, 0x0000, 0xf047, 0x0000, 0x0000, 0x392a, 0x0f84,
  0x084b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9527,
  0x0a50, 0x0000, 0x2c0a, 0x38c5, 0x0732, 0x0000, 0x0000, 0xa6a7,
  0x3189, 0x0d66, 0x0000, 0x2e45, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1985, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7945, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3148, 0x0464, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7324,
  0x0000, 0x0000, 0x0000, 0xd407, 0x0000, 0xbde6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x7aa9, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8606, 0x0000, 0x0000, 0x0000, 0x5904, 0x0000, 0xcba6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5b06,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x9326, 0x0000, 0x0000, 0x0000, 0xc907,
  0x0217, 0x0000, 0x0000, 0x0000, 0x0000, 0x3ca5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1328, 0x23a4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xf326, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x068e, 0x0000, 0x02b4, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6668, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x72ab, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6207, 0x0000, 0x0000, 0x0000, 0x0000,
  0x10ef, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x38ca, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x68a8, 0xd6e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6a87,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7704, 0x0000, 0x0000,
  0x0000, 0x0000, 0x470a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3809, 0x0000, 0x0000, 0x0000, 0x0868, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xe446, 0x522a, 0x0000, 0x5b2b, 0x5346,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x53a4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3245,
  0x0000, 0x0000, 0x130b, 0x0000, 0x0000, 0x0000, 0x0000, 0x7207,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0668, 0x2807,
  0x0000, 0x37a4, 0x0000, 0x0000, 0x0000, 0x0000, 0x456a, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x304b, 0x0000, 0x0000, 0x1de5,
  0x0000, 0x0000, 0x1048, 0x0a67, 0x0000, 0x11e4, 0x0000, 0x0f65,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x77c6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1a44, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x35c4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x00ea, 0x1aa5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6427, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7506, 0x0000, 0x0d85,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6ea4, 0x496b, 0x1b65, 0x31ca, 0x1824, 0x0000, 0x91a7,
  0x0000, 0x0000, 0x6808, 0x1e26, 0x25e9, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7466,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1fc9, 0x4644, 0x0000, 0x6244, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa1c7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3da8, 0x1b06, 0x0000, 0x0000, 0x0000, 0x0000, 0x1b6b, 0x2aa7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x104b, 0xd8c7, 0x0e6a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x57a8, 0x4b85,
  0x0000, 0x0000, 0x6b08, 0x0000, 0x1869, 0x06c4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xd0a6, 0x0000, 0x0000, 0x0000, 0xdfe6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x9987, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4de4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x63c7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2069, 0x0f47, 0x0000, 0x0000,
  0x0000, 0x68a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7ea8, 0x0000, 0x0000, 0x4826, 0x0000, 0x0000, 0x0000, 0x3986,
  0x6f68, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x03e8, 0x0a45, 0x0000, 0x0000,
  0x0000, 0x4ba6, 0x0000, 0x0000, 0x0000, 0x9bc6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0889, 0x22c5, 0x14a8, 0x1464, 0x61a8, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0426, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8b26, 0x0000, 0x0000, 0x5a08, 0xf427, 0x196a, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3529, 0x28c6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x49a9, 0xa487, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3405, 0x0000, 0x0000, 0x0000, 0xa286, 0x0000, 0x69e7,
  0x0000, 0x0000, 0x52ca, 0x2cc5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x68e8, 0xe3e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x51cc, 0xbe46, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x146b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x274d, 0x7a44,
  0x0000, 0x0000, 0x0000, 0x4b24, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7645, 0x3648, 0x0000, 0x0000, 0x0000, 0x4ee8, 0x3367,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2908, 0xb767, 0x3feb, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6865, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x54a4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08c9, 0x0000,
  0x0000, 0x0000, 0x0000, 0xafa7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0d89, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2964, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5d65,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x088e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x3f24, 0x0000, 0x28c5, 0x0000, 0x0000,
  0x0469, 0x5664, 0x51ca, 0x0000, 0x0000, 0x0000, 0x04a8, 0x0406,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0e08, 0x1306, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x48a4, 0x0000, 0x0000, 0x0000, 0x0000, 0x31a8, 0x0fc6,
  0x0b2a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xbf66, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x196c, 0x73c5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4269, 0x9a07, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x75e6, 0x0000, 0x53c5, 0x1ceb, 0x6e04,
  0x0000, 0xca26, 0x0000, 0x0000, 0x0000, 0xf4a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x79e6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1e47, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x34a5, 0x0000, 0x0000, 0x01c8, 0x6845,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3a2a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6849, 0x5606, 0x33a9, 0x2ca4, 0x0000, 0x0000,
  0x0000, 0x49c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0e4b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x05a8, 0x1525,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x18c4, 0x0000, 0x0000, 0x46ab, 0x0304,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5666, 0x0000, 0x0000,
  0x0000, 0x29c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7227, 0x0e8c, 0x0000, 0x0000, 0x0000,
  0x0000, 0xaa06, 0x0000, 0x0000, 0x0000, 0x6444, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5429, 0x2686, 0x0000, 0x58a4,
  0x7c49, 0xea86, 0x0000, 0x1c84, 0x0000, 0x0000, 0x0000, 0xe607,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4c04, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc4a6, 0x0000, 0xfee7,
  0x1108, 0x4386, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7024, 0x0000, 0x0000, 0x7549, 0xeac6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb7a6,
  0x0000, 0x7ce5, 0x0000, 0x2564, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5d24, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3905, 0x0000, 0x0000, 0x0000, 0xb626, 0x1688, 0x56a7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0612, 0x5e64,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2a4b, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8866, 0x0000, 0x0000, 0x0000, 0x0000, 0x56ec, 0x0000,
  0x0000, 0xb707, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x79e7,
  0x0000, 0x0000, 0x29ed, 0x0000, 0x0000, 0xf766, 0x0000, 0x0000,
  0x0000, 0x0000, 0x21a8, 0xc3c7, 0x4ec9, 0x6f44, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xe2e7, 0x17ca, 0x0005, 0x0000, 0x0000, 0x78c8, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0128, 0x1d06,
  0x0000, 0x77c7, 0x0000, 0x0000, 0x4868, 0x2fc4, 0x0000, 0x1a84,
  0x0000, 0x0000, 0x0000, 0x0000, 0x7968, 0x5524, 0x0000, 0x0000,
  0x490b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x51e5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0871, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5de6, 0x0000, 0x0000, 0x0000, 0x0000, 0x34e8, 0x1ce6,
  0x0000, 0x0000, 0x7f0a, 0x2585, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0c88, 0x1da6, 0x0000, 0x0000, 0x0000, 0xab46, 0x0000, 0x0000,
  0x0000, 0x9707, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9866,
  0x342d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x18e5,
  0x0000, 0x0000, 0x356c, 0x0000, 0x0000, 0x0000, 0x0000, 0x76a6,
  0x5328, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5605, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x9446, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x490a, 0x2706,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x12e9, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4984, 0x0098, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x33cc, 0x1ce4, 0x0000, 0x0000, 0x5eaa, 0x20e6,
  0x0000, 0x4c84, 0x0000, 0x0000, 0x0000, 0x2804, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1c24, 0x0000, 0x0000, 0x0000, 0x0000, 0x074e, 0x32a4,
  0x0000, 0x79c5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7c84,
  0x106b, 0x41e4, 0x0209, 0x0000, 0x49c8, 0x7787, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1129, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x118a, 0x30c7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x8f07, 0x0000, 0x0000, 0x0000, 0x3a06,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x198b, 0x32e5, 0x25e8, 0x9847,
  0x0000, 0x0000, 0x0000, 0x0000, 0x00a8, 0x28a5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x018a, 0x6407, 0x0000, 0xdee7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3f0d, 0x4da6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7306, 0x0000, 0x2f04, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1b46, 0x5028, 0x0000, 0x6008, 0x38c7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0010, 0x0000, 0x548a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1486, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0656, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x51c8, 0x23a6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1c49, 0x2ae6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0113, 0x0000, 0x0000, 0xe286,
  0x0000, 0x0000, 0x0115, 0x0000, 0x0000, 0x0000, 0x11e9, 0x8ca7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa5e6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x47e9, 0xc7c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6fe6, 0x0000, 0x0000,
  0x0000, 0x77e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xdbe7,
  0x15a8, 0x0000, 0x0000, 0x0000, 0x0000, 0x2146, 0x20ae, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xb266, 0x0000, 0x0000, 0x2588, 0x8126, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4906, 0x0000, 0x0000, 0x0000, 0x0000, 0x0688, 0x3565,
  0x0000, 0x0000, 0x1b2b, 0x1de7, 0x0000, 0x8d26, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5b88, 0x1506,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x3446, 0x0000, 0x0000, 0x0000, 0x4ca5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4f04, 0x0000, 0x0000, 0x0aa8, 0x0407, 0x0000, 0x0000,
  0x0000, 0x0000, 0x71a8, 0x56c5, 0x00eb, 0x8aa7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x14e4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2308, 0x07c5, 0x0000, 0x0000, 0x042a, 0x0000,
  0x0000, 0x2ce4, 0x2909, 0x7a87, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4a86,
  0x0000, 0x0000, 0x0000, 0x1a65, 0x0000, 0x0000, 0x2a0d, 0x1226,
  0x0000, 0x8d46, 0x0000, 0x6d27, 0x0000, 0x0000, 0x6908, 0x20e4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7284, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x136f, 0x0000, 0x0000, 0x0000,
  0x19e8, 0x4ae4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa987,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4a24,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xae06, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0fd3, 0x0000, 0x0000, 0x0000, 0x0000, 0x9366,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1444, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5fa6, 0x0000, 0x1765, 0x0000, 0xa0c7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4f66, 0x0000, 0x0000, 0x6f48, 0x1ae4, 0x0000, 0x0000,
  0x0000, 0x91a6, 0x0000, 0x0000, 0x0c2d, 0x5987, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5228, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2566, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x10ce, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x524c, 0x8746,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xfa47, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x682b, 0x0384, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xcec6, 0x0000, 0x0000, 0x426a, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4f46, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6aa5,
  0x47ab, 0x1f26, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x41ea, 0x0000, 0x0000, 0x0000, 0x0000, 0xb166,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0288, 0x0627,
  0x0000, 0x0000, 0x0000, 0x6b45, 0x0000, 0x0000, 0x0000, 0x5b05,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3e28, 0x41a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x07c9, 0x2186, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x9626, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3dea, 0x1827, 0x0000, 0x0000, 0x0000, 0x0000, 0x0d4a, 0x0000,
  0x0000, 0x6b66, 0x0000, 0x0000, 0x02ed, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x65a9, 0x73a6, 0x0000, 0x0000,
  0x1be8, 0x4ca6, 0x7728, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5344, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x53c4, 0x0000, 0x0000,
  0x0509, 0x1b07, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x206b, 0x0000, 0x0000, 0x0000, 0x26c9, 0x8b47, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07e8, 0x2504,
  0x0000, 0x0000, 0x178c, 0x1164, 0x0000, 0x63a4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc486, 0x0000, 0x0000,
  0x0000, 0x0000, 0x04f5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc746,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5d64,
  0x0000, 0x1d05, 0x0000, 0x0000, 0x6ee9, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4128, 0x01c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ca6,
  0x0000, 0x0000, 0x0000, 0x7c06, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0df0, 0x0000, 0x0000, 0x3524,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x62a7, 0x0000, 0x0000,
  0x0000, 0xc726, 0x0000, 0xdd06, 0x0000, 0x0000, 0x1d2b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x75e5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7764, 0x1c28, 0x1ea5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1e2e, 0x0000, 0x0000, 0x0000,
  0x0000, 0xf2e6, 0x0000, 0x0000, 0x0000, 0xa086, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x58a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4548, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc386, 0x0000, 0x0000,
  0x0000, 0x3764, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x230e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5b24, 0x0000, 0x0000, 0x0000, 0x2b84, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ec6, 0x6a09, 0x2544,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x67a9, 0xb1c6,
  0x17ae, 0x1485, 0x0000, 0x0000, 0x4f09, 0x6587, 0x0000, 0x0000,
  0x458b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4c69, 0x1584,
  0x424b, 0x6985, 0x1d0d, 0x7b06, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x20e9, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4325,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6b64, 0x0000, 0x0000,
  0x6949, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xa167, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb946,
  0x4709, 0x1cc5, 0x0000, 0x0000, 0x0000, 0x20c6, 0x03ee, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5e24, 0x44a9, 0x0004, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5705, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6844, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6064,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7325, 0x0000, 0x0000,
  0x0000, 0x5445, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2688, 0x3786, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5de8, 0x1686, 0x0000, 0x0000,
  0x670b, 0x16e4, 0x0000, 0x0000, 0x716b, 0x0264, 0x0000, 0x97e7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3068, 0x21e6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xcda6, 0x52a8, 0x0b86,
  0x0000, 0x3964, 0x0000, 0x0000, 0x294c, 0xc2a6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4488, 0x0246,
  0x0000, 0x0000, 0x0000, 0xd9c6, 0x0000, 0x0000, 0x0000, 0x78a5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x16c6, 0x0000, 0x0000,
  0x082a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x79a6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2907, 0x0000, 0x0000, 0x4989, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xdf46, 0x0000, 0x0000, 0x7848, 0xa606, 0x0000, 0x0000,
  0x0000, 0x2687, 0x3f8b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4988, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4cc5, 0x23e8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x244c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8e06, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6388, 0x59e7, 0x0000, 0x0000, 0x28c8, 0x1a45, 0x0000, 0x0000,
  0x0000, 0x57a4, 0x5ec9, 0x3b05, 0x0000, 0x0000, 0x0000, 0xf367,
  0x22ca, 0x86e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x32a8, 0x3044, 0x0000, 0x0000, 0x4f48, 0x05c5, 0x7828, 0x0000,
  0x6548, 0x4184, 0x0000, 0x0000, 0x1dca, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4285, 0x0000, 0x7ca5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa2a6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xa246, 0x0000, 0x61c5, 0x0000, 0x0000,
  0x0000, 0x2644, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x56ab, 0xe3e7, 0x0000, 0x0000,
  0x0000, 0x5ee7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf187,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x314a, 0x09c4,
  0x0000, 0x0000, 0x0000, 0xf587, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4124,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3509, 0x1ae6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x53e8, 0x2905, 0x0000, 0x4224,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5986, 0x0000, 0xbca6,
  0x2c49, 0x0866, 0x0000, 0x0000, 0x0000, 0x0000, 0x0769, 0x11a6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x61e8, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7766,
  0x0000, 0x0000, 0x0000, 0x0000, 0x05cb, 0x35c7, 0x3449, 0x4b45,
  0x54a8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa9a6, 0x06b0, 0x0000,
  0x0000, 0x0000, 0x0000, 0x49c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2927, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3aa4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x398e, 0x0000, 0x0000, 0xd9e6,
  0x0000, 0x0000, 0x2f08, 0x7bc4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xc866, 0x0000, 0x0000, 0x1f4c, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x50c8, 0x1b45, 0x0000, 0xbd07, 0x000b, 0x0000,
  0x0000, 0x4765, 0x0000, 0x38e4, 0x0000, 0x0000, 0x0000, 0x7e86,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4aa9, 0x1426, 0x0000, 0x2ba4,
  0x0000, 0x4186, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5de9, 0x3606,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x28aa, 0x1be5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x46c4, 0x0000, 0x0000,
  0x0000, 0x0764, 0x3c2b, 0x3686, 0x0000, 0x0604, 0x3928, 0x4c45,
  0x5e89, 0x60a4, 0x0000, 0x0000, 0x0000, 0x5e65, 0x0000, 0x9827,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x18a4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4408, 0x2c84, 0x0d6e, 0x2065,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7de4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x01cf, 0x0000, 0x0000, 0xc586, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5424, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xe666, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x14a4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6529, 0x6ea6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3e49, 0x0000, 0x0000, 0x0000,
  0x264c, 0x0125, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x36a4, 0x5a2a, 0x1245, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1626,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xac26,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1905, 0x0000, 0x77e4,
  0x0000, 0x0000, 0x0000, 0xf106, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xb366, 0x0000, 0x3c26, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x098a, 0x0a84, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7ee5, 0x0000, 0x0000, 0x0000, 0x2764,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ee9, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5906,
  0x0000, 0x0000, 0x0000, 0xd746, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1bc8, 0x0000, 0x74c8, 0x7b44, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9f27,
  0x434a, 0x5847, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0b8b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0506, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x35e7, 0x0c2a, 0x34e6, 0x5308, 0x1da7,
  0x0000, 0x0000, 0x0000, 0x2107, 0x0000, 0x0000, 0x1aa8, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x38e9, 0x0000,
  0x0000, 0x0000, 0x7148, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4e0b, 0x0000, 0x47c8, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2c44, 0x0000, 0x0000, 0x0000, 0xc2c7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x088f, 0x1d67, 0x72a8, 0x75c4,
  0x0000, 0x0000, 0x0000, 0x77a7, 0x0000, 0x67c5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x02f2, 0x0000, 0x0000, 0x3e05, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4466, 0x1de9, 0x6c04,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5147, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0a09, 0x8687, 0x0000, 0x0000, 0x452c, 0x0000,
  0x0000, 0x0000, 0x3beb, 0x2247, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e24,
  0x0000, 0x0000, 0x3a29, 0x20a7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x01a8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x62e6,
  0x1f48, 0x5047, 0x0000, 0x0000, 0x0000, 0xb2a7, 0x6eaa, 0x76a4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6644, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7ac8, 0x7d84, 0x0000, 0x0000, 0x0000, 0x0000,
  0x442a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7666,
  0x0000, 0x9486, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7104,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xab86, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x56a4, 0x2f2b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x56e7, 0x0000, 0x0000, 0x592a, 0x3047, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0568, 0x00e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x350d, 0x6fa7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7108, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4509, 0x2846,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0a68, 0xe206, 0x062c, 0x0000, 0x0000, 0x0000, 0x0000, 0xe506,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x34a7, 0x0000, 0x0000, 0x3749, 0x33e6, 0x0000, 0x0000,
  0x242b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x33ea, 0x0dc4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x19a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x400b, 0xc067,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa786, 0x0000, 0x2364,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x44ac, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xd706, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x27e5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0e14, 0x9387, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x78e6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf287,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5be8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3cc9, 0x1085, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x04ca, 0x68c4, 0x0000, 0x0000, 0x0000, 0x2f65, 0x1b48, 0x0105,
  0x528a, 0x7f24, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0ded, 0x3066, 0x50e9, 0x1c06, 0x0000, 0x0000, 0x3fc9, 0x62c7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x394e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7746,
  0x0000, 0x0000, 0x0000, 0x3147, 0x0000, 0xaae6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6e44, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb027, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x04c8, 0x0f87,
  0x65e8, 0x20a5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5a8c, 0x4e84, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6488, 0x2147, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1a07, 0x0000, 0x09e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5ca8, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x58c4,
  0x0000, 0xbac6, 0x66a9, 0x6a46, 0x0000, 0x0000, 0x10ec, 0x3a64,
  0x0000, 0x0000, 0x1648, 0x0c86, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3c24, 0x0000, 0x0000, 0x0000, 0xac46, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x62e5, 0x0428, 0x55c7, 0x6b29, 0x0000,
  0x3a68, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x37e4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x58ca, 0x1004, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4968, 0x0000, 0x0000, 0x0000, 0x568a, 0x3566, 0x0000, 0x1864,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc146,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5586, 0x0000, 0x0000, 0x2b28, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2da5, 0x0000, 0xd266,
  0x0000, 0x0000, 0x3b0a, 0x0000, 0x362e, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0397, 0x0000, 0x0000, 0x0000,
  0x7cac, 0x0000, 0x4848, 0x0065, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ca5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0cc8, 0x0000, 0x0000, 0x0000, 0x0000, 0x6c46,
  0x7fc8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x06f6, 0x0000, 0x0e68, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5226, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1cc4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xd806, 0x0352, 0x3c84, 0x0000, 0x0000, 0x0000, 0x1727,
  0x4d4a, 0x3426, 0x0000, 0x6466, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9dc6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4f24, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x3be7, 0x20ca, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x67c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1569, 0x08c5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1b2f, 0x0000, 0x5008, 0x02e4, 0x0000, 0x0000,
  0x2d0d, 0xc647, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5187,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5fc7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2548, 0x5c27, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x51e9, 0x1bc5,
  0x7149, 0x0000, 0x0000, 0x7ea6, 0x7be8, 0xf486, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3eea, 0x0000, 0x0000, 0x0000, 0x72a9, 0x1345,
  0x0000, 0x0000, 0x0000, 0x5985, 0x0000, 0x6987, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4da8, 0x0b64, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5d89, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0cee, 0x0000, 0x13cc, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4807, 0x0000, 0x0000,
  0x0000, 0x6065, 0x0000, 0x0000, 0x0000, 0x2965, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4f0c, 0x0000, 0x0000, 0x0000, 0x40c8, 0x0d65,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6a69, 0x0000, 0x0000, 0x0000, 0x0000, 0x3f04, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3108, 0x6e65, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7345, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0b69, 0x7c25, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1908, 0x1064, 0x0158, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2da9, 0xb327, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4888, 0x0ce5, 0x0000, 0x0000, 0x63c8, 0x71e4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x04ec, 0x39a5, 0x0000, 0x6aa6, 0x0000, 0x0000, 0x21ea, 0x10e5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2a4e, 0x0000, 0x0000, 0x2584,
  0x3ac9, 0x3465, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6889, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf226,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3124, 0x0000, 0x0000,
  0x2ca8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x57eb, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3065, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0968, 0x00c4, 0x48a9, 0xa8e7,
  0x0000, 0x25e4, 0x0000, 0x0000, 0x608a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5da4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x8526, 0x0000, 0x0000, 0x59ab, 0x0d44,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6f45, 0x35ee, 0x4e46,
  0x0000, 0x0000, 0x0000, 0x0000, 0x584a, 0x0000, 0x0000, 0x0000,
  0x066d, 0x5744, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6786, 0x0000, 0x0000,
  0x022a, 0x0000, 0x0000, 0x0000, 0x0000, 0xf127, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5625,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0373, 0x6ce7,
  0x3e4c, 0x0000, 0x3948, 0x7b45, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x366a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x78ca, 0x0000, 0x1029, 0xcd87, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7ca7, 0x3ec8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x66e4,
  0x0000, 0xf0e7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c49, 0x5f44,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0118, 0x0000, 0x140b, 0x82c7,
  0x0000, 0x3d87, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1028, 0x05a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2c28, 0x45c7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6225,
  0x0000, 0x0000, 0x0000, 0x8f26, 0x0a28, 0x0000, 0x0000, 0x0000,
  0x5f4b, 0x2c25, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xfd06,
  0x0000, 0x0000, 0x0000, 0x4c64, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0410, 0x0326, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xfb66, 0x0000, 0x0000, 0x22a8, 0x0084,
  0x0000, 0x0000, 0x39ab, 0x5f87, 0x0000, 0x0000, 0x0000, 0xb526,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb4a6,
  0x0000, 0x0000, 0x0000, 0x9206, 0x0000, 0x0000, 0x0000, 0x1d26,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1fe6, 0x0000, 0x0000, 0x1b09, 0x0000, 0x0000, 0x0000,
  0x16e9, 0x0000, 0x0000, 0x0000, 0x778b, 0x0000, 0x0000, 0x0000,
  0x5a6a, 0x4304, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x23a7,
  0x0000, 0x0000, 0x0000, 0x4607, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5644, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9bc7,
  0x0000, 0x0000, 0x13b2, 0x0000, 0x4aea, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3d6c, 0xe8c7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x380a, 0x0000, 0x0000, 0x0000, 0x0000, 0x17c4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7d25, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x37c5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xa426, 0x0000, 0x0000, 0x68a9, 0x4f86, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x22cb, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6c84,
  0x0000, 0x0000, 0x0000, 0x0000, 0x7e4a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x99e7, 0x0000, 0x2604, 0x0000, 0x3f47,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0356, 0x0000,
  0x0408, 0x06a6, 0x634a, 0x6964, 0x580b, 0x0000, 0x23ad, 0x0e45,
  0x3ca8, 0x4d66, 0x1229, 0x0000, 0x0268, 0xfe67, 0x0000, 0x0000,
  0x0000, 0xf1a7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xd807, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5d48, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7c68, 0x7b64, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc1c6,
  0x0000, 0x6d46, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7f44,
  0x0000, 0x0000, 0x0000, 0x65c4, 0x0fcb, 0x0000, 0x0000, 0x9e06,
  0x0000, 0x0000, 0x65c8, 0x7765, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7aa6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x6f88, 0x0705, 0x0000, 0x0000,
  0x0c94, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x008a, 0x0000, 0x0000, 0x0000, 0x0000, 0x5c45,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5ec5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x8b07, 0x0000, 0x0000, 0x290b, 0x0000,
  0x0000, 0x0000, 0x10a9, 0x0000, 0x188d, 0x1507, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x9006, 0x0000, 0x9ba7, 0x0000, 0x0000,
  0x4348, 0x0dc5, 0x6cea, 0xe306, 0x0000, 0x0000, 0x33a8, 0x10a6,
  0x0000, 0x0000, 0x0000, 0x7a46, 0x0000, 0x0000, 0x5428, 0x0ba6,
  0x2e69, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x41c5,
  0x0329, 0x0000, 0x5e4c, 0x29e4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x16cb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x04e8, 0x4b25, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x16a4, 0x2e48, 0x0000,
  0x0000, 0xce86, 0x2cc8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x160d, 0x0c24, 0x0000, 0x4326,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ce6, 0x6188, 0x2ee6,
  0x7d68, 0x7006, 0x0000, 0x0000, 0x0000, 0xb4e7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5d0c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fd2, 0x0000,
  0x052b, 0x6284, 0x0000, 0x0000, 0x0000, 0x4ea5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x24a5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3484, 0x67cc, 0x8dc6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x43cc, 0xc447, 0x74a8, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2ea8, 0xab66,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0faa, 0x28a4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x286a, 0x0000, 0x0000, 0xc166,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x59c4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x7669, 0xed06, 0x4ea9, 0x0f85,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3408, 0x0966,
  0x0a69, 0x11a5, 0x0000, 0x0000, 0x0000, 0x42a7, 0x0000, 0x0000,
  0x00d5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4345,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2a44, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6feb, 0x0006, 0x0000, 0x0000, 0x238a, 0x1ba4, 0x0000, 0x7ba5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6a07, 0x0000, 0x0000, 0x3f6a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1784, 0x7beb, 0x6e85,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0790, 0x77e7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xcea6, 0x0000, 0x0000, 0x7348, 0xf8a6,
  0x0000, 0x4fc4, 0x0000, 0x0000, 0x3e8a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x14cc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3447, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5f08, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9fa6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6048, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1e6a, 0x0b24, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xae86, 0x0000, 0x4605,
  0x0000, 0x0000, 0x0069, 0xcf46, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x494a, 0x0000, 0x0000, 0x9ee7,
  0x0000, 0x0000, 0x0000, 0x14c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4fa6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf366, 0x2668, 0x37a7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0728, 0x17a4, 0x0000, 0x0000, 0x2e6a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4504, 0x0000, 0x6e66, 0x0000, 0x7366, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6d67, 0x0000, 0x0000, 0x0000, 0xdf87, 0x0631, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x52aa, 0x0000, 0x0000, 0xf327, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6346, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x8de6, 0x0000, 0x0000, 0x0000, 0x6204,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0a85,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3345,
  0x0000, 0x7a04, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x57e6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1748, 0x2845,
  0x0000, 0x0000, 0x0000, 0x1c65, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4609, 0x0000, 0x3cc8, 0xae67, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3a47, 0x0000, 0x0000, 0x0000, 0x0000, 0x506a, 0x14e6,
  0x0000, 0x0000, 0x0000, 0xb286, 0x0000, 0x3385, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8bc6,
  0x4648, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2789, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xdd66, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x94c7, 0x1089, 0x0000, 0x084f, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x27a4, 0x0000, 0x0000, 0x0000, 0x07e5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb866, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2404, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0b28, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x9926, 0x0000, 0x94a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb786, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5626, 0x0f0a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0037, 0x0000, 0x292e, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1c47, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xe7e7, 0x0000, 0x0000, 0x39a9, 0x0000, 0x0000, 0x0000,
  0x0000, 0xa847, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0aa6,
  0x0000, 0x0000, 0x256e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9266, 0x0000, 0x0000,
  0x0000, 0x7a84, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x37c8, 0x22e5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x24a4, 0x0000, 0x0000, 0x0000, 0x0000, 0x4209, 0x0225,
  0x0000, 0x0000, 0x0000, 0x0000, 0x00b6, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0616, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4b2a, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6165, 0x0000, 0x1884,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa546, 0x5c2b, 0x5e04,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3387,
  0x4588, 0x1c64, 0x0000, 0x0000, 0x0848, 0xb7c7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6d24,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6866, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1728, 0x04c6, 0x7b4a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08a8, 0x13e4,
  0x22c8, 0x71e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5da8, 0x12e4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7baa, 0x0000, 0x0000, 0x7bc5, 0x0000, 0x0000, 0x0b49, 0x1845,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3525, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x60c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x50cc, 0x6764,
  0x5e0b, 0x0000, 0x0000, 0x0000, 0x52c9, 0x0000, 0x1ae8, 0x0905,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0bea, 0x1de6,
  0x0000, 0x0000, 0x0000, 0x35e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x000f, 0x6d45, 0x0000, 0x0000, 0x4389, 0x0826, 0x0000, 0x0000,
  0x0000, 0xa8c6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5545, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6524, 0x0000, 0x5704,
  0x0000, 0x8646, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ac4, 0x0000, 0x0000,
  0x6448, 0x0000, 0x0000, 0x0000, 0x0713, 0xa726, 0x0000, 0x7944,
  0x0000, 0x0000, 0x7588, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1f09, 0x0000, 0x0000, 0xf3e6, 0x0000, 0x0000, 0x052d, 0x0000,
  0x016c, 0x0ec6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1f6a, 0x4ce7, 0x0000, 0x0000, 0x0000, 0x8287,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1c25, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2e44, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6068, 0xcfc6, 0x1a2a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7446, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa0c6, 0x0000, 0x5ee6,
  0x0000, 0x0f04, 0x3029, 0x0000, 0x0000, 0x0000, 0x35aa, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6685,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x18ea, 0x0000,
  0x0157, 0x12e6, 0x0000, 0x0000, 0x0000, 0x5f26, 0x2da8, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x05d1, 0x87c7, 0x0000, 0x0000, 0x0000, 0x0000, 0x016b, 0x7f86,
  0x3b0e, 0x0564, 0x0000, 0x0000, 0x7309, 0x5aa6, 0x0000, 0x0000,
  0x0000, 0x6f05, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x58e4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3709, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7249, 0xef26, 0x0000, 0x77c5, 0x0000, 0x6ea7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x69e4, 0x228b, 0x0000, 0x27a8, 0x0824,
  0x0000, 0x0000, 0x0000, 0x20a4, 0x0000, 0xbd47, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4069, 0x2464, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x234b, 0x49a4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1044, 0x0000, 0x0000, 0x39eb, 0x0545, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x10c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5505, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x74e8, 0xf9a6,
  0x0000, 0x0000, 0x0000, 0x6544, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xadc7, 0x0000, 0x0000,
  0x0000, 0x5084, 0x0000, 0x0000, 0x6c6a, 0x7ac4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4387, 0x0000, 0x0f67,
  0x0000, 0x0000, 0x0000, 0xf746, 0x0000, 0x0000, 0x0000, 0x0000,
  0x62a8, 0x4de6, 0x0000, 0x7184, 0x0000, 0x9886, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2aa4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6f06, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2568, 0xf967,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2fa8, 0x1dc4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x35e9, 0x0f24,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xaba6, 0x4469, 0x0a06, 0x188c, 0x0000,
  0x0000, 0x7364, 0x0000, 0x0000, 0x0000, 0x50c6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xc966, 0x0000, 0x0000, 0x0000, 0x0000,
  0x73cb, 0x0000, 0x0000, 0x0000, 0x5248, 0x4a64, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x37c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3d46,
  0x0000, 0x0000, 0x0000, 0x3d66, 0x0000, 0xc606, 0x0000, 0x0000,
  0x3f68, 0x1f47, 0x0000, 0x0000, 0x0000, 0x13c4, 0x1a28, 0x1184,
  0x0033, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3309, 0x1c86, 0x6b8a, 0x2ea4, 0x0000, 0x6166,
  0x0000, 0x0000, 0x0000, 0x45a4, 0x0000, 0x0000, 0x11c8, 0x4484,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xba46, 0x0a6f, 0x4885, 0x278a, 0x8426,
  0x0000, 0x0000, 0x3268, 0x1524, 0x256b, 0xc147, 0x0000, 0x1624,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3365, 0x0000, 0x0000, 0x0000, 0x0000, 0x5aea, 0x36e7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1a05, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x34cb, 0x0000, 0x4d49, 0x0000,
  0x0000, 0x0000, 0x3f2e, 0xf406, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e45,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7725,
  0x0000, 0x0000, 0x0000, 0x0000, 0x644b, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2445,
  0x0000, 0x0000, 0x2e09, 0x2f84, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e04,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8086, 0x0000, 0x0000,
  0x114a, 0x0000, 0x0000, 0x0000, 0x0000, 0x5aa5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x6d88, 0x7a64, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2e68, 0x04c4, 0x0000, 0x0000, 0x0000, 0xa207,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5a65,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9606, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7b46, 0x250c, 0x0da5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5286, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7628, 0x1b05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x8846, 0x0a29, 0x0000, 0x0000, 0x0000,
  0x0000, 0x30e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x1f28, 0x2847,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb086,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x41ca, 0x4f05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1d68, 0x1206, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7586, 0x0000, 0x0000, 0x0000, 0x2d44, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x26a8, 0x1885, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xef07, 0x0000, 0xa147, 0x0000, 0x55c4,
  0x0000, 0x0000, 0x5848, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x338b, 0x0000,
  0x0000, 0x0000, 0x0000, 0x03c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x016d, 0x78e7, 0x5ecc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x1b84, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x6d28, 0x76c4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xc566, 0x0000, 0x0000, 0x004d, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xddc7,
  0x312a, 0x20e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6649, 0x3907, 0x0000, 0x0000, 0x1f68, 0x1646, 0x3129, 0x0c25,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5446, 0x1beb, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x13f2, 0xcce6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x50e8, 0x74c7, 0x0000, 0x17e4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2b49, 0x14a5, 0x0000, 0x6da5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xa227, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x148e, 0x0000, 0x0000, 0x0000, 0x3dac, 0x0725, 0x1e28, 0x3965,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1c88, 0x2886, 0x03d5, 0x0000, 0x0000, 0x71c7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5bc9, 0x5827,
  0x1b28, 0x0924, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4f88, 0x30a5, 0x0000, 0xb026, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6fa6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x02a8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5a2c, 0x0000,
  0x0000, 0x0000, 0x77e8, 0x0000, 0x0000, 0x0000, 0x0000, 0xb326,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2328, 0x17a5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x02c8, 0x0046, 0x0000, 0x0000, 0x334a, 0x2c47, 0x0000, 0x0000,
  0x0000, 0x0000, 0x352c, 0x0000, 0x3368, 0x0786, 0x01cd, 0xc967,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb8c6, 0x4a8b, 0x0000,
  0x0000, 0x19c5, 0x0000, 0x0647, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4daa, 0x40a6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4a04, 0x1bea, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ea8, 0x0807,
  0x0000, 0x0000, 0x0000, 0x0000, 0x22ce, 0x0000, 0x4b88, 0x0000,
  0x0000, 0xbbc6, 0x212a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x26cc, 0xdc67, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1025, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa986,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3f2d, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7d0b, 0x0000, 0x0000, 0x78c6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x68e6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4fa5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x49c9, 0x0000, 0x0000, 0x0000, 0x0000, 0x2305, 0x0000, 0x0000,
  0x0000, 0xad46, 0x0000, 0x0000, 0x0000, 0x2325, 0x0000, 0x8507,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x72a6, 0x0000, 0x0000,
  0x1809, 0x4567, 0x0000, 0x0000, 0x7629, 0xeb46, 0x0000, 0x0000,
  0x0000, 0x78a6, 0x0000, 0x0000, 0x3d28, 0x0427, 0x0000, 0x0000,
  0x0000, 0x7524, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6da4,
  0x0000, 0x56a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2da4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x60cb, 0x00e5, 0x0000, 0x5bc4,
  0x0000, 0x0000, 0x1da8, 0x2d05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x66c9, 0x5c86, 0x0000, 0x0000,
  0x7428, 0xb9a7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6a84, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0229, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7d26, 0x0000, 0x0000, 0x0000, 0x0000, 0x046f, 0x67e4,
  0x0000, 0x0000, 0x300c, 0x22a4, 0x0000, 0x0000, 0x0000, 0xa8e6,
  0x0000, 0x0367, 0x0000, 0x0000, 0x7b08, 0x0000, 0x2109, 0x4505,
  0x0000, 0x3224, 0x0000, 0x0000, 0x0000, 0x58c6, 0x0000, 0x9766,
  0x0000, 0x0000, 0x40e8, 0x19a4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0529, 0x4867, 0x0000, 0x59a4, 0x0000, 0x0000, 0x7e68, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x64a4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3d24, 0x0000, 0x0000, 0x0000, 0x8006, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6f87,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3b29, 0x0000, 0x0000, 0x0000,
  0x526c, 0x6c06, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0349, 0x6667, 0x0000, 0x0667, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1049, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1ca8, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5444, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6044, 0x068b, 0x09e5, 0x0000, 0x0000,
  0x0000, 0xd046, 0x0000, 0x3326, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x62a5, 0x0000, 0x1f64, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6f25, 0x15c8, 0x1404, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6d06, 0x0000, 0x72c6, 0x4728, 0x2187, 0x0000, 0x0000,
  0x0000, 0x9906, 0x0000, 0xaa26, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2ec5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5b65, 0x0000, 0x0000, 0x0000, 0x0000,
  0x17cb, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x194a, 0x4e44, 0x3789, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6868, 0x0000, 0x0237, 0xbec7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3ba7, 0x0000, 0x0000, 0x7c4a, 0xabc6, 0x0992, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2c68, 0x23e7,
  0x0000, 0xada6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x38e8, 0x3005, 0x0000, 0x0000, 0x0000, 0x2105, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7d28, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4f25,
  0x0000, 0x0000, 0x0000, 0x6a64, 0x1e68, 0x2ce7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x23ea, 0x0d24,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6b26, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6669, 0xaf46, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x15cd, 0x1c05, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5ec4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x51e8, 0x47a4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x100b, 0x2be7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x72c5, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x55e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xbea6, 0x0000, 0x0000, 0x0000, 0x7e24,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2a84,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x69e8, 0x0000, 0x160b, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c11, 0x7b25,
  0x0000, 0x4ce4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xefe7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8d66,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ee4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0368, 0x1704, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x04cd, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7ee4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8806, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc626,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1c6a, 0x0000, 0x0000, 0x0000,
  0x3bc8, 0x2d06, 0x0000, 0x0000, 0x0000, 0x0be7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5768, 0x0000, 0x0000, 0x0000,
  0x034e, 0x0000, 0x0000, 0x0000, 0x0000, 0x48a6, 0x0000, 0x0000,
  0x0000, 0x5c64, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5ca9, 0x0864, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3a08, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x054e, 0x0000, 0x0c0a, 0x0000, 0x0000, 0x0000, 0x6ca8, 0x4004,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1968, 0x0000,
  0x0000, 0x3824, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2009, 0x2c64, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5eca, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6765, 0x0000, 0x0000,
  0x0000, 0x0000, 0x48ac, 0x0805, 0x0000, 0x3744, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7a25, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xabe6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1fc4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2f0c, 0x2264,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x76e6, 0x0000, 0xbe06,
  0x0000, 0xdb26, 0x2b88, 0x2e26, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x21a4, 0x2468, 0x3c05, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x01f4, 0x0000, 0x0000, 0x0000, 0x0000, 0xa7a6, 0x0000, 0x7f26,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6ec8, 0xe246, 0x42a8, 0x0000, 0x0000, 0xb5a6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6888, 0x1a64, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0270, 0x0000, 0x1388, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7e25, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6686, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2b68, 0x1c85, 0x0000, 0x0000, 0x0000, 0x8d67,
  0x0000, 0x9f86, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6a2a, 0xe006,
  0x0000, 0x0000, 0x30a9, 0x2465, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x41aa, 0x0000,
  0x0000, 0x0000, 0x38ae, 0x0000, 0x0000, 0x0000, 0x0000, 0x5347,
  0x0000, 0x0000, 0x0000, 0x34c4, 0x72c9, 0x2c65, 0x0000, 0x0000,
  0x0000, 0x0000, 0x14ab, 0x0000, 0x2089, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6c25, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7245, 0x0000, 0x0000,
  0x0000, 0x1d45, 0x0000, 0xace7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2648, 0x0000, 0x0000, 0x0000,
  0x7369, 0xefe6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x146d, 0x0000, 0x0000, 0x0000, 0x0000, 0xa407, 0x65c9, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x5865, 0x0000, 0x0000, 0x0000, 0xbaa7, 0x016a, 0x34a6,
  0x5bac, 0x0000, 0x0000, 0x0000, 0x2aa9, 0x0000, 0x0000, 0x0000,
  0x0c4e, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x7ec8, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x11cf, 0x0cc6, 0x0000, 0x0000,
  0x03d7, 0x0000, 0x0000, 0x66e7, 0x0000, 0x82a6, 0x0000, 0x0000,
  0x0000, 0xf147, 0x0000, 0xbd06, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0ae6, 0x0000, 0x9b66, 0x1ea9, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0608, 0x0887,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0fc8, 0x0b04, 0x4e29, 0x7544, 0x0000, 0x0000, 0x2bea, 0x0000,
  0x0000, 0x0000, 0x0ea8, 0xd086, 0x0000, 0x5867, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3265, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00e9, 0x0000,
  0x0000, 0x2346, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0109, 0x0584, 0x0000, 0x0000, 0x1689, 0x2b44, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4429, 0x5f27, 0x0000, 0x0000, 0x6869, 0x5e06,
  0x0000, 0x0000, 0x0000, 0x0000, 0x7448, 0xf206, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x51ac, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x2b08, 0x0000, 0x0000, 0xb966,
  0x6d69, 0x1726, 0x0000, 0x0000, 0x3868, 0x0ba7, 0x5e28, 0x28e4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7f85, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ce4, 0x0000, 0x0000,
  0x0000, 0x3e64, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x19ea, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0c04,
  0x0000, 0x7907, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7248, 0x0000, 0x0000, 0x0000, 0x0000, 0x31e7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1c09, 0x4666, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5806, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc2e6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x6ba8, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7646, 0x29ac, 0x5d45, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x71c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4f06, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xae26, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xbd46, 0x0000, 0x0000,
  0x0000, 0x0000, 0x192a, 0x0000, 0x3fca, 0xaca6, 0x0000, 0x0000,
  0x4208, 0x0000, 0x0000, 0x0000, 0x0000, 0x0284, 0x0000, 0x0000,
  0x0000, 0x9c66, 0x0000, 0x0000, 0x0000, 0x9166, 0x0000, 0x0000,
  0x0000, 0x2666, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8867,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0344, 0x0000, 0x0000, 0x0000, 0x6e24,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4da4, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x43c5, 0x0000, 0x2b86,
  0x0000, 0x6c85, 0x0000, 0x0000, 0x0000, 0x0000, 0x3628, 0x0000,
  0x0000, 0x0000, 0x606a, 0xbae7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1aea, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0f8d, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x06ec, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0e13, 0x07c7, 0x0000, 0x6b04, 0x21cc, 0x0000,
  0x4788, 0x0000, 0x0000, 0x0000, 0x0000, 0x7566, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2c06, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x50e4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0152, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1b8a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3a0e, 0x0000, 0x0000, 0x0da4, 0x0000, 0x0000,
  0x0000, 0xda46, 0x0000, 0x0000, 0x0000, 0x4066, 0x0000, 0x0000,
  0x0000, 0x46c7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x086a, 0x0504, 0x0000, 0x0000, 0x25a8, 0x6424, 0x0000, 0x0000,
  0x736b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8f27,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4707, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1ee9, 0x0000, 0x0000, 0x0000, 0x0000, 0x50a4,
  0x0000, 0x0000, 0x290c, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xaa66,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa006, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x280a, 0x0385, 0x2d09, 0x45c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5f86,
  0x0000, 0x0000, 0x6829, 0x6bc6, 0x0000, 0x6b05, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5c0a, 0x0b85, 0x0000, 0x0000,
  0x7388, 0xf0e6, 0x0000, 0xb8e6, 0x2d08, 0x49c5, 0x0000, 0x0000,
  0x0000, 0xbe26, 0x0000, 0x0000, 0x0000, 0x58a6, 0x0000, 0x0000,
  0x3bad, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3c69, 0x0000, 0x0000, 0x0000, 0x0000, 0x97a6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3ee8, 0x7fc4, 0x0000, 0xd607,
  0x0000, 0x3a46, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5b64,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3c8a, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1e2a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x7888, 0xfaa6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x8986, 0x0000, 0x0000,
  0x0000, 0x7747, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xf4c7, 0x0000, 0x0000, 0x0448, 0x44a6,
  0x770a, 0x0000, 0x0000, 0x5185, 0x0971, 0x51e4, 0x0000, 0x0000,
  0x53c8, 0x1244, 0x0000, 0x0000, 0x0000, 0x0000, 0x40c9, 0x13e6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x12ed, 0x0000, 0x0000, 0x8066, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x76c8, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7c27, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0de9, 0x3ea7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3885, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x1d28, 0x12a5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x48cc, 0x0000, 0x0000, 0x0000, 0x6428, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08c4, 0x0000, 0x0000,
  0x2e2a, 0x0000, 0x0490, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1d8a, 0x5a27, 0x35ca, 0x1e27, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xe326, 0x0210, 0x86c6, 0x7faa, 0x0000, 0x0000, 0x32c5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08a6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xe4c7, 0x0000, 0x0000, 0x0000, 0x3604,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6745, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x6609, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7d05, 0x58c8, 0x2524,
  0x0000, 0x34e7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3fc8, 0x0000, 0x0000, 0x8306, 0x0000, 0x0000,
  0x0000, 0x4d46, 0x0000, 0x0000, 0x0000, 0x4104, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7bc8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2824, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5a67, 0x0000, 0x0000, 0x7328, 0x0000,
  0x0000, 0x0000, 0x3768, 0x31a5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6b06, 0x0000, 0x0000, 0x0000, 0x1167,
  0x234d, 0x7aa5, 0x0000, 0x2405, 0x0000, 0x0000, 0x0000, 0xec47,
  0x4be8, 0x0704, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x13c9, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4d28, 0xaf66,
  0x0000, 0x96a6, 0x0000, 0x0000, 0x466b, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1e44, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2e24, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4dc6, 0x0000, 0x0000,
  0x0000, 0xafe6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4e0a, 0x1407,
  0x0000, 0x2d64, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4b29, 0x0000, 0x15cb, 0x2486,
  0x0000, 0x0000, 0x41a9, 0x1625, 0x0000, 0x0000, 0x0000, 0x55a6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x50e7, 0x0000, 0x0000,
  0x0000, 0x1424, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5a46, 0x0000, 0x0000,
  0x0000, 0xe0a6, 0x0000, 0x0000, 0x0000, 0xd287, 0x0000, 0x0000,
  0x3aa9, 0x0000, 0x4268, 0x99c7, 0x1caa, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x218c, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x34a8, 0x0d46, 0x0daa, 0x0825,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x4a68, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x2eca, 0xe507, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0d49, 0x0000, 0x32a9, 0x00c6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6e25,
  0x0000, 0x6ac6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x11c5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x476b, 0x3a45,
  0x31e9, 0x1724, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x12a8, 0x3287, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5908, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6b88, 0xe706, 0x0000, 0x0000, 0x6549, 0x4ea6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x01b8, 0x2f24, 0x0000, 0xe647,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xbba6, 0x0000, 0x0000, 0x0000, 0x1684, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x3d64, 0x1d4a, 0x1564, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4eea, 0x4944, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x7469, 0x0000, 0x154b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc666, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5fa5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3505, 0x0000, 0x0000,
  0x5948, 0x0000, 0x0000, 0x0000, 0x0000, 0x55a7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3489, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x35a4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5e08, 0x0247,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0e8e, 0x06a4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x47e8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5464, 0x0000, 0x0000, 0x0000, 0xb206,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x50e6, 0x0000, 0x0000,
  0x0000, 0xa6c6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3a88, 0x1a26, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2ac4, 0x0000, 0x0000, 0x0000, 0x7404, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xe5c7, 0x0cb0, 0x3e04, 0x51cb, 0x27c4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1ee8, 0x7267,
  0x5ec8, 0x1944, 0x0000, 0x0000, 0x402c, 0x8fc7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x62ea, 0x0000, 0x66ab, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6384, 0x71a9, 0x37a6,
  0x610a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4846, 0x0000, 0x0000, 0x0000, 0xad66, 0x0000, 0x0000,
  0x0000, 0x36c4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5fc8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x43a7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6e06, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xbc46,
  0x0000, 0x0000, 0x7aeb, 0x0000, 0x6009, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4904, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x5c2c, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x1c44, 0x03c8, 0x3545, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0eb3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2b24, 0x0000, 0x0000, 0x0000, 0x3024, 0x0000, 0x31c5,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x2b64, 0x0000, 0x0000, 0x0000, 0x0000, 0x0fa9, 0x9d67,
  0x5088, 0x1105, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3aa7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x22c4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x3624, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xb1e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5da6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4448, 0x2fa6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x22ac, 0x0000, 0x0000, 0x5826, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x38a6, 0x4308, 0x4564, 0x0000, 0x0000,
  0x7b6a, 0x8a67, 0x0000, 0x0000, 0x2e49, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6b84, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2024, 0x0000, 0xdd07,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x85e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0a66,
  0x0000, 0x6864, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xfac6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5709, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0be9, 0xd6c7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0345, 0x0000, 0x44c4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x70a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x66c8, 0x0000, 0x0000, 0x70c4, 0x0000, 0x0000, 0x0000, 0x64e6,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x20c7, 0x0000, 0x4d85,
  0x4b28, 0x0444, 0x0000, 0x0000, 0x1549, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4324, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2985, 0x0000, 0x0000, 0x7889, 0xeea6,
  0x16c8, 0x20a6, 0x0000, 0x0000, 0x0000, 0xd726, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x74a4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc926, 0x0000, 0x6fe7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6585,
  0x0000, 0x0000, 0x7429, 0xec46, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6147, 0x0000, 0x0000, 0x0000, 0x1124,
  0x0000, 0xa446, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xcfa6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xc6e6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x668b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1729, 0x0b25,
  0x0000, 0x7b66, 0x1ccc, 0x00c5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x07eb, 0x03a6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x26e4, 0x0000, 0x0000, 0x0b48, 0x1547,
  0x0000, 0xf526, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0b6b, 0x0000,
  0x022c, 0x3dc4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x21c5, 0x0000, 0x2284, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xbe66, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3d49, 0x00e4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x15e9, 0x4987, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6246,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x4887, 0x4e68, 0x0b07,
  0x37e9, 0x6d05, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x69a8, 0x5be6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x03e5, 0x2948, 0x0000, 0x398a, 0x4244, 0x4729, 0x3506,
  0x0000, 0x0000, 0x0000, 0xa2c7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4a65, 0x0000, 0x0000, 0x0000, 0x01a5,
  0x2848, 0x0c26, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x7fa7, 0x144b, 0x85e7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0e71, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xafc6, 0x0000, 0x8ae7,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0028, 0x0000, 0x0f28, 0x3d05,
  0x0000, 0x2166, 0x0000, 0x0000, 0x0000, 0xf7e6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9066, 0x0000, 0xc4e6,
  0x0000, 0xb3c6, 0x03e9, 0x0000, 0x0000, 0x2f25, 0x0cb1, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3b89, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xfce7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xe587, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0470, 0x6965, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4544, 0x0000, 0x0000, 0x0000, 0x4305, 0x09e9, 0x19e5,
  0x0000, 0xab67, 0x0000, 0x0000, 0x0000, 0x3504, 0x6228, 0x2a07,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x7004, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1be9, 0x5dc7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1dcc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x2fec, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x4b64, 0x5aaa, 0x0164, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3b84, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xc206, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5504, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0289, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb2e7, 0x0000, 0x0000,
  0x2489, 0x0e05, 0x0000, 0x0000, 0x2c8a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xf566,
  0x0000, 0x0000, 0x0000, 0x9b86, 0x198a, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6c66, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x01e8, 0x5884, 0x39e8, 0x4664, 0x0000, 0x3ec4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x142a, 0x2b66,
  0x0000, 0x0000, 0x0000, 0x0000, 0x3ac8, 0x0424, 0x0000, 0x1ec7,
  0x4768, 0x0146, 0x0000, 0x4e45, 0x4cc8, 0x0000, 0x1daa, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x030d, 0x0245, 0x0000, 0x3f46,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03d6, 0x26a4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1189, 0x0000, 0x0000, 0x0000, 0x0000, 0x8406,
  0x0000, 0x0000, 0x0000, 0xd506, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x8186, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xa466, 0x0aa9, 0x0ac5,
  0x2108, 0x4185, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0d6a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0f6a, 0x73e4, 0x0000, 0x0000, 0x1389, 0x8fa7, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6145, 0x0000, 0x3ec5, 0x1888, 0x0000,
  0x0000, 0x0000, 0x0000, 0xa406, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6ae5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x37c9, 0xaf07,
  0x0000, 0x0000, 0x0000, 0x7d64, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x8926, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x4428, 0x4c87, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x06cb, 0x0000, 0x0000, 0x0000, 0x0000, 0x1587, 0x0000, 0x0000,
  0x0000, 0x80a6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x4704, 0x0000, 0x0000, 0x0000, 0x5b84,
  0x4d2a, 0x0000, 0x0000, 0x79c6, 0x2f2a, 0x7ba7, 0x5ba8, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3584, 0x0000, 0x0000,
  0x532c, 0xfbe7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x64ca, 0x23e5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc066,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x16cd, 0xc367, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3c87, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0xcae6, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x6dc8, 0xe526, 0x0000, 0xc426,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0bac, 0x0000, 0x5968, 0x7c44, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x07e4, 0x0000, 0x49e4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x5da5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x446c, 0x2dc5, 0x0000, 0x0000, 0x0000, 0xda67, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0b27, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb6e6,
  0x0000, 0x6086, 0x6faa, 0x0000, 0x0000, 0x0000, 0x0614, 0x0000,
  0x0000, 0x6705, 0x0000, 0x0000, 0x564a, 0xc0e7, 0x1cc8, 0x3707,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0411, 0x0000, 0x2989, 0x1b04, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x7244, 0x0000, 0x0000,
  0x340a, 0x4687, 0x0000, 0x72c4, 0x0000, 0xdc86, 0x0000, 0x0000,
  0x0078, 0x0000, 0x0000, 0x0b84, 0x0000, 0x0000, 0x0000, 0x0000,
  0x3ea8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x6a6a, 0x5ce5, 0x0000, 0x0624, 0x0000, 0x6de6, 0x0000, 0x0000,
  0x05e8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6c24,
  0x0000, 0x9646, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x18a8, 0x2205, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xb5e6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x6f69, 0xeee7, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5f24, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x32e4,
  0x0000, 0x4604, 0x0000, 0x0000, 0x3d4d, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x046b, 0x3b64, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3444, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x47e4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0b90, 0x6647, 0x0000, 0x0000, 0x3328, 0x1bc6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x78e9, 0xeb06, 0x0000, 0x0000, 0x0000, 0x4f26,
  0x0000, 0xa386, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0aca, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6624, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x6e45, 0x0000, 0x0000,
  0x0000, 0x7246, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x6ea8, 0x0000, 0x0000, 0x3544,
  0x31e8, 0x0746, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4349, 0x0cc7, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x6d87, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x1169, 0x46c5, 0x0000, 0x0606,
  0x0192, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0068, 0x0e46,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x4808, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x74a5, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5686, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5e0a, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x2ee4, 0x0000, 0x7e66, 0x0000, 0x0000,
  0x0c09, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x03cc, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2a28, 0xaec6,
  0x534a, 0x0000, 0x1ec8, 0x3145, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x36a9, 0x0000, 0x0000, 0x0000,
  0x2809, 0x0000, 0x0000, 0x0000, 0x0000, 0x7d66, 0x0000, 0x6c47,
  0x0000, 0x2904, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x7d08, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5d08, 0x0ca4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5ac5,
  0x0000, 0x0000, 0x160a, 0x0000, 0x4f0a, 0x0126, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x68e4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x342b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x1ed2, 0xf166, 0x18c8, 0x0000, 0x0000, 0xdd67,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x69c6, 0x1508, 0x1744,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x6d65, 0x0000, 0x0000, 0x3ba9, 0x60a5, 0x48a8, 0x4fe4,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xda66,
  0x0000, 0x0000, 0x0000, 0x0000, 0x13cd, 0x6d26, 0x0000, 0x3284,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x30e5, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x5388, 0x6e64, 0x0000, 0x09c6, 0x4e8c, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0xb686, 0x0000, 0x7846, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x3985, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x044b, 0x18e4, 0x0000, 0x0000, 0x0000, 0x3086, 0x3b4e, 0x0000,
  0x21eb, 0x0000, 0x29a9, 0x3fe4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0636, 0x0000, 0x7b8c, 0x0000, 0x5868, 0x7545,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x5e86,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xc5e6, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x23ab, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2b07,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x406a, 0x3aa6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3289, 0x0000, 0x0000, 0x0000, 0x0000, 0x3e84,
  0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0885, 0x1b0b, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x3d08, 0x2a24, 0x0000, 0x0000, 0x2068, 0x1d87,
  0x0000, 0x0000, 0x4d09, 0x01e4, 0x0000, 0x0000, 0x0000, 0x0000,
  0x0000, 0x0000, 0x5e8c, 0xbc06, 0x0000, 0x5ea6, 0x0000, 0x9e46,
  0x0000, 0x0000, 0x0d88, 0x4ac5, 0x0000, 0x0000, 0x0000, 0x0000,
};

}  // namespace brotli

#endif  // BROTLI_ENC_DICTIONARY_HASH_H_
