/**
 * https://www.amcharts.com/svg-maps/?map=taiwan
 * map data by amcharts team
 */
'use strict';

(function() {
    var data = [{"code":"TW-LCG","name":"Lienchiang","path":"M368.13,96.5L367.26,96.77L367.14,97.52L365.19,97.09L363.28,101.53L365.09,100.55L366.44,99.9L368,98.3L368.13,96.5zM358.84,95.81L360.35,94.95L358.2,93.84L355.43,94.81L357.25,97.52L358.84,95.81zM356.34,52.71L354.61,52.09L354.37,51.47L354.41,50.4L353.58,50.52L352.76,52.12L352.37,54.28L352.98,56.17L354.96,57.5L356.27,57.29L360.57,55.04L362.81,52.54L362.76,51.07L360.61,51.09L357.15,53.1L356.34,52.71zM373.11,38.78L372.64,38.12L371.96,37.71L370.92,36.15L368.96,35.86L367.23,36.92L366.67,37.62L364.62,38.29L363.73,38.84L363.33,40.1L362.98,43.46L363.35,44.68L364.2,45.22L365.16,41.25L366.32,39.96L367.33,39.69L368.1,40L369.95,39L370.82,39.59L371.96,41.25L372.97,42.13L373.04,41.44L372.64,40.53L372.94,39.74L373.11,38.78zM471.57,0L469.82,1.43L469.1,1.86L469.5,2.95L468.65,4.3L469.57,4.81L470.07,5.1L471.02,5.27L471.27,5.67L472.12,4.03L472.66,3.31L473.22,2.98L473.67,3.17L474.11,3.29L475,2.95L474.11,2.19L473.62,1.17L471.57,0z"},{"code":"TW-KNM","name":"Kinmen","path":"M6.83,451.66L7.79,451.13L8.24,450.19L9.11,449.27L10.37,449.17L11.45,447.54L11.48,445.09L10.17,443.66L8.66,442.59L7.01,442.63L5.37,443.06L4.33,444.13L0.39,451.93L2.71,452.86L6.83,451.66zM50.07,430.63L44.5,425.54L38.64,426.74L36.81,431.02L35.99,437.89L30.5,438.56L22.62,433.39L16.68,436.32L15.48,437.02L15.67,438.68L17.03,441.95L17.6,445.35L17.68,447.29L17.53,448.9L16.99,449.89L15.28,452.06L14.96,452.65L15.87,454.28L17.73,455.1L19.85,455.24L22.94,456.71L25.58,455.36L28.63,450.58L34.23,447.04L40.58,446.4L44.56,447.69L49.9,451.05L52.91,447.42L53.74,440.54L50.07,430.63zM261.51,322.57L262.18,320.87L262.01,319.37L260.65,319.17L258.77,320.31L258.26,322.75L259.29,323.7L261.51,322.57z"},{"code":"TW-PEN","name":"Penghu","path":"M251.46,726.5L252.72,724.74L253.66,723.86L253.88,722.58L253.74,720.94L251.61,720.34L248.63,721.37L247.88,722.34L249.05,726.05L250.08,727.21L251.46,726.5zM250.57,717.1L249.14,714.67L246.62,714.27L245.68,715.14L245.88,717.1L247.47,719.01L249.22,719.53L250.57,717.1zM288.91,714.57L289.53,714.57L289.57,714.5L290.47,714.41L290,713.72L290.17,713.41L289.8,712.84L289.38,712.81L289.15,712.9L287.87,713.02L287.99,713.37L287.65,713.5L288.49,714.54L288.51,714.58L288.52,714.58L288.56,714.62L288.91,714.57zM289.83,712.67L289.9,712.52L289.68,712.11L289.53,712.67L289.83,712.67zM299.83,710.97L299.81,711.13L299.75,711.13L299.6,712.56L300.02,713.58L300.45,714.75L300.45,714.74L300.47,714.75L301.06,713.29L301.9,712.14L301.6,711.96L301.9,711.13L300.12,711.13L299.83,710.97zM298.39,710.55L297.8,711.14L297.45,711.15L297.7,711.26L297.61,711.34L298.03,711.39L298.44,711.55L298.44,711.13L298.25,711.13L298.39,710.55zM267.82,709.37L267.34,708.6L266.41,710L267.82,709.37zM231.75,698.99L231.68,698.58L231.45,698.53L231.16,698.67L231.38,699.01L231.39,699L231.5,699.12L231.75,698.99zM228.69,697.75L228.62,697.36L228.52,697.24L228.12,697.44L228.34,697.78L228.44,697.89L228.69,697.75zM231.78,697.63L231.16,697.21L231.45,698.41L231.73,698.44L231.78,697.63zM273.54,687.69L273.7,686.7L272.53,685.98L271.3,686.24L270.71,686.68L269.87,687.84L269.57,688.9L269.87,689.18L272.23,687.82L272.85,687.85L273.54,687.69zM266.93,682.46L266.48,681.98L265.97,681.86L263.84,678.98L262.55,679.26L260.95,683.24L261.4,685.05L262.97,684.58L263.66,684.1L263.86,687.38L262.73,689.82L263.96,690.36L266.45,690.6L267.59,690.15L267.22,689.35L267.15,688.63L268.04,687.71L268.56,686.5L268.02,685.97L267.4,685.52L267.02,684.3L266.93,682.46zM228.1,677.95L227.93,678.25L227.8,678.27L226.99,680.02L227.6,680.41L227.6,680.5L227.83,680.88L229.5,680.45L229.97,679.72L229.71,678.87L229.93,678.46L228.91,678.08L228.64,678.13L228.1,677.95zM274.06,658.51L273.89,658.5L273.94,658.48L271.99,658.08L270.21,658.95L270.18,658.99L269.94,659.08L269.13,659.43L268.86,659.65L267.42,659.22L267.02,659.57L266.95,659.52L267,659.6L266.88,659.69L267.15,661.11L267.89,661.22L267.91,661.21L268.11,661.54L269.91,660.61L270.98,660.22L271.52,660.17L271.77,659.94L272.07,659.85L274.06,658.51zM289.33,636.53L290.3,633.05L286.66,634.31L280.83,637.96L279.18,637.54L277.77,637.54L277.59,640.67L277.77,643.83L278.59,643.4L278.74,643.26L278.74,643.01L279.18,642.29L280.29,644.01L281.52,645.27L283.03,646.19L284.94,646.91L282.17,649.17L278.79,650.1L275.65,649.43L273.55,646.91L272.54,648.89L276.36,652.7L280.16,654.16L283.95,653.63L287.62,651.51L288.15,650.55L288.99,647.35L289.6,646.2L290.69,645.59L292.89,645.33L295.98,643.59L298.2,644.03L300.22,645.35L301.73,646.91L302.18,644.56L301.18,641.39L297.5,634.59L296.24,636.71L294.47,636.84L292.05,636.58L288.89,637.54L289.33,636.53zM257.98,643.83L258.93,643.04L259.94,642.57L261.15,642.35L262.87,642.29L265.24,641.9L265.47,640.84L264.93,639.33L265.03,637.54L267.2,630.91L268.56,628.08L270.53,626.9L267.22,624.02L264.76,626.44L262.21,634.59L262.16,638.34L261.67,639.94L259.96,640.6L257.98,640.75L256.51,641.2L255.56,642.19L255.05,643.83L257.98,643.83zM284.52,629.8L285.67,627.98L284.89,625.23L286.81,623.37L285.75,621.06L283.23,618.9L280.66,617.53L276.29,620.74L279.7,624.14L281.26,626.42L281.94,629.14L282.81,630.3L284.52,629.8zM286.62,605.89L288.15,604.01L289.92,603.01L290.24,601.6L288.25,600.48L288.19,600.2L287.87,599.68L287.4,600.38L286.56,602.04L285.21,603.14L285.57,603.91L285.36,604.26L286.24,606.35L286.29,606.3L286.37,606.64L286.62,605.89z"},{"code":"TW-TTT","name":"Taitung","labelCoordinate":{"x":0.4,"y":0.3},"path":"M701.71,1004.06L700.79,1003.28L700.15,1004.37L701.06,1005.14L701.71,1004.06zM697.98,990.66L698.24,988.51L696.62,986.57L692.99,983.8L692.29,981.82L692.56,979.56L693.23,977.67L693.63,976.81L693.63,975.44L678.24,975.44L679.64,977.09L680.43,978.92L680.46,980.92L679.54,983.04L682.61,985.93L687.92,989.69L693.7,992.01L697.98,990.66zM679.13,851.24L678.85,849.96L679.13,848.65L679.84,847.39L680.46,844.3L679.89,842.79L679.01,842.28L671.12,842.86L670.68,843.33L671.77,846.65L673.99,850.5L676.06,851.33L676.41,851.76L677.12,851.93L678.48,851.93L679.08,852.09L679.13,851.24zM655.44,745.43L659.25,737.61L660.03,730.02L659.93,722.05L661.07,713.1L662.7,708.27L664.77,704.44L670.31,697.05L672.08,693.22L675.65,672.48L672.91,671.69L664.46,675.78L661.43,680.06L662.75,685.46L663.22,690.85L660.36,696.24L657.72,700.33L655.58,705.53L653.7,712.13L650.8,718.17L647.05,728.57L644.57,733.31L644.66,738.6L643.93,743.47L638.85,746.4L632.41,745.47L623.19,737.9L615.98,725.32L611.54,724.11L606.59,723.42L602.66,719.66L597.84,717.43L591.73,715.2L587.77,708.83L586.89,703.04L574.62,706.05L569.54,709.25L566.43,712.32L560.32,716.27L559.64,720.77L561.39,725.46L559.3,729.31L553.49,732.47L552.81,737.86L554.52,745.65L552.13,756L552.09,764.81L548.71,769.4L542.01,775.1L540.18,782.75L541.25,789.15L543.59,792.76L548.42,797.76L549.4,801.65L546.37,802.02L549.06,807.21L549.65,811.01L553.84,812.03L558.19,814.9L556.01,825.73L555.88,829.8L554.31,833.69L546.67,836.93L542.91,839.06L536.89,840.35L532.67,843.87L530.79,849.05L527.89,854.22L525.5,860.1L524.86,871.65L525.84,876.78L527.42,881.54L528.23,887.13L528.23,891.33L530.28,895.26L533.95,899.64L531.99,902.64L527.8,905.14L526.18,908.18L525.75,911.78L527.89,914.83L530.58,916.12L533.01,919.63L532.92,924.1L533.35,928.85L535.91,933.51L539.5,937.34L547.52,941.03L551.05,940.77L550.84,929.26L552.16,916.61L553.23,912.14L560.72,899.01L564.49,885.86L565.97,876.21L568.52,871.52L574.84,863.63L576.89,859.67L580.99,849.13L582.65,846.97L584.72,845.88L593.22,836.56L605.86,828.12L609.55,824.61L613.28,819.87L614.96,817.11L615.94,814.6L616.07,812.41L615.57,807.48L615.94,805.41L618.53,802.42L629.43,793.18L630.44,791.04L638.5,779.41L640.17,774.79L642.49,764.53L646.25,757.9L647.56,753.34L648.38,751.56L650.05,749.84L653.81,747.1L655.44,745.43z"},{"code":"TW-YUN","name":"Yunlin","labelCoordinate":{"x":0.5,"y":0.4},"path":"M426.52,585.04L420.55,581.6L420.55,581.6L419.89,582.87L415.5,586.23L414.9,587.42L414.09,589.56L409.25,595.96L408.26,598.31L406.43,605.2L405.45,613.08L402.03,619.1L399.83,626.8L399.27,636.44L399.44,649.35L395.84,653.39L396.58,653.35L396.69,653.26L404.97,652.33L411.5,656.01L416.24,656.06L419.36,653.59L420.68,649.73L422.3,647.4L426.48,646.75L431.95,642.28L435.45,640.41L438.43,637.43L451.24,630.03L456.87,628.49L466.77,626.63L472.19,626.35L476.33,629.98L480.26,634.59L490.16,638.23L493.06,637.81L499.59,635.94L503.31,638.55L505.18,641.67L510.13,641.16L519.35,639.3L522.43,638.27L522.43,635.57L522.72,631.66L523.11,631.7L521.06,628.91L514.57,629.61L509.24,631.24L504.67,629.24L501.56,625.56L502.28,621.04L503.77,616.98L502.96,610.97L503.77,605.33L505.35,601.65L503.86,595.93L503.05,596.49L493.64,594.62L489.07,594.69L479.52,589.96L464.04,588.21L454.94,584.73L449.7,583.3L443.78,582.99L426.52,585.04z"},{"code":"TW-TXQ","name":"Taichung City","path":"M546.22,479.04L537.12,473.79L532,472.86L526.19,470.05L514.36,461.3L509.43,456.99L505.71,453.06L498.47,441.87L488.04,453.45L485.42,457.76L483.2,465.55L475.89,478.23L473.75,487.9L472.01,492.93L469.42,495.1L468.83,497.69L468.34,498.27L468.34,498.27L472.92,499.76L476.05,502.51L478.15,507.49L478.96,513.45L482.48,517.73L491.81,520.47L495.2,523.27L497.72,527.2L499.29,530.32L499.33,533.43L500.3,536.07L503.65,536.67L507.94,539.47L507.95,540.57L511.26,540.69L525.38,542.68L528.68,542.15L532.58,538.42L538.53,527.11L541.43,520.47L546.45,518.06L554.4,519.22L559.13,519L563.65,512.98L566.01,511.49L573.06,516.73L575.79,516.01L577.85,511.74L581.52,508.65L586.73,508.75L590.66,507.25L596.86,501.26L600.84,499.01L604.3,498.36L611.24,494.71L616.09,494.52L620.99,493.74L629.72,490.28L633.39,490.03L637.08,490.87L647.57,491.84L647.58,491.84L649.78,490.27L650.74,488.68L653.42,487.28L655.81,484.35L656.83,480.29L659.19,476.42L665.12,472.68L666.97,467.83L667.31,464.56L670.95,460.74L666.37,457.05L662.53,457.05L658.77,458.83L655.7,459.31L652.78,457.3L649.33,455.31L645.47,454.46L644.33,451.56L644.86,447.18L641.99,446.4L639.77,445.8L631.47,446.58L630.86,447.01L627.94,449.06L626.52,453.46L622.7,455.06L618.52,454.96L615.19,457.3L611.6,460.77L606.99,463.3L597.89,470.55L592.48,472.76L585.55,476.48L581.28,474.8L577.37,470.45L572.63,468.55L564.89,467.96L560.56,470.55L559.88,476.32L555.78,478.54L546.22,479.04z"},{"code":"TW-NAN","name":"Nantou","path":"M647.57,491.84L637.08,490.87L633.39,490.03L629.72,490.28L620.99,493.74L616.09,494.52L611.24,494.71L604.3,498.36L600.84,499.01L596.86,501.26L590.66,507.25L586.73,508.75L581.52,508.65L577.85,511.74L575.79,516.01L573.06,516.73L566.01,511.49L563.65,512.98L559.13,519L554.4,519.22L546.45,518.06L541.43,520.47L538.53,527.11L532.58,538.42L528.68,542.15L525.38,542.68L511.26,540.69L507.95,540.57L507.97,543.4L504.61,544.58L503.65,546.89L504.09,550.07L502.5,553.62L501.22,557.88L501.14,562.33L500.23,567.52L499.55,578.04L501.14,582.99L504.01,585.6L507.06,586.72L511.44,588.93L510.7,591.7L507.68,592.91L505.7,594.69L503.86,595.93L505.35,601.65L503.77,605.33L502.96,610.97L503.77,616.98L502.28,621.04L501.56,625.56L504.67,629.24L509.24,631.24L514.57,629.61L521.06,628.91L523.11,631.7L527.89,632.22L533.18,634.27L536.42,635.2L540.48,637.39L540.18,641.53L537.83,645.58L538.81,649.35L540.9,654.47L541.2,659.03L542.06,662.06L548.03,663.13L568.13,663.27L568.84,663.44L572.27,664.25L576.84,666.01L580.13,670.57L580.64,672.15L585.38,669.46L587.79,667.22L586.45,662.36L587.65,660.27L588.81,657.08L592.89,654.07L598.69,652.77L604.5,652.58L608.66,648.86L609.72,642.15L612.82,638.12L618.84,635.94L622.34,633.46L623.62,629.49L626.11,619.55L627.08,612.99L626.35,607.36L625.41,603.07L622.93,599.91L621.25,596.76L625.72,589.4L625.89,586.47L627.88,580.94L630.89,574.28L633.31,567.4L634.53,559.59L635.01,553.64L633.62,550.12L631.98,547.51L633.86,541.53L637.83,533.15L644.12,524.95L644.33,521.96L643.16,518.38L639.09,515.73L636.85,513.33L636.64,505.5L639.55,503.25L644.77,501.51L648.84,499.61L648.65,496.77L647.57,491.84z"},{"code":"TW-HUA","name":"Hualien","path":"M701.45,470.3L696.32,470.27L689.84,467.8L678.01,464.8L672.91,462.33L670.95,460.74L667.31,464.56L666.97,467.83L665.12,472.68L659.19,476.42L656.83,480.29L655.81,484.35L653.42,487.28L650.74,488.68L649.78,490.27L647.58,491.84L647.57,491.84L648.65,496.77L648.84,499.61L644.77,501.51L639.55,503.25L636.64,505.5L636.85,513.33L639.09,515.73L643.16,518.38L644.33,521.96L644.12,524.95L637.83,533.15L633.86,541.53L631.98,547.51L633.62,550.12L635.01,553.64L634.53,559.59L633.31,567.4L630.89,574.28L627.88,580.94L625.89,586.47L625.72,589.4L621.25,596.76L622.93,599.91L625.41,603.07L626.35,607.36L627.08,612.99L626.11,619.55L623.62,629.49L622.34,633.46L618.84,635.94L612.82,638.12L609.72,642.15L608.66,648.86L604.5,652.58L598.69,652.77L592.89,654.07L588.81,657.08L587.65,660.27L586.45,662.36L587.79,667.22L585.38,669.46L580.64,672.15L582.13,676.71L579.78,680.62L575.39,682.57L574.32,685.08L575.09,688.2L579.44,691.03L584.44,695.08L586.61,701.07L586.89,703.04L587.77,708.83L591.73,715.2L597.84,717.43L602.66,719.66L606.59,723.42L611.54,724.11L615.98,725.32L623.19,737.9L632.41,745.47L638.85,746.4L643.93,743.47L644.66,738.6L644.57,733.31L647.05,728.57L650.8,718.17L653.7,712.13L655.58,705.53L657.72,700.33L660.36,696.24L663.22,690.85L662.75,685.46L661.43,680.06L664.46,675.78L672.91,671.69L675.65,672.48L675.65,672.48L684.32,622.15L688.1,614.45L694.41,583.03L699.4,569.62L701.92,556.85L702.22,551.81L702.82,549.07L705.7,544.57L706.55,541.73L706.5,539.19L705.85,538.11L704.82,537.29L703.63,535.55L702.22,531.44L702.07,527.74L703.23,524.29L709.06,515.74L711.31,506.17L713.51,501.43L715.48,499.54L720.72,495.58L721.37,494.4L720.82,492.74L721.98,491.19L725.61,488.29L730.53,481.48L735.1,477.02L736.19,475.14L736.04,474.3L735.49,473.14L734.78,471.97L734.26,471.38L734.26,471.38L733.41,471.36L724.67,470.05L710.14,461.37L707.15,462.05L705.32,466.74L701.45,470.3z"},{"code":"TW-CYI","name":"Chiayi City","path":"M464.04,670.2L469.38,668.06L472.92,667.6L475.27,665.87L473.26,660.52L471.34,657.41L468.14,655.68L463.74,654.01L457.55,654.57L450.26,655.82L447.31,659.03L447.99,663.46L452.77,665.36L458.28,668.9L464.04,670.2z"},{"code":"TW-CYQ","name":"Chiayi","labelCoordinate":{"x":0.7,"y":0.5},"path":"M391.96,700.38L393.15,697.89L394.28,696.38L394.19,695.53L393.69,695.11L392.87,696.31L392.13,698.13L390.28,700.56L390.57,701.42L391.96,700.38zM393.74,690.44L395.05,688.1L395.44,686.65L394.73,686.95L393.15,689.9L392.98,691.33L393.74,690.44zM397.59,683.37L397.94,682.51L397.89,680.25L397.52,679.92L397.52,683.38L397.59,683.37zM398.65,675.76L398.58,675.74L398.6,675.71L397.67,675.46L398.08,677.04L398.18,676.8L398.24,677.08L398.65,675.76zM397.64,670.97L397.47,670.91L397.52,670.71L396.23,670.38L396.43,670.71L397.24,672.05L397.64,670.97zM374.22,671.77L377.74,668.97L380.07,667.33L383.04,664.36L385.35,661.54L388.83,658.03L395.94,646.54L393.98,647.11L385.65,657.71L374.7,668.78L371.76,673.07L374.22,671.77zM480.26,634.59L476.33,629.98L472.19,626.35L466.77,626.63L456.87,628.49L451.24,630.03L438.43,637.43L435.45,640.41L431.95,642.28L426.48,646.75L422.3,647.4L420.68,649.73L419.36,653.59L416.24,656.06L411.5,656.01L404.97,652.33L396.69,653.26L396.58,653.35L395.84,653.39L396,660.24L402.71,659.82L399.52,663.96L398.82,665.94L397.45,667.58L397.14,668.93L399.52,670.1L399.52,671.64L398.01,674.5L401.29,680.82L404.16,689.02L399.95,688.98L397.05,689.18L395.12,693.62L395.15,696.21L397.08,696.3L398.54,696.66L400.28,695.4L400.93,697.89L399.82,697.52L397.27,698.66L394.24,698.87L398.36,700.42L405.32,701.45L410.99,702.89L415.9,700.7L417.86,696.8L422.39,694.01L427.59,689.97L431.26,686.2L436.09,682.62L442.19,679.88L454.14,677.64L460.8,677.27L466.43,679.13L469.59,681.04L471.21,684.34L472.58,688.34L480.34,696.29L481.11,702.19L479.75,713.34L480.98,716.92L484.53,719.66L487.47,719.7L491.7,717.8L495.62,717.29L498.53,718.17L505.1,718.93L505.1,718.91L504.33,713.71L503.18,710.13L503.31,706.28L506.12,703.49L511.5,704.05L516.11,703.58L525.75,697.82L529.25,693.64L535.53,688.85L541.54,685.46L544.87,681.5L547.69,676.16L554.31,670.85L568.84,663.44L568.13,663.27L548.03,663.13L542.06,662.06L541.2,659.03L540.9,654.47L538.81,649.35L537.83,645.58L540.18,641.53L540.48,637.39L536.42,635.2L533.18,634.27L527.89,632.22L523.11,631.7L522.72,631.66L522.43,635.57L522.43,638.27L519.35,639.3L510.13,641.16L505.18,641.67L503.31,638.55L499.59,635.94L493.06,637.81L490.16,638.23L480.26,634.59zM450.26,655.82L457.55,654.57L463.74,654.01L468.14,655.68L471.34,657.41L473.26,660.52L475.27,665.87L472.92,667.6L469.38,668.06L464.04,670.2L458.28,668.9L452.77,665.36L447.99,663.46L447.31,659.03L450.26,655.82z"},{"code":"TW-CHA","name":"Changhua","path":"M507.95,540.57L507.94,539.47L503.65,536.67L500.3,536.07L499.33,533.43L499.29,530.32L497.72,527.2L495.2,523.27L491.81,520.47L482.48,517.73L478.96,513.45L478.15,507.49L476.05,502.51L472.92,499.76L468.34,498.27L459.44,508.68L457.32,510.7L456.62,512.88L456.15,520.81L455.22,523.2L451.19,526.37L450.26,528.54L449.78,530.86L448.55,532L446.84,532.82L444.89,534.14L442.52,536.5L440.4,540.18L435.87,552.84L432.64,558.92L430.52,565.01L428.91,567.25L423.35,572.58L422.41,574.91L421.13,580.48L420.55,581.6L420.55,581.6L426.52,585.04L443.78,582.99L449.7,583.3L454.94,584.73L464.04,588.21L479.52,589.96L489.07,594.69L493.64,594.62L503.05,596.49L503.86,595.93L505.7,594.69L507.68,592.91L510.7,591.7L511.44,588.93L507.06,586.72L504.01,585.6L501.14,582.99L499.55,578.04L500.23,567.52L501.14,562.33L501.22,557.88L502.5,553.62L504.09,550.07L503.65,546.89L504.61,544.58L507.97,543.4L507.95,540.57z"},{"code":"TW-TAO","name":"Taoyuan","path":"M652.98,353.4L648.95,351.15L650.01,345.87L649.21,341.85L645.01,337.84L644.15,333.85L645.01,329.31L644.84,324.44L647.74,321.27L657.98,318.26L660.63,315.53L661.4,312.23L661.02,309.06L656.99,303.19L653.66,301.43L650.47,300.67L647.96,298.41L644.24,296.02L639.32,293.64L635.99,290.02L620.21,292.87L613.18,295.41L609.65,297.33L606.75,299.89L603.37,302L588.9,306.76L583.26,311.54L577.8,318.05L570.81,329.19L573.31,330.07L584.01,329.31L587.64,331.75L590.77,338.57L594.7,340.1L598.09,341.08L601.31,342.61L606.68,344.37L609.5,347.63L608.61,352.24L611.32,355.15L616.47,356.79L619.74,359.17L622.21,361.61L625.21,362.18L628.22,361.93L630.89,364.68L632.94,368.26L636.36,369.95L639.04,372.02L639.32,375.96L640.56,381.67L639.09,387.74L635.46,392.85L635.91,396.26L639.92,399.36L644.78,402.27L649.14,403.02L652.3,405.28L658.01,408.53L661.77,410.22L662.2,409.03L665.27,407.78L667.8,408.28L670.5,407.28L672.27,404.27L669.82,394.51L674.03,391.44L676.44,390.77L674.51,386.49L667.49,379.85L666.4,375.46L665.77,371.39L668.23,368.44L669.37,364.34L662.76,354.66L658.8,353.09L652.98,353.4z"},{"code":"TW-TPQ","name":"New Taipei City","labelCoordinate":{"x":0.4,"y":0.77},"path":"M707.97,267.4L700.1,256.3L696.57,253.66L688.09,252.65L679.43,254.63L671.89,258.48L666.73,263.15L664.23,267.74L662.6,271.79L661.98,272.51L660.48,273.22L659.05,274.4L658.36,276.53L660.77,278.03L665.32,282.65L668.16,287.11L665.44,288.22L664.21,287L663.25,284.84L661.78,282.77L659.02,281.85L656.63,281.89L654.85,282.2L653.41,282.93L648.57,286.95L644.84,288.42L636,290.02L635.99,290.02L639.32,293.64L644.24,296.02L647.96,298.41L650.47,300.67L653.66,301.43L656.99,303.19L661.02,309.06L661.4,312.23L660.63,315.53L657.98,318.26L647.74,321.27L644.84,324.44L645.01,329.31L644.15,333.85L645.01,337.84L649.21,341.85L650.01,345.87L648.95,351.15L652.98,353.4L658.8,353.09L662.76,354.66L669.37,364.34L668.23,368.44L665.77,371.39L666.4,375.46L667.49,379.85L674.51,386.49L676.44,390.77L680.98,389.5L684.82,388.06L687.8,385.49L691.68,382.76L696.91,380.23L699.97,378.07L699.64,376.47L698.84,373.97L698.73,370.71L700.23,366.82L703.96,363.68L706.95,361.9L717.19,357.73L727.77,351.39L732.64,349.89L736.6,347.06L739.02,343.11L741.58,339.88L744.48,338.35L747.24,337.38L750.85,335.08L752.13,332.1L750.17,329.31L751.28,326.99L760.04,325.2L762.92,323.29L769.51,319.77L774.19,318.79L776.8,320.27L777.41,321.15L777.41,321.15L784.23,317.77L782.65,315.77L779.73,314.3L776.42,313.41L773.6,313.11L768.1,313.95L766.44,313.19L764.37,310L762.46,303.17L761.9,299.09L762.25,296.79L763.53,293.91L760.99,292.3L733.83,285.7L733.6,295.08L733.73,297.46L736.63,300.5L736.33,302.43L734.34,303.89L731.21,305.07L727.17,304.55L718.87,301.09L716.53,299.42L713.65,296.68L711.41,293.95L710.06,291.19L707.82,288.29L707.37,286.03L709.87,284.33L715.5,281.88L718.96,279.58L718.96,279.57L717.16,278.3L716.32,277.31L716.25,275.59L717.04,274.2L717.86,273.19L717.96,272.49L716.25,272.02L713.83,272.3L711.71,272.88L710.79,273.27L707.97,267.4zM674.74,286.6L676.41,283.01L679.2,279.88L687.76,274.79L690.07,272.83L693.2,271.27L696.21,272.26L697.83,273.96L697.41,276.79L697.73,279.5L698.94,282.07L700.27,284.85L702.21,292.75L705.26,295.46L706.54,298.95L705.26,304.13L705.41,308.13L709.02,310.16L711.94,312.66L710.38,316L704.41,323.53L701.12,324.9L696.55,324.85L692.78,324L689.9,321.46L686.91,318.05L682.38,314.49L679.27,309.22L680.51,303.38L679.57,298.48L675.04,294.14L672.08,290.82L673.34,288.48L674.74,286.6zM799.61,174.24L797.67,173.06L797.96,175.38L799.61,174.24z"},{"code":"TW-TPE","name":"Taipei City","path":"M701.12,324.9L704.41,323.53L710.38,316L711.94,312.66L709.02,310.16L705.41,308.13L705.26,304.13L706.54,298.95L705.26,295.46L702.21,292.75L700.27,284.85L698.94,282.07L697.73,279.5L697.41,276.79L697.83,273.96L696.21,272.26L693.2,271.27L690.07,272.83L687.76,274.79L679.2,279.88L676.41,283.01L674.74,286.6L673.34,288.48L672.08,290.82L675.04,294.14L679.57,298.48L680.51,303.38L679.27,309.22L682.38,314.49L686.91,318.05L689.9,321.46L692.78,324L696.55,324.85L701.12,324.9z"},{"code":"TW-MIA","name":"Miaoli","path":"M564.68,384.11L561.24,382.73L559.11,379.76L555.78,377.72L550.38,375.62L550.37,375.61L550.09,376.64L547.27,378.06L546.61,379.5L545.17,384L542.24,386.96L540.11,389.87L540.86,394.18L535.22,393.1L530.83,394.26L527.22,396.93L523.93,400.37L522.85,402.29L521.96,404.36L520.47,406.02L515.16,407.6L513.95,409.7L512.69,414.61L508.05,422.8L506.32,427.19L505.63,432.37L504.17,435.54L498.47,441.87L498.47,441.87L505.71,453.06L509.43,456.99L514.36,461.3L526.19,470.05L532,472.86L537.12,473.79L546.22,479.04L555.78,478.54L559.88,476.32L560.56,470.55L564.89,467.96L572.63,468.55L577.37,470.45L581.28,474.8L585.55,476.48L592.48,472.76L597.89,470.55L606.99,463.3L611.6,460.77L615.19,457.3L618.52,454.96L622.7,455.06L626.52,453.46L627.94,449.06L630.86,447.01L630.36,443.18L626.8,437.05L624.19,434.52L623.16,431.05L619.23,427.92L609.36,430.42L605.63,430.05L600.28,430.39L594.24,432.05L591.03,431.27L591.75,427.3L592.72,423.64L591.97,420.54L591.2,418.26L591.97,415.79L592.59,413.09L592.87,410.03L592.25,405.9L589.24,403.27L579.68,398.76L574.96,395.25L571.93,391.75L568.44,383.05L568.29,383.23L564.68,384.11z"},{"code":"TW-KEE","name":"Keelung City","path":"M733.83,285.7L725,283.56L721.98,282.44L720.67,281.14L720.06,280.35L718.96,279.57L718.96,279.58L715.5,281.88L709.87,284.33L707.37,286.03L707.82,288.29L710.06,291.19L711.41,293.95L713.65,296.68L716.53,299.42L718.87,301.09L727.17,304.55L731.21,305.07L734.34,303.89L736.33,302.43L736.63,300.5L733.73,297.46L733.6,295.08L733.83,285.7z"},{"code":"TW-ILA","name":"Yilan","labelCoordinate":{"x":0.5,"y":0.65},"path":"M771.16,351.63L771.08,351.67L770.94,351.65L770.82,351.82L768.87,352.94L768.1,352.68L769.11,354.31L769.18,354.32L769.48,354.8L770.54,355.4L773.55,355.51L774.12,353.67L773.61,353.18L772.86,351.98L771.34,351.72L771.16,351.63zM758.73,408.28L752.71,407.17L747.6,404.01L744.91,399.11L744.76,392.76L745.87,389.65L746.02,386.55L743.44,374.39L743.23,368.56L743.65,362.56L744.85,356.51L746.68,351.24L749,347.46L763.67,329.57L768,325.81L777.41,321.15L777.41,321.15L776.8,320.27L774.19,318.79L769.51,319.77L762.92,323.29L760.04,325.2L751.28,326.99L750.17,329.31L752.13,332.1L750.85,335.08L747.24,337.38L744.48,338.35L741.58,339.88L739.02,343.11L736.6,347.06L732.64,349.89L727.77,351.39L717.19,357.73L706.95,361.9L703.96,363.68L700.23,366.82L698.73,370.71L698.84,373.97L699.64,376.47L699.97,378.07L696.91,380.23L691.68,382.76L687.8,385.49L684.82,388.06L680.98,389.5L676.44,390.77L674.03,391.44L669.82,394.51L672.27,404.27L670.5,407.28L667.8,408.28L665.27,407.78L662.2,409.03L661.77,410.22L659.95,415.32L658.89,419.04L659.34,422.48L656.39,427.05L645.4,438.18L641.99,446.4L644.86,447.18L644.33,451.56L645.47,454.46L649.33,455.31L652.78,457.3L655.7,459.31L658.77,458.83L662.53,457.05L666.37,457.05L670.95,460.74L672.91,462.33L678.01,464.8L689.84,467.8L696.32,470.27L701.45,470.3L705.32,466.74L707.15,462.05L710.14,461.37L724.67,470.05L733.41,471.36L734.26,471.38L734.09,471.2L733.27,469.9L733.67,468.82L734.46,467.78L734.9,466.5L735.3,461.51L735.94,458.97L736.95,457.21L737.86,455.11L737.52,449.63L737.71,447.15L743.23,440.81L748.11,437.98L750.09,436.12L749.62,433.92L748.29,431.8L747.69,429.45L748.04,427.52L752.73,424.85L753.38,420.42L752.32,415.32L750.26,411.38L751.72,410.34L753.75,409.67L756.17,409.43L758.73,409.68L758.73,408.28z"},{"code":"TW-HSZ","name":"Hsinchu","path":"M573.31,330.07L570.81,329.19L570.81,329.19L569.19,331.78L567.43,336.57L566.91,338.87L567.08,339.84L565.09,340.51L563.01,342.21L561.38,344.46L560.72,346.75L560.25,349.77L559.08,351.52L559.03,351.58L565.55,354.4L577.39,358.16L581.64,360.42L584.68,363.43L586.13,366.31L585.37,369.2L583.52,370.26L579.45,370.95L574.88,372.83L572.17,376.22L570.4,380.67L568.44,383.05L571.93,391.75L574.96,395.25L579.68,398.76L589.24,403.27L592.25,405.9L592.87,410.03L592.59,413.09L591.97,415.79L591.2,418.26L591.97,420.54L592.72,423.64L591.75,427.3L591.03,431.27L594.24,432.05L600.28,430.39L605.63,430.05L609.36,430.42L619.23,427.92L623.16,431.05L624.19,434.52L626.8,437.05L630.36,443.18L630.86,447.01L631.47,446.58L639.77,445.8L641.99,446.4L645.4,438.18L656.39,427.05L659.34,422.48L658.89,419.04L659.95,415.32L661.77,410.22L658.01,408.53L652.3,405.28L649.14,403.02L644.78,402.27L639.92,399.36L635.91,396.26L635.46,392.85L639.09,387.74L640.56,381.67L639.32,375.96L639.04,372.02L636.36,369.95L632.94,368.26L630.89,364.68L628.22,361.93L625.21,362.18L622.21,361.61L619.74,359.17L616.47,356.79L611.32,355.15L608.61,352.24L609.5,347.63L606.68,344.37L601.31,342.61L598.09,341.08L594.7,340.1L590.77,338.57L587.64,331.75L584.01,329.31L573.31,330.07z"},{"code":"TW-HSQ","name":"Hsinchu City","path":"M568.44,383.05L570.4,380.67L572.17,376.22L574.88,372.83L579.45,370.95L583.52,370.26L585.37,369.2L586.13,366.31L584.68,363.43L581.64,360.42L577.39,358.16L565.55,354.4L559.03,351.58L559.03,351.58L557.67,353.02L556.49,355.36L557.35,357.12L557.87,358.56L557.9,359.89L557.33,361.12L555.62,363.47L551.25,372.4L550.37,375.61L550.38,375.62L555.78,377.72L559.11,379.76L561.24,382.73L564.68,384.11L568.29,383.23L568.44,383.05z"},{"code":"TW-TNQ","name":"Tainan City","path":"M379.59,759.29L379.69,758.53L378,756.79L377.48,755.33L376.79,754.38L376.23,754.39L376.01,755.41L377.34,758.66L379.11,760.26L379.59,759.29zM380.01,737.62L380.2,736.68L381.27,732.65L380.97,732.63L380.8,732.52L377.68,743L377.73,743.11L380.01,737.62zM382.7,727.56L386.05,721.2L385.91,719.78L385.49,719.84L382.65,727.56L382.7,727.56zM387.71,709.94L388.26,703.64L387.86,703.51L387.37,711.79L387.46,711.87L387.71,709.94zM481.11,702.19L480.34,696.29L472.58,688.34L471.21,684.34L469.59,681.04L466.43,679.13L460.8,677.27L454.14,677.64L442.19,679.88L436.09,682.62L431.26,686.2L427.59,689.97L422.39,694.01L417.86,696.8L415.9,700.7L410.99,702.89L405.32,701.45L398.36,700.42L394.24,698.87L393,702.06L395.93,704.02L393.91,704.53L392.67,705.88L390.01,712.93L389.64,714.69L390.02,716.49L388.24,718.56L387.15,721.48L386.42,723.8L387.49,726.32L388.13,729.4L387.09,731.39L384.95,732.1L382.99,733.22L382.45,736.36L384.65,738.88L387.99,741.77L388.6,743.84L382.45,743.89L382.45,745.43L389.79,747.26L390.92,748.49L390.09,750.87L387.68,751.65L384.75,752.04L382.45,753.23L381.53,755.05L381,757.74L381.58,760.46L383.86,762.43L386.01,761.86L387.47,759.59L389.27,757.97L392.46,759.36L393.1,761.29L392.72,766.79L393.74,768.54L396.35,768.65L397.74,766.55L398.56,763.89L399.52,762.43L404.49,763.14L405.33,767.26L403.25,772.02L399.52,774.68L402.58,777.76L404.01,780.61L404.76,785.53L404.76,785.54L409.6,782.64L409.71,782.98L412.83,789.8L416.58,791.69L428.87,793.46L435.36,792.76L441.98,793.55L445.26,792.39L448.04,790.35L453.12,788.31L458.07,784.84L459.94,780.53L462.29,776.4L466.43,770.89L471.25,765.83L476.33,761.61L482.18,755.91L487.26,749.36L495.11,736L503.31,724.11L505.1,718.93L498.53,718.17L495.62,717.29L491.7,717.8L487.47,719.7L484.53,719.66L480.98,716.92L479.75,713.34L481.11,702.19z"},{"code":"TW-PIF","name":"Pingtung","path":"M446.8,914.48L446.28,914.85L444.67,914.85L442.49,917.62L442.5,917.69L441.43,919.77L442.07,922.19L442.08,922.16L442.1,922.33L444.47,920.27L445.78,919.23L446.05,918.98L448.16,917.55L448.05,917.16L448.42,916.81L447.37,915.29L447.21,914.85L447.06,914.85L446.8,914.48zM543.69,1014.98L543.94,1010.33L542.83,1003.16L542.73,996.58L545.85,993.69L548.49,991.75L550.49,987.07L551.72,981.31L551.05,940.77L547.52,941.03L539.5,937.34L535.91,933.51L533.35,928.85L532.92,924.1L533.01,919.63L530.58,916.12L527.89,914.83L525.75,911.78L526.18,908.18L527.8,905.14L531.99,902.64L533.95,899.64L530.28,895.26L528.23,891.33L528.23,887.13L527.42,881.54L525.84,876.78L524.86,871.65L525.5,860.1L527.89,854.22L530.79,849.05L532.67,843.87L536.89,840.35L542.91,839.06L546.67,836.93L554.31,833.69L555.88,829.8L556.01,825.73L558.19,814.9L553.84,812.03L549.65,811.01L549.06,807.21L546.37,802.02L546.32,802.03L542.23,801.28L538.86,801.47L532.16,806.75L527.55,802.4L521.61,795.45L515.94,796.84L510.73,801.47L500.45,796.28L493.06,799.8L488.07,805.36L481.8,807.58L467.8,806.75L466.43,810.55L465.41,816.19L463.36,822.4L463.78,827.9L463.7,835.35L459.26,852.01L459.13,857.6L461.31,863.47L461.61,869.94L455.22,886.03L455.51,886.15L457.25,887.26L461.02,890.56L464.58,893.01L472.44,896.78L475.89,899.01L476.39,900.06L477.15,902.99L478.01,903.59L478.86,903.87L481.42,905.34L487.8,910.38L489.38,912.62L492.81,920.36L497.16,925.75L498.45,927.97L514.08,968.52L513.64,970.88L511.73,973.66L511.27,976.13L511.27,984.57L510.97,987.15L510.92,988.72L511.27,990.66L515.61,997.89L514.62,1003.38L514.79,1005.22L517.68,1007.66L520.35,1008.33L522.16,1006.47L522.41,1001.28L528.63,1002.8L534.82,1005.59L540.12,1009.63L543.69,1014.98z"},{"code":"TW-KHQ","name":"Kaohsiung City","path":"M580.64,672.15L580.13,670.57L576.84,666.01L572.27,664.25L568.84,663.44L554.31,670.85L547.69,676.16L544.87,681.5L541.54,685.46L535.53,688.85L529.25,693.64L525.75,697.82L516.11,703.58L511.5,704.05L506.12,703.49L503.31,706.28L503.18,710.13L504.33,713.71L505.1,718.91L505.1,718.93L503.31,724.11L495.11,736L487.26,749.36L482.18,755.91L476.33,761.61L471.25,765.83L466.43,770.89L462.29,776.4L459.94,780.53L458.07,784.84L453.12,788.31L448.04,790.35L445.26,792.39L441.98,793.55L435.36,792.76L428.87,793.46L416.58,791.69L412.83,789.8L409.71,782.98L409.6,782.64L404.76,785.54L406.43,796.24L407.03,797.76L409.25,801.6L409.7,803.43L410.75,804.45L411.75,805.2L412.19,806.2L411.92,808.09L410.75,810.92L410.66,813.22L411.47,816.77L415.1,824.77L418.94,830.78L421.05,835.26L422.24,839.79L421.35,843.01L419.65,846.63L420.93,850.33L423.65,853.67L430.74,860.23L434.91,864.98L436.23,867.49L436.24,867.49L437.9,870.64L439.07,876.4L429.06,864.3L438.57,877.79L448.82,885.81L450.5,885.76L451.95,885.22L453.21,885.15L455.22,886.03L461.61,869.94L461.31,863.47L459.13,857.6L459.26,852.01L463.7,835.35L463.78,827.9L463.36,822.4L465.41,816.19L466.43,810.55L467.8,806.75L481.8,807.58L488.07,805.36L493.06,799.8L500.45,796.28L510.73,801.47L515.94,796.84L521.61,795.45L527.55,802.4L532.16,806.75L538.86,801.47L542.23,801.28L546.32,802.03L546.37,802.02L549.4,801.65L548.42,797.76L543.59,792.76L541.25,789.15L540.18,782.75L542.01,775.1L548.71,769.4L552.09,764.81L552.13,756L554.52,745.65L552.81,737.86L553.49,732.47L559.3,729.31L561.39,725.46L559.64,720.77L560.32,716.27L566.43,712.32L569.54,709.25L574.62,706.05L586.89,703.04L586.61,701.07L584.44,695.08L579.44,691.03L575.09,688.2L574.32,685.08L575.39,682.57L579.78,680.62L582.13,676.71L580.64,672.15z"}];
    var chart = null

    if (typeof window === 'undefined') {
        return;
    }

    if (typeof require === 'undefined') {
        chart = tui.chart;
    } else {
        chart = require('tui-chart');
    }
    chart.registerMap('taiwan', data);
})(tui.chart);
