# @turf/great-circle

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## greatCircle

Calculate great circles routes as [LineString][1]

### Parameters

-   `start` **[Coord][2]** source point feature
-   `end` **[Coord][2]** destination point feature
-   `options` **[Object][3]** Optional parameters (optional, default `{}`)
    -   `options.properties` **[Object][3]** line feature properties (optional, default `{}`)
    -   `options.npoints` **[number][4]** number of points (optional, default `100`)
    -   `options.offset` **[number][4]** offset controls the likelyhood that lines will
        be split which cross the dateline. The higher the number the more likely. (optional, default `10`)

### Examples

```javascript
var start = turf.point([-122, 48]);
var end = turf.point([-77, 39]);

var greatCircle = turf.greatCircle(start, end, {properties: {name: 'Seattle to DC'}});

//addToMap
var addToMap = [start, end, greatCircle]
```

Returns **[Feature][5]&lt;[LineString][6]>** great circle line feature

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.4

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.1

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[5]: https://tools.ietf.org/html/rfc7946#section-3.2

[6]: https://tools.ietf.org/html/rfc7946#section-3.1.4

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/great-circle
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
