# @turf/isobands

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## isobands

Takes a grid [FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3) of [Point](https://tools.ietf.org/html/rfc7946#section-3.1.2) features with z-values and an array of
value breaks and generates filled contour isobands.

**Parameters**

-   `pointGrid` **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Point](https://tools.ietf.org/html/rfc7946#section-3.1.2)>** input points
-   `breaks` **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)>** where to draw contours
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** options on output (optional, default `{}`)
    -   `options.zProperty` **[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)** the property name in `points` from which z-values will be pulled (optional, default `'elevation'`)
    -   `options.commonProperties` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** GeoJSON properties passed to ALL isobands (optional, default `{}`)
    -   `options.breaksProperties` **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)>** GeoJSON properties passed, in order, to the correspondent isoband (order defined by breaks) (optional, default `[]`)

Returns **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[MultiPolygon](https://tools.ietf.org/html/rfc7946#section-3.1.7)>** a FeatureCollection of [MultiPolygon](https://tools.ietf.org/html/rfc7946#section-3.1.7) features representing isobands

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/isobands
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
