# @turf/kinks

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## kinks

Takes a [linestring](https://tools.ietf.org/html/rfc7946#section-3.1.4), [multi-linestring](https://tools.ietf.org/html/rfc7946#section-3.1.5), [multi-polygon](https://tools.ietf.org/html/rfc7946#section-3.1.7), or [polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6) and returns [points](https://tools.ietf.org/html/rfc7946#section-3.1.2) at all self-intersections.

**Parameters**

-   `featureIn` **[Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;([LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4) \| [MultiLineString](https://tools.ietf.org/html/rfc7946#section-3.1.5) \| [MultiPolygon](https://tools.ietf.org/html/rfc7946#section-3.1.7) \| [Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6))>** input feature

**Examples**

```javascript
var poly = turf.polygon([[
  [-12.034835, 8.901183],
  [-12.060413, 8.899826],
  [-12.03638, 8.873199],
  [-12.059383, 8.871418],
  [-12.034835, 8.901183]
]]);

var kinks = turf.kinks(poly);

//addToMap
var addToMap = [poly, kinks]
```

Returns **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Point](https://tools.ietf.org/html/rfc7946#section-3.1.2)>** self-intersections

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/kinks
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
