# @turf/polygon-tangents

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## polygonTangents

Finds the tangents of a [(Multi)Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6) from a [Point](https://tools.ietf.org/html/rfc7946#section-3.1.2).

**Parameters**

-   `pt` **[Coord](https://tools.ietf.org/html/rfc7946#section-3.1.1)** to calculate the tangent points from
-   `polygon` **[Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;([Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6) \| [MultiPolygon](https://tools.ietf.org/html/rfc7946#section-3.1.7))>** to get tangents from

**Examples**

```javascript
var polygon = turf.polygon([[[11, 0], [22, 4], [31, 0], [31, 11], [21, 15], [11, 11], [11, 0]]]);
var point = turf.point([61, 5]);

var tangents = turf.polygonTangents(point, polygon)

//addToMap
var addToMap = [tangents, point, polygon];
```

Returns **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Point](https://tools.ietf.org/html/rfc7946#section-3.1.2)>** Feature Collection containing the two tangent points

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/polygon-tangents
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
