# @turf/polygon-to-line

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## polygonToLine

Converts a [Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6) to [(Multi)LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4) or [MultiPolygon](https://tools.ietf.org/html/rfc7946#section-3.1.7) to a [FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3) of [(Multi)LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4).

**Parameters**

-   `polygon` **[Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;([Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6) \| [MultiPolygon](https://tools.ietf.org/html/rfc7946#section-3.1.7))>** Feature to convert
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Optional parameters (optional, default `{}`)
    -   `options.properties` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** translates GeoJSON properties to Feature (optional, default `{}`)

**Examples**

```javascript
var poly = turf.polygon([[[125, -30], [145, -30], [145, -20], [125, -20], [125, -30]]]);

var line = turf.polygonToLine(poly);

//addToMap
var addToMap = [line];
```

Returns **([FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3) \| [Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;([LineString](https://tools.ietf.org/html/rfc7946#section-3.1.4) | MultiLinestring)>)** converted (Multi)Polygon to (Multi)LineString

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/polygon-to-line
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
