# @turf/polygon-to-linestring

# polygonToLineString

Converts a [Polygon](http://geojson.org/geojson-spec.html#polygon) to [(Multi)LineString](http://geojson.org/geojson-spec.html#linestring) or [MultiPolygon](http://geojson.org/geojson-spec.html#multipolygon) to a [FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects) of [(Multi)LineString](http://geojson.org/geojson-spec.html#linestring).

**Parameters**

-   `polygon` **[Feature](http://geojson.org/geojson-spec.html#feature-objects)&lt;([Polygon](http://geojson.org/geojson-spec.html#polygon) \| [MultiPolygon](http://geojson.org/geojson-spec.html#multipolygon))>** Feature to convert
-   `properties` **\[[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)]** translates GeoJSON properties to Feature

**Examples**

```javascript
var poly = turf.polygon([[[125, -30], [145, -30], [145, -20], [125, -20], [125, -30]]]);

var line = turf.polygonToLineString(poly);

//addToMap
var addToMap = [line];
```

Returns **([FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects) \| [Feature](http://geojson.org/geojson-spec.html#feature-objects)&lt;([LineString](http://geojson.org/geojson-spec.html#linestring) | MultiLinestring)>)** converted (Multi)Polygon to (Multi)LineString

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/polygon-to-linestring
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
