# @turf/rhumb-bearing

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## rhumbBearing

Takes two [points][1] and finds the bearing angle between them along a Rhumb line
i.e. the angle measured in degrees start the north line (0 degrees)

**Parameters**

-   `start` **[Coord][2]** starting Point
-   `end` **[Coord][2]** ending Point
-   `options` **[Object][3]?** Optional parameters
    -   `options.final` **[boolean][4]** calculates the final bearing if true (optional, default `false`)

**Examples**

```javascript
var point1 = turf.point([-75.343, 39.984], {"marker-color": "#F00"});
var point2 = turf.point([-75.534, 39.123], {"marker-color": "#00F"});

var bearing = turf.rhumbBearing(point1, point2);

//addToMap
var addToMap = [point1, point2];
point1.properties.bearing = bearing;
point2.properties.bearing = bearing;
```

Returns **[number][5]** bearing from north in decimal degrees, between -180 and 180 degrees (positive clockwise)

[1]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.1

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/rhumb-bearing
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
