# @turf/standard-deviational-ellipse

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## standardDeviationalEllipse

Takes a [FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3) and returns a standard deviational ellipse,
also known as a “directional distribution.” The standard deviational ellipse
aims to show the direction and the distribution of a dataset by drawing
an ellipse that contains about one standard deviation’s worth (~ 70%) of the
data.

This module mirrors the functionality of [Directional Distribution](http://desktop.arcgis.com/en/arcmap/10.3/tools/spatial-statistics-toolbox/directional-distribution.htm)
in ArcGIS and the [QGIS Standard Deviational Ellipse Plugin](http://arken.nmbu.no/~havatv/gis/qgisplugins/SDEllipse/)

**Bibliography**

• Robert S. Yuill, “The Standard Deviational Ellipse; An Updated Tool for
Spatial Description,” _Geografiska Annaler_ 53, no. 1 (1971): 28–39,
doi:[10.2307/490885](https://doi.org/10.2307/490885).

• Paul Hanly Furfey, “A Note on Lefever’s “Standard Deviational Ellipse,”
_American Journal of Sociology_ 33, no. 1 (1927): 94—98,
doi:[10.1086/214336](https://doi.org/10.1086/214336).

**Parameters**

-   `points` **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Point](https://tools.ietf.org/html/rfc7946#section-3.1.2)>** GeoJSON points
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Optional parameters (optional, default `{}`)
    -   `options.weight` **[string](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String)?** the property name used to weight the center
    -   `options.steps` **[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)** number of steps for the polygon (optional, default `64`)
    -   `options.properties` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** properties to pass to the resulting ellipse (optional, default `{}`)

**Examples**

```javascript
var bbox = [-74, 40.72, -73.98, 40.74];
var points = turf.randomPoint(400, {bbox: bbox});
var sdEllipse = turf.standardDeviationalEllipse(points);

//addToMap
var addToMap = [points, sdEllipse];
```

Returns **[Feature](https://tools.ietf.org/html/rfc7946#section-3.2)&lt;[Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6)>** an elliptical Polygon that includes approximately 1 SD of the dataset within it.

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/standard-deviational-ellipse
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
