# @turf/voronoi

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## voronoi

Takes a FeatureCollection of points, and a bounding box, and returns a FeatureCollection
of Voronoi polygons.

The Voronoi algorithim used comes from the d3-voronoi package.

**Parameters**

-   `points` **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Point](https://tools.ietf.org/html/rfc7946#section-3.1.2)>** to find the Voronoi polygons around.
-   `options` **[Object](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object)** Optional parameters (optional, default `{}`)
    -   `options.bbox` **[Array](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array)&lt;[number](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number)>** clipping rectangle, in [minX, minY, maxX, MaxY] order. (optional, default `[-180,-85,180,-85]`)

**Examples**

```javascript
var options = {
  bbox: [-70, 40, -60, 60]
};
var points = turf.randomPoint(100, options);
var voronoiPolygons = turf.voronoi(points, options);

//addToMap
var addToMap = [voronoiPolygons, points];
```

Returns **[FeatureCollection](https://tools.ietf.org/html/rfc7946#section-3.3)&lt;[Polygon](https://tools.ietf.org/html/rfc7946#section-3.1.6)>** a set of polygons, one per input point.

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/voronoi
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
