# @turf/within

# within

Takes a set of [points](http://geojson.org/geojson-spec.html#point) and a set of [polygons](http://geojson.org/geojson-spec.html#polygon) and returns the points that fall within the polygons.

**Parameters**

-   `points` **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)&lt;[Point](http://geojson.org/geojson-spec.html#point)>** input points
-   `polygons` **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)&lt;[Polygon](http://geojson.org/geojson-spec.html#polygon)>** input polygons

**Examples**

```javascript
var searchWithin = turf.featureCollection([
    turf.polygon([[
        [-46.653,-23.543],
        [-46.634,-23.5346],
        [-46.613,-23.543],
        [-46.614,-23.559],
        [-46.631,-23.567],
        [-46.653,-23.560],
        [-46.653,-23.543]
    ]])
]);
var points = turf.featureCollection([
    turf.point([-46.6318, -23.5523]),
    turf.point([-46.6246, -23.5325]),
    turf.point([-46.6062, -23.5513]),
    turf.point([-46.663, -23.554]),
    turf.point([-46.643, -23.557])
]);

var ptsWithin = turf.within(points, searchWithin);

//addToMap
var addToMap = [points, searchWithin, ptsWithin]
turf.featureEach(ptsWithin, function (currentFeature) {
  currentFeature.properties['marker-size'] = 'large';
  currentFeature.properties['marker-color'] = '#000';
});
```

Returns **[FeatureCollection](http://geojson.org/geojson-spec.html#feature-collection-objects)&lt;[Point](http://geojson.org/geojson-spec.html#point)>** points that land within at least one polygon

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/within
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
