/*! twilio-video.js 2.10.0

The following license applies to all parts of this software except as
documented below.

    Copyright (C) 2019-2020 Twilio, inc.
    All rights reserved.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are
    met:

      1. Redistributions of source code must retain the above copyright
         notice, this list of conditions and the following disclaimer.

      2. Redistributions in binary form must reproduce the above copyright
         notice, this list of conditions and the following disclaimer in
         the documentation and/or other materials provided with the
         distribution.

      3. Neither the name of Twilio nor the names of its contributors may
         be used to endorse or promote products derived from this software
         without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
    A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
    HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */
/* eslint strict:0 */
(function(root) {
  var bundle = (function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
'use strict';

var CancelablePromise = require('./util/cancelablepromise');

/**
 * Create a {@link CancelablePromise<Room>}.
 * @param {function(function(Array<LocalTrack>): CancelablePromise<RoomSignaling>):
 *   Promise<function(): CancelablePromise<RoomSignaling>>} getLocalTracks
 * @param {function(Array<LocalTrack>): LocalParticipant} createLocalParticipant
 * @param {function(Array<LocalTrack>): CancelablePromise<RoomSignaling>} createRoomSignaling
 * @param {function(LocalParticipant, RoomSignaling): Room} createRoom
 * @returns CancelablePromise<Room>
 */
function createCancelableRoomPromise(getLocalTracks, createLocalParticipant, createRoomSignaling, createRoom) {
  var cancelableRoomSignalingPromise = void 0;
  var cancellationError = new Error('Canceled');

  return new CancelablePromise(function onCreate(resolve, reject, isCanceled) {
    var localParticipant = void 0;
    getLocalTracks(function getLocalTracksSucceeded(localTracks) {
      if (isCanceled()) {
        return CancelablePromise.reject(cancellationError);
      }
      localParticipant = createLocalParticipant(localTracks);
      return createRoomSignaling(localParticipant).then(function createRoomSignalingSucceeded(getCancelableRoomSignalingPromise) {
        if (isCanceled()) {
          throw cancellationError;
        }
        cancelableRoomSignalingPromise = getCancelableRoomSignalingPromise();
        return cancelableRoomSignalingPromise;
      });
    }).then(function roomSignalingConnected(roomSignaling) {
      if (isCanceled()) {
        roomSignaling.disconnect();
        throw cancellationError;
      }
      resolve(createRoom(localParticipant, roomSignaling));
    }).catch(function onError(error) {
      reject(error);
    });
  }, function onCancel() {
    if (cancelableRoomSignalingPromise) {
      cancelableRoomSignalingPromise.cancel();
    }
  });
}

module.exports = createCancelableRoomPromise;
},{"./util/cancelablepromise":107}],2:[function(require,module,exports){
'use strict';

var _require = require('@twilio/webrtc'),
    MediaStreamTrack = _require.MediaStreamTrack;

var _require2 = require('@twilio/webrtc/lib/util'),
    guessBrowser = _require2.guessBrowser,
    guessBrowserVersion = _require2.guessBrowserVersion;

var createCancelableRoomPromise = require('./cancelableroompromise');
var createLocalTracks = require('./createlocaltracks');
var EncodingParametersImpl = require('./encodingparameters');
var LocalParticipant = require('./localparticipant');

var _require3 = require('./media/track/es5'),
    LocalAudioTrack = _require3.LocalAudioTrack,
    LocalDataTrack = _require3.LocalDataTrack,
    LocalVideoTrack = _require3.LocalVideoTrack;

var NetworkQualityConfigurationImpl = require('./networkqualityconfiguration');
var Room = require('./room');
var SignalingV2 = require('./signaling/v2');

var _require4 = require('./util'),
    asLocalTrack = _require4.asLocalTrack,
    buildLogLevels = _require4.buildLogLevels,
    filterObject = _require4.filterObject,
    isNonArrayObject = _require4.isNonArrayObject;

var _require5 = require('./util/constants'),
    DEFAULT_ENVIRONMENT = _require5.DEFAULT_ENVIRONMENT,
    DEFAULT_LOG_LEVEL = _require5.DEFAULT_LOG_LEVEL,
    DEFAULT_LOGGER_NAME = _require5.DEFAULT_LOGGER_NAME,
    DEFAULT_REALM = _require5.DEFAULT_REALM,
    DEFAULT_REGION = _require5.DEFAULT_REGION,
    WS_SERVER = _require5.WS_SERVER,
    E = _require5.typeErrors;

var CancelablePromise = require('./util/cancelablepromise');
var EventObserver = require('./util/eventobserver');
var DefaultLog = require('./util/log');

var _require6 = require('./util/validate'),
    validateBandwidthProfile = _require6.validateBandwidthProfile;

var safariVersion = guessBrowser() === 'safari' && guessBrowserVersion();

// This is used to make out which connect() call a particular Log statement
// belongs to. Each call to connect() increments this counter.
var connectCalls = 0;

var didPrintSafariWarning = false;
var isSafariWithoutVP8Support = false;

if (safariVersion) {
  var safariMajorVersion = safariVersion.major,
      safariMinorVersion = safariVersion.minor;

  isSafariWithoutVP8Support = safariMajorVersion < 12 || safariMajorVersion === 12 && safariMinorVersion < 1;
}

/**
 * Connect to a {@link Room}.
 *   <br><br>
 *   By default, this will automatically acquire an array containing a
 *   {@link LocalAudioTrack} and {@link LocalVideoTrack} before connecting to
 *   the {@link Room}. These will be stopped when you disconnect from the
 *   {@link Room}.
 *   <br><br>
 *   You can override the default behavior by specifying
 *   <code>options</code>. For example, rather than acquiring a
 *   {@link LocalAudioTrack} and {@link LocalVideoTrack} automatically, you can
 *   pass your own array which you can stop yourself. See {@link ConnectOptions}
 *   for more information.
 * @alias module:twilio-video.connect
 * @param {string} token - The Access Token string
 * @param {ConnectOptions} [options] - Options to override the default behavior
 * @returns {CancelablePromise<Room>}
 * @throws {RangeError}
 * @throws {TwilioError}
 * @throws {TypeError}
 * @example
 * var Video = require('twilio-video');
 * var token = getAccessToken();
 * Video.connect(token, {
 *   name: 'my-cool-room'
 * }).then(function(room) {
 *   room.on('participantConnected', function(participant) {
 *     console.log(participant.identity + ' has connected');
 *   });

 *   room.once('disconnected', function() {
 *     console.log('You left the Room:', room.name);
 *   });
 * }).catch(error => {
 *   console.log('Could not connect to the Room:', error.message);
 * });
 * @example
 * var Video = require('twilio-video');
 * var token = getAccessToken();
 *
 * // Connect with audio-only
 * Video.connect(token, {
 *   name: 'my-cool-room',
 *   audio: true
 * }).then(function(room) {
 *   room.on('participantConnected', function(participant) {
 *     console.log(participant.identity + ' has connected');
 *   });
 *
 *   room.once('disconnected', function() {
 *     console.log('You left the Room:', room.name);
 *   });
 * }).catch(error => {
 *   console.log('Could not connect to the Room:', error.message);
 * });
 * @example
 * var Video = require('twilio-video');
 * var token = getAccessToken();
 *
 * // Connect with media acquired using getUserMedia()
 * navigator.mediaDevices.getUserMedia({
 *   audio: true,
 *   video: true
 * }).then(function(mediaStream) {
 *   return Video.connect(token, {
 *     name: 'my-cool-room',
 *     tracks: mediaStream.getTracks()
 *   });
 * }).then(function(room) {
 *   room.on('participantConnected', function(participant) {
 *     console.log(participant.identity + ' has connected');
 *   });
 *
 *   room.once('disconnected', function() {
 *     console.log('You left the Room:', room.name);
 *   });
 * }).catch(error => {
 *   console.log('Could not connect to the Room:', error.message);
 * });
 * @example
 * var Video = require('twilio-video');
 * var token = getAccessToken();
 *
 * // Connect with custom names for LocalAudioTrack and LocalVideoTrack
 * Video.connect(token, {
 *   name: 'my-cool-room'
 *   audio: { name: 'microphone' },
 *   video: { name: 'camera' }
 * }).then(function(room) {
 *   room.localParticipants.trackPublications.forEach(function(publication) {
 *     console.log('The LocalTrack "' + publication.trackName + '" was successfully published');
 *   });
 * }).catch(error => {
 *   console.log('Could not connect to the Room:', error.message);
 * });
 * @example
 * // Accessing the SDK logger
 * var { Logger, connect } = require('twilio-video');
 * var token = getAccessToken();
 *
 * var logger = Logger.getLogger('twilio-video');
 *
 * // Listen for logs
 * var originalFactory = logger.methodFactory;
 * logger.methodFactory = function (methodName, logLevel, loggerName) {
 *   var method = originalFactory(methodName, logLevel, loggerName);
 *
 *   return function (datetime, logLevel, component, message, data) {
 *     method(datetime, logLevel, component, message, data);
 *     // Send to your own server
 *     postDataToServer(arguments);
 *   };
 * };
 * logger.setLevel('debug');
 *
 * connect(token, {
 *   name: 'my-cool-room'
 * }).then(function(room) {
 *   room.on('participantConnected', function(participant) {
 *     console.log(participant.identity + ' has connected');
 *   });
 * }).catch(error => {
 *   console.log('Could not connect to the Room:', error.message);
 * });
 */
function connect(token, options) {
  if (typeof options === 'undefined') {
    options = {};
  }
  if (!isNonArrayObject(options)) {
    return CancelablePromise.reject(E.INVALID_TYPE('options', 'object'));
  }

  var Log = options.Log || DefaultLog;
  var loggerName = options.loggerName || DEFAULT_LOGGER_NAME;
  var logLevel = options.logLevel || DEFAULT_LOG_LEVEL;
  var logLevels = buildLogLevels(logLevel);
  var logComponentName = '[connect #' + ++connectCalls + ']';

  var log = void 0;
  try {
    log = new Log('default', logComponentName, logLevels, loggerName);
  } catch (error) {
    return CancelablePromise.reject(error);
  }

  // NOTE(csantos): Log a warning for the deprecated ConnectOptions properties.
  // The warning is displayed only for the first call to connect() per browser session.
  // Additionally, the options that are no longer needed will be removed.
  deprecateOptions(options, log);

  options = Object.assign({
    automaticSubscription: true,
    createLocalTracks: createLocalTracks,
    dominantSpeaker: false,
    enableDscp: false,
    environment: DEFAULT_ENVIRONMENT,
    eventListener: null,
    insights: true,
    LocalAudioTrack: LocalAudioTrack,
    LocalDataTrack: LocalDataTrack,
    LocalParticipant: LocalParticipant,
    LocalVideoTrack: LocalVideoTrack,
    Log: Log,
    MediaStreamTrack: MediaStreamTrack,
    loggerName: loggerName,
    logLevel: logLevel,
    maxAudioBitrate: null,
    maxVideoBitrate: null,
    name: null,
    networkMonitor: true,
    networkQuality: false,
    preferredAudioCodecs: [],
    preferredVideoCodecs: [],
    realm: DEFAULT_REALM,
    region: DEFAULT_REGION,
    signaling: SignalingV2
  }, filterObject(options));

  /* eslint new-cap:0 */
  var wsServer = WS_SERVER(options.environment, options.region);
  var eventObserver = new EventObserver(Date.now(), log, options.eventListener);
  options = Object.assign({ eventObserver: eventObserver, wsServer: wsServer }, options);

  options.log = log;

  // NOTE(mroberts): Print the Safari warning once if the log-level is at least
  // "warn", i.e. neither "error" nor "off".
  // NOTE(mmalavalli): Print the Safari warning only for versions 12.0 and below.
  if (isSafariWithoutVP8Support && !didPrintSafariWarning && log.logLevel !== 'error' && log.logLevel !== 'off') {
    didPrintSafariWarning = true;
    log.warn(['Support for Safari 12.0 and below is limited because it does not support VP8.', 'This means you may experience codec issues in Group Rooms. You may also', 'experience codec issues in Peer-to-Peer (P2P) Rooms containing Android- or', 'iOS-based Participants who do not support H.264. However, P2P Rooms', 'with browser-based Participants should work. For more information, please', 'refer to this guide: https://www.twilio.com/docs/video/javascript-v2-developing-safari-11'].join(' '));
  }

  if (typeof token !== 'string') {
    return CancelablePromise.reject(E.INVALID_TYPE('token', 'string'));
  }

  // NOTE(mmalavalli): The Room "name" in "options" was being used
  // as the LocalTrack name in asLocalTrack(). So we pass a copy of
  // "options" without the "name".
  var localTrackOptions = Object.assign({}, options);
  delete localTrackOptions.name;

  if ('tracks' in options) {
    if (!Array.isArray(options.tracks)) {
      return CancelablePromise.reject(E.INVALID_TYPE('options.tracks', 'Array of LocalAudioTrack, LocalVideoTrack or MediaStreamTrack'));
    }
    try {
      options.tracks = options.tracks.map(function (track) {
        return asLocalTrack(track, localTrackOptions);
      });
    } catch (error) {
      return CancelablePromise.reject(error);
    }
  }

  var error = validateBandwidthProfile(options.bandwidthProfile);
  if (error) {
    return CancelablePromise.reject(error);
  }

  var Signaling = options.signaling;
  var signaling = new Signaling(options.wsServer, options);

  log.info('Connecting to a Room');
  log.debug('Options:', options);

  var encodingParameters = new EncodingParametersImpl({
    maxAudioBitrate: options.maxAudioBitrate,
    maxVideoBitrate: options.maxVideoBitrate
  });

  var preferredCodecs = {
    audio: options.preferredAudioCodecs.map(normalizeCodecSettings),
    video: options.preferredVideoCodecs.map(normalizeCodecSettings)
  };

  var networkQualityConfiguration = new NetworkQualityConfigurationImpl(isNonArrayObject(options.networkQuality) ? options.networkQuality : {});

  // Convert options.networkQuality to boolean to configure Media Signaling
  options.networkQuality = isNonArrayObject(options.networkQuality) || options.networkQuality;

  // Create a CancelableRoomPromise<Room> that resolves after these steps:
  // 1 - Get the LocalTracks.
  // 2 - Create the LocalParticipant using options.tracks.
  // 3 - Connect to rtc-room-service and create the RoomSignaling.
  // 4 - Create the Room and then resolve the CancelablePromise.
  var cancelableRoomPromise = createCancelableRoomPromise(getLocalTracks.bind(null, options), createLocalParticipant.bind(null, signaling, log, encodingParameters, networkQualityConfiguration, options), createRoomSignaling.bind(null, token, options, signaling, encodingParameters, preferredCodecs), createRoom.bind(null, options));

  cancelableRoomPromise.then(function (room) {
    log.info('Connected to Room:', room.toString());
    log.info('Room name:', room.name);
    log.debug('Room:', room);
    return room;
  }, function (error) {
    if (cancelableRoomPromise._isCanceled) {
      log.info('Attempt to connect to a Room was canceled');
    } else {
      log.info('Error while connecting to a Room:', error);
    }
  });

  return cancelableRoomPromise;
}

/**
 * You may pass these options to {@link connect} in order to override the
 * default behavior.
 * @typedef {object} ConnectOptions
 * @property {boolean|CreateLocalTrackOptions} [audio=true] - Whether or not to
 *   get local audio with <code>getUserMedia</code> when <code>tracks</code>
 *   are not provided.
 * @property {boolean} [automaticSubscription=true] - By default, you will subscribe
 *   to all RemoteTracks shared by other Participants in a Room. You can now override this
 *   behavior by setting this flag to <code>false</code>. It will make sure that you will
 *   not subscribe to any RemoteTrack in a Group or Small Group Room. Setting it to
 *   <code>true</code>, or not setting it at all preserves the default behavior. This
 *   flag does not have any effect in a Peer-to-Peer Room.
 * @property {BandwidthProfileOptions} [bandwidthProfile] - You can optionally configure
 *   how your available downlink bandwidth is shared among the RemoteTracks you have subscribed
 *   to in a Group Room. By default, bandwidth is shared equally among the RemoteTracks.
 *   This has no effect in Peer-to-Peer Rooms.
 * @property {boolean} [dominantSpeaker=false] - Whether to enable the Dominant
 *   Speaker API or not. This only takes effect in Group Rooms.
 * @property {boolean} [dscpTagging=false] - <code>(deprecated: use "enableDscp" instead)</code>
 *   DSCP tagging allows you to request enhanced QoS treatment for RTP media packets from any
 *   firewall that the client may be behind. Setting this option to <code>true</code> will
 *   request DSCP tagging for media packets on supported browsers (only Chrome supports this
 *   as of now). Audio packets will be sent with DSCP header value set to 0xb8 which corresponds
 *   to Expedited Forwarding (EF). Video packets will be sent with DSCP header value set to 0x88
 *   which corresponds to Assured Forwarding (AF41).
 * @property {boolean} [enableDscp=false] - DSCP tagging allows you to request enhanced
 *   QoS treatment for RTP media packets from any firewall that the client may be behind.
 *   Setting this option to <code>true</code> will request DSCP tagging for media packets
 *   on supported browsers (only Chrome supports this as of now). Audio packets will be
 *   sent with DSCP header value set to 0xb8 which corresponds to Expedited Forwarding (EF).
 *   Video packets will be sent with DSCP header value set to 0x88 which corresponds to
 *   Assured Forwarding (AF41).
 * @property {EventListener} [eventListener] - <code>(deprecated: use [Video.Logger](module-twilio-video.html)</code>
 *   you can listen to fine-grained events related to signaling and media that are
 *   not available in the public APIs. These events might be useful for your own reporting
 *   and diagnostics.
 * @property {Array<RTCIceServer>} iceServers - Override the STUN and TURN
 *   servers used when connecting to {@link Room}s
 * @property {RTCIceTransportPolicy} [iceTransportPolicy="all"] - Override the
 *   ICE transport policy to be one of "relay" or "all"
 * @property {boolean} [insights=true] - Whether publishing events
 *   to the Insights gateway is enabled or not
 * @property {?number} [maxAudioBitrate=null] - Max outgoing audio bitrate (bps);
 *   A <code>null</code> or a <code>0</code> value does not set any bitrate limit;
 *   This value is set as a hint for variable bitrate codecs, but will not take
 *   effect for fixed bitrate codecs; Based on our tests, Chrome, Firefox and Safari
 *   support a bitrate range of 12000 bps to 256000 bps for Opus codec; This parameter
 *   has no effect on iSAC, PCMU and PCMA codecs
 * @property {?number} [maxVideoBitrate=null] - Max outgoing video bitrate (bps);
 *   A <code>null</code> or <code>0</code> value does not set any bitrate limit;
 *   This value is set as a hint for variable bitrate codecs, but will not take
 *   effect for fixed bitrate codecs; Based on our tests, Chrome, Firefox and Safari
 *   all seem to support an average bitrate range of 20000 bps (20 kbps) to
 *   8000000 bps (8 mbps) for a 720p VideoTrack
 * @property {?string} [name=null] - Set to connect to a {@link Room} by name
 * @property {boolean|NetworkQualityConfiguration} [networkQuality=false] - Whether to enable the Network
 *   Quality API or not. This only takes effect in Group Rooms. Pass a {@link NetworkQualityConfiguration}
 *   to configure verbosity levels for network quality information for {@link LocalParticipant}
 *   and {@link RemoteParticipant}s. A <code>true</code> value will set the {@link NetworkQualityVerbosity}
 *   for the {@link LocalParticipant} to {@link NetworkQualityVerbosity}<code style="padding:0 0">#minimal</code>
 *   and the {@link NetworkQualityVerbosity} for {@link RemoteParticipant}s to
 *   {@link NetworkQualityVerbosity}<code style="padding:0 0">#none</code>.
 * @property {string} [region='gll'] - Preferred signaling region; By default, you will be connected to the
 *   nearest signaling server determined by latency based routing. Setting a value other
 *   than <code style="padding:0 0">gll</code> bypasses routing and guarantees that signaling traffic will be
 *   terminated in the region that you prefer. Please refer to this <a href="https://www.twilio.com/docs/video/ip-address-whitelisting#signaling-communication" target="_blank">table</a>
 *   for the list of supported signaling regions.
 * @property {Array<AudioCodec|AudioCodecSettings>} [preferredAudioCodecs=[]] - Preferred audio codecs;
 *  An empty array preserves the current audio codec preference order.
 * @property {Array<VideoCodec|VideoCodecSettings>} [preferredVideoCodecs=[]] -
 *  Preferred video codecs; An empty array preserves the current video codec
 *  preference order. If you want to set a preferred video codec on a Group Room,
 *  you will need to create the Room using the REST API and set the
 *  <code>VideoCodecs</code> property.
 *  See <a href="https://www.twilio.com/docs/api/video/rooms-resource#create-room">
 *  here</a> for more information.
 * @property {LogLevel|LogLevels} [logLevel='warn'] - <code>(deprecated: use [Video.Logger](module-twilio-video.html) instead.
 *   See [examples](module-twilio-video.html#.connect) for details)</code>
 *   Set the default log verbosity
 *   of logging. Passing a {@link LogLevel} string will use the same
 *   level for all components. Pass a {@link LogLevels} to set specific log
 *   levels.
 * @property {string} [loggerName='twilio-video'] - The name of the logger. Use this name when accessing the logger used by the SDK.
 *   See [examples](module-twilio-video.html#.connect) for details.
 * @property {Array<LocalTrack|MediaStreamTrack>} [tracks] - The
 *   {@link LocalTrack}s or MediaStreamTracks with which to join the
 *   {@link Room}. These tracks can be obtained either by calling
 *   {@link createLocalTracks}, or by constructing them from the MediaStream
 *   obtained by calling <code>getUserMedia()</code>.
 * @property {boolean|CreateLocalTrackOptions} [video=true] - Whether or not to
 *   get local video with <code>getUserMedia</code> when <code>tracks</code>
 *   are not provided.
 */

/**
 * {@link BandwidthProfileOptions} allows you to configure how your available downlink
 * bandwidth is shared among the RemoteTracks you have subscribed to in a Group Room.
 * @typedef {object} BandwidthProfileOptions
 * @property {VideoBandwidthProfileOptions} [video] - Optional parameter to configure
 *   how your available downlink bandwidth is shared among the {@link RemoteVideoTrack}s you
 *   have subscribed to in a Group Room.
 */

/**
 * {@link VideoBandwidthProfileOptions} allows you to configure how your available downlink
 * bandwidth is shared among the {@link RemoteVideoTrack}s you have subscribed to in a Group Room.
 * @typedef {object} VideoBandwidthProfileOptions
 * @property {Track.Priority} [dominantSpeakerPriority="standard"] - Optional parameter to
 *   specify the minimum subscribe {@link Track.Priority} of the Dominant Speaker's {@link RemoteVideoTrack}s.
 *   This means that the Dominant Speaker's {@link RemoteVideoTrack}s that are published with
 *   lower {@link Track.Priority} will be subscribed to with the {@link Track.Priority} specified here.
 *   This has no effect on {@link RemoteVideoTrack}s published with higher {@link Track.Priority}, which will
 *   still be subscribed to with with the same {@link Track.Priority}. If not specified, this defaults to "standard".
 *   This parameter only applies to a Group Room Participant when {@link ConnectOptions}.dominantSpeaker is set to true.
 * @property {number} [maxSubscriptionBitrate] - Optional parameter to specify the maximum
 *   downlink video bandwidth in bits per second (bps). By default, there are no limits on
 *   the downlink video bandwidth.
 * @property {number} [maxTracks] - Optional parameter to specify the maximum number of visible
 *   {@link RemoteVideoTrack}s, which will be selected based on {@link Track.Priority} and an N-Loudest
 *   policy. By default there are no limits on the number of visible {@link RemoteVideoTrack}s.
 *   0 or a negative value will remove any limit on the maximum number of visible {@link RemoteVideoTrack}s.
 * @property {BandwidthProfileMode} [mode="grid"] - Optional parameter to specify how the {@link RemoteVideoTrack}s'
 *   TrackPriority values are mapped to bandwidth allocation in Group Rooms. This defaults to "grid",
 *   which results in equal bandwidth share allocation to all {@link RemoteVideoTrack}s.
 * @property {VideoRenderDimensions} [renderDimensions] - Optional parameter to specify the desired
 *   render dimensions of {@link RemoteVideoTrack}s based on {@link Track.Priority} and the
 *   {@link RemoteVideoTrack}s of the Dominant Speaker.
 * @property {TrackSwitchOffMode} [trackSwitchOffMode="predicted"] - Optional parameter to configure
 *   how {@link RemoteVideoTrack}s are switched off in response to bandwidth pressure. Defaults to "predicted".
 */

/**
 * {@link VideoRenderDimensions} allows you to specify the desired render dimensions of {@link RemoteVideoTrack}s
 * based on {@link Track.Priority}. The bandwidth allocation algorithm will distribute the available downlink bandwidth
 * proportional to the requested render dimensions. This is just an input for calculating the bandwidth to be allocated
 * and does not affect the actual resolution of the {@link RemoteVideoTrack}s.
 * @typedef {object} VideoRenderDimensions
 * @property {VideoTrack.Dimensions} [high] - Optional parameter to specify the desired rendering dimensions of
 *   {@link RemoteVideoTrack} whose {@link Track.Priority} is "high". 0 or a negative value will result in the lowest
 *   possible resolution. This defaults to 1280 x 720 (HD).
 * @property {VideoTrack.Dimensions} [low] - Optional parameter to specify the desired rendering dimensions of
 *   {@link RemoteVideoTrack} whose {@link Track.Priority} is "low". 0 or a negative value will result in the lowest
 *   possible resolution. This defaults to 176 x 144 (QCIF).
 * @property {VideoTrack.Dimensions} [standard] - Optional parameter to specify the desired rendering dimensions of
 *   {@link RemoteVideoTrack} whose {@link Track.Priority} is "standard". 0 or a negative value will result in the lowest
 *   possible resolution. This defaults to 640 x 480 (VGA).
 */

/**
 * Configure verbosity levels for network quality information for
 * {@link LocalParticipant} and {@link RemoteParticipant}s.
 * @typedef {object} NetworkQualityConfiguration
 * @property {NetworkQualityVerbosity} [local=1] - Verbosity level for {@link LocalParticipant}
 * @property {NetworkQualityVerbosity} [remote=0] - Verbosity level for {@link RemoteParticipant}s
 */

/**
 * You may pass these levels to {@link ConnectOptions} to override
 * log levels for individual components.
 * @typedef {object} LogLevels
 * @property {LogLevel} [default='warn'] - Log level for 'default' modules.
 * @property {LogLevel} [media='warn'] - Log level for 'media' modules.
 * @property {LogLevel} [signaling='warn'] - Log level for 'signaling' modules.
 * @property {LogLevel} [webrtc='warn'] - Log level for 'webrtc' modules.
 */

/**
 * Audio codec settings.
 * @typedef {object} AudioCodecSettings
 * @property {AudioCodec} codec - Audio codec name
 */

/**
 * Opus codec settings.
 * @typedef {AudioCodecSettings} OpusCodecSettings
 * @property {AudioCodec} name - "opus"
 * @property {boolean} [dtx=true] - Enable/disable discontinuous transmission (DTX);
 *   If enabled all published {@link LocalAudioTrack}s will reduce the outgoing bitrate
 *   to near-zero whenever speech is not detected, resulting in bandwidth and CPU savings;
 *   It defaults to true.
 */

/**
 * Video codec settings.
 * @typedef {object} VideoCodecSettings
 * @property {VideoCodec} codec - Video codec name
 */

/**
 * VP8 codec settings.
 * @typedef {VideoCodecSettings} VP8CodecSettings
 * @property {VideoCodec} name - "VP8"
 * @property {boolean} [simulcast=false] - Enable/disable VP8 simulcast; If
 *   enabled, Twilio's Video SDK will send three video streams of different
 *   qualities
 */

/**
 * Names of the supported audio codecs.
 * @enum {string}
 */
// eslint-disable-next-line
var AudioCodec = {
  isac: 'isac',
  opus: 'opus',
  PCMA: 'PCMA',
  PCMU: 'PCMU'
};

/**
 * Names of the supported video codecs.
 * @enum {string}
 */
// eslint-disable-next-line
var VideoCodec = {
  H264: 'H264',
  VP8: 'VP8',
  VP9: 'VP9'
};

/**
 * Levels for logging verbosity.
 * @enum {string}
 */
// eslint-disable-next-line
var LogLevel = {
  debug: 'debug',
  info: 'info',
  warn: 'warn',
  error: 'error',
  off: 'off'
};

/**
 * The verbosity level of network quality information of a {@link Participant}.
 * @enum {number}
 */
// eslint-disable-next-line
var NetworkQualityVerbosity = {
  /**
   * Nothing is reported for the {@link Participant}. This has no effect and
   * defaults to {@link NetworkQualityVerbosity}<code style="padding:0 0">#minimal</code>
   * for the {@link LocalParticipant}.
   */
  none: 0,
  /**
   * Reports {@link NetworkQualityLevel} for the {@link Participant}.
   */
  minimal: 1,
  /**
   * Reports {@link NetworkQualityLevel} and {@link NetworkQualityStats} for the {@link Participant}.
   * {@link NetworkQualityStats} is populated with audio and video {@link NetworkQualityLevel}s
   * based on which the {@link Participant}'s {@link NetworkQualityLevel} is calculated.
   */
  moderate: 2,
  /**
   * Reports {@link NetworkQualityLevel} and {@link NetworkQualityStats} for the {@link Participant}.
   * {@link NetworkQualityStats} is populated with audio and Video {@link NetworkQualityLevel}s
   * and their corresponding {@link NetworkQualityMediaStats} based on which the
   * {@link Participant}'s {@link NetworkQualityLevel} is calculated.
   */
  detailed: 3
};

/**
 * {@link TrackSwitchOffMode} specifies when {@link RemoteVideoTrack}s' are switched off.
 * @enum {string}
 */
// eslint-disable-next-line
var TrackSwitchOffMode = {
  /**
   * In this mode, {@link RemoteVideoTrack}s are switched off only when network congestion
   * is detected.
   */
  detected: 'detected',

  /**
   * In this mode, {@link RemoteVideoTrack}s are pro-actively switched off when network
   * congestion is predicted by the bandwidth estimation mechanism.
   */
  predicted: 'predicted',

  /**
   * In this mode, {@link RemoteVideoTrack}s are not switched off. Instead in response to network
   * congestion, tracks will be adjusted to lower quality.
   */
  disabled: 'disabled'
};

/**
 * {@link BandwidthProfileMode} specifies how {@link RemoteVideoTrack}s' {@link Track.Priority} values
 * are mapped to bandwidth allocation in Group Rooms.
 * @enum {string}
 */
// eslint-disable-next-line
var BandwidthProfileMode = {
  /**
   * This mode is for use cases where all the subscribed {@link RemoteVideoTrack}s are
   * equally important. The bandwidth allocation algorithm will share the available
   * downlink bandwidth equally among the subscribed {@link RemoteVideoTrack}s, irrespective
   * of their {@link Track.Priority}. In case of insufficient downlink bandwidth, the lower
   * priority {@link RemoteVideoTrack}s are switched off.
   */
  grid: 'grid',
  /**
   * This mode is for use cases where some {@link RemoteVideoTrack}s are prioritized more than
   * others. However, the lower priority {@link RemoteVideoTrack}s still need to be visible.
   * The bandwidth allocation algorithm will share the available downlink bandwidth proportional
   * to the requested {@link VideoRenderDimensions} corresponding to their {@link Track.Priority}.
   * In case of insufficient downlink bandwidth, the quality of higher priority {@link RemoteVideoTrack}s
   * may be degraded to avoid switching off lower priority {@link RemoteVideoTrack}s.
   */
  collaboration: 'collaboration',
  /**
   * This mode is for use cases where some {@link RemoteVideoTrack}s are deemed critical and must
   * be preserved at any cost over the other {@link RemoteVideoTrack}s. The bandwidth allocation
   * algorithm will allocate as big a share of the available downlink bandwidth as it possibly
   * can to the higher priority {@link RemoteVideoTrack}s, and only then consider the lower priority
   * {@link RemoteVideoTrack}s. In case of insufficient downlink bandwidth, the lower priority
   * {@link RemoteVideoTrack}s are switched off in order to preserve the quality of the higher
   * priority {@link RemoteVideoTrack}s.
   */
  presentation: 'presentation'
};

/**
 * Names of the supported levels for {@link EventListenerEvent}s.
 * @enum {string}
 */
// eslint-disable-next-line
var EventListenerLevel = {
  debug: 'debug',
  error: 'error',
  info: 'info',
  warning: 'warning'
};

/**
 * Names of the supported groups for {@link EventListenerEvent}s.
 * @enum {string}
 */
// eslint-disable-next-line
var EventListenerGroup = {
  /**
   * Events associated with the connection to Twilio's signaling server
   */
  signaling: 'signaling'
};

/**
 * An {@link EventListener} allows you to listen to fine-grained {@link EventListenerEvent}s related
 * to signaling and media that are not available in the public APIs, which might be useful for your own
 * reporting and diagnostics.
 * @typedef {EventEmitter} EventListener
 * @example
 * const { EventEmitter } = require('events');
 * const { connect } = require('twilio-video');
 *
 * const eventListener = new EventEmitter();
 * eventListener.on('event', function(event) {
 *   console.log('The SDK raised an event:', event);
 * });
 *
 * connect('token', {
 *   eventListener: eventListener
 * });
 */

/**
 * The SDK raised an {@link EventListenerEvent}.
 * @event EventListener#event
 * @param {EventListenerEvent} event - Context about the event raised by the SDK.
 * This can be one of the following:
 *  * {@link EventListenerClosedEvent}
 *  * {@link EventListenerConnectingEvent}
 *  * {@link EventListenerEarlyEvent}
 *  * {@link EventListenerOpenEvent}
 *  * {@link EventListenerWaitingEvent}
 */

/**
 * An {@link EventListenerEvent} provides context about an event raised by the SDK on the
 * {@link EventListener}. Apart from the properties listed here, it may also include some
 * event-specific data within an optional "payload" property. The different types of
 * {@link EventListenerEvent}s are listed below:
 *  * {@link EventListenerClosedEvent}
 *  * {@link EventListenerConnectingEvent}
 *  * {@link EventListenerEarlyEvent}
 *  * {@link EventListenerOpenEvent}
 *  * {@link EventListenerWaitingEvent}
 * @typedef {object} EventListenerEvent
 * @property {number} elapsedTime - The time elapsed in milliseconds since connect() was called
 * @property {EventListenerGroup} group - The group under which the event is classified
 * @property {EventListenerLevel} level - The verbosity level of the event, which can be one of "debug", "error", "info", "warning"
 * @property {string} name - The name of the event
 * @property {*} [payload] - Optional event-specific data
 * @property {number} timestamp - The time in milliseconds relative to the Unix Epoch when the event was raised
 */

/**
 * The connection to Twilio's signaling server was closed.
 * @typedef {EventListenerEvent} EventListenerClosedEvent
 * @property {EventListenerGroup} group='signaling'
 * @property {EventListenerLevel} level - 'info' if the connection was closed by the client, 'error' otherwise
 * @property {string} name='closed'
 * @property {{reason: string}} payload - Reason for the connection being closed. It can be one of
 *   'busy', 'failed', 'local', 'remote' or 'timeout'
 */

/**
 * The SDK is connecting to Twilio's signaling server.
 * @typedef {EventListenerEvent} EventListenerConnectingEvent
 * @property {EventListenerGroup} group='signaling'
 * @property {EventListenerLevel} level='info'
 * @property {string} name='connecting'
 */

/**
 * The SDK is about to connect to Twilio's signaling server.
 * @typedef {EventListenerEvent} EventListenerEarlyEvent
 * @property {EventListenerGroup} group='signaling'
 * @property {EventListenerLevel} level='info'
 * @property {string} name='early'
 */

/**
 * The SDK has established a signaling connection to Twilio's signaling server.
 * @typedef {EventListenerEvent} EventListenerOpenEvent
 * @property {EventListenerGroup} group='signaling'
 * @property {EventListenerLevel} level='info'
 * @property {string} name='open'
 */

/**
 * The SDK is waiting to retry connecting th Twilio's signaling server. This can
 * happen if the server is busy with too many connection requests.
 * @typedef {EventListenerEvent} EventListenerWaitingEvent
 * @property {EventListenerGroup} group='signaling'
 * @property {EventListenerLevel} level='warning'
 * @property {string} name='waiting'
 */

var deprecatedConnectOptionsProps = new Set([{ didWarn: false, shouldDelete: true, name: 'abortOnIceServersTimeout' }, { didWarn: false, shouldDelete: true, name: 'dscpTagging', newName: 'enableDscp' }, { didWarn: false, shouldDelete: true, name: 'iceServersTimeout' }, { didWarn: false, shouldDelete: false, name: 'eventListener', newName: 'Video.Logger' }, { didWarn: false, shouldDelete: false, name: 'logLevel', newName: 'Video.Logger' }]);

function deprecateOptions(options, log) {
  deprecatedConnectOptionsProps.forEach(function (prop) {
    var didWarn = prop.didWarn,
        name = prop.name,
        newName = prop.newName,
        shouldDelete = prop.shouldDelete;

    if (name in options && typeof options[name] !== 'undefined') {
      if (newName && shouldDelete) {
        options[newName] = options[name];
      }
      if (shouldDelete) {
        delete options[name];
      }
      if (!didWarn && !['error', 'off'].includes(log.level)) {
        log.warn('The ConnectOptions "' + name + '" is ' + (newName ? 'deprecated and scheduled for removal. Please use "' + newName + '" instead.' : 'no longer applicable and will be ignored.'));
        prop.didWarn = true;
      }
    }
  });
}

function createLocalParticipant(signaling, log, encodingParameters, networkQualityConfiguration, options, localTracks) {
  var localParticipantSignaling = signaling.createLocalParticipantSignaling(encodingParameters, networkQualityConfiguration);
  log.debug('Creating a new LocalParticipant:', localParticipantSignaling);
  return new options.LocalParticipant(localParticipantSignaling, localTracks, options);
}

function createRoom(options, localParticipant, roomSignaling) {
  var room = new Room(localParticipant, roomSignaling, options);
  var log = options.log;

  log.debug('Creating a new Room:', room);
  roomSignaling.on('stateChanged', function stateChanged(state) {
    if (state === 'disconnected') {
      log.info('Disconnected from Room:', room.toString());
      roomSignaling.removeListener('stateChanged', stateChanged);
    }
  });

  return room;
}

function createRoomSignaling(token, options, signaling, encodingParameters, preferredCodecs, localParticipant) {
  options.log.debug('Creating a new RoomSignaling');
  return signaling.connect(localParticipant._signaling, token, encodingParameters, preferredCodecs, options);
}

function getLocalTracks(options, handleLocalTracks) {
  var log = options.log;

  options.shouldStopLocalTracks = !options.tracks;
  if (options.shouldStopLocalTracks) {
    log.info('LocalTracks were not provided, so they will be acquired ' + 'automatically before connecting to the Room. LocalTracks will ' + 'be released if connecting to the Room fails or if the Room ' + 'is disconnected');
  } else {
    log.info('Getting LocalTracks');
    log.debug('Options:', options);
  }

  return options.createLocalTracks(options).then(function getLocalTracksSucceeded(localTracks) {
    var promise = handleLocalTracks(localTracks);

    promise.catch(function handleLocalTracksFailed() {
      if (options.shouldStopLocalTracks) {
        log.info('The automatically acquired LocalTracks will now be stopped');
        localTracks.forEach(function (track) {
          track.stop();
        });
      }
    });

    return promise;
  });
}

function normalizeCodecSettings(nameOrSettings) {
  var settings = typeof nameOrSettings === 'string' ? { codec: nameOrSettings } : nameOrSettings;
  switch (settings.codec.toLowerCase()) {
    case 'opus':
      {
        return Object.assign({ dtx: true }, settings);
      }
    case 'vp8':
      {
        return Object.assign({ simulcast: false }, settings);
      }
    default:
      {
        return settings;
      }
  }
}

module.exports = connect;
},{"./cancelableroompromise":1,"./createlocaltracks":4,"./encodingparameters":9,"./localparticipant":12,"./media/track/es5":14,"./networkqualityconfiguration":41,"./room":45,"./signaling/v2":59,"./util":114,"./util/cancelablepromise":107,"./util/constants":108,"./util/eventobserver":112,"./util/log":118,"./util/validate":130,"@twilio/webrtc":136,"@twilio/webrtc/lib/util":149}],3:[function(require,module,exports){
'use strict';

var defaultCreateLocalTracks = require('./createlocaltracks');

var _require = require('./util/constants'),
    DEFAULT_LOG_LEVEL = _require.DEFAULT_LOG_LEVEL,
    DEFAULT_LOGGER_NAME = _require.DEFAULT_LOGGER_NAME;

/**
 * Request a {@link LocalAudioTrack} or {@link LocalVideoTrack}.
 * @param {Track.Kind} kind - "audio" or "video"
 * @param {CreateLocalTrackOptions} [options]
 * @returns {Promise<LocalAudioTrack|LocalVideoTrack>}
 * @private
 */


function createLocalTrack(kind, options) {
  options = Object.assign({
    createLocalTracks: defaultCreateLocalTracks,
    loggerName: DEFAULT_LOGGER_NAME,
    logLevel: DEFAULT_LOG_LEVEL
  }, options);

  var createOptions = {};
  createOptions.loggerName = options.loggerName;
  createOptions.logLevel = options.logLevel;
  delete options.loggerName;
  delete options.logLevel;

  var createLocalTracks = options.createLocalTracks;
  delete options.createLocalTracks;
  createOptions[kind] = Object.keys(options).length > 0 ? options : true;

  return createLocalTracks(createOptions).then(function (localTracks) {
    return localTracks[0];
  });
}

/**
 * Request a {@link LocalAudioTrack}.
 * @alias module:twilio-video.createLocalAudioTrack
 * @param {CreateLocalTrackOptions} [options] - Options for requesting a {@link LocalAudioTrack}
 * @returns {Promise<LocalAudioTrack>}
 * @example
 * var Video = require('twilio-video');
 *
 * // Connect to the Room with just video
 * Video.connect('my-token', {
 *   name: 'my-cool-room',
 *   video: true
 * }).then(function(room) {
 *   // Add audio after connecting to the Room
 *   Video.createLocalAudioTrack().then(function(localTrack) {
 *     room.localParticipant.publishTrack(localTrack);
 *   });
 * });
 * @example
 * var Video = require('twilio-video');
 *
 * // Request the default LocalAudioTrack with a custom name
 * Video.createLocalAudioTrack({ name: 'microphone' }).then(function(localTrack) {
 *   console.log(localTrack.name); // 'microphone'
 * });
 */
function createLocalAudioTrack(options) {
  return createLocalTrack('audio', options);
}

/**
 * Request a {@link LocalVideoTrack}. Note that on mobile browsers,
 * the camera can be reserved by only one {@link LocalVideoTrack} at any given
 * time. If you attempt to create a second {@link LocalVideoTrack}, video frames
 * will no longer be supplied to the first {@link LocalVideoTrack}.
 * @alias module:twilio-video.createLocalVideoTrack
 * @param {CreateLocalTrackOptions} [options] - Options for requesting a {@link LocalVideoTrack}
 * @returns {Promise<LocalVideoTrack>}
 * @example
 * var Video = require('twilio-video');
 *
 * // Connect to the Room with just audio
 * Video.connect('my-token', {
 *   name: 'my-cool-room',
 *   audio: true
 * }).then(function(room) {
 *   // Add video after connecting to the Room
 *   Video.createLocalVideoTrack().then(function(localTrack) {
 *     room.localParticipant.publishTrack(localTrack);
 *   });
 * });
 * @example
 * var Video = require('twilio-video');
 *
 * // Request the default LocalVideoTrack with a custom name
 * Video.createLocalVideoTrack({ name: 'camera' }).then(function(localTrack) {
 *   console.log(localTrack.name); // 'camera'
 * });
 */
function createLocalVideoTrack(options) {
  return createLocalTrack('video', options);
}

/**
 * Create {@link LocalTrack} options. Apart from the properties listed here, you can
 * also specify any of the <a href="https://developer.mozilla.org/en-US/docs/Web/API/MediaTrackConstraints" target="_blank">MediaTrackConstraints</a>
 * properties.
 * @typedef {MediaTrackConstraints} CreateLocalTrackOptions
 * @property {LogLevel|LogLevels} [logLevel='warn'] - <code>(deprecated: use [Video.Logger](module-twilio-video.html) instead.
 *   See [examples](module-twilio-video.html#.connect) for details)</code>
 *   Set the default log verbosity
 *   of logging. Passing a {@link LogLevel} string will use the same
 *   level for all components. Pass a {@link LogLevels} to set specific log
 *   levels.
 * @property {string} [loggerName='twilio-video'] - The name of the logger. Use this name when accessing the logger used by the SDK.
 *   See [examples](module-twilio-video.html#.connect) for details.
 * @property {string} [name] - The {@link LocalTrack}'s name; by default,
 *   it is set to the {@link LocalTrack}'s ID.
 * @property {boolean} [workaroundWebKitBug180748=false] - Only valid for
 *   {@link LocalAudioTrack}s; setting this attempts to workaround WebKit Bug
 *   180748, where, in Safari, getUserMedia may return a silent audio
 *   MediaStreamTrack.
 */

module.exports = {
  audio: createLocalAudioTrack,
  video: createLocalVideoTrack
};
},{"./createlocaltracks":4,"./util/constants":108}],4:[function(require,module,exports){
'use strict';

var asLocalTrack = require('./util').asLocalTrack;
var buildLogLevels = require('./util').buildLogLevels;
var getUserMedia = require('@twilio/webrtc').getUserMedia;

var _require = require('./media/track/es5'),
    LocalAudioTrack = _require.LocalAudioTrack,
    LocalDataTrack = _require.LocalDataTrack,
    LocalVideoTrack = _require.LocalVideoTrack;

var MediaStreamTrack = require('@twilio/webrtc').MediaStreamTrack;
var Log = require('./util/log');

var _require2 = require('./util/constants'),
    DEFAULT_LOG_LEVEL = _require2.DEFAULT_LOG_LEVEL,
    DEFAULT_LOGGER_NAME = _require2.DEFAULT_LOGGER_NAME;

var workaround180748 = require('./webaudio/workaround180748');

// This is used to make out which createLocalTracks() call a particular Log
// statement belongs to. Each call to createLocalTracks() increments this
// counter.
var createLocalTrackCalls = 0;

/**
 * Request {@link LocalTrack}s. By default, it requests a
 * {@link LocalAudioTrack} and a {@link LocalVideoTrack}.
 * Note that on mobile browsers, the camera can be reserved by only one {@link LocalVideoTrack}
 * at any given time. If you attempt to create a second {@link LocalVideoTrack}, video frames
 * will no longer be supplied to the first {@link LocalVideoTrack}.
 * @alias module:twilio-video.createLocalTracks
 * @param {CreateLocalTracksOptions} [options]
 * @returns {Promise<Array<LocalTrack>>}
 * @example
 * var Video = require('twilio-video');
 * // Request audio and video tracks
 * Video.createLocalTracks().then(function(localTracks) {
 *   var localMediaContainer = document.getElementById('local-media-container-id');
 *   localTracks.forEach(function(track) {
 *     localMediaContainer.appendChild(track.attach());
 *   });
 * });
 * @example
 * var Video = require('twilio-video');
 * // Request just the default audio track
 * Video.createLocalTracks({ audio: true }).then(function(localTracks) {
 *   return Video.connect('my-token', {
 *     name: 'my-cool-room',
 *     tracks: localTracks
 *   });
 * });
 * @example
 * var Video = require('twilio-video');
 * // Request the audio and video tracks with custom names
 * Video.createLocalTracks({
 *   audio: { name: 'microphone' },
 *   video: { name: 'camera' }
 * }).then(function(localTracks) {
 *   localTracks.forEach(function(localTrack) {
 *     console.log(localTrack.name);
 *   });
 * });
 *
 * @example
 * var Video = require('twilio-video');
 * var localTracks;
 *
 * // Pre-acquire tracks to display camera preview.
 * Video.createLocalTracks().then(function(tracks) {
 *  localTracks = tracks;
 *  var localVideoTrack = localTracks.find(track => track.kind === 'video');
 *  divContainer.appendChild(localVideoTrack.attach());
 * })
 *
 * // Later, join the Room with the pre-acquired LocalTracks.
 * Video.connect('token', {
 *   name: 'my-cool-room',
 *   tracks: localTracks
 * });
 *
 */
function createLocalTracks(options) {
  var isAudioVideoAbsent = !(options && ('audio' in options || 'video' in options));

  options = Object.assign({
    audio: isAudioVideoAbsent,
    getUserMedia: getUserMedia,
    loggerName: DEFAULT_LOGGER_NAME,
    logLevel: DEFAULT_LOG_LEVEL,
    LocalAudioTrack: LocalAudioTrack,
    LocalDataTrack: LocalDataTrack,
    LocalVideoTrack: LocalVideoTrack,
    MediaStreamTrack: MediaStreamTrack,
    Log: Log,
    video: isAudioVideoAbsent
  }, options);

  var logComponentName = '[createLocalTracks #' + ++createLocalTrackCalls + ']';
  var logLevels = buildLogLevels(options.logLevel);
  var log = new options.Log('default', logComponentName, logLevels, options.loggerName);

  // NOTE(mmalavalli): The Room "name" in "options" was being used
  // as the LocalTrack name in asLocalTrack(). So we pass a copy of
  // "options" without the "name".
  var localTrackOptions = Object.assign({ log: log }, options);
  delete localTrackOptions.name;

  if (options.audio === false && options.video === false) {
    log.info('Neither audio nor video requested, so returning empty LocalTracks');
    return Promise.resolve([]);
  }

  if (options.tracks) {
    log.info('Adding user-provided LocalTracks');
    log.debug('LocalTracks:', options.tracks);
    return Promise.resolve(options.tracks);
  }

  var extraLocalTrackOptions = {
    audio: options.audio && options.audio.name ? { name: options.audio.name } : {},
    video: options.video && options.video.name ? { name: options.video.name } : {}
  };

  extraLocalTrackOptions.audio.isCreatedByCreateLocalTracks = true;
  extraLocalTrackOptions.video.isCreatedByCreateLocalTracks = true;

  if (options.audio && typeof options.audio.workaroundWebKitBug1208516 === 'boolean') {
    extraLocalTrackOptions.audio.workaroundWebKitBug1208516 = options.audio.workaroundWebKitBug1208516;
  }

  if (options.video && typeof options.video.workaroundWebKitBug1208516 === 'boolean') {
    extraLocalTrackOptions.video.workaroundWebKitBug1208516 = options.video.workaroundWebKitBug1208516;
  }

  if (options.audio) {
    delete options.audio.name;
  }
  if (options.video) {
    delete options.video.name;
  }

  var mediaStreamConstraints = {
    audio: options.audio,
    video: options.video
  };

  var workaroundWebKitBug180748 = options.audio && options.audio.workaroundWebKitBug180748;

  var mediaStreamPromise = workaroundWebKitBug180748 ? workaround180748(log, options.getUserMedia, mediaStreamConstraints) : options.getUserMedia(mediaStreamConstraints);

  return mediaStreamPromise.then(function (mediaStream) {
    var mediaStreamTracks = mediaStream.getAudioTracks().concat(mediaStream.getVideoTracks());

    log.info('Call to getUserMedia successful; got MediaStreamTracks:', mediaStreamTracks);

    return mediaStreamTracks.map(function (mediaStreamTrack) {
      return asLocalTrack(mediaStreamTrack, Object.assign(extraLocalTrackOptions[mediaStreamTrack.kind], localTrackOptions));
    });
  }, function (error) {
    log.warn('Call to getUserMedia failed:', error);
    throw error;
  });
}

/**
 * {@link createLocalTracks} options
 * @typedef {object} CreateLocalTracksOptions
 * @property {boolean|CreateLocalTrackOptions} [audio=true] - Whether or not to
 *   get local audio with <code>getUserMedia</code> when <code>tracks</code>
 *   are not provided.
 * @property {LogLevel|LogLevels} [logLevel='warn'] - <code>(deprecated: use [Video.Logger](module-twilio-video.html) instead.
 *   See [examples](module-twilio-video.html#.connect) for details)</code>
 *   Set the default log verbosity
 *   of logging. Passing a {@link LogLevel} string will use the same
 *   level for all components. Pass a {@link LogLevels} to set specific log
 *   levels.
 * @property {string} [loggerName='twilio-video'] - The name of the logger. Use this name when accessing the logger used by the SDK.
 *   See [examples](module-twilio-video.html#.connect) for details.
 * @property {boolean|CreateLocalTrackOptions} [video=true] - Whether or not to
 *   get local video with <code>getUserMedia</code> when <code>tracks</code>
 *   are not provided.
 */

module.exports = createLocalTracks;
},{"./media/track/es5":14,"./util":114,"./util/constants":108,"./util/log":118,"./webaudio/workaround180748":133,"@twilio/webrtc":136}],5:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var DataTrackTransceiver = require('./transceiver');
var DataTransport = require('./transport');

/**
 * A {@link DataTrackReceiver} represents a {@link DataTrackTransceiver} over
 * which data can be received. Internally, it users a single RTCDataChannel to
 * receive data.
 * @extends DataTrackTransceiver
 * @emits DataTrackReceiver#message
 * @emits DataTrackReceiver#close
 */

var DataTrackReceiver = function (_DataTrackTransceiver) {
  _inherits(DataTrackReceiver, _DataTrackTransceiver);

  /**
   * Construct an {@link DataTrackReceiver}.
   * @param {RTCDataChannel} dataChannel
   */
  function DataTrackReceiver(dataChannel) {
    _classCallCheck(this, DataTrackReceiver);

    var _this = _possibleConstructorReturn(this, (DataTrackReceiver.__proto__ || Object.getPrototypeOf(DataTrackReceiver)).call(this, dataChannel.label, dataChannel.maxPacketLifeTime, dataChannel.maxRetransmits, dataChannel.ordered));

    Object.defineProperties(_this, {
      _dataChannel: {
        value: dataChannel
      }
    });

    // NOTE(mmalavalli): In Firefox, the default value for "binaryType" is "blob".
    // So, we set it to "arraybuffer" to ensure that it is consistent with Chrome
    // and Safari.
    dataChannel.binaryType = 'arraybuffer';

    dataChannel.addEventListener('message', function (event) {
      _this.emit('message', event.data);
    });

    dataChannel.addEventListener('close', function () {
      _this.emit('close');
    });
    return _this;
  }

  _createClass(DataTrackReceiver, [{
    key: 'stop',
    value: function stop() {
      this._dataChannel.close();
      _get(DataTrackReceiver.prototype.__proto__ || Object.getPrototypeOf(DataTrackReceiver.prototype), 'stop', this).call(this);
    }

    /**
     * Create a {@link DataTransport} from the {@link DataTrackReceiver}.
     * @returns {DataTransport}
     */

  }, {
    key: 'toDataTransport',
    value: function toDataTransport() {
      return new DataTransport(this._dataChannel);
    }
  }]);

  return DataTrackReceiver;
}(DataTrackTransceiver);

/**
 * @event DataTrackReceiver#message
 * @param {string|ArrayBuffer} data
 */

/**
 * @event DataTrackReceiver#close
 */

module.exports = DataTrackReceiver;
},{"./transceiver":7,"./transport":8}],6:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var DataTrackTransceiver = require('./transceiver');
var makeUUID = require('../util').makeUUID;

/**
 * A {@link DataTrackSender} represents a {@link DataTrackTransceiver} over
 * which data can be sent. Internally, it uses a collection of RTCDataChannels
 * to send data.
 * @extends DataTrackTransceiver
 */

var DataTrackSender = function (_DataTrackTransceiver) {
  _inherits(DataTrackSender, _DataTrackTransceiver);

  /**
   * Construct a {@link DataTrackSender}.
   * @param {?number} maxPacketLifeTime
   * @param {?number} maxRetransmits
   * @param {boolean} ordered
   */
  function DataTrackSender(maxPacketLifeTime, maxRetransmtis, ordered) {
    _classCallCheck(this, DataTrackSender);

    var _this = _possibleConstructorReturn(this, (DataTrackSender.__proto__ || Object.getPrototypeOf(DataTrackSender)).call(this, makeUUID(), maxPacketLifeTime, maxRetransmtis, ordered));

    Object.defineProperties(_this, {
      _clones: {
        value: new Set()
      },
      _dataChannels: {
        value: new Set()
      }
    });
    return _this;
  }

  /**
   * Add a cloned {@link DataTrackSender}.
   * @private
   * @returns {void}
   */


  _createClass(DataTrackSender, [{
    key: '_addClone',
    value: function _addClone(clone) {
      this._clones.add(clone);
    }

    /**
     * Remove a cloned {@link DataTrackSender}.
     * @returns {void}
     */

  }, {
    key: 'removeClone',
    value: function removeClone(clone) {
      this._clones.delete(clone);
    }

    /**
     * Add an RTCDataChannel to the {@link DataTrackSender}.
     * @param {RTCDataChannel} dataChannel
     * @returns {this}
     */

  }, {
    key: 'addDataChannel',
    value: function addDataChannel(dataChannel) {
      this._dataChannels.add(dataChannel);
      return this;
    }

    /**
     * Return a new {@link DataTrackSender}. Any message sent over this
     * {@link DataTrackSender} will also be sent over the clone. Whenever this
     * {@link DataTrackSender} is stopped, so to will the clone.
     * @returns {DataTrackSender}
     */

  }, {
    key: 'clone',
    value: function clone() {
      var _this2 = this;

      var clone = new DataTrackSender(this.maxPacketLifeTime, this.maxRetransmits, this.ordered);
      this._addClone(clone);
      clone.once('stopped', function () {
        return _this2.removeClone(clone);
      });
      return clone;
    }

    /**
     * Remove an RTCDataChannel from the {@link DataTrackSender}.
     * @param {RTCDataChannel} dataChannel
     * @returns {this}
     */

  }, {
    key: 'removeDataChannel',
    value: function removeDataChannel(dataChannel) {
      this._dataChannels.delete(dataChannel);
      return this;
    }

    /**
     * Send data over the {@link DataTrackSender}. Internally, this calls
     * <code>send</code> over each of the underlying RTCDataChannels.
     * @param {string|Blob|ArrayBuffer|ArrayBufferView} data
     * @returns {this}
     */

  }, {
    key: 'send',
    value: function send(data) {
      this._dataChannels.forEach(function (dataChannel) {
        try {
          dataChannel.send(data);
        } catch (error) {
          // Do nothing.
        }
      });
      this._clones.forEach(function (clone) {
        try {
          clone.send(data);
        } catch (error) {
          // Do nothing.
        }
      });
      return this;
    }
  }, {
    key: 'stop',
    value: function stop() {
      this._dataChannels.forEach(function (dataChannel) {
        return dataChannel.close();
      });
      this._clones.forEach(function (clone) {
        return clone.stop();
      });
      _get(DataTrackSender.prototype.__proto__ || Object.getPrototypeOf(DataTrackSender.prototype), 'stop', this).call(this);
    }
  }]);

  return DataTrackSender;
}(DataTrackTransceiver);

module.exports = DataTrackSender;
},{"../util":114,"./transceiver":7}],7:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TrackTransceiver = require('../transceiver');

/**
 * A {@link DataTrackTransceiver} represents either one or more local
 * RTCDataChannels or a single remote RTCDataChannel. It can be used to send or
 * receive data.
 * @extends TrackTransceiver
 * @property {string} id
 * @property {string} kind - "data"
 * @property {?number} maxPacketLifeTime
 * @property {?number} maxRetransmits
 * @property {boolean} ordered
 */

var DataTrackTransceiver = function (_TrackTransceiver) {
  _inherits(DataTrackTransceiver, _TrackTransceiver);

  /**
   * Construct a {@link DataTrackTransceiver}.
   * @param {string} id
   * @param {?number} maxPacketLifeTime
   * @param {?number} maxRetransmits
   * @param {boolean} ordered
   */
  function DataTrackTransceiver(id, maxPacketLifeTime, maxRetransmits, ordered) {
    _classCallCheck(this, DataTrackTransceiver);

    var _this = _possibleConstructorReturn(this, (DataTrackTransceiver.__proto__ || Object.getPrototypeOf(DataTrackTransceiver)).call(this, id, 'data'));

    Object.defineProperties(_this, {
      maxPacketLifeTime: {
        enumerable: true,
        value: maxPacketLifeTime
      },
      maxRetransmits: {
        enumerable: true,
        value: maxRetransmits
      },
      ordered: {
        enumerable: true,
        value: ordered
      }
    });
    return _this;
  }

  return DataTrackTransceiver;
}(TrackTransceiver);

module.exports = DataTrackTransceiver;
},{"../transceiver":104}],8:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('events'),
    EventEmitter = _require.EventEmitter;

/**
 * @classdesc A {@link DataTransport} implements {@link MediaSignalingTransport}
 *   in terms of an RTCDataChannel.
 * @extends EventEmitter
 * @implements MediaSignalingTransport
 * @emits DataTransport#message
 */


var DataTransport = function (_EventEmitter) {
  _inherits(DataTransport, _EventEmitter);

  /**
   * Construct a {@link DataTransport}.
   * @param {RTCDataChannel} dataChannel
   */
  function DataTransport(dataChannel) {
    _classCallCheck(this, DataTransport);

    var _this = _possibleConstructorReturn(this, (DataTransport.__proto__ || Object.getPrototypeOf(DataTransport)).call(this));

    Object.defineProperties(_this, {
      _dataChannel: {
        value: dataChannel
      },
      _messageQueue: {
        value: []
      }
    });

    dataChannel.addEventListener('open', function () {
      _this._messageQueue.splice(0).forEach(function (message) {
        return _this._publish(message);
      });
    });

    dataChannel.addEventListener('message', function (_ref) {
      var data = _ref.data;

      try {
        var message = JSON.parse(data);
        _this.emit('message', message);
      } catch (error) {
        // Do nothing.
      }
    });

    _this.publish({ type: 'ready' });
    return _this;
  }

  /**
   * @param message
   * @private
   */


  _createClass(DataTransport, [{
    key: '_publish',
    value: function _publish(message) {
      var data = JSON.stringify(message);
      try {
        this._dataChannel.send(data);
      } catch (error) {
        // Do nothing.
      }
    }

    /**
     * Publish a message. Returns true if calling the method resulted in
     * publishing (or eventually publishing) the update.
     * @param {object} message
     * @returns {boolean}
     */

  }, {
    key: 'publish',
    value: function publish(message) {
      var dataChannel = this._dataChannel;
      if (dataChannel.readyState === 'closing' || dataChannel.readyState === 'closed') {
        return false;
      }
      if (dataChannel.readyState === 'connecting') {
        this._messageQueue.push(message);
        return true;
      }
      this._publish(message);
      return true;
    }
  }]);

  return DataTransport;
}(EventEmitter);

/**
 * The {@link DataTransport} received a message.
 * @event DataTransport#message
 * @param {object} message
 */

module.exports = DataTransport;
},{"events":165}],9:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EventEmitter = require('events').EventEmitter;

/**
 * {@link EncodingParametersImpl} represents an object which notifies its
 * listeners of any changes in the values of its properties.
 * @extends EventEmitter
 * @implements EncodingParameters
 * @emits EncodingParametersImpl#changed
 * @property {?number} maxAudioBitrate
 * @property {?number} maxVideoBitrate
 */

var EncodingParametersImpl = function (_EventEmitter) {
  _inherits(EncodingParametersImpl, _EventEmitter);

  /**
   * Construct an {@link EncodingParametersImpl}.
   * @param {EncodingParamters} encodingParameters - Initial {@link EncodingParameters}
   */
  function EncodingParametersImpl(encodingParameters) {
    _classCallCheck(this, EncodingParametersImpl);

    var _this = _possibleConstructorReturn(this, (EncodingParametersImpl.__proto__ || Object.getPrototypeOf(EncodingParametersImpl)).call(this));

    encodingParameters = Object.assign({
      maxAudioBitrate: null,
      maxVideoBitrate: null
    }, encodingParameters);

    Object.defineProperties(_this, {
      maxAudioBitrate: {
        value: encodingParameters.maxAudioBitrate,
        writable: true
      },
      maxVideoBitrate: {
        value: encodingParameters.maxVideoBitrate,
        writable: true
      }
    });
    return _this;
  }

  /**
   * Returns the bitrate values in an {@link EncodingParameters}.
   * @returns {EncodingParameters}
   */


  _createClass(EncodingParametersImpl, [{
    key: 'toJSON',
    value: function toJSON() {
      return {
        maxAudioBitrate: this.maxAudioBitrate,
        maxVideoBitrate: this.maxVideoBitrate
      };
    }

    /**
     * Update the bitrate values with those in the given {@link EncodingParameters}.
     * @param {EncodingParameters} encodingParameters - The new {@link EncodingParameters}
     * @fires EncodingParametersImpl#changed
     */

  }, {
    key: 'update',
    value: function update(encodingParameters) {
      var _this2 = this;

      encodingParameters = Object.assign({
        maxAudioBitrate: this.maxAudioBitrate,
        maxVideoBitrate: this.maxVideoBitrate
      }, encodingParameters);

      var shouldEmitChanged = ['maxAudioBitrate', 'maxVideoBitrate'].reduce(function (shouldEmitChanged, maxKindBitrate) {
        if (_this2[maxKindBitrate] !== encodingParameters[maxKindBitrate]) {
          _this2[maxKindBitrate] = encodingParameters[maxKindBitrate];
          shouldEmitChanged = true;
        }
        return shouldEmitChanged;
      }, false);

      if (shouldEmitChanged) {
        this.emit('changed');
      }
    }
  }]);

  return EncodingParametersImpl;
}(EventEmitter);

/**
 * At least one of the {@link EncodingParametersImpl}'s bitrate values changed.
 * @event EncodingParametersImpl#changed
 */

module.exports = EncodingParametersImpl;
},{"events":165}],10:[function(require,module,exports){
'use strict';

var _require = require('events'),
    EventEmitter = _require.EventEmitter;

var _require2 = require('./util'),
    hidePrivateAndCertainPublicPropertiesInClass = _require2.hidePrivateAndCertainPublicPropertiesInClass;

module.exports = hidePrivateAndCertainPublicPropertiesInClass(EventEmitter, ['domain']);
},{"./util":114,"events":165}],11:[function(require,module,exports){
'use strict';

var _require = require('./media/track/es5'),
    LocalAudioTrack = _require.LocalAudioTrack,
    LocalDataTrack = _require.LocalDataTrack,
    LocalVideoTrack = _require.LocalVideoTrack;

/**
 * @module twilio-video
 * @property {boolean} isSupported - true if the current browser is officially
 *   supported by twilio-video.js; In this context, "supported" means that
 *   twilio-video.js has been extensively tested with this browser; This
 *   <a href="https://www.twilio.com/docs/video/javascript#supported-browsers" target="_blank">table</a>
 *   specifies the list of officially supported browsers.
 *
 * @property {object} Logger - The <a href="https://www.npmjs.com/package/loglevel" target="_blank">loglevel</a>
 *    module used by the SDK. Use this object to access the internal loggers and perform actions as defined by the
 *   <a href="https://www.npmjs.com/package/loglevel" target="_blank">loglevel</a> APIs.
 *   See [connect](#.connect) for examples.
 *
 * @property {string} version - current version of twilio-video.js.
 */


var version = require('../package.json').version;
var Video = {};

Object.defineProperties(Video, {
  connect: {
    enumerable: true,
    value: require('./connect')
  },
  createLocalAudioTrack: {
    enumerable: true,
    value: require('./createlocaltrack').audio
  },
  createLocalTracks: {
    enumerable: true,
    value: require('./createlocaltracks')
  },
  createLocalVideoTrack: {
    enumerable: true,
    value: require('./createlocaltrack').video
  },
  isSupported: {
    enumerable: true,
    value: require('./util/support')()
  },
  LocalAudioTrack: {
    enumerable: true,
    value: LocalAudioTrack
  },
  LocalDataTrack: {
    enumerable: true,
    value: LocalDataTrack
  },
  LocalVideoTrack: {
    enumerable: true,
    value: LocalVideoTrack
  },
  Logger: {
    enumerable: true,
    value: require('loglevel')
  },
  version: {
    enumerable: true,
    value: version
  }
});

module.exports = Video;
},{"../package.json":184,"./connect":2,"./createlocaltrack":3,"./createlocaltracks":4,"./media/track/es5":14,"./util/support":126,"loglevel":175}],12:[function(require,module,exports){
'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('@twilio/webrtc'),
    MediaStreamTrack = _require.MediaStreamTrack;

var _require2 = require('./util'),
    asLocalTrack = _require2.asLocalTrack,
    asLocalTrackPublication = _require2.asLocalTrackPublication,
    trackClass = _require2.trackClass;

var _require3 = require('./util/constants'),
    E = _require3.typeErrors,
    trackPriority = _require3.trackPriority;

var _require4 = require('./util/validate'),
    validateLocalTrack = _require4.validateLocalTrack;

var _require5 = require('./media/track/es5'),
    LocalAudioTrack = _require5.LocalAudioTrack,
    LocalDataTrack = _require5.LocalDataTrack,
    LocalVideoTrack = _require5.LocalVideoTrack;

var LocalAudioTrackPublication = require('./media/track/localaudiotrackpublication');
var LocalDataTrackPublication = require('./media/track/localdatatrackpublication');
var LocalVideoTrackPublication = require('./media/track/localvideotrackpublication');
var Participant = require('./participant');

/**
 * A {@link LocalParticipant} represents the local {@link Participant} in a
 * {@link Room}.
 * @extends Participant
 * @property {Map<Track.SID, LocalAudioTrackPublication>} audioTracks -
 *    The {@link LocalParticipant}'s {@link LocalAudioTrackPublication}s
 * @property {Map<Track.SID, LocalDataTrackPublication>} dataTracks -
 *    The {@link LocalParticipant}'s {@link LocalDataTrackPublication}s
 * @property {Map<Track.SID, LocalTrackPublication>} tracks -
 *    The {@link LocalParticipant}'s {@link LocalTrackPublication}s
 * @property {Map<Track.SID, LocalVideoTrackPublication>} videoTracks -
 *    The {@link LocalParticipant}'s {@link LocalVideoTrackPublication}s
 * @property {string} signalingRegion - The geographical region of the
 *     signaling edge the {@link LocalParticipant} is connected to.
 *
 * @emits RemoteParticipant#reconnected
 * @emits RemoteParticipant#reconnecting
 * @emits LocalParticipant#trackDimensionsChanged
 * @emits LocalParticipant#trackDisabled
 * @emits LocalParticipant#trackEnabled
 * @emits LocalParticipant#trackPublicationFailed
 * @emits LocalParticipant#trackPublished
 * @emits LocalParticipant#trackStarted
 * @emits LocalParticipant#trackStopped
 */

var LocalParticipant = function (_Participant) {
  _inherits(LocalParticipant, _Participant);

  /**
   * Construct a {@link LocalParticipant}.
   * @param {ParticipantSignaling} signaling
   * @param {Array<LocalTrack>} localTracks
   * @param {Object} options
   */
  function LocalParticipant(signaling, localTracks, options) {
    _classCallCheck(this, LocalParticipant);

    options = Object.assign({
      LocalAudioTrack: LocalAudioTrack,
      LocalVideoTrack: LocalVideoTrack,
      LocalDataTrack: LocalDataTrack,
      MediaStreamTrack: MediaStreamTrack,
      LocalAudioTrackPublication: LocalAudioTrackPublication,
      LocalVideoTrackPublication: LocalVideoTrackPublication,
      LocalDataTrackPublication: LocalDataTrackPublication,
      shouldStopLocalTracks: false,
      tracks: localTracks
    }, options);

    var tracksToStop = options.shouldStopLocalTracks ? new Set(localTracks.filter(function (localTrack) {
      return localTrack.kind !== 'data';
    })) : new Set();

    var _this = _possibleConstructorReturn(this, (LocalParticipant.__proto__ || Object.getPrototypeOf(LocalParticipant)).call(this, signaling, options));

    Object.defineProperties(_this, {
      _LocalAudioTrack: {
        value: options.LocalAudioTrack
      },
      _LocalDataTrack: {
        value: options.LocalDataTrack
      },
      _LocalVideoTrack: {
        value: options.LocalVideoTrack
      },
      _MediaStreamTrack: {
        value: options.MediaStreamTrack
      },
      _LocalAudioTrackPublication: {
        value: options.LocalAudioTrackPublication
      },
      _LocalDataTrackPublication: {
        value: options.LocalDataTrackPublication
      },
      _LocalVideoTrackPublication: {
        value: options.LocalVideoTrackPublication
      },
      _tracksToStop: {
        value: tracksToStop
      },
      signalingRegion: {
        enumerable: true,
        get: function get() {
          return signaling.signalingRegion;
        }
      }
    });

    _this._handleTrackSignalingEvents();
    return _this;
  }

  /**
   * @private
   * @param {LocalTrack} track
   * @param {Track.ID} id
   * @param {Track.Priority} priority
   * @returns {?LocalTrack}
   */


  _createClass(LocalParticipant, [{
    key: '_addTrack',
    value: function _addTrack(track, id, priority) {
      var addedTrack = _get(LocalParticipant.prototype.__proto__ || Object.getPrototypeOf(LocalParticipant.prototype), '_addTrack', this).call(this, track, id);
      if (addedTrack && this.state !== 'disconnected') {
        this._addLocalTrack(track, priority);
      }
      return addedTrack;
    }

    /**
     * @private
     * @param {LocalTrack} track
     * @param {Track.Priority} priority
     * @returns {void}
     */

  }, {
    key: '_addLocalTrack',
    value: function _addLocalTrack(track, priority) {
      this._signaling.addTrack(track._trackSender, track.name, priority);
      this._log.info('Added a new ' + trackClass(track, true) + ':', track.id);
      this._log.debug(trackClass(track, true) + ':', track);
    }

    /**
     * @private
     * @param {LocalTrack} track
     * @param {Track.ID} id
     * @returns {?LocalTrack}
     */

  }, {
    key: '_removeTrack',
    value: function _removeTrack(track, id) {
      var removedTrack = _get(LocalParticipant.prototype.__proto__ || Object.getPrototypeOf(LocalParticipant.prototype), '_removeTrack', this).call(this, track, id);
      if (removedTrack && this.state !== 'disconnected') {
        this._signaling.removeTrack(track._trackSender);
        this._log.info('Removed a ' + trackClass(track, true) + ':', track.id);
        this._log.debug(trackClass(track, true) + ':', track);
      }
      return removedTrack;
    }

    /**
     * Get the {@link LocalTrack} events to re-emit.
     * @private
     * @returns {Array<Array<string>>} events
     */

  }, {
    key: '_getTrackEvents',
    value: function _getTrackEvents() {
      return _get(LocalParticipant.prototype.__proto__ || Object.getPrototypeOf(LocalParticipant.prototype), '_getTrackEvents', this).call(this).concat([['disabled', 'trackDisabled'], ['enabled', 'trackEnabled'], ['stopped', 'trackStopped']]);
    }
  }, {
    key: 'toString',
    value: function toString() {
      return '[LocalParticipant #' + this._instanceId + (this.sid ? ': ' + this.sid : '') + ']';
    }

    /**
     * @private
     */

  }, {
    key: '_handleTrackSignalingEvents',
    value: function _handleTrackSignalingEvents() {
      var _this2 = this;

      var log = this._log;

      if (this.state === 'disconnected') {
        return;
      }

      var signaling = this._signaling;

      function localTrackDisabled(localTrack) {
        var trackSignaling = signaling.getPublication(localTrack._trackSender);
        if (trackSignaling) {
          trackSignaling.disable();
          log.debug('Disabled the ' + trackClass(localTrack, true) + ':', localTrack.id);
        }
      }

      function localTrackEnabled(localTrack) {
        var trackSignaling = signaling.getPublication(localTrack._trackSender);
        if (trackSignaling) {
          trackSignaling.enable();
          log.debug('Enabled the ' + trackClass(localTrack, true) + ':', localTrack.id);
        }
      }

      function localTrackStopped(localTrack) {
        // NOTE(mroberts): We shouldn't need to check for `stop`, since DataTracks
        // do not emit "stopped".
        var trackSignaling = signaling.getPublication(localTrack._trackSender);
        if (trackSignaling) {
          trackSignaling.stop();
        }
        return trackSignaling;
      }

      this.on('trackDisabled', localTrackDisabled);
      this.on('trackEnabled', localTrackEnabled);
      this.on('trackStopped', localTrackStopped);

      this._tracks.forEach(function (track) {
        _this2._addLocalTrack(track, trackPriority.PRIORITY_STANDARD);
        _this2._getOrCreateLocalTrackPublication(track).catch(function (error) {
          // Just log a warning for now.
          log.warn('Failed to get or create LocalTrackPublication for ' + track + ':', error);
        });
      });

      var self = this;
      signaling.on('stateChanged', function stateChanged(state) {
        log.debug('Transitioned to state:', state);
        if (state === 'disconnected') {
          log.debug('Removing LocalTrack event listeners');
          signaling.removeListener('stateChanged', stateChanged);
          self.removeListener('trackDisabled', localTrackDisabled);
          self.removeListener('trackEnabled', localTrackEnabled);
          self.removeListener('trackStopped', localTrackStopped);

          // NOTE(mmalavalli): Remove the stale MediaTrackSender clones so that we
          // do not call replaceTrack() on their RTCRtpSenders.
          self._tracks.forEach(function (track) {
            var trackSignaling = localTrackStopped(track);
            if (trackSignaling) {
              track._trackSender.removeClone(trackSignaling._trackTransceiver);
            }
          });

          log.info('LocalParticipant disconnected. Stopping ' + self._tracksToStop.size + ' automatically-acquired LocalTracks');
          self._tracksToStop.forEach(function (track) {
            track.stop();
          });
        } else if (state === 'connected') {
          // NOTE(mmalavalli): Any transition to "connected" here is a result of
          // successful signaling reconnection, and not a first-time establishment
          // of the signaling connection.
          log.info('reconnected');

          // NOTE(mpatwardhan): `stateChanged` can get emitted with StateMachine locked.
          // Do not signal  public events synchronously with lock held.
          setTimeout(function () {
            return self.emit('reconnected');
          }, 0);
        }
      });
    }

    /**
     * @private
     * @param {LocalTrack} localTrack
     * @returns {Promise<LocalTrackPublication>}
     */

  }, {
    key: '_getOrCreateLocalTrackPublication',
    value: function _getOrCreateLocalTrackPublication(localTrack) {
      var localTrackPublication = getTrackPublication(this.tracks, localTrack);
      if (localTrackPublication) {
        return Promise.resolve(localTrackPublication);
      }

      var log = this._log;
      var self = this;

      var trackSignaling = this._signaling.getPublication(localTrack._trackSender);
      if (!trackSignaling) {
        return Promise.reject(new Error('Unexpected error: The ' + localTrack + ' cannot be published'));
      }

      function unpublish(publication) {
        self.unpublishTrack(publication.track);
      }

      return new Promise(function (resolve, reject) {
        function updated() {
          var error = trackSignaling.error;
          if (error) {
            trackSignaling.removeListener('updated', updated);
            log.warn('Failed to publish the ' + trackClass(localTrack, true) + ': ' + error.message);
            self._removeTrack(localTrack, localTrack.id);
            setTimeout(function () {
              self.emit('trackPublicationFailed', error, localTrack);
            });
            reject(error);
            return;
          }

          if (!self._tracks.has(localTrack.id)) {
            trackSignaling.removeListener('updated', updated);
            reject(new Error('The ' + localTrack + ' was unpublished'));
            return;
          }

          var sid = trackSignaling.sid;
          if (!sid) {
            return;
          }

          trackSignaling.removeListener('updated', updated);

          var options = {
            log: log,
            LocalAudioTrackPublication: self._LocalAudioTrackPublication,
            LocalDataTrackPublication: self._LocalDataTrackPublication,
            LocalVideoTrackPublication: self._LocalVideoTrackPublication
          };

          localTrackPublication = getTrackPublication(self.tracks, localTrack);

          if (!localTrackPublication) {
            localTrackPublication = asLocalTrackPublication(localTrack, trackSignaling, unpublish, options);
            self._addTrackPublication(localTrackPublication);
          }

          if (self._signaling.state === 'connected') {
            setTimeout(function () {
              self.emit('trackPublished', localTrackPublication);
            });
          }
          resolve(localTrackPublication);
        }

        trackSignaling.on('updated', updated);
      });
    }

    /**
     * Publishes a {@link LocalTrack} to the {@link Room}.
     * @param {LocalTrack} localTrack - The {@link LocalTrack} to publish
     * @param {LocalTrackPublishOptions} [options] - The {@link LocalTrackPublishOptions}
     *   for publishing the {@link LocalTrack}
     * @returns {Promise<LocalTrackPublication>} - Resolves with the corresponding
     *   {@link LocalTrackPublication} if successful
     * @throws {TypeError}
     * @throws {RangeError}
     * @example
     * var Video = require('twilio-video');
     *
     * Video.connect(token, {
     *   name: 'my-cool-room',
     *   audio: true
     * }).then(function(room) {
     *   return Video.createLocalVideoTrack({
     *     name: 'camera'
     *   }).then(function(localVideoTrack) {
     *     return room.localParticipant.publishTrack(localVideoTrack, {
     *       priority: 'high'
     *     });
     *   });
     * }).then(function(publication) {
     *   console.log('The LocalTrack "' + publication.trackName
     *     + '" was successfully published with priority "'
     *     * publication.priority + '"');
     * });
    */ /**
       * Publishes a MediaStreamTrack to the {@link Room}.
       * @param {MediaStreamTrack} mediaStreamTrack - The MediaStreamTrack
       *   to publish; if a corresponding {@link LocalAudioTrack} or
       *   {@link LocalVideoTrack} has not yet been published, this method will
       *   construct one
       * @param {MediaStreamTrackPublishOptions} [options] - The options for publishing
       *   the MediaStreamTrack
       * @returns {Promise<LocalTrackPublication>} - Resolves with the corresponding
       *   {@link LocalTrackPublication} if successful
       * @throws {TypeError}
       * @throws {RangeError}
       * @example
       * var Video = require('twilio-video');
       *
       * Video.connect(token, {
       *   name: 'my-cool-room',
       *   audio: true
       * }).then(function(room) {
       *   return navigator.mediaDevices.getUserMedia({
       *     video: true
       *   }).then(function(mediaStream) {
       *     var mediaStreamTrack = mediaStream.getTracks()[0];
       *     return room.localParticipant.publishTrack(mediaStreamTrack, {
       *       name: 'camera',
       *       priority: 'high'
       *     });
       *   });
       * }).then(function(publication) {
       *   console.log('The LocalTrack "' + publication.trackName
       *     + '" was successfully published with priority "'
       *     * publication.priority + '"');
       * });
       */

  }, {
    key: 'publishTrack',
    value: function publishTrack(localTrackOrMediaStreamTrack, options) {
      var trackPublication = getTrackPublication(this.tracks, localTrackOrMediaStreamTrack);
      if (trackPublication) {
        return Promise.resolve(trackPublication);
      }

      options = Object.assign({
        log: this._log,
        priority: trackPriority.PRIORITY_STANDARD,
        LocalAudioTrack: this._LocalAudioTrack,
        LocalDataTrack: this._LocalDataTrack,
        LocalVideoTrack: this._LocalVideoTrack,
        MediaStreamTrack: this._MediaStreamTrack
      }, options);

      var localTrack = void 0;
      try {
        localTrack = asLocalTrack(localTrackOrMediaStreamTrack, options);
      } catch (error) {
        return Promise.reject(error);
      }

      var priorityValues = Object.values(trackPriority);
      if (!priorityValues.includes(options.priority)) {
        // eslint-disable-next-line new-cap
        return Promise.reject(E.INVALID_VALUE('LocalTrackPublishOptions.priority', priorityValues));
      }

      var addedLocalTrack = this._addTrack(localTrack, localTrack.id, options.priority) || this._tracks.get(localTrack.id);

      return this._getOrCreateLocalTrackPublication(addedLocalTrack);
    }

    /**
     * Publishes multiple {@link LocalTrack}s to the {@link Room}.
     * @param {Array<LocalTrack|MediaStreamTrack>} tracks - The {@link LocalTrack}s
     *   to publish; for any MediaStreamTracks provided, if a corresponding
     *   {@link LocalAudioTrack} or {@link LocalVideoTrack} has not yet been
     *   published, this method will construct one
     * @returns {Promise<Array<LocalTrackPublication>>} - The resulting
     *   {@link LocalTrackPublication}s
     * @throws {TypeError}
     */

  }, {
    key: 'publishTracks',
    value: function publishTracks(tracks) {
      if (!Array.isArray(tracks)) {
        // eslint-disable-next-line new-cap
        throw E.INVALID_TYPE('tracks', 'Array of LocalAudioTrack, LocalVideoTrack, LocalDataTrack, or MediaStreamTrack');
      }
      return Promise.all(tracks.map(this.publishTrack, this));
    }
  }, {
    key: 'setBandwidthProfile',
    value: function setBandwidthProfile() {
      this._log.warn('setBandwidthProfile is not implemented yet and may be available in future versions of twilio-video.js');
    }

    /**
     * Sets the {@link NetworkQualityVerbosity} for the {@link LocalParticipant} and
     * {@link RemoteParticipant}s. It does nothing if Network Quality is not enabled
     * while calling {@link connect}.
     * @param {NetworkQualityConfiguration} networkQualityConfiguration - The new
     *   {@link NetworkQualityConfiguration}; If either or both of the local and
     *   remote {@link NetworkQualityVerbosity} values are absent, then the corresponding
     *   existing values are retained
     * @returns {this}
     * @example
     * // Update verbosity levels for both LocalParticipant and RemoteParticipants
     * localParticipant.setNetworkQualityConfiguration({
     *   local: 1,
     *   remote: 2
     * });
     * @example
     * // Update verbosity level for only the LocalParticipant
     * localParticipant.setNetworkQualityConfiguration({
     *   local: 1
     * });
     *  @example
     * // Update verbosity level for only the RemoteParticipants
     * localParticipant.setNetworkQualityConfiguration({
     *   remote: 2
     * });
     */

  }, {
    key: 'setNetworkQualityConfiguration',
    value: function setNetworkQualityConfiguration(networkQualityConfiguration) {
      if ((typeof networkQualityConfiguration === 'undefined' ? 'undefined' : _typeof(networkQualityConfiguration)) !== 'object' || networkQualityConfiguration === null) {
        // eslint-disable-next-line new-cap
        throw E.INVALID_TYPE('networkQualityConfiguration', 'NetworkQualityConfiguration');
      }
      ['local', 'remote'].forEach(function (prop) {
        if (prop in networkQualityConfiguration && (typeof networkQualityConfiguration[prop] !== 'number' || isNaN(networkQualityConfiguration[prop]))) {
          // eslint-disable-next-line new-cap
          throw E.INVALID_TYPE('networkQualityConfiguration.' + prop, 'number');
        }
      });
      this._signaling.setNetworkQualityConfiguration(networkQualityConfiguration);
      return this;
    }

    /**
     * Set the {@link LocalParticipant}'s {@link EncodingParameters}.
     * @param {?EncodingParameters} [encodingParameters] - The new
     *   {@link EncodingParameters}; If null, then the bitrate limits are removed;
     *   If not specified, then the existing bitrate limits are preserved
     * @returns {this}
     * @throws {TypeError}
     */

  }, {
    key: 'setParameters',
    value: function setParameters(encodingParameters) {
      if (typeof encodingParameters !== 'undefined' && (typeof encodingParameters === 'undefined' ? 'undefined' : _typeof(encodingParameters)) !== 'object') {
        // eslint-disable-next-line new-cap
        throw E.INVALID_TYPE('encodingParameters', 'EncodingParameters, null or undefined');
      }

      if (encodingParameters) {
        ['maxAudioBitrate', 'maxVideoBitrate'].forEach(function (prop) {
          if (typeof encodingParameters[prop] !== 'undefined' && typeof encodingParameters[prop] !== 'number' && encodingParameters[prop] !== null) {
            // eslint-disable-next-line new-cap
            throw E.INVALID_TYPE('encodingParameters.' + prop, 'number, null or undefined');
          }
        });
      } else if (encodingParameters === null) {
        encodingParameters = { maxAudioBitrate: null, maxVideoBitrate: null };
      }

      this._signaling.setParameters(encodingParameters);
      return this;
    }

    /**
     * Stops publishing a {@link LocalTrack} to the {@link Room}.
     * @param {LocalTrack|MediaStreamTrack} track - The {@link LocalTrack}
     *   to stop publishing; if a MediaStreamTrack is provided, this method
     *   looks up the corresponding {@link LocalAudioTrack} or
     *   {@link LocalVideoTrack} to stop publishing
     * @returns {?LocalTrackPublication} - The corresponding
     *   {@link LocalTrackPublication} if the {@link LocalTrack} was previously
     *   published, null otherwise
     * @throws {TypeError}
    */

  }, {
    key: 'unpublishTrack',
    value: function unpublishTrack(track) {
      validateLocalTrack(track, {
        LocalAudioTrack: this._LocalAudioTrack,
        LocalDataTrack: this._LocalDataTrack,
        LocalVideoTrack: this._LocalVideoTrack,
        MediaStreamTrack: this._MediaStreamTrack
      });

      var localTrack = this._tracks.get(track.id);
      if (!localTrack) {
        return null;
      }

      var trackSignaling = this._signaling.getPublication(localTrack._trackSender);
      trackSignaling.publishFailed(new Error('The ' + localTrack + ' was unpublished'));

      localTrack = this._removeTrack(localTrack, localTrack.id);
      if (!localTrack) {
        return null;
      }

      var localTrackPublication = getTrackPublication(this.tracks, localTrack);
      if (localTrackPublication) {
        this._removeTrackPublication(localTrackPublication);
      }
      return localTrackPublication;
    }

    /**
     * Stops publishing multiple {@link LocalTrack}s to the {@link Room}.
     * @param {Array<LocalTrack|MediaStreamTrack>} tracks - The {@link LocalTrack}s
     *   to stop publishing; for any MediaStreamTracks provided, this method looks
     *   up the corresponding {@link LocalAudioTrack} or {@link LocalVideoTrack} to
     *   stop publishing
     * @returns {Array<LocalTrackPublication>} - The corresponding
     *   {@link LocalTrackPublication}s that were successfully unpublished
     * @throws {TypeError}
     */

  }, {
    key: 'unpublishTracks',
    value: function unpublishTracks(tracks) {
      var _this3 = this;

      if (!Array.isArray(tracks)) {
        // eslint-disable-next-line new-cap
        throw E.INVALID_TYPE('tracks', 'Array of LocalAudioTrack, LocalVideoTrack, LocalDataTrack, or MediaStreamTrack');
      }

      return tracks.reduce(function (unpublishedTracks, track) {
        var unpublishedTrack = _this3.unpublishTrack(track);
        return unpublishedTrack ? unpublishedTracks.concat(unpublishedTrack) : unpublishedTracks;
      }, []);
    }
  }]);

  return LocalParticipant;
}(Participant);

/**
 * The {@link LocalParticipant} has reconnected to the {@link Room} after a signaling connection disruption.
 * @event LocalParticipant#reconnected
 */

/**
 * The {@link LocalParticipant} is reconnecting to the {@link Room} after a signaling connection disruption.
 * @event LocalParticipant#reconnecting
 */

/**
 * One of the {@link LocalParticipant}'s {@link LocalVideoTrack}'s dimensions changed.
 * @param {LocalVideoTrack} track - The {@link LocalVideoTrack} whose dimensions changed
 * @event LocalParticipant#trackDimensionsChanged
 */

/**
 * A {@link LocalTrack} was disabled by the {@link LocalParticipant}.
 * @param {LocalTrack} track - The {@link LocalTrack} that was disabled
 * @event LocalParticipant#trackDisabled
 */

/**
 * A {@link LocalTrack} was enabled by the {@link LocalParticipant}.
 * @param {LocalTrack} track - The {@link LocalTrack} that was enabled
 * @event LocalParticipant#trackEnabled
 */

/**
 * A {@link LocalTrack} failed to publish. Check the error message for more
 * information.
 * @param {TwilioError} error - A {@link TwilioError} explaining why publication
 *   failed
 * @param {LocalTrack} localTrack - The {@link LocalTrack} that failed to
 *   publish
 * @event LocalParticipant#trackPublicationFailed
 */

/**
 * A {@link LocalTrack} was successfully published.
 * @param {LocalTrackPublication} publication - The resulting
 *   {@link LocalTrackPublication} for the published {@link LocalTrack}
 * @event LocalParticipant#trackPublished
 */

/**
 * One of the {@link LocalParticipant}'s {@link LocalTrack}s started.
 * @param {LocalTrack} track - The {@link LocalTrack} that started
 * @event LocalParticipant#trackStarted
 */

/**
 * One of the {@link LocalParticipant}'s {@link LocalTrack}s stopped, either
 * because {@link LocalTrack#stop} was called or because the underlying
 * MediaStreamTrack ended).
 * @param {LocalTrack} track - The {@link LocalTrack} that stopped
 * @event LocalParticipant#trackStopped
 */

/**
 * Outgoing media encoding parameters.
 * @typedef {object} EncodingParameters
 * @property {?number} [maxAudioBitrate] - Max outgoing audio bitrate (bps);
 *   If not specified, retains the existing bitrate limit; A <code>null</code> or a
 *   <code>0</code> value removes any previously set bitrate limit; This value is set
 *   as a hint for variable bitrate codecs, but will not take effect for fixed bitrate
 *   codecs; Based on our tests, Chrome, Firefox and Safari support a bitrate range of
 *   12000 bps to 256000 bps for Opus codec; This parameter has no effect on iSAC, PCMU
 *   and PCMA codecs
 * @property {?number} [maxVideoBitrate] - Max outgoing video bitrate (bps);
 *   If not specified, retains the existing bitrate limit; A <code>null</code> or
 *   a <code>0</code> value removes any previously set bitrate limit; This value is
 *   set as a hint for variable bitrate codecs, but will not take effect for fixed
 *   bitrate codecs; Based on our tests, Chrome, Firefox and Safari all seem to support
 *   an average bitrate range of 20000 bps (20 kbps) to 8000000 bps (8 mbps) for a
 *   720p VideoTrack.
 *   Note: this limit is not applied for screen share tracks published on Chrome.
 */

/**
 * Options for publishing a {@link LocalTrack}.
 * @typedef {object} LocalTrackPublishOptions
 * @property {Track.Priority} [priority='standard'] - The priority with which the {@link LocalTrack}
 *   is to be published; In Group or Small Group Rooms, the appropriate bandwidth is
 *   allocated to the {@link LocalTrack} based on its {@link Track.Priority}; It has no
 *   effect in Peer-to-Peer Rooms; It defaults to "standard" when not provided
 */

/**
 * Options for publishing a {@link MediaStreamTrack}.
 * @typedef {LocalTrackOptions} MediaStreamTrackPublishOptions
 * @property {Track.Priority} [priority='standard'] - The priority with which the {@link LocalTrack}
 *   is to be published; In Group or Small Group Rooms, the appropriate bandwidth is
 *   allocated to the {@link LocalTrack} based on its {@link Track.Priority}; It has no
 *   effect in Peer-to-Peer Rooms; It defaults to "standard" when not provided
 */

/**
 * @private
 * @param {Map<Track.SID, LocalTrackPublication>} trackPublications
 * @param {LocalTrack|MediaStreamTrack} track
 * @returns {?LocalTrackPublication} trackPublication
 */


function getTrackPublication(trackPublications, track) {
  return Array.from(trackPublications.values()).find(function (trackPublication) {
    return trackPublication.track === track || trackPublication.track.mediaStreamTrack === track;
  }) || null;
}

module.exports = LocalParticipant;
},{"./media/track/es5":14,"./media/track/localaudiotrackpublication":20,"./media/track/localdatatrackpublication":22,"./media/track/localvideotrackpublication":26,"./participant":42,"./util":114,"./util/constants":108,"./util/validate":130,"@twilio/webrtc":136}],13:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var MediaTrack = require('./mediatrack');

/**
 * An {@link AudioTrack} is a {@link Track} representing audio.
 * @extends Track
 * @property {boolean} isStarted - Whether or not the {@link AudioTrack} has
 *   started; if the {@link AudioTrack} started, there is enough audio data to
 *   begin playback
 * @property {boolean} isEnabled - Whether or not the {@link AudioTrack} is
 *   enabled; if the {@link AudioTrack} is not enabled, it is "muted"
 * @property {Track.Kind} kind - "audio"
 * @property {MediaStreamTrack} mediaStreamTrack - An audio MediaStreamTrack
 * @emits AudioTrack#disabled
 * @emits AudioTrack#enabled
 * @emits AudioTrack#started
 */

var AudioTrack = function (_MediaTrack) {
  _inherits(AudioTrack, _MediaTrack);

  /**
   * Construct an {@link AudioTrack}.
   * @param {MediaTrackTransceiver} mediaTrackTransceiver
   * @param {{log: Log}} options
   */
  function AudioTrack(mediaTrackTransceiver, options) {
    _classCallCheck(this, AudioTrack);

    return _possibleConstructorReturn(this, (AudioTrack.__proto__ || Object.getPrototypeOf(AudioTrack)).call(this, mediaTrackTransceiver, options));
  }

  /**
   * @private
   */


  _createClass(AudioTrack, [{
    key: '_start',
    value: function _start() {
      _get(AudioTrack.prototype.__proto__ || Object.getPrototypeOf(AudioTrack.prototype), '_start', this).call(this);
      if (this._dummyEl) {
        this._detachElement(this._dummyEl);
      }
    }

    /**
     * Create an HTMLAudioElement and attach the {@link AudioTrack} to it.
     *
     * The HTMLAudioElement's <code>srcObject</code> will be set to a new
     * MediaStream containing the {@link AudioTrack}'s MediaStreamTrack.
     *
     * @returns {HTMLAudioElement} audioElement
     * @example
     * const Video = require('twilio-video');
     *
     * Video.createLocalAudioTrack().then(function(audioTrack) {
     *   const audioElement = audioTrack.attach();
     *   document.body.appendChild(audioElement);
     * });
    */ /**
       * Attach the {@link AudioTrack} to an existing HTMLMediaElement. The
       * HTMLMediaElement could be an HTMLAudioElement or an HTMLVideoElement.
       *
       * If the HTMLMediaElement's <code>srcObject</code> is not set to a MediaStream,
       * this method sets it to a new MediaStream containing the {@link AudioTrack}'s
       * MediaStreamTrack; otherwise, it adds the {@link MediaTrack}'s
       * MediaStreamTrack to the existing MediaStream. Finally, if there are any other
       * MediaStreamTracks of the same kind on the MediaStream, this method removes
       * them.
       *
       * @param {HTMLMediaElement} mediaElement - The HTMLMediaElement to attach to
       * @returns {HTMLMediaElement} mediaElement
       * @example
       * const Video = require('twilio-video');
       *
       * const videoElement = document.createElement('video');
       * document.body.appendChild(videoElement);
       *
       * Video.createLocalAudioTrack().then(function(audioTrack) {
       *   audioTrack.attach(videoElement);
       * });
       */ /**
          * Attach the {@link AudioTrack} to an HTMLMediaElement selected by
          * <code>document.querySelector</code>. The HTMLMediaElement could be an
          * HTMLAudioElement or an HTMLVideoElement.
          *
          * If the HTMLMediaElement's <code>srcObject</code> is not set to a MediaStream,
          * this method sets it to a new MediaStream containing the {@link AudioTrack}'s
          * MediaStreamTrack; otherwise, it adds the {@link AudioTrack}'s
          * MediaStreamTrack to the existing MediaStream. Finally, if there are any other
          * MediaStreamTracks of the same kind on the MediaStream, this method removes
          * them.
          *
          * @param {string} selector - A query selector for the HTMLMediaElement to
          *   attach to
          * @returns {HTMLMediaElement} mediaElement
          * @example
          * const Video = require('twilio-video');
          *
          * const videoElement = document.createElement('video');
          * videoElement.id = 'my-video-element';
          * document.body.appendChild(videoElement);
          *
          * Video.createLocalAudioTrack().then(function(track) {
          *   track.attach('#my-video-element');
          * });
          */

  }, {
    key: 'attach',
    value: function attach() {
      return _get(AudioTrack.prototype.__proto__ || Object.getPrototypeOf(AudioTrack.prototype), 'attach', this).apply(this, arguments);
    }

    /**
     * Detach the {@link AudioTrack} from all previously attached HTMLMediaElements.
     * @returns {Array<HTMLMediaElement>} mediaElements
     * @example
     * const mediaElements = audioTrack.detach();
     * mediaElements.forEach(mediaElement => mediaElement.remove());
    */ /**
       * Detach the {@link AudioTrack} from a previously attached HTMLMediaElement.
       * @param {HTMLMediaElement} mediaElement - One of the HTMLMediaElements to
       *   which the {@link AudioTrack} is attached
       * @returns {HTMLMediaElement} mediaElement
       * @example
       * const videoElement = document.getElementById('my-video-element');
       * audioTrack.detach(videoElement).remove();
       */ /**
          * Detach the {@link AudioTrack} from a previously attached HTMLMediaElement
          *   specified by <code>document.querySelector</code>.
          * @param {string} selector - The query selector of HTMLMediaElement to which
          *    the {@link AudioTrack} is attached
          * @returns {HTMLMediaElement} mediaElement
          * @example
          * audioTrack.detach('#my-video-element').remove();
          */

  }, {
    key: 'detach',
    value: function detach() {
      return _get(AudioTrack.prototype.__proto__ || Object.getPrototypeOf(AudioTrack.prototype), 'detach', this).apply(this, arguments);
    }
  }]);

  return AudioTrack;
}(MediaTrack);

/**
 * The {@link AudioTrack} was disabled, i.e. "muted".
 * @param {AudioTrack} track - The {@link AudioTrack} that was disabled
 * @event AudioTrack#disabled
 */

/**
 * The {@link AudioTrack} was enabled, i.e. "unmuted".
 * @param {AudioTrack} track - The {@link AudioTrack} that was enabled
 * @event AudioTrack#enabled
 */

/**
 * The {@link AudioTrack} started. This means there is enough audio data to
 * begin playback.
 * @param {AudioTrack} track - The {@link AudioTrack} that started
 * @event AudioTrack#started
 */

module.exports = AudioTrack;
},{"./mediatrack":27}],14:[function(require,module,exports){
'use strict';

module.exports = {
  LocalAudioTrack: require('./localaudiotrack'),
  LocalVideoTrack: require('./localvideotrack'),
  LocalDataTrack: require('./localdatatrack')
};
},{"./localaudiotrack":15,"./localdatatrack":16,"./localvideotrack":17}],15:[function(require,module,exports){
// eslint-disable-next-line no-warning-comments
// TODO(mroberts): Remove this when we go to the next major version. This is
// only in place so that we can support ES6 classes without requiring `new`.
'use strict';

var _require = require('util'),
    inherits = _require.inherits;

var LocalAudioTrackClass = require('../localaudiotrack');

function LocalAudioTrack(mediaStreamTrack, options) {
  var track = new LocalAudioTrackClass(mediaStreamTrack, options);
  Object.setPrototypeOf(track, LocalAudioTrack.prototype);
  return track;
}

inherits(LocalAudioTrack, LocalAudioTrackClass);

module.exports = LocalAudioTrack;
},{"../localaudiotrack":19,"util":182}],16:[function(require,module,exports){
// eslint-disable-next-line no-warning-comments
// TODO(mroberts): Remove this when we go to the next major version. This is
// only in place so that we can support ES6 classes without requiring `new`.
'use strict';

var _require = require('util'),
    inherits = _require.inherits;

var LocalDataTrackClass = require('../localdatatrack');

function LocalDataTrack(options) {
  var track = new LocalDataTrackClass(options);
  Object.setPrototypeOf(track, LocalDataTrack.prototype);
  return track;
}

inherits(LocalDataTrack, LocalDataTrackClass);

module.exports = LocalDataTrack;
},{"../localdatatrack":21,"util":182}],17:[function(require,module,exports){
// eslint-disable-next-line no-warning-comments
// TODO(mroberts): Remove this when we go to the next major version. This is
// only in place so that we can support ES6 classes without requiring `new`.
'use strict';

var _require = require('util'),
    inherits = _require.inherits;

var LocalVideoTrackClass = require('../localvideotrack');

function LocalVideoTrack(mediaStreamTrack, options) {
  var track = new LocalVideoTrackClass(mediaStreamTrack, options);
  Object.setPrototypeOf(track, LocalVideoTrack.prototype);
  return track;
}

inherits(LocalVideoTrack, LocalVideoTrackClass);

module.exports = LocalVideoTrack;
},{"../localvideotrack":25,"util":182}],18:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EventEmitter = require('../../eventemitter');

var _require = require('../../util'),
    buildLogLevels = _require.buildLogLevels,
    valueToJSON = _require.valueToJSON;

var DEFAULT_LOG_LEVEL = require('../../util/constants').DEFAULT_LOG_LEVEL;
var Log = require('../../util/log');

var nInstances = 0;

/**
 * A {@link Track} represents a stream of audio, video, or data.
 * @extends EventEmitter
 * @property {Track.Kind} kind - The {@link Track}'s kind
 * @property {string} name - The {@link Track}'s name
 */

var Track = function (_EventEmitter) {
  _inherits(Track, _EventEmitter);

  /**
   * Construct a {@link Track}.
   * @param {Track.ID} id - The {@link Track}'s ID
   * @param {Track.Kind} kind - The {@link Track}'s kind
   * @param {{ log: Log, name: ?string }} options
   */
  function Track(id, kind, options) {
    _classCallCheck(this, Track);

    options = Object.assign({
      name: id,
      log: null,
      logLevel: DEFAULT_LOG_LEVEL
    }, options);

    var _this = _possibleConstructorReturn(this, (Track.__proto__ || Object.getPrototypeOf(Track)).call(this));

    var name = String(options.name);

    var logLevels = buildLogLevels(options.logLevel);
    var log = options.log ? options.log.createLog('media', _this) : new Log('media', _this, logLevels, options.loggerName);

    Object.defineProperties(_this, {
      _instanceId: {
        value: ++nInstances
      },
      _log: {
        value: log
      },
      kind: {
        enumerable: true,
        value: kind
      },
      name: {
        enumerable: true,
        value: name
      }
    });
    return _this;
  }

  _createClass(Track, [{
    key: 'toJSON',
    value: function toJSON() {
      return valueToJSON(this);
    }
  }]);

  return Track;
}(EventEmitter);

/**
 * The {@link Track} ID is a string identifier for the {@link Track}.
 * @typedef {string} Track.ID
 */

/**
 * The {@link Track} kind is either "audio", "video", or "data".
 * @typedef {string} Track.Kind
 */

/**
 * The {@link Track}'s priority can be "low", "standard", or "high".
 * @typedef {string} Track.Priority
 */

/**
 * The {@link Track} SID is a unique string identifier for the {@link Track}
 * that is published to a {@link Room}.
 * @typedef {string} Track.SID
 */

/**
 * A {@link DataTrack} is a {@link LocalDataTrack} or {@link RemoteDataTrack}.
 * @typedef {LocalDataTrack|RemoteDataTrack} DataTrack
 */

/**
 * A {@link LocalTrack} is a {@link LocalAudioTrack}, {@link LocalVideoTrack},
 * or {@link LocalDataTrack}.
 * @typedef {LocalAudioTrack|LocalVideoTrack|LocalDataTrack} LocalTrack
 */

/**
 * {@link LocalTrack} options
 * @typedef {object} LocalTrackOptions
 * @property {LogLevel|LogLevels} logLevel - Log level for 'media' modules
 * @property {string} [name] - The {@link LocalTrack}'s name; by default,
 *   it is set to the {@link LocalTrack}'s ID.
 */

/**
 * A {@link RemoteTrack} is a {@link RemoteAudioTrack},
 * {@link RemoteVideoTrack}, or {@link RemoteDataTrack}.
 * @typedef {RemoteAudioTrack|RemoteVideoTrack|RemoteDataTrack} RemoteTrack
 */

module.exports = Track;
},{"../../eventemitter":10,"../../util":114,"../../util/constants":108,"../../util/log":118}],19:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var AudioTrack = require('./audiotrack');
var mixinLocalMediaTrack = require('./localmediatrack');

var LocalMediaAudioTrack = mixinLocalMediaTrack(AudioTrack);

/**
 * A {@link LocalAudioTrack} is an {@link AudioTrack} representing audio that
 * your {@link LocalParticipant} can publish to a {@link Room}. It can be
 * enabled and disabled with {@link LocalAudioTrack#enable} and
 * {@link LocalAudioTrack#disable} or stopped completely with
 * {@link LocalAudioTrack#stop}.
 * @extends AudioTrack
 * @property {Track.ID} id - The {@link LocalAudioTrack}'s ID
 * @property {boolean} isStopped - Whether or not the {@link LocalAudioTrack} is
 *   stopped
 * @emits LocalAudioTrack#disabled
 * @emits LocalAudioTrack#enabled
 * @emits LocalAudioTrack#started
 * @emits LocalAudioTrack#stopped
 */

var LocalAudioTrack = function (_LocalMediaAudioTrack) {
  _inherits(LocalAudioTrack, _LocalMediaAudioTrack);

  /**
   * Construct a {@link LocalAudioTrack} from a MediaStreamTrack.
   * @param {MediaStreamTrack} mediaStreamTrack - An audio MediaStreamTrack
   * @param {LocalTrackOptions} [options] - {@link LocalTrack} options
   */
  function LocalAudioTrack(mediaStreamTrack, options) {
    _classCallCheck(this, LocalAudioTrack);

    return _possibleConstructorReturn(this, (LocalAudioTrack.__proto__ || Object.getPrototypeOf(LocalAudioTrack)).call(this, mediaStreamTrack, options));
  }

  _createClass(LocalAudioTrack, [{
    key: 'toString',
    value: function toString() {
      return '[LocalAudioTrack #' + this._instanceId + ': ' + this.id + ']';
    }
  }, {
    key: 'attach',
    value: function attach(el) {
      el = _get(LocalAudioTrack.prototype.__proto__ || Object.getPrototypeOf(LocalAudioTrack.prototype), 'attach', this).call(this, el);
      el.muted = true;
      return el;
    }

    /**
     * @private
     */

  }, {
    key: '_end',
    value: function _end() {
      return _get(LocalAudioTrack.prototype.__proto__ || Object.getPrototypeOf(LocalAudioTrack.prototype), '_end', this).apply(this, arguments);
    }

    /**
     * Disable the {@link LocalAudioTrack}. This is effectively "mute".
     * @returns {this}
     * @fires LocalAudioTrack#disabled
     */

  }, {
    key: 'disable',
    value: function disable() {
      return _get(LocalAudioTrack.prototype.__proto__ || Object.getPrototypeOf(LocalAudioTrack.prototype), 'disable', this).apply(this, arguments);
    }

    /**
     * Enable the {@link LocalAudioTrack}. This is effectively "unmute".
     * @returns {this}
     * @fires LocalAudioTrack#enabled
    */ /**
       * Enable or disable the {@link LocalAudioTrack}. This is effectively "unmute"
       * or "mute".
       * @param {boolean} [enabled] - Specify false to mute the
       *   {@link LocalAudioTrack}
       * @returns {this}
       * @fires LocalAudioTrack#disabled
       * @fires LocalAudioTrack#enabled
       */

  }, {
    key: 'enable',
    value: function enable() {
      return _get(LocalAudioTrack.prototype.__proto__ || Object.getPrototypeOf(LocalAudioTrack.prototype), 'enable', this).apply(this, arguments);
    }

    /**
     * Restart the {@link LocalAudioTrack}. This stops the existing MediaStreamTrack
     * and creates a new MediaStreamTrack. If the {@link LocalAudioTrack} is being published
     * to a {@link Room}, then all the {@link RemoteParticipant}s will start receiving media
     * from the newly created MediaStreamTrack. You can access the new MediaStreamTrack via
     * the <code>mediaStreamTrack</code> property. If you want to listen to events on
     * the MediaStreamTrack directly, please do so in the "started" event handler. Also,
     * the {@link LocalAudioTrack}'s ID is no longer guaranteed to be the same as the
     * underlying MediaStreamTrack's ID.
     * @param {MediaTrackConstraints} [constraints] - The optional <a href="https://developer.mozilla.org/en-US/docs/Web/API/MediaTrackConstraints" target="_blank">MediaTrackConstraints</a>
     *   for restarting the {@link LocalAudioTrack}; If not specified, then the current MediaTrackConstraints
     *   will be used; If <code>{}</code> (empty object) is specified, then the default MediaTrackConstraints
     *   will be used
     * @returns {Promise<void>} Rejects with a TypeError if the {@link LocalAudioTrack} was not created
     *   using an one of <code>createLocalAudioTrack</code>, <code>createLocalTracks</code> or <code>connect</code>;
     *   Also rejects with the <a href="https://developer.mozilla.org/en-US/docs/Web/API/MediaDevices/getUserMedia#Exceptions" target="_blank">DOMException</a>
     *   raised by <code>getUserMedia</code> when it fails
     * @fires LocalAudioTrack#stopped
     * @fires LocalAudioTrack#started
     * @example
     * const { connect, createLocalAudioTrack } = require('twilio-video');
     *
     * // Create a LocalAudioTrack that captures audio from a USB microphone.
     * createLocalAudioTrack({ deviceId: 'usb-mic-id' }).then(function(localAudioTrack) {
     *   return connect('token', {
     *     name: 'my-cool-room',
     *     tracks: [localAudioTrack]
     *   });
     * }).then(function(room) {
     *   // Restart the LocalAudioTrack to capture audio from the default microphone.
     *   const localAudioTrack = Array.from(room.localParticipant.audioTracks.values())[0].track;
     *   return localAudioTrack.restart({ deviceId: 'default-mic-id' });
     * });
     */

  }, {
    key: 'restart',
    value: function restart() {
      return _get(LocalAudioTrack.prototype.__proto__ || Object.getPrototypeOf(LocalAudioTrack.prototype), 'restart', this).apply(this, arguments);
    }

    /**
     * Calls stop on the underlying MediaStreamTrack. If you choose to stop a
     * {@link LocalAudioTrack}, you should unpublish it after stopping.
     * @returns {this}
     * @fires LocalAudioTrack#stopped
     */

  }, {
    key: 'stop',
    value: function stop() {
      return _get(LocalAudioTrack.prototype.__proto__ || Object.getPrototypeOf(LocalAudioTrack.prototype), 'stop', this).apply(this, arguments);
    }
  }]);

  return LocalAudioTrack;
}(LocalMediaAudioTrack);

/**
 * The {@link LocalAudioTrack} was disabled, i.e. "muted".
 * @param {LocalAudioTrack} track - The {@link LocalAudioTrack} that was
 *   disabled
 * @event LocalAudioTrack#disabled
 */

/**
 * The {@link LocalAudioTrack} was enabled, i.e. "unmuted".
 * @param {LocalAudioTrack} track - The {@link LocalAudioTrack} that was enabled
 * @event LocalAudioTrack#enabled
 */

/**
 * The {@link LocalAudioTrack} started. This means there is enough audio data to
 * begin playback.
 * @param {LocalAudioTrack} track - The {@link LocalAudioTrack} that started
 * @event LocalAudioTrack#started
 */

/**
 * The {@link LocalAudioTrack} stopped, either because {@link LocalAudioTrack#stop}
 * or {@link LocalAudioTrack#restart} was called or because the underlying
 * MediaStreamTrack ended.
 * @param {LocalAudioTrack} track - The {@link LocalAudioTrack} that stopped
 * @event LocalAudioTrack#stopped
 */

module.exports = LocalAudioTrack;
},{"./audiotrack":13,"./localmediatrack":23}],20:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var LocalTrackPublication = require('./localtrackpublication');

/**
 * A {@link LocalAudioTrackPublication} is a {@link LocalAudioTrack} that has
 * been published to a {@link Room}.
 * @extends LocalTrackPublication
 * @property {Track.Kind} kind - "audio"
 * @property {LocalAudioTrack} track - the {@link LocalAudioTrack}
 */

var LocalAudioTrackPublication = function (_LocalTrackPublicatio) {
  _inherits(LocalAudioTrackPublication, _LocalTrackPublicatio);

  /**
   * Construct a {@link LocalAudioTrackPublication}.
   * @param {LocalTrackPublicationSignaling} signaling - The corresponding
   *   {@link LocalTrackPublicationSignaling}
   * @param {LocalAudioTrack} track - the {@link LocalAudioTrack}
   * @param {function(LocalTrackPublication): void} unpublish - The callback
   *    that unpublishes the {@link LocalTrackPublication}
   * @param {TrackPublicationOptions} options - {@link LocalTrackPublication} options
   */
  function LocalAudioTrackPublication(signaling, track, unpublish, options) {
    _classCallCheck(this, LocalAudioTrackPublication);

    return _possibleConstructorReturn(this, (LocalAudioTrackPublication.__proto__ || Object.getPrototypeOf(LocalAudioTrackPublication)).call(this, signaling, track, unpublish, options));
  }

  _createClass(LocalAudioTrackPublication, [{
    key: 'toString',
    value: function toString() {
      return '[LocalAudioTrackPublication #' + this._instanceId + ': ' + this.trackSid + ']';
    }
  }]);

  return LocalAudioTrackPublication;
}(LocalTrackPublication);

module.exports = LocalAudioTrackPublication;
},{"./localtrackpublication":24}],21:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Track = require('./');
var DefaultDataTrackSender = require('../../data/sender');

/**
 * A {@link LocalDataTrack} is a {@link Track} representing data that your
 * {@link LocalParticipant} can publish to a {@link Room}.
 * @extends Track
 * @property {Track.ID} id - The {@link LocalDataTrack}'s ID
 * @property {Track.Kind} kind - "data"
 * @property {?number} maxPacketLifeTime - If non-null, this represents a time
 *   limit (in milliseconds) during which the {@link LocalDataTrack} will send
 *   or re-send data if not acknowledged on the underlying RTCDataChannel(s).
 * @property {?number} maxRetransmits - If non-null, this represents the number
 *   of times the {@link LocalDataTrack} will resend data if not successfully
 *   delivered on the underlying RTCDataChannel(s).
 * @property {boolean} ordered - true if data on the {@link LocalDataTrack} is
 *   guaranteed to be sent in order.
 * @property {boolean} reliable - This is true if both
 *   <code>maxPacketLifeTime</code> and <code>maxRetransmits</code> are set to
 *   null. In other words, if this is true, there is no bound on packet lifetime
 *   or the number of times the {@link LocalDataTrack} will attempt to send
 *   data, ensuring "reliable" transmission.
 * @example
 * var Video = require('twilio-video');
 *
 * var localDataTrack = new Video.LocalDataTrack();
 * window.addEventListener('mousemove', function(event) {
 *   localDataTrack.send(JSON.stringify({
 *     x: e.clientX,
 *     y: e.clientY
 *   }));
 * });
 *
 * var token1 = getAccessToken();
 * Video.connect(token1, {
 *   name: 'my-cool-room',
 *   tracks: [localDataTrack]
 * });
 *
 * var token2 = getAccessToken();
 * Video.connect(token2, {
 *   name: 'my-cool-room',
 *   tracks: []
 * }).then(function(room) {
 *   room.on('trackSubscribed', function(track) {
 *     track.on('message', function(message) {
 *       console.log(JSON.parse(message)); // { x: <number>, y: <number> }
 *     });
 *   });
 * });
 */

var LocalDataTrack = function (_Track) {
  _inherits(LocalDataTrack, _Track);

  /**
   * Construct a {@link LocalDataTrack}.
   * @param {LocalDataTrackOptions} [options] - {@link LocalDataTrack} options
   */
  function LocalDataTrack(options) {
    _classCallCheck(this, LocalDataTrack);

    options = Object.assign({
      DataTrackSender: DefaultDataTrackSender,
      maxPacketLifeTime: null,
      maxRetransmits: null,
      ordered: true
    }, options);

    var DataTrackSender = options.DataTrackSender;
    var dataTrackSender = new DataTrackSender(options.maxPacketLifeTime, options.maxRetransmits, options.ordered);

    var _this = _possibleConstructorReturn(this, (LocalDataTrack.__proto__ || Object.getPrototypeOf(LocalDataTrack)).call(this, dataTrackSender.id, 'data', options));

    Object.defineProperties(_this, {
      _trackSender: {
        value: dataTrackSender
      },
      id: {
        enumerable: true,
        value: dataTrackSender.id
      },
      maxPacketLifeTime: {
        enumerable: true,
        value: options.maxPacketLifeTime
      },
      maxRetransmits: {
        enumerable: true,
        value: options.maxRetransmits
      },
      ordered: {
        enumerable: true,
        value: options.ordered
      },
      reliable: {
        enumerable: true,
        value: options.maxPacketLifeTime === null && options.maxRetransmits === null
      }
    });
    return _this;
  }

  /**
   * Send a message over the {@link LocalDataTrack}.
   * @param {string|Blob|ArrayBuffer|ArrayBufferView} data
   * @returns {void}
   */


  _createClass(LocalDataTrack, [{
    key: 'send',
    value: function send(data) {
      this._trackSender.send(data);
    }
  }]);

  return LocalDataTrack;
}(Track);

/**
 * {@link LocalDataTrack} options
 * @typedef {LocalTrackOptions} LocalDataTrackOptions
 * @property {?number} [maxPacketLifeTime=null] - Set this to limit the time
 *   (in milliseconds) during which the LocalDataTrack will send or re-send data
 *   if not successfully delivered on the underlying RTCDataChannel(s). It is an
 *   error to specify both this and <code>maxRetransmits</code>.
 * @property {?number} [maxRetransmits=null] - Set this to limit the number of
 *   times the {@link LocalDataTrack} will send or re-send data if not
 *   acknowledged on the underlying RTCDataChannel(s). It is an error to specify
 *   both this and <code>maxPacketLifeTime</code>.
 * @property {boolean} [ordered=true] - Set this to false to allow data on the
 *   LocalDataTrack to be sent out-of-order.
 */

module.exports = LocalDataTrack;
},{"../../data/sender":6,"./":18}],22:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var LocalTrackPublication = require('./localtrackpublication');

/**
 * A {@link LocalDataTrackPublication} is a {@link LocalDataTrack} that has been
 * published to a {@link Room}.
 * @extends LocalTrackPublication
 * @property {Track.Kind} kind - "data"
 * @property {LocalDataTrack} track - the {@link LocalDataTrack}
 */

var LocalDataTrackPublication = function (_LocalTrackPublicatio) {
  _inherits(LocalDataTrackPublication, _LocalTrackPublicatio);

  /**
   * Construct a {@link LocalDataTrackPublication}.
   * @param {LocalTrackPublicationSignaling} signaling - The corresponding
   *   {@link LocalTrackPublicationSignaling}
   * @param {LocalDataTrack} track - the {@link LocalDataTrack}
   * @param {function(LocalTrackPublication): void} unpublish - The callback
   *    that unpublishes the {@link LocalTrackPublication}
   * @param {TrackPublicationOptions} options - {@link LocalTrackPublication} options
   */
  function LocalDataTrackPublication(signaling, track, unpublish, options) {
    _classCallCheck(this, LocalDataTrackPublication);

    return _possibleConstructorReturn(this, (LocalDataTrackPublication.__proto__ || Object.getPrototypeOf(LocalDataTrackPublication)).call(this, signaling, track, unpublish, options));
  }

  _createClass(LocalDataTrackPublication, [{
    key: 'toString',
    value: function toString() {
      return '[LocalDataTrackPublication #' + this._instanceId + ': ' + this.trackSid + ']';
    }
  }]);

  return LocalDataTrackPublication;
}(LocalTrackPublication);

module.exports = LocalDataTrackPublication;
},{"./localtrackpublication":24}],23:[function(require,module,exports){
/* eslint new-cap:0 */
'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('@twilio/webrtc'),
    getUserMedia = _require.getUserMedia;

var _require2 = require('@twilio/webrtc/lib/util'),
    guessBrowser = _require2.guessBrowser;

var _require3 = require('../../util'),
    capitalize = _require3.capitalize,
    defer = _require3.defer,
    waitForSometime = _require3.waitForSometime,
    waitForEvent = _require3.waitForEvent;

var _require4 = require('../../util/constants'),
    ILLEGAL_INVOKE = _require4.typeErrors.ILLEGAL_INVOKE;

var detectSilentAudio = require('../../util/detectsilentaudio');
var detectSilentVideo = require('../../util/detectsilentvideo');
var documentVisibilityMonitor = require('../../util/documentvisibilitymonitor.js');
var localMediaRestartDeferreds = require('../../util/localmediarestartdeferreds');
var gUMSilentTrackWorkaround = require('../../webaudio/workaround180748');
var MediaTrackSender = require('./sender');

function mixinLocalMediaTrack(AudioOrVideoTrack) {
  /**
   * A {@link LocalMediaTrack} represents audio or video that your
   * {@link LocalParticipant} is sending to a {@link Room}. As such, it can be
   * enabled and disabled with {@link LocalMediaTrack#enable} and
   * {@link LocalMediaTrack#disable} or stopped completely with
   * {@link LocalMediaTrack#stop}.
   * @emits LocalMediaTrack#stopped
   */
  return function (_AudioOrVideoTrack) {
    _inherits(LocalMediaTrack, _AudioOrVideoTrack);

    /**
     * Construct a {@link LocalMediaTrack} from a MediaStreamTrack.
     * @param {MediaStreamTrack} mediaStreamTrack - The underlying MediaStreamTrack
     * @param {LocalTrackOptions} [options] - {@link LocalTrack} options
     */
    function LocalMediaTrack(mediaStreamTrack, options) {
      _classCallCheck(this, LocalMediaTrack);

      // NOTE(mpatwardhan): by default workaround for WebKitBug1208516 will be enabled on Safari browsers
      // although the bug is seen  mainly on iOS devices, we do not have a reliable way to tell iOS from MacOs
      // userAgent on iOS pretends its macOs if Safari is set to request desktop pages.
      var workaroundWebKitBug1208516 = guessBrowser() === 'safari' && (typeof document === 'undefined' ? 'undefined' : _typeof(document)) === 'object' && typeof document.addEventListener === 'function' && typeof document.visibilityState === 'string';

      options = Object.assign({
        getUserMedia: getUserMedia,
        isCreatedByCreateLocalTracks: false,
        workaroundWebKitBug1208516: workaroundWebKitBug1208516,
        gUMSilentTrackWorkaround: gUMSilentTrackWorkaround
      }, options);

      var mediaTrackSender = new MediaTrackSender(mediaStreamTrack);
      var kind = mediaTrackSender.kind;

      var _this = _possibleConstructorReturn(this, (LocalMediaTrack.__proto__ || Object.getPrototypeOf(LocalMediaTrack)).call(this, mediaTrackSender, options));

      Object.defineProperties(_this, {
        _constraints: {
          value: _typeof(options[kind]) === 'object' ? options[kind] : {},
          writable: true
        },
        _getUserMedia: {
          value: options.getUserMedia
        },
        _gUMSilentTrackWorkaround: {
          value: options.gUMSilentTrackWorkaround
        },
        _workaroundWebKitBug1208516: {
          value: options.workaroundWebKitBug1208516
        },
        _workaroundWebKitBug1208516Cleanup: {
          value: null,
          writable: true
        },
        _didCallEnd: {
          value: false,
          writable: true
        },
        _isCreatedByCreateLocalTracks: {
          value: options.isCreatedByCreateLocalTracks
        },
        _trackSender: {
          value: mediaTrackSender
        },
        id: {
          enumerable: true,
          value: mediaTrackSender.id
        },
        isEnabled: {
          enumerable: true,
          get: function get() {
            return mediaTrackSender.enabled;
          }
        },
        isStopped: {
          enumerable: true,
          get: function get() {
            return mediaTrackSender.readyState === 'ended';
          }
        }
      });

      // NOTE(mpatwardhan): As a workaround for WebKit bug: https://bugs.webkit.org/show_bug.cgi?id=208516,
      // upon foregrounding, re-acquire new MediaStreamTrack if the existing one is ended or muted.
      if (_this._workaroundWebKitBug1208516) {
        _this._workaroundWebKitBug1208516Cleanup = restartWhenInadvertentlyStopped(_this);
      }
      return _this;
    }

    /**
     * @private
     */


    _createClass(LocalMediaTrack, [{
      key: '_end',
      value: function _end() {
        if (this._didCallEnd) {
          return;
        }
        _get(LocalMediaTrack.prototype.__proto__ || Object.getPrototypeOf(LocalMediaTrack.prototype), '_end', this).call(this);
        this._didCallEnd = true;
        this.emit('stopped', this);
      }

      /**
       * @private
       */

    }, {
      key: '_initialize',
      value: function _initialize() {
        if (this._didCallEnd) {
          this._didCallEnd = false;
        }
        _get(LocalMediaTrack.prototype.__proto__ || Object.getPrototypeOf(LocalMediaTrack.prototype), '_initialize', this).call(this);
      }

      /**
       * @private
       */

    }, {
      key: '_reacquireTrack',
      value: function _reacquireTrack(constraints) {
        var getUserMedia = this._getUserMedia,
            gUMSilentTrackWorkaround = this._gUMSilentTrackWorkaround,
            log = this._log,
            kind = this.mediaStreamTrack.kind;


        log.info('Re-acquiring the MediaStreamTrack');
        log.debug('Constraints:', constraints);

        var gUMConstraints = Object.assign({
          audio: false,
          video: false
        }, _defineProperty({}, kind, constraints));

        var gUMPromise = this._workaroundWebKitBug1208516Cleanup ? gUMSilentTrackWorkaround(log, getUserMedia, gUMConstraints) : getUserMedia(gUMConstraints);

        return gUMPromise.then(function (mediaStream) {
          return mediaStream.getTracks()[0];
        });
      }

      /**
       * @private
       */

    }, {
      key: '_restart',
      value: function _restart(constraints) {
        var _this2 = this;

        var log = this._log;

        constraints = constraints || this._constraints;

        // NOTE(mmalavalli): If we try and restart a silent MediaStreamTrack
        // without stopping it first, then a NotReadableError is raised in case of
        // video, or the restarted audio will still be silent. Hence, we stop the
        // MediaStreamTrack here.
        this._stop();

        return this._reacquireTrack(constraints).catch(function (error) {
          log.error('Failed to re-acquire the MediaStreamTrack:', { error: error, constraints: constraints });
          throw error;
        }).then(function (newMediaStreamTrack) {
          log.info('Re-acquired the MediaStreamTrack');
          log.debug('MediaStreamTrack:', newMediaStreamTrack);
          _this2._constraints = Object.assign({}, constraints);
          return _this2._setMediaStreamTrack(newMediaStreamTrack);
        });
      }

      /**
       * @private
       */

    }, {
      key: '_setMediaStreamTrack',
      value: function _setMediaStreamTrack(mediaStreamTrack) {
        var _this3 = this;

        // NOTE(mpatwardhan): Preserve the value of the "enabled" flag.
        mediaStreamTrack.enabled = this.mediaStreamTrack.enabled;

        // NOTE(mmalavalli): Stop the current MediaStreamTrack. If not already
        // stopped, this should fire a "stopped" event.
        this._stop();

        return this._trackSender.setMediaStreamTrack(mediaStreamTrack).catch(function (error) {
          _this3._log.warn('setMediaStreamTrack failed:', { error: error, mediaStreamTrack: mediaStreamTrack });
        }).then(function () {
          _this3._initialize();
          _this3._getAllAttachedElements().forEach(function (el) {
            return _this3._attach(el);
          });
        });
      }

      /**
       * @private
       */

    }, {
      key: '_stop',
      value: function _stop() {
        this.mediaStreamTrack.stop();
        this._end();
        return this;
      }
    }, {
      key: 'enable',
      value: function enable(enabled) {
        enabled = typeof enabled === 'boolean' ? enabled : true;
        if (enabled !== this.mediaStreamTrack.enabled) {
          this._log.info((enabled ? 'En' : 'Dis') + 'abling');
          this.mediaStreamTrack.enabled = enabled;
          this.emit(enabled ? 'enabled' : 'disabled', this);
        }
        return this;
      }
    }, {
      key: 'disable',
      value: function disable() {
        return this.enable(false);
      }
    }, {
      key: 'restart',
      value: function restart(constraints) {
        var _this4 = this;

        var kind = this.kind;

        if (!this._isCreatedByCreateLocalTracks) {
          return Promise.reject(ILLEGAL_INVOKE('restart', 'can only be called on a' + (' Local' + capitalize(kind) + 'Track that is created using createLocalTracks') + (' or createLocal' + capitalize(kind) + 'Track.')));
        }
        if (this._workaroundWebKitBug1208516Cleanup) {
          this._workaroundWebKitBug1208516Cleanup();
          this._workaroundWebKitBug1208516Cleanup = null;
        }
        var promise = this._restart(constraints);

        if (this._workaroundWebKitBug1208516) {
          promise = promise.finally(function () {
            _this4._workaroundWebKitBug1208516Cleanup = restartWhenInadvertentlyStopped(_this4);
          });
        }
        return promise;
      }
    }, {
      key: 'stop',
      value: function stop() {
        this._log.info('Stopping');
        if (this._workaroundWebKitBug1208516Cleanup) {
          this._workaroundWebKitBug1208516Cleanup();
          this._workaroundWebKitBug1208516Cleanup = null;
        }
        return this._stop();
      }
    }]);

    return LocalMediaTrack;
  }(AudioOrVideoTrack);
}

/**
 * Restart the given {@link LocalMediaTrack} if it has been inadvertently stopped.
 * @private
 * @param {LocalAudioTrack|LocalVideoTrack} localMediaTrack
 * @returns {function} Clean up listeners attached by the workaround
 */
function restartWhenInadvertentlyStopped(localMediaTrack) {
  var log = localMediaTrack._log,
      kind = localMediaTrack.kind;

  var detectSilence = { audio: detectSilentAudio, video: detectSilentVideo }[kind];

  var el = localMediaTrack._dummyEl,
      mediaStreamTrack = localMediaTrack.mediaStreamTrack;

  var trackChangeInProgress = null;

  function checkSilence() {
    // The dummy element is paused, so play it and then detect silence.
    return el.play().then(function () {
      return detectSilence(el);
    }).then(function (isSilent) {
      if (isSilent) {
        log.warn('Silence detected');
      } else {
        log.info('Non-silence detected');
      }
      return isSilent;
    }).catch(function (error) {
      log.warn('Failed to detect silence:', error);
    }).finally(function () {
      // Pause the dummy element again.
      el.pause();
    });
  }

  function shouldReacquireTrack() {
    var _workaroundWebKitBug1208516Cleanup = localMediaTrack._workaroundWebKitBug1208516Cleanup,
        isStopped = localMediaTrack.isStopped,
        muted = localMediaTrack.mediaStreamTrack.muted;


    var isInadvertentlyStopped = isStopped && !!_workaroundWebKitBug1208516Cleanup;

    // NOTE(mmalavalli): Restart the LocalMediaTrack if:
    // 1. The app is foregrounded, and
    // 2. A restart is not already in progress, and
    // 3. The LocalMediaTrack is either muted, inadvertently stopped or silent
    return Promise.resolve().then(function () {
      return document.visibilityState === 'visible' && !trackChangeInProgress && (muted || isInadvertentlyStopped || checkSilence());
    });
  }

  function maybeRestart() {
    return Promise.race([waitForEvent(mediaStreamTrack, 'unmute'), waitForSometime(50)]).then(function () {
      return shouldReacquireTrack();
    }).then(function (shouldReacquire) {
      if (shouldReacquire && !trackChangeInProgress) {
        trackChangeInProgress = defer();
        localMediaTrack._restart().finally(function () {
          el = localMediaTrack._dummyEl;
          removeMediaStreamTrackListeners();
          mediaStreamTrack = localMediaTrack.mediaStreamTrack;
          addMediaStreamTrackListeners();
          trackChangeInProgress.resolve();
          trackChangeInProgress = null;
        });
      }

      // NOTE(mmalavalli): If the MediaStreamTrack ends before the DOM is visible,
      // then this makes sure that visibility callback for phase 2 is called only
      // after the MediaStreamTrack is re-acquired.
      var promise = trackChangeInProgress && trackChangeInProgress.promise || Promise.resolve();
      return promise.finally(function () {
        return localMediaRestartDeferreds.resolveDeferred(kind);
      });
    });
  }

  function onMute() {
    var log = localMediaTrack._log,
        kind = localMediaTrack.kind;

    log.info('Muted');
    log.debug('LocalMediaTrack:', localMediaTrack);

    // NOTE(mmalavalli): When a LocalMediaTrack is muted without the app being
    // backgrounded, and the inadvertently paused elements are played before it
    // is restarted, it never gets unmuted due to the WebKit Bug 213853. Hence,
    // setting this Deferred will make sure that the inadvertently paused elements
    // are played only after the LocalMediaTrack is unmuted.
    //
    // Bug: https://bugs.webkit.org/show_bug.cgi?id=213853
    //
    localMediaRestartDeferreds.startDeferred(kind);
  }

  function addMediaStreamTrackListeners() {
    mediaStreamTrack.addEventListener('ended', maybeRestart);
    mediaStreamTrack.addEventListener('mute', onMute);
    mediaStreamTrack.addEventListener('unmute', maybeRestart);
  }

  function removeMediaStreamTrackListeners() {
    mediaStreamTrack.removeEventListener('ended', maybeRestart);
    mediaStreamTrack.removeEventListener('mute', onMute);
    mediaStreamTrack.removeEventListener('unmute', maybeRestart);
  }

  // NOTE(mpatwardhan): listen for document visibility callback on phase 1.
  // this ensures that we acquire media tracks before RemoteMediaTrack
  // tries to `play` them (in phase 2). This order is important because
  // play can fail on safari if audio is not being captured.
  documentVisibilityMonitor.onVisible(1, maybeRestart);
  addMediaStreamTrackListeners();

  return function () {
    documentVisibilityMonitor.offVisible(1, maybeRestart);
    removeMediaStreamTrackListeners();
  };
}

module.exports = mixinLocalMediaTrack;
},{"../../util":114,"../../util/constants":108,"../../util/detectsilentaudio":109,"../../util/detectsilentvideo":110,"../../util/documentvisibilitymonitor.js":111,"../../util/localmediarestartdeferreds":117,"../../webaudio/workaround180748":133,"./sender":37,"@twilio/webrtc":136,"@twilio/webrtc/lib/util":149}],24:[function(require,module,exports){
/* eslint new-cap:0 */
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TrackPublication = require('./trackpublication');

var _require = require('../../util/constants'),
    E = _require.typeErrors,
    trackPriority = _require.trackPriority;

/**
 * A {@link LocalTrackPublication} is a {@link LocalTrack} that has been
 * published to a {@link Room}.
 * @extends TrackPublication
 * @property {boolean} isTrackEnabled - whether the published {@link LocalTrack}
 *   is enabled
 * @property {Track.Kind} kind - kind of the published {@link LocalTrack}
 * @property {Track.Priority} priority - the publish priority of the {@link LocalTrack}
 * @property {LocalTrack} track - the {@link LocalTrack}
 */


var LocalTrackPublication = function (_TrackPublication) {
  _inherits(LocalTrackPublication, _TrackPublication);

  /**
   * Construct a {@link LocalTrackPublication}.
   * @param {LocalTrackPublicationSignaling} signaling - The corresponding
   *   {@link LocalTrackPublicationSignaling}
   * @param {LocalTrack} track - The {@link LocalTrack}
   * @param {function(LocalTrackPublication): void} unpublish - The callback
   *   that unpublishes the {@link LocalTrackPublication}
   * @param {TrackPublicationOptions} options - {@link LocalTrackPublication}
   *   options
   */
  function LocalTrackPublication(signaling, track, unpublish, options) {
    _classCallCheck(this, LocalTrackPublication);

    var _this = _possibleConstructorReturn(this, (LocalTrackPublication.__proto__ || Object.getPrototypeOf(LocalTrackPublication)).call(this, track.name, signaling.sid, options));

    Object.defineProperties(_this, {
      _reemitTrackEvent: {
        value: function value() {
          return _this.emit(_this.isTrackEnabled ? 'trackEnabled' : 'trackDisabled');
        }
      },
      _signaling: {
        value: signaling
      },
      _unpublish: {
        value: unpublish
      },
      isTrackEnabled: {
        enumerable: true,
        get: function get() {
          return this.track.kind === 'data' ? true : this.track.isEnabled;
        }
      },
      kind: {
        enumerable: true,
        value: track.kind
      },
      priority: {
        enumerable: true,
        get: function get() {
          return signaling.updatedPriority;
        }
      },
      track: {
        enumerable: true,
        value: track
      }
    });

    track.on('disabled', _this._reemitTrackEvent);
    track.on('enabled', _this._reemitTrackEvent);
    return _this;
  }

  _createClass(LocalTrackPublication, [{
    key: 'toString',
    value: function toString() {
      return '[LocalTrackPublication #' + this._instanceId + ': ' + this.trackSid + ']';
    }

    /**
     * Update the {@link Track.Priority} of the published {@link LocalTrack}.
     * @param {Track.Priority} priority - the new {@link Track.priority}
     * @returns {this}
     * @throws {RangeError}
     */

  }, {
    key: 'setPriority',
    value: function setPriority(priority) {
      var priorityValues = Object.values(trackPriority);
      if (!priorityValues.includes(priority)) {
        throw E.INVALID_VALUE('priority', priorityValues);
      }
      this._signaling.setPriority(priority);
      return this;
    }

    /**
     * Unpublish a {@link LocalTrackPublication}. This means that the media
     * from this {@link LocalTrackPublication} is no longer available to the
     * {@link Room}'s {@link RemoteParticipant}s.
     * @returns {this}
     */

  }, {
    key: 'unpublish',
    value: function unpublish() {
      this.track.removeListener('disabled', this._reemitTrackEvent);
      this.track.removeListener('enabled', this._reemitTrackEvent);
      this._unpublish(this);
      return this;
    }
  }]);

  return LocalTrackPublication;
}(TrackPublication);

module.exports = LocalTrackPublication;
},{"../../util/constants":108,"./trackpublication":38}],25:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('@twilio/webrtc/lib/util'),
    guessBrowser = _require.guessBrowser;

var detectSilentVideo = require('../../util/detectsilentvideo');
var mixinLocalMediaTrack = require('./localmediatrack');
var VideoTrack = require('./videotrack');

var LocalMediaVideoTrack = mixinLocalMediaTrack(VideoTrack);

/**
 * A {@link LocalVideoTrack} is a {@link VideoTrack} representing video that
 * your {@link LocalParticipant} can publish to a {@link Room}. It can be
 * enabled and disabled with {@link LocalVideoTrack#enable} and
 * {@link LocalVideoTrack#disable} or stopped completely with
 * {@link LocalVideoTrack#stop}.
 * @extends VideoTrack
 * @property {Track.ID} id - The {@link LocalVideoTrack}'s ID
 * @property {boolean} isStopped - Whether or not the {@link LocalVideoTrack} is
 *   stopped
 * @emits LocalVideoTrack#disabled
 * @emits LocalVideoTrack#enabled
 * @emits LocalVideoTrack#started
 * @emits LocalVideoTrack#stopped
 */

var LocalVideoTrack = function (_LocalMediaVideoTrack) {
  _inherits(LocalVideoTrack, _LocalMediaVideoTrack);

  /**
   * Construct a {@link LocalVideoTrack} from a MediaStreamTrack.
   * @param {MediaStreamTrack} mediaStreamTrack - The underlying MediaStreamTrack
   * @param {LocalTrackOptions} [options] - {@link LocalTrack} options
   */
  function LocalVideoTrack(mediaStreamTrack, options) {
    _classCallCheck(this, LocalVideoTrack);

    options = Object.assign({
      workaroundSilentLocalVideo: guessBrowser() === 'safari' && typeof document !== 'undefined' && typeof document.createElement === 'function'
    }, options);

    var _this = _possibleConstructorReturn(this, (LocalVideoTrack.__proto__ || Object.getPrototypeOf(LocalVideoTrack)).call(this, mediaStreamTrack, options));

    Object.defineProperties(_this, {
      _workaroundSilentLocalVideo: {
        value: options.workaroundSilentLocalVideo ? workaroundSilentLocalVideo : null
      },
      _workaroundSilentLocalVideoCleanup: {
        value: null,
        writable: true
      }
    });

    // NOTE(mmalavalli): In iOS Safari, we work around a bug where local video
    // MediaStreamTracks are silent (even though they are enabled, live and unmuted)
    // after accepting/rejecting a phone call.
    if (_this._workaroundSilentLocalVideo) {
      _this._workaroundSilentLocalVideoCleanup = _this._workaroundSilentLocalVideo(_this, document);
    }
    return _this;
  }

  _createClass(LocalVideoTrack, [{
    key: 'toString',
    value: function toString() {
      return '[LocalVideoTrack #' + this._instanceId + ': ' + this.id + ']';
    }

    /**
     * @private
     */

  }, {
    key: '_end',
    value: function _end() {
      return _get(LocalVideoTrack.prototype.__proto__ || Object.getPrototypeOf(LocalVideoTrack.prototype), '_end', this).apply(this, arguments);
    }

    /**
     * Disable the {@link LocalVideoTrack}. This is effectively "pause".
     * @returns {this}
     * @fires VideoTrack#disabled
     */

  }, {
    key: 'disable',
    value: function disable() {
      return _get(LocalVideoTrack.prototype.__proto__ || Object.getPrototypeOf(LocalVideoTrack.prototype), 'disable', this).apply(this, arguments);
    }

    /**
     * Enable the {@link LocalVideoTrack}. This is effectively "unpause".
     * @returns {this}
     * @fires VideoTrack#enabled
    */ /**
       * Enable or disable the {@link LocalVideoTrack}. This is effectively "unpause"
       * or "pause".
       * @param {boolean} [enabled] - Specify false to pause the
       *   {@link LocalVideoTrack}
       * @returns {this}
       * @fires VideoTrack#disabled
       * @fires VideoTrack#enabled
       */

  }, {
    key: 'enable',
    value: function enable() {
      return _get(LocalVideoTrack.prototype.__proto__ || Object.getPrototypeOf(LocalVideoTrack.prototype), 'enable', this).apply(this, arguments);
    }

    /**
     * Restart the {@link LocalVideoTrack}. This stops the existing MediaStreamTrack
     * and creates a new MediaStreamTrack. If the {@link LocalVideoTrack} is being published
     * to a {@link Room}, then all the {@link RemoteParticipant}s will start receiving media
     * from the newly created MediaStreamTrack. You can access the new MediaStreamTrack via
     * the <code>mediaStreamTrack</code> property. If you want to listen to events on
     * the MediaStreamTrack directly, please do so in the "started" event handler. Also,
     * the {@link LocalVideoTrack}'s ID is no longer guaranteed to be the same as the
     * underlying MediaStreamTrack's ID.
     * @param {MediaTrackConstraints} [constraints] - The optional <a href="https://developer.mozilla.org/en-US/docs/Web/API/MediaTrackConstraints" target="_blank">MediaTrackConstraints</a>
     *   for restarting the {@link LocalVideoTrack}; If not specified, then the current MediaTrackConstraints
     *   will be used; If <code>{}</code> (empty object) is specified, then the default MediaTrackConstraints
     *   will be used
     * @returns {Promise<void>} Rejects with a TypeError if the {@link LocalVideoTrack} was not created
     *   using an one of <code>createLocalVideoTrack</code>, <code>createLocalTracks</code> or <code>connect</code>;
     *   Also rejects with the <a href="https://developer.mozilla.org/en-US/docs/Web/API/MediaDevices/getUserMedia#Exceptions" target="_blank">DOMException</a>
     *   raised by <code>getUserMedia</code> when it fails
     * @fires LocalVideoTrack#stopped
     * @fires LocalVideoTrack#started
     * @example
     * const { connect, createLocalVideoTrack } = require('twilio-video');
     *
     * // Create a LocalVideoTrack that captures video from the front-facing camera.
     * createLocalVideoTrack({ facingMode: 'user' }).then(function(localVideoTrack) {
     *   return connect('token', {
     *     name: 'my-cool-room',
     *     tracks: [localVideoTrack]
     *   });
     * }).then(function(room) {
     *   // Restart the LocalVideoTrack to capture video from the back-facing camera.
     *   const localVideoTrack = Array.from(room.localParticipant.videoTracks.values())[0].track;
     *   return localVideoTrack.restart({ facingMode: 'environment' });
     * });
     */

  }, {
    key: 'restart',
    value: function restart() {
      var _this2 = this;

      if (this._workaroundSilentLocalVideoCleanup) {
        this._workaroundSilentLocalVideoCleanup();
        this._workaroundSilentLocalVideoCleanup = null;
      }
      var promise = _get(LocalVideoTrack.prototype.__proto__ || Object.getPrototypeOf(LocalVideoTrack.prototype), 'restart', this).apply(this, arguments);

      if (this._workaroundSilentLocalVideo) {
        promise.finally(function () {
          _this2._workaroundSilentLocalVideoCleanup = _this2._workaroundSilentLocalVideo(_this2, document);
        });
      }
      return promise;
    }

    /**
     * Calls stop on the underlying MediaStreamTrack. If you choose to stop a
     * {@link LocalVideoTrack}, you should unpublish it after stopping.
     * @returns {this}
     * @fires LocalVideoTrack#stopped
     */

  }, {
    key: 'stop',
    value: function stop() {
      if (this._workaroundSilentLocalVideoCleanup) {
        this._workaroundSilentLocalVideoCleanup();
        this._workaroundSilentLocalVideoCleanup = null;
      }
      return _get(LocalVideoTrack.prototype.__proto__ || Object.getPrototypeOf(LocalVideoTrack.prototype), 'stop', this).apply(this, arguments);
    }
  }]);

  return LocalVideoTrack;
}(LocalMediaVideoTrack);

/**
 * Work around a bug where local video MediaStreamTracks are silent (even though
 * they are enabled, live and unmuted) after accepting/rejecting a phone call.
 * @private
 * @param {LocalVideoTrack} localVideoTrack
 * @param {HTMLDocument} doc
 * @returns {function} Cleans up listeners attached by the workaround
 */


function workaroundSilentLocalVideo(localVideoTrack, doc) {
  var log = localVideoTrack._log;
  var el = localVideoTrack._dummyEl,
      mediaStreamTrack = localVideoTrack.mediaStreamTrack;


  function onUnmute() {
    if (!localVideoTrack.isEnabled) {
      return;
    }
    log.info('Unmuted, checking silence');

    // The dummy element is paused, so play it and then detect silence.
    el.play().then(function () {
      return detectSilentVideo(el, doc);
    }).then(function (isSilent) {
      if (!isSilent) {
        log.info('Non-silent frames detected, so no need to restart');
        return;
      }
      log.warn('Silence detected, restarting');

      // NOTE(mmalavalli): If we try and restart a silent MediaStreamTrack
      // without stopping it first, then a NotReadableError is raised. Hence,
      // we stop the MediaStreamTrack here.
      localVideoTrack._stop();

      // Restart the LocalVideoTrack.
      // eslint-disable-next-line consistent-return
      return localVideoTrack._restart();
    }).catch(function (error) {
      log.warn('Failed to detect silence and restart:', error);
    }).finally(function () {
      // If silent frames were not detected, then pause the dummy element again.
      el = localVideoTrack._dummyEl;
      if (!el.paused) {
        el.pause();
      }

      // Reset the unmute handler.
      mediaStreamTrack.removeEventListener('unmute', onUnmute);
      mediaStreamTrack = localVideoTrack.mediaStreamTrack;
      mediaStreamTrack.addEventListener('unmute', onUnmute);
    });
  }

  // Set the unmute handler.
  mediaStreamTrack.addEventListener('unmute', onUnmute);

  return function () {
    mediaStreamTrack.removeEventListener('unmute', onUnmute);
  };
}

/**
 * The {@link LocalVideoTrack} was disabled, i.e. "muted".
 * @param {LocalVideoTrack} track - The {@link LocalVideoTrack} that was
 *   disabled
 * @event LocalVideoTrack#disabled
 */

/**
 * The {@link LocalVideoTrack} was enabled, i.e. "unmuted".
 * @param {LocalVideoTrack} track - The {@link LocalVideoTrack} that was enabled
 * @event LocalVideoTrack#enabled
 */

/**
 * The {@link LocalVideoTrack} started. This means there is enough video data
 * to begin playback.
 * @param {LocalVideoTrack} track - The {@link LocalVideoTrack} that started
 * @event LocalVideoTrack#started
 */

/**
 * The {@link LocalVideoTrack} stopped, either because {@link LocalVideoTrack#stop}
 * or {@link LocalVideoTrack#restart} was called or because the underlying
 * MediaStreamTrack ended.
 * @param {LocalVideoTrack} track - The {@link LocalVideoTrack} that stopped
 * @event LocalVideoTrack#stopped
 */

module.exports = LocalVideoTrack;
},{"../../util/detectsilentvideo":110,"./localmediatrack":23,"./videotrack":40,"@twilio/webrtc/lib/util":149}],26:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var LocalTrackPublication = require('./localtrackpublication');

/**
 * A {@link LocalVideoTrackPublication} is a {@link LocalVideoTrack} that has
 * been published to a {@link Room}.
 * @extends LocalTrackPublication
 * @property {Track.Kind} kind - "video"
 * @property {LocalVideoTrack} track - the {@link LocalVideoTrack}
 */

var LocalVideoTrackPublication = function (_LocalTrackPublicatio) {
  _inherits(LocalVideoTrackPublication, _LocalTrackPublicatio);

  /**
   * Construct a {@link LocalVideoTrackPublication}.
   * @param {LocalTrackPublicationSignaling} signaling - The corresponding
   *   {@link LocalTrackPublicationSignaling}
   * @param {LocalVideoTrack} track - the {@link LocalVideoTrack}
   * @param {function(LocalTrackPublication): void} unpublish - The callback
   *    that unpublishes the {@link LocalTrackPublication}
   * @param {TrackPublicationOptions} options - {@link LocalTrackPublication} options
   */
  function LocalVideoTrackPublication(signaling, track, unpublish, options) {
    _classCallCheck(this, LocalVideoTrackPublication);

    return _possibleConstructorReturn(this, (LocalVideoTrackPublication.__proto__ || Object.getPrototypeOf(LocalVideoTrackPublication)).call(this, signaling, track, unpublish, options));
  }

  _createClass(LocalVideoTrackPublication, [{
    key: 'toString',
    value: function toString() {
      return '[LocalVideoTrackPublication #' + this._instanceId + ': ' + this.trackSid + ']';
    }
  }]);

  return LocalVideoTrackPublication;
}(LocalTrackPublication);

module.exports = LocalVideoTrackPublication;
},{"./localtrackpublication":24}],27:[function(require,module,exports){
'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('@twilio/webrtc/lib/util'),
    guessBrowser = _require.guessBrowser;

var _require2 = require('@twilio/webrtc'),
    MediaStream = _require2.MediaStream;

var _require3 = require('../../util'),
    waitForEvent = _require3.waitForEvent,
    waitForSometime = _require3.waitForSometime;

var localMediaRestartDeferreds = require('../../util/localmediarestartdeferreds');
var Track = require('./');

/**
 * A {@link MediaTrack} represents audio or video that can be sent to or
 * received from a {@link Room}.
 * @extends Track
 * @property {Track.ID} id - This {@link Track}'s ID
 * @property {boolean} isStarted - Whether or not the {@link MediaTrack} has
 *   started
 * @property {boolean} isEnabled - Whether or not the {@link MediaTrack} is
 *   enabled (i.e., whether it is paused or muted)
 * @property {Track.Kind} kind - The kind of the underlying
 *   MediaStreamTrack, "audio" or "video"
 * @property {MediaStreamTrack} mediaStreamTrack - The underlying
 *   MediaStreamTrack
 * @emits MediaTrack#disabled
 * @emits MediaTrack#enabled
 * @emits MediaTrack#started
 */

var MediaTrack = function (_Track) {
  _inherits(MediaTrack, _Track);

  /**
   * Construct a {@link MediaTrack}.
   * @param {MediaTrackTransceiver} mediaTrackTransceiver
   * @param {{log: Log}} options
   */
  function MediaTrack(mediaTrackTransceiver, options) {
    _classCallCheck(this, MediaTrack);

    options = Object.assign({
      playPausedElementsIfNotBackgrounded: guessBrowser() === 'safari' && (typeof document === 'undefined' ? 'undefined' : _typeof(document)) === 'object' && typeof document.addEventListener === 'function' && typeof document.visibilityState === 'string'
    }, options);

    var _this = _possibleConstructorReturn(this, (MediaTrack.__proto__ || Object.getPrototypeOf(MediaTrack)).call(this, mediaTrackTransceiver.id, mediaTrackTransceiver.kind, options));

    var isStarted = false;

    options = Object.assign({
      MediaStream: MediaStream
    }, options);

    /* istanbul ignore next */
    Object.defineProperties(_this, {
      _attachments: {
        value: new Set()
      },
      _dummyEl: {
        value: null,
        writable: true
      },
      _elShims: {
        value: new WeakMap()
      },
      _isStarted: {
        get: function get() {
          return isStarted;
        },
        set: function set(_isStarted) {
          isStarted = _isStarted;
        }
      },
      _playPausedElementsIfNotBackgrounded: {
        value: options.playPausedElementsIfNotBackgrounded
      },
      _shouldShimAttachedElements: {
        value: options.workaroundWebKitBug212780 || options.playPausedElementsIfNotBackgrounded
      },
      _MediaStream: {
        value: options.MediaStream
      },
      isStarted: {
        enumerable: true,
        get: function get() {
          return isStarted;
        }
      },
      mediaStreamTrack: {
        enumerable: true,
        get: function get() {
          return mediaTrackTransceiver.track;
        }
      }
    });

    _this._initialize();
    return _this;
  }

  /**
   * @private
   */


  _createClass(MediaTrack, [{
    key: '_start',
    value: function _start() {
      this._log.debug('Started');
      this._isStarted = true;
      if (this._dummyEl) {
        this._dummyEl.oncanplay = null;
      }
      // eslint-disable-next-line no-use-before-define
      this.emit('started', this);
    }

    /**
     * @private
     */

  }, {
    key: '_initialize',
    value: function _initialize() {
      var self = this;

      this._log.debug('Initializing');
      this._dummyEl = this._createElement();

      this.mediaStreamTrack.addEventListener('ended', function onended() {
        self._end();
        self.mediaStreamTrack.removeEventListener('ended', onended);
      });

      if (this._dummyEl) {
        this._dummyEl.muted = true;
        this._dummyEl.oncanplay = this._start.bind(this, this._dummyEl);
        this._attach(this._dummyEl);
        this._attachments.delete(this._dummyEl);
      }
    }

    /**
     * @private
     */

  }, {
    key: '_end',
    value: function _end() {
      this._log.debug('Ended');
      if (this._dummyEl) {
        this._detachElement(this._dummyEl);
        this._dummyEl.oncanplay = null;
      }
    }
  }, {
    key: 'attach',
    value: function attach(el) {
      var _this2 = this;

      if (typeof el === 'string') {
        el = this._selectElement(el);
      } else if (!el) {
        el = this._createElement();
      }
      this._log.debug('Attempting to attach to element:', el);
      el = this._attach(el);

      if (this._shouldShimAttachedElements && !this._elShims.has(el)) {
        var onUnintentionallyPaused = this._playPausedElementsIfNotBackgrounded ? function () {
          return playIfPausedAndNotBackgrounded(el, _this2._log);
        } : null;
        this._elShims.set(el, shimMediaElement(el, onUnintentionallyPaused));
      }

      return el;
    }

    /**
     * @private
     */

  }, {
    key: '_attach',
    value: function _attach(el) {
      var mediaStream = el.srcObject;
      if (!(mediaStream instanceof this._MediaStream)) {
        mediaStream = new this._MediaStream();
      }

      var getTracks = this.mediaStreamTrack.kind === 'audio' ? 'getAudioTracks' : 'getVideoTracks';

      mediaStream[getTracks]().forEach(function (mediaStreamTrack) {
        mediaStream.removeTrack(mediaStreamTrack);
      });
      mediaStream.addTrack(this.mediaStreamTrack);

      // NOTE(mpatwardhan): resetting `srcObject` here, causes flicker (JSDK-2641), but it lets us
      // to sidestep the a chrome bug: https://bugs.chromium.org/p/chromium/issues/detail?id=1052353
      //
      el.srcObject = mediaStream;
      el.autoplay = true;
      el.playsInline = true;

      if (!this._attachments.has(el)) {
        this._attachments.add(el);
      }

      return el;
    }

    /**
     * @private
     */

  }, {
    key: '_selectElement',
    value: function _selectElement(selector) {
      var el = document.querySelector(selector);

      if (!el) {
        throw new Error('Selector matched no element: ' + selector);
      }

      return el;
    }

    /**
     * @private
     */

  }, {
    key: '_createElement',
    value: function _createElement() {
      return typeof document !== 'undefined' ? document.createElement(this.kind) : null;
    }
  }, {
    key: 'detach',
    value: function detach(el) {
      var els = void 0;

      if (typeof el === 'string') {
        els = [this._selectElement(el)];
      } else if (!el) {
        els = this._getAllAttachedElements();
      } else {
        els = [el];
      }

      this._log.debug('Attempting to detach from elements:', els);
      this._detachElements(els);
      return el ? els[0] : els;
    }

    /**
     * @private
     */

  }, {
    key: '_detachElements',
    value: function _detachElements(elements) {
      return elements.map(this._detachElement.bind(this));
    }

    /**
     * @private
     */

  }, {
    key: '_detachElement',
    value: function _detachElement(el) {
      if (!this._attachments.has(el)) {
        return el;
      }

      var mediaStream = el.srcObject;
      if (mediaStream instanceof this._MediaStream) {
        mediaStream.removeTrack(this.mediaStreamTrack);
      }

      this._attachments.delete(el);

      if (this._shouldShimAttachedElements && this._elShims.has(el)) {
        var shim = this._elShims.get(el);
        shim.unShim();
        this._elShims.delete(el);
      }

      return el;
    }

    /**
     * @private
     */

  }, {
    key: '_getAllAttachedElements',
    value: function _getAllAttachedElements() {
      var els = [];

      this._attachments.forEach(function (el) {
        els.push(el);
      });

      return els;
    }
  }]);

  return MediaTrack;
}(Track);

/**
 * Play an HTMLMediaElement if it is paused and not backgrounded.
 * @private
 * @param {HTMLMediaElement} el
 * @param {Log} log
 * @returns {void}
 */


function playIfPausedAndNotBackgrounded(el, log) {
  var tag = el.tagName.toLowerCase();
  log.warn('Unintentionally paused:', el);

  // NOTE(mmalavalli): When the element is unintentionally paused, we wait one
  // second for the "onvisibilitychange" event on the HTMLDocument to see if the
  // app will be backgrounded. If not, then the element can be safely played.
  Promise.race([waitForEvent(document, 'visibilitychange'), waitForSometime(1000)]).then(function () {
    if (document.visibilityState === 'visible') {
      // NOTE(mmalavalli): We play the inadvertently paused elements only after
      // the LocalAudioTrack is unmuted to work around WebKit Bug 213853.
      //
      // Bug: https://bugs.webkit.org/show_bug.cgi?id=213853
      //
      localMediaRestartDeferreds.whenResolved('audio').then(function () {
        log.info('Playing unintentionally paused <' + tag + '> element');
        log.debug('Element:', el);
        return el.play();
      }).then(function () {
        log.info('Successfully played unintentionally paused <' + tag + '> element');
        log.debug('Element:', el);
      }).catch(function (error) {
        log.warn('Error while playing unintentionally paused <' + tag + '> element:', { error: error, el: el });
      });
    }
  });
}

/**
 * Shim the pause() and play() methods of the given HTMLMediaElement so that
 * we can detect if it was paused unintentionally.
 * @param {HTMLMediaElement} el
 * @param {?function} [onUnintentionallyPaused=null]
 * @returns {{pausedIntentionally: function, unShim: function}}
 */
function shimMediaElement(el) {
  var onUnintentionallyPaused = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

  var origPause = el.pause;
  var origPlay = el.play;

  var _pausedIntentionally = false;

  el.pause = function () {
    _pausedIntentionally = true;
    return origPause.call(el);
  };

  el.play = function () {
    _pausedIntentionally = false;
    return origPlay.call(el);
  };

  var onPause = onUnintentionallyPaused ? function () {
    if (!_pausedIntentionally) {
      onUnintentionallyPaused();
    }
  } : null;

  if (onPause) {
    el.addEventListener('pause', onPause);
  }

  return {
    pausedIntentionally: function pausedIntentionally() {
      return _pausedIntentionally;
    },
    unShim: function unShim() {
      el.pause = origPause;
      el.play = origPlay;
      if (onPause) {
        el.removeEventListener('pause', onPause);
      }
    }
  };
}

module.exports = MediaTrack;
},{"../../util":114,"../../util/localmediarestartdeferreds":117,"./":18,"@twilio/webrtc":136,"@twilio/webrtc/lib/util":149}],28:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var MediaTrackTransceiver = require('./transceiver');

/**
 * A {@link MediaTrackReceiver} represents a remote MediaStreamTrack.
 * @extends MediaTrackTransceiver
 */

var MediaTrackReceiver = function (_MediaTrackTransceive) {
  _inherits(MediaTrackReceiver, _MediaTrackTransceive);

  /**
   * Construct a {@link MediaTrackReceiver}.
   * @param {Track.ID} id - The MediaStreamTrack ID signaled through RSP/SDP
   * @param {MediaStreamTrack} mediaStreamTrack - The remote MediaStreamTrack
   */
  function MediaTrackReceiver(id, mediaStreamTrack) {
    _classCallCheck(this, MediaTrackReceiver);

    return _possibleConstructorReturn(this, (MediaTrackReceiver.__proto__ || Object.getPrototypeOf(MediaTrackReceiver)).call(this, id, mediaStreamTrack));
  }

  return MediaTrackReceiver;
}(MediaTrackTransceiver);

module.exports = MediaTrackReceiver;
},{"./transceiver":39}],29:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var AudioTrack = require('./audiotrack');
var mixinRemoteMediaTrack = require('./remotemediatrack');

var RemoteMediaAudioTrack = mixinRemoteMediaTrack(AudioTrack);

/**
 * A {@link RemoteAudioTrack} represents an {@link AudioTrack} published to a
 * {@link Room} by a {@link RemoteParticipant}.
 * @extends AudioTrack
 * @property {boolean} isEnabled - Whether the {@link RemoteAudioTrack} is enabled
 * @property {boolean} isSwitchedOff - Whether the {@link RemoteAudioTrack} is switched off
 * @property {Track.SID} sid - The {@link RemoteAudioTrack}'s SID
 * @property {?Track.Priority} priority - The subscribe priority of the {@link RemoteAudioTrack}
 * @emits RemoteAudioTrack#disabled
 * @emits RemoteAudioTrack#enabled
 * @emits RemoteAudioTrack#started
 * @emits RemoteAudioTrack#switchedOff
 * @emits RemoteAudioTrack#switchedOn
 */

var RemoteAudioTrack = function (_RemoteMediaAudioTrac) {
  _inherits(RemoteAudioTrack, _RemoteMediaAudioTrac);

  /**
   * Construct a {@link RemoteAudioTrack}.
   * @param {Track.SID} sid - The {@link RemoteAudioTrack}'s SID
   * @param {MediaTrackReceiver} mediaTrackReceiver - An audio MediaStreamTrack container
   * @param {boolean} isEnabled - Whether the {@link RemoteAudioTrack} is enabled
   * @param {function(?Track.Priority): void} setPriority - Set or clear the subscribe
   *  {@link Track.Priority} of the {@link RemoteAudioTrack}
   * @param {{log: Log}} options - The {@link RemoteTrack} options
   */
  function RemoteAudioTrack(sid, mediaTrackReceiver, isEnabled, setPriority, options) {
    _classCallCheck(this, RemoteAudioTrack);

    return _possibleConstructorReturn(this, (RemoteAudioTrack.__proto__ || Object.getPrototypeOf(RemoteAudioTrack)).call(this, sid, mediaTrackReceiver, isEnabled, setPriority, options));
  }

  _createClass(RemoteAudioTrack, [{
    key: 'toString',
    value: function toString() {
      return '[RemoteAudioTrack #' + this._instanceId + ': ' + this.sid + ']';
    }

    /**
     * Update the subscribe {@link Track.Priority} of the {@link RemoteAudioTrack}.
     * @param {?Track.Priority} priority - the new subscribe {@link Track.Priority};
     *   Currently setPriority has no effect on audio tracks.
     * @returns {this}
     * @throws {RangeError}
     */

  }, {
    key: 'setPriority',
    value: function setPriority(priority) {
      return _get(RemoteAudioTrack.prototype.__proto__ || Object.getPrototypeOf(RemoteAudioTrack.prototype), 'setPriority', this).call(this, priority);
    }
  }]);

  return RemoteAudioTrack;
}(RemoteMediaAudioTrack);

/**
 * The {@link RemoteAudioTrack} was disabled, i.e. "muted".
 * @param {RemoteAudioTrack} track - The {@link RemoteAudioTrack} that was
 *   disabled
 * @event RemoteAudioTrack#disabled
 */

/**
 * The {@link RemoteAudioTrack} was enabled, i.e. "unmuted".
 * @param {RemoteAudioTrack} track - The {@link RemoteAudioTrack} that was
 *   enabled
 * @event RemoteAudioTrack#enabled
 */

/**
 * The {@link RemoteAudioTrack} started. This means there is enough audio data
 * to begin playback.
 * @param {RemoteAudioTrack} track - The {@link RemoteAudioTrack} that started
 * @event RemoteAudioTrack#started
 */

/**
 * A {@link RemoteAudioTrack} was switched off.
 * @param {RemoteAudioTrack} track - The {@link RemoteAudioTrack} that was
 *   switched off
 * @event RemoteAudioTrack#switchedOff
 */

/**
 * A {@link RemoteAudioTrack} was switched on.
 * @param {RemoteAudioTrack} track - The {@link RemoteAudioTrack} that was
 *   switched on
 * @event RemoteAudioTrack#switchedOn
 */

module.exports = RemoteAudioTrack;
},{"./audiotrack":13,"./remotemediatrack":33}],30:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var RemoteTrackPublication = require('./remotetrackpublication');

/**
 * A {@link RemoteAudioTrackPublication} represents a {@link RemoteAudioTrack}
 * that has been published to a {@link Room}.
 * @property {Track.Kind} kind - "audio"
 * @property {?RemoteAudioTrack} track - unless you have subscribed to the
 *   {@link RemoteAudioTrack}, this property is null
 * @emits RemoteAudioTrackPublication#subscribed
 * @emits RemoteAudioTrackPublication#subscriptionFailed
 * @emits RemoteAudioTrackPublication#trackDisabled
 * @emits RemoteAudioTrackPublication#trackEnabled
 * @emits RemoteAudioTrackPublication#unsubscribed
 */

var RemoteAudioTrackPublication = function (_RemoteTrackPublicati) {
  _inherits(RemoteAudioTrackPublication, _RemoteTrackPublicati);

  /**
   * Construct a {@link RemoteAudioTrackPublication}.
   * @param {RemoteTrackPublicationSignaling} signaling - {@link RemoteTrackPublication} signaling
   * @param {RemoteTrackPublicationOptions} options - {@link RemoteTrackPublication}
   *   options
   */
  function RemoteAudioTrackPublication(signaling, options) {
    _classCallCheck(this, RemoteAudioTrackPublication);

    return _possibleConstructorReturn(this, (RemoteAudioTrackPublication.__proto__ || Object.getPrototypeOf(RemoteAudioTrackPublication)).call(this, signaling, options));
  }

  _createClass(RemoteAudioTrackPublication, [{
    key: 'toString',
    value: function toString() {
      return '[RemoteAudioTrackPublication #' + this._instanceId + ': ' + this.trackSid + ']';
    }
  }]);

  return RemoteAudioTrackPublication;
}(RemoteTrackPublication);

/**
 * Your {@link LocalParticipant} subscribed to the {@link RemoteAudioTrack}.
 * @param {RemoteAudioTrack} track - the {@link RemoteAudioTrack} that was subscribed to
 * @event RemoteAudioTrackPublication#subscribed
 */

/**
 * Your {@link LocalParticipant} failed to subscribe to the {@link RemoteAudioTrack}.
 * @param {TwilioError} error - the reason the {@link RemoteAudioTrack} could not be
 *   subscribed to
 * @event RemoteAudioTrackPublication#subscriptionFailed
 */

/**
 * The {@link RemoteAudioTrack} was disabled.
 * @event RemoteAudioTrackPublication#trackDisabled
 */

/**
 * The {@link RemoteAudioTrack} was enabled.
 * @event RemoteAudioTrackPublication#trackEnabled
 */

/**
 * Your {@link LocalParticipant} unsubscribed from the {@link RemoteAudioTrack}.
 * @param {RemoteAudioTrack} track - the {@link RemoteAudioTrack} that was unsubscribed from
 * @event RemoteAudioTrackPublication#unsubscribed
 */

module.exports = RemoteAudioTrackPublication;
},{"./remotetrackpublication":34}],31:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Track = require('./');

var _require = require('../../util/constants'),
    E = _require.typeErrors,
    trackPriority = _require.trackPriority;

/**
 * A {@link RemoteDataTrack} represents data published to a {@link Room} by a
 * {@link RemoteParticipant}.
 * @extends Track
 * @property {boolean} isEnabled - true
 * @property {boolean} isSubscribed - Whether the {@link RemoteDataTrack} is
 *   subscribed to
 * @property {boolean} isSwitchedOff - Whether the {@link RemoteDataTrack} is
 *   switched off
 * @property {Track.Kind} kind - "data"
 * @property {?number} maxPacketLifeTime - If non-null, this represents a time
 *   limit (in milliseconds) during which data will be transmitted or
 *   retransmitted if not acknowledged on the underlying RTCDataChannel.
 * @property {?number} maxRetransmits - If non-null, this represents the number
 *   of times the data will be retransmitted if not successfully received on the
 *   underlying RTCDataChannel.
 * @property {boolean} ordered - true if data on the {@link RemoteDataTrack} can
 *   be received out-of-order.
 * @property {?Track.Priority} priority - The subscribe priority of the {@link RemoteDataTrack}
 * @property {boolean} reliable - This is true if both
 *   <code>maxPacketLifeTime</code> and <code>maxRetransmits</code> are set to
 *   null. In other words, if this is true, there is no bound on packet lifetime
 *   or the number of retransmits that will be attempted, ensuring "reliable"
 *   transmission.
 * @property {Track.SID} sid - The SID assigned to the {@link RemoteDataTrack}
 * @emits RemoteDataTrack#message
 * @emits RemoteDataTrack#switchedOff
 * @emits RemoteDataTrack#switchedOn
 */


var RemoteDataTrack = function (_Track) {
  _inherits(RemoteDataTrack, _Track);

  /**
   * Construct a {@link RemoteDataTrack} from a {@link DataTrackReceiver}.
   * @param {Track.SID} sid
   * @param {DataTrackReceiver} dataTrackReceiver
   * @param {{log: Log, name: ?string}} options
   */
  function RemoteDataTrack(sid, dataTrackReceiver, options) {
    _classCallCheck(this, RemoteDataTrack);

    var _this = _possibleConstructorReturn(this, (RemoteDataTrack.__proto__ || Object.getPrototypeOf(RemoteDataTrack)).call(this, dataTrackReceiver.id, 'data', options));

    Object.defineProperties(_this, {
      _isSwitchedOff: {
        value: false,
        writable: true
      },
      _priority: {
        value: null,
        writable: true
      },
      isEnabled: {
        enumerable: true,
        value: true
      },
      isSwitchedOff: {
        enumerable: true,
        get: function get() {
          return this._isSwitchedOff;
        }
      },
      maxPacketLifeTime: {
        enumerable: true,
        value: dataTrackReceiver.maxPacketLifeTime
      },
      maxRetransmits: {
        enumerable: true,
        value: dataTrackReceiver.maxRetransmits
      },
      ordered: {
        enumerable: true,
        value: dataTrackReceiver.ordered
      },
      priority: {
        enumerable: true,
        get: function get() {
          return this._priority;
        }
      },
      reliable: {
        enumerable: true,
        value: dataTrackReceiver.maxPacketLifeTime === null && dataTrackReceiver.maxRetransmits === null
      },
      sid: {
        enumerable: true,
        value: sid
      }
    });

    dataTrackReceiver.on('message', function (data) {
      _this.emit('message', data, _this);
    });
    return _this;
  }

  /**
   * Update the subscriber {@link Track.Priority} of the {@link RemoteDataTrack}.
   * @param {?Track.Priority} priority - the new {@link Track.priority};
   *   Currently setPriority has no effect on data tracks.
   * @returns {this}
   * @throws {RangeError}
   */


  _createClass(RemoteDataTrack, [{
    key: 'setPriority',
    value: function setPriority(priority) {
      var priorityValues = [null].concat(_toConsumableArray(Object.values(trackPriority)));
      if (!priorityValues.includes(priority)) {
        // eslint-disable-next-line new-cap
        throw E.INVALID_VALUE('priority', priorityValues);
      }

      // Note: priority has no real effect on the data tracks.
      this._priority = priority;
      return this;
    }

    /**
     * @private
     */

  }, {
    key: '_setEnabled',
    value: function _setEnabled() {}
    // Do nothing.


    /**
     * @private
     * @param {boolean} isSwitchedOff
     */

  }, {
    key: '_setSwitchedOff',
    value: function _setSwitchedOff(isSwitchedOff) {
      if (this._isSwitchedOff !== isSwitchedOff) {
        this._isSwitchedOff = isSwitchedOff;
        this.emit(isSwitchedOff ? 'switchedOff' : 'switchedOn', this);
      }
    }
  }]);

  return RemoteDataTrack;
}(Track);

/**
 * A message was received over the {@link RemoteDataTrack}.
 * @event RemoteDataTrack#message
 * @param {string|ArrayBuffer} data
 * @param {RemoteDataTrack} track - The {@link RemoteDataTrack} that received
 *   the message
 */

/**
 * A {@link RemoteDataTrack} was switched off.
 * @param {RemoteDataTrack} track - The {@link RemoteDataTrack} that was
 *   switched off
 * @event RemoteDataTrack#switchedOff
 */

/**
 * A {@link RemoteDataTrack} was switched on.
 * @param {RemoteDataTrack} track - The {@link RemoteDataTrack} that was
 *   switched on
 * @event RemoteDataTrack#switchedOn
 */

module.exports = RemoteDataTrack;
},{"../../util/constants":108,"./":18}],32:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var RemoteTrackPublication = require('./remotetrackpublication');

/**
 * A {@link RemoteDataTrackPublication} represents a {@link RemoteDataTrack}
 * that has been published to a {@link Room}.
 * @property {Track.Kind} kind - "data"
 * @property {?RemoteDataTrack} track - unless you have subscribed to the
 *   {@link RemoteDataTrack}, this property is null
 * @emits RemoteDataTrackPublication#subscribed
 * @emits RemoteDataTrackPublication#subscriptionFailed
 * @emits RemoteDataTrackPublication#unsubscribed
 */

var RemoteDataTrackPublication = function (_RemoteTrackPublicati) {
  _inherits(RemoteDataTrackPublication, _RemoteTrackPublicati);

  /**
   * Construct a {@link RemoteDataTrackPublication}.
   * @param {RemoteTrackPublicationSignaling} signaling - {@link RemoteTrackPublication} signaling
   * @param {RemoteTrackPublicationOptions} options - {@link RemoteTrackPublication}
   *   options
   */
  function RemoteDataTrackPublication(signaling, options) {
    _classCallCheck(this, RemoteDataTrackPublication);

    return _possibleConstructorReturn(this, (RemoteDataTrackPublication.__proto__ || Object.getPrototypeOf(RemoteDataTrackPublication)).call(this, signaling, options));
  }

  _createClass(RemoteDataTrackPublication, [{
    key: 'toString',
    value: function toString() {
      return '[RemoteDataTrackPublication #' + this._instanceId + ': ' + this.trackSid + ']';
    }
  }]);

  return RemoteDataTrackPublication;
}(RemoteTrackPublication);

/**
 * Your {@link LocalParticipant} subscribed to the {@link RemoteDataTrack}.
 * @param {RemoteDataTrack} track - the {@link RemoteDataTrack} that was subscribed to
 * @event RemoteDataTrackPublication#subscribed
 */

/**
 * Your {@link LocalParticipant} failed to subscribe to the {@link RemoteDataTrack}.
 * @param {TwilioError} error - the reason the {@link RemoteDataTrack} could not be
 *   subscribed to
 * @event RemoteDataTrackPublication#subscriptionFailed
 */

/**
 * Your {@link LocalParticipant} unsubscribed from the {@link RemoteDataTrack}.
 * @param {RemoteDataTrack} track - the {@link RemoteDataTrack} that was unsubscribed from
 * @event RemoteDataTrackPublication#unsubscribed
 */

module.exports = RemoteDataTrackPublication;
},{"./remotetrackpublication":34}],33:[function(require,module,exports){
'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('../../util/constants'),
    E = _require.typeErrors,
    trackPriority = _require.trackPriority;

var _require2 = require('@twilio/webrtc/lib/util'),
    guessBrowser = _require2.guessBrowser;

var documentVisibilityMonitor = require('../../util/documentvisibilitymonitor.js');

function mixinRemoteMediaTrack(AudioOrVideoTrack) {
  /**
   * A {@link RemoteMediaTrack} represents a {@link MediaTrack} published to a
   * {@link Room} by a {@link RemoteParticipant}.
   * @property {boolean} isEnabled - Whether the {@link RemoteMediaTrack} is enabled
   * @property {boolean} isSwitchedOff - Whether the {@link RemoteMediaTrack} is switched off
   * @property {Track.SID} sid - The SID assigned to the {@link RemoteMediaTrack}
   * @property {?Track.Priority} priority - The subscribe priority of the {@link RemoteMediaTrack}
   * @emits RemoteMediaTrack#disabled
   * @emits RemoteMediaTrack#enabled
   * @emits RemoteMediaTrack#switchedOff
   * @emits RemoteMediaTrack#switchedOn
   */
  return function (_AudioOrVideoTrack) {
    _inherits(RemoteMediaTrack, _AudioOrVideoTrack);

    /**
     * Construct a {@link RemoteMediaTrack}.
     * @param {Track.SID} sid
     * @param {MediaTrackReceiver} mediaTrackReceiver
     * @param {boolean} isEnabled
     * @param {function(?Track.Priority): void} setPriority - Set or clear the subscribe
     *  {@link Track.Priority} of the {@link RemoteMediaTrack}
     * @param {{log: Log, name: ?string}} options
     */
    function RemoteMediaTrack(sid, mediaTrackReceiver, isEnabled, setPriority, options) {
      _classCallCheck(this, RemoteMediaTrack);

      options = Object.assign({
        // NOTE(mpatwardhan): WebKit bug: 212780 sometimes causes the audio/video elements to stay paused when safari
        // regains foreground. To workaround it, when safari gains foreground - we will play any elements that were
        // playing before safari lost foreground.
        workaroundWebKitBug212780: guessBrowser() === 'safari' && (typeof document === 'undefined' ? 'undefined' : _typeof(document)) === 'object' && typeof document.addEventListener === 'function' && typeof document.visibilityState === 'string'
      }, options);

      var _this = _possibleConstructorReturn(this, (RemoteMediaTrack.__proto__ || Object.getPrototypeOf(RemoteMediaTrack)).call(this, mediaTrackReceiver, options));

      Object.defineProperties(_this, {
        _isEnabled: {
          value: isEnabled,
          writable: true
        },
        _isSwitchedOff: {
          value: false,
          writable: true
        },
        _priority: {
          value: null,
          writable: true
        },
        _setPriority: {
          value: setPriority
        },
        isEnabled: {
          enumerable: true,
          get: function get() {
            return this._isEnabled;
          }
        },
        isSwitchedOff: {
          enumerable: true,
          get: function get() {
            return this._isSwitchedOff;
          }
        },
        priority: {
          enumerable: true,
          get: function get() {
            return this._priority;
          }
        },
        sid: {
          enumerable: true,
          value: sid
        },
        _workaroundWebKitBug212780: {
          value: options.workaroundWebKitBug212780
        },
        _workaroundWebKitBug212780Cleanup: {
          value: null,
          writable: true
        }
      });
      return _this;
    }

    /**
     * Update the subscribe {@link Track.Priority} of the {@link RemoteMediaTrack}.
     * @param {?Track.Priority} priority - the new subscribe {@link Track.Priority};
     *   If <code>null</code>, then the subscribe {@link Track.Priority} is cleared, which
     *   means the {@link Track.Priority} set by the publisher is now the effective priority.
     * @returns {this}
     * @throws {RangeError}
     */


    _createClass(RemoteMediaTrack, [{
      key: 'setPriority',
      value: function setPriority(priority) {
        var priorityValues = [null].concat(_toConsumableArray(Object.values(trackPriority)));
        if (!priorityValues.includes(priority)) {
          // eslint-disable-next-line new-cap
          throw E.INVALID_VALUE('priority', priorityValues);
        }
        if (this._priority !== priority) {
          this._priority = priority;
          this._setPriority(priority);
        }
        return this;
      }

      /**
       * @private
       * @param {boolean} isEnabled
       */

    }, {
      key: '_setEnabled',
      value: function _setEnabled(isEnabled) {
        if (this._isEnabled !== isEnabled) {
          this._isEnabled = isEnabled;
          this.emit(this._isEnabled ? 'enabled' : 'disabled', this);
        }
      }

      /**
       * @private
       * @param {boolean} isSwitchedOff
       */

    }, {
      key: '_setSwitchedOff',
      value: function _setSwitchedOff(isSwitchedOff) {
        if (this._isSwitchedOff !== isSwitchedOff) {
          this._isSwitchedOff = isSwitchedOff;
          this.emit(isSwitchedOff ? 'switchedOff' : 'switchedOn', this);
        }
      }
    }, {
      key: 'attach',
      value: function attach(el) {
        var result = _get(RemoteMediaTrack.prototype.__proto__ || Object.getPrototypeOf(RemoteMediaTrack.prototype), 'attach', this).call(this, el);
        if (this.mediaStreamTrack.enabled !== true) {
          // NOTE(mpatwardhan): we disable mediaStreamTrack when there
          // are no attachments to it (see notes below). Now that there
          // are attachments re-enable the track.
          this.mediaStreamTrack.enabled = true;
        }
        if (this._workaroundWebKitBug212780) {
          this._workaroundWebKitBug212780Cleanup = this._workaroundWebKitBug212780Cleanup || playIfPausedWhileInBackground(this);
        }

        return result;
      }
    }, {
      key: 'detach',
      value: function detach(el) {
        var result = _get(RemoteMediaTrack.prototype.__proto__ || Object.getPrototypeOf(RemoteMediaTrack.prototype), 'detach', this).call(this, el);
        if (this._attachments.size === 0) {
          // NOTE(mpatwardhan): chrome continues playing webrtc audio
          // track even after audio element is removed from the DOM.
          // https://bugs.chromium.org/p/chromium/issues/detail?id=749928
          // to workaround: here disable the track when
          // there are no elements attached to it.
          this.mediaStreamTrack.enabled = false;

          if (this._workaroundWebKitBug212780Cleanup) {
            // unhook visibility change
            this._workaroundWebKitBug212780Cleanup();
            this._workaroundWebKitBug212780Cleanup = null;
          }
        }
        return result;
      }
    }]);

    return RemoteMediaTrack;
  }(AudioOrVideoTrack);
}

function playIfPausedWhileInBackground(remoteMediaTrack) {
  var log = remoteMediaTrack._log,
      kind = remoteMediaTrack.kind;


  function onVisibilityChanged() {
    remoteMediaTrack._attachments.forEach(function (el) {
      var shim = remoteMediaTrack._elShims.get(el);
      var isInadvertentlyPaused = el.paused && shim && !shim.pausedIntentionally();
      if (isInadvertentlyPaused) {
        log.info('Playing inadvertently paused <' + kind + '> element');
        log.debug('Element:', el);
        log.debug('RemoteMediaTrack:', remoteMediaTrack);
        el.play().then(function () {
          log.info('Successfully played inadvertently paused <' + kind + '> element');
          log.debug('Element:', el);
          log.debug('RemoteMediaTrack:', remoteMediaTrack);
        }).catch(function (err) {
          log.warn('Error while playing inadvertently paused <' + kind + '> element:', { err: err, el: el, remoteMediaTrack: remoteMediaTrack });
        });
      }
    });
  }

  // NOTE(mpatwardhan): listen for document visibility callback on phase 2.
  // this ensures that any LocalMediaTrack's restart (which listen on phase 1) gets executed
  // first. This order is important because we `play` tracks in the callback, and
  // play can fail on safari if audio is not being captured.
  documentVisibilityMonitor.onVisible(2, onVisibilityChanged);
  return function () {
    documentVisibilityMonitor.offVisible(2, onVisibilityChanged);
  };
}

/**
 * A {@link RemoteMediaTrack} was disabled.
 * @param {RemoteMediaTrack} track - The {@link RemoteMediaTrack} that was
 *   disabled
 * @event RemoteMediaTrack#disabled
 */

/**
 * A {@link RemoteMediaTrack} was enabled.
 * @param {RemoteMediaTrack} track - The {@link RemoteMediaTrack} that was
 *   enabled
 * @event RemoteMediaTrack#enabled
 */

/**
 * A {@link RemoteMediaTrack} was switched off.
 * @param {RemoteMediaTrack} track - The {@link RemoteMediaTrack} that was
 *   switched off
 * @event RemoteMediaTrack#switchedOff
 */

/**
 * A {@link RemoteMediaTrack} was switched on.
 * @param {RemoteMediaTrack} track - The {@link RemoteMediaTrack} that was
 *   switched on
 * @event RemoteMediaTrack#switchedOn
 */

module.exports = mixinRemoteMediaTrack;
},{"../../util/constants":108,"../../util/documentvisibilitymonitor.js":111,"@twilio/webrtc/lib/util":149}],34:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TrackPublication = require('./trackpublication');

/**
 * A {@link RemoteTrackPublication} represents a {@link RemoteTrack} that has
 * been published to a {@link Room}.
 * @extends TrackPublication
 * @property {boolean} isSubscribed - whether the published {@link RemoteTrack}
 *   is subscribed to
 * @property {boolean} isTrackEnabled - whether the published
 *   {@link RemoteTrack} is enabled
 * @property {Track.Kind} kind - kind of the published {@link RemoteTrack}
 * @property {Track.Priority} publishPriority - the {@link Track.Priority} of the published
 *   {@link RemoteTrack} set by the {@link RemoteParticipant}
 * @property {?RemoteTrack} track - Unless you have subscribed to the
 *   {@link RemoteTrack}, this property is null
 * @emits RemoteTrackPublication#publishPriorityChanged
 * @emits RemoteTrackPublication#subscribed
 * @emits RemoteTrackPublication#subscriptionFailed
 * @emits RemoteTrackPublication#trackDisabled
 * @emits RemoteTrackPublication#trackEnabled
 * @emits RemoteTrackPublication#trackSwitchedOff
 * @emits RemoteTrackPublication#trackSwitchedOn
 * @emits RemoteTrackPublication#unsubscribed
 *
 */

var RemoteTrackPublication = function (_TrackPublication) {
  _inherits(RemoteTrackPublication, _TrackPublication);

  /**
   * Construct a {@link RemoteTrackPublication}.
   * @param {RemoteTrackPublicationSignaling} signaling - {@link RemoteTrackPublication} signaling
   * @param {RemoteTrackPublicationOptions} options - {@link RemoteTrackPublication}
   *   options
   */
  function RemoteTrackPublication(signaling, options) {
    _classCallCheck(this, RemoteTrackPublication);

    var _this = _possibleConstructorReturn(this, (RemoteTrackPublication.__proto__ || Object.getPrototypeOf(RemoteTrackPublication)).call(this, signaling.name, signaling.sid, options));

    Object.defineProperties(_this, {
      _signaling: {
        value: signaling
      },
      _track: {
        value: null,
        writable: true
      },
      isSubscribed: {
        enumerable: true,
        get: function get() {
          return !!this._track;
        }
      },
      isTrackEnabled: {
        enumerable: true,
        get: function get() {
          return signaling.isEnabled;
        }
      },
      kind: {
        enumerable: true,
        value: signaling.kind
      },
      publishPriority: {
        enumerable: true,
        get: function get() {
          return signaling.priority;
        }
      },
      track: {
        enumerable: true,
        get: function get() {
          return this._track;
        }
      }
    });

    // remember original state, and fire events only on change.
    var error = signaling.error,
        isEnabled = signaling.isEnabled,
        isSwitchedOff = signaling.isSwitchedOff,
        priority = signaling.priority;


    signaling.on('updated', function () {
      if (error !== signaling.error) {
        error = signaling.error;
        _this.emit('subscriptionFailed', signaling.error);
        return;
      }
      if (isEnabled !== signaling.isEnabled) {
        isEnabled = signaling.isEnabled;
        if (_this.track) {
          _this.track._setEnabled(signaling.isEnabled);
        }
        _this.emit(signaling.isEnabled ? 'trackEnabled' : 'trackDisabled');
      }
      if (isSwitchedOff !== signaling.isSwitchedOff) {
        isSwitchedOff = signaling.isSwitchedOff;
        if (_this.track) {
          _this.track._setSwitchedOff(signaling.isSwitchedOff);
          _this.emit(signaling.isSwitchedOff ? 'trackSwitchedOff' : 'trackSwitchedOn', _this.track);
        }
      }
      if (priority !== signaling.priority) {
        priority = signaling.priority;
        _this.emit('publishPriorityChanged', priority);
      }
    });
    return _this;
  }

  _createClass(RemoteTrackPublication, [{
    key: 'toString',
    value: function toString() {
      return '[RemoteTrackPublication #' + this._instanceId + ': ' + this.trackSid + ']';
    }

    /**
     * @private
     * @param {RemoteTrack} track
     */

  }, {
    key: '_subscribed',
    value: function _subscribed(track) {
      if (!this._track && track) {
        this._track = track;
        this.emit('subscribed', track);
      }
    }

    /**
     * @private
     */

  }, {
    key: '_unsubscribe',
    value: function _unsubscribe() {
      if (this._track) {
        var track = this._track;
        this._track = null;
        this.emit('unsubscribed', track);
      }
    }
  }]);

  return RemoteTrackPublication;
}(TrackPublication);

/**
 * The {@link RemoteTrack}'s publish {@link Track.Priority} was changed by the
 * {@link RemoteParticipant}.
 * @param {Track.Priority} priority - the {@link RemoteTrack}'s new publish
 *   {@link Track.Priority}; RemoteTrackPublication#publishPriority is also
 *   updated accordingly
 * @event RemoteTrackPublication#publishPriorityChanged
 */

/**
 * Your {@link LocalParticipant} subscribed to the {@link RemoteTrack}.
 * @param {RemoteTrack} track - the {@link RemoteTrack} that was subscribed to
 * @event RemoteTrackPublication#subscribed
 */

/**
 * Your {@link LocalParticipant} failed to subscribe to the {@link RemoteTrack}.
 * @param {TwilioError} error - the reason the {@link RemoteTrack} could not be
 *   subscribed to
 * @event RemoteTrackPublication#subscriptionFailed
 */

/**
 * The {@link RemoteTrack} was disabled.
 * @event RemoteTrackPublication#trackDisabled
 */

/**
 * The {@link RemoteTrack} was enabled.
 * @event RemoteTrackPublication#trackEnabled
 */

/**
 * The {@link RemoteTrack} was switched off.
 * @param {RemoteTrack} track - the {@link RemoteTrack} that was switched off
 * @event RemoteTrackPublication#trackSwitchedOff
 */

/**
 * The {@link RemoteTrack} was switched on.
 * @param {RemoteTrack} track - the {@link RemoteTrack} that was switched on
 * @event RemoteTrackPublication#trackSwitchedOn
 */

/**
 * Your {@link LocalParticipant} unsubscribed from the {@link RemoteTrack}.
 * @param {RemoteTrack} track - the {@link RemoteTrack} that was unsubscribed from
 * @event RemoteTrackPublication#unsubscribed
 */

/**
 * {@link RemoteTrackPublication} options
 * @typedef {object} RemoteTrackPublicationOptions
 * @property {LogLevel|LogLevels} logLevel - Log level for 'media' modules
 */

module.exports = RemoteTrackPublication;
},{"./trackpublication":38}],35:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var mixinRemoteMediaTrack = require('./remotemediatrack');
var VideoTrack = require('./videotrack');

var RemoteMediaVideoTrack = mixinRemoteMediaTrack(VideoTrack);

/**
 * A {@link RemoteVideoTrack} represents a {@link VideoTrack} published to a
 * {@link Room} by a {@link RemoteParticipant}.
 * @extends VideoTrack
 * @property {boolean} isEnabled - Whether the {@link RemoteVideoTrack} is enabled
 * @property {boolean} isSwitchedOff - Whether the {@link RemoteVideoTrack} is switched off
 * @property {Track.SID} sid - The {@link RemoteVideoTrack}'s SID
 * @property {?Track.Priority} priority - The subscribe priority of the {@link RemoteVideoTrack}
 * @emits RemoteVideoTrack#dimensionsChanged
 * @emits RemoteVideoTrack#disabled
 * @emits RemoteVideoTrack#enabled
 * @emits RemoteVideoTrack#started
 * @emits RemoteVideoTrack#switchedOff
 * @emits RemoteVideoTrack#switchedOn
 */

var RemoteVideoTrack = function (_RemoteMediaVideoTrac) {
  _inherits(RemoteVideoTrack, _RemoteMediaVideoTrac);

  /**
   * Construct a {@link RemoteVideoTrack}.
   * @param {Track.SID} sid - The {@link RemoteVideoTrack}'s SID
   * @param {MediaTrackReceiver} mediaTrackReceiver - A video MediaStreamTrack container
   * @param {boolean} isEnabled - whether the {@link RemoteVideoTrack} is enabled
   * @param {function(?Track.Priority): void} setPriority - Set or clear the subscribe
   *  {@link Track.Priority} of the {@link RemoteVideoTrack}
   * @param {{log: Log}} options - The {@link RemoteTrack} options
   */
  function RemoteVideoTrack(sid, mediaTrackReceiver, isEnabled, setPriority, options) {
    _classCallCheck(this, RemoteVideoTrack);

    return _possibleConstructorReturn(this, (RemoteVideoTrack.__proto__ || Object.getPrototypeOf(RemoteVideoTrack)).call(this, sid, mediaTrackReceiver, isEnabled, setPriority, options));
  }

  _createClass(RemoteVideoTrack, [{
    key: 'toString',
    value: function toString() {
      return '[RemoteVideoTrack #' + this._instanceId + ': ' + this.sid + ']';
    }

    /**
     * Update the subscribe {@link Track.Priority} of the {@link RemoteVideoTrack}.
     * @param {?Track.Priority} priority - the new subscribe {@link Track.Priority};
     *   If <code>null</code>, then the subscribe {@link Track.Priority} is cleared, which
     *   means the {@link Track.Priority} set by the publisher is now the effective priority.
     * @returns {this}
     * @throws {RangeError}
     */

  }, {
    key: 'setPriority',
    value: function setPriority(priority) {
      return _get(RemoteVideoTrack.prototype.__proto__ || Object.getPrototypeOf(RemoteVideoTrack.prototype), 'setPriority', this).call(this, priority);
    }
  }]);

  return RemoteVideoTrack;
}(RemoteMediaVideoTrack);

/**
 * The {@link RemoteVideoTrack}'s dimensions changed.
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} whose
 *   dimensions changed
 * @event RemoteVideoTrack#dimensionsChanged
 */

/**
 * The {@link RemoteVideoTrack} was disabled, i.e. "paused".
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} that was
 *   disabled
 * @event RemoteVideoTrack#disabled
 */

/**
 * The {@link RemoteVideoTrack} was enabled, i.e. "resumed".
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} that was
 *   enabled
 * @event RemoteVideoTrack#enabled
 */

/**
 * The {@link RemoteVideoTrack} started. This means there is enough video data
 * to begin playback.
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} that started
 * @event RemoteVideoTrack#started
 */

/**
 * A {@link RemoteVideoTrack} was switched off.
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} that was
 *   switched off
 * @event RemoteVideoTrack#switchedOff
 */

/**
 * A {@link RemoteVideoTrack} was switched on.
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} that was
 *   switched on
 * @event RemoteVideoTrack#switchedOn
 */

module.exports = RemoteVideoTrack;
},{"./remotemediatrack":33,"./videotrack":40}],36:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var RemoteTrackPublication = require('./remotetrackpublication');

/**
 * A {@link RemoteVideoTrackPublication} represents a {@link RemoteVideoTrack}
 * that has been published to a {@link Room}.
 * @property {Track.Kind} kind - "video"
 * @property {?RemoteVideoTrack} track - unless you have subscribed to the
 *   {@link RemoteVideoTrack}, this property is null
 * @emits RemoteVideoTrackPublication#subscribed
 * @emits RemoteVideoTrackPublication#subscriptionFailed
 * @emits RemoteVideoTrackPublication#trackDisabled
 * @emits RemoteVideoTrackPublication#trackEnabled
 * @emits RemoteVideoTrackPublication#unsubscribed
 */

var RemoteVideoTrackPublication = function (_RemoteTrackPublicati) {
  _inherits(RemoteVideoTrackPublication, _RemoteTrackPublicati);

  /**
   * Construct a {@link RemoteVideoTrackPublication}.
   * @param {RemoteTrackPublicationSignaling} signaling - {@link RemoteTrackPublication} signaling
   * @param {RemoteTrackPublicationOptions} options - {@link RemoteTrackPublication}
   *   options
   */
  function RemoteVideoTrackPublication(signaling, options) {
    _classCallCheck(this, RemoteVideoTrackPublication);

    return _possibleConstructorReturn(this, (RemoteVideoTrackPublication.__proto__ || Object.getPrototypeOf(RemoteVideoTrackPublication)).call(this, signaling, options));
  }

  _createClass(RemoteVideoTrackPublication, [{
    key: 'toString',
    value: function toString() {
      return '[RemoteVideoTrackPublication #' + this._instanceId + ': ' + this.trackSid + ']';
    }
  }]);

  return RemoteVideoTrackPublication;
}(RemoteTrackPublication);

/**
 * Your {@link LocalParticipant} subscribed to the {@link RemoteVideoTrack}.
 * @param {RemoteVideoTrack} track - the {@link RemoteVideoTrack} that was subscribed to
 * @event RemoteVideoTrackPublication#subscribed
 */

/**
 * Your {@link LocalParticipant} failed to subscribe to the {@link RemoteVideoTrack}.
 * @param {TwilioError} error - the reason the {@link RemoteVideoTrack} could not be
 *   subscribed to
 * @event RemoteVideoTrackPublication#subscriptionFailed
 */

/**
 * The {@link RemoteVideoTrack} was disabled.
 * @event RemoteVideoTrackPublication#trackDisabled
 */

/**
 * The {@link RemoteVideoTrack} was enabled.
 * @event RemoteVideoTrackPublication#trackEnabled
 */

/**
 * Your {@link LocalParticipant} unsubscribed from the {@link RemoteVideoTrack}.
 * @param {RemoteVideoTrack} track - the {@link RemoteVideoTrack} that was unsubscribed from
 * @event RemoteVideoTrackPublication#unsubscribed
 */

module.exports = RemoteVideoTrackPublication;
},{"./remotetrackpublication":34}],37:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var MediaTrackTransceiver = require('./transceiver');

/**
 * A {@link MediaTrackSender} represents one or more local RTCRtpSenders.
 * @extends MediaTrackTransceiver
 */

var MediaTrackSender = function (_MediaTrackTransceive) {
  _inherits(MediaTrackSender, _MediaTrackTransceive);

  /**
   * Construct a {@link MediaTrackSender}.
   * @param {MediaStreamTrack} mediaStreamTrack
   */
  function MediaTrackSender(mediaStreamTrack) {
    _classCallCheck(this, MediaTrackSender);

    var _this = _possibleConstructorReturn(this, (MediaTrackSender.__proto__ || Object.getPrototypeOf(MediaTrackSender)).call(this, mediaStreamTrack.id, mediaStreamTrack));

    Object.defineProperties(_this, {
      _clones: {
        value: new Set()
      },
      _senders: {
        value: new Set()
      }
    });
    return _this;
  }

  /**
   * Return a new {@link MediaTrackSender} containing a clone of the underlying
   * MediaStreamTrack. No RTCRtpSenders are copied.
   * @returns {MediaTrackSender}
   */


  _createClass(MediaTrackSender, [{
    key: 'clone',
    value: function clone() {
      var clone = new MediaTrackSender(this.track.clone());
      this._clones.add(clone);
      return clone;
    }

    /**
     * Remove a cloned {@link MediaTrackSender}.
     * @returns {void}
     */

  }, {
    key: 'removeClone',
    value: function removeClone(clone) {
      this._clones.delete(clone);
    }

    /**
     * Set the given MediaStreamTrack.
     * @param {MediaStreamTrack} mediaStreamTrack
     * @returns {Promise<void>}
     */

  }, {
    key: 'setMediaStreamTrack',
    value: function setMediaStreamTrack(mediaStreamTrack) {
      var _this2 = this;

      var clones = Array.from(this._clones);
      var senders = Array.from(this._senders);
      return Promise.all(clones.map(function (clone) {
        return clone.setMediaStreamTrack(mediaStreamTrack.clone());
      }).concat(senders.map(function (sender) {
        return sender.replaceTrack(mediaStreamTrack);
      }))).finally(function () {
        _this2._track = mediaStreamTrack;
      });
    }

    /**
     * Add an RTCRtpSender.
     * @param {RTCRtpSender} sender
     * @returns {this}
     */

  }, {
    key: 'addSender',
    value: function addSender(sender) {
      this._senders.add(sender);
      return this;
    }

    /**
     * Remove an RTCRtpSender.
     * @param {RTCRtpSender} sender
     * @returns {this}
     */

  }, {
    key: 'removeSender',
    value: function removeSender(sender) {
      this._senders.delete(sender);
      return this;
    }
  }]);

  return MediaTrackSender;
}(MediaTrackTransceiver);

module.exports = MediaTrackSender;
},{"./transceiver":39}],38:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EventEmitter = require('../../eventemitter');

var _require = require('../../util'),
    buildLogLevels = _require.buildLogLevels,
    valueToJSON = _require.valueToJSON;

var _require2 = require('../../util/constants'),
    DEFAULT_LOG_LEVEL = _require2.DEFAULT_LOG_LEVEL;

var Log = require('../../util/log');
var nInstances = 0;

/**
 * A {@link TrackPublication} represents a {@link Track} that
 * has been published to a {@link Room}.
 * @property {string} trackName - the published {@link Track}'s name
 * @property {Track.SID} trackSid - SID assigned to the published {@link Track}
 * @emits TrackPublication#trackDisabled
 * @emits TrackPublication#trackEnabled
 */

var TrackPublication = function (_EventEmitter) {
  _inherits(TrackPublication, _EventEmitter);

  /**
   * Construct a {@link TrackPublication}.
   * @param {string} trackName - the published {@link Track}'s name
   * @param {Track.SID} trackSid - SID assigned to the {@link Track}
   * @param {TrackPublicationOptions} options - {@link TrackPublication} options
   */
  function TrackPublication(trackName, trackSid, options) {
    _classCallCheck(this, TrackPublication);

    var _this = _possibleConstructorReturn(this, (TrackPublication.__proto__ || Object.getPrototypeOf(TrackPublication)).call(this));

    options = Object.assign({
      logLevel: DEFAULT_LOG_LEVEL
    }, options);

    var logLevels = buildLogLevels(options.logLevel);

    Object.defineProperties(_this, {
      _instanceId: {
        value: nInstances++
      },
      _log: {
        value: options.log || new Log('default', _this, logLevels, options.loggerName)
      },
      trackName: {
        enumerable: true,
        value: trackName
      },
      trackSid: {
        enumerable: true,
        value: trackSid
      }
    });
    return _this;
  }

  _createClass(TrackPublication, [{
    key: 'toJSON',
    value: function toJSON() {
      return valueToJSON(this);
    }
  }, {
    key: 'toString',
    value: function toString() {
      return '[TrackPublication #' + this._instanceId + ': ' + this.trackSid + ']';
    }
  }]);

  return TrackPublication;
}(EventEmitter);

/**
 * The published {@link Track} was disabled.
 * @event TrackPublication#trackDisabled
 */

/**
 * The published {@link Track} was enabled.
 * @event TrackPublication#trackEnabled
 */

/**
 * A {@link LocalAudioTrackPublication} or a {@link RemoteAudioTrackPublication}.
 * @typedef {LocalAudioTrackPublication|RemoteAudioTrackPublication} AudioTrackPublication
 */

/**
 * A {@link LocalDataTrackPublication} or a {@link RemoteDataTrackPublication}.
 * @typedef {LocalDataTrackPublication|RemoteDataTrackPublication} DataTrackPublication
 */

/**
 * A {@link LocalVideoTrackPublication} or a {@link RemoteVideoTrackPublication}.
 * @typedef {LocalVideoTrackPublication|RemoteVideoTrackPublication} VideoTrackPublication
 */

/**
 * {@link TrackPublication} options
 * @typedef {object} TrackPublicationOptions
 * @property {LogLevel|LogLevels} logLevel - Log level for 'media' modules
 */

module.exports = TrackPublication;
},{"../../eventemitter":10,"../../util":114,"../../util/constants":108,"../../util/log":118}],39:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TrackTransceiver = require('../../transceiver');

/**
 * A {@link MediaTrackTransceiver} represents either one or more local
 * RTCRtpSenders, or a single RTCRtpReceiver.
 * @extends TrackTransceiver
 * @property {MediaStreamTrack} track
 */

var MediaTrackTransceiver = function (_TrackTransceiver) {
  _inherits(MediaTrackTransceiver, _TrackTransceiver);

  /**
   * Construct a {@link MediaTrackTransceiver}.
   * @param {Track.ID} id - The MediaStreamTrack ID signaled through RSP/SDP
   * @param {MediaStreamTrack} mediaStreamTrack
   */
  function MediaTrackTransceiver(id, mediaStreamTrack) {
    _classCallCheck(this, MediaTrackTransceiver);

    var _this = _possibleConstructorReturn(this, (MediaTrackTransceiver.__proto__ || Object.getPrototypeOf(MediaTrackTransceiver)).call(this, id, mediaStreamTrack.kind));

    Object.defineProperties(_this, {
      _track: {
        value: mediaStreamTrack,
        writable: true
      },
      enabled: {
        enumerable: true,
        get: function get() {
          return this._track.enabled;
        }
      },
      readyState: {
        enumerable: true,
        get: function get() {
          return this._track.readyState;
        }
      },
      track: {
        enumerable: true,
        get: function get() {
          return this._track;
        }
      }
    });
    return _this;
  }

  _createClass(MediaTrackTransceiver, [{
    key: 'stop',
    value: function stop() {
      this.track.stop();
      _get(MediaTrackTransceiver.prototype.__proto__ || Object.getPrototypeOf(MediaTrackTransceiver.prototype), 'stop', this).call(this);
    }
  }]);

  return MediaTrackTransceiver;
}(TrackTransceiver);

module.exports = MediaTrackTransceiver;
},{"../../transceiver":104}],40:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var MediaTrack = require('./mediatrack');

/**
 * A {@link VideoTrack} is a {@link Track} representing video.
 * @extends Track
 * @property {boolean} isStarted - Whether or not the {@link VideoTrack} has
 *   started; if the {@link VideoTrack} started, there is enough video data to
 *   begin playback
 * @property {boolean} isEnabled - Whether or not the {@link VideoTrack} is
 *   enabled; if the {@link VideoTrack} is not enabled, it is "paused"
 * @property {VideoTrack.Dimensions} dimensions - The {@link VideoTrack}'s
 *   {@link VideoTrack.Dimensions}
 * @property {Track.Kind} kind - "video"
 * @property {MediaStreamTrack} mediaStreamTrack - A video MediaStreamTrack
 * @emits VideoTrack#dimensionsChanged
 * @emits VideoTrack#disabled
 * @emits VideoTrack#enabled
 * @emits VideoTrack#started
 */

var VideoTrack = function (_MediaTrack) {
  _inherits(VideoTrack, _MediaTrack);

  /**
   * Construct a {@link VideoTrack}.
   * @param {MediaTrackTransceiver} mediaTrackTransceiver
   * @param {{log: Log}} options
   */
  function VideoTrack(mediaTrackTransceiver, options) {
    var _ret;

    _classCallCheck(this, VideoTrack);

    var _this = _possibleConstructorReturn(this, (VideoTrack.__proto__ || Object.getPrototypeOf(VideoTrack)).call(this, mediaTrackTransceiver, options));

    Object.defineProperties(_this, {
      dimensions: {
        enumerable: true,
        value: {
          width: null,
          height: null
        }
      }
    });
    return _ret = _this, _possibleConstructorReturn(_this, _ret);
  }

  /**
   * @private
   */


  _createClass(VideoTrack, [{
    key: '_initialize',
    value: function _initialize() {
      var _this2 = this;

      _get(VideoTrack.prototype.__proto__ || Object.getPrototypeOf(VideoTrack.prototype), '_initialize', this).call(this);
      if (this._dummyEl) {
        this._dummyEl.onloadedmetadata = function () {
          if (dimensionsChanged(_this2, _this2._dummyEl)) {
            _this2.dimensions.width = _this2._dummyEl.videoWidth;
            _this2.dimensions.height = _this2._dummyEl.videoHeight;
          }
        };
        this._dummyEl.onresize = function () {
          if (dimensionsChanged(_this2, _this2._dummyEl)) {
            _this2.dimensions.width = _this2._dummyEl.videoWidth;
            _this2.dimensions.height = _this2._dummyEl.videoHeight;
            if (_this2.isStarted) {
              _this2._log.debug('Dimensions changed:', _this2.dimensions);
              _this2.emit(VideoTrack.DIMENSIONS_CHANGED, _this2);
            }
          }
        };
      }
    }

    /**
     * @private
     */

  }, {
    key: '_start',
    value: function _start(dummyEl) {
      this.dimensions.width = dummyEl.videoWidth;
      this.dimensions.height = dummyEl.videoHeight;

      this._log.debug('Dimensions:', this.dimensions);
      return _get(VideoTrack.prototype.__proto__ || Object.getPrototypeOf(VideoTrack.prototype), '_start', this).call(this, dummyEl);
    }

    /**
     * Create an HTMLVideoElement and attach the {@link VideoTrack} to it.
     *
     * The HTMLVideoElement's <code>srcObject</code> will be set to a new
     * MediaStream containing the {@link VideoTrack}'s MediaStreamTrack.
     *
     * @returns {HTMLVideoElement} videoElement
     * @example
     * const Video = require('twilio-video');
     *
     * Video.createLocalVideoTrack().then(function(videoTrack) {
     *   const videoElement = videoTrack.attach();
     *   document.body.appendChild(videoElement);
     * });
    */ /**
       * Attach the {@link VideoTrack} to an existing HTMLMediaElement. The
       * HTMLMediaElement could be an HTMLAudioElement or an HTMLVideoElement.
       *
       * If the HTMLMediaElement's <code>srcObject</code> is not set to a MediaStream,
       * this method sets it to a new MediaStream containing the {@link VideoTrack}'s
       * MediaStreamTrack; otherwise, it adds the {@link MediaTrack}'s
       * MediaStreamTrack to the existing MediaStream. Finally, if there are any other
       * MediaStreamTracks of the same kind on the MediaStream, this method removes
       * them.
       *
       * @param {HTMLMediaElement} mediaElement - The HTMLMediaElement to attach to
       * @returns {HTMLMediaElement} mediaElement
       * @example
       * const Video = require('twilio-video');
       *
       * const videoElement = document.createElement('video');
       * document.body.appendChild(videoElement);
       *
       * Video.createLocalVideoTrack().then(function(videoTrack) {
       *   videoTrack.attach(videoElement);
       * });
       */ /**
          * Attach the {@link VideoTrack} to an HTMLMediaElement selected by
          * <code>document.querySelector</code>. The HTMLMediaElement could be an
          * HTMLAudioElement or an HTMLVideoElement.
          *
          * If the HTMLMediaElement's <code>srcObject</code> is not set to a MediaStream,
          * this method sets it to a new MediaStream containing the {@link VideoTrack}'s
          * MediaStreamTrack; otherwise, it adds the {@link VideoTrack}'s
          * MediaStreamTrack to the existing MediaStream. Finally, if there are any other
          * MediaStreamTracks of the same kind on the MediaStream, this method removes
          * them.
          *
          * @param {string} selector - A query selector for the HTMLMediaElement to
          *   attach to
          * @returns {HTMLMediaElement} mediaElement
          * @example
          * const Video = require('twilio-video');
          *
          * const videoElement = document.createElement('video');
          * videoElement.id = 'my-video-element';
          * document.body.appendChild(videoElement);
          *
          * Video.createLocalVideoTrack().then(function(track) {
          *   track.attach('#my-video-element');
          * });
          */

  }, {
    key: 'attach',
    value: function attach() {
      return _get(VideoTrack.prototype.__proto__ || Object.getPrototypeOf(VideoTrack.prototype), 'attach', this).apply(this, arguments);
    }

    /**
     * Detach the {@link VideoTrack} from all previously attached HTMLMediaElements.
     * @returns {Array<HTMLMediaElement>} mediaElements
     * @example
     * const mediaElements = videoTrack.detach();
     * mediaElements.forEach(mediaElement => mediaElement.remove());
    */ /**
       * Detach the {@link VideoTrack} from a previously attached HTMLMediaElement.
       * @param {HTMLMediaElement} mediaElement - One of the HTMLMediaElements to
       *   which the {@link VideoTrack} is attached
       * @returns {HTMLMediaElement} mediaElement
       * @example
       * const videoElement = document.getElementById('my-video-element');
       * videoTrack.detach(videoElement).remove();
       */ /**
          * Detach the {@link VideoTrack} from a previously attached HTMLMediaElement
          *   specified by <code>document.querySelector</code>.
          * @param {string} selector - The query selector of HTMLMediaElement to which
          *    the {@link VideoTrack} is attached
          * @returns {HTMLMediaElement} mediaElement
          * @example
          * videoTrack.detach('#my-video-element').remove();
          */

  }, {
    key: 'detach',
    value: function detach() {
      return _get(VideoTrack.prototype.__proto__ || Object.getPrototypeOf(VideoTrack.prototype), 'detach', this).apply(this, arguments);
    }
  }]);

  return VideoTrack;
}(MediaTrack);

VideoTrack.DIMENSIONS_CHANGED = 'dimensionsChanged';

function dimensionsChanged(track, elem) {
  return track.dimensions.width !== elem.videoWidth || track.dimensions.height !== elem.videoHeight;
}

/**
 * A {@link VideoTrack}'s width and height.
 * @typedef {object} VideoTrack.Dimensions
 * @property {?number} width - The {@link VideoTrack}'s width or null if the
 *   {@link VideoTrack} has not yet started
 * @property {?number} height - The {@link VideoTrack}'s height or null if the
 *   {@link VideoTrack} has not yet started
 */

/**
 * The {@link VideoTrack}'s dimensions changed.
 * @param {VideoTrack} track - The {@link VideoTrack} whose dimensions changed
 * @event VideoTrack#dimensionsChanged
 */

/**
 * The {@link VideoTrack} was disabled, i.e. "paused".
 * @param {VideoTrack} track - The {@link VideoTrack} that was disabled
 * @event VideoTrack#disabled
 */

/**
 * The {@link VideoTrack} was enabled, i.e. "unpaused".
 * @param {VideoTrack} track - The {@link VideoTrack} that was enabled
 * @event VideoTrack#enabled
 */

/**
 * The {@link VideoTrack} started. This means there is enough video data to
 * begin playback.
 * @param {VideoTrack} track - The {@link VideoTrack} that started
 * @event VideoTrack#started
 */

module.exports = VideoTrack;
},{"./mediatrack":27}],41:[function(require,module,exports){
'use strict';

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('events'),
    EventEmitter = _require.EventEmitter;

var _require2 = require('./util/constants'),
    DEFAULT_NQ_LEVEL_LOCAL = _require2.DEFAULT_NQ_LEVEL_LOCAL,
    DEFAULT_NQ_LEVEL_REMOTE = _require2.DEFAULT_NQ_LEVEL_REMOTE,
    MAX_NQ_LEVEL = _require2.MAX_NQ_LEVEL;

var _require3 = require('./util'),
    inRange = _require3.inRange;

/**
 * {@link NetworkQualityConfigurationImpl} represents an object which notifies its
 * listeners of any changes in the values of its properties.
 * @extends EventEmitter
 * @implements NetworkQualityConfiguration
 * @property {?NetworkQualityVerbosity} local - Verbosity level for {@link LocalParticipant}
 * @property {?NetworkQualityVerbosity} remote - Verbosity level for {@link RemoteParticipant}s
 */


var NetworkQualityConfigurationImpl = function (_EventEmitter) {
  _inherits(NetworkQualityConfigurationImpl, _EventEmitter);

  /**
   * Construct an {@link NetworkQualityConfigurationImpl}.
   * @param {NetworkQualityConfiguration} networkQualityConfiguration - Initial {@link NetworkQualityConfiguration}
   */
  function NetworkQualityConfigurationImpl(networkQualityConfiguration) {
    _classCallCheck(this, NetworkQualityConfigurationImpl);

    var _this = _possibleConstructorReturn(this, (NetworkQualityConfigurationImpl.__proto__ || Object.getPrototypeOf(NetworkQualityConfigurationImpl)).call(this));

    networkQualityConfiguration = Object.assign({
      local: DEFAULT_NQ_LEVEL_LOCAL,
      remote: DEFAULT_NQ_LEVEL_REMOTE
    }, networkQualityConfiguration);

    Object.defineProperties(_this, {
      local: {
        value: inRange(networkQualityConfiguration.local, DEFAULT_NQ_LEVEL_LOCAL, MAX_NQ_LEVEL) ? networkQualityConfiguration.local : DEFAULT_NQ_LEVEL_LOCAL,
        writable: true
      },
      remote: {
        value: inRange(networkQualityConfiguration.remote, DEFAULT_NQ_LEVEL_REMOTE, MAX_NQ_LEVEL) ? networkQualityConfiguration.remote : DEFAULT_NQ_LEVEL_REMOTE,
        writable: true
      }
    });
    return _this;
  }

  /**
   * Update the verbosity levels for network quality information for
   * {@link LocalParticipant} and {@link RemoteParticipant} with those
   * in the given {@link NetworkQualityConfiguration}.
   * @param {NetworkQualityConfiguration} networkQualityConfiguration - The new {@link NetworkQualityConfiguration}
   */


  _createClass(NetworkQualityConfigurationImpl, [{
    key: 'update',
    value: function update(networkQualityConfiguration) {
      var _this2 = this;

      networkQualityConfiguration = Object.assign({
        local: this.local,
        remote: this.remote
      }, networkQualityConfiguration);

      [['local', DEFAULT_NQ_LEVEL_LOCAL, 3], ['remote', DEFAULT_NQ_LEVEL_REMOTE, 3]].forEach(function (_ref) {
        var _ref2 = _slicedToArray(_ref, 3),
            localOrRemote = _ref2[0],
            min = _ref2[1],
            max = _ref2[2];

        _this2[localOrRemote] = typeof networkQualityConfiguration[localOrRemote] === 'number' && inRange(networkQualityConfiguration[localOrRemote], min, max) ? networkQualityConfiguration[localOrRemote] : min;
      });
    }
  }]);

  return NetworkQualityConfigurationImpl;
}(EventEmitter);

module.exports = NetworkQualityConfigurationImpl;
},{"./util":114,"./util/constants":108,"events":165}],42:[function(require,module,exports){
'use strict';

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EventEmitter = require('./eventemitter');
var RemoteAudioTrack = require('./media/track/remoteaudiotrack');
var RemoteAudioTrackPublication = require('./media/track/remoteaudiotrackpublication');
var RemoteDataTrack = require('./media/track/remotedatatrack');
var RemoteDataTrackPublication = require('./media/track/remotedatatrackpublication');
var RemoteVideoTrack = require('./media/track/remotevideotrack');
var RemoteVideoTrackPublication = require('./media/track/remotevideotrackpublication');
var util = require('./util');

var nInstances = 0;

/**
 * {@link NetworkQualityLevel} is a value from 0–5, inclusive, representing the
 * quality of a network connection.
 * @typedef {number} NetworkQualityLevel
 */

/**
 * @extends EventEmitter
 * @property {Map<Track.SID, AudioTrackPublication>} audioTracks -
 *    The {@link Participant}'s {@link AudioTrackPublication}s
 * @property {Map<Track.SID, DataTrackPublication>} dataTracks -
 *    The {@link Participant}'s {@link DataTrackPublication}s.
 * @property {Participant.Identity} identity - The identity of the {@link Participant}
 * @property {?NetworkQualityLevel} networkQualityLevel - The
 *    {@link Participant}'s current {@link NetworkQualityLevel}, if any
 * @property {?NetworkQualityStats} networkQualityStats - The
 *    {@link Participant}'s current {@link NetworkQualityStats}, if any
 * @property {Participant.SID} sid - The {@link Participant}'s SID
 * @property {string} state - "connected", "disconnected" or "reconnecting"
 * @property {Map<Track.SID, TrackPublication>} tracks -
 *    The {@link Participant}'s {@link TrackPublication}s
 * @property {Map<Track.SID, VideoTrackPublication>} videoTracks -
 *    The {@link Participant}'s {@link VideoTrackPublication}s
 * @emits Participant#disconnected
 * @emits Participant#networkQualityLevelChanged
 * @emits Participant#reconnected
 * @emits Participant#reconnecting
 * @emits Participant#trackDimensionsChanged
 * @emits Participant#trackStarted
 */

var Participant = function (_EventEmitter) {
  _inherits(Participant, _EventEmitter);

  /**
   * Construct a {@link Participant}.
   * @param {ParticipantSignaling} signaling
   * @param {object} [options]
   */
  function Participant(signaling, options) {
    _classCallCheck(this, Participant);

    var _this = _possibleConstructorReturn(this, (Participant.__proto__ || Object.getPrototypeOf(Participant)).call(this));

    options = Object.assign({
      RemoteAudioTrack: RemoteAudioTrack,
      RemoteAudioTrackPublication: RemoteAudioTrackPublication,
      RemoteDataTrack: RemoteDataTrack,
      RemoteDataTrackPublication: RemoteDataTrackPublication,
      RemoteVideoTrack: RemoteVideoTrack,
      RemoteVideoTrackPublication: RemoteVideoTrackPublication,
      tracks: []
    }, options);

    var indexed = indexTracksById(options.tracks);
    var log = options.log.createLog('default', _this);
    var audioTracks = new Map(indexed.audioTracks);
    var dataTracks = new Map(indexed.dataTracks);
    var tracks = new Map(indexed.tracks);
    var videoTracks = new Map(indexed.videoTracks);

    Object.defineProperties(_this, {
      _RemoteAudioTrack: {
        value: options.RemoteAudioTrack
      },
      _RemoteAudioTrackPublication: {
        value: options.RemoteAudioTrackPublication
      },
      _RemoteDataTrack: {
        value: options.RemoteDataTrack
      },
      _RemoteDataTrackPublication: {
        value: options.RemoteDataTrackPublication
      },
      _RemoteVideoTrack: {
        value: options.RemoteVideoTrack
      },
      _RemoteVideoTrackPublication: {
        value: options.RemoteVideoTrackPublication
      },
      _audioTracks: {
        value: audioTracks
      },
      _dataTracks: {
        value: dataTracks
      },
      _instanceId: {
        value: ++nInstances
      },
      _log: {
        value: log
      },
      _signaling: {
        value: signaling
      },
      _tracks: {
        value: tracks
      },
      _trackEventReemitters: {
        value: new Map()
      },
      _trackPublicationEventReemitters: {
        value: new Map()
      },
      _trackSignalingUpdatedEventCallbacks: {
        value: new Map()
      },
      _videoTracks: {
        value: videoTracks
      },
      audioTracks: {
        enumerable: true,
        value: new Map()
      },
      dataTracks: {
        enumerable: true,
        value: new Map()
      },
      identity: {
        enumerable: true,
        get: function get() {
          return signaling.identity;
        }
      },
      networkQualityLevel: {
        enumerable: true,
        get: function get() {
          return signaling.networkQualityLevel;
        }
      },
      networkQualityStats: {
        enumerable: true,
        get: function get() {
          return signaling.networkQualityStats;
        }
      },
      sid: {
        enumerable: true,
        get: function get() {
          return signaling.sid;
        }
      },
      state: {
        enumerable: true,
        get: function get() {
          return signaling.state;
        }
      },
      tracks: {
        enumerable: true,
        value: new Map()
      },
      videoTracks: {
        enumerable: true,
        value: new Map()
      }
    });

    _this._tracks.forEach(reemitTrackEvents.bind(null, _this));
    signaling.on('networkQualityLevelChanged', function () {
      return _this.emit('networkQualityLevelChanged', _this.networkQualityLevel, _this.networkQualityStats && (_this.networkQualityStats.audio || _this.networkQualityStats.video) ? _this.networkQualityStats : null);
    });
    reemitSignalingStateChangedEvents(_this, signaling);
    log.info('Created a new Participant' + (_this.identity ? ': ' + _this.identity : ''));
    return _this;
  }

  /**
   * Get the {@link RemoteTrack} events to re-emit.
   * @private
   * @returns {Array<Array<string>>} events
   */


  _createClass(Participant, [{
    key: '_getTrackEvents',
    value: function _getTrackEvents() {
      return [['dimensionsChanged', 'trackDimensionsChanged'], ['message', 'trackMessage'], ['started', 'trackStarted']];
    }

    /**
     * @private
     */

  }, {
    key: '_getTrackPublicationEvents',
    value: function _getTrackPublicationEvents() {
      return [];
    }
  }, {
    key: 'toString',
    value: function toString() {
      return '[Participant #' + this._instanceId + ': ' + this.sid + ']';
    }

    /**
     * @private
     * @param {RemoteTrack} track
     * @param {Track.ID} id
     * @returns {?RemoteTrack}
     */

  }, {
    key: '_addTrack',
    value: function _addTrack(track, id) {
      var log = this._log;
      if (this._tracks.has(id)) {
        return null;
      }
      this._tracks.set(id, track);

      var tracksByKind = {
        audio: this._audioTracks,
        video: this._videoTracks,
        data: this._dataTracks
      }[track.kind];
      tracksByKind.set(id, track);
      reemitTrackEvents(this, track, id);

      log.info('Added a new ' + util.trackClass(track) + ':', id);
      log.debug(util.trackClass(track) + ':', track);

      return track;
    }

    /**
     * @private
     * @param {RemoteTrackPublication} publication
     * @returns {?RemoteTrackPublication}
     */

  }, {
    key: '_addTrackPublication',
    value: function _addTrackPublication(publication) {
      var log = this._log;
      if (this.tracks.has(publication.trackSid)) {
        return null;
      }
      this.tracks.set(publication.trackSid, publication);

      var trackPublicationsByKind = {
        audio: this.audioTracks,
        data: this.dataTracks,
        video: this.videoTracks
      }[publication.kind];
      trackPublicationsByKind.set(publication.trackSid, publication);
      reemitTrackPublicationEvents(this, publication);

      log.info('Added a new ' + util.trackPublicationClass(publication) + ':', publication.trackSid);
      log.debug(util.trackPublicationClass(publication) + ':', publication);
      return publication;
    }

    /**
     * @private
     */

  }, {
    key: '_handleTrackSignalingEvents',
    value: function _handleTrackSignalingEvents() {
      var log = this._log;
      var self = this;

      if (this.state === 'disconnected') {
        return;
      }

      var RemoteAudioTrack = this._RemoteAudioTrack;
      var RemoteAudioTrackPublication = this._RemoteAudioTrackPublication;
      var RemoteVideoTrack = this._RemoteVideoTrack;
      var RemoteVideoTrackPublication = this._RemoteVideoTrackPublication;
      var RemoteDataTrack = this._RemoteDataTrack;
      var RemoteDataTrackPublication = this._RemoteDataTrackPublication;
      var participantSignaling = this._signaling;

      function trackSignalingAdded(signaling) {
        var RemoteTrackPublication = {
          audio: RemoteAudioTrackPublication,
          data: RemoteDataTrackPublication,
          video: RemoteVideoTrackPublication
        }[signaling.kind];

        var publication = new RemoteTrackPublication(signaling, { log: log });
        self._addTrackPublication(publication);

        var isSubscribed = signaling.isSubscribed;
        if (isSubscribed) {
          trackSignalingSubscribed(signaling);
        }

        self._trackSignalingUpdatedEventCallbacks.set(signaling.sid, function () {
          if (isSubscribed !== signaling.isSubscribed) {
            isSubscribed = signaling.isSubscribed;
            if (isSubscribed) {
              trackSignalingSubscribed(signaling);
              return;
            }
            trackSignalingUnsubscribed(signaling);
          }
        });
        signaling.on('updated', self._trackSignalingUpdatedEventCallbacks.get(signaling.sid));
      }

      function trackSignalingRemoved(signaling) {
        if (signaling.isSubscribed) {
          signaling.setTrackTransceiver(null);
        }
        var updated = self._trackSignalingUpdatedEventCallbacks.get(signaling.sid);
        if (updated) {
          signaling.removeListener('updated', updated);
          self._trackSignalingUpdatedEventCallbacks.delete(signaling.sid);
        }
        var publication = self.tracks.get(signaling.sid);
        if (publication) {
          self._removeTrackPublication(publication);
        }
      }

      function trackSignalingSubscribed(signaling) {
        var isEnabled = signaling.isEnabled,
            name = signaling.name,
            kind = signaling.kind,
            sid = signaling.sid,
            trackTransceiver = signaling.trackTransceiver;

        var RemoteTrack = {
          audio: RemoteAudioTrack,
          video: RemoteVideoTrack,
          data: RemoteDataTrack
        }[kind];

        var publication = self.tracks.get(sid);

        // NOTE(mroberts): It should never be the case that the TrackSignaling and
        // MediaStreamTrack or DataTrackReceiver kinds disagree; however, just in
        // case, we handle it here.
        if (!RemoteTrack || kind !== trackTransceiver.kind) {
          return;
        }

        var options = { log: log, name: name };
        var setPriority = function setPriority(newPriority) {
          return participantSignaling.updateSubscriberTrackPriority(sid, newPriority);
        };
        var track = kind === 'data' ? new RemoteTrack(sid, trackTransceiver, options) : new RemoteTrack(sid, trackTransceiver, isEnabled, setPriority, options);

        self._addTrack(track, publication, trackTransceiver.id);
      }

      function trackSignalingUnsubscribed(signaling) {
        var _Array$from$find = Array.from(self._tracks.entries()).find(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              track = _ref2[1];

          return track.sid === signaling.sid;
        }),
            _Array$from$find2 = _slicedToArray(_Array$from$find, 2),
            id = _Array$from$find2[0],
            track = _Array$from$find2[1];

        var publication = self.tracks.get(signaling.sid);
        if (track) {
          self._removeTrack(track, publication, id);
        }
      }

      participantSignaling.on('trackAdded', trackSignalingAdded);
      participantSignaling.on('trackRemoved', trackSignalingRemoved);

      participantSignaling.tracks.forEach(trackSignalingAdded);

      participantSignaling.on('stateChanged', function stateChanged(state) {
        if (state === 'disconnected') {
          log.debug('Removing event listeners');
          participantSignaling.removeListener('stateChanged', stateChanged);
          participantSignaling.removeListener('trackAdded', trackSignalingAdded);
          participantSignaling.removeListener('trackRemoved', trackSignalingRemoved);
        } else if (state === 'connected') {
          // NOTE(mmalavalli): Any transition to "connected" here is a result of
          // successful signaling reconnection, and not a first-time establishment
          // of the signaling connection.
          log.info('reconnected');

          // NOTE(mpatwardhan): `stateChanged` can get emitted with StateMachine locked.
          // Do not signal  public events synchronously with lock held.
          setTimeout(function () {
            return self.emit('reconnected');
          }, 0);
        }
      });
    }

    /**
     * @private
     * @param {RemoteTrack} track
     * @param {Track.ID} id
     * @returns {?RemoteTrack}
     */

  }, {
    key: '_removeTrack',
    value: function _removeTrack(track, id) {
      if (!this._tracks.has(id)) {
        return null;
      }
      this._tracks.delete(id);

      var tracksByKind = {
        audio: this._audioTracks,
        video: this._videoTracks,
        data: this._dataTracks
      }[track.kind];
      tracksByKind.delete(id);

      var reemitters = this._trackEventReemitters.get(id) || new Map();
      reemitters.forEach(function (reemitter, event) {
        track.removeListener(event, reemitter);
      });

      var log = this._log;
      log.info('Removed a ' + util.trackClass(track) + ':', id);
      log.debug(util.trackClass(track) + ':', track);
      return track;
    }

    /**
     * @private
     * @param {RemoteTrackPublication} publication
     * @returns {?RemoteTrackPublication}
     */

  }, {
    key: '_removeTrackPublication',
    value: function _removeTrackPublication(publication) {
      publication = this.tracks.get(publication.trackSid);
      if (!publication) {
        return null;
      }
      this.tracks.delete(publication.trackSid);

      var trackPublicationsByKind = {
        audio: this.audioTracks,
        data: this.dataTracks,
        video: this.videoTracks
      }[publication.kind];
      trackPublicationsByKind.delete(publication.trackSid);

      var reemitters = this._trackPublicationEventReemitters.get(publication.trackSid) || new Map();
      reemitters.forEach(function (reemitter, event) {
        publication.removeListener(event, reemitter);
      });

      var log = this._log;
      log.info('Removed a ' + util.trackPublicationClass(publication) + ':', publication.trackSid);
      log.debug(util.trackPublicationClass(publication) + ':', publication);
      return publication;
    }
  }, {
    key: 'toJSON',
    value: function toJSON() {
      return util.valueToJSON(this);
    }
  }]);

  return Participant;
}(EventEmitter);

/**
 * A {@link Participant.SID} is a 34-character string starting with "PA"
 * that uniquely identifies a {@link Participant}.
 * @type string
 * @typedef Participant.SID
 */

/**
 * A {@link Participant.Identity} is a string that identifies a
 * {@link Participant}. You can think of it like a name.
 * @typedef {string} Participant.Identity
 */

/**
 * The {@link Participant} has disconnected.
 * @param {Participant} participant - The {@link Participant} that disconnected.
 * @event Participant#disconnected
 */

/**
 * The {@link Participant}'s {@link NetworkQualityLevel} changed.
 * @param {NetworkQualityLevel} networkQualityLevel - The new
 *   {@link NetworkQualityLevel}
 * @param {?NetworkQualityStats} networkQualityStats - The {@link NetworkQualityStats}
 *   based on which {@link NetworkQualityLevel} is calculated, if any
 * @event Participant#networkQualityLevelChanged
 */

/**
 * The {@link Participant} has reconnected to the {@link Room} after a signaling connection disruption.
 * @event Participant#reconnected
 */

/**
 * The {@link Participant} is reconnecting to the {@link Room} after a signaling connection disruption.
 * @event Participant#reconnecting
 */

/**
 * One of the {@link Participant}'s {@link VideoTrack}'s dimensions changed.
 * @param {VideoTrack} track - The {@link VideoTrack} whose dimensions changed
 * @event Participant#trackDimensionsChanged
 */

/**
 * One of the {@link Participant}'s {@link Track}s started.
 * @param {Track} track - The {@link Track} that started
 * @event Participant#trackStarted
 */

/**
 * Indexed {@link Track}s by {@link Track.ID}.
 * @typedef {object} IndexedTracks
 * @property {Array<{0: Track.ID, 1: AudioTrack}>} audioTracks - Indexed
 *   {@link AudioTrack}s
 * @property {Array<{0: Track.ID, 1: DataTrack}>} dataTracks - Indexed
 *   {@link DataTrack}s
 * @property {Array<{0: Track.ID, 1: Track}>} tracks - Indexed {@link Track}s
 * @property {Array<{0: Track.ID, 1: VideoTrack}>} videoTracks - Indexed
 *   {@link VideoTrack}s
 * @private
 */

/**
 * Index tracks by {@link Track.ID}.
 * @param {Array<Track>} tracks
 * @returns {IndexedTracks}
 * @private
 */


function indexTracksById(tracks) {
  var indexedTracks = tracks.map(function (track) {
    return [track.id, track];
  });
  var indexedAudioTracks = indexedTracks.filter(function (keyValue) {
    return keyValue[1].kind === 'audio';
  });
  var indexedVideoTracks = indexedTracks.filter(function (keyValue) {
    return keyValue[1].kind === 'video';
  });
  var indexedDataTracks = indexedTracks.filter(function (keyValue) {
    return keyValue[1].kind === 'data';
  });

  return {
    audioTracks: indexedAudioTracks,
    dataTracks: indexedDataTracks,
    tracks: indexedTracks,
    videoTracks: indexedVideoTracks
  };
}

/**
 * Re-emit {@link ParticipantSignaling} 'stateChanged' events.
 * @param {Participant} participant
 * @param {ParticipantSignaling} signaling
 * @private
 */
function reemitSignalingStateChangedEvents(participant, signaling) {
  var log = participant._log;

  if (participant.state === 'disconnected') {
    return;
  }

  // Reemit state transition events from the ParticipantSignaling.
  signaling.on('stateChanged', function stateChanged(state) {
    log.debug('Transitioned to state:', state);
    participant.emit(state, participant);
    if (state === 'disconnected') {
      log.debug('Removing Track event reemitters');
      signaling.removeListener('stateChanged', stateChanged);

      participant._tracks.forEach(function (track) {
        var reemitters = participant._trackEventReemitters.get(track.id);
        if (track && reemitters) {
          reemitters.forEach(function (reemitter, event) {
            track.removeListener(event, reemitter);
          });
        }
      });

      // TODO(joma): Removing this introduced unit test failures in the RemoteParticipant.
      // Investigate further before removing.
      signaling.tracks.forEach(function (trackSignaling) {
        var track = participant._tracks.get(trackSignaling.id);
        var reemitters = participant._trackEventReemitters.get(trackSignaling.id);
        if (track && reemitters) {
          reemitters.forEach(function (reemitter, event) {
            track.removeListener(event, reemitter);
          });
        }
      });

      participant._trackEventReemitters.clear();

      participant.tracks.forEach(function (publication) {
        participant._trackPublicationEventReemitters.get(publication.trackSid).forEach(function (reemitter, event) {
          publication.removeListener(event, reemitter);
        });
      });
      participant._trackPublicationEventReemitters.clear();
    }
  });
}

/**
 * Re-emit {@link Track} events.
 * @param {Participant} participant
 * @param {Track} track
 * @param {Track.ID} id
 * @private
 */
function reemitTrackEvents(participant, track, id) {
  var trackEventReemitters = new Map();

  if (participant.state === 'disconnected') {
    return;
  }

  participant._getTrackEvents().forEach(function (eventPair) {
    var trackEvent = eventPair[0];
    var participantEvent = eventPair[1];

    trackEventReemitters.set(trackEvent, function () {
      var args = [participantEvent].concat([].slice.call(arguments));
      return participant.emit.apply(participant, _toConsumableArray(args));
    });

    track.on(trackEvent, trackEventReemitters.get(trackEvent));
  });

  participant._trackEventReemitters.set(id, trackEventReemitters);
}

/**
 * Re-emit {@link TrackPublication} events.
 * @private
 * @param {Participant} participant
 * @param {TrackPublication} publication
 */
function reemitTrackPublicationEvents(participant, publication) {
  var publicationEventReemitters = new Map();

  if (participant.state === 'disconnected') {
    return;
  }

  participant._getTrackPublicationEvents().forEach(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 2),
        publicationEvent = _ref4[0],
        participantEvent = _ref4[1];

    publicationEventReemitters.set(publicationEvent, function () {
      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      participant.emit.apply(participant, [participantEvent].concat(args, [publication]));
    });
    publication.on(publicationEvent, publicationEventReemitters.get(publicationEvent));
  });

  participant._trackPublicationEventReemitters.set(publication.trackSid, publicationEventReemitters);
}

module.exports = Participant;
},{"./eventemitter":10,"./media/track/remoteaudiotrack":29,"./media/track/remoteaudiotrackpublication":30,"./media/track/remotedatatrack":31,"./media/track/remotedatatrackpublication":32,"./media/track/remotevideotrack":35,"./media/track/remotevideotrackpublication":36,"./util":114}],43:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EventEmitter = require('events').EventEmitter;

/**
 * A {@link QueueingEventEmitter} can queue events until a listener has been
 * added.
 * @extends EventEmitter
 */

var QueueingEventEmitter = function (_EventEmitter) {
  _inherits(QueueingEventEmitter, _EventEmitter);

  /**
   * Construct a {@link QueueingEventEmitter}
   */
  function QueueingEventEmitter() {
    _classCallCheck(this, QueueingEventEmitter);

    var _this = _possibleConstructorReturn(this, (QueueingEventEmitter.__proto__ || Object.getPrototypeOf(QueueingEventEmitter)).call(this));

    Object.defineProperties(_this, {
      _queuedEvents: {
        value: new Map()
      }
    });
    return _this;
  }

  /**
   * Emit any queued events.
   * @returns {boolean} true if every event had listeners, false otherwise
  */ /**
     * Emit any queued events matching the event name.
     * @param {string} event
     * @returns {boolean} true if every event had listeners, false otherwise
     */


  _createClass(QueueingEventEmitter, [{
    key: 'dequeue',
    value: function dequeue(event) {
      var _this2 = this;

      var result = true;
      if (!event) {
        this._queuedEvents.forEach(function (_, queuedEvent) {
          result = this.dequeue(queuedEvent) && result;
        }, this);
        return result;
      }
      var queue = this._queuedEvents.get(event) || [];
      this._queuedEvents.delete(event);
      return queue.reduce(function (result, args) {
        return _this2.emit.apply(_this2, _toConsumableArray([event].concat(args))) && result;
      }, result);
    }

    /**
     * If the event has listeners, emit the event; otherwise, queue the event.
     * @param {string} event
     * @param {...*} args
     * @returns {boolean} true if the event had listeners, false if the event was queued
     */

  }, {
    key: 'queue',
    value: function queue() {
      var args = [].slice.call(arguments);
      if (this.emit.apply(this, _toConsumableArray(args))) {
        return true;
      }
      var event = args[0];
      if (!this._queuedEvents.has(event)) {
        this._queuedEvents.set(event, []);
      }
      this._queuedEvents.get(event).push(args.slice(1));
      return false;
    }
  }]);

  return QueueingEventEmitter;
}(EventEmitter);

module.exports = QueueingEventEmitter;
},{"events":165}],44:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Participant = require('./participant');

/**
 * A {@link RemoteParticipant} represents a remote {@link Participant} in a
 * {@link Room}.
 * @extends Participant
 * @property {Map<Track.SID, RemoteAudioTrackPublication>} audioTracks -
 *    The {@link Participant}'s {@link RemoteAudioTrackPublication}s
 * @property {Map<Track.SID, RemoteDataTrackPublication>} dataTracks -
 *    The {@link Participant}'s {@link RemoteDataTrackPublication}s
 * @property {Map<Track.SID, RemoteTrackPublication>} tracks -
 *    The {@link Participant}'s {@link RemoteTrackPublication}s
 * @property {Map<Track.SID, RemoteVideoTrackPublication>} videoTracks -
 *    The {@link Participant}'s {@link RemoteVideoTrackPublication}s
 * @emits RemoteParticipant#reconnected
 * @emits RemoteParticipant#reconnecting
 * @emits RemoteParticipant#trackDimensionsChanged
 * @emits RemoteParticipant#trackDisabled
 * @emits RemoteParticipant#trackEnabled
 * @emits RemoteParticipant#trackMessage
 * @emits RemoteParticipant#trackPublished
 * @emits RemoteParticipant#trackPublishPriorityChanged
 * @emits RemoteParticipant#trackStarted
 * @emits RemoteParticipant#trackSubscribed
 * @emits RemoteParticipant#trackSubscriptionFailed
 * @emits RemoteParticipant#trackSwitchedOff
 * @emits RemoteParticipant#trackSwitchedOn
 * @emits RemoteParticipant#trackUnpublished
 * @emits RemoteParticipant#trackUnsubscribed
 */

var RemoteParticipant = function (_Participant) {
  _inherits(RemoteParticipant, _Participant);

  /**
   * Construct a {@link RemoteParticipant}.
   * @param {ParticipantSignaling} signaling
   * @param {object} [options]
   */
  function RemoteParticipant(signaling, options) {
    _classCallCheck(this, RemoteParticipant);

    var _this = _possibleConstructorReturn(this, (RemoteParticipant.__proto__ || Object.getPrototypeOf(RemoteParticipant)).call(this, signaling, options));

    _this._handleTrackSignalingEvents();
    _this.once('disconnected', _this._unsubscribeTracks.bind(_this));
    return _this;
  }

  _createClass(RemoteParticipant, [{
    key: 'toString',
    value: function toString() {
      return '[RemoteParticipant #' + this._instanceId + (this.sid ? ': ' + this.sid : '') + ']';
    }

    /**
     * @private
     * @param {RemoteTrack} remoteTrack
     * @param {RemoteTrackPublication} publication
     * @param {Track.ID} id
     * @returns {?RemoteTrack}
     */

  }, {
    key: '_addTrack',
    value: function _addTrack(remoteTrack, publication, id) {
      if (!_get(RemoteParticipant.prototype.__proto__ || Object.getPrototypeOf(RemoteParticipant.prototype), '_addTrack', this).call(this, remoteTrack, id)) {
        return null;
      }
      publication._subscribed(remoteTrack);
      this.emit('trackSubscribed', remoteTrack, publication);
      return remoteTrack;
    }

    /**
     * @private
     * @param {RemoteTrackPublication} publication
     * @returns {?RemoteTrackPublication}
     */

  }, {
    key: '_addTrackPublication',
    value: function _addTrackPublication(publication) {
      var addedPublication = _get(RemoteParticipant.prototype.__proto__ || Object.getPrototypeOf(RemoteParticipant.prototype), '_addTrackPublication', this).call(this, publication);
      if (!addedPublication) {
        return null;
      }
      this.emit('trackPublished', addedPublication);
      return addedPublication;
    }
    /**
     * @private
     */

  }, {
    key: '_getTrackPublicationEvents',
    value: function _getTrackPublicationEvents() {
      return [].concat(_toConsumableArray(_get(RemoteParticipant.prototype.__proto__ || Object.getPrototypeOf(RemoteParticipant.prototype), '_getTrackPublicationEvents', this).call(this)), [['subscriptionFailed', 'trackSubscriptionFailed'], ['trackDisabled', 'trackDisabled'], ['trackEnabled', 'trackEnabled'], ['publishPriorityChanged', 'trackPublishPriorityChanged'], ['trackSwitchedOff', 'trackSwitchedOff'], ['trackSwitchedOn', 'trackSwitchedOn']]);
    }

    /**
     * @private
     */

  }, {
    key: '_unsubscribeTracks',
    value: function _unsubscribeTracks() {
      var _this2 = this;

      this.tracks.forEach(function (publication) {
        if (publication.isSubscribed) {
          var track = publication.track;
          publication._unsubscribe();
          _this2.emit('trackUnsubscribed', track, publication);
        }
      });
    }

    /**
     * @private
     * @param {RemoteTrack} remoteTrack
     * @param {RemoteTrackPublication} publication
     * @param {Track.ID} id
     * @returns {?RemoteTrack}
     */

  }, {
    key: '_removeTrack',
    value: function _removeTrack(remoteTrack, publication, id) {
      var unsubscribedTrack = this._tracks.get(id);
      if (!unsubscribedTrack) {
        return null;
      }

      _get(RemoteParticipant.prototype.__proto__ || Object.getPrototypeOf(RemoteParticipant.prototype), '_removeTrack', this).call(this, unsubscribedTrack, id);
      publication._unsubscribe();
      this.emit('trackUnsubscribed', unsubscribedTrack, publication);
      return unsubscribedTrack;
    }

    /**
     * @private
     * @param {RemoteTrackPublication} publication
     * @returns {?RemoteTrackPublication}
     */

  }, {
    key: '_removeTrackPublication',
    value: function _removeTrackPublication(publication) {
      var removedPublication = _get(RemoteParticipant.prototype.__proto__ || Object.getPrototypeOf(RemoteParticipant.prototype), '_removeTrackPublication', this).call(this, publication);
      if (!removedPublication) {
        return null;
      }
      this.emit('trackUnpublished', removedPublication);
      return removedPublication;
    }
  }]);

  return RemoteParticipant;
}(Participant);

/**
 * The {@link RemoteParticipant} has reconnected to the {@link Room} after a signaling connection disruption.
 * @event RemoteParticipant#reconnected
 */

/**
 * The {@link RemoteParticipant} is reconnecting to the {@link Room} after a signaling connection disruption.
 * @event RemoteParticipant#reconnecting
 */

/**
 * One of the {@link RemoteParticipant}'s {@link RemoteVideoTrack}'s dimensions changed.
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} whose dimensions changed
 * @event RemoteParticipant#trackDimensionsChanged
 */

/**
 * A {@link RemoteTrack} was disabled by the {@link RemoteParticipant}.
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication} associated with the disabled {@link RemoteTrack}
 * @event RemoteParticipant#trackDisabled
 */

/**
 * A {@link RemoteTrack} was enabled by the {@link RemoteParticipant}.
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication} associated with the enabled {@link RemoteTrack}
 * @event RemoteParticipant#trackEnabled
 */

/**
 * A message was received over one of the {@link RemoteParticipant}'s
 * {@link RemoteDataTrack}s.
 * @event RemoteParticipant#trackMessage
 * @param {string|ArrayBuffer} data
 * @param {RemoteDataTrack} track - The {@link RemoteDataTrack} over which the
 *   message was received
 */

/**
 * A {@link RemoteTrack} was published by the {@link RemoteParticipant} after
 * connecting to the {@link Room}. This event is not emitted for
 * {@link RemoteTrack}s that were published while the {@link RemoteParticipant}
 * was connecting to the {@link Room}.
 * @event RemoteParticipant#trackPublished
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   which represents the published {@link RemoteTrack}
 * @example
 * function trackPublished(publication) {
 *   console.log(`Track ${publication.trackSid} was published`);
 * }
 *
 * room.on('participantConnected', participant => {
 *   // Handle RemoteTracks published while connecting to the Room.
 *   participant.trackPublications.forEach(trackPublished);
 *
 *   // Handle RemoteTracks published after connecting to the Room.
 *   participant.on('trackPublished', trackPublished);
 * });
 */

/**
 * One of the {@link RemoteParticipant}'s {@link RemoteTrack}s started.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that started
 * @event RemoteParticipant#trackStarted
 */

/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was subscribed to.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was subscribed to
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was subscribed to
 * @event RemoteParticipant#trackSubscribed
 */

/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} could not be subscribed to.
 * @param {TwilioError} error - The reason the {@link RemoteTrack} could not be
 *   subscribed to
 * @param {RemoteTrackPublication} publication - The
 *   {@link RemoteTrackPublication} for the {@link RemoteTrack} that could not
 *   be subscribed to
 * @event RemoteParticipant#trackSubscriptionFailed
 */

/**
 * The {@link RemoteTrackPublication}'s publish {@link Track.Priority} was changed by the
 * {@link RemoteParticipant}.
 * @param {Track.Priority} priority - the {@link RemoteTrack}'s new publish
 *   {@link Track.Priority};
 * @param {RemoteTrackPublication} publication - The
 *   {@link RemoteTrackPublication} for the {@link RemoteTrack} that changed priority
 * @event RemoteParticipant#trackPublishPriorityChanged
 */

/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was subscribed to.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was switched off
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was switched off
 * @event RemoteParticipant#trackSwitchedOff
 */

/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was switched on.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was switched on.
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was switched on
 * @event RemoteParticipant#trackSwitchedOn
 */

/**
 * A {@link RemoteTrack} was unpublished by the {@link RemoteParticipant}.
 * @event RemoteParticipant#trackUnpublished
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   which represents the unpublished {@link RemoteTrack}
 */

/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was unsubscribed from.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was unsubscribed from
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was unsubscribed from
 * @event RemoteParticipant#trackUnsubscribed
 */

module.exports = RemoteParticipant;
},{"./participant":42}],45:[function(require,module,exports){
'use strict';

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EventEmitter = require('./eventemitter');
var RemoteParticipant = require('./remoteparticipant');
var StatsReport = require('./stats/statsreport');

var _require = require('./util'),
    valueToJSON = _require.valueToJSON;

var nInstances = 0;

/**
 * A {@link Room} represents communication between you and one or more
 * {@link RemoteParticipant}s sharing {@link AudioTrack}s and
 * {@link VideoTrack}s.
 * <br><br>
 * You can connect to a {@link Room} by calling {@link module:twilio-video.connect}.
 * @extends EventEmitter
 * @property {?RemoteParticipant} dominantSpeaker - The Dominant Speaker in the
 *   {@link Room}, if any
 * @property {boolean} isRecording - Whether or not the {@link Room} is being
 *   recorded
 * @property {LocalParticipant} localParticipant - Your {@link LocalParticipant}
 *   in the {@link Room}
 * @property {string} mediaRegion - String indicating geographical region
 *    where  media is processed for the {@link Room}.
 * @property {string} name - The {@link Room}'s name
 * @property {Map<Participant.SID, RemoteParticipant>} participants -
 *   The {@link RemoteParticipant}s participating in this {@link Room}
 * @property {Room.SID} sid - The {@link Room}'s SID
 * @property {string} state - "connected", "reconnecting", or "disconnected"
 * @throws {SignalingConnectionDisconnectedError}
 * @emits Room#disconnected
 * @emits Room#participantConnected
 * @emits Room#participantDisconnected
 * @emits Room#participantReconnected
 * @emits Room#participantReconnecting
 * @emits Room#reconnected
 * @emits Room#reconnecting
 * @emits Room#recordingStarted
 * @emits Room#recordingStopped
 * @emits Room#trackDimensionsChanged
 * @emits Room#trackDisabled
 * @emits Room#trackEnabled
 * @emits Room#trackMessage
 * @emits Room#trackPublished
 * @emits Room#trackPublishPriorityChanged
 * @emits Room#trackStarted
 * @emits Room#trackSubscribed
 * @emits Room#trackSwitchedOff
 * @emits Room#trackSwitchedOn
 * @emits Room#trackUnpublished
 * @emits Room#trackUnsubscribed
 */

var Room = function (_EventEmitter) {
  _inherits(Room, _EventEmitter);

  /**
   * Construct a {@link Room}.
   * @param {RoomSignaling} signaling
   * @param {?object} [options={}]
   */
  function Room(localParticipant, signaling, options) {
    _classCallCheck(this, Room);

    var _this = _possibleConstructorReturn(this, (Room.__proto__ || Object.getPrototypeOf(Room)).call(this));

    var log = options.log.createLog('default', _this);
    var participants = new Map();

    /* istanbul ignore next */
    Object.defineProperties(_this, {
      _log: {
        value: log
      },
      _instanceId: {
        value: ++nInstances
      },
      _options: {
        value: options
      },
      _participants: {
        value: participants
      },
      _signaling: {
        value: signaling
      },
      dominantSpeaker: {
        enumerable: true,
        get: function get() {
          return this.participants.get(signaling.dominantSpeakerSid) || null;
        }
      },
      isRecording: {
        enumerable: true,
        get: function get() {
          return signaling.recording.isEnabled || false;
        }
      },
      localParticipant: {
        enumerable: true,
        value: localParticipant
      },
      name: {
        enumerable: true,
        value: signaling.name
      },
      participants: {
        enumerable: true,
        value: participants
      },
      sid: {
        enumerable: true,
        value: signaling.sid
      },
      state: {
        enumerable: true,
        get: function get() {
          return signaling.state;
        }
      },
      mediaRegion: {
        enumerable: true,
        value: signaling.mediaRegion
      }
    });

    handleRecordingEvents(_this, signaling.recording);
    handleSignalingEvents(_this, signaling);

    log.info('Created a new Room:', _this.name);
    log.debug('Initial RemoteParticipants:', Array.from(_this._participants.values()));
    return _this;
  }

  _createClass(Room, [{
    key: 'toString',
    value: function toString() {
      return '[Room #' + this._instanceId + ': ' + this.sid + ']';
    }

    /**
     * Disconnect from the {@link Room}.
     * @returns {this}
     */

  }, {
    key: 'disconnect',
    value: function disconnect() {
      this._log.info('Disconnecting');
      this._signaling.disconnect();
      return this;
    }

    /**
     * Get the {@link Room}'s media statistics. This is not supported in Safari 12.0 or below
     * due to this bug : https://bugs.webkit.org/show_bug.cgi?id=192601
     *
     * @returns {Promise.<Array<StatsReport>>}
     */

  }, {
    key: 'getStats',
    value: function getStats() {
      var _this2 = this;

      return this._signaling.getStats().then(function (responses) {
        return Array.from(responses).map(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              id = _ref2[0],
              response = _ref2[1];

          return new StatsReport(id, Object.assign({}, response, {
            localAudioTrackStats: rewriteLocalTrackIds(_this2, response.localAudioTrackStats),
            localVideoTrackStats: rewriteLocalTrackIds(_this2, response.localVideoTrackStats)
          }));
        });
      });
    }
  }, {
    key: 'toJSON',
    value: function toJSON() {
      return valueToJSON(this);
    }
  }]);

  return Room;
}(EventEmitter);

function rewriteLocalTrackIds(room, trackStats) {
  var localParticipantSignaling = room.localParticipant._signaling;
  return trackStats.reduce(function (trackStats, trackStat) {
    var publication = localParticipantSignaling.tracks.get(trackStat.trackId);
    var trackSender = localParticipantSignaling.getSender(publication);
    return trackSender ? [Object.assign({}, trackStat, { trackId: trackSender.id })].concat(trackStats) : trackStats;
  }, []);
}

/**
 * A {@link Room.SID} is a 34-character string starting with "RM"
 * that uniquely identifies a {@link Room}.
 * @type string
 * @typedef Room.SID
 */

/**
 * The Dominant Speaker in the {@link Room} changed. Either the Dominant Speaker
 * is a new {@link RemoteParticipant} or the Dominant Speaker has been reset and
 * is now null.
 * @param {?RemoteParticipant} dominantSpeaker - The Dominant Speaker in the
 *   {@link Room}, if any
 * @event Room#dominantSpeakerChanged
 */

/**
 * Your {@link LocalParticipant} was disconnected from the {@link Room} and all
 * other {@link RemoteParticipant}s.
 * @param {Room} room - The {@link Room} your
 *   {@link LocalParticipant} was disconnected from
 * @param {?TwilioError} error - Present when the {@link LocalParticipant} got
 *   disconnected from the {@link Room} unexpectedly
 * @event Room#disconnected
 * @example
 * myRoom.on('disconnected', function(room, error) {
 *   if (error) {
 *     console.log('Unexpectedly disconnected:', error);
 *   }
 *   myRoom.localParticipant.tracks.forEach(function(track) {
 *     track.stop();
 *     track.detach();
 *   });
 * });
 */

/**
 * A {@link RemoteParticipant} joined the {@link Room}.
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} who joined
 * @event Room#participantConnected
 * @example
 * myRoom.on('participantConnected', function(participant) {
 *   console.log(participant.identity + ' joined the Room');
 * });
 */

/**
 * A {@link RemoteParticipant} left the {@link Room}.
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} who left
 * @event Room#participantDisconnected
 * @example
 * myRoom.on('participantDisconnected', function(participant) {
 *   console.log(participant.identity + ' left the Room');
 *   participant.tracks.forEach(function(track) {
 *     track.detach().forEach(function(mediaElement) {
 *       mediaElement.remove();
 *     });
 *   });
 * });
 */

/**
 * A {@link RemoteParticipant} has reconnected to the {@link Room} after a signaling connection disruption.
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} that has reconnected.
 * @event Room#participantReconnected
 * @example
 * myRoom.on('participantReconnected', participant => {
 *   console.log(participant.identity + ' reconnected to the Room');
 * });
 */

/**
 * A {@link RemoteParticipant} is reconnecting to the {@link Room} after a signaling connection disruption.
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} that is reconnecting.
 * @event Room#participantReconnecting
 * @example
 * myRoom.on('participantReconnecting', participant => {
 *   console.log(participant.identity + ' is reconnecting to the Room');
 * });
 */

/**
 * Your application successfully reconnected to the {@link Room}. When this
 * event is emitted, the {@link Room} is in state "connected".
 * @event Room#reconnected
 * @example
 * myRoom.on('reconnected', () => {
 *   console.log('Reconnected!');
 * });
 */

/**
 * Your application is reconnecting to the {@link Room}. This happens when there
 * is a disruption in your signaling connection and/or your media connection. When
 * this event is emitted, the {@link Room} is in state "reconnecting". If reconnecting
 * succeeds, the {@link Room} will emit a "reconnected" event.
 * @param {MediaConnectionError|SignalingConnectionDisconnectedError} error - A
 *   {@link MediaConnectionError} if your application is reconnecting due to a
 *   disruption in your media connection, or a {@link SignalingConnectionDisconnectedError}
 *   if your application is reconnecting due to a disruption in your signaling connection
 * @event Room#reconnecting
 * @example
 * myRoom.on('reconnecting', error => {
 *   if (error.code === 53001) {
 *     console.log('Reconnecting your signaling connection!', error.message);
 *   } else if (error.code === 53405) {
 *     console.log('Reconnecting your media connection!', error.message);
 *   }
 * });
 */

/**
 * The {@link Room} is now being recorded
 * @event Room#recordingStarted
 */

/**
 * The {@link Room} is no longer being recorded
 * @event Room#recordingStopped
 */

/**
 * One of the {@link RemoteParticipant}'s {@link VideoTrack}'s dimensions changed.
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} whose dimensions changed
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteVideoTrack}'s dimensions changed
 * @event Room#trackDimensionsChanged
 */

/**
 * A {@link RemoteTrack} was disabled by a {@link RemoteParticipant} in the {@link Room}.
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication} that represents disabled {@link RemoteTrack}
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} who
 *   disabled the {@link RemoteTrack}
 * @event Room#trackDisabled
 */

/**
 * A {@link RemoteTrack} was enabled by a {@link RemoteParticipant} in the {@link Room}.
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication} that represents enabled {@link RemoteTrack}
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} who
 *   enabled the {@link RemoteTrack}
 * @event Room#trackEnabled
 */

/**
 * A message was received over one of the {@link RemoteParticipant}'s
 * {@link RemoteDataTrack}'s.
 * @param {string|ArrayBuffer} data
 * @param {RemoteVideoTrack} track - The {@link RemoteDataTrack} over which the
 *   message was received
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteDataTrack} received the message
 * @event Room#trackMessage
 */

/**
 * A {@link RemoteTrack} was published by a {@link RemoteParticipant} after
 * connecting to the {@link Room}. This event is not emitted for
 * {@link RemoteTrack}s that were published while the {@link RemoteParticipant}
 * was connecting to the {@link Room}.
 * @event Room#trackPublished
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   which represents the published {@link RemoteTrack}
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} who
 *   published the {@link RemoteTrack}
 * @example
 * function trackPublished(publication, participant) {
 *   console.log(`RemoteParticipant ${participant.sid} published Track ${publication.trackSid}`);
 * }
 *
 * // Handle RemoteTracks published after connecting to the Room.
 * room.on('trackPublished', trackPublished);
 *
 * room.on('participantConnected', participant => {
 *   // Handle RemoteTracks published while connecting to the Room.
 *   participant.trackPublications.forEach(publication => trackPublished(publication, participant));
 * });
 */

/**
 * One of a {@link RemoteParticipant}'s {@link RemoteTrack}s in the {@link Room} started.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that started
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteTrack} started
 * @event Room#trackStarted
 */

/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was subscribed to.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was subscribed
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was subscribed to
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteTrack} was subscribed
 * @event Room#trackSubscribed
 * @example
 * room.on('trackSubscribed', function(track, publication, participant) {
 *   var participantView = document.getElementById('participant-view-' + participant.identity);
 *   participantView.appendChild(track.attach());
 * });
 */

/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was switched off.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was switched off
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was subscribed to
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteTrack} was switched off
 * @event Room#trackSwitchedOff
 */

/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was switched on.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was switched on
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was subscribed to
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteTrack} was switched on
 * @event Room#trackSwitchedOn
 */

/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} could not be subscribed to.
 * @param {TwilioError} error - The reason the {@link RemoteTrack} could not be
 *   subscribed to
 * @param {RemoteTrackPublication} publication - The
 *   {@link RemoteTrackPublication} for the {@link RemoteTrack} that could not
 *   be subscribed to
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteTrack} could not be subscribed to
 * @event Room#trackSubscriptionFailed
 */

/**
 * The {@link RemoteTrack}'s publish {@link Track.Priority} was changed by the
 * {@link RemoteParticipant}.
 * @param {Track.Priority} priority - the {@link RemoteTrack}'s new publish
 *   {@link Track.Priority};
 * @param {RemoteTrackPublication} publication - The
 *   {@link RemoteTrackPublication} for the {@link RemoteTrack} that changed priority
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteTrack} changed priority
 * @event Room#trackPublishPriorityChanged
 */

/**
 * A {@link RemoteTrack} was unpublished by a {@link RemoteParticipant} to the {@link Room}.
 * @event Room#trackUnpublished
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   which represents the unpublished {@link RemoteTrack}
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} who
 *   unpublished the {@link RemoteTrack}
 */

/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was unsubscribed from.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was unsubscribed
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was unsubscribed from
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteTrack} was unsubscribed
 * @event Room#trackUnsubscribed
 * @example
 * room.on('trackUnsubscribed', function(track, publication, participant) {
 *   track.detach().forEach(function(mediaElement) {
 *     mediaElement.remove();
 *   });
 * });
 */

function connectParticipant(room, participantSignaling) {
  var log = room._log;
  var participant = new RemoteParticipant(participantSignaling, { log: log });

  log.info('A new RemoteParticipant connected:', participant);
  room._participants.set(participant.sid, participant);
  room.emit('participantConnected', participant);

  // Reemit Track and RemoteParticipant events.
  var eventListeners = [['reconnected', 'participantReconnected'], ['reconnecting', 'participantReconnecting'], 'trackDimensionsChanged', 'trackDisabled', 'trackEnabled', 'trackMessage', 'trackPublished', 'trackPublishPriorityChanged', 'trackStarted', 'trackSubscribed', 'trackSubscriptionFailed', 'trackSwitchedOff', 'trackSwitchedOn', 'trackUnpublished', 'trackUnsubscribed'].map(function (eventOrPair) {
    var _ref3 = Array.isArray(eventOrPair) ? eventOrPair : [eventOrPair, eventOrPair],
        _ref4 = _slicedToArray(_ref3, 2),
        event = _ref4[0],
        participantEvent = _ref4[1];

    function reemit() {
      var args = [].slice.call(arguments);
      args.unshift(participantEvent);
      args.push(participant);
      room.emit.apply(room, _toConsumableArray(args));
    }
    participant.on(event, reemit);
    return [event, reemit];
  });

  participant.once('disconnected', function participantDisconnected() {
    var dominantSpeaker = room.dominantSpeaker;
    log.info('RemoteParticipant disconnected:', participant);
    room._participants.delete(participant.sid);
    eventListeners.forEach(function (args) {
      participant.removeListener(args[0], args[1]);
    });
    room.emit('participantDisconnected', participant);
    if (participant === dominantSpeaker) {
      room.emit('dominantSpeakerChanged', room.dominantSpeaker);
    }
  });
}

function handleRecordingEvents(room, recording) {
  recording.on('updated', function updated() {
    var started = recording.isEnabled;
    room._log.info('Recording ' + (started ? 'started' : 'stopped'));
    room.emit('recording' + (started ? 'Started' : 'Stopped'));
  });
}

function handleSignalingEvents(room, signaling) {
  var log = room._log;

  // Reemit RemoteParticipant events from the RoomSignaling.
  log.debug('Creating a new RemoteParticipant for each ParticipantSignaling ' + 'in the RoomSignaling');
  signaling.participants.forEach(connectParticipant.bind(null, room));
  log.debug('Setting up RemoteParticipant creation for all subsequent ' + 'ParticipantSignalings that connect to the RoomSignaling');
  signaling.on('participantConnected', connectParticipant.bind(null, room));

  signaling.on('dominantSpeakerChanged', function () {
    return room.emit('dominantSpeakerChanged', room.dominantSpeaker);
  });

  // Reemit state transition events from the RoomSignaling.
  signaling.on('stateChanged', function stateChanged(state, error) {
    log.info('Transitioned to state:', state);
    switch (state) {
      case 'disconnected':
        room.participants.forEach(function (participant) {
          participant._unsubscribeTracks();
        });
        room.emit(state, room, error);
        room.localParticipant.tracks.forEach(function (publication) {
          publication.unpublish();
        });
        signaling.removeListener('stateChanged', stateChanged);
        break;
      case 'reconnecting':

        // NOTE(mpatwardhan): `stateChanged` can get emitted with StateMachine locked.
        // Do not signal  public events synchronously with lock held.
        setTimeout(function () {
          return room.emit('reconnecting', error);
        }, 0);

        break;
      default:

        // NOTE(mpatwardhan): `stateChanged` can get emitted with StateMachine locked.
        // Do not signal  public events synchronously with lock held.
        setTimeout(function () {
          return room.emit('reconnected');
        }, 0);
    }
  });
}

module.exports = Room;
},{"./eventemitter":10,"./remoteparticipant":44,"./stats/statsreport":101,"./util":114}],46:[function(require,module,exports){
/* eslint consistent-return:0 */
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var ParticipantSignaling = require('./participant');
var RoomSignaling = require('./room');
var StateMachine = require('../statemachine');

/*
Signaling States
----------------

              +---------+
              |         |
              | opening |
         +--->|         |
         |    +---------+
    +--------+   |   |   +------+
    |        |<--+   +-->|      |
    | closed |<----------| open |
    |        |<--+   +-->|      |
    +--------+   |   |   +------+
              +---------+   |
              |         |<--+
              | closing |
              |         |
              +---------+

*/

var states = {
  closed: ['opening'],
  opening: ['closed', 'open'],
  open: ['closed', 'closing'],
  closing: ['closed', 'open']
};

/**
 * @extends StateMachine
 * @property {string} state - one of "closed", "opening", "open", or "closing"
 */

var Signaling = function (_StateMachine) {
  _inherits(Signaling, _StateMachine);

  /**
   * Construct {@link Signaling}.
   */
  function Signaling() {
    _classCallCheck(this, Signaling);

    return _possibleConstructorReturn(this, (Signaling.__proto__ || Object.getPrototypeOf(Signaling)).call(this, 'closed', states));
  }

  /**
   * @private
   */
  // NOTE(mroberts): This is a dummy implementation suitable for testing.


  _createClass(Signaling, [{
    key: '_close',
    value: function _close(key) {
      this.transition('closing', key);
      this.transition('closed', key);
      return Promise.resolve(this);
    }

    /**
     * @private
     */
    // NOTE(mroberts): This is a dummy implementation suitable for testing.

  }, {
    key: '_connect',
    value: function _connect(localParticipant, token, encodingParameters, preferredCodecs, options) {
      localParticipant.connect('PA00000000000000000000000000000000', 'test');
      var sid = 'RM00000000000000000000000000000000';
      var promise = Promise.resolve(new RoomSignaling(localParticipant, sid, options));
      promise.cancel = function cancel() {};
      return promise;
    }

    /**
     * @private
     */
    // NOTE(mroberts): This is a dummy implementation suitable for testing.

  }, {
    key: '_open',
    value: function _open(key) {
      this.transition('opening', key);
      this.transition('open', key);
      return Promise.resolve(this);
    }

    /**
     * Close the {@link Signaling}.
     * @returns {Promise<this>}
     */

  }, {
    key: 'close',
    value: function close() {
      var _this2 = this;

      return this.bracket('close', function (key) {
        switch (_this2.state) {
          case 'closed':
            return _this2;
          case 'open':
            return _this2._close(key);
          default:
            throw new Error('Unexpected Signaling state "' + _this2.state + '"');
        }
      });
    }

    /**
     * Connect to a {@link RoomSignaling}.
     * @param {ParticipantSignaling} localParticipant
     * @param {string} token
     * @param {EncodingParametersImpl} encodingParameters
     * @param {PreferredCodecs} preferredCodecs
     * @param {object} options
     * @returns {Promise<function(): CancelablePromise<RoomSignaling>>}
     */

  }, {
    key: 'connect',
    value: function connect(localParticipant, token, encodingParameters, preferredCodecs, options) {
      var self = this;
      return this.bracket('connect', function transition(key) {
        switch (self.state) {
          case 'closed':
            return self._open(key).then(transition.bind(null, key));
          case 'open':
            // NOTE(mroberts): We don't need to hold the lock in _connect. Instead,
            // we just need to ensure the Signaling remains open.
            self.releaseLockCompletely(key);
            return self._connect(localParticipant, token, encodingParameters, preferredCodecs, options);
          default:
            throw new Error('Unexpected Signaling state "' + self.state + '"');
        }
      });
    }

    /**
     * Create a local {@link ParticipantSignaling}.
     * @returns {ParticipantSignaling}
     */

  }, {
    key: 'createLocalParticipantSignaling',
    value: function createLocalParticipantSignaling() {
      return new ParticipantSignaling();
    }

    /**
     * Open the {@link Signaling}.
     * @returns {Promise<this>}
     */

  }, {
    key: 'open',
    value: function open() {
      var _this3 = this;

      return this.bracket('open', function (key) {
        switch (_this3.state) {
          case 'closed':
            return _this3._open(key);
          case 'open':
            return _this3;
          default:
            throw new Error('Unexpected Signaling state "' + _this3.state + '"');
        }
      });
    }
  }]);

  return Signaling;
}(StateMachine);

module.exports = Signaling;
},{"../statemachine":73,"./participant":49,"./room":53}],47:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var ParticipantSignaling = require('./participant');

var LocalParticipantSignaling = function (_ParticipantSignaling) {
  _inherits(LocalParticipantSignaling, _ParticipantSignaling);

  function LocalParticipantSignaling() {
    _classCallCheck(this, LocalParticipantSignaling);

    var _this = _possibleConstructorReturn(this, (LocalParticipantSignaling.__proto__ || Object.getPrototypeOf(LocalParticipantSignaling)).call(this));

    Object.defineProperties(_this, {
      _publicationsToTrackSenders: {
        value: new Map()
      },
      _trackSendersToPublications: {
        value: new Map()
      }
    });
    return _this;
  }

  /**
   * @param {DataTrackSender|MediaTrackSender} trackSender
   * @param {string} name
   * @param {Track.Priority} priority
   * @returns {LocalTrackPublicationSignaling} publication
   */


  _createClass(LocalParticipantSignaling, [{
    key: 'addTrack',
    value: function addTrack(trackSender, name, priority) {
      var publication = this._createLocalTrackPublicationSignaling(trackSender, name, priority);
      this._trackSendersToPublications.set(trackSender, publication);
      this._publicationsToTrackSenders.set(publication, trackSender);
      _get(LocalParticipantSignaling.prototype.__proto__ || Object.getPrototypeOf(LocalParticipantSignaling.prototype), 'addTrack', this).call(this, publication);
      return this;
    }

    /**
     * @param {DataTrackSender|MediaTrackSender} trackSender
     * @returns {?LocalTrackPublicationSignaling}
     */

  }, {
    key: 'getPublication',
    value: function getPublication(trackSender) {
      return this._trackSendersToPublications.get(trackSender) || null;
    }

    /**
     * @param {LocalTrackPublicationSignaling} trackPublication
     * @returns {?DataTrackSender|MediaTrackSender}
     */

  }, {
    key: 'getSender',
    value: function getSender(trackPublication) {
      return this._publicationsToTrackSenders.get(trackPublication) || null;
    }

    /**
     * @param {DataTrackSender|MediaTrackSender} trackSender
     * @returns {?LocalTrackPublicationSignaling}
     */

  }, {
    key: 'removeTrack',
    value: function removeTrack(trackSender) {
      var publication = this._trackSendersToPublications.get(trackSender);
      if (!publication) {
        return null;
      }
      this._trackSendersToPublications.delete(trackSender);
      this._publicationsToTrackSenders.delete(publication);
      var didDelete = _get(LocalParticipantSignaling.prototype.__proto__ || Object.getPrototypeOf(LocalParticipantSignaling.prototype), 'removeTrack', this).call(this, publication);
      if (didDelete) {
        publication.stop();
      }
      return publication;
    }
  }]);

  return LocalParticipantSignaling;
}(ParticipantSignaling);

module.exports = LocalParticipantSignaling;
},{"./participant":49}],48:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TrackSignaling = require('./track');

/**
 * A {@link LocalTrackPublication} implementation
 * @extends TrackSignaling
 * @property {Track.ID} id
 */

var LocalTrackPublicationSignaling = function (_TrackSignaling) {
  _inherits(LocalTrackPublicationSignaling, _TrackSignaling);

  /**
   * Construct a {@link LocalTrackPublicationSignaling}. {@link TrackSenders}
   * are always cloned.
   * @param {DataTrackSender|MediaTrackSender} trackSender - the {@link TrackSender}
   *   of the {@link LocalTrack} to be published
   * @param {string} name - the name of the {@link LocalTrack} to be published
   * @param {Track.Priority} priority - initial {@link Track.Priority}
   */
  function LocalTrackPublicationSignaling(trackSender, name, priority) {
    _classCallCheck(this, LocalTrackPublicationSignaling);

    trackSender = trackSender.clone();
    var enabled = trackSender.kind === 'data' ? true : trackSender.track.enabled;

    var _this = _possibleConstructorReturn(this, (LocalTrackPublicationSignaling.__proto__ || Object.getPrototypeOf(LocalTrackPublicationSignaling)).call(this, name, trackSender.kind, enabled, priority));

    _this.setTrackTransceiver(trackSender);
    Object.defineProperties(_this, {
      _updatedPriority: {
        value: priority,
        writable: true
      },
      id: {
        enumerable: true,
        value: trackSender.id
      }
    });
    return _this;
  }

  /**
   * The updated {@link Track.Priority} of the {@link LocalTrack}.
   * @property {Track.priority}
   */


  _createClass(LocalTrackPublicationSignaling, [{
    key: 'enable',


    /**
     * Enable (or disable) the {@link LocalTrackPublicationSignaling} if it is not
     * already enabled (or disabled). This also updates the cloned
     * {@link MediaTrackSender}'s MediaStreamTracks `enabled` state.
     * @param {boolean} [enabled=true]
     * @return {this}
     */
    value: function enable(enabled) {
      enabled = typeof enabled === 'boolean' ? enabled : true;
      this.trackTransceiver.track.enabled = enabled;
      return _get(LocalTrackPublicationSignaling.prototype.__proto__ || Object.getPrototypeOf(LocalTrackPublicationSignaling.prototype), 'enable', this).call(this, enabled);
    }

    /**
     * Rejects the SID's deferred promise with the given Error.
     * @param {Error} error
     * @returns {this}
     */

  }, {
    key: 'publishFailed',
    value: function publishFailed(error) {
      if (setError(this, error)) {
        this.emit('updated');
      }
      return this;
    }

    /**
     * Update the {@link Track.Priority} of the published {@link LocalTrack}.
     * @param {Track.priority} priority
     * @returns {this}
     */

  }, {
    key: 'setPriority',
    value: function setPriority(priority) {
      if (this._updatedPriority !== priority) {
        this._updatedPriority = priority;
        this.emit('updated');
      }
      return this;
    }

    /**
     * Set the published {@link LocalTrack}'s {@link Track.SID}.
     * @param {Track.SID} sid
     * @returns {this}
     */

  }, {
    key: 'setSid',
    value: function setSid(sid) {
      if (this._error) {
        return this;
      }
      return _get(LocalTrackPublicationSignaling.prototype.__proto__ || Object.getPrototypeOf(LocalTrackPublicationSignaling.prototype), 'setSid', this).call(this, sid);
    }

    /**
     * Stop the cloned {@link TrackSender}.
     * @returns {void}
     */

  }, {
    key: 'stop',
    value: function stop() {
      this.trackTransceiver.stop();
    }
  }, {
    key: 'updatedPriority',
    get: function get() {
      return this._updatedPriority;
    }
  }]);

  return LocalTrackPublicationSignaling;
}(TrackSignaling);

/**
 * @param {LocalTrackPublication} publication
 * @param {Error} error
 * @returns {boolean} updated
 */


function setError(publication, error) {
  if (publication._sid !== null || publication._error) {
    return false;
  }
  publication._error = error;
  return true;
}

module.exports = LocalTrackPublicationSignaling;
},{"./track":54}],49:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var StateMachine = require('../statemachine');
var NetworkQualityStats = require('../stats/networkqualitystats');

/*
ParticipantSignaling States
----------------------

    +------------+     +-----------+     +--------------+
    |            |     |           |     |              |
    | connecting |---->| connected |---->| disconnected |
    |            |     |           |     |              |
    +------------+     +-----------+     +--------------+
                           | ^                    ^
                           | |  +--------------+  |
                           | |--|              |  |
                           |--->| reconnecting |--|
                                |              |
                                +--------------+
*/

var states = {
  connecting: ['connected'],
  connected: ['disconnected', 'reconnecting'],
  reconnecting: ['connected', 'disconnected'],
  disconnected: []
};

/**
 * A {@link Participant} implementation
 * @extends StateMachine
 * @property {?string} identity
 * @property {?Participant.SID} sid
 * @property {string} state - "connecting", "connected", or "disconnected"
 * @property {Map<Track.ID | Track.SID, TrackSignaling>} tracks
 * @emits ParticipantSignaling#networkQualityLevelChanged
 * @emits ParticipantSignaling#trackAdded
 * @emits ParticipantSignaling#trackRemoved
 */

var ParticipantSignaling = function (_StateMachine) {
  _inherits(ParticipantSignaling, _StateMachine);

  /**
   * Construct a {@link ParticipantSignaling}.
   */
  function ParticipantSignaling() {
    _classCallCheck(this, ParticipantSignaling);

    var _this = _possibleConstructorReturn(this, (ParticipantSignaling.__proto__ || Object.getPrototypeOf(ParticipantSignaling)).call(this, 'connecting', states));

    Object.defineProperties(_this, {
      _enqueuedPriorityUpdates: {
        value: new Map()
      },
      _identity: {
        writable: true,
        value: null
      },
      _networkQualityLevel: {
        value: null,
        writable: true
      },
      _networkQualityStats: {
        value: null,
        writable: true
      },
      _sid: {
        writable: true,
        value: null
      },
      _trackPrioritySignaling: {
        value: null,
        writable: true
      },
      identity: {
        enumerable: true,
        get: function get() {
          return this._identity;
        }
      },
      sid: {
        enumerable: true,
        get: function get() {
          return this._sid;
        }
      },
      tracks: {
        enumerable: true,
        value: new Map()
      }
    });
    return _this;
  }

  /**
   * Get the current {@link NetworkQualityLevel}, if any.
   * @returns {?NetworkQualityLevel} networkQualityLevel - initially null
   */


  _createClass(ParticipantSignaling, [{
    key: 'addTrack',


    /**
     * Add the {@link TrackSignaling}, MediaStreamTrack, or
     * {@link DataTrackSender} to the {@link ParticipantSignaling}.
     * @param {TrackSignaling|DataTrackSender|MediaTrackSender} track
     * @returns {this}
     * @fires ParticipantSignaling#trackAdded
     */
    value: function addTrack(track) {
      this.tracks.set(track.id || track.sid, track);
      this.emit('trackAdded', track);
      return this;
    }

    /**
     * Disconnect the {@link ParticipantSignaling}.
     * @returns {boolean}
     */

  }, {
    key: 'disconnect',
    value: function disconnect() {
      if (this.state !== 'disconnected') {
        this.preempt('disconnected');
        return true;
      }
      return false;
    }

    /**
     * Remove the {@link TrackSignaling}, MediaStreamTrack, or
     * {@link DataTrackSender} from the {@link ParticipantSignaling}.
     * @param {TrackSignaling|DataTrackSender|MediaTrackSender} track
     * @returns {?TrackSignaling}
     * @fires ParticipantSignaling#trackRemoved
     */

  }, {
    key: 'removeTrack',
    value: function removeTrack(track) {
      var signaling = this.tracks.get(track.id || track.sid);
      this.tracks.delete(track.id || track.sid);
      if (signaling) {
        this.emit('trackRemoved', track);
      }
      return signaling || null;
    }

    /**
     * @param {NetworkQualityLevel} networkQualityLevel
     * @param {?NetworkQualityLevels} [networkQualityLevels=null]
     * @returns {void}
     */

  }, {
    key: 'setNetworkQualityLevel',
    value: function setNetworkQualityLevel(networkQualityLevel, networkQualityLevels) {
      if (this._networkQualityLevel !== networkQualityLevel) {
        this._networkQualityLevel = networkQualityLevel;
        this._networkQualityStats = networkQualityLevels && (networkQualityLevels.audio || networkQualityLevels.video) ? new NetworkQualityStats(networkQualityLevels) : null;
        this.emit('networkQualityLevelChanged');
      }
    }

    /**
     * updates the subscriber priority for the given track.
     * @param {Track.SID} trackSid
     * @param {?Track.Priority} priority
     * @returns {void}
     */

  }, {
    key: 'updateSubscriberTrackPriority',
    value: function updateSubscriberTrackPriority(trackSid, priority) {
      // note the most recent priority update for the track.
      this._enqueuedPriorityUpdates.set(trackSid, priority);
      if (this._trackPrioritySignaling) {
        this._trackPrioritySignaling.sendTrackPriorityUpdate(trackSid, 'subscribe', priority);
      }
    }

    /**
     * Set the {@link TrackPrioritySignaling}.
     * @param {TrackPrioritySignaling} trackPrioritySignaling
     * @returns {this}
     */

  }, {
    key: 'setTrackPrioritySignaling',
    value: function setTrackPrioritySignaling(trackPrioritySignaling) {
      var _this2 = this;

      this._trackPrioritySignaling = trackPrioritySignaling;
      if (trackPrioritySignaling) {
        this._enqueuedPriorityUpdates.forEach(function (priority, trackSid) {
          _this2._trackPrioritySignaling.sendTrackPriorityUpdate(trackSid, 'subscribe', priority);
        });
        // NOTE(mpatwardhan)- we intentionally do not clear _enqueuedPriorityUpdates,
        // this cache will be used to re-send the priorities in case of VMS-FailOver.
      }
      return this;
    }

    /**
     * Connect the {@link ParticipantSignaling}.
     * @param {Participant.SID} sid
     * @param {string} identity
     * @returns {boolean}
     */

  }, {
    key: 'connect',
    value: function connect(sid, identity) {
      if (this.state === 'connecting' || this.state === 'reconnecting') {
        if (!this._sid) {
          this._sid = sid;
        }
        if (!this._identity) {
          this._identity = identity;
        }
        this.preempt('connected');
        return true;
      }
      return false;
    }

    /**
     * Transition to "reconnecting" state.
     * @returns {boolean}
     */

  }, {
    key: 'reconnecting',
    value: function reconnecting() {
      if (this.state === 'connecting' || this.state === 'connected') {
        this.preempt('reconnecting');
        return true;
      }
      return false;
    }
  }, {
    key: 'networkQualityLevel',
    get: function get() {
      return this._networkQualityLevel;
    }

    /**
     * Get the current {@link NetworkQualityStats}
     * @returns {?NetworkQualityStats} networkQualityStats - initially null
     */

  }, {
    key: 'networkQualityStats',
    get: function get() {
      return this._networkQualityStats;
    }
  }]);

  return ParticipantSignaling;
}(StateMachine);

/**
 * @event ParticipantSignaling#event:networkQualityLevelChanged
 */

/**
 * {@link TrackSignaling} was added to the {@link ParticipantSignaling}.
 * @event ParticipantSignaling#trackAdded
 * @param {TrackSignaling} track
 */

/**
 * {@link TrackSignaling} was removed from the {@link ParticipantSignaling}.
 * @event ParticipantSignaling#trackRemoved
 * @param {TrackSignaling} track
 */

module.exports = ParticipantSignaling;
},{"../statemachine":73,"../stats/networkqualitystats":88}],50:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EventEmitter = require('events').EventEmitter;

/**
 * Represents recording state
 * @extends EventEmitter
 * @property {?boolean} isEnabled
 */

var RecordingSignaling = function (_EventEmitter) {
  _inherits(RecordingSignaling, _EventEmitter);

  /**
   * Construct a {@link RecordingSignaling}.
   */
  function RecordingSignaling() {
    _classCallCheck(this, RecordingSignaling);

    var _this = _possibleConstructorReturn(this, (RecordingSignaling.__proto__ || Object.getPrototypeOf(RecordingSignaling)).call(this));

    Object.defineProperties(_this, {
      _isEnabled: {
        value: null,
        writable: true
      },
      isEnabled: {
        enumerable: true,
        get: function get() {
          return this._isEnabled;
        }
      }
    });
    return _this;
  }

  /**
   * Disable the {@link RecordingSignaling} if it is not already disabled.
   * @return {this}
   */


  _createClass(RecordingSignaling, [{
    key: 'disable',
    value: function disable() {
      return this.enable(false);
    }

    /**
     * Enable (or disable) the {@link RecordingSignaling} if it is not already enabled
     * (or disabled).
     * @param {boolean} [enabled=true]
     * @return {this}
     */

  }, {
    key: 'enable',
    value: function enable(enabled) {
      enabled = typeof enabled === 'boolean' ? enabled : true;
      if (this.isEnabled !== enabled) {
        this._isEnabled = enabled;
        this.emit('updated');
      }
      return this;
    }
  }]);

  return RecordingSignaling;
}(EventEmitter);

/**
 * Emitted whenever the {@link RecordingSignaling} is updated
 * @event RecordingSignaling#updated
 */

module.exports = RecordingSignaling;
},{"events":165}],51:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var ParticipantSignaling = require('./participant');

/**
 * A {@link Participant} implementation
 * @extends ParticipantSignaling
 * @property {string} identity
 * @property {Participant.SID} sid
 */

var RemoteParticipantSignaling = function (_ParticipantSignaling) {
  _inherits(RemoteParticipantSignaling, _ParticipantSignaling);

  /**
   * Construct a {@link RemoteParticipantSignaling}.
   * @param {Participant.SID} sid
   * @param {string} identity
   */
  function RemoteParticipantSignaling(sid, identity) {
    _classCallCheck(this, RemoteParticipantSignaling);

    var _this = _possibleConstructorReturn(this, (RemoteParticipantSignaling.__proto__ || Object.getPrototypeOf(RemoteParticipantSignaling)).call(this));

    _this.connect(sid, identity);
    return _this;
  }

  return RemoteParticipantSignaling;
}(ParticipantSignaling);

module.exports = RemoteParticipantSignaling;
},{"./participant":49}],52:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TrackSignaling = require('./track');

/**
 * A {@link RemoteTrackPublication} implementation
 * @extends TrackSignaling
 */

var RemoteTrackPublicationSignaling = function (_TrackSignaling) {
  _inherits(RemoteTrackPublicationSignaling, _TrackSignaling);

  /**
   * Construct a {@link RemoteTrackPublicationSignaling}.
   * @param {Track.SID} sid
   * @param {string} name
   * @param {Track.Kind} kind
   * @param {boolean} isEnabled
   * @param {Track.Priority} priority
   */
  function RemoteTrackPublicationSignaling(sid, name, kind, isEnabled, priority) {
    _classCallCheck(this, RemoteTrackPublicationSignaling);

    var _this = _possibleConstructorReturn(this, (RemoteTrackPublicationSignaling.__proto__ || Object.getPrototypeOf(RemoteTrackPublicationSignaling)).call(this, name, kind, isEnabled, priority));

    Object.defineProperties(_this, {
      _isSwitchedOff: {
        value: false,
        writable: true
      }
    });
    _this.setSid(sid);
    return _this;
  }

  /**
   * Whether the {@link RemoteTrackPublicationSignaling} is subscribed to.
   * @property {boolean}
   */


  _createClass(RemoteTrackPublicationSignaling, [{
    key: 'subscribeFailed',


    /**
     * @param {Error} error
     * @returns {this}
     */
    value: function subscribeFailed(error) {
      if (!this.error) {
        this._error = error;
        this.emit('updated');
      }
      return this;
    }

    /**
     * Update the publish {@link Track.Priority}.
     * @param {Track.Priority} priority
     * @returns {this}
     */

  }, {
    key: 'setPriority',
    value: function setPriority(priority) {
      if (this._priority !== priority) {
        this._priority = priority;
        this.emit('updated');
      }
      return this;
    }

    /**
     * Updates track switch on/off state.
     * @param {boolean} isSwitchedOff
     * @returns {this}
     */

  }, {
    key: 'setSwitchedOff',
    value: function setSwitchedOff(isSwitchedOff) {
      if (this._isSwitchedOff !== isSwitchedOff) {
        this._isSwitchedOff = isSwitchedOff;
        this.emit('updated');
      }
      return this;
    }
  }, {
    key: 'isSubscribed',
    get: function get() {
      return !!this.trackTransceiver;
    }

    /**
     * Whether the {@link RemoteTrackPublicationSignaling} is switched off.
     * @property {boolean}
     */

  }, {
    key: 'isSwitchedOff',
    get: function get() {
      return this._isSwitchedOff;
    }
  }]);

  return RemoteTrackPublicationSignaling;
}(TrackSignaling);

module.exports = RemoteTrackPublicationSignaling;
},{"./track":54}],53:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var DefaultRecordingSignaling = require('./recording');
var StateMachine = require('../statemachine');
var DefaultTimeout = require('../util/timeout');

var _require = require('../util/twilio-video-errors'),
    MediaConnectionError = _require.MediaConnectionError,
    MediaDTLSTransportFailedError = _require.MediaDTLSTransportFailedError,
    SignalingConnectionDisconnectedError = _require.SignalingConnectionDisconnectedError;

/*
RoomSignaling States
-----------------------

    +-----------+     +--------------+
    |           |     |              |
    | connected |---->| disconnected |
    |           |     |              |
    +-----------+     +--------------+
          |  ^               ^
          |  |               |
          |  |   +--------------+
          |  +---|              |
          |      | reconnecting |
          +----->|              |
                 +--------------+

*/

var states = {
  connected: ['reconnecting', 'disconnected'],
  reconnecting: ['connected', 'disconnected'],
  disconnected: []
};

/**
 * A {@link Room} implementation
 * @extends StateMachine
 * @property {RTCPeerConnectionState} connectionState
 * @property {?Participant.SID} dominantSpeakerSid
 * @property {ParticipantSignaling} localParticipant
 * @property {RTCIceConnectionState} iceConnectionState
 * @property {string} name
 * @property {Map<string, RemoteParticipantSignaling>} participants
 * @property {RecordingSignaling} recording
 * @property {Room.SID} sid
 * @property {string} state - "connected", "reconnecting", or "disconnected"
 * @property {string} signalingConnectionState - "connected",
 *   "reconnecting", or "disconnected"
 * @emits RoomSignaling#connectionStateChanged
 * @emits RoomSignaling#dominantSpeakerChanged
 * @emits RoomSignaling#iceConnectionStateChanged
 * @emits RoomSignaling#signalingConnectionStateChanged
 */

var RoomSignaling = function (_StateMachine) {
  _inherits(RoomSignaling, _StateMachine);

  /**
   * Construct a {@link RoomSignaling}.
   * @param {ParticipantSignaling} localParticipant
   * @param {Room.SID} sid
   * @param {string} name
   * @param {object} options
   */
  function RoomSignaling(localParticipant, sid, name, options) {
    _classCallCheck(this, RoomSignaling);

    options = Object.assign({
      RecordingSignaling: DefaultRecordingSignaling,
      Timeout: DefaultTimeout
    }, options);

    var _this = _possibleConstructorReturn(this, (RoomSignaling.__proto__ || Object.getPrototypeOf(RoomSignaling)).call(this, 'connected', states));

    var RecordingSignaling = options.RecordingSignaling;

    var sessionTimeout = new options.Timeout(function () {
      _this._disconnect(_this._reconnectingError);
    }, options.sessionTimeout, false);

    Object.defineProperties(_this, {
      _mediaConnectionIsReconnecting: {
        writable: true,
        value: false
      },
      _options: {
        value: options
      },
      _reconnectingError: {
        value: null,
        writable: true
      },
      _sessionTimeout: {
        value: sessionTimeout
      },
      dominantSpeakerSid: {
        enumerable: true,
        value: null,
        writable: true
      },
      localParticipant: {
        enumerable: true,
        value: localParticipant
      },
      name: {
        enumerable: true,
        value: name
      },
      participants: {
        enumerable: true,
        value: new Map()
      },
      recording: {
        enumerable: true,
        value: new RecordingSignaling()
      },
      sid: {
        enumerable: true,
        value: sid
      }
    });

    _this.on('connectionStateChanged', function () {
      if (_this.connectionState === 'failed' && !['disconnected', 'failed'].includes(_this.iceConnectionState)) {
        _this._disconnect(new MediaDTLSTransportFailedError());
      }
    });

    _this.on('iceConnectionStateChanged', function () {
      return maybeUpdateState(_this);
    });
    _this.on('signalingConnectionStateChanged', function () {
      return maybeUpdateState(_this);
    });

    // NOTE(mmalavalli): In case "iceConnectionState" is already failed, update
    // the RoomSignaling state. setTimeout() ensures that the state is updated
    // after RoomV2's constructor is fully executed, thereby making "signalingConnectionState"
    // available here.
    setTimeout(function () {
      return maybeUpdateState(_this);
    });
    return _this;
  }

  /**
   * Disconnect, possibly with an Error.
   * @private
   * @param {Error} [error]
   * @returns {boolean}
   */


  _createClass(RoomSignaling, [{
    key: '_disconnect',
    value: function _disconnect(error) {
      if (this.state !== 'disconnected') {
        this.preempt('disconnected', null, [error]);
        return true;
      }
      return false;
    }

    /**
     * Connect {@link RemoteParticipantSignaling} to the {@link RoomSignaling}.
     * @param {RemoteParticipantSignaling} participant
     * @returns {boolean}
     */

  }, {
    key: 'connectParticipant',
    value: function connectParticipant(participant) {
      var self = this;

      if (participant.state === 'disconnected') {
        return false;
      }

      if (this.participants.has(participant.sid)) {
        return false;
      }

      this.participants.set(participant.sid, participant);

      participant.on('stateChanged', function stateChanged(state) {
        if (state === 'disconnected') {
          participant.removeListener('stateChanged', stateChanged);
          self.participants.delete(participant.sid);
          self.emit('participantDisconnected', participant);
        }
      });

      this.emit('participantConnected', participant);

      return true;
    }

    /**
     * Disconnect.
     * @returns {boolean}
     */

  }, {
    key: 'disconnect',
    value: function disconnect() {
      return this._disconnect();
    }

    /**
     * Set (or unset) the Dominant Speaker.
     * @param {?Participant.SID} dominantSpeakerSid
     * @returns {void}
     */

  }, {
    key: 'setDominantSpeaker',
    value: function setDominantSpeaker(dominantSpeakerSid) {
      this.dominantSpeakerSid = dominantSpeakerSid;
      this.emit('dominantSpeakerChanged');
    }
  }]);

  return RoomSignaling;
}(StateMachine);

/**
 * @event RoomSignaling#event:connectionStateChanged
 */

/**
 * @event RoomSignaling#event:dominantSpeakerChanged
 */

/**
 * {@link RemoteParticipantSignaling} connected to the {@link RoomSignaling}.
 * @event RoomSignaling#event:participantConnected
 * @param {RemoteParticipantSignaling} participantSignaling
 */

/**
 * {@link RemoteParticipantSignaling} disconnected from the {@link RoomSignaling}.
 * @event RoomSignaling#event:participantDisconnected
 * @param {RemoteParticipantSignaling} participantSignaling
 */

/**
 * @event RoomSignaling#event:iceConnectionStateChanged
 */

/**
 * @event RoomSignaling#event:signalingConnectionStateChanged
 */

/**
 * Maybe update the {@link RoomSignaling} state.
 * @param {RoomSignaling} roomSignaling
 */


function maybeUpdateState(roomSignaling) {
  if (roomSignaling.state === 'disconnected' || roomSignaling.signalingConnectionState === 'disconnected') {
    roomSignaling._sessionTimeout.clear();
    return;
  }

  var newState = void 0;

  if (roomSignaling.signalingConnectionState === 'reconnecting') {
    newState = roomSignaling.signalingConnectionState;
  } else if (roomSignaling.iceConnectionState === 'failed') {
    roomSignaling._mediaConnectionIsReconnecting = true;
    newState = 'reconnecting';
  } else if (roomSignaling.iceConnectionState === 'new' || roomSignaling.iceConnectionState === 'checking') {
    newState = roomSignaling._mediaConnectionIsReconnecting ? 'reconnecting' : 'connected';
  } else {
    roomSignaling._mediaConnectionIsReconnecting = false;
    roomSignaling._reconnectingError = null;
    roomSignaling._sessionTimeout.clear();
    newState = 'connected';
  }

  if (newState === roomSignaling.state) {
    return;
  }

  if (newState === 'reconnecting') {
    roomSignaling._reconnectingError = roomSignaling.signalingConnectionState === 'reconnecting' ? new SignalingConnectionDisconnectedError() : new MediaConnectionError();
    roomSignaling._sessionTimeout.start();
    roomSignaling.preempt(newState, null, [roomSignaling._reconnectingError]);
  } else {
    roomSignaling.preempt(newState);
  }
}

module.exports = RoomSignaling;
},{"../statemachine":73,"../util/timeout":127,"../util/twilio-video-errors":128,"./recording":50}],54:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('events'),
    EventEmitter = _require.EventEmitter;

/**
 * A {@link Track} implementation
 * @extends EventEmitter
 * @property {Track.Kind} kind
 * @property {string} name
 */


var TrackSignaling = function (_EventEmitter) {
  _inherits(TrackSignaling, _EventEmitter);

  /**
   * Construct a {@link TrackSignaling}.
   * @param {string} name
   * @param {Track.Kind} kind
   * @param {boolean} isEnabled
   * @param {Track.Priority} priority
   */
  function TrackSignaling(name, kind, isEnabled, priority) {
    _classCallCheck(this, TrackSignaling);

    var _this = _possibleConstructorReturn(this, (TrackSignaling.__proto__ || Object.getPrototypeOf(TrackSignaling)).call(this));

    var sid = null;
    Object.defineProperties(_this, {
      _error: {
        value: null,
        writable: true
      },
      _isEnabled: {
        value: isEnabled,
        writable: true
      },
      _priority: {
        value: priority,
        writable: true
      },
      _trackTransceiver: {
        value: null,
        writable: true
      },
      _sid: {
        get: function get() {
          return sid;
        },
        set: function set(_sid) {
          if (sid === null) {
            sid = _sid;
          }
        }
      },
      kind: {
        enumerable: true,
        value: kind
      },
      name: {
        enumerable: true,
        value: name
      }
    });
    return _this;
  }

  /**
   * Non-null if publication or subscription failed.
   * @property {?Error} error
   */


  _createClass(TrackSignaling, [{
    key: 'disable',


    /**
     * Disable the {@link TrackSignaling} if it is not already disabled.
     * @return {this}
     */
    value: function disable() {
      return this.enable(false);
    }

    /**
     * Enable (or disable) the {@link TrackSignaling} if it is not already enabled
     * (or disabled).
     * @param {boolean} [enabled=true]
     * @return {this}
     */

  }, {
    key: 'enable',
    value: function enable(enabled) {
      enabled = typeof enabled === 'boolean' ? enabled : true;
      if (this.isEnabled !== enabled) {
        this._isEnabled = enabled;
        this.emit('updated');
      }
      return this;
    }

    /**
     * Set the {@link TrackTransceiver} on the {@link TrackSignaling}.
     * @param {TrackTransceiver} trackTransceiver
     * @returns {this}
     */

  }, {
    key: 'setTrackTransceiver',
    value: function setTrackTransceiver(trackTransceiver) {
      trackTransceiver = trackTransceiver || null;
      if (this.trackTransceiver !== trackTransceiver) {
        this._trackTransceiver = trackTransceiver;
        this.emit('updated');
      }
      return this;
    }

    /**
     * Set the SID on the {@link TrackSignaling} once.
     * @param {string} sid
     * @returns {this}
     */

  }, {
    key: 'setSid',
    value: function setSid(sid) {
      if (this.sid === null) {
        this._sid = sid;
        this.emit('updated');
      }
      return this;
    }
  }, {
    key: 'error',
    get: function get() {
      return this._error;
    }

    /**
     * Whether the {@link TrackSignaling} is enabled.
     * @property {boolean}
     */

  }, {
    key: 'isEnabled',
    get: function get() {
      return this._isEnabled;
    }

    /**
     * The {@link TrackSignaling}'s priority.
     * @property {Track.Priority}
     */

  }, {
    key: 'priority',
    get: function get() {
      return this._priority;
    }

    /**
     * The {@link TrackSignaling}'s {@link Track.SID}.
     * @property {Track.SID}
     */

  }, {
    key: 'sid',
    get: function get() {
      return this._sid;
    }

    /**
     * The {@link TrackSignaling}'s {@link TrackTransceiver}.
     * @property {TrackTransceiver}
     */

  }, {
    key: 'trackTransceiver',
    get: function get() {
      return this._trackTransceiver;
    }
  }]);

  return TrackSignaling;
}(EventEmitter);

/**
 * Emitted whenever the {@link TrackSignaling} is updated
 * @event TrackSignaling#updated
 */

module.exports = TrackSignaling;
},{"events":165}],55:[function(require,module,exports){
'use strict';

var CancelablePromise = require('../../util/cancelablepromise');
var DefaultPeerConnectionManager = require('./peerconnectionmanager');
var DefaultRoomV2 = require('./room');
var DefaultTransport = require('./twilioconnectiontransport');

var _require = require('../../util/twilio-video-errors'),
    SignalingConnectionDisconnectedError = _require.SignalingConnectionDisconnectedError,
    SignalingIncomingMessageInvalidError = _require.SignalingIncomingMessageInvalidError;

var _require2 = require('../../util'),
    flatMap = _require2.flatMap,
    createRoomConnectEventPayload = _require2.createRoomConnectEventPayload;

function createCancelableRoomSignalingPromise(token, wsServer, localParticipant, encodingParameters, preferredCodecs, options) {
  options = Object.assign({
    PeerConnectionManager: DefaultPeerConnectionManager,
    RoomV2: DefaultRoomV2,
    Transport: DefaultTransport
  }, options);

  var _options = options,
      PeerConnectionManager = _options.PeerConnectionManager,
      RoomV2 = _options.RoomV2,
      Transport = _options.Transport,
      iceServers = _options.iceServers,
      log = _options.log;

  var peerConnectionManager = new PeerConnectionManager(encodingParameters, preferredCodecs, options);
  var trackSenders = flatMap(localParticipant.tracks, function (trackV2) {
    return [trackV2.trackTransceiver];
  });
  peerConnectionManager.setTrackSenders(trackSenders);

  var cancellationError = new Error('Canceled');

  var transport = void 0;

  var cancelablePromise = new CancelablePromise(function (resolve, reject, isCanceled) {
    var onIced = function onIced(iceServers) {
      if (isCanceled()) {
        reject(cancellationError);
        return Promise.reject(cancellationError);
      }
      log.debug('Got ICE servers:', iceServers);
      options.iceServers = iceServers;
      peerConnectionManager.setConfiguration(options);

      return peerConnectionManager.createAndOffer().then(function () {
        if (isCanceled()) {
          reject(cancellationError);
          throw cancellationError;
        }
        log.debug('createAndOffer() succeeded.');
        // NOTE(mmalavalli): PeerConnectionManager#createAndOffer() queues the
        // initial offer in the event queue for the 'description' event. So,
        // we are dequeueing to prevent the spurious 'update' message sent by
        // the client after connecting to a room.
        peerConnectionManager.dequeue('description');
      }).catch(function (error) {
        log.error('createAndOffer() failed:', error);
        reject(error);
        throw error;
      });
    };

    var _options2 = options,
        InsightsPublisher = _options2.InsightsPublisher,
        NullInsightsPublisher = _options2.NullInsightsPublisher,
        automaticSubscription = _options2.automaticSubscription,
        bandwidthProfile = _options2.bandwidthProfile,
        dominantSpeaker = _options2.dominantSpeaker,
        environment = _options2.environment,
        eventObserver = _options2.eventObserver,
        loggerName = _options2.loggerName,
        logLevel = _options2.logLevel,
        name = _options2.name,
        networkMonitor = _options2.networkMonitor,
        networkQuality = _options2.networkQuality,
        insights = _options2.insights,
        realm = _options2.realm,
        sdpSemantics = _options2.sdpSemantics,
        wsServerInsights = _options2.wsServerInsights;


    var transportOptions = Object.assign({
      automaticSubscription: automaticSubscription,
      dominantSpeaker: dominantSpeaker,
      environment: environment,
      eventObserver: eventObserver,
      loggerName: loggerName,
      logLevel: logLevel,
      networkMonitor: networkMonitor,
      networkQuality: networkQuality,
      iceServers: iceServers,
      insights: insights,
      onIced: onIced,
      realm: realm,
      sdpSemantics: sdpSemantics
    }, typeof wsServerInsights === 'string' ? {
      wsServerInsights: wsServerInsights
    } : {}, InsightsPublisher ? {
      InsightsPublisher: InsightsPublisher
    } : {}, NullInsightsPublisher ? {
      NullInsightsPublisher: NullInsightsPublisher
    } : {}, bandwidthProfile ? {
      bandwidthProfile: bandwidthProfile
    } : {});

    transport = new Transport(name, token, localParticipant, peerConnectionManager, wsServer, transportOptions);

    var connectEventPayload = createRoomConnectEventPayload(options);
    eventObserver.emit('event', connectEventPayload);

    transport.once('connected', function (initialState) {
      log.debug('Transport connected:', initialState);
      if (isCanceled()) {
        reject(cancellationError);
        return;
      }
      var localParticipantState = initialState.participant;

      if (!localParticipantState) {
        reject(new SignalingIncomingMessageInvalidError());
        return;
      }

      var signalingRegion = initialState.options.signaling_region;

      localParticipant.setSignalingRegion(signalingRegion);
      resolve(new RoomV2(localParticipant, initialState, transport, peerConnectionManager, options));
    });

    transport.once('stateChanged', function (state, error) {
      if (state === 'disconnected') {
        transport = null;
        reject(error || new SignalingConnectionDisconnectedError());
      } else {
        log.debug('Transport state changed:', state);
      }
    });
  }, function () {
    if (transport) {
      transport.disconnect();
      transport = null;
    }
  });

  cancelablePromise.catch(function () {
    if (transport) {
      transport.disconnect();
      transport = null;
    }
    peerConnectionManager.close();
  });

  return cancelablePromise;
}

module.exports = createCancelableRoomSignalingPromise;
},{"../../util":114,"../../util/cancelablepromise":107,"../../util/twilio-video-errors":128,"./peerconnectionmanager":65,"./room":69,"./twilioconnectiontransport":72}],56:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('events'),
    EventEmitter = _require.EventEmitter;

/**
 * @property {?Track.SID} loudestParticipantSid
 * @emits DominantSpeakerSignaling#updated
 */


var DominantSpeakerSignaling = function (_EventEmitter) {
  _inherits(DominantSpeakerSignaling, _EventEmitter);

  /**
   * Construct an {@link DominantSpeakerSignaling}.
   * @param {MediaSignalingTransport} mediaSignalingTransport
   */
  function DominantSpeakerSignaling(mediaSignalingTransport) {
    _classCallCheck(this, DominantSpeakerSignaling);

    var _this = _possibleConstructorReturn(this, (DominantSpeakerSignaling.__proto__ || Object.getPrototypeOf(DominantSpeakerSignaling)).call(this));

    Object.defineProperties(_this, {
      _loudestParticipantSid: {
        value: null,
        writable: true
      }
    });

    mediaSignalingTransport.on('message', function (message) {
      switch (message.type) {
        case 'active_speaker':
          _this._setLoudestParticipantSid(message.participant);
          break;
        default:
          break;
      }
    });
    return _this;
  }

  /**
   * Get the loudest {@link Track.SID}, if known.
   * @returns {?Track.SID}
   */


  _createClass(DominantSpeakerSignaling, [{
    key: '_setLoudestParticipantSid',


    /**
     * @private
     * @param {Track.SID} loudestParticipantSid
     * @returns {void}
     */
    value: function _setLoudestParticipantSid(loudestParticipantSid) {
      if (this.loudestParticipantSid === loudestParticipantSid) {
        return;
      }
      this._loudestParticipantSid = loudestParticipantSid;
      this.emit('updated');
    }
  }, {
    key: 'loudestParticipantSid',
    get: function get() {
      return this._loudestParticipantSid;
    }
  }]);

  return DominantSpeakerSignaling;
}(EventEmitter);

/**
 * @event DominantSpeakerSignaling#updated
 */

module.exports = DominantSpeakerSignaling;
},{"events":165}],57:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Filter = require('../../util/filter');

/**
 * An {@link IceBox} stores trickled ICE candidates. Candidates added to the
 * {@link IceBox} via {@link IceBox#update} are compared against previously
 * trickled candidates and only new candidates will be returned (assuming they
 * match the current ICE username fragment set by {@link IceBox#setUfrag}).
 * @property {?string} ufrag
 */

var IceBox = function () {
  /**
   * Construct an {@link IceBox}.
   */
  function IceBox() {
    _classCallCheck(this, IceBox);

    Object.defineProperties(this, {
      _filter: {
        value: new Filter({
          getKey: function getKey(iceState) {
            return iceState.ufrag;
          },
          isLessThanOrEqualTo: function isLessThanOrEqualTo(a, b) {
            return a.revision <= b.revision;
          }
        })
      },
      _ufrag: {
        writable: true,
        value: null
      },
      ufrag: {
        enumerable: true,
        get: function get() {
          return this._ufrag;
        }
      }
    });
  }

  /**
   * Set the ICE username fragment on the {@link IceBox}. This method returns any
   * ICE candidates associated with the username fragment.
   * @param {string} ufrag
   * @returns {Array<RTCIceCandidateInit>}
   */


  _createClass(IceBox, [{
    key: 'setUfrag',
    value: function setUfrag(ufrag) {
      this._ufrag = ufrag;
      var ice = this._filter.toMap().get(ufrag);
      return ice ? ice.candidates : [];
    }

    /**
     * Update the {@link IceBox}. This method returns any new ICE candidates
     * associated with the current username fragment.
     * @param {object} iceState
     * @returns {Array<RTCIceCandidateInit>}
     */

  }, {
    key: 'update',
    value: function update(iceState) {
      // NOTE(mroberts): The Server sometimes does not set the candidates property.
      iceState.candidates = iceState.candidates || [];
      var oldIceState = this._filter.toMap().get(iceState.ufrag);
      var oldCandidates = oldIceState ? oldIceState.candidates : [];
      return this._filter.update(iceState) && this._ufrag === iceState.ufrag ? iceState.candidates.slice(oldCandidates.length) : [];
    }
  }]);

  return IceBox;
}();

module.exports = IceBox;
},{"../../util/filter":113}],58:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _require = require('../../util/constants'),
    ICE_ACTIVITY_CHECK_PERIOD_MS = _require.ICE_ACTIVITY_CHECK_PERIOD_MS,
    ICE_INACTIVITY_THRESHOLD_MS = _require.ICE_INACTIVITY_THRESHOLD_MS;

/**
 * Monitors a {@link RTCPeerConnection}'s stats and notifies
 * caller when inactivity is detected.
 */


var IceConnectionMonitor = function () {
  /**
   * Construct an {@link IceConnectionMonitor}.
   * @param {RTCPeerConnection} peerConnection
   * @param {object} [options]
   */
  function IceConnectionMonitor(peerConnection, options) {
    _classCallCheck(this, IceConnectionMonitor);

    options = Object.assign({
      activityCheckPeriodMs: ICE_ACTIVITY_CHECK_PERIOD_MS,
      inactivityThresholdMs: ICE_INACTIVITY_THRESHOLD_MS
    }, options);

    Object.defineProperties(this, {
      _activityCheckPeriodMs: {
        value: options.activityCheckPeriodMs
      },
      _inactivityThresholdMs: {
        value: options.inactivityThresholdMs
      },
      _lastActivity: {
        value: null,
        writable: true
      },
      _peerConnection: {
        value: peerConnection
      },
      _timer: {
        value: null,
        writable: true
      },
      _onIceConnectionStateChanged: {
        value: null,
        writable: true
      }
    });
  }

  _createClass(IceConnectionMonitor, [{
    key: '_getActivePairStat',
    value: function _getActivePairStat(stats) {
      var statsArray = Array.from(stats.values());
      var hasInBoundTracks = statsArray.find(function (stat) {
        return stat.type === 'inbound-rtp';
      });
      if (!hasInBoundTracks) {
        // NOTE(mpatwardhan): when there are no tracks shared on a peerConnection
        // we may see inactivity on bytesReceived - but that is not real inactivity,
        // ignore it.
        return null;
      }

      var activePairStats = statsArray.find(function (stat) {
        return stat.type === 'candidate-pair' && stat.nominated;
      });
      // NOTE(mpatwardhan): sometimes (JSDK-2667) after getting disconnected while switching network
      // we may not find active pair. Treat this as 0 bytesReceived so that we count it towards inactivity.
      return activePairStats || {
        bytesReceived: 0,
        timestamp: Math.round(new Date().getTime())
      };
    }

    /**
     * Get ICE connection stats, and extract received and send bytes.
     * @returns Promise<?RTCIceCandidatePairStats>
     */

  }, {
    key: '_getIceConnectionStats',
    value: function _getIceConnectionStats() {
      var _this = this;

      return this._peerConnection.getStats().then(function (stats) {
        return _this._getActivePairStat(stats);
      }).catch(function () {
        return null;
      });
    }

    /**
     * schedules/un-schedules inactivity callback.
     */

  }, {
    key: '_scheduleInactivityCallback',
    value: function _scheduleInactivityCallback(callback) {
      var _this2 = this;

      if (callback && this._onIceConnectionStateChanged === null) {
        // schedule callback
        this._onIceConnectionStateChanged = function () {
          if (_this2._peerConnection.iceConnectionState === 'disconnected') {
            // eslint-disable-next-line callback-return
            callback();
          }
        };
        this._peerConnection.addEventListener('iceconnectionstatechange', this._onIceConnectionStateChanged);
      } else if (!callback && this._onIceConnectionStateChanged) {
        // unschedule callback
        this._peerConnection.removeEventListener('iceconnectionstatechange', this._onIceConnectionStateChanged);
        this._onIceConnectionStateChanged = null;
      }
    }

    /**
     * Start monitoring the ICE connection.
     * Monitors bytes received on active ice connection pair,
     * invokes onIceConnectionInactive when inactivity is detected.
     * @param {function} onIceConnectionInactive
     */

  }, {
    key: 'start',
    value: function start(onIceConnectionInactive) {
      var _this3 = this;

      this.stop();

      this._timer = setInterval(function () {
        _this3._getIceConnectionStats().then(function (iceStats) {
          if (!iceStats) {
            return;
          }

          if (!_this3._lastActivity || _this3._lastActivity.bytesReceived !== iceStats.bytesReceived) {
            _this3._lastActivity = iceStats;
            // detected activity, cancel scheduled callback if any.
            _this3._scheduleInactivityCallback(null);
          }

          if (iceStats.timestamp - _this3._lastActivity.timestamp >= _this3._inactivityThresholdMs) {
            // detected inactivity.
            if (_this3._peerConnection.iceConnectionState === 'disconnected') {
              onIceConnectionInactive();
            } else if (_this3._onIceConnectionStateChanged === null) {
              _this3._scheduleInactivityCallback(onIceConnectionInactive);
            }
          }
        });
      }, this._activityCheckPeriodMs);
    }

    /**
     * Stop monitoring the ICE connection state.
     * @returns {void}
     */

  }, {
    key: 'stop',
    value: function stop() {
      this._scheduleInactivityCallback(null);
      if (this._timer !== null) {
        clearInterval(this._timer);
        this._timer = null;
        this._lastActivity = null;
      }
    }
  }]);

  return IceConnectionMonitor;
}();

module.exports = IceConnectionMonitor;
},{"../../util/constants":108}],59:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var defaultCreateCancelableRoomSignalingPromise = require('./cancelableroomsignalingpromise');
var LocalParticipantV2 = require('./localparticipant');
var Signaling = require('../');

/**
 * {@link SignalingV2} implements version 2 of our signaling protocol.
 * @extends Signaling
 */

var SignalingV2 = function (_Signaling) {
  _inherits(SignalingV2, _Signaling);

  /**
   * Construct {@link SignalingV2}.
   * @param {string} wsServer
   * @param {?object} [options={}]
   */
  function SignalingV2(wsServer, options) {
    _classCallCheck(this, SignalingV2);

    /* eslint new-cap:0 */
    options = Object.assign({
      createCancelableRoomSignalingPromise: defaultCreateCancelableRoomSignalingPromise
    }, options);

    var _this = _possibleConstructorReturn(this, (SignalingV2.__proto__ || Object.getPrototypeOf(SignalingV2)).call(this));

    Object.defineProperties(_this, {
      _createCancelableRoomSignalingPromise: {
        value: options.createCancelableRoomSignalingPromise
      },
      _options: {
        value: options
      },
      _wsServer: {
        value: wsServer
      }
    });
    return _this;
  }

  /**
   * @private
   */


  _createClass(SignalingV2, [{
    key: '_connect',
    value: function _connect(localParticipant, token, encodingParameters, preferredCodecs, options) {
      options = Object.assign({}, this._options, options);
      return this._createCancelableRoomSignalingPromise.bind(null, token, this._wsServer, localParticipant, encodingParameters, preferredCodecs, options);
    }
  }, {
    key: 'createLocalParticipantSignaling',
    value: function createLocalParticipantSignaling(encodingParameters, networkQualityConfiguration) {
      return new LocalParticipantV2(encodingParameters, networkQualityConfiguration);
    }
  }]);

  return SignalingV2;
}(Signaling);

module.exports = SignalingV2;
},{"../":46,"./cancelableroomsignalingpromise":55,"./localparticipant":60}],60:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var LocalParticipantSignaling = require('../localparticipant');
var LocalTrackPublicationV2 = require('./localtrackpublication');

var _require = require('../../util'),
    isDeepEqual = _require.isDeepEqual;

/**
 * @extends ParticipantSignaling
 * @property {BandwidthProfileOptions} bandwidthProfile
 * @property {NetworkQualityConfigurationImpl} networkQualityConfiguration
 * @property {number} revision
 * @emits LocalParticipantV2#updated
 */


var LocalParticipantV2 = function (_LocalParticipantSign) {
  _inherits(LocalParticipantV2, _LocalParticipantSign);

  /**
   * Construct a {@link LocalParticipantV2}.
   * @param {EncodingParametersImpl} encodingParameters
   * @param {NetworkQualityConfigurationImpl} networkQualityConfiguration
   * @param {object} [options]
   */
  function LocalParticipantV2(encodingParameters, networkQualityConfiguration, options) {
    _classCallCheck(this, LocalParticipantV2);

    options = Object.assign({
      LocalTrackPublicationV2: LocalTrackPublicationV2
    }, options);

    var _this = _possibleConstructorReturn(this, (LocalParticipantV2.__proto__ || Object.getPrototypeOf(LocalParticipantV2)).call(this));

    Object.defineProperties(_this, {
      _bandwidthProfile: {
        value: null,
        writable: true
      },
      _bandwidthProfileRevision: {
        value: 0,
        writable: true
      },
      _encodingParameters: {
        value: encodingParameters
      },
      _removeListeners: {
        value: new Map()
      },
      _LocalTrackPublicationV2: {
        value: options.LocalTrackPublicationV2
      },
      _publishedRevision: {
        writable: true,
        value: 0
      },
      _revision: {
        writable: true,
        value: 1
      },
      _signalingRegion: {
        value: null,
        writable: true
      },
      bandwidthProfile: {
        enumerable: true,
        get: function get() {
          return this._bandwidthProfile;
        }
      },
      bandwidthProfileRevision: {
        enumerable: true,
        get: function get() {
          return this._bandwidthProfileRevision;
        }
      },
      networkQualityConfiguration: {
        enumerable: true,
        value: networkQualityConfiguration
      },
      revision: {
        enumerable: true,
        get: function get() {
          return this._revision;
        }
      },
      signalingRegion: {
        enumerable: true,
        get: function get() {
          return this._signalingRegion;
        }
      }
    });
    return _this;
  }

  /**
   * Set the signalingRegion.
   * @param {string} signalingRegion.
   */


  _createClass(LocalParticipantV2, [{
    key: 'setSignalingRegion',
    value: function setSignalingRegion(signalingRegion) {
      if (!this._signalingRegion) {
        this._signalingRegion = signalingRegion;
      }
    }

    /**
     * Update the {@link BandwidthProfileOptions}.
     * @param {BandwidthProfileOptions} bandwidthProfile
     */

  }, {
    key: 'setBandwidthProfile',
    value: function setBandwidthProfile(bandwidthProfile) {
      if (!isDeepEqual(this._bandwidthProfile, bandwidthProfile)) {
        // NOTE(mmalavalli): Object.assign() copies the values of only
        // the top level properties. In order to deep copy the object, we
        // stringify and parse the object.
        this._bandwidthProfile = JSON.parse(JSON.stringify(bandwidthProfile));
        this._bandwidthProfileRevision++;
        this.didUpdate();
      }
    }

    /**
     * Set the {@link EncodingParameters}.
     * @param {?EncodingParameters} encodingParameters
     * @returns {this}
     */

  }, {
    key: 'setParameters',
    value: function setParameters(encodingParameters) {
      this._encodingParameters.update(encodingParameters);
      return this;
    }

    /**
     * Update the {@link LocalParticipantV2} with the new state.
     * @param {Published} published
     * @returns {this}
     */

  }, {
    key: 'update',
    value: function update(published) {
      if (this._publishedRevision >= published.revision) {
        return this;
      }

      this._publishedRevision = published.revision;

      published.tracks.forEach(function (publicationState) {
        var localTrackPublicationV2 = this.tracks.get(publicationState.id);
        if (localTrackPublicationV2) {
          localTrackPublicationV2.update(publicationState);
        }
      }, this);

      return this;
    }

    /**
     * @protected
     * @param {DataTrackSender|MediaTrackSender} trackSender
     * @param {string} name
     * @param {Track.Priority} priority
     * @returns {LocalTrackPublicationV2}
     */

  }, {
    key: '_createLocalTrackPublicationSignaling',
    value: function _createLocalTrackPublicationSignaling(trackSender, name, priority) {
      return new this._LocalTrackPublicationV2(trackSender, name, priority);
    }

    /**
     * Add a {@link LocalTrackPublicationV2} for the given {@link DataTrackSender}
     * or {@link MediaTrackSender} to the {@link LocalParticipantV2}.
     * @param {DataTrackSender|MediaTrackSender} trackSender
     * @param {string} name
     * @param {Track.Priority} priority
     * @returns {this}
     */

  }, {
    key: 'addTrack',
    value: function addTrack(trackSender, name, priority) {
      var _this2 = this;

      _get(LocalParticipantV2.prototype.__proto__ || Object.getPrototypeOf(LocalParticipantV2.prototype), 'addTrack', this).call(this, trackSender, name, priority);
      var publication = this.getPublication(trackSender);

      var isEnabled = publication.isEnabled,
          updatedPriority = publication.updatedPriority;


      var updated = function updated() {
        // NOTE(mmalavalli): The LocalParticipantV2's state is only published if
        // the "updated" event is emitted due to LocalTrackPublicationV2's
        // .isEnabled or .updatedPriority being changed. We do not publish if it is fired due to the
        // LocalTrackPublicationV2's .sid being set.
        if (isEnabled !== publication.isEnabled || updatedPriority !== publication.updatedPriority) {
          _this2.didUpdate();
          isEnabled = publication.isEnabled;
          updatedPriority = publication.updatedPriority;
        }
      };

      publication.on('updated', updated);

      this._removeListener(publication);
      this._removeListeners.set(publication, function () {
        return publication.removeListener('updated', updated);
      });

      this.didUpdate();

      return this;
    }

    /**
     * @private
     * @param {LocalTrackPublicationV2} publication
     * @returns {void}
     */

  }, {
    key: '_removeListener',
    value: function _removeListener(publication) {
      var removeListener = this._removeListeners.get(publication);
      if (removeListener) {
        removeListener();
      }
    }

    /**
     * Get the current state of the {@link LocalParticipantV2}.
     * @returns {object}
     */

  }, {
    key: 'getState',
    value: function getState() {
      return {
        revision: this.revision,
        tracks: Array.from(this.tracks.values()).map(function (track) {
          return track.getState();
        })
      };
    }

    /**
     * Increment the revision for the {@link LocalParticipantV2}.
     * @private
     * @returns {void}
     */

  }, {
    key: 'didUpdate',
    value: function didUpdate() {
      this._revision++;
      this.emit('updated');
    }

    /**
     * Remove the {@link LocalTrackPublicationV2} for the given {@link DataTrackSender}
     * or {@link MediaTrackSender} from the {@link LocalParticipantV2}.
     * @param {DataTrackSender|MediaTrackSender} trackSender
     * @returns {?LocalTrackPublicationV2}
     */

  }, {
    key: 'removeTrack',
    value: function removeTrack(trackSender) {
      var publication = _get(LocalParticipantV2.prototype.__proto__ || Object.getPrototypeOf(LocalParticipantV2.prototype), 'removeTrack', this).call(this, trackSender);
      if (publication) {
        trackSender.removeClone(publication.trackTransceiver);
        this._removeListener(publication);
        this.didUpdate();
      }
      return publication;
    }

    /**
     * Updates the verbosity of network quality information.
     * @param {NetworkQualityConfiguration} networkQualityConfiguration
     * @returns {void}
     */

  }, {
    key: 'setNetworkQualityConfiguration',
    value: function setNetworkQualityConfiguration(networkQualityConfiguration) {
      this.networkQualityConfiguration.update(networkQualityConfiguration);
    }
  }]);

  return LocalParticipantV2;
}(LocalParticipantSignaling);

/**
 * @interface Published
 * @property {number} revision
 * @property {Array<PublishedTrack>} tracks
 */

/**
 * @typedef {CreatedTrack|ReadyTrack|FailedTrack} PublishedTrack
 */

/**
 * @interface CreatedTrack
 * @property {Track.ID} id
 * @property {string} state - "created"
 */

/**
 * @interface ReadyTrack
 * @property {Track.ID} id
 * @property {Track.SID} sid
 * @property {string} state - "ready"
 */

/**
 * @interface FailedTrack
 * @property {Track.ID} id
 * @property {TrackError} error
 * @property {string} state - "failed"
 */

/**
 * @interface TrackError
 * @property {number} code
 * @property {string} message
 */

/**
 * @event LocalParticipantV2#updated
 */

module.exports = LocalParticipantV2;
},{"../../util":114,"../localparticipant":47,"./localtrackpublication":61}],61:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var LocalTrackPublicationSignaling = require('../localtrackpublication');
var createTwilioError = require('../../util/twilio-video-errors').createTwilioError;

/**
 * @extends LocalTrackPublicationSignaling
 */

var LocalTrackPublicationV2 = function (_LocalTrackPublicatio) {
  _inherits(LocalTrackPublicationV2, _LocalTrackPublicatio);

  /**
   * Construct a {@link LocalTrackPublicationV2}.
   * @param {DataTrackSender|MediaTrackSender} trackSender
   * @param {string} name
   * @param {Track.Priority} priority
   */
  function LocalTrackPublicationV2(trackSender, name, priority) {
    _classCallCheck(this, LocalTrackPublicationV2);

    return _possibleConstructorReturn(this, (LocalTrackPublicationV2.__proto__ || Object.getPrototypeOf(LocalTrackPublicationV2)).call(this, trackSender, name, priority));
  }

  /**
   * Get the {@link LocalTrackPublicationV2#Representation} of a given {@link TrackSignaling}.
   * @returns {LocalTrackPublicationV2#Representation} - without the SID
   */


  _createClass(LocalTrackPublicationV2, [{
    key: 'getState',
    value: function getState() {
      return {
        enabled: this.isEnabled,
        id: this.id,
        kind: this.kind,
        name: this.name,
        priority: this.updatedPriority
      };
    }

    /**
     * Compare the {@link LocalTrackPublicationV2} to a {@link LocalTrackPublicationV2#Representation} of itself
     * and perform any updates necessary.
     * @param {PublishedTrack} track
     * @returns {this}
     * @fires TrackSignaling#updated
     */

  }, {
    key: 'update',
    value: function update(track) {
      switch (track.state) {
        case 'ready':
          this.setSid(track.sid);
          break;
        case 'failed':
          {
            var error = track.error;
            this.publishFailed(createTwilioError(error.code, error.message));
            break;
          }
        default:
          // 'created'
          break;
      }
      return this;
    }
  }]);

  return LocalTrackPublicationV2;
}(LocalTrackPublicationSignaling);

/**
 * The Room Signaling Protocol (RSP) representation of a {@link LocalTrackPublicationV2}.
 * @typedef {object} LocalTrackPublicationV2#Representation
 * @property {boolean} enabled
 * @property {Track.ID} id
 * @property {Track.Kind} kind
 * @property {string} name
 * @priority {Track.Priority} priority
 * @property {Track.SID} sid
 */

module.exports = LocalTrackPublicationV2;
},{"../../util/twilio-video-errors":128,"../localtrackpublication":48}],62:[function(require,module,exports){
/* eslint callback-return:0 */
'use strict';

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EventEmitter = require('events');

var PeerConnectionReportFactory = require('../../stats/peerconnectionreportfactory');

/**
 * @emits NetworkQualityMonitor#updated
 */

var NetworkQualityMonitor = function (_EventEmitter) {
  _inherits(NetworkQualityMonitor, _EventEmitter);

  /**
   * Construct a {@link NetworkQualityMonitor}.
   * @param {PeerConnectionManager} manager
   * @param {NetworkQualitySignaling} signaling
   */
  function NetworkQualityMonitor(manager, signaling) {
    _classCallCheck(this, NetworkQualityMonitor);

    var _this = _possibleConstructorReturn(this, (NetworkQualityMonitor.__proto__ || Object.getPrototypeOf(NetworkQualityMonitor)).call(this));

    Object.defineProperties(_this, {
      _factories: {
        value: new WeakMap()
      },
      _manager: {
        value: manager
      },
      _signaling: {
        value: signaling
      }
    });
    signaling.on('updated', function () {
      return _this.emit('updated');
    });
    return _this;
  }

  /**
   * Get the current {@link NetworkQualityLevel}, if any.
   * @returns {?NetworkQualityLevel} level - initially null
   */


  _createClass(NetworkQualityMonitor, [{
    key: 'start',


    /**
     * Start monitoring.
     * @returns {void}
     */
    value: function start() {
      var _this2 = this;

      this.stop();
      var timeout = setTimeout(function () {
        if (_this2._timeout !== timeout) {
          return;
        }
        next(_this2).then(function (reports) {
          if (_this2._timeout !== timeout) {
            return;
          }
          if (reports.length) {
            var _reports = _slicedToArray(reports, 1),
                report = _reports[0];

            _this2._signaling.put(report);
          }
          _this2.start();
        });
      }, 200);
      this._timeout = timeout;
    }

    /**
     * Stop monitoring.
     * @returns {void}
     */

  }, {
    key: 'stop',
    value: function stop() {
      clearTimeout(this._timeout);
      this._timeout = null;
    }
  }, {
    key: 'level',
    get: function get() {
      return this._signaling.level;
    }

    /**
     * Get the current {@link NetworkQualityLevels}, if any.
     * @returns {?NetworkQualityLevels} levels - initially null
     */

  }, {
    key: 'levels',
    get: function get() {
      return this._signaling.levels;
    }

    /**
     * Get the current {@link NetworkQualityLevels} of remote participants, if any.
     * @returns {Map<String, NetworkQualityLevels>} remoteLevels
     */

  }, {
    key: 'remoteLevels',
    get: function get() {
      return this._signaling.remoteLevels;
    }
  }]);

  return NetworkQualityMonitor;
}(EventEmitter);

/**
 * @param {NetworkQualityMonitor}
 * @returns {Promise<NetworkQualityInputs>}
 */


function next(monitor) {
  var pcv2s = monitor._manager._peerConnections ? Array.from(monitor._manager._peerConnections.values()) : [];

  var pcs = pcv2s.map(function (pcv2) {
    return pcv2._peerConnection;
  }).filter(function (pc) {
    return pc.signalingState !== 'closed';
  });

  var factories = pcs.map(function (pc) {
    if (monitor._factories.has(pc)) {
      return monitor._factories.get(pc);
    }
    var factory = new PeerConnectionReportFactory(pc);
    monitor._factories.set(pc, factory);
    return factory;
  });

  var reportsOrNullPromises = factories.map(function (factory) {
    return factory.next().catch(function () {
      return null;
    });
  });

  return Promise.all(reportsOrNullPromises).then(function (reportsOrNull) {
    return reportsOrNull.filter(function (reportOrNull) {
      return reportOrNull;
    }).map(function (report) {
      return report.summarize();
    });
  });
}

/**
 * The {@link NetworkQualityLevel} changed.
 * @event NetworkQualityMonitor#updated
 */

module.exports = NetworkQualityMonitor;
},{"../../stats/peerconnectionreportfactory":91,"events":165}],63:[function(require,module,exports){
'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('events'),
    EventEmitter = _require.EventEmitter;

var AsyncVar = require('../../util/asyncvar');

/**
 * @interface MediaSignalingTransport
 * @property {function(object): boolean} send
 * @emits MediaSignalingTransport#message
 */

/**
 * The {@link MediaSignalingTransport} received a message.
 * @event MediaSignalingTransport#message
 * @param {object} message
 */

/**
 * @interface LatencyStats
 * @property {number} jitter
 * @property {number} rtt
 * @property {number} level
 */

/**
 * @interface FractionLostStats
 * @property {number} fractionLost
 * @property {number} level
 */

/**
 * @interface BandwidthStats
 * @property {number} actual
 * @property {number} available
 * @property {number} level
 */

/**
 * @interface SendOrRecvStats
 * @property {BandwidthStats} bandwidth
 * @property {FractionLostStats} fractionLost
 * @property {LatencyStats} latency
 */

/**
 * @interface MediaLevels
 * @property {number} send
 * @property {SendOrRecvStats} sendStats
 * @property {number} recv
 * @property {SendOrRecvStats} recvStats
 */

/**
 * @interface NetworkQualityLevels
 * @property {number} level
 * @property {MediaLevels} audio
 * @property {MediaLevels} video
 */

/**
 * @typedef {PeerConnectionSummary} NetworkQualityInputs
 */

/**
 * @classdesc The {@link NetworkQualitySignaling} class allows submitting
 *   {@link NetworkQualityInputs} for computing {@link NetworkQualityLevel}. It
 *   does so by sending and receiving messages over a
 *   {@link MediaSignalingTransport}. The exact transport used depends on the
 *   topology of the {@link Room} that {@link NetworkQualitySignaling} is being
 *   used within: for P2P Rooms, we re-use the {@link TransportV2}; and for
 *   Group Rooms, we use a {@link DataTransport}.
 * @emits NetworkQualitySignaling#updated
 */

var NetworkQualitySignaling = function (_EventEmitter) {
  _inherits(NetworkQualitySignaling, _EventEmitter);

  /**
   * Construct a {@link NetworkQualitySignaling}.
   * @param {MediaSignalingTransport} mediaSignalingTransport
   * @param {NetworkQualityConfigurationImpl} networkQualityConfiguration
   */
  function NetworkQualitySignaling(mediaSignalingTransport, networkQualityConfiguration) {
    _classCallCheck(this, NetworkQualitySignaling);

    var _this = _possibleConstructorReturn(this, (NetworkQualitySignaling.__proto__ || Object.getPrototypeOf(NetworkQualitySignaling)).call(this));

    Object.defineProperties(_this, {
      _level: {
        value: null,
        writable: true
      },
      _levels: {
        value: null,
        writable: true
      },
      _remoteLevels: {
        value: new Map(),
        writable: true
      },
      _mediaSignalingTransport: {
        value: mediaSignalingTransport
      },
      _networkQualityInputs: {
        value: new AsyncVar()
      },
      _networkQualityReportLevels: {
        get: function get() {
          return {
            reportLevel: networkQualityConfiguration.local,
            remoteReportLevel: networkQualityConfiguration.remote
          };
        }
      }
    });

    mediaSignalingTransport.on('message', function (message) {
      switch (message.type) {
        case 'network_quality':
          _this._handleNetworkQualityMessage(message);
          break;
        default:
          break;
      }
    });

    _this._sendNetworkQualityInputs();
    return _this;
  }

  /**
   * Get the current {@link NetworkQualityLevel}, if any.
   * @returns {?NetworkQualityLevel} level - initially null
   */


  _createClass(NetworkQualitySignaling, [{
    key: '_handleNetworkQualityMessage',


    /**
     * Check to see if the {@link NetworkQualityLevel} is new, and raise an
     * event if necessary.
     * @private
     * @param {object} message
     * @returns {void}
     */
    value: function _handleNetworkQualityMessage(message) {
      var _this2 = this;

      var updated = false;
      var level = null;
      var local = message ? message.local : null;
      if (typeof local === 'number') {
        // NOTE(mroberts): In prod, we plan to only send the level.
        level = local;
        this._levels = null;
      } else if ((typeof local === 'undefined' ? 'undefined' : _typeof(local)) === 'object' && local) {
        // NOTE(mroberts): In dev, we plan to send the decomposed levels. An early
        // VMS version does not compute `level` for us, so we fallback to taking
        // the minimum ourselves.
        this._levels = local;
        level = typeof local.level === 'number' ? local.level : Math.min(local.audio.send, local.audio.recv, local.video.send, local.video.recv);
      }
      if (level !== null && this.level !== level) {
        this._level = level;
        updated = true;
      }
      this._remoteLevels = message && message.remotes ? message.remotes.reduce(function (levels, obj) {
        var oldObj = _this2._remoteLevels.get(obj.sid) || {};
        if (oldObj.level !== obj.level) {
          updated = true;
        }
        return levels.set(obj.sid, obj);
      }, new Map()) : this._remoteLevels;

      if (updated) {
        this.emit('updated');
      }
      setTimeout(function () {
        return _this2._sendNetworkQualityInputs();
      }, 1000);
    }

    /**
     * Start sending {@link NetworkQualityInputs}.
     * @private
     * @returns {Promise<void>}
     */

  }, {
    key: '_sendNetworkQualityInputs',
    value: function _sendNetworkQualityInputs() {
      var _this3 = this;

      return this._networkQualityInputs.take().then(function (networkQualityInputs) {
        _this3._mediaSignalingTransport.publish(createNetworkQualityInputsMessage(networkQualityInputs, _this3._networkQualityReportLevels));
      });
    }

    /**
     * Put {@link NetworkQualityInputs} to be used for computing
     * {@link NetworkQualityLevel}.
     * @param {NetworkQualityInputs} networkQualityInputs
     * @returns {void}
     */

  }, {
    key: 'put',
    value: function put(networkQualityInputs) {
      this._networkQualityInputs.put(networkQualityInputs);
    }
  }, {
    key: 'level',
    get: function get() {
      return this._level;
    }

    /**
     * Get the current {@link NetworkQualityLevels}, if any.
     * @returns {?NetworkQualityLevels} levels - initially null
     */

  }, {
    key: 'levels',
    get: function get() {
      return this._levels;
    }

    /**
     * Get the current {@link NetworkQualityLevels} of remote participants, if any.
     * @returns {Map<String, NetworkQualityLevels>} remoteLevels
     */

  }, {
    key: 'remoteLevels',
    get: function get() {
      return this._remoteLevels;
    }
  }]);

  return NetworkQualitySignaling;
}(EventEmitter);

/**
 * The {@link NetworkQualityLevel} changed.
 * @event NetworkQualitySignaling#updated
 */

/**
 * @typedef {object} NetworkQualityReportLevels
 * @param {number} reportLevel
 * @param {number} remoteReportLevel
 */

/**
 * @param {NetworkQualityInputs} networkQualityInputs
 * @param {NetworkQualityReportLevels} networkQualityReportLevels
 * @returns {object} message
 */


function createNetworkQualityInputsMessage(networkQualityInputs, networkQualityReportLevels) {
  return Object.assign({ type: 'network_quality' }, networkQualityInputs, networkQualityReportLevels);
}

module.exports = NetworkQualitySignaling;
},{"../../util/asyncvar":106,"events":165}],64:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var DefaultBackoff = require('backoff');

var _require = require('@twilio/webrtc'),
    DefaultMediaStream = _require.MediaStream,
    DefaultRTCIceCandidate = _require.RTCIceCandidate,
    DefaultRTCPeerConnection = _require.RTCPeerConnection,
    DefaultRTCSessionDescription = _require.RTCSessionDescription,
    getStatistics = _require.getStats;

var _require2 = require('@twilio/webrtc/lib/util'),
    guessBrowser = _require2.guessBrowser;

var _require3 = require('@twilio/webrtc/lib/util/sdp'),
    getSdpFormat = _require3.getSdpFormat;

var _require4 = require('../../util/constants'),
    DEFAULT_ICE_GATHERING_TIMEOUT_MS = _require4.DEFAULT_ICE_GATHERING_TIMEOUT_MS,
    DEFAULT_LOG_LEVEL = _require4.DEFAULT_LOG_LEVEL,
    DEFAULT_SESSION_TIMEOUT_SEC = _require4.DEFAULT_SESSION_TIMEOUT_SEC,
    iceRestartBackoffConfig = _require4.iceRestartBackoffConfig;

var _require5 = require('../../util/sdp'),
    createCodecMapForMediaSection = _require5.createCodecMapForMediaSection,
    disableRtx = _require5.disableRtx,
    enableDtxForOpus = _require5.enableDtxForOpus,
    getMediaSections = _require5.getMediaSections,
    removeSSRCAttributes = _require5.removeSSRCAttributes,
    revertSimulcastForNonVP8MediaSections = _require5.revertSimulcastForNonVP8MediaSections,
    setBitrateParameters = _require5.setBitrateParameters,
    setCodecPreferences = _require5.setCodecPreferences,
    setSimulcast = _require5.setSimulcast,
    unifiedPlanAddOrRewriteNewTrackIds = _require5.unifiedPlanAddOrRewriteNewTrackIds,
    unifiedPlanAddOrRewriteTrackIds = _require5.unifiedPlanAddOrRewriteTrackIds,
    unifiedPlanFilterLocalCodecs = _require5.unifiedPlanFilterLocalCodecs;

var DefaultTimeout = require('../../util/timeout');

var _require6 = require('../../util/twilio-video-errors'),
    MediaClientLocalDescFailedError = _require6.MediaClientLocalDescFailedError,
    MediaClientRemoteDescFailedError = _require6.MediaClientRemoteDescFailedError;

var _require7 = require('../../util'),
    buildLogLevels = _require7.buildLogLevels,
    isChromeScreenShareTrack = _require7.isChromeScreenShareTrack,
    oncePerTick = _require7.oncePerTick;

var IceBox = require('./icebox');
var DefaultIceConnectionMonitor = require('./iceconnectionmonitor.js');
var DataTrackReceiver = require('../../data/receiver');
var MediaTrackReceiver = require('../../media/track/receiver');
var StateMachine = require('../../statemachine');
var Log = require('../../util/log');
var IdentityTrackMatcher = require('../../util/sdp/trackmatcher/identity');
var OrderedTrackMatcher = require('../../util/sdp/trackmatcher/ordered');
var MIDTrackMatcher = require('../../util/sdp/trackmatcher/mid');
var workaroundIssue8329 = require('../../util/sdp/issue8329');

var guess = guessBrowser();
var isChrome = guess === 'chrome';
var isFirefox = guess === 'firefox';
var isSafari = guess === 'safari';

var isRTCRtpSenderParamsSupported = typeof RTCRtpSender !== 'undefined' && typeof RTCRtpSender.prototype.getParameters === 'function' && typeof RTCRtpSender.prototype.setParameters === 'function';

var nInstances = 0;

/*
PeerConnectionV2 States
-----------------------

    +------+    +--------+
    |      |    |        |
    | open |--->| closed |
    |      |    |        |
    +------+    +--------+
      |  ^          ^
      |  |          |
      |  |          |
      v  |          |
  +----------+      |
  |          |      |
  | updating |------+
  |          |
  +----------+

*/

var states = {
  open: ['closed', 'updating'],
  updating: ['closed', 'open'],
  closed: []
};

/**
 * @extends StateMachine
 * @property {id}
 * @emits PeerConnectionV2#connectionStateChanged
 * @emits PeerConnectionV2#iceConnectionStateChanged
 * @emits PeerConnectionV2#candidates
 * @emits PeerConnectionV2#description
 */

var PeerConnectionV2 = function (_StateMachine) {
  _inherits(PeerConnectionV2, _StateMachine);

  /**
   * Construct a {@link PeerConnectionV2}.
   * @param {string} id
   * @param {EncodingParametersImpl} encodingParameters
   * @param {PreferredCodecs} preferredCodecs
   * @param {object} [options]
   */
  function PeerConnectionV2(id, encodingParameters, preferredCodecs, options) {
    _classCallCheck(this, PeerConnectionV2);

    var _this = _possibleConstructorReturn(this, (PeerConnectionV2.__proto__ || Object.getPrototypeOf(PeerConnectionV2)).call(this, 'open', states));

    options = Object.assign({
      enableDscp: false,
      dummyAudioMediaStreamTrack: null,
      isChromeScreenShareTrack: isChromeScreenShareTrack,
      iceServers: [],
      isRTCRtpSenderParamsSupported: isRTCRtpSenderParamsSupported,
      logLevel: DEFAULT_LOG_LEVEL,
      offerOptions: {},
      revertSimulcastForNonVP8MediaSections: revertSimulcastForNonVP8MediaSections,
      sessionTimeout: DEFAULT_SESSION_TIMEOUT_SEC * 1000,
      setBitrateParameters: setBitrateParameters,
      setCodecPreferences: setCodecPreferences,
      setSimulcast: setSimulcast,
      Backoff: DefaultBackoff,
      IceConnectionMonitor: DefaultIceConnectionMonitor,
      MediaStream: DefaultMediaStream,
      RTCIceCandidate: DefaultRTCIceCandidate,
      RTCPeerConnection: DefaultRTCPeerConnection,
      RTCSessionDescription: DefaultRTCSessionDescription,
      Timeout: DefaultTimeout
    }, options);

    var configuration = getConfiguration(options);
    var sdpFormat = getSdpFormat(configuration.sdpSemantics);
    var isUnifiedPlan = sdpFormat === 'unified';

    var localMediaStream = isUnifiedPlan ? null : new options.MediaStream();
    var logLevels = buildLogLevels(options.logLevel);
    var RTCPeerConnection = options.RTCPeerConnection;

    if (options.enableDscp === true) {
      options.chromeSpecificConstraints = options.chromeSpecificConstraints || {};
      options.chromeSpecificConstraints.optional = options.chromeSpecificConstraints.optional || [];
      options.chromeSpecificConstraints.optional.push({ googDscp: true });
    }

    var log = options.log ? options.log.createLog('webrtc', _this) : new Log('webrtc', _this, logLevels, options.loggerName);
    var peerConnection = new RTCPeerConnection(configuration, options.chromeSpecificConstraints);

    if (options.dummyAudioMediaStreamTrack) {
      peerConnection.addTrack(options.dummyAudioMediaStreamTrack, localMediaStream || new options.MediaStream());
    }

    Object.defineProperties(_this, {
      _appliedTrackIdsToAttributes: {
        value: new Map(),
        writable: true
      },
      _dataChannels: {
        value: new Map()
      },
      _dataTrackReceivers: {
        value: new Set()
      },
      _descriptionRevision: {
        writable: true,
        value: 0
      },
      _didGenerateLocalCandidates: {
        writable: true,
        value: false
      },
      _enableDscp: {
        value: options.enableDscp
      },
      _encodingParameters: {
        value: encodingParameters
      },
      _isChromeScreenShareTrack: {
        value: options.isChromeScreenShareTrack
      },
      _iceGatheringFailed: {
        value: false,
        writable: true
      },
      _iceGatheringTimeout: {
        value: new options.Timeout(function () {
          return _this._handleIceGatheringTimeout();
        }, DEFAULT_ICE_GATHERING_TIMEOUT_MS, false)
      },
      _iceRestartBackoff: {
        value: options.Backoff.exponential(iceRestartBackoffConfig)
      },
      _instanceId: {
        value: ++nInstances
      },
      _isIceConnectionInactive: {
        writable: true,
        value: false
      },
      _isIceLite: {
        writable: true,
        value: false
      },
      _isIceRestartBackoffInProgress: {
        writable: true,
        value: false
      },
      _isRestartingIce: {
        writable: true,
        value: false
      },
      _isUnifiedPlan: {
        value: isUnifiedPlan
      },
      _isRTCRtpSenderParamsSupported: {
        value: options.isRTCRtpSenderParamsSupported
      },
      _lastIceConnectionState: {
        writable: true,
        value: null
      },
      _lastStableDescriptionRevision: {
        writable: true,
        value: 0
      },
      _localCandidates: {
        writable: true,
        value: []
      },
      _localCodecs: {
        value: new Set()
      },
      _localCandidatesRevision: {
        writable: true,
        value: 1
      },
      _localDescriptionWithoutSimulcast: {
        writable: true,
        value: null
      },
      _localDescription: {
        writable: true,
        value: null
      },
      _localMediaStream: {
        value: localMediaStream
      },
      _localUfrag: {
        writable: true,
        value: null
      },
      _log: {
        value: log
      },
      _remoteCodecMaps: {
        value: new Map()
      },
      _rtpSenders: {
        value: new Map()
      },
      _iceConnectionMonitor: {
        value: new options.IceConnectionMonitor(peerConnection)
      },
      _mediaTrackReceivers: {
        value: new Set()
      },
      _needsAnswer: {
        writable: true,
        value: false
      },
      _negotiationRole: {
        writable: true,
        value: null
      },
      _offerOptions: {
        writable: true,
        value: options.offerOptions
      },
      _onEncodingParametersChanged: {
        value: oncePerTick(function () {
          if (_this._isRTCRtpSenderParamsSupported) {
            if (!_this._needsAnswer) {
              updateEncodingParameters(_this);
            }
            return;
          }
          _this.offer();
        })
      },
      _peerConnection: {
        value: peerConnection
      },
      _preferredAudioCodecs: {
        value: preferredCodecs.audio
      },
      _preferredVideoCodecs: {
        value: preferredCodecs.video
      },
      _shouldApplyDtx: {
        value: preferredCodecs.audio.every(function (_ref) {
          var codec = _ref.codec;
          return codec !== 'opus';
        }) || preferredCodecs.audio.some(function (_ref2) {
          var codec = _ref2.codec,
              dtx = _ref2.dtx;
          return codec === 'opus' && dtx;
        })
      },
      _shouldApplySimulcast: {
        value: (isChrome || isSafari) && preferredCodecs.video.some(function (codecSettings) {
          return codecSettings.codec.toLowerCase() === 'vp8' && codecSettings.simulcast;
        })
      },
      _queuedDescription: {
        writable: true,
        value: null
      },
      _iceReconnectTimeout: {
        value: new options.Timeout(function () {
          log.debug('ICE reconnect timed out');
          _this.close();
        }, options.sessionTimeout, false)
      },
      _recycledTransceivers: {
        value: {
          audio: [],
          video: []
        }
      },
      _replaceTrackPromises: {
        value: new Map()
      },
      _remoteCandidates: {
        writable: true,
        value: new IceBox()
      },
      _sdpFormat: {
        value: sdpFormat
      },
      _setBitrateParameters: {
        value: options.setBitrateParameters
      },
      _setCodecPreferences: {
        value: options.setCodecPreferences
      },
      _setSimulcast: {
        value: options.setSimulcast
      },
      _revertSimulcastForNonVP8MediaSections: {
        value: options.revertSimulcastForNonVP8MediaSections
      },
      _RTCIceCandidate: {
        value: options.RTCIceCandidate
      },
      _RTCPeerConnection: {
        value: options.RTCPeerConnection
      },
      _RTCSessionDescription: {
        value: options.RTCSessionDescription
      },
      _shouldOffer: {
        writable: true,
        value: false
      },
      _shouldRestartIce: {
        writable: true,
        value: false
      },
      _trackIdsToAttributes: {
        value: new Map(),
        writable: true
      },
      _trackMatcher: {
        writable: true,
        value: null
      },
      id: {
        enumerable: true,
        value: id
      }
    });

    encodingParameters.on('changed', _this._onEncodingParametersChanged);

    peerConnection.addEventListener('connectionstatechange', _this._handleConnectionStateChange.bind(_this));
    peerConnection.addEventListener('datachannel', _this._handleDataChannelEvent.bind(_this));
    peerConnection.addEventListener('icecandidate', _this._handleIceCandidateEvent.bind(_this));
    peerConnection.addEventListener('iceconnectionstatechange', _this._handleIceConnectionStateChange.bind(_this));
    peerConnection.addEventListener('icegatheringstatechange', _this._handleIceGatheringStateChange.bind(_this));
    peerConnection.addEventListener('signalingstatechange', _this._handleSignalingStateChange.bind(_this));
    peerConnection.addEventListener('track', _this._handleTrackEvent.bind(_this));
    _this._iceRestartBackoff.on('ready', function () {
      return _this._initiateIceRestart();
    });

    var self = _this;
    _this.on('stateChanged', function stateChanged(state) {
      if (state !== 'closed') {
        return;
      }
      self.removeListener('stateChanged', stateChanged);
      self._dataChannels.forEach(function (dataChannel, dataTrackSender) {
        self.removeDataTrackSender(dataTrackSender);
      });
    });
    return _this;
  }

  _createClass(PeerConnectionV2, [{
    key: 'toString',
    value: function toString() {
      return '[PeerConnectionV2 #' + this._instanceId + ': ' + this.id + ']';
    }

    /**
     * The {@link PeerConnectionV2}'s underlying RTCPeerConnection's RTCPeerConnectionState
     * if supported by the browser, its RTCIceConnectionState otherwise.
     * @property {RTCPeerConnectionState}
     */

  }, {
    key: '_addIceCandidate',


    /**
     * Add an ICE candidate to the {@link PeerConnectionV2}.
     * @private
     * @param {object} candidate
     * @returns {Promise<void>}
     */
    value: function _addIceCandidate(candidate) {
      var _this2 = this;

      return Promise.resolve().then(function () {
        candidate = new _this2._RTCIceCandidate(candidate);
        return _this2._peerConnection.addIceCandidate(candidate);
      }).catch(function (error) {
        // NOTE(mmalavalli): Firefox 68+ now generates an RTCIceCandidate with an
        // empty candidate string to signal end-of-candidates, followed by a null
        // candidate. As of now, Chrome and Safari reject this RTCIceCandidate. Since
        // this does not affect the media connection between Firefox 68+ and Chrome/Safari
        // in Peer-to-Peer Rooms, we suppress the Error and log a warning message.
        //
        // Chrome bug: https://bugs.chromium.org/p/chromium/issues/detail?id=978582
        //
        _this2._log.warn('Failed to add RTCIceCandidate ' + (candidate ? '"' + candidate.candidate + '"' : 'null') + ': ' + error.message);
      });
    }

    /**
     * Add ICE candidates to the {@link PeerConnectionV2}.
     * @private
     * @param {Array<object>} candidates
     * @returns {Promise<void>}
     */

  }, {
    key: '_addIceCandidates',
    value: function _addIceCandidates(candidates) {
      return Promise.all(candidates.map(this._addIceCandidate, this)).then(function () {});
    }

    /**
     * Add a new RTCRtpTransceiver or update an existing RTCRtpTransceiver for the
     * given MediaStreamTrack.
     * @private
     * @param {MediaStreamTrack} track
     * @returns {RTCRtpTransceiver}
     */

  }, {
    key: '_addOrUpdateTransceiver',
    value: function _addOrUpdateTransceiver(track) {
      var _this3 = this;

      var transceiver = takeRecycledTransceiver(this, track.kind);
      if (transceiver && transceiver.sender) {
        var oldTrackId = transceiver.sender.track ? transceiver.sender.track.id : null;
        if (oldTrackId) {
          this._log.warn('Reusing transceiver: ' + transceiver.mid + '] ' + oldTrackId + ' => ' + track.id);
        }
        // NOTE(mpatwardhan):remember this transceiver while we replace track.
        // we recycle transceivers that are not in use after 'negotiationCompleted', but we want to prevent
        // this one from getting recycled while replaceTrack is pending.
        this._replaceTrackPromises.set(transceiver, transceiver.sender.replaceTrack(track).then(function () {
          transceiver.direction = 'sendrecv';
        }, function () {
          // Do nothing.
        }).finally(function () {
          _this3._replaceTrackPromises.delete(transceiver);
        }));
        return transceiver;
      }
      return this._peerConnection.addTransceiver(track);
    }

    /**
     * Check the {@link IceBox}.
     * @private
     * @param {RTCSessionDescriptionInit} description
     * @returns {Promise<void>}
     */

  }, {
    key: '_checkIceBox',
    value: function _checkIceBox(description) {
      var ufrag = getUfrag(description);
      if (!ufrag) {
        return Promise.resolve();
      }
      var candidates = this._remoteCandidates.setUfrag(ufrag);
      return this._addIceCandidates(candidates);
    }

    /**
     * Create an answer and set it on the {@link PeerConnectionV2}.
     * @private
     * @param {RTCSessionDescriptionInit} offer
     * @returns {Promise<boolean>}
     */

  }, {
    key: '_answer',
    value: function _answer(offer) {
      var _this4 = this;

      return Promise.resolve().then(function () {
        if (!_this4._negotiationRole) {
          _this4._negotiationRole = 'answerer';
        }
        return _this4._setRemoteDescription(offer);
      }).catch(function () {
        throw new MediaClientRemoteDescFailedError();
      }).then(function () {
        return _this4._peerConnection.createAnswer();
      }).then(function (answer) {
        if (isFirefox) {
          // NOTE(mmalavalli): We work around Chromium bug 1106157 by disabling
          // RTX in Firefox 79+. For more details about the bug, please go here:
          // https://bugs.chromium.org/p/chromium/issues/detail?id=1106157
          answer = new _this4._RTCSessionDescription({
            sdp: disableRtx(answer.sdp),
            type: answer.type
          });
        } else {
          answer = workaroundIssue8329(answer);
        }

        // NOTE(mpatwardhan): Upcoming chrome versions are going to remove ssrc attributes
        // mslabel and label. See this bug https://bugs.chromium.org/p/webrtc/issues/detail?id=7110
        // and PSA: https://groups.google.com/forum/#!searchin/discuss-webrtc/PSA%7Csort:date/discuss-webrtc/jcZO-Wj0Wus/k2XvPCvoAwAJ
        // We are not referencing those attributes, but this changes goes ahead and removes them to see if it works.
        // this also helps reduce bytes on wires
        var updatedSdp = removeSSRCAttributes(answer.sdp, ['mslabel', 'label']);
        if (_this4._shouldApplySimulcast) {
          var sdpWithoutSimulcast = updatedSdp;
          updatedSdp = _this4._setSimulcast(sdpWithoutSimulcast, _this4._sdpFormat, _this4._trackIdsToAttributes);
          // NOTE(syerrapragada): VMS does not support H264 simulcast. So,
          // unset simulcast for sections in local offer where corresponding
          // sections in answer doesn't have vp8 as preferred codec and reapply offer.
          updatedSdp = _this4._revertSimulcastForNonVP8MediaSections(updatedSdp, sdpWithoutSimulcast, offer.sdp);
        }

        // NOTE(mmalavalli): Work around Chromium bug 1074421.
        // https://bugs.chromium.org/p/chromium/issues/detail?id=1074421
        updatedSdp = updatedSdp.replace(/42e015/g, '42e01f');

        return _this4._setLocalDescription({
          type: answer.type,
          sdp: updatedSdp
        });
      }).then(function () {
        return _this4._checkIceBox(offer);
      }).then(function () {
        return _this4._queuedDescription && _this4._updateDescription(_this4._queuedDescription);
      }).then(function () {
        _this4._queuedDescription = null;
        return _this4._maybeReoffer(_this4._peerConnection.localDescription);
      }).catch(function (error) {
        throw error instanceof MediaClientRemoteDescFailedError ? error : new MediaClientLocalDescFailedError();
      });
    }

    /**
     * Close the underlying RTCPeerConnection. Returns false if the
     * RTCPeerConnection was already closed.
     * @private
     * @returns {boolean}
     */

  }, {
    key: '_close',
    value: function _close() {
      this._iceConnectionMonitor.stop();
      if (this._peerConnection.signalingState !== 'closed') {
        this._peerConnection.close();
        this.preempt('closed');
        this._encodingParameters.removeListener('changed', this._onEncodingParametersChanged);
        return true;
      }
      return false;
    }

    /**
     * Handle a "connectionstatechange" event.
     * @private
     * @returns {void}
     */

  }, {
    key: '_handleConnectionStateChange',
    value: function _handleConnectionStateChange() {
      this.emit('connectionStateChanged');
    }

    /**
     * Handle a "datachannel" event.
     * @private
     * @param {RTCDataChannelEvent} event
     * @returns {void}
     */

  }, {
    key: '_handleDataChannelEvent',
    value: function _handleDataChannelEvent(event) {
      var _this5 = this;

      var dataChannel = event.channel;
      var dataTrackReceiver = new DataTrackReceiver(dataChannel);
      this._dataTrackReceivers.add(dataTrackReceiver);

      dataChannel.addEventListener('close', function () {
        _this5._dataTrackReceivers.delete(dataTrackReceiver);
      });

      this.emit('trackAdded', dataTrackReceiver);
    }

    /**
     * Handle a glare scenario on the {@link PeerConnectionV2}.
     * @private
     * @param {RTCSessionDescriptionInit} offer
     * @returns {Promise<void>}
     */

  }, {
    key: '_handleGlare',
    value: function _handleGlare(offer) {
      var _this6 = this;

      this._log.debug('Glare detected; rolling back');
      if (this._isRestartingIce) {
        this._log.debug('An ICE restart was in progress; we\'ll need to restart ICE again after rolling back');
        this._isRestartingIce = false;
        this._shouldRestartIce = true;
      }
      return Promise.resolve().then(function () {
        _this6._trackIdsToAttributes = new Map(_this6._appliedTrackIdsToAttributes);
        return _this6._setLocalDescription({ type: 'rollback' });
      }).then(function () {
        _this6._needsAnswer = false;
        return _this6._answer(offer);
      }).then(function (didReoffer) {
        return didReoffer ? Promise.resolve() : _this6._offer();
      });
    }

    /**
     * Handle an ICE candidate event.
     * @private
     * @param {Event} event
     * @returns {void}
     */

  }, {
    key: '_handleIceCandidateEvent',
    value: function _handleIceCandidateEvent(event) {
      if (event.candidate) {
        this._log.debug('Clearing ICE gathering timeout');
        this._didGenerateLocalCandidates = true;
        this._iceGatheringTimeout.clear();
        this._localCandidates.push(event.candidate);
      }
      var peerConnectionState = {
        ice: {
          candidates: this._isIceLite ? [] : this._localCandidates.slice(),
          ufrag: this._localUfrag
        },
        id: this.id
      };
      if (!event.candidate) {
        peerConnectionState.ice.complete = true;
      }
      if (!(this._isIceLite && event.candidate)) {
        peerConnectionState.ice.revision = this._localCandidatesRevision++;
        this.emit('candidates', peerConnectionState);
      }
    }

    /**
     * Handle an ICE connection state change event.
     * @private
     * @returns {void}
     */

  }, {
    key: '_handleIceConnectionStateChange',
    value: function _handleIceConnectionStateChange() {
      var _this7 = this;

      var iceConnectionState = this._peerConnection.iceConnectionState;

      var isIceConnectedOrComplete = ['connected', 'completed'].includes(iceConnectionState);
      var log = this._log;

      log.debug('ICE connection state is "' + iceConnectionState + '"');
      if (isIceConnectedOrComplete) {
        this._iceReconnectTimeout.clear();
        this._iceRestartBackoff.reset();
      }

      if (this._lastIceConnectionState !== 'failed' && iceConnectionState === 'failed' && !this._shouldRestartIce && !this._isRestartingIce) {
        // Case 1: Transition to "failed".
        log.warn('ICE failed');
        this._initiateIceRestartBackoff();
      } else if (['disconnected', 'failed'].includes(this._lastIceConnectionState) && isIceConnectedOrComplete) {
        // Case 2: Transition from "disconnected" or "failed".
        log.debug('ICE reconnected');
      }

      // start monitor media when connected, and continue to monitor while state is complete-disconnected-connected.
      if (iceConnectionState === 'connected') {
        this._isIceConnectionInactive = false;
        this._iceConnectionMonitor.start(function () {
          // note: iceConnection monitor waits for iceConnectionState=disconnected for
          // detecting inactivity. Its possible that it may know about disconnected before _handleIceConnectionStateChange
          _this7._iceConnectionMonitor.stop();
          if (!_this7._shouldRestartIce && !_this7._isRestartingIce) {
            log.warn('ICE Connection Monitor detected inactivity');
            _this7._isIceConnectionInactive = true;
            _this7._initiateIceRestartBackoff();
            _this7.emit('iceConnectionStateChanged');
            _this7.emit('connectionStateChanged');
          }
        });
      } else if (!['disconnected', 'completed'].includes(iceConnectionState)) {
        // don't stop monitoring for disconnected or completed.
        this._iceConnectionMonitor.stop();
        this._isIceConnectionInactive = false;
      }

      this._lastIceConnectionState = iceConnectionState;
      this.emit('iceConnectionStateChanged');
    }

    /**
     * Handle ICE gathering timeout.
     * @private
     * @returns {void}
     */

  }, {
    key: '_handleIceGatheringTimeout',
    value: function _handleIceGatheringTimeout() {
      this._log.warn('ICE failed to gather any local candidates');
      this._iceGatheringFailed = true;
      this._initiateIceRestartBackoff();
      this.emit('iceConnectionStateChanged');
      this.emit('connectionStateChanged');
    }

    /**
     * Handle an ICE gathering state change event.
     * @private
     * @returns {void}
     */

  }, {
    key: '_handleIceGatheringStateChange',
    value: function _handleIceGatheringStateChange() {
      var iceGatheringState = this._peerConnection.iceGatheringState;

      var log = this._log;
      log.debug('ICE gathering state is "' + iceGatheringState + '"');

      // NOTE(mmalavalli): Start the ICE gathering timeout only if the RTCPeerConnection
      // has started gathering candidates for the first time since the initial offer/answer
      // or an offer/answer with ICE restart.
      var _iceGatheringTimeout = this._iceGatheringTimeout,
          delay = _iceGatheringTimeout.delay,
          isSet = _iceGatheringTimeout.isSet;

      if (iceGatheringState === 'gathering' && !this._didGenerateLocalCandidates && !isSet) {
        log.debug('Starting ICE gathering timeout: ' + delay);
        this._iceGatheringFailed = false;
        this._iceGatheringTimeout.start();
      }
    }

    /**
     * Handle a signaling state change event.
     * @private
     * @returns {void}
     */

  }, {
    key: '_handleSignalingStateChange',
    value: function _handleSignalingStateChange() {
      if (this._peerConnection.signalingState === 'stable') {
        this._appliedTrackIdsToAttributes = new Map(this._trackIdsToAttributes);
      }
    }

    /**
     * Handle a track event.
     * @private
     * @param {Event} event
     * @returns {void}
     */

  }, {
    key: '_handleTrackEvent',
    value: function _handleTrackEvent(event) {
      var _this8 = this;

      var sdp = this._peerConnection.remoteDescription ? this._peerConnection.remoteDescription.sdp : null;

      if (!this._trackMatcher) {
        this._trackMatcher = event.transceiver && event.transceiver.mid ? new MIDTrackMatcher()
        // NOTE(mroberts): Until Chrome ships RTCRtpTransceivers with MID
        // support, we have to use the same hacky solution as Safari. Revisit
        // this when RTCRtpTransceivers and MIDs land. We should be able to use
        // the same technique as Firefox.
        : isSafari || this._isUnifiedPlan ? new OrderedTrackMatcher() : new IdentityTrackMatcher();
      }
      this._trackMatcher.update(sdp);

      var mediaStreamTrack = event.track;
      var signaledTrackId = this._trackMatcher.match(event) || mediaStreamTrack.id;
      var mediaTrackReceiver = new MediaTrackReceiver(signaledTrackId, mediaStreamTrack);

      // NOTE(mmalavalli): In unified plan mode, "ended" is not fired on the remote
      // MediaStreamTrack when the remote peer removes a track. So, when this
      // MediaStreamTrack is re-used for a different track due to the remote peer
      // calling RTCRtpSender.replaceTrack(), we delete the previous MediaTrackReceiver
      // that owned this MediaStreamTrack before adding the new MediaTrackReceiver.
      this._mediaTrackReceivers.forEach(function (trackReceiver) {
        if (trackReceiver.track.id === mediaTrackReceiver.track.id) {
          _this8._mediaTrackReceivers.delete(trackReceiver);
        }
      });

      this._mediaTrackReceivers.add(mediaTrackReceiver);
      mediaStreamTrack.addEventListener('ended', function () {
        return _this8._mediaTrackReceivers.delete(mediaTrackReceiver);
      });
      this.emit('trackAdded', mediaTrackReceiver);
    }

    /**
     * Initiate ICE Restart.
     * @private
     * @returns {void}
     */

  }, {
    key: '_initiateIceRestart',
    value: function _initiateIceRestart() {
      if (this._peerConnection.signalingState === 'closed') {
        return;
      }
      var log = this._log;
      log.warn('Attempting to restart ICE');
      this._didGenerateLocalCandidates = false;
      this._isIceRestartBackoffInProgress = false;
      this._shouldRestartIce = true;

      var _iceReconnectTimeout = this._iceReconnectTimeout,
          delay = _iceReconnectTimeout.delay,
          isSet = _iceReconnectTimeout.isSet;

      if (!isSet) {
        log.debug('Starting ICE reconnect timeout: ' + delay);
        this._iceReconnectTimeout.start();
      }
      this.offer();
    }

    /**
     * Schedule an ICE Restart.
     * @private
     * @returns {void}
     */

  }, {
    key: '_initiateIceRestartBackoff',
    value: function _initiateIceRestartBackoff() {
      if (this._peerConnection.signalingState === 'closed' || this._isIceRestartBackoffInProgress) {
        return;
      }
      this._log.warn('An ICE restart has been scheduled');
      this._isIceRestartBackoffInProgress = true;
      this._iceRestartBackoff.backoff();
    }

    /**
     * Conditionally re-offer.
     * @private
     * @param {?RTCSessionDescriptionInit} localDescription
     * @returns {Promise<boolean>}
     */

  }, {
    key: '_maybeReoffer',
    value: function _maybeReoffer(localDescription) {
      var shouldReoffer = this._shouldOffer;

      if (localDescription && localDescription.sdp) {
        // NOTE(mmalavalli): For "unified-plan" sdps, if the local RTCSessionDescription
        // has fewer audio and/or video send* m= lines than the corresponding RTCRtpSenders
        // with non-null MediaStreamTracks, it means that the newly added RTCRtpSenders
        // require renegotiation.
        if (this._isUnifiedPlan) {
          var senders = this._peerConnection.getSenders().filter(function (sender) {
            return sender.track;
          });
          shouldReoffer = ['audio', 'video'].reduce(function (shouldOffer, kind) {
            var mediaSections = getMediaSections(localDescription.sdp, kind, '(sendrecv|sendonly)');
            var sendersOfKind = senders.filter(isSenderOfKind.bind(null, kind));
            return shouldOffer || mediaSections.length < sendersOfKind.length;
          }, shouldReoffer);
        }

        // NOTE(mroberts): We also need to re-offer if we have a DataTrack to share
        // but no m= application section.
        var hasDataTrack = this._dataChannels.size > 0;
        var hasApplicationMediaSection = getMediaSections(localDescription.sdp, 'application').length > 0;
        var needsApplicationMediaSection = hasDataTrack && !hasApplicationMediaSection;
        shouldReoffer = shouldReoffer || needsApplicationMediaSection;
      }

      var promise = shouldReoffer ? this._offer() : Promise.resolve();
      return promise.then(function () {
        return shouldReoffer;
      });
    }

    /**
     * Create an offer and set it on the {@link PeerConnectionV2}.
     * @private
     * @returns {Promise<void>}
     */

  }, {
    key: '_offer',
    value: function _offer() {
      var _this9 = this;

      var offerOptions = Object.assign({}, this._offerOptions);
      this._needsAnswer = true;
      if (this._shouldRestartIce) {
        this._shouldRestartIce = false;
        this._isRestartingIce = true;
        offerOptions.iceRestart = true;
      }

      return Promise.all(this._replaceTrackPromises.values()).then(function () {
        return _this9._peerConnection.createOffer(offerOptions);
      }).catch(function () {
        throw new MediaClientLocalDescFailedError();
      }).then(function (offer) {
        if (isFirefox) {
          // NOTE(mmalavalli): We work around Chromium bug 1106157 by disabling
          // RTX in Firefox 79+. For more details about the bug, please go here:
          // https://bugs.chromium.org/p/chromium/issues/detail?id=1106157
          offer = new _this9._RTCSessionDescription({
            sdp: disableRtx(offer.sdp),
            type: offer.type
          });
        } else {
          offer = workaroundIssue8329(offer);
        }

        // NOTE(mpatwardhan): upcoming chrome versions are going to remove ssrc attributes
        // mslabel and label. See this bug https://bugs.chromium.org/p/webrtc/issues/detail?id=7110
        // and PSA: https://groups.google.com/forum/#!searchin/discuss-webrtc/PSA%7Csort:date/discuss-webrtc/jcZO-Wj0Wus/k2XvPCvoAwAJ
        // Looks like we are not referencing those attributes, but this changes goes ahead and removes them to see if it works.
        // this also helps reduce bytes on wires
        var sdp = removeSSRCAttributes(offer.sdp, ['mslabel', 'label']);
        sdp = _this9._isUnifiedPlan && _this9._peerConnection.remoteDescription ? unifiedPlanFilterLocalCodecs(sdp, _this9._peerConnection.remoteDescription.sdp) : sdp;

        var updatedSdp = _this9._setCodecPreferences(sdp, _this9._preferredAudioCodecs, _this9._preferredVideoCodecs);

        _this9._shouldOffer = false;
        if (!_this9._negotiationRole) {
          _this9._negotiationRole = 'offerer';
        }

        if (_this9._shouldApplySimulcast) {
          _this9._localDescriptionWithoutSimulcast = {
            type: 'offer',
            sdp: updatedSdp
          };
          updatedSdp = _this9._setSimulcast(updatedSdp, _this9._sdpFormat, _this9._trackIdsToAttributes);
        }
        return _this9._setLocalDescription({
          type: 'offer',
          sdp: updatedSdp
        });
      });
    }

    /**
     * Get the MediaTrackSender ID of the given MediaStreamTrack ID.
     * Since a MediaTrackSender's underlying MediaStreamTrack can be
     * replaced, the corresponding IDs can mismatch.
     * @private
     * @param {Track.ID} id
     * @returns {Track.ID}
     */

  }, {
    key: '_getMediaTrackSenderId',
    value: function _getMediaTrackSenderId(trackId) {
      var mediaTrackSender = Array.from(this._rtpSenders.keys()).find(function (_ref3) {
        var id = _ref3.track.id;
        return id === trackId;
      });
      return mediaTrackSender ? mediaTrackSender.id : trackId;
    }

    /**
     * Add or rewrite local MediaStreamTrack IDs in the given Unified Plan RTCSessionDescription.
     * @private
     * @param {RTCSessionDescription} description
     * @return {RTCSessionDescription}
     */

  }, {
    key: '_addOrRewriteLocalTrackIds',
    value: function _addOrRewriteLocalTrackIds(description) {
      var _this10 = this;

      var transceivers = this._peerConnection.getTransceivers();
      var activeTransceivers = transceivers.filter(function (_ref4) {
        var sender = _ref4.sender,
            stopped = _ref4.stopped;
        return !stopped && sender && sender.track;
      });

      // NOTE(mmalavalli): There is no guarantee that MediaStreamTrack IDs will be present in
      // SDPs, and even if they are, there is no guarantee that they will be the same as the
      // actual MediaStreamTrack IDs. So, we add or re-write the actual MediaStreamTrack IDs
      // to the assigned m= sections here.
      var assignedTransceivers = activeTransceivers.filter(function (_ref5) {
        var mid = _ref5.mid;
        return mid;
      });
      var midsToTrackIds = new Map(assignedTransceivers.map(function (_ref6) {
        var mid = _ref6.mid,
            sender = _ref6.sender;
        return [mid, _this10._getMediaTrackSenderId(sender.track.id)];
      }));
      var sdp1 = unifiedPlanAddOrRewriteTrackIds(description.sdp, midsToTrackIds);

      // NOTE(mmalavalli): Chrome and Safari do not apply the offer until they get an answer.
      // So, we add or re-write the actual MediaStreamTrack IDs to the unassigned m= sections here.
      var unassignedTransceivers = activeTransceivers.filter(function (_ref7) {
        var mid = _ref7.mid;
        return !mid;
      });
      var newTrackIdsByKind = new Map(['audio', 'video'].map(function (kind) {
        return [kind, unassignedTransceivers.filter(function (_ref8) {
          var sender = _ref8.sender;
          return sender.track.kind === kind;
        }).map(function (_ref9) {
          var sender = _ref9.sender;
          return _this10._getMediaTrackSenderId(sender.track.id);
        })];
      }));
      var sdp2 = unifiedPlanAddOrRewriteNewTrackIds(sdp1, midsToTrackIds, newTrackIdsByKind);

      return new this._RTCSessionDescription({
        sdp: sdp2,
        type: description.type
      });
    }

    /**
     * Rollback and apply the given offer.
     * @private
     * @param {RTCSessionDescriptionInit} offer
     * @returns {Promise<void>}
     */

  }, {
    key: '_rollbackAndApplyOffer',
    value: function _rollbackAndApplyOffer(offer) {
      var _this11 = this;

      return this._setLocalDescription({ type: 'rollback' }).then(function () {
        return _this11._setLocalDescription(offer);
      });
    }

    /**
     * Set a local description on the {@link PeerConnectionV2}.
     * @private
     * @param {RTCSessionDescription|RTCSessionDescriptionInit} description
     * @returns {Promise<void>}
     */

  }, {
    key: '_setLocalDescription',
    value: function _setLocalDescription(description) {
      var _this12 = this;

      if (description.type !== 'rollback' && this._shouldApplyDtx) {
        description = new this._RTCSessionDescription({
          sdp: enableDtxForOpus(description.sdp),
          type: description.type
        });
      }
      return this._peerConnection.setLocalDescription(description).catch(function (error) {
        _this12._log.warn('Calling setLocalDescription with an RTCSessionDescription of type "' + description.type + '" failed with the error "' + error.message + '".');
        if (description.sdp) {
          _this12._log.warn('The SDP was ' + description.sdp);
        }
        throw new MediaClientLocalDescFailedError();
      }).then(function () {
        if (description.type !== 'rollback') {
          _this12._localDescription = _this12._isUnifiedPlan ? _this12._addOrRewriteLocalTrackIds(description) : description;

          // NOTE(mmalavalli): In order for this feature to be backward compatible with older
          // SDK versions which to not support opus DTX, we append "usedtx=1" to the local SDP
          // only while applying it. We will not send it over the wire to prevent inadvertent
          // enabling of opus DTX in older SDKs. Newer SDKs will append "usedtx=1" by themselves
          // if the developer has requested opus DTX to be enabled. (JSDK-3063)
          if (_this12._shouldApplyDtx) {
            _this12._localDescription = new _this12._RTCSessionDescription({
              sdp: enableDtxForOpus(_this12._localDescription.sdp, []),
              type: _this12._localDescription.type
            });
          }

          _this12._localCandidates = [];
          if (description.type === 'offer') {
            _this12._descriptionRevision++;
          } else if (description.type === 'answer') {
            _this12._lastStableDescriptionRevision = _this12._descriptionRevision;
            negotiationCompleted(_this12);
          }
          _this12._localUfrag = getUfrag(description);
          _this12.emit('description', _this12.getState());
        }
      });
    }

    /**
     * Set a remote RTCSessionDescription on the {@link PeerConnectionV2}.
     * @private
     * @param {RTCSessionDescriptionInit} description
     * @returns {Promise<void>}
     */

  }, {
    key: '_setRemoteDescription',
    value: function _setRemoteDescription(description) {
      var _this13 = this;

      if (description.sdp) {
        if (!this._isRTCRtpSenderParamsSupported) {
          description.sdp = this._setBitrateParameters(description.sdp, isFirefox ? 'TIAS' : 'AS', this._encodingParameters.maxAudioBitrate, this._encodingParameters.maxVideoBitrate);
        }
        description.sdp = this._setCodecPreferences(description.sdp, this._preferredAudioCodecs, this._preferredVideoCodecs);

        if (this._shouldApplyDtx) {
          description.sdp = enableDtxForOpus(description.sdp);
        } else {
          // NOTE(mmalavalli): Remove "usedtx=1" from opus's fmtp line if present
          // since DTX is disabled.
          description.sdp = enableDtxForOpus(description.sdp, []);
        }

        // NOTE(mroberts): Do this to reduce our MediaStream count in Firefox. By
        // mapping MediaStream IDs in the SDP to "-", we ensure the "track" event
        // doesn't include any new MediaStreams in Firefox. Its `streams` member
        // will always be the empty Array.
        if (isFirefox) {
          description.sdp = filterOutMediaStreamIds(description.sdp);
        }
        if (!this._peerConnection.remoteDescription) {
          this._isIceLite = /a=ice-lite/.test(description.sdp);
        }
      }
      description = new this._RTCSessionDescription(description);
      // eslint-disable-next-line consistent-return
      return Promise.resolve().then(function () {
        // NOTE(syerrapragada): VMS does not support H264 simulcast. So,
        // unset simulcast for sections in local offer where corresponding
        // sections in answer doesn't have vp8 as preferred codec and reapply offer.
        if (description.type === 'answer' && _this13._shouldApplySimulcast) {
          var sdpWithoutSimulcastForNonVP8MediaSections = _this13._revertSimulcastForNonVP8MediaSections(_this13._localDescription.sdp, _this13._localDescriptionWithoutSimulcast.sdp, description.sdp);
          if (sdpWithoutSimulcastForNonVP8MediaSections !== _this13._localDescription.sdp) {
            return _this13._rollbackAndApplyOffer({
              type: _this13._localDescription.type,
              sdp: sdpWithoutSimulcastForNonVP8MediaSections
            });
          }
        }
      }).then(function () {
        return _this13._peerConnection.setRemoteDescription(description);
      }).then(function () {
        if (description.type === 'answer') {
          if (_this13._isRestartingIce) {
            _this13._log.debug('An ICE restart was in-progress and is now completed');
            _this13._isRestartingIce = false;
          }
          negotiationCompleted(_this13);
        }
      }, function (error) {
        _this13._log.warn('Calling setRemoteDescription with an RTCSessionDescription of type "' + description.type + '" failed with the error "' + error.message + '".');
        if (description.sdp) {
          _this13._log.warn('The SDP was ' + description.sdp);
        }
        throw error;
      });
    }

    /**
     * Update the {@link PeerConnectionV2}'s description.
     * @private
     * @param {RTCSessionDescriptionInit} description
     * @returns {Promise<void>}
     */

  }, {
    key: '_updateDescription',
    value: function _updateDescription(description) {
      var _this14 = this;

      switch (description.type) {
        case 'answer':
        case 'pranswer':
          if (description.revision !== this._descriptionRevision || this._peerConnection.signalingState !== 'have-local-offer') {
            return Promise.resolve();
          }
          this._descriptionRevision = description.revision;
          break;
        case 'close':
          return this._close();
        case 'create-offer':
          if (description.revision <= this._lastStableDescriptionRevision) {
            return Promise.resolve();
          } else if (this._needsAnswer) {
            this._queuedDescription = description;
            return Promise.resolve();
          }
          this._descriptionRevision = description.revision;
          return this._offer();
        case 'offer':
          if (description.revision <= this._lastStableDescriptionRevision || this._peerConnection.signalingState === 'closed') {
            return Promise.resolve();
          }
          if (this._peerConnection.signalingState === 'have-local-offer') {
            // NOTE(mpatwardhan): For a peer connection
            // 1) createOffer always generate SDP with `setup:actpass`
            // 2) when remote description is set `setup:active`  - the answer generated selects the dtls role of setup:passive
            // 3) when remote description is set `setup:passive` - the answer generated selects the dtls role of setup:active
            // 4) when remote description is set `setup:actpass` - the answer generated uses the previously negotiated role (if not negotiated previously setup:active is used)
            // This test shows the  behavior: https://github.com/twilio/twilio-webrtc.js/blob/master/test/integration/spec/rtcpeerconnection.js#L936
            // with glare handling (if dtls role was not negotiated before ) the generated answer will set setup:active.
            // we do not want that. lets wait for "initial negotiation" before attempting glare handling.
            if (this._needsAnswer && this._lastStableDescriptionRevision === 0) {
              this._queuedDescription = description;
              return Promise.resolve();
            }
            this._descriptionRevision = description.revision;
            return this._handleGlare(description);
          }
          this._descriptionRevision = description.revision;
          return this._answer(description).then(function () {});
        default:
        // Do nothing.
      }

      // Handle answer or pranswer.
      var revision = description.revision;
      return Promise.resolve().then(function () {
        return _this14._setRemoteDescription(description);
      }).catch(function () {
        throw new MediaClientRemoteDescFailedError();
      }).then(function () {
        _this14._lastStableDescriptionRevision = revision;
        _this14._needsAnswer = false;
        return _this14._checkIceBox(description);
      }).then(function () {
        return _this14._queuedDescription && _this14._updateDescription(_this14._queuedDescription);
      }).then(function () {
        _this14._queuedDescription = null;
        return _this14._maybeReoffer(_this14._peerConnection.localDescription).then(function () {});
      });
    }

    /**
     * Update the {@link PeerConnectionV2}'s ICE candidates.
     * @private
     * @param {object} iceState
     * @returns {Promise<void>}
     */

  }, {
    key: '_updateIce',
    value: function _updateIce(iceState) {
      var candidates = this._remoteCandidates.update(iceState);
      return this._addIceCandidates(candidates);
    }

    /**
     * Add a {@link DataTrackSender} to the {@link PeerConnectionV2}.
     * @param {DataTrackSender} dataTrackSender
     * @returns {void}
     */

  }, {
    key: 'addDataTrackSender',
    value: function addDataTrackSender(dataTrackSender) {
      if (this._dataChannels.has(dataTrackSender)) {
        return;
      }
      try {
        var dataChannelDict = {
          ordered: dataTrackSender.ordered
        };
        if (dataTrackSender.maxPacketLifeTime !== null) {
          dataChannelDict.maxPacketLifeTime = dataTrackSender.maxPacketLifeTime;
        }
        if (dataTrackSender.maxRetransmits !== null) {
          dataChannelDict.maxRetransmits = dataTrackSender.maxRetransmits;
        }
        var dataChannel = this._peerConnection.createDataChannel(dataTrackSender.id, dataChannelDict);
        dataTrackSender.addDataChannel(dataChannel);
        this._dataChannels.set(dataTrackSender, dataChannel);
      } catch (error) {
        this._log.warn('Error creating an RTCDataChannel for DataTrack "' + dataTrackSender.id + '": ' + error.message);
      }
    }

    /**
     * Add the {@link MediaTrackSender} to the {@link PeerConnectionV2}.
     * @param {MediaTrackSender} mediaTrackSender
     * @returns {void}
     */

  }, {
    key: 'addMediaTrackSender',
    value: function addMediaTrackSender(mediaTrackSender) {
      if (this._peerConnection.signalingState === 'closed' || this._rtpSenders.has(mediaTrackSender)) {
        return;
      }
      var sender = void 0;
      if (this._localMediaStream) {
        this._localMediaStream.addTrack(mediaTrackSender.track);
        sender = this._peerConnection.addTrack(mediaTrackSender.track, this._localMediaStream);
      } else {
        var transceiver = this._addOrUpdateTransceiver(mediaTrackSender.track);
        sender = transceiver.sender;
      }
      mediaTrackSender.addSender(sender);
      this._rtpSenders.set(mediaTrackSender, sender);
    }

    /**
     * Close the {@link PeerConnectionV2}.
     * @returns {void}
     */

  }, {
    key: 'close',
    value: function close() {
      if (this._close()) {
        this._descriptionRevision++;
        this._localDescription = { type: 'close' };
        this.emit('description', this.getState());
      }
    }

    /**
     * Get the {@link DataTrackReceiver}s and the {@link MediaTrackReceivers} on the
     * {@link PeerConnectionV2}.
     * @returns {Array<DataTrackReceiver|MediaTrackReceiver>} trackReceivers
     */

  }, {
    key: 'getTrackReceivers',
    value: function getTrackReceivers() {
      return Array.from(this._dataTrackReceivers).concat(Array.from(this._mediaTrackReceivers));
    }

    /**
     * Get the {@link PeerConnectionV2}'s state (specifically, its description).
     * @returns {?object}
     */

  }, {
    key: 'getState',
    value: function getState() {
      if (!this._localDescription) {
        return null;
      }

      // NOTE(mpatwardhan): Return most recent localDescription. If the most recent local description is an
      // answer, and this method is called for sending a "sync" message while the next remote offer is being processed,
      // we need to send the most recent stable description revision instead of the current description revision,
      // which is supposed to be for the next local answer.
      var localDescriptionRevision = this._localDescription.type === 'answer' ? this._lastStableDescriptionRevision : this._descriptionRevision;
      var localDescription = {
        type: this._localDescription.type,
        revision: localDescriptionRevision
      };
      if (this._localDescription.sdp) {
        localDescription.sdp = this._localDescription.sdp;
      }
      return {
        description: localDescription,
        id: this.id
      };
    }

    /**
     * Create an offer and set it on the {@link PeerConnectionV2}.
     * @returns {Promise<void>}
     */

  }, {
    key: 'offer',
    value: function offer() {
      var _this15 = this;

      if (this._needsAnswer || this._isRestartingIce) {
        this._shouldOffer = true;
        return Promise.resolve();
      }

      return this.bracket('offering', function (key) {
        _this15.transition('updating', key);
        var promise = _this15._needsAnswer || _this15._isRestartingIce ? Promise.resolve() : _this15._offer();
        return promise.then(function () {
          _this15.tryTransition('open', key);
        }, function (error) {
          _this15.tryTransition('open', key);
          throw error;
        });
      });
    }

    /**
     * Remove a {@link DataTrackSender} from the {@link PeerConnectionV2}.
     * @param {DataTrackSender} dataTrackSender
     * @returns {void}
     */

  }, {
    key: 'removeDataTrackSender',
    value: function removeDataTrackSender(dataTrackSender) {
      var dataChannel = this._dataChannels.get(dataTrackSender);
      if (dataChannel) {
        dataTrackSender.removeDataChannel(dataChannel);
        this._dataChannels.delete(dataTrackSender);
        dataChannel.close();
      }
    }

    /**
     * Remove the {@link MediaTrackSender} from the {@link PeerConnectionV2}.
     * @param {MediaTrackSender} mediaTrackSender
     * @returns {void}
     */

  }, {
    key: 'removeMediaTrackSender',
    value: function removeMediaTrackSender(mediaTrackSender) {
      if (this._peerConnection.signalingState === 'closed' || !this._rtpSenders.has(mediaTrackSender)) {
        return;
      }
      var sender = this._rtpSenders.get(mediaTrackSender);
      this._peerConnection.removeTrack(sender);
      if (this._localMediaStream) {
        this._localMediaStream.removeTrack(mediaTrackSender.track);
      }
      mediaTrackSender.removeSender(sender);
      this._rtpSenders.delete(mediaTrackSender);
    }

    /**
     * Set the RTCConfiguration on the underlying RTCPeerConnection.
     * @param {RTCConfiguration} configuration
     * @returns {void}
     */

  }, {
    key: 'setConfiguration',
    value: function setConfiguration(configuration) {
      if (typeof this._peerConnection.setConfiguration === 'function') {
        this._peerConnection.setConfiguration(getConfiguration(configuration));
      }
    }

    /**
     * Set the ICE reconnect timeout period.
     * @param {number} period - Period in milliseconds.
     * @returns {this}
     */

  }, {
    key: 'setIceReconnectTimeout',
    value: function setIceReconnectTimeout(period) {
      this._iceReconnectTimeout.setDelay(period);
      this._log.debug('Updated ICE reconnection timeout period:', this._iceReconnectTimeout.delay);
      return this;
    }

    /**
     * Update the {@link PeerConnectionV2}.
     * @param {object} peerConnectionState
     * @returns {Promise<void>}
     */

  }, {
    key: 'update',
    value: function update(peerConnectionState) {
      var _this16 = this;

      return this.bracket('updating', function (key) {
        if (_this16.state === 'closed') {
          return Promise.resolve();
        }

        _this16.transition('updating', key);

        var updates = [];

        if (peerConnectionState.ice) {
          updates.push(_this16._updateIce(peerConnectionState.ice));
        }

        if (peerConnectionState.description) {
          updates.push(_this16._updateDescription(peerConnectionState.description));
        }

        return Promise.all(updates).then(function () {
          _this16.tryTransition('open', key);
        }, function (error) {
          _this16.tryTransition('open', key);
          throw error;
        });
      });
    }

    /**
     * Get the {@link PeerConnectionV2}'s media statistics.
     * @returns {Promise<StandardizedStatsResponse>}
     */

  }, {
    key: 'getStats',
    value: function getStats() {
      var _this17 = this;

      return getStatistics(this._peerConnection).then(function (response) {
        return rewriteTrackIds(_this17, response);
      });
    }
  }, {
    key: 'connectionState',
    get: function get() {
      return this.iceConnectionState === 'failed' ? 'failed' : this._peerConnection.connectionState || this.iceConnectionState;
    }

    /**
     * The {@link PeerConnectionV2}'s underlying RTCPeerConnection's
     * RTCIceConnectionState.
     * @property {RTCIceConnectionState}
     */

  }, {
    key: 'iceConnectionState',
    get: function get() {
      return this._isIceConnectionInactive && this._peerConnection.iceConnectionState === 'disconnected' || this._iceGatheringFailed ? 'failed' : this._peerConnection.iceConnectionState;
    }

    /**
     * Whether the {@link PeerConnectionV2} has negotiated or is in the process
     * of negotiating the application m= section.
     * @returns {boolean}
     */

  }, {
    key: 'isApplicationSectionNegotiated',
    get: function get() {
      if (this._peerConnection.signalingState !== 'closed') {
        // accessing .localDescription in 'closed' state causes it throw exceptions.
        return this._peerConnection.localDescription ? getMediaSections(this._peerConnection.localDescription.sdp, 'application').length > 0 : false;
      }
      return true;
    }
  }]);

  return PeerConnectionV2;
}(StateMachine);

function rewriteLocalTrackId(pcv2, stats) {
  var trackId = pcv2._getMediaTrackSenderId(stats.trackId);
  return Object.assign(stats, { trackId: trackId });
}

function rewriteTrackId(pcv2, stats) {
  var receiver = [].concat(_toConsumableArray(pcv2._mediaTrackReceivers)).find(function (receiver) {
    return receiver.track.id === stats.trackId;
  });
  var trackId = receiver ? receiver.id : null;
  return Object.assign(stats, { trackId: trackId });
}

function rewriteTrackIds(pcv2, response) {
  return Object.assign(response, {
    remoteAudioTrackStats: response.remoteAudioTrackStats.map(function (stats) {
      return rewriteTrackId(pcv2, stats);
    }),
    remoteVideoTrackStats: response.remoteVideoTrackStats.map(function (stats) {
      return rewriteTrackId(pcv2, stats);
    }),
    localAudioTrackStats: response.localAudioTrackStats.map(function (stats) {
      return rewriteLocalTrackId(pcv2, stats);
    }),
    localVideoTrackStats: response.localVideoTrackStats.map(function (stats) {
      return rewriteLocalTrackId(pcv2, stats);
    })
  });
}

/**
 * @event PeerConnectionV2#candidates
 * @param {object} candidates
 */

/**
 * @event PeerConnectionV2#connectionStateChanged
 */

/**
 * @event PeerConnectionV2#description
 * @param {object} description
 */

/**
 * @event PeerConnectionV2#iceConnectionStateChanged
 */

/**
 * @event PeerConnectionV2#trackAdded
 * @param {DataTrackReceiver|MediaTrackReceiver} trackReceiver
 */

function getUfrag(description) {
  if (description.sdp) {
    var match = description.sdp.match(/^a=ice-ufrag:([a-zA-Z0-9+/]+)/m);
    if (match) {
      return match[1];
    }
  }
  return null;
}

function getConfiguration(configuration) {
  return Object.assign({
    bundlePolicy: 'max-bundle',
    rtcpMuxPolicy: 'require'
  }, configuration);
}

/**
 * Whether the MediaStreamTrack of the given RTCRTPSender is a non-ended
 * MediaStreamTrack of a given kind.
 * @private
 * @param {string} kind
 * @param {RTCRtpSender} sender
 * @return {boolean}
 */
function isSenderOfKind(kind, sender) {
  var track = sender.track;
  return track && track.kind === kind && track.readyState !== 'ended';
}

/**
 * Preferred codecs.
 * @typedef {object} PreferredCodecs
 * @property {Array<AudioCodec>} audio
 * @property {Array<VideoCodec>} video
 */

function filterOutMediaStreamIds(sdp) {
  return sdp.replace(/a=msid:[^ ]+ /g, 'a=msid:- ');
}

/**
 * Whether an RTCRtpTransceiver can be recycled.
 * @param {RTCRtpTransceiver} transceiver
 * @returns {boolean}
 */
function shouldRecycleTransceiver(transceiver, pcv2) {
  return !transceiver.stopped && !pcv2._replaceTrackPromises.has(transceiver) && ['inactive', 'recvonly'].includes(transceiver.direction);
}

/**
 * Take a recycled RTCRtpTransceiver if available.
 * @param {PeerConnectionV2} pcv2
 * @param {Track.Kind} kind
 * @returns {?RTCRtpTransceiver}
 */
function takeRecycledTransceiver(pcv2, kind) {
  var preferredCodecs = {
    audio: pcv2._preferredAudioCodecs.map(function (_ref10) {
      var codec = _ref10.codec;
      return codec.toLowerCase();
    }),
    video: pcv2._preferredVideoCodecs.map(function (_ref11) {
      var codec = _ref11.codec;
      return codec.toLowerCase();
    })
  }[kind];

  var recycledTransceivers = pcv2._recycledTransceivers[kind];
  var localCodec = preferredCodecs.find(function (codec) {
    return pcv2._localCodecs.has(codec);
  });
  if (!localCodec) {
    return recycledTransceivers.shift();
  }

  var transceiver = recycledTransceivers.find(function (transceiver) {
    var remoteCodecMap = pcv2._remoteCodecMaps.get(transceiver.mid);
    return remoteCodecMap && remoteCodecMap.has(localCodec);
  });

  if (transceiver) {
    recycledTransceivers.splice(recycledTransceivers.indexOf(transceiver), 1);
  }
  return transceiver;
}

/**
 * Update the set of locally supported {@link Codec}s.
 * @param pcv2
 * @returns {void}
 */
function updateLocalCodecs(pcv2) {
  var description = pcv2._peerConnection.localDescription;
  if (!description) {
    return;
  }
  getMediaSections(description.sdp).forEach(function (section) {
    var codecMap = createCodecMapForMediaSection(section);
    codecMap.forEach(function (pts, codec) {
      return pcv2._localCodecs.add(codec);
    });
  });
}

/**
 * Update the {@link Codec} maps for all m= sections in the remote {@link RTCSessionDescription}s.
 * @param {PeerConnectionV2} pcv2
 * @returns {void}
 */
function updateRemoteCodecMaps(pcv2) {
  var description = pcv2._peerConnection.remoteDescription;
  if (!description) {
    return;
  }
  getMediaSections(description.sdp).forEach(function (section) {
    var mid = section.match(/^a=mid:(.+)$/m)[1];
    var codecMap = createCodecMapForMediaSection(section);
    pcv2._remoteCodecMaps.set(mid, codecMap);
  });
}

/**
 * Update the list of recycled RTCRtpTransceivers.
 * @param {PeerConnectionV2} pcv2
 */
function updateRecycledTransceivers(pcv2) {
  pcv2._recycledTransceivers.audio = [];
  pcv2._recycledTransceivers.video = [];
  pcv2._peerConnection.getTransceivers().forEach(function (transceiver) {
    if (shouldRecycleTransceiver(transceiver, pcv2)) {
      var track = transceiver.receiver.track;
      pcv2._recycledTransceivers[track.kind].push(transceiver);
    }
  });
}

/**
 * Perform certain updates after an SDP negotiation is completed.
 * @param {PeerConnectionV2} pcv2
 * @returns {void}
 */
function negotiationCompleted(pcv2) {
  if (pcv2._isUnifiedPlan) {
    updateRecycledTransceivers(pcv2);
    updateLocalCodecs(pcv2);
    updateRemoteCodecMaps(pcv2);
  }
  if (pcv2._isRTCRtpSenderParamsSupported) {
    updateEncodingParameters(pcv2);
  }
}

/**
 * Update the RTCRtpEncodingParameters of all active RTCRtpSenders.
 * @param {PeerConnectionV2} pcv2
 * @returns {void}
 */
function updateEncodingParameters(pcv2) {
  var _pcv2$_encodingParame = pcv2._encodingParameters,
      maxAudioBitrate = _pcv2$_encodingParame.maxAudioBitrate,
      maxVideoBitrate = _pcv2$_encodingParame.maxVideoBitrate;


  var maxBitrates = new Map([['audio', maxAudioBitrate], ['video', maxVideoBitrate]]);

  pcv2._peerConnection.getSenders().filter(function (sender) {
    return sender.track;
  }).forEach(function (sender) {
    var maxBitrate = maxBitrates.get(sender.track.kind);
    var params = sender.getParameters();

    if (maxBitrate === null || maxBitrate === 0) {
      removeMaxBitrate(params);
    } else if (pcv2._isChromeScreenShareTrack(sender.track)) {
      // NOTE(mpatwardhan): Sometimes (JSDK-2557) chrome does not send any bytes on screen track if MaxBitRate is set on it via setParameters,
      // To workaround this issue we will not apply maxBitrate if the track appears to be a screen share track created by chrome
      pcv2._log.warn('Not setting maxBitrate for ' + sender.track.kind + ' Track ' + sender.track.id + ' because it appears to be screen share track: ' + sender.track.label);
    } else {
      setMaxBitrate(params, maxBitrate);
    }

    if (!isFirefox && pcv2._enableDscp && params.encodings.length > 0) {
      // NOTE(mmalavalli): "networkPriority" is a per-sender property and not
      // a per-encoding-layer property. So, we set the value only on the first
      // encoding layer. Any attempt to set the value on subsequent encoding
      // layers (in the case of simulcast) will result in the Promise returned
      // by RTCRtpSender.setParameters() being rejected.
      params.encodings[0].networkPriority = 'high';
    }

    sender.setParameters(params).catch(function (error) {
      pcv2._log.warn('Error while setting encodings parameters for ' + sender.track.kind + ' Track ' + sender.track.id + ': ' + (error.message || error.name));
    });
  });
}

/**
 * Remove maxBitrate from the RTCRtpSendParameters' encodings.
 * @param {RTCRtpSendParameters} params
 * @returns {void}
 */
function removeMaxBitrate(params) {
  if (Array.isArray(params.encodings)) {
    params.encodings.forEach(function (encoding) {
      return delete encoding.maxBitrate;
    });
  }
}

/**
 * Set the given maxBitrate in the RTCRtpSendParameters' encodings.
 * @param {RTCRtpSendParameters} params
 * @param {number} maxBitrate
 * @returns {void}
 */
function setMaxBitrate(params, maxBitrate) {
  if (isFirefox) {
    params.encodings = [{ maxBitrate: maxBitrate }];
  } else {
    params.encodings.forEach(function (encoding) {
      encoding.maxBitrate = maxBitrate;
    });
  }
}
module.exports = PeerConnectionV2;
},{"../../data/receiver":5,"../../media/track/receiver":28,"../../statemachine":73,"../../util":114,"../../util/constants":108,"../../util/log":118,"../../util/sdp":120,"../../util/sdp/issue8329":121,"../../util/sdp/trackmatcher/identity":123,"../../util/sdp/trackmatcher/mid":124,"../../util/sdp/trackmatcher/ordered":125,"../../util/timeout":127,"../../util/twilio-video-errors":128,"./icebox":57,"./iceconnectionmonitor.js":58,"@twilio/webrtc":136,"@twilio/webrtc/lib/util":149,"@twilio/webrtc/lib/util/sdp":151,"backoff":155}],65:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('@twilio/webrtc/lib/util'),
    guessBrowser = _require.guessBrowser;

var PeerConnectionV2 = require('./peerconnection');
var MediaTrackSender = require('../../media/track/sender');
var QueueingEventEmitter = require('../../queueingeventemitter');
var util = require('../../util');

var _require2 = require('../../util/twilio-video-errors'),
    MediaConnectionError = _require2.MediaConnectionError;

var isFirefox = guessBrowser() === 'firefox';

/**
 * {@link PeerConnectionManager} manages multiple {@link PeerConnectionV2}s.
 * @extends QueueingEventEmitter
 * @emits PeerConnectionManager#candidates
 * @emits PeerConnectionManager#connectionStateChanged
 * @emits PeerConnectionManager#description
 * @emits PeerConnectionManager#iceConnectionStateChanged
 * @emits PeerConnectionManager#trackAdded
 */

var PeerConnectionManager = function (_QueueingEventEmitter) {
  _inherits(PeerConnectionManager, _QueueingEventEmitter);

  /**
   * Construct {@link PeerConnectionManager}.
   * @param {EncodingParametersImpl} encodingParameters
   * @param {PreferredCodecs} preferredCodecs
   * @param {object} options
   */
  function PeerConnectionManager(encodingParameters, preferredCodecs, options) {
    _classCallCheck(this, PeerConnectionManager);

    var _this = _possibleConstructorReturn(this, (PeerConnectionManager.__proto__ || Object.getPrototypeOf(PeerConnectionManager)).call(this));

    options = Object.assign({
      audioContextFactory: isFirefox ? require('../../webaudio/audiocontext') : null,
      PeerConnectionV2: PeerConnectionV2
    }, options);

    var audioContext = options.audioContextFactory ? options.audioContextFactory.getOrCreate(_this) : null;

    // NOTE(mroberts): If we're using an AudioContext, we don't need to specify
    // `offerToReceiveAudio` in RTCOfferOptions.
    var offerOptions = audioContext ? { offerToReceiveVideo: true } : { offerToReceiveAudio: true, offerToReceiveVideo: true };

    Object.defineProperties(_this, {
      _audioContextFactory: {
        value: options.audioContextFactory
      },
      _closedPeerConnectionIds: {
        value: new Set()
      },
      _configuration: {
        writable: true,
        value: null
      },
      _configurationDeferred: {
        writable: true,
        value: util.defer()
      },
      _connectionState: {
        value: 'new',
        writable: true
      },
      _dummyAudioTrackSender: {
        value: audioContext ? new MediaTrackSender(createDummyAudioMediaStreamTrack(audioContext)) : null
      },
      _encodingParameters: {
        value: encodingParameters
      },
      _iceConnectionState: {
        writable: true,
        value: 'new'
      },
      _dataTrackSenders: {
        writable: true,
        value: new Set()
      },
      _lastConnectionState: {
        value: 'new',
        writable: true
      },
      _lastIceConnectionState: {
        writable: true,
        value: 'new'
      },
      _mediaTrackSenders: {
        writable: true,
        value: new Set()
      },
      _offerOptions: {
        value: offerOptions
      },
      _peerConnections: {
        value: new Map()
      },
      _preferredCodecs: {
        value: preferredCodecs
      },
      _sessionTimeout: {
        value: null,
        writable: true
      },
      _PeerConnectionV2: {
        value: options.PeerConnectionV2
      }
    });
    return _this;
  }

  /**
   * A summarized RTCPeerConnectionState across all the
   * {@link PeerConnectionManager}'s underlying {@link PeerConnectionV2}s.
   * @property {RTCPeerConnectionState}
   */


  _createClass(PeerConnectionManager, [{
    key: '_closeAbsentPeerConnections',


    /**
     * Close the {@link PeerConnectionV2}s which are no longer relevant.
     * @param {Array<object>} peerConnectionStates
     * @returns {this}
     */
    value: function _closeAbsentPeerConnections(peerConnectionStates) {
      var peerConnectionIds = new Set(peerConnectionStates.map(function (peerConnectionState) {
        return peerConnectionState.id;
      }));
      this._peerConnections.forEach(function (peerConnection) {
        if (!peerConnectionIds.has(peerConnection.id)) {
          peerConnection._close();
        }
      });
      return this;
    }

    /**
     * Get the {@link PeerConnectionManager}'s configuration.
     * @private
     * @returns {Promise<object>}
     */

  }, {
    key: '_getConfiguration',
    value: function _getConfiguration() {
      return this._configurationDeferred.promise;
    }

    /**
     * Get or create a {@link PeerConnectionV2}.
     * @private
     * @param {string} id
     * @param {object} [configuration]
     * @returns {PeerConnectionV2}
     */

  }, {
    key: '_getOrCreate',
    value: function _getOrCreate(id, configuration) {
      var _this2 = this;

      var self = this;
      var peerConnection = this._peerConnections.get(id);
      if (!peerConnection) {
        var _PeerConnectionV = this._PeerConnectionV2;

        var options = Object.assign({
          dummyAudioMediaStreamTrack: this._dummyAudioTrackSender ? this._dummyAudioTrackSender.track : null,
          offerOptions: this._offerOptions
        }, this._sessionTimeout ? {
          sessionTimeout: this._sessionTimeout
        } : {}, configuration);

        try {
          peerConnection = new _PeerConnectionV(id, this._encodingParameters, this._preferredCodecs, options);
        } catch (e) {
          throw new MediaConnectionError();
        }

        this._peerConnections.set(peerConnection.id, peerConnection);
        peerConnection.on('candidates', this.queue.bind(this, 'candidates'));
        peerConnection.on('description', this.queue.bind(this, 'description'));
        peerConnection.on('trackAdded', this.queue.bind(this, 'trackAdded'));
        peerConnection.on('stateChanged', function stateChanged(state) {
          if (state === 'closed') {
            peerConnection.removeListener('stateChanged', stateChanged);
            self._peerConnections.delete(peerConnection.id);
            self._closedPeerConnectionIds.add(peerConnection.id);
            updateConnectionState(self);
            updateIceConnectionState(self);
          }
        });
        peerConnection.on('connectionStateChanged', function () {
          return updateConnectionState(_this2);
        });
        peerConnection.on('iceConnectionStateChanged', function () {
          return updateIceConnectionState(_this2);
        });

        this._dataTrackSenders.forEach(peerConnection.addDataTrackSender, peerConnection);
        this._mediaTrackSenders.forEach(peerConnection.addMediaTrackSender, peerConnection);

        updateIceConnectionState(this);
      }
      return peerConnection;
    }

    /**
     * Close all the {@link PeerConnectionV2}s in this {@link PeerConnectionManager}.
     * @returns {this}
     */

  }, {
    key: 'close',
    value: function close() {
      this._peerConnections.forEach(function (peerConnection) {
        peerConnection.close();
      });
      if (this._dummyAudioTrackSender) {
        this._dummyAudioTrackSender.stop();
      }
      if (this._audioContextFactory) {
        this._audioContextFactory.release(this);
      }
      updateIceConnectionState(this);
      return this;
    }

    /**
     * Create a new {@link PeerConnectionV2} on this {@link PeerConnectionManager}.
     * Then, create a new offer with the newly-created {@link PeerConnectionV2}.
     * @return {Promise<this>}
     */

  }, {
    key: 'createAndOffer',
    value: function createAndOffer() {
      var _this3 = this;

      return this._getConfiguration().then(function (configuration) {
        var id = void 0;
        do {
          id = util.makeUUID();
        } while (_this3._peerConnections.has(id));

        return _this3._getOrCreate(id, configuration);
      }).then(function (peerConnection) {
        return peerConnection.offer();
      }).then(function () {
        return _this3;
      });
    }

    /**
     * Get the {@link DataTrackReceiver}s and {@link MediaTrackReceiver}s of all
     * the {@link PeerConnectionV2}s.
     * @returns {Array<DataTrackReceiver|MediaTrackReceiver>} trackReceivers
     */

  }, {
    key: 'getTrackReceivers',
    value: function getTrackReceivers() {
      return util.flatMap(this._peerConnections, function (peerConnection) {
        return peerConnection.getTrackReceivers();
      });
    }

    /**
     * Get the states of all {@link PeerConnectionV2}s.
     * @returns {Array<object>}
     */

  }, {
    key: 'getStates',
    value: function getStates() {
      var peerConnectionStates = [];
      this._peerConnections.forEach(function (peerConnection) {
        var peerConnectionState = peerConnection.getState();
        if (peerConnectionState) {
          peerConnectionStates.push(peerConnectionState);
        }
      });
      return peerConnectionStates;
    }

    /**
     * Set the {@link PeerConnectionManager}'s configuration.
     * @param {object} configuration
     * @returns {this}
     */

  }, {
    key: 'setConfiguration',
    value: function setConfiguration(configuration) {
      if (this._configuration) {
        this._configurationDeferred = util.defer();
        this._peerConnections.forEach(function (peerConnection) {
          peerConnection.setConfiguration(configuration);
        });
      }
      this._configuration = configuration;
      this._configurationDeferred.resolve(configuration);
      return this;
    }

    /**
     * Set the ICE reconnect timeout period for all {@link PeerConnectionV2}s.
     * @param {number} period - Period in milliseconds.
     * @returns {this}
     */

  }, {
    key: 'setIceReconnectTimeout',
    value: function setIceReconnectTimeout(period) {
      if (this._sessionTimeout === null) {
        this._peerConnections.forEach(function (peerConnection) {
          peerConnection.setIceReconnectTimeout(period);
        });
        this._sessionTimeout = period;
      }
      return this;
    }

    /**
     * Set the {@link DataTrackSender}s and {@link MediaTrackSender}s on the
     * {@link PeerConnectionManager}'s underlying {@link PeerConnectionV2}s.
     * @param {Array<DataTrackSender|MediaTrackSender>} trackSenders
     * @returns {this}
     */

  }, {
    key: 'setTrackSenders',
    value: function setTrackSenders(trackSenders) {
      var dataTrackSenders = new Set(trackSenders.filter(function (trackSender) {
        return trackSender.kind === 'data';
      }));

      var mediaTrackSenders = new Set(trackSenders.filter(function (trackSender) {
        return trackSender && (trackSender.kind === 'audio' || trackSender.kind === 'video');
      }));

      var changes = getTrackSenderChanges(this, dataTrackSenders, mediaTrackSenders);
      this._dataTrackSenders = dataTrackSenders;
      this._mediaTrackSenders = mediaTrackSenders;
      applyTrackSenderChanges(this, changes);

      return this;
    }

    /**
     * Update the {@link PeerConnectionManager}.
     * @param {Array<object>} peerConnectionStates
     * @param {boolean} [synced=false]
     * @returns {Promise<this>}
     */

  }, {
    key: 'update',
    value: function update(peerConnectionStates) {
      var _this4 = this;

      var synced = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

      if (synced) {
        this._closeAbsentPeerConnections(peerConnectionStates);
      }
      return this._getConfiguration().then(function (configuration) {
        return Promise.all(peerConnectionStates.map(function (peerConnectionState) {
          if (_this4._closedPeerConnectionIds.has(peerConnectionState.id)) {
            return null;
          }
          var peerConnection = _this4._getOrCreate(peerConnectionState.id, configuration);
          return peerConnection.update(peerConnectionState);
        }));
      }).then(function () {
        return _this4;
      });
    }

    /**
     * Get the {@link PeerConnectionManager}'s media statistics.
     * @returns {Promise.<Map<PeerConnectionV2#id, StandardizedStatsResponse>>}
     */

  }, {
    key: 'getStats',
    value: function getStats() {
      var peerConnections = Array.from(this._peerConnections.values());
      return Promise.all(peerConnections.map(function (peerConnection) {
        return peerConnection.getStats().then(function (response) {
          return [peerConnection.id, response];
        });
      })).then(function (responses) {
        return new Map(responses);
      });
    }
  }, {
    key: 'connectionState',
    get: function get() {
      return this._connectionState;
    }

    /**
     * A summarized RTCIceConnectionState across all the
     * {@link PeerConnectionManager}'s underlying {@link PeerConnectionV2}s.
     * @property {RTCIceConnectionState}
     */

  }, {
    key: 'iceConnectionState',
    get: function get() {
      return this._iceConnectionState;
    }
  }]);

  return PeerConnectionManager;
}(QueueingEventEmitter);

/**
 * Create a dummy audio MediaStreamTrack with the given AudioContext.
 * @private
 * @param {AudioContext} audioContext
 * @return {MediaStreamTrack}
 */


function createDummyAudioMediaStreamTrack(audioContext) {
  var mediaStreamDestination = audioContext.createMediaStreamDestination();
  return mediaStreamDestination.stream.getAudioTracks()[0];
}

/**
 * @event {PeerConnectionManager#candidates}
 * @param {object} candidates
 */

/**
 * @event {PeerConnectionManager#connectionStateChanged}
 */

/**
 * @event {PeerConnectionManager#description}
 * @param {object} description
 */

/**
 * @event {PeerConnectionManager#iceConnectionStateChanged}
 */

/**
 * @event {PeerConnectionManager#trackAdded}
 * @param {MediaStreamTrack|DataTrackReceiver} mediaStreamTrackOrDataTrackReceiver
 */

/**
 * Apply {@link TrackSenderChanges}.
 * @param {PeerConnectionManager} peerConnectionManager
 * @param {TrackSenderChanges} changes
 * @returns {void}
 */
function applyTrackSenderChanges(peerConnectionManager, changes) {
  if (changes.data.add.size || changes.data.remove.size || changes.media.add.size || changes.media.remove.size) {
    peerConnectionManager._peerConnections.forEach(function (peerConnection) {
      changes.data.remove.forEach(peerConnection.removeDataTrackSender, peerConnection);
      changes.media.remove.forEach(peerConnection.removeMediaTrackSender, peerConnection);
      changes.data.add.forEach(peerConnection.addDataTrackSender, peerConnection);
      changes.media.add.forEach(peerConnection.addMediaTrackSender, peerConnection);
      if (changes.media.add.size || changes.media.remove.size || changes.data.add.size && !peerConnection.isApplicationSectionNegotiated) {
        peerConnection.offer();
      }
    });
  }
}

/**
 * @interface DataTrackSenderChanges
 * @property {Set<DataTrackSender>} add
 * @property {Set<DataTrackSender>} remove
 */

/**
 * Get the {@Link DataTrackSender} changes.
 * @param {PeerConnectionManager} peerConnectionManager
 * @param {Array<DataTrackSender>} dataTrackSenders
 * @returns {DataTrackSenderChanges} changes
 */
function getDataTrackSenderChanges(peerConnectionManager, dataTrackSenders) {
  var dataTrackSendersToAdd = util.difference(dataTrackSenders, peerConnectionManager._dataTrackSenders);
  var dataTrackSendersToRemove = util.difference(peerConnectionManager._dataTrackSenders, dataTrackSenders);
  return {
    add: dataTrackSendersToAdd,
    remove: dataTrackSendersToRemove
  };
}

/**
 * @interface TrackSenderChanges
 * @property {DataTrackSenderChanges} data
 * @property {MediaTrackSenderChanges} media
 */

/**
 * Get {@link DataTrackSender} and {@link MediaTrackSender} changes.
 * @param {PeerConnectionManager} peerConnectionManager
 * @param {Array<DataTrackSender>} dataTrackSenders
 * @param {Array<MediaTrackSender>} mediaTrackSenders
 * @returns {TrackSenderChanges} changes
 */
function getTrackSenderChanges(peerConnectionManager, dataTrackSenders, mediaTrackSenders) {
  return {
    data: getDataTrackSenderChanges(peerConnectionManager, dataTrackSenders),
    media: getMediaTrackSenderChanges(peerConnectionManager, mediaTrackSenders)
  };
}

/**
 * @interface MediaTrackSenderChanges
 * @property {Set<MediaTrackSender>} add
 * @property {Set<MediaTrackSender>} remove
 */

/**
 * Get the {@link MediaTrackSender} changes.
 * @param {PeerConnectionManager} peerConnectionManager
 * @param {Array<MediaTrackSender>} mediaTrackSenders
 * @returns {MediaTrackSenderChanges} changes
 */
function getMediaTrackSenderChanges(peerConnectionManager, mediaTrackSenders) {
  var mediaTrackSendersToAdd = util.difference(mediaTrackSenders, peerConnectionManager._mediaTrackSenders);
  var mediaTrackSendersToRemove = util.difference(peerConnectionManager._mediaTrackSenders, mediaTrackSenders);
  return {
    add: mediaTrackSendersToAdd,
    remove: mediaTrackSendersToRemove
  };
}

/**
 * This object maps RTCIceConnectionState and RTCPeerConnectionState values to a "rank".
 */
var toRank = {
  new: 0,
  checking: 1,
  connecting: 2,
  connected: 3,
  completed: 4,
  disconnected: -1,
  failed: -2,
  closed: -3
};

/**
 * This object maps "rank" back to RTCIceConnectionState or RTCPeerConnectionState values.
 */
var fromRank = void 0;

/**
 * `Object.keys` is not supported in older browsers, so we can't just
 * synchronously call it in this module; we need to defer invoking it until we
 * know we're in a modern environment (i.e., anything that supports WebRTC).
 * @returns {object} fromRank
 */
function createFromRank() {
  return Object.keys(toRank).reduce(function (fromRank, state) {
    return Object.assign(fromRank, _defineProperty({}, toRank[state], state));
  }, {});
}

/**
 * Summarize RTCIceConnectionStates or RTCPeerConnectionStates.
 * @param {Array<RTCIceConnectionState>|Array<RTCPeerConnectionState>} states
 * @returns {RTCIceConnectionState|RTCPeerConnectionState} summary
 */
function summarizeIceOrPeerConnectionStates(states) {
  if (!states.length) {
    return 'new';
  }
  fromRank = fromRank || createFromRank();
  return states.reduce(function (state1, state2) {
    return fromRank[Math.max(toRank[state1], toRank[state2])];
  });
}

/**
 * Update the {@link PeerConnectionManager}'s `iceConnectionState`, and emit an
 * "iceConnectionStateChanged" event, if necessary.
 * @param {PeerConnectionManager} pcm
 * @returns {void}
 */
function updateIceConnectionState(pcm) {
  pcm._lastIceConnectionState = pcm.iceConnectionState;
  pcm._iceConnectionState = summarizeIceOrPeerConnectionStates([].concat(_toConsumableArray(pcm._peerConnections.values())).map(function (pcv2) {
    return pcv2.iceConnectionState;
  }));
  if (pcm.iceConnectionState !== pcm._lastIceConnectionState) {
    pcm.emit('iceConnectionStateChanged');
  }
}

/**
 * Update the {@link PeerConnectionManager}'s `connectionState`, and emit a
 * "connectionStateChanged" event, if necessary.
 * @param {PeerConnectionManager} pcm
 * @returns {void}
 */
function updateConnectionState(pcm) {
  pcm._lastConnectionState = pcm.connectionState;
  pcm._connectionState = summarizeIceOrPeerConnectionStates([].concat(_toConsumableArray(pcm._peerConnections.values())).map(function (pcv2) {
    return pcv2.connectionState;
  }));
  if (pcm.connectionState !== pcm._lastConnectionState) {
    pcm.emit('connectionStateChanged');
  }
}

module.exports = PeerConnectionManager;
},{"../../media/track/sender":37,"../../queueingeventemitter":43,"../../util":114,"../../util/twilio-video-errors":128,"../../webaudio/audiocontext":131,"./peerconnection":64,"@twilio/webrtc/lib/util":149}],66:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var RecordingSignaling = require('../recording');

/**
 * @extends RecordingSignaling
 */

var RecordingV2 = function (_RecordingSignaling) {
  _inherits(RecordingV2, _RecordingSignaling);

  /**
   * Construct a {@link RecordingV2}.
   */
  function RecordingV2() {
    _classCallCheck(this, RecordingV2);

    var _this = _possibleConstructorReturn(this, (RecordingV2.__proto__ || Object.getPrototypeOf(RecordingV2)).call(this));

    Object.defineProperties(_this, {
      _revision: {
        value: 1,
        writable: true
      }
    });
    return _this;
  }

  /**
   * Compare the {@link RecordingV2} to a {@link RecordingV2#Representation}
   * of itself and perform any updates necessary.
   * @param {RecordingV2#Representation} recording
   * @returns {this}
   * @fires RecordingSignaling#updated
   */


  _createClass(RecordingV2, [{
    key: 'update',
    value: function update(recording) {
      if (recording.revision < this._revision) {
        return this;
      }
      this._revision = recording.revision;
      return this.enable(recording.is_recording);
    }
  }]);

  return RecordingV2;
}(RecordingSignaling);

/**
 * The Room Signaling Protocol (RSP) representation of a {@link RecordingV2}
 * @typedef {object} RecordingV2#Representation
 * @property {boolean} enabled
 * @property {number} revision
 */

module.exports = RecordingV2;
},{"../recording":50}],67:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var RemoteParticipantSignaling = require('../remoteparticipant');
var RemoteTrackPublicationV2 = require('./remotetrackpublication');

/**
 * @extends RemoteParticipantSignaling
 * @property {?number} revision
 */

var RemoteParticipantV2 = function (_RemoteParticipantSig) {
  _inherits(RemoteParticipantV2, _RemoteParticipantSig);

  /**
   * Construct a {@link RemoteParticipantV2}.
   * @param {object} participantState
   * @param {function(string): Promise<DataTrackReceiver|MediaTrackReceiver>} getTrackReceiver
   * @param {object} [options]
   */
  function RemoteParticipantV2(participantState, getTrackReceiver, options) {
    var _ret;

    _classCallCheck(this, RemoteParticipantV2);

    var _this = _possibleConstructorReturn(this, (RemoteParticipantV2.__proto__ || Object.getPrototypeOf(RemoteParticipantV2)).call(this, participantState.sid, participantState.identity));

    options = Object.assign({
      RemoteTrackPublicationV2: RemoteTrackPublicationV2
    }, options);

    Object.defineProperties(_this, {
      _revision: {
        writable: true,
        value: null
      },
      _RemoteTrackPublicationV2: {
        value: options.RemoteTrackPublicationV2
      },
      _getTrackReceiver: {
        value: getTrackReceiver
      },
      revision: {
        enumerable: true,
        get: function get() {
          return this._revision;
        }
      }
    });

    return _ret = _this.update(participantState), _possibleConstructorReturn(_this, _ret);
  }

  /**
   * @private
   */


  _createClass(RemoteParticipantV2, [{
    key: '_getOrCreateTrack',
    value: function _getOrCreateTrack(trackState) {
      var RemoteTrackPublicationV2 = this._RemoteTrackPublicationV2;
      var track = this.tracks.get(trackState.sid);
      if (!track) {
        track = new RemoteTrackPublicationV2(trackState);
        this.addTrack(track);
      }
      return track;
    }

    /**
     * Update the {@link RemoteParticipantV2} with the new state.
     * @param {object} participantState
     * @returns {this}
     */

  }, {
    key: 'update',
    value: function update(participantState) {
      var _this2 = this;

      if (this.revision !== null && participantState.revision <= this.revision) {
        return this;
      }
      this._revision = participantState.revision;

      var tracksToKeep = new Set();

      participantState.tracks.forEach(function (trackState) {
        var track = _this2._getOrCreateTrack(trackState);
        track.update(trackState);
        tracksToKeep.add(track);
      });

      this.tracks.forEach(function (track) {
        if (!tracksToKeep.has(track)) {
          _this2.removeTrack(track);
        }
      });

      switch (participantState.state) {
        case 'disconnected':
          this.disconnect();
          break;
        case 'reconnecting':
          this.reconnecting();
          break;
        case 'connected':
          this.connect(this.sid, this.identity);
          break;
      }

      return this;
    }
  }]);

  return RemoteParticipantV2;
}(RemoteParticipantSignaling);

module.exports = RemoteParticipantV2;
},{"../remoteparticipant":51,"./remotetrackpublication":68}],68:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var RemoteTrackPublicationSignaling = require('../remotetrackpublication');

/**
 * @extends RemoteTrackPublicationSignaling
 */

var RemoteTrackPublicationV2 = function (_RemoteTrackPublicati) {
  _inherits(RemoteTrackPublicationV2, _RemoteTrackPublicati);

  /**
   * Construct a {@link RemoteTrackPublicationV2}.
   * @param {RemoteTrackPublicationV2#Representation} track
   */
  function RemoteTrackPublicationV2(track) {
    _classCallCheck(this, RemoteTrackPublicationV2);

    return _possibleConstructorReturn(this, (RemoteTrackPublicationV2.__proto__ || Object.getPrototypeOf(RemoteTrackPublicationV2)).call(this, track.sid, track.name, track.kind, track.enabled, track.priority));
  }

  /**
   * Compare the {@link RemoteTrackPublicationV2} to a
   * {@link RemoteTrackPublicationV2#Representation} of itself and perform any
   * updates necessary.
   * @param {RemoteTrackPublicationV2#Representation} track
   * @returns {this}
   * @fires TrackSignaling#updated
   */


  _createClass(RemoteTrackPublicationV2, [{
    key: 'update',
    value: function update(track) {
      this.enable(track.enabled);
      this.setPriority(track.priority);
      return this;
    }
  }]);

  return RemoteTrackPublicationV2;
}(RemoteTrackPublicationSignaling);

/**
 * The Room Signaling Protocol (RSP) representation of a {@link RemoteTrackPublicationV2}.
 * @typedef {LocalTrackPublicationV2#Representation} RemoteTrackPublicationV2#Representation
 * @property {boolean} subscribed
 */

module.exports = RemoteTrackPublicationV2;
},{"../remotetrackpublication":52}],69:[function(require,module,exports){
'use strict';

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var DominantSpeakerSignaling = require('./dominantspeakersignaling');
var NetworkQualityMonitor = require('./networkqualitymonitor');
var NetworkQualitySignaling = require('./networkqualitysignaling');
var RecordingV2 = require('./recording');
var RoomSignaling = require('../room');
var RemoteParticipantV2 = require('./remoteparticipant');
var StatsReport = require('../../stats/statsreport');
var TrackPrioritySignaling = require('./trackprioritysignaling');
var TrackSwitchOffSignaling = require('./trackswitchoffsignaling');

var _require = require('../../util'),
    DEFAULT_SESSION_TIMEOUT_SEC = _require.constants.DEFAULT_SESSION_TIMEOUT_SEC,
    createBandwidthProfilePayload = _require.createBandwidthProfilePayload,
    defer = _require.defer,
    filterObject = _require.filterObject,
    flatMap = _require.flatMap,
    oncePerTick = _require.oncePerTick;

var _require2 = require('../../util/twilio-video-errors'),
    createTwilioError = _require2.createTwilioError;

var STATS_PUBLISH_INTERVAL_MS = 10000;

/**
 * @extends RoomSignaling
 */

var RoomV2 = function (_RoomSignaling) {
  _inherits(RoomV2, _RoomSignaling);

  function RoomV2(localParticipant, initialState, transport, peerConnectionManager, options) {
    _classCallCheck(this, RoomV2);

    initialState.options = Object.assign({
      session_timeout: DEFAULT_SESSION_TIMEOUT_SEC
    }, initialState.options);

    options = Object.assign({
      DominantSpeakerSignaling: DominantSpeakerSignaling,
      NetworkQualityMonitor: NetworkQualityMonitor,
      NetworkQualitySignaling: NetworkQualitySignaling,
      RecordingSignaling: RecordingV2,
      RemoteParticipantV2: RemoteParticipantV2,
      TrackPrioritySignaling: TrackPrioritySignaling,
      TrackSwitchOffSignaling: TrackSwitchOffSignaling,
      bandwidthProfile: null,
      sessionTimeout: initialState.options.session_timeout * 1000,
      statsPublishIntervalMs: STATS_PUBLISH_INTERVAL_MS
    }, options);

    localParticipant.setBandwidthProfile(options.bandwidthProfile);
    peerConnectionManager.setIceReconnectTimeout(options.sessionTimeout);

    var _this = _possibleConstructorReturn(this, (RoomV2.__proto__ || Object.getPrototypeOf(RoomV2)).call(this, localParticipant, initialState.sid, initialState.name, options));

    Object.defineProperties(_this, {
      _dominantSpeakerSignaling: {
        value: null,
        writable: true
      },
      _DominantSpeakerSignaling: {
        value: options.DominantSpeakerSignaling
      },
      _dominantSpeakerSignalingPromise: {
        value: null,
        writable: true
      },
      _disconnectedParticipantSids: {
        value: new Set()
      },
      _NetworkQualityMonitor: {
        value: options.NetworkQualityMonitor
      },
      _NetworkQualitySignaling: {
        value: options.NetworkQualitySignaling
      },
      _lastBandwidthProfileRevision: {
        value: localParticipant.bandwidthProfileRevision,
        writable: true
      },
      _networkQualityMonitor: {
        value: null,
        writable: true
      },
      _networkQualityMonitorPromise: {
        value: null,
        writable: true
      },
      _networkQualityConfiguration: {
        value: localParticipant.networkQualityConfiguration
      },
      _peerConnectionManager: {
        value: peerConnectionManager
      },
      _published: {
        value: new Map()
      },
      _publishedRevision: {
        value: 0,
        writable: true
      },
      _RemoteParticipantV2: {
        value: options.RemoteParticipantV2
      },
      _subscribed: {
        value: new Map()
      },
      _subscribedRevision: {
        value: 0,
        writable: true
      },
      _subscriptionFailures: {
        value: new Map()
      },
      _trackPriorityPromise: {
        value: null,
        writable: true
      },
      _trackPrioritySignaling: {
        value: null,
        writable: true
      },
      _trackSwitchOffPromise: {
        value: null,
        writable: true
      },
      _trackSwitchOffSignaling: {
        value: null,
        writable: true
      },
      _TrackPrioritySignaling: {
        value: options.TrackPrioritySignaling
      },
      _TrackSwitchOffSignaling: {
        value: options.TrackSwitchOffSignaling
      },
      _transport: {
        value: transport
      },
      _trackReceiverDeferreds: {
        value: new Map()
      },
      mediaRegion: {
        enumerable: true,
        value: initialState.options.media_region || null
      }
    });

    handleLocalParticipantEvents(_this, localParticipant);
    handlePeerConnectionEvents(_this, peerConnectionManager);
    handleTransportEvents(_this, transport);
    periodicallyPublishStats(_this, transport, options.statsPublishIntervalMs);

    _this._update(initialState);
    return _this;
  }

  /**
   * The PeerConnection state.
   * @property {RTCPeerConnectionState}
   */


  _createClass(RoomV2, [{
    key: '_deleteTrackReceiverDeferred',


    /**
     * @private
     */
    value: function _deleteTrackReceiverDeferred(id) {
      return this._trackReceiverDeferreds.delete(id);
    }

    /**
     * @private
     */

  }, {
    key: '_getOrCreateTrackReceiverDeferred',
    value: function _getOrCreateTrackReceiverDeferred(id) {
      var deferred = this._trackReceiverDeferreds.get(id) || defer();
      var trackReceivers = this._peerConnectionManager.getTrackReceivers();

      // NOTE(mmalavalli): In Firefox, there can be instances where a MediaStreamTrack
      // for the given Track ID already exists, for example, when a Track is removed
      // and added back. If that is the case, then we should resolve 'deferred'.
      var trackReceiver = trackReceivers.find(function (trackReceiver) {
        return trackReceiver.id === id && trackReceiver.readyState !== 'ended';
      });

      if (trackReceiver) {
        deferred.resolve(trackReceiver);
      } else {
        // NOTE(mmalavalli): Only add the 'deferred' to the map if it's not
        // resolved. This will prevent old copies of the MediaStreamTrack from
        // being used when the remote peer removes and re-adds a MediaStreamTrack.
        this._trackReceiverDeferreds.set(id, deferred);
      }

      return deferred;
    }

    /**
     * @private
     */

  }, {
    key: '_addTrackReceiver',
    value: function _addTrackReceiver(trackReceiver) {
      var deferred = this._getOrCreateTrackReceiverDeferred(trackReceiver.id);
      deferred.resolve(trackReceiver);
      return this;
    }

    /**
     * @private
     */

  }, {
    key: '_disconnect',
    value: function _disconnect(error) {
      var didDisconnect = _get(RoomV2.prototype.__proto__ || Object.getPrototypeOf(RoomV2.prototype), '_disconnect', this).call(this, error);
      if (didDisconnect) {
        this._teardownDominantSpeakerSignaling();
        this._teardownNetworkQualityMonitor();
        this._transport.disconnect();
        this._peerConnectionManager.close();
      }

      this.localParticipant.tracks.forEach(function (track) {
        track.publishFailed(error || new Error('LocalParticipant disconnected'));
      });

      return didDisconnect;
    }

    /**
     * @private
     */

  }, {
    key: '_getTrackReceiver',
    value: function _getTrackReceiver(id) {
      var _this2 = this;

      return this._getOrCreateTrackReceiverDeferred(id).promise.then(function (trackReceiver) {
        _this2._deleteTrackReceiverDeferred(id);
        return trackReceiver;
      });
    }

    /**
     * @private
     */

  }, {
    key: '_getTrackSidsToTrackSignalings',
    value: function _getTrackSidsToTrackSignalings() {
      var trackSidsToTrackSignalings = flatMap(this.participants, function (participant) {
        return Array.from(participant.tracks);
      });
      return new Map(trackSidsToTrackSignalings);
    }

    /**
     * @private
     */

  }, {
    key: '_getOrCreateRemoteParticipant',
    value: function _getOrCreateRemoteParticipant(participantState) {
      var RemoteParticipantV2 = this._RemoteParticipantV2;
      var participant = this.participants.get(participantState.sid);
      var self = this;
      if (!participant) {
        participant = new RemoteParticipantV2(participantState, this._getTrackReceiver.bind(this));
        participant.on('stateChanged', function stateChanged(state) {
          if (state === 'disconnected') {
            participant.removeListener('stateChanged', stateChanged);
            self.participants.delete(participant.sid);
            self._disconnectedParticipantSids.add(participant.sid);
          }
        });
        this.connectParticipant(participant);
        participant.setTrackPrioritySignaling(this._trackPrioritySignaling);
      }
      return participant;
    }

    /**
     * @private
     */

  }, {
    key: '_getState',
    value: function _getState() {
      return {
        participant: this.localParticipant.getState()
      };
    }

    /**
     * @private
     */

  }, {
    key: '_maybeAddBandwidthProfile',
    value: function _maybeAddBandwidthProfile(update) {
      var _localParticipant = this.localParticipant,
          bandwidthProfile = _localParticipant.bandwidthProfile,
          bandwidthProfileRevision = _localParticipant.bandwidthProfileRevision;

      if (bandwidthProfile && this._lastBandwidthProfileRevision < bandwidthProfileRevision) {
        this._lastBandwidthProfileRevision = bandwidthProfileRevision;
        return Object.assign({
          bandwidth_profile: createBandwidthProfilePayload(bandwidthProfile)
        }, update);
      }
      return update;
    }
    /**
     * @private
     */

  }, {
    key: '_publishNewLocalParticipantState',
    value: function _publishNewLocalParticipantState() {
      this._transport.publish(this._maybeAddBandwidthProfile(this._getState()));
    }

    /**
     * @private
     */

  }, {
    key: '_publishPeerConnectionState',
    value: function _publishPeerConnectionState(peerConnectionState) {
      /* eslint camelcase:0 */
      this._transport.publish(Object.assign({
        peer_connections: [peerConnectionState]
      }, this._getState()));
    }

    /**
     * @private
     */

  }, {
    key: '_update',
    value: function _update(roomState) {
      var _this3 = this;

      if (roomState.subscribed && roomState.subscribed.revision > this._subscribedRevision) {
        this._subscribedRevision = roomState.subscribed.revision;
        roomState.subscribed.tracks.forEach(function (trackState) {
          if (trackState.id) {
            _this3._subscriptionFailures.delete(trackState.sid);
            _this3._subscribed.set(trackState.sid, trackState.id);
          } else if (trackState.error && !_this3._subscriptionFailures.has(trackState.sid)) {
            _this3._subscriptionFailures.set(trackState.sid, trackState.error);
          }
        });

        var subscribedTrackSids = new Set(roomState.subscribed.tracks.filter(function (trackState) {
          return !!trackState.id;
        }).map(function (trackState) {
          return trackState.sid;
        }));

        this._subscribed.forEach(function (trackId, trackSid) {
          if (!subscribedTrackSids.has(trackSid)) {
            _this3._subscribed.delete(trackSid);
          }
        });
      }

      var participantsToKeep = new Set();

      // eslint-disable-next-line no-warning-comments
      // TODO(mroberts): Remove me once the Server is fixed.
      (roomState.participants || []).forEach(function (participantState) {
        if (participantState.sid === _this3.localParticipant.sid || _this3._disconnectedParticipantSids.has(participantState.sid)) {
          return;
        }
        var participant = _this3._getOrCreateRemoteParticipant(participantState);
        participant.update(participantState);
        participantsToKeep.add(participant);
      });

      if (roomState.type === 'synced') {
        this.participants.forEach(function (participant) {
          if (!participantsToKeep.has(participant)) {
            participant.disconnect();
          }
        });
      }

      handleSubscriptions(this);

      // eslint-disable-next-line no-warning-comments
      // TODO(mroberts): Remove me once the Server is fixed.
      /* eslint camelcase:0 */
      if (roomState.peer_connections) {
        this._peerConnectionManager.update(roomState.peer_connections, roomState.type === 'synced');
      }

      if (roomState.recording) {
        this.recording.update(roomState.recording);
      }

      if (roomState.published && roomState.published.revision > this._publishedRevision) {
        this._publishedRevision = roomState.published.revision;
        roomState.published.tracks.forEach(function (track) {
          if (track.sid) {
            _this3._published.set(track.id, track.sid);
          }
        });
        this.localParticipant.update(roomState.published);
      }

      if (roomState.participant) {
        this.localParticipant.connect(roomState.participant.sid, roomState.participant.identity);
      }

      if (!this._dominantSpeakerSignalingPromise && roomState.media_signaling && roomState.media_signaling.active_speaker && roomState.media_signaling.active_speaker.transport && roomState.media_signaling.active_speaker.transport.type === 'data-channel') {
        this._setupDataTransportBackedDominantSpeakerSignaling(roomState.media_signaling.active_speaker.transport.label);
      }

      if (!this._networkQualityMonitorPromise && roomState.media_signaling && roomState.media_signaling.network_quality && roomState.media_signaling.network_quality.transport && roomState.media_signaling.network_quality.transport.type === 'data-channel') {
        this._setupDataTransportBackedNetworkQualityMonitor(roomState.media_signaling.network_quality.transport.label);
      }

      if (!this._trackPriorityPromise && roomState.media_signaling && roomState.media_signaling.track_priority && roomState.media_signaling.track_priority.transport && roomState.media_signaling.track_priority.transport.type === 'data-channel') {
        this._setupTrackPrioritySignaling(roomState.media_signaling.track_priority.transport.label);
      }

      if (!this._trackSwitchOffPromise && roomState.media_signaling && roomState.media_signaling.track_switch_off && roomState.media_signaling.track_switch_off.transport && roomState.media_signaling.track_switch_off.transport.type === 'data-channel') {
        this._setupTrackSwitchOffMonitor(roomState.media_signaling.track_switch_off.transport.label);
      }

      return this;
    }

    // track priority signaling MSP is now used only for subscribe side priority changes.
    // publisher side priority changes and notifications are handled by RSP.

  }, {
    key: '_setupTrackPrioritySignaling',
    value: function _setupTrackPrioritySignaling(id) {
      var _this4 = this;

      this._teardownTrackPrioritySignaling();
      var trackPriorityPromise = this._getTrackReceiver(id).then(function (receiver) {
        if (receiver.kind !== 'data') {
          throw new Error('Expected a DataTrackReceiver');
        }if (_this4._trackPriorityPromise !== trackPriorityPromise) {
          return;
        }

        // NOTE(mmalavalli): The underlying RTCDataChannel is closed whenever
        // the VMS instance fails over, and a new RTCDataChannel is created in order
        // to resume sending Track Priority updates.
        receiver.once('close', function () {
          return _this4._teardownTrackPrioritySignaling();
        });

        _this4._trackPrioritySignaling = new _this4._TrackPrioritySignaling(receiver.toDataTransport());
        [].concat(_toConsumableArray(_this4.participants.values())).forEach(function (participant) {
          participant.setTrackPrioritySignaling(_this4._trackPrioritySignaling);
        });
      });
      this._trackPriorityPromise = trackPriorityPromise;
    }
  }, {
    key: '_setupTrackSwitchOff',
    value: function _setupTrackSwitchOff(trackSwitchOffSignaling) {
      var _this5 = this;

      this._trackSwitchOffSignaling = trackSwitchOffSignaling;
      trackSwitchOffSignaling.on('updated', function (tracksOff, tracksOn) {
        _this5.participants.forEach(function (participant) {
          participant.tracks.forEach(function (track) {
            if (tracksOff.includes(track.sid)) {
              track.setSwitchedOff(true);
            }
            if (tracksOn.includes(track.sid)) {
              track.setSwitchedOff(false);
            }
          });
        });
      });
    }
  }, {
    key: '_setupTrackSwitchOffMonitor',
    value: function _setupTrackSwitchOffMonitor(id) {
      var _this6 = this;

      this._teardownTrackSwitchOff();
      var trackSwitchOffPromise = this._getTrackReceiver(id).then(function (receiver) {
        if (receiver.kind !== 'data') {
          throw new Error('Expected a DataTrackReceiver');
        }if (_this6._trackSwitchOffPromise !== trackSwitchOffPromise) {
          return;
        }

        // NOTE(mpatwardhan): The underlying RTCDataChannel is closed whenever
        // the VMS instance fails over, and a new RTCDataChannel is created in order
        // to resume sending Dominant Speaker updates.
        receiver.once('close', function () {
          return _this6._teardownTrackSwitchOff();
        });

        var trackSwitchOffSignaling = new _this6._TrackSwitchOffSignaling(receiver.toDataTransport());
        _this6._setupTrackSwitchOff(trackSwitchOffSignaling);
      });
      this._trackSwitchOffPromise = trackSwitchOffPromise;
    }

    /**
     * Create a {@link DataTransport}-backed {@link DominantSpeakerSignaling}.
     * @private
     * @param {ID} id - ID of the {@link DataTrackReceiver} that will ultimately
     *   be converted into a {@link DataTrackTransport} for use with
     *   {@link DominantSpeakerSignaling}
     * @returns {Promise<void>}
     */

  }, {
    key: '_setupDataTransportBackedDominantSpeakerSignaling',
    value: function _setupDataTransportBackedDominantSpeakerSignaling(id) {
      var _this7 = this;

      this._teardownDominantSpeakerSignaling();
      var dominantSpeakerSignalingPromise = this._getTrackReceiver(id).then(function (receiver) {
        if (receiver.kind !== 'data') {
          throw new Error('Expected a DataTrackReceiver');
        }if (_this7._dominantSpeakerSignalingPromise !== dominantSpeakerSignalingPromise) {
          // NOTE(mroberts): _teardownDominantSpeakerSignaling was called.
          return;
        }

        // NOTE(mpatwardhan): The underlying RTCDataChannel is closed whenever
        // the VMS instance fails over, and a new RTCDataChannel is created in order
        // to resume sending Dominant Speaker updates.
        receiver.once('close', function () {
          return _this7._teardownDominantSpeakerSignaling();
        });

        var dominantSpeakerSignaling = new _this7._DominantSpeakerSignaling(receiver.toDataTransport());
        _this7._setDominantSpeakerSignaling(dominantSpeakerSignaling);
      });
      this._dominantSpeakerSignalingPromise = dominantSpeakerSignalingPromise;
    }
    /**
     * Create a {@link DataTransport}-backed {@link NetworkQualityMonitor}.
     * @private
     * @param {ID} id - ID of the {@link DataTrackReceiver} that will ultimately
     *   be converted into a {@link DataTrackTransport} for use with
     *   {@link NetworkQualitySignaling}
     * @returns {Promise<void>}
     */

  }, {
    key: '_setupDataTransportBackedNetworkQualityMonitor',
    value: function _setupDataTransportBackedNetworkQualityMonitor(id) {
      var _this8 = this;

      var self = this;
      this._teardownNetworkQualityMonitor();
      var networkQualityMonitorPromise = this._getTrackReceiver(id).then(function (receiver) {
        if (receiver.kind !== 'data') {
          throw new Error('Expected a DataTrackReceiver');
        }if (_this8._networkQualityMonitorPromise !== networkQualityMonitorPromise) {
          // NOTE(mroberts): _teardownNetworkQualityMonitor was called.
          return;
        }

        // NOTE(mpatwardhan): The underlying RTCDataChannel is closed whenever
        // the VMS instance fails over, and new a RTCDataChannel is created in order
        // to resume exchanging Network Quality messages.
        receiver.once('close', function () {
          return _this8._teardownNetworkQualityMonitor();
        });

        var networkQualitySignaling = new _this8._NetworkQualitySignaling(receiver.toDataTransport(), self._networkQualityConfiguration);
        var networkQualityMonitor = new _this8._NetworkQualityMonitor(_this8._peerConnectionManager, networkQualitySignaling);
        _this8._setNetworkQualityMonitor(networkQualityMonitor);
      });
      this._networkQualityMonitorPromise = networkQualityMonitorPromise;
    }
  }, {
    key: '_setDominantSpeakerSignaling',
    value: function _setDominantSpeakerSignaling(dominantSpeakerSignaling) {
      var _this9 = this;

      this._dominantSpeakerSignaling = dominantSpeakerSignaling;
      dominantSpeakerSignaling.on('updated', function () {
        return _this9.setDominantSpeaker(dominantSpeakerSignaling.loudestParticipantSid);
      });
    }
  }, {
    key: '_setNetworkQualityMonitor',
    value: function _setNetworkQualityMonitor(networkQualityMonitor) {
      var _this10 = this;

      this._networkQualityMonitor = networkQualityMonitor;
      networkQualityMonitor.on('updated', function () {
        if (_this10.iceConnectionState === 'failed') {
          return;
        }
        _this10.localParticipant.setNetworkQualityLevel(networkQualityMonitor.level, networkQualityMonitor.levels);
        _this10.participants.forEach(function (participant) {
          var levels = networkQualityMonitor.remoteLevels.get(participant.sid);
          if (levels) {
            participant.setNetworkQualityLevel(levels.level, levels);
          }
        });
      });
      networkQualityMonitor.start();
    }
  }, {
    key: '_teardownDominantSpeakerSignaling',
    value: function _teardownDominantSpeakerSignaling() {
      this._dominantSpeakerSignalingPromise = null;
      this._dominantSpeakerSignaling = null;
    }
  }, {
    key: '_teardownNetworkQualityMonitor',
    value: function _teardownNetworkQualityMonitor() {
      this._networkQualityMonitorPromise = null;
      if (this._networkQualityMonitor) {
        this._networkQualityMonitor.stop();
        this._networkQualityMonitor = null;
      }
    }
  }, {
    key: '_teardownTrackPrioritySignaling',
    value: function _teardownTrackPrioritySignaling() {
      this._trackPrioritySignaling = null;
      this._trackPriorityPromise = null;
      this.localParticipant.setTrackPrioritySignaling(null);
      this.participants.forEach(function (participant) {
        participant.setTrackPrioritySignaling(null);
      });
    }
  }, {
    key: '_teardownTrackSwitchOff',
    value: function _teardownTrackSwitchOff() {
      this._trackSwitchOffSignaling = null;
      this._trackSwitchOffPromise = null;
    }

    /**
     * Get the {@link RoomV2}'s media statistics.
     * @returns {Promise.<Map<PeerConnectionV2#id, StandardizedStatsResponse>>}
     */

  }, {
    key: 'getStats',
    value: function getStats() {
      var _this11 = this;

      return this._peerConnectionManager.getStats().then(function (responses) {
        return new Map(Array.from(responses).map(function (_ref) {
          var _ref2 = _slicedToArray(_ref, 2),
              id = _ref2[0],
              response = _ref2[1];

          return [id, Object.assign({}, response, {
            localAudioTrackStats: filterAndAddLocalTrackSids(_this11, response.localAudioTrackStats),
            localVideoTrackStats: filterAndAddLocalTrackSids(_this11, response.localVideoTrackStats),
            remoteAudioTrackStats: filterAndAddRemoteTrackSids(_this11, response.remoteAudioTrackStats),
            remoteVideoTrackStats: filterAndAddRemoteTrackSids(_this11, response.remoteVideoTrackStats)
          })];
        }));
      });
    }
  }, {
    key: 'connectionState',
    get: function get() {
      return this._peerConnectionManager.connectionState;
    }

    /**
     * The Signaling Connection State.
     * @property {string} - "connected", "reconnecting", "disconnected"
     */

  }, {
    key: 'signalingConnectionState',
    get: function get() {
      return this._transport.state === 'syncing' ? 'reconnecting' : this._transport.state;
    }

    /**
     * The Ice Connection State.
     * @property {RTCIceConnectionState}
     */

  }, {
    key: 'iceConnectionState',
    get: function get() {
      return this._peerConnectionManager.iceConnectionState;
    }
  }]);

  return RoomV2;
}(RoomSignaling);

/**
 * Filter out {@link TrackStats} that aren't in the collection while also
 * stamping their Track SIDs.
 * @param {Map<ID, SID>} idToSid
 * @param {Array<TrackStats>} trackStats
 * @returns {Array<TrackStats>}
 */


function filterAndAddTrackSids(idToSid, trackStats) {
  return trackStats.reduce(function (trackStats, trackStat) {
    var trackSid = idToSid.get(trackStat.trackId);
    return trackSid ? [Object.assign({}, trackStat, { trackSid: trackSid })].concat(trackStats) : trackStats;
  }, []);
}

/**
 * Filter out {@link LocalTrackStats} that aren't currently published while also
 * stamping their Track SIDs.
 * @param {RoomV2} roomV2
 * @param {Array<LocalTrackStats>} localTrackStats
 * @returns {Array<LocalTrackStats>}
 */
function filterAndAddLocalTrackSids(roomV2, localTrackStats) {
  return filterAndAddTrackSids(roomV2._published, localTrackStats);
}

/**
 * Filter out {@link RemoteTrackStats} that aren't currently subscribed while
 * also stamping their Track SIDs.
 * @param {RoomV2} roomV2
 * @param {Array<RemoteTrackStats>} remoteTrackStats
 * @returns {Array<RemoteTrackStats>}
 */
function filterAndAddRemoteTrackSids(roomV2, remoteTrackStats) {
  var idToSid = new Map(Array.from(roomV2._subscribed.entries()).map(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 2),
        sid = _ref4[0],
        id = _ref4[1];

    return [id, sid];
  }));
  return filterAndAddTrackSids(idToSid, remoteTrackStats);
}

/**
 * @typedef {object} RoomV2#Representation
 * @property {string} name
 * @property {LocalParticipantV2#Representation} participant
 * @property {?Array<RemoteParticipantV2#Representation>} participants
 * @property {?Array<PeerConnectionV2#Representation>} peer_connections
 * @property {?RecordingV2#Representation} recording
 * @property {string} sid
 */

function handleLocalParticipantEvents(roomV2, localParticipant) {
  var localParticipantUpdated = oncePerTick(function () {
    roomV2._publishNewLocalParticipantState();
  });

  var renegotiate = oncePerTick(function () {
    var trackSenders = flatMap(localParticipant.tracks, function (trackV2) {
      return trackV2.trackTransceiver;
    });
    roomV2._peerConnectionManager.setTrackSenders(trackSenders);
  });

  localParticipant.on('trackAdded', renegotiate);
  localParticipant.on('trackRemoved', renegotiate);
  localParticipant.on('updated', localParticipantUpdated);

  roomV2.on('stateChanged', function stateChanged(state) {
    if (state === 'disconnected') {
      localParticipant.removeListener('trackAdded', renegotiate);
      localParticipant.removeListener('trackRemoved', renegotiate);
      localParticipant.removeListener('updated', localParticipantUpdated);
      roomV2.removeListener('stateChanged', stateChanged);
      localParticipant.disconnect();
    }
  });

  roomV2.on('signalingConnectionStateChanged', function () {
    var localParticipant = roomV2.localParticipant,
        signalingConnectionState = roomV2.signalingConnectionState;
    var identity = localParticipant.identity,
        sid = localParticipant.sid;

    switch (signalingConnectionState) {
      case 'connected':
        localParticipant.connect(sid, identity);
        break;
      case 'reconnecting':
        localParticipant.reconnecting();
        break;
    }
  });
}

function handlePeerConnectionEvents(roomV2, peerConnectionManager) {
  peerConnectionManager.on('description', function onDescription(description) {
    roomV2._publishPeerConnectionState(description);
  });
  peerConnectionManager.dequeue('description');

  peerConnectionManager.on('candidates', function onCandidates(candidates) {
    roomV2._publishPeerConnectionState(candidates);
  });
  peerConnectionManager.dequeue('candidates');

  peerConnectionManager.on('trackAdded', roomV2._addTrackReceiver.bind(roomV2));
  peerConnectionManager.dequeue('trackAdded');
  peerConnectionManager.getTrackReceivers().forEach(roomV2._addTrackReceiver, roomV2);

  peerConnectionManager.on('connectionStateChanged', function () {
    roomV2.emit('connectionStateChanged');
  });

  peerConnectionManager.on('iceConnectionStateChanged', function () {
    roomV2.emit('iceConnectionStateChanged');
    if (roomV2.iceConnectionState === 'failed') {
      if (roomV2.localParticipant.networkQualityLevel !== null) {
        roomV2.localParticipant.setNetworkQualityLevel(0);
      }
      roomV2.participants.forEach(function (participant) {
        if (participant.networkQualityLevel !== null) {
          participant.setNetworkQualityLevel(0);
        }
      });
    }
  });
}

function handleTransportEvents(roomV2, transport) {
  transport.on('message', roomV2._update.bind(roomV2));
  transport.on('stateChanged', function stateChanged(state, error) {
    if (state === 'disconnected') {
      if (roomV2.state !== 'disconnected') {
        roomV2._disconnect(error);
      }
      transport.removeListener('stateChanged', stateChanged);
    }
    roomV2.emit('signalingConnectionStateChanged');
  });
}

/**
 * Periodically publish {@link StatsReport}s.
 * @private
 * @param {RoomV2} roomV2
 * @param {Transport} transport
 * @param {Number} intervalMs
 */
function periodicallyPublishStats(roomV2, transport, intervalMs) {
  var oddPublishCount = false;
  var interval = setInterval(function () {
    roomV2.getStats().then(function (stats) {
      oddPublishCount = !oddPublishCount;
      stats.forEach(function (response, id) {
        // NOTE(mmalavalli): A StatsReport is used to publish a "stats-report"
        // event instead of using StandardizedStatsResponse directly because
        // StatsReport will add zeros to properties that do not exist.
        var report = new StatsReport(id, response, true /* prepareForInsights */);

        transport.publishEvent('quality', 'stats-report', {
          audioTrackStats: report.remoteAudioTrackStats,
          localAudioTrackStats: report.localAudioTrackStats,
          localVideoTrackStats: report.localVideoTrackStats,
          peerConnectionId: report.peerConnectionId,
          videoTrackStats: report.remoteVideoTrackStats
        });

        if (oddPublishCount) {
          // NOTE(mmalavalli): null properties of the "active-ice-candidate-pair"
          // payload are assigned default values until the Insights gateway
          // accepts null values.
          var activeIceCandidatePair = replaceNullsWithDefaults(response.activeIceCandidatePair, report.peerConnectionId);

          transport.publishEvent('quality', 'active-ice-candidate-pair', activeIceCandidatePair);
        }
      });
    }, function () {
      // Do nothing.
    });
  }, intervalMs);

  roomV2.on('stateChanged', function onStateChanged(state) {
    if (state === 'disconnected') {
      clearInterval(interval);
      roomV2.removeListener('stateChanged', onStateChanged);
    }
  });
}

function handleSubscriptions(room) {
  var trackSidsToTrackSignalings = room._getTrackSidsToTrackSignalings();

  room._subscriptionFailures.forEach(function (error, trackSid) {
    var trackSignaling = trackSidsToTrackSignalings.get(trackSid);
    if (trackSignaling) {
      room._subscriptionFailures.delete(trackSid);
      trackSignaling.subscribeFailed(createTwilioError(error.code, error.message));
    }
  });

  trackSidsToTrackSignalings.forEach(function (trackSignaling) {
    var trackId = room._subscribed.get(trackSignaling.sid);
    if (!trackId || trackSignaling.isSubscribed && trackSignaling.trackTransceiver.id !== trackId) {
      trackSignaling.setTrackTransceiver(null);
    }
    if (trackId) {
      room._getTrackReceiver(trackId).then(function (trackReceiver) {
        return trackSignaling.setTrackTransceiver(trackReceiver);
      });
    }
  });
}

function replaceNullsWithDefaults(activeIceCandidatePair, peerConnectionId) {
  activeIceCandidatePair = Object.assign({
    availableIncomingBitrate: 0,
    availableOutgoingBitrate: 0,
    bytesReceived: 0,
    bytesSent: 0,
    consentRequestsSent: 0,
    currentRoundTripTime: 0,
    lastPacketReceivedTimestamp: 0,
    lastPacketSentTimestamp: 0,
    nominated: false,
    peerConnectionId: peerConnectionId,
    priority: 0,
    readable: false,
    requestsReceived: 0,
    requestsSent: 0,
    responsesReceived: 0,
    responsesSent: 0,
    retransmissionsReceived: 0,
    retransmissionsSent: 0,
    state: 'failed',
    totalRoundTripTime: 0,
    transportId: '',
    writable: false
  }, filterObject(activeIceCandidatePair || {}, null));

  activeIceCandidatePair.localCandidate = Object.assign({
    candidateType: 'host',
    deleted: false,
    ip: '',
    port: 0,
    priority: 0,
    protocol: 'udp',
    relayProtocol: 'udp',
    url: ''
  }, filterObject(activeIceCandidatePair.localCandidate || {}, null));

  activeIceCandidatePair.remoteCandidate = Object.assign({
    candidateType: 'host',
    ip: '',
    port: 0,
    priority: 0,
    protocol: 'udp',
    url: ''
  }, filterObject(activeIceCandidatePair.remoteCandidate || {}, null));

  return activeIceCandidatePair;
}

module.exports = RoomV2;
},{"../../stats/statsreport":101,"../../util":114,"../../util/twilio-video-errors":128,"../room":53,"./dominantspeakersignaling":56,"./networkqualitymonitor":62,"./networkqualitysignaling":63,"./recording":66,"./remoteparticipant":67,"./trackprioritysignaling":70,"./trackswitchoffsignaling":71}],70:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var TrackPrioritySignaling = function () {
  /**
   * Construct a {@link TrackPrioritySignaling}.
   * @param {MediaSignalingTransport} mediaSignalingTransport
   */
  function TrackPrioritySignaling(mediaSignalingTransport) {
    _classCallCheck(this, TrackPrioritySignaling);

    Object.defineProperties(this, {
      _mediaSignalingTransport: {
        value: mediaSignalingTransport
      }
    });
  }

  /**
   * @param {Track.SID} trackSid
   * @param {'publish'|'subscribe'} publishOrSubscribe
   * @param {Track.Priority} priority
   */


  _createClass(TrackPrioritySignaling, [{
    key: 'sendTrackPriorityUpdate',
    value: function sendTrackPriorityUpdate(trackSid, publishOrSubscribe, priority) {
      this._mediaSignalingTransport.publish(_defineProperty({
        type: 'track_priority',
        track: trackSid
      }, publishOrSubscribe, priority));
    }
  }]);

  return TrackPrioritySignaling;
}();

module.exports = TrackPrioritySignaling;
},{}],71:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('events'),
    EventEmitter = _require.EventEmitter;

/**
 * @emits TrackSwitchOffSignalinging#updated
 */


var TrackSwitchOffSignaling = function (_EventEmitter) {
  _inherits(TrackSwitchOffSignaling, _EventEmitter);

  /**
   * Construct a {@link TrackSwitchOffSignaling}.
   * @param {MediaSignalingTransport} mediaSignalingTransport
   */
  function TrackSwitchOffSignaling(mediaSignalingTransport) {
    _classCallCheck(this, TrackSwitchOffSignaling);

    var _this = _possibleConstructorReturn(this, (TrackSwitchOffSignaling.__proto__ || Object.getPrototypeOf(TrackSwitchOffSignaling)).call(this));

    mediaSignalingTransport.on('message', function (message) {
      switch (message.type) {
        case 'track_switch_off':
          _this._setTrackSwitchOffUpdates(message.off || [], message.on || []);
          break;
        default:
          break;
      }
    });
    return _this;
  }

  /**
   * @private
   * @param {[Track.SID]} tracksSwitchedOff
   * @param {[Track.SID]} tracksSwitchedOn
   * @returns {void}
   */


  _createClass(TrackSwitchOffSignaling, [{
    key: '_setTrackSwitchOffUpdates',
    value: function _setTrackSwitchOffUpdates(tracksSwitchedOff, tracksSwitchedOn) {
      this.emit('updated', tracksSwitchedOff, tracksSwitchedOn);
    }
  }]);

  return TrackSwitchOffSignaling;
}(EventEmitter);

/**
 * @event TrackSwitchOffSignaling#updated
 */

module.exports = TrackSwitchOffSignaling;
},{"events":165}],72:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('@twilio/webrtc/lib/util/sdp'),
    getSdpFormat = _require.getSdpFormat;

var packageInfo = require('../../../package.json');
var InsightsPublisher = require('../../util/insightspublisher');
var NullInsightsPublisher = require('../../util/insightspublisher/null');
var StateMachine = require('../../statemachine');
var TwilioConnection = require('../../twilioconnection');
var DefaultBackoff = require('backoff');

var _require2 = require('../../util/constants'),
    reconnectBackoffConfig = _require2.reconnectBackoffConfig;

var Timeout = require('../../util/timeout');

var _require3 = require('../../util'),
    createBandwidthProfilePayload = _require3.createBandwidthProfilePayload,
    createMediaSignalingPayload = _require3.createMediaSignalingPayload,
    createSubscribePayload = _require3.createSubscribePayload,
    getUserAgent = _require3.getUserAgent;

var _require4 = require('../../util/twilio-video-errors'),
    createTwilioError = _require4.createTwilioError,
    RoomCompletedError = _require4.RoomCompletedError,
    SignalingConnectionError = _require4.SignalingConnectionError,
    SignalingServerBusyError = _require4.SignalingServerBusyError;

var ICE_VERSION = 1;
var RSP_VERSION = 2;
var SDK_NAME = packageInfo.name + '.js';
var SDK_VERSION = packageInfo.version;

/*
TwilioConnectionTransport States
----------------

                      +-----------+
                      |           |
                      |  syncing  |---------+
                      |           |         |
                      +-----------+         |
                         ^     |            |
                         |     |            |
                         |     v            v
    +------------+    +-----------+    +--------------+
    |            |    |           |    |              |
    | connecting |--->| connected |--->| disconnected |
    |            |    |           |    |              |
    +------------+    +-----------+    +--------------+
             |                              ^
             |                              |
             |                              |
             +------------------------------+

*/

var states = {
  connecting: ['connected', 'disconnected'],
  connected: ['disconnected', 'syncing'],
  syncing: ['connected', 'disconnected'],
  disconnected: []
};

/**
 * A {@link TwilioConnectionTransport} supports sending and receiving Room Signaling Protocol
 * (RSP) messages. It also supports RSP requests, such as Sync and Disconnect.
 * @extends StateMachine
 * @emits TwilioConnectionTransport#connected
 * @emits TwilioConnectionTransport#message
 */

var TwilioConnectionTransport = function (_StateMachine) {
  _inherits(TwilioConnectionTransport, _StateMachine);

  /**
   * Construct a {@link TwilioConnectionTransport}.
   * @param {?string} name
   * @param {string} accessToken
   * @param {ParticipantSignaling} localParticipant
   * @param {PeerConnectionManager} peerConnectionManager
   * @param {string} wsServer
   * @param {object} [options]
   */
  function TwilioConnectionTransport(name, accessToken, localParticipant, peerConnectionManager, wsServer, options) {
    _classCallCheck(this, TwilioConnectionTransport);

    options = Object.assign({
      Backoff: DefaultBackoff,
      InsightsPublisher: InsightsPublisher,
      NullInsightsPublisher: NullInsightsPublisher,
      TwilioConnection: TwilioConnection,
      iceServers: null,
      sdpFormat: getSdpFormat(options.sdpSemantics),
      trackPriority: true,
      trackSwitchOff: true,
      userAgent: getUserAgent()
    }, options);

    var _this = _possibleConstructorReturn(this, (TwilioConnectionTransport.__proto__ || Object.getPrototypeOf(TwilioConnectionTransport)).call(this, 'connecting', states));

    var eventPublisherOptions = {};
    if (options.wsServerInsights) {
      eventPublisherOptions.gateway = options.wsServerInsights;
    }

    var EventPublisher = options.insights ? options.InsightsPublisher : options.NullInsightsPublisher;
    Object.defineProperties(_this, {
      _accessToken: {
        value: accessToken
      },
      _automaticSubscription: {
        value: options.automaticSubscription
      },
      _bandwidthProfile: {
        value: options.bandwidthProfile
      },
      _dominantSpeaker: {
        value: options.dominantSpeaker
      },
      _eventPublisher: {
        value: new EventPublisher(accessToken, SDK_NAME, SDK_VERSION, options.environment, options.realm, eventPublisherOptions)
      },
      _iceServersStatus: {
        value: Array.isArray(options.iceServers) ? 'overrode' : 'acquire'
      },
      _localParticipant: {
        value: localParticipant
      },
      _name: {
        value: name
      },
      _networkQuality: {
        value: options.networkQuality
      },
      _options: {
        value: options
      },
      _peerConnectionManager: {
        value: peerConnectionManager
      },
      _sessionTimer: {
        value: null,
        writable: true
      },
      _sessionTimeoutMS: {
        value: 0, // initially 0, set only after 1st successful connection.
        writable: true
      },
      _reconnectBackoff: {
        value: options.Backoff.exponential(reconnectBackoffConfig)
      },
      _session: {
        value: null,
        writable: true
      },
      _trackPriority: {
        value: options.trackPriority
      },
      _trackSwitchOff: {
        value: options.trackSwitchOff
      },
      _twilioConnection: {
        value: null,
        writable: true
      },
      _updatesReceived: {
        value: []
      },
      _updatesToSend: {
        value: []
      },
      _userAgent: {
        value: options.userAgent
      },
      _wsServer: {
        value: wsServer
      }
    });

    if (options.eventObserver) {
      options.eventObserver.setPublisher(_this._eventPublisher);
    }

    setupTransport(_this);

    _this.once('connected', function (_ref) {
      var sid = _ref.sid,
          participant = _ref.participant;

      _this._eventPublisher.connect(sid, participant.sid);
    });
    return _this;
  }

  /**
   * Create a Connect, Sync or Disconnect RSP message.
   * @private
   * @returns {?object}
   */


  _createClass(TwilioConnectionTransport, [{
    key: '_createConnectOrSyncOrDisconnectMessage',
    value: function _createConnectOrSyncOrDisconnectMessage() {
      if (this.state === 'connected') {
        return null;
      }

      if (this.state === 'disconnected') {
        return {
          session: this._session,
          type: 'disconnect',
          version: RSP_VERSION
        };
      }

      var type = {
        connecting: 'connect',
        syncing: 'sync'
      }[this.state];

      var message = {
        name: this._name,
        participant: this._localParticipant.getState(),
        peer_connections: this._peerConnectionManager.getStates(),
        type: type,
        version: RSP_VERSION
      };

      if (message.type === 'connect') {
        message.ice_servers = this._iceServersStatus;

        message.publisher = {
          name: SDK_NAME,
          sdk_version: SDK_VERSION,
          user_agent: this._userAgent
        };

        if (this._bandwidthProfile) {
          message.bandwidth_profile = createBandwidthProfilePayload(this._bandwidthProfile);
        }

        message.media_signaling = createMediaSignalingPayload(this._dominantSpeaker, this._networkQuality, this._trackPriority, this._trackSwitchOff);

        message.subscribe = createSubscribePayload(this._automaticSubscription);

        var sdpFormat = this._options.sdpFormat;
        if (sdpFormat) {
          message.format = sdpFormat;
        }
        message.token = this._accessToken;
      } else if (message.type === 'sync') {
        message.session = this._session;
        message.token = this._accessToken;
      } else if (message.type === 'update') {
        message.session = this._session;
      }

      return message;
    }

    /**
     * Create an "ice" message.
     * @private
     */

  }, {
    key: '_createIceMessage',
    value: function _createIceMessage() {
      return {
        edge: 'roaming', // roaming here means use same edge as signaling.
        token: this._accessToken,
        type: 'ice',
        version: ICE_VERSION
      };
    }

    /**
     * Send a Connect, Sync or Disconnect RSP message.
     * @private
     */

  }, {
    key: '_sendConnectOrSyncOrDisconnectMessage',
    value: function _sendConnectOrSyncOrDisconnectMessage() {
      var message = this._createConnectOrSyncOrDisconnectMessage();
      if (message) {
        this._twilioConnection.sendMessage(message);
      }
    }

    /**
     * Disconnect the {@link TwilioConnectionTransport}. Returns true if calling the method resulted
     * in disconnection.
     * @param {TwilioError} [error]
     * @returns {boolean}
     */

  }, {
    key: 'disconnect',
    value: function disconnect(error) {
      if (this.state !== 'disconnected') {
        this.preempt('disconnected', null, [error]);
        this._sendConnectOrSyncOrDisconnectMessage();
        this._twilioConnection.close();
        this._eventPublisher.disconnect();
        return true;
      }
      return false;
    }

    /**
     * Publish an RSP Update. Returns true if calling the method resulted in
     * publishing (or eventually publishing) the update.
     * @param {object} update
     * @returns {boolean}
     */

  }, {
    key: 'publish',
    value: function publish(update) {
      switch (this.state) {
        case 'connected':
          this._twilioConnection.sendMessage(Object.assign({
            session: this._session,
            type: 'update',
            version: RSP_VERSION
          }, update));
          return true;
        case 'connecting':
        case 'syncing':
          this._updatesToSend.push(update);
          return true;
        case 'disconnected':
        default:
          return false;
      }
    }

    /**
     * Publish (or queue) an event to the Insights gateway.
     * @param {string} groupName - Event group name
     * @param {string} eventName - Event name
     * @param {object} payload - Event payload
     * @returns {boolean} true if queued or published, false if disconnected from the Insights gateway
     */

  }, {
    key: 'publishEvent',
    value: function publishEvent(groupName, eventName, payload) {
      return this._eventPublisher.publish(groupName, eventName, payload);
    }

    /**
     * Sync the {@link TwilioConnectionTransport}. Returns true if calling the method resulted in
     * syncing.
     * @returns {boolean}
     */

  }, {
    key: 'sync',
    value: function sync() {
      if (this.state === 'connected') {
        this.preempt('syncing');
        this._sendConnectOrSyncOrDisconnectMessage();
        return true;
      }
      return false;
    }

    /**
     * @private
     * @returns {void}
     */

  }, {
    key: '_setSession',
    value: function _setSession(session, sessionTimeout) {
      this._session = session;
      this._sessionTimeoutMS = sessionTimeout * 1000;
    }

    /**
     * Determines if we should attempt reconnect.
     * returns a Promise to wait on before attempting to
     * reconnect. returns null if its not okay to reconnect.
     * @private
     * @returns {Promise<void>}
     */

  }, {
    key: '_getReconnectTimer',
    value: function _getReconnectTimer() {
      var _this2 = this;

      if (this._sessionTimeoutMS === 0) {
        // this means either we have never connected.
        // or we timed out while trying to reconnect
        // In either case we do not want to reconnect.
        return null;
      }

      // start session timer
      if (!this._sessionTimer) {
        this._sessionTimer = new Timeout(function () {
          // ensure that _clearReconnectTimer wasn't
          // called while we were waiting.
          if (_this2._sessionTimer) {
            // do not allow any more reconnect attempts.
            _this2._sessionTimeoutMS = 0;
          }
        }, this._sessionTimeoutMS);
      }

      // return promise that waits with exponential backoff.
      return new Promise(function (resolve) {
        _this2._reconnectBackoff.once('ready', resolve);
        _this2._reconnectBackoff.backoff();
      });
    }

    /**
     * clears the session reconnect timer.
     *
     * @private
     * @returns {void}
     */

  }, {
    key: '_clearReconnectTimer',
    value: function _clearReconnectTimer() {
      this._reconnectBackoff.reset();
      if (this._sessionTimer) {
        this._sessionTimer.clear();
        this._sessionTimer = null;
      }
    }
  }]);

  return TwilioConnectionTransport;
}(StateMachine);

/**
 * @event TwilioConnectionTransport#connected
 * @param {object} initialState
 */

/**
 * @event TwilioConnectionTransport#message
 * @param {object} peerConnections
 */

function reducePeerConnections(peerConnections) {
  return Array.from(peerConnections.reduce(function (peerConnectionsById, update) {
    var reduced = peerConnectionsById.get(update.id) || update;

    // First, reduce the top-level `description` property.
    if (!reduced.description && update.description) {
      reduced.description = update.description;
    } else if (reduced.description && update.description) {
      if (update.description.revision > reduced.description.revision) {
        reduced.description = update.description;
      }
    }

    // Then, reduce the top-level `ice` property.
    if (!reduced.ice && update.ice) {
      reduced.ice = update.ice;
    } else if (reduced.ice && update.ice) {
      if (update.ice.revision > reduced.ice.revision) {
        reduced.ice = update.ice;
      }
    }

    // Finally, update the map.
    peerConnectionsById.set(reduced.id, reduced);
    return peerConnectionsById;
  }, new Map()).values());
}

function reduceUpdates(updates) {
  return updates.reduce(function (reduced, update) {
    // First, reduce the top-level `participant` property.
    if (!reduced.participant && update.participant) {
      reduced.participant = update.participant;
    } else if (reduced.participant && update.participant) {
      if (update.participant.revision > reduced.participant.revision) {
        reduced.participant = update.participant;
      }
    }

    // Then, reduce the top-level `peer_connections` property.
    /* eslint camelcase:0 */
    if (!reduced.peer_connections && update.peer_connections) {
      reduced.peer_connections = reducePeerConnections(update.peer_connections);
    } else if (reduced.peer_connections && update.peer_connections) {
      reduced.peer_connections = reducePeerConnections(reduced.peer_connections.concat(update.peer_connections));
    }
    return reduced;
  }, {});
}

function setupTransport(transport) {
  function createOrResetTwilioConnection() {
    if (transport.state === 'disconnected') {
      return;
    }
    if (transport._twilioConnection) {
      transport._twilioConnection.removeListener('message', handleMessage);
    }
    var _iceServersStatus = transport._iceServersStatus,
        _options = transport._options,
        _wsServer = transport._wsServer,
        state = transport.state;
    var TwilioConnection = _options.TwilioConnection;


    var twilioConnection = new TwilioConnection(_wsServer, Object.assign({
      helloBody: state === 'connecting' && _iceServersStatus === 'acquire' ? transport._createIceMessage() : transport._createConnectOrSyncOrDisconnectMessage()
    }, _options));

    twilioConnection.once('close', function (reason) {
      if (reason === TwilioConnection.CloseReason.LOCAL) {
        disconnect();
      } else {
        disconnect(new Error(reason));
      }
    });

    twilioConnection.on('message', handleMessage);
    transport._twilioConnection = twilioConnection;
  }

  function disconnect(error) {
    if (transport.state === 'disconnected') {
      return;
    }
    if (!error) {
      transport.disconnect();
      return;
    }

    var reconnectTimer = transport._getReconnectTimer();
    if (!reconnectTimer) {
      var twilioError = error.message === TwilioConnection.CloseReason.BUSY ? new SignalingServerBusyError() : new SignalingConnectionError();
      transport.disconnect(twilioError);
      return;
    }

    if (transport.state === 'connected') {
      transport.preempt('syncing');
    }

    reconnectTimer.then(createOrResetTwilioConnection);
  }

  function handleMessage(message) {
    if (transport.state === 'disconnected') {
      return;
    }
    if (message.type === 'error') {
      transport.disconnect(createTwilioError(message.code, message.message));
      return;
    }
    switch (transport.state) {
      case 'connected':
        switch (message.type) {
          case 'connected':
          case 'synced':
          case 'update':
            transport.emit('message', message);
            return;
          case 'disconnected':
            transport.disconnect(message.status === 'completed' ? new RoomCompletedError() : null);
            return;
          default:
            // Do nothing.
            return;
        }
      case 'connecting':
        switch (message.type) {
          case 'iced':
            transport._options.onIced(message.ice_servers).then(function () {
              transport._sendConnectOrSyncOrDisconnectMessage();
            });
            return;
          case 'connected':
            transport._setSession(message.session, message.options.session_timeout);
            transport.emit('connected', message);
            transport.preempt('connected');
            return;
          case 'synced':
          case 'update':
            transport._updatesReceived.push(message);
            return;
          case 'disconnected':
            transport.disconnect(message.status === 'completed' ? new RoomCompletedError() : null);
            return;
          default:
            // Do nothing.
            return;
        }
      case 'syncing':
        switch (message.type) {
          case 'connected':
          case 'update':
            transport._updatesReceived.push(message);
            return;
          case 'synced':
            transport._clearReconnectTimer();
            transport.emit('message', message);
            transport.preempt('connected');
            return;
          case 'disconnected':
            transport.disconnect(message.status === 'completed' ? new RoomCompletedError() : null);
            return;
          default:
            // Do nothing.
            return;
        }
      default:
        // Impossible
        return;
    }
  }

  transport.on('stateChanged', function stateChanged(state) {
    switch (state) {
      case 'connected':
        {
          var updates = transport._updatesToSend.splice(0);
          if (updates.length) {
            transport.publish(reduceUpdates(updates));
          }
          transport._updatesReceived.splice(0).forEach(function (update) {
            return transport.emit('message', update);
          });
          return;
        }
      case 'disconnected':
        transport._twilioConnection.removeListener('message', handleMessage);
        transport.removeListener('stateChanged', stateChanged);
        return;
      case 'syncing':
        // Do nothing.
        return;
      default:
        // Impossible
        return;
    }
  });

  var _options = transport._options,
      _iceServersStatus = transport._iceServersStatus;
  var iceServers = _options.iceServers,
      onIced = _options.onIced;


  if (_iceServersStatus === 'overrode') {
    onIced(iceServers).then(createOrResetTwilioConnection);
  } else {
    createOrResetTwilioConnection();
  }
}

module.exports = TwilioConnectionTransport;
},{"../../../package.json":184,"../../statemachine":73,"../../twilioconnection":105,"../../util":114,"../../util/constants":108,"../../util/insightspublisher":115,"../../util/insightspublisher/null":116,"../../util/timeout":127,"../../util/twilio-video-errors":128,"@twilio/webrtc/lib/util/sdp":151,"backoff":155}],73:[function(require,module,exports){
'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EventEmitter = require('events').EventEmitter;
var util = require('./util');

/**
 * {@link StateMachine} represents a state machine. The state machine supports a
 * reentrant locking mechanism to allow asynchronous state transitions to ensure
 * they have not been preempted. Calls to {@link StateMachine#takeLock} are
 * guaranteed to be resolved in FIFO order.
 * @extends EventEmitter
 * @property {boolean} isLocked - whether or not the {@link StateMachine} is
 *   locked performing asynchronous state transition
 * @property {string} state - the current state
 * @emits {@link StateMachine#stateChanged}
 */

var StateMachine = function (_EventEmitter) {
  _inherits(StateMachine, _EventEmitter);

  /**
   * Construct a {@link StateMachine}.
   * @param {string} initialState - the intiial state
   * @param {object} states
   */
  function StateMachine(initialState, states) {
    _classCallCheck(this, StateMachine);

    var _this = _possibleConstructorReturn(this, (StateMachine.__proto__ || Object.getPrototypeOf(StateMachine)).call(this));

    var lock = null;
    var state = initialState;
    states = transformStates(states);
    Object.defineProperties(_this, {
      _lock: {
        get: function get() {
          return lock;
        },
        set: function set(_lock) {
          lock = _lock;
        }
      },
      _reachableStates: {
        value: reachable(states)
      },
      _state: {
        get: function get() {
          return state;
        },
        set: function set(_state) {
          state = _state;
        }
      },
      _states: {
        value: states
      },
      _whenDeferreds: {
        value: new Set()
      },
      isLocked: {
        enumerable: true,
        get: function get() {
          return lock !== null;
        }
      },
      state: {
        enumerable: true,
        get: function get() {
          return state;
        }
      }
    });

    _this.on('stateChanged', function (state) {
      _this._whenDeferreds.forEach(function (deferred) {
        deferred.when(state, deferred.resolve, deferred.reject);
      });
    });
    return _this;
  }

  /**
   * Returns a promise whose executor function is called on each state change.
   * @param {function(state: string, resolve: function, reject: function): void} when
   * @returns {Promise.<*>}
   * @private
   */


  _createClass(StateMachine, [{
    key: '_whenPromise',
    value: function _whenPromise(when) {
      var _this2 = this;

      if (typeof when !== 'function') {
        return Promise.reject(new Error('when() executor must be a function'));
      }

      var deferred = util.defer();

      deferred.when = when;
      this._whenDeferreds.add(deferred);

      return deferred.promise.then(function (payload) {
        _this2._whenDeferreds.delete(deferred);
        return payload;
      }, function (error) {
        _this2._whenDeferreds.delete(deferred);
        throw error;
      });
    }

    /**
     * This method takes a lock and passes the {@link StateMachine#Key} to your
     * transition function. You may perform zero or more state transitions in your
     * transition function, but you should check for preemption in each tick. You
     * may also reenter the lock. Once the Promise returned by your transition
     * function resolves or rejects, this method releases the lock it acquired for
     * you.
     * @param {string} name - a name for the lock
     * @param {function(StateMachine#Key): Promise} transitionFunction
     * @returns {Promise}
     */
    // NOTE(mroberts): This method is named after a Haskell function:
    // https://hackage.haskell.org/package/base-4.8.2.0/docs/Control-Exception.html#v:bracket

  }, {
    key: 'bracket',
    value: function bracket(name, transitionFunction) {
      var key = void 0;
      var self = this;

      function releaseLock(error) {
        if (self.hasLock(key)) {
          self.releaseLockCompletely(key);
        }
        if (error) {
          throw error;
        }
      }

      return this.takeLock(name).then(function gotKey(_key) {
        key = _key;
        return transitionFunction(key);
      }).then(function success(result) {
        releaseLock();
        return result;
      }, releaseLock);
    }

    /**
     * Check whether or not a {@link StateMachine#Key} matches the lock.
     * @param {StateMachine#Key} key
     * @returns {boolean}
     */

  }, {
    key: 'hasLock',
    value: function hasLock(key) {
      return this._lock === key;
    }

    /**
     * Preempt any pending state transitions and immediately transition to the new
     * state. If a lock name is specified, take the lock and return the
     * {@link StateMachine#Key}.
     * @param {string} newState
     * @param {?string} [name=null] - a name for the lock
     * @param {Array<*>} [payload=[]]
     * @returns {?StateMachine#Key}
     */

  }, {
    key: 'preempt',
    value: function preempt(newState, name, payload) {
      // 1. Check that the new state is valid.
      if (!isValidTransition(this._states, this.state, newState)) {
        throw new Error('Cannot transition from "' + this.state + '" to "' + newState + '"');
      }

      // 2. Release the old lock, if any.
      var oldLock = void 0;
      if (this.isLocked) {
        oldLock = this._lock;
        this._lock = null;
      }

      // 3. Take the lock, if requested.
      var key = null;
      if (name) {
        key = this.takeLockSync(name);
      }

      // 4. If a lock wasn't requested, take a "preemption" lock in order to
      // maintain FIFO order of those taking locks.
      var preemptionKey = key ? null : this.takeLockSync('preemption');

      // 5. Transition.
      this.transition(newState, key || preemptionKey, payload);

      // 6. Preempt anyone blocked on the old lock.
      if (oldLock) {
        oldLock.resolve();
      }

      // 7. Release the "preemption" lock, if we took it.
      if (preemptionKey) {
        this.releaseLock(preemptionKey);
      }

      return key;
    }

    /**
     * Release a lock. This method succeeds only if the {@link StateMachine} is
     * still locked and has not been preempted.
     * @param {StateMachine#Key} key
     * @throws Error
     */

  }, {
    key: 'releaseLock',
    value: function releaseLock(key) {
      if (!this.isLocked) {
        throw new Error('Could not release the lock for ' + key.name + ' because the StateMachine is not locked');
      } else if (!this.hasLock(key)) {
        throw new Error('Could not release the lock for ' + key.name + ' because ' + this._lock.name + ' has the lock');
      }
      if (key.depth === 0) {
        this._lock = null;
        key.resolve();
      } else {
        key.depth--;
      }
    }

    /**
     * Release a lock completely, even if it has been reentered. This method
     * succeeds only if the {@link StateMachine} is still locked and has not been
     * preempted.
     * @param {StateMachine#Key} key
     * @throws Error
     */

  }, {
    key: 'releaseLockCompletely',
    value: function releaseLockCompletely(key) {
      if (!this.isLocked) {
        throw new Error('Could not release the lock for ' + key.name + ' because the StateMachine is not locked');
      } else if (!this.hasLock(key)) {
        throw new Error('Could not release the lock for ' + key.name + ' because ' + this._lock.name + ' has the lock');
      }
      key.depth = 0;
      this._lock = null;
      key.resolve();
    }

    /**
     * Take a lock, returning a Promise for the {@link StateMachine#Key}. You should
     * take a lock anytime you intend to perform asynchronous transitions. Calls to
     * this method are guaranteed to be resolved in FIFO order. You may reenter
     * a lock by passing its {@link StateMachine#Key}.
     * @param {string|StateMachine#Key} nameOrKey - a name for the lock or an
     * existing {@link StateMachine#Key}
     * @returns {Promise<object>}
     */

  }, {
    key: 'takeLock',
    value: function takeLock(nameOrKey) {
      var _this3 = this;

      // Reentrant lock
      if ((typeof nameOrKey === 'undefined' ? 'undefined' : _typeof(nameOrKey)) === 'object') {
        var key = nameOrKey;
        return new Promise(function (resolve) {
          resolve(_this3.takeLockSync(key));
        });
      }

      // New lock
      var name = nameOrKey;
      if (this.isLocked) {
        var takeLock = this.takeLock.bind(this, name);
        return this._lock.promise.then(takeLock);
      }
      return Promise.resolve(this.takeLockSync(name));
    }

    /**
     * Take a lock, returning the {@Link StateMachine#Key}. This method throws if
     * the {@link StateMachine} is locked or the wrong {@link StateMachine#Key} is
     * provided. You may reenter a lock by passing its {@link StateMachine#Key}.
     * @param {string|StateMachine#Key} nameOrKey - a name for the lock or an
     * existing {@link StateMachine#Key}
     * @returns {object}
     * @throws Error
     */

  }, {
    key: 'takeLockSync',
    value: function takeLockSync(nameOrKey) {
      var key = typeof nameOrKey === 'string' ? null : nameOrKey;
      var name = key ? key.name : nameOrKey;

      if (key && !this.hasLock(key) || !key && this.isLocked) {
        throw new Error('Could not take the lock for ' + name + ' because the lock for ' + this._lock.name + ' was not released');
      }

      // Reentrant lock
      if (key) {
        key.depth++;
        return key;
      }

      // New lock
      var lock = makeLock(name);
      this._lock = lock;
      return lock;
    }

    /**
     * Transition to a new state. If the {@link StateMachine} is locked, you must
     * provide the {@link StateMachine#Key}. An invalid state or the wrong
     * {@link StateMachine#Key} will throw an error.
     * @param {string} newState
     * @param {?StateMachine#Key} [key=null]
     * @param {Array<*>} [payload=[]]
     * @throws {Error}
     */

  }, {
    key: 'transition',
    value: function transition(newState, key, payload) {
      payload = payload || [];

      // 1. If we're locked, required the key.
      if (this.isLocked) {
        if (!key) {
          throw new Error('You must provide the key in order to ' + 'transition');
        } else if (!this.hasLock(key)) {
          throw new Error('Could not transition using the key for ' + key.name + ' because ' + this._lock.name + ' has the lock');
        }
      } else if (key) {
        throw new Error('Key provided for ' + key.name + ', but the StateMachine was not locked (possibly due to preemption)');
      }

      // 2. Check that the new state is valid.
      if (!isValidTransition(this._states, this.state, newState)) {
        throw new Error('Cannot transition from "' + this.state + '" to "' + newState + '"');
      }

      // 3. Update the state and emit an event.
      this._state = newState;
      this.emit.apply(this, _toConsumableArray(['stateChanged', newState].concat(payload)));
    }

    /**
     * Attempt to transition to a new state. Unlike {@link StateMachine#transition},
     * this method does not throw.
     * @param {string} newState
     * @param {?StateMachine#Key} [key=null]
     * @param {Array<*>} [payload=[]]
     * @returns {boolean}
     */

  }, {
    key: 'tryTransition',
    value: function tryTransition(newState, key, payload) {
      try {
        this.transition(newState, key, payload);
      } catch (error) {
        return false;
      }
      return true;
    }

    /**
     * Return a Promise that resolves when the {@link StateMachine} transitions to
     * the specified state. If the {@link StateMachine} transitions such that the
     * requested state becomes unreachable, the Promise rejects.
     * @param {string} state
     * @returns {Promise<this>}
     */

  }, {
    key: 'when',
    value: function when(state) {
      var _this4 = this;

      if (this.state === state) {
        return Promise.resolve(this);
      } else if (!isValidTransition(this._reachableStates, this.state, state)) {
        return Promise.reject(createUnreachableError(this.state, state));
      }
      return this._whenPromise(function (newState, resolve, reject) {
        if (newState === state) {
          resolve(_this4);
        } else if (!isValidTransition(_this4._reachableStates, newState, state)) {
          reject(createUnreachableError(newState, state));
        }
      });
    }
  }]);

  return StateMachine;
}(EventEmitter);

/**
 * @event StateMachine#stateChanged
 * @param {string} newState
 */

/**
 * Check if a transition is valid.
 * @private
 * @param {Map<*, Set<*>>} graph
 * @param {*} from
 * @param {*} to
 * @returns {boolean}
 */


function isValidTransition(graph, from, to) {
  return graph.get(from).has(to);
}

/**
 * @typedef {object} StateMachine#Key
 */

function makeLock(name) {
  var lock = util.defer();
  lock.name = name;
  lock.depth = 0;
  return lock;
}

/**
 * Compute the transitive closure of a graph (i.e. what nodes are reachable from
 * where).
 * @private
 * @param {Map<*, Set<*>>} graph
 * @returns {Map<*, Set<*>>}
 */
function reachable(graph) {
  return Array.from(graph.keys()).reduce(function (newGraph, from) {
    return newGraph.set(from, reachableFrom(graph, from));
  }, new Map());
}

/**
 * Compute the Set of node reachable from a particular node in the graph.
 * @private
 * @param {Map<*, Set<*>>} graph
 * @param {*} from
 * @param {Set<*>} [to]
 * @returns {Set<*>}
 */
function reachableFrom(graph, from, to) {
  to = to || new Set();
  graph.get(from).forEach(function (node) {
    if (!to.has(node)) {
      to.add(node);
      reachableFrom(graph, node, to).forEach(to.add, to);
    }
  });
  return to;
}

function transformStates(states) {
  var newStates = new Map();
  for (var key in states) {
    newStates.set(key, new Set(states[key]));
  }
  return newStates;
}

/**
 * Create an "unreachable state" Error.
 * @param {string} here
 * @param {string} there
 * @returns {Error}
 */
function createUnreachableError(here, there) {
  return new Error('"' + there + '" cannot be reached from "' + here + '"');
}

module.exports = StateMachine;
},{"./util":114,"events":165}],74:[function(require,module,exports){
/* eslint no-undefined:0 */
'use strict';

/**
 * @param {Array<number|undefined>} xs
 * @returns {number|undefined}
 */

function average(xs) {
  xs = xs.filter(function (x) {
    return typeof x === 'number';
  });
  return xs.length < 1 ? undefined : xs.reduce(function (y, x) {
    return x + y;
  }) / xs.length;
}

module.exports = average;
},{}],75:[function(require,module,exports){
'use strict';

/**
 * @property {number} [availableSend] - bps (undefined in Firefox)
 * @property {number} recv - bps
 * @property {number} [rtt] - s (undefined in Firefox)
 * @property {number} send - bps
 */

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var IceReport = function () {
  /**
   * Construct an {@link IceReport}.
   * @param {number} send - bps
   * @param {number} recv - bps
   * @param {number} [rtt] - s
   * @param {number} [availableSend] - bps
   */
  function IceReport(send, recv, availableSend, rtt) {
    _classCallCheck(this, IceReport);

    Object.defineProperties(this, {
      availableSend: {
        enumerable: true,
        value: availableSend
      },
      recv: {
        enumerable: true,
        value: recv
      },
      rtt: {
        enumerable: true,
        value: rtt
      },
      send: {
        enumerable: true,
        value: send
      }
    });
  }

  /**
   * @param {RTCStats} olderStats
   * @param {RTCStats} newerStats
   * @returns {IceReport}
   */


  _createClass(IceReport, null, [{
    key: 'of',
    value: function of(olderStats, newerStats) {
      var secondsElapsed = (newerStats.timestamp - olderStats.timestamp) / 1000;
      var deltaBytesSent = newerStats.bytesSent - olderStats.bytesSent;
      var deltaBytesReceived = newerStats.bytesReceived - olderStats.bytesReceived;
      var send = secondsElapsed > 0 ? deltaBytesSent / secondsElapsed * 8 : 0;
      var recv = secondsElapsed > 0 ? deltaBytesReceived / secondsElapsed * 8 : 0;
      var availableSend = newerStats.availableOutgoingBitrate,
          rtt = newerStats.currentRoundTripTime;

      return new IceReport(send, recv, availableSend, rtt);
    }
  }]);

  return IceReport;
}();

module.exports = IceReport;
},{}],76:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var IceReport = require('./icereport');

/**
 * @property {IceReport} lastReport
 * @property {?RTCStats} lastStats
 */

var IceReportFactory = function () {
  /**
   * Construct an {@link IceReportFactory}.
   */
  function IceReportFactory() {
    _classCallCheck(this, IceReportFactory);

    Object.defineProperties(this, {
      lastReport: {
        enumerable: true,
        value: new IceReport(0, 0),
        writable: true
      },
      lastStats: {
        enumerable: true,
        value: null,
        writable: true
      }
    });
  }

  /**
   * Create an {@link IceReport}.
   * @param {RTCStats} newerStats;
   * @returns {IceReport}
   */


  _createClass(IceReportFactory, [{
    key: 'next',
    value: function next(newerStats) {
      var olderStats = this.lastStats;
      this.lastStats = newerStats;
      if (olderStats) {
        var report = olderStats.id === newerStats.id ? IceReport.of(olderStats, newerStats) : new IceReport(0, 0);
        this.lastReport = report;
      }
      return this.lastReport;
    }
  }]);

  return IceReportFactory;
}();

module.exports = IceReportFactory;
},{"./icereport":75}],77:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var LocalTrackStats = require('./localtrackstats');

/**
 * Statistics for a {@link LocalAudioTrack}.
 * @extends LocalTrackStats
 * @property {?AudioLevel} audioLevel - Input {@link AudioLevel}
 * @property {?number} jitter - Audio jitter in milliseconds
 */

var LocalAudioTrackStats = function (_LocalTrackStats) {
  _inherits(LocalAudioTrackStats, _LocalTrackStats);

  /**
   * @param {string} trackId - {@link LocalAudioTrack} ID
   * @param {StandardizedTrackStatsReport} statsReport
   * @param {boolean} prepareForInsights
   */
  function LocalAudioTrackStats(trackId, statsReport, prepareForInsights) {
    _classCallCheck(this, LocalAudioTrackStats);

    var _this = _possibleConstructorReturn(this, (LocalAudioTrackStats.__proto__ || Object.getPrototypeOf(LocalAudioTrackStats)).call(this, trackId, statsReport, prepareForInsights));

    Object.defineProperties(_this, {
      audioLevel: {
        value: typeof statsReport.audioInputLevel === 'number' ? statsReport.audioInputLevel : null,
        enumerable: true
      },
      jitter: {
        value: typeof statsReport.jitter === 'number' ? statsReport.jitter : null,
        enumerable: true
      }
    });
    return _this;
  }

  return LocalAudioTrackStats;
}(LocalTrackStats);

/**
 * The maximum absolute amplitude of a set of audio samples in the
 * range of 0 to 32767 inclusive.
 * @typedef {number} AudioLevel
 */

module.exports = LocalAudioTrackStats;
},{"./localtrackstats":78}],78:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TrackStats = require('./trackstats');

/**
 * Statistics for a {@link LocalTrack}.
 * @extends TrackStats
 * @property {?number} bytesSent - Number of bytes sent
 * @property {?number} packetsSent - Number of packets sent
 * @property {?number} roundTripTime - Round trip time in milliseconds
 */

var LocalTrackStats = function (_TrackStats) {
  _inherits(LocalTrackStats, _TrackStats);

  /**
   * @param {string} trackId - {@link LocalTrack} ID
   * @param {StandardizedTrackStatsReport} statsReport
   * @param {boolean} prepareForInsights
   */
  function LocalTrackStats(trackId, statsReport, prepareForInsights) {
    _classCallCheck(this, LocalTrackStats);

    var _this = _possibleConstructorReturn(this, (LocalTrackStats.__proto__ || Object.getPrototypeOf(LocalTrackStats)).call(this, trackId, statsReport));

    Object.defineProperties(_this, {
      bytesSent: {
        value: typeof statsReport.bytesSent === 'number' ? statsReport.bytesSent : prepareForInsights ? 0 : null,
        enumerable: true
      },
      packetsSent: {
        value: typeof statsReport.packetsSent === 'number' ? statsReport.packetsSent : prepareForInsights ? 0 : null,
        enumerable: true
      },
      roundTripTime: {
        value: typeof statsReport.roundTripTime === 'number' ? statsReport.roundTripTime : prepareForInsights ? 0 : null,
        enumerable: true
      }
    });
    return _this;
  }

  return LocalTrackStats;
}(TrackStats);

module.exports = LocalTrackStats;
},{"./trackstats":103}],79:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var LocalTrackStats = require('./localtrackstats');

/**
 * Statistics for a {@link LocalVideoTrack}.
 * @extends LocalTrackStats
 * @property {?VideoTrack#Dimensions} captureDimensions - Video capture resolution
 * @property {?VideoTrack#Dimensions} dimensions - Video encoding resolution
 * @property {?number} captureFrameRate - Video capture frame rate
 * @property {?number} frameRate - Video encoding frame rate
 */

var LocalVideoTrackStats = function (_LocalTrackStats) {
  _inherits(LocalVideoTrackStats, _LocalTrackStats);

  /**
   * @param {string} trackId - {@link LocalVideoTrack} ID
   * @param {StandardizedTrackStatsReport} statsReport
   * @param {boolean} prepareForInsights
   */
  function LocalVideoTrackStats(trackId, statsReport, prepareForInsights) {
    _classCallCheck(this, LocalVideoTrackStats);

    var _this = _possibleConstructorReturn(this, (LocalVideoTrackStats.__proto__ || Object.getPrototypeOf(LocalVideoTrackStats)).call(this, trackId, statsReport, prepareForInsights));

    var captureDimensions = null;
    if (typeof statsReport.frameWidthInput === 'number' && typeof statsReport.frameHeightInput === 'number') {
      captureDimensions = {};

      Object.defineProperties(captureDimensions, {
        width: {
          value: statsReport.frameWidthInput,
          enumerable: true
        },
        height: {
          value: statsReport.frameHeightInput,
          enumerable: true
        }
      });
    }

    var dimensions = null;
    if (typeof statsReport.frameWidthSent === 'number' && typeof statsReport.frameHeightSent === 'number') {
      dimensions = {};

      Object.defineProperties(dimensions, {
        width: {
          value: statsReport.frameWidthSent,
          enumerable: true
        },
        height: {
          value: statsReport.frameHeightSent,
          enumerable: true
        }
      });
    }

    Object.defineProperties(_this, {
      captureDimensions: {
        value: captureDimensions,
        enumerable: true
      },
      dimensions: {
        value: dimensions,
        enumerable: true
      },
      captureFrameRate: {
        value: typeof statsReport.frameRateInput === 'number' ? statsReport.frameRateInput : null,
        enumerable: true
      },
      frameRate: {
        value: typeof statsReport.frameRateSent === 'number' ? statsReport.frameRateSent : null,
        enumerable: true
      }
    });
    return _this;
  }

  return LocalVideoTrackStats;
}(LocalTrackStats);

module.exports = LocalVideoTrackStats;
},{"./localtrackstats":78}],80:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var NetworkQualityMediaStats = require('./networkqualitymediastats');

/**
 * {@link NetworkQualityMediaStats} for a {@link Participant}'s audio.
 */

var NetworkQualityAudioStats = function (_NetworkQualityMediaS) {
  _inherits(NetworkQualityAudioStats, _NetworkQualityMediaS);

  /**
   * Construct a {@link NetworkQualityAudioStats}.
   * @param {MediaLevels} mediaLevels
   */
  function NetworkQualityAudioStats(mediaLevels) {
    _classCallCheck(this, NetworkQualityAudioStats);

    return _possibleConstructorReturn(this, (NetworkQualityAudioStats.__proto__ || Object.getPrototypeOf(NetworkQualityAudioStats)).call(this, mediaLevels));
  }

  return NetworkQualityAudioStats;
}(NetworkQualityMediaStats);

module.exports = NetworkQualityAudioStats;
},{"./networkqualitymediastats":84}],81:[function(require,module,exports){
'use strict';

/**
 * Bandwidth network quality statistics.
 * @property {?number} actual - actual bandwidth, in bytes
 * @property {?number} available - available bandwidth, in bytes
 * @property {?NetworkQualityLevel} level - {@link NetworkQualityLevel} for bandwidth
 */

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var NetworkQualityBandwidthStats =
/**
 * Construct a {@link NetworkQualityBandwidthStats}.
 * @param {BandwidthStats} bandwidthStats
 */
function NetworkQualityBandwidthStats(_ref) {
  var _ref$actual = _ref.actual,
      actual = _ref$actual === undefined ? null : _ref$actual,
      _ref$available = _ref.available,
      available = _ref$available === undefined ? null : _ref$available,
      _ref$level = _ref.level,
      level = _ref$level === undefined ? null : _ref$level;

  _classCallCheck(this, NetworkQualityBandwidthStats);

  Object.defineProperties(this, {
    actual: {
      value: actual,
      enumerable: true
    },
    available: {
      value: available,
      enumerable: true
    },
    level: {
      value: level,
      enumerable: true
    }
  });
};

module.exports = NetworkQualityBandwidthStats;
},{}],82:[function(require,module,exports){
'use strict';

/**
 * Fraction lost network quality statistics.
 * @property {?number} fractionLost - packets lost
 * @property {?NetworkQualityLevel} level - {@link NetworkQualityLevel} for fraction lost
 */

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var NetworkQualityFractionLostStats =
/**
 * Construct a {@link NetworkQualityFractionLostStats}.
 * @param {FractionLostStats} fractionLostStats
 */
function NetworkQualityFractionLostStats(_ref) {
  var _ref$fractionLost = _ref.fractionLost,
      fractionLost = _ref$fractionLost === undefined ? null : _ref$fractionLost,
      _ref$level = _ref.level,
      level = _ref$level === undefined ? null : _ref$level;

  _classCallCheck(this, NetworkQualityFractionLostStats);

  Object.defineProperties(this, {
    fractionLost: {
      value: fractionLost,
      enumerable: true
    },
    level: {
      value: level,
      enumerable: true
    }
  });
};

module.exports = NetworkQualityFractionLostStats;
},{}],83:[function(require,module,exports){
'use strict';

/**
 * Latency network quality statistics.
 * @property {?number} jitter - media jitter in seconds
 * @property {?number} rtt - round trip time in seconds
 * @property {?NetworkQualityLevel} level - {@link NetworkQualityLevel} for latency
 */

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var NetworkQualityLatencyStats =
/**
 * Construct a {@link NetworkQualityLatencyStats}.
 * @param {LatencyStats} latencyStats
 */
function NetworkQualityLatencyStats(_ref) {
  var _ref$jitter = _ref.jitter,
      jitter = _ref$jitter === undefined ? null : _ref$jitter,
      _ref$rtt = _ref.rtt,
      rtt = _ref$rtt === undefined ? null : _ref$rtt,
      _ref$level = _ref.level,
      level = _ref$level === undefined ? null : _ref$level;

  _classCallCheck(this, NetworkQualityLatencyStats);

  Object.defineProperties(this, {
    jitter: {
      value: jitter,
      enumerable: true
    },
    rtt: {
      value: rtt,
      enumerable: true
    },
    level: {
      value: level,
      enumerable: true
    }
  });
};

module.exports = NetworkQualityLatencyStats;
},{}],84:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var NetworkQualitySendStats = require('./networkqualitysendstats');
var NetworkQualityRecvStats = require('./networkqualityrecvstats');

/**
 * Network quality statistics shared between a {@link Participant}'s audio or video.
 * @property {NetworkQualityLevel} send - {@link NetworkQualityLevel} of the
 *  {@link Participant}'s published audio or video
 * @property {number} recv - {@link NetworkQualityLevel} of the
 *  {@link Participant}'s subscribed audio or video
 * @property {?NetworkQualitySendOrRecvStats} sendStats - {@link NetworkQualitySendOrRecvStats}
 *   based on which {@link NetworkQualityMediaStats}<code style="padding:0 0">#send</code>
 *   is calculated
 * @property {?NetworkQualitySendOrRecvStats} recvStats - {@link NetworkQualitySendOrRecvStats}
 *   based on which {@link NetworkQualityMediaStats}<code style="padding:0 0">#recv</code>
 *   is calculated
 */

var NetworkQualityMediaStats =
/**
 * Construct a {@link NetworkQualityMediaStats}.
 * @param {MediaLevels} mediaLevels
 */
function NetworkQualityMediaStats(_ref) {
  var send = _ref.send,
      recv = _ref.recv,
      _ref$sendStats = _ref.sendStats,
      sendStats = _ref$sendStats === undefined ? null : _ref$sendStats,
      _ref$recvStats = _ref.recvStats,
      recvStats = _ref$recvStats === undefined ? null : _ref$recvStats;

  _classCallCheck(this, NetworkQualityMediaStats);

  Object.defineProperties(this, {
    send: {
      value: send,
      enumerable: true
    },
    recv: {
      value: recv,
      enumerable: true
    },
    sendStats: {
      value: sendStats ? new NetworkQualitySendStats(sendStats) : null,
      enumerable: true
    },
    recvStats: {
      value: recvStats ? new NetworkQualityRecvStats(recvStats) : null,
      enumerable: true
    }
  });
};

module.exports = NetworkQualityMediaStats;
},{"./networkqualityrecvstats":85,"./networkqualitysendstats":87}],85:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var NetworkQualitySendOrRecvStats = require('./networkqualitysendorrecvstats');

/**
 * {@link NetworkQualitySendOrRecvStats} based on which a {@link Participant}'s
 * {@link NetworkQualityMediaStats}<code style="padding:0 0">#recv</code> is calculated.
 */

var NetworkQualityRecvStats = function (_NetworkQualitySendOr) {
  _inherits(NetworkQualityRecvStats, _NetworkQualitySendOr);

  /**
   * Construct a {@link NetworkQualityRecvStats}.
   * @param {SendOrRecvStats} sendOrRecvStats
   */
  function NetworkQualityRecvStats(sendOrRecvStats) {
    _classCallCheck(this, NetworkQualityRecvStats);

    return _possibleConstructorReturn(this, (NetworkQualityRecvStats.__proto__ || Object.getPrototypeOf(NetworkQualityRecvStats)).call(this, sendOrRecvStats));
  }

  return NetworkQualityRecvStats;
}(NetworkQualitySendOrRecvStats);

module.exports = NetworkQualityRecvStats;
},{"./networkqualitysendorrecvstats":86}],86:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var NetworkQualityBandwidthStats = require('./networkqualitybandwidthstats');
var NetworkQualityFractionLostStats = require('./networkqualityfractionloststats');
var NetworkQualityLatencyStats = require('./networkqualitylatencystats');

/**
 * Network quality statistics shared between {@link NetworkQualitySendStats} and
 * {@link NetworkQualityRecvStats} based on which a {@link Participant}'s
 * {@link NetworkQualityMediaStats}<code style="padding:0 0">#send</code> or
 * {@link NetworkQualityMediaStats}<code style="padding:0 0">#recv</code> is calculated.
 * @property {?NetworkQualityBandwidthStats} bandwidth - bandwidth statistics
 * @property {?NetworkQualityLatencyStats} latency - latency statistics
 * @property {?NetworkQualityFractionLostStats} fractionLost - fraction lost statistics
 */

var NetworkQualitySendOrRecvStats =
/**
 * Construct a {@link NetworkQualitySendOrRecvStats}.
 * @param {SendOrRecvStats} sendOrRecvStats
 */
function NetworkQualitySendOrRecvStats(_ref) {
  var _ref$bandwidth = _ref.bandwidth,
      bandwidth = _ref$bandwidth === undefined ? null : _ref$bandwidth,
      _ref$fractionLost = _ref.fractionLost,
      fractionLost = _ref$fractionLost === undefined ? null : _ref$fractionLost,
      _ref$latency = _ref.latency,
      latency = _ref$latency === undefined ? null : _ref$latency;

  _classCallCheck(this, NetworkQualitySendOrRecvStats);

  Object.defineProperties(this, {
    bandwidth: {
      value: bandwidth ? new NetworkQualityBandwidthStats(bandwidth) : null,
      enumerable: true
    },
    fractionLost: {
      value: fractionLost ? new NetworkQualityFractionLostStats(fractionLost) : null,
      enumerable: true
    },
    latency: {
      value: latency ? new NetworkQualityLatencyStats(latency) : null,
      enumerable: true
    }
  });
};

module.exports = NetworkQualitySendOrRecvStats;
},{"./networkqualitybandwidthstats":81,"./networkqualityfractionloststats":82,"./networkqualitylatencystats":83}],87:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var NetworkQualitySendOrRecvStats = require('./networkqualitysendorrecvstats');

/**
 * {@link NetworkQualitySendOrRecvStats} based on which a {@link Participant}'s
 * {@link NetworkQualityMediaStats}<code style="padding:0 0">#send</code> is calculated.
 */

var NetworkQualitySendStats = function (_NetworkQualitySendOr) {
  _inherits(NetworkQualitySendStats, _NetworkQualitySendOr);

  /**
   * Construct a {@link NetworkQualitySendStats}.
   * @param {SendOrRecvStats} sendOrRecvStats
   */
  function NetworkQualitySendStats(sendOrRecvStats) {
    _classCallCheck(this, NetworkQualitySendStats);

    return _possibleConstructorReturn(this, (NetworkQualitySendStats.__proto__ || Object.getPrototypeOf(NetworkQualitySendStats)).call(this, sendOrRecvStats));
  }

  return NetworkQualitySendStats;
}(NetworkQualitySendOrRecvStats);

module.exports = NetworkQualitySendStats;
},{"./networkqualitysendorrecvstats":86}],88:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var NetworkQualityAudioStats = require('./networkqualityaudiostats');
var NetworkQualityVideoStats = require('./networkqualityvideostats');

/**
 * Network quality statistics for a {@link Participant}.
 * @property {NetworkQualityLevel} level - {@link NetworkQualityLevel} of the {@link Participant}
 * @property {?NetworkQualityAudioStats} audio - {@link NetworkQualityMediaStats}
 *   for audio; <code>null</code> if {@link NetworkQualityVerbosity} is {@link NetworkQualityVerbosity}<code style="padding:0 0">#minimal</code>
 *   or below
 * @property {?NetworkQualityVideoStats} video - {@link NetworkQualityMediaStats}
 *   for video; <code>null</code> if {@link NetworkQualityVerbosity} is {@link NetworkQualityVerbosity}<code style="padding:0 0">#minimal</code>
 *   or below
 */

var NetworkQualityStats =
/**
 * Construct a {@link NetworkQualityStats}.
 * @param {NetworkQualityLevels} networkQualityLevels
 */
function NetworkQualityStats(_ref) {
  var level = _ref.level,
      audio = _ref.audio,
      video = _ref.video;

  _classCallCheck(this, NetworkQualityStats);

  Object.defineProperties(this, {
    level: {
      value: level,
      enumerable: true
    },
    audio: {
      value: audio ? new NetworkQualityAudioStats(audio) : null,
      enumerable: true
    },
    video: {
      value: video ? new NetworkQualityVideoStats(video) : null,
      enumerable: true
    }
  });
};

module.exports = NetworkQualityStats;
},{"./networkqualityaudiostats":80,"./networkqualityvideostats":89}],89:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var NetworkQualityMediaStats = require('./networkqualitymediastats');

/**
 * {@link NetworkQualityMediaStats} for a {@link Participant}'s video.
 */

var NetworkQualityVideoStats = function (_NetworkQualityMediaS) {
  _inherits(NetworkQualityVideoStats, _NetworkQualityMediaS);

  /**
   * Construct a {@link NetworkQualityVideoStats}.
   * @param {MediaLevels} mediaLevels
   */
  function NetworkQualityVideoStats(mediaLevels) {
    _classCallCheck(this, NetworkQualityVideoStats);

    return _possibleConstructorReturn(this, (NetworkQualityVideoStats.__proto__ || Object.getPrototypeOf(NetworkQualityVideoStats)).call(this, mediaLevels));
  }

  return NetworkQualityVideoStats;
}(NetworkQualityMediaStats);

module.exports = NetworkQualityVideoStats;
},{"./networkqualitymediastats":84}],90:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var ReceiverReport = require('./receiverreport');
var SenderReport = require('./senderreport');

/**
 * @interface SenderAndReceiverReports
 * @property {Array<SenderReport>} send
 * @property {Array<ReceiverReport>} recv
 */

/**
 * @interface SenderAndReceiverSummary
 * @property {SenderSummary} send
 * @property {ReceiverSummary} recv
 */

/**
 * @interface PeerConnectionSummary
 * @property {IceReport} ice
 * @property {SenderSummary} send
 * @property {ReceiverSummary} recv
 * @property {SenderAndReceiverSummary} audio
 * @property {SenderAndReceiverSummary} video
 */

/**
 * @property {IceReport} ice
 * @roperty {SenderAndReceiverReports} audio
 * @roperty {SenderAndReceiverReports} video
 */

var PeerConnectionReport = function () {
  /**
   * Construct a {@link PeerConnectionReport}.
   * @param {IceReport} ice
   * @param {SenderAndReceiverReports} audio
   * @param {SenderAndReceiverReports} video
   */
  function PeerConnectionReport(ice, audio, video) {
    _classCallCheck(this, PeerConnectionReport);

    Object.defineProperties(this, {
      ice: {
        enumerable: true,
        value: ice
      },
      audio: {
        enumerable: true,
        value: audio
      },
      video: {
        enumerable: true,
        value: video
      }
    });
  }

  /**
   * Summarize the {@link PeerConnectionReport} by summarizing its
   * {@link SenderReport}s and {@link ReceiverReport}s.
   * @returns {PeerConnectionSummary}
   */


  _createClass(PeerConnectionReport, [{
    key: 'summarize',
    value: function summarize() {
      var senderReports = this.audio.send.concat(this.video.send);
      var send = SenderReport.summarize(senderReports);

      var receiverReports = this.audio.recv.concat(this.video.recv);
      var recv = ReceiverReport.summarize(receiverReports);

      return {
        ice: this.ice,
        send: send,
        recv: recv,
        audio: {
          send: SenderReport.summarize(this.audio.send),
          recv: ReceiverReport.summarize(this.audio.recv)
        },
        video: {
          send: SenderReport.summarize(this.video.send),
          recv: ReceiverReport.summarize(this.video.recv)
        }
      };
    }
  }]);

  return PeerConnectionReport;
}();

module.exports = PeerConnectionReport;
},{"./receiverreport":92,"./senderreport":99}],91:[function(require,module,exports){
'use strict';

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _require = require('@twilio/webrtc/lib/util'),
    guessBrowser = _require.guessBrowser;

var IceReportFactory = require('./icereportfactory');
var PeerConnectionReport = require('./peerconnectionreport');
var ReceiverReportFactory = require('./receiverreportfactory');
var SenderReportFactory = require('./senderreportfactory');

/**
 * @typedef {string} TrackId
 */

/**
 * @typedef {string} StatsId
 */

/**
 * @interface SenderReportFactoriesByMediaType
 * @property {Map<StatsId, SenderReportFactory>} audio
 * @property {Map<StatsId, SenderReportFactory>} video
 */

/**
 * @interface ReceiverReportFactoriesByMediaType
 * @property {Map<StatsId, ReceiverReportFactory>} audio
 * @property {Map<StatsId, ReceiverReportFactory>} video
 */

/**
 * @interface SenderAndReceiverReportFactories
 * @property {Map<StatsId, SenderReportFactories>} send
 * @property {Map<StatsId, ReceiverReportFactories>} recv
 */

/**
 * @interface {StatsIdsByMediaType}
 * @property {Set<StatsId>} audio
 * @property {Set<StatsId>} video
 */

/**
 * @property {RTCPeerConnection} pc
 * @property {IceReportFactory} iceReportFactory
 * @property {SenderAndReceiverReportFactories} audio
 * @property {SenderAndReceiverReportFactories} video
 * @property {?PeerConnectionReport} lastReport
 */

var PeerConnectionReportFactory = function () {
  /**
   * Construct a {@link PeerConnectionReportFactory}.
   * @param {RTCPeerConnection} pc
   */
  function PeerConnectionReportFactory(pc) {
    _classCallCheck(this, PeerConnectionReportFactory);

    Object.defineProperties(this, {
      pc: {
        enumerable: true,
        value: pc
      },
      ice: {
        enumerable: true,
        value: new IceReportFactory()
      },
      audio: {
        enumerable: true,
        value: {
          send: new Map(),
          recv: new Map()
        }
      },
      video: {
        enumerable: true,
        value: {
          send: new Map(),
          recv: new Map()
        }
      },
      lastReport: {
        enumerable: true,
        value: null,
        writable: true
      }
    });
  }

  /**
   * Create a {@link PeerConnectionReport}.
   * @returns {Promise<PeerConnectionReport>}
   */


  _createClass(PeerConnectionReportFactory, [{
    key: 'next',
    value: function next() {
      var _this = this;

      var updatePromise = guessBrowser() === 'firefox' ? updateFirefox(this) : updateChrome(this);

      return updatePromise.then(function () {
        var audioSenderReportFactories = [].concat(_toConsumableArray(_this.audio.send.values()));
        var videoSenderReportFactories = [].concat(_toConsumableArray(_this.video.send.values()));
        var audioReceiverReportFactories = [].concat(_toConsumableArray(_this.audio.recv.values()));
        var videoReceiverReportFactories = [].concat(_toConsumableArray(_this.video.recv.values()));

        var report = new PeerConnectionReport(_this.ice.lastReport, {
          send: audioSenderReportFactories.map(function (factory) {
            return factory.lastReport;
          }).filter(function (report) {
            return report;
          }),
          recv: audioReceiverReportFactories.map(function (factory) {
            return factory.lastReport;
          }).filter(function (report) {
            return report;
          })
        }, {
          send: videoSenderReportFactories.map(function (factory) {
            return factory.lastReport;
          }).filter(function (report) {
            return report;
          }),
          recv: videoReceiverReportFactories.map(function (factory) {
            return factory.lastReport;
          }).filter(function (report) {
            return report;
          })
        });

        _this.lastReport = report;

        return report;
      });
    }
  }]);

  return PeerConnectionReportFactory;
}();

/**
 * Construct a Map from MediaStreamTrack Ids to RTCStatsReports.
 * @param {Array<RTCRtpSender>|Array<RTCRtpReceiver>} sendersOrReceivers - each
 *   RTCRtpSender should have a non-null track
 * @returns {Promise<Map<TrackId, RTCStats>>}
 */


function getSenderOrReceiverReports(sendersOrReceivers) {
  return Promise.all(sendersOrReceivers.map(function (senderOrReceiver) {
    var trackId = senderOrReceiver.track.id;
    return senderOrReceiver.getStats().then(function (report) {
      // NOTE(mroberts): We have to rewrite Ids due to this bug:
      //
      //   https://bugzilla.mozilla.org/show_bug.cgi?id=1463430
      //
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = report.values()[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var stats = _step.value;

          if (stats.type === 'inbound-rtp') {
            stats.id = trackId + '-' + stats.id;
          }
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return [trackId, report];
    });
  })).then(function (pairs) {
    return new Map(pairs);
  });
}

/**
 * @param {SenderReportFactory.constructor} SenderReportFactory
 * @param {SenderReportFactoriesByMediaType} sendersByMediaType
 * @param {RTCStatsReport} report
 * @param {RTCStats} stats
 * @param {TrackId} [trackId]
 * @returns {?SenderReportFactory}
 */ /**
    * @param {ReceiverReportFactory.constructor} ReceiverReportFactory
    * @param {ReceiverReportFactoriesByMediaType} receiversByMediaType
    * @param {RTCStatsReport} report
    * @param {RTCStats} stats
    * @param {TrackId} [trackId]
    * @returns {?ReceiverReportFactory}
    */
function getOrCreateSenderOrReceiverReportFactory(SenderOrReceiverReportFactory, sendersOrReceiversByMediaType, report, stats, trackId) {
  var sendersOrReceivers = sendersOrReceiversByMediaType[stats.mediaType];
  if (!trackId) {
    var trackStats = report.get(stats.trackId);
    if (trackStats) {
      trackId = trackStats.trackIdentifier;
    }
  }
  if (sendersOrReceivers && trackId) {
    if (sendersOrReceivers.has(stats.id)) {
      return sendersOrReceivers.get(stats.id);
    }
    var senderOrReceiverFactory = new SenderOrReceiverReportFactory(trackId, stats);
    sendersOrReceivers.set(stats.id, senderOrReceiverFactory);
  }
  return null;
}

/**
 * @param {PeerConnectionReportFactory} factory
 * @returns {SenderReportFactoriesByMediaType}
 */
function getSenderReportFactoriesByMediaType(factory) {
  return { audio: factory.audio.send, video: factory.video.send };
}

/**
 * @param {PeerConnectionReportFactory} factory
 * @returns {ReceiverReportFactoriesByMediaType}
 */
function getReceiverReportFactoriesByMediaType(factory) {
  return { audio: factory.audio.recv, video: factory.video.recv };
}

/**
 * @param {PeerConnectionReportFactory} factory
 * @param {RTCStatsReport} report
 * @param {RTCStats} stats
 * @param {TrackId} [trackId]
 * @returns {?SenderReportFactory}
 */
function getOrCreateSenderReportFactory(factory, report, stats, trackId) {
  return getOrCreateSenderOrReceiverReportFactory(SenderReportFactory, getSenderReportFactoriesByMediaType(factory), report, stats, trackId);
}

/**
 * @param {PeerConnectionReportFactory} factory
 * @param {RTCStatsReport} report
 * @param {RTCStats} stats
 * @param {TrackId} [trackId]
 * @returns {?ReceiverReportFactory}
 */
function getOrCreateReceiverReportFactory(factory, report, stats, trackId) {
  return getOrCreateSenderOrReceiverReportFactory(ReceiverReportFactory, getReceiverReportFactoriesByMediaType(factory), report, stats, trackId);
}

/**
 * @param {PeerConnectionReportFactory} factory
 * @retuns {StatsIdsByMediaType}
 */
function getSenderReportFactoryIdsByMediaType(factory) {
  return {
    audio: new Set(factory.audio.send.keys()),
    video: new Set(factory.video.send.keys())
  };
}

/**
 * @param {PeerConnectionReportFactory} factory
 * @retuns {StatsIdsByMediaType}
 */
function getReceiverReportFactoryIdsByMediaType(factory) {
  return {
    audio: new Set(factory.audio.recv.keys()),
    video: new Set(factory.video.recv.keys())
  };
}

/**
 * @param {PeerConnectionReportFactory} factory
 * @param {RTCStatsReport} report
 * @param {StatsIdsByMediaType} senderReportFactoryIdsToDeleteByMediaType
 * @param {TrackId} [trackId]
 * @returns {void}
 */
function updateSenderReports(factory, report, senderReportFactoryIdsToDeleteByMediaType, trackId) {
  var _iteratorNormalCompletion2 = true;
  var _didIteratorError2 = false;
  var _iteratorError2 = undefined;

  try {
    for (var _iterator2 = report.values()[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
      var stats = _step2.value;

      if (stats.type === 'outbound-rtp' && !stats.isRemote) {
        if (guessBrowser() !== 'firefox' && !stats.trackId) {
          continue;
        }
        var senderReportFactoryIdsToDelete = senderReportFactoryIdsToDeleteByMediaType[stats.mediaType];
        if (senderReportFactoryIdsToDelete) {
          senderReportFactoryIdsToDelete.delete(stats.id);
        }
        var senderReportFactory = getOrCreateSenderReportFactory(factory, report, stats, trackId);
        if (senderReportFactory) {
          var remoteInboundStats = report.get(stats.remoteId);
          senderReportFactory.next(trackId || senderReportFactory.trackId, stats, remoteInboundStats);
        }
      }
    }
  } catch (err) {
    _didIteratorError2 = true;
    _iteratorError2 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion2 && _iterator2.return) {
        _iterator2.return();
      }
    } finally {
      if (_didIteratorError2) {
        throw _iteratorError2;
      }
    }
  }
}

/**
 * @param {PeerConnectionReportFactory} factory
 * @param {RTCStatsReport} report
 * @param {StatsIdsByMediaType} receiverReportFactoryIdsToDeleteByMediaType
 * @param {TrackId} [trackId]
 * @returns {void}
 */
function updateReceiverReports(factory, report, receiverReportFactoryIdsToDeleteByMediaType, trackId) {
  var _iteratorNormalCompletion3 = true;
  var _didIteratorError3 = false;
  var _iteratorError3 = undefined;

  try {
    for (var _iterator3 = report.values()[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
      var stats = _step3.value;

      if (stats.type === 'inbound-rtp' && !stats.isRemote) {
        var receiverReportFactoryIdsToDelete = receiverReportFactoryIdsToDeleteByMediaType[stats.mediaType];
        if (receiverReportFactoryIdsToDelete) {
          receiverReportFactoryIdsToDelete.delete(stats.id);
        }
        var receiverReportFactory = getOrCreateReceiverReportFactory(factory, report, stats, trackId);
        if (receiverReportFactory) {
          receiverReportFactory.next(trackId || receiverReportFactory.trackId, stats);
        }
      }
    }
  } catch (err) {
    _didIteratorError3 = true;
    _iteratorError3 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion3 && _iterator3.return) {
        _iterator3.return();
      }
    } finally {
      if (_didIteratorError3) {
        throw _iteratorError3;
      }
    }
  }
}

/**
 * @param {SenderReportFactoriesByMediaType|ReceiverReportFactoriesByMediaType} senderOrReceiverReportFactoriesByMediaType
 * @param {StatsIdsByMediaType} senderOrReceiverReportFactoryIdsByMediaType
 * @returns {void}
 */
function deleteSenderOrReceiverReportFactories(senderOrReceiverReportFactoriesByMediaType, senderOrReceiverReportFactoryIdsByMediaType) {
  var _loop = function _loop(mediaType) {
    var senderOrReceiverReportFactories = senderOrReceiverReportFactoriesByMediaType[mediaType];
    var senderOrReceiverReportFactoryIds = senderOrReceiverReportFactoryIdsByMediaType[mediaType];
    senderOrReceiverReportFactoryIds.forEach(function (senderOrReceiverReportFactoryId) {
      return senderOrReceiverReportFactories.delete(senderOrReceiverReportFactoryId);
    });
  };

  for (var mediaType in senderOrReceiverReportFactoryIdsByMediaType) {
    _loop(mediaType);
  }
}

/**
 * @param {IceReportFactory} ice
 * @param {RTCStatsReport} report
 * @returns {void}
 */
function updateIceReport(ice, report) {
  var selectedCandidatePair = void 0;
  var _iteratorNormalCompletion4 = true;
  var _didIteratorError4 = false;
  var _iteratorError4 = undefined;

  try {
    for (var _iterator4 = report.values()[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
      var stats = _step4.value;

      if (stats.type === 'transport') {
        selectedCandidatePair = report.get(stats.selectedCandidatePairId);
      }
    }
  } catch (err) {
    _didIteratorError4 = true;
    _iteratorError4 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion4 && _iterator4.return) {
        _iterator4.return();
      }
    } finally {
      if (_didIteratorError4) {
        throw _iteratorError4;
      }
    }
  }

  if (selectedCandidatePair) {
    ice.next(selectedCandidatePair);
    return;
  }
  var _iteratorNormalCompletion5 = true;
  var _didIteratorError5 = false;
  var _iteratorError5 = undefined;

  try {
    for (var _iterator5 = report.values()[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done); _iteratorNormalCompletion5 = true) {
      var _stats = _step5.value;

      if (_stats.type === 'candidate-pair' && _stats.nominated && ('selected' in _stats ? _stats.selected : true)) {
        ice.next(_stats);
      }
    }
  } catch (err) {
    _didIteratorError5 = true;
    _iteratorError5 = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion5 && _iterator5.return) {
        _iterator5.return();
      }
    } finally {
      if (_didIteratorError5) {
        throw _iteratorError5;
      }
    }
  }
}

/**
 * @param {PeerConnectionReportFactory} factory
 * @returns {Promise<PeerConnectionReport>}
 */
function updateFirefox(factory) {
  var senders = factory.pc.getTransceivers().filter(function (transceiver) {
    return transceiver.currentDirection && transceiver.currentDirection.match(/send/) && transceiver.sender.track;
  }).map(function (transceiver) {
    return transceiver.sender;
  });

  var receivers = factory.pc.getTransceivers().filter(function (transceiver) {
    return transceiver.currentDirection && transceiver.currentDirection.match(/recv/);
  }).map(function (transceiver) {
    return transceiver.receiver;
  });

  return Promise.all([getSenderOrReceiverReports(senders), getSenderOrReceiverReports(receivers), factory.pc.getStats()]).then(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 3),
        senderReports = _ref2[0],
        receiverReports = _ref2[1],
        pcReport = _ref2[2];

    var senderReportFactoriesByMediaType = getSenderReportFactoriesByMediaType(factory);
    var senderReportFactoryIdsToDeleteByMediaType = getSenderReportFactoryIdsByMediaType(factory);
    senderReports.forEach(function (report, trackId) {
      return updateSenderReports(factory, report, senderReportFactoryIdsToDeleteByMediaType, trackId);
    });
    deleteSenderOrReceiverReportFactories(senderReportFactoriesByMediaType, senderReportFactoryIdsToDeleteByMediaType);

    var receiverReportFactoriesByMediaType = getReceiverReportFactoriesByMediaType(factory);
    var receiverReportFactoryIdsToDeleteByMediaType = getReceiverReportFactoryIdsByMediaType(factory);
    receiverReports.forEach(function (report, trackId) {
      return updateReceiverReports(factory, report, receiverReportFactoryIdsToDeleteByMediaType, trackId);
    });
    deleteSenderOrReceiverReportFactories(receiverReportFactoriesByMediaType, receiverReportFactoryIdsToDeleteByMediaType);

    updateIceReport(factory.ice, pcReport);
  });
}

/**
 * @param {PeerConnectionReportFactory} factory
 * @returns {Promise<PeerConnectionReport>}
 */
function updateChrome(factory) {
  return factory.pc.getStats().then(function (report) {
    var senderReportFactoriesByMediaType = getSenderReportFactoriesByMediaType(factory);
    var senderReportFactoryIdsToDeleteByMediaType = getSenderReportFactoryIdsByMediaType(factory);
    updateSenderReports(factory, report, senderReportFactoryIdsToDeleteByMediaType);
    deleteSenderOrReceiverReportFactories(senderReportFactoriesByMediaType, senderReportFactoryIdsToDeleteByMediaType);

    var receiverReportFactoriesByMediaType = getReceiverReportFactoriesByMediaType(factory);
    var receiverReportFactoryIdsToDeleteByMediaType = getReceiverReportFactoryIdsByMediaType(factory);
    updateReceiverReports(factory, report, receiverReportFactoryIdsToDeleteByMediaType);
    deleteSenderOrReceiverReportFactories(receiverReportFactoriesByMediaType, receiverReportFactoryIdsToDeleteByMediaType);

    updateIceReport(factory.ice, report);
  });
}

module.exports = PeerConnectionReportFactory;
},{"./icereportfactory":76,"./peerconnectionreport":90,"./receiverreportfactory":93,"./senderreportfactory":100,"@twilio/webrtc/lib/util":149}],92:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var average = require('./average');
var SenderOrReceiverReport = require('./senderorreceiverreport');
var sum = require('./sum');

/**
 * @interface ReceiverSummary
 * @property {number} bitrate
 * @property {number} fractionLost - 0–1
 * @property {number} [jitter] - s (undefined for video tracks in Chrome)
 */

/**
 * @extends SenderOrReceiverReport
 * @property {number} deltaPacketsLost
 * @property {number} deltaPacketsReceived
 * @property {number} [fractionLost] - 0–1 (undefined in Firefox)
 * @property {number} [jitter] - s (undefined for video tracks in Chrome)
 * @property {number} phonyPacketsLost - 0–1
 */

var ReceiverReport = function (_SenderOrReceiverRepo) {
  _inherits(ReceiverReport, _SenderOrReceiverRepo);

  /**
   * @param {StatsId} id
   * @param {TrackId} trackId
   * @param {number} bitrate - bps
   * @param {number} deltaPacketsLost
   * @param {number} deltaPacketsReceived
   * @param {number} [fractionLost] - 0–1 (undefined in Firefox)
   * @param {number} [jitter] - s (undefined for video tracks in Chrome)
   */
  function ReceiverReport(id, trackId, bitrate, deltaPacketsLost, deltaPacketsReceived, fractionLost, jitter) {
    _classCallCheck(this, ReceiverReport);

    var _this = _possibleConstructorReturn(this, (ReceiverReport.__proto__ || Object.getPrototypeOf(ReceiverReport)).call(this, id, trackId, bitrate));

    var phonyFractionLost = deltaPacketsReceived > 0 ? deltaPacketsLost / deltaPacketsReceived : 0;
    Object.defineProperties(_this, {
      deltaPacketsLost: {
        enumerable: true,
        value: deltaPacketsLost
      },
      deltaPacketsReceived: {
        enumerable: true,
        value: deltaPacketsReceived
      },
      fractionLost: {
        enumerable: true,
        value: fractionLost
      },
      jitter: {
        enumerable: true,
        value: jitter
      },
      phonyFractionLost: {
        enumerable: true,
        value: phonyFractionLost
      }
    });
    return _this;
  }

  /**
   * Create a {@link ReceiverReport}.
   * @param {string} trackId
   * @param {RTCStats} olderStats
   * @param {RTCStats} newerStats
   * @returns {ReceiverReport}
   */


  _createClass(ReceiverReport, [{
    key: 'summarize',


    /**
     * Summarize the {@link ReceiveReport}.
     * @returns {ReceiverSummary}
     */
    value: function summarize() {
      return {
        bitrate: this.bitrate,
        fractionLost: typeof this.fractionLost === 'number' ? this.fractionLost : this.phonyFractionLost,
        jitter: this.jitter
      };
    }
  }], [{
    key: 'of',
    value: function of(trackId, olderStats, newerStats) {
      if (olderStats.id !== newerStats.id) {
        throw new Error('RTCStats IDs must match');
      }
      var secondsElapsed = (newerStats.timestamp - olderStats.timestamp) / 1000;
      var deltaBytesReceived = newerStats.bytesReceived - olderStats.bytesReceived;
      var bitrate = secondsElapsed > 0 ? deltaBytesReceived / secondsElapsed * 8 : 0;
      var deltaPacketsLost = Math.max(newerStats.packetsLost - olderStats.packetsLost, 0);
      var deltaPacketsReceived = newerStats.packetsReceived - olderStats.packetsReceived;
      var fractionLost = newerStats.fractionLost,
          jitter = newerStats.jitter;

      return new ReceiverReport(olderStats.id, trackId, bitrate, deltaPacketsLost, deltaPacketsReceived, fractionLost, jitter);
    }

    /**
     * Summarize {@link ReceiverReport}s by summing and averaging their values.
     * @param {Array<ReceiverReport>} reports
     * @returns {ReceiverSummary}
     */

  }, {
    key: 'summarize',
    value: function summarize(reports) {
      var summaries = reports.map(function (report) {
        return report.summarize();
      });
      var bitrate = sum(summaries.map(function (summary) {
        return summary.bitrate;
      }));
      var fractionLost = average(summaries.map(function (summary) {
        return summary.fractionLost;
      }));
      var jitter = average(summaries.map(function (summary) {
        return summary.jitter;
      }));
      return {
        bitrate: bitrate,
        fractionLost: fractionLost,
        jitter: jitter
      };
    }
  }]);

  return ReceiverReport;
}(SenderOrReceiverReport);

module.exports = ReceiverReport;
},{"./average":74,"./senderorreceiverreport":97,"./sum":102}],93:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var ReceiverReport = require('./receiverreport');
var SenderOrReceiverReportFactory = require('./senderorreceiverreportfactory');

/**
 * @extends SenderOrReceiverReportFactory
 * @param {?ReceiverReport} lastReport
 */

var ReceiverReportFactory = function (_SenderOrReceiverRepo) {
  _inherits(ReceiverReportFactory, _SenderOrReceiverRepo);

  /**
   * Construct a {@link ReceiverReportFactory}.
   * @param {TrackId} trackId
   * @param {RTCStats} initialStats
   */
  function ReceiverReportFactory(trackId, initialStats) {
    _classCallCheck(this, ReceiverReportFactory);

    var _this = _possibleConstructorReturn(this, (ReceiverReportFactory.__proto__ || Object.getPrototypeOf(ReceiverReportFactory)).call(this, initialStats.id, trackId, initialStats));

    Object.defineProperties(_this, {
      lastReport: {
        enumerable: true,
        value: null,
        writable: true
      }
    });
    return _this;
  }

  /**
   * Create a {@link ReceiverReport}.
   * @param {TrackId} trackId
   * @param {RTCStats} newerStats
   * @returns {ReceiverReport}
   */


  _createClass(ReceiverReportFactory, [{
    key: 'next',
    value: function next(trackId, newerStats) {
      var olderStats = this.lastStats;
      this.lastStats = newerStats;
      this.trackId = trackId;
      var report = ReceiverReport.of(trackId, olderStats, newerStats);
      this.lastReport = report;
      return report;
    }
  }]);

  return ReceiverReportFactory;
}(SenderOrReceiverReportFactory);

module.exports = ReceiverReportFactory;
},{"./receiverreport":92,"./senderorreceiverreportfactory":98}],94:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var RemoteTrackStats = require('./remotetrackstats');

/**
 * Statistics for an {@link AudioTrack}.
 * @extends RemoteTrackStats
 * @property {?AudioLevel} audioLevel - Output {@link AudioLevel}
 * @property {?number} jitter - Audio jitter in milliseconds
 */

var RemoteAudioTrackStats = function (_RemoteTrackStats) {
  _inherits(RemoteAudioTrackStats, _RemoteTrackStats);

  /**
   * @param {string} trackId - {@link AudioTrack} ID
   * @param {StandardizedTrackStatsReport} statsReport
   */
  function RemoteAudioTrackStats(trackId, statsReport) {
    _classCallCheck(this, RemoteAudioTrackStats);

    var _this = _possibleConstructorReturn(this, (RemoteAudioTrackStats.__proto__ || Object.getPrototypeOf(RemoteAudioTrackStats)).call(this, trackId, statsReport));

    Object.defineProperties(_this, {
      audioLevel: {
        value: typeof statsReport.audioOutputLevel === 'number' ? statsReport.audioOutputLevel : null,
        enumerable: true
      },
      jitter: {
        value: typeof statsReport.jitter === 'number' ? statsReport.jitter : null,
        enumerable: true
      }
    });
    return _this;
  }

  return RemoteAudioTrackStats;
}(RemoteTrackStats);

module.exports = RemoteAudioTrackStats;
},{"./remotetrackstats":95}],95:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TrackStats = require('./trackstats');

/**
 * Statistics for a remote {@link Track}.
 * @extends TrackStats
 * @property {?number} bytesReceived - Number of bytes received
 * @property {?number} packetsReceived - Number of packets received
 */

var RemoteTrackStats = function (_TrackStats) {
  _inherits(RemoteTrackStats, _TrackStats);

  /*
   * @param {string} trackId - {@link Track} ID
   * @param {StandardizedTrackStatsReport} statsReport
   */
  function RemoteTrackStats(trackId, statsReport) {
    _classCallCheck(this, RemoteTrackStats);

    var _this = _possibleConstructorReturn(this, (RemoteTrackStats.__proto__ || Object.getPrototypeOf(RemoteTrackStats)).call(this, trackId, statsReport));

    Object.defineProperties(_this, {
      bytesReceived: {
        value: typeof statsReport.bytesReceived === 'number' ? statsReport.bytesReceived : null,
        enumerable: true
      },
      packetsReceived: {
        value: typeof statsReport.packetsReceived === 'number' ? statsReport.packetsReceived : null,
        enumerable: true
      }
    });
    return _this;
  }

  return RemoteTrackStats;
}(TrackStats);

module.exports = RemoteTrackStats;
},{"./trackstats":103}],96:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var RemoteTrackStats = require('./remotetrackstats');

/**
 * Statistics for a {@link VideoTrack}.
 * @extends RemoteTrackStats
 * @property {?VideoTrack#Dimensions} dimensions - Received video resolution
 * @property {?number} frameRate - Received video frame rate
 */

var RemoteVideoTrackStats = function (_RemoteTrackStats) {
  _inherits(RemoteVideoTrackStats, _RemoteTrackStats);

  /**
   * @param {string} trackId - {@link VideoTrack} ID
   * @param {StandardizedTrackStatsReport} statsReport
   */
  function RemoteVideoTrackStats(trackId, statsReport) {
    _classCallCheck(this, RemoteVideoTrackStats);

    var _this = _possibleConstructorReturn(this, (RemoteVideoTrackStats.__proto__ || Object.getPrototypeOf(RemoteVideoTrackStats)).call(this, trackId, statsReport));

    var dimensions = null;
    if (typeof statsReport.frameWidthReceived === 'number' && typeof statsReport.frameHeightReceived === 'number') {
      dimensions = {};

      Object.defineProperties(dimensions, {
        width: {
          value: statsReport.frameWidthReceived,
          enumerable: true
        },
        height: {
          value: statsReport.frameHeightReceived,
          enumerable: true
        }
      });
    }

    Object.defineProperties(_this, {
      dimensions: {
        value: dimensions,
        enumerable: true
      },
      frameRate: {
        value: typeof statsReport.frameRateReceived === 'number' ? statsReport.frameRateReceived : null,
        enumerable: true
      }
    });
    return _this;
  }

  return RemoteVideoTrackStats;
}(RemoteTrackStats);

module.exports = RemoteVideoTrackStats;
},{"./remotetrackstats":95}],97:[function(require,module,exports){
'use strict';

/**
 * @property {StatsId} id
 * @property {TrackId} trackId
 * @property {number} bitrate - bps
 */

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var SenderOrReceiverReport =
/**
 * Construct a {@link SenderOrReceiverReport}.
 * @param {StatsId} id
 * @param {TrackId} trackId
 * @param {number} bitrate - bps
 */
function SenderOrReceiverReport(id, trackId, bitrate) {
  _classCallCheck(this, SenderOrReceiverReport);

  Object.defineProperties(this, {
    id: {
      enumerable: true,
      value: id
    },
    trackId: {
      enumerable: true,
      value: trackId
    },
    bitrate: {
      enumerable: true,
      value: bitrate
    }
  });
};

module.exports = SenderOrReceiverReport;
},{}],98:[function(require,module,exports){
'use strict';

/**
 * @property {StatsId} id
 * @property {TrackId} trackId
 * @property {RTCStats} lastStats
 */

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var SenderOrReceiverReportFactory =
/**
 * @param {StatsId} id
 * @param {TrackId} trackId
 * @param {RTCStats} initialStats
 */
function SenderOrReceiverReportFactory(id, trackId, initialStats) {
  _classCallCheck(this, SenderOrReceiverReportFactory);

  Object.defineProperties(this, {
    id: {
      enumerable: true,
      value: id,
      writable: true
    },
    trackId: {
      enumerable: true,
      value: trackId,
      writable: true
    },
    lastStats: {
      enumerable: true,
      value: initialStats,
      writable: true
    }
  });
};

module.exports = SenderOrReceiverReportFactory;
},{}],99:[function(require,module,exports){
/* eslint no-undefined:0 */
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var average = require('./average');
var SenderOrReceiverReport = require('./senderorreceiverreport');
var sum = require('./sum');

/**
 * @interface SenderSummary
 * @property {number} bitrate
 * @property {number} [rtt] - s (undefined in Chrome)
 */

/**
 * @extends SenderOrReceiverReport
 * @property {number} [rtt] - s (undefined in Chrome)
 */

var SenderReport = function (_SenderOrReceiverRepo) {
  _inherits(SenderReport, _SenderOrReceiverRepo);

  /**
   * Construct a {@link SenderReport}.
   * @param {StatsId} id
   * @param {TrackId} trackId
   * @param {number} bitrate - bps
   * @param {number} [rtt] - s
   */
  function SenderReport(id, trackId, bitrate, rtt) {
    _classCallCheck(this, SenderReport);

    var _this = _possibleConstructorReturn(this, (SenderReport.__proto__ || Object.getPrototypeOf(SenderReport)).call(this, id, trackId, bitrate));

    Object.defineProperties(_this, {
      rtt: {
        enumerable: true,
        value: rtt
      }
    });
    return _this;
  }

  /**
   * Create a {@link SenderReport}.
   * @param {string} trackId
   * @param {RTCStats} olderStats
   * @param {RTCStats} newerStats
   * @param {RTCRemoteInboundRtpStreamStats} [newerRemoteStats]
   * @returns {SenderReport}
   */


  _createClass(SenderReport, null, [{
    key: 'of',
    value: function of(trackId, olderStats, newerStats, newerRemoteStats) {
      if (olderStats.id !== newerStats.id) {
        throw new Error('RTCStats IDs must match');
      }
      var secondsElapsed = (newerStats.timestamp - olderStats.timestamp) / 1000;
      var deltaBytesSent = newerStats.bytesSent - olderStats.bytesSent;
      var bitrate = secondsElapsed > 0 ? deltaBytesSent / secondsElapsed * 8 : 0;
      var rtt = newerRemoteStats && typeof newerRemoteStats.roundTripTime === 'number' ? newerRemoteStats.roundTripTime / 1000 : undefined;
      return new SenderReport(olderStats.id, trackId, bitrate, rtt);
    }

    /**
     * Summarize {@link SenderReport}s by summing and averaging their values.
     * @param {Array<SenderReport>} reports
     * @returns {SenderSummary}
     */

  }, {
    key: 'summarize',
    value: function summarize(reports) {
      var bitrate = sum(reports.map(function (report) {
        return report.bitrate;
      }));
      var rtt = average(reports.map(function (report) {
        return report.rtt;
      }));
      return {
        bitrate: bitrate,
        rtt: rtt
      };
    }
  }]);

  return SenderReport;
}(SenderOrReceiverReport);

module.exports = SenderReport;
},{"./average":74,"./senderorreceiverreport":97,"./sum":102}],100:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var SenderOrReceiverReportFactory = require('./senderorreceiverreportfactory');
var SenderReport = require('./senderreport');

/**
 * @extends {SenderOrReceiverReportFactory}
 * @property {?SenderReport} lastReport
 */

var SenderReportFactory = function (_SenderOrReceiverRepo) {
  _inherits(SenderReportFactory, _SenderOrReceiverRepo);

  /**
   * Construct a {@link SenderReportFactory}.
   * @param {TrackId} trackId
   * @param {RTCStats} initialStats
   */
  function SenderReportFactory(trackId, initialStats) {
    _classCallCheck(this, SenderReportFactory);

    var _this = _possibleConstructorReturn(this, (SenderReportFactory.__proto__ || Object.getPrototypeOf(SenderReportFactory)).call(this, initialStats.id, trackId, initialStats));

    Object.defineProperties(_this, {
      lastReport: {
        enumerable: true,
        value: null,
        writable: true
      }
    });
    return _this;
  }

  /**
   * @param {TrackId} trackId
   * @param {RTCStats} newerStats
   * @param {RTCRemoteInboundRtpStreamStats} [newerRemoteStats]
   * @returns {SenderReport}
   */


  _createClass(SenderReportFactory, [{
    key: 'next',
    value: function next(trackId, newerStats, newerRemoteStats) {
      var olderStats = this.lastStats;
      this.lastStats = newerStats;
      this.trackId = trackId;
      var report = SenderReport.of(trackId, olderStats, newerStats, newerRemoteStats);
      this.lastReport = report;
      return report;
    }
  }]);

  return SenderReportFactory;
}(SenderOrReceiverReportFactory);

module.exports = SenderReportFactory;
},{"./senderorreceiverreportfactory":98,"./senderreport":99}],101:[function(require,module,exports){
'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var LocalAudioTrackStats = require('./localaudiotrackstats');
var LocalVideoTrackStats = require('./localvideotrackstats');
var RemoteAudioTrackStats = require('./remoteaudiotrackstats');
var RemoteVideoTrackStats = require('./remotevideotrackstats');

/**
 * Statistics report for an RTCPeerConnection.
 * @property {string} peerConnectionId - ID of the RTCPeerConnection
 * @property {Array<LocalAudioTrackStats>} localAudioTrackStats - List of {@link LocalAudioTrackStats}
 * @property {Array<LocalVideoTrackStats>} localVideoTrackStats - List of {@link LocalVideoTrackStats}
 * @property {Array<RemoteAudioTrackStats>} remoteAudioTrackStats - List of {@link RemoteAudioTrackStats}
 * @property {Array<RemoteVideoTrackStats>} remoteVideoTrackStats - List of {@link RemoteVideoTrackStats}
 */

var StatsReport =
/**
 * @param {string} peerConnectionId - RTCPeerConnection ID
 * @param {StandardizedStatsResponse} statsResponse
 * @param {boolean} prepareForInsights - if report is being prepared to send to insights.
 */
function StatsReport(peerConnectionId, statsResponse, prepareForInsights) {
  _classCallCheck(this, StatsReport);

  if (typeof peerConnectionId !== 'string') {
    throw new Error('RTCPeerConnection id must be a string');
  }

  Object.defineProperties(this, {
    peerConnectionId: {
      value: peerConnectionId,
      enumerable: true
    },
    localAudioTrackStats: {
      value: statsResponse.localAudioTrackStats.map(function (report) {
        return new LocalAudioTrackStats(report.trackId, report, prepareForInsights);
      }),
      enumerable: true
    },
    localVideoTrackStats: {
      value: statsResponse.localVideoTrackStats.map(function (report) {
        return new LocalVideoTrackStats(report.trackId, report, prepareForInsights);
      }),
      enumerable: true
    },
    remoteAudioTrackStats: {
      value: statsResponse.remoteAudioTrackStats.map(function (report) {
        return new RemoteAudioTrackStats(report.trackId, report);
      }),
      enumerable: true
    },
    remoteVideoTrackStats: {
      value: statsResponse.remoteVideoTrackStats.map(function (report) {
        return new RemoteVideoTrackStats(report.trackId, report);
      }),
      enumerable: true
    }
  });
};

module.exports = StatsReport;
},{"./localaudiotrackstats":77,"./localvideotrackstats":79,"./remoteaudiotrackstats":94,"./remotevideotrackstats":96}],102:[function(require,module,exports){
'use strict';

/**
 * @param {Array<number|undefined>} xs
 * @returns {number}
 */

function sum(xs) {
  return xs.reduce(function (y, x) {
    return typeof x === 'number' ? x + y : y;
  }, 0);
}

module.exports = sum;
},{}],103:[function(require,module,exports){
'use strict';

/**
 * Statistics for a {@link Track}.
 * @property {Track.ID} trackId - The {@link Track} ID
 * @property {Track.SID} trackSid - The {@link Track}'s SID when published in
 *  in a {@link Room}
 * @property {number} timestamp - A Unix timestamp in milliseconds indicating
 *   when the {@link TrackStats} were gathered
 * @property {string} ssrc - The {@link Track}'s SSRC when transmitted over the
 *   RTCPeerConnection
 * @property {?number} packetsLost - The number of packets lost
 * @property {?string} codec - The name of the codec used to encode the
 *   {@link Track}'s media
 */

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var TrackStats =
/**
 * @param {string} trackId - {@link Track} ID
 * @param {StandardizedTrackStatsReport} statsReport
 */
function TrackStats(trackId, statsReport) {
  _classCallCheck(this, TrackStats);

  if (typeof trackId !== 'string') {
    throw new Error('Track id must be a string');
  }

  Object.defineProperties(this, {
    trackId: {
      value: trackId,
      enumerable: true
    },
    trackSid: {
      value: statsReport.trackSid,
      enumerable: true
    },
    timestamp: {
      value: statsReport.timestamp,
      enumerable: true
    },
    ssrc: {
      value: statsReport.ssrc,
      enumerable: true
    },
    packetsLost: {
      value: typeof statsReport.packetsLost === 'number' ? statsReport.packetsLost : null,
      enumerable: true
    },
    codec: {
      value: typeof statsReport.codecName === 'string' ? statsReport.codecName : null,
      enumerable: true
    }
  });
};

module.exports = TrackStats;
},{}],104:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EventEmitter = require('events').EventEmitter;

/**
 * A {@link TrackTransceiver} represents either one or more local RTCRtpSenders
 * or RTCDataChannels, or a single RTCRtpReceiver or remote RTCDataChannel.
 * @extends EventEmitter
 * @property {Track.ID} id
 * @property {Track.kind} kind
 */

var TrackTransceiver = function (_EventEmitter) {
  _inherits(TrackTransceiver, _EventEmitter);

  /**
   * Construct a {@link TrackTransceiver}.
   * @param {Track.ID} id
   * @param {Track.kind} kind
   */
  function TrackTransceiver(id, kind) {
    _classCallCheck(this, TrackTransceiver);

    var _this = _possibleConstructorReturn(this, (TrackTransceiver.__proto__ || Object.getPrototypeOf(TrackTransceiver)).call(this));

    Object.defineProperties(_this, {
      id: {
        enumerable: true,
        value: id
      },
      kind: {
        enumerable: true,
        value: kind
      }
    });
    return _this;
  }

  /**
   * Stop the {@link TrackTransceiver}.
   * #emits TrackTransceiver#stopped
   * @returns {void}
   */


  _createClass(TrackTransceiver, [{
    key: 'stop',
    value: function stop() {
      this.emit('stopped');
    }
  }]);

  return TrackTransceiver;
}(EventEmitter);

/**
 * The {@link TrackTransceiver} was stopped.
 * @event TrackTransceiver#stopped
 */

module.exports = TrackTransceiver;
},{"events":165}],105:[function(require,module,exports){
(function (global){(function (){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var StateMachine = require('./statemachine');

var _require = require('./util'),
    buildLogLevels = _require.buildLogLevels,
    makeUUID = _require.makeUUID;

var Log = require('./util/log');
var NetworkMonitor = require('./util/networkmonitor');
var Timeout = require('./util/timeout');

var nInstances = 0;

/*
  TwilioConnection states
  -----------------------

       ------------------------------------------
       |                                        |
       |                                        v
  +---------+       +--------------+       +----------+
  |  early  | ----> |  connecting  | ----> |  closed  |
  +---------+       +--------------+       +----------+
    ^                     | ^ |                 ^ ^
    | --------------------- | |                 | |
    | | --------------------- |                 | |
    | | | --------------------|------------------ |
    | v | |                   v                   |
  +----------+           +--------+               |
  | waiting  | --------> |  open  | ---------------
  +----------+           +--------+
 */

var states = {
  closed: [],
  connecting: ['closed', 'open', 'waiting'],
  early: ['closed', 'connecting'],
  open: ['closed'],
  waiting: ['closed', 'connecting', 'early', 'open']
};

var events = {
  closed: 'close',
  open: 'open',
  waiting: 'waiting'
};

var TCMP_VERSION = 2;

var DEFAULT_MAX_CONSECUTIVE_MISSED_HEARTBEATS = 3;
var DEFAULT_MAX_CONSECUTIVE_FAILED_HELLOS = 3;
var DEFAULT_MAX_REQUESTED_HEARTBEAT_TIMEOUT = 5000;
var DEFAULT_OPEN_TIMEOUT = 15000;
var DEFAULT_WELCOME_TIMEOUT = 5000;
var OUTGOING_HEARTBEAT_OFFSET = 200;

var WS_CLOSE_NORMAL = 1000;
var WS_CLOSE_WELCOME_TIMEOUT = 3000;
var WS_CLOSE_HEARTBEATS_MISSED = 3001;
var WS_CLOSE_HELLO_FAILED = 3002;
var WS_CLOSE_SEND_FAILED = 3003;
var WS_CLOSE_NETWORK_CHANGED = 3004;
var WS_CLOSE_BUSY_WAIT = 3005;
var WS_CLOSE_SERVER_BUSY = 3006;
var WS_CLOSE_OPEN_TIMEOUT = 3007;

var toplevel = global.window || global;
var WebSocket = toplevel.WebSocket ? toplevel.WebSocket : require('ws');

var CloseReason = {
  BUSY: 'busy',
  FAILED: 'failed',
  LOCAL: 'local',
  REMOTE: 'remote',
  TIMEOUT: 'timeout'
};

var wsCloseCodesToCloseReasons = new Map([[WS_CLOSE_WELCOME_TIMEOUT, CloseReason.TIMEOUT], [WS_CLOSE_HEARTBEATS_MISSED, CloseReason.TIMEOUT], [WS_CLOSE_HELLO_FAILED, CloseReason.FAILED], [WS_CLOSE_SEND_FAILED, CloseReason.FAILED], [WS_CLOSE_NETWORK_CHANGED, CloseReason.TIMEOUT], [WS_CLOSE_SERVER_BUSY, CloseReason.BUSY], [WS_CLOSE_OPEN_TIMEOUT, CloseReason.TIMEOUT]]);

/**
 * A {@link TwilioConnection} represents a WebSocket connection
 * to a Twilio Connections Messaging Protocol (TCMP) server.
 * @fires TwilioConnection#close
 * @fires TwilioConnection#error
 * @fires TwilioConnection#message
 * @fires TwilioConnection#open
 * @fires TwilioConnection#waiting
 */

var TwilioConnection = function (_StateMachine) {
  _inherits(TwilioConnection, _StateMachine);

  /**
   * Construct a {@link TwilioConnection}.
   * @param {string} serverUrl - TCMP server url
   * @param {TwilioConnectionOptions} options - {@link TwilioConnection} options
   */
  function TwilioConnection(serverUrl, options) {
    _classCallCheck(this, TwilioConnection);

    var _this = _possibleConstructorReturn(this, (TwilioConnection.__proto__ || Object.getPrototypeOf(TwilioConnection)).call(this, 'early', states));

    options = Object.assign({
      helloBody: null,
      maxConsecutiveFailedHellos: DEFAULT_MAX_CONSECUTIVE_FAILED_HELLOS,
      maxConsecutiveMissedHeartbeats: DEFAULT_MAX_CONSECUTIVE_MISSED_HEARTBEATS,
      requestedHeartbeatTimeout: DEFAULT_MAX_REQUESTED_HEARTBEAT_TIMEOUT,
      openTimeout: DEFAULT_OPEN_TIMEOUT,
      welcomeTimeout: DEFAULT_WELCOME_TIMEOUT,
      Log: Log,
      WebSocket: WebSocket
    }, options);

    var logLevels = buildLogLevels(options.logLevel);
    var log = new options.Log('default', _this, logLevels, options.loggerName);

    var networkMonitor = options.networkMonitor ? new NetworkMonitor(function () {
      var type = networkMonitor.type;

      var reason = 'Network changed' + (type ? ' to ' + type : '');
      log.debug(reason);
      _this._close({ code: WS_CLOSE_NETWORK_CHANGED, reason: reason });
    }) : null;

    Object.defineProperties(_this, {
      _busyWaitTimeout: {
        value: null,
        writable: true
      },
      _consecutiveHeartbeatsMissed: {
        value: 0,
        writable: true
      },
      _cookie: {
        value: null,
        writable: true
      },
      _eventObserver: {
        value: options.eventObserver
      },
      _heartbeatTimeout: {
        value: null,
        writable: true
      },
      _hellosLeft: {
        value: options.maxConsecutiveFailedHellos,
        writable: true
      },
      _instanceId: {
        value: ++nInstances
      },
      _log: {
        value: log
      },
      _messageQueue: {
        value: []
      },
      _networkMonitor: {
        value: networkMonitor
      },
      _options: {
        value: options
      },
      _openTimeout: {
        value: null,
        writable: true
      },
      _sendHeartbeatTimeout: {
        value: null,
        writable: true
      },
      _serverUrl: {
        value: serverUrl
      },
      _welcomeTimeout: {
        value: null,
        writable: true
      },
      _ws: {
        value: null,
        writable: true
      }
    });

    var eventsToLevels = {
      connecting: 'info',
      early: 'info',
      open: 'info',
      waiting: 'warning',
      closed: 'info'
    };

    _this.on('stateChanged', function (state) {
      for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }

      if (state in events) {
        _this.emit.apply(_this, [events[state]].concat(args));
      }
      var event = { name: state, group: 'signaling', level: eventsToLevels[_this.state] };
      if (state === 'closed') {
        var reason = args[0];

        event.payload = { reason: reason };
        event.level = reason === CloseReason.LOCAL ? 'info' : 'error';
      }
      _this._eventObserver.emit('event', event);
    });

    _this._eventObserver.emit('event', { name: _this.state, group: 'signaling', level: eventsToLevels[_this.state] });
    _this._connect();
    return _this;
  }

  _createClass(TwilioConnection, [{
    key: 'toString',
    value: function toString() {
      return '[TwilioConnection #' + this._instanceId + ': ' + this._ws.url + ']';
    }

    /**
     * Close the {@link TwilioConnection}.
     * @param {{code: number, reason: string}} event
     * @private
     */

  }, {
    key: '_close',
    value: function _close(_ref) {
      var code = _ref.code,
          reason = _ref.reason;

      if (this.state === 'closed') {
        return;
      }
      if (this._openTimeout) {
        this._openTimeout.clear();
      }
      if (this._welcomeTimeout) {
        this._welcomeTimeout.clear();
      }
      if (this._heartbeatTimeout) {
        this._heartbeatTimeout.clear();
      }
      if (this._sendHeartbeatTimeout) {
        this._sendHeartbeatTimeout.clear();
      }
      if (this._networkMonitor) {
        this._networkMonitor.stop();
      }
      if (this._busyWaitTimeout && code !== WS_CLOSE_BUSY_WAIT) {
        this._busyWaitTimeout.clear();
      }
      this._messageQueue.splice(0);
      var log = this._log;

      if (code === WS_CLOSE_NORMAL) {
        log.debug('Closed');
        this.transition('closed', null, [CloseReason.LOCAL]);
      } else {
        log.warn('Closed: ' + code + ' - ' + reason);
        if (code !== WS_CLOSE_BUSY_WAIT) {
          this.transition('closed', null, [wsCloseCodesToCloseReasons.get(code) || CloseReason.REMOTE]);
        }
      }
      var readyState = this._ws.readyState;
      var WebSocket = this._options.WebSocket;


      if (readyState !== WebSocket.CLOSING && readyState !== WebSocket.CLOSED) {
        this._ws.close(code, reason);
      }
    }

    /**
     * Connect to the TCMP server.
     * @private
     */

  }, {
    key: '_connect',
    value: function _connect() {
      var _this2 = this;

      var log = this._log;
      if (this.state === 'waiting') {
        this.transition('early');
      } else if (this.state !== 'early') {
        log.warn('Unexpected state "' + this.state + '" for connecting to the' + ' TCMP server.');
        return;
      }
      this._ws = new this._options.WebSocket(this._serverUrl);
      var ws = this._ws;
      log.debug('Created a new WebSocket:', ws);
      ws.addEventListener('close', function (event) {
        return _this2._close(event);
      });

      var openTimeout = this._options.openTimeout;
      // Add a timeout for getting the onopen event on the WebSocket (15 sec). After that, attempt to reconnect only if this is not the first attempt.

      this._openTimeout = new Timeout(function () {
        var reason = 'Failed to open in ' + openTimeout + ' ms';
        _this2._close({ code: WS_CLOSE_OPEN_TIMEOUT, reason: reason });
      }, openTimeout);

      ws.addEventListener('open', function () {
        log.debug('WebSocket opened:', ws);
        _this2._openTimeout.clear();
        _this2._startHandshake();
        if (_this2._networkMonitor) {
          _this2._networkMonitor.start();
        }
      });

      ws.addEventListener('message', function (message) {
        log.debug('Incoming: ' + message.data);
        try {
          message = JSON.parse(message.data);
        } catch (error) {
          _this2.emit('error', error);
          return;
        }

        switch (message.type) {
          case 'bad':
            _this2._handleBad(message);
            break;
          case 'busy':
            _this2._handleBusy(message);
            break;
          case 'bye':
            // Do nothing.
            break;
          case 'msg':
            _this2._handleMessage(message);
          // NOTE(mpatwardhan): Each incoming message should be treated as an incoming
          // heartbeat intentionally falling through to 'heartbeat' case.
          // eslint-disable-next-line no-fallthrough
          case 'heartbeat':
            _this2._handleHeartbeat();
            break;
          case 'welcome':
            _this2._handleWelcome(message);
            break;
          default:
            _this2._log.debug('Unknown message type: ' + message.type);
            _this2.emit('error', new Error('Unknown message type: ' + message.type));
            break;
        }
      });
    }

    /**
     * Handle an incoming "bad" message.
     * @param {{reason: string}} message
     * @private
     */

  }, {
    key: '_handleBad',
    value: function _handleBad(_ref2) {
      var reason = _ref2.reason;

      var log = this._log;
      if (!['connecting', 'open'].includes(this.state)) {
        log.warn('Unexpected state "' + this.state + '" for handling a "bad" message' + ' from the TCMP server.');
        return;
      }
      if (this.state === 'connecting') {
        log.warn('Closing: ' + WS_CLOSE_HELLO_FAILED + ' - ' + reason);
        this._close({ code: WS_CLOSE_HELLO_FAILED, reason: reason });
        return;
      }
      log.debug('Error: ' + reason);
      this.emit('error', new Error(reason));
    }

    /**
     * Handle an incoming "busy" message.
     * @param {{cookie: ?string, keepAlive: boolean, retryAfter: number}} message
     * @private
     */

  }, {
    key: '_handleBusy',
    value: function _handleBusy(_ref3) {
      var _this3 = this;

      var cookie = _ref3.cookie,
          keepAlive = _ref3.keepAlive,
          retryAfter = _ref3.retryAfter;

      var log = this._log;
      if (!['connecting', 'waiting'].includes(this.state)) {
        log.warn('Unexpected state "' + this.state + '" for handling a "busy" message' + ' from the TCMP server.');
        return;
      }
      if (this._busyWaitTimeout) {
        this._busyWaitTimeout.clear();
      }
      if (this._welcomeTimeout) {
        this._welcomeTimeout.clear();
      }
      var reason = retryAfter < 0 ? 'Received terminal "busy" message' : 'Received "busy" message, retrying after ' + retryAfter + ' ms';

      if (retryAfter < 0) {
        log.warn('Closing: ' + WS_CLOSE_SERVER_BUSY + ' - ' + reason);
        this._close({ code: WS_CLOSE_SERVER_BUSY, reason: reason });
        return;
      }
      var maxConsecutiveFailedHellos = this._options.maxConsecutiveFailedHellos;

      this._hellosLeft = maxConsecutiveFailedHellos;
      this._cookie = cookie || null;

      if (keepAlive) {
        log.warn(reason);
        this._busyWaitTimeout = new Timeout(function () {
          return _this3._startHandshake();
        }, retryAfter);
      } else {
        log.warn('Closing: ' + WS_CLOSE_BUSY_WAIT + ' - ' + reason);
        this._close({ code: WS_CLOSE_BUSY_WAIT, reason: reason });
        this._busyWaitTimeout = new Timeout(function () {
          return _this3._connect();
        }, retryAfter);
      }

      this.transition('waiting', null, [keepAlive, retryAfter]);
    }

    /**
     * Handle an incoming "heartbeat" message.
     * @private
     */

  }, {
    key: '_handleHeartbeat',
    value: function _handleHeartbeat() {
      if (this.state !== 'open') {
        this._log.warn('Unexpected state "' + this.state + '" for handling a "heartbeat"' + ' message from the TCMP server.');
        return;
      }
      this._heartbeatTimeout.reset();
    }

    /**
     * Handle a missed "heartbeat" message.
     * @private
     */

  }, {
    key: '_handleHeartbeatTimeout',
    value: function _handleHeartbeatTimeout() {
      if (this.state !== 'open') {
        return;
      }
      var log = this._log;
      var maxConsecutiveMissedHeartbeats = this._options.maxConsecutiveMissedHeartbeats;


      log.debug('Consecutive heartbeats missed: ' + maxConsecutiveMissedHeartbeats);
      var reason = 'Missed ' + maxConsecutiveMissedHeartbeats + ' "heartbeat" messages';
      log.warn('Closing: ' + WS_CLOSE_HEARTBEATS_MISSED + ' - ' + reason);
      this._close({ code: WS_CLOSE_HEARTBEATS_MISSED, reason: reason });
    }

    /**
     * Handle an incoming "msg" message.
     * @param {{body: object}} message
     * @private
     */

  }, {
    key: '_handleMessage',
    value: function _handleMessage(_ref4) {
      var body = _ref4.body;

      if (this.state !== 'open') {
        this._log.warn('Unexpected state "' + this.state + '" for handling a "msg" message' + ' from the TCMP server.');
        return;
      }
      this.emit('message', body);
    }

    /**
     * Handle an incoming "welcome" message.
     * @param {{ negotiatedTimeout: number }} message
     * @private
     */

  }, {
    key: '_handleWelcome',
    value: function _handleWelcome(_ref5) {
      var _this4 = this;

      var negotiatedTimeout = _ref5.negotiatedTimeout;

      var log = this._log;

      if (!['connecting', 'waiting'].includes(this.state)) {
        log.warn('Unexpected state "' + this.state + '" for handling a "welcome"' + ' message from the TCMP server.');
        return;
      }

      if (this.state === 'waiting') {
        log.debug('Received "welcome" message, no need to retry connection.');
        this._busyWaitTimeout.clear();
      }

      var maxConsecutiveMissedHeartbeats = this._options.maxConsecutiveMissedHeartbeats;

      var heartbeatTimeout = negotiatedTimeout * maxConsecutiveMissedHeartbeats;
      var outgoingHeartbeatTimeout = negotiatedTimeout - OUTGOING_HEARTBEAT_OFFSET;

      this._welcomeTimeout.clear();
      this._heartbeatTimeout = new Timeout(function () {
        return _this4._handleHeartbeatTimeout();
      }, heartbeatTimeout);
      this._messageQueue.splice(0).forEach(function (message) {
        return _this4._send(message);
      });
      this._sendHeartbeatTimeout = new Timeout(function () {
        return _this4._sendHeartbeat();
      }, outgoingHeartbeatTimeout);
      this.transition('open');
    }

    /**
     * Handle a missed "welcome" message.
     * @private
     */

  }, {
    key: '_handleWelcomeTimeout',
    value: function _handleWelcomeTimeout() {
      if (this.state !== 'connecting') {
        return;
      }
      var log = this._log;

      if (this._hellosLeft <= 0) {
        var reason = 'All handshake attempts failed';
        log.warn('Closing: ' + WS_CLOSE_WELCOME_TIMEOUT + ' - ' + reason);
        this._close({ code: WS_CLOSE_WELCOME_TIMEOUT, reason: reason });
        return;
      }

      var maxConsecutiveFailedHellos = this._options.maxConsecutiveFailedHellos;

      log.warn('Handshake attempt ' + (maxConsecutiveFailedHellos - this._hellosLeft) + ' failed');
      this._startHandshake();
    }

    /**
     * Send a message to the TCMP server.
     * @param {*} message
     * @private
     */

  }, {
    key: '_send',
    value: function _send(message) {
      var readyState = this._ws.readyState;
      var WebSocket = this._options.WebSocket;

      if (readyState === WebSocket.OPEN) {
        var data = JSON.stringify(message);
        this._log.debug('Outgoing: ' + data);
        try {
          this._ws.send(data);
          if (this._sendHeartbeatTimeout) {
            // Each outgoing message is to be treated as an outgoing heartbeat.
            this._sendHeartbeatTimeout.reset();
          }
        } catch (error) {
          var reason = 'Failed to send message';
          this._log.warn('Closing: ' + WS_CLOSE_SEND_FAILED + ' - ' + reason);
          this._close({ code: WS_CLOSE_SEND_FAILED, reason: reason });
        }
      }
    }

    /**
     * Send a "heartbeat" message.
     * @private
     */

  }, {
    key: '_sendHeartbeat',
    value: function _sendHeartbeat() {
      if (this.state === 'closed') {
        return;
      }
      this._send({ type: 'heartbeat' });
    }

    /**
     * Send a "hello" message.
     * @private
     */

  }, {
    key: '_sendHello',
    value: function _sendHello() {
      var _options = this._options,
          helloBody = _options.helloBody,
          timeout = _options.requestedHeartbeatTimeout;

      var hello = {
        id: makeUUID(),
        timeout: timeout,
        type: 'hello',
        version: TCMP_VERSION
      };
      if (this._cookie) {
        hello.cookie = this._cookie;
      }
      if (helloBody) {
        hello.body = helloBody;
      }
      this._send(hello);
    }

    /**
     * Send or enqueue a message.
     * @param {*} message
     * @private
     */

  }, {
    key: '_sendOrEnqueue',
    value: function _sendOrEnqueue(message) {
      var _this5 = this;

      if (this.state === 'closed') {
        return;
      }
      var sendOrEnqueue = this.state === 'open' ? function (message) {
        return _this5._send(message);
      } : function (message) {
        return _this5._messageQueue.push(message);
      };

      sendOrEnqueue(message);
    }

    /**
     * Start the TCMP handshake.
     * @private
     */

  }, {
    key: '_startHandshake',
    value: function _startHandshake() {
      var _this6 = this;

      if (['early', 'waiting'].includes(this.state)) {
        this.transition('connecting');
      }
      if (this.state !== 'connecting') {
        return;
      }
      this._hellosLeft--;
      this._sendHello();
      var welcomeTimeout = this._options.welcomeTimeout;

      this._welcomeTimeout = new Timeout(function () {
        return _this6._handleWelcomeTimeout();
      }, welcomeTimeout);
    }

    /**
     * Close the {@link TwilioConnection}.
     * @returns {void}
     */

  }, {
    key: 'close',
    value: function close() {
      if (this.state === 'closed') {
        return;
      }
      this._sendOrEnqueue({ type: 'bye' });
      this._close({ code: WS_CLOSE_NORMAL, reason: 'Normal' });
    }

    /**
     * Send a "msg" message.
     * @param {*} body
     * @returns {void}
     */

  }, {
    key: 'sendMessage',
    value: function sendMessage(body) {
      this._sendOrEnqueue({ body: body, type: 'msg' });
    }
  }]);

  return TwilioConnection;
}(StateMachine);

/**
 * A unique string depicting the reason for the {@link TwilioConnection} being closed.
 * @enum {string}
 */


TwilioConnection.CloseReason = CloseReason;

/**
 * A {@link TwilioConnection} was closed.
 * @event TwilioConnection#close
 * @param {CloseReason} reason - The reason for the {@link TwilioConnection} being closed
 */

/**
 * A {@link TwilioConnection} received an error from the TCMP server.
 * @event TwilioConnection#error
 * @param {Error} error - The TCMP server error
 */

/**
 * A {@link TwilioConnection} received a message from the TCMP server.
 * @event TwilioConnection#message
 * @param {*} body - Message body
 */

/**
 * A {@link TwilioConnection} completed a hello/welcome handshake with the TCMP server.
 * @event TwilioConnection#open
 */

/**
 * A {@link TwilioConnection} received a "busy" message from the TCMP server.
 * @event TwilioConnection#waiting
 * @param {boolean} keepAlive - true if the WebSocket connection is retained
 * @param {number} retryAfter - delay in milliseconds after which a retry is attempted
 */

/**
 * {@link TwilioConnection} options
 * @typedef {object} TwilioConnectionOptions
 * @property {EventObserver} [eventObserver] - Optional event observer
 * @property {*} [helloBody=null] - Optional body for "hello" message
 * @property {LogLevel} [logLevel=warn] - Log level of the {@link TwilioConnection}
 * @property {number} [maxConsecutiveFailedHellos=3] - Max. number of consecutive failed "hello"s
 * @property {number} [maxConsecutiveMissedHeartbeats=3] - Max. number of (effective) consecutive "heartbeat" messages that can be missed
 * @property {number} [requestedHeartbeatTimeout=5000] - "heartbeat" timeout (ms) requested by the {@link TwilioConnection}
 * @property {number} [welcomeTimeout=5000] - Time (ms) to wait for the "welcome" message after sending the "hello" message
 */

module.exports = TwilioConnection;
}).call(this)}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"./statemachine":73,"./util":114,"./util/log":118,"./util/networkmonitor":119,"./util/timeout":127,"ws":185}],106:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _require = require('./'),
    defer = _require.defer;

/**
 * An {@link AsyncVar} is an "asynchronous variable" which may or may not
 * contain a value of some type T. You can put a value into the {@link AsyncVar}
 * with {@link AsyncVar#put}. Callers can take a value out of the
 * {@link AsyncVar} by queueing up with {@link AsyncVar#take}. N calls to
 * {@link AsyncVar#take} require N calls to {@link AsyncVar#put} to resolve, and
 * they resolve in order.
 */


var AsyncVar = function () {
  /**
   * Construct an {@link AsyncVar}.
   */
  function AsyncVar() {
    _classCallCheck(this, AsyncVar);

    Object.defineProperties(this, {
      _deferreds: {
        value: []
      },
      _hasValue: {
        value: false,
        writable: true
      },
      _value: {
        value: null,
        writable: true
      }
    });
  }

  /**
   * Put a value into the {@link AsyncVar}.
   * @param {T} value
   * @returns {this}
   */


  _createClass(AsyncVar, [{
    key: 'put',
    value: function put(value) {
      this._hasValue = true;
      this._value = value;
      var deferred = this._deferreds.shift();
      if (deferred) {
        deferred.resolve(value);
      }
      return this;
    }

    /**
     * Take the value out of the {@link AsyncVar}.
     * @returns {Promise<T>}
     */

  }, {
    key: 'take',
    value: function take() {
      var _this = this;

      if (this._hasValue && !this._deferreds.length) {
        this._hasValue = false;
        return Promise.resolve(this._value);
      }
      var deferred = defer();
      this._deferreds.push(deferred);
      return deferred.promise.then(function (value) {
        _this._hasValue = false;
        return value;
      });
    }
  }]);

  return AsyncVar;
}();

module.exports = AsyncVar;
},{"./":114}],107:[function(require,module,exports){
'use strict';

/**
 * A Promise that can be canceled with {@link CancelablePromise#cancel}.
 * @extends Promise
*/

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var CancelablePromise = function () {
  /**
   * Construct a new {@link CancelablePromise}.
   * @param {CancelablePromise.OnCreate} onCreate
   * @param {CancelablePromise.OnCancel} onCancel
  */ /**
     * A function to be called on {@link CancelablePromise} creation
     * @typedef {function} CancelablePromise.OnCreate
     * @param {function(*)} resolve
     * @param {function(*)} reject
     * @param {function(): boolean} isCanceled
     */ /**
        * A function to be called when {@link CancelablePromise#cancel} is called
        * @typedef {function} CancelablePromise.OnCancel
        */
  function CancelablePromise(onCreate, onCancel) {
    var _this = this;

    _classCallCheck(this, CancelablePromise);

    /* istanbul ignore next */
    Object.defineProperties(this, {
      _isCancelable: {
        writable: true,
        value: true
      },
      _isCanceled: {
        writable: true,
        value: false
      },
      _onCancel: {
        value: onCancel
      }
    });

    Object.defineProperty(this, '_promise', {
      value: new Promise(function (resolve, reject) {
        onCreate(function (value) {
          _this._isCancelable = false;
          resolve(value);
        }, function (reason) {
          _this._isCancelable = false;
          reject(reason);
        }, function () {
          return _this._isCanceled;
        });
      })
    });
  }

  /**
   * Create a synchronously-rejected {@link CancelablePromise}.
   * @param {*} reason
   * @returns {Promise<*>}
   */


  _createClass(CancelablePromise, [{
    key: 'cancel',


    /**
     * Attempt to cancel the {@link CancelablePromise}.
     * @returns {this}
     */
    value: function cancel() {
      if (this._isCancelable) {
        this._isCanceled = true;
        this._onCancel();
      }
      return this;
    }

    /**
     * @param {function} onRejected
     * @returns {CancelablePromise}
     */

  }, {
    key: 'catch',
    value: function _catch() {
      var args = [].slice.call(arguments);
      var promise = this._promise;
      return new CancelablePromise(function onCreate(resolve, reject) {
        promise.catch.apply(promise, _toConsumableArray(args)).then(resolve, reject);
      }, this._onCancel);
    }

    /**
     * @param {?function} onResolved
     * @param {function} [onRejected]
     * @returns {CancelablePromise}
     */

  }, {
    key: 'then',
    value: function then() {
      var args = [].slice.call(arguments);
      var promise = this._promise;
      return new CancelablePromise(function onCreate(resolve, reject) {
        promise.then.apply(promise, _toConsumableArray(args)).then(resolve, reject);
      }, this._onCancel);
    }
  }], [{
    key: 'reject',
    value: function reject(reason) {
      return new CancelablePromise(function rejected(resolve, reject) {
        reject(reason);
      }, function onCancel() {
        // Do nothing.
      });
    }

    /**
     * Create a synchronously-resolved {@link CancelablePromise}.
     * @param {*|Promise<*>|Thenable<*>} result
     * @returns {CancelablePromise<*>}
     */

  }, {
    key: 'resolve',
    value: function resolve(result) {
      return new CancelablePromise(function resolved(resolve) {
        resolve(result);
      }, function onCancel() {
        // Do nothing.
      });
    }
  }]);

  return CancelablePromise;
}();

module.exports = CancelablePromise;
},{}],108:[function(require,module,exports){
'use strict';

module.exports.DEFAULT_ENVIRONMENT = 'prod';
module.exports.DEFAULT_REALM = 'us1';
module.exports.DEFAULT_REGION = 'gll';
module.exports.DEFAULT_LOG_LEVEL = 'warn';
module.exports.DEFAULT_LOGGER_NAME = 'twilio-video';
module.exports.WS_SERVER = function (environment, region) {
  region = region === 'gll' ? 'global' : encodeURIComponent(region);
  return environment === 'prod' ? 'wss://' + region + '.vss.twilio.com/signaling' : 'wss://' + region + '.vss.' + environment + '.twilio.com/signaling';
};
module.exports.PUBLISH_MAX_ATTEMPTS = 5;
module.exports.PUBLISH_BACKOFF_JITTER = 10;
module.exports.PUBLISH_BACKOFF_MS = 20;

/**
 * Returns the appropriate indefinite article ("a" | "an").
 * @param {string} word - The word which determines whether "a" | "an" is returned
 * @returns {string} "a" if word's first letter is a vowel, "an" otherwise
 */
function article(word) {
  // NOTE(mmalavalli): This will not be accurate for words like "hour",
  // which have consonants as their first character, but are pronounced like
  // vowels. We can address this issue if the need arises.
  return ['a', 'e', 'i', 'o', 'u'].includes(word.toLowerCase()[0]) ? 'an' : 'a';
}

module.exports.typeErrors = {
  ILLEGAL_INVOKE: function ILLEGAL_INVOKE(name, context) {
    return new TypeError('Illegal call to ' + name + ': ' + context);
  },
  INVALID_TYPE: function INVALID_TYPE(name, type) {
    return new TypeError(name + ' must be ' + article(type) + ' ' + type);
  },
  INVALID_VALUE: function INVALID_VALUE(name, values) {
    return new RangeError(name + ' must be one of ' + values.join(', '));
  },
  REQUIRED_ARGUMENT: function REQUIRED_ARGUMENT(name) {
    return new TypeError(name + ' must be specified');
  }
};

module.exports.DEFAULT_ICE_GATHERING_TIMEOUT_MS = 15000;
module.exports.DEFAULT_SESSION_TIMEOUT_SEC = 30;

module.exports.DEFAULT_NQ_LEVEL_LOCAL = 1;
module.exports.DEFAULT_NQ_LEVEL_REMOTE = 0;
module.exports.MAX_NQ_LEVEL = 3;

module.exports.ICE_ACTIVITY_CHECK_PERIOD_MS = 1000;
module.exports.ICE_INACTIVITY_THRESHOLD_MS = 3000;

module.exports.iceRestartBackoffConfig = {
  factor: 1.1,
  initialDelay: 1,
  maxDelay: module.exports.DEFAULT_SESSION_TIMEOUT_SEC * 1000,
  randomisationFactor: 0.5
};

module.exports.reconnectBackoffConfig = {
  factor: 1.5,
  initialDelay: 80,
  randomisationFactor: 0.5
};

module.exports.subscriptionMode = {
  MODE_COLLABORATION: 'collaboration',
  MODE_GRID: 'grid',
  MODE_PRESENTATION: 'presentation'
};

module.exports.trackSwitchOffMode = {
  MODE_DISABLED: 'disabled',
  MODE_DETECTED: 'detected',
  MODE_PREDICTED: 'predicted'
};

module.exports.trackPriority = {
  PRIORITY_HIGH: 'high',
  PRIORITY_LOW: 'low',
  PRIORITY_STANDARD: 'standard'
};
},{}],109:[function(require,module,exports){
'use strict';

var detectSilence = require('../webaudio/detectsilence');

var N_ATTEMPTS = 3;
var ATTEMPT_DURATION_MS = 250;

/**
 * Detect whether the audio stream rendered by the given HTMLVideoElement is silent.
 * @param {HTMLAudioElement} el
 * @returns {Promise<boolean>} true if silent, false if not.
 */
function detectSilentAudio(el) {
  // NOTE(mmalavalli): We have to delay require-ing AudioContextFactory, because
  // it exports a default instance whose constructor calls Object.assign.
  var AudioContextFactory = require('../webaudio/audiocontext');
  var holder = {};
  var audioContext = AudioContextFactory.getOrCreate(holder);

  var attemptsLeft = N_ATTEMPTS;

  function doCheckSilence() {
    attemptsLeft--;
    return detectSilence(audioContext, el.srcObject, ATTEMPT_DURATION_MS).then(function (isSilent) {
      if (!isSilent) {
        return false;
      }
      if (attemptsLeft > 0) {
        return doCheckSilence();
      }
      return true;
    }).catch(function () {
      // NOTE(mmalavalli): If an error is thrown while detect silence, the audio
      // stream is assumed to be silent.
      return true;
    });
  }

  // Resolve the returned Promise with true if 3 consecutive attempts
  // to detect silent audio are successful.
  return doCheckSilence().finally(function () {
    AudioContextFactory.release(holder);
  });
}

module.exports = detectSilentAudio;
},{"../webaudio/audiocontext":131,"../webaudio/detectsilence":132}],110:[function(require,module,exports){
'use strict';

// Cached copy of the <canvas> used to check silent video frames.

var canvas = null;

var N_SAMPLES = 3;
var SAMPLE_HEIGHT = 50;
var SAMPLE_INTERVAL_MS = 250;
var SAMPLE_WIDTH = 50;

/**
 * Check whether the current video frame is silent by selecting a 50x50
 * sample and calculating the max value of the pixel data. If it is 0, then
 * the frame is considered to be silent.
 * @private
 * @param {HTMLVideoElement} el
 * @returns {boolean} true if silent, false if not
 */
function checkSilence(el) {
  var context = canvas.getContext('2d');
  context.drawImage(el, 0, 0, SAMPLE_WIDTH, SAMPLE_HEIGHT);
  var frame = context.getImageData(0, 0, SAMPLE_WIDTH, SAMPLE_HEIGHT);
  var frameDataWithoutAlpha = frame.data.filter(function (item, i) {
    return (i + 1) % 4;
  });
  var max = Math.max.apply(Math, frameDataWithoutAlpha);
  return max === 0;
}

/**
 * Detect whether the video stream rendered by the given HTMLVideoElement is silent.
 * @param {HTMLVideoElement} el
 * @returns {Promise<boolean>} true if silent, false if not.
 */
function detectSilentVideo(el) {
  // Create the canvas when detectSilentVideo() is called for the
  // first time.
  canvas = canvas || document.createElement('canvas');

  // Resolve the returned Promise with true if 3 consecutive sample
  // frames from the video being played by the HTMLVideoElement are
  // silent.
  return new Promise(function (resolve) {
    var samplesLeft = N_SAMPLES;
    setTimeout(function doCheckSilence() {
      samplesLeft--;
      if (!checkSilence(el)) {
        return resolve(false);
      }
      if (samplesLeft > 0) {
        return setTimeout(doCheckSilence, SAMPLE_INTERVAL_MS);
      }
      return resolve(true);
    }, SAMPLE_INTERVAL_MS);
  });
}

module.exports = detectSilentVideo;
},{}],111:[function(require,module,exports){
'use strict';

/**
 * The {@link DocumentVisibilityMonitor} monitors the visibility state of the DOM
 * and executes the attached listeners in phase order when the DOM is visible.
 */

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var DocumentVisibilityMonitor = function () {
  /**
   * Constructor.
   * @param {number} [nPhases=1] - the number of phases
   */
  function DocumentVisibilityMonitor() {
    var _this = this;

    var nPhases = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;

    _classCallCheck(this, DocumentVisibilityMonitor);

    Object.defineProperties(this, {
      _listeners: {
        value: []
      },
      _onVisibilityChange: {
        value: function value() {
          if (document.visibilityState === 'visible') {
            _this._emitVisible();
          }
        }
      }
    });

    for (var i = 0; i < nPhases; i++) {
      this._listeners.push([]);
    }
  }

  _createClass(DocumentVisibilityMonitor, [{
    key: '_listenerCount',
    value: function _listenerCount() {
      return this._listeners.reduce(function (count, phaseListeners) {
        return count + phaseListeners.length;
      }, 0);
    }

    /**
     * Call all the listeners. Makes sure that all listeners for a given phase
     * are executed before calling the listeners of the next phase.
     * @private
     */

  }, {
    key: '_emitVisible',
    value: function _emitVisible() {
      var _this2 = this;

      var promise = Promise.resolve();

      var _loop = function _loop(phase) {
        promise = promise.then(function () {
          return _this2._emitVisiblePhase(phase);
        });
      };

      for (var phase = 1; phase <= this._listeners.length; phase++) {
        _loop(phase);
      }
      return promise;
    }

    /**
     * Call all the listeners for a given phase.
     * @private
     */

  }, {
    key: '_emitVisiblePhase',
    value: function _emitVisiblePhase(phase) {
      var phaseListeners = this._listeners[phase - 1];
      return Promise.all(phaseListeners.map(function (listener) {
        var ret = listener();
        return ret instanceof Promise ? ret : Promise.resolve(ret);
      }));
    }

    /**
     * Start listening to the DOM visibility state change.
     * @private
     */

  }, {
    key: '_start',
    value: function _start() {
      document.addEventListener('visibilitychange', this._onVisibilityChange);
    }

    /**
     * Stop listening to the DOM visibility state change.
     * @private
     */

  }, {
    key: '_stop',
    value: function _stop() {
      document.removeEventListener('visibilitychange', this._onVisibilityChange);
    }

    /**
     * Listen for the DOM to be visible at the given phase.
     * @param {number} phase
     * @param {function} listener
     * @returns {this}
     */

  }, {
    key: 'onVisible',
    value: function onVisible(phase, listener) {
      if (typeof phase !== 'number' || phase <= 0 || phase > this._listeners.length) {
        throw new Error('invalid phase: ', phase);
      }
      var phaseListeners = this._listeners[phase - 1];
      phaseListeners.push(listener);
      if (this._listenerCount() === 1) {
        this._start();
      }
      return this;
    }

    /**
     * Stop listening for the DOM to be visible at the given phase.
     * @param {number} phase
     * @param {function} listener
     * @returns {this}
     */

  }, {
    key: 'offVisible',
    value: function offVisible(phase, listener) {
      if (typeof phase !== 'number' || phase <= 0 || phase > this._listeners.length) {
        throw new Error('invalid phase: ', phase);
      }

      var phaseListeners = this._listeners[phase - 1];
      var index = phaseListeners.indexOf(listener);
      if (index !== -1) {
        phaseListeners.splice(index, 1);
        if (this._listenerCount() === 0) {
          this._stop();
        }
      }
      return this;
    }
  }]);

  return DocumentVisibilityMonitor;
}();

module.exports = new DocumentVisibilityMonitor(2);
},{}],112:[function(require,module,exports){
/* eslint-disable no-console */
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var _require = require('events'),
    EventEmitter = _require.EventEmitter;

var VALID_GROUPS = ['signaling', 'room'];

var VALID_LEVELS = ['debug', 'error', 'info', 'warning'];

/**
 * EventObserver listens to SDK events and re-emits them on the
 * @link EventListener} with some additional information.
 * @extends EventEmitter
 * @emits EventObserver#event
 */

var EventObserver = function (_EventEmitter) {
  _inherits(EventObserver, _EventEmitter);

  /**
   * Constructor.
   * @param {number} connectTimestamp
   * @param {log} Log
   * @param {EventListener} eventListener
   */
  function EventObserver(connectTimestamp, log) {
    var eventListener = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

    _classCallCheck(this, EventObserver);

    var _this = _possibleConstructorReturn(this, (EventObserver.__proto__ || Object.getPrototypeOf(EventObserver)).call(this));

    Object.defineProperties(_this, {
      _publisher: {
        value: null,
        writable: true
      }
    });

    _this.on('event', function (_ref) {
      var name = _ref.name,
          group = _ref.group,
          level = _ref.level,
          payload = _ref.payload;

      if (typeof name !== 'string') {
        throw new Error('Unexpected name: ', name);
      }

      if (!VALID_GROUPS.includes(group)) {
        throw new Error('Unexpected group: ', group);
      }

      if (!VALID_LEVELS.includes(level)) {
        throw new Error('Unexpected level: ', level);
      }

      var timestamp = Date.now();
      var elapsedTime = timestamp - connectTimestamp;

      if (_this._publisher) {
        var publisherPayload = Object.assign(payload ? payload : {}, { elapsedTime: elapsedTime, level: level });
        _this._publisher.publish(group, name, publisherPayload);
      }
      var event = Object.assign(payload ? { payload: payload } : {}, {
        elapsedTime: elapsedTime,
        group: group,
        level: level,
        name: name,
        timestamp: timestamp
      });

      var logLevel = {
        debug: 'debug',
        error: 'error',
        info: 'info',
        warning: 'warn'
      }[level];
      log[logLevel]('event', event);

      if (eventListener && group === 'signaling') {
        var _event = Object.assign(payload ? { payload: payload } : {}, {
          elapsedTime: elapsedTime,
          group: group,
          level: level,
          name: name,
          timestamp: timestamp
        });
        eventListener.emit('event', _event);
      }
    });
    return _this;
  }

  /**
   * sets the publisher object. Once set events will be send to publisher.
   * @param {InsightsPublisher} publisher
  */


  _createClass(EventObserver, [{
    key: 'setPublisher',
    value: function setPublisher(publisher) {
      this._publisher = publisher;
    }
  }]);

  return EventObserver;
}(EventEmitter);

/**
 * An SDK event.
 * @event EventObserver#event
 * @param {{name: string, payload: *}} event
 */

module.exports = EventObserver;
},{"events":165}],113:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Filter = function () {
  function Filter(options) {
    _classCallCheck(this, Filter);

    options = Object.assign({
      getKey: function defaultGetKey(a) {
        return a;
      },
      getValue: function defaultGetValue(a) {
        return a;
      },
      isLessThanOrEqualTo: function defaultIsLessThanOrEqualTo(a, b) {
        return a <= b;
      }
    }, options);
    Object.defineProperties(this, {
      _getKey: {
        value: options.getKey
      },
      _getValue: {
        value: options.getValue
      },
      _isLessThanOrEqualTo: {
        value: options.isLessThanOrEqualTo
      },
      _map: {
        value: new Map()
      }
    });
  }

  _createClass(Filter, [{
    key: 'toMap',
    value: function toMap() {
      return new Map(this._map);
    }
  }, {
    key: 'updateAndFilter',
    value: function updateAndFilter(entries) {
      return entries.filter(this.update, this);
    }
  }, {
    key: 'update',
    value: function update(entry) {
      var key = this._getKey(entry);
      var value = this._getValue(entry);
      if (this._map.has(key) && this._isLessThanOrEqualTo(value, this._map.get(key))) {
        return false;
      }
      this._map.set(key, value);
      return true;
    }
  }]);

  return Filter;
}();

module.exports = Filter;
},{}],114:[function(require,module,exports){
'use strict';

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

var constants = require('./constants');
var E = constants.typeErrors,
    trackPriority = constants.trackPriority;

var util = require('@twilio/webrtc/lib/util');

/**
 * Return the given {@link LocalTrack} or a new {@link LocalTrack} for the
 * given MediaStreamTrack.
 * @param {LocalTrack|MediaStreamTrack} track
 * @param {object} options
 * @returns {LocalTrack}
 * @throws {TypeError}
 */
function asLocalTrack(track, options) {
  if (track instanceof options.LocalAudioTrack || track instanceof options.LocalVideoTrack || track instanceof options.LocalDataTrack) {
    return track;
  }
  if (track instanceof options.MediaStreamTrack) {
    return track.kind === 'audio' ? new options.LocalAudioTrack(track, options) : new options.LocalVideoTrack(track, options);
  }
  /* eslint new-cap:0 */
  throw E.INVALID_TYPE('track', 'LocalAudioTrack, LocalVideoTrack, LocalDataTrack, or MediaStreamTrack');
}

/**
 * Create a new {@link LocalTrackPublication} for the given {@link LocalTrack}.
 * @param {LocalTrack} track
 * @param {LocalTrackPublicationSignaling} signaling
 * @param {function(track: LocalTrackPublication): void} unpublish
 * @param {object} options
 */
function asLocalTrackPublication(track, signaling, unpublish, options) {
  var LocalTrackPublication = {
    audio: options.LocalAudioTrackPublication,
    video: options.LocalVideoTrackPublication,
    data: options.LocalDataTrackPublication
  }[track.kind];
  return new LocalTrackPublication(signaling, track, unpublish, options);
}

/**
 * Capitalize a word.
 * @param {string} word
 * @returns {string} capitalized
 */
function capitalize(word) {
  return word[0].toUpperCase() + word.slice(1);
}

/**
 * Log deprecation warnings for the given events of an EventEmitter.
 * @param {string} name
 * @param {EventEmitter} emitter
 * @param {Map<string, string>} events
 * @param {Log} log
 */
function deprecateEvents(name, emitter, events, log) {
  var warningsShown = new Set();
  emitter.on('newListener', function newListener(event) {
    if (events.has(event) && !warningsShown.has(event)) {
      log.deprecated(name + '#' + event + ' has been deprecated and scheduled for removal in twilio-video.js@2.0.0.' + (events.get(event) ? ' Use ' + name + '#' + events.get(event) + ' instead.' : ''));
      warningsShown.add(event);
    }
    if (warningsShown.size >= events.size) {
      emitter.removeListener('newListener', newListener);
    }
  });
}

/**
 * Finds the items in list1 that are not in list2.
 * @param {Array<*>|Map<*>|Set<*>} list1
 * @param {Array<*>|Map<*>|Set<*>} list2
 * @returns {Set}
 */
function difference(list1, list2) {
  list1 = Array.isArray(list1) ? new Set(list1) : new Set(list1.values());
  list2 = Array.isArray(list2) ? new Set(list2) : new Set(list2.values());

  var difference = new Set();

  list1.forEach(function (item) {
    if (!list2.has(item)) {
      difference.add(item);
    }
  });

  return difference;
}

/**
 * Filter out the keys in an object with a given value.
 * @param {object} object - Object to be filtered
 * @param {*} [filterValue] - Value to be filtered out; If not specified, then
 *   filters out all keys which have an explicit value of "undefined"
 * @returns {object} - Filtered object
 */
function filterObject(object, filterValue) {
  return Object.keys(object).reduce(function (filtered, key) {
    if (object[key] !== filterValue) {
      filtered[key] = object[key];
    }
    return filtered;
  }, {});
}

/**
 * Map a list to an array of arrays, and return the flattened result.
 * @param {Array<*>|Set<*>|Map<*>} list
 * @param {function(*): Array<*>} [mapFn]
 * @returns Array<*>
 */
function flatMap(list, mapFn) {
  var listArray = list instanceof Map || list instanceof Set ? Array.from(list.values()) : list;

  mapFn = mapFn || function mapFn(item) {
    return item;
  };

  return listArray.reduce(function (flattened, item) {
    var mapped = mapFn(item);
    return flattened.concat(mapped);
  }, []);
}

/**
 * Get the user agent string, or return "Unknown".
 * @returns {string}
 */
function getUserAgent() {
  return typeof navigator !== 'undefined' && navigator.userAgent ? navigator.userAgent : 'Unknown';
}

/**
 * Create a unique identifier.
 * @returns {string}
 */
function makeUUID() {
  return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
    var r = Math.random() * 16 | 0;
    var v = c === 'x' ? r : r & 0x3 | 0x8;
    return v.toString(16);
  });
}

/**
 * Ensure that the given function is called once per tick.
 * @param {function} fn - Function to be executed
 * @returns {function} - Schedules the given function to be called on the next tick
 */
function oncePerTick(fn) {
  var timeout = null;

  function nextTick() {
    timeout = null;
    fn();
  }

  return function scheduleNextTick() {
    if (timeout) {
      clearTimeout(timeout);
    }
    timeout = setTimeout(nextTick);
  };
}

function promiseFromEvents(operation, eventEmitter, successEvent, failureEvent) {
  return new Promise(function (resolve, reject) {
    function onSuccess() {
      var args = [].slice.call(arguments);
      if (failureEvent) {
        eventEmitter.removeListener(failureEvent, onFailure);
      }
      resolve.apply(undefined, _toConsumableArray(args));
    }
    function onFailure() {
      var args = [].slice.call(arguments);
      eventEmitter.removeListener(successEvent, onSuccess);
      reject.apply(undefined, _toConsumableArray(args));
    }
    eventEmitter.once(successEvent, onSuccess);
    if (failureEvent) {
      eventEmitter.once(failureEvent, onFailure);
    }
    operation();
  });
}

/**
 * Traverse down multiple nodes on an object and return null if
 * any link in the path is unavailable.
 * @param {Object} obj - Object to traverse
 * @param {String} path - Path to traverse. Period-separated.
 * @returns {Any|null}
 */
function getOrNull(obj, path) {
  return path.split('.').reduce(function (output, step) {
    if (!output) {
      return null;
    }
    return output[step];
  }, obj);
}

/**
 * @typedef {object} Deferred
 * @property {Promise} promise
 * @property {function} reject
 * @property {function} resolve
 */

/**
 * Create a {@link Deferred}.
 * @returns {Deferred}
 */
function defer() {
  var deferred = {};
  deferred.promise = new Promise(function (resolve, reject) {
    deferred.resolve = resolve;
    deferred.reject = reject;
  });
  return deferred;
}

/**
 * Copy a method from a `source` prototype onto a `wrapper` prototype. Invoking
 * the method on the `wrapper` prototype will invoke the corresponding method
 * on an instance accessed by `target`.
 * @param {object} source
 * @param {object} wrapper
 * @param {string} target
 * @param {string} methodName
 * @returns {undefined}
 */
function delegateMethod(source, wrapper, target, methodName) {
  if (methodName in wrapper) {
    // Skip any methods already set.
    return;
  } else if (methodName.match(/^on[a-z]+$/)) {
    // Skip EventHandlers (these are handled in the constructor).
    return;
  }

  var type = void 0;
  try {
    type = _typeof(source[methodName]);
  } catch (error) {
    // NOTE(mroberts): Attempting to check the type of non-function members
    // on the prototype throws an error for some types.
  }

  if (type !== 'function') {
    // Skip non-function members.
    return;
  }

  /* eslint no-loop-func:0 */
  wrapper[methodName] = function () {
    var _target;

    return (_target = this[target])[methodName].apply(_target, arguments);
  };
}

/**
 * Copy methods from a `source` prototype onto a `wrapper` prototype. Invoking
 * the methods on the `wrapper` prototype will invoke the corresponding method
 * on an instance accessed by `target`.
 * @param {object} source
 * @param {object} wrapper
 * @param {string} target
 * @returns {undefined}
 */
function delegateMethods(source, wrapper, target) {
  for (var methodName in source) {
    delegateMethod(source, wrapper, target, methodName);
  }
}

/**
 * Determine whether two values are deeply equal.
 * @param {*} val1
 * @param {*} val2
 * @returns {boolean}
 */
function isDeepEqual(val1, val2) {
  if (val1 === val2) {
    return true;
  }
  if ((typeof val1 === 'undefined' ? 'undefined' : _typeof(val1)) !== (typeof val2 === 'undefined' ? 'undefined' : _typeof(val2))) {
    return false;
  }
  if (val1 === null) {
    return val2 === null;
  }
  if (val2 === null) {
    return false;
  }
  if (Array.isArray(val1)) {
    return Array.isArray(val2) && val1.length === val2.length && val1.every(function (val, i) {
      return isDeepEqual(val, val2[i]);
    });
  }
  if ((typeof val1 === 'undefined' ? 'undefined' : _typeof(val1)) === 'object') {
    var val1Keys = Object.keys(val1).sort();
    var val2Keys = Object.keys(val2).sort();
    return !Array.isArray(val2) && isDeepEqual(val1Keys, val2Keys) && val1Keys.every(function (key) {
      return isDeepEqual(val1[key], val2[key]);
    });
  }
  return false;
}

/**
 * Whether the given argument is a non-array object.
 * @param {*} object
 * @return {boolean}
 */
function isNonArrayObject(object) {
  return (typeof object === 'undefined' ? 'undefined' : _typeof(object)) === 'object' && !Array.isArray(object);
}

/**
 * For each property name on the `source` prototype, add getters and/or setters
 * to `wrapper` that proxy to `target`.
 * @param {object} source
 * @param {object} wrapper
 * @param {string} target
 * @returns {undefined}
 */
function proxyProperties(source, wrapper, target) {
  Object.getOwnPropertyNames(source).forEach(function (propertyName) {
    proxyProperty(source, wrapper, target, propertyName);
  });
}

/**
 * For the property name on the `source` prototype, add a getter and/or setter
 * to `wrapper` that proxies to `target`.
 * @param {object} source
 * @param {object} wrapper
 * @param {string} target
 * @param {string} propertyName
 * @returns {undefined}
 */
function proxyProperty(source, wrapper, target, propertyName) {
  if (propertyName in wrapper) {
    // Skip any properties already set.
    return;
  } else if (propertyName.match(/^on[a-z]+$/)) {
    Object.defineProperty(wrapper, propertyName, {
      value: null,
      writable: true
    });

    target.addEventListener(propertyName.slice(2), function () {
      wrapper.dispatchEvent.apply(wrapper, arguments);
    });

    return;
  }

  Object.defineProperty(wrapper, propertyName, {
    enumerable: true,
    get: function get() {
      return target[propertyName];
    }
  });
}

/**
 * This is a function for turning a Promise into the kind referenced in the
 * Legacy Interface Extensions section of the WebRTC spec.
 * @param {Promise<*>} promise
 * @param {function<*>} onSuccess
 * @param {function<Error>} onFailure
 * @returns {Promise<undefined>}
 */
function legacyPromise(promise, onSuccess, onFailure) {
  if (onSuccess) {
    return promise.then(function (result) {
      onSuccess(result);
    }, function (error) {
      onFailure(error);
    });
  }
  return promise;
}

/**
 * Build the {@link LogLevels} object.
 * @param {String|LogLevel} logLevel - Log level name or object
 * @returns {LogLevels}
 */
function buildLogLevels(logLevel) {
  if (typeof logLevel === 'string') {
    return {
      default: logLevel,
      media: logLevel,
      signaling: logLevel,
      webrtc: logLevel
    };
  }
  return logLevel;
}

/**
 * Get the {@link Track}'s derived class name
 * @param {Track} track
 * @param {?boolean} [local=undefined]
 * @returns {string}
 */
function trackClass(track, local) {
  local = local ? 'Local' : '';
  return local + (track.kind || '').replace(/\w{1}/, function (m) {
    return m.toUpperCase();
  }) + 'Track';
}

/**
 * Get the {@link TrackPublication}'s derived class name
 * @param {TrackPublication} publication
 * @param {?boolean} [local=undefined]
 * @returns {string}
 */
function trackPublicationClass(publication, local) {
  local = local ? 'Local' : '';
  return local + (publication.kind || '').replace(/\w{1}/, function (m) {
    return m.toUpperCase();
  }) + 'TrackPublication';
}

/**
 * Sets all underscore-prefixed properties on `object` non-enumerable.
 * @param {Object} object
 * @returns {void}
 */
function hidePrivateProperties(object) {
  Object.getOwnPropertyNames(object).forEach(function (name) {
    if (name.startsWith('_')) {
      hideProperty(object, name);
    }
  });
}

/**
 * Creates a new subclass which, in the constructor, sets all underscore-prefixed
 * properties and the given public properties non-enumerable. This is useful for
 * patching up classes like EventEmitter which may set properties like `_events`
 * and `domain`.
 * @param {Function} klass
 * @param {Array<string>} props
 * @returns {Function} subclass
 */
function hidePrivateAndCertainPublicPropertiesInClass(klass, props) {
  // NOTE(mroberts): We do this to avoid giving the class a name.
  return function (_klass) {
    _inherits(_class, _klass);

    function _class() {
      var _ref;

      _classCallCheck(this, _class);

      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      var _this = _possibleConstructorReturn(this, (_ref = _class.__proto__ || Object.getPrototypeOf(_class)).call.apply(_ref, [this].concat(args)));

      hidePrivateProperties(_this);
      hidePublicProperties(_this, props);
      return _this;
    }

    return _class;
  }(klass);
}

/**
 * Hide a property of an object.
 * @param {object} object
 * @param {string} name
 */
function hideProperty(object, name) {
  var descriptor = Object.getOwnPropertyDescriptor(object, name);
  descriptor.enumerable = false;
  Object.defineProperty(object, name, descriptor);
}

/**
 * Hide the given public properties of an object.
 * @param {object} object
 * @param {Array<string>} [props=[]]
 */
function hidePublicProperties(object) {
  var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

  props.forEach(function (name) {
    // eslint-disable-next-line no-prototype-builtins
    if (object.hasOwnProperty(name)) {
      hideProperty(object, name);
    }
  });
}

/**
 * Convert an Array of values to an Array of JSON values by calling
 * `valueToJSON` on each value.
 * @param {Array<*>} array
 * @returns {Array<*>}
 */
function arrayToJSON(array) {
  return array.map(valueToJSON);
}

/**
 * Convert a Set of values to an Array of JSON values by calling `valueToJSON`
 * on each value.
 * @param {Set<*>} set
 * @returns {Array<*>}
 */
function setToJSON(set) {
  return arrayToJSON([].concat(_toConsumableArray(set)));
}

/**
 * Convert a Map from strings to values to an object of JSON values by calling
 * `valueToJSON` on each value.
 * @param {Map<string, *>} map
 * @returns {object}
 */
function mapToJSON(map) {
  return [].concat(_toConsumableArray(map.entries())).reduce(function (json, _ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
        key = _ref3[0],
        value = _ref3[1];

    return Object.assign(_defineProperty({}, key, valueToJSON(value)), json);
  }, {});
}

/**
 * Convert an object to a JSON value by calling `valueToJSON` on its enumerable
 * keys.
 * @param {object} object
 * @returns {object}
 */
function objectToJSON(object) {
  return Object.entries(object).reduce(function (json, _ref4) {
    var _ref5 = _slicedToArray(_ref4, 2),
        key = _ref5[0],
        value = _ref5[1];

    return Object.assign(_defineProperty({}, key, valueToJSON(value)), json);
  }, {});
}

/**
 * Convert a value into a JSON value.
 * @param {*} value
 * @returns {*}
 */
function valueToJSON(value) {
  if (Array.isArray(value)) {
    return arrayToJSON(value);
  } else if (value instanceof Set) {
    return setToJSON(value);
  } else if (value instanceof Map) {
    return mapToJSON(value);
  } else if (value && (typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object') {
    return objectToJSON(value);
  }
  return value;
}

function createRoomConnectEventPayload(connectOptions) {
  function boolToString(val) {
    return val ? 'true' : 'false';
  }
  var payload = {
    // arrays props converted to lengths.
    iceServers: (connectOptions.iceServers || []).length,
    audioTracks: (connectOptions.tracks || []).filter(function (track) {
      return track.kind === 'audio';
    }).length,
    videoTracks: (connectOptions.tracks || []).filter(function (track) {
      return track.kind === 'video';
    }).length,
    dataTracks: (connectOptions.tracks || []).filter(function (track) {
      return track.kind === 'data';
    }).length
  };

  // boolean properties.
  [['audio'], ['automaticSubscription'], ['enableDscp'], ['eventListener'], ['preflight'], ['video'], ['dominantSpeaker', 'enableDominantSpeaker']].forEach(function (_ref6) {
    var _ref7 = _slicedToArray(_ref6, 2),
        prop = _ref7[0],
        eventProp = _ref7[1];

    eventProp = eventProp || prop;
    payload[eventProp] = boolToString(!!connectOptions[prop]);
  });

  // numbers and string properties.
  [['maxVideoBitrate'], ['maxAudioBitrate'], ['iceTransportPolicy'], ['region'], ['name', 'roomName']].forEach(function (_ref8) {
    var _ref9 = _slicedToArray(_ref8, 2),
        prop = _ref9[0],
        eventProp = _ref9[1];

    eventProp = eventProp || prop;
    if (typeof connectOptions[prop] === 'number' || typeof connectOptions[prop] === 'string') {
      payload[eventProp] = connectOptions[prop];
    }
  });

  // array props stringified.
  ['preferredAudioCodecs', 'preferredVideoCodecs'].forEach(function (prop) {
    if (prop in connectOptions) {
      payload[prop] = JSON.stringify(connectOptions[prop]);
    }
  });

  if (connectOptions.bandwidthProfile && connectOptions.bandwidthProfile.video) {
    var videoBPOptions = connectOptions.bandwidthProfile.video || {};
    payload.bandwidthProfileOptions = {};
    ['mode', 'maxTracks', 'trackSwitchOffMode', 'dominantSpeakerPriority'].forEach(function (prop) {
      if (typeof videoBPOptions[prop] === 'number' || typeof videoBPOptions[prop] === 'string') {
        if (prop in videoBPOptions) {
          payload.bandwidthProfileOptions[prop] = videoBPOptions[prop];
        }
      }
    });

    if ('renderDimensions' in videoBPOptions) {
      payload.bandwidthProfileOptions.renderDimensions = JSON.stringify(videoBPOptions.renderDimensions);
    }
  }

  return {
    group: 'room',
    name: 'connect',
    level: 'info',
    payload: payload
  };
}

/**
 * Create the bandwidth profile payload included in an RSP connect message.
 * @param {BandwidthProfileOptions} bandwidthProfile
 * @returns {object}
 */
function createBandwidthProfilePayload(bandwidthProfile) {
  return createRSPPayload(bandwidthProfile, [{ prop: 'video', type: 'object', transform: createBandwidthProfileVideoPayload }]);
}

/**
 * Create the bandwidth profile video payload included in an RSP connect message.
 * @param {VideoBandwidthProfileOptions} bandwidthProfileVideo
 * @returns {object}
 */
function createBandwidthProfileVideoPayload(bandwidthProfileVideo) {
  return createRSPPayload(bandwidthProfileVideo, [{ prop: 'dominantSpeakerPriority', type: 'string', payloadProp: 'active_speaker_priority' }, { prop: 'maxSubscriptionBitrate', type: 'number', payloadProp: 'max_subscription_bandwidth' }, { prop: 'maxTracks', type: 'number', payloadProp: 'max_tracks' }, { prop: 'mode', type: 'string' }, { prop: 'renderDimensions', type: 'object', payloadProp: 'render_dimensions', transform: createRenderDimensionsPayload }, { prop: 'trackSwitchOffMode', type: 'string', payloadProp: 'track_switch_off' }]);
}

/**
 * Create the Media Signaling payload included in an RSP connect message.
 * @param {boolean} dominantSpeaker - whether to enable the Dominant Speaker
 *   protocol or not
 * @param {boolean} networkQuality - whether to enable the Network Quality
 *   protocol or not
 * @param {boolean} trackPriority - whether to enable the Track Priority
 *   protocol or not
 * @param {boolean} trackSwitchOff - whether to enable the Track Switch-Off
 *   protocol or not.
 * @returns {object}
 */
function createMediaSignalingPayload(dominantSpeaker, networkQuality, trackPriority, trackSwitchOff) {
  var transports = { transports: [{ type: 'data-channel' }] };
  return Object.assign(dominantSpeaker
  // eslint-disable-next-line
  ? { active_speaker: transports } : {}, networkQuality
  // eslint-disable-next-line
  ? { network_quality: transports } : {}, trackPriority
  // eslint-disable-next-line
  ? { track_priority: transports } : {}, trackSwitchOff
  // eslint-disable-next-line
  ? { track_switch_off: transports } : {});
}

/**
 * Create {@link VideoTrack.Dimensions} RSP payload.
 * @param {VideoTrack.Dimensions} [dimensions]
 * @returns {object}
 */
function createDimensionsPayload(dimensions) {
  return createRSPPayload(dimensions, [{ prop: 'height', type: 'number' }, { prop: 'width', type: 'number' }]);
}

/**
 * Create {@link VideoRenderDimensions} RSP payload.
 * @param renderDimensions
 * @returns {object}
 */
function createRenderDimensionsPayload(renderDimensions) {
  var PRIORITY_HIGH = trackPriority.PRIORITY_HIGH,
      PRIORITY_LOW = trackPriority.PRIORITY_LOW,
      PRIORITY_STANDARD = trackPriority.PRIORITY_STANDARD;

  return createRSPPayload(renderDimensions, [{ prop: PRIORITY_HIGH, type: 'object', transform: createDimensionsPayload }, { prop: PRIORITY_LOW, type: 'object', transform: createDimensionsPayload }, { prop: PRIORITY_STANDARD, type: 'object', transform: createDimensionsPayload }]);
}

/**
 * Create an RSP payload for the given object.
 * @param {object} object - object for which RSP payload is to be generated
 * @param {Array<object>} propConversions - conversion rules for object properties;
 *   they specify how object properties should be converted to their corresponding
 *   RSP payload properties
 * @returns {object}
 */
function createRSPPayload(object, propConversions) {
  return propConversions.reduce(function (payload, _ref10) {
    var prop = _ref10.prop,
        type = _ref10.type,
        _ref10$payloadProp = _ref10.payloadProp,
        payloadProp = _ref10$payloadProp === undefined ? prop : _ref10$payloadProp,
        _ref10$transform = _ref10.transform,
        transform = _ref10$transform === undefined ? function (x) {
      return x;
    } : _ref10$transform;

    return _typeof(object[prop]) === type ? Object.assign(_defineProperty({}, payloadProp, transform(object[prop])), payload) : payload;
  }, {});
}

/**
 * Create the subscribe payload included in an RSP connect/update message.
 * @param {boolean} automaticSubscription - whether to subscribe to all RemoteTracks
 * @returns {object}
 */
function createSubscribePayload(automaticSubscription) {
  return {
    rules: [{
      type: automaticSubscription ? 'include' : 'exclude',
      all: true
    }],
    revision: 1
  };
}

/**
 * Add random jitter to a given value in the range [-jitter, jitter].
 * @private
 * @param {number} value
 * @param {number} jitter
 * @returns {number} value + random(-jitter, +jitter)
 */
function withJitter(value, jitter) {
  var rand = Math.random();
  return value - jitter + Math.floor(2 * jitter * rand + 0.5);
}

/**
 * Checks if the a number is in the range [min, max].
 * @private
 * @param {num} num
 * @param {number} min
 * @param {number} max
 * @return {boolean}
 */
function inRange(num, min, max) {
  return min <= num && num <= max;
}

/**
 * returns true if given MediaStreamTrack is a screen share track
 * @private
 * @param {MediaStreamTrack} track
 * @returns {boolean}
 */
function isChromeScreenShareTrack(track) {
  // NOTE(mpatwardhan): Chrome creates screen share tracks with label like: "screen:69734272*"
  // we will check for label that starts with "screen:D" where D being a digit.
  var isChrome = util.guessBrowser() === 'chrome';
  return isChrome && track.kind === 'video' && track.label && (/^screen:[0-9]+/.test(track.label) || /^web-contents-media-stream:[0-9/]+/.test(track.label) || /^window:[0-9]+/.test(track.label));
}

/**
 * Returns a promise that resolve after timeoutMS have passed.
 * @param {number} timeoutMS - time to wait in milliseconds.
 * @returns {Promise<void>}
 */
function waitForSometime() {
  var timeoutMS = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 10;

  return new Promise(function (resolve) {
    return setTimeout(resolve, timeoutMS);
  });
}

/**
 * Returns a promise that resolve after event is received
 * @returns {Promise<void>}
 */
function waitForEvent(eventTarget, event) {
  return new Promise(function (resolve) {
    eventTarget.addEventListener(event, function onevent(e) {
      eventTarget.removeEventListener(event, onevent);
      resolve(e);
    });
  });
}

exports.constants = constants;
exports.createBandwidthProfilePayload = createBandwidthProfilePayload;
exports.createMediaSignalingPayload = createMediaSignalingPayload;
exports.createRoomConnectEventPayload = createRoomConnectEventPayload;
exports.createSubscribePayload = createSubscribePayload;
exports.asLocalTrack = asLocalTrack;
exports.asLocalTrackPublication = asLocalTrackPublication;
exports.capitalize = capitalize;
exports.deprecateEvents = deprecateEvents;
exports.difference = difference;
exports.filterObject = filterObject;
exports.flatMap = flatMap;
exports.getUserAgent = getUserAgent;
exports.hidePrivateProperties = hidePrivateProperties;
exports.hidePrivateAndCertainPublicPropertiesInClass = hidePrivateAndCertainPublicPropertiesInClass;
exports.isDeepEqual = isDeepEqual;
exports.isNonArrayObject = isNonArrayObject;
exports.inRange = inRange;
exports.makeUUID = makeUUID;
exports.oncePerTick = oncePerTick;
exports.promiseFromEvents = promiseFromEvents;
exports.getOrNull = getOrNull;
exports.defer = defer;
exports.delegateMethods = delegateMethods;
exports.proxyProperties = proxyProperties;
exports.legacyPromise = legacyPromise;
exports.buildLogLevels = buildLogLevels;
exports.trackClass = trackClass;
exports.trackPublicationClass = trackPublicationClass;
exports.valueToJSON = valueToJSON;
exports.withJitter = withJitter;
exports.isChromeScreenShareTrack = isChromeScreenShareTrack;
exports.waitForSometime = waitForSometime;
exports.waitForEvent = waitForEvent;
},{"./constants":108,"@twilio/webrtc/lib/util":149}],115:[function(require,module,exports){
(function (global){(function (){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EventEmitter = require('events').EventEmitter;

var _require = require('..'),
    getUserAgent = _require.getUserAgent;

var MAX_RECONNECT_ATTEMPTS = 5;
var RECONNECT_INTERVAL_MS = 50;
var WS_CLOSE_NORMAL = 1000;

var toplevel = global.window || global;
var WebSocket = toplevel.WebSocket ? toplevel.WebSocket : require('ws');
var util = require('../../util');

/**
 * Publish events to the Insights gateway.
 * @extends EventEmitter
 * @emits InsightsPublisher#connected
 * @emits InsightsPublisher#disconnected
 * @emits InsightsPublisher#reconnecting
 */

var InsightsPublisher = function (_EventEmitter) {
  _inherits(InsightsPublisher, _EventEmitter);

  /**
   * @param {string} token - Insights gateway token
   * @param {string} sdkName - Name of the SDK using the {@link InsightsPublisher}
   * @param {string} sdkVersion - Version of the SDK using the {@link InsightsPublisher}
   * @param {string} environment - One of 'dev', 'stage' or 'prod'
   * @param {string} realm - Region identifier
   * @param {InsightsPublisherOptions} options - Override default behavior
   */
  function InsightsPublisher(token, sdkName, sdkVersion, environment, realm, options) {
    _classCallCheck(this, InsightsPublisher);

    var _this = _possibleConstructorReturn(this, (InsightsPublisher.__proto__ || Object.getPrototypeOf(InsightsPublisher)).call(this));

    options = Object.assign({
      gateway: createGateway(environment, realm) + '/v1/VideoEvents',
      maxReconnectAttempts: MAX_RECONNECT_ATTEMPTS,
      reconnectIntervalMs: RECONNECT_INTERVAL_MS,
      userAgent: getUserAgent(),
      WebSocket: WebSocket
    }, options);

    Object.defineProperties(_this, {
      _connectTimestamp: {
        value: 0,
        writable: true
      },
      _eventQueue: {
        value: []
      },
      _readyToConnect: {
        value: util.defer()
      },
      _reconnectAttemptsLeft: {
        value: options.maxReconnectAttempts,
        writable: true
      },
      _ws: {
        value: null,
        writable: true
      },
      _WebSocket: {
        value: options.WebSocket
      }
    });

    _this._readyToConnect.promise.then(function (_ref) {
      var roomSid = _ref.roomSid,
          participantSid = _ref.participantSid;

      var self = _this;
      _this.on('disconnected', function maybeReconnect(error) {
        self._session = null;
        if (error && self._reconnectAttemptsLeft > 0) {
          self.emit('reconnecting');
          reconnect(self, token, sdkName, sdkVersion, roomSid, participantSid, options);
          return;
        }
        self.removeListener('disconnected', maybeReconnect);
      });
      connect(_this, token, sdkName, sdkVersion, roomSid, participantSid, options);
    }).catch(function () {
      // ignore failures to connect
    });
    return _this;
  }

  /**
   * Start connecting to the Insights gateway.
   * @param {string} roomSid
   * @param {string} participantSid
   * @returns {void}
   */


  _createClass(InsightsPublisher, [{
    key: 'connect',
    value: function connect(roomSid, participantSid) {
      this._readyToConnect.resolve({ roomSid: roomSid, participantSid: participantSid });
    }

    /**
     * Publish an event to the Insights gateway.
     * @private
     * @param {*} event
     */

  }, {
    key: '_publish',
    value: function _publish(event) {
      event.session = this._session;
      this._ws.send(JSON.stringify(event));
    }

    /**
     * Disconnect from the Insights gateway.
     * @returns {boolean} true if called when connecting/open, false if not
     */

  }, {
    key: 'disconnect',
    value: function disconnect() {
      if (this._ws === null || this._ws.readyState === this._WebSocket.CLOSING || this._ws.readyState === this._WebSocket.CLOSED) {
        return false;
      }

      try {
        this._ws.close();
      } catch (error) {
        // Do nothing.
      }
      this.emit('disconnected');

      return true;
    }

    /**
     * Publish (or queue, if not connected) an event to the Insights gateway.
     * @param {string} groupName - Event group name
     * @param {string} eventName - Event name
     * @param {object} payload - Event payload
     * @returns {boolean} true if queued or published, false if disconnect() called
     */

  }, {
    key: 'publish',
    value: function publish(groupName, eventName, payload) {
      if (this._ws !== null && (this._ws.readyState === this._WebSocket.CLOSING || this._ws.readyState === this._WebSocket.CLOSED)) {
        return false;
      }

      var publishOrEnqueue = typeof this._session === 'string' ? this._publish.bind(this) : this._eventQueue.push.bind(this._eventQueue);

      publishOrEnqueue({
        group: groupName,
        name: eventName,
        payload: payload,
        timestamp: Date.now(),
        type: 'event',
        version: 1
      });

      return true;
    }
  }]);

  return InsightsPublisher;
}(EventEmitter);

/**
 * Start connecting to the Insights gateway.
 * @private
 * @param {InsightsPublisher} publisher
 * @param {string} name
 * @param {string} token
 * @param {string} sdkName
 * @param {string} sdkVersion
 * @param {string} roomSid
 * @param {string} participantSid
 * @param {InsightsPublisherOptions} options
 */


function connect(publisher, token, sdkName, sdkVersion, roomSid, participantSid, options) {
  publisher._connectTimestamp = Date.now();
  publisher._reconnectAttemptsLeft--;
  publisher._ws = new options.WebSocket(options.gateway);
  var ws = publisher._ws;

  ws.addEventListener('close', function (event) {
    if (event.code === WS_CLOSE_NORMAL) {
      publisher.emit('disconnected');
      return;
    }
    publisher.emit('disconnected', new Error('WebSocket Error ' + event.code + ': ' + event.reason));
  });

  ws.addEventListener('message', function (message) {
    handleConnectResponse(publisher, JSON.parse(message.data), options);
  });

  ws.addEventListener('open', function () {
    var connectRequest = {
      type: 'connect',
      token: token,
      version: 1
    };

    connectRequest.publisher = {
      name: sdkName,
      sdkVersion: sdkVersion,
      userAgent: options.userAgent,
      participantSid: participantSid,
      roomSid: roomSid
    };

    ws.send(JSON.stringify(connectRequest));
  });
}

/**
 * Create the Insights Websocket gateway URL.
 * @param {string} environment
 * @param {string} realm
 * @returns {string}
 */
function createGateway(environment, realm) {
  return environment === 'prod' ? 'wss://sdkgw.' + realm + '.twilio.com' : 'wss://sdkgw.' + environment + '-' + realm + '.twilio.com';
}

/**
 * Handle connect response from the Insights gateway.
 * @param {InsightsPublisher} publisher
 * @param {*} response
 * @param {InsightsPublisherOptions} options
 */
function handleConnectResponse(publisher, response, options) {
  switch (response.type) {
    case 'connected':
      publisher._session = response.session;
      publisher._reconnectAttemptsLeft = options.maxReconnectAttempts;
      publisher._eventQueue.splice(0).forEach(publisher._publish, publisher);
      publisher.emit('connected');
      break;
    case 'error':
      publisher._ws.close();
      publisher.emit('disconnected', new Error(response.message));
      break;
  }
}

/**
 * Start re-connecting to the Insights gateway with an appropriate delay based
 * on InsightsPublisherOptions#reconnectIntervalMs.
 * @private
 * @param {InsightsPublisher} publisher
 * @param {string} token
 * @param {string} sdkName
 * @param {string} sdkVersion
 * @param {string} roomSid
 * @param {string} participantSid
 * @param {InsightsPublisherOptions} options
 */
function reconnect(publisher, token, sdkName, sdkVersion, roomSid, participantSid, options) {
  var connectInterval = Date.now() - publisher._connectTimestamp;
  var timeToWait = options.reconnectIntervalMs - connectInterval;

  if (timeToWait > 0) {
    setTimeout(function () {
      connect(publisher, token, sdkName, sdkVersion, roomSid, participantSid, options);
    }, timeToWait);
    return;
  }

  connect(publisher, token, sdkName, sdkVersion, roomSid, participantSid, options);
}

/**
 * The {@link InsightsPublisher} is connected to the gateway.
 * @event InsightsPublisher#connected
 */

/**
 * The {@link InsightsPublisher} is disconnected from the gateway.
 * @event InsightsPublisher#disconnected
 * @param {Error} [error] - Optional error if disconnected unintentionally
 */

/**
 * The {@link InsightsPublisher} is re-connecting to the gateway.
 * @event InsightsPublisher#reconnecting
 */

/**
 * {@link InsightsPublisher} options.
 * @typedef {object} InsightsPublisherOptions
 * @property {string} [gateway=sdkgw.{environment}-{realm}.twilio.com] - Insights WebSocket gateway url
 * @property {number} [maxReconnectAttempts=5] - Max re-connect attempts
 * @property {number} [reconnectIntervalMs=50] - Re-connect interval in ms
 */

module.exports = InsightsPublisher;
}).call(this)}).call(this,typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : {})
},{"..":114,"../../util":114,"events":165,"ws":185}],116:[function(require,module,exports){
// eslint-disable-next-line no-warning-comments
// TODO(mroberts): This should be described as implementing some
// InsightsPublisher interface.
'use strict';

/**
 * Null Insights publisher.
 */

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var InsightsPublisher = function () {
  function InsightsPublisher() {
    _classCallCheck(this, InsightsPublisher);

    Object.defineProperties(this, {
      _connected: {
        writable: true,
        value: true
      }
    });
  }

  /**
   * Connect
   * @returns {void}
   */


  _createClass(InsightsPublisher, [{
    key: 'connect',
    value: function connect() {}

    /**
     * Disconnect.
     * @returns {boolean}
     */

  }, {
    key: 'disconnect',
    value: function disconnect() {
      if (this._connected) {
        this._connected = false;
        return true;
      }
      return false;
    }

    /**
     * Publish.
     * @returns {boolean}
     */

  }, {
    key: 'publish',
    value: function publish() {
      return this._connected;
    }
  }]);

  return InsightsPublisher;
}();

module.exports = InsightsPublisher;
},{}],117:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _require = require('./'),
    defer = _require.defer;

/**
 * This is a pair of Deferreds that are set whenever local media is muted and
 * resolved whenever local media is unmuted/ended and restarted if necessary.
 */


var LocalMediaRestartDeferreds = function () {
  /**
   * Constructor.
   */
  function LocalMediaRestartDeferreds() {
    _classCallCheck(this, LocalMediaRestartDeferreds);

    Object.defineProperties(this, {
      _audio: {
        value: defer(),
        writable: true
      },
      _video: {
        value: defer(),
        writable: true
      }
    });

    // Initially, resolve both the Deferreds.
    this._audio.resolve();
    this._video.resolve();
  }

  /**
   * Resolve the Deferred for audio or video.
   * @param {'audio'|'video'} kind
   */


  _createClass(LocalMediaRestartDeferreds, [{
    key: 'resolveDeferred',
    value: function resolveDeferred(kind) {
      if (kind === 'audio') {
        this._audio.resolve();
      } else {
        this._video.resolve();
      }
    }

    /**
     * Start the Deferred for audio or video.
     * @param {'audio' | 'video'} kind
     */

  }, {
    key: 'startDeferred',
    value: function startDeferred(kind) {
      if (kind === 'audio') {
        this._audio = defer();
      } else {
        this._video = defer();
      }
    }

    /**
     * Wait until the Deferred for audio or video is resolved.
     * @param {'audio'|'video'} kind
     * @returns {Promise<void>}
     */

  }, {
    key: 'whenResolved',
    value: function whenResolved(kind) {
      return kind === 'audio' ? this._audio.promise : this._video.promise;
    }
  }]);

  return LocalMediaRestartDeferreds;
}();

module.exports = new LocalMediaRestartDeferreds();
},{"./":114}],118:[function(require,module,exports){
/* eslint new-cap:0 */
'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var defaultGetLogger = require('loglevel').getLogger;
var constants = require('./constants');
var DEFAULT_LOG_LEVEL = constants.DEFAULT_LOG_LEVEL,
    DEFAULT_LOGGER_NAME = constants.DEFAULT_LOGGER_NAME;

var E = require('./constants').typeErrors;

var deprecationWarningsByComponentConstructor = void 0;

function getDeprecationWarnings(componentConstructor) {
  deprecationWarningsByComponentConstructor = deprecationWarningsByComponentConstructor || new Map();
  if (deprecationWarningsByComponentConstructor.has(componentConstructor)) {
    return deprecationWarningsByComponentConstructor.get(componentConstructor);
  }
  var deprecationWarnings = new Set();
  deprecationWarningsByComponentConstructor.set(componentConstructor, deprecationWarnings);
  return deprecationWarnings;
}

/**
 * Selectively outputs messages to console based on specified minimum module
 * specific log levels.
 *
 * NOTE: The values in the logLevels object passed to the constructor is changed
 *       by subsequent calls to {@link Log#setLevels}.
 */

var Log = function () {
  /**
   * Construct a new {@link Log} object.
   * @param {String} moduleName - Name of the logging module (webrtc/media/signaling)
   * @param {object} component - Component owning this instance of {@link Log}
   * @param {LogLevels} logLevels - Logging levels. See {@link LogLevels}
   * @param {String} loggerName - Name of the logger instance. Used when calling getLogger from loglevel module
   */
  function Log(moduleName, component, logLevels, loggerName, getLogger) {
    _classCallCheck(this, Log);

    if (typeof moduleName !== 'string') {
      throw E.INVALID_TYPE('moduleName', 'string');
    }

    if (!component) {
      throw E.REQUIRED_ARGUMENT('component');
    }

    if ((typeof logLevels === 'undefined' ? 'undefined' : _typeof(logLevels)) !== 'object') {
      logLevels = {};
    }

    getLogger = getLogger || defaultGetLogger;

    validateLogLevels(logLevels);

    /* istanbul ignore next */
    Object.defineProperties(this, {
      _component: {
        value: component
      },
      _logLevels: {
        value: logLevels
      },
      _warnings: {
        value: new Set()
      },
      _loggerName: {
        get: function get() {
          var name = loggerName && typeof loggerName === 'string' ? loggerName : DEFAULT_LOGGER_NAME;

          if (!this._logLevelsEqual) {
            name = name + '-' + moduleName;
          }
          return name;
        }
      },
      _logger: {
        get: function get() {
          var logger = getLogger(this._loggerName);
          var level = this._logLevels[moduleName] || DEFAULT_LOG_LEVEL;

          // There is no 'off' in the logger module. It uses 'silent' instead
          level = level === 'off' ? 'silent' : level;

          logger.setDefaultLevel(level);
          return logger;
        }
      },
      _logLevelsEqual: {
        get: function get() {
          // True if all levels are the same
          return new Set(Object.values(this._logLevels)).size === 1;
        }
      },
      logLevel: {
        get: function get() {
          return Log.getLevelByName(logLevels[moduleName] || DEFAULT_LOG_LEVEL);
        }
      },
      name: { get: component.toString.bind(component) }
    });
  }

  /**
   * Get the log level (number) by its name (string)
   * @param {String} name - Name of the log level
   * @returns {Number} Requested log level
   * @throws {TwilioError} INVALID_LOG_LEVEL (32056)
   * @public
   */


  _createClass(Log, [{
    key: 'createLog',


    /**
     * Create a child {@link Log} instance with this._logLevels
     * @param moduleName - Name of the logging module
     * @param component - Component owning this instance of {@link Log}
     * @returns {Log} this
     */
    value: function createLog(moduleName, component) {
      var name = this._loggerName;
      // Grab the original logger name
      if (!this._logLevelsEqual) {
        name = name.substring(0, name.lastIndexOf('-'));
      }
      return new Log(moduleName, component, this._logLevels, name);
    }

    /**
     * Set new log levels.
     * This changes the levels for all its ancestors,
     * siblings, and children and descendants instances of {@link Log}.
     * @param {LogLevels} levels - New log levels
     * @throws {TwilioError} INVALID_ARGUMENT
     * @returns {Log} this
     */

  }, {
    key: 'setLevels',
    value: function setLevels(levels) {
      validateLogLevels(levels);
      Object.assign(this._logLevels, levels);
      return this;
    }

    /**
     * Log a message using the logger method appropriate for the specified logLevel
     * @param {Number} logLevel - Log level of the message being logged
     * @param {Array} messages - Message(s) to log
     * @returns {Log} This instance of {@link Log}
     * @public
     */

  }, {
    key: 'log',
    value: function log(logLevel, messages) {
      var name = Log._levels[logLevel];
      // eslint-disable-next-line no-use-before-define
      if (!name) {
        throw E.INVALID_VALUE('logLevel', LOG_LEVEL_VALUES);
      }

      name = name.toLowerCase();
      var prefix = [new Date().toISOString(), name, this.name];

      (this._logger[name] || function noop() {}).apply(undefined, _toConsumableArray(prefix.concat(messages)));

      return this;
    }

    /**
     * Log a debug message
     * @param {...String} messages - Message(s) to pass to the logger
     * @returns {Log} This instance of {@link Log}
     * @public
     */

  }, {
    key: 'debug',
    value: function debug() {
      return this.log(Log.DEBUG, [].slice.call(arguments));
    }

    /**
     * Log a deprecation warning. Deprecation warnings are logged as warnings and
     * they are only ever logged once.
     * @param {String} deprecationWarning - The deprecation warning
     * @returns {Log} This instance of {@link Log}
     * @public
     */

  }, {
    key: 'deprecated',
    value: function deprecated(deprecationWarning) {
      var deprecationWarnings = getDeprecationWarnings(this._component.constructor);
      if (deprecationWarnings.has(deprecationWarning)) {
        return this;
      }
      deprecationWarnings.add(deprecationWarning);
      return this.warn(deprecationWarning);
    }

    /**
     * Log an info message
     * @param {...String} messages - Message(s) to pass to the logger
     * @returns {Log} This instance of {@link Log}
     * @public
     */

  }, {
    key: 'info',
    value: function info() {
      return this.log(Log.INFO, [].slice.call(arguments));
    }

    /**
     * Log a warn message
     * @param {...String} messages - Message(s) to pass to the logger
     * @returns {Log} This instance of {@link Log}
     * @public
     */

  }, {
    key: 'warn',
    value: function warn() {
      return this.log(Log.WARN, [].slice.call(arguments));
    }

    /**
     * Log a warning once.
     * @param {String} warning
     * @returns {Log} This instance of {@link Log}
     * @public
     */

  }, {
    key: 'warnOnce',
    value: function warnOnce(warning) {
      if (this._warnings.has(warning)) {
        return this;
      }
      this._warnings.add(warning);
      return this.warn(warning);
    }

    /**
     * Log an error message
     * @param {...String} messages - Message(s) to pass to the logger
     * @returns {Log} This instance of {@link Log}
     * @public
     */

  }, {
    key: 'error',
    value: function error() {
      return this.log(Log.ERROR, [].slice.call(arguments));
    }

    /**
     * Log an error message and throw an exception
     * @param {TwilioError} error - Error to throw
     * @param {String} customMessage - Custom message for the error
     * @public
     */

  }, {
    key: 'throw',
    value: function _throw(error, customMessage) {
      if (error.clone) {
        error = error.clone(customMessage);
      }

      this.log(Log.ERROR, error);
      throw error;
    }
  }], [{
    key: 'getLevelByName',
    value: function getLevelByName(name) {
      if (!isNaN(name)) {
        return parseInt(name, 10);
      }
      name = name.toUpperCase();
      validateLogLevel(name);
      return Log[name];
    }
  }]);

  return Log;
}();

// Singleton Constants
/* eslint key-spacing:0 */
/* istanbul ignore next */


Object.defineProperties(Log, {
  DEBUG: { value: 0 },
  INFO: { value: 1 },
  WARN: { value: 2 },
  ERROR: { value: 3 },
  OFF: { value: 4 },
  _levels: {
    value: ['DEBUG', 'INFO', 'WARN', 'ERROR', 'OFF']
  }
});

var LOG_LEVELS_SET = {};
var LOG_LEVEL_VALUES = [];

var LOG_LEVEL_NAMES = Log._levels.map(function (level, i) {
  LOG_LEVELS_SET[level] = true;
  LOG_LEVEL_VALUES.push(i);
  return level;
});

function validateLogLevel(level) {
  if (!(level in LOG_LEVELS_SET)) {
    throw E.INVALID_VALUE('level', LOG_LEVEL_NAMES);
  }
}

function validateLogLevels(levels) {
  Object.keys(levels).forEach(function (moduleName) {
    validateLogLevel(levels[moduleName].toUpperCase());
  });
}

module.exports = Log;
},{"./constants":108,"loglevel":175}],119:[function(require,module,exports){
'use strict';

/**
 * Monitor the network connection status to detect interruptions and handoffs.
 */

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var NetworkMonitor = function () {
  /**
   * Construct a {@link NetworkMonitor}.
   * @param {function} onNetworkChanged
   * @param {*} [options]
   */
  function NetworkMonitor(onNetworkChanged, options) {
    var _this = this;

    _classCallCheck(this, NetworkMonitor);

    options = Object.assign({
      navigator: navigator,
      window: window
    }, options);

    var nav = options.navigator;
    var connection = nav.connection || { type: null };
    var type = connection.type;

    var _ref = connection.type ? {
      _events: {
        value: ['change', 'typechange']
      },
      _listener: {
        value: function value() {
          var networkChanged = type !== _this.type && _this.isOnline;
          type = _this.type;
          if (networkChanged) {
            onNetworkChanged();
          }
        }
      },
      _target: {
        value: connection
      }
    } : {
      _events: {
        value: ['online']
      },
      _listener: {
        value: onNetworkChanged
      },
      _target: {
        value: options.window
      }
    },
        _events = _ref._events,
        _listener = _ref._listener,
        _target = _ref._target;

    Object.defineProperties(this, {
      isOnline: {
        enumerable: true,
        get: function get() {
          return typeof nav.onLine === 'boolean' ? nav.onLine : true;
        }
      },
      type: {
        enumerable: true,
        get: function get() {
          return connection.type || null;
        }
      },
      _listener: _listener,
      _events: _events,
      _target: _target
    });
  }

  /**
   * Start the {@link NetworkMonitor}.
   */


  _createClass(NetworkMonitor, [{
    key: 'start',
    value: function start() {
      var _this2 = this;

      this._events.forEach(function (event) {
        _this2._target.addEventListener(event, _this2._listener);
      });
    }

    /**
     * Stop the {@link NetworkMonitor}.
     */

  }, {
    key: 'stop',
    value: function stop() {
      var _this3 = this;

      this._events.forEach(function (event) {
        _this3._target.removeEventListener(event, _this3._listener);
      });
    }
  }]);

  return NetworkMonitor;
}();

module.exports = NetworkMonitor;
},{}],120:[function(require,module,exports){
'use strict';

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var difference = require('../').difference;
var flatMap = require('../').flatMap;
var setSimulcastInMediaSection = require('./simulcast');

var ptToFixedBitrateAudioCodecName = {
  0: 'PCMU',
  8: 'PCMA'
};

/**
 * A payload type
 * @typedef {number} PT
 */

/**
 * An {@link AudioCodec} or {@link VideoCodec}
 * @typedef {AudioCodec|VideoCodec} Codec
 */

// NOTE(mmalavalli): This value is derived from the IETF spec
// for JSEP, and it is used to convert a 'b=TIAS' value in bps
// to a 'b=AS' value in kbps.
// Spec: https://tools.ietf.org/html/draft-ietf-rtcweb-jsep-21#section-5.9
var RTCP_BITRATE = 16000;

/**
 * Construct a b= line string for the given max bitrate in bps. If the modifier
 * is 'AS', then the max bitrate will be converted to kbps using the formula
 * specified in the IETF spec for JSEP mentioned above.
 * @param {string} modifier - 'AS' | 'TIAS'
 * @param {?number} maxBitrate - Max outgoing bitrate (bps)
 * @returns {?string} - If "maxBitrate" is null, then returns null;
 *   otherwise return the constructed b= line string
 */
function createBLine(modifier, maxBitrate) {
  if (!maxBitrate) {
    return null;
  }
  return '\r\nb=' + modifier + ':' + (modifier === 'AS' ? Math.round((maxBitrate + RTCP_BITRATE) / 950) : maxBitrate);
}

/**
 * Create a Codec Map for the given m= section.
 * @param {string} section - The given m= section
 * @returns {Map<Codec, Array<PT>>}
 */
function createCodecMapForMediaSection(section) {
  return Array.from(createPtToCodecName(section)).reduce(function (codecMap, pair) {
    var pt = pair[0];
    var codecName = pair[1];
    var pts = codecMap.get(codecName) || [];
    return codecMap.set(codecName, pts.concat(pt));
  }, new Map());
}

/**
 * Create a Map of MIDs to m= sections for the given SDP.
 * @param {string} sdp
 * @returns {Map<string, string>}
 */
function createMidToMediaSectionMap(sdp) {
  return getMediaSections(sdp).reduce(function (midsToMediaSections, mediaSection) {
    var mid = getMidForMediaSection(mediaSection);
    return mid ? midsToMediaSections.set(mid, mediaSection) : midsToMediaSections;
  }, new Map());
}

/**
 * Create a Map from PTs to codec names for the given m= section.
 * @param {string} mediaSection - The given m= section.
 * @returns {Map<PT, Codec>} ptToCodecName
 */
function createPtToCodecName(mediaSection) {
  return getPayloadTypesInMediaSection(mediaSection).reduce(function (ptToCodecName, pt) {
    var rtpmapPattern = new RegExp('a=rtpmap:' + pt + ' ([^/]+)');
    var matches = mediaSection.match(rtpmapPattern);
    var codecName = matches ? matches[1].toLowerCase() : ptToFixedBitrateAudioCodecName[pt] ? ptToFixedBitrateAudioCodecName[pt].toLowerCase() : '';
    return ptToCodecName.set(pt, codecName);
  }, new Map());
}

/**
 * Get the associated fmtp attributes for the given Payload Type in an m= section.
 * @param {PT} pt
 * @param {string} mediaSection
 * @returns {?object}
 */
function getFmtpAttributesForPt(pt, mediaSection) {
  // In "a=fmtp:<pt> <name>=<value>[;<name>=<value>]*", the regex matches the codec
  // profile parameters expressed as name/value pairs separated by ";".
  var fmtpRegex = new RegExp('^a=fmtp:' + pt + ' (.+)$', 'm');
  var matches = mediaSection.match(fmtpRegex);
  return matches && matches[1].split(';').reduce(function (attrs, nvPair) {
    var _nvPair$split = nvPair.split('='),
        _nvPair$split2 = _slicedToArray(_nvPair$split, 2),
        name = _nvPair$split2[0],
        value = _nvPair$split2[1];

    attrs[name] = isNaN(value) ? value : parseInt(value, 10);
    return attrs;
  }, {});
}

/**
 * Get the MID for the given m= section.
 * @param {string} mediaSection
 * @return {?string}
 */
function getMidForMediaSection(mediaSection) {
  // In "a=mid:<mid>", the regex matches <mid>.
  var midMatches = mediaSection.match(/^a=mid:(.+)$/m);
  return midMatches && midMatches[1];
}

/**
 * Get the m= sections of a particular kind and direction from an sdp.
 * @param {string} sdp - SDP string
 * @param {string} [kind] - Pattern for matching kind
 * @param {string} [direction] - Pattern for matching direction
 * @returns {Array<string>} mediaSections
 */
function getMediaSections(sdp, kind, direction) {
  return sdp.replace(/\r\n\r\n$/, '\r\n').split('\r\nm=').slice(1).map(function (mediaSection) {
    return 'm=' + mediaSection;
  }).filter(function (mediaSection) {
    var kindPattern = new RegExp('m=' + (kind || '.*'), 'gm');
    var directionPattern = new RegExp('a=' + (direction || '.*'), 'gm');
    return kindPattern.test(mediaSection) && directionPattern.test(mediaSection);
  });
}

/**
 * Get the Codec Payload Types present in the first line of the given m= section
 * @param {string} section - The m= section
 * @returns {Array<PT>} Payload Types
 */
function getPayloadTypesInMediaSection(section) {
  var mLine = section.split('\r\n')[0];

  // In "m=<kind> <port> <proto> <payload_type_1> <payload_type_2> ... <payload_type_n>",
  // the regex matches <port> and the Payload Types.
  var matches = mLine.match(/([0-9]+)/g);

  // This should not happen, but in case there are no Payload Types in
  // the m= line, return an empty array.
  if (!matches) {
    return [];
  }

  // Since only the Payload Types are needed, we discard the <port>.
  return matches.slice(1).map(function (match) {
    return parseInt(match, 10);
  });
}

/**
 * Create the reordered Codec Payload Types based on the preferred Codec Names.
 * @param {Map<Codec, Array<PT>>} codecMap - Codec Map
 * @param {Array<AudioCodecSettings|VideoCodecSettings>} preferredCodecs - Preferred Codecs
 * @returns {Array<PT>} Reordered Payload Types
 */
function getReorderedPayloadTypes(codecMap, preferredCodecs) {
  preferredCodecs = preferredCodecs.map(function (_ref) {
    var codec = _ref.codec;
    return codec.toLowerCase();
  });
  var preferredPayloadTypes = flatMap(preferredCodecs, function (codecName) {
    return codecMap.get(codecName) || [];
  });
  var remainingCodecs = difference(Array.from(codecMap.keys()), preferredCodecs);
  var remainingPayloadTypes = flatMap(remainingCodecs, function (codecName) {
    return codecMap.get(codecName);
  });
  return preferredPayloadTypes.concat(remainingPayloadTypes);
}

/**
 * Set the specified max bitrate in the given m= section.
 * @param {string} modifier - 'AS' | 'TIAS'
 * @param {?number} maxBitrate - Max outgoing bitrate (bps)
 * @param {string} section - m= section string
 * @returns {string} The updated m= section
 */
function setBitrateInMediaSection(modifier, maxBitrate, section) {
  var bLine = createBLine(modifier, maxBitrate) || '';
  var bLinePattern = /\r\nb=(AS|TIAS):([0-9]+)/;
  var bLineMatched = section.match(bLinePattern);

  if (!bLineMatched) {
    return section.replace(/(\r\n)?$/, bLine + '$1');
  }

  var maxBitrateMatched = parseInt(bLineMatched[2], 10);
  maxBitrate = maxBitrate || Infinity;
  bLine = createBLine(modifier, Math.min(maxBitrateMatched, maxBitrate));
  return section.replace(bLinePattern, bLine);
}

/**
 * Set maximum bitrates to the media sections in a given sdp.
 * @param {string} sdp - sdp string
 * @param {string} modifier - 'AS' | 'TIAS"
 * @param {?number} maxAudioBitrate - Max outgoing audio bitrate (bps), null
 *   if no limit is to be applied
 * @param {?number} maxVideoBitrate - Max outgoing video bitrate (bps), null
 *   if no limit is to be applied
 * @returns {string} - The updated sdp string
 */
function setBitrateParameters(sdp, modifier, maxAudioBitrate, maxVideoBitrate) {
  var mediaSections = getMediaSections(sdp);
  var session = sdp.split('\r\nm=')[0];
  return [session].concat(mediaSections.map(function (section) {
    // Bitrate parameters should not be applied to m=application sections
    // or to m=(audio|video) sections that do not receive media.
    if (!/^m=(audio|video)/.test(section) || !/a=(recvonly|sendrecv)/.test(section)) {
      return section;
    }
    var kind = section.match(/^m=(audio|video)/)[1];
    var maxBitrate = kind === 'audio' ? maxAudioBitrate : maxVideoBitrate;
    return setBitrateInMediaSection(modifier, maxBitrate, section);
  })).join('\r\n');
}

/**
 * Set the given Codec Payload Types in the first line of the given m= section.
 * @param {Array<PT>} payloadTypes - Payload Types
 * @param {string} section - Given m= section
 * @returns {string} - Updated m= section
 */
function setPayloadTypesInMediaSection(payloadTypes, section) {
  var lines = section.split('\r\n');
  var mLine = lines[0];
  var otherLines = lines.slice(1);
  mLine = mLine.replace(/([0-9]+\s?)+$/, payloadTypes.join(' '));
  return [mLine].concat(otherLines).join('\r\n');
}

/**
 * Return a new SDP string with the re-ordered codec preferences.
 * @param {string} sdp
 * @param {Array<AudioCodec>} preferredAudioCodecs - If empty, the existing order
 *   of audio codecs is preserved
 * @param {Array<VideoCodecSettings>} preferredVideoCodecs - If empty, the
 *   existing order of video codecs is preserved
 * @returns {string} Updated SDP string
 */
function setCodecPreferences(sdp, preferredAudioCodecs, preferredVideoCodecs) {
  var mediaSections = getMediaSections(sdp);
  var session = sdp.split('\r\nm=')[0];
  return [session].concat(mediaSections.map(function (section) {
    // Codec preferences should not be applied to m=application sections.
    if (!/^m=(audio|video)/.test(section)) {
      return section;
    }
    var kind = section.match(/^m=(audio|video)/)[1];
    var codecMap = createCodecMapForMediaSection(section);
    var preferredCodecs = kind === 'audio' ? preferredAudioCodecs : preferredVideoCodecs;
    var payloadTypes = getReorderedPayloadTypes(codecMap, preferredCodecs);
    var newSection = setPayloadTypesInMediaSection(payloadTypes, section);

    var pcmaPayloadTypes = codecMap.get('pcma') || [];
    var pcmuPayloadTypes = codecMap.get('pcmu') || [];
    var fixedBitratePayloadTypes = kind === 'audio' ? new Set(pcmaPayloadTypes.concat(pcmuPayloadTypes)) : new Set();

    return fixedBitratePayloadTypes.has(payloadTypes[0]) ? newSection.replace(/\r\nb=(AS|TIAS):([0-9]+)/g, '') : newSection;
  })).join('\r\n');
}

/**
 * Return a new SDP string with simulcast settings.
 * @param {string} sdp
 * @param {'planb' | 'unified'} sdpFormat
 * @param {Map<Track.ID, TrackAttributes>} trackIdsToAttributes
 * @returns {string} Updated SDP string
 */
function setSimulcast(sdp, sdpFormat, trackIdsToAttributes) {
  var mediaSections = getMediaSections(sdp);
  var session = sdp.split('\r\nm=')[0];
  return [session].concat(mediaSections.map(function (section) {
    section = section.replace(/\r\n$/, '');
    if (!/^m=video/.test(section)) {
      return section;
    }
    var codecMap = createCodecMapForMediaSection(section);
    var payloadTypes = getPayloadTypesInMediaSection(section);
    var vp8PayloadTypes = new Set(codecMap.get('vp8') || []);

    var hasVP8PayloadType = payloadTypes.some(function (payloadType) {
      return vp8PayloadTypes.has(payloadType);
    });
    return hasVP8PayloadType ? setSimulcastInMediaSection(section, sdpFormat, trackIdsToAttributes) : section;
  })).concat('').join('\r\n');
}

/**
 * Get the matching Payload Types in a unified plan local m= section for a particular remote codec.
 * @param {Codec} remoteCodec
 * @param {PT} remotePt
 * @param {Map<Codec, PT>} localCodecsToPts
 * @param {string} localSection
 * @param {string} remoteSection
 * @returns {Array<PT>}
 */
function unifiedPlanGetMatchingLocalPayloadTypes(remoteCodec, remotePt, localCodecsToPts, localSection, remoteSection) {
  // If there is at most one local Payload Type that matches the remote codec, retain it.
  var matchingLocalPts = localCodecsToPts.get(remoteCodec) || [];
  if (matchingLocalPts.length <= 1) {
    return matchingLocalPts;
  }

  // If there are no fmtp attributes for the codec in the remote m= section,
  // then we cannot get a match in the local m= section. In that case, retain
  // all matching local Payload Types.
  var remoteFmtpAttrs = getFmtpAttributesForPt(remotePt, remoteSection);
  if (!remoteFmtpAttrs) {
    return matchingLocalPts;
  }

  // Among the matched local Payload Types, find the one that matches the remote
  // fmtp attributes.
  var matchinglocalPt = matchingLocalPts.find(function (localPt) {
    var localFmtpAttrs = getFmtpAttributesForPt(localPt, localSection);
    return localFmtpAttrs && Object.keys(remoteFmtpAttrs).every(function (attr) {
      return remoteFmtpAttrs[attr] === localFmtpAttrs[attr];
    });
  });

  // If none of the matched local Payload Types also have matching fmtp attributes,
  // then retain all of them, otherwise retain only the local Payload Type that
  // matches the remote fmtp attributes.
  return typeof matchinglocalPt === 'number' ? [matchinglocalPt] : matchingLocalPts;
}

/**
 * Filter codecs in a local unified plan m= section based on its equivalent remote m= section.
 * @param {string} localSection
 * @param {Map<string, string>} remoteMidsToMediaSections
 * @returns {string}
 */
function unifiedPlanFilterCodecsInLocalMediaSection(localSection, remoteMidsToMediaSections) {
  // Do nothing if the local m= section represents neither audio nor video.
  if (!/^m=(audio|video)/.test(localSection)) {
    return localSection;
  }

  // Do nothing if the local m= section does not have an equivalent remote m= section.
  var localMid = getMidForMediaSection(localSection);
  var remoteSection = localMid && remoteMidsToMediaSections.get(localMid);
  if (!remoteSection) {
    return localSection;
  }

  // Construct a Map of the remote Payload Types to their codec names.
  var remotePtToCodecs = createPtToCodecName(remoteSection);
  // Construct a Map of the local codec names to their Payload Types.
  var localCodecsToPts = createCodecMapForMediaSection(localSection);
  // Maintain a list of local non-rtx Payload Types to retain.
  var localPts = flatMap(Array.from(remotePtToCodecs), function (_ref2) {
    var _ref3 = _slicedToArray(_ref2, 2),
        remotePt = _ref3[0],
        remoteCodec = _ref3[1];

    return remoteCodec !== 'rtx' ? unifiedPlanGetMatchingLocalPayloadTypes(remoteCodec, remotePt, localCodecsToPts, localSection, remoteSection) : [];
  });

  // For each local Payload Type that will be retained, retain their
  // corresponding rtx Payload Type if present.
  var localRtxPts = localCodecsToPts.get('rtx') || [];
  // In "a=fmtp:<rtxPt> apt=<apt>", extract the codec PT <apt> associated with rtxPt.
  localPts = localPts.concat(localRtxPts.filter(function (rtxPt) {
    var fmtpAttrs = getFmtpAttributesForPt(rtxPt, localSection);
    return fmtpAttrs && localPts.includes(fmtpAttrs.apt);
  }));

  // Filter out the below mentioned attribute lines in the local m= section that
  // do not belong to one of the local Payload Types that are to be retained.
  // 1. "a=rtpmap:<pt> <codec>"
  // 2. "a=rtcp-fb:<pt> <attr>[ <attr>]*"
  // 3. "a=fmtp:<pt> <name>=<value>[;<name>=<value>]*"
  var lines = localSection.split('\r\n').filter(function (line) {
    var ptMatches = line.match(/^a=(rtpmap|fmtp|rtcp-fb):(.+) .+$/);
    var pt = ptMatches && ptMatches[2];
    return !ptMatches || pt && localPts.includes(parseInt(pt, 10));
  });

  // Filter the list of Payload Types in the first line of the m= section.
  var orderedLocalPts = getPayloadTypesInMediaSection(localSection).filter(function (pt) {
    return localPts.includes(pt);
  });
  return setPayloadTypesInMediaSection(orderedLocalPts, lines.join('\r\n'));
}

/**
 * Filter local codecs based on the remote unified plan SDP.
 * @param {string} localSdp
 * @param {string} remoteSdp
 * @returns {string} - Updated local SDP
 */
function unifiedPlanFilterLocalCodecs(localSdp, remoteSdp) {
  var localMediaSections = getMediaSections(localSdp);
  var localSession = localSdp.split('\r\nm=')[0];
  var remoteMidsToMediaSections = createMidToMediaSectionMap(remoteSdp);
  return [localSession].concat(localMediaSections.map(function (localSection) {
    return unifiedPlanFilterCodecsInLocalMediaSection(localSection, remoteMidsToMediaSections);
  })).join('\r\n');
}

/**
 * Return a new SDP string after reverting simulcast for non vp8 sections in remote sdp.
 * @param localSdp - simulcast enabled local sdp
 * @param localSdpWithoutSimulcast - local sdp before simulcast was set
 * @param remoteSdp - remote sdp
 * @return {string} Updated SDP string
 */
function revertSimulcastForNonVP8MediaSections(localSdp, localSdpWithoutSimulcast, remoteSdp) {
  var remoteMidToMediaSections = createMidToMediaSectionMap(remoteSdp);
  var localMidToMediaSectionsWithoutSimulcast = createMidToMediaSectionMap(localSdpWithoutSimulcast);
  var mediaSections = getMediaSections(localSdp);
  var session = localSdp.split('\r\nm=')[0];
  return [session].concat(mediaSections.map(function (section) {
    section = section.replace(/\r\n$/, '');
    if (!/^m=video/.test(section)) {
      return section;
    }
    var midMatches = section.match(/^a=mid:(.+)$/m);
    var mid = midMatches && midMatches[1];
    if (!mid) {
      return section;
    }

    var remoteSection = remoteMidToMediaSections.get(mid);
    var remotePtToCodecs = createPtToCodecName(remoteSection);
    var remotePayloadTypes = getPayloadTypesInMediaSection(remoteSection);

    var isVP8ThePreferredCodec = remotePayloadTypes.length && remotePtToCodecs.get(remotePayloadTypes[0]) === 'vp8';
    return isVP8ThePreferredCodec ? section : localMidToMediaSectionsWithoutSimulcast.get(mid).replace(/\r\n$/, '');
  })).concat('').join('\r\n');
}

/**
 * Add or rewrite MSIDs for new m= sections in the given Unified Plan SDP with their
 * corresponding local MediaStreamTrack IDs. These can be different when previously
 * removed MediaStreamTracks are added back (or Track IDs may not be present in the
 * SDPs at all once browsers implement the latest WebRTC spec).
 * @param {string} sdp
 * @param {Map<string, Track.ID>} activeMidsToTrackIds
 * @param {Map<Track.Kind, Array<Track.ID>>} trackIdsByKind
 * @returns {string}
 */
function unifiedPlanAddOrRewriteNewTrackIds(sdp, activeMidsToTrackIds, trackIdsByKind) {
  // NOTE(mmalavalli): The m= sections for the new MediaStreamTracks are usually
  // present after the m= sections for the existing MediaStreamTracks, in order
  // of addition.
  var newMidsToTrackIds = Array.from(trackIdsByKind).reduce(function (midsToTrackIds, _ref4) {
    var _ref5 = _slicedToArray(_ref4, 2),
        kind = _ref5[0],
        trackIds = _ref5[1];

    var mediaSections = getMediaSections(sdp, kind, 'send(only|recv)');
    var newMids = mediaSections.map(getMidForMediaSection).filter(function (mid) {
      return !activeMidsToTrackIds.has(mid);
    });
    newMids.forEach(function (mid, i) {
      return midsToTrackIds.set(mid, trackIds[i]);
    });
    return midsToTrackIds;
  }, new Map());
  return unifiedPlanAddOrRewriteTrackIds(sdp, newMidsToTrackIds);
}

/**
 * Add or rewrite MSIDs in the given Unified Plan SDP with their corresponding local
 * MediaStreamTrack IDs. These IDs need not be the same (or Track IDs may not be
 * present in the SDPs at all once browsers implement the latest WebRTC spec).
 * @param {string} sdp
 * @param {Map<string, Track.ID>} midsToTrackIds
 * @returns {string}
 */
function unifiedPlanAddOrRewriteTrackIds(sdp, midsToTrackIds) {
  var mediaSections = getMediaSections(sdp);
  var session = sdp.split('\r\nm=')[0];
  return [session].concat(mediaSections.map(function (mediaSection) {
    // Do nothing if the m= section represents neither audio nor video.
    if (!/^m=(audio|video)/.test(mediaSection)) {
      return mediaSection;
    }
    // This shouldn't happen, but in case there is no MID for the m= section, do nothing.
    var mid = getMidForMediaSection(mediaSection);
    if (!mid) {
      return mediaSection;
    }
    // In case there is no Track ID for the given MID in the map, do nothing.
    var trackId = midsToTrackIds.get(mid);
    if (!trackId) {
      return mediaSection;
    }
    // This shouldn't happen, but in case there is no a=msid: line, do nothing.
    var attributes = (mediaSection.match(/^a=msid:(.+)$/m) || [])[1];
    if (!attributes) {
      return mediaSection;
    }
    // If the a=msid: line contains the "appdata" field, then replace it with the Track ID,
    // otherwise append the Track ID.

    var _attributes$split = attributes.split(' '),
        _attributes$split2 = _slicedToArray(_attributes$split, 2),
        msid = _attributes$split2[0],
        trackIdToRewrite = _attributes$split2[1];

    var msidRegex = new RegExp('msid:' + msid + (trackIdToRewrite ? ' ' + trackIdToRewrite : '') + '$', 'gm');
    return mediaSection.replace(msidRegex, 'msid:' + msid + ' ' + trackId);
  })).join('\r\n');
}

/**
 * removes specified ssrc attributes from given sdp
 * @param {string} sdp
 * @param {Array<string>} ssrcAttributesToRemove
 * @returns {string}
 */
function removeSSRCAttributes(sdp, ssrcAttributesToRemove) {
  return sdp.split('\r\n').filter(function (line) {
    return !ssrcAttributesToRemove.find(function (srcAttribute) {
      return new RegExp('a=ssrc:.*' + srcAttribute + ':', 'g').test(line);
    });
  }).join('\r\n');
}

/**
 * Disable RTX in a given sdp.
 * @param {string} sdp
 * @returns {string} sdp without RTX
 */
function disableRtx(sdp) {
  var mediaSections = getMediaSections(sdp);
  var session = sdp.split('\r\nm=')[0];
  return [session].concat(mediaSections.map(function (mediaSection) {
    // Do nothing if the m= section does not represent a video track.
    if (!/^m=video/.test(mediaSection)) {
      return mediaSection;
    }

    // Create a map of codecs to payload types.
    var codecsToPts = createCodecMapForMediaSection(mediaSection);
    // Get the RTX payload types.
    var rtxPts = codecsToPts.get('rtx');

    // Do nothing if there are no RTX payload types.
    if (!rtxPts) {
      return mediaSection;
    }

    // Remove the RTX payload types.
    var pts = new Set(getPayloadTypesInMediaSection(mediaSection));
    rtxPts.forEach(function (rtxPt) {
      return pts.delete(rtxPt);
    });

    // Get the RTX SSRC.
    var rtxSSRCMatches = mediaSection.match(/a=ssrc-group:FID [0-9]+ ([0-9]+)/);
    var rtxSSRC = rtxSSRCMatches && rtxSSRCMatches[1];

    // Remove the following lines associated with the RTX payload types:
    // 1. "a=fmtp:<rtxPt> apt=<pt>"
    // 2. "a=rtpmap:<rtxPt> rtx/..."
    // 3. "a=ssrc:<rtxSSRC> cname:..."
    // 4. "a=ssrc-group:FID <SSRC> <rtxSSRC>"
    var filterRegexes = [/^a=fmtp:.+ apt=.+$/, /^a=rtpmap:.+ rtx\/.+$/, /^a=ssrc-group:.+$/].concat(rtxSSRC ? [new RegExp('^a=ssrc:' + rtxSSRC + ' .+$')] : []);

    mediaSection = mediaSection.split('\r\n').filter(function (line) {
      return filterRegexes.every(function (regex) {
        return !regex.test(line);
      });
    }).join('\r\n');

    // Reconstruct the m= section without the RTX payload types.
    return setPayloadTypesInMediaSection(Array.from(pts), mediaSection);
  })).join('\r\n');
}

/**
 * Generate an a=fmtp: line from the given payload type and attributes.
 * @param {PT} pt
 * @param {*} fmtpAttrs
 * @returns {string}
 */
function generateFmtpLineFromPtAndAttributes(pt, fmtpAttrs) {
  var serializedFmtpAttrs = Object.entries(fmtpAttrs).map(function (_ref6) {
    var _ref7 = _slicedToArray(_ref6, 2),
        name = _ref7[0],
        value = _ref7[1];

    return name + '=' + value;
  }).join(';');
  return 'a=fmtp:' + pt + ' ' + serializedFmtpAttrs;
}

/**
 * Enable DTX for opus in the m= sections for the given MIDs.`
 * @param {string} sdp
 * @param {Array<string>} [mids] - If not specified, enables opus DTX for all
 *   audio m= lines.
 * @returns {string}
 */
function enableDtxForOpus(sdp, mids) {
  var mediaSections = getMediaSections(sdp);
  var session = sdp.split('\r\nm=')[0];

  mids = mids || mediaSections.filter(function (section) {
    return (/^m=audio/.test(section)
    );
  }).map(getMidForMediaSection);

  return [session].concat(mediaSections.map(function (section) {
    // Do nothing if the m= section is not audio.
    if (!/^m=audio/.test(section)) {
      return section;
    }

    // Build a map codecs to payload types.
    var codecsToPts = createCodecMapForMediaSection(section);

    // Do nothing if a payload type for opus does not exist.
    var opusPt = codecsToPts.get('opus');
    if (!opusPt) {
      return section;
    }

    // If no fmtp attributes are found for opus, do nothing.
    var opusFmtpAttrs = getFmtpAttributesForPt(opusPt, section);
    if (!opusFmtpAttrs) {
      return section;
    }

    // Add usedtx=1 to the a=fmtp: line for opus.
    var origOpusFmtpLine = generateFmtpLineFromPtAndAttributes(opusPt, opusFmtpAttrs);
    var origOpusFmtpRegex = new RegExp(origOpusFmtpLine);

    // If the m= section's MID is in the list of MIDs, then enable dtx. Otherwise disable it.
    var mid = getMidForMediaSection(section);
    if (mids.includes(mid)) {
      opusFmtpAttrs.usedtx = 1;
    } else {
      delete opusFmtpAttrs.usedtx;
    }

    var opusFmtpLineWithDtx = generateFmtpLineFromPtAndAttributes(opusPt, opusFmtpAttrs);
    return section.replace(origOpusFmtpRegex, opusFmtpLineWithDtx);
  })).join('\r\n');
}

exports.createCodecMapForMediaSection = createCodecMapForMediaSection;
exports.createPtToCodecName = createPtToCodecName;
exports.disableRtx = disableRtx;
exports.enableDtxForOpus = enableDtxForOpus;
exports.getMediaSections = getMediaSections;
exports.removeSSRCAttributes = removeSSRCAttributes;
exports.revertSimulcastForNonVP8MediaSections = revertSimulcastForNonVP8MediaSections;
exports.setBitrateParameters = setBitrateParameters;
exports.setCodecPreferences = setCodecPreferences;
exports.setSimulcast = setSimulcast;
exports.unifiedPlanFilterLocalCodecs = unifiedPlanFilterLocalCodecs;
exports.unifiedPlanAddOrRewriteNewTrackIds = unifiedPlanAddOrRewriteNewTrackIds;
exports.unifiedPlanAddOrRewriteTrackIds = unifiedPlanAddOrRewriteTrackIds;
},{"../":114,"./simulcast":122}],121:[function(require,module,exports){
'use strict';

var RTCSessionDescription = require('@twilio/webrtc').RTCSessionDescription;

var createPtToCodecName = require('./').createPtToCodecName;
var getMediaSections = require('./').getMediaSections;

/**
 * An RTX payload type
 * @typedef {PT} RtxPT
 */

/**
 * A non-RTX payload type
 * @typedef {PT} NonRtxPT
 */

/**
 * A Set with at least one element
 * @typedef {Set} NonEmptySet
 */

/**
 * Apply the workaround for Issue 8329 to an RTCSessionDescriptionInit.
 * @param {RTCSessionDescriptionInit} description
 * @returns {RTCSessionDescription} newDescription
 */
function workaround(description) {
  var descriptionInit = { type: description.type };
  if (description.type !== 'rollback') {
    descriptionInit.sdp = sdpWorkaround(description.sdp);
  }
  return new RTCSessionDescription(descriptionInit);
}

/**
 * @param {string} sdp
 * @returns {string} newSdp
 */
function sdpWorkaround(sdp) {
  var mediaSections = getMediaSections(sdp);
  var session = sdp.split('\r\nm=')[0];
  return [session].concat(mediaSections.map(mediaSectionWorkaround)).join('\r\n');
}

/**
 * @param {string} mediaSection
 * @returns {string} newMediaSection
 */
function mediaSectionWorkaround(mediaSection) {
  var ptToCodecName = createPtToCodecName(mediaSection);
  mediaSection = deleteDuplicateRtxPts(mediaSection, ptToCodecName);
  var codecNameToPts = createCodecNameToPts(ptToCodecName);
  var rtxPts = codecNameToPts.get('rtx') || new Set();

  var invalidRtxPts = new Set();
  var rtxPtToAssociatedPt = createRtxPtToAssociatedPt(mediaSection, ptToCodecName, rtxPts, invalidRtxPts);
  var associatedPtToRtxPt = createAssociatedPtToRtxPt(rtxPtToAssociatedPt, invalidRtxPts);

  var unassociatedRtxPts = Array.from(invalidRtxPts);

  // NOTE(mroberts): We normalize to lowercase.
  var knownCodecNames = ['h264', 'vp8', 'vp9'];
  var unassociatedPts = knownCodecNames.reduce(function (unassociatedPts, codecName) {
    var pts = codecNameToPts.get(codecName) || new Set();
    return Array.from(pts).reduce(function (unassociatedPts, pt) {
      return associatedPtToRtxPt.has(pt) ? unassociatedPts : unassociatedPts.add(pt);
    }, unassociatedPts);
  }, new Set());

  unassociatedPts.forEach(function (pt) {
    if (unassociatedRtxPts.length) {
      var rtxPt = unassociatedRtxPts.shift();
      mediaSection = deleteFmtpAttributesForRtxPt(mediaSection, rtxPt);
      mediaSection = addFmtpAttributeForRtxPt(mediaSection, rtxPt, pt);
    }
  });

  unassociatedRtxPts.forEach(function (rtxPt) {
    mediaSection = deleteFmtpAttributesForRtxPt(mediaSection, rtxPt);
    mediaSection = deleteRtpmapAttributesForRtxPt(mediaSection, rtxPt);
  });

  return mediaSection;
}

/**
 * @param {string} mediaSection
 * @param {Map<PT, Codec>} ptToCodecName
 * @returns {string} newMediaSection
 */
function deleteDuplicateRtxPts(mediaSection, ptToCodecName) {
  // NOTE(syerrapragada): In some cases Chrome produces an offer/answer
  // with duplicate "rtx" payload mapping in media section. When applied,
  // Chrome rejects the SDP. We workaround this by deleting duplicate
  // "rtx" mappings found in SDP.
  return Array.from(ptToCodecName.keys()).reduce(function (section, pt) {
    var rtpmapRegex = new RegExp('^a=rtpmap:' + pt + ' rtx.+$', 'gm');
    return (section.match(rtpmapRegex) || []).slice(ptToCodecName.get(pt) === 'rtx' ? 1 : 0).reduce(function (section, rtpmap) {
      var rtpmapRegex = new RegExp('\r\n' + rtpmap);
      var fmtpmapRegex = new RegExp('\r\na=fmtp:' + pt + ' apt=[0-9]+');
      return section.replace(rtpmapRegex, '').replace(fmtpmapRegex, '');
    }, section);
  }, mediaSection);
}

/**
 * @param {Map<PT, Codec>} ptToCodecName
 * @returns {Map<string, NonEmptySet<PT>>} codecNameToPts
 */
function createCodecNameToPts(ptToCodecName) {
  var codecNameToPts = new Map();
  ptToCodecName.forEach(function (codecName, pt) {
    var pts = codecNameToPts.get(codecName) || new Set();
    return codecNameToPts.set(codecName, pts.add(pt));
  });
  return codecNameToPts;
}

/**
 * @param {string} mediaSection
 * @param {Map<PT, Codec>} ptToCodecName
 * @param {Set<RtxPT>} rtxPts
 * @param {Set<RtxPT>} invalidRtxPts
 * @returns {Map<RtxPT, NonRtxPT>} rtxPtToAssociatedPt
 */
function createRtxPtToAssociatedPt(mediaSection, ptToCodecName, rtxPts, invalidRtxPts) {
  return Array.from(rtxPts).reduce(function (rtxPtToAssociatedPt, rtxPt) {
    var fmtpPattern = new RegExp('a=fmtp:' + rtxPt + ' apt=(\\d+)');
    var matches = mediaSection.match(fmtpPattern);
    if (!matches) {
      invalidRtxPts.add(rtxPt);
      return rtxPtToAssociatedPt;
    }

    var pt = Number.parseInt(matches[1]);
    if (!ptToCodecName.has(pt)) {
      // This is Issue 8329.
      invalidRtxPts.add(rtxPt);
      return rtxPtToAssociatedPt;
    }

    var codecName = ptToCodecName.get(pt);
    if (codecName === 'rtx') {
      // Strange
      invalidRtxPts.add(rtxPt);
      return rtxPtToAssociatedPt;
    }

    return rtxPtToAssociatedPt.set(rtxPt, pt);
  }, new Map());
}

/**
 * @param {string} mediaSection
 * @param {Map<RtxPT, NonRtxPT>} rtxPtToAssociatedPt
 * @param {Set<RtxPT>} invalidRtxPts
 * @returns {Map<NonRtxPT, RtxPT>} associatedPtToRtxPt
 */
function createAssociatedPtToRtxPt(rtxPtToAssociatedPt, invalidRtxPts) {
  // First, we construct a Map<NonRtxPT, NonEmptySet<RtxPT>>.
  var associatedPtToRtxPts = Array.from(rtxPtToAssociatedPt).reduce(function (associatedPtToRtxPts, pair) {
    var rtxPt = pair[0];
    var pt = pair[1];
    var rtxPts = associatedPtToRtxPts.get(pt) || new Set();
    return associatedPtToRtxPts.set(pt, rtxPts.add(rtxPt));
  }, new Map());

  // Then, we filter down to a Map<NonRtxPT, RtxPt>. Any RtxPTs that map to the
  // same NonRtxPT are removed and added to invalidRtxPts.
  return Array.from(associatedPtToRtxPts).reduce(function (associatedPtToRtxPt, pair) {
    var pt = pair[0];
    var rtxPts = Array.from(pair[1]);
    if (rtxPts.length > 1) {
      rtxPts.forEach(function (rtxPt) {
        invalidRtxPts.add(rtxPt);
      });
      return associatedPtToRtxPt;
    }
    return associatedPtToRtxPt.set(pt, rtxPts[0]);
  }, new Map());
}

/**
 * @param {string} mediaSection
 * @param {RtxPT} rtxPt
 * @returns {string} newMediaSection
 */
function deleteFmtpAttributesForRtxPt(mediaSection, rtxPt) {
  var pattern = new RegExp('a=fmtp:' + rtxPt + '.*\r\n', 'gm');
  return mediaSection.replace(pattern, '');
}

/**
 * @param {string} mediaSection
 * @param {RtxPT} rtxPt
 * @returns {string} newMediaSection
 */
function deleteRtpmapAttributesForRtxPt(mediaSection, rtxPt) {
  var pattern = new RegExp('a=rtpmap:' + rtxPt + '.*\r\n', 'gm');
  return mediaSection.replace(pattern, '');
}

/**
 * @param {string} mediaSection
 * @param {RtxPT} rtxPt
 * @param {NonRtxPT} pt
 * @returns {string} newMediaSection
 */
function addFmtpAttributeForRtxPt(mediaSection, rtxPt, pt) {
  return mediaSection.endsWith('\r\n') ? mediaSection + 'a=fmtp:' + rtxPt + ' apt=' + pt + '\r\n' : mediaSection + '\r\na=fmtp:' + rtxPt + ' apt=' + pt;
}

module.exports = workaround;
},{"./":120,"@twilio/webrtc":136}],122:[function(require,module,exports){
'use strict';

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var difference = require('../').difference;
var flatMap = require('../').flatMap;

/**
 * Create a random {@link SSRC}.
 * @returns {SSRC}
 */
function createSSRC() {
  var ssrcMax = 0xffffffff;
  return String(Math.floor(Math.random() * ssrcMax));
}

/**
 * @property {string} cName
 * @property {boolean} isSimulcastEnabled
 * @property {Map<RtxSSRC, PrimarySSRC>} rtxPairs
 * @property {Set<PrimarySSRC>} primarySSRCs
 * @property {string} streamId
 * @property {Track.ID} trackId
 */

var TrackAttributes = function () {
  /**
   * Construct a {@link MediaStreamTrack} attribute store.
   * @param {Track.ID} trackId - The MediaStreamTrack ID
   * @param {MediaStreamID} streamId - The MediaStream ID
   * @param {string} cName - The MediaStream cname
   */
  function TrackAttributes(trackId, streamId, cName) {
    _classCallCheck(this, TrackAttributes);

    Object.defineProperties(this, {
      cName: {
        enumerable: true,
        value: cName
      },
      isSimulcastEnabled: {
        enumerable: true,
        value: false,
        writable: true
      },
      primarySSRCs: {
        enumerable: true,
        value: new Set()
      },
      rtxPairs: {
        enumerable: true,
        value: new Map()
      },
      streamId: {
        enumerable: true,
        value: streamId
      },
      trackId: {
        enumerable: true,
        value: trackId
      }
    });
  }

  /**
   * Add {@link SimSSRC}s to the {@link TrackAttributes}.
   * @returns {void}
   */


  _createClass(TrackAttributes, [{
    key: 'addSimulcastSSRCs',
    value: function addSimulcastSSRCs() {
      if (this.isSimulcastEnabled) {
        return;
      }
      var simulcastSSRCs = [createSSRC(), createSSRC()];
      simulcastSSRCs.forEach(function (ssrc) {
        this.primarySSRCs.add(ssrc);
      }, this);

      if (this.rtxPairs.size) {
        simulcastSSRCs.forEach(function (ssrc) {
          this.rtxPairs.set(createSSRC(), ssrc);
        }, this);
      }
    }

    /**
     * Add the given {@link PrimarySSRC} or {@link RtxSSRC} to the {@link TrackAttributes}
     * and update the "isSimulcastEnabled" flag if it is also a {@link SimSSRC}.
     * @param {SSRC} ssrc - The {@link SSRC} to be added
     * @param {?PrimarySSRC} primarySSRC - The {@link PrimarySSRC}; if the given
     *   {@link SSRC} itself is the {@link PrimarySSRC}, then this is set to null
     * @param {boolean} isSimSSRC - true if the given {@link SSRC} is a
     *   {@link SimSSRC}; false otherwise
     * @returns {void}
     */

  }, {
    key: 'addSSRC',
    value: function addSSRC(ssrc, primarySSRC, isSimSSRC) {
      if (primarySSRC) {
        this.rtxPairs.set(ssrc, primarySSRC);
      } else {
        this.primarySSRCs.add(ssrc);
      }
      this.isSimulcastEnabled = this.isSimulcastEnabled || isSimSSRC;
    }

    /**
     * Construct the SDP lines for the {@link TrackAttributes}.
     * @param {boolean} [excludeRtx=false]
     * @returns {Array<string>} Array of SDP lines
     */

  }, {
    key: 'toSdpLines',
    value: function toSdpLines(excludeRtx) {
      var _this = this;

      var rtxPairs = excludeRtx ? [] : Array.from(this.rtxPairs.entries()).map(function (rtxPair) {
        return rtxPair.reverse();
      });

      var simSSRCs = Array.from(this.primarySSRCs.values());
      var ssrcs = rtxPairs.length ? flatMap(rtxPairs) : simSSRCs;

      var attrLines = flatMap(ssrcs, function (ssrc) {
        return ['a=ssrc:' + ssrc + ' cname:' + _this.cName, 'a=ssrc:' + ssrc + ' msid:' + _this.streamId + ' ' + _this.trackId];
      });
      var rtxPairLines = rtxPairs.map(function (rtxPair) {
        return 'a=ssrc-group:FID ' + rtxPair.join(' ');
      });
      var simGroupLines = ['a=ssrc-group:SIM ' + simSSRCs.join(' ')];

      return rtxPairLines.concat(attrLines).concat(simGroupLines);
    }
  }]);

  return TrackAttributes;
}();

/**
 * Get the matches for a given RegEx pattern.
 * @param {string} section - SDP media section
 * @param {string} pattern - RegEx pattern
 * @returns {Array<Array<string>>} - Array of pattern matches
 */


function getMatches(section, pattern) {
  var matches = section.match(new RegExp(pattern, 'gm')) || [];
  return matches.map(function (match) {
    var matches = match.match(new RegExp(pattern)) || [];
    return matches.slice(1);
  });
}

/**
 * Get the {@link SimSSRC}s that belong to a simulcast group.
 * @param {string} section - SDP media section
 * @returns {Set<SimSSRC>} Set of simulcast {@link SSRC}s
 */
function getSimulcastSSRCs(section) {
  var simGroupPattern = '^a=ssrc-group:SIM ([0-9]+) ([0-9]+) ([0-9]+)$';
  return new Set(flatMap(getMatches(section, simGroupPattern)));
}

/**
 * Get the value of the given attribute for an SSRC.
 * @param {string} section - SDP media section
 * @param {SSRC} ssrc - {@link SSRC} whose attribute's value is to be determinded
 * @param {string} attribute - {@link SSRC} attribute name
 * @param {string} - {@link SSRC} attribute value
 */
function getSSRCAttribute(section, ssrc, attribute) {
  var pattern = 'a=ssrc:' + ssrc + ' ' + attribute + ':(.+)';
  return section.match(new RegExp(pattern))[1];
}

/**
 * Create a Map of {@link PrimarySSRC}s and their {@link RtxSSRC}s.
 * @param {string} section - SDP media section
 * @returns {Map<RtxSSRC, PrimarySSRC>} - Map of {@link RtxSSRC}s and their
 *   corresponding {@link PrimarySSRC}s
 */
function getSSRCRtxPairs(section) {
  var rtxPairPattern = '^a=ssrc-group:FID ([0-9]+) ([0-9]+)$';
  return new Map(getMatches(section, rtxPairPattern).map(function (pair) {
    return pair.reverse();
  }));
}

/**
 * Create SSRC attribute tuples.
 * @param {string} section
 * @param {'planb' | 'unified'} sdpFormat
 * @returns {Array<[SSRC, MediaStreamID, Track.ID]>}
 */
function createSSRCAttributeTuples(section, sdpFormat) {
  return {
    planb: createPlanBSSRCAttributeTuples,
    unified: createUnifiedPlanSSRCAttributeTuples
  }[sdpFormat](section);
}

/**
 * Create "plan-b" SSRC attribute tuples.
 * @param {string} section
 * @returns {Array<[SSRC, MediaStreamID, Track.ID]>}
 */
function createPlanBSSRCAttributeTuples(section) {
  return getMatches(section, '^a=ssrc:([0-9]+) msid:([^\\s]+) ([^\\s]+)$');
}

/**
 * Create "unified-plan" SSRC attribute tuples.
 * @param {string} section
 * @returns {Array<[SSRC, MediaStreamID, Track.ID]>}
 */
function createUnifiedPlanSSRCAttributeTuples(section) {
  var _flatMap = flatMap(getMatches(section, '^a=msid:(.+) (.+)$')),
      _flatMap2 = _slicedToArray(_flatMap, 2),
      streamId = _flatMap2[0],
      trackId = _flatMap2[1];

  var ssrcs = flatMap(getMatches(section, '^a=ssrc:(.+) cname:.+$'));
  return ssrcs.map(function (ssrc) {
    return [ssrc, streamId, trackId];
  });
}

/**
 * Create a Map of MediaStreamTrack IDs and their {@link TrackAttributes}.
 * @param {string} section - SDP media section
 * @param {'planb' | 'unified'} sdpFormat
 * @returns {Map<Track.ID, TrackAttributes>}
 */
function createTrackIdsToAttributes(section, sdpFormat) {
  var simSSRCs = getSimulcastSSRCs(section);
  var rtxPairs = getSSRCRtxPairs(section);
  var ssrcAttrTuples = createSSRCAttributeTuples(section, sdpFormat);

  return ssrcAttrTuples.reduce(function (trackIdsToSSRCs, tuple) {
    var ssrc = tuple[0];
    var streamId = tuple[1];
    var trackId = tuple[2];

    var trackAttributes = trackIdsToSSRCs.get(trackId) || new TrackAttributes(trackId, streamId, getSSRCAttribute(section, ssrc, 'cname'));

    var primarySSRC = rtxPairs.get(ssrc) || null;
    trackAttributes.addSSRC(ssrc, primarySSRC, simSSRCs.has(ssrc));
    return trackIdsToSSRCs.set(trackId, trackAttributes);
  }, new Map());
}

/**
 * Apply simulcast settings to the given SDP media section.
 * @param {string} section - SDP media section
 * @param {'planb' | 'unified'} sdpFormat
 * @param {Map<Track.ID, TrackAttributes>} trackIdsToAttributes - Existing
 *   map which will be updated for new MediaStreamTrack IDs
 * @returns {string} - The transformed SDP media section
 */
function setSimulcastInMediaSection(section, sdpFormat, trackIdsToAttributes) {
  var newTrackIdsToAttributes = createTrackIdsToAttributes(section, sdpFormat);
  var newTrackIds = Array.from(newTrackIdsToAttributes.keys());
  var trackIds = Array.from(trackIdsToAttributes.keys());
  var trackIdsToAdd = difference(newTrackIds, trackIds);
  var trackIdsToIgnore = difference(trackIds, newTrackIds);

  // Update "trackIdsToAttributes" with TrackAttributes for new
  // MediaStreamTrack IDs.
  var trackAttributesToAdd = flatMap(trackIdsToAdd, function (trackId) {
    return newTrackIdsToAttributes.get(trackId);
  });
  trackAttributesToAdd.forEach(function (trackAttributes) {
    trackAttributes.addSimulcastSSRCs();
    trackIdsToAttributes.set(trackAttributes.trackId, trackAttributes);
  });

  // Get the SDP lines of the relevant MediaStreamTrack IDs from
  // "trackIdsToAttributes".
  trackIds = Array.from(trackIdsToAttributes.keys());
  var relevantTrackIds = difference(trackIds, trackIdsToIgnore);
  var relevantTrackAttributes = flatMap(relevantTrackIds, function (trackId) {
    return trackIdsToAttributes.get(trackId);
  });
  var excludeRtx = !section.match(/a=rtpmap:[0-9]+ rtx/);
  var relevantSdpLines = flatMap(relevantTrackAttributes, function (trackAttributes) {
    return trackAttributes.toSdpLines(excludeRtx);
  });

  // Add the simulcast SSRC SDP lines to the media section. The Set ensures
  // that the duplicates of the SSRC SDP lines that are in both "section" and
  // "relevantSdpLines" are removed.
  var sectionLines = flatMap(new Set(section.split('\r\n').concat(relevantSdpLines)));

  var xGoogleFlagConference = 'a=x-google-flag:conference';
  if (!section.match(xGoogleFlagConference)) {
    sectionLines.push(xGoogleFlagConference);
  }

  return sectionLines.join('\r\n');
}

/**
 * String representing a MediaStream ID.
 * @typedef {string} MediaStreamID
 */

/**
 * String representing the SSRC of a MediaStreamTrack.
 * @typedef {string} SSRC
 */

/**
 * Primary SSRC.
 * @typedef {SSRC} PrimarySSRC
 */

/**
 * Retransmission SSRC.
 * @typedef {SSRC} RtxSSRC
 */

/**
 * Simulcast SSRC.
 * @typedef {SSRC} SimSSRC
 */

module.exports = setSimulcastInMediaSection;
},{"../":114}],123:[function(require,module,exports){
'use strict';

/**
 * An {@link IdentityTrackMatcher} matches RTCTrackEvents with their respective
 * MediaStreamTrack IDs.
 */

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var IdentityTrackMatcher = function () {
  function IdentityTrackMatcher() {
    _classCallCheck(this, IdentityTrackMatcher);
  }

  _createClass(IdentityTrackMatcher, [{
    key: 'match',

    /**
    * Match a given MediaStreamTrack with its ID.
    * @param {RTCTrackEvent} event
    * @returns {Track.ID}
    */
    value: function match(event) {
      return event.track.id;
    }

    /**
    * Update the {@link IdentityTrackMatcher} with a new SDP.
    * @param {string} sdp
    */

  }, {
    key: 'update',
    value: function update() {}
  }]);

  return IdentityTrackMatcher;
}();

module.exports = IdentityTrackMatcher;
},{}],124:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var getMediaSections = require('../').getMediaSections;

/**
 * An {@link MIDTrackMatcher} matches an RTCTrackEvent with a MediaStreamTrack
 * ID based on the MID of the underlying RTCRtpTransceiver.
 */

var MIDTrackMatcher = function () {
  /**
   * Construct an {@link MIDTrackMatcher}.
   */
  function MIDTrackMatcher() {
    _classCallCheck(this, MIDTrackMatcher);

    Object.defineProperties(this, {
      _midsToTrackIds: {
        value: new Map(),
        writable: true
      }
    });
  }

  /**
   * Match a given MediaStreamTrack with its ID.
   * @param {RTCTrackEvent} event
   * @returns {?Track.ID}
   */


  _createClass(MIDTrackMatcher, [{
    key: 'match',
    value: function match(event) {
      return this._midsToTrackIds.get(event.transceiver.mid) || null;
    }

    /**
     * Update the {@link MIDTrackMatcher} with a new SDP.
     * @param {string} sdp
     */

  }, {
    key: 'update',
    value: function update(sdp) {
      var sections = getMediaSections(sdp, '(audio|video)');
      this._midsToTrackIds = sections.reduce(function (midsToTrackIds, section) {
        var midMatches = section.match(/^a=mid:(.+)$/m) || [];
        var trackIdMatches = section.match(/^a=msid:.+ (.+)$/m) || [];
        var mid = midMatches[1];
        var trackId = trackIdMatches[1];
        return mid && trackId ? midsToTrackIds.set(mid, trackId) : midsToTrackIds;
      }, this._midsToTrackIds);
    }
  }]);

  return MIDTrackMatcher;
}();

module.exports = MIDTrackMatcher;
},{"../":120}],125:[function(require,module,exports){
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var util = require('../../');
var getMediaSections = require('../').getMediaSections;

// NOTE(mroberts): OrderedTrackMatcher is meant to solve the problem identified in
//
//   https://bugs.webkit.org/show_bug.cgi?id=174519
//
// Namely that, without MIDs, we cannot "correctly" identify MediaStreamTracks
// in Safari's current WebRTC implementation. So, this module tries to hack
// around this by making a possibly dangerous assumption: "track" events will
// be raised for MediaStreamTracks of a particular kind in the same order that
// those kinds' MSIDs appear in the SDP. By calling `update` with an
// RTCPeerConnection's `remoteDescription` and then invoking `match`, we ought
// to be able to dequeue MediaStreamTrack IDs in the correct order to be
// assigned to "track" events.

/**
 * @interface MatchedAndUnmatched
 * @property {Set<Track.ID>} matched
 * @property {Set<Track.ID>} unmatched
 */

/**
 * Create a new instance of {@link MatchedAndUnmatched}.
 * @returns {MatchedAndUnmatched}
 */
function create() {
  return {
    matched: new Set(),
    unmatched: new Set()
  };
}

/**
 * Attempt to match a MediaStreamTrack ID.
 * @param {MatchedAndUnmatched} mAndM
 * @returns {?Track.ID} id
 */
function _match(mAndM) {
  var unmatched = Array.from(mAndM.unmatched);
  if (!unmatched.length) {
    return null;
  }
  var id = unmatched[0];
  mAndM.matched.add(id);
  mAndM.unmatched.delete(id);
  return id;
}

/**
 * Update a {@link MatchedAndUnmatched}'s MediaStreamTrack IDs.
 * @param {MatchedAndUnmatched} mAndM
 * @param {Set<Track.ID>} ids
 * @returns {void}
 */
function _update(mAndM, ids) {
  ids = new Set(ids);
  var removedMatchedIds = util.difference(mAndM.matched, ids);
  removedMatchedIds.forEach(mAndM.matched.delete, mAndM.matched);
  mAndM.unmatched = util.difference(ids, mAndM.matched);
}

/**
 * Parse MediaStreamTrack IDs of a particular kind from an SDP.
 * @param {string} kind
 * @param {string} sdp
 * @returns {Set<Track.ID>} ids
 */
function parse(kind, sdp) {
  var mediaSections = getMediaSections(sdp, kind);
  var pattern = 'msid: ?(.+) +(.+) ?$';
  return new Set(util.flatMap(mediaSections, function (mediaSection) {
    return mediaSection.match(new RegExp(pattern, 'mg')) || [];
  }).map(function (msid) {
    return msid.match(new RegExp(pattern))[2];
  }));
}

/**
 * A {@link OrderedTrackMatcher} is used to match RTCTrackEvents.
 * @property {MatchedAndUnmatched} audio
 * @property {MatchedAndUnmatched} video
 */

var OrderedTrackMatcher = function () {
  function OrderedTrackMatcher() {
    _classCallCheck(this, OrderedTrackMatcher);

    if (!(this instanceof OrderedTrackMatcher)) {
      return new OrderedTrackMatcher();
    }
    Object.defineProperties(this, {
      audio: {
        enumerable: true,
        value: create()
      },
      video: {
        enumerable: true,
        value: create()
      }
    });
  }

  /**
   * Attempt to match a new MediaStreamTrack ID.
   * @param {RTCTrackEvent} event
   * @returns {?Track.ID} id
   */


  _createClass(OrderedTrackMatcher, [{
    key: 'match',
    value: function match(event) {
      return _match(this[event.track.kind]);
    }

    /**
     * Update the {@link OrderedTrackMatcher} with a new SDP.
     * @param {string} sdp
     * @returns {void}
     */

  }, {
    key: 'update',
    value: function update(sdp) {
      ['audio', 'video'].forEach(function (kind) {
        _update(this[kind], parse(kind, sdp));
      }, this);
    }
  }]);

  return OrderedTrackMatcher;
}();

module.exports = OrderedTrackMatcher;
},{"../":120,"../../":114}],126:[function(require,module,exports){
/* globals chrome, navigator */
'use strict';

function _toArray(arr) { return Array.isArray(arr) ? arr : Array.from(arr); }

var _require = require('@twilio/webrtc/lib/util'),
    guessBrowser = _require.guessBrowser,
    isWebRTCSupported = _require.support;

var SUPPORTED_CHROME_BASED_BROWSERS = ['edg', 'edge', 'electron', 'headlesschrome'];

/**
 * Get the top level parenthesized substrings within a given string. Unmatched
 * parentheses are ignored.
 * Ex: "abc) (def) gh(ij) (kl (mn)o) (pqr" => ["(def)", "(ij)", "(kl (mn)o)"]
 * @param {string} string
 * @returns {string[]}
 */
function getParenthesizedSubstrings(string) {
  var openParenthesisPositions = [];
  var substrings = [];
  for (var i = 0; i < string.length; i++) {
    if (string[i] === '(') {
      openParenthesisPositions.push(i);
    } else if (string[i] === ')' && openParenthesisPositions.length > 0) {
      var openParenthesisPosition = openParenthesisPositions.pop();
      if (openParenthesisPositions.length === 0) {
        substrings.push(string.substring(openParenthesisPosition, i + 1));
      }
    }
  }
  return substrings;
}

/**
 * Check whether the current browser is non-Chromium Edge.
 * @param {string} browser
 * @returns {boolean}
 */
function isNonChromiumEdge(browser) {
  return browser === 'chrome' && /Edge/.test(navigator.userAgent) && (typeof chrome === 'undefined' || typeof chrome.runtime === 'undefined');
}

/**
 * Get the name of the rebranded Chromium browser, if any. Re-branded Chrome's user
 * agent has the following format:
 * <source>/<version> (<os>) <engine>/<version> (<engine_name>) Chrome/<version> [Mobile] Safari/<version>
 * @param browser
 * @returns {?string} Name of the rebranded Chrome browser, or null if the browser
 *   is either not Chrome or vanilla Chrome.
 */
function rebrandedChromeBrowser(browser) {
  // If the browser is not Chrome based, then it is not a rebranded Chrome browser.
  if (browser !== 'chrome') {
    return null;
  }

  // Latest desktop Brave browser has a "brave" property in navigator.
  if ('brave' in navigator) {
    return 'brave';
  }

  // Remove the "(.+)" entries from the user agent thereby retaining only the
  // <name>[/<version>] entries.
  var parenthesizedSubstrings = getParenthesizedSubstrings(navigator.userAgent);
  var nameAndVersions = parenthesizedSubstrings.reduce(function (userAgent, substring) {
    return userAgent.replace(substring, '');
  }, navigator.userAgent);

  // Extract the potential browser <name>s by ignoring the first two names, which
  // point to <source> and <engine>.
  var matches = nameAndVersions.match(/[^\s]+/g) || [];

  var _matches$map = matches.map(function (nameAndVersion) {
    return nameAndVersion.split('/')[0].toLowerCase();
  }),
      _matches$map2 = _toArray(_matches$map),
      browserNames = _matches$map2.slice(2);

  // Extract the <name> that is not expected to be present in the vanilla Chrome
  // browser, which indicates the rebranded name (ex: "edg[e]", "electron"). If null,
  // then this is a vanilla Chrome browser.


  return browserNames.find(function (name) {
    return !['chrome', 'mobile', 'safari'].includes(name);
  }) || null;
}

/**
 * Check if the current browser is officially supported by twilio-video.js.
 * @returns {boolean}
 */
function isSupported() {
  var browser = guessBrowser();
  var rebrandedChrome = rebrandedChromeBrowser(browser);
  return !!browser && isWebRTCSupported() && (!rebrandedChrome || SUPPORTED_CHROME_BASED_BROWSERS.includes(rebrandedChrome)) && !isNonChromiumEdge(browser);
}

module.exports = isSupported;
},{"@twilio/webrtc/lib/util":149}],127:[function(require,module,exports){
'use strict';

/**
 * A {@link Timeout} represents a resettable and clearable timeout.
 */

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Timeout = function () {
  /**
   * Construct a {@link Timeout}.
   * @param {function} fn - Function to call
   * @param {number} delay - Delay in milliseconds
   * @param {boolean} [autoStart=true] - If true, then start the {@link Timeout}.
   */
  function Timeout(fn, delay) {
    var autoStart = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

    _classCallCheck(this, Timeout);

    Object.defineProperties(this, {
      _delay: {
        value: delay,
        writable: true
      },
      _fn: {
        value: fn
      },
      _timeout: {
        value: null,
        writable: true
      }
    });

    if (autoStart) {
      this.start();
    }
  }

  /**
   * The {@link Timeout} delay in milliseconds.
   * @property {number}
   */


  _createClass(Timeout, [{
    key: 'setDelay',


    /**
     * Update the {@link Timeout} delay.
     * @param {number} delay
     * @returns {void}
     */
    value: function setDelay(delay) {
      this._delay = delay;
    }

    /**
     * Start the {@link Timeout}, if not already started.
     * @returns {void}
     */

  }, {
    key: 'start',
    value: function start() {
      var _this = this;

      if (!this.isSet) {
        this._timeout = setTimeout(function () {
          var fn = _this._fn;
          _this.clear();
          fn();
        }, this._delay);
      }
    }

    /**
     * Clear the {@link Timeout}.
     * @returns {void}
     */

  }, {
    key: 'clear',
    value: function clear() {
      clearTimeout(this._timeout);
      this._timeout = null;
    }

    /**
     * Reset the {@link Timeout}.
     * @returns {void}
     */

  }, {
    key: 'reset',
    value: function reset() {
      this.clear();
      this.start();
    }
  }, {
    key: 'delay',
    get: function get() {
      return this._delay;
    }

    /**
     * Whether the {@link Timeout} is set.
     * @property {boolean}
     */

  }, {
    key: 'isSet',
    get: function get() {
      return !!this._timeout;
    }
  }]);

  return Timeout;
}();

module.exports = Timeout;
},{}],128:[function(require,module,exports){
// NOTE: Do not edit this file. This code is auto-generated. Contact the
// Twilio SDK Team for more information.

'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TwilioError = require('./twilioerror');
var TwilioErrorByCode = {};

/**
 * Create a {@link TwilioError} for a given code and message.
 * @private
 * @param {number} [code] - Error code
 * @param {string} [message] - Error message
 * @returns {TwilioError}
 */
exports.createTwilioError = function createTwilioError(code, message) {
  code = typeof code === 'number' ? code : 0;
  message = typeof message === 'string' && message ? message : 'Unknown error';
  return TwilioErrorByCode[code] ? new TwilioErrorByCode[code]() : new TwilioError(code, message);
};

/**
 * @class AccessTokenInvalidError
 * @classdesc Raised whenever the AccessToken used for connecting to a Room is invalid.
 * @extends TwilioError
 * @property {number} code - 20101
 * @property {string} message - 'Invalid Access Token'
 */

var AccessTokenInvalidError = function (_TwilioError) {
  _inherits(AccessTokenInvalidError, _TwilioError);

  function AccessTokenInvalidError() {
    _classCallCheck(this, AccessTokenInvalidError);

    return _possibleConstructorReturn(this, (AccessTokenInvalidError.__proto__ || Object.getPrototypeOf(AccessTokenInvalidError)).call(this, 20101, 'Invalid Access Token'));
  }

  return AccessTokenInvalidError;
}(TwilioError);

exports.AccessTokenInvalidError = AccessTokenInvalidError;
Object.defineProperty(TwilioErrorByCode, 20101, { value: AccessTokenInvalidError });

/**
 * @class AccessTokenHeaderInvalidError
 * @classdesc Raised whenever the AccessToken used for connecting to a Room has an invalid header.
 * @extends TwilioError
 * @property {number} code - 20102
 * @property {string} message - 'Invalid Access Token header'
 */

var AccessTokenHeaderInvalidError = function (_TwilioError2) {
  _inherits(AccessTokenHeaderInvalidError, _TwilioError2);

  function AccessTokenHeaderInvalidError() {
    _classCallCheck(this, AccessTokenHeaderInvalidError);

    return _possibleConstructorReturn(this, (AccessTokenHeaderInvalidError.__proto__ || Object.getPrototypeOf(AccessTokenHeaderInvalidError)).call(this, 20102, 'Invalid Access Token header'));
  }

  return AccessTokenHeaderInvalidError;
}(TwilioError);

exports.AccessTokenHeaderInvalidError = AccessTokenHeaderInvalidError;
Object.defineProperty(TwilioErrorByCode, 20102, { value: AccessTokenHeaderInvalidError });

/**
 * @class AccessTokenIssuerInvalidError
 * @classdesc Raised whenever the AccessToken used for connecting to a Room contains an invalid issuer or subject.
 * @extends TwilioError
 * @property {number} code - 20103
 * @property {string} message - 'Invalid Access Token issuer/subject'
 */

var AccessTokenIssuerInvalidError = function (_TwilioError3) {
  _inherits(AccessTokenIssuerInvalidError, _TwilioError3);

  function AccessTokenIssuerInvalidError() {
    _classCallCheck(this, AccessTokenIssuerInvalidError);

    return _possibleConstructorReturn(this, (AccessTokenIssuerInvalidError.__proto__ || Object.getPrototypeOf(AccessTokenIssuerInvalidError)).call(this, 20103, 'Invalid Access Token issuer/subject'));
  }

  return AccessTokenIssuerInvalidError;
}(TwilioError);

exports.AccessTokenIssuerInvalidError = AccessTokenIssuerInvalidError;
Object.defineProperty(TwilioErrorByCode, 20103, { value: AccessTokenIssuerInvalidError });

/**
 * @class AccessTokenExpiredError
 * @classdesc Raised whenever the AccessToken used for connecting, or reconnecting to a Room has expired.
 * @extends TwilioError
 * @property {number} code - 20104
 * @property {string} message - 'Access Token expired or expiration date invalid'
 */

var AccessTokenExpiredError = function (_TwilioError4) {
  _inherits(AccessTokenExpiredError, _TwilioError4);

  function AccessTokenExpiredError() {
    _classCallCheck(this, AccessTokenExpiredError);

    return _possibleConstructorReturn(this, (AccessTokenExpiredError.__proto__ || Object.getPrototypeOf(AccessTokenExpiredError)).call(this, 20104, 'Access Token expired or expiration date invalid'));
  }

  return AccessTokenExpiredError;
}(TwilioError);

exports.AccessTokenExpiredError = AccessTokenExpiredError;
Object.defineProperty(TwilioErrorByCode, 20104, { value: AccessTokenExpiredError });

/**
 * @class AccessTokenNotYetValidError
 * @classdesc Raised whenever the AccessToken used for connecting to a Room is not yet valid.
 * @extends TwilioError
 * @property {number} code - 20105
 * @property {string} message - 'Access Token not yet valid'
 */

var AccessTokenNotYetValidError = function (_TwilioError5) {
  _inherits(AccessTokenNotYetValidError, _TwilioError5);

  function AccessTokenNotYetValidError() {
    _classCallCheck(this, AccessTokenNotYetValidError);

    return _possibleConstructorReturn(this, (AccessTokenNotYetValidError.__proto__ || Object.getPrototypeOf(AccessTokenNotYetValidError)).call(this, 20105, 'Access Token not yet valid'));
  }

  return AccessTokenNotYetValidError;
}(TwilioError);

exports.AccessTokenNotYetValidError = AccessTokenNotYetValidError;
Object.defineProperty(TwilioErrorByCode, 20105, { value: AccessTokenNotYetValidError });

/**
 * @class AccessTokenGrantsInvalidError
 * @classdesc Raised whenever the AccessToken used for connecting to a Room has invalid grants.
 * @extends TwilioError
 * @property {number} code - 20106
 * @property {string} message - 'Invalid Access Token grants'
 */

var AccessTokenGrantsInvalidError = function (_TwilioError6) {
  _inherits(AccessTokenGrantsInvalidError, _TwilioError6);

  function AccessTokenGrantsInvalidError() {
    _classCallCheck(this, AccessTokenGrantsInvalidError);

    return _possibleConstructorReturn(this, (AccessTokenGrantsInvalidError.__proto__ || Object.getPrototypeOf(AccessTokenGrantsInvalidError)).call(this, 20106, 'Invalid Access Token grants'));
  }

  return AccessTokenGrantsInvalidError;
}(TwilioError);

exports.AccessTokenGrantsInvalidError = AccessTokenGrantsInvalidError;
Object.defineProperty(TwilioErrorByCode, 20106, { value: AccessTokenGrantsInvalidError });

/**
 * @class AccessTokenSignatureInvalidError
 * @classdesc Raised whenever the AccessToken used for connecting to a Room has an invalid signature.
 * @extends TwilioError
 * @property {number} code - 20107
 * @property {string} message - 'Invalid Access Token signature'
 */

var AccessTokenSignatureInvalidError = function (_TwilioError7) {
  _inherits(AccessTokenSignatureInvalidError, _TwilioError7);

  function AccessTokenSignatureInvalidError() {
    _classCallCheck(this, AccessTokenSignatureInvalidError);

    return _possibleConstructorReturn(this, (AccessTokenSignatureInvalidError.__proto__ || Object.getPrototypeOf(AccessTokenSignatureInvalidError)).call(this, 20107, 'Invalid Access Token signature'));
  }

  return AccessTokenSignatureInvalidError;
}(TwilioError);

exports.AccessTokenSignatureInvalidError = AccessTokenSignatureInvalidError;
Object.defineProperty(TwilioErrorByCode, 20107, { value: AccessTokenSignatureInvalidError });

/**
 * @class SignalingConnectionError
 * @classdesc Raised whenever a signaling connection error occurs that is not covered by a more specific error code.
 * @extends TwilioError
 * @property {number} code - 53000
 * @property {string} message - 'Signaling connection error'
 */

var SignalingConnectionError = function (_TwilioError8) {
  _inherits(SignalingConnectionError, _TwilioError8);

  function SignalingConnectionError() {
    _classCallCheck(this, SignalingConnectionError);

    return _possibleConstructorReturn(this, (SignalingConnectionError.__proto__ || Object.getPrototypeOf(SignalingConnectionError)).call(this, 53000, 'Signaling connection error'));
  }

  return SignalingConnectionError;
}(TwilioError);

exports.SignalingConnectionError = SignalingConnectionError;
Object.defineProperty(TwilioErrorByCode, 53000, { value: SignalingConnectionError });

/**
 * @class SignalingConnectionDisconnectedError
 * @classdesc Raised whenever the signaling connection is unexpectedly disconnected.
 * @extends TwilioError
 * @property {number} code - 53001
 * @property {string} message - 'Signaling connection disconnected'
 */

var SignalingConnectionDisconnectedError = function (_TwilioError9) {
  _inherits(SignalingConnectionDisconnectedError, _TwilioError9);

  function SignalingConnectionDisconnectedError() {
    _classCallCheck(this, SignalingConnectionDisconnectedError);

    return _possibleConstructorReturn(this, (SignalingConnectionDisconnectedError.__proto__ || Object.getPrototypeOf(SignalingConnectionDisconnectedError)).call(this, 53001, 'Signaling connection disconnected'));
  }

  return SignalingConnectionDisconnectedError;
}(TwilioError);

exports.SignalingConnectionDisconnectedError = SignalingConnectionDisconnectedError;
Object.defineProperty(TwilioErrorByCode, 53001, { value: SignalingConnectionDisconnectedError });

/**
 * @class SignalingConnectionTimeoutError
 * @classdesc Raised when connection liveliness checks fail, or when the signaling session expires.
 * @extends TwilioError
 * @property {number} code - 53002
 * @property {string} message - 'Signaling connection timed out'
 */

var SignalingConnectionTimeoutError = function (_TwilioError10) {
  _inherits(SignalingConnectionTimeoutError, _TwilioError10);

  function SignalingConnectionTimeoutError() {
    _classCallCheck(this, SignalingConnectionTimeoutError);

    return _possibleConstructorReturn(this, (SignalingConnectionTimeoutError.__proto__ || Object.getPrototypeOf(SignalingConnectionTimeoutError)).call(this, 53002, 'Signaling connection timed out'));
  }

  return SignalingConnectionTimeoutError;
}(TwilioError);

exports.SignalingConnectionTimeoutError = SignalingConnectionTimeoutError;
Object.defineProperty(TwilioErrorByCode, 53002, { value: SignalingConnectionTimeoutError });

/**
 * @class SignalingIncomingMessageInvalidError
 * @classdesc Raised whenever the Client receives a message from the Server that the Client cannot handle.
 * @extends TwilioError
 * @property {number} code - 53003
 * @property {string} message - 'Client received an invalid signaling message'
 */

var SignalingIncomingMessageInvalidError = function (_TwilioError11) {
  _inherits(SignalingIncomingMessageInvalidError, _TwilioError11);

  function SignalingIncomingMessageInvalidError() {
    _classCallCheck(this, SignalingIncomingMessageInvalidError);

    return _possibleConstructorReturn(this, (SignalingIncomingMessageInvalidError.__proto__ || Object.getPrototypeOf(SignalingIncomingMessageInvalidError)).call(this, 53003, 'Client received an invalid signaling message'));
  }

  return SignalingIncomingMessageInvalidError;
}(TwilioError);

exports.SignalingIncomingMessageInvalidError = SignalingIncomingMessageInvalidError;
Object.defineProperty(TwilioErrorByCode, 53003, { value: SignalingIncomingMessageInvalidError });

/**
 * @class SignalingOutgoingMessageInvalidError
 * @classdesc Raised whenever the Client sends a message to the Server that the Server cannot handle.
 * @extends TwilioError
 * @property {number} code - 53004
 * @property {string} message - 'Client sent an invalid signaling message'
 */

var SignalingOutgoingMessageInvalidError = function (_TwilioError12) {
  _inherits(SignalingOutgoingMessageInvalidError, _TwilioError12);

  function SignalingOutgoingMessageInvalidError() {
    _classCallCheck(this, SignalingOutgoingMessageInvalidError);

    return _possibleConstructorReturn(this, (SignalingOutgoingMessageInvalidError.__proto__ || Object.getPrototypeOf(SignalingOutgoingMessageInvalidError)).call(this, 53004, 'Client sent an invalid signaling message'));
  }

  return SignalingOutgoingMessageInvalidError;
}(TwilioError);

exports.SignalingOutgoingMessageInvalidError = SignalingOutgoingMessageInvalidError;
Object.defineProperty(TwilioErrorByCode, 53004, { value: SignalingOutgoingMessageInvalidError });

/**
 * @class SignalingServerBusyError
 * @classdesc Raised when the server is too busy to accept new clients.
 * @extends TwilioError
 * @property {number} code - 53006
 * @property {string} message - 'Video server is busy'
 */

var SignalingServerBusyError = function (_TwilioError13) {
  _inherits(SignalingServerBusyError, _TwilioError13);

  function SignalingServerBusyError() {
    _classCallCheck(this, SignalingServerBusyError);

    return _possibleConstructorReturn(this, (SignalingServerBusyError.__proto__ || Object.getPrototypeOf(SignalingServerBusyError)).call(this, 53006, 'Video server is busy'));
  }

  return SignalingServerBusyError;
}(TwilioError);

exports.SignalingServerBusyError = SignalingServerBusyError;
Object.defineProperty(TwilioErrorByCode, 53006, { value: SignalingServerBusyError });

/**
 * @class RoomNameInvalidError
 * @classdesc Raised whenever a Room name is invalid, and the scenario is not covered by a more specific error code.
 * @extends TwilioError
 * @property {number} code - 53100
 * @property {string} message - 'Room name is invalid'
 */

var RoomNameInvalidError = function (_TwilioError14) {
  _inherits(RoomNameInvalidError, _TwilioError14);

  function RoomNameInvalidError() {
    _classCallCheck(this, RoomNameInvalidError);

    return _possibleConstructorReturn(this, (RoomNameInvalidError.__proto__ || Object.getPrototypeOf(RoomNameInvalidError)).call(this, 53100, 'Room name is invalid'));
  }

  return RoomNameInvalidError;
}(TwilioError);

exports.RoomNameInvalidError = RoomNameInvalidError;
Object.defineProperty(TwilioErrorByCode, 53100, { value: RoomNameInvalidError });

/**
 * @class RoomNameTooLongError
 * @classdesc Raised whenever a Room name is too long.
 * @extends TwilioError
 * @property {number} code - 53101
 * @property {string} message - 'Room name is too long'
 */

var RoomNameTooLongError = function (_TwilioError15) {
  _inherits(RoomNameTooLongError, _TwilioError15);

  function RoomNameTooLongError() {
    _classCallCheck(this, RoomNameTooLongError);

    return _possibleConstructorReturn(this, (RoomNameTooLongError.__proto__ || Object.getPrototypeOf(RoomNameTooLongError)).call(this, 53101, 'Room name is too long'));
  }

  return RoomNameTooLongError;
}(TwilioError);

exports.RoomNameTooLongError = RoomNameTooLongError;
Object.defineProperty(TwilioErrorByCode, 53101, { value: RoomNameTooLongError });

/**
 * @class RoomNameCharsInvalidError
 * @classdesc Raised whenever a Room name contains invalid characters.
 * @extends TwilioError
 * @property {number} code - 53102
 * @property {string} message - 'Room name contains invalid characters'
 */

var RoomNameCharsInvalidError = function (_TwilioError16) {
  _inherits(RoomNameCharsInvalidError, _TwilioError16);

  function RoomNameCharsInvalidError() {
    _classCallCheck(this, RoomNameCharsInvalidError);

    return _possibleConstructorReturn(this, (RoomNameCharsInvalidError.__proto__ || Object.getPrototypeOf(RoomNameCharsInvalidError)).call(this, 53102, 'Room name contains invalid characters'));
  }

  return RoomNameCharsInvalidError;
}(TwilioError);

exports.RoomNameCharsInvalidError = RoomNameCharsInvalidError;
Object.defineProperty(TwilioErrorByCode, 53102, { value: RoomNameCharsInvalidError });

/**
 * @class RoomCreateFailedError
 * @classdesc Raised whenever the Server is unable to create a Room.
 * @extends TwilioError
 * @property {number} code - 53103
 * @property {string} message - 'Unable to create Room'
 */

var RoomCreateFailedError = function (_TwilioError17) {
  _inherits(RoomCreateFailedError, _TwilioError17);

  function RoomCreateFailedError() {
    _classCallCheck(this, RoomCreateFailedError);

    return _possibleConstructorReturn(this, (RoomCreateFailedError.__proto__ || Object.getPrototypeOf(RoomCreateFailedError)).call(this, 53103, 'Unable to create Room'));
  }

  return RoomCreateFailedError;
}(TwilioError);

exports.RoomCreateFailedError = RoomCreateFailedError;
Object.defineProperty(TwilioErrorByCode, 53103, { value: RoomCreateFailedError });

/**
 * @class RoomConnectFailedError
 * @classdesc Raised whenever a Client is unable to connect to a Room, and the scenario is not covered by a more specific error code.
 * @extends TwilioError
 * @property {number} code - 53104
 * @property {string} message - 'Unable to connect to Room'
 */

var RoomConnectFailedError = function (_TwilioError18) {
  _inherits(RoomConnectFailedError, _TwilioError18);

  function RoomConnectFailedError() {
    _classCallCheck(this, RoomConnectFailedError);

    return _possibleConstructorReturn(this, (RoomConnectFailedError.__proto__ || Object.getPrototypeOf(RoomConnectFailedError)).call(this, 53104, 'Unable to connect to Room'));
  }

  return RoomConnectFailedError;
}(TwilioError);

exports.RoomConnectFailedError = RoomConnectFailedError;
Object.defineProperty(TwilioErrorByCode, 53104, { value: RoomConnectFailedError });

/**
 * @class RoomMaxParticipantsExceededError
 * @classdesc Raised whenever a Client is unable to connect to a Room because the Room contains too many Participants.
 * @extends TwilioError
 * @property {number} code - 53105
 * @property {string} message - 'Room contains too many Participants'
 */

var RoomMaxParticipantsExceededError = function (_TwilioError19) {
  _inherits(RoomMaxParticipantsExceededError, _TwilioError19);

  function RoomMaxParticipantsExceededError() {
    _classCallCheck(this, RoomMaxParticipantsExceededError);

    return _possibleConstructorReturn(this, (RoomMaxParticipantsExceededError.__proto__ || Object.getPrototypeOf(RoomMaxParticipantsExceededError)).call(this, 53105, 'Room contains too many Participants'));
  }

  return RoomMaxParticipantsExceededError;
}(TwilioError);

exports.RoomMaxParticipantsExceededError = RoomMaxParticipantsExceededError;
Object.defineProperty(TwilioErrorByCode, 53105, { value: RoomMaxParticipantsExceededError });

/**
 * @class RoomNotFoundError
 * @classdesc Raised whenever attempting operation on a non-existent Room.
 * @extends TwilioError
 * @property {number} code - 53106
 * @property {string} message - 'Room not found'
 */

var RoomNotFoundError = function (_TwilioError20) {
  _inherits(RoomNotFoundError, _TwilioError20);

  function RoomNotFoundError() {
    _classCallCheck(this, RoomNotFoundError);

    return _possibleConstructorReturn(this, (RoomNotFoundError.__proto__ || Object.getPrototypeOf(RoomNotFoundError)).call(this, 53106, 'Room not found'));
  }

  return RoomNotFoundError;
}(TwilioError);

exports.RoomNotFoundError = RoomNotFoundError;
Object.defineProperty(TwilioErrorByCode, 53106, { value: RoomNotFoundError });

/**
 * @class RoomMaxParticipantsOutOfRangeError
 * @classdesc Raised in the REST API when MaxParticipants is set out of range.
 * @extends TwilioError
 * @property {number} code - 53107
 * @property {string} message - 'MaxParticipants is out of range'
 */

var RoomMaxParticipantsOutOfRangeError = function (_TwilioError21) {
  _inherits(RoomMaxParticipantsOutOfRangeError, _TwilioError21);

  function RoomMaxParticipantsOutOfRangeError() {
    _classCallCheck(this, RoomMaxParticipantsOutOfRangeError);

    return _possibleConstructorReturn(this, (RoomMaxParticipantsOutOfRangeError.__proto__ || Object.getPrototypeOf(RoomMaxParticipantsOutOfRangeError)).call(this, 53107, 'MaxParticipants is out of range'));
  }

  return RoomMaxParticipantsOutOfRangeError;
}(TwilioError);

exports.RoomMaxParticipantsOutOfRangeError = RoomMaxParticipantsOutOfRangeError;
Object.defineProperty(TwilioErrorByCode, 53107, { value: RoomMaxParticipantsOutOfRangeError });

/**
 * @class RoomTypeInvalidError
 * @classdesc Raised in the REST API when the user attempts to create a Room with an invalid RoomType
 * @extends TwilioError
 * @property {number} code - 53108
 * @property {string} message - 'RoomType is not valid'
 */

var RoomTypeInvalidError = function (_TwilioError22) {
  _inherits(RoomTypeInvalidError, _TwilioError22);

  function RoomTypeInvalidError() {
    _classCallCheck(this, RoomTypeInvalidError);

    return _possibleConstructorReturn(this, (RoomTypeInvalidError.__proto__ || Object.getPrototypeOf(RoomTypeInvalidError)).call(this, 53108, 'RoomType is not valid'));
  }

  return RoomTypeInvalidError;
}(TwilioError);

exports.RoomTypeInvalidError = RoomTypeInvalidError;
Object.defineProperty(TwilioErrorByCode, 53108, { value: RoomTypeInvalidError });

/**
 * @class RoomTimeoutOutOfRangeError
 * @classdesc Raised in the REST API when Timeout is set out of range.
 * @extends TwilioError
 * @property {number} code - 53109
 * @property {string} message - 'Timeout is out of range'
 */

var RoomTimeoutOutOfRangeError = function (_TwilioError23) {
  _inherits(RoomTimeoutOutOfRangeError, _TwilioError23);

  function RoomTimeoutOutOfRangeError() {
    _classCallCheck(this, RoomTimeoutOutOfRangeError);

    return _possibleConstructorReturn(this, (RoomTimeoutOutOfRangeError.__proto__ || Object.getPrototypeOf(RoomTimeoutOutOfRangeError)).call(this, 53109, 'Timeout is out of range'));
  }

  return RoomTimeoutOutOfRangeError;
}(TwilioError);

exports.RoomTimeoutOutOfRangeError = RoomTimeoutOutOfRangeError;
Object.defineProperty(TwilioErrorByCode, 53109, { value: RoomTimeoutOutOfRangeError });

/**
 * @class RoomStatusCallbackMethodInvalidError
 * @classdesc Raised in the REST API when StatusCallbackMethod is set to an invalid value.
 * @extends TwilioError
 * @property {number} code - 53110
 * @property {string} message - 'StatusCallbackMethod is invalid'
 */

var RoomStatusCallbackMethodInvalidError = function (_TwilioError24) {
  _inherits(RoomStatusCallbackMethodInvalidError, _TwilioError24);

  function RoomStatusCallbackMethodInvalidError() {
    _classCallCheck(this, RoomStatusCallbackMethodInvalidError);

    return _possibleConstructorReturn(this, (RoomStatusCallbackMethodInvalidError.__proto__ || Object.getPrototypeOf(RoomStatusCallbackMethodInvalidError)).call(this, 53110, 'StatusCallbackMethod is invalid'));
  }

  return RoomStatusCallbackMethodInvalidError;
}(TwilioError);

exports.RoomStatusCallbackMethodInvalidError = RoomStatusCallbackMethodInvalidError;
Object.defineProperty(TwilioErrorByCode, 53110, { value: RoomStatusCallbackMethodInvalidError });

/**
 * @class RoomStatusCallbackInvalidError
 * @classdesc Raised in the REST API when StatusCallback is not a valid URL or the url is too long.
 * @extends TwilioError
 * @property {number} code - 53111
 * @property {string} message - 'StatusCallback is invalid'
 */

var RoomStatusCallbackInvalidError = function (_TwilioError25) {
  _inherits(RoomStatusCallbackInvalidError, _TwilioError25);

  function RoomStatusCallbackInvalidError() {
    _classCallCheck(this, RoomStatusCallbackInvalidError);

    return _possibleConstructorReturn(this, (RoomStatusCallbackInvalidError.__proto__ || Object.getPrototypeOf(RoomStatusCallbackInvalidError)).call(this, 53111, 'StatusCallback is invalid'));
  }

  return RoomStatusCallbackInvalidError;
}(TwilioError);

exports.RoomStatusCallbackInvalidError = RoomStatusCallbackInvalidError;
Object.defineProperty(TwilioErrorByCode, 53111, { value: RoomStatusCallbackInvalidError });

/**
 * @class RoomStatusInvalidError
 * @classdesc Raised in the REST API when Status is not valid or the Room is not in-progress.
 * @extends TwilioError
 * @property {number} code - 53112
 * @property {string} message - 'Status is invalid'
 */

var RoomStatusInvalidError = function (_TwilioError26) {
  _inherits(RoomStatusInvalidError, _TwilioError26);

  function RoomStatusInvalidError() {
    _classCallCheck(this, RoomStatusInvalidError);

    return _possibleConstructorReturn(this, (RoomStatusInvalidError.__proto__ || Object.getPrototypeOf(RoomStatusInvalidError)).call(this, 53112, 'Status is invalid'));
  }

  return RoomStatusInvalidError;
}(TwilioError);

exports.RoomStatusInvalidError = RoomStatusInvalidError;
Object.defineProperty(TwilioErrorByCode, 53112, { value: RoomStatusInvalidError });

/**
 * @class RoomRoomExistsError
 * @classdesc Raised in the REST API when the Room creation fails because a Room exists with the same name.
 * @extends TwilioError
 * @property {number} code - 53113
 * @property {string} message - 'Room exists'
 */

var RoomRoomExistsError = function (_TwilioError27) {
  _inherits(RoomRoomExistsError, _TwilioError27);

  function RoomRoomExistsError() {
    _classCallCheck(this, RoomRoomExistsError);

    return _possibleConstructorReturn(this, (RoomRoomExistsError.__proto__ || Object.getPrototypeOf(RoomRoomExistsError)).call(this, 53113, 'Room exists'));
  }

  return RoomRoomExistsError;
}(TwilioError);

exports.RoomRoomExistsError = RoomRoomExistsError;
Object.defineProperty(TwilioErrorByCode, 53113, { value: RoomRoomExistsError });

/**
 * @class RoomInvalidParametersError
 * @classdesc Raised in the REST API when one or more Room creation parameter is incompatible with the Room type.
 * @extends TwilioError
 * @property {number} code - 53114
 * @property {string} message - 'Room creation parameter(s) incompatible with the Room type'
 */

var RoomInvalidParametersError = function (_TwilioError28) {
  _inherits(RoomInvalidParametersError, _TwilioError28);

  function RoomInvalidParametersError() {
    _classCallCheck(this, RoomInvalidParametersError);

    return _possibleConstructorReturn(this, (RoomInvalidParametersError.__proto__ || Object.getPrototypeOf(RoomInvalidParametersError)).call(this, 53114, 'Room creation parameter(s) incompatible with the Room type'));
  }

  return RoomInvalidParametersError;
}(TwilioError);

exports.RoomInvalidParametersError = RoomInvalidParametersError;
Object.defineProperty(TwilioErrorByCode, 53114, { value: RoomInvalidParametersError });

/**
 * @class RoomMediaRegionInvalidError
 * @classdesc Raised in the REST API when MediaRegion is set to an invalid value.
 * @extends TwilioError
 * @property {number} code - 53115
 * @property {string} message - 'MediaRegion is invalid'
 */

var RoomMediaRegionInvalidError = function (_TwilioError29) {
  _inherits(RoomMediaRegionInvalidError, _TwilioError29);

  function RoomMediaRegionInvalidError() {
    _classCallCheck(this, RoomMediaRegionInvalidError);

    return _possibleConstructorReturn(this, (RoomMediaRegionInvalidError.__proto__ || Object.getPrototypeOf(RoomMediaRegionInvalidError)).call(this, 53115, 'MediaRegion is invalid'));
  }

  return RoomMediaRegionInvalidError;
}(TwilioError);

exports.RoomMediaRegionInvalidError = RoomMediaRegionInvalidError;
Object.defineProperty(TwilioErrorByCode, 53115, { value: RoomMediaRegionInvalidError });

/**
 * @class RoomMediaRegionUnavailableError
 * @classdesc Raised in the REST API when MediaRegion is set to a valid value but no media servers are available.
 * @extends TwilioError
 * @property {number} code - 53116
 * @property {string} message - 'There are no media servers available in the MediaRegion'
 */

var RoomMediaRegionUnavailableError = function (_TwilioError30) {
  _inherits(RoomMediaRegionUnavailableError, _TwilioError30);

  function RoomMediaRegionUnavailableError() {
    _classCallCheck(this, RoomMediaRegionUnavailableError);

    return _possibleConstructorReturn(this, (RoomMediaRegionUnavailableError.__proto__ || Object.getPrototypeOf(RoomMediaRegionUnavailableError)).call(this, 53116, 'There are no media servers available in the MediaRegion'));
  }

  return RoomMediaRegionUnavailableError;
}(TwilioError);

exports.RoomMediaRegionUnavailableError = RoomMediaRegionUnavailableError;
Object.defineProperty(TwilioErrorByCode, 53116, { value: RoomMediaRegionUnavailableError });

/**
 * @class RoomSubscriptionOperationNotSupportedError
 * @classdesc Raised whenever the subscription operation requested is not supported for the Room type.
 * @extends TwilioError
 * @property {number} code - 53117
 * @property {string} message - 'The subscription operation requested is not supported for the Room type'
 */

var RoomSubscriptionOperationNotSupportedError = function (_TwilioError31) {
  _inherits(RoomSubscriptionOperationNotSupportedError, _TwilioError31);

  function RoomSubscriptionOperationNotSupportedError() {
    _classCallCheck(this, RoomSubscriptionOperationNotSupportedError);

    return _possibleConstructorReturn(this, (RoomSubscriptionOperationNotSupportedError.__proto__ || Object.getPrototypeOf(RoomSubscriptionOperationNotSupportedError)).call(this, 53117, 'The subscription operation requested is not supported for the Room type'));
  }

  return RoomSubscriptionOperationNotSupportedError;
}(TwilioError);

exports.RoomSubscriptionOperationNotSupportedError = RoomSubscriptionOperationNotSupportedError;
Object.defineProperty(TwilioErrorByCode, 53117, { value: RoomSubscriptionOperationNotSupportedError });

/**
 * @class RoomCompletedError
 * @classdesc Raised whenever a Room is completed via the REST API.
 * @extends TwilioError
 * @property {number} code - 53118
 * @property {string} message - 'Room completed'
 */

var RoomCompletedError = function (_TwilioError32) {
  _inherits(RoomCompletedError, _TwilioError32);

  function RoomCompletedError() {
    _classCallCheck(this, RoomCompletedError);

    return _possibleConstructorReturn(this, (RoomCompletedError.__proto__ || Object.getPrototypeOf(RoomCompletedError)).call(this, 53118, 'Room completed'));
  }

  return RoomCompletedError;
}(TwilioError);

exports.RoomCompletedError = RoomCompletedError;
Object.defineProperty(TwilioErrorByCode, 53118, { value: RoomCompletedError });

/**
 * @class ParticipantIdentityInvalidError
 * @classdesc Raised whenever a Participant identity is invalid, and the scenario is not covered by a more specific error code.
 * @extends TwilioError
 * @property {number} code - 53200
 * @property {string} message - 'Participant identity is invalid'
 */

var ParticipantIdentityInvalidError = function (_TwilioError33) {
  _inherits(ParticipantIdentityInvalidError, _TwilioError33);

  function ParticipantIdentityInvalidError() {
    _classCallCheck(this, ParticipantIdentityInvalidError);

    return _possibleConstructorReturn(this, (ParticipantIdentityInvalidError.__proto__ || Object.getPrototypeOf(ParticipantIdentityInvalidError)).call(this, 53200, 'Participant identity is invalid'));
  }

  return ParticipantIdentityInvalidError;
}(TwilioError);

exports.ParticipantIdentityInvalidError = ParticipantIdentityInvalidError;
Object.defineProperty(TwilioErrorByCode, 53200, { value: ParticipantIdentityInvalidError });

/**
 * @class ParticipantIdentityTooLongError
 * @classdesc Raised whenever a Participant identity is too long.
 * @extends TwilioError
 * @property {number} code - 53201
 * @property {string} message - 'Participant identity is too long'
 */

var ParticipantIdentityTooLongError = function (_TwilioError34) {
  _inherits(ParticipantIdentityTooLongError, _TwilioError34);

  function ParticipantIdentityTooLongError() {
    _classCallCheck(this, ParticipantIdentityTooLongError);

    return _possibleConstructorReturn(this, (ParticipantIdentityTooLongError.__proto__ || Object.getPrototypeOf(ParticipantIdentityTooLongError)).call(this, 53201, 'Participant identity is too long'));
  }

  return ParticipantIdentityTooLongError;
}(TwilioError);

exports.ParticipantIdentityTooLongError = ParticipantIdentityTooLongError;
Object.defineProperty(TwilioErrorByCode, 53201, { value: ParticipantIdentityTooLongError });

/**
 * @class ParticipantIdentityCharsInvalidError
 * @classdesc Raised whenever a Participant identity contains invalid characters.
 * @extends TwilioError
 * @property {number} code - 53202
 * @property {string} message - 'Participant identity contains invalid characters'
 */

var ParticipantIdentityCharsInvalidError = function (_TwilioError35) {
  _inherits(ParticipantIdentityCharsInvalidError, _TwilioError35);

  function ParticipantIdentityCharsInvalidError() {
    _classCallCheck(this, ParticipantIdentityCharsInvalidError);

    return _possibleConstructorReturn(this, (ParticipantIdentityCharsInvalidError.__proto__ || Object.getPrototypeOf(ParticipantIdentityCharsInvalidError)).call(this, 53202, 'Participant identity contains invalid characters'));
  }

  return ParticipantIdentityCharsInvalidError;
}(TwilioError);

exports.ParticipantIdentityCharsInvalidError = ParticipantIdentityCharsInvalidError;
Object.defineProperty(TwilioErrorByCode, 53202, { value: ParticipantIdentityCharsInvalidError });

/**
 * @class ParticipantMaxTracksExceededError
 * @classdesc Raised whenever a Participant has too many Tracks.
 * @extends TwilioError
 * @property {number} code - 53203
 * @property {string} message - 'Participant has too many Tracks'
 */

var ParticipantMaxTracksExceededError = function (_TwilioError36) {
  _inherits(ParticipantMaxTracksExceededError, _TwilioError36);

  function ParticipantMaxTracksExceededError() {
    _classCallCheck(this, ParticipantMaxTracksExceededError);

    return _possibleConstructorReturn(this, (ParticipantMaxTracksExceededError.__proto__ || Object.getPrototypeOf(ParticipantMaxTracksExceededError)).call(this, 53203, 'Participant has too many Tracks'));
  }

  return ParticipantMaxTracksExceededError;
}(TwilioError);

exports.ParticipantMaxTracksExceededError = ParticipantMaxTracksExceededError;
Object.defineProperty(TwilioErrorByCode, 53203, { value: ParticipantMaxTracksExceededError });

/**
 * @class ParticipantNotFoundError
 * @classdesc Raised whenever attempting an operation on a non-existent Participant.
 * @extends TwilioError
 * @property {number} code - 53204
 * @property {string} message - 'Participant not found'
 */

var ParticipantNotFoundError = function (_TwilioError37) {
  _inherits(ParticipantNotFoundError, _TwilioError37);

  function ParticipantNotFoundError() {
    _classCallCheck(this, ParticipantNotFoundError);

    return _possibleConstructorReturn(this, (ParticipantNotFoundError.__proto__ || Object.getPrototypeOf(ParticipantNotFoundError)).call(this, 53204, 'Participant not found'));
  }

  return ParticipantNotFoundError;
}(TwilioError);

exports.ParticipantNotFoundError = ParticipantNotFoundError;
Object.defineProperty(TwilioErrorByCode, 53204, { value: ParticipantNotFoundError });

/**
 * @class ParticipantDuplicateIdentityError
 * @classdesc Raised by the server to the existing Participant when a new Participant joins a Room with the same identity as the existing Participant.
 * @extends TwilioError
 * @property {number} code - 53205
 * @property {string} message - 'Participant disconnected because of duplicate identity'
 */

var ParticipantDuplicateIdentityError = function (_TwilioError38) {
  _inherits(ParticipantDuplicateIdentityError, _TwilioError38);

  function ParticipantDuplicateIdentityError() {
    _classCallCheck(this, ParticipantDuplicateIdentityError);

    return _possibleConstructorReturn(this, (ParticipantDuplicateIdentityError.__proto__ || Object.getPrototypeOf(ParticipantDuplicateIdentityError)).call(this, 53205, 'Participant disconnected because of duplicate identity'));
  }

  return ParticipantDuplicateIdentityError;
}(TwilioError);

exports.ParticipantDuplicateIdentityError = ParticipantDuplicateIdentityError;
Object.defineProperty(TwilioErrorByCode, 53205, { value: ParticipantDuplicateIdentityError });

/**
 * @class TrackInvalidError
 * @classdesc Raised whenever a Track is invalid, and the scenario is not covered by a more specific error code.
 * @extends TwilioError
 * @property {number} code - 53300
 * @property {string} message - 'Track is invalid'
 */

var TrackInvalidError = function (_TwilioError39) {
  _inherits(TrackInvalidError, _TwilioError39);

  function TrackInvalidError() {
    _classCallCheck(this, TrackInvalidError);

    return _possibleConstructorReturn(this, (TrackInvalidError.__proto__ || Object.getPrototypeOf(TrackInvalidError)).call(this, 53300, 'Track is invalid'));
  }

  return TrackInvalidError;
}(TwilioError);

exports.TrackInvalidError = TrackInvalidError;
Object.defineProperty(TwilioErrorByCode, 53300, { value: TrackInvalidError });

/**
 * @class TrackNameInvalidError
 * @classdesc Raised whenever a Track name is invalid, and the scenario is not covered by a more specific error code.
 * @extends TwilioError
 * @property {number} code - 53301
 * @property {string} message - 'Track name is invalid'
 */

var TrackNameInvalidError = function (_TwilioError40) {
  _inherits(TrackNameInvalidError, _TwilioError40);

  function TrackNameInvalidError() {
    _classCallCheck(this, TrackNameInvalidError);

    return _possibleConstructorReturn(this, (TrackNameInvalidError.__proto__ || Object.getPrototypeOf(TrackNameInvalidError)).call(this, 53301, 'Track name is invalid'));
  }

  return TrackNameInvalidError;
}(TwilioError);

exports.TrackNameInvalidError = TrackNameInvalidError;
Object.defineProperty(TwilioErrorByCode, 53301, { value: TrackNameInvalidError });

/**
 * @class TrackNameTooLongError
 * @classdesc Raised whenever a Track name is too long.
 * @extends TwilioError
 * @property {number} code - 53302
 * @property {string} message - 'Track name is too long'
 */

var TrackNameTooLongError = function (_TwilioError41) {
  _inherits(TrackNameTooLongError, _TwilioError41);

  function TrackNameTooLongError() {
    _classCallCheck(this, TrackNameTooLongError);

    return _possibleConstructorReturn(this, (TrackNameTooLongError.__proto__ || Object.getPrototypeOf(TrackNameTooLongError)).call(this, 53302, 'Track name is too long'));
  }

  return TrackNameTooLongError;
}(TwilioError);

exports.TrackNameTooLongError = TrackNameTooLongError;
Object.defineProperty(TwilioErrorByCode, 53302, { value: TrackNameTooLongError });

/**
 * @class TrackNameCharsInvalidError
 * @classdesc Raised whenever a Track name contains invalid characters.
 * @extends TwilioError
 * @property {number} code - 53303
 * @property {string} message - 'Track name contains invalid characters'
 */

var TrackNameCharsInvalidError = function (_TwilioError42) {
  _inherits(TrackNameCharsInvalidError, _TwilioError42);

  function TrackNameCharsInvalidError() {
    _classCallCheck(this, TrackNameCharsInvalidError);

    return _possibleConstructorReturn(this, (TrackNameCharsInvalidError.__proto__ || Object.getPrototypeOf(TrackNameCharsInvalidError)).call(this, 53303, 'Track name contains invalid characters'));
  }

  return TrackNameCharsInvalidError;
}(TwilioError);

exports.TrackNameCharsInvalidError = TrackNameCharsInvalidError;
Object.defineProperty(TwilioErrorByCode, 53303, { value: TrackNameCharsInvalidError });

/**
 * @class TrackNameIsDuplicatedError
 * @classdesc Raised whenever a Participant is currently publishing a Track with the same name.
 * @extends TwilioError
 * @property {number} code - 53304
 * @property {string} message - 'Track name is duplicated'
 */

var TrackNameIsDuplicatedError = function (_TwilioError43) {
  _inherits(TrackNameIsDuplicatedError, _TwilioError43);

  function TrackNameIsDuplicatedError() {
    _classCallCheck(this, TrackNameIsDuplicatedError);

    return _possibleConstructorReturn(this, (TrackNameIsDuplicatedError.__proto__ || Object.getPrototypeOf(TrackNameIsDuplicatedError)).call(this, 53304, 'Track name is duplicated'));
  }

  return TrackNameIsDuplicatedError;
}(TwilioError);

exports.TrackNameIsDuplicatedError = TrackNameIsDuplicatedError;
Object.defineProperty(TwilioErrorByCode, 53304, { value: TrackNameIsDuplicatedError });

/**
 * @class TrackServerTrackCapacityReachedError
 * @classdesc The server does not have enough resources available to create a new Track.
 * @extends TwilioError
 * @property {number} code - 53305
 * @property {string} message - 'The server has reached capacity and cannot fulfill this request'
 */

var TrackServerTrackCapacityReachedError = function (_TwilioError44) {
  _inherits(TrackServerTrackCapacityReachedError, _TwilioError44);

  function TrackServerTrackCapacityReachedError() {
    _classCallCheck(this, TrackServerTrackCapacityReachedError);

    return _possibleConstructorReturn(this, (TrackServerTrackCapacityReachedError.__proto__ || Object.getPrototypeOf(TrackServerTrackCapacityReachedError)).call(this, 53305, 'The server has reached capacity and cannot fulfill this request'));
  }

  return TrackServerTrackCapacityReachedError;
}(TwilioError);

exports.TrackServerTrackCapacityReachedError = TrackServerTrackCapacityReachedError;
Object.defineProperty(TwilioErrorByCode, 53305, { value: TrackServerTrackCapacityReachedError });

/**
 * @class MediaClientLocalDescFailedError
 * @classdesc Raised whenever a Client is unable to create or apply a local media description.
 * @extends TwilioError
 * @property {number} code - 53400
 * @property {string} message - 'Client is unable to create or apply a local media description'
 */

var MediaClientLocalDescFailedError = function (_TwilioError45) {
  _inherits(MediaClientLocalDescFailedError, _TwilioError45);

  function MediaClientLocalDescFailedError() {
    _classCallCheck(this, MediaClientLocalDescFailedError);

    return _possibleConstructorReturn(this, (MediaClientLocalDescFailedError.__proto__ || Object.getPrototypeOf(MediaClientLocalDescFailedError)).call(this, 53400, 'Client is unable to create or apply a local media description'));
  }

  return MediaClientLocalDescFailedError;
}(TwilioError);

exports.MediaClientLocalDescFailedError = MediaClientLocalDescFailedError;
Object.defineProperty(TwilioErrorByCode, 53400, { value: MediaClientLocalDescFailedError });

/**
 * @class MediaServerLocalDescFailedError
 * @classdesc Raised whenever the Server is unable to create or apply a local media description.
 * @extends TwilioError
 * @property {number} code - 53401
 * @property {string} message - 'Server is unable to create or apply a local media description'
 */

var MediaServerLocalDescFailedError = function (_TwilioError46) {
  _inherits(MediaServerLocalDescFailedError, _TwilioError46);

  function MediaServerLocalDescFailedError() {
    _classCallCheck(this, MediaServerLocalDescFailedError);

    return _possibleConstructorReturn(this, (MediaServerLocalDescFailedError.__proto__ || Object.getPrototypeOf(MediaServerLocalDescFailedError)).call(this, 53401, 'Server is unable to create or apply a local media description'));
  }

  return MediaServerLocalDescFailedError;
}(TwilioError);

exports.MediaServerLocalDescFailedError = MediaServerLocalDescFailedError;
Object.defineProperty(TwilioErrorByCode, 53401, { value: MediaServerLocalDescFailedError });

/**
 * @class MediaClientRemoteDescFailedError
 * @classdesc Raised whenever the Client receives a remote media description but is unable to apply it.
 * @extends TwilioError
 * @property {number} code - 53402
 * @property {string} message - 'Client is unable to apply a remote media description'
 */

var MediaClientRemoteDescFailedError = function (_TwilioError47) {
  _inherits(MediaClientRemoteDescFailedError, _TwilioError47);

  function MediaClientRemoteDescFailedError() {
    _classCallCheck(this, MediaClientRemoteDescFailedError);

    return _possibleConstructorReturn(this, (MediaClientRemoteDescFailedError.__proto__ || Object.getPrototypeOf(MediaClientRemoteDescFailedError)).call(this, 53402, 'Client is unable to apply a remote media description'));
  }

  return MediaClientRemoteDescFailedError;
}(TwilioError);

exports.MediaClientRemoteDescFailedError = MediaClientRemoteDescFailedError;
Object.defineProperty(TwilioErrorByCode, 53402, { value: MediaClientRemoteDescFailedError });

/**
 * @class MediaServerRemoteDescFailedError
 * @classdesc Raised whenever the Server receives a remote media description but is unable to apply it.
 * @extends TwilioError
 * @property {number} code - 53403
 * @property {string} message - 'Server is unable to apply a remote media description'
 */

var MediaServerRemoteDescFailedError = function (_TwilioError48) {
  _inherits(MediaServerRemoteDescFailedError, _TwilioError48);

  function MediaServerRemoteDescFailedError() {
    _classCallCheck(this, MediaServerRemoteDescFailedError);

    return _possibleConstructorReturn(this, (MediaServerRemoteDescFailedError.__proto__ || Object.getPrototypeOf(MediaServerRemoteDescFailedError)).call(this, 53403, 'Server is unable to apply a remote media description'));
  }

  return MediaServerRemoteDescFailedError;
}(TwilioError);

exports.MediaServerRemoteDescFailedError = MediaServerRemoteDescFailedError;
Object.defineProperty(TwilioErrorByCode, 53403, { value: MediaServerRemoteDescFailedError });

/**
 * @class MediaNoSupportedCodecError
 * @classdesc Raised whenever the intersection of codecs supported by the Client and the Server (or, in peer-to-peer, the Client and another Participant) is empty.
 * @extends TwilioError
 * @property {number} code - 53404
 * @property {string} message - 'No supported codec'
 */

var MediaNoSupportedCodecError = function (_TwilioError49) {
  _inherits(MediaNoSupportedCodecError, _TwilioError49);

  function MediaNoSupportedCodecError() {
    _classCallCheck(this, MediaNoSupportedCodecError);

    return _possibleConstructorReturn(this, (MediaNoSupportedCodecError.__proto__ || Object.getPrototypeOf(MediaNoSupportedCodecError)).call(this, 53404, 'No supported codec'));
  }

  return MediaNoSupportedCodecError;
}(TwilioError);

exports.MediaNoSupportedCodecError = MediaNoSupportedCodecError;
Object.defineProperty(TwilioErrorByCode, 53404, { value: MediaNoSupportedCodecError });

/**
 * @class MediaConnectionError
 * @classdesc Raised by the Client or Server whenever a media connection fails or raised by the Client whenever it detects that media has stopped flowing.
 * @extends TwilioError
 * @property {number} code - 53405
 * @property {string} message - 'Media connection failed or Media activity ceased'
 */

var MediaConnectionError = function (_TwilioError50) {
  _inherits(MediaConnectionError, _TwilioError50);

  function MediaConnectionError() {
    _classCallCheck(this, MediaConnectionError);

    return _possibleConstructorReturn(this, (MediaConnectionError.__proto__ || Object.getPrototypeOf(MediaConnectionError)).call(this, 53405, 'Media connection failed or Media activity ceased'));
  }

  return MediaConnectionError;
}(TwilioError);

exports.MediaConnectionError = MediaConnectionError;
Object.defineProperty(TwilioErrorByCode, 53405, { value: MediaConnectionError });

/**
 * @class MediaDTLSTransportFailedError
 * @classdesc There was a problem while negotiating with the remote DTLS peer. Therefore the Participant will not be able to publish or subscribe to Tracks.
 * @extends TwilioError
 * @property {number} code - 53407
 * @property {string} message - 'Media connection failed due to DTLS handshake failure'
 */

var MediaDTLSTransportFailedError = function (_TwilioError51) {
  _inherits(MediaDTLSTransportFailedError, _TwilioError51);

  function MediaDTLSTransportFailedError() {
    _classCallCheck(this, MediaDTLSTransportFailedError);

    return _possibleConstructorReturn(this, (MediaDTLSTransportFailedError.__proto__ || Object.getPrototypeOf(MediaDTLSTransportFailedError)).call(this, 53407, 'Media connection failed due to DTLS handshake failure'));
  }

  return MediaDTLSTransportFailedError;
}(TwilioError);

exports.MediaDTLSTransportFailedError = MediaDTLSTransportFailedError;
Object.defineProperty(TwilioErrorByCode, 53407, { value: MediaDTLSTransportFailedError });

/**
 * @class ConfigurationAcquireFailedError
 * @classdesc Raised whenever the Client is unable to acquire configuration information from the Server.
 * @extends TwilioError
 * @property {number} code - 53500
 * @property {string} message - 'Unable to acquire configuration'
 */

var ConfigurationAcquireFailedError = function (_TwilioError52) {
  _inherits(ConfigurationAcquireFailedError, _TwilioError52);

  function ConfigurationAcquireFailedError() {
    _classCallCheck(this, ConfigurationAcquireFailedError);

    return _possibleConstructorReturn(this, (ConfigurationAcquireFailedError.__proto__ || Object.getPrototypeOf(ConfigurationAcquireFailedError)).call(this, 53500, 'Unable to acquire configuration'));
  }

  return ConfigurationAcquireFailedError;
}(TwilioError);

exports.ConfigurationAcquireFailedError = ConfigurationAcquireFailedError;
Object.defineProperty(TwilioErrorByCode, 53500, { value: ConfigurationAcquireFailedError });

/**
 * @class ConfigurationAcquireTurnFailedError
 * @classdesc Raised whenever the Server is unable to return TURN credentials to the Client
 * @extends TwilioError
 * @property {number} code - 53501
 * @property {string} message - 'Unable to acquire TURN credentials'
 */

var ConfigurationAcquireTurnFailedError = function (_TwilioError53) {
  _inherits(ConfigurationAcquireTurnFailedError, _TwilioError53);

  function ConfigurationAcquireTurnFailedError() {
    _classCallCheck(this, ConfigurationAcquireTurnFailedError);

    return _possibleConstructorReturn(this, (ConfigurationAcquireTurnFailedError.__proto__ || Object.getPrototypeOf(ConfigurationAcquireTurnFailedError)).call(this, 53501, 'Unable to acquire TURN credentials'));
  }

  return ConfigurationAcquireTurnFailedError;
}(TwilioError);

exports.ConfigurationAcquireTurnFailedError = ConfigurationAcquireTurnFailedError;
Object.defineProperty(TwilioErrorByCode, 53501, { value: ConfigurationAcquireTurnFailedError });
},{"./twilioerror":129}],129:[function(require,module,exports){
'use strict';

/**
 * @extends Error
 * @property {number} code - Error code
 */

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TwilioError = function (_Error) {
  _inherits(TwilioError, _Error);

  /**
   * Creates a new {@link TwilioError}
   * @param {number} code - Error code
   * @param {string} [message] - Error message
   * @param {string} [fileName] - Name of the script file where error was generated
   * @param {number} [lineNumber] - Line number of the script file where error was generated
   */
  function TwilioError(code) {
    var _ref;

    _classCallCheck(this, TwilioError);

    var args = [].slice.call(arguments, 1);

    var _this = _possibleConstructorReturn(this, (_ref = TwilioError.__proto__ || Object.getPrototypeOf(TwilioError)).call.apply(_ref, [this].concat(_toConsumableArray(args))));

    var error = Error.apply(_this, args);
    error.name = 'TwilioError';

    Object.defineProperty(_this, 'code', {
      value: code,
      enumerable: true
    });

    Object.getOwnPropertyNames(error).forEach(function (prop) {
      Object.defineProperty(this, prop, {
        value: error[prop],
        enumerable: true
      });
    }, _this);
    return _this;
  }

  /**
   * Returns human readable string describing the error.
   * @returns {string}
   */


  _createClass(TwilioError, [{
    key: 'toString',
    value: function toString() {
      var message = this.message ? ': ' + this.message : '';
      return this.name + ' ' + this.code + message;
    }
  }]);

  return TwilioError;
}(Error);

module.exports = TwilioError;
},{}],130:[function(require,module,exports){
'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _require = require('./'),
    isNonArrayObject = _require.isNonArrayObject;

var _require2 = require('./constants'),
    E = _require2.typeErrors,
    subscriptionMode = _require2.subscriptionMode,
    trackPriority = _require2.trackPriority,
    trackSwitchOffMode = _require2.trackSwitchOffMode;

/**
 * Validate the {@link BandwidthProfileOptions} object.
 * @param {BandwidthProfileOptions} bandwidthProfile
 * @returns {?Error} - null if valid, Error if not.
 */


function validateBandwidthProfile(bandwidthProfile) {
  var error = validateObject(bandwidthProfile, 'options.bandwidthProfile');
  if (!bandwidthProfile || error) {
    return error;
  }
  error = validateObject(bandwidthProfile.video, 'options.bandwidthProfile.video', [{ prop: 'dominantSpeakerPriority', values: Object.values(trackPriority) }, { prop: 'maxSubscriptionBitrate', type: 'number' }, { prop: 'maxTracks', type: 'number' }, { prop: 'mode', values: Object.values(subscriptionMode) }, { prop: 'trackSwitchOffMode', values: Object.values(trackSwitchOffMode) }]);
  return error || (bandwidthProfile.video ? validateRenderDimensions(bandwidthProfile.video.renderDimensions) : null);
}

/**
 * Throw if the given track is not a {@link LocalAudioTrack}, a
 * {@link LocalVideoTrack} or a MediaStreamTrack.
 * @param {*} track
 * @param {object} options
 */
function validateLocalTrack(track, options) {
  if (!(track instanceof options.LocalAudioTrack || track instanceof options.LocalDataTrack || track instanceof options.LocalVideoTrack || track instanceof options.MediaStreamTrack)) {
    /* eslint new-cap:0 */
    throw E.INVALID_TYPE('track', 'LocalAudioTrack, LocalVideoTrack, LocalDataTrack, or MediaStreamTrack');
  }
}

/**
 * Validate an object. An object is valid if it is undefined or a non-null, non-array
 * object whose properties satisfy the specified data-type or value-range requirements.
 * @param {object} object - the object to be validated
 * @param {string} name - the object name to be used to build the error message, if invalid
 * @param {Array<object>} [propChecks] - optional data-type or value-range requirements
 *   for the object's properties
 * @returns {?Error} - null if object is valid, Error if not
 */
function validateObject(object, name) {
  var propChecks = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];

  // NOTE(mmalavalli): We determine that an undefined object is valid because this
  // means the parent object does not contain this object as a property, which is
  // a valid scenario.
  if (typeof object === 'undefined') {
    return null;
  }
  // NOTE(mmalavalli): We determine that if the object is null, or an Array, or
  // any other non-object type, then it is invalid.
  if (object === null || !isNonArrayObject(object)) {
    return E.INVALID_TYPE(name, 'object');
  }
  // NOTE(mmalavalli): We determine that the object is invalid if at least one of
  // its properties does not satisfy its data-type or value-range requirement.
  return propChecks.reduce(function (error, _ref) {
    var prop = _ref.prop,
        type = _ref.type,
        values = _ref.values;

    if (error || !(prop in object)) {
      return error;
    }
    var value = object[prop];
    if (type && (typeof value === 'undefined' ? 'undefined' : _typeof(value)) !== type) {
      return E.INVALID_TYPE(name + '.' + prop, type);
    }
    if (type === 'number' && isNaN(value)) {
      return E.INVALID_TYPE(name + '.' + prop, type);
    }
    if (Array.isArray(values) && !values.includes(value)) {
      return E.INVALID_VALUE(name + '.' + prop, values);
    }
    return error;
  }, null);
}

/**
 * Validate the {@link VideoRenderDimensions} object.
 * @param {VideoRenderDimensions} renderDimensions
 * @returns {?Error} - null if valid, Error if not.
 */
function validateRenderDimensions(renderDimensions) {
  var name = 'options.bandwidthProfile.video.renderDimensions';
  var error = validateObject(renderDimensions, name);
  return renderDimensions ? error || Object.values(trackPriority).reduce(function (error, prop) {
    return error || validateObject(renderDimensions[prop], name + '.' + prop, [{ prop: 'height', type: 'number' }, { prop: 'width', type: 'number' }]);
  }, null) : error;
}

exports.validateBandwidthProfile = validateBandwidthProfile;
exports.validateLocalTrack = validateLocalTrack;
exports.validateObject = validateObject;
},{"./":114,"./constants":108}],131:[function(require,module,exports){
/* globals webkitAudioContext, AudioContext */
'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var NativeAudioContext = typeof AudioContext !== 'undefined' ? AudioContext : typeof webkitAudioContext !== 'undefined' ? webkitAudioContext : null;

/**
 * @interface AudioContextFactoryOptions
 * @property {AudioContext} [AudioContext] - The AudioContext constructor
 */

/**
 * {@link AudioContextFactory} ensures we construct at most one AudioContext
 * at a time, and that it is eventually closed when we no longer need it.
 * @property {AudioContextFactory} AudioContextFactory - The
 *   {@link AudioContextFactory} constructor
 */

var AudioContextFactory = function () {
  /**
   * @param {AudioContextFactoryOptions} [options]
   */
  function AudioContextFactory(options) {
    _classCallCheck(this, AudioContextFactory);

    options = Object.assign({
      AudioContext: NativeAudioContext
    }, options);
    Object.defineProperties(this, {
      _AudioContext: {
        value: options.AudioContext
      },
      _audioContext: {
        value: null,
        writable: true
      },
      _holders: {
        value: new Set()
      },
      AudioContextFactory: {
        enumerable: true,
        value: AudioContextFactory
      }
    });
  }

  /**
   * Each call to {@link AudioContextFactory#getOrCreate} should be paired with a
   * call to {@link AudioContextFactory#release}. Calling this increments an
   * internal reference count.
   * @param {*} holder - The object to hold a reference to the AudioContext
   * @returns {?AudioContext}
   */


  _createClass(AudioContextFactory, [{
    key: 'getOrCreate',
    value: function getOrCreate(holder) {
      if (!this._holders.has(holder)) {
        this._holders.add(holder);
        if (this._AudioContext && !this._audioContext) {
          try {
            this._audioContext = new this._AudioContext();
          } catch (error) {
            // Do nothing;
          }
        }
      }
      return this._audioContext;
    }

    /**
     * Decrement the internal reference count. If it reaches zero, close and destroy
     * the AudioContext.
     * @param {*} holder - The object that held a reference to the AudioContext
     * @returns {void}
     */

  }, {
    key: 'release',
    value: function release(holder) {
      if (this._holders.has(holder)) {
        this._holders.delete(holder);
        if (!this._holders.size && this._audioContext) {
          this._audioContext.close();
          this._audioContext = null;
        }
      }
    }
  }]);

  return AudioContextFactory;
}();

module.exports = new AudioContextFactory();
},{}],132:[function(require,module,exports){
'use strict';

/**
 * Return a Promise that resolves after `timeout` milliseconds.
 * @param {?number} [timeout=0]
 * @returns {Promise<void>}
 */

function delay(timeout) {
  timeout = typeof timeout === 'number' ? timeout : 0;
  return new Promise(function (resolve) {
    return setTimeout(resolve, timeout);
  });
}

/**
 * Attempt to detect silence. The Promise returned by this function returns
 * false as soon as audio is detected or true after `timeout` milliseconds.
 * @param {AudioContext} audioContext
 * @param {MediaStream} stream
 * @param {?number} [timeout=250]
 * @returns {Promise<boolean>}
 */
function detectSilence(audioContext, stream, timeout) {
  timeout = typeof timeout === 'number' ? timeout : 250;

  var source = audioContext.createMediaStreamSource(stream);
  var analyser = audioContext.createAnalyser();
  analyser.fftSize = 2048;
  source.connect(analyser);

  var samples = new Uint8Array(analyser.fftSize);

  var timeoutDidFire = false;
  setTimeout(function () {
    timeoutDidFire = true;
  }, timeout);

  /**
   * We can't use async/await yet, so I need to factor this out.
   * @returns {Promise<boolean>}
   */
  function doDetectSilence() {
    if (timeoutDidFire) {
      return Promise.resolve(true);
    }
    analyser.getByteTimeDomainData(samples);
    // NOTE(mpatwardhan): An audio MediaStreamTrack can be silent either due to all samples
    // being equal to 128 or all samples being equal to 0.
    return samples.some(function (sample) {
      return sample !== 128 && sample !== 0;
    }) ? Promise.resolve(false) : delay().then(doDetectSilence);
  }

  return doDetectSilence().then(function (isSilent) {
    source.disconnect();
    return isSilent;
  }, function (error) {
    source.disconnect();
    throw error;
  });
}

module.exports = detectSilence;
},{}],133:[function(require,module,exports){
'use strict';

var detectSilence = require('./detectsilence');

/**
 * This function attempts to workaround WebKit Bug 180748. It does so by
 *
 *   1. Calling `getUserMedia`, and
 *   2. Checking to see if the resulting MediaStream is silent.
 *   3. If so, repeat Step 1; otherwise, return the MediaStream.
 *
 * The function only repeats up to `n` times, and it only waits `timeout`
 * milliseconds when detecting silence. Assuming `getUserMedia` is
 * instantaneous, in the best case, this function returns a Promise that
 * resolves immediately; in the worst case, this function returns a Promise that
 * resolves in `n` * `timeout` milliseconds.
 *
 * @param {Log} log
 * @param {function(MediaStreamConstraints): Promise<MediaStream>} getUserMedia
 * @param {MediaStreamConstraints} constraints
 * @param {number} [n=3]
 * @param {number} [timeout=250]
 * @returns Promise<MediaStream>
 */
function workaround(log, getUserMedia, constraints, n, timeout) {
  n = typeof n === 'number' ? n : 3;
  var retry = 0;

  // NOTE(mroberts): We have to delay require-ing AudioContextFactory, because
  // it exports a default instance whose constructor calls Object.assign.
  var AudioContextFactory = require('./audiocontext');
  var holder = {};
  var audioContext = AudioContextFactory.getOrCreate(holder);

  /**
   * We can't use async/await yet, so I need to factor this out.
   * @returns {Promise<MediaStream>}
   */
  function doWorkaround() {
    return getUserMedia(constraints).then(function (stream) {
      var isSilentPromise = constraints.audio ? detectSilence(audioContext, stream, timeout).catch(function (err) {
        log.warn('Encountered an error while detecting silence', err);
        return true;
      }) : Promise.resolve(false);
      return isSilentPromise.then(function (isSilent) {
        if (!isSilent) {
          log.info('Got a non-silent audio MediaStreamTrack; returning it.');
          return stream;
        } else if (n <= 0) {
          log.warn('Got a silent audio MediaStreamTrack. Normally we would try \
to get a new one, but we\'ve run out of retries; returning it anyway.');
          return stream;
        }
        log.warn('Got a silent audio MediaStreamTrack. Stopping all MediaStreamTracks and calling getUserMedia again. This is retry #' + ++retry + '.');
        stream.getTracks().forEach(function (track) {
          return track.stop();
        });
        n--;
        return doWorkaround();
      });
    });
  }

  return doWorkaround().then(function (stream) {
    AudioContextFactory.release(holder);
    return stream;
  }, function (error) {
    AudioContextFactory.release(holder);
    throw error;
  });
}

module.exports = workaround;
},{"./audiocontext":131,"./detectsilence":132}],134:[function(require,module,exports){
'use strict';

var flatMap = require('./util').flatMap;
var guessBrowser = require('./util').guessBrowser;
var guessBrowserVersion = require('./util').guessBrowserVersion;
var getSdpFormat = require('./util/sdp').getSdpFormat;

var guess = guessBrowser();
var guessVersion = guessBrowserVersion();
var isChrome = guess === 'chrome';
var isFirefox = guess === 'firefox';
var isSafari = guess === 'safari';

var chromeMajorVersion = isChrome ? guessVersion.major : null;

var CHROME_LEGACY_MAX_AUDIO_LEVEL = 32767;

/**
 * Get the standardized {@link RTCPeerConnection} statistics.
 * @param {RTCPeerConnection} peerConnection
 * @param {object} [options] - Used for testing
 * @returns {Promise.<StandardizedStatsResponse>}
 */
function getStats(peerConnection, options) {
  if (!(peerConnection && typeof peerConnection.getStats === 'function')) {
    return Promise.reject(new Error('Given PeerConnection does not support getStats'));
  }
  return _getStats(peerConnection, options);
}

/**
 * getStats() implementation.
 * @param {RTCPeerConnection} peerConnection
 * @param {object} [options] - Used for testing
 * @returns {Promise.<StandardizedStatsResponse>}
 */
function _getStats(peerConnection, options) {
  var localAudioTracks = getTracks(peerConnection, 'audio', 'local');
  var localVideoTracks = getTracks(peerConnection, 'video', 'local');
  var remoteAudioTracks = getTracks(peerConnection, 'audio');
  var remoteVideoTracks = getTracks(peerConnection, 'video');

  var statsResponse = {
    activeIceCandidatePair: null,
    localAudioTrackStats: [],
    localVideoTrackStats: [],
    remoteAudioTrackStats: [],
    remoteVideoTrackStats: []
  };

  var trackStatsPromises = flatMap([
    [localAudioTracks, 'localAudioTrackStats', false],
    [localVideoTracks, 'localVideoTrackStats', false],
    [remoteAudioTracks, 'remoteAudioTrackStats', true],
    [remoteVideoTracks, 'remoteVideoTrackStats', true]
  ], function(triple) {
    var tracks = triple[0];
    var statsArrayName = triple[1];
    var isRemote = triple[2];
    return tracks.map(function(track) {
      return getTrackStats(peerConnection, track, Object.assign({
        isRemote: isRemote
      }, options)).then(function(trackStatsArray) {
        trackStatsArray.forEach(function(trackStats) {
          trackStats.trackId = track.id;
          statsResponse[statsArrayName].push(trackStats);
        });
      });
    });
  });

  return Promise.all(trackStatsPromises).then(function() {
    return getActiveIceCandidatePairStats(peerConnection, options);
  }).then(function(activeIceCandidatePairStatsReport) {
    statsResponse.activeIceCandidatePair = activeIceCandidatePairStatsReport;
    return statsResponse;
  });
}

/**
 * Generate the {@link StandardizedActiveIceCandidatePairStatsReport} for the
 * {@link RTCPeerConnection}.
 * @param {RTCPeerConnection} peerConnection
 * @param {object} [options]
 * @returns {Promise<StandardizedActiveIceCandidatePairStatsReport>}
 */
function getActiveIceCandidatePairStats(peerConnection, options) {
  options = options || {};

  if (typeof options.testForChrome !== 'undefined' || isChrome
    || typeof options.testForSafari  !== 'undefined' || isSafari) {
    return peerConnection.getStats().then(
      standardizeChromeOrSafariActiveIceCandidatePairStats);
  }
  if (typeof options.testForFirefox !== 'undefined' || isFirefox) {
    return peerConnection.getStats().then(standardizeFirefoxActiveIceCandidatePairStats);
  }
  return Promise.reject(new Error('RTCPeerConnection#getStats() not supported'));
}

/**
 * Standardize the active RTCIceCandidate pair's statistics in Chrome or Safari.
 * @param {RTCStatsReport} stats
 * @returns {?StandardizedActiveIceCandidatePairStatsReport}
 */
function standardizeChromeOrSafariActiveIceCandidatePairStats(stats) {
  var activeCandidatePairStats = Array.from(stats.values()).find(function(stat) {
    return stat.type === 'candidate-pair' && stat.nominated;
  });

  if (!activeCandidatePairStats) {
    return null;
  }

  var activeLocalCandidateStats = stats.get(activeCandidatePairStats.localCandidateId);
  var activeRemoteCandidateStats = stats.get(activeCandidatePairStats.remoteCandidateId);

  var standardizedCandidateStatsKeys = [
    { key: 'candidateType', type: 'string' },
    { key: 'ip', type: 'string' },
    { key: 'port', type: 'number' },
    { key: 'priority', type: 'number' },
    { key: 'protocol', type: 'string' },
    { key: 'url', type: 'string' }
  ];

  var standardizedLocalCandidateStatsKeys = standardizedCandidateStatsKeys.concat([
    { key: 'deleted', type: 'boolean' },
    { key: 'relayProtocol', type: 'string' }
  ]);

  var standatdizedLocalCandidateStatsReport = activeLocalCandidateStats
    ? standardizedLocalCandidateStatsKeys.reduce(function(report, keyInfo) {
      report[keyInfo.key] = typeof activeLocalCandidateStats[keyInfo.key] === keyInfo.type
        ? activeLocalCandidateStats[keyInfo.key]
        : keyInfo.key === 'deleted' ? false : null;
      return report;
    }, {})
    : null;

  var standardizedRemoteCandidateStatsReport = activeRemoteCandidateStats
    ? standardizedCandidateStatsKeys.reduce(function(report, keyInfo) {
      report[keyInfo.key] = typeof activeRemoteCandidateStats[keyInfo.key] === keyInfo.type
        ? activeRemoteCandidateStats[keyInfo.key]
        : null;
      return report;
    }, {})
    : null;

  return [
    { key: 'availableIncomingBitrate', type: 'number' },
    { key: 'availableOutgoingBitrate', type: 'number' },
    { key: 'bytesReceived', type: 'number' },
    { key: 'bytesSent', type: 'number' },
    { key: 'consentRequestsSent', type: 'number' },
    { key: 'currentRoundTripTime', type: 'number' },
    { key: 'lastPacketReceivedTimestamp', type: 'number' },
    { key: 'lastPacketSentTimestamp', type: 'number' },
    { key: 'nominated', type: 'boolean' },
    { key: 'priority', type: 'number' },
    { key: 'readable', type: 'boolean' },
    { key: 'requestsReceived', type: 'number' },
    { key: 'requestsSent', type: 'number' },
    { key: 'responsesReceived', type: 'number' },
    { key: 'responsesSent', type: 'number' },
    { key: 'retransmissionsReceived', type: 'number' },
    { key: 'retransmissionsSent', type: 'number' },
    { key: 'state', type: 'string', fixup: function(state) { return state === 'inprogress' ? 'in-progress' : state; } },
    { key: 'totalRoundTripTime', type: 'number' },
    { key: 'transportId', type: 'string' },
    { key: 'writable', type: 'boolean' }
  ].reduce(function(report, keyInfo) {
    report[keyInfo.key] = typeof activeCandidatePairStats[keyInfo.key] === keyInfo.type
      ? (keyInfo.fixup ? keyInfo.fixup(activeCandidatePairStats[keyInfo.key]) : activeCandidatePairStats[keyInfo.key])
      : null;
    return report;
  }, {
    localCandidate: standatdizedLocalCandidateStatsReport,
    remoteCandidate: standardizedRemoteCandidateStatsReport
  });
}

/**
 * Standardize the active RTCIceCandidate pair's statistics in Firefox.
 * @param {RTCStatsReport} stats
 * @returns {?StandardizedActiveIceCandidatePairStatsReport}
 */
function standardizeFirefoxActiveIceCandidatePairStats(stats) {
  var activeCandidatePairStats = Array.from(stats.values()).find(function(stat) {
    return stat.type === 'candidate-pair' && stat.nominated;
  });

  if (!activeCandidatePairStats) {
    return null;
  }

  var activeLocalCandidateStats = stats.get(activeCandidatePairStats.localCandidateId);
  var activeRemoteCandidateStats = stats.get(activeCandidatePairStats.remoteCandidateId);

  var standardizedCandidateStatsKeys = [
    { key: 'candidateType', type: 'string' },
    { key: 'ip', ffKeys: ['address', 'ipAddress'], type: 'string' },
    { key: 'port', ffKeys: ['portNumber'], type: 'number' },
    { key: 'priority', type: 'number' },
    { key: 'protocol', ffKeys: ['transport'], type: 'string' },
    { key: 'url', type: 'string' }
  ];

  var standardizedLocalCandidateStatsKeys = standardizedCandidateStatsKeys.concat([
    { key: 'deleted', type: 'boolean' },
    { key: 'relayProtocol', type: 'string' }
  ]);

  var candidateTypes = {
    host: 'host',
    peerreflexive: 'prflx',
    relayed: 'relay',
    serverreflexive: 'srflx'
  };

  var standatdizedLocalCandidateStatsReport = activeLocalCandidateStats
    ? standardizedLocalCandidateStatsKeys.reduce(function(report, keyInfo) {
      var key = keyInfo.ffKeys && keyInfo.ffKeys.find(function(key) {
        return key in activeLocalCandidateStats;
      }) || keyInfo.key;
      report[keyInfo.key] = typeof activeLocalCandidateStats[key] === keyInfo.type
        ? key === 'candidateType'
          ? candidateTypes[activeLocalCandidateStats[key]] || activeLocalCandidateStats[key]
          : activeLocalCandidateStats[key]
        : key === 'deleted' ? false : null;
      return report;
    }, {})
    : null;

  var standardizedRemoteCandidateStatsReport = activeRemoteCandidateStats
    ? standardizedCandidateStatsKeys.reduce(function(report, keyInfo) {
      var key = keyInfo.ffKeys && keyInfo.ffKeys.find(function(key) {
        return key in activeRemoteCandidateStats;
      }) || keyInfo.key;
      report[keyInfo.key] = typeof activeRemoteCandidateStats[key] === keyInfo.type
        ? key === 'candidateType'
          ? candidateTypes[activeRemoteCandidateStats[key]] || activeRemoteCandidateStats[key]
          : activeRemoteCandidateStats[key]
        : null;
      return report;
    }, {})
    : null;

  return [
    { key: 'availableIncomingBitrate', type: 'number' },
    { key: 'availableOutgoingBitrate', type: 'number' },
    { key: 'bytesReceived', type: 'number' },
    { key: 'bytesSent', type: 'number' },
    { key: 'consentRequestsSent', type: 'number' },
    { key: 'currentRoundTripTime', type: 'number' },
    { key: 'lastPacketReceivedTimestamp', type: 'number' },
    { key: 'lastPacketSentTimestamp', type: 'number' },
    { key: 'nominated', type: 'boolean' },
    { key: 'priority', type: 'number' },
    { key: 'readable', type: 'boolean' },
    { key: 'requestsReceived', type: 'number' },
    { key: 'requestsSent', type: 'number' },
    { key: 'responsesReceived', type: 'number' },
    { key: 'responsesSent', type: 'number' },
    { key: 'retransmissionsReceived', type: 'number' },
    { key: 'retransmissionsSent', type: 'number' },
    { key: 'state', type: 'string' },
    { key: 'totalRoundTripTime', type: 'number' },
    { key: 'transportId', type: 'string' },
    { key: 'writable', type: 'boolean' }
  ].reduce(function(report, keyInfo) {
    report[keyInfo.key] = typeof activeCandidatePairStats[keyInfo.key] === keyInfo.type
      ? activeCandidatePairStats[keyInfo.key]
      : null;
    return report;
  }, {
    localCandidate: standatdizedLocalCandidateStatsReport,
    remoteCandidate: standardizedRemoteCandidateStatsReport
  });
}

/**
 * Get local/remote audio/video MediaStreamTracks.
 * @param {RTCPeerConnection} peerConnection - The RTCPeerConnection
 * @param {string} kind - 'audio' or 'video'
 * @param {string} [localOrRemote] - 'local' or 'remote'
 * @returns {Array<MediaStreamTrack>}
 */
function getTracks(peerConnection, kind, localOrRemote) {
  var getSendersOrReceivers = localOrRemote === 'local' ? 'getSenders' : 'getReceivers';
  if (peerConnection[getSendersOrReceivers]) {
    return peerConnection[getSendersOrReceivers]().map(function(senderOrReceiver) {
      return senderOrReceiver.track;
    }).filter(function(track) {
      return track && track.kind === kind;
    });
  }
  var getStreams = localOrRemote === 'local' ? 'getLocalStreams' : 'getRemoteStreams';
  return flatMap(peerConnection[getStreams](), function(stream) {
    var getTracks = kind === 'audio' ? 'getAudioTracks' : 'getVideoTracks';
    return stream[getTracks]();
  });
}

/**
 * Get the standardized statistics for a particular MediaStreamTrack.
 * @param {RTCPeerConnection} peerConnection
 * @param {MediaStreamTrack} track
 * @param {object} [options] - Used for testing
 * @returns {Promise.<Array<StandardizedTrackStatsReport>>}
 */
function getTrackStats(peerConnection, track, options) {
  options = options || {};

  if (typeof options.testForChrome !== 'undefined' || isChrome) {
    return chromeOrSafariGetTrackStats(peerConnection, track);
  }
  if (typeof options.testForFirefox  !== 'undefined' || isFirefox) {
    return firefoxGetTrackStats(peerConnection, track, options.isRemote);
  }
  if (typeof options.testForSafari  !== 'undefined' || isSafari) {
    if (typeof options.testForSafari  !== 'undefined' || getSdpFormat() === 'unified') {
      return chromeOrSafariGetTrackStats(peerConnection, track);
    }
    // NOTE(syerrapragada): getStats() is not supported on
    // Safari versions where plan-b is the SDP format
    // due to this bug: https://bugs.webkit.org/show_bug.cgi?id=192601
    return Promise.reject(new Error([
      'getStats() is not supported on this version of Safari',
      'due to this bug: https://bugs.webkit.org/show_bug.cgi?id=192601'
    ].join(' ')));
  }
  return Promise.reject(new Error('RTCPeerConnection#getStats() not supported'));
}

/**
 * Get the standardized statistics for a particular MediaStreamTrack in Chrome or Safari.
 * @param {RTCPeerConnection} peerConnection
 * @param {MediaStreamTrack} track
 * @returns {Promise.<Array<StandardizedTrackStatsReport>>}
 */
function chromeOrSafariGetTrackStats(peerConnection, track) {
  return new Promise(function(resolve, reject) {
    if (chromeMajorVersion && chromeMajorVersion < 67) {
      peerConnection.getStats(function(response) {
        resolve([standardizeChromeLegacyStats(response, track)]);
      }, null, reject);
      return;
    }
    peerConnection.getStats(track).then(function(response) {
      resolve(standardizeChromeOrSafariStats(response));
    }, reject);
  });
}

/**
 * Get the standardized statistics for a particular MediaStreamTrack in Firefox.
 * @param {RTCPeerConnection} peerConnection
 * @param {MediaStreamTrack} track
 * @param {boolean} isRemote
 * @returns {Promise.<Array<StandardizedTrackStatsReport>>}
 */
function firefoxGetTrackStats(peerConnection, track, isRemote) {
  return new Promise(function(resolve, reject) {
    peerConnection.getStats(track).then(function(response) {
      resolve([standardizeFirefoxStats(response, isRemote)]);
    }, reject);
  });
}

/**
 * Standardize the MediaStreamTrack's legacy statistics in Chrome.
 * @param {RTCStatsResponse} response
 * @param {MediaStreamTrack} track
 * @returns {StandardizedTrackStatsReport}
 */
function standardizeChromeLegacyStats(response, track) {
  var ssrcReport = response.result().find(function(report) {
    return report.type === 'ssrc' && report.stat('googTrackId') === track.id;
  });

  var standardizedStats = {};

  if (ssrcReport) {
    standardizedStats.timestamp = Math.round(Number(ssrcReport.timestamp));
    standardizedStats = ssrcReport.names().reduce(function(stats, name) {
      switch (name) {
        case 'googCodecName':
          stats.codecName = ssrcReport.stat(name);
          break;
        case 'googRtt':
          stats.roundTripTime = Number(ssrcReport.stat(name));
          break;
        case 'googJitterReceived':
          stats.jitter = Number(ssrcReport.stat(name));
          break;
        case 'googFrameWidthInput':
          stats.frameWidthInput = Number(ssrcReport.stat(name));
          break;
        case 'googFrameHeightInput':
          stats.frameHeightInput = Number(ssrcReport.stat(name));
          break;
        case 'googFrameWidthSent':
          stats.frameWidthSent = Number(ssrcReport.stat(name));
          break;
        case 'googFrameHeightSent':
          stats.frameHeightSent = Number(ssrcReport.stat(name));
          break;
        case 'googFrameWidthReceived':
          stats.frameWidthReceived = Number(ssrcReport.stat(name));
          break;
        case 'googFrameHeightReceived':
          stats.frameHeightReceived = Number(ssrcReport.stat(name));
          break;
        case 'googFrameRateInput':
          stats.frameRateInput = Number(ssrcReport.stat(name));
          break;
        case 'googFrameRateSent':
          stats.frameRateSent = Number(ssrcReport.stat(name));
          break;
        case 'googFrameRateReceived':
          stats.frameRateReceived = Number(ssrcReport.stat(name));
          break;
        case 'ssrc':
          stats[name] = ssrcReport.stat(name);
          break;
        case 'bytesReceived':
        case 'bytesSent':
        case 'packetsLost':
        case 'packetsReceived':
        case 'packetsSent':
        case 'audioInputLevel':
        case 'audioOutputLevel':
          stats[name] = Number(ssrcReport.stat(name));
          break;
      }

      return stats;
    }, standardizedStats);
  }

  return standardizedStats;
}

/**
 * Standardize the MediaStreamTrack's statistics in Chrome or Safari.
 * @param {RTCStatsResponse} response
 * @returns {Array<StandardizedTrackStatsReport>}
 */
function standardizeChromeOrSafariStats(response) {
  var inbound = null;

  // NOTE(mpatwardhan): We should expect more than one "outbound-rtp" stats for a
  // VP8 simulcast MediaStreamTrack.
  var outbound = [];

  var remoteInbound = null;
  var remoteOutbound = null;
  var track = null;
  var codec = null;

  response.forEach(function(stat) {
    switch (stat.type) {
      case 'inbound-rtp':
        inbound = stat;
        break;
      case 'outbound-rtp':
        outbound.push(stat);
        break;
      case 'track':
        track = stat;
        break;
      case 'codec':
        codec = stat;
        break;
      case 'remote-inbound-rtp':
        remoteInbound = stat;
        break;
      case 'remote-outbound-rtp':
        remoteOutbound = stat;
        break;
    }
  });

  var isRemote = track && track.remoteSource;
  var mainSources = isRemote ? [inbound] : outbound;
  var stats = [];
  var remoteSource = isRemote ? remoteOutbound : remoteInbound; // remote rtp stats

  mainSources.forEach(function(source) {
    var standardizedStats = {};
    var statSources = [
      source, // local rtp stats
      track,
      codec,
      remoteSource && remoteSource.ssrc === source.ssrc ? remoteSource : null, // remote rtp stats
    ];

    function getStatValue(name) {
      var sourceFound = statSources.find(function(statSource) {
        return statSource && typeof statSource[name] !== 'undefined';
      }) || null;

      return sourceFound ? sourceFound[name] : null;
    }

    var ssrc = getStatValue('ssrc');
    if (typeof ssrc === 'number') {
      standardizedStats.ssrc = String(ssrc);
    }

    var timestamp = getStatValue('timestamp');
    standardizedStats.timestamp = Math.round(timestamp);

    var mimeType = getStatValue('mimeType');
    if (typeof mimeType === 'string') {
      mimeType = mimeType.split('/');
      standardizedStats.codecName = mimeType[mimeType.length - 1];
    }

    var roundTripTime = getStatValue('roundTripTime');
    if (typeof roundTripTime === 'number') {
      standardizedStats.roundTripTime = Math.round(roundTripTime * 1000);
    }

    var jitter = getStatValue('jitter');
    if (typeof jitter === 'number') {
      standardizedStats.jitter = Math.round(jitter * 1000);
    }

    var frameWidth = getStatValue('frameWidth');
    if (typeof frameWidth === 'number') {
      if (isRemote) {
        standardizedStats.frameWidthReceived = frameWidth;
      } else {
        standardizedStats.frameWidthSent = frameWidth;
      }
    }

    var frameHeight = getStatValue('frameHeight');
    if (typeof frameHeight === 'number') {
      if (isRemote) {
        standardizedStats.frameHeightReceived = frameHeight;
      } else {
        standardizedStats.frameHeightSent = frameHeight;
      }
    }

    var framesPerSecond = getStatValue('framesPerSecond');
    if (typeof framesPerSecond === 'number') {
      standardizedStats.frameRateSent = framesPerSecond;
    }

    var bytesReceived = getStatValue('bytesReceived');
    if (typeof bytesReceived === 'number') {
      standardizedStats.bytesReceived = bytesReceived;
    }

    var bytesSent = getStatValue('bytesSent');
    if (typeof bytesSent === 'number') {
      standardizedStats.bytesSent = bytesSent;
    }

    var packetsLost = getStatValue('packetsLost');
    if (typeof packetsLost === 'number') {
      standardizedStats.packetsLost = packetsLost;
    }

    var packetsReceived = getStatValue('packetsReceived');
    if (typeof packetsReceived === 'number') {
      standardizedStats.packetsReceived = packetsReceived;
    }

    var packetsSent = getStatValue('packetsSent');
    if (typeof packetsSent === 'number') {
      standardizedStats.packetsSent = packetsSent;
    }

    var audioLevel = getStatValue('audioLevel');
    if (typeof audioLevel === 'number') {
      audioLevel = Math.round(audioLevel * CHROME_LEGACY_MAX_AUDIO_LEVEL);
      if (isRemote) {
        standardizedStats.audioOutputLevel = audioLevel;
      } else {
        standardizedStats.audioInputLevel = audioLevel;
      }
    }

    stats.push(standardizedStats);
  });

  return stats;
}

/**
 * Standardize the MediaStreamTrack's statistics in Firefox.
 * @param {RTCStatsReport} response
 * @param {boolean} isRemote
 * @returns {StandardizedTrackStatsReport}
 */
function standardizeFirefoxStats(response, isRemote) {
  // NOTE(mroberts): If getStats is called on a closed RTCPeerConnection,
  // Firefox returns undefined instead of an RTCStatsReport. We workaround this
  // here. See the following bug for more details:
  //
  //   https://bugzilla.mozilla.org/show_bug.cgi?id=1377225
  //
  response = response || new Map();

  var inbound = null;
  var outbound = null;

  // NOTE(mmalavalli): Starting from Firefox 63, RTC{Inbound, Outbound}RTPStreamStats.isRemote
  // will be deprecated, followed by its removal in Firefox 66. Also, trying to
  // access members of the remote RTC{Inbound, Outbound}RTPStreamStats without
  // using RTCStatsReport.get(remoteId) will trigger console warnings. So, we
  // no longer depend on "isRemote", and we call RTCStatsReport.get(remoteId)
  // to access the remote RTC{Inbound, Outbound}RTPStreamStats.
  //
  // Source: https://blog.mozilla.org/webrtc/getstats-isremote-65/
  //
  response.forEach(function(stat) {
    if (stat.isRemote) {
      return;
    }
    switch (stat.type) {
      case 'inbound-rtp':
        inbound = stat;
        outbound = response.get(stat.remoteId);
        break;
      case 'outbound-rtp':
        outbound = stat;
        inbound = response.get(stat.remoteId);
        break;
    }
  });

  var first = isRemote ? inbound : outbound;
  var second = isRemote ? outbound : inbound;

  function getStatValue(name) {
    if (first && typeof first[name] !== 'undefined') {
      return first[name];
    }
    if (second && typeof second[name] !== 'undefined') {
      return second[name];
    }
    return null;
  }

  var standardizedStats = {};
  var timestamp = getStatValue('timestamp');
  standardizedStats.timestamp = Math.round(timestamp);

  var ssrc = getStatValue('ssrc');
  if (typeof ssrc === 'number') {
    standardizedStats.ssrc = String(ssrc);
  }

  var bytesSent = getStatValue('bytesSent');
  if (typeof bytesSent === 'number') {
    standardizedStats.bytesSent = bytesSent;
  }

  var packetsLost = getStatValue('packetsLost');
  if (typeof packetsLost === 'number') {
    standardizedStats.packetsLost = packetsLost;
  }

  var packetsSent = getStatValue('packetsSent');
  if (typeof packetsSent === 'number') {
    standardizedStats.packetsSent = packetsSent;
  }

  var roundTripTime = getStatValue('roundTripTime');
  if (typeof roundTripTime === 'number') {
    // roundTripTime is double - measured in seconds.
    // https://www.w3.org/TR/webrtc-stats/#dom-rtcremoteinboundrtpstreamstats-roundtriptime
    // cover it to milliseconds (and make it integer)
    standardizedStats.roundTripTime = Math.round(roundTripTime * 1000);
  }

  var jitter = getStatValue('jitter');
  if (typeof jitter === 'number') {
    standardizedStats.jitter = Math.round(jitter * 1000);
  }

  var frameRateSent = getStatValue('framerateMean');
  if (typeof frameRateSent === 'number') {
    standardizedStats.frameRateSent = Math.round(frameRateSent);
  }

  var bytesReceived = getStatValue('bytesReceived');
  if (typeof bytesReceived === 'number') {
    standardizedStats.bytesReceived = bytesReceived;
  }

  var packetsReceived = getStatValue('packetsReceived');
  if (typeof packetsReceived === 'number') {
    standardizedStats.packetsReceived = packetsReceived;
  }

  var frameRateReceived = getStatValue('framerateMean');
  if (typeof frameRateReceived === 'number') {
    standardizedStats.frameRateReceived = Math.round(frameRateReceived);
  }

  return standardizedStats;
}

/**
 * Standardized RTCIceCandidate statistics.
 * @typedef {object} StandardizedIceCandidateStatsReport
 * @property {'host'|'prflx'|'relay'|'srflx'} candidateType
 * @property {string} ip
 * @property {number} port
 * @property {number} priority
 * @property {'tcp'|'udp'} protocol
 * @property {string} url
 */

/**
 * Standardized local RTCIceCandidate statistics.
 * @typedef {StandardizedIceCandidateStatsReport} StandardizedLocalIceCandidateStatsReport
 * @property {boolean} [deleted=false]
 * @property {'tcp'|'tls'|'udp'} relayProtocol
 */

/**
 * Standardized active RTCIceCandidate pair statistics.
 * @typedef {object} StandardizedActiveIceCandidatePairStatsReport
 * @property {number} availableIncomingBitrate
 * @property {number} availableOutgoingBitrate
 * @property {number} bytesReceived
 * @property {number} bytesSent
 * @property {number} consentRequestsSent
 * @property {number} currentRoundTripTime
 * @property {number} lastPacketReceivedTimestamp
 * @property {number} lastPacketSentTimestamp
 * @property {StandardizedLocalIceCandidateStatsReport} localCandidate
 * @property {boolean} nominated
 * @property {number} priority
 * @property {boolean} readable
 * @property {StandardizedIceCandidateStatsReport} remoteCandidate
 * @property {number} requestsReceived
 * @property {number} requestsSent
 * @property {number} responsesReceived
 * @property {number} responsesSent
 * @property {number} retransmissionsReceived
 * @property {number} retransmissionsSent
 * @property {'frozen'|'waiting'|'in-progress'|'failed'|'succeeded'} state
 * @property {number} totalRoundTripTime
 * @property {string} transportId
 * @property {boolean} writable
 */

/**
 * Standardized {@link RTCPeerConnection} statistics.
 * @typedef {Object} StandardizedStatsResponse
 * @property {StandardizedActiveIceCandidatePairStatsReport} activeIceCandidatePair - Stats for active ICE candidate pair
 * @property Array<StandardizedTrackStatsReport> localAudioTrackStats - Stats for local audio MediaStreamTracks
 * @property Array<StandardizedTrackStatsReport> localVideoTrackStats - Stats for local video MediaStreamTracks
 * @property Array<StandardizedTrackStatsReport> remoteAudioTrackStats - Stats for remote audio MediaStreamTracks
 * @property Array<StandardizedTrackStatsReport> remoteVideoTrackStats - Stats for remote video MediaStreamTracks
 */

/**
 * Standardized MediaStreamTrack statistics.
 * @typedef {Object} StandardizedTrackStatsReport
 * @property {string} trackId - MediaStreamTrack ID
 * @property {string} ssrc - SSRC of the MediaStreamTrack
 * @property {number} timestamp - The Unix timestamp in milliseconds
 * @property {string} [codecName] - Name of the codec used to encode the MediaStreamTrack's media
 * @property {number} [roundTripTime] - Round trip time in milliseconds
 * @property {number} [jitter] - Jitter in milliseconds
 * @property {number} [frameWidthInput] - Width in pixels of the local video MediaStreamTrack's captured frame
 * @property {number} [frameHeightInput] - Height in pixels of the local video MediaStreamTrack's captured frame
 * @property {number} [frameWidthSent] - Width in pixels of the local video MediaStreamTrack's encoded frame
 * @property {number} [frameHeightSent] - Height in pixels of the local video MediaStreamTrack's encoded frame
 * @property {number} [frameWidthReceived] - Width in pixels of the remote video MediaStreamTrack's received frame
 * @property {number} [frameHeightReceived] - Height in pixels of the remote video MediaStreamTrack's received frame
 * @property {number} [frameRateInput] - Captured frames per second of the local video MediaStreamTrack
 * @property {number} [frameRateSent] - Frames per second of the local video MediaStreamTrack's encoded video
 * @property {number} [frameRateReceived] - Frames per second of the remote video MediaStreamTrack's received video
 * @property {number} [bytesReceived] - Number of bytes of the remote MediaStreamTrack's media received
 * @property {number} [bytesSent] - Number of bytes of the local MediaStreamTrack's media sent
 * @property {number} [packetsLost] - Number of packets of the MediaStreamTrack's media lost
 * @property {number} [packetsReceived] - Number of packets of the remote MediaStreamTrack's media received
 * @property {number} [packetsSent] - Number of packets of the local MediaStreamTrack's media sent
 * @property {AudioLevel} [audioInputLevel] - The {@link AudioLevel} of the local audio MediaStreamTrack
 * @property {AudioLevel} [audioOutputLevel] - The {@link AudioLevel} of the remote video MediaStreamTrack
 */

module.exports = getStats;

},{"./util":149,"./util/sdp":151}],135:[function(require,module,exports){
/* globals navigator */
'use strict';

/**
 * This function is very similar to <code>navigator.mediaDevices.getUserMedia</code>
 * except that if no MediaStreamConstraints are provided, then bot audio and video
 * are requested.
 * @function getUserMedia
 * @param {MediaStreamConstraints} [constraints={audio:true,video:true}] - the
 *   MediaStreamConstraints object specifying what kind of MediaStream to
 *   request from the browser (by default both audio and video)
 * @returns Promise<MediaStream>
 */
function getUserMedia(constraints) {
  if (typeof navigator === 'object'
    && typeof navigator.mediaDevices === 'object'
    && typeof navigator.mediaDevices.getUserMedia === 'function') {
    constraints = constraints || { audio: true, video: true };
    return navigator.mediaDevices.getUserMedia(constraints);
  }
  return Promise.reject(new Error('getUserMedia is not supported'));
}

module.exports = getUserMedia;

},{}],136:[function(require,module,exports){
'use strict';

var WebRTC = {};

Object.defineProperties(WebRTC, {
  getStats: {
    enumerable: true,
    value: require('./getstats')
  },
  getUserMedia: {
    enumerable: true,
    value: require('./getusermedia')
  },
  MediaStream: {
    enumerable: true,
    value: require('./mediastream')
  },
  MediaStreamTrack: {
    enumerable: true,
    value: require('./mediastreamtrack')
  },
  RTCIceCandidate: {
    enumerable: true,
    value: require('./rtcicecandidate')
  },
  RTCPeerConnection: {
    enumerable: true,
    value: require('./rtcpeerconnection')
  },
  RTCSessionDescription: {
    enumerable: true,
    value: require('./rtcsessiondescription')
  },
  version: {
    enumerable: true,
    value: require('../package.json').version
  }
});

module.exports = WebRTC;

},{"../package.json":152,"./getstats":134,"./getusermedia":135,"./mediastream":137,"./mediastreamtrack":138,"./rtcicecandidate":139,"./rtcpeerconnection":142,"./rtcsessiondescription":147}],137:[function(require,module,exports){
/* globals MediaStream */
'use strict';

if (typeof MediaStream === 'function') {
  module.exports = MediaStream;
} else {
  module.exports = function MediaStream() {
    throw new Error('MediaStream is not supported');
  };
}

},{}],138:[function(require,module,exports){
/* global MediaStreamTrack */
'use strict';

if (typeof MediaStreamTrack === 'function') {
  module.exports = MediaStreamTrack;
} else {
  module.exports = function MediaStreamTrack() {
    throw new Error('MediaStreamTrack is not supported');
  };
}

},{}],139:[function(require,module,exports){
/* global RTCIceCandidate */
'use strict';

if (typeof RTCIceCandidate === 'function') {
  module.exports = RTCIceCandidate;
} else {
  module.exports = function RTCIceCandidate() {
    throw new Error('RTCIceCandidate is not supported');
  };
}

},{}],140:[function(require,module,exports){
/* globals RTCDataChannel, RTCPeerConnection, RTCSessionDescription */
'use strict';

var ChromeRTCSessionDescription = require('../rtcsessiondescription/chrome');
var EventTarget = require('../util/eventtarget');
var inherits = require('util').inherits;
var Latch = require('../util/latch');
var MediaStream = require('../mediastream');
var RTCRtpSenderShim = require('../rtcrtpsender');
var sdpUtils = require('../util/sdp');
var util = require('../util');

// NOTE(mroberts): This class wraps Chrome's RTCPeerConnection implementation.
// It provides some functionality not currently present in Chrome, namely the
// abilities to
//
//   1. Rollback, per the workaround suggested here:
//      https://bugs.chromium.org/p/webrtc/issues/detail?id=5738#c3
//
//   2. Listen for track events, per the adapter.js workaround.
//
//   3. Set iceTransportPolicy.
//
function ChromeRTCPeerConnection(configuration, constraints) {
  if (!(this instanceof ChromeRTCPeerConnection)) {
    return new ChromeRTCPeerConnection(configuration, constraints);
  }

  EventTarget.call(this);

  configuration = configuration || {};
  var newConfiguration = Object.assign(configuration.iceTransportPolicy
    ? { iceTransports: configuration.iceTransportPolicy }
    : {}, configuration);

  util.interceptEvent(this, 'datachannel');
  util.interceptEvent(this, 'signalingstatechange');

  var sdpFormat = sdpUtils.getSdpFormat(newConfiguration.sdpSemantics);
  var peerConnection = new RTCPeerConnection(newConfiguration, constraints);

  Object.defineProperties(this, {
    _appliedTracksToSSRCs: {
      value: new Map(),
      writable: true
    },
    _localStream: {
      value: new MediaStream()
    },
    _peerConnection: {
      value: peerConnection
    },
    _pendingLocalOffer: {
      value: null,
      writable: true
    },
    _pendingRemoteOffer: {
      value: null,
      writable: true
    },
    _rolledBackTracksToSSRCs: {
      value: new Map(),
      writable: true
    },
    _sdpFormat: {
      value: sdpFormat
    },
    _senders: {
      value: new Map()
    },
    _signalingStateLatch: {
      value: new Latch()
    },
    _tracksToSSRCs: {
      value: new Map(),
      writable: true
    },
    localDescription: {
      enumerable: true,
      get: function() {
        return this._pendingLocalOffer ? this._pendingLocalOffer : peerConnection.localDescription;
      }
    },
    remoteDescription: {
      enumerable: true,
      get: function() {
        return this._pendingRemoteOffer ? this._pendingRemoteOffer : peerConnection.remoteDescription;
      }
    },
    signalingState: {
      enumerable: true,
      get: function() {
        if (this._pendingLocalOffer) {
          return 'have-local-offer';
        } else if (this._pendingRemoteOffer) {
          return 'have-remote-offer';
        }
        return peerConnection.signalingState;
      }
    }
  });

  var self = this;

  peerConnection.addEventListener('datachannel', function ondatachannel(event) {
    shimDataChannel(event.channel);
    self.dispatchEvent(event);
  });

  peerConnection.addEventListener('signalingstatechange', function onsignalingstatechange() {
    if (peerConnection.signalingState === 'stable') {
      self._appliedTracksToSSRCs = new Map(self._tracksToSSRCs);
    }
    if (!self._pendingLocalOffer && !self._pendingRemoteOffer) {
      self.dispatchEvent.apply(self, arguments);
    }
  });

  peerConnection.ontrack = function ontrack() {
    // NOTE(mroberts): adapter.js's "track" event shim only kicks off if we set
    // the ontrack property of the RTCPeerConnection.
  };

  if (typeof RTCPeerConnection.prototype.addTrack !== 'function') {
    peerConnection.addStream(this._localStream);
  }
  util.proxyProperties(RTCPeerConnection.prototype, this, peerConnection);
}

inherits(ChromeRTCPeerConnection, EventTarget);

if (typeof RTCPeerConnection.prototype.addTrack !== 'function') {
  // NOTE(mmalavalli): This shim supports our limited case of adding
  // all MediaStreamTracks to one MediaStream. It has been implemented this
  // keeping in mind that this is to be maintained only until "addTrack" is
  // supported natively in Chrome.
  ChromeRTCPeerConnection.prototype.addTrack = function addTrack() {
    var args = [].slice.call(arguments);
    var track = args[0];
    if (this._peerConnection.signalingState === 'closed') {
      throw new Error('Cannot add MediaStreamTrack [' + track.id + ', '
        + track.kind + ']: RTCPeerConnection is closed');
    }

    var sender = this._senders.get(track);
    if (sender && sender.track) {
      throw new Error('Cannot add MediaStreamTrack [' + track.id + ', '
        + track.kind + ']: RTCPeerConnection already has it');
    }
    this._peerConnection.removeStream(this._localStream);
    this._localStream.addTrack(track);
    this._peerConnection.addStream(this._localStream);

    sender = new RTCRtpSenderShim(track);
    this._senders.set(track, sender);
    return sender;
  };

  // NOTE(mmalavalli): This shim supports our limited case of removing
  // MediaStreamTracks from one MediaStream. It has been implemented this
  // keeping in mind that this is to be maintained only until "removeTrack" is
  // supported natively in Chrome.
  ChromeRTCPeerConnection.prototype.removeTrack = function removeTrack(sender) {
    if (this._peerConnection.signalingState === 'closed') {
      throw new Error('Cannot remove MediaStreamTrack: RTCPeerConnection is closed');
    }

    var track = sender.track;
    if (!track) {
      return;
    }
    sender = this._senders.get(track);
    if (sender && sender.track) {
      sender.track = null;
      this._peerConnection.removeStream(this._localStream);
      this._localStream.removeTrack(track);
      this._peerConnection.addStream(this._localStream);
    }
  };

  ChromeRTCPeerConnection.prototype.getSenders = function getSenders() {
    return Array.from(this._senders.values());
  };
} else {
  ChromeRTCPeerConnection.prototype.removeTrack = function removeTrack(sender) {
    if (this._peerConnection.signalingState === 'closed') {
      throw new Error('Cannot remove MediaStreamTrack: RTCPeerConnection is closed');
    }
    try {
      this._peerConnection.removeTrack(sender);
    } catch (e) {
      // NOTE(mhuynh): Do nothing. In Chrome, will throw if a 'sender was not
      // created by this peer connection'. This behavior does not seem to be
      // spec compliant, so a temporary shim is introduced. A bug has been filed,
      // and is tracked here:
      // https://bugs.chromium.org/p/chromium/issues/detail?id=860853
    }
  };
}

ChromeRTCPeerConnection.prototype.addIceCandidate = function addIceCandidate(candidate) {
  var args = [].slice.call(arguments);
  var promise;
  var self = this;

  if (this.signalingState === 'have-remote-offer') {
    // NOTE(mroberts): Because the ChromeRTCPeerConnection simulates the
    // "have-remote-offer" signalingStates, we only want to invoke the true
    // addIceCandidates method when the remote description has been applied.
    promise = this._signalingStateLatch.when('low').then(function signalingStatesResolved() {
      return self._peerConnection.addIceCandidate(candidate);
    });
  } else {
    promise = this._peerConnection.addIceCandidate(candidate);
  }

  return args.length > 1
    ? util.legacyPromise(promise, args[1], args[2])
    : promise;
};

// NOTE(mroberts): The WebRTC spec does not specify that close should throw an
// Error; however, in Chrome it does. We workaround this by checking the
// signalingState manually.
ChromeRTCPeerConnection.prototype.close = function close() {
  if (this.signalingState !== 'closed') {
    this._pendingLocalOffer = null;
    this._pendingRemoteOffer = null;
    this._peerConnection.close();
  }
};

// NOTE(mroberts): Because we workaround Chrome's lack of rollback support by
// "faking" setRemoteDescription, we cannot create an answer until we actually
// apply the remote description. This means, once you call createAnswer, you
// can no longer rollback. This is acceptable for our use case because we will
// apply the newly-created answer almost immediately; however, this may be
// unacceptable for other use cases.
ChromeRTCPeerConnection.prototype.createAnswer = function createAnswer() {
  var args = [].slice.call(arguments);
  var promise;
  var self = this;

  if (this._pendingRemoteOffer) {
    promise = this._peerConnection.setRemoteDescription(this._pendingRemoteOffer).then(function setRemoteDescriptionSucceeded() {
      // NOTE(mroberts): The signalingStates between the ChromeRTCPeerConnection
      // and the underlying RTCPeerConnection implementation have converged. We
      // can unblock any pending calls to addIceCandidate now.
      self._signalingStateLatch.lower();
      return self._peerConnection.createAnswer();
    }).then(function createAnswerSucceeded(answer) {
      self._pendingRemoteOffer = null;

      // NOTE(mmalavalli): If createAnswer() is called immediately after rolling back, then we no
      // longer need to retain the rolled back tracks to SSRCs Map.
      self._rolledBackTracksToSSRCs.clear();

      return new ChromeRTCSessionDescription({
        type: 'answer',
        sdp: updateTrackIdsToSSRCs(self._sdpFormat, self._tracksToSSRCs, answer.sdp)
      });
    }, function setRemoteDescriptionOrCreateAnswerFailed(error) {
      self._pendingRemoteOffer = null;
      throw error;
    });
  } else {
    promise = this._peerConnection.createAnswer().then(function(answer) {
      // NOTE(mmalavalli): If createAnswer() is called immediately after rolling back, then we no
      // longer need to retain the rolled back tracks to SSRCs Map.
      self._rolledBackTracksToSSRCs.clear();

      return new ChromeRTCSessionDescription({
        type: 'answer',
        sdp: updateTrackIdsToSSRCs(self._sdpFormat, self._tracksToSSRCs, answer.sdp)
      });
    });
  }

  return args.length > 1
    ? util.legacyPromise(promise, args[0], args[1])
    : promise;
};

ChromeRTCPeerConnection.prototype.createOffer = function createOffer() {
  var args = [].slice.call(arguments);
  var options = (args.length > 1 ? args[2] : args[0]) || {};
  var self = this;

  var promise = this._peerConnection.createOffer(options).then(function(offer) {
    // NOTE(mmalavalli): If createOffer() is called immediately after rolling back, then we no
    // longer need to retain the rolled back tracks to SSRCs Map.
    self._rolledBackTracksToSSRCs.clear();

    return new ChromeRTCSessionDescription({
      type: offer.type,
      sdp: updateTrackIdsToSSRCs(self._sdpFormat, self._tracksToSSRCs, offer.sdp)
    });
  });

  return args.length > 1
    ? util.legacyPromise(promise, args[0], args[1])
    : promise;
};

ChromeRTCPeerConnection.prototype.createDataChannel = function createDataChannel(label, dataChannelDict) {
  dataChannelDict = shimDataChannelInit(dataChannelDict);
  var dataChannel = this._peerConnection.createDataChannel(label, dataChannelDict);
  shimDataChannel(dataChannel);
  return dataChannel;
};

ChromeRTCPeerConnection.prototype.setLocalDescription = function setLocalDescription() {
  var args = [].slice.call(arguments);
  var description = args[0];

  // NOTE(mmalavalli): If setLocalDescription() is called immediately after rolling back,
  // then we need to restore the rolled back tracks to SSRCs Map.
  if (this._rolledBackTracksToSSRCs.size > 0) {
    this._tracksToSSRCs = new Map(this._rolledBackTracksToSSRCs);
    this._rolledBackTracksToSSRCs.clear();
  }

  var promise = setDescription(this, true, description);
  return args.length > 1
    ? util.legacyPromise(promise, args[1], args[2])
    : promise;
};

ChromeRTCPeerConnection.prototype.setRemoteDescription = function setRemoteDescription() {
  var args = [].slice.call(arguments);
  var description = args[0];

  // NOTE(mmalavalli): If setRemoteDescription() is called immediately after rolling back,
  // then we no longer need to retain the rolled back tracks to SSRCs Map.
  this._rolledBackTracksToSSRCs.clear();

  var promise = setDescription(this, false, description);
  return args.length > 1
    ? util.legacyPromise(promise, args[1], args[2])
    : promise;
};

util.delegateMethods(
  RTCPeerConnection.prototype,
  ChromeRTCPeerConnection.prototype,
  '_peerConnection');

// NOTE(mroberts): We workaround Chrome's lack of rollback support, per the
// workaround suggested here: https://bugs.chromium.org/p/webrtc/issues/detail?id=5738#c3
// Namely, we "fake" setting the local or remote description and instead buffer
// it. If we receive or create an answer, then we will actually apply the
// description. Until we receive or create an answer, we will be able to
// "rollback" by simply discarding the buffer description.
function setDescription(peerConnection, local, description) {
  function setPendingLocalOffer(offer) {
    if (local) {
      peerConnection._pendingLocalOffer = offer;
    } else {
      peerConnection._pendingRemoteOffer = offer;
    }
  }

  function clearPendingLocalOffer() {
    if (local) {
      peerConnection._pendingLocalOffer = null;
    } else {
      peerConnection._pendingRemoteOffer = null;
    }
  }

  var pendingLocalOffer = local ? peerConnection._pendingLocalOffer : peerConnection._pendingRemoteOffer;
  var pendingRemoteOffer = local ? peerConnection._pendingRemoteOffer : peerConnection._pendingLocalOffer;
  var intermediateState = local ? 'have-local-offer' : 'have-remote-offer';
  var setLocalDescription = local ? 'setLocalDescription' : 'setRemoteDescription';
  var promise;

  if (!local && pendingRemoteOffer && description.type === 'answer') {
    promise = setRemoteAnswer(peerConnection, description);
  } else if (description.type === 'offer') {
    if (peerConnection.signalingState !== intermediateState && peerConnection.signalingState !== 'stable') {
      // NOTE(mroberts): Error message copied from Firefox.
      return Promise.reject(new Error('Cannot set ' + (local ? 'local' : 'remote') +
        ' offer in state ' + peerConnection.signalingState));
    }

    // We need to save this local offer in case of a rollback. We also need to
    // check to see if the signalingState between the ChromeRTCPeerConnection
    // and the underlying RTCPeerConnection implementation are about to diverge.
    // If so, we need to ensure subsequent calls to addIceCandidate will block.
    if (!pendingLocalOffer && peerConnection._signalingStateLatch.state === 'low') {
      peerConnection._signalingStateLatch.raise();
    }
    var previousSignalingState = peerConnection.signalingState;
    setPendingLocalOffer(unwrap(description));
    promise = Promise.resolve();

    // Only dispatch a signalingstatechange event if we transitioned.
    if (peerConnection.signalingState !== previousSignalingState) {
      promise.then(function dispatchSignalingStateChangeEvent() {
        peerConnection.dispatchEvent(new Event('signalingstatechange'));
      });
    }

  } else if (description.type === 'rollback') {
    if (peerConnection.signalingState !== intermediateState) {
      // NOTE(mroberts): Error message copied from Firefox.
      promise = Promise.reject(new Error('Cannot rollback ' +
        (local ? 'local' : 'remote') + ' description in ' + peerConnection.signalingState));
    } else {
      // Reset the pending offer.
      clearPendingLocalOffer();

      // NOTE(mmalavalli): We store the rolled back tracks to SSRCs Map here in case
      // setLocalDescription() is called immediately after a rollback (without calling
      // createOffer() or createAnswer()), in which case this roll back is not due to a
      // glare scenario and this Map should be restored.
      peerConnection._rolledBackTracksToSSRCs = new Map(peerConnection._tracksToSSRCs);
      peerConnection._tracksToSSRCs = new Map(peerConnection._appliedTracksToSSRCs);

      promise = Promise.resolve();
      promise.then(function dispatchSignalingStateChangeEvent() {
        peerConnection.dispatchEvent(new Event('signalingstatechange'));
      });
    }
  }

  return promise || peerConnection._peerConnection[setLocalDescription](unwrap(description));
}

function setRemoteAnswer(peerConnection, answer) {
  // Apply the pending local offer.
  var pendingLocalOffer = peerConnection._pendingLocalOffer;
  return peerConnection._peerConnection.setLocalDescription(pendingLocalOffer).then(function setLocalOfferSucceeded() {
    peerConnection._pendingLocalOffer = null;
    return peerConnection.setRemoteDescription(answer);
  }).then(function setRemoteAnswerSucceeded() {
    // NOTE(mroberts): The signalingStates between the ChromeRTCPeerConnection
    // and the underlying RTCPeerConnection implementation have converged. We
    // can unblock any pending calls to addIceCandidate now.
    peerConnection._signalingStateLatch.lower();
  });
}

function unwrap(description) {
  if (description instanceof ChromeRTCSessionDescription) {
    if (description._description) {
      return description._description;
    }
  }
  return new RTCSessionDescription(description);
}

/**
 * Check whether or not we need to apply our maxPacketLifeTime shim. We are
 * pretty conservative: we'll only apply it if the legacy maxRetransmitTime
 * property is available _and_ the standard maxPacketLifeTime property is _not_
 * available (the thinking being that Chrome will land the standards-compliant
 * property).
 * @returns {boolean}
 */
function needsMaxPacketLifeTimeShim() {
  return 'maxRetransmitTime' in RTCDataChannel.prototype
    && !('maxPacketLifeTime' in RTCDataChannel.prototype);
}

/**
 * Shim an RTCDataChannelInit dictionary (if necessary). This function returns
 * a copy of the original RTCDataChannelInit.
 * @param {RTCDataChannelInit} dataChannelDict
 * @returns {RTCDataChannelInit}
 */
function shimDataChannelInit(dataChannelDict) {
  dataChannelDict = Object.assign({}, dataChannelDict);
  if (needsMaxPacketLifeTimeShim() && 'maxPacketLifeTime' in dataChannelDict) {
    dataChannelDict.maxRetransmitTime = dataChannelDict.maxPacketLifeTime;
  }
  return dataChannelDict;
}

/**
 * Shim an RTCDataChannel (if necessary). This function mutates the
 * RTCDataChannel.
 * @param {RTCDataChannel} dataChannel
 * @returns {RTCDataChannel}
 */
function shimDataChannel(dataChannel) {
  Object.defineProperty(dataChannel, 'maxRetransmits', {
    value: dataChannel.maxRetransmits === 65535
      ? null
      : dataChannel.maxRetransmits
  });
  if (needsMaxPacketLifeTimeShim()) {
    // NOTE(mroberts): We can rename `maxRetransmitTime` to `maxPacketLifeTime`.
    //
    //   https://bugs.chromium.org/p/chromium/issues/detail?id=696681
    //
    Object.defineProperty(dataChannel, 'maxPacketLifeTime', {
      value: dataChannel.maxRetransmitTime === 65535
        ? null
        : dataChannel.maxRetransmitTime
    });
  }
  return dataChannel;
}

/**
 * Update the mappings from MediaStreamTrack IDs to SSRCs as indicated by both
 * the Map from MediaStreamTrack IDs to SSRCs and the SDP itself. This method
 * ensures that SSRCs never change once announced.
 * @param {'planb'|'unified'} sdpFormat
 * @param {Map<string, Set<string>>} tracksToSSRCs
 * @param {string} sdp - an SDP whose format is determined by `sdpSemantics`
 * @returns {string} updatedSdp - updated SDP
 */
function updateTrackIdsToSSRCs(sdpFormat, tracksToSSRCs, sdp) {
  return sdpFormat === 'unified'
    ? sdpUtils.updateUnifiedPlanTrackIdsToSSRCs(tracksToSSRCs, sdp)
    : sdpUtils.updatePlanBTrackIdsToSSRCs(tracksToSSRCs, sdp);
}

module.exports = ChromeRTCPeerConnection;

},{"../mediastream":137,"../rtcrtpsender":144,"../rtcsessiondescription/chrome":145,"../util":149,"../util/eventtarget":148,"../util/latch":150,"../util/sdp":151,"util":182}],141:[function(require,module,exports){
/* globals RTCPeerConnection */
'use strict';

var EventTarget = require('../util/eventtarget');
var FirefoxRTCSessionDescription = require('../rtcsessiondescription/firefox');
var inherits = require('util').inherits;
var updateTracksToSSRCs = require('../util/sdp').updateUnifiedPlanTrackIdsToSSRCs;
var util = require('../util');

// NOTE(mroberts): This is a short-lived workaround. Checking the user agent
// string might not fix every affected Firefox instance, but it should be good
// enough for this bug.
var needsWorkaroundForBug1480277 = typeof navigator === 'object'
  && navigator.userAgent
  && (navigator.userAgent.match(/Firefox\/61/) || navigator.userAgent.match(/Firefox\/62/));

// NOTE(mroberts): This class wraps Firefox's RTCPeerConnection implementation.
// It provides some functionality not currently present in Firefox, namely the
// abilities to
//
//   1. Call setLocalDescription and setRemoteDescription with new offers in
//      signalingStates "have-local-offer" and "have-remote-offer",
//      respectively.
//
//   2. The ability to call createOffer in signalingState "have-local-offer".
//
// Both of these are implemented using rollbacks to workaround the following
// bug:
//
//   https://bugzilla.mozilla.org/show_bug.cgi?id=1072388
//
// We also provide a workaround for a bug where Firefox may change the
// previously-negotiated DTLS role in an answer, which breaks Chrome:
//
//     https://bugzilla.mozilla.org/show_bug.cgi?id=1240897
//
function FirefoxRTCPeerConnection(configuration) {
  if (!(this instanceof FirefoxRTCPeerConnection)) {
    return new FirefoxRTCPeerConnection(configuration);
  }

  EventTarget.call(this);

  util.interceptEvent(this, 'signalingstatechange');

  /* eslint new-cap:0 */
  var peerConnection = new RTCPeerConnection(configuration);

  Object.defineProperties(this, {
    _initiallyNegotiatedDtlsRole: {
      value: null,
      writable: true
    },
    _isClosed: {
      value: false,
      writable: true
    },
    _peerConnection: {
      value: peerConnection
    },
    _rollingBack: {
      value: false,
      writable: true
    },
    _tracksToSSRCs: {
      value: new Map()
    },
    iceGatheringState: {
      enumerable: true,
      get: function() {
        return this._isClosed ? 'complete' : this._peerConnection.iceGatheringState;
      }
    },
    localDescription: {
      enumerable: true,
      get: function() {
        return overwriteWithInitiallyNegotiatedDtlsRole(this._peerConnection.localDescription, this._initiallyNegotiatedDtlsRole);
      }
    },
    signalingState: {
      enumerable: true,
      get: function() {
        return this._isClosed ? 'closed' : this._peerConnection.signalingState;
      }
    }
  });

  var self = this;
  var previousSignalingState;

  peerConnection.addEventListener('signalingstatechange', function onsignalingstatechange() {
    if (!self._rollingBack && self.signalingState !== previousSignalingState) {
      previousSignalingState = self.signalingState;

      // NOTE(mmalavalli): In Firefox, 'signalingstatechange' event is
      // triggered synchronously in the same tick after
      // RTCPeerConnection#close() is called. So we mimic Chrome's behavior
      // by triggering 'signalingstatechange' on the next tick.
      var dispatchEventToSelf = self.dispatchEvent.apply.bind(self.dispatchEvent, self, arguments);
      if (self._isClosed) {
        setTimeout(dispatchEventToSelf);
      } else {
        dispatchEventToSelf();
      }
    }
  });

  util.proxyProperties(RTCPeerConnection.prototype, this, peerConnection);
}

inherits(FirefoxRTCPeerConnection, EventTarget);

// NOTE(mmalavalli): Firefox throws a TypeError when the PeerConnection's
// prototype's "peerIdentity" property is accessed. In order to overcome
// this, we ignore this property while delegating methods.
// Reference: https://bugzilla.mozilla.org/show_bug.cgi?id=1363815
Object.defineProperty(FirefoxRTCPeerConnection.prototype, 'peerIdentity', {
  enumerable: true,
  value: Promise.resolve({
    idp: '',
    name: ''
  })
});

if (needsWorkaroundForBug1480277) {
  FirefoxRTCPeerConnection.prototype.addTrack = function addTrack() {
    var track = arguments[0];
    var sender = this._peerConnection.addTrack.apply(this._peerConnection, arguments);
    sender.replaceTrack(track);
    return sender;
  };
}

FirefoxRTCPeerConnection.prototype.createAnswer = function createAnswer() {
  var args = [].slice.call(arguments);
  var promise;
  var self = this;

  promise = this._peerConnection.createAnswer().then(function createAnswerSucceeded(answer) {
    saveInitiallyNegotiatedDtlsRole(self, answer);
    return overwriteWithInitiallyNegotiatedDtlsRole(answer, self._initiallyNegotiatedDtlsRole);
  });

  return typeof args[0] === 'function'
    ? util.legacyPromise(promise, args[0], args[1])
    : promise;
};

// NOTE(mroberts): The WebRTC spec allows you to call createOffer from any
// signalingState other than "closed"; however, Firefox has not yet implemented
// this (https://bugzilla.mozilla.org/show_bug.cgi?id=1072388). We workaround
// this by rolling back if we are in state "have-local-offer" or
// "have-remote-offer". This is acceptable for our use case because we will
// apply the newly-created offer almost immediately; however, this may be
// unacceptable for other use cases.
FirefoxRTCPeerConnection.prototype.createOffer = function createOffer() {
  var args = [].slice.call(arguments);
  var options = (args.length > 1 ? args[2] : args[0]) || {};
  var promise;
  var self = this;

  if (this.signalingState === 'have-local-offer' ||
      this.signalingState === 'have-remote-offer') {
    var local = this.signalingState === 'have-local-offer';
    promise = rollback(this, local, function rollbackSucceeded() {
      return self.createOffer(options);
    });
  } else {
    promise = self._peerConnection.createOffer(options);
  }

  promise = promise.then(function(offer) {
    return new FirefoxRTCSessionDescription({
      type: offer.type,
      sdp: updateTracksToSSRCs(self._tracksToSSRCs, offer.sdp)
    });
  });

  return args.length > 1
    ? util.legacyPromise(promise, args[0], args[1])
    : promise;
};

// NOTE(mroberts): While Firefox will reject the Prom