'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var DataTrackTransceiver = require('./transceiver');
var makeUUID = require('../util').makeUUID;

/**
 * A {@link DataTrackSender} represents a {@link DataTrackTransceiver} over
 * which data can be sent. Internally, it uses a collection of RTCDataChannels
 * to send data.
 * @extends DataTrackTransceiver
 */

var DataTrackSender = function (_DataTrackTransceiver) {
  _inherits(DataTrackSender, _DataTrackTransceiver);

  /**
   * Construct a {@link DataTrackSender}.
   * @param {?number} maxPacketLifeTime
   * @param {?number} maxRetransmits
   * @param {boolean} ordered
   */
  function DataTrackSender(maxPacketLifeTime, maxRetransmtis, ordered) {
    _classCallCheck(this, DataTrackSender);

    var _this = _possibleConstructorReturn(this, (DataTrackSender.__proto__ || Object.getPrototypeOf(DataTrackSender)).call(this, makeUUID(), maxPacketLifeTime, maxRetransmtis, ordered));

    Object.defineProperties(_this, {
      _clones: {
        value: new Set()
      },
      _dataChannels: {
        value: new Set()
      }
    });
    return _this;
  }

  /**
   * Add a cloned {@link DataTrackSender}.
   * @private
   * @returns {void}
   */


  _createClass(DataTrackSender, [{
    key: '_addClone',
    value: function _addClone(clone) {
      this._clones.add(clone);
    }

    /**
     * Remove a cloned {@link DataTrackSender}.
     * @returns {void}
     */

  }, {
    key: 'removeClone',
    value: function removeClone(clone) {
      this._clones.delete(clone);
    }

    /**
     * Add an RTCDataChannel to the {@link DataTrackSender}.
     * @param {RTCDataChannel} dataChannel
     * @returns {this}
     */

  }, {
    key: 'addDataChannel',
    value: function addDataChannel(dataChannel) {
      this._dataChannels.add(dataChannel);
      return this;
    }

    /**
     * Return a new {@link DataTrackSender}. Any message sent over this
     * {@link DataTrackSender} will also be sent over the clone. Whenever this
     * {@link DataTrackSender} is stopped, so to will the clone.
     * @returns {DataTrackSender}
     */

  }, {
    key: 'clone',
    value: function clone() {
      var _this2 = this;

      var clone = new DataTrackSender(this.maxPacketLifeTime, this.maxRetransmits, this.ordered);
      this._addClone(clone);
      clone.once('stopped', function () {
        return _this2.removeClone(clone);
      });
      return clone;
    }

    /**
     * Remove an RTCDataChannel from the {@link DataTrackSender}.
     * @param {RTCDataChannel} dataChannel
     * @returns {this}
     */

  }, {
    key: 'removeDataChannel',
    value: function removeDataChannel(dataChannel) {
      this._dataChannels.delete(dataChannel);
      return this;
    }

    /**
     * Send data over the {@link DataTrackSender}. Internally, this calls
     * <code>send</code> over each of the underlying RTCDataChannels.
     * @param {string|Blob|ArrayBuffer|ArrayBufferView} data
     * @returns {this}
     */

  }, {
    key: 'send',
    value: function send(data) {
      this._dataChannels.forEach(function (dataChannel) {
        try {
          dataChannel.send(data);
        } catch (error) {
          // Do nothing.
        }
      });
      this._clones.forEach(function (clone) {
        try {
          clone.send(data);
        } catch (error) {
          // Do nothing.
        }
      });
      return this;
    }
  }, {
    key: 'stop',
    value: function stop() {
      this._dataChannels.forEach(function (dataChannel) {
        return dataChannel.close();
      });
      this._clones.forEach(function (clone) {
        return clone.stop();
      });
      _get(DataTrackSender.prototype.__proto__ || Object.getPrototypeOf(DataTrackSender.prototype), 'stop', this).call(this);
    }
  }]);

  return DataTrackSender;
}(DataTrackTransceiver);

module.exports = DataTrackSender;