// NOTE: Do not edit this file. This code is auto-generated. Contact the
// Twilio SDK Team for more information.

'use strict';

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var TwilioError = require('./twilioerror');
var TwilioErrorByCode = {};

/**
 * Create a {@link TwilioError} for a given code and message.
 * @private
 * @param {number} [code] - Error code
 * @param {string} [message] - Error message
 * @returns {TwilioError}
 */
exports.createTwilioError = function createTwilioError(code, message) {
  code = typeof code === 'number' ? code : 0;
  message = typeof message === 'string' && message ? message : 'Unknown error';
  return TwilioErrorByCode[code] ? new TwilioErrorByCode[code]() : new TwilioError(code, message);
};

/**
 * @class AccessTokenInvalidError
 * @classdesc Raised whenever the AccessToken used for connecting to a Room is invalid.
 * @extends TwilioError
 * @property {number} code - 20101
 * @property {string} message - 'Invalid Access Token'
 */

var AccessTokenInvalidError = function (_TwilioError) {
  _inherits(AccessTokenInvalidError, _TwilioError);

  function AccessTokenInvalidError() {
    _classCallCheck(this, AccessTokenInvalidError);

    return _possibleConstructorReturn(this, (AccessTokenInvalidError.__proto__ || Object.getPrototypeOf(AccessTokenInvalidError)).call(this, 20101, 'Invalid Access Token'));
  }

  return AccessTokenInvalidError;
}(TwilioError);

exports.AccessTokenInvalidError = AccessTokenInvalidError;
Object.defineProperty(TwilioErrorByCode, 20101, { value: AccessTokenInvalidError });

/**
 * @class AccessTokenHeaderInvalidError
 * @classdesc Raised whenever the AccessToken used for connecting to a Room has an invalid header.
 * @extends TwilioError
 * @property {number} code - 20102
 * @property {string} message - 'Invalid Access Token header'
 */

var AccessTokenHeaderInvalidError = function (_TwilioError2) {
  _inherits(AccessTokenHeaderInvalidError, _TwilioError2);

  function AccessTokenHeaderInvalidError() {
    _classCallCheck(this, AccessTokenHeaderInvalidError);

    return _possibleConstructorReturn(this, (AccessTokenHeaderInvalidError.__proto__ || Object.getPrototypeOf(AccessTokenHeaderInvalidError)).call(this, 20102, 'Invalid Access Token header'));
  }

  return AccessTokenHeaderInvalidError;
}(TwilioError);

exports.AccessTokenHeaderInvalidError = AccessTokenHeaderInvalidError;
Object.defineProperty(TwilioErrorByCode, 20102, { value: AccessTokenHeaderInvalidError });

/**
 * @class AccessTokenIssuerInvalidError
 * @classdesc Raised whenever the AccessToken used for connecting to a Room contains an invalid issuer or subject.
 * @extends TwilioError
 * @property {number} code - 20103
 * @property {string} message - 'Invalid Access Token issuer/subject'
 */

var AccessTokenIssuerInvalidError = function (_TwilioError3) {
  _inherits(AccessTokenIssuerInvalidError, _TwilioError3);

  function AccessTokenIssuerInvalidError() {
    _classCallCheck(this, AccessTokenIssuerInvalidError);

    return _possibleConstructorReturn(this, (AccessTokenIssuerInvalidError.__proto__ || Object.getPrototypeOf(AccessTokenIssuerInvalidError)).call(this, 20103, 'Invalid Access Token issuer/subject'));
  }

  return AccessTokenIssuerInvalidError;
}(TwilioError);

exports.AccessTokenIssuerInvalidError = AccessTokenIssuerInvalidError;
Object.defineProperty(TwilioErrorByCode, 20103, { value: AccessTokenIssuerInvalidError });

/**
 * @class AccessTokenExpiredError
 * @classdesc Raised whenever the AccessToken used for connecting, or reconnecting to a Room has expired.
 * @extends TwilioError
 * @property {number} code - 20104
 * @property {string} message - 'Access Token expired or expiration date invalid'
 */

var AccessTokenExpiredError = function (_TwilioError4) {
  _inherits(AccessTokenExpiredError, _TwilioError4);

  function AccessTokenExpiredError() {
    _classCallCheck(this, AccessTokenExpiredError);

    return _possibleConstructorReturn(this, (AccessTokenExpiredError.__proto__ || Object.getPrototypeOf(AccessTokenExpiredError)).call(this, 20104, 'Access Token expired or expiration date invalid'));
  }

  return AccessTokenExpiredError;
}(TwilioError);

exports.AccessTokenExpiredError = AccessTokenExpiredError;
Object.defineProperty(TwilioErrorByCode, 20104, { value: AccessTokenExpiredError });

/**
 * @class AccessTokenNotYetValidError
 * @classdesc Raised whenever the AccessToken used for connecting to a Room is not yet valid.
 * @extends TwilioError
 * @property {number} code - 20105
 * @property {string} message - 'Access Token not yet valid'
 */

var AccessTokenNotYetValidError = function (_TwilioError5) {
  _inherits(AccessTokenNotYetValidError, _TwilioError5);

  function AccessTokenNotYetValidError() {
    _classCallCheck(this, AccessTokenNotYetValidError);

    return _possibleConstructorReturn(this, (AccessTokenNotYetValidError.__proto__ || Object.getPrototypeOf(AccessTokenNotYetValidError)).call(this, 20105, 'Access Token not yet valid'));
  }

  return AccessTokenNotYetValidError;
}(TwilioError);

exports.AccessTokenNotYetValidError = AccessTokenNotYetValidError;
Object.defineProperty(TwilioErrorByCode, 20105, { value: AccessTokenNotYetValidError });

/**
 * @class AccessTokenGrantsInvalidError
 * @classdesc Raised whenever the AccessToken used for connecting to a Room has invalid grants.
 * @extends TwilioError
 * @property {number} code - 20106
 * @property {string} message - 'Invalid Access Token grants'
 */

var AccessTokenGrantsInvalidError = function (_TwilioError6) {
  _inherits(AccessTokenGrantsInvalidError, _TwilioError6);

  function AccessTokenGrantsInvalidError() {
    _classCallCheck(this, AccessTokenGrantsInvalidError);

    return _possibleConstructorReturn(this, (AccessTokenGrantsInvalidError.__proto__ || Object.getPrototypeOf(AccessTokenGrantsInvalidError)).call(this, 20106, 'Invalid Access Token grants'));
  }

  return AccessTokenGrantsInvalidError;
}(TwilioError);

exports.AccessTokenGrantsInvalidError = AccessTokenGrantsInvalidError;
Object.defineProperty(TwilioErrorByCode, 20106, { value: AccessTokenGrantsInvalidError });

/**
 * @class AccessTokenSignatureInvalidError
 * @classdesc Raised whenever the AccessToken used for connecting to a Room has an invalid signature.
 * @extends TwilioError
 * @property {number} code - 20107
 * @property {string} message - 'Invalid Access Token signature'
 */

var AccessTokenSignatureInvalidError = function (_TwilioError7) {
  _inherits(AccessTokenSignatureInvalidError, _TwilioError7);

  function AccessTokenSignatureInvalidError() {
    _classCallCheck(this, AccessTokenSignatureInvalidError);

    return _possibleConstructorReturn(this, (AccessTokenSignatureInvalidError.__proto__ || Object.getPrototypeOf(AccessTokenSignatureInvalidError)).call(this, 20107, 'Invalid Access Token signature'));
  }

  return AccessTokenSignatureInvalidError;
}(TwilioError);

exports.AccessTokenSignatureInvalidError = AccessTokenSignatureInvalidError;
Object.defineProperty(TwilioErrorByCode, 20107, { value: AccessTokenSignatureInvalidError });

/**
 * @class SignalingConnectionError
 * @classdesc Raised whenever a signaling connection error occurs that is not covered by a more specific error code.
 * @extends TwilioError
 * @property {number} code - 53000
 * @property {string} message - 'Signaling connection error'
 */

var SignalingConnectionError = function (_TwilioError8) {
  _inherits(SignalingConnectionError, _TwilioError8);

  function SignalingConnectionError() {
    _classCallCheck(this, SignalingConnectionError);

    return _possibleConstructorReturn(this, (SignalingConnectionError.__proto__ || Object.getPrototypeOf(SignalingConnectionError)).call(this, 53000, 'Signaling connection error'));
  }

  return SignalingConnectionError;
}(TwilioError);

exports.SignalingConnectionError = SignalingConnectionError;
Object.defineProperty(TwilioErrorByCode, 53000, { value: SignalingConnectionError });

/**
 * @class SignalingConnectionDisconnectedError
 * @classdesc Raised whenever the signaling connection is unexpectedly disconnected.
 * @extends TwilioError
 * @property {number} code - 53001
 * @property {string} message - 'Signaling connection disconnected'
 */

var SignalingConnectionDisconnectedError = function (_TwilioError9) {
  _inherits(SignalingConnectionDisconnectedError, _TwilioError9);

  function SignalingConnectionDisconnectedError() {
    _classCallCheck(this, SignalingConnectionDisconnectedError);

    return _possibleConstructorReturn(this, (SignalingConnectionDisconnectedError.__proto__ || Object.getPrototypeOf(SignalingConnectionDisconnectedError)).call(this, 53001, 'Signaling connection disconnected'));
  }

  return SignalingConnectionDisconnectedError;
}(TwilioError);

exports.SignalingConnectionDisconnectedError = SignalingConnectionDisconnectedError;
Object.defineProperty(TwilioErrorByCode, 53001, { value: SignalingConnectionDisconnectedError });

/**
 * @class SignalingConnectionTimeoutError
 * @classdesc Raised when connection liveliness checks fail, or when the signaling session expires.
 * @extends TwilioError
 * @property {number} code - 53002
 * @property {string} message - 'Signaling connection timed out'
 */

var SignalingConnectionTimeoutError = function (_TwilioError10) {
  _inherits(SignalingConnectionTimeoutError, _TwilioError10);

  function SignalingConnectionTimeoutError() {
    _classCallCheck(this, SignalingConnectionTimeoutError);

    return _possibleConstructorReturn(this, (SignalingConnectionTimeoutError.__proto__ || Object.getPrototypeOf(SignalingConnectionTimeoutError)).call(this, 53002, 'Signaling connection timed out'));
  }

  return SignalingConnectionTimeoutError;
}(TwilioError);

exports.SignalingConnectionTimeoutError = SignalingConnectionTimeoutError;
Object.defineProperty(TwilioErrorByCode, 53002, { value: SignalingConnectionTimeoutError });

/**
 * @class SignalingIncomingMessageInvalidError
 * @classdesc Raised whenever the Client receives a message from the Server that the Client cannot handle.
 * @extends TwilioError
 * @property {number} code - 53003
 * @property {string} message - 'Client received an invalid signaling message'
 */

var SignalingIncomingMessageInvalidError = function (_TwilioError11) {
  _inherits(SignalingIncomingMessageInvalidError, _TwilioError11);

  function SignalingIncomingMessageInvalidError() {
    _classCallCheck(this, SignalingIncomingMessageInvalidError);

    return _possibleConstructorReturn(this, (SignalingIncomingMessageInvalidError.__proto__ || Object.getPrototypeOf(SignalingIncomingMessageInvalidError)).call(this, 53003, 'Client received an invalid signaling message'));
  }

  return SignalingIncomingMessageInvalidError;
}(TwilioError);

exports.SignalingIncomingMessageInvalidError = SignalingIncomingMessageInvalidError;
Object.defineProperty(TwilioErrorByCode, 53003, { value: SignalingIncomingMessageInvalidError });

/**
 * @class SignalingOutgoingMessageInvalidError
 * @classdesc Raised whenever the Client sends a message to the Server that the Server cannot handle.
 * @extends TwilioError
 * @property {number} code - 53004
 * @property {string} message - 'Client sent an invalid signaling message'
 */

var SignalingOutgoingMessageInvalidError = function (_TwilioError12) {
  _inherits(SignalingOutgoingMessageInvalidError, _TwilioError12);

  function SignalingOutgoingMessageInvalidError() {
    _classCallCheck(this, SignalingOutgoingMessageInvalidError);

    return _possibleConstructorReturn(this, (SignalingOutgoingMessageInvalidError.__proto__ || Object.getPrototypeOf(SignalingOutgoingMessageInvalidError)).call(this, 53004, 'Client sent an invalid signaling message'));
  }

  return SignalingOutgoingMessageInvalidError;
}(TwilioError);

exports.SignalingOutgoingMessageInvalidError = SignalingOutgoingMessageInvalidError;
Object.defineProperty(TwilioErrorByCode, 53004, { value: SignalingOutgoingMessageInvalidError });

/**
 * @class SignalingServerBusyError
 * @classdesc Raised when the server is too busy to accept new clients.
 * @extends TwilioError
 * @property {number} code - 53006
 * @property {string} message - 'Video server is busy'
 */

var SignalingServerBusyError = function (_TwilioError13) {
  _inherits(SignalingServerBusyError, _TwilioError13);

  function SignalingServerBusyError() {
    _classCallCheck(this, SignalingServerBusyError);

    return _possibleConstructorReturn(this, (SignalingServerBusyError.__proto__ || Object.getPrototypeOf(SignalingServerBusyError)).call(this, 53006, 'Video server is busy'));
  }

  return SignalingServerBusyError;
}(TwilioError);

exports.SignalingServerBusyError = SignalingServerBusyError;
Object.defineProperty(TwilioErrorByCode, 53006, { value: SignalingServerBusyError });

/**
 * @class RoomNameInvalidError
 * @classdesc Raised whenever a Room name is invalid, and the scenario is not covered by a more specific error code.
 * @extends TwilioError
 * @property {number} code - 53100
 * @property {string} message - 'Room name is invalid'
 */

var RoomNameInvalidError = function (_TwilioError14) {
  _inherits(RoomNameInvalidError, _TwilioError14);

  function RoomNameInvalidError() {
    _classCallCheck(this, RoomNameInvalidError);

    return _possibleConstructorReturn(this, (RoomNameInvalidError.__proto__ || Object.getPrototypeOf(RoomNameInvalidError)).call(this, 53100, 'Room name is invalid'));
  }

  return RoomNameInvalidError;
}(TwilioError);

exports.RoomNameInvalidError = RoomNameInvalidError;
Object.defineProperty(TwilioErrorByCode, 53100, { value: RoomNameInvalidError });

/**
 * @class RoomNameTooLongError
 * @classdesc Raised whenever a Room name is too long.
 * @extends TwilioError
 * @property {number} code - 53101
 * @property {string} message - 'Room name is too long'
 */

var RoomNameTooLongError = function (_TwilioError15) {
  _inherits(RoomNameTooLongError, _TwilioError15);

  function RoomNameTooLongError() {
    _classCallCheck(this, RoomNameTooLongError);

    return _possibleConstructorReturn(this, (RoomNameTooLongError.__proto__ || Object.getPrototypeOf(RoomNameTooLongError)).call(this, 53101, 'Room name is too long'));
  }

  return RoomNameTooLongError;
}(TwilioError);

exports.RoomNameTooLongError = RoomNameTooLongError;
Object.defineProperty(TwilioErrorByCode, 53101, { value: RoomNameTooLongError });

/**
 * @class RoomNameCharsInvalidError
 * @classdesc Raised whenever a Room name contains invalid characters.
 * @extends TwilioError
 * @property {number} code - 53102
 * @property {string} message - 'Room name contains invalid characters'
 */

var RoomNameCharsInvalidError = function (_TwilioError16) {
  _inherits(RoomNameCharsInvalidError, _TwilioError16);

  function RoomNameCharsInvalidError() {
    _classCallCheck(this, RoomNameCharsInvalidError);

    return _possibleConstructorReturn(this, (RoomNameCharsInvalidError.__proto__ || Object.getPrototypeOf(RoomNameCharsInvalidError)).call(this, 53102, 'Room name contains invalid characters'));
  }

  return RoomNameCharsInvalidError;
}(TwilioError);

exports.RoomNameCharsInvalidError = RoomNameCharsInvalidError;
Object.defineProperty(TwilioErrorByCode, 53102, { value: RoomNameCharsInvalidError });

/**
 * @class RoomCreateFailedError
 * @classdesc Raised whenever the Server is unable to create a Room.
 * @extends TwilioError
 * @property {number} code - 53103
 * @property {string} message - 'Unable to create Room'
 */

var RoomCreateFailedError = function (_TwilioError17) {
  _inherits(RoomCreateFailedError, _TwilioError17);

  function RoomCreateFailedError() {
    _classCallCheck(this, RoomCreateFailedError);

    return _possibleConstructorReturn(this, (RoomCreateFailedError.__proto__ || Object.getPrototypeOf(RoomCreateFailedError)).call(this, 53103, 'Unable to create Room'));
  }

  return RoomCreateFailedError;
}(TwilioError);

exports.RoomCreateFailedError = RoomCreateFailedError;
Object.defineProperty(TwilioErrorByCode, 53103, { value: RoomCreateFailedError });

/**
 * @class RoomConnectFailedError
 * @classdesc Raised whenever a Client is unable to connect to a Room, and the scenario is not covered by a more specific error code.
 * @extends TwilioError
 * @property {number} code - 53104
 * @property {string} message - 'Unable to connect to Room'
 */

var RoomConnectFailedError = function (_TwilioError18) {
  _inherits(RoomConnectFailedError, _TwilioError18);

  function RoomConnectFailedError() {
    _classCallCheck(this, RoomConnectFailedError);

    return _possibleConstructorReturn(this, (RoomConnectFailedError.__proto__ || Object.getPrototypeOf(RoomConnectFailedError)).call(this, 53104, 'Unable to connect to Room'));
  }

  return RoomConnectFailedError;
}(TwilioError);

exports.RoomConnectFailedError = RoomConnectFailedError;
Object.defineProperty(TwilioErrorByCode, 53104, { value: RoomConnectFailedError });

/**
 * @class RoomMaxParticipantsExceededError
 * @classdesc Raised whenever a Client is unable to connect to a Room because the Room contains too many Participants.
 * @extends TwilioError
 * @property {number} code - 53105
 * @property {string} message - 'Room contains too many Participants'
 */

var RoomMaxParticipantsExceededError = function (_TwilioError19) {
  _inherits(RoomMaxParticipantsExceededError, _TwilioError19);

  function RoomMaxParticipantsExceededError() {
    _classCallCheck(this, RoomMaxParticipantsExceededError);

    return _possibleConstructorReturn(this, (RoomMaxParticipantsExceededError.__proto__ || Object.getPrototypeOf(RoomMaxParticipantsExceededError)).call(this, 53105, 'Room contains too many Participants'));
  }

  return RoomMaxParticipantsExceededError;
}(TwilioError);

exports.RoomMaxParticipantsExceededError = RoomMaxParticipantsExceededError;
Object.defineProperty(TwilioErrorByCode, 53105, { value: RoomMaxParticipantsExceededError });

/**
 * @class RoomNotFoundError
 * @classdesc Raised whenever attempting operation on a non-existent Room.
 * @extends TwilioError
 * @property {number} code - 53106
 * @property {string} message - 'Room not found'
 */

var RoomNotFoundError = function (_TwilioError20) {
  _inherits(RoomNotFoundError, _TwilioError20);

  function RoomNotFoundError() {
    _classCallCheck(this, RoomNotFoundError);

    return _possibleConstructorReturn(this, (RoomNotFoundError.__proto__ || Object.getPrototypeOf(RoomNotFoundError)).call(this, 53106, 'Room not found'));
  }

  return RoomNotFoundError;
}(TwilioError);

exports.RoomNotFoundError = RoomNotFoundError;
Object.defineProperty(TwilioErrorByCode, 53106, { value: RoomNotFoundError });

/**
 * @class RoomMaxParticipantsOutOfRangeError
 * @classdesc Raised in the REST API when MaxParticipants is set out of range.
 * @extends TwilioError
 * @property {number} code - 53107
 * @property {string} message - 'MaxParticipants is out of range'
 */

var RoomMaxParticipantsOutOfRangeError = function (_TwilioError21) {
  _inherits(RoomMaxParticipantsOutOfRangeError, _TwilioError21);

  function RoomMaxParticipantsOutOfRangeError() {
    _classCallCheck(this, RoomMaxParticipantsOutOfRangeError);

    return _possibleConstructorReturn(this, (RoomMaxParticipantsOutOfRangeError.__proto__ || Object.getPrototypeOf(RoomMaxParticipantsOutOfRangeError)).call(this, 53107, 'MaxParticipants is out of range'));
  }

  return RoomMaxParticipantsOutOfRangeError;
}(TwilioError);

exports.RoomMaxParticipantsOutOfRangeError = RoomMaxParticipantsOutOfRangeError;
Object.defineProperty(TwilioErrorByCode, 53107, { value: RoomMaxParticipantsOutOfRangeError });

/**
 * @class RoomTypeInvalidError
 * @classdesc Raised in the REST API when the user attempts to create a Room with an invalid RoomType
 * @extends TwilioError
 * @property {number} code - 53108
 * @property {string} message - 'RoomType is not valid'
 */

var RoomTypeInvalidError = function (_TwilioError22) {
  _inherits(RoomTypeInvalidError, _TwilioError22);

  function RoomTypeInvalidError() {
    _classCallCheck(this, RoomTypeInvalidError);

    return _possibleConstructorReturn(this, (RoomTypeInvalidError.__proto__ || Object.getPrototypeOf(RoomTypeInvalidError)).call(this, 53108, 'RoomType is not valid'));
  }

  return RoomTypeInvalidError;
}(TwilioError);

exports.RoomTypeInvalidError = RoomTypeInvalidError;
Object.defineProperty(TwilioErrorByCode, 53108, { value: RoomTypeInvalidError });

/**
 * @class RoomTimeoutOutOfRangeError
 * @classdesc Raised in the REST API when Timeout is set out of range.
 * @extends TwilioError
 * @property {number} code - 53109
 * @property {string} message - 'Timeout is out of range'
 */

var RoomTimeoutOutOfRangeError = function (_TwilioError23) {
  _inherits(RoomTimeoutOutOfRangeError, _TwilioError23);

  function RoomTimeoutOutOfRangeError() {
    _classCallCheck(this, RoomTimeoutOutOfRangeError);

    return _possibleConstructorReturn(this, (RoomTimeoutOutOfRangeError.__proto__ || Object.getPrototypeOf(RoomTimeoutOutOfRangeError)).call(this, 53109, 'Timeout is out of range'));
  }

  return RoomTimeoutOutOfRangeError;
}(TwilioError);

exports.RoomTimeoutOutOfRangeError = RoomTimeoutOutOfRangeError;
Object.defineProperty(TwilioErrorByCode, 53109, { value: RoomTimeoutOutOfRangeError });

/**
 * @class RoomStatusCallbackMethodInvalidError
 * @classdesc Raised in the REST API when StatusCallbackMethod is set to an invalid value.
 * @extends TwilioError
 * @property {number} code - 53110
 * @property {string} message - 'StatusCallbackMethod is invalid'
 */

var RoomStatusCallbackMethodInvalidError = function (_TwilioError24) {
  _inherits(RoomStatusCallbackMethodInvalidError, _TwilioError24);

  function RoomStatusCallbackMethodInvalidError() {
    _classCallCheck(this, RoomStatusCallbackMethodInvalidError);

    return _possibleConstructorReturn(this, (RoomStatusCallbackMethodInvalidError.__proto__ || Object.getPrototypeOf(RoomStatusCallbackMethodInvalidError)).call(this, 53110, 'StatusCallbackMethod is invalid'));
  }

  return RoomStatusCallbackMethodInvalidError;
}(TwilioError);

exports.RoomStatusCallbackMethodInvalidError = RoomStatusCallbackMethodInvalidError;
Object.defineProperty(TwilioErrorByCode, 53110, { value: RoomStatusCallbackMethodInvalidError });

/**
 * @class RoomStatusCallbackInvalidError
 * @classdesc Raised in the REST API when StatusCallback is not a valid URL or the url is too long.
 * @extends TwilioError
 * @property {number} code - 53111
 * @property {string} message - 'StatusCallback is invalid'
 */

var RoomStatusCallbackInvalidError = function (_TwilioError25) {
  _inherits(RoomStatusCallbackInvalidError, _TwilioError25);

  function RoomStatusCallbackInvalidError() {
    _classCallCheck(this, RoomStatusCallbackInvalidError);

    return _possibleConstructorReturn(this, (RoomStatusCallbackInvalidError.__proto__ || Object.getPrototypeOf(RoomStatusCallbackInvalidError)).call(this, 53111, 'StatusCallback is invalid'));
  }

  return RoomStatusCallbackInvalidError;
}(TwilioError);

exports.RoomStatusCallbackInvalidError = RoomStatusCallbackInvalidError;
Object.defineProperty(TwilioErrorByCode, 53111, { value: RoomStatusCallbackInvalidError });

/**
 * @class RoomStatusInvalidError
 * @classdesc Raised in the REST API when Status is not valid or the Room is not in-progress.
 * @extends TwilioError
 * @property {number} code - 53112
 * @property {string} message - 'Status is invalid'
 */

var RoomStatusInvalidError = function (_TwilioError26) {
  _inherits(RoomStatusInvalidError, _TwilioError26);

  function RoomStatusInvalidError() {
    _classCallCheck(this, RoomStatusInvalidError);

    return _possibleConstructorReturn(this, (RoomStatusInvalidError.__proto__ || Object.getPrototypeOf(RoomStatusInvalidError)).call(this, 53112, 'Status is invalid'));
  }

  return RoomStatusInvalidError;
}(TwilioError);

exports.RoomStatusInvalidError = RoomStatusInvalidError;
Object.defineProperty(TwilioErrorByCode, 53112, { value: RoomStatusInvalidError });

/**
 * @class RoomRoomExistsError
 * @classdesc Raised in the REST API when the Room creation fails because a Room exists with the same name.
 * @extends TwilioError
 * @property {number} code - 53113
 * @property {string} message - 'Room exists'
 */

var RoomRoomExistsError = function (_TwilioError27) {
  _inherits(RoomRoomExistsError, _TwilioError27);

  function RoomRoomExistsError() {
    _classCallCheck(this, RoomRoomExistsError);

    return _possibleConstructorReturn(this, (RoomRoomExistsError.__proto__ || Object.getPrototypeOf(RoomRoomExistsError)).call(this, 53113, 'Room exists'));
  }

  return RoomRoomExistsError;
}(TwilioError);

exports.RoomRoomExistsError = RoomRoomExistsError;
Object.defineProperty(TwilioErrorByCode, 53113, { value: RoomRoomExistsError });

/**
 * @class RoomInvalidParametersError
 * @classdesc Raised in the REST API when one or more Room creation parameter is incompatible with the Room type.
 * @extends TwilioError
 * @property {number} code - 53114
 * @property {string} message - 'Room creation parameter(s) incompatible with the Room type'
 */

var RoomInvalidParametersError = function (_TwilioError28) {
  _inherits(RoomInvalidParametersError, _TwilioError28);

  function RoomInvalidParametersError() {
    _classCallCheck(this, RoomInvalidParametersError);

    return _possibleConstructorReturn(this, (RoomInvalidParametersError.__proto__ || Object.getPrototypeOf(RoomInvalidParametersError)).call(this, 53114, 'Room creation parameter(s) incompatible with the Room type'));
  }

  return RoomInvalidParametersError;
}(TwilioError);

exports.RoomInvalidParametersError = RoomInvalidParametersError;
Object.defineProperty(TwilioErrorByCode, 53114, { value: RoomInvalidParametersError });

/**
 * @class RoomMediaRegionInvalidError
 * @classdesc Raised in the REST API when MediaRegion is set to an invalid value.
 * @extends TwilioError
 * @property {number} code - 53115
 * @property {string} message - 'MediaRegion is invalid'
 */

var RoomMediaRegionInvalidError = function (_TwilioError29) {
  _inherits(RoomMediaRegionInvalidError, _TwilioError29);

  function RoomMediaRegionInvalidError() {
    _classCallCheck(this, RoomMediaRegionInvalidError);

    return _possibleConstructorReturn(this, (RoomMediaRegionInvalidError.__proto__ || Object.getPrototypeOf(RoomMediaRegionInvalidError)).call(this, 53115, 'MediaRegion is invalid'));
  }

  return RoomMediaRegionInvalidError;
}(TwilioError);

exports.RoomMediaRegionInvalidError = RoomMediaRegionInvalidError;
Object.defineProperty(TwilioErrorByCode, 53115, { value: RoomMediaRegionInvalidError });

/**
 * @class RoomMediaRegionUnavailableError
 * @classdesc Raised in the REST API when MediaRegion is set to a valid value but no media servers are available.
 * @extends TwilioError
 * @property {number} code - 53116
 * @property {string} message - 'There are no media servers available in the MediaRegion'
 */

var RoomMediaRegionUnavailableError = function (_TwilioError30) {
  _inherits(RoomMediaRegionUnavailableError, _TwilioError30);

  function RoomMediaRegionUnavailableError() {
    _classCallCheck(this, RoomMediaRegionUnavailableError);

    return _possibleConstructorReturn(this, (RoomMediaRegionUnavailableError.__proto__ || Object.getPrototypeOf(RoomMediaRegionUnavailableError)).call(this, 53116, 'There are no media servers available in the MediaRegion'));
  }

  return RoomMediaRegionUnavailableError;
}(TwilioError);

exports.RoomMediaRegionUnavailableError = RoomMediaRegionUnavailableError;
Object.defineProperty(TwilioErrorByCode, 53116, { value: RoomMediaRegionUnavailableError });

/**
 * @class RoomSubscriptionOperationNotSupportedError
 * @classdesc Raised whenever the subscription operation requested is not supported for the Room type.
 * @extends TwilioError
 * @property {number} code - 53117
 * @property {string} message - 'The subscription operation requested is not supported for the Room type'
 */

var RoomSubscriptionOperationNotSupportedError = function (_TwilioError31) {
  _inherits(RoomSubscriptionOperationNotSupportedError, _TwilioError31);

  function RoomSubscriptionOperationNotSupportedError() {
    _classCallCheck(this, RoomSubscriptionOperationNotSupportedError);

    return _possibleConstructorReturn(this, (RoomSubscriptionOperationNotSupportedError.__proto__ || Object.getPrototypeOf(RoomSubscriptionOperationNotSupportedError)).call(this, 53117, 'The subscription operation requested is not supported for the Room type'));
  }

  return RoomSubscriptionOperationNotSupportedError;
}(TwilioError);

exports.RoomSubscriptionOperationNotSupportedError = RoomSubscriptionOperationNotSupportedError;
Object.defineProperty(TwilioErrorByCode, 53117, { value: RoomSubscriptionOperationNotSupportedError });

/**
 * @class RoomCompletedError
 * @classdesc Raised whenever a Room is completed via the REST API.
 * @extends TwilioError
 * @property {number} code - 53118
 * @property {string} message - 'Room completed'
 */

var RoomCompletedError = function (_TwilioError32) {
  _inherits(RoomCompletedError, _TwilioError32);

  function RoomCompletedError() {
    _classCallCheck(this, RoomCompletedError);

    return _possibleConstructorReturn(this, (RoomCompletedError.__proto__ || Object.getPrototypeOf(RoomCompletedError)).call(this, 53118, 'Room completed'));
  }

  return RoomCompletedError;
}(TwilioError);

exports.RoomCompletedError = RoomCompletedError;
Object.defineProperty(TwilioErrorByCode, 53118, { value: RoomCompletedError });

/**
 * @class ParticipantIdentityInvalidError
 * @classdesc Raised whenever a Participant identity is invalid, and the scenario is not covered by a more specific error code.
 * @extends TwilioError
 * @property {number} code - 53200
 * @property {string} message - 'Participant identity is invalid'
 */

var ParticipantIdentityInvalidError = function (_TwilioError33) {
  _inherits(ParticipantIdentityInvalidError, _TwilioError33);

  function ParticipantIdentityInvalidError() {
    _classCallCheck(this, ParticipantIdentityInvalidError);

    return _possibleConstructorReturn(this, (ParticipantIdentityInvalidError.__proto__ || Object.getPrototypeOf(ParticipantIdentityInvalidError)).call(this, 53200, 'Participant identity is invalid'));
  }

  return ParticipantIdentityInvalidError;
}(TwilioError);

exports.ParticipantIdentityInvalidError = ParticipantIdentityInvalidError;
Object.defineProperty(TwilioErrorByCode, 53200, { value: ParticipantIdentityInvalidError });

/**
 * @class ParticipantIdentityTooLongError
 * @classdesc Raised whenever a Participant identity is too long.
 * @extends TwilioError
 * @property {number} code - 53201
 * @property {string} message - 'Participant identity is too long'
 */

var ParticipantIdentityTooLongError = function (_TwilioError34) {
  _inherits(ParticipantIdentityTooLongError, _TwilioError34);

  function ParticipantIdentityTooLongError() {
    _classCallCheck(this, ParticipantIdentityTooLongError);

    return _possibleConstructorReturn(this, (ParticipantIdentityTooLongError.__proto__ || Object.getPrototypeOf(ParticipantIdentityTooLongError)).call(this, 53201, 'Participant identity is too long'));
  }

  return ParticipantIdentityTooLongError;
}(TwilioError);

exports.ParticipantIdentityTooLongError = ParticipantIdentityTooLongError;
Object.defineProperty(TwilioErrorByCode, 53201, { value: ParticipantIdentityTooLongError });

/**
 * @class ParticipantIdentityCharsInvalidError
 * @classdesc Raised whenever a Participant identity contains invalid characters.
 * @extends TwilioError
 * @property {number} code - 53202
 * @property {string} message - 'Participant identity contains invalid characters'
 */

var ParticipantIdentityCharsInvalidError = function (_TwilioError35) {
  _inherits(ParticipantIdentityCharsInvalidError, _TwilioError35);

  function ParticipantIdentityCharsInvalidError() {
    _classCallCheck(this, ParticipantIdentityCharsInvalidError);

    return _possibleConstructorReturn(this, (ParticipantIdentityCharsInvalidError.__proto__ || Object.getPrototypeOf(ParticipantIdentityCharsInvalidError)).call(this, 53202, 'Participant identity contains invalid characters'));
  }

  return ParticipantIdentityCharsInvalidError;
}(TwilioError);

exports.ParticipantIdentityCharsInvalidError = ParticipantIdentityCharsInvalidError;
Object.defineProperty(TwilioErrorByCode, 53202, { value: ParticipantIdentityCharsInvalidError });

/**
 * @class ParticipantMaxTracksExceededError
 * @classdesc Raised when the Room limit for published tracks has been reached and a Participant tries to publish a track to the Room.
 * @extends TwilioError
 * @property {number} code - 53203
 * @property {string} message - 'The maximum number of published tracks allowed in the Room at the same time has been reached'
 */

var ParticipantMaxTracksExceededError = function (_TwilioError36) {
  _inherits(ParticipantMaxTracksExceededError, _TwilioError36);

  function ParticipantMaxTracksExceededError() {
    _classCallCheck(this, ParticipantMaxTracksExceededError);

    return _possibleConstructorReturn(this, (ParticipantMaxTracksExceededError.__proto__ || Object.getPrototypeOf(ParticipantMaxTracksExceededError)).call(this, 53203, 'The maximum number of published tracks allowed in the Room at the same time has been reached'));
  }

  return ParticipantMaxTracksExceededError;
}(TwilioError);

exports.ParticipantMaxTracksExceededError = ParticipantMaxTracksExceededError;
Object.defineProperty(TwilioErrorByCode, 53203, { value: ParticipantMaxTracksExceededError });

/**
 * @class ParticipantNotFoundError
 * @classdesc Raised whenever attempting an operation on a non-existent Participant.
 * @extends TwilioError
 * @property {number} code - 53204
 * @property {string} message - 'Participant not found'
 */

var ParticipantNotFoundError = function (_TwilioError37) {
  _inherits(ParticipantNotFoundError, _TwilioError37);

  function ParticipantNotFoundError() {
    _classCallCheck(this, ParticipantNotFoundError);

    return _possibleConstructorReturn(this, (ParticipantNotFoundError.__proto__ || Object.getPrototypeOf(ParticipantNotFoundError)).call(this, 53204, 'Participant not found'));
  }

  return ParticipantNotFoundError;
}(TwilioError);

exports.ParticipantNotFoundError = ParticipantNotFoundError;
Object.defineProperty(TwilioErrorByCode, 53204, { value: ParticipantNotFoundError });

/**
 * @class ParticipantDuplicateIdentityError
 * @classdesc Raised by the server to the existing Participant when a new Participant joins a Room with the same identity as the existing Participant.
 * @extends TwilioError
 * @property {number} code - 53205
 * @property {string} message - 'Participant disconnected because of duplicate identity'
 */

var ParticipantDuplicateIdentityError = function (_TwilioError38) {
  _inherits(ParticipantDuplicateIdentityError, _TwilioError38);

  function ParticipantDuplicateIdentityError() {
    _classCallCheck(this, ParticipantDuplicateIdentityError);

    return _possibleConstructorReturn(this, (ParticipantDuplicateIdentityError.__proto__ || Object.getPrototypeOf(ParticipantDuplicateIdentityError)).call(this, 53205, 'Participant disconnected because of duplicate identity'));
  }

  return ParticipantDuplicateIdentityError;
}(TwilioError);

exports.ParticipantDuplicateIdentityError = ParticipantDuplicateIdentityError;
Object.defineProperty(TwilioErrorByCode, 53205, { value: ParticipantDuplicateIdentityError });

/**
 * @class TrackInvalidError
 * @classdesc Raised whenever a Track is invalid, and the scenario is not covered by a more specific error code.
 * @extends TwilioError
 * @property {number} code - 53300
 * @property {string} message - 'Track is invalid'
 */

var TrackInvalidError = function (_TwilioError39) {
  _inherits(TrackInvalidError, _TwilioError39);

  function TrackInvalidError() {
    _classCallCheck(this, TrackInvalidError);

    return _possibleConstructorReturn(this, (TrackInvalidError.__proto__ || Object.getPrototypeOf(TrackInvalidError)).call(this, 53300, 'Track is invalid'));
  }

  return TrackInvalidError;
}(TwilioError);

exports.TrackInvalidError = TrackInvalidError;
Object.defineProperty(TwilioErrorByCode, 53300, { value: TrackInvalidError });

/**
 * @class TrackNameInvalidError
 * @classdesc Raised whenever a Track name is invalid, and the scenario is not covered by a more specific error code.
 * @extends TwilioError
 * @property {number} code - 53301
 * @property {string} message - 'Track name is invalid'
 */

var TrackNameInvalidError = function (_TwilioError40) {
  _inherits(TrackNameInvalidError, _TwilioError40);

  function TrackNameInvalidError() {
    _classCallCheck(this, TrackNameInvalidError);

    return _possibleConstructorReturn(this, (TrackNameInvalidError.__proto__ || Object.getPrototypeOf(TrackNameInvalidError)).call(this, 53301, 'Track name is invalid'));
  }

  return TrackNameInvalidError;
}(TwilioError);

exports.TrackNameInvalidError = TrackNameInvalidError;
Object.defineProperty(TwilioErrorByCode, 53301, { value: TrackNameInvalidError });

/**
 * @class TrackNameTooLongError
 * @classdesc Raised whenever a Track name is too long.
 * @extends TwilioError
 * @property {number} code - 53302
 * @property {string} message - 'Track name is too long'
 */

var TrackNameTooLongError = function (_TwilioError41) {
  _inherits(TrackNameTooLongError, _TwilioError41);

  function TrackNameTooLongError() {
    _classCallCheck(this, TrackNameTooLongError);

    return _possibleConstructorReturn(this, (TrackNameTooLongError.__proto__ || Object.getPrototypeOf(TrackNameTooLongError)).call(this, 53302, 'Track name is too long'));
  }

  return TrackNameTooLongError;
}(TwilioError);

exports.TrackNameTooLongError = TrackNameTooLongError;
Object.defineProperty(TwilioErrorByCode, 53302, { value: TrackNameTooLongError });

/**
 * @class TrackNameCharsInvalidError
 * @classdesc Raised whenever a Track name contains invalid characters.
 * @extends TwilioError
 * @property {number} code - 53303
 * @property {string} message - 'Track name contains invalid characters'
 */

var TrackNameCharsInvalidError = function (_TwilioError42) {
  _inherits(TrackNameCharsInvalidError, _TwilioError42);

  function TrackNameCharsInvalidError() {
    _classCallCheck(this, TrackNameCharsInvalidError);

    return _possibleConstructorReturn(this, (TrackNameCharsInvalidError.__proto__ || Object.getPrototypeOf(TrackNameCharsInvalidError)).call(this, 53303, 'Track name contains invalid characters'));
  }

  return TrackNameCharsInvalidError;
}(TwilioError);

exports.TrackNameCharsInvalidError = TrackNameCharsInvalidError;
Object.defineProperty(TwilioErrorByCode, 53303, { value: TrackNameCharsInvalidError });

/**
 * @class TrackNameIsDuplicatedError
 * @classdesc Raised whenever a Participant is currently publishing a Track with the same name.
 * @extends TwilioError
 * @property {number} code - 53304
 * @property {string} message - 'Track name is duplicated'
 */

var TrackNameIsDuplicatedError = function (_TwilioError43) {
  _inherits(TrackNameIsDuplicatedError, _TwilioError43);

  function TrackNameIsDuplicatedError() {
    _classCallCheck(this, TrackNameIsDuplicatedError);

    return _possibleConstructorReturn(this, (TrackNameIsDuplicatedError.__proto__ || Object.getPrototypeOf(TrackNameIsDuplicatedError)).call(this, 53304, 'Track name is duplicated'));
  }

  return TrackNameIsDuplicatedError;
}(TwilioError);

exports.TrackNameIsDuplicatedError = TrackNameIsDuplicatedError;
Object.defineProperty(TwilioErrorByCode, 53304, { value: TrackNameIsDuplicatedError });

/**
 * @class TrackServerTrackCapacityReachedError
 * @classdesc The server does not have enough resources available to create a new Track.
 * @extends TwilioError
 * @property {number} code - 53305
 * @property {string} message - 'The server has reached capacity and cannot fulfill this request'
 */

var TrackServerTrackCapacityReachedError = function (_TwilioError44) {
  _inherits(TrackServerTrackCapacityReachedError, _TwilioError44);

  function TrackServerTrackCapacityReachedError() {
    _classCallCheck(this, TrackServerTrackCapacityReachedError);

    return _possibleConstructorReturn(this, (TrackServerTrackCapacityReachedError.__proto__ || Object.getPrototypeOf(TrackServerTrackCapacityReachedError)).call(this, 53305, 'The server has reached capacity and cannot fulfill this request'));
  }

  return TrackServerTrackCapacityReachedError;
}(TwilioError);

exports.TrackServerTrackCapacityReachedError = TrackServerTrackCapacityReachedError;
Object.defineProperty(TwilioErrorByCode, 53305, { value: TrackServerTrackCapacityReachedError });

/**
 * @class MediaClientLocalDescFailedError
 * @classdesc Raised whenever a Client is unable to create or apply a local media description.
 * @extends TwilioError
 * @property {number} code - 53400
 * @property {string} message - 'Client is unable to create or apply a local media description'
 */

var MediaClientLocalDescFailedError = function (_TwilioError45) {
  _inherits(MediaClientLocalDescFailedError, _TwilioError45);

  function MediaClientLocalDescFailedError() {
    _classCallCheck(this, MediaClientLocalDescFailedError);

    return _possibleConstructorReturn(this, (MediaClientLocalDescFailedError.__proto__ || Object.getPrototypeOf(MediaClientLocalDescFailedError)).call(this, 53400, 'Client is unable to create or apply a local media description'));
  }

  return MediaClientLocalDescFailedError;
}(TwilioError);

exports.MediaClientLocalDescFailedError = MediaClientLocalDescFailedError;
Object.defineProperty(TwilioErrorByCode, 53400, { value: MediaClientLocalDescFailedError });

/**
 * @class MediaServerLocalDescFailedError
 * @classdesc Raised whenever the Server is unable to create or apply a local media description.
 * @extends TwilioError
 * @property {number} code - 53401
 * @property {string} message - 'Server is unable to create or apply a local media description'
 */

var MediaServerLocalDescFailedError = function (_TwilioError46) {
  _inherits(MediaServerLocalDescFailedError, _TwilioError46);

  function MediaServerLocalDescFailedError() {
    _classCallCheck(this, MediaServerLocalDescFailedError);

    return _possibleConstructorReturn(this, (MediaServerLocalDescFailedError.__proto__ || Object.getPrototypeOf(MediaServerLocalDescFailedError)).call(this, 53401, 'Server is unable to create or apply a local media description'));
  }

  return MediaServerLocalDescFailedError;
}(TwilioError);

exports.MediaServerLocalDescFailedError = MediaServerLocalDescFailedError;
Object.defineProperty(TwilioErrorByCode, 53401, { value: MediaServerLocalDescFailedError });

/**
 * @class MediaClientRemoteDescFailedError
 * @classdesc Raised whenever the Client receives a remote media description but is unable to apply it.
 * @extends TwilioError
 * @property {number} code - 53402
 * @property {string} message - 'Client is unable to apply a remote media description'
 */

var MediaClientRemoteDescFailedError = function (_TwilioError47) {
  _inherits(MediaClientRemoteDescFailedError, _TwilioError47);

  function MediaClientRemoteDescFailedError() {
    _classCallCheck(this, MediaClientRemoteDescFailedError);

    return _possibleConstructorReturn(this, (MediaClientRemoteDescFailedError.__proto__ || Object.getPrototypeOf(MediaClientRemoteDescFailedError)).call(this, 53402, 'Client is unable to apply a remote media description'));
  }

  return MediaClientRemoteDescFailedError;
}(TwilioError);

exports.MediaClientRemoteDescFailedError = MediaClientRemoteDescFailedError;
Object.defineProperty(TwilioErrorByCode, 53402, { value: MediaClientRemoteDescFailedError });

/**
 * @class MediaServerRemoteDescFailedError
 * @classdesc Raised whenever the Server receives a remote media description but is unable to apply it.
 * @extends TwilioError
 * @property {number} code - 53403
 * @property {string} message - 'Server is unable to apply a remote media description'
 */

var MediaServerRemoteDescFailedError = function (_TwilioError48) {
  _inherits(MediaServerRemoteDescFailedError, _TwilioError48);

  function MediaServerRemoteDescFailedError() {
    _classCallCheck(this, MediaServerRemoteDescFailedError);

    return _possibleConstructorReturn(this, (MediaServerRemoteDescFailedError.__proto__ || Object.getPrototypeOf(MediaServerRemoteDescFailedError)).call(this, 53403, 'Server is unable to apply a remote media description'));
  }

  return MediaServerRemoteDescFailedError;
}(TwilioError);

exports.MediaServerRemoteDescFailedError = MediaServerRemoteDescFailedError;
Object.defineProperty(TwilioErrorByCode, 53403, { value: MediaServerRemoteDescFailedError });

/**
 * @class MediaNoSupportedCodecError
 * @classdesc Raised whenever the intersection of codecs supported by the Client and the Server (or, in peer-to-peer, the Client and another Participant) is empty.
 * @extends TwilioError
 * @property {number} code - 53404
 * @property {string} message - 'No supported codec'
 */

var MediaNoSupportedCodecError = function (_TwilioError49) {
  _inherits(MediaNoSupportedCodecError, _TwilioError49);

  function MediaNoSupportedCodecError() {
    _classCallCheck(this, MediaNoSupportedCodecError);

    return _possibleConstructorReturn(this, (MediaNoSupportedCodecError.__proto__ || Object.getPrototypeOf(MediaNoSupportedCodecError)).call(this, 53404, 'No supported codec'));
  }

  return MediaNoSupportedCodecError;
}(TwilioError);

exports.MediaNoSupportedCodecError = MediaNoSupportedCodecError;
Object.defineProperty(TwilioErrorByCode, 53404, { value: MediaNoSupportedCodecError });

/**
 * @class MediaConnectionError
 * @classdesc Raised by the Client or Server whenever a media connection fails or raised by the Client whenever it detects that media has stopped flowing.
 * @extends TwilioError
 * @property {number} code - 53405
 * @property {string} message - 'Media connection failed or Media activity ceased'
 */

var MediaConnectionError = function (_TwilioError50) {
  _inherits(MediaConnectionError, _TwilioError50);

  function MediaConnectionError() {
    _classCallCheck(this, MediaConnectionError);

    return _possibleConstructorReturn(this, (MediaConnectionError.__proto__ || Object.getPrototypeOf(MediaConnectionError)).call(this, 53405, 'Media connection failed or Media activity ceased'));
  }

  return MediaConnectionError;
}(TwilioError);

exports.MediaConnectionError = MediaConnectionError;
Object.defineProperty(TwilioErrorByCode, 53405, { value: MediaConnectionError });

/**
 * @class MediaDTLSTransportFailedError
 * @classdesc There was a problem while negotiating with the remote DTLS peer. Therefore the Participant will not be able to publish or subscribe to Tracks.
 * @extends TwilioError
 * @property {number} code - 53407
 * @property {string} message - 'Media connection failed due to DTLS handshake failure'
 */

var MediaDTLSTransportFailedError = function (_TwilioError51) {
  _inherits(MediaDTLSTransportFailedError, _TwilioError51);

  function MediaDTLSTransportFailedError() {
    _classCallCheck(this, MediaDTLSTransportFailedError);

    return _possibleConstructorReturn(this, (MediaDTLSTransportFailedError.__proto__ || Object.getPrototypeOf(MediaDTLSTransportFailedError)).call(this, 53407, 'Media connection failed due to DTLS handshake failure'));
  }

  return MediaDTLSTransportFailedError;
}(TwilioError);

exports.MediaDTLSTransportFailedError = MediaDTLSTransportFailedError;
Object.defineProperty(TwilioErrorByCode, 53407, { value: MediaDTLSTransportFailedError });

/**
 * @class ConfigurationAcquireFailedError
 * @classdesc Raised whenever the Client is unable to acquire configuration information from the Server.
 * @extends TwilioError
 * @property {number} code - 53500
 * @property {string} message - 'Unable to acquire configuration'
 */

var ConfigurationAcquireFailedError = function (_TwilioError52) {
  _inherits(ConfigurationAcquireFailedError, _TwilioError52);

  function ConfigurationAcquireFailedError() {
    _classCallCheck(this, ConfigurationAcquireFailedError);

    return _possibleConstructorReturn(this, (ConfigurationAcquireFailedError.__proto__ || Object.getPrototypeOf(ConfigurationAcquireFailedError)).call(this, 53500, 'Unable to acquire configuration'));
  }

  return ConfigurationAcquireFailedError;
}(TwilioError);

exports.ConfigurationAcquireFailedError = ConfigurationAcquireFailedError;
Object.defineProperty(TwilioErrorByCode, 53500, { value: ConfigurationAcquireFailedError });

/**
 * @class ConfigurationAcquireTurnFailedError
 * @classdesc Raised whenever the Server is unable to return TURN credentials to the Client
 * @extends TwilioError
 * @property {number} code - 53501
 * @property {string} message - 'Unable to acquire TURN credentials'
 */

var ConfigurationAcquireTurnFailedError = function (_TwilioError53) {
  _inherits(ConfigurationAcquireTurnFailedError, _TwilioError53);

  function ConfigurationAcquireTurnFailedError() {
    _classCallCheck(this, ConfigurationAcquireTurnFailedError);

    return _possibleConstructorReturn(this, (ConfigurationAcquireTurnFailedError.__proto__ || Object.getPrototypeOf(ConfigurationAcquireTurnFailedError)).call(this, 53501, 'Unable to acquire TURN credentials'));
  }

  return ConfigurationAcquireTurnFailedError;
}(TwilioError);

exports.ConfigurationAcquireTurnFailedError = ConfigurationAcquireTurnFailedError;
Object.defineProperty(TwilioErrorByCode, 53501, { value: ConfigurationAcquireTurnFailedError });