/*! twilio-video.js 2.29.0

The following license applies to all parts of this software except as
documented below.

    Copyright (C) 2019-2025 Twilio, inc.
    All rights reserved.

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions are
    met:

      1. Redistributions of source code must retain the above copyright
         notice, this list of conditions and the following disclaimer.

      2. Redistributions in binary form must reproduce the above copyright
         notice, this list of conditions and the following disclaimer in
         the documentation and/or other materials provided with the
         distribution.

      3. Neither the name of Twilio nor the names of its contributors may
         be used to endorse or promote products derived from this software
         without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
    "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
    LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
    A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
    HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
    SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
    LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
    DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
    THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
    (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
    OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

 */
/* eslint strict:0 */
(function(root) {
  var bundle = (function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){var n=e[i][1][r];return o(n||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r})()({1:[function(require,module,exports){
'use strict';
var CancelablePromise = require('./util/cancelablepromise');
/**
 * Create a {@link CancelablePromise<Room>}.
 * @param {function(function(Array<LocalTrack>): CancelablePromise<RoomSignaling>):
 *   Promise<function(): CancelablePromise<RoomSignaling>>} getLocalTracks
 * @param {function(Array<LocalTrack>): LocalParticipant} createLocalParticipant
 * @param {function(Array<LocalTrack>): CancelablePromise<RoomSignaling>} createRoomSignaling
 * @param {function(LocalParticipant, RoomSignaling): Room} createRoom
 * @returns CancelablePromise<Room>
 */
function createCancelableRoomPromise(getLocalTracks, createLocalParticipant, createRoomSignaling, createRoom) {
    var cancelableRoomSignalingPromise;
    var cancellationError = new Error('Canceled');
    return new CancelablePromise(function onCreate(resolve, reject, isCanceled) {
        var localParticipant;
        getLocalTracks(function getLocalTracksSucceeded(localTracks) {
            if (isCanceled()) {
                return CancelablePromise.reject(cancellationError);
            }
            localParticipant = createLocalParticipant(localTracks);
            return createRoomSignaling(localParticipant).then(function createRoomSignalingSucceeded(getCancelableRoomSignalingPromise) {
                if (isCanceled()) {
                    throw cancellationError;
                }
                cancelableRoomSignalingPromise = getCancelableRoomSignalingPromise();
                return cancelableRoomSignalingPromise;
            });
        }).then(function roomSignalingConnected(roomSignaling) {
            if (isCanceled()) {
                roomSignaling.disconnect();
                throw cancellationError;
            }
            resolve(createRoom(localParticipant, roomSignaling));
        }).catch(function onError(error) {
            reject(error);
        });
    }, function onCancel() {
        if (cancelableRoomSignalingPromise) {
            cancelableRoomSignalingPromise.cancel();
        }
    });
}
module.exports = createCancelableRoomPromise;

},{"./util/cancelablepromise":125}],2:[function(require,module,exports){
'use strict';
var MediaStreamTrack = require('./webrtc').MediaStreamTrack;
var _a = require('./webrtc/util'), guessBrowser = _a.guessBrowser, guessBrowserVersion = _a.guessBrowserVersion, isCodecSupported = _a.isCodecSupported;
var createCancelableRoomPromise = require('./cancelableroompromise');
var EncodingParametersImpl = require('./encodingparameters');
var LocalParticipant = require('./localparticipant');
var InsightsPublisher = require('./util/insightspublisher');
var NullInsightsPublisher = require('./util/insightspublisher/null');
var _b = require('./media/track/es5'), LocalAudioTrack = _b.LocalAudioTrack, LocalDataTrack = _b.LocalDataTrack, LocalVideoTrack = _b.LocalVideoTrack;
var NetworkQualityConfigurationImpl = require('./networkqualityconfiguration');
var Room = require('./room');
var SignalingV2 = require('./signaling/v2');
var _c = require('./util'), asLocalTrack = _c.asLocalTrack, buildLogLevels = _c.buildLogLevels, filterObject = _c.filterObject, isNonArrayObject = _c.isNonArrayObject;
var _d = require('./util/constants'), DEFAULT_ENVIRONMENT = _d.DEFAULT_ENVIRONMENT, DEFAULT_LOG_LEVEL = _d.DEFAULT_LOG_LEVEL, DEFAULT_LOGGER_NAME = _d.DEFAULT_LOGGER_NAME, DEFAULT_REALM = _d.DEFAULT_REALM, DEFAULT_REGION = _d.DEFAULT_REGION, WS_SERVER = _d.WS_SERVER, SDK_NAME = _d.SDK_NAME, SDK_VERSION = _d.SDK_VERSION, E = _d.typeErrors;
var CancelablePromise = require('./util/cancelablepromise');
var EventObserver = require('./util/eventobserver');
var DefaultLog = require('./util/log');
var validateBandwidthProfile = require('./util/validate').validateBandwidthProfile;
var safariVersion = guessBrowser() === 'safari' && guessBrowserVersion();
// This is used to make out which connect() call a particular Log statement
// belongs to. Each call to connect() increments this counter.
var connectCalls = 0;
var didPrintSafariWarning = false;
var isSafariWithoutVP8Support = false;
if (safariVersion) {
    var safariMajorVersion = safariVersion.major, safariMinorVersion = safariVersion.minor;
    isSafariWithoutVP8Support = safariMajorVersion < 12 || (safariMajorVersion === 12 && safariMinorVersion < 1);
}
var deprecatedConnectOptionsProps = new Set([
    { didWarn: false, shouldDelete: true, name: 'abortOnIceServersTimeout' },
    { didWarn: false, shouldDelete: true, name: 'dscpTagging', newName: 'enableDscp' },
    { didWarn: false, shouldDelete: true, name: 'iceServersTimeout' },
    { didWarn: false, shouldDelete: false, name: 'eventListener', newName: 'Video.Logger' },
    { didWarn: false, shouldDelete: false, name: 'logLevel', newName: 'Video.Logger' },
]);
var deprecatedBandwidthProfileOptions = new Set([
    { didWarn: false, shouldDelete: false, name: 'maxTracks', newName: 'bandwidthProfile.video.clientTrackSwitchOffControl' },
    { didWarn: false, shouldDelete: false, name: 'renderDimensions', newName: 'bandwidthProfile.video.contentPreferencesMode' },
]);
/**
 * Connect to a {@link Room}.
 *   <br><br>
 *   By default, this will automatically acquire an array containing a
 *   {@link LocalAudioTrack} and {@link LocalVideoTrack} before connecting to
 *   the {@link Room}. These will be stopped when you disconnect from the
 *   {@link Room}.
 *   <br><br>
 *   You can override the default behavior by specifying
 *   <code>options</code>. For example, rather than acquiring a
 *   {@link LocalAudioTrack} and {@link LocalVideoTrack} automatically, you can
 *   pass your own array which you can stop yourself. See {@link ConnectOptions}
 *   for more information.
 * @alias module:twilio-video.connect
 * @param {string} token - The Access Token string
 * @param {ConnectOptions} [options] - Options to override the default behavior, invalid options are ignored.
 * @returns {CancelablePromise<Room>}
 * @throws {RangeError}
 * @throws {TwilioError}
 * @throws {TypeError}
 * @example
 * var Video = require('twilio-video');
 * var token = getAccessToken();
 * Video.connect(token, {
 *   name: 'my-cool-room'
 * }).then(function(room) {
 *   room.on('participantConnected', function(participant) {
 *     console.log(participant.identity + ' has connected');
 *   });

 *   room.once('disconnected', function() {
 *     console.log('You left the Room:', room.name);
 *   });
 * }).catch(error => {
 *   console.log('Could not connect to the Room:', error.message);
 * });
 * @example
 * var Video = require('twilio-video');
 * var token = getAccessToken();
 *
 * // Connect with audio-only
 * Video.connect(token, {
 *   name: 'my-cool-room',
 *   audio: true
 * }).then(function(room) {
 *   room.on('participantConnected', function(participant) {
 *     console.log(participant.identity + ' has connected');
 *   });
 *
 *   room.once('disconnected', function() {
 *     console.log('You left the Room:', room.name);
 *   });
 * }).catch(error => {
 *   console.log('Could not connect to the Room:', error.message);
 * });
 * @example
 * var Video = require('twilio-video');
 * var token = getAccessToken();
 *
 * // Connect with media acquired using getUserMedia()
 * navigator.mediaDevices.getUserMedia({
 *   audio: true,
 *   video: true
 * }).then(function(mediaStream) {
 *   return Video.connect(token, {
 *     name: 'my-cool-room',
 *     tracks: mediaStream.getTracks()
 *   });
 * }).then(function(room) {
 *   room.on('participantConnected', function(participant) {
 *     console.log(participant.identity + ' has connected');
 *   });
 *
 *   room.once('disconnected', function() {
 *     console.log('You left the Room:', room.name);
 *   });
 * }).catch(error => {
 *   console.log('Could not connect to the Room:', error.message);
 * });
 * @example
 * var Video = require('twilio-video');
 * var token = getAccessToken();
 *
 * // Connect with custom names for LocalAudioTrack and LocalVideoTrack
 * Video.connect(token, {
 *   name: 'my-cool-room'
 *   audio: { name: 'microphone' },
 *   video: { name: 'camera' }
 * }).then(function(room) {
 *   room.localParticipants.trackPublications.forEach(function(publication) {
 *     console.log('The LocalTrack "' + publication.trackName + '" was successfully published');
 *   });
 * }).catch(error => {
 *   console.log('Could not connect to the Room:', error.message);
 * });
 * @example
 * // Accessing the SDK logger
 * var { Logger, connect } = require('twilio-video');
 * var token = getAccessToken();
 *
 * var logger = Logger.getLogger('twilio-video');
 *
 * // Listen for logs
 * var originalFactory = logger.methodFactory;
 * logger.methodFactory = function (methodName, logLevel, loggerName) {
 *   var method = originalFactory(methodName, logLevel, loggerName);
 *
 *   return function (datetime, logLevel, component, message, data) {
 *     method(datetime, logLevel, component, message, data);
 *     // Send to your own server
 *     postDataToServer(arguments);
 *   };
 * };
 * logger.setLevel('debug');
 *
 * connect(token, {
 *   name: 'my-cool-room'
 * }).then(function(room) {
 *   room.on('participantConnected', function(participant) {
 *     console.log(participant.identity + ' has connected');
 *   });
 * }).catch(error => {
 *   console.log('Could not connect to the Room:', error.message);
 * });
 */
function connect(token, options) {
    if (typeof options === 'undefined') {
        options = {};
    }
    if (!isNonArrayObject(options)) {
        return CancelablePromise.reject(E.INVALID_TYPE('options', 'object'));
    }
    var Log = options.Log || DefaultLog;
    var loggerName = options.loggerName || DEFAULT_LOGGER_NAME;
    var logLevel = options.logLevel || DEFAULT_LOG_LEVEL;
    var logLevels = buildLogLevels(logLevel);
    var logComponentName = "[connect #" + ++connectCalls + "]";
    var log;
    try {
        log = new Log('default', logComponentName, logLevels, loggerName);
    }
    catch (error) {
        return CancelablePromise.reject(error);
    }
    // NOTE(csantos): Log a warning for the deprecated ConnectOptions properties.
    // The warning is displayed only for the first call to connect() per browser session.
    // Additionally, the options that are no longer needed will be removed.
    deprecateOptions(options, log, deprecatedConnectOptionsProps);
    var adaptiveSimulcast = options.preferredVideoCodecs === 'auto';
    if (adaptiveSimulcast) {
        // NOTE(mpatwardhan): enable adaptiveSimulcast.
        options.preferredVideoCodecs = [{ codec: 'VP8', simulcast: true, adaptiveSimulcast: true }];
    }
    if (options.maxVideoBitrate && adaptiveSimulcast) {
        log.error('ConnectOptions "maxVideoBitrate" is not compatible with "preferredVideoCodecs=auto"');
        return CancelablePromise.reject(E.ILLEGAL_INVOKE('connect', 'ConnectOptions "maxVideoBitrate" is not compatible with "preferredVideoCodecs=auto"'));
    }
    options = Object.assign({
        automaticSubscription: true,
        dominantSpeaker: false,
        enableDscp: false,
        environment: DEFAULT_ENVIRONMENT,
        eventListener: null,
        insights: true,
        LocalAudioTrack: LocalAudioTrack,
        LocalDataTrack: LocalDataTrack,
        LocalParticipant: LocalParticipant,
        LocalVideoTrack: LocalVideoTrack,
        Log: Log,
        MediaStreamTrack: MediaStreamTrack,
        loggerName: loggerName,
        logLevel: logLevel,
        maxAudioBitrate: null,
        maxVideoBitrate: null,
        name: null,
        networkMonitor: true,
        networkQuality: false,
        preferredAudioCodecs: [],
        preferredVideoCodecs: [],
        realm: DEFAULT_REALM,
        region: DEFAULT_REGION,
        signaling: SignalingV2
    }, filterObject(options));
    /* eslint new-cap:0 */
    var eventPublisherOptions = {};
    if (typeof options.wsServerInsights === 'string') {
        eventPublisherOptions.gateway = options.wsServerInsights;
    }
    var EventPublisher = options.insights ? InsightsPublisher : NullInsightsPublisher;
    var eventPublisher = new EventPublisher(token, SDK_NAME, SDK_VERSION, options.environment, options.realm, eventPublisherOptions);
    var wsServer = WS_SERVER(options.environment, options.region);
    var eventObserver = new EventObserver(eventPublisher, Date.now(), log, options.eventListener);
    options = Object.assign({ eventObserver: eventObserver, wsServer: wsServer }, options);
    options.log = log;
    // NOTE(mroberts): Print the Safari warning once if the log-level is at least
    // "warn", i.e. neither "error" nor "off".
    // NOTE(mmalavalli): Print the Safari warning only for versions 12.0 and below.
    if (isSafariWithoutVP8Support
        && !didPrintSafariWarning
        && (log.logLevel !== 'error' && log.logLevel !== 'off')) {
        didPrintSafariWarning = true;
        log.warn([
            'Support for Safari 12.0 and below is limited because it does not support VP8.',
            'This means you may experience codec issues in Group Rooms. You may also',
            'experience codec issues in Peer-to-Peer (P2P) Rooms containing Android- or',
            'iOS-based Participants who do not support H.264. However, P2P Rooms',
            'with browser-based Participants should work. For more information, please',
            'refer to this guide: https://www.twilio.com/docs/video/javascript-v2-developing-safari-11'
        ].join(' '));
    }
    if (typeof token !== 'string') {
        return CancelablePromise.reject(E.INVALID_TYPE('token', 'string'));
    }
    // NOTE(mmalavalli): The Room "name" in "options" was being used
    // as the LocalTrack name in asLocalTrack(). So we pass a copy of
    // "options" without the "name".
    var localTrackOptions = Object.assign({}, options);
    delete localTrackOptions.name;
    if ('tracks' in options) {
        if (!Array.isArray(options.tracks)) {
            return CancelablePromise.reject(E.INVALID_TYPE('options.tracks', 'Array of LocalAudioTrack, LocalVideoTrack or MediaStreamTrack'));
        }
        try {
            options.tracks = options.tracks.map(function (track) { return asLocalTrack(track, localTrackOptions); });
        }
        catch (error) {
            return CancelablePromise.reject(error);
        }
    }
    var error = validateBandwidthProfile(options.bandwidthProfile);
    if (error) {
        return CancelablePromise.reject(error);
    }
    // Note(mpatwardhan): "clientTrackSwitchOffControl" allows tracks to be switched off
    // and "contentPreferencesMode" allows track dimensions to be specified dynamically.
    // The properties can have one of the three values internally:
    // 1) "auto" = sdk will decide and send the hints.
    // 2) "manual" - app can use api to send the hints.
    // 3) "disabled" = do not enable this feature. (this is internal only value)
    // 'disabled' is needed because clientTrackSwitchOffControl and contentPreferencesMode are incompatible with
    // deprecated properties maxTracks and renderDimensions respectively. once we make @breaking_version_change
    // we can remove 'disabled' state along with maxTracks and renderDimensions.
    options.clientTrackSwitchOffControl = 'disabled'; // should sdk turn off idle tracks automatically?
    options.contentPreferencesMode = 'disabled'; // should sdk  use video element dimensions for content hints?
    if (options.bandwidthProfile) {
        options.clientTrackSwitchOffControl = 'auto';
        options.contentPreferencesMode = 'auto';
        if (options.bandwidthProfile.video) {
            // log any warnings about deprecated bwp options
            deprecateOptions(options.bandwidthProfile.video, log, deprecatedBandwidthProfileOptions);
            if ('maxTracks' in options.bandwidthProfile.video) {
                // when deprecated maxTracks is specified. disable clientTrackSwitchOffControl
                options.clientTrackSwitchOffControl = 'disabled';
            }
            else if (options.bandwidthProfile.video.clientTrackSwitchOffControl === 'manual') {
                options.clientTrackSwitchOffControl = 'manual';
            }
            else {
                options.clientTrackSwitchOffControl = 'auto';
            }
            if ('renderDimensions' in options.bandwidthProfile.video) {
                options.contentPreferencesMode = 'disabled';
            }
            else if (options.bandwidthProfile.video.contentPreferencesMode === 'manual') {
                options.contentPreferencesMode = 'manual';
            }
            else {
                options.contentPreferencesMode = 'auto';
            }
        }
    }
    var Signaling = options.signaling;
    var signaling = new Signaling(options.wsServer, options);
    log.info('Connecting to a Room');
    log.debug('Options:', options);
    var encodingParameters = new EncodingParametersImpl({
        maxAudioBitrate: options.maxAudioBitrate,
        maxVideoBitrate: options.maxVideoBitrate
    }, adaptiveSimulcast);
    var preferredCodecs = {
        audio: options.preferredAudioCodecs.map(normalizeCodecSettings),
        video: options.preferredVideoCodecs.map(normalizeCodecSettings)
    };
    var networkQualityConfiguration = new NetworkQualityConfigurationImpl(isNonArrayObject(options.networkQuality) ? options.networkQuality : {});
    // Log warnings for any unsupported preferred codecs.
    ['audio', 'video'].forEach(function (kind) { return preferredCodecs[kind].forEach(function (_a) {
        var codec = _a.codec;
        return isCodecSupported(codec, kind).then(function (isSupported) { return !isSupported && log.warn("The preferred " + kind + " codec \"" + codec + "\" will be ignored as it is not supported by the browser."); });
    }); });
    // Create a CancelableRoomPromise<Room> that resolves after these steps:
    // 1 - Get the LocalTracks.
    // 2 - Create the LocalParticipant using options.tracks.
    // 3 - Connect to rtc-room-service and create the RoomSignaling.
    // 4 - Create the Room and then resolve the CancelablePromise.
    var cancelableRoomPromise = createCancelableRoomPromise(getLocalTracks.bind(null, options), createLocalParticipant.bind(null, signaling, log, encodingParameters, networkQualityConfiguration, options), createRoomSignaling.bind(null, token, options, signaling, encodingParameters, preferredCodecs), createRoom.bind(null, options));
    cancelableRoomPromise.then(function (room) {
        eventPublisher.connect(room.sid, room.localParticipant.sid);
        log.info('Connected to Room:', room.toString());
        log.info('Room name:', room.name);
        log.debug('Room:', room);
        room.once('disconnected', function () { return eventPublisher.disconnect(); });
        return room;
    }, function (error) {
        eventPublisher.disconnect();
        if (cancelableRoomPromise._isCanceled) {
            log.info('Attempt to connect to a Room was canceled');
        }
        else {
            log.info('Error while connecting to a Room:', error);
        }
    });
    return cancelableRoomPromise;
}
/**
 * You may pass these options to {@link connect} in order to override the
 * default behavior.
 * @typedef {object} ConnectOptions
 * @property {boolean|CreateLocalTracksOptions|CreateLocalAudioTrackOptions} [audio=true] - Whether or not to
 *   get local audio with <code>getUserMedia</code> when <code>tracks</code>
 *   are not provided.
 * @property {boolean} [automaticSubscription=true] - By default, you will subscribe
 *   to all RemoteTracks shared by other Participants in a Room. You can now override this
 *   behavior by setting this flag to <code>false</code>. It will make sure that you will
 *   not subscribe to any RemoteTrack in a Group or Small Group Room. Setting it to
 *   <code>true</code>, or not setting it at all preserves the default behavior. This
 *   flag does not have any effect in a Peer-to-Peer Room.
 * @property {BandwidthProfileOptions} [bandwidthProfile] - You can optionally configure
 *   how your available downlink bandwidth is shared among the RemoteTracks you have subscribed
 *   to in a Group Room. By default, bandwidth is shared equally among the RemoteTracks.
 *   This has no effect in Peer-to-Peer Rooms.
 * @property {boolean} [dominantSpeaker=false] - Whether to enable the Dominant
 *   Speaker API or not. This only takes effect in Group Rooms.
 * @property {boolean} [dscpTagging=false] - <code>(deprecated: use "enableDscp" instead)</code>
 *   DSCP tagging allows you to request enhanced QoS treatment for RTP media packets from any
 *   firewall that the client may be behind. Setting this option to <code>true</code> will
 *   request DSCP tagging for media packets on supported browsers (only Chrome supports this
 *   as of now). Audio packets will be sent with DSCP header value set to 0xb8 which corresponds
 *   to Expedited Forwarding (EF). Video packets will be sent with DSCP header value set to 0x88
 *   which corresponds to Assured Forwarding (AF41).
 * @property {boolean} [enableDscp=false] - DSCP tagging allows you to request enhanced
 *   QoS treatment for RTP media packets from any firewall that the client may be behind.
 *   Setting this option to <code>true</code> will request DSCP tagging for media packets
 *   on supported browsers (only Chrome supports this as of now). Audio packets will be
 *   sent with DSCP header value set to 0xb8 which corresponds to Expedited Forwarding (EF).
 *   Video packets will be sent with DSCP header value set to 0x88 which corresponds to
 *   Assured Forwarding (AF41).
 * @property {EventListener} [eventListener] - <code>(deprecated: use [Video.Logger](module-twilio-video.html)</code>
 *   you can listen to fine-grained events related to signaling and media that are
 *   not available in the public APIs. These events might be useful for your own reporting
 *   and diagnostics.
 * @property {Array<RTCIceServer>} iceServers - Override the STUN and TURN
 *   servers used when connecting to {@link Room}s
 * @property {RTCIceTransportPolicy} [iceTransportPolicy="all"] - Override the
 *   ICE transport policy to be one of "relay" or "all"
 * @property {boolean} [insights=true] - Whether publishing events
 *   to the Insights gateway is enabled or not
 * @property {?number} [maxAudioBitrate=null] - Max outgoing audio bitrate (bps);
 *   A <code>null</code> or a <code>0</code> value does not set any bitrate limit;
 *   This value is set as a hint for variable bitrate codecs, but will not take
 *   effect for fixed bitrate codecs; Based on our tests, Chrome, Firefox and Safari
 *   support a bitrate range of 12000 bps to 256000 bps for Opus codec; This parameter
 *   has no effect on iSAC, PCMU and PCMA codecs
 * @property {?number} [maxVideoBitrate=null] - Max outgoing video bitrate (bps);
 *   A <code>null</code> or <code>0</code> value does not set any bitrate limit;
 *   This value is set as a hint for variable bitrate codecs, but will not take
 *   effect for fixed bitrate codecs; Based on our tests, Chrome, Firefox and Safari
 *   all seem to support an average bitrate range of 20000 bps (20 kbps) to
 *   8000000 bps (8 mbps) for a 720p VideoTrack
 *   This parameter must not be set when when preferredVideoCodecs is set to `auto`.
 * @property {?string} [name=null] - Set to connect to a {@link Room} by name
 * @property {boolean|NetworkQualityConfiguration} [networkQuality=false] - Whether to enable the Network
 *   Quality API or not. This only takes effect in Group Rooms. Pass a {@link NetworkQualityConfiguration}
 *   to configure verbosity levels for network quality information for {@link LocalParticipant}
 *   and {@link RemoteParticipant}s. A <code>true</code> value will set the {@link NetworkQualityVerbosity}
 *   for the {@link LocalParticipant} to {@link NetworkQualityVerbosity}<code style="padding:0 0">#minimal</code>
 *   and the {@link NetworkQualityVerbosity} for {@link RemoteParticipant}s to
 *   {@link NetworkQualityVerbosity}<code style="padding:0 0">#none</code>.
 * @property {Array<string>} [notifyWarnings=[]] - The SDK raises warning events when it
 *   detects certain conditions. You can implement callbacks on these events to act on them, or to alert
 *   the user of an issue. Subsequently, "warningsCleared" event is raised when conditions have returned
 *   to normal. You can listen to these events by specifying an array of warning. By default,
 *   this array is empty and no warning events will be raised.
 *   Possible values include <code>recording-media-lost</code>, which is raised when the media server
 *   has not detected any media on the published track that is being recorded in the past 30 seconds.
 *   This usually happens when there are network interruptions or when the track has stopped.
 *   This warning is raised by {@link LocalTrackPublication}, {@link LocalParticipant}, and {@link Room} object.
 * @property {string} [region='gll'] - Preferred signaling region; By default, you will be connected to the
 *   nearest signaling server determined by latency based routing. Setting a value other
 *   than <code style="padding:0 0">gll</code> bypasses routing and guarantees that signaling traffic will be
 *   terminated in the region that you prefer. Please refer to this <a href="https://www.twilio.com/docs/video/ip-address-whitelisting#signaling-communication" target="_blank">table</a>
 *   for the list of supported signaling regions.
 * @property {Array<AudioCodec|AudioCodecSettings>} [preferredAudioCodecs=[]] - Preferred audio codecs;
 *  An empty array preserves the current audio codec preference order.
 * @property {Array<VideoCodec|VideoCodecSettings>|VideoEncodingMode} [preferredVideoCodecs=[]] -
 *  Preferred video codecs; when set to 'VideoEncodingMode.Auto', SDK manages the video codec,
 *  by preferring VP8 simulcast in group rooms. It also enables adaptive simulcast, which allows SDK
 *  to turn off simulcast layers that are not needed for efficient bandwidth and CPU usage.
 *  An empty array preserves the current video codec.
 *  preference order. If you want to set a preferred video codec on a Group Room,
 *  you will need to create the Room using the REST API and set the
 *  <code>VideoCodecs</code> property.
 *  See <a href="https://www.twilio.com/docs/api/video/rooms-resource#create-room">
 *  here</a> for more information.
 * @property {LogLevel|LogLevels} [logLevel='warn'] - <code>(deprecated: use [Video.Logger](module-twilio-video.html) instead.
 *   See [examples](module-twilio-video.html#.connect) for details)</code>
 *   Set the default log verbosity
 *   of logging. Passing a {@link LogLevel} string will use the same
 *   level for all components. Pass a {@link LogLevels} to set specific log
 *   levels.
 * @property {string} [loggerName='twilio-video'] - The name of the logger. Use this name when accessing the logger used by the SDK.
 *   See [examples](module-twilio-video.html#.connect) for details.
 * @property {Array<LocalTrack|MediaStreamTrack>} [tracks] - The
 *   {@link LocalTrack}s or MediaStreamTracks with which to join the
 *   {@link Room}. These tracks can be obtained either by calling
 *   {@link createLocalTracks}, or by constructing them from the MediaStream
 *   obtained by calling <code>getUserMedia()</code>.
 * @property {boolean|CreateLocalTrackOptions} [video=true] - Whether or not to
 *   get local video with <code>getUserMedia</code> when <code>tracks</code>
 *   are not provided.
 */
/**
 * {@link BandwidthProfileOptions} allows you to configure how your available downlink
 * bandwidth is shared among the RemoteTracks you have subscribed to in a Group Room.
 * @typedef {object} BandwidthProfileOptions
 * @property {VideoBandwidthProfileOptions} [video] - Optional parameter to configure
 *   how your available downlink bandwidth is shared among the {@link RemoteVideoTrack}s you
 *   have subscribed to in a Group Room.
 */
/**
 * {@link VideoBandwidthProfileOptions} allows you to configure how your available downlink
 * bandwidth is shared among the {@link RemoteVideoTrack}s you have subscribed to in a Group Room.
 * @typedef {object} VideoBandwidthProfileOptions
 * @property {Track.Priority} [dominantSpeakerPriority="standard"] - Optional parameter to
 *   specify the minimum subscribe {@link Track.Priority} of the Dominant Speaker's {@link RemoteVideoTrack}s.
 *   This means that the Dominant Speaker's {@link RemoteVideoTrack}s that are published with
 *   lower {@link Track.Priority} will be subscribed to with the {@link Track.Priority} specified here.
 *   This has no effect on {@link RemoteVideoTrack}s published with higher {@link Track.Priority}, which will
 *   still be subscribed to with with the same {@link Track.Priority}. If not specified, this defaults to "standard".
 *   This parameter only applies to a Group Room Participant when {@link ConnectOptions}.dominantSpeaker is set to true.
 * @property {number} [maxSubscriptionBitrate] - Optional parameter to specify the maximum
 *   downlink video bandwidth in bits per second (bps). By default, there are no limits on
 *   the downlink video bandwidth.
 * @property {ClientTrackSwitchOffControl} [clientTrackSwitchOffControl="auto"] - Optional parameter that determines
 *    when to turn the {@link RemoteVideoTrack} on or off. When set to "auto", SDK will use the visibility of the
 *    attached elements to determine if the {@link RemoteVideoTrack} should be turned off or on. When the attached video elements become invisible the {@link RemoteVideoTrack} will
 *    be turned off, and when elements become visible they will be turned on. When set to "manual" you can turn the {@link RemoteVideoTrack}
 *    on and off using the api {@link RemoteVideoTrack#switchOn} and {@link RemoteVideoTrack#switchOff} respectively.
 * @property {VideoContentPreferencesMode} [contentPreferencesMode="auto"] - This Optional parameter configures
 *    the mode for specifying content preferences for the {@link RemoteVideoTrack}. When set to "auto" the
 *    SDK determines the render dimensions by inspecting the attached video elements. {@link RemoteVideoTrack}s rendered in smaller video elements
 *    will receive a lower resolution stream compared to the video rendered in larger video elements. When set to "manual" you can set
 *    the dimensions programmatically by calling {@link RemoteVideoTrack#setContentPreferences}.
 * @property {number} [maxTracks] - <code>(deprecated: use "clientTrackSwitchOffControl" instead)</code>. Optional
 *   parameter to specify the maximum number of visible {@link RemoteVideoTrack}s, which will be selected based on
 *   {@link Track.Priority} and an N-Loudest policy. By default there are no limits on the number of visible {@link RemoteVideoTrack}s.
 *   0 or a negative value will remove any limit on the maximum number of visible {@link RemoteVideoTrack}s.
 * @property {BandwidthProfileMode} [mode="grid"] - Optional parameter to specify how the {@link RemoteVideoTrack}s'
 *   TrackPriority values are mapped to bandwidth allocation in Group Rooms. This defaults to "grid",
 *   which results in equal bandwidth share allocation to all {@link RemoteVideoTrack}s.
 * @property {VideoRenderDimensions} [renderDimensions] - <code>(deprecated: use "contentPreferencesMode" instead)</code>. Optional
 * parameter to specify the desired render dimensions of {@link RemoteVideoTrack}s.
 * @property {TrackSwitchOffMode} [trackSwitchOffMode="predicted"] - Optional parameter to configure
 *   how {@link RemoteVideoTrack}s are switched off in response to bandwidth pressure. Defaults to "predicted".
 */
/**
 * @deprecated
 * {@link VideoRenderDimensions} allows you to specify the desired render dimensions of {@link RemoteVideoTrack}s.
 * You can specify 'auto' for this field - which is also default value -  based on {@link Track.Priority}. The bandwidth allocation algorithm will distribute the available downlink bandwidth
 * proportional to the requested render dimensions. This is just an input for calculating the bandwidth to be allocated
 * and does not affect the actual resolution of the {@link RemoteVideoTrack}s.
 * @typedef {object} VideoRenderDimensions
 * @property {VideoTrack.Dimensions} [high] - Optional parameter to specify the desired rendering dimensions of
 *   {@link RemoteVideoTrack} whose {@link Track.Priority} is "high". 0 or a negative value will result in the lowest
 *   possible resolution. This defaults to 1280 x 720 (HD).
 * @property {VideoTrack.Dimensions} [low] - Optional parameter to specify the desired rendering dimensions of
 *   {@link RemoteVideoTrack} whose {@link Track.Priority} is "low". 0 or a negative value will result in the lowest
 *   possible resolution. This defaults to 176 x 144 (QCIF).
 * @property {VideoTrack.Dimensions} [standard] - Optional parameter to specify the desired rendering dimensions of
 *   {@link RemoteVideoTrack} whose {@link Track.Priority} is "standard". 0 or a negative value will result in the lowest
 *   possible resolution. This defaults to 640 x 480 (VGA).
 */
/**
 * Configure verbosity levels for network quality information for
 * {@link LocalParticipant} and {@link RemoteParticipant}s.
 * @typedef {object} NetworkQualityConfiguration
 * @property {NetworkQualityVerbosity} [local=1] - Verbosity level for {@link LocalParticipant}
 * @property {NetworkQualityVerbosity} [remote=0] - Verbosity level for {@link RemoteParticipant}s
 */
/**
 * You may pass these levels to {@link ConnectOptions} to override
 * log levels for individual components.
 * @typedef {object} LogLevels
 * @property {LogLevel} [default='warn'] - Log level for 'default' modules.
 * @property {LogLevel} [media='warn'] - Log level for 'media' modules.
 * @property {LogLevel} [signaling='warn'] - Log level for 'signaling' modules.
 * @property {LogLevel} [webrtc='warn'] - Log level for 'webrtc' modules.
 */
/**
 * Audio codec settings.
 * @typedef {object} AudioCodecSettings
 * @property {AudioCodec} codec - Audio codec name
 */
/**
 * Opus codec settings.
 * @typedef {AudioCodecSettings} OpusCodecSettings
 * @property {AudioCodec} name - "opus"
 * @property {boolean} [dtx=true] - Enable/disable discontinuous transmission (DTX);
 *   If enabled all published {@link LocalAudioTrack}s will reduce the outgoing bitrate
 *   to near-zero whenever speech is not detected, resulting in bandwidth and CPU savings;
 *   It defaults to true.
 */
/**
 * Video codec settings.
 * @typedef {object} VideoCodecSettings
 * @property {VideoCodec} codec - Video codec name
 */
/**
 * VP8 codec settings.
 * @typedef {VideoCodecSettings} VP8CodecSettings
 * @property {VideoCodec} name - "VP8"
 * @property {boolean} [simulcast=false] - Enable/disable VP8 simulcast; If
 *   enabled, Twilio's Video SDK will send three video streams of different
 *   qualities
 */
/**
 * Names of the supported audio codecs.
 * @enum {string}
 */
// eslint-disable-next-line
var AudioCodec = {
    isac: 'isac',
    opus: 'opus',
    PCMA: 'PCMA',
    PCMU: 'PCMU'
};
/**
 * Names of the supported VideoEncodingMode.
 * @enum {string}
 */
// eslint-disable-next-line
var VideoEncodingMode = {
    Auto: 'auto',
};
/**
 * Names of the supported video codecs.
 * @enum {string}
 */
// eslint-disable-next-line
var VideoCodec = {
    H264: 'H264',
    VP8: 'VP8'
};
// VP9 is supported by most browsers, but backend doesn't at the moment.
// Hide it from public documentation until then.
VideoCodec.VP9 = 'VP9';
/**
 * Levels for logging verbosity.
 * @enum {string}
 */
// eslint-disable-next-line
var LogLevel = {
    debug: 'debug',
    info: 'info',
    warn: 'warn',
    error: 'error',
    off: 'off'
};
/**
 * The verbosity level of network quality information of a {@link Participant}.
 * @enum {number}
 */
// eslint-disable-next-line
var NetworkQualityVerbosity = {
    /**
     * Nothing is reported for the {@link Participant}. This has no effect and
     * defaults to {@link NetworkQualityVerbosity}<code style="padding:0 0">#minimal</code>
     * for the {@link LocalParticipant}.
     */
    none: 0,
    /**
     * Reports {@link NetworkQualityLevel} for the {@link Participant}.
     */
    minimal: 1,
    /**
     * Reports {@link NetworkQualityLevel} and {@link NetworkQualityStats} for the {@link Participant}.
     * {@link NetworkQualityStats} is populated with audio and video {@link NetworkQualityLevel}s
     * based on which the {@link Participant}'s {@link NetworkQualityLevel} is calculated.
     */
    moderate: 2,
    /**
     * Reports {@link NetworkQualityLevel} and {@link NetworkQualityStats} for the {@link Participant}.
     * {@link NetworkQualityStats} is populated with audio and Video {@link NetworkQualityLevel}s
     * and their corresponding {@link NetworkQualityMediaStats} based on which the
     * {@link Participant}'s {@link NetworkQualityLevel} is calculated.
     */
    detailed: 3
};
/**
 * {@link TrackSwitchOffMode} specifies when {@link RemoteVideoTrack}s' are switched off.
 * @enum {string}
 */
// eslint-disable-next-line
var TrackSwitchOffMode = {
    /**
     * In this mode, {@link RemoteVideoTrack}s are switched off only when network congestion
     * is detected.
     */
    detected: 'detected',
    /**
     * In this mode, {@link RemoteVideoTrack}s are pro-actively switched off when network
     * congestion is predicted by the bandwidth estimation mechanism.
     */
    predicted: 'predicted',
    /**
     * In this mode, {@link RemoteVideoTrack}s are not switched off. Instead in response to network
     * congestion, tracks will be adjusted to lower quality.
     */
    disabled: 'disabled'
};
/**
 * {@link BandwidthProfileMode} specifies how {@link RemoteVideoTrack}s' {@link Track.Priority} values
 * are mapped to bandwidth allocation in Group Rooms.
 * @enum {string}
 */
// eslint-disable-next-line
var BandwidthProfileMode = {
    /**
     * This mode is for use cases where all the subscribed {@link RemoteVideoTrack}s are
     * equally important. The bandwidth allocation algorithm will share the available
     * downlink bandwidth equally among the subscribed {@link RemoteVideoTrack}s, irrespective
     * of their {@link Track.Priority}. In case of insufficient downlink bandwidth, the lower
     * priority {@link RemoteVideoTrack}s are switched off.
     */
    grid: 'grid',
    /**
     * This mode is for use cases where some {@link RemoteVideoTrack}s are prioritized more than
     * others. However, the lower priority {@link RemoteVideoTrack}s still need to be visible.
     * The bandwidth allocation algorithm will share the available downlink bandwidth proportional
     * to the requested {@link VideoRenderDimensions} corresponding to their {@link Track.Priority}.
     * In case of insufficient downlink bandwidth, the quality of higher priority {@link RemoteVideoTrack}s
     * may be degraded to avoid switching off lower priority {@link RemoteVideoTrack}s.
     */
    collaboration: 'collaboration',
    /**
     * This mode is for use cases where some {@link RemoteVideoTrack}s are deemed critical and must
     * be preserved at any cost over the other {@link RemoteVideoTrack}s. The bandwidth allocation
     * algorithm will allocate as big a share of the available downlink bandwidth as it possibly
     * can to the higher priority {@link RemoteVideoTrack}s, and only then consider the lower priority
     * {@link RemoteVideoTrack}s. In case of insufficient downlink bandwidth, the lower priority
     * {@link RemoteVideoTrack}s are switched off in order to preserve the quality of the higher
     * priority {@link RemoteVideoTrack}s.
     */
    presentation: 'presentation'
};
/**
 * {@link VideoContentPreferencesMode} specifies how {@link RemoteVideoTrack}s' render dimensions are
 * decided by the SDK.
 * @enum {string}
 */
// eslint-disable-next-line
var VideoContentPreferencesMode = {
    /**
     * when set to auto, SDK uses the sizes of the video elements attached to the to the  {@link RemoteVideoTrack} dynamically to
     * decide the render dimensions. {@link RemoteVideoTrack}s rendered in smaller video elements will be given smaller bandwidth allocation
     * compared to the tracks rendered in large video elements.
     */
    auto: 'auto',
    /**
     * When set to manual, application can use {@link RemoteVideoTrack#setContentPreference} to set the
     * desired render dimensions for the {@link RemoteVideoTrack}.
     */
    manual: 'manual'
};
/**
 * {@link ClientTrackSwitchOffControl} specifies how {@link RemoteVideoTrack}s' turned on and off
 * @enum {string}
 */
// eslint-disable-next-line
var ClientTrackSwitchOffControl = {
    /**
     * when set to auto, SDK uses the visibility of the video elements attached to the to the  {@link RemoteVideoTrack} to decide.
     * on turning tracks on or off. The track that are not attached to any video elements or not visible on the screen will be turned
     * off automatically.
     */
    auto: 'auto',
    /**
     * When set to manual, application can use {@link RemoteVideoTrack}s switchOff and switchOn apis to control turn the track on or off.
     */
    manual: 'manual'
};
/**
 * Names of the supported levels for {@link EventListenerEvent}s.
 * @enum {string}
 */
// eslint-disable-next-line
var EventListenerLevel = {
    debug: 'debug',
    error: 'error',
    info: 'info',
    warning: 'warning'
};
/**
 * Names of the supported groups for {@link EventListenerEvent}s.
 * @enum {string}
 */
// eslint-disable-next-line
var EventListenerGroup = {
    /**
     * Events associated with the connection to Twilio's signaling server
     */
    signaling: 'signaling'
};
/**
 * An {@link EventListener} allows you to listen to fine-grained {@link EventListenerEvent}s related
 * to signaling and media that are not available in the public APIs, which might be useful for your own
 * reporting and diagnostics.
 * @typedef {EventEmitter} EventListener
 * @example
 * const { EventEmitter } = require('events');
 * const { connect } = require('twilio-video');
 *
 * const eventListener = new EventEmitter();
 * eventListener.on('event', function(event) {
 *   console.log('The SDK raised an event:', event);
 * });
 *
 * connect('token', {
 *   eventListener: eventListener
 * });
 */
/**
 * The SDK raised an {@link EventListenerEvent}.
 * @event EventListener#event
 * @param {EventListenerEvent} event - Context about the event raised by the SDK.
 * This can be one of the following:
 *  * {@link EventListenerClosedEvent}
 *  * {@link EventListenerConnectingEvent}
 *  * {@link EventListenerEarlyEvent}
 *  * {@link EventListenerOpenEvent}
 *  * {@link EventListenerWaitingEvent}
 */
/**
 * An {@link EventListenerEvent} provides context about an event raised by the SDK on the
 * {@link EventListener}. Apart from the properties listed here, it may also include some
 * event-specific data within an optional "payload" property. The different types of
 * {@link EventListenerEvent}s are listed below:
 *  * {@link EventListenerClosedEvent}
 *  * {@link EventListenerConnectingEvent}
 *  * {@link EventListenerEarlyEvent}
 *  * {@link EventListenerOpenEvent}
 *  * {@link EventListenerWaitingEvent}
 * @typedef {object} EventListenerEvent
 * @property {number} elapsedTime - The time elapsed in milliseconds since connect() was called
 * @property {EventListenerGroup} group - The group under which the event is classified
 * @property {EventListenerLevel} level - The verbosity level of the event, which can be one of "debug", "error", "info", "warning"
 * @property {string} name - The name of the event
 * @property {*} [payload] - Optional event-specific data
 * @property {number} timestamp - The time in milliseconds relative to the Unix Epoch when the event was raised
 */
/**
 * The connection to Twilio's signaling server was closed.
 * @typedef {EventListenerEvent} EventListenerClosedEvent
 * @property {EventListenerGroup} group='signaling'
 * @property {EventListenerLevel} level - 'info' if the connection was closed by the client, 'error' otherwise
 * @property {string} name='closed'
 * @property {{reason: string}} payload - Reason for the connection being closed. It can be one of
 *   'busy', 'failed', 'local', 'remote' or 'timeout'
 */
/**
 * The SDK is connecting to Twilio's signaling server.
 * @typedef {EventListenerEvent} EventListenerConnectingEvent
 * @property {EventListenerGroup} group='signaling'
 * @property {EventListenerLevel} level='info'
 * @property {string} name='connecting'
 */
/**
 * The SDK is about to connect to Twilio's signaling server.
 * @typedef {EventListenerEvent} EventListenerEarlyEvent
 * @property {EventListenerGroup} group='signaling'
 * @property {EventListenerLevel} level='info'
 * @property {string} name='early'
 */
/**
 * The SDK has established a signaling connection to Twilio's signaling server.
 * @typedef {EventListenerEvent} EventListenerOpenEvent
 * @property {EventListenerGroup} group='signaling'
 * @property {EventListenerLevel} level='info'
 * @property {string} name='open'
 */
/**
 * The SDK is waiting to retry connecting th Twilio's signaling server. This can
 * happen if the server is busy with too many connection requests.
 * @typedef {EventListenerEvent} EventListenerWaitingEvent
 * @property {EventListenerGroup} group='signaling'
 * @property {EventListenerLevel} level='warning'
 * @property {string} name='waiting'
 */
function deprecateOptions(options, log, deprecationTable) {
    deprecationTable.forEach(function (prop) {
        var didWarn = prop.didWarn, name = prop.name, newName = prop.newName, shouldDelete = prop.shouldDelete;
        if (name in options && typeof options[name] !== 'undefined') {
            if (newName && shouldDelete) {
                options[newName] = options[name];
            }
            if (shouldDelete) {
                delete options[name];
            }
            if (!didWarn && !['error', 'off'].includes(log.level)) {
                log.warn("The ConnectOptions \"" + name + "\" is " + (newName
                    ? "deprecated and scheduled for removal. Please use \"" + newName + "\" instead."
                    : 'no longer applicable and will be ignored.'));
                prop.didWarn = true;
            }
        }
    });
}
function createLocalParticipant(signaling, log, encodingParameters, networkQualityConfiguration, options, localTracks) {
    var localParticipantSignaling = signaling.createLocalParticipantSignaling(encodingParameters, networkQualityConfiguration);
    log.debug('Creating a new LocalParticipant:', localParticipantSignaling);
    return new options.LocalParticipant(localParticipantSignaling, localTracks, options);
}
function createRoom(options, localParticipant, roomSignaling) {
    var room = new Room(localParticipant, roomSignaling, options);
    var log = options.log;
    log.debug('Creating a new Room:', room);
    roomSignaling.on('stateChanged', function stateChanged(state) {
        if (state === 'disconnected') {
            log.info('Disconnected from Room:', room.toString());
            roomSignaling.removeListener('stateChanged', stateChanged);
        }
    });
    return room;
}
function createRoomSignaling(token, options, signaling, encodingParameters, preferredCodecs, localParticipant) {
    options.log.debug('Creating a new RoomSignaling');
    return signaling.connect(localParticipant._signaling, token, encodingParameters, preferredCodecs, options);
}
function getLocalTracks(options, handleLocalTracks) {
    var log = options.log;
    options.shouldStopLocalTracks = !options.tracks;
    if (options.shouldStopLocalTracks) {
        log.info('LocalTracks were not provided, so they will be acquired '
            + 'automatically before connecting to the Room. LocalTracks will '
            + 'be released if connecting to the Room fails or if the Room '
            + 'is disconnected');
    }
    else {
        log.info('Getting LocalTracks');
        log.debug('Options:', options);
    }
    return options.createLocalTracks(options).then(function getLocalTracksSucceeded(localTracks) {
        var promise = handleLocalTracks(localTracks);
        promise.catch(function handleLocalTracksFailed() {
            if (options.shouldStopLocalTracks) {
                log.info('The automatically acquired LocalTracks will now be stopped');
                localTracks.forEach(function (track) {
                    track.stop();
                });
            }
        });
        return promise;
    });
}
function normalizeCodecSettings(nameOrSettings) {
    var settings = typeof nameOrSettings === 'string'
        ? { codec: nameOrSettings }
        : nameOrSettings;
    switch (settings.codec.toLowerCase()) {
        case 'opus': {
            return Object.assign({ dtx: true }, settings);
        }
        case 'vp8': {
            return Object.assign({ simulcast: false }, settings);
        }
        default: {
            return settings;
        }
    }
}
module.exports = connect;

},{"./cancelableroompromise":1,"./encodingparameters":9,"./localparticipant":13,"./media/track/es5":16,"./networkqualityconfiguration":45,"./room":58,"./signaling/v2":72,"./util":133,"./util/cancelablepromise":125,"./util/constants":126,"./util/eventobserver":131,"./util/insightspublisher":134,"./util/insightspublisher/null":135,"./util/log":137,"./util/validate":151,"./webrtc":159,"./webrtc/util":171}],3:[function(require,module,exports){
'use strict';
var _a = require('./util/constants'), DEFAULT_LOG_LEVEL = _a.DEFAULT_LOG_LEVEL, DEFAULT_LOGGER_NAME = _a.DEFAULT_LOGGER_NAME;
/**
 * Request a {@link LocalAudioTrack} or {@link LocalVideoTrack}.
 * @param {Track.Kind} kind - "audio" or "video"
 * @param {CreateLocalTrackOptions} [options]
 * @returns {Promise<LocalAudioTrack|LocalVideoTrack>}
 * @private
 */
function createLocalTrack(kind, options) {
    options = Object.assign({
        loggerName: DEFAULT_LOGGER_NAME,
        logLevel: DEFAULT_LOG_LEVEL,
    }, options);
    var createOptions = {};
    createOptions.loggerName = options.loggerName;
    createOptions.logLevel = options.logLevel;
    delete options.loggerName;
    delete options.logLevel;
    var createLocalTracks = options.createLocalTracks;
    delete options.createLocalTracks;
    createOptions[kind] = Object.keys(options).length > 0 ? options : true;
    return createLocalTracks(createOptions).then(function (localTracks) { return localTracks[0]; });
}
/**
 * Request a {@link LocalAudioTrack}.
 * @alias module:twilio-video.createLocalAudioTrack
 * @param {CreateLocalTracksOptions|CreateLocalAudioTrackOptions} [options] - Options for requesting a {@link LocalAudioTrack}
 * @returns {Promise<LocalAudioTrack>}
 * @example
 * var Video = require('twilio-video');
 *
 * // Connect to the Room with just video
 * Video.connect('my-token', {
 *   name: 'my-cool-room',
 *   video: true
 * }).then(function(room) {
 *   // Add audio after connecting to the Room
 *   Video.createLocalAudioTrack().then(function(localTrack) {
 *     room.localParticipant.publishTrack(localTrack);
 *   });
 * });
 * @example
 * var Video = require('twilio-video');
 *
 * // Request the LocalAudioTrack with a custom name
 * // and krisp noise cancellation
 * Video.createLocalAudioTrack({
 *   name: 'microphone',
 *   noiseCancellationOptions: {
 *      vendor: 'krisp',
 *      sdkAssetsPath: '/twilio-krisp-audio-plugin/1.0.0/dist'
 *   }
 * });
 */
function createLocalAudioTrack(options) {
    return createLocalTrack('audio', options);
}
/**
 * Request a {@link LocalVideoTrack}. Note that on mobile browsers,
 * the camera can be reserved by only one {@link LocalVideoTrack} at any given
 * time. If you attempt to create a second {@link LocalVideoTrack}, video frames
 * will no longer be supplied to the first {@link LocalVideoTrack}.
 * @alias module:twilio-video.createLocalVideoTrack
 * @param {CreateLocalTrackOptions} [options] - Options for requesting a {@link LocalVideoTrack}
 * @returns {Promise<LocalVideoTrack>}
 * @example
 * var Video = require('twilio-video');
 *
 * // Connect to the Room with just audio
 * Video.connect('my-token', {
 *   name: 'my-cool-room',
 *   audio: true
 * }).then(function(room) {
 *   // Add video after connecting to the Room
 *   Video.createLocalVideoTrack().then(function(localTrack) {
 *     room.localParticipant.publishTrack(localTrack);
 *   });
 * });
 * @example
 * var Video = require('twilio-video');
 *
 * // Request the default LocalVideoTrack with a custom name
 * Video.createLocalVideoTrack({ name: 'camera' }).then(function(localTrack) {
 *   console.log(localTrack.name); // 'camera'
 * });
 */
function createLocalVideoTrack(options) {
    return createLocalTrack('video', options);
}
/**
 * {@link NoiseCancellationVendor} specifies the 3rd party plugin to use for noise cancellation.
 * @enum {string}
 */
// eslint-disable-next-line
var NoiseCancellationVendor = {
    /**
     * This plugin can be found by requesting access with this form {@link https://forms.gle/eeFyoGJj1mgMrxN88}
     */
    krisp: 'krisp',
};
/**
 * You can use 3rd party noise cancellation plugin when creating {@link LocalAudioTrack}
 * By specifying these options. This is a beta feature.
 * @typedef {object} NoiseCancellationOptions
 * @property {NoiseCancellationVendor} vendor - Specifies the vendor library to use
 *   You need to obtain and host the library files on your web server.
 * @property {string} sdkAssetsPath - Specifies path where vendor library files are
 *   hosted on your web server.
 */
/**
 * Create {@link LocalAudioTrack} options.
 * @typedef {CreateLocalTrackOptions} CreateLocalAudioTrackOptions
 * @property {boolean} [workaroundWebKitBug180748=false] - setting this
 *   attempts to workaround WebKit Bug 180748, where, in Safari, getUserMedia may return a silent audio
 *   MediaStreamTrack.
 * @property {DefaultDeviceCaptureMode} [defaultDeviceCaptureMode="auto"] - This optional property only applies if the
 *   {@link LocalAudioTrack} is capturing from the default audio input device connected to a desktop or laptop. When the
 *   property is set to "auto", the LocalAudioTrack restarts whenever the default audio input device changes, in order to
 *   capture audio from the new default audio input device. For example, when a bluetooth audio headset is connected to a
 *   Macbook, the LocalAudioTrack will start capturing audio from the headset microphone. When the headset is disconnected,
 *   the LocalAudioTrack will start capturing audio from the Macbook microphone. When the property is set to "manual", the
 *   LocalAudioTrack continues to capture from the same audio input device even after the default audio input device changes.
 *   When the property is not specified, it defaults to "auto".
 * @property {NoiseCancellationOptions} [noiseCancellationOptions] - This optional property enables using 3rd party plugins
 *   for noise cancellation.
 */
/**
 * Create {@link LocalTrack} options. Apart from the properties listed here, you can
 * also specify any of the <a href="https://developer.mozilla.org/en-US/docs/Web/API/MediaTrackConstraints" target="_blank">MediaTrackConstraints</a>
 * properties.
 * @typedef {MediaTrackConstraints} CreateLocalTrackOptions
 * @property {LogLevel|LogLevels} [logLevel='warn'] - <code>(deprecated: use [Video.Logger](module-twilio-video.html) instead.
 *   See [examples](module-twilio-video.html#.connect) for details)</code>
 *   Set the default log verbosity
 *   of logging. Passing a {@link LogLevel} string will use the same
 *   level for all components. Pass a {@link LogLevels} to set specific log
 *   levels.
 * @property {string} [loggerName='twilio-video'] - The name of the logger. Use this name when accessing the logger used by the SDK.
 *   See [examples](module-twilio-video.html#.connect) for details.
 * @property {string} [name] - The {@link LocalTrack}'s name; by default,
 *   it is set to the {@link LocalTrack}'s ID.
 */
module.exports = {
    audio: createLocalAudioTrack,
    video: createLocalVideoTrack
};

},{"./util/constants":126}],4:[function(require,module,exports){
/* eslint-disable @typescript-eslint/no-explicit-any */
'use strict';
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createLocalTracks = void 0;
var noisecancellationimpl_1 = require("./media/track/noisecancellationimpl");
var buildLogLevels = require('./util').buildLogLevels;
var _a = require('./webrtc'), getUserMedia = _a.getUserMedia, MediaStreamTrack = _a.MediaStreamTrack;
var _b = require('./media/track/es5'), LocalAudioTrack = _b.LocalAudioTrack, LocalDataTrack = _b.LocalDataTrack, LocalVideoTrack = _b.LocalVideoTrack;
var Log = require('./util/log');
var _c = require('./util/constants'), DEFAULT_LOG_LEVEL = _c.DEFAULT_LOG_LEVEL, DEFAULT_LOGGER_NAME = _c.DEFAULT_LOGGER_NAME, INVALID_VALUE = _c.typeErrors.INVALID_VALUE;
var workaround180748 = require('./webaudio/workaround180748');
// This is used to make out which createLocalTracks() call a particular Log
// statement belongs to. Each call to createLocalTracks() increments this
// counter.
var createLocalTrackCalls = 0;
/**
 * Request {@link LocalTrack}s. By default, it requests a
 * {@link LocalAudioTrack} and a {@link LocalVideoTrack}.
 * Note that on mobile browsers, the camera can be reserved by only one {@link LocalVideoTrack}
 * at any given time. If you attempt to create a second {@link LocalVideoTrack}, video frames
 * will no longer be supplied to the first {@link LocalVideoTrack}.
 * @alias module:twilio-video.createLocalTracks
 * @param {CreateLocalTracksOptions} [options]
 * @returns {Promise<Array<LocalTrack>>}
 * @example
 * var Video = require('twilio-video');
 * // Request audio and video tracks
 * Video.createLocalTracks().then(function(localTracks) {
 *   var localMediaContainer = document.getElementById('local-media-container-id');
 *   localTracks.forEach(function(track) {
 *     localMediaContainer.appendChild(track.attach());
 *   });
 * });
 * @example
 * var Video = require('twilio-video');
 * // Request just the default audio track
 * Video.createLocalTracks({ audio: true }).then(function(localTracks) {
 *   return Video.connect('my-token', {
 *     name: 'my-cool-room',
 *     tracks: localTracks
 *   });
 * });
 * @example
 * var Video = require('twilio-video');
 * // Request the audio and video tracks with custom names
 * Video.createLocalTracks({
 *   audio: { name: 'microphone' },
 *   video: { name: 'camera' }
 * }).then(function(localTracks) {
 *   localTracks.forEach(function(localTrack) {
 *     console.log(localTrack.name);
 *   });
 * });
 *
 * @example
 * var Video = require('twilio-video');
 * var localTracks;
 *
 * // Pre-acquire tracks to display camera preview.
 * Video.createLocalTracks().then(function(tracks) {
 *  localTracks = tracks;
 *  var localVideoTrack = localTracks.find(track => track.kind === 'video');
 *  divContainer.appendChild(localVideoTrack.attach());
 * })
 *
 * // Later, join the Room with the pre-acquired LocalTracks.
 * Video.connect('token', {
 *   name: 'my-cool-room',
 *   tracks: localTracks
 * });
 *
 */
function createLocalTracks(options) {
    return __awaiter(this, void 0, void 0, function () {
        var isAudioVideoAbsent, fullOptions, logComponentName, logLevels, log, localTrackOptions, extraLocalTrackOptions, noiseCancellationOptions, mediaStreamConstraints, workaroundWebKitBug180748, mediaStream, mediaStreamTracks, error_1;
        var _this = this;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    isAudioVideoAbsent = !(options && ('audio' in options || 'video' in options));
                    fullOptions = __assign({ audio: isAudioVideoAbsent, getUserMedia: getUserMedia, loggerName: DEFAULT_LOGGER_NAME, logLevel: DEFAULT_LOG_LEVEL, LocalAudioTrack: LocalAudioTrack,
                        LocalDataTrack: LocalDataTrack,
                        LocalVideoTrack: LocalVideoTrack,
                        MediaStreamTrack: MediaStreamTrack,
                        Log: Log, video: isAudioVideoAbsent }, options);
                    logComponentName = "[createLocalTracks #" + ++createLocalTrackCalls + "]";
                    logLevels = buildLogLevels(fullOptions.logLevel);
                    log = new fullOptions.Log('default', logComponentName, logLevels, fullOptions.loggerName);
                    localTrackOptions = Object.assign({ log: log }, fullOptions);
                    // NOTE(mmalavalli): The Room "name" in "options" was being used
                    // as the LocalTrack name in asLocalTrack(). So we pass a copy of
                    // "options" without the "name".
                    // NOTE(joma): CreateLocalTracksOptions type does not really have a "name" property when used publicly by customers.
                    // But we are passing this property when used internally by other JS files.
                    // We can update this "any" type once those JS files are converted to TS.
                    delete localTrackOptions.name;
                    if (fullOptions.audio === false && fullOptions.video === false) {
                        log.info('Neither audio nor video requested, so returning empty LocalTracks');
                        return [2 /*return*/, []];
                    }
                    if (fullOptions.tracks) {
                        log.info('Adding user-provided LocalTracks');
                        log.debug('LocalTracks:', fullOptions.tracks);
                        return [2 /*return*/, fullOptions.tracks];
                    }
                    extraLocalTrackOptions = {
                        audio: typeof fullOptions.audio === 'object' && fullOptions.audio.name
                            ? { name: fullOptions.audio.name }
                            : { defaultDeviceCaptureMode: 'auto' },
                        video: typeof fullOptions.video === 'object' && fullOptions.video.name
                            ? { name: fullOptions.video.name }
                            : {}
                    };
                    extraLocalTrackOptions.audio.isCreatedByCreateLocalTracks = true;
                    extraLocalTrackOptions.video.isCreatedByCreateLocalTracks = true;
                    if (typeof fullOptions.audio === 'object') {
                        if (typeof fullOptions.audio.workaroundWebKitBug1208516 === 'boolean') {
                            extraLocalTrackOptions.audio.workaroundWebKitBug1208516 = fullOptions.audio.workaroundWebKitBug1208516;
                        }
                        if ('noiseCancellationOptions' in fullOptions.audio) {
                            noiseCancellationOptions = fullOptions.audio.noiseCancellationOptions;
                            delete fullOptions.audio.noiseCancellationOptions;
                        }
                        if (!('defaultDeviceCaptureMode' in fullOptions.audio)) {
                            extraLocalTrackOptions.audio.defaultDeviceCaptureMode = 'auto';
                        }
                        else if (['auto', 'manual'].every(function (mode) { return mode !== fullOptions.audio.defaultDeviceCaptureMode; })) {
                            // eslint-disable-next-line new-cap
                            throw INVALID_VALUE('CreateLocalAudioTrackOptions.defaultDeviceCaptureMode', ['auto', 'manual']);
                        }
                        else {
                            extraLocalTrackOptions.audio.defaultDeviceCaptureMode = fullOptions.audio.defaultDeviceCaptureMode;
                        }
                    }
                    if (typeof fullOptions.video === 'object' && typeof fullOptions.video.workaroundWebKitBug1208516 === 'boolean') {
                        extraLocalTrackOptions.video.workaroundWebKitBug1208516 = fullOptions.video.workaroundWebKitBug1208516;
                    }
                    if (typeof fullOptions.audio === 'object') {
                        delete fullOptions.audio.name;
                    }
                    if (typeof fullOptions.video === 'object') {
                        delete fullOptions.video.name;
                    }
                    mediaStreamConstraints = {
                        audio: fullOptions.audio,
                        video: fullOptions.video
                    };
                    workaroundWebKitBug180748 = typeof fullOptions.audio === 'object' && fullOptions.audio.workaroundWebKitBug180748;
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 4, , 5]);
                    return [4 /*yield*/, (workaroundWebKitBug180748
                            ? workaround180748(log, fullOptions.getUserMedia, mediaStreamConstraints)
                            : fullOptions.getUserMedia(mediaStreamConstraints))];
                case 2:
                    mediaStream = _a.sent();
                    mediaStreamTracks = __spreadArray(__spreadArray([], __read(mediaStream.getAudioTracks())), __read(mediaStream.getVideoTracks()));
                    log.info('Call to getUserMedia successful; got tracks:', mediaStreamTracks);
                    return [4 /*yield*/, Promise.all(mediaStreamTracks.map(function (mediaStreamTrack) { return __awaiter(_this, void 0, void 0, function () {
                            var _a, cleanTrack, noiseCancellation;
                            return __generator(this, function (_b) {
                                switch (_b.label) {
                                    case 0:
                                        if (!(mediaStreamTrack.kind === 'audio' && noiseCancellationOptions)) return [3 /*break*/, 2];
                                        return [4 /*yield*/, noisecancellationimpl_1.applyNoiseCancellation(mediaStreamTrack, noiseCancellationOptions, log)];
                                    case 1:
                                        _a = _b.sent(), cleanTrack = _a.cleanTrack, noiseCancellation = _a.noiseCancellation;
                                        return [2 /*return*/, new localTrackOptions.LocalAudioTrack(cleanTrack, __assign(__assign(__assign({}, extraLocalTrackOptions.audio), localTrackOptions), { noiseCancellation: noiseCancellation }))];
                                    case 2:
                                        if (mediaStreamTrack.kind === 'audio') {
                                            return [2 /*return*/, new localTrackOptions.LocalAudioTrack(mediaStreamTrack, __assign(__assign({}, extraLocalTrackOptions.audio), localTrackOptions))];
                                        }
                                        _b.label = 3;
                                    case 3: return [2 /*return*/, new localTrackOptions.LocalVideoTrack(mediaStreamTrack, __assign(__assign({}, extraLocalTrackOptions.video), localTrackOptions))];
                                }
                            });
                        }); }))];
                case 3: return [2 /*return*/, _a.sent()];
                case 4:
                    error_1 = _a.sent();
                    log.warn('Call to getUserMedia failed:', error_1);
                    throw error_1;
                case 5: return [2 /*return*/];
            }
        });
    });
}
exports.createLocalTracks = createLocalTracks;

},{"./media/track/es5":16,"./media/track/noisecancellationimpl":30,"./util":133,"./util/constants":126,"./util/log":137,"./webaudio/workaround180748":156,"./webrtc":159}],5:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var DataTrackTransceiver = require('./transceiver');
var DataTransport = require('./transport');
/**
 * A {@link DataTrackReceiver} represents a {@link DataTrackTransceiver} over
 * which data can be received. Internally, it users a single RTCDataChannel to
 * receive data.
 * @extends DataTrackTransceiver
 * @emits DataTrackReceiver#message
 * @emits DataTrackReceiver#close
 */
var DataTrackReceiver = /** @class */ (function (_super) {
    __extends(DataTrackReceiver, _super);
    /**
     * Construct an {@link DataTrackReceiver}.
     * @param {RTCDataChannel} dataChannel
     */
    function DataTrackReceiver(dataChannel) {
        var _this = _super.call(this, dataChannel.label, dataChannel.maxPacketLifeTime, dataChannel.maxRetransmits, dataChannel.ordered) || this;
        Object.defineProperties(_this, {
            _dataChannel: {
                value: dataChannel
            }
        });
        // NOTE(mmalavalli): In Firefox, the default value for "binaryType" is "blob".
        // So, we set it to "arraybuffer" to ensure that it is consistent with Chrome
        // and Safari.
        dataChannel.binaryType = 'arraybuffer';
        dataChannel.addEventListener('message', function (event) {
            _this.emit('message', event.data);
        });
        dataChannel.addEventListener('close', function () {
            _this.emit('close');
        });
        return _this;
    }
    DataTrackReceiver.prototype.stop = function () {
        this._dataChannel.close();
        _super.prototype.stop.call(this);
    };
    /**
     * Create a {@link DataTransport} from the {@link DataTrackReceiver}.
     * @returns {DataTransport}
     */
    DataTrackReceiver.prototype.toDataTransport = function () {
        return new DataTransport(this._dataChannel);
    };
    return DataTrackReceiver;
}(DataTrackTransceiver));
/**
 * @event DataTrackReceiver#message
 * @param {string|ArrayBuffer} data
 */
/**
 * @event DataTrackReceiver#close
 */
module.exports = DataTrackReceiver;

},{"./transceiver":7,"./transport":8}],6:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var DataTrackTransceiver = require('./transceiver');
var makeUUID = require('../util').makeUUID;
/**
 * A {@link DataTrackSender} represents a {@link DataTrackTransceiver} over
 * which data can be sent. Internally, it uses a collection of RTCDataChannels
 * to send data.
 * @extends DataTrackTransceiver
 */
var DataTrackSender = /** @class */ (function (_super) {
    __extends(DataTrackSender, _super);
    /**
     * Construct a {@link DataTrackSender}.
     * @param {?number} maxPacketLifeTime
     * @param {?number} maxRetransmits
     * @param {boolean} ordered
     */
    function DataTrackSender(maxPacketLifeTime, maxRetransmtis, ordered) {
        var _this = _super.call(this, makeUUID(), maxPacketLifeTime, maxRetransmtis, ordered) || this;
        Object.defineProperties(_this, {
            _clones: {
                value: new Set()
            },
            _dataChannels: {
                value: new Set()
            }
        });
        return _this;
    }
    /**
     * Add a cloned {@link DataTrackSender}.
     * @private
     * @returns {void}
     */
    DataTrackSender.prototype._addClone = function (clone) {
        this._clones.add(clone);
    };
    /**
     * Remove a cloned {@link DataTrackSender}.
     * @returns {void}
     */
    DataTrackSender.prototype.removeClone = function (clone) {
        this._clones.delete(clone);
    };
    /**
     * Add an RTCDataChannel to the {@link DataTrackSender}.
     * @param {RTCDataChannel} dataChannel
     * @returns {this}
     */
    DataTrackSender.prototype.addDataChannel = function (dataChannel) {
        this._dataChannels.add(dataChannel);
        return this;
    };
    /**
     * Return a new {@link DataTrackSender}. Any message sent over this
     * {@link DataTrackSender} will also be sent over the clone. Whenever this
     * {@link DataTrackSender} is stopped, so to will the clone.
     * @returns {DataTrackSender}
     */
    DataTrackSender.prototype.clone = function () {
        var _this = this;
        var clone = new DataTrackSender(this.maxPacketLifeTime, this.maxRetransmits, this.ordered);
        this._addClone(clone);
        clone.once('stopped', function () { return _this.removeClone(clone); });
        return clone;
    };
    /**
     * Remove an RTCDataChannel from the {@link DataTrackSender}.
     * @param {RTCDataChannel} dataChannel
     * @returns {this}
     */
    DataTrackSender.prototype.removeDataChannel = function (dataChannel) {
        this._dataChannels.delete(dataChannel);
        return this;
    };
    /**
     * Send data over the {@link DataTrackSender}. Internally, this calls
     * <code>send</code> over each of the underlying RTCDataChannels.
     * @param {string|Blob|ArrayBuffer|ArrayBufferView} data
     * @returns {this}
     */
    DataTrackSender.prototype.send = function (data) {
        this._dataChannels.forEach(function (dataChannel) {
            try {
                dataChannel.send(data);
            }
            catch (error) {
                // Do nothing.
            }
        });
        this._clones.forEach(function (clone) {
            try {
                clone.send(data);
            }
            catch (error) {
                // Do nothing.
            }
        });
        return this;
    };
    DataTrackSender.prototype.stop = function () {
        this._dataChannels.forEach(function (dataChannel) { return dataChannel.close(); });
        this._clones.forEach(function (clone) { return clone.stop(); });
        _super.prototype.stop.call(this);
    };
    return DataTrackSender;
}(DataTrackTransceiver));
module.exports = DataTrackSender;

},{"../util":133,"./transceiver":7}],7:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var TrackTransceiver = require('../transceiver');
/**
 * A {@link DataTrackTransceiver} represents either one or more local
 * RTCDataChannels or a single remote RTCDataChannel. It can be used to send or
 * receive data.
 * @extends TrackTransceiver
 * @property {string} id
 * @property {string} kind - "data"
 * @property {?number} maxPacketLifeTime
 * @property {?number} maxRetransmits
 * @property {boolean} ordered
 */
var DataTrackTransceiver = /** @class */ (function (_super) {
    __extends(DataTrackTransceiver, _super);
    /**
     * Construct a {@link DataTrackTransceiver}.
     * @param {string} id
     * @param {?number} maxPacketLifeTime
     * @param {?number} maxRetransmits
     * @param {boolean} ordered
     */
    function DataTrackTransceiver(id, maxPacketLifeTime, maxRetransmits, ordered) {
        var _this = _super.call(this, id, 'data') || this;
        Object.defineProperties(_this, {
            maxPacketLifeTime: {
                enumerable: true,
                value: maxPacketLifeTime
            },
            maxRetransmits: {
                enumerable: true,
                value: maxRetransmits
            },
            ordered: {
                enumerable: true,
                value: ordered
            }
        });
        return _this;
    }
    return DataTrackTransceiver;
}(TrackTransceiver));
module.exports = DataTrackTransceiver;

},{"../transceiver":120}],8:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var EventEmitter = require('events').EventEmitter;
/**
 * @classdesc A {@link DataTransport} implements {@link MediaSignalingTransport}
 *   in terms of an RTCDataChannel.
 * @extends EventEmitter
 * @implements MediaSignalingTransport
 * @emits DataTransport#message
 */
var DataTransport = /** @class */ (function (_super) {
    __extends(DataTransport, _super);
    /**
     * Construct a {@link DataTransport}.
     * @param {RTCDataChannel} dataChannel
     */
    function DataTransport(dataChannel) {
        var _this = _super.call(this) || this;
        Object.defineProperties(_this, {
            _dataChannel: {
                value: dataChannel
            },
            _messageQueue: {
                value: []
            }
        });
        dataChannel.addEventListener('open', function () {
            _this._messageQueue.splice(0).forEach(function (message) { return _this._publish(message); });
        });
        dataChannel.addEventListener('message', function (_a) {
            var data = _a.data;
            try {
                var message = JSON.parse(data);
                _this.emit('message', message);
            }
            catch (error) {
                // Do nothing.
            }
        });
        _this.publish({ type: 'ready' });
        return _this;
    }
    /**
     * @param message
     * @private
     */
    DataTransport.prototype._publish = function (message) {
        var data = JSON.stringify(message);
        try {
            this._dataChannel.send(data);
        }
        catch (error) {
            // Do nothing.
        }
    };
    /**
     * Publish a message. Returns true if calling the method resulted in
     * publishing (or eventually publishing) the update.
     * @param {object} message
     * @returns {boolean}
     */
    DataTransport.prototype.publish = function (message) {
        var dataChannel = this._dataChannel;
        if (dataChannel.readyState === 'closing' || dataChannel.readyState === 'closed') {
            return false;
        }
        if (dataChannel.readyState === 'connecting') {
            this._messageQueue.push(message);
            return true;
        }
        this._publish(message);
        return true;
    };
    return DataTransport;
}(EventEmitter));
/**
 * The {@link DataTransport} received a message.
 * @event DataTransport#message
 * @param {object} message
 */
module.exports = DataTransport;

},{"events":174}],9:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var EventEmitter = require('events').EventEmitter;
/**
 * {@link EncodingParametersImpl} represents an object which notifies its
 * listeners of any changes in the values of its properties.
 * @extends EventEmitter
 * @implements EncodingParameters
 * @emits EncodingParametersImpl#changed
 * @property {?number} maxAudioBitrate
 * @property {?number} maxVideoBitrate
 */
var EncodingParametersImpl = /** @class */ (function (_super) {
    __extends(EncodingParametersImpl, _super);
    /**
     * Construct an {@link EncodingParametersImpl}.
     * @param {EncodingParamters} encodingParameters - Initial {@link EncodingParameters}
     * @param {Boolean} adaptiveSimulcast - true if adaptive simulcast was enabled by connect options.
     */
    function EncodingParametersImpl(encodingParameters, adaptiveSimulcast) {
        var _this = _super.call(this) || this;
        encodingParameters = Object.assign({
            maxAudioBitrate: null,
            maxVideoBitrate: null
        }, encodingParameters);
        Object.defineProperties(_this, {
            maxAudioBitrate: {
                value: encodingParameters.maxAudioBitrate,
                writable: true
            },
            maxVideoBitrate: {
                value: encodingParameters.maxVideoBitrate,
                writable: true
            },
            adaptiveSimulcast: {
                value: adaptiveSimulcast
            }
        });
        return _this;
    }
    /**
     * Returns the bitrate values in an {@link EncodingParameters}.
     * @returns {EncodingParameters}
     */
    EncodingParametersImpl.prototype.toJSON = function () {
        return {
            maxAudioBitrate: this.maxAudioBitrate,
            maxVideoBitrate: this.maxVideoBitrate
        };
    };
    /**
     * Update the bitrate values with those in the given {@link EncodingParameters}.
     * @param {EncodingParameters} encodingParameters - The new {@link EncodingParameters}
     * @fires EncodingParametersImpl#changed
     */
    EncodingParametersImpl.prototype.update = function (encodingParameters) {
        var _this = this;
        encodingParameters = Object.assign({
            maxAudioBitrate: this.maxAudioBitrate,
            maxVideoBitrate: this.maxVideoBitrate
        }, encodingParameters);
        var shouldEmitChanged = [
            'maxAudioBitrate',
            'maxVideoBitrate'
        ].reduce(function (shouldEmitChanged, maxKindBitrate) {
            if (_this[maxKindBitrate] !== encodingParameters[maxKindBitrate]) {
                _this[maxKindBitrate] = encodingParameters[maxKindBitrate];
                shouldEmitChanged = true;
            }
            return shouldEmitChanged;
        }, false);
        if (shouldEmitChanged) {
            this.emit('changed');
        }
    };
    return EncodingParametersImpl;
}(EventEmitter));
/**
 * At least one of the {@link EncodingParametersImpl}'s bitrate values changed.
 * @event EncodingParametersImpl#changed
 */
module.exports = EncodingParametersImpl;

},{"events":174}],10:[function(require,module,exports){
'use strict';
var EventEmitter = require('events').EventEmitter;
var hidePrivateAndCertainPublicPropertiesInClass = require('./util').hidePrivateAndCertainPublicPropertiesInClass;
module.exports = hidePrivateAndCertainPublicPropertiesInClass(EventEmitter, ['domain']);

},{"./util":133,"events":174}],11:[function(require,module,exports){
'use strict';
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var EventEmitter = require('events').EventEmitter;
var EventTarget = /** @class */ (function () {
    function EventTarget() {
        Object.defineProperties(this, {
            _eventEmitter: {
                value: new EventEmitter()
            }
        });
    }
    EventTarget.prototype.dispatchEvent = function (event) {
        return this._eventEmitter.emit(event.type, event);
    };
    EventTarget.prototype.addEventListener = function () {
        var _a;
        return (_a = this._eventEmitter).addListener.apply(_a, __spreadArray([], __read(arguments)));
    };
    EventTarget.prototype.removeEventListener = function () {
        var _a;
        return (_a = this._eventEmitter).removeListener.apply(_a, __spreadArray([], __read(arguments)));
    };
    return EventTarget;
}());
module.exports = EventTarget;

},{"events":174}],12:[function(require,module,exports){
'use strict';
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var createlocaltracks_1 = require("./createlocaltracks");
var preflighttest_1 = require("./preflight/preflighttest");
var internals = {
    connect: require('./connect'),
    createLocalAudioTrack: require('./createlocaltrack').audio,
    createLocalVideoTrack: require('./createlocaltrack').video,
    isSupported: require('./util/support')(),
    version: require('../package.json').version,
    Logger: require('./vendor/loglevel'),
    LocalAudioTrack: require('./media/track/es5').LocalAudioTrack,
    LocalDataTrack: require('./media/track/es5').LocalDataTrack,
    LocalVideoTrack: require('./media/track/es5').LocalVideoTrack
};
function connect(token, options) {
    var internalOptions = __assign({ createLocalTracks: createlocaltracks_1.createLocalTracks }, options);
    return internals.connect(token, internalOptions);
}
function createLocalAudioTrack(options) {
    var internalOptions = __assign({ createLocalTracks: createlocaltracks_1.createLocalTracks }, options);
    return internals.createLocalAudioTrack(internalOptions);
}
function createLocalVideoTrack(options) {
    var internalOptions = __assign({ createLocalTracks: createlocaltracks_1.createLocalTracks }, options);
    return internals.createLocalVideoTrack(internalOptions);
}
/**
 * @module twilio-video
 * @property {boolean} isSupported - true if the current browser is officially
 *   supported by twilio-video.js; In this context, "supported" means that
 *   twilio-video.js has been extensively tested with this browser; This
 *   <a href="https://www.twilio.com/docs/video/javascript#supported-browsers" target="_blank">table</a>
 *   specifies the list of officially supported browsers.
 *
 * @property {object} Logger - The <a href="https://www.npmjs.com/package/loglevel" target="_blank">loglevel</a>
 *    module used by the SDK. Use this object to access the internal loggers and perform actions as defined by the
 *   <a href="https://www.npmjs.com/package/loglevel" target="_blank">loglevel</a> APIs.
 *   See [connect](#.connect) for examples.
 *
 * @property {string} version - current version of twilio-video.js.
 */
var isSupported = internals.isSupported;
var version = internals.version;
var Logger = internals.Logger;
var LocalAudioTrack = internals.LocalAudioTrack;
var LocalVideoTrack = internals.LocalVideoTrack;
var LocalDataTrack = internals.LocalDataTrack;
module.exports = {
    connect: connect,
    createLocalAudioTrack: createLocalAudioTrack,
    createLocalVideoTrack: createLocalVideoTrack,
    createLocalTracks: createlocaltracks_1.createLocalTracks,
    runPreflight: preflighttest_1.runPreflight,
    isSupported: isSupported,
    version: version,
    Logger: Logger,
    LocalAudioTrack: LocalAudioTrack,
    LocalVideoTrack: LocalVideoTrack,
    LocalDataTrack: LocalDataTrack,
};

},{"../package.json":175,"./connect":2,"./createlocaltrack":3,"./createlocaltracks":4,"./media/track/es5":16,"./preflight/preflighttest":52,"./util/support":146,"./vendor/loglevel":153}],13:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var MediaStreamTrack = require('./webrtc').MediaStreamTrack;
var _a = require('./util'), asLocalTrack = _a.asLocalTrack, asLocalTrackPublication = _a.asLocalTrackPublication, trackClass = _a.trackClass;
var _b = require('./util/constants'), E = _b.typeErrors, trackPriority = _b.trackPriority;
var validateLocalTrack = require('./util/validate').validateLocalTrack;
var _c = require('./media/track/es5'), LocalAudioTrack = _c.LocalAudioTrack, LocalDataTrack = _c.LocalDataTrack, LocalVideoTrack = _c.LocalVideoTrack;
var LocalAudioTrackPublication = require('./media/track/localaudiotrackpublication');
var LocalDataTrackPublication = require('./media/track/localdatatrackpublication');
var LocalVideoTrackPublication = require('./media/track/localvideotrackpublication');
var Participant = require('./participant');
/**
 * A {@link LocalParticipant} represents the local {@link Participant} in a
 * {@link Room}.
 * @extends Participant
 * @property {Map<Track.SID, LocalAudioTrackPublication>} audioTracks -
 *    The {@link LocalParticipant}'s {@link LocalAudioTrackPublication}s
 * @property {Map<Track.SID, LocalDataTrackPublication>} dataTracks -
 *    The {@link LocalParticipant}'s {@link LocalDataTrackPublication}s
 * @property {Map<Track.SID, LocalTrackPublication>} tracks -
 *    The {@link LocalParticipant}'s {@link LocalTrackPublication}s
 * @property {Map<Track.SID, LocalVideoTrackPublication>} videoTracks -
 *    The {@link LocalParticipant}'s {@link LocalVideoTrackPublication}s
 * @property {string} signalingRegion - The geographical region of the
 *     signaling edge the {@link LocalParticipant} is connected to.
 *
 * @emits RemoteParticipant#reconnected
 * @emits RemoteParticipant#reconnecting
 * @emits LocalParticipant#trackDimensionsChanged
 * @emits LocalParticipant#trackDisabled
 * @emits LocalParticipant#trackEnabled
 * @emits LocalParticipant#trackPublicationFailed
 * @emits LocalParticipant#trackPublished
 * @emits LocalParticipant#trackStarted
 * @emits LocalParticipant#trackStopped
 * @emits LocalParticipant#trackWarning
 * @emits LocalParticipant#trackWarningsCleared
 */
var LocalParticipant = /** @class */ (function (_super) {
    __extends(LocalParticipant, _super);
    /**
     * Construct a {@link LocalParticipant}.
     * @param {ParticipantSignaling} signaling
     * @param {Array<LocalTrack>} localTracks
     * @param {Object} options
     */
    function LocalParticipant(signaling, localTracks, options) {
        var _this = this;
        options = Object.assign({
            LocalAudioTrack: LocalAudioTrack,
            LocalVideoTrack: LocalVideoTrack,
            LocalDataTrack: LocalDataTrack,
            MediaStreamTrack: MediaStreamTrack,
            LocalAudioTrackPublication: LocalAudioTrackPublication,
            LocalVideoTrackPublication: LocalVideoTrackPublication,
            LocalDataTrackPublication: LocalDataTrackPublication,
            shouldStopLocalTracks: false,
            tracks: localTracks
        }, options);
        var tracksToStop = options.shouldStopLocalTracks
            ? new Set(localTracks.filter(function (localTrack) { return localTrack.kind !== 'data'; }))
            : new Set();
        _this = _super.call(this, signaling, options) || this;
        Object.defineProperties(_this, {
            _eventObserver: {
                value: options.eventObserver
            },
            _LocalAudioTrack: {
                value: options.LocalAudioTrack
            },
            _LocalDataTrack: {
                value: options.LocalDataTrack
            },
            _LocalVideoTrack: {
                value: options.LocalVideoTrack
            },
            _MediaStreamTrack: {
                value: options.MediaStreamTrack
            },
            _LocalAudioTrackPublication: {
                value: options.LocalAudioTrackPublication
            },
            _LocalDataTrackPublication: {
                value: options.LocalDataTrackPublication
            },
            _LocalVideoTrackPublication: {
                value: options.LocalVideoTrackPublication
            },
            _tracksToStop: {
                value: tracksToStop
            },
            signalingRegion: {
                enumerable: true,
                get: function () {
                    return signaling.signalingRegion;
                }
            }
        });
        _this._handleTrackSignalingEvents();
        return _this;
    }
    /**
     * @private
     * @param {LocalTrack} track
     * @param {Track.ID} id
     * @param {Track.Priority} priority
     * @returns {?LocalTrack}
     */
    LocalParticipant.prototype._addTrack = function (track, id, priority) {
        var addedTrack = _super.prototype._addTrack.call(this, track, id);
        if (addedTrack && this.state !== 'disconnected') {
            this._addLocalTrack(track, priority);
        }
        return addedTrack;
    };
    /**
     * @private
     * @param {LocalTrack} track
     * @param {Track.Priority} priority
     * @returns {void}
     */
    LocalParticipant.prototype._addLocalTrack = function (track, priority) {
        var _a;
        // check if track has noise cancellation enabled.
        var vendor = (_a = track.noiseCancellation) === null || _a === void 0 ? void 0 : _a.vendor;
        this._signaling.addTrack(track._trackSender, track.name, priority, vendor);
        this._log.info("Added a new " + trackClass(track, true) + ":", track.id);
        this._log.debug(trackClass(track, true) + ":", track);
    };
    /**
     * @private
     * @param {LocalTrack} track
     * @param {Track.ID} id
     * @returns {?LocalTrack}
     */
    LocalParticipant.prototype._removeTrack = function (track, id) {
        var removedTrack = _super.prototype._removeTrack.call(this, track, id);
        if (removedTrack && this.state !== 'disconnected') {
            this._signaling.removeTrack(track._trackSender);
            this._log.info("Removed a " + trackClass(track, true) + ":", track.id);
            this._log.debug(trackClass(track, true) + ":", track);
        }
        return removedTrack;
    };
    /**
     * Get the {@link LocalTrack} events to re-emit.
     * @private
     * @returns {Array<Array<string>>} events
     */
    LocalParticipant.prototype._getTrackEvents = function () {
        return _super.prototype._getTrackEvents.call(this).concat([
            ['disabled', 'trackDisabled'],
            ['enabled', 'trackEnabled'],
            ['stopped', 'trackStopped']
        ]);
    };
    LocalParticipant.prototype.toString = function () {
        return "[LocalParticipant #" + this._instanceId + (this.sid ? ": " + this.sid : '') + "]";
    };
    /**
     * @private
     */
    LocalParticipant.prototype._handleTrackSignalingEvents = function () {
        var _this = this;
        var log = this._log;
        if (this.state === 'disconnected') {
            return;
        }
        var localTrackDisabled = function (localTrack) {
            var trackSignaling = _this._signaling.getPublication(localTrack._trackSender);
            if (trackSignaling) {
                trackSignaling.disable();
                log.debug("Disabled the " + trackClass(localTrack, true) + ":", localTrack.id);
            }
        };
        var localTrackEnabled = function (localTrack) {
            var trackSignaling = _this._signaling.getPublication(localTrack._trackSender);
            if (trackSignaling) {
                trackSignaling.enable();
                log.debug("Enabled the " + trackClass(localTrack, true) + ":", localTrack.id);
            }
        };
        var localTrackStopped = function (localTrack) {
            // NOTE(mroberts): We shouldn't need to check for `stop`, since DataTracks
            // do not emit "stopped".
            var trackSignaling = _this._signaling.getPublication(localTrack._trackSender);
            if (trackSignaling) {
                trackSignaling.stop();
            }
            return trackSignaling;
        };
        var stateChanged = function (state) {
            log.debug('Transitioned to state:', state);
            if (state === 'disconnected') {
                log.debug('Removing LocalTrack event listeners');
                _this._signaling.removeListener('stateChanged', stateChanged);
                _this.removeListener('trackDisabled', localTrackDisabled);
                _this.removeListener('trackEnabled', localTrackEnabled);
                _this.removeListener('trackStopped', localTrackStopped);
                // NOTE(mmalavalli): Remove the stale MediaTrackSender clones so that we
                // do not call replaceTrack() on their RTCRtpSenders.
                _this._tracks.forEach(function (track) {
                    var trackSignaling = localTrackStopped(track);
                    if (trackSignaling) {
                        track._trackSender.removeClone(trackSignaling._trackTransceiver);
                    }
                });
                log.info("LocalParticipant disconnected. Stopping " + _this._tracksToStop.size + " automatically-acquired LocalTracks");
                _this._tracksToStop.forEach(function (track) {
                    track.stop();
                });
            }
            else if (state === 'connected') {
                // NOTE(mmalavalli): Any transition to "connected" here is a result of
                // successful signaling reconnection, and not a first-time establishment
                // of the signaling connection.
                log.info('reconnected');
                // NOTE(mpatwardhan): `stateChanged` can get emitted with StateMachine locked.
                // Do not signal  public events synchronously with lock held.
                setTimeout(function () { return _this.emit('reconnected'); }, 0);
            }
        };
        this.on('trackDisabled', localTrackDisabled);
        this.on('trackEnabled', localTrackEnabled);
        this.on('trackStopped', localTrackStopped);
        this._signaling.on('stateChanged', stateChanged);
        this._tracks.forEach(function (track) {
            _this._addLocalTrack(track, trackPriority.PRIORITY_STANDARD);
            _this._getOrCreateLocalTrackPublication(track).catch(function (error) {
                // Just log a warning for now.
                log.warn("Failed to get or create LocalTrackPublication for " + track + ":", error);
            });
        });
    };
    /**
     * @private
     * @param {LocalTrack} localTrack
     * @returns {Promise<LocalTrackPublication>}
     */
    LocalParticipant.prototype._getOrCreateLocalTrackPublication = function (localTrack) {
        var localTrackPublication = getTrackPublication(this.tracks, localTrack);
        if (localTrackPublication) {
            return Promise.resolve(localTrackPublication);
        }
        var log = this._log;
        var self = this;
        var trackSignaling = this._signaling.getPublication(localTrack._trackSender);
        if (!trackSignaling) {
            return Promise.reject(new Error("Unexpected error: The " + localTrack + " cannot be published"));
        }
        return new Promise(function (resolve, reject) {
            function updated() {
                var error = trackSignaling.error;
                if (error) {
                    trackSignaling.removeListener('updated', updated);
                    log.warn("Failed to publish the " + trackClass(localTrack, true) + ": " + error.message);
                    self._removeTrack(localTrack, localTrack.id);
                    setTimeout(function () {
                        self.emit('trackPublicationFailed', error, localTrack);
                    });
                    reject(error);
                    return;
                }
                if (!self._tracks.has(localTrack.id)) {
                    trackSignaling.removeListener('updated', updated);
                    reject(new Error("The " + localTrack + " was unpublished"));
                    return;
                }
                var sid = trackSignaling.sid;
                if (!sid) {
                    return;
                }
                trackSignaling.removeListener('updated', updated);
                var options = {
                    log: log,
                    LocalAudioTrackPublication: self._LocalAudioTrackPublication,
                    LocalDataTrackPublication: self._LocalDataTrackPublication,
                    LocalVideoTrackPublication: self._LocalVideoTrackPublication
                };
                localTrackPublication = getTrackPublication(self.tracks, localTrack);
                var warningHandler = function (twilioWarningName) {
                    return self.emit('trackWarning', twilioWarningName, localTrackPublication);
                };
                var warningsClearedHandler = function () {
                    return self.emit('trackWarningsCleared', localTrackPublication);
                };
                var unpublish = function (publication) {
                    localTrackPublication.removeListener('trackWarning', warningHandler);
                    localTrackPublication.removeListener('trackWarningsCleared', warningsClearedHandler);
                    self.unpublishTrack(publication.track);
                };
                if (!localTrackPublication) {
                    localTrackPublication = asLocalTrackPublication(localTrack, trackSignaling, unpublish, options);
                    self._addTrackPublication(localTrackPublication);
                }
                localTrackPublication.on('warning', warningHandler);
                localTrackPublication.on('warningsCleared', warningsClearedHandler);
                var state = self._signaling.state;
                if (state === 'connected' || state === 'connecting') {
                    if (localTrack._processorEventObserver) {
                        localTrack._processorEventObserver.on('event', function (event) {
                            self._eventObserver.emit('event', {
                                name: event.name,
                                payload: event.data,
                                group: 'video-processor',
                                level: 'info'
                            });
                        });
                    }
                    // NOTE(csantos): For tracks created before joining a room or already joined but about to publish it
                    if (localTrack.processedTrack) {
                        localTrack._captureFrames();
                        localTrack._setSenderMediaStreamTrack(true);
                    }
                }
                if (state === 'connected') {
                    setTimeout(function () {
                        self.emit('trackPublished', localTrackPublication);
                    });
                }
                resolve(localTrackPublication);
            }
            trackSignaling.on('updated', updated);
        });
    };
    /**
     * Publishes a {@link LocalTrack} to the {@link Room}.
     * @param {LocalTrack} localTrack - The {@link LocalTrack} to publish
     * @param {LocalTrackPublishOptions} [options] - The {@link LocalTrackPublishOptions}
     *   for publishing the {@link LocalTrack}
     * @returns {Promise<LocalTrackPublication>} - Resolves with the corresponding
     *   {@link LocalTrackPublication} if successful; In a Large Group Room (Maximum
     *   Participants greater than 50), rejects with a {@link ParticipantMaxTracksExceededError}
     *   if either the total number of published Tracks in the Room exceeds 16, or the {@link LocalTrack}
     *   is part of a set of {@link LocalTrack}s which along with the published Tracks exceeds 16.
     * @throws {TypeError}
     * @throws {RangeError}
     * @example
     * var Video = require('twilio-video');
     *
     * Video.connect(token, {
     *   name: 'my-cool-room',
     *   audio: true
     * }).then(function(room) {
     *   return Video.createLocalVideoTrack({
     *     name: 'camera'
     *   }).then(function(localVideoTrack) {
     *     return room.localParticipant.publishTrack(localVideoTrack, {
     *       priority: 'high'
     *     });
     *   });
     * }).then(function(publication) {
     *   console.log('The LocalTrack "' + publication.trackName
     *     + '" was successfully published with priority "'
     *     * publication.priority + '"');
     * });
    */ /**
     * Publishes a MediaStreamTrack to the {@link Room}.
     * @param {MediaStreamTrack} mediaStreamTrack - The MediaStreamTrack
     *   to publish; if a corresponding {@link LocalAudioTrack} or
     *   {@link LocalVideoTrack} has not yet been published, this method will
     *   construct one
     * @param {MediaStreamTrackPublishOptions} [options] - The options for publishing
     *   the MediaStreamTrack
     * @returns {Promise<LocalTrackPublication>} - Resolves with the corresponding
     *   {@link LocalTrackPublication} if successful; In a Large Group Room (Maximum
     *   Participants greater than 50), rejects with a {@link ParticipantMaxTracksExceededError}
     *   if the total number of published Tracks in the Room exceeds 16, or the {@link LocalTrack}
     *   is part of a set of {@link LocalTrack}s which along with the published Tracks exceeds 16.
     * @throws {TypeError}
     * @throws {RangeError}
     * @example
     * var Video = require('twilio-video');
     *
     * Video.connect(token, {
     *   name: 'my-cool-room',
     *   audio: true
     * }).then(function(room) {
     *   return navigator.mediaDevices.getUserMedia({
     *     video: true
     *   }).then(function(mediaStream) {
     *     var mediaStreamTrack = mediaStream.getTracks()[0];
     *     return room.localParticipant.publishTrack(mediaStreamTrack, {
     *       name: 'camera',
     *       priority: 'high'
     *     });
     *   });
     * }).then(function(publication) {
     *   console.log('The LocalTrack "' + publication.trackName
     *     + '" was successfully published with priority "'
     *     * publication.priority + '"');
     * });
     */
    LocalParticipant.prototype.publishTrack = function (localTrackOrMediaStreamTrack, options) {
        var trackPublication = getTrackPublication(this.tracks, localTrackOrMediaStreamTrack);
        if (trackPublication) {
            return Promise.resolve(trackPublication);
        }
        options = Object.assign({
            log: this._log,
            priority: trackPriority.PRIORITY_STANDARD,
            LocalAudioTrack: this._LocalAudioTrack,
            LocalDataTrack: this._LocalDataTrack,
            LocalVideoTrack: this._LocalVideoTrack,
            MediaStreamTrack: this._MediaStreamTrack
        }, options);
        var localTrack;
        try {
            localTrack = asLocalTrack(localTrackOrMediaStreamTrack, options);
        }
        catch (error) {
            return Promise.reject(error);
        }
        var noiseCancellation = localTrack.noiseCancellation;
        var allowedAudioProcessors = this._signaling.audioProcessors;
        if (noiseCancellation && !allowedAudioProcessors.includes(noiseCancellation.vendor)) {
            this._log.warn(noiseCancellation.vendor + " is not supported in this room. disabling it permanently");
            noiseCancellation.disablePermanently();
        }
        var priorityValues = Object.values(trackPriority);
        if (!priorityValues.includes(options.priority)) {
            // eslint-disable-next-line new-cap
            return Promise.reject(E.INVALID_VALUE('LocalTrackPublishOptions.priority', priorityValues));
        }
        var addedLocalTrack = this._addTrack(localTrack, localTrack.id, options.priority)
            || this._tracks.get(localTrack.id);
        return this._getOrCreateLocalTrackPublication(addedLocalTrack);
    };
    /**
     * Publishes multiple {@link LocalTrack}s to the {@link Room}.
     * @param {Array<LocalTrack|MediaStreamTrack>} tracks - The {@link LocalTrack}s
     *   to publish; for any MediaStreamTracks provided, if a corresponding
     *   {@link LocalAudioTrack} or {@link LocalVideoTrack} has not yet been
     *   published, this method will construct one
     * @returns {Promise<Array<LocalTrackPublication>>} - The resulting
     *   {@link LocalTrackPublication}s if successful; In a Large Group Room (Maximum
     *   Participants greater than 50), rejects with a {@link ParticipantMaxTracksExceededError}
     *   if the total number of published Tracks in the Room exceeds 16, or the {@link LocalTrack}s
     *   along with the published Tracks exceeds 16.
     * @throws {TypeError}
     */
    LocalParticipant.prototype.publishTracks = function (tracks) {
        if (!Array.isArray(tracks)) {
            // eslint-disable-next-line new-cap
            throw E.INVALID_TYPE('tracks', 'Array of LocalAudioTrack, LocalVideoTrack, LocalDataTrack, or MediaStreamTrack');
        }
        return Promise.all(tracks.map(this.publishTrack, this));
    };
    LocalParticipant.prototype.setBandwidthProfile = function () {
        this._log.warn('setBandwidthProfile is not implemented yet and may be available in future versions of twilio-video.js');
    };
    /**
     * Sets the {@link NetworkQualityVerbosity} for the {@link LocalParticipant} and
     * {@link RemoteParticipant}s. It does nothing if Network Quality is not enabled
     * while calling {@link connect}.
     * @param {NetworkQualityConfiguration} networkQualityConfiguration - The new
     *   {@link NetworkQualityConfiguration}; If either or both of the local and
     *   remote {@link NetworkQualityVerbosity} values are absent, then the corresponding
     *   existing values are retained
     * @returns {this}
     * @example
     * // Update verbosity levels for both LocalParticipant and RemoteParticipants
     * localParticipant.setNetworkQualityConfiguration({
     *   local: 1,
     *   remote: 2
     * });
     * @example
     * // Update verbosity level for only the LocalParticipant
     * localParticipant.setNetworkQualityConfiguration({
     *   local: 1
     * });
     *  @example
     * // Update verbosity level for only the RemoteParticipants
     * localParticipant.setNetworkQualityConfiguration({
     *   remote: 2
     * });
     */
    LocalParticipant.prototype.setNetworkQualityConfiguration = function (networkQualityConfiguration) {
        if (typeof networkQualityConfiguration !== 'object'
            || networkQualityConfiguration === null) {
            // eslint-disable-next-line new-cap
            throw E.INVALID_TYPE('networkQualityConfiguration', 'NetworkQualityConfiguration');
        }
        ['local', 'remote'].forEach(function (prop) {
            if (prop in networkQualityConfiguration && (typeof networkQualityConfiguration[prop] !== 'number' || isNaN(networkQualityConfiguration[prop]))) {
                // eslint-disable-next-line new-cap
                throw E.INVALID_TYPE("networkQualityConfiguration." + prop, 'number');
            }
        });
        this._signaling.setNetworkQualityConfiguration(networkQualityConfiguration);
        return this;
    };
    /**
     * Set the {@link LocalParticipant}'s {@link EncodingParameters}.
     * @param {?EncodingParameters} [encodingParameters] - The new
     *   {@link EncodingParameters}; If null, then the bitrate limits are removed;
     *   If not specified, then the existing bitrate limits are preserved
     * @returns {this}
     * @throws {TypeError}
     */
    LocalParticipant.prototype.setParameters = function (encodingParameters) {
        if (typeof encodingParameters !== 'undefined'
            && typeof encodingParameters !== 'object') {
            // eslint-disable-next-line new-cap
            throw E.INVALID_TYPE('encodingParameters', 'EncodingParameters, null or undefined');
        }
        if (encodingParameters) {
            if (this._signaling.getParameters().adaptiveSimulcast && encodingParameters.maxVideoBitrate) {
                // eslint-disable-next-line new-cap
                throw E.INVALID_TYPE('encodingParameters', 'encodingParameters.maxVideoBitrate is not compatible with "preferredVideoCodecs=auto"');
            }
            ['maxAudioBitrate', 'maxVideoBitrate'].forEach(function (prop) {
                if (typeof encodingParameters[prop] !== 'undefined'
                    && typeof encodingParameters[prop] !== 'number'
                    && encodingParameters[prop] !== null) {
                    // eslint-disable-next-line new-cap
                    throw E.INVALID_TYPE("encodingParameters." + prop, 'number, null or undefined');
                }
            });
        }
        else if (encodingParameters === null) {
            encodingParameters = { maxAudioBitrate: null, maxVideoBitrate: null };
        }
        this._signaling.setParameters(encodingParameters);
        return this;
    };
    /**
     * Stops publishing a {@link LocalTrack} to the {@link Room}.
     * @param {LocalTrack|MediaStreamTrack} track - The {@link LocalTrack}
     *   to stop publishing; if a MediaStreamTrack is provided, this method
     *   looks up the corresponding {@link LocalAudioTrack} or
     *   {@link LocalVideoTrack} to stop publishing
     * @returns {?LocalTrackPublication} - The corresponding
     *   {@link LocalTrackPublication} if the {@link LocalTrack} was previously
     *   published, null otherwise
     * @throws {TypeError}
    */
    LocalParticipant.prototype.unpublishTrack = function (track) {
        validateLocalTrack(track, {
            LocalAudioTrack: this._LocalAudioTrack,
            LocalDataTrack: this._LocalDataTrack,
            LocalVideoTrack: this._LocalVideoTrack,
            MediaStreamTrack: this._MediaStreamTrack
        });
        var localTrack = this._tracks.get(track.id);
        if (!localTrack) {
            return null;
        }
        var trackSignaling = this._signaling.getPublication(localTrack._trackSender);
        trackSignaling.publishFailed(new Error("The " + localTrack + " was unpublished"));
        localTrack = this._removeTrack(localTrack, localTrack.id);
        if (!localTrack) {
            return null;
        }
        var localTrackPublication = getTrackPublication(this.tracks, localTrack);
        if (localTrackPublication) {
            this._removeTrackPublication(localTrackPublication);
        }
        return localTrackPublication;
    };
    /**
     * Stops publishing multiple {@link LocalTrack}s to the {@link Room}.
     * @param {Array<LocalTrack|MediaStreamTrack>} tracks - The {@link LocalTrack}s
     *   to stop publishing; for any MediaStreamTracks provided, this method looks
     *   up the corresponding {@link LocalAudioTrack} or {@link LocalVideoTrack} to
     *   stop publishing
     * @returns {Array<LocalTrackPublication>} - The corresponding
     *   {@link LocalTrackPublication}s that were successfully unpublished
     * @throws {TypeError}
     */
    LocalParticipant.prototype.unpublishTracks = function (tracks) {
        var _this = this;
        if (!Array.isArray(tracks)) {
            // eslint-disable-next-line new-cap
            throw E.INVALID_TYPE('tracks', 'Array of LocalAudioTrack, LocalVideoTrack, LocalDataTrack, or MediaStreamTrack');
        }
        return tracks.reduce(function (unpublishedTracks, track) {
            var unpublishedTrack = _this.unpublishTrack(track);
            return unpublishedTrack ? unpublishedTracks.concat(unpublishedTrack) : unpublishedTracks;
        }, []);
    };
    return LocalParticipant;
}(Participant));
/**
 * The {@link LocalParticipant} has reconnected to the {@link Room} after a signaling connection disruption.
 * @event LocalParticipant#reconnected
 */
/**
 * The {@link LocalParticipant} is reconnecting to the {@link Room} after a signaling connection disruption.
 * @event LocalParticipant#reconnecting
 */
/**
 * One of the {@link LocalParticipant}'s {@link LocalVideoTrack}'s dimensions changed.
 * @param {LocalVideoTrack} track - The {@link LocalVideoTrack} whose dimensions changed
 * @event LocalParticipant#trackDimensionsChanged
 */
/**
 * A {@link LocalTrack} was disabled by the {@link LocalParticipant}.
 * @param {LocalTrack} track - The {@link LocalTrack} that was disabled
 * @event LocalParticipant#trackDisabled
 */
/**
 * A {@link LocalTrack} was enabled by the {@link LocalParticipant}.
 * @param {LocalTrack} track - The {@link LocalTrack} that was enabled
 * @event LocalParticipant#trackEnabled
 */
/**
 * A {@link LocalTrack} failed to publish. Check the error message for more
 * information. In a Large Group Room (Maximum Participants greater than 50),
 * this event is raised with a {@link ParticipantMaxTracksExceededError} either
 * when attempting to publish the {@link LocalTrack} will exceed the Maximum Published
 * Tracks limit of 16, or the {@link LocalTrack} is part of a set of {@link LocalTrack}s
 * which along with the published Tracks exceeds 16.
 * @param {TwilioError} error - A {@link TwilioError} explaining why publication
 *   failed
 * @param {LocalTrack} localTrack - The {@link LocalTrack} that failed to
 *   publish
 * @event LocalParticipant#trackPublicationFailed
 */
/**
 * A {@link LocalTrack} that was added using {@link LocalParticipant#publishTrack} was successfully published. This event
 * is not raised for {@link LocalTrack}s added in {@link ConnectOptions}<code>.tracks</code> or auto-created within
 * <a href="module-twilio-video.html#.connect__anchor"><code>{@link connect}</code></a>.
 * @param {LocalTrackPublication} publication - The resulting
 *   {@link LocalTrackPublication} for the published {@link LocalTrack}
 * @event LocalParticipant#trackPublished
 */
/**
 * One of the {@link LocalParticipant}'s {@link LocalTrack}s started.
 * @param {LocalTrack} track - The {@link LocalTrack} that started
 * @event LocalParticipant#trackStarted
 */
/**
 * One of the {@link LocalParticipant}'s {@link LocalTrack}s stopped, either
 * because {@link LocalTrack#stop} was called or because the underlying
 * MediaStreamTrack ended).
 * @param {LocalTrack} track - The {@link LocalTrack} that stopped
 * @event LocalParticipant#trackStopped
 */
/**
 * One of the {@link LocalParticipant}'s {@link LocalTrackPublication}s encountered a warning.
 * This event is only raised if you enabled warnings using <code>notifyWarnings</code> in <code>ConnectOptions</code>.
 * @param {string} name - The warning that was raised.
 * @param {LocalTrackPublication} publication - The {@link LocalTrackPublication} that encountered the warning.
 * @event LocalParticipant#trackWarning
 */
/**
 * One of the {@link LocalParticipant}'s {@link LocalTrackPublication}s cleared all warnings.
 * This event is only raised if you enabled warnings using <code>notifyWarnings</code> in <code>ConnectOptions</code>.
 * @param {LocalTrackPublication} publication - The {@link LocalTrackPublication} that cleared all warnings.
 * @event LocalParticipant#trackWarningsCleared
 */
/**
 * Outgoing media encoding parameters.
 * @typedef {object} EncodingParameters
 * @property {?number} [maxAudioBitrate] - Max outgoing audio bitrate (bps);
 *   If not specified, retains the existing bitrate limit; A <code>null</code> or a
 *   <code>0</code> value removes any previously set bitrate limit; This value is set
 *   as a hint for variable bitrate codecs, but will not take effect for fixed bitrate
 *   codecs; Based on our tests, Chrome, Firefox and Safari support a bitrate range of
 *   12000 bps to 256000 bps for Opus codec; This parameter has no effect on iSAC, PCMU
 *   and PCMA codecs
 * @property {?number} [maxVideoBitrate] - Max outgoing video bitrate (bps);
 *   If not specified, retains the existing bitrate limit; A <code>null</code> or
 *   a <code>0</code> value removes any previously set bitrate limit; This value is
 *   set as a hint for variable bitrate codecs, but will not take effect for fixed
 *   bitrate codecs; Based on our tests, Chrome, Firefox and Safari all seem to support
 *   an average bitrate range of 20000 bps (20 kbps) to 8000000 bps (8 mbps) for a
 *   720p VideoTrack.
 *   Note: this limit is not applied for screen share tracks published on Chrome.
 */
/**
 * Options for publishing a {@link LocalTrack}.
 * @typedef {object} LocalTrackPublishOptions
 * @property {Track.Priority} [priority='standard'] - The priority with which the {@link LocalTrack}
 *   is to be published; In Group or Small Group Rooms, the appropriate bandwidth is
 *   allocated to the {@link LocalTrack} based on its {@link Track.Priority}; It has no
 *   effect in Peer-to-Peer Rooms; It defaults to "standard" when not provided
 */
/**
 * Options for publishing a {@link MediaStreamTrack}.
 * @typedef {LocalTrackOptions} MediaStreamTrackPublishOptions
 * @property {Track.Priority} [priority='standard'] - The priority with which the {@link LocalTrack}
 *   is to be published; In Group or Small Group Rooms, the appropriate bandwidth is
 *   allocated to the {@link LocalTrack} based on its {@link Track.Priority}; It has no
 *   effect in Peer-to-Peer Rooms; It defaults to "standard" when not provided
 */
/**
 * @private
 * @param {Map<Track.SID, LocalTrackPublication>} trackPublications
 * @param {LocalTrack|MediaStreamTrack} track
 * @returns {?LocalTrackPublication} trackPublication
 */
function getTrackPublication(trackPublications, track) {
    return Array.from(trackPublications.values()).find(function (trackPublication) { return trackPublication.track === track
        || trackPublication.track.mediaStreamTrack === track; }) || null;
}
module.exports = LocalParticipant;

},{"./media/track/es5":16,"./media/track/localaudiotrackpublication":22,"./media/track/localdatatrackpublication":24,"./media/track/localvideotrackpublication":28,"./participant":47,"./util":133,"./util/constants":126,"./util/validate":151,"./webrtc":159}],14:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var MediaTrack = require('./mediatrack');
/**
 * An {@link AudioTrack} is a {@link Track} representing audio.
 * @extends Track
 * @property {boolean} isStarted - Whether or not the {@link AudioTrack} has
 *   started; if the {@link AudioTrack} started, there is enough audio data to
 *   begin playback
 * @property {boolean} isEnabled - Whether or not the {@link AudioTrack} is
 *   enabled; if the {@link AudioTrack} is not enabled, it is "muted"
 * @property {Track.Kind} kind - "audio"
 * @property {MediaStreamTrack} mediaStreamTrack - An audio MediaStreamTrack
 * @property {?MediaStreamTrack} processedTrack - The source of processed audio samples.
 * It is always null as audio processing is not currently supported.
 * @emits AudioTrack#disabled
 * @emits AudioTrack#enabled
 * @emits AudioTrack#started
 */
var AudioTrack = /** @class */ (function (_super) {
    __extends(AudioTrack, _super);
    /**
     * Construct an {@link AudioTrack}.
     * @param {MediaTrackTransceiver} mediaTrackTransceiver
     * @param {{log: Log}} options
     */
    function AudioTrack(mediaTrackTransceiver, options) {
        return _super.call(this, mediaTrackTransceiver, options) || this;
    }
    /**
     * Create an HTMLAudioElement and attach the {@link AudioTrack} to it.
     *
     * The HTMLAudioElement's <code>srcObject</code> will be set to a new
     * MediaStream containing the {@link AudioTrack}'s MediaStreamTrack.
     *
     * @returns {HTMLAudioElement} audioElement
     * @example
     * const Video = require('twilio-video');
     *
     * Video.createLocalAudioTrack().then(function(audioTrack) {
     *   const audioElement = audioTrack.attach();
     *   document.body.appendChild(audioElement);
     * });
    */ /**
     * Attach the {@link AudioTrack} to an existing HTMLMediaElement. The
     * HTMLMediaElement could be an HTMLAudioElement or an HTMLVideoElement.
     *
     * If the HTMLMediaElement's <code>srcObject</code> is not set to a MediaStream,
     * this method sets it to a new MediaStream containing the {@link AudioTrack}'s
     * MediaStreamTrack; otherwise, it adds the {@link MediaTrack}'s
     * MediaStreamTrack to the existing MediaStream. Finally, if there are any other
     * MediaStreamTracks of the same kind on the MediaStream, this method removes
     * them.
     *
     * @param {HTMLMediaElement} mediaElement - The HTMLMediaElement to attach to
     * @returns {HTMLMediaElement} mediaElement
     * @example
     * const Video = require('twilio-video');
     *
     * const videoElement = document.createElement('video');
     * document.body.appendChild(videoElement);
     *
     * Video.createLocalAudioTrack().then(function(audioTrack) {
     *   audioTrack.attach(videoElement);
     * });
    */ /**
     * Attach the {@link AudioTrack} to an HTMLMediaElement selected by
     * <code>document.querySelector</code>. The HTMLMediaElement could be an
     * HTMLAudioElement or an HTMLVideoElement.
     *
     * If the HTMLMediaElement's <code>srcObject</code> is not set to a MediaStream,
     * this method sets it to a new MediaStream containing the {@link AudioTrack}'s
     * MediaStreamTrack; otherwise, it adds the {@link AudioTrack}'s
     * MediaStreamTrack to the existing MediaStream. Finally, if there are any other
     * MediaStreamTracks of the same kind on the MediaStream, this method removes
     * them.
     *
     * @param {string} selector - A query selector for the HTMLMediaElement to
     *   attach to
     * @returns {HTMLMediaElement} mediaElement
     * @example
     * const Video = require('twilio-video');
     *
     * const videoElement = document.createElement('video');
     * videoElement.id = 'my-video-element';
     * document.body.appendChild(videoElement);
     *
     * Video.createLocalAudioTrack().then(function(track) {
     *   track.attach('#my-video-element');
     * });
     */
    AudioTrack.prototype.attach = function () {
        return _super.prototype.attach.apply(this, arguments);
    };
    /**
     * Detach the {@link AudioTrack} from all previously attached HTMLMediaElements.
     * @returns {Array<HTMLMediaElement>} mediaElements
     * @example
     * const mediaElements = audioTrack.detach();
     * mediaElements.forEach(mediaElement => mediaElement.remove());
    */ /**
     * Detach the {@link AudioTrack} from a previously attached HTMLMediaElement.
     * @param {HTMLMediaElement} mediaElement - One of the HTMLMediaElements to
     *   which the {@link AudioTrack} is attached
     * @returns {HTMLMediaElement} mediaElement
     * @example
     * const videoElement = document.getElementById('my-video-element');
     * audioTrack.detach(videoElement).remove();
    */ /**
     * Detach the {@link AudioTrack} from a previously attached HTMLMediaElement
     *   specified by <code>document.querySelector</code>.
     * @param {string} selector - The query selector of HTMLMediaElement to which
     *    the {@link AudioTrack} is attached
     * @returns {HTMLMediaElement} mediaElement
     * @example
     * audioTrack.detach('#my-video-element').remove();
     */
    AudioTrack.prototype.detach = function () {
        return _super.prototype.detach.apply(this, arguments);
    };
    return AudioTrack;
}(MediaTrack));
/**
 * The {@link AudioTrack} was disabled, i.e. "muted".
 * @param {AudioTrack} track - The {@link AudioTrack} that was disabled
 * @event AudioTrack#disabled
 */
/**
 * The {@link AudioTrack} was enabled, i.e. "unmuted".
 * @param {AudioTrack} track - The {@link AudioTrack} that was enabled
 * @event AudioTrack#enabled
 */
/**
 * The {@link AudioTrack} started. This means there is enough audio data to
 * begin playback.
 * @param {AudioTrack} track - The {@link AudioTrack} that started
 * @event AudioTrack#started
 */
module.exports = AudioTrack;

},{"./mediatrack":29}],15:[function(require,module,exports){
/* globals MediaStreamTrackGenerator, MediaStreamTrackProcessor, TransformStream */
'use strict';
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var DEFAULT_FRAME_RATE = require('../../util/constants').DEFAULT_FRAME_RATE;
function captureVideoFramesSetInterval(videoEl, processVideoFrame) {
    var _a = __read(videoEl.srcObject.getVideoTracks(), 1), track = _a[0];
    var _b = track.getSettings().frameRate, frameRate = _b === void 0 ? DEFAULT_FRAME_RATE : _b;
    var sampleInterval;
    var readable = new ReadableStream({
        start: function (controller) {
            sampleInterval = setInterval(function () { return controller.enqueue(); }, 1000 / frameRate);
        }
    });
    var transformer = new TransformStream({
        transform: function () {
            return processVideoFrame();
        }
    });
    readable
        .pipeThrough(transformer)
        .pipeTo(new WritableStream())
        .then(function () { });
    return function () {
        clearInterval(sampleInterval);
    };
}
function captureVideoFramesInsertableStreams(videoEl, processVideoFrame, videoFrameType) {
    var _a = __read(videoEl.srcObject.getVideoTracks(), 1), track = _a[0];
    var readable = new MediaStreamTrackProcessor({ track: track }).readable;
    var generator = new MediaStreamTrackGenerator({ kind: 'video' });
    var shouldStop = false;
    var transformer = new TransformStream({
        transform: function (videoFrame, controller) {
            var promise = videoFrameType === 'videoframe'
                ? processVideoFrame(videoFrame)
                : Promise.resolve(videoFrame.close())
                    .then(processVideoFrame);
            return promise.finally(function () {
                if (shouldStop) {
                    controller.terminate();
                }
            });
        }
    });
    readable
        .pipeThrough(transformer)
        .pipeTo(generator.writable)
        .then(function () { });
    return function () {
        shouldStop = true;
    };
}
module.exports = typeof MediaStreamTrackGenerator === 'function' && typeof MediaStreamTrackProcessor === 'function'
    ? captureVideoFramesInsertableStreams
    : captureVideoFramesSetInterval;

},{"../../util/constants":126}],16:[function(require,module,exports){
'use strict';
module.exports = {
    LocalAudioTrack: require('./localaudiotrack'),
    LocalVideoTrack: require('./localvideotrack'),
    LocalDataTrack: require('./localdatatrack')
};

},{"./localaudiotrack":17,"./localdatatrack":18,"./localvideotrack":19}],17:[function(require,module,exports){
// eslint-disable-next-line no-warning-comments
// TODO(mroberts): Remove this when we go to the next major version. This is
// only in place so that we can support ES6 classes without requiring `new`.
'use strict';
var inherits = require('../../../vendor/inherits');
var LocalAudioTrackClass = require('../localaudiotrack');
function LocalAudioTrack(mediaStreamTrack, options) {
    var track = new LocalAudioTrackClass(mediaStreamTrack, options);
    Object.setPrototypeOf(track, LocalAudioTrack.prototype);
    return track;
}
inherits(LocalAudioTrack, LocalAudioTrackClass);
module.exports = LocalAudioTrack;

},{"../../../vendor/inherits":152,"../localaudiotrack":21}],18:[function(require,module,exports){
// eslint-disable-next-line no-warning-comments
// TODO(mroberts): Remove this when we go to the next major version. This is
// only in place so that we can support ES6 classes without requiring `new`.
'use strict';
var inherits = require('../../../vendor/inherits');
var LocalDataTrackClass = require('../localdatatrack');
function LocalDataTrack(options) {
    var track = new LocalDataTrackClass(options);
    Object.setPrototypeOf(track, LocalDataTrack.prototype);
    return track;
}
inherits(LocalDataTrack, LocalDataTrackClass);
module.exports = LocalDataTrack;

},{"../../../vendor/inherits":152,"../localdatatrack":23}],19:[function(require,module,exports){
// eslint-disable-next-line no-warning-comments
// TODO(mroberts): Remove this when we go to the next major version. This is
// only in place so that we can support ES6 classes without requiring `new`.
'use strict';
var inherits = require('../../../vendor/inherits');
var LocalVideoTrackClass = require('../localvideotrack');
function LocalVideoTrack(mediaStreamTrack, options) {
    var track = new LocalVideoTrackClass(mediaStreamTrack, options);
    Object.setPrototypeOf(track, LocalVideoTrack.prototype);
    return track;
}
inherits(LocalVideoTrack, LocalVideoTrackClass);
module.exports = LocalVideoTrack;

},{"../../../vendor/inherits":152,"../localvideotrack":27}],20:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var EventEmitter = require('../../eventemitter');
var _a = require('../../util'), buildLogLevels = _a.buildLogLevels, valueToJSON = _a.valueToJSON;
var DEFAULT_LOG_LEVEL = require('../../util/constants').DEFAULT_LOG_LEVEL;
var Log = require('../../util/log');
var nInstances = 0;
/**
 * A {@link Track} represents a stream of audio, video, or data.
 * @extends EventEmitter
 * @property {Track.Kind} kind - The {@link Track}'s kind
 * @property {string} name - The {@link Track}'s name
 */
var Track = /** @class */ (function (_super) {
    __extends(Track, _super);
    /**
     * Construct a {@link Track}.
     * @param {Track.ID} id - The {@link Track}'s ID
     * @param {Track.Kind} kind - The {@link Track}'s kind
     * @param {{ log: Log, name: ?string }} options
     */
    function Track(id, kind, options) {
        var _this = this;
        options = Object.assign({
            name: id,
            log: null,
            logLevel: DEFAULT_LOG_LEVEL
        }, options);
        _this = _super.call(this) || this;
        var name = String(options.name);
        var logLevels = buildLogLevels(options.logLevel);
        var log = options.log
            ? options.log.createLog('media', _this)
            : new Log('media', _this, logLevels, options.loggerName);
        Object.defineProperties(_this, {
            _instanceId: {
                value: ++nInstances
            },
            _log: {
                value: log
            },
            kind: {
                enumerable: true,
                value: kind
            },
            name: {
                enumerable: true,
                value: name
            }
        });
        return _this;
    }
    Track.prototype.toJSON = function () {
        return valueToJSON(this);
    };
    return Track;
}(EventEmitter));
/**
 * The {@link Track} ID is a string identifier for the {@link Track}.
 * @typedef {string} Track.ID
 */
/**
 * The {@link Track} kind is either "audio", "video", or "data".
 * @typedef {string} Track.Kind
 */
/**
 * The {@link Track}'s priority can be "low", "standard", or "high".
 * @typedef {string} Track.Priority
 */
/**
 * The {@link Track} SID is a unique string identifier for the {@link Track}
 * that is published to a {@link Room}.
 * @typedef {string} Track.SID
 */
/**
 * A {@link DataTrack} is a {@link LocalDataTrack} or {@link RemoteDataTrack}.
 * @typedef {LocalDataTrack|RemoteDataTrack} DataTrack
 */
/**
 * A {@link LocalTrack} is a {@link LocalAudioTrack}, {@link LocalVideoTrack},
 * or {@link LocalDataTrack}.
 * @typedef {LocalAudioTrack|LocalVideoTrack|LocalDataTrack} LocalTrack
 */
/**
 * {@link LocalTrack} options
 * @typedef {object} LocalTrackOptions
 * @property {LogLevel|LogLevels} logLevel - Log level for 'media' modules
 * @property {string} [name] - The {@link LocalTrack}'s name; by default,
 *   it is set to the {@link LocalTrack}'s ID.
 */
/**
 * A {@link RemoteTrack} is a {@link RemoteAudioTrack},
 * {@link RemoteVideoTrack}, or {@link RemoteDataTrack}.
 * @typedef {RemoteAudioTrack|RemoteVideoTrack|RemoteDataTrack} RemoteTrack
 */
module.exports = Track;

},{"../../eventemitter":10,"../../util":133,"../../util/constants":126,"../../util/log":137}],21:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var isIOS = require('../../util/browserdetection').isIOS;
var detectSilentAudio = require('../../util/detectsilentaudio');
var isIOSChrome = require('../../webrtc/util').isIOSChrome;
var AudioTrack = require('./audiotrack');
var mixinLocalMediaTrack = require('./localmediatrack');
var LocalMediaAudioTrack = mixinLocalMediaTrack(AudioTrack);
/**
 * A {@link LocalAudioTrack} is an {@link AudioTrack} representing audio that
 * your {@link LocalParticipant} can publish to a {@link Room}. It can be
 * enabled and disabled with {@link LocalAudioTrack#enable} and
 * {@link LocalAudioTrack#disable} or stopped completely with
 * {@link LocalAudioTrack#stop}.
 * @extends AudioTrack
 * @property {Track.ID} id - The {@link LocalAudioTrack}'s ID
 * @property {boolean} isMuted - Whether or not the audio source has stopped sending samples to the
 *   {@link LocalAudioTrack}; This can happen when the microphone is taken over by another application,
 *   mainly on mobile devices; When this property toggles, then <code>muted</code> and <code>unmuted</code>
 *   events are fired appropriately
 * @property {boolean} isStopped - Whether or not the {@link LocalAudioTrack} is
 *   stopped
 * @property {NoiseCancellation?} noiseCancellation - When a LocalAudioTrack is created
 *   with {@link NoiseCancellationOptions}, this property provides interface
 *   to enable or disable the noise cancellation at runtime.
 * @emits LocalAudioTrack#disabled
 * @emits LocalAudioTrack#enabled
 * @emits LocalAudioTrack#muted
 * @emits LocalAudioTrack#started
 * @emits LocalAudioTrack#stopped
 * @emits LocalAudioTrack#unmuted
 */
var LocalAudioTrack = /** @class */ (function (_super) {
    __extends(LocalAudioTrack, _super);
    /**
     * Construct a {@link LocalAudioTrack} from a MediaStreamTrack.
     * @param {MediaStreamTrack} mediaStreamTrack - An audio MediaStreamTrack
     * @param {LocalTrackOptions} [options] - {@link LocalTrack} options
     */
    function LocalAudioTrack(mediaStreamTrack, options) {
        var _this = this;
        var noiseCancellation = (options === null || options === void 0 ? void 0 : options.noiseCancellation) || null;
        _this = _super.call(this, mediaStreamTrack, options) || this;
        var log = _this._log;
        var _a = mediaStreamTrack.label, defaultDeviceLabel = _a === void 0 ? '' : _a;
        var _b = mediaStreamTrack.getSettings(), _c = _b.deviceId, defaultDeviceId = _c === void 0 ? '' : _c, _d = _b.groupId, defaultGroupId = _d === void 0 ? '' : _d;
        Object.defineProperties(_this, {
            _currentDefaultDeviceInfo: {
                value: { deviceId: defaultDeviceId, groupId: defaultGroupId, label: defaultDeviceLabel },
                writable: true
            },
            _defaultDeviceCaptureMode: {
                value: !isIOS()
                    && _this._isCreatedByCreateLocalTracks
                    && typeof navigator === 'object'
                    && typeof navigator.mediaDevices === 'object'
                    && typeof navigator.mediaDevices.addEventListener === 'function'
                    && typeof navigator.mediaDevices.enumerateDevices === 'function'
                    ? (options === null || options === void 0 ? void 0 : options.defaultDeviceCaptureMode) || 'auto'
                    : 'manual'
            },
            _onDeviceChange: {
                value: function () {
                    navigator.mediaDevices.enumerateDevices().then(function (deviceInfos) {
                        // NOTE(mmalavalli): In Chrome, when the default device changes, and we restart the LocalAudioTrack with
                        // device ID "default", it will not switch to the new default device unless all LocalAudioTracks capturing
                        // from the old default device are stopped. So, we restart the LocalAudioTrack with the actual device ID of
                        // the new default device instead.
                        var defaultDeviceInfo = deviceInfos.find(function (_a) {
                            var deviceId = _a.deviceId, kind = _a.kind;
                            return kind === 'audioinput' && deviceId !== 'default';
                        });
                        if (defaultDeviceInfo && ['deviceId', 'groupId'].some(function (prop) {
                            return defaultDeviceInfo[prop] !== _this._currentDefaultDeviceInfo[prop];
                        })) {
                            log.info('Default device changed, restarting the LocalAudioTrack');
                            log.debug("Old default device: \"" + _this._currentDefaultDeviceInfo.deviceId + "\" => \"" + _this._currentDefaultDeviceInfo.label + "\"");
                            log.debug("New default device: \"" + defaultDeviceInfo.deviceId + "\" => \"" + defaultDeviceInfo.label + "\"");
                            _this._currentDefaultDeviceInfo = defaultDeviceInfo;
                            _this._restartDefaultDevice().catch(function (error) { return log.warn("Failed to restart: " + error.message); });
                        }
                    }, function (error) {
                        log.warn("Failed to run enumerateDevices(): " + error.message);
                    });
                }
            },
            _restartOnDefaultDeviceChangeCleanup: {
                value: null,
                writable: true
            },
            noiseCancellation: {
                enumerable: true,
                value: noiseCancellation,
                writable: false
            },
        });
        log.debug('defaultDeviceCaptureMode:', _this._defaultDeviceCaptureMode);
        _this._maybeRestartOnDefaultDeviceChange();
        return _this;
    }
    LocalAudioTrack.prototype.toString = function () {
        return "[LocalAudioTrack #" + this._instanceId + ": " + this.id + "]";
    };
    LocalAudioTrack.prototype.attach = function (el) {
        el = _super.prototype.attach.call(this, el);
        el.muted = true;
        return el;
    };
    /**
     * @private
     */
    LocalAudioTrack.prototype._end = function () {
        return _super.prototype._end.apply(this, arguments);
    };
    /**
     * @private
     */
    LocalAudioTrack.prototype._maybeRestartOnDefaultDeviceChange = function () {
        var _this = this;
        var _a = this, constraints = _a._constraints, defaultDeviceCaptureMode = _a._defaultDeviceCaptureMode, log = _a._log;
        var mediaStreamTrack = this.noiseCancellation ? this.noiseCancellation.sourceTrack : this.mediaStreamTrack;
        var deviceId = mediaStreamTrack.getSettings().deviceId;
        var isNotEqualToCapturedDeviceIdOrEqualToDefault = function (requestedDeviceId) {
            return requestedDeviceId !== deviceId || requestedDeviceId === 'default';
        };
        var isCapturingFromDefaultDevice = (function checkIfCapturingFromDefaultDevice(deviceIdConstraint) {
            if (deviceIdConstraint === void 0) { deviceIdConstraint = {}; }
            if (typeof deviceIdConstraint === 'string') {
                return isNotEqualToCapturedDeviceIdOrEqualToDefault(deviceIdConstraint);
            }
            else if (Array.isArray(deviceIdConstraint)) {
                return deviceIdConstraint.every(isNotEqualToCapturedDeviceIdOrEqualToDefault);
            }
            else if (deviceIdConstraint.exact) {
                return checkIfCapturingFromDefaultDevice(deviceIdConstraint.exact);
            }
            else if (deviceIdConstraint.ideal) {
                return checkIfCapturingFromDefaultDevice(deviceIdConstraint.ideal);
            }
            return true;
        }(constraints.deviceId));
        if (defaultDeviceCaptureMode === 'auto' && isCapturingFromDefaultDevice) {
            if (!this._restartOnDefaultDeviceChangeCleanup) {
                log.info('LocalAudioTrack will be restarted if the default device changes');
                navigator.mediaDevices.addEventListener('devicechange', this._onDeviceChange);
                this._restartOnDefaultDeviceChangeCleanup = function () {
                    log.info('Cleaning up the listener to restart the LocalAudioTrack if the default device changes');
                    navigator.mediaDevices.removeEventListener('devicechange', _this._onDeviceChange);
                    _this._restartOnDefaultDeviceChangeCleanup = null;
                };
            }
        }
        else {
            log.info('LocalAudioTrack will NOT be restarted if the default device changes');
            if (this._restartOnDefaultDeviceChangeCleanup) {
                this._restartOnDefaultDeviceChangeCleanup();
            }
        }
    };
    /**
     * @private
     */
    LocalAudioTrack.prototype._reacquireTrack = function (constraints) {
        var _this = this;
        this._log.debug('_reacquireTrack: ', constraints);
        if (this.noiseCancellation) {
            return this.noiseCancellation.reacquireTrack(function () {
                return _super.prototype._reacquireTrack.call(_this, constraints);
            });
        }
        return _super.prototype._reacquireTrack.call(this, constraints);
    };
    /**
     * @private
     */
    LocalAudioTrack.prototype._restartDefaultDevice = function () {
        var _this = this;
        var constraints = Object.assign({}, this._constraints);
        var restartConstraints = Object.assign({}, constraints, { deviceId: this._currentDefaultDeviceInfo.deviceId });
        return this.restart(restartConstraints).then(function () {
            // NOTE(mmalavalli): Since we used the new default device's ID while restarting the LocalAudioTrack,
            // we reset the constraints to the original constraints so that the default device detection logic in
            // _maybeRestartOnDefaultDeviceChange() still works.
            _this._constraints = constraints;
            _this._maybeRestartOnDefaultDeviceChange();
        });
    };
    /**
     * NOTE(mmalavalli): On iOS 17 Chrome, a LocalAudioTrack with Krisp Noise Cancellation
     * enabled that is restarted due to foregrounding the browser is silent for as-of-yet
     * unknown reason. We work around this by discarding the Krisp MediaStreamTrack and using
     * the source MediaStreamTrack. (VIDEO-13006)
     * @private
     */
    LocalAudioTrack.prototype._setMediaStreamTrack = function (mediaStreamTrack) {
        var _this = this;
        var _a = this, log = _a._log, noiseCancellation = _a.noiseCancellation;
        var promise = _super.prototype._setMediaStreamTrack.call(this, mediaStreamTrack);
        if (isIOSChrome() && !!noiseCancellation) {
            log.debug('iOS Chrome detected, checking if the restarted Krisp audio is silent');
            promise = promise.then(function () { return detectSilentAudio(_this._dummyEl); }).then(function (isSilent) {
                log.debug("Krisp audio is " + (isSilent ? 'silent, using source audio' : 'not silent'));
                return isSilent && noiseCancellation.disablePermanently().then(function () {
                    return _super.prototype._setMediaStreamTrack.call(_this, noiseCancellation.sourceTrack);
                });
            });
        }
        return promise;
    };
    /**
     * Disable the {@link LocalAudioTrack}. This is equivalent to muting the audio source.
     * @returns {this}
     * @fires LocalAudioTrack#disabled
     */
    LocalAudioTrack.prototype.disable = function () {
        return _super.prototype.disable.apply(this, arguments);
    };
    /**
     * Enable the {@link LocalAudioTrack}. This is equivalent to unmuting the audio source.
     * @returns {this}
     * @fires LocalAudioTrack#enabled
    */ /**
     * Enable or disable the {@link LocalAudioTrack}. This is equivalent to unmuting or muting
     * the audio source respectively.
     * @param {boolean} [enabled] - Specify false to disable the
     *   {@link LocalAudioTrack}
     * @returns {this}
     * @fires LocalAudioTrack#disabled
     * @fires LocalAudioTrack#enabled
     */
    LocalAudioTrack.prototype.enable = function () {
        return _super.prototype.enable.apply(this, arguments);
    };
    /**
     * Restart the {@link LocalAudioTrack}. This stops the existing MediaStreamTrack
     * and creates a new MediaStreamTrack. If the {@link LocalAudioTrack} is being published
     * to a {@link Room}, then all the {@link RemoteParticipant}s will start receiving media
     * from the newly created MediaStreamTrack. You can access the new MediaStreamTrack via
     * the <code>mediaStreamTrack</code> property. If you want to listen to events on
     * the MediaStreamTrack directly, please do so in the "started" event handler. Also,
     * the {@link LocalAudioTrack}'s ID is no longer guaranteed to be the same as the
     * underlying MediaStreamTrack's ID.
     * @param {MediaTrackConstraints} [constraints] - The optional <a href="https://developer.mozilla.org/en-US/docs/Web/API/MediaTrackConstraints" target="_blank">MediaTrackConstraints</a>
     *   for restarting the {@link LocalAudioTrack}; If not specified, then the current MediaTrackConstraints
     *   will be used; If <code>{}</code> (empty object) is specified, then the default MediaTrackConstraints
     *   will be used
     * @returns {Promise<void>} Rejects with a TypeError if the {@link LocalAudioTrack} was not created
     *   using an one of <code>createLocalAudioTrack</code>, <code>createLocalTracks</code> or <code>connect</code>;
     *   Also rejects with the <a href="https://developer.mozilla.org/en-US/docs/Web/API/MediaDevices/getUserMedia#Exceptions" target="_blank">DOMException</a>
     *   raised by <code>getUserMedia</code> when it fails
     * @fires LocalAudioTrack#stopped
     * @fires LocalAudioTrack#started
     * @example
     * const { connect, createLocalAudioTrack } = require('twilio-video');
     *
     * // Create a LocalAudioTrack that captures audio from a USB microphone.
     * createLocalAudioTrack({ deviceId: 'usb-mic-id' }).then(function(localAudioTrack) {
     *   return connect('token', {
     *     name: 'my-cool-room',
     *     tracks: [localAudioTrack]
     *   });
     * }).then(function(room) {
     *   // Restart the LocalAudioTrack to capture audio from the default microphone.
     *   const localAudioTrack = Array.from(room.localParticipant.audioTracks.values())[0].track;
     *   return localAudioTrack.restart({ deviceId: 'default-mic-id' });
     * });
     */
    LocalAudioTrack.prototype.restart = function () {
        return _super.prototype.restart.apply(this, arguments);
    };
    /**
     * Calls stop on the underlying MediaStreamTrack. If you choose to stop a
     * {@link LocalAudioTrack}, you should unpublish it after stopping.
     * @returns {this}
     * @fires LocalAudioTrack#stopped
     */
    LocalAudioTrack.prototype.stop = function () {
        if (this.noiseCancellation) {
            this.noiseCancellation.stop();
        }
        if (this._restartOnDefaultDeviceChangeCleanup) {
            this._restartOnDefaultDeviceChangeCleanup();
        }
        return _super.prototype.stop.apply(this, arguments);
    };
    return LocalAudioTrack;
}(LocalMediaAudioTrack));
/**
 * The {@link LocalAudioTrack} was disabled, i.e. the audio source was muted by the user.
 * @param {LocalAudioTrack} track - The {@link LocalAudioTrack} that was
 *   disabled
 * @event LocalAudioTrack#disabled
 */
/**
 * The {@link LocalAudioTrack} was enabled, i.e. the audio source was unmuted by the user.
 * @param {LocalAudioTrack} track - The {@link LocalAudioTrack} that was enabled
 * @event LocalAudioTrack#enabled
 */
/**
 * The {@link LocalAudioTrack} was muted because the audio source stopped sending samples, most
 * likely due to another application taking said audio source, especially on mobile devices.
 * @param {LocalAudioTrack} track - The {@link LocalAudioTrack} that was muted
 * @event LocalAudioTrack#muted
 */
/**
 * The {@link LocalAudioTrack} started. This means there is enough audio data to
 * begin playback.
 * @param {LocalAudioTrack} track - The {@link LocalAudioTrack} that started
 * @event LocalAudioTrack#started
 */
/**
 * The {@link LocalAudioTrack} stopped, either because {@link LocalAudioTrack#stop}
 * or {@link LocalAudioTrack#restart} was called or because the underlying
 * MediaStreamTrack ended.
 * @param {LocalAudioTrack} track - The {@link LocalAudioTrack} that stopped
 * @event LocalAudioTrack#stopped
 */
/**
 * The {@link LocalAudioTrack} was unmuted because the audio source resumed sending samples,
 * most likely due to the application that took over the said audio source has released it
 * back to the application, especially on mobile devices. This event is also fired when
 * {@link LocalAudioTrack#restart} is called on a muted {@link LocalAudioTrack} with a
 * new audio source.
 * @param {LocalAudioTrack} track - The {@link LocalAudioTrack} that was unmuted
 * @event LocalAudioTrack#unmuted
 */
module.exports = LocalAudioTrack;

},{"../../util/browserdetection":124,"../../util/detectsilentaudio":127,"../../webrtc/util":171,"./audiotrack":14,"./localmediatrack":25}],22:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var LocalTrackPublication = require('./localtrackpublication');
/**
 * A {@link LocalAudioTrackPublication} is a {@link LocalAudioTrack} that has
 * been published to a {@link Room}.
 * @extends LocalTrackPublication
 * @property {Track.Kind} kind - "audio"
 * @property {LocalAudioTrack} track - the {@link LocalAudioTrack}
 */
var LocalAudioTrackPublication = /** @class */ (function (_super) {
    __extends(LocalAudioTrackPublication, _super);
    /**
     * Construct a {@link LocalAudioTrackPublication}.
     * @param {LocalTrackPublicationSignaling} signaling - The corresponding
     *   {@link LocalTrackPublicationSignaling}
     * @param {LocalAudioTrack} track - the {@link LocalAudioTrack}
     * @param {function(LocalTrackPublication): void} unpublish - The callback
     *    that unpublishes the {@link LocalTrackPublication}
     * @param {TrackPublicationOptions} options - {@link LocalTrackPublication} options
     */
    function LocalAudioTrackPublication(signaling, track, unpublish, options) {
        return _super.call(this, signaling, track, unpublish, options) || this;
    }
    LocalAudioTrackPublication.prototype.toString = function () {
        return "[LocalAudioTrackPublication #" + this._instanceId + ": " + this.trackSid + "]";
    };
    return LocalAudioTrackPublication;
}(LocalTrackPublication));
module.exports = LocalAudioTrackPublication;

},{"./localtrackpublication":26}],23:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Track = require('./');
var DefaultDataTrackSender = require('../../data/sender');
/**
 * A {@link LocalDataTrack} is a {@link Track} representing data that your
 * {@link LocalParticipant} can publish to a {@link Room}.
 * @extends Track
 * @property {Track.ID} id - The {@link LocalDataTrack}'s ID
 * @property {Track.Kind} kind - "data"
 * @property {?number} maxPacketLifeTime - If non-null, this represents a time
 *   limit (in milliseconds) during which the {@link LocalDataTrack} will send
 *   or re-send data if not acknowledged on the underlying RTCDataChannel(s).
 * @property {?number} maxRetransmits - If non-null, this represents the number
 *   of times the {@link LocalDataTrack} will resend data if not successfully
 *   delivered on the underlying RTCDataChannel(s).
 * @property {boolean} ordered - true if data on the {@link LocalDataTrack} is
 *   guaranteed to be sent in order.
 * @property {boolean} reliable - This is true if both
 *   <code>maxPacketLifeTime</code> and <code>maxRetransmits</code> are set to
 *   null. In other words, if this is true, there is no bound on packet lifetime
 *   or the number of times the {@link LocalDataTrack} will attempt to send
 *   data, ensuring "reliable" transmission.
 * @example
 * var Video = require('twilio-video');
 *
 * var localDataTrack = new Video.LocalDataTrack();
 * window.addEventListener('mousemove', function(event) {
 *   localDataTrack.send(JSON.stringify({
 *     x: e.clientX,
 *     y: e.clientY
 *   }));
 * });
 *
 * var token1 = getAccessToken();
 * Video.connect(token1, {
 *   name: 'my-cool-room',
 *   tracks: [localDataTrack]
 * });
 *
 * var token2 = getAccessToken();
 * Video.connect(token2, {
 *   name: 'my-cool-room',
 *   tracks: []
 * }).then(function(room) {
 *   room.on('trackSubscribed', function(track) {
 *     track.on('message', function(message) {
 *       console.log(JSON.parse(message)); // { x: <number>, y: <number> }
 *     });
 *   });
 * });
 */
var LocalDataTrack = /** @class */ (function (_super) {
    __extends(LocalDataTrack, _super);
    /**
     * Construct a {@link LocalDataTrack}.
     * @param {LocalDataTrackOptions} [options] - {@link LocalDataTrack} options
     */
    function LocalDataTrack(options) {
        var _this = this;
        options = Object.assign({
            DataTrackSender: DefaultDataTrackSender,
            maxPacketLifeTime: null,
            maxRetransmits: null,
            ordered: true
        }, options);
        var DataTrackSender = options.DataTrackSender;
        var dataTrackSender = new DataTrackSender(options.maxPacketLifeTime, options.maxRetransmits, options.ordered);
        _this = _super.call(this, dataTrackSender.id, 'data', options) || this;
        Object.defineProperties(_this, {
            _trackSender: {
                value: dataTrackSender
            },
            id: {
                enumerable: true,
                value: dataTrackSender.id
            },
            maxPacketLifeTime: {
                enumerable: true,
                value: options.maxPacketLifeTime
            },
            maxRetransmits: {
                enumerable: true,
                value: options.maxRetransmits
            },
            ordered: {
                enumerable: true,
                value: options.ordered
            },
            reliable: {
                enumerable: true,
                value: options.maxPacketLifeTime === null
                    && options.maxRetransmits === null
            }
        });
        return _this;
    }
    /**
     * Send a message over the {@link LocalDataTrack}.
     * @param {string|Blob|ArrayBuffer|ArrayBufferView} data
     * @returns {void}
     */
    LocalDataTrack.prototype.send = function (data) {
        this._trackSender.send(data);
    };
    return LocalDataTrack;
}(Track));
/**
 * {@link LocalDataTrack} options
 * @typedef {LocalTrackOptions} LocalDataTrackOptions
 * @property {?number} [maxPacketLifeTime=null] - Set this to limit the time
 *   (in milliseconds) during which the LocalDataTrack will send or re-send data
 *   if not successfully delivered on the underlying RTCDataChannel(s). It is an
 *   error to specify both this and <code>maxRetransmits</code>.
 * @property {?number} [maxRetransmits=null] - Set this to limit the number of
 *   times the {@link LocalDataTrack} will send or re-send data if not
 *   acknowledged on the underlying RTCDataChannel(s). It is an error to specify
 *   both this and <code>maxPacketLifeTime</code>.
 * @property {boolean} [ordered=true] - Set this to false to allow data on the
 *   LocalDataTrack to be sent out-of-order.
 */
module.exports = LocalDataTrack;

},{"../../data/sender":6,"./":20}],24:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var LocalTrackPublication = require('./localtrackpublication');
/**
 * A {@link LocalDataTrackPublication} is a {@link LocalDataTrack} that has been
 * published to a {@link Room}.
 * @extends LocalTrackPublication
 * @property {Track.Kind} kind - "data"
 * @property {LocalDataTrack} track - the {@link LocalDataTrack}
 */
var LocalDataTrackPublication = /** @class */ (function (_super) {
    __extends(LocalDataTrackPublication, _super);
    /**
     * Construct a {@link LocalDataTrackPublication}.
     * @param {LocalTrackPublicationSignaling} signaling - The corresponding
     *   {@link LocalTrackPublicationSignaling}
     * @param {LocalDataTrack} track - the {@link LocalDataTrack}
     * @param {function(LocalTrackPublication): void} unpublish - The callback
     *    that unpublishes the {@link LocalTrackPublication}
     * @param {TrackPublicationOptions} options - {@link LocalTrackPublication} options
     */
    function LocalDataTrackPublication(signaling, track, unpublish, options) {
        return _super.call(this, signaling, track, unpublish, options) || this;
    }
    LocalDataTrackPublication.prototype.toString = function () {
        return "[LocalDataTrackPublication #" + this._instanceId + ": " + this.trackSid + "]";
    };
    return LocalDataTrackPublication;
}(LocalTrackPublication));
module.exports = LocalDataTrackPublication;

},{"./localtrackpublication":26}],25:[function(require,module,exports){
/* eslint new-cap:0 */
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var getUserMedia = require('../../webrtc').getUserMedia;
var isIOS = require('../../util/browserdetection').isIOS;
var _a = require('../../util'), capitalize = _a.capitalize, defer = _a.defer, waitForSometime = _a.waitForSometime, waitForEvent = _a.waitForEvent;
var ILLEGAL_INVOKE = require('../../util/constants').typeErrors.ILLEGAL_INVOKE;
var detectSilentAudio = require('../../util/detectsilentaudio');
var detectSilentVideo = require('../../util/detectsilentvideo');
var documentVisibilityMonitor = require('../../util/documentvisibilitymonitor.js');
var localMediaRestartDeferreds = require('../../util/localmediarestartdeferreds');
var gUMSilentTrackWorkaround = require('../../webaudio/workaround180748');
var MediaTrackSender = require('./sender');
function mixinLocalMediaTrack(AudioOrVideoTrack) {
    /**
     * A {@link LocalMediaTrack} represents audio or video that your
     * {@link LocalParticipant} is sending to a {@link Room}. As such, it can be
     * enabled and disabled with {@link LocalMediaTrack#enable} and
     * {@link LocalMediaTrack#disable} or stopped completely with
     * {@link LocalMediaTrack#stop}.
     * @emits LocalMediaTrack#muted
     * @emits LocalMediaTrack#stopped
     * @emits LocalMediaTrack#unmuted
     */
    return /** @class */ (function (_super) {
        __extends(LocalMediaTrack, _super);
        /**
         * Construct a {@link LocalMediaTrack} from a MediaStreamTrack.
         * @param {MediaStreamTrack} mediaStreamTrack - The underlying MediaStreamTrack
         * @param {LocalTrackOptions} [options] - {@link LocalTrack} options
         */
        function LocalMediaTrack(mediaStreamTrack, options) {
            var _this = this;
            var workaroundWebKitBug1208516 = isIOS()
                && typeof document === 'object'
                && typeof document.addEventListener === 'function'
                && typeof document.visibilityState === 'string';
            options = Object.assign({
                getUserMedia: getUserMedia,
                isCreatedByCreateLocalTracks: false,
                workaroundWebKitBug1208516: workaroundWebKitBug1208516,
                gUMSilentTrackWorkaround: gUMSilentTrackWorkaround
            }, options);
            var mediaTrackSender = new MediaTrackSender(mediaStreamTrack);
            var kind = mediaTrackSender.kind;
            _this = _super.call(this, mediaTrackSender, options) || this;
            Object.defineProperties(_this, {
                _constraints: {
                    value: typeof options[kind] === 'object'
                        ? options[kind]
                        : {},
                    writable: true
                },
                _getUserMedia: {
                    value: options.getUserMedia
                },
                _gUMSilentTrackWorkaround: {
                    value: options.gUMSilentTrackWorkaround
                },
                _eventsToReemitters: {
                    value: new Map([
                        ['muted', function () { return _this.emit('muted', _this); }],
                        ['unmuted', function () { return _this.emit('unmuted', _this); }]
                    ])
                },
                _workaroundWebKitBug1208516: {
                    value: options.workaroundWebKitBug1208516
                },
                _workaroundWebKitBug1208516Cleanup: {
                    value: null,
                    writable: true
                },
                _didCallEnd: {
                    value: false,
                    writable: true
                },
                _isCreatedByCreateLocalTracks: {
                    value: options.isCreatedByCreateLocalTracks
                },
                _noiseCancellation: {
                    value: options.noiseCancellation || null
                },
                _trackSender: {
                    value: mediaTrackSender
                },
                id: {
                    enumerable: true,
                    value: mediaTrackSender.id
                },
                isEnabled: {
                    enumerable: true,
                    get: function () {
                        return mediaTrackSender.enabled;
                    }
                },
                isMuted: {
                    enumerable: true,
                    get: function () {
                        return mediaTrackSender.muted;
                    }
                },
                isStopped: {
                    enumerable: true,
                    get: function () {
                        return mediaTrackSender.readyState === 'ended';
                    }
                }
            });
            // NOTE(mpatwardhan): As a workaround for WebKit bug: https://bugs.webkit.org/show_bug.cgi?id=208516,
            // upon foregrounding, re-acquire new MediaStreamTrack if the existing one is ended or muted.
            if (_this._workaroundWebKitBug1208516) {
                _this._workaroundWebKitBug1208516Cleanup = restartWhenInadvertentlyStopped(_this);
            }
            _this._reemitTrackSenderEvents();
            return _this;
        }
        /**
         * @private
         */
        LocalMediaTrack.prototype._end = function () {
            var _this = this;
            if (this._didCallEnd) {
                return;
            }
            _super.prototype._end.call(this);
            this._didCallEnd = true;
            this._eventsToReemitters.forEach(function (reemitter, event) { return _this._trackSender.removeListener(event, reemitter); });
            this.emit('stopped', this);
        };
        /**
         * @private
         */
        LocalMediaTrack.prototype._initialize = function () {
            if (this._didCallEnd) {
                this._didCallEnd = false;
            }
            if (this._eventsToReemitters) {
                this._reemitTrackSenderEvents();
            }
            _super.prototype._initialize.call(this);
        };
        /**
         * @private
         */
        LocalMediaTrack.prototype._reacquireTrack = function (constraints) {
            var _a;
            var _b = this, getUserMedia = _b._getUserMedia, gUMSilentTrackWorkaround = _b._gUMSilentTrackWorkaround, log = _b._log, kind = _b.mediaStreamTrack.kind;
            log.info('Re-acquiring the MediaStreamTrack');
            log.debug('Constraints:', constraints);
            var gUMConstraints = Object.assign({
                audio: false,
                video: false
            }, (_a = {}, _a[kind] = constraints, _a));
            var gUMPromise = this._workaroundWebKitBug1208516Cleanup
                ? gUMSilentTrackWorkaround(log, getUserMedia, gUMConstraints)
                : getUserMedia(gUMConstraints);
            return gUMPromise.then(function (mediaStream) {
                return mediaStream.getTracks()[0];
            });
        };
        /**
         * @private
         */
        LocalMediaTrack.prototype._reemitTrackSenderEvents = function () {
            var _this = this;
            this._eventsToReemitters.forEach(function (reemitter, event) { return _this._trackSender.on(event, reemitter); });
            this._trackSender.dequeue('muted');
            this._trackSender.dequeue('unmuted');
        };
        /**
         * @private
         */
        LocalMediaTrack.prototype._restart = function (constraints) {
            var _this = this;
            var log = this._log;
            constraints = constraints || this._constraints;
            // NOTE(mmalavalli): If we try and restart a silent MediaStreamTrack
            // without stopping it first, then a NotReadableError is raised in case of
            // video, or the restarted audio will still be silent. Hence, we stop the
            // MediaStreamTrack here.
            this._stop();
            return this._reacquireTrack(constraints).catch(function (error) {
                log.error('Failed to re-acquire the MediaStreamTrack:', { error: error, constraints: constraints });
                throw error;
            }).then(function (newMediaStreamTrack) {
                log.info('Re-acquired the MediaStreamTrack');
                log.debug('MediaStreamTrack:', newMediaStreamTrack);
                _this._constraints = Object.assign({}, constraints);
                return _this._setMediaStreamTrack(newMediaStreamTrack);
            });
        };
        /**
         * @private
         */
        LocalMediaTrack.prototype._setMediaStreamTrack = function (mediaStreamTrack) {
            var _this = this;
            // NOTE(mpatwardhan): Preserve the value of the "enabled" flag.
            mediaStreamTrack.enabled = this.mediaStreamTrack.enabled;
            // NOTE(mmalavalli): Stop the current MediaStreamTrack. If not already
            // stopped, this should fire a "stopped" event.
            this._stop();
            // NOTE(csantos): If there's an unprocessedTrack, this means RTCRtpSender has
            // the processedTrack already set, we don't want to replace that.
            return (this._unprocessedTrack ? Promise.resolve().then(function () {
                _this._unprocessedTrack = mediaStreamTrack;
            }) : this._trackSender.setMediaStreamTrack(mediaStreamTrack).catch(function (error) {
                _this._log.warn('setMediaStreamTrack failed:', { error: error, mediaStreamTrack: mediaStreamTrack });
            })).then(function () {
                _this._initialize();
                _this._getAllAttachedElements().forEach(function (el) { return _this._attach(el); });
            });
        };
        /**
         * @private
         */
        LocalMediaTrack.prototype._stop = function () {
            this.mediaStreamTrack.stop();
            this._end();
            return this;
        };
        LocalMediaTrack.prototype.enable = function (enabled) {
            enabled = typeof enabled === 'boolean' ? enabled : true;
            if (enabled !== this.mediaStreamTrack.enabled) {
                this._log.info((enabled ? 'En' : 'Dis') + "abling");
                this.mediaStreamTrack.enabled = enabled;
                this.emit(enabled ? 'enabled' : 'disabled', this);
            }
            return this;
        };
        LocalMediaTrack.prototype.disable = function () {
            return this.enable(false);
        };
        LocalMediaTrack.prototype.restart = function (constraints) {
            var _this = this;
            var kind = this.kind;
            if (!this._isCreatedByCreateLocalTracks) {
                return Promise.reject(ILLEGAL_INVOKE('restart', 'can only be called on a'
                    + (" Local" + capitalize(kind) + "Track that is created using createLocalTracks")
                    + (" or createLocal" + capitalize(kind) + "Track.")));
            }
            if (this._workaroundWebKitBug1208516Cleanup) {
                this._workaroundWebKitBug1208516Cleanup();
                this._workaroundWebKitBug1208516Cleanup = null;
            }
            var promise = this._restart(constraints);
            if (this._workaroundWebKitBug1208516) {
                promise = promise.finally(function () {
                    _this._workaroundWebKitBug1208516Cleanup = restartWhenInadvertentlyStopped(_this);
                });
            }
            return promise;
        };
        LocalMediaTrack.prototype.stop = function () {
            this._log.info('Stopping');
            if (this._workaroundWebKitBug1208516Cleanup) {
                this._workaroundWebKitBug1208516Cleanup();
                this._workaroundWebKitBug1208516Cleanup = null;
            }
            return this._stop();
        };
        return LocalMediaTrack;
    }(AudioOrVideoTrack));
}
/**
 * Restart the given {@link LocalMediaTrack} if it has been inadvertently stopped.
 * @private
 * @param {LocalAudioTrack|LocalVideoTrack} localMediaTrack
 * @returns {function} Clean up listeners attached by the workaround
 */
function restartWhenInadvertentlyStopped(localMediaTrack) {
    var log = localMediaTrack._log, kind = localMediaTrack.kind, noiseCancellation = localMediaTrack._noiseCancellation;
    var detectSilence = {
        audio: detectSilentAudio,
        video: detectSilentVideo
    }[kind];
    var getSourceMediaStreamTrack = function () { return noiseCancellation
        ? noiseCancellation.sourceTrack
        : localMediaTrack.mediaStreamTrack; };
    var el = localMediaTrack._dummyEl;
    var mediaStreamTrack = getSourceMediaStreamTrack();
    var trackChangeInProgress = null;
    function checkSilence() {
        // The dummy element is paused, so play it and then detect silence.
        return el.play().then(function () { return detectSilence(el); }).then(function (isSilent) {
            if (isSilent) {
                log.warn('Silence detected');
            }
            else {
                log.info('Non-silence detected');
            }
            return isSilent;
        }).catch(function (error) {
            log.warn('Failed to detect silence:', error);
        }).finally(function () {
            // Pause the dummy element again, if there is no processed track.
            if (!localMediaTrack.processedTrack) {
                el.pause();
            }
        });
    }
    function shouldReacquireTrack() {
        var _workaroundWebKitBug1208516Cleanup = localMediaTrack._workaroundWebKitBug1208516Cleanup, isStopped = localMediaTrack.isStopped;
        var isInadvertentlyStopped = isStopped && !!_workaroundWebKitBug1208516Cleanup;
        var muted = getSourceMediaStreamTrack().muted;
        // NOTE(mmalavalli): Restart the LocalMediaTrack if:
        // 1. The app is foregrounded, and
        // 2. A restart is not already in progress, and
        // 3. The LocalMediaTrack is either muted, inadvertently stopped or silent
        return Promise.resolve().then(function () {
            return document.visibilityState === 'visible'
                && !trackChangeInProgress
                && (muted || isInadvertentlyStopped || checkSilence());
        });
    }
    function maybeRestart() {
        return Promise.race([
            waitForEvent(mediaStreamTrack, 'unmute'),
            waitForSometime(50)
        ]).then(function () { return shouldReacquireTrack(); }).then(function (shouldReacquire) {
            if (shouldReacquire && !trackChangeInProgress) {
                trackChangeInProgress = defer();
                localMediaTrack._restart().finally(function () {
                    el = localMediaTrack._dummyEl;
                    removeMediaStreamTrackListeners();
                    mediaStreamTrack = getSourceMediaStreamTrack();
                    addMediaStreamTrackListeners();
                    trackChangeInProgress.resolve();
                    trackChangeInProgress = null;
                }).catch(function (error) {
                    log.error('failed to restart track: ', error);
                });
            }
            // NOTE(mmalavalli): If the MediaStreamTrack ends before the DOM is visible,
            // then this makes sure that visibility callback for phase 2 is called only
            // after the MediaStreamTrack is re-acquired.
            var promise = (trackChangeInProgress && trackChangeInProgress.promise) || Promise.resolve();
            return promise.finally(function () { return localMediaRestartDeferreds.resolveDeferred(kind); });
        }).catch(function (ex) {
            log.error("error in maybeRestart: " + ex.message);
        });
    }
    function onMute() {
        var log = localMediaTrack._log, kind = localMediaTrack.kind;
        log.info('Muted');
        log.debug('LocalMediaTrack:', localMediaTrack);
        // NOTE(mmalavalli): When a LocalMediaTrack is muted without the app being
        // backgrounded, and the inadvertently paused elements are played before it
        // is restarted, it never gets unmuted due to the WebKit Bug 213853. Hence,
        // setting this Deferred will make sure that the inadvertently paused elements
        // are played only after the LocalMediaTrack is unmuted.
        //
        // Bug: https://bugs.webkit.org/show_bug.cgi?id=213853
        //
        localMediaRestartDeferreds.startDeferred(kind);
    }
    function addMediaStreamTrackListeners() {
        mediaStreamTrack.addEventListener('ended', maybeRestart);
        mediaStreamTrack.addEventListener('mute', onMute);
        mediaStreamTrack.addEventListener('unmute', maybeRestart);
    }
    function removeMediaStreamTrackListeners() {
        mediaStreamTrack.removeEventListener('ended', maybeRestart);
        mediaStreamTrack.removeEventListener('mute', onMute);
        mediaStreamTrack.removeEventListener('unmute', maybeRestart);
    }
    // NOTE(mpatwardhan): listen for document visibility callback on phase 1.
    // this ensures that we acquire media tracks before RemoteMediaTrack
    // tries to `play` them (in phase 2). This order is important because
    // play can fail on safari if audio is not being captured.
    var onVisibilityChange = function (isVisible) {
        return isVisible ? maybeRestart() : false;
    };
    documentVisibilityMonitor.onVisibilityChange(1, onVisibilityChange);
    addMediaStreamTrackListeners();
    return function () {
        documentVisibilityMonitor.offVisibilityChange(1, onVisibilityChange);
        removeMediaStreamTrackListeners();
    };
}
module.exports = mixinLocalMediaTrack;

},{"../../util":133,"../../util/browserdetection":124,"../../util/constants":126,"../../util/detectsilentaudio":127,"../../util/detectsilentvideo":128,"../../util/documentvisibilitymonitor.js":129,"../../util/localmediarestartdeferreds":136,"../../webaudio/workaround180748":156,"../../webrtc":159,"./sender":40}],26:[function(require,module,exports){
/* eslint new-cap:0 */
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var TrackPublication = require('./trackpublication');
var _a = require('../../util/constants'), E = _a.typeErrors, trackPriority = _a.trackPriority;
/**
 * A {@link LocalTrackPublication} is a {@link LocalTrack} that has been
 * published to a {@link Room}.
 * @extends TrackPublication
 * @property {boolean} isTrackEnabled - whether the published {@link LocalTrack}
 *   is enabled
 * @property {Track.Kind} kind - kind of the published {@link LocalTrack}
 * @property {Track.Priority} priority - the publish priority of the {@link LocalTrack}
 * @property {LocalTrack} track - the {@link LocalTrack}
 * @emits LocalTrackPublication#warning
 * @emits LocalTrackPublication#warningsCleared
 */
var LocalTrackPublication = /** @class */ (function (_super) {
    __extends(LocalTrackPublication, _super);
    /**
     * Construct a {@link LocalTrackPublication}.
     * @param {LocalTrackPublicationSignaling} signaling - The corresponding
     *   {@link LocalTrackPublicationSignaling}
     * @param {LocalTrack} track - The {@link LocalTrack}
     * @param {function(LocalTrackPublication): void} unpublish - The callback
     *   that unpublishes the {@link LocalTrackPublication}
     * @param {TrackPublicationOptions} options - {@link LocalTrackPublication}
     *   options
     */
    function LocalTrackPublication(signaling, track, unpublish, options) {
        var _this = _super.call(this, track.name, signaling.sid, options) || this;
        Object.defineProperties(_this, {
            _reemitSignalingEvent: {
                value: function () {
                    var args = [];
                    for (var _i = 0; _i < arguments.length; _i++) {
                        args[_i] = arguments[_i];
                    }
                    return _this.emit.apply(_this, __spreadArray([args && args.length ? 'warning' : 'warningsCleared'], __read(args)));
                }
            },
            _reemitTrackEvent: {
                value: function () { return _this.emit(_this.isTrackEnabled
                    ? 'trackEnabled'
                    : 'trackDisabled'); }
            },
            _signaling: {
                value: signaling
            },
            _unpublish: {
                value: unpublish
            },
            isTrackEnabled: {
                enumerable: true,
                get: function () {
                    return this.track.kind === 'data' ? true : this.track.isEnabled;
                }
            },
            kind: {
                enumerable: true,
                value: track.kind
            },
            priority: {
                enumerable: true,
                get: function () {
                    return signaling.updatedPriority;
                }
            },
            track: {
                enumerable: true,
                value: track
            }
        });
        ['disabled', 'enabled'].forEach(function (name) {
            return track.on(name, _this._reemitTrackEvent);
        });
        ['warning', 'warningsCleared'].forEach(function (name) {
            return signaling.on(name, _this._reemitSignalingEvent);
        });
        return _this;
    }
    LocalTrackPublication.prototype.toString = function () {
        return "[LocalTrackPublication #" + this._instanceId + ": " + this.trackSid + "]";
    };
    /**
     * Update the {@link Track.Priority} of the published {@link LocalTrack}.
     * @param {Track.Priority} priority - the new {@link Track.priority}
     * @returns {this}
     * @throws {RangeError}
     */
    LocalTrackPublication.prototype.setPriority = function (priority) {
        var priorityValues = Object.values(trackPriority);
        if (!priorityValues.includes(priority)) {
            throw E.INVALID_VALUE('priority', priorityValues);
        }
        this._signaling.setPriority(priority);
        return this;
    };
    /**
     * Unpublish a {@link LocalTrackPublication}. This means that the media
     * from this {@link LocalTrackPublication} is no longer available to the
     * {@link Room}'s {@link RemoteParticipant}s.
     * @returns {this}
     */
    LocalTrackPublication.prototype.unpublish = function () {
        var _this = this;
        ['disabled', 'enabled'].forEach(function (name) {
            return _this.track.removeListener(name, _this._reemitTrackEvent);
        });
        ['warning', 'warningsCleared'].forEach(function (name) {
            return _this._signaling.removeListener(name, _this._reemitSignalingEvent);
        });
        this._unpublish(this);
        return this;
    };
    return LocalTrackPublication;
}(TrackPublication));
/**
 * The published {@link LocalTrack} encountered a warning.
 * This event is only raised if you enabled warnings using <code>notifyWarnings</code> in <code>ConnectOptions</code>.
 * @event LocalTrackPublication#warning
 * @param {string} name - The warning that was raised.
 */
/**
 * The published {@link LocalTrack} cleared all warnings.
 * This event is only raised if you enabled warnings using <code>notifyWarnings</code> in <code>ConnectOptions</code>.
 * @event LocalTrackPublication#warningsCleared
 */
module.exports = LocalTrackPublication;

},{"../../util/constants":126,"./trackpublication":41}],27:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var isIOS = require('../../util/browserdetection').isIOS;
var detectSilentVideo = require('../../util/detectsilentvideo');
var mixinLocalMediaTrack = require('./localmediatrack');
var VideoTrack = require('./videotrack');
var LocalMediaVideoTrack = mixinLocalMediaTrack(VideoTrack);
/**
 * A {@link LocalVideoTrack} is a {@link VideoTrack} representing video that
 * your {@link LocalParticipant} can publish to a {@link Room}. It can be
 * enabled and disabled with {@link LocalVideoTrack#enable} and
 * {@link LocalVideoTrack#disable} or stopped completely with
 * {@link LocalVideoTrack#stop}.
 * @extends VideoTrack
 * @property {Track.ID} id - The {@link LocalVideoTrack}'s ID
 * @property {boolean} isMuted - Whether or not the video source has stopped sending frames to the
 *   {@link LocalVideoTrack}; This can happen when the camera is taken over by another application,
 *   mainly on mobile devices; When this property toggles, then <code>muted</code> and <code>unmuted</code>
 *   events are fired appropriately
 * @property {boolean} isStopped - Whether or not the {@link LocalVideoTrack} is
 *   stopped
 * @emits LocalVideoTrack#disabled
 * @emits LocalVideoTrack#enabled
 * @emits LocalVideoTrack#muted
 * @emits LocalVideoTrack#started
 * @emits LocalVideoTrack#stopped
 * @emits LocalVideoTrack#unmuted
 */
var LocalVideoTrack = /** @class */ (function (_super) {
    __extends(LocalVideoTrack, _super);
    /**
     * Construct a {@link LocalVideoTrack} from a MediaStreamTrack.
     * @param {MediaStreamTrack} mediaStreamTrack - The underlying MediaStreamTrack
     * @param {LocalTrackOptions} [options] - {@link LocalTrack} options
     */
    function LocalVideoTrack(mediaStreamTrack, options) {
        var _this = this;
        options = Object.assign({
            workaroundSilentLocalVideo: isIOS()
                && typeof document !== 'undefined'
                && typeof document.createElement === 'function'
        }, options);
        _this = _super.call(this, mediaStreamTrack, options) || this;
        Object.defineProperties(_this, {
            _workaroundSilentLocalVideo: {
                value: options.workaroundSilentLocalVideo
                    ? workaroundSilentLocalVideo
                    : null
            },
            _workaroundSilentLocalVideoCleanup: {
                value: null,
                writable: true
            }
        });
        // NOTE(mmalavalli): In iOS Safari, we work around a bug where local video
        // MediaStreamTracks are silent (even though they are enabled, live and unmuted)
        // after accepting/rejecting a phone call.
        if (_this._workaroundSilentLocalVideo) {
            _this._workaroundSilentLocalVideoCleanup = _this._workaroundSilentLocalVideo(_this, document);
        }
        return _this;
    }
    LocalVideoTrack.prototype.toString = function () {
        return "[LocalVideoTrack #" + this._instanceId + ": " + this.id + "]";
    };
    /**
     * @private
     */
    LocalVideoTrack.prototype._checkIfCanCaptureFrames = function () {
        return _super.prototype._checkIfCanCaptureFrames.call(this, this._trackSender.isPublishing);
    };
    /**
     * @private
     */
    LocalVideoTrack.prototype._end = function () {
        return _super.prototype._end.apply(this, arguments);
    };
    /**
     * @private
     */
    LocalVideoTrack.prototype._setSenderMediaStreamTrack = function (useProcessed) {
        var _this = this;
        var unprocessedTrack = this.mediaStreamTrack;
        var mediaStreamTrack = useProcessed ? this.processedTrack : unprocessedTrack;
        return this._trackSender.setMediaStreamTrack(mediaStreamTrack)
            .catch(function (error) { return _this._log.warn('setMediaStreamTrack failed on LocalVideoTrack RTCRtpSender', { error: error, mediaStreamTrack: mediaStreamTrack }); })
            .then(function () {
            _this._unprocessedTrack = useProcessed ? unprocessedTrack : null;
        });
    };
    /**
     * Add a {@link VideoProcessor} to allow for custom processing of video frames belonging to a VideoTrack.
     * @param {VideoProcessor} processor - The {@link VideoProcessor} to use.
     * @param {AddProcessorOptions} [options] - {@link AddProcessorOptions} to provide.
     * @returns {this}
     * @example
     * class GrayScaleProcessor {
     *   constructor(percentage) {
     *     this.percentage = percentage;
     *   }
     *   processFrame(inputFrameBuffer, outputFrameBuffer) {
     *     const context = outputFrameBuffer.getContext('2d');
     *     context.filter = `grayscale(${this.percentage}%)`;
     *     context.drawImage(inputFrameBuffer, 0, 0, inputFrameBuffer.width, inputFrameBuffer.height);
     *   }
     * }
     *
     * const localVideoTrack = Array.from(room.localParticipant.videoTracks.values())[0].track;
     * localVideoTrack.addProcessor(new GrayScaleProcessor(100));
     */
    LocalVideoTrack.prototype.addProcessor = function () {
        this._log.debug('Adding VideoProcessor to the LocalVideoTrack');
        var result = _super.prototype.addProcessor.apply(this, arguments);
        if (!this.processedTrack) {
            return this._log.warn('Unable to add a VideoProcessor to the LocalVideoTrack');
        }
        this._log.debug('Updating LocalVideoTrack\'s MediaStreamTrack with the processed MediaStreamTrack', this.processedTrack);
        this._setSenderMediaStreamTrack(true);
        return result;
    };
    /**
     * Remove the previously added {@link VideoProcessor} using `addProcessor` API.
     * @param {VideoProcessor} processor - The {@link VideoProcessor} to remove.
     * @returns {this}
     * @example
     * class GrayScaleProcessor {
     *   constructor(percentage) {
     *     this.percentage = percentage;
     *   }
     *   processFrame(inputFrameBuffer, outputFrameBuffer) {
     *     const context = outputFrameBuffer.getContext('2d');
     *     context.filter = `grayscale(${this.percentage}%)`;
     *     context.drawImage(inputFrameBuffer, 0, 0, inputFrameBuffer.width, inputFrameBuffer.height);
     *   }
     * }
     *
     * const localVideoTrack = Array.from(room.localParticipant.videoTracks.values())[0].track;
     * const grayScaleProcessor = new GrayScaleProcessor(100);
     * localVideoTrack.addProcessor(grayScaleProcessor);
     *
     * document.getElementById('remove-button').onclick = () => localVideoTrack.removeProcessor(grayScaleProcessor);
     */
    LocalVideoTrack.prototype.removeProcessor = function () {
        var _this = this;
        this._log.debug('Removing VideoProcessor from the LocalVideoTrack');
        var result = _super.prototype.removeProcessor.apply(this, arguments);
        this._log.debug('Updating LocalVideoTrack\'s MediaStreamTrack with the original MediaStreamTrack');
        this._setSenderMediaStreamTrack()
            .then(function () { return _this._updateElementsMediaStreamTrack(); });
        return result;
    };
    /**
     * Disable the {@link LocalVideoTrack}. This is equivalent to pausing a video source.
     * If a {@link VideoProcessor} is added, then <code>processedTrack</code> is also disabled.
     * @returns {this}
     * @fires VideoTrack#disabled
     */
    LocalVideoTrack.prototype.disable = function () {
        var result = _super.prototype.disable.apply(this, arguments);
        if (this.processedTrack) {
            this.processedTrack.enabled = false;
        }
        return result;
    };
    /**
     * Enable the {@link LocalVideoTrack}. This is equivalent to unpausing the video source.
     * If a {@link VideoProcessor} is added, then <code>processedTrack</code> is also enabled.
     * @returns {this}
     * @fires VideoTrack#enabled
    */ /**
     * Enable or disable the {@link LocalVideoTrack}. This is equivalent to unpausing or pausing
     * the video source respectively. If a {@link VideoProcessor} is added, then <code>processedTrack</code>
     * is also enabled or disabled.
     * @param {boolean} [enabled] - Specify false to disable the
     *   {@link LocalVideoTrack}
     * @returns {this}
     * @fires VideoTrack#disabled
     * @fires VideoTrack#enabled
     */
    LocalVideoTrack.prototype.enable = function (enabled) {
        if (enabled === void 0) { enabled = true; }
        var result = _super.prototype.enable.apply(this, arguments);
        if (this.processedTrack) {
            this.processedTrack.enabled = enabled;
            if (enabled) {
                this._captureFrames();
                this._log.debug('Updating LocalVideoTrack\'s MediaStreamTrack with the processed MediaStreamTrack', this.processedTrack);
                this._setSenderMediaStreamTrack(true);
            }
        }
        return result;
    };
    /**
     * Restart the {@link LocalVideoTrack}. This stops the existing MediaStreamTrack
     * and creates a new MediaStreamTrack. If the {@link LocalVideoTrack} is being published
     * to a {@link Room}, then all the {@link RemoteParticipant}s will start receiving media
     * from the newly created MediaStreamTrack. You can access the new MediaStreamTrack via
     * the <code>mediaStreamTrack</code> property. If you want to listen to events on
     * the MediaStreamTrack directly, please do so in the "started" event handler. Also,
     * the {@link LocalVideoTrack}'s ID is no longer guaranteed to be the same as the
     * underlying MediaStreamTrack's ID.
     * @param {MediaTrackConstraints} [constraints] - The optional <a href="https://developer.mozilla.org/en-US/docs/Web/API/MediaTrackConstraints" target="_blank">MediaTrackConstraints</a>
     *   for restarting the {@link LocalVideoTrack}; If not specified, then the current MediaTrackConstraints
     *   will be used; If <code>{}</code> (empty object) is specified, then the default MediaTrackConstraints
     *   will be used
     * @returns {Promise<void>} Rejects with a TypeError if the {@link LocalVideoTrack} was not created
     *   using an one of <code>createLocalVideoTrack</code>, <code>createLocalTracks</code> or <code>connect</code>;
     *   Also rejects with the <a href="https://developer.mozilla.org/en-US/docs/Web/API/MediaDevices/getUserMedia#Exceptions" target="_blank">DOMException</a>
     *   raised by <code>getUserMedia</code> when it fails
     * @fires LocalVideoTrack#stopped
     * @fires LocalVideoTrack#started
     * @example
     * const { connect, createLocalVideoTrack } = require('twilio-video');
     *
     * // Create a LocalVideoTrack that captures video from the front-facing camera.
     * createLocalVideoTrack({ facingMode: 'user' }).then(function(localVideoTrack) {
     *   return connect('token', {
     *     name: 'my-cool-room',
     *     tracks: [localVideoTrack]
     *   });
     * }).then(function(room) {
     *   // Restart the LocalVideoTrack to capture video from the back-facing camera.
     *   const localVideoTrack = Array.from(room.localParticipant.videoTracks.values())[0].track;
     *   return localVideoTrack.restart({ facingMode: 'environment' });
     * });
     */
    LocalVideoTrack.prototype.restart = function () {
        var _this = this;
        if (this._workaroundSilentLocalVideoCleanup) {
            this._workaroundSilentLocalVideoCleanup();
            this._workaroundSilentLocalVideoCleanup = null;
        }
        var promise = _super.prototype.restart.apply(this, arguments);
        if (this.processor) {
            promise.then(function () {
                _this._restartProcessor();
            });
        }
        if (this._workaroundSilentLocalVideo) {
            promise.finally(function () {
                _this._workaroundSilentLocalVideoCleanup = _this._workaroundSilentLocalVideo(_this, document);
            });
        }
        return promise;
    };
    /**
     * Calls stop on the underlying MediaStreamTrack. If you choose to stop a
     * {@link LocalVideoTrack}, you should unpublish it after stopping.
     * @returns {this}
     * @fires LocalVideoTrack#stopped
     */
    LocalVideoTrack.prototype.stop = function () {
        if (this._workaroundSilentLocalVideoCleanup) {
            this._workaroundSilentLocalVideoCleanup();
            this._workaroundSilentLocalVideoCleanup = null;
        }
        return _super.prototype.stop.apply(this, arguments);
    };
    return LocalVideoTrack;
}(LocalMediaVideoTrack));
/**
 * Work around a bug where local video MediaStreamTracks are silent (even though
 * they are enabled, live and unmuted) after accepting/rejecting a phone call.
 * @private
 * @param {LocalVideoTrack} localVideoTrack
 * @param {HTMLDocument} doc
 * @returns {function} Cleans up listeners attached by the workaround
 */
function workaroundSilentLocalVideo(localVideoTrack, doc) {
    var log = localVideoTrack._log;
    var el = localVideoTrack._dummyEl, mediaStreamTrack = localVideoTrack.mediaStreamTrack;
    function onUnmute() {
        if (!localVideoTrack.isEnabled) {
            return;
        }
        log.info('Unmuted, checking silence');
        // The dummy element is paused, so play it and then detect silence.
        el.play().then(function () { return detectSilentVideo(el, doc); }).then(function (isSilent) {
            if (!isSilent) {
                log.info('Non-silent frames detected, so no need to restart');
                return;
            }
            log.warn('Silence detected, restarting');
            // NOTE(mmalavalli): If we try and restart a silent MediaStreamTrack
            // without stopping it first, then a NotReadableError is raised. Hence,
            // we stop the MediaStreamTrack here.
            localVideoTrack._stop();
            // Restart the LocalVideoTrack.
            // eslint-disable-next-line consistent-return
            return localVideoTrack._restart();
        }).catch(function (error) {
            log.warn('Failed to detect silence and restart:', error);
        }).finally(function () {
            // If silent frames were not detected, then pause the dummy element again,
            // if there is no processed track.
            el = localVideoTrack._dummyEl;
            if (el && !el.paused && !localVideoTrack.processedTrack) {
                el.pause();
            }
            // Reset the unmute handler.
            mediaStreamTrack.removeEventListener('unmute', onUnmute);
            mediaStreamTrack = localVideoTrack.mediaStreamTrack;
            mediaStreamTrack.addEventListener('unmute', onUnmute);
        });
    }
    // Set the unmute handler.
    mediaStreamTrack.addEventListener('unmute', onUnmute);
    return function () {
        mediaStreamTrack.removeEventListener('unmute', onUnmute);
    };
}
/**
 * The {@link LocalVideoTrack} was disabled, i.e. the video source was paused by the user.
 * @param {LocalVideoTrack} track - The {@link LocalVideoTrack} that was
 *   disabled
 * @event LocalVideoTrack#disabled
 */
/**
 * The {@link LocalVideoTrack} was enabled, i.e. the video source was unpaused by the user.
 * @param {LocalVideoTrack} track - The {@link LocalVideoTrack} that was enabled
 * @event LocalVideoTrack#enabled
 */
/**
 * The {@link LocalVideoTrack} was muted because the video source stopped sending frames, most
 * likely due to another application taking said video source, especially on mobile devices.
 * @param {LocalVideoTrack} track - The {@link LocalVideoTrack} that was muted
 * @event LocalVideoTrack#muted
 */
/**
 * The {@link LocalVideoTrack} started. This means there is enough video data
 * to begin playback.
 * @param {LocalVideoTrack} track - The {@link LocalVideoTrack} that started
 * @event LocalVideoTrack#started
 */
/**
 * The {@link LocalVideoTrack} stopped, either because {@link LocalVideoTrack#stop}
 * or {@link LocalVideoTrack#restart} was called or because the underlying
 * MediaStreamTrack ended.
 * @param {LocalVideoTrack} track - The {@link LocalVideoTrack} that stopped
 * @event LocalVideoTrack#stopped
 */
/**
 * The {@link LocalVideoTrack} was unmuted because the video source resumed sending frames,
 * most likely due to the application that took over the said video source has released it
 * back to the application, especially on mobile devices. This event is also fired when
 * {@link LocalVideoTrack#restart} is called on a muted {@link LocalVideoTrack} with a
 * new video source.
 * @param {LocalVideoTrack} track - The {@link LocalVideoTrack} that was unmuted
 * @event LocalVideoTrack#unmuted
 */
module.exports = LocalVideoTrack;

},{"../../util/browserdetection":124,"../../util/detectsilentvideo":128,"./localmediatrack":25,"./videotrack":44}],28:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var LocalTrackPublication = require('./localtrackpublication');
/**
 * A {@link LocalVideoTrackPublication} is a {@link LocalVideoTrack} that has
 * been published to a {@link Room}.
 * @extends LocalTrackPublication
 * @property {Track.Kind} kind - "video"
 * @property {LocalVideoTrack} track - the {@link LocalVideoTrack}
 */
var LocalVideoTrackPublication = /** @class */ (function (_super) {
    __extends(LocalVideoTrackPublication, _super);
    /**
     * Construct a {@link LocalVideoTrackPublication}.
     * @param {LocalTrackPublicationSignaling} signaling - The corresponding
     *   {@link LocalTrackPublicationSignaling}
     * @param {LocalVideoTrack} track - the {@link LocalVideoTrack}
     * @param {function(LocalTrackPublication): void} unpublish - The callback
     *    that unpublishes the {@link LocalTrackPublication}
     * @param {TrackPublicationOptions} options - {@link LocalTrackPublication} options
     */
    function LocalVideoTrackPublication(signaling, track, unpublish, options) {
        return _super.call(this, signaling, track, unpublish, options) || this;
    }
    LocalVideoTrackPublication.prototype.toString = function () {
        return "[LocalVideoTrackPublication #" + this._instanceId + ": " + this.trackSid + "]";
    };
    return LocalVideoTrackPublication;
}(LocalTrackPublication));
module.exports = LocalVideoTrackPublication;

},{"./localtrackpublication":26}],29:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var isIOS = require('../../util/browserdetection').isIOS;
var MediaStream = require('../../webrtc').MediaStream;
var _a = require('../../util'), waitForEvent = _a.waitForEvent, waitForSometime = _a.waitForSometime;
var localMediaRestartDeferreds = require('../../util/localmediarestartdeferreds');
var Track = require('./');
/**
 * A {@link MediaTrack} represents audio or video that can be sent to or
 * received from a {@link Room}.
 * @extends Track
 * @property {Track.ID} id - This {@link Track}'s ID
 * @property {boolean} isStarted - Whether or not the {@link MediaTrack} has
 *   started
 * @property {boolean} isEnabled - Whether or not the {@link MediaTrack} is
 *   enabled (i.e., whether it is paused or muted)
 * @property {Track.Kind} kind - The kind of the underlying
 *   MediaStreamTrack, "audio" or "video"
 * @property {MediaStreamTrack} mediaStreamTrack - The underlying
 *   MediaStreamTrack
 * @emits MediaTrack#disabled
 * @emits MediaTrack#enabled
 * @emits MediaTrack#started
 */
var MediaTrack = /** @class */ (function (_super) {
    __extends(MediaTrack, _super);
    /**
     * Construct a {@link MediaTrack}.
     * @param {MediaTrackTransceiver} mediaTrackTransceiver
     * @param {{log: Log}} options
     */
    function MediaTrack(mediaTrackTransceiver, options) {
        var _this = this;
        options = Object.assign({
            playPausedElementsIfNotBackgrounded: isIOS()
                && typeof document === 'object'
                && typeof document.addEventListener === 'function'
                && typeof document.visibilityState === 'string'
        }, options);
        _this = _super.call(this, mediaTrackTransceiver.id, mediaTrackTransceiver.kind, options) || this;
        var isStarted = false;
        options = Object.assign({
            MediaStream: MediaStream
        }, options);
        /* istanbul ignore next */
        Object.defineProperties(_this, {
            _attachments: {
                value: new Set()
            },
            _dummyEl: {
                value: null,
                writable: true
            },
            _elShims: {
                value: new WeakMap()
            },
            _isStarted: {
                get: function () {
                    return isStarted;
                },
                set: function (_isStarted) {
                    isStarted = _isStarted;
                }
            },
            _playPausedElementsIfNotBackgrounded: {
                value: options.playPausedElementsIfNotBackgrounded
            },
            _shouldShimAttachedElements: {
                value: options.workaroundWebKitBug212780
                    || options.playPausedElementsIfNotBackgrounded
            },
            _unprocessedTrack: {
                value: null,
                writable: true
            },
            _MediaStream: {
                value: options.MediaStream
            },
            isStarted: {
                enumerable: true,
                get: function () {
                    return isStarted;
                }
            },
            mediaStreamTrack: {
                enumerable: true,
                get: function () {
                    return this._unprocessedTrack || mediaTrackTransceiver.track;
                }
            },
            processedTrack: {
                enumerable: true,
                value: null,
                writable: true
            }
        });
        _this._initialize();
        return _this;
    }
    /**
     * @private
     */
    MediaTrack.prototype._start = function () {
        this._log.debug('Started');
        this._isStarted = true;
        if (this._dummyEl) {
            this._dummyEl.oncanplay = null;
        }
        // eslint-disable-next-line no-use-before-define
        this.emit('started', this);
    };
    /**
     * @private
     */
    MediaTrack.prototype._initialize = function () {
        var self = this;
        this._log.debug('Initializing');
        this._dummyEl = this._createElement();
        this.mediaStreamTrack.addEventListener('ended', function onended() {
            self._end();
            self.mediaStreamTrack.removeEventListener('ended', onended);
        });
        if (this._dummyEl) {
            this._dummyEl.muted = true;
            this._dummyEl.oncanplay = this._start.bind(this, this._dummyEl);
            // NOTE(csantos): We always want to attach the original mediaStreamTrack for dummyEl
            this._attach(this._dummyEl, this.mediaStreamTrack);
            this._attachments.delete(this._dummyEl);
        }
    };
    /**
     * @private
     */
    MediaTrack.prototype._end = function () {
        this._log.debug('Ended');
        if (this._dummyEl) {
            this._dummyEl.remove();
            this._dummyEl.srcObject = null;
            this._dummyEl.oncanplay = null;
            this._dummyEl = null;
        }
    };
    MediaTrack.prototype.attach = function (el) {
        var _this = this;
        if (typeof el === 'string') {
            el = this._selectElement(el);
        }
        else if (!el) {
            el = this._createElement();
        }
        this._log.debug('Attempting to attach to element:', el);
        el = this._attach(el);
        if (this._shouldShimAttachedElements && !this._elShims.has(el)) {
            var onUnintentionallyPaused = this._playPausedElementsIfNotBackgrounded
                ? function () { return playIfPausedAndNotBackgrounded(el, _this._log); }
                : null;
            this._elShims.set(el, shimMediaElement(el, onUnintentionallyPaused));
        }
        return el;
    };
    /**
     * Attach the provided MediaStreamTrack to the media element.
     * @param el - The media element to attach to
     * @param mediaStreamTrack - The MediaStreamTrack to attach. If this is
     * not provided, it uses the processedTrack if it exists
     * or it defaults to the current mediaStreamTrack
     * @private
     */
    MediaTrack.prototype._attach = function (el, mediaStreamTrack) {
        if (mediaStreamTrack === void 0) { mediaStreamTrack = this.processedTrack || this.mediaStreamTrack; }
        var mediaStream = el.srcObject;
        if (!(mediaStream instanceof this._MediaStream)) {
            mediaStream = new this._MediaStream();
        }
        var getTracks = mediaStreamTrack.kind === 'audio'
            ? 'getAudioTracks'
            : 'getVideoTracks';
        mediaStream[getTracks]().forEach(function (track) {
            mediaStream.removeTrack(track);
        });
        mediaStream.addTrack(mediaStreamTrack);
        // NOTE(mpatwardhan): resetting `srcObject` here, causes flicker (JSDK-2641), but it lets us
        // to sidestep the a chrome bug: https://bugs.chromium.org/p/chromium/issues/detail?id=1052353
        //
        el.srcObject = mediaStream;
        el.autoplay = true;
        el.playsInline = true;
        if (!this._attachments.has(el)) {
            this._attachments.add(el);
        }
        return el;
    };
    /**
     * @private
     */
    MediaTrack.prototype._selectElement = function (selector) {
        var el = document.querySelector(selector);
        if (!el) {
            throw new Error("Selector matched no element: " + selector);
        }
        return el;
    };
    /**
     * @private
     */
    MediaTrack.prototype._updateElementsMediaStreamTrack = function () {
        var _this = this;
        this._log.debug('Reattaching all elements to update mediaStreamTrack');
        this._getAllAttachedElements().forEach(function (el) { return _this._attach(el); });
    };
    /**
     * @private
     */
    MediaTrack.prototype._createElement = function () {
        return typeof document !== 'undefined'
            ? document.createElement(this.kind)
            : null;
    };
    MediaTrack.prototype.detach = function (el) {
        var els;
        if (typeof el === 'string') {
            els = [this._selectElement(el)];
        }
        else if (!el) {
            els = this._getAllAttachedElements();
        }
        else {
            els = [el];
        }
        this._log.debug('Attempting to detach from elements:', els);
        this._detachElements(els);
        return el ? els[0] : els;
    };
    /**
     * @private
     */
    MediaTrack.prototype._detachElements = function (elements) {
        return elements.map(this._detachElement.bind(this));
    };
    /**
     * @private
     */
    MediaTrack.prototype._detachElement = function (el) {
        if (!this._attachments.has(el)) {
            return el;
        }
        var mediaStream = el.srcObject;
        if (mediaStream instanceof this._MediaStream) {
            mediaStream.removeTrack(this.processedTrack || this.mediaStreamTrack);
        }
        this._attachments.delete(el);
        if (this._shouldShimAttachedElements && this._elShims.has(el)) {
            var shim = this._elShims.get(el);
            shim.unShim();
            this._elShims.delete(el);
        }
        return el;
    };
    /**
     * @private
     */
    MediaTrack.prototype._getAllAttachedElements = function () {
        var els = [];
        this._attachments.forEach(function (el) {
            els.push(el);
        });
        return els;
    };
    return MediaTrack;
}(Track));
/**
 * Play an HTMLMediaElement if it is paused and not backgrounded.
 * @private
 * @param {HTMLMediaElement} el
 * @param {Log} log
 * @returns {void}
 */
function playIfPausedAndNotBackgrounded(el, log) {
    var tag = el.tagName.toLowerCase();
    log.warn('Unintentionally paused:', el);
    // NOTE(mmalavalli): When the element is unintentionally paused, we wait one
    // second for the "onvisibilitychange" event on the HTMLDocument to see if the
    // app will be backgrounded. If not, then the element can be safely played.
    Promise.race([
        waitForEvent(document, 'visibilitychange'),
        waitForSometime(1000)
    ]).then(function () {
        if (document.visibilityState === 'visible') {
            // NOTE(mmalavalli): We play the inadvertently paused elements only after
            // the LocalAudioTrack is unmuted to work around WebKit Bug 213853.
            //
            // Bug: https://bugs.webkit.org/show_bug.cgi?id=213853
            //
            localMediaRestartDeferreds.whenResolved('audio').then(function () {
                log.info("Playing unintentionally paused <" + tag + "> element");
                log.debug('Element:', el);
                return el.play();
            }).then(function () {
                log.info("Successfully played unintentionally paused <" + tag + "> element");
                log.debug('Element:', el);
            }).catch(function (error) {
                log.warn("Error while playing unintentionally paused <" + tag + "> element:", { error: error, el: el });
            });
        }
    });
}
/**
 * Shim the pause() and play() methods of the given HTMLMediaElement so that
 * we can detect if it was paused unintentionally.
 * @param {HTMLMediaElement} el
 * @param {?function} [onUnintentionallyPaused=null]
 * @returns {{pausedIntentionally: function, unShim: function}}
 */
function shimMediaElement(el, onUnintentionallyPaused) {
    if (onUnintentionallyPaused === void 0) { onUnintentionallyPaused = null; }
    var origPause = el.pause;
    var origPlay = el.play;
    var pausedIntentionally = false;
    el.pause = function () {
        pausedIntentionally = true;
        return origPause.call(el);
    };
    el.play = function () {
        pausedIntentionally = false;
        return origPlay.call(el);
    };
    var onPause = onUnintentionallyPaused ? function () {
        if (!pausedIntentionally) {
            onUnintentionallyPaused();
        }
    } : null;
    if (onPause) {
        el.addEventListener('pause', onPause);
    }
    return {
        pausedIntentionally: function () {
            return pausedIntentionally;
        },
        unShim: function () {
            el.pause = origPause;
            el.play = origPlay;
            if (onPause) {
                el.removeEventListener('pause', onPause);
            }
        }
    };
}
module.exports = MediaTrack;

},{"../../util":133,"../../util/browserdetection":124,"../../util/localmediarestartdeferreds":136,"../../webrtc":159,"./":20}],30:[function(require,module,exports){
'use strict';
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyNoiseCancellation = exports.NoiseCancellationImpl = void 0;
var noisecancellationadapter_1 = require("../../noisecancellationadapter");
var Log = require('../../util/log');
/**
 * {@link NoiseCancellation} interface provides methods to control noise cancellation at runtime. This interface is exposed
 * on {@link LocalAudioTrack} property `noiseCancellation`. It is available only when {@link NoiseCancellationOptions} are
 * specified when creating a {@link LocalAudioTrack}, and the plugin is successfully loaded.
 * @alias NoiseCancellation
 * @interface
 *
 * @example
 * const { connect, createLocalAudioTrack } = require('twilio-video');
 *
 * // Create a LocalAudioTrack with Krisp noise cancellation enabled.
 * const localAudioTrack = await createLocalAudioTrack({
 *   noiseCancellationOptions: {
 *     sdkAssetsPath: 'path/to/hosted/twilio/krisp/audio/plugin/1.0.0/dist',
 *     vendor: 'krisp'
 *   }
 * });
 *
 * if (!localAudioTrack.noiseCancellation) {
 *   // If the Krisp audio plugin fails to load, then a warning message will be logged
 *   // in the browser console, and the "noiseCancellation" property will be set to null.
 *   // You can still use the LocalAudioTrack to join a Room. However, it will use the
 *   // browser's noise suppression instead of the Krisp noise cancellation. Make sure
 *   // the "sdkAssetsPath" provided in "noiseCancellationOptions" points to the correct
 *   // hosted path of the plugin assets.
 * } else {
 *   // Join a Room with the LocalAudioTrack.
 *   const room = await connect('token', {
 *     name: 'my-cool-room',
 *     tracks: [localAudioTrack]
 *   });
 *
 *   if (!localAudioTrack.noiseCancellation.isEnabled) {
 *     // Krisp noise cancellation is permanently disabled in Peer-to-Peer and Go Rooms.
 *   }
 * }
 *
 * //
 * // Enable/disable noise cancellation.
 * // @param {boolean} enable - whether noise cancellation should be enabled
 * //
 * function setNoiseCancellation(enable) {
 *   const { noiseCancellation } = localAudioTrack;
 *   if (noiseCancellation) {
 *     if (enable) {
 *       // If enabled, then the LocalAudioTrack will use the Krisp noise
 *       // cancellation instead of the browser's noise suppression.
 *       noiseCancellation.enable();
 *     } else {
 *       // If disabled, then the LocalAudioTrack will use the browser's
 *       // noise suppression instead of the Krisp noise cancellation.
 *       noiseCancellation.disable();
 *     }
 *   }
 * }
 */
var NoiseCancellationImpl = /** @class */ (function () {
    function NoiseCancellationImpl(processor, originalTrack) {
        this._processor = processor;
        this._sourceTrack = originalTrack;
        this._disabledPermanent = false;
    }
    Object.defineProperty(NoiseCancellationImpl.prototype, "vendor", {
        /**
         * Name of the noise cancellation vendor.
         * @type {NoiseCancellationVendor}
         */
        get: function () {
            return this._processor.vendor;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(NoiseCancellationImpl.prototype, "sourceTrack", {
        /**
         * The underlying MediaStreamTrack of the {@link LocalAudioTrack}.
         * @type {MediaStreamTrack}
         */
        get: function () {
            return this._sourceTrack;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(NoiseCancellationImpl.prototype, "isEnabled", {
        /**
         * Whether noise cancellation is enabled.
         * @type {boolean}
         */
        get: function () {
            return this._processor.isEnabled();
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Enable noise cancellation.
     * @returns {Promise<void>} Promise that resolves when the operation is complete
     * @throws {Error} Throws an error if noise cancellation is disabled permanently
     *   for the {@link LocalAudioTrack}
     */
    NoiseCancellationImpl.prototype.enable = function () {
        if (this._disabledPermanent) {
            throw new Error(this.vendor + " noise cancellation is disabled permanently for this track");
        }
        this._processor.enable();
        return Promise.resolve();
    };
    /**
     * Disable noise cancellation.
     * @returns {Promise<void>} Promise that resolves when the operation is complete
     */
    NoiseCancellationImpl.prototype.disable = function () {
        this._processor.disable();
        return Promise.resolve();
    };
    /**
     * @private
     */
    NoiseCancellationImpl.prototype.reacquireTrack = function (reacquire) {
        return __awaiter(this, void 0, void 0, function () {
            var processorWasEnabled, track, processedTrack;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        processorWasEnabled = this._processor.isEnabled();
                        this._processor.disconnect();
                        return [4 /*yield*/, reacquire()];
                    case 1:
                        track = _a.sent();
                        this._sourceTrack = track;
                        return [4 /*yield*/, this._processor.connect(track)];
                    case 2:
                        processedTrack = _a.sent();
                        if (processorWasEnabled) {
                            this._processor.enable();
                        }
                        else {
                            this._processor.disable();
                        }
                        return [2 /*return*/, processedTrack];
                }
            });
        });
    };
    /**
     * @private
     */
    NoiseCancellationImpl.prototype.disablePermanently = function () {
        this._disabledPermanent = true;
        return this.disable();
    };
    /**
     * @private
     */
    NoiseCancellationImpl.prototype.stop = function () {
        this._processor.disconnect();
        this._sourceTrack.stop();
    };
    return NoiseCancellationImpl;
}());
exports.NoiseCancellationImpl = NoiseCancellationImpl;
function applyNoiseCancellation(mediaStreamTrack, noiseCancellationOptions, log) {
    return __awaiter(this, void 0, void 0, function () {
        var processor, cleanTrack, noiseCancellation, ex_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, , 3]);
                    return [4 /*yield*/, noisecancellationadapter_1.createNoiseCancellationAudioProcessor(noiseCancellationOptions, log)];
                case 1:
                    processor = _a.sent();
                    cleanTrack = processor.connect(mediaStreamTrack);
                    noiseCancellation = new NoiseCancellationImpl(processor, mediaStreamTrack);
                    return [2 /*return*/, { cleanTrack: cleanTrack, noiseCancellation: noiseCancellation }];
                case 2:
                    ex_1 = _a.sent();
                    // in case of failures to load noise cancellation library just return original media stream.
                    log.warn("Failed to create noise cancellation. Returning normal audio track: " + ex_1);
                    return [2 /*return*/, { cleanTrack: mediaStreamTrack }];
                case 3: return [2 /*return*/];
            }
        });
    });
}
exports.applyNoiseCancellation = applyNoiseCancellation;

},{"../../noisecancellationadapter":46,"../../util/log":137}],31:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var MediaTrackTransceiver = require('./transceiver');
/**
 * A {@link MediaTrackReceiver} represents a remote MediaStreamTrack.
 * @extends MediaTrackTransceiver
 */
var MediaTrackReceiver = /** @class */ (function (_super) {
    __extends(MediaTrackReceiver, _super);
    /**
     * Construct a {@link MediaTrackReceiver}.
     * @param {Track.ID} id - The MediaStreamTrack ID signaled through RSP/SDP
     * @param {MediaStreamTrack} mediaStreamTrack - The remote MediaStreamTrack
     */
    function MediaTrackReceiver(id, mediaStreamTrack) {
        return _super.call(this, id, mediaStreamTrack) || this;
    }
    return MediaTrackReceiver;
}(MediaTrackTransceiver));
module.exports = MediaTrackReceiver;

},{"./transceiver":42}],32:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var AudioTrack = require('./audiotrack');
var mixinRemoteMediaTrack = require('./remotemediatrack');
var RemoteMediaAudioTrack = mixinRemoteMediaTrack(AudioTrack);
/**
 * A {@link RemoteAudioTrack} represents an {@link AudioTrack} published to a
 * {@link Room} by a {@link RemoteParticipant}.
 * @extends AudioTrack
 * @property {boolean} isEnabled - Whether the {@link RemoteAudioTrack} is enabled
 * @property {boolean} isSwitchedOff - Whether the {@link RemoteAudioTrack} is switched off
 * @property {Track.SID} sid - The {@link RemoteAudioTrack}'s SID
 * @property {?Track.Priority} priority - The subscribe priority of the {@link RemoteAudioTrack}
 * @emits RemoteAudioTrack#disabled
 * @emits RemoteAudioTrack#enabled
 * @emits RemoteAudioTrack#started
 * @emits RemoteAudioTrack#switchedOff
 * @emits RemoteAudioTrack#switchedOn
 */
var RemoteAudioTrack = /** @class */ (function (_super) {
    __extends(RemoteAudioTrack, _super);
    /**
     * Construct a {@link RemoteAudioTrack}.
     * @param {Track.SID} sid - The {@link RemoteAudioTrack}'s SID
     * @param {MediaTrackReceiver} mediaTrackReceiver - An audio MediaStreamTrack container
     * @param {boolean} isEnabled - Whether the {@link RemoteAudioTrack} is enabled
     * @param {boolean} isSwitchedOff - Whether the {@link RemoteAudioTrack} is switched off
     * @param {function(?Track.Priority): void} setPriority - Set or clear the subscribe
     *  {@link Track.Priority} of the {@link RemoteAudioTrack}
     * @param {function(ClientRenderHint): void} setRenderHint - Set render hints.
     * @param {{log: Log}} options - The {@link RemoteTrack} options
     */
    function RemoteAudioTrack(sid, mediaTrackReceiver, isEnabled, isSwitchedOff, setPriority, setRenderHint, options) {
        return _super.call(this, sid, mediaTrackReceiver, isEnabled, isSwitchedOff, setPriority, setRenderHint, options) || this;
    }
    RemoteAudioTrack.prototype.toString = function () {
        return "[RemoteAudioTrack #" + this._instanceId + ": " + this.sid + "]";
    };
    /**
     * @private
     */
    RemoteAudioTrack.prototype._start = function () {
        _super.prototype._start.call(this);
        if (this._dummyEl) {
            // NOTE(mpatwardhan): To fix VIDEO-6336, clear dummy element after the
            // RemoteAudioTrack has started.
            this._dummyEl.srcObject = null;
            this._dummyEl = null;
        }
    };
    /**
     * Update the subscribe {@link Track.Priority} of the {@link RemoteAudioTrack}.
     * @param {?Track.Priority} priority - the new subscribe {@link Track.Priority};
     *   Currently setPriority has no effect on audio tracks.
     * @returns {this}
     * @throws {RangeError}
     */
    RemoteAudioTrack.prototype.setPriority = function (priority) {
        return _super.prototype.setPriority.call(this, priority);
    };
    return RemoteAudioTrack;
}(RemoteMediaAudioTrack));
/**
 * The {@link RemoteAudioTrack} was disabled, i.e. "muted".
 * @param {RemoteAudioTrack} track - The {@link RemoteAudioTrack} that was
 *   disabled
 * @event RemoteAudioTrack#disabled
 */
/**
 * The {@link RemoteAudioTrack} was enabled, i.e. "unmuted".
 * @param {RemoteAudioTrack} track - The {@link RemoteAudioTrack} that was
 *   enabled
 * @event RemoteAudioTrack#enabled
 */
/**
 * The {@link RemoteAudioTrack} started. This means there is enough audio data
 * to begin playback.
 * @param {RemoteAudioTrack} track - The {@link RemoteAudioTrack} that started
 * @event RemoteAudioTrack#started
 */
/**
 * A {@link RemoteAudioTrack} was switched off.
 * @param {RemoteAudioTrack} track - The {@link RemoteAudioTrack} that was
 *   switched off
 * @event RemoteAudioTrack#switchedOff
 */
/**
 * A {@link RemoteAudioTrack} was switched on.
 * @param {RemoteAudioTrack} track - The {@link RemoteAudioTrack} that was
 *   switched on
 * @event RemoteAudioTrack#switchedOn
 */
module.exports = RemoteAudioTrack;

},{"./audiotrack":14,"./remotemediatrack":36}],33:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var RemoteTrackPublication = require('./remotetrackpublication');
/**
 * A {@link RemoteAudioTrackPublication} represents a {@link RemoteAudioTrack}
 * that has been published to a {@link Room}.
 * @property {Track.Kind} kind - "audio"
 * @property {?RemoteAudioTrack} track - unless you have subscribed to the
 *   {@link RemoteAudioTrack}, this property is null
 * @emits RemoteAudioTrackPublication#subscribed
 * @emits RemoteAudioTrackPublication#subscriptionFailed
 * @emits RemoteAudioTrackPublication#trackDisabled
 * @emits RemoteAudioTrackPublication#trackEnabled
 * @emits RemoteAudioTrackPublication#unsubscribed
 */
var RemoteAudioTrackPublication = /** @class */ (function (_super) {
    __extends(RemoteAudioTrackPublication, _super);
    /**
     * Construct a {@link RemoteAudioTrackPublication}.
     * @param {RemoteTrackPublicationSignaling} signaling - {@link RemoteTrackPublication} signaling
     * @param {RemoteTrackPublicationOptions} options - {@link RemoteTrackPublication}
     *   options
     */
    function RemoteAudioTrackPublication(signaling, options) {
        return _super.call(this, signaling, options) || this;
    }
    RemoteAudioTrackPublication.prototype.toString = function () {
        return "[RemoteAudioTrackPublication #" + this._instanceId + ": " + this.trackSid + "]";
    };
    return RemoteAudioTrackPublication;
}(RemoteTrackPublication));
/**
 * Your {@link LocalParticipant} subscribed to the {@link RemoteAudioTrack}.
 * @param {RemoteAudioTrack} track - the {@link RemoteAudioTrack} that was subscribed to
 * @event RemoteAudioTrackPublication#subscribed
 */
/**
 * Your {@link LocalParticipant} failed to subscribe to the {@link RemoteAudioTrack}.
 * @param {TwilioError} error - the reason the {@link RemoteAudioTrack} could not be
 *   subscribed to
 * @event RemoteAudioTrackPublication#subscriptionFailed
 */
/**
 * The {@link RemoteAudioTrack} was disabled.
 * @event RemoteAudioTrackPublication#trackDisabled
 */
/**
 * The {@link RemoteAudioTrack} was enabled.
 * @event RemoteAudioTrackPublication#trackEnabled
 */
/**
 * Your {@link LocalParticipant} unsubscribed from the {@link RemoteAudioTrack}.
 * @param {RemoteAudioTrack} track - the {@link RemoteAudioTrack} that was unsubscribed from
 * @event RemoteAudioTrackPublication#unsubscribed
 */
module.exports = RemoteAudioTrackPublication;

},{"./remotetrackpublication":37}],34:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var Track = require('./');
var _a = require('../../util/constants'), E = _a.typeErrors, trackPriority = _a.trackPriority;
/**
 * A {@link RemoteDataTrack} represents data published to a {@link Room} by a
 * {@link RemoteParticipant}.
 * @extends Track
 * @property {boolean} isEnabled - true
 * @property {boolean} isSubscribed - Whether the {@link RemoteDataTrack} is
 *   subscribed to
 * @property {boolean} isSwitchedOff - Whether the {@link RemoteDataTrack} is
 *   switched off
 * @property {Track.Kind} kind - "data"
 * @property {?number} maxPacketLifeTime - If non-null, this represents a time
 *   limit (in milliseconds) during which data will be transmitted or
 *   retransmitted if not acknowledged on the underlying RTCDataChannel.
 * @property {?number} maxRetransmits - If non-null, this represents the number
 *   of times the data will be retransmitted if not successfully received on the
 *   underlying RTCDataChannel.
 * @property {boolean} ordered - true if data on the {@link RemoteDataTrack} can
 *   be received out-of-order.
 * @property {?Track.Priority} priority - The subscribe priority of the {@link RemoteDataTrack}
 * @property {boolean} reliable - This is true if both
 *   <code>maxPacketLifeTime</code> and <code>maxRetransmits</code> are set to
 *   null. In other words, if this is true, there is no bound on packet lifetime
 *   or the number of retransmits that will be attempted, ensuring "reliable"
 *   transmission.
 * @property {Track.SID} sid - The SID assigned to the {@link RemoteDataTrack}
 * @emits RemoteDataTrack#message
 * @emits RemoteDataTrack#switchedOff
 * @emits RemoteDataTrack#switchedOn
 */
var RemoteDataTrack = /** @class */ (function (_super) {
    __extends(RemoteDataTrack, _super);
    /**
     * Construct a {@link RemoteDataTrack} from a {@link DataTrackReceiver}.
     * @param {Track.SID} sid
     * @param {DataTrackReceiver} dataTrackReceiver
     * @param {{log: Log, name: ?string}} options
     */
    function RemoteDataTrack(sid, dataTrackReceiver, options) {
        var _this = _super.call(this, dataTrackReceiver.id, 'data', options) || this;
        Object.defineProperties(_this, {
            _isSwitchedOff: {
                value: false,
                writable: true
            },
            _priority: {
                value: null,
                writable: true
            },
            isEnabled: {
                enumerable: true,
                value: true
            },
            isSwitchedOff: {
                enumerable: true,
                get: function () {
                    return this._isSwitchedOff;
                }
            },
            maxPacketLifeTime: {
                enumerable: true,
                value: dataTrackReceiver.maxPacketLifeTime
            },
            maxRetransmits: {
                enumerable: true,
                value: dataTrackReceiver.maxRetransmits
            },
            ordered: {
                enumerable: true,
                value: dataTrackReceiver.ordered
            },
            priority: {
                enumerable: true,
                get: function () {
                    return this._priority;
                }
            },
            reliable: {
                enumerable: true,
                value: dataTrackReceiver.maxPacketLifeTime === null
                    && dataTrackReceiver.maxRetransmits === null
            },
            sid: {
                enumerable: true,
                value: sid
            }
        });
        dataTrackReceiver.on('message', function (data) {
            _this.emit('message', data, _this);
        });
        return _this;
    }
    /**
     * Update the subscriber {@link Track.Priority} of the {@link RemoteDataTrack}.
     * @param {?Track.Priority} priority - the new {@link Track.priority};
     *   Currently setPriority has no effect on data tracks.
     * @returns {this}
     * @throws {RangeError}
     */
    RemoteDataTrack.prototype.setPriority = function (priority) {
        var priorityValues = __spreadArray([null], __read(Object.values(trackPriority)));
        if (!priorityValues.includes(priority)) {
            // eslint-disable-next-line new-cap
            throw E.INVALID_VALUE('priority', priorityValues);
        }
        // Note: priority has no real effect on the data tracks.
        this._priority = priority;
        return this;
    };
    /**
     * @private
     */
    RemoteDataTrack.prototype._setEnabled = function () {
        // Do nothing.
    };
    /**
     * @private
     * @param {boolean} isSwitchedOff
     */
    RemoteDataTrack.prototype._setSwitchedOff = function (isSwitchedOff) {
        if (this._isSwitchedOff !== isSwitchedOff) {
            this._isSwitchedOff = isSwitchedOff;
            this.emit(isSwitchedOff ? 'switchedOff' : 'switchedOn', this);
        }
    };
    return RemoteDataTrack;
}(Track));
/**
 * A message was received over the {@link RemoteDataTrack}.
 * @event RemoteDataTrack#message
 * @param {string|ArrayBuffer} data
 * @param {RemoteDataTrack} track - The {@link RemoteDataTrack} that received
 *   the message
 */
/**
 * A {@link RemoteDataTrack} was switched off.
 * @param {RemoteDataTrack} track - The {@link RemoteDataTrack} that was
 *   switched off
 * @event RemoteDataTrack#switchedOff
 */
/**
 * A {@link RemoteDataTrack} was switched on.
 * @param {RemoteDataTrack} track - The {@link RemoteDataTrack} that was
 *   switched on
 * @event RemoteDataTrack#switchedOn
 */
module.exports = RemoteDataTrack;

},{"../../util/constants":126,"./":20}],35:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var RemoteTrackPublication = require('./remotetrackpublication');
/**
 * A {@link RemoteDataTrackPublication} represents a {@link RemoteDataTrack}
 * that has been published to a {@link Room}.
 * @property {Track.Kind} kind - "data"
 * @property {?RemoteDataTrack} track - unless you have subscribed to the
 *   {@link RemoteDataTrack}, this property is null
 * @emits RemoteDataTrackPublication#subscribed
 * @emits RemoteDataTrackPublication#subscriptionFailed
 * @emits RemoteDataTrackPublication#unsubscribed
 */
var RemoteDataTrackPublication = /** @class */ (function (_super) {
    __extends(RemoteDataTrackPublication, _super);
    /**
     * Construct a {@link RemoteDataTrackPublication}.
     * @param {RemoteTrackPublicationSignaling} signaling - {@link RemoteTrackPublication} signaling
     * @param {RemoteTrackPublicationOptions} options - {@link RemoteTrackPublication}
     *   options
     */
    function RemoteDataTrackPublication(signaling, options) {
        return _super.call(this, signaling, options) || this;
    }
    RemoteDataTrackPublication.prototype.toString = function () {
        return "[RemoteDataTrackPublication #" + this._instanceId + ": " + this.trackSid + "]";
    };
    return RemoteDataTrackPublication;
}(RemoteTrackPublication));
/**
 * Your {@link LocalParticipant} subscribed to the {@link RemoteDataTrack}.
 * @param {RemoteDataTrack} track - the {@link RemoteDataTrack} that was subscribed to
 * @event RemoteDataTrackPublication#subscribed
 */
/**
 * Your {@link LocalParticipant} failed to subscribe to the {@link RemoteDataTrack}.
 * @param {TwilioError} error - the reason the {@link RemoteDataTrack} could not be
 *   subscribed to
 * @event RemoteDataTrackPublication#subscriptionFailed
 */
/**
 * Your {@link LocalParticipant} unsubscribed from the {@link RemoteDataTrack}.
 * @param {RemoteDataTrack} track - the {@link RemoteDataTrack} that was unsubscribed from
 * @event RemoteDataTrackPublication#unsubscribed
 */
module.exports = RemoteDataTrackPublication;

},{"./remotetrackpublication":37}],36:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var _a = require('../../util/constants'), E = _a.typeErrors, trackPriority = _a.trackPriority;
var isIOS = require('../../util/browserdetection').isIOS;
var documentVisibilityMonitor = require('../../util/documentvisibilitymonitor.js');
function mixinRemoteMediaTrack(AudioOrVideoTrack) {
    /**
     * A {@link RemoteMediaTrack} represents a {@link MediaTrack} published to a
     * {@link Room} by a {@link RemoteParticipant}.
     * @property {boolean} isEnabled - Whether the {@link RemoteMediaTrack} is enabled
     * @property {boolean} isSwitchedOff - Whether the {@link RemoteMediaTrack} is switched off
     * @property {Track.SID} sid - The SID assigned to the {@link RemoteMediaTrack}
     * @property {?Track.Priority} priority - The subscribe priority of the {@link RemoteMediaTrack}
     * @emits RemoteMediaTrack#disabled
     * @emits RemoteMediaTrack#enabled
     * @emits RemoteMediaTrack#switchedOff
     * @emits RemoteMediaTrack#switchedOn
     */
    return /** @class */ (function (_super) {
        __extends(RemoteMediaTrack, _super);
        /**
         * Construct a {@link RemoteMediaTrack}.
         * @param {Track.SID} sid
         * @param {MediaTrackReceiver} mediaTrackReceiver
         * @param {boolean} isEnabled
          @param {boolean} isSwitchedOff
         * @param {function(?Track.Priority): void} setPriority - Set or clear the subscribe
         *  {@link Track.Priority} of the {@link RemoteMediaTrack}
         * @param {function(ClientRenderHint): void} setRenderHint - Set render hints.
         * @param {{log: Log, name: ?string}} options
         */
        function RemoteMediaTrack(sid, mediaTrackReceiver, isEnabled, isSwitchedOff, setPriority, setRenderHint, options) {
            var _this = this;
            options = Object.assign({
                // NOTE(mpatwardhan): WebKit bug: 212780 sometimes causes the audio/video elements to stay paused when safari
                // regains foreground. To workaround it, when safari gains foreground - we will play any elements that were
                // playing before safari lost foreground.
                workaroundWebKitBug212780: isIOS()
                    && typeof document === 'object'
                    && typeof document.addEventListener === 'function'
                    && typeof document.visibilityState === 'string'
            }, options);
            _this = _super.call(this, mediaTrackReceiver, options) || this;
            Object.defineProperties(_this, {
                _isEnabled: {
                    value: isEnabled,
                    writable: true
                },
                _isSwitchedOff: {
                    value: isSwitchedOff,
                    writable: true
                },
                _priority: {
                    value: null,
                    writable: true
                },
                _setPriority: {
                    value: setPriority
                },
                _setRenderHint: {
                    value: function (renderHint) {
                        _this._log.debug('updating render hint:', renderHint);
                        setRenderHint(renderHint);
                    }
                },
                isEnabled: {
                    enumerable: true,
                    get: function () {
                        return this._isEnabled;
                    }
                },
                isSwitchedOff: {
                    enumerable: true,
                    get: function () {
                        return this._isSwitchedOff;
                    }
                },
                priority: {
                    enumerable: true,
                    get: function () {
                        return this._priority;
                    }
                },
                sid: {
                    enumerable: true,
                    value: sid
                },
                _workaroundWebKitBug212780: {
                    value: options.workaroundWebKitBug212780
                },
                _workaroundWebKitBug212780Cleanup: {
                    value: null,
                    writable: true
                }
            });
            return _this;
        }
        /**
         * Update the subscribe {@link Track.Priority} of the {@link RemoteMediaTrack}.
         * @param {?Track.Priority} priority - the new subscribe {@link Track.Priority};
         *   If <code>null</code>, then the subscribe {@link Track.Priority} is cleared, which
         *   means the {@link Track.Priority} set by the publisher is now the effective priority.
         * @returns {this}
         * @throws {RangeError}
         */
        RemoteMediaTrack.prototype.setPriority = function (priority) {
            var priorityValues = __spreadArray([null], __read(Object.values(trackPriority)));
            if (!priorityValues.includes(priority)) {
                // eslint-disable-next-line new-cap
                throw E.INVALID_VALUE('priority', priorityValues);
            }
            if (this._priority !== priority) {
                this._priority = priority;
                this._setPriority(priority);
            }
            return this;
        };
        /**
         * @private
         * @param {boolean} isEnabled
         */
        RemoteMediaTrack.prototype._setEnabled = function (isEnabled) {
            if (this._isEnabled !== isEnabled) {
                this._isEnabled = isEnabled;
                this.emit(this._isEnabled ? 'enabled' : 'disabled', this);
            }
        };
        /**
         * @private
         * @param {boolean} isSwitchedOff
         */
        RemoteMediaTrack.prototype._setSwitchedOff = function (isSwitchedOff) {
            if (this._isSwitchedOff !== isSwitchedOff) {
                this._isSwitchedOff = isSwitchedOff;
                this.emit(isSwitchedOff ? 'switchedOff' : 'switchedOn', this);
            }
        };
        RemoteMediaTrack.prototype.attach = function (el) {
            var result = _super.prototype.attach.call(this, el);
            if (this.mediaStreamTrack.enabled !== true) {
                // NOTE(mpatwardhan): we disable mediaStreamTrack when there
                // are no attachments to it (see notes below). Now that there
                // are attachments re-enable the track.
                this.mediaStreamTrack.enabled = true;
                if (this.processedTrack) {
                    this.processedTrack.enabled = true;
                }
                // NOTE(csantos): since remote tracks disables/enables the mediaStreamTrack,
                // captureFrames stops along with it. We need to start it again after re-enabling.
                // See attach/detach methods in this class and in VideoTrack class.
                if (this.processor) {
                    this._captureFrames();
                }
            }
            if (this._workaroundWebKitBug212780) {
                this._workaroundWebKitBug212780Cleanup = this._workaroundWebKitBug212780Cleanup
                    || playIfPausedWhileInBackground(this);
            }
            return result;
        };
        RemoteMediaTrack.prototype.detach = function (el) {
            var result = _super.prototype.detach.call(this, el);
            if (this._attachments.size === 0) {
                // NOTE(mpatwardhan): chrome continues playing webrtc audio
                // track even after audio element is removed from the DOM.
                // https://bugs.chromium.org/p/chromium/issues/detail?id=749928
                // to workaround: here disable the track when
                // there are no elements attached to it.
                this.mediaStreamTrack.enabled = false;
                if (this.processedTrack) {
                    this.processedTrack.enabled = false;
                }
                if (this._workaroundWebKitBug212780Cleanup) {
                    // unhook visibility change
                    this._workaroundWebKitBug212780Cleanup();
                    this._workaroundWebKitBug212780Cleanup = null;
                }
            }
            return result;
        };
        return RemoteMediaTrack;
    }(AudioOrVideoTrack));
}
function playIfPausedWhileInBackground(remoteMediaTrack) {
    var log = remoteMediaTrack._log, kind = remoteMediaTrack.kind;
    function onVisibilityChanged(isVisible) {
        if (!isVisible) {
            return;
        }
        remoteMediaTrack._attachments.forEach(function (el) {
            var shim = remoteMediaTrack._elShims.get(el);
            var isInadvertentlyPaused = el.paused && shim && !shim.pausedIntentionally();
            if (isInadvertentlyPaused) {
                log.info("Playing inadvertently paused <" + kind + "> element");
                log.debug('Element:', el);
                log.debug('RemoteMediaTrack:', remoteMediaTrack);
                el.play().then(function () {
                    log.info("Successfully played inadvertently paused <" + kind + "> element");
                    log.debug('Element:', el);
                    log.debug('RemoteMediaTrack:', remoteMediaTrack);
                }).catch(function (err) {
                    log.warn("Error while playing inadvertently paused <" + kind + "> element:", { err: err, el: el, remoteMediaTrack: remoteMediaTrack });
                });
            }
        });
    }
    // NOTE(mpatwardhan): listen for document visibility callback on phase 2.
    // this ensures that any LocalMediaTrack's restart (which listen on phase 1) gets executed
    // first. This order is important because we `play` tracks in the callback, and
    // play can fail on safari if audio is not being captured.
    documentVisibilityMonitor.onVisibilityChange(2, onVisibilityChanged);
    return function () {
        documentVisibilityMonitor.offVisibilityChange(2, onVisibilityChanged);
    };
}
/**
 * A {@link RemoteMediaTrack} was disabled.
 * @param {RemoteMediaTrack} track - The {@link RemoteMediaTrack} that was
 *   disabled
 * @event RemoteMediaTrack#disabled
 */
/**
 * A {@link RemoteMediaTrack} was enabled.
 * @param {RemoteMediaTrack} track - The {@link RemoteMediaTrack} that was
 *   enabled
 * @event RemoteMediaTrack#enabled
 */
/**
 * A {@link RemoteMediaTrack} was switched off.
 * @param {RemoteMediaTrack} track - The {@link RemoteMediaTrack} that was
 *   switched off
 * @event RemoteMediaTrack#switchedOff
 */
/**
 * A {@link RemoteMediaTrack} was switched on.
 * @param {RemoteMediaTrack} track - The {@link RemoteMediaTrack} that was
 *   switched on
 * @event RemoteMediaTrack#switchedOn
 */
/**
 * A {@link ClientRenderHint} object specifies track dimensions and /enabled disable state.
 * This state will be used by the server(SFU) to determine bandwidth allocation for the track,
 * and turn it on or off as needed.
 * @typedef {object} ClientRenderHint
 * @property {boolean} [enabled] - track is enabled or disabled. defaults to disabled.
 * @property {VideoTrack.Dimensions} [renderDimensions] - Optional parameter to specify the desired
 *   render dimensions of {@link RemoteVideoTrack}s. This property must be specified if enabled=true
 */
module.exports = mixinRemoteMediaTrack;

},{"../../util/browserdetection":124,"../../util/constants":126,"../../util/documentvisibilitymonitor.js":129}],37:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var TrackPublication = require('./trackpublication');
/**
 * A {@link RemoteTrackPublication} represents a {@link RemoteTrack} that has
 * been published to a {@link Room}.
 * @extends TrackPublication
 * @property {boolean} isSubscribed - whether the published {@link RemoteTrack}
 *   is subscribed to
 * @property {boolean} isTrackEnabled - whether the published
 *   {@link RemoteTrack} is enabled
 * @property {Track.Kind} kind - kind of the published {@link RemoteTrack}
 * @property {Track.Priority} publishPriority - the {@link Track.Priority} of the published
 *   {@link RemoteTrack} set by the {@link RemoteParticipant}
 * @property {?RemoteTrack} track - Unless you have subscribed to the
 *   {@link RemoteTrack}, this property is null
 * @emits RemoteTrackPublication#publishPriorityChanged
 * @emits RemoteTrackPublication#subscribed
 * @emits RemoteTrackPublication#subscriptionFailed
 * @emits RemoteTrackPublication#trackDisabled
 * @emits RemoteTrackPublication#trackEnabled
 * @emits RemoteTrackPublication#trackSwitchedOff
 * @emits RemoteTrackPublication#trackSwitchedOn
 * @emits RemoteTrackPublication#unsubscribed
 *
 */
var RemoteTrackPublication = /** @class */ (function (_super) {
    __extends(RemoteTrackPublication, _super);
    /**
     * Construct a {@link RemoteTrackPublication}.
     * @param {RemoteTrackPublicationSignaling} signaling - {@link RemoteTrackPublication} signaling
     * @param {RemoteTrackPublicationOptions} options - {@link RemoteTrackPublication}
     *   options
     */
    function RemoteTrackPublication(signaling, options) {
        var _this = _super.call(this, signaling.name, signaling.sid, options) || this;
        Object.defineProperties(_this, {
            _signaling: {
                value: signaling
            },
            _track: {
                value: null,
                writable: true
            },
            isSubscribed: {
                enumerable: true,
                get: function () {
                    return !!this._track;
                }
            },
            isTrackEnabled: {
                enumerable: true,
                get: function () {
                    return signaling.isEnabled;
                }
            },
            kind: {
                enumerable: true,
                value: signaling.kind
            },
            publishPriority: {
                enumerable: true,
                get: function () {
                    return signaling.priority;
                }
            },
            track: {
                enumerable: true,
                get: function () {
                    return this._track;
                }
            }
        });
        // remember original state, and fire events only on change.
        var error = signaling.error, isEnabled = signaling.isEnabled, isSwitchedOff = signaling.isSwitchedOff, priority = signaling.priority;
        signaling.on('updated', function () {
            if (error !== signaling.error) {
                error = signaling.error;
                _this.emit('subscriptionFailed', signaling.error);
                return;
            }
            if (isEnabled !== signaling.isEnabled) {
                isEnabled = signaling.isEnabled;
                if (_this.track) {
                    _this.track._setEnabled(signaling.isEnabled);
                }
                _this.emit(signaling.isEnabled ? 'trackEnabled' : 'trackDisabled');
            }
            if (isSwitchedOff !== signaling.isSwitchedOff) {
                _this._log.debug(_this.trackSid + ": " + (isSwitchedOff ? 'OFF' : 'ON') + " => " + (signaling.isSwitchedOff ? 'OFF' : 'ON'));
                isSwitchedOff = signaling.isSwitchedOff;
                if (_this.track) {
                    _this.track._setSwitchedOff(signaling.isSwitchedOff);
                    _this.emit(isSwitchedOff ? 'trackSwitchedOff' : 'trackSwitchedOn', _this.track);
                }
                else if (isSwitchedOff) {
                    _this._log.warn('Track was not subscribed when switched Off.');
                }
            }
            if (priority !== signaling.priority) {
                priority = signaling.priority;
                _this.emit('publishPriorityChanged', priority);
            }
        });
        return _this;
    }
    RemoteTrackPublication.prototype.toString = function () {
        return "[RemoteTrackPublication #" + this._instanceId + ": " + this.trackSid + "]";
    };
    /**
     * @private
     * @param {RemoteTrack} track
     */
    RemoteTrackPublication.prototype._subscribed = function (track) {
        if (!this._track && track) {
            this._track = track;
            this.emit('subscribed', track);
        }
    };
    /**
     * @private
     */
    RemoteTrackPublication.prototype._unsubscribe = function () {
        if (this._track) {
            var track = this._track;
            this._track = null;
            this.emit('unsubscribed', track);
        }
    };
    return RemoteTrackPublication;
}(TrackPublication));
/**
 * The {@link RemoteTrack}'s publish {@link Track.Priority} was changed by the
 * {@link RemoteParticipant}.
 * @param {Track.Priority} priority - the {@link RemoteTrack}'s new publish
 *   {@link Track.Priority}; RemoteTrackPublication#publishPriority is also
 *   updated accordingly
 * @event RemoteTrackPublication#publishPriorityChanged
 */
/**
 * Your {@link LocalParticipant} subscribed to the {@link RemoteTrack}.
 * @param {RemoteTrack} track - the {@link RemoteTrack} that was subscribed to
 * @event RemoteTrackPublication#subscribed
 */
/**
 * Your {@link LocalParticipant} failed to subscribe to the {@link RemoteTrack}.
 * @param {TwilioError} error - the reason the {@link RemoteTrack} could not be
 *   subscribed to
 * @event RemoteTrackPublication#subscriptionFailed
 */
/**
 * The {@link RemoteTrack} was disabled.
 * @event RemoteTrackPublication#trackDisabled
 */
/**
 * The {@link RemoteTrack} was enabled.
 * @event RemoteTrackPublication#trackEnabled
 */
/**
 * The {@link RemoteTrack} was switched off.
 * @param {RemoteTrack} track - the {@link RemoteTrack} that was switched off
 * @event RemoteTrackPublication#trackSwitchedOff
 */
/**
 * The {@link RemoteTrack} was switched on.
 * @param {RemoteTrack} track - the {@link RemoteTrack} that was switched on
 * @event RemoteTrackPublication#trackSwitchedOn
 */
/**
 * Your {@link LocalParticipant} unsubscribed from the {@link RemoteTrack}.
 * @param {RemoteTrack} track - the {@link RemoteTrack} that was unsubscribed from
 * @event RemoteTrackPublication#unsubscribed
 */
/**
 * {@link RemoteTrackPublication} options
 * @typedef {object} RemoteTrackPublicationOptions
 * @property {LogLevel|LogLevels} logLevel - Log level for 'media' modules
 */
module.exports = RemoteTrackPublication;

},{"./trackpublication":41}],38:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var mixinRemoteMediaTrack = require('./remotemediatrack');
var VideoTrack = require('./videotrack');
var documentVisibilityMonitor = require('../../util/documentvisibilitymonitor.js');
var NullObserver = require('../../util/nullobserver.js').NullObserver;
var Timeout = require('../../util/timeout');
var RemoteMediaVideoTrack = mixinRemoteMediaTrack(VideoTrack);
var TRACK_TURN_OF_DELAY_MS = 50;
/**
 * A {@link RemoteVideoTrack} represents a {@link VideoTrack} published to a
 * {@link Room} by a {@link RemoteParticipant}.
 * @extends VideoTrack
 * @property {boolean} isEnabled - Whether the {@link RemoteVideoTrack} is enabled
 * @property {boolean} isSwitchedOff - Whether the {@link RemoteVideoTrack} is switched off
 * @property {Track.SID} sid - The {@link RemoteVideoTrack}'s SID
 * @property {?Track.Priority} priority - The subscribe priority of the {@link RemoteVideoTrack}
 * @emits RemoteVideoTrack#dimensionsChanged
 * @emits RemoteVideoTrack#disabled
 * @emits RemoteVideoTrack#enabled
 * @emits RemoteVideoTrack#started
 * @emits RemoteVideoTrack#switchedOff
 * @emits RemoteVideoTrack#switchedOn
 */
var RemoteVideoTrack = /** @class */ (function (_super) {
    __extends(RemoteVideoTrack, _super);
    /**
     * Construct a {@link RemoteVideoTrack}.
     * @param {Track.SID} sid - The {@link RemoteVideoTrack}'s SID
     * @param {MediaTrackReceiver} mediaTrackReceiver - A video MediaStreamTrack container
     * @param {boolean} isEnabled - whether the {@link RemoteVideoTrack} is enabled
     * @param {boolean} isSwitchedOff - Whether the {@link RemoteVideoTrack} is switched off
     * @param {function(?Track.Priority): void} setPriority - Set or clear the subscribe
     *  {@link Track.Priority} of the {@link RemoteVideoTrack}
     * @param {function(ClientRenderHint): void} setRenderHint - Set render hints.
     * @param {{log: Log}} options - The {@link RemoteTrack} options
     */
    function RemoteVideoTrack(sid, mediaTrackReceiver, isEnabled, isSwitchedOff, setPriority, setRenderHint, options) {
        var _this = this;
        options = Object.assign({
            clientTrackSwitchOffControl: 'auto',
            contentPreferencesMode: 'auto',
            enableDocumentVisibilityTurnOff: true,
        }, options);
        options = Object.assign({
            IntersectionObserver: typeof IntersectionObserver === 'undefined' || options.clientTrackSwitchOffControl !== 'auto' ? NullObserver : IntersectionObserver,
            ResizeObserver: typeof ResizeObserver === 'undefined' || options.contentPreferencesMode !== 'auto' ? NullObserver : ResizeObserver,
        }, options);
        _this = _super.call(this, sid, mediaTrackReceiver, isEnabled, isSwitchedOff, setPriority, setRenderHint, options) || this;
        Object.defineProperties(_this, {
            _enableDocumentVisibilityTurnOff: {
                value: options.enableDocumentVisibilityTurnOff === true && options.clientTrackSwitchOffControl === 'auto',
            },
            _documentVisibilityTurnOffCleanup: {
                value: null,
                writable: true
            },
            _clientTrackSwitchOffControl: {
                value: options.clientTrackSwitchOffControl,
            },
            _contentPreferencesMode: {
                value: options.contentPreferencesMode,
            },
            _invisibleElements: {
                value: new WeakSet(),
            },
            _elToPipCallbacks: {
                value: new WeakMap(),
            },
            _elToPipWindows: {
                value: new WeakMap(),
            },
            _turnOffTimer: {
                value: new Timeout(function () {
                    _this._setRenderHint({ enabled: false });
                }, TRACK_TURN_OF_DELAY_MS, false),
            },
            _resizeObserver: {
                value: new options.ResizeObserver(function (entries) {
                    // NOTE(mpatwardhan): we ignore elements in _invisibleElements
                    // to ensure that ResizeObserver does not end-up turning off a track when a fresh Video element is
                    // attached and IntersectionObserver has not had its callback executed yet.
                    var visibleElementResized = entries.find(function (entry) { return !_this._invisibleElements.has(entry.target); });
                    if (visibleElementResized) {
                        maybeUpdateDimensionHint(_this);
                    }
                })
            },
            _intersectionObserver: {
                value: new options.IntersectionObserver(function (entries) {
                    var shouldSetRenderHint = false;
                    entries.forEach(function (entry) {
                        var wasVisible = !_this._invisibleElements.has(entry.target);
                        if (wasVisible !== entry.isIntersecting) {
                            if (entry.isIntersecting) {
                                _this._log.debug('intersectionObserver detected: Off => On');
                                _this._invisibleElements.delete(entry.target);
                            }
                            else {
                                _this._log.debug('intersectionObserver detected: On => Off');
                                _this._invisibleElements.add(entry.target);
                            }
                            shouldSetRenderHint = true;
                        }
                    });
                    if (shouldSetRenderHint) {
                        maybeUpdateEnabledHint(_this);
                        // when visibility of an element changes that may cause the "biggest" element to change,
                        // update dimensions as well. since dimensions are cached and de-duped at signaling layer,
                        // its okay if they got  resent.
                        maybeUpdateDimensionHint(_this);
                    }
                }, { threshold: 0.25 })
            },
        });
        return _this;
    }
    /**
     * @private
     */
    RemoteVideoTrack.prototype._start = function (dummyEl) {
        var result = _super.prototype._start.call(this, dummyEl);
        // NOTE(mpatwardhan): after emitting started, update turn off track if not visible.
        maybeUpdateEnabledHint(this);
        return result;
    };
    /**
     * Request to switch on a {@link RemoteVideoTrack}, This method is applicable only for the group rooms and only when connected with
     * clientTrackSwitchOffControl in video bandwidth profile options set to 'manual'
     * @returns {this}
     */
    RemoteVideoTrack.prototype.switchOn = function () {
        if (this._clientTrackSwitchOffControl !== 'manual') {
            throw new Error('Invalid state. You can call switchOn only when bandwidthProfile.video.clientTrackSwitchOffControl is set to "manual"');
        }
        this._setRenderHint({ enabled: true });
        return this;
    };
    /**
     * Request to switch off a {@link RemoteVideoTrack}, This method is applicable only for the group rooms and only when connected with
     * clientTrackSwitchOffControl in video bandwidth profile options set to 'manual'
     * @returns {this}
     */
    RemoteVideoTrack.prototype.switchOff = function () {
        if (this._clientTrackSwitchOffControl !== 'manual') {
            throw new Error('Invalid state. You can call switchOff only when bandwidthProfile.video.clientTrackSwitchOffControl is set to "manual"');
        }
        this._setRenderHint({ enabled: false });
        return this;
    };
    /**
     * Set the {@link RemoteVideoTrack}'s content preferences. This method is applicable only for the group rooms and only when connected with
     * videoContentPreferencesMode in video bandwidth profile options set to 'manual'
     * @param {VideoContentPreferences} contentPreferences - requested preferences.
     * @returns {this}
     */
    RemoteVideoTrack.prototype.setContentPreferences = function (contentPreferences) {
        if (this._contentPreferencesMode !== 'manual') {
            throw new Error('Invalid state. You can call switchOn only when bandwidthProfile.video.contentPreferencesMode is set to "manual"');
        }
        if (contentPreferences.renderDimensions) {
            this._setRenderHint({ renderDimensions: contentPreferences.renderDimensions });
        }
        return this;
    };
    RemoteVideoTrack.prototype._unObservePip = function (el) {
        var pipCallbacks = this._elToPipCallbacks.get(el);
        if (pipCallbacks) {
            el.removeEventListener('enterpictureinpicture', pipCallbacks.onEnterPip);
            el.removeEventListener('leavepictureinpicture', pipCallbacks.onLeavePip);
            this._elToPipCallbacks.delete(el);
        }
    };
    RemoteVideoTrack.prototype._observePip = function (el) {
        var _this = this;
        var pipCallbacks = this._elToPipCallbacks.get(el);
        if (!pipCallbacks) {
            var onEnterPip = function (event) { return _this._onEnterPip(event, el); };
            var onLeavePip = function (event) { return _this._onLeavePip(event, el); };
            var onResizePip = function (event) { return _this._onResizePip(event, el); };
            el.addEventListener('enterpictureinpicture', onEnterPip);
            el.addEventListener('leavepictureinpicture', onLeavePip);
            this._elToPipCallbacks.set(el, { onEnterPip: onEnterPip, onLeavePip: onLeavePip, onResizePip: onResizePip });
        }
    };
    RemoteVideoTrack.prototype._onEnterPip = function (event, videoEl) {
        this._log.debug('onEnterPip');
        var pipWindow = event.pictureInPictureWindow;
        this._elToPipWindows.set(videoEl, pipWindow);
        var onResizePip = this._elToPipCallbacks.get(videoEl).onResizePip;
        pipWindow.addEventListener('resize', onResizePip);
        maybeUpdateEnabledHint(this);
    };
    RemoteVideoTrack.prototype._onLeavePip = function (event, videoEl) {
        this._log.debug('onLeavePip');
        this._elToPipWindows.delete(videoEl);
        var onResizePip = this._elToPipCallbacks.get(videoEl).onResizePip;
        var pipWindow = event.pictureInPictureWindow;
        pipWindow.removeEventListener('resize', onResizePip);
        maybeUpdateEnabledHint(this);
    };
    RemoteVideoTrack.prototype._onResizePip = function () {
        maybeUpdateDimensionHint(this);
    };
    RemoteVideoTrack.prototype.attach = function (el) {
        var result = _super.prototype.attach.call(this, el);
        if (this._clientTrackSwitchOffControl === 'auto') {
            // start off the element as invisible. will mark it
            // visible (and update render hints) once intersection observer calls back.
            this._invisibleElements.add(result);
        }
        this._intersectionObserver.observe(result);
        this._resizeObserver.observe(result);
        if (this._enableDocumentVisibilityTurnOff) {
            this._documentVisibilityTurnOffCleanup = this._documentVisibilityTurnOffCleanup || setupDocumentVisibilityTurnOff(this);
        }
        this._observePip(result);
        return result;
    };
    RemoteVideoTrack.prototype.detach = function (el) {
        var _this = this;
        var result = _super.prototype.detach.call(this, el);
        var elements = Array.isArray(result) ? result : [result];
        elements.forEach(function (element) {
            _this._intersectionObserver.unobserve(element);
            _this._resizeObserver.unobserve(element);
            _this._invisibleElements.delete(element);
            _this._unObservePip(element);
        });
        if (this._attachments.size === 0) {
            if (this._documentVisibilityTurnOffCleanup) {
                this._documentVisibilityTurnOffCleanup();
                this._documentVisibilityTurnOffCleanup = null;
            }
        }
        maybeUpdateEnabledHint(this);
        maybeUpdateDimensionHint(this);
        return result;
    };
    /**
     * Add a {@link VideoProcessor} to allow for custom processing of video frames belonging to a VideoTrack.
     * When a Participant un-publishes and re-publishes a VideoTrack, a new RemoteVideoTrack is created and
     * any VideoProcessors attached to the previous RemoteVideoTrack would have to be re-added again.
     * @param {VideoProcessor} processor - The {@link VideoProcessor} to use.
     * @param {AddProcessorOptions} [options] - {@link AddProcessorOptions} to provide.
     * @returns {this}
     * @example
     * class GrayScaleProcessor {
     *   constructor(percentage) {
     *     this.percentage = percentage;
     *   }
     *   processFrame(inputFrameBuffer, outputFrameBuffer) {
     *     const context = outputFrameBuffer.getContext('2d');
     *     context.filter = `grayscale(${this.percentage}%)`;
     *     context.drawImage(inputFrameBuffer, 0, 0, inputFrameBuffer.width, inputFrameBuffer.height);
     *   }
     * }
     *
     * const grayscaleProcessor = new GrayScaleProcessor(100);
     *
     * Array.from(room.participants.values()).forEach(participant => {
     *   const remoteVideoTrack = Array.from(participant.videoTracks.values())[0].track;
     *   remoteVideoTrack.addProcessor(grayscaleProcessor);
     * });
     */
    RemoteVideoTrack.prototype.addProcessor = function () {
        return _super.prototype.addProcessor.apply(this, arguments);
    };
    /**
     * Remove the previously added {@link VideoProcessor} using `addProcessor` API.
     * @param {VideoProcessor} processor - The {@link VideoProcessor} to remove.
     * @returns {this}
     * @example
     * class GrayScaleProcessor {
     *   constructor(percentage) {
     *     this.percentage = percentage;
     *   }
     *   processFrame(inputFrameBuffer, outputFrameBuffer) {
     *     const context = outputFrameBuffer.getContext('2d');
     *     context.filter = `grayscale(${this.percentage}%)`;
     *     context.drawImage(inputFrameBuffer, 0, 0, inputFrameBuffer.width, inputFrameBuffer.height);
     *   }
     * }
     *
     * const grayscaleProcessor = new GrayScaleProcessor(100);
     *
     * Array.from(room.participants.values()).forEach(participant => {
     *   const remoteVideoTrack = Array.from(participant.videoTracks.values())[0].track;
     *   remoteVideoTrack.addProcessor(grayscaleProcessor);
     * });
     *
     * document.getElementById('remove-button').onclick = () => {
     *   Array.from(room.participants.values()).forEach(participant => {
     *     const remoteVideoTrack = Array.from(participant.videoTracks.values())[0].track;
     *     remoteVideoTrack.removeProcessor(grayscaleProcessor);
     *   });
     * }
     */
    RemoteVideoTrack.prototype.removeProcessor = function () {
        return _super.prototype.removeProcessor.apply(this, arguments);
    };
    RemoteVideoTrack.prototype.toString = function () {
        return "[RemoteVideoTrack #" + this._instanceId + ": " + this.sid + "]";
    };
    /**
     * Update the subscribe {@link Track.Priority} of the {@link RemoteVideoTrack}.
     * @param {?Track.Priority} priority - the new subscribe {@link Track.Priority};
     *   If <code>null</code>, then the subscribe {@link Track.Priority} is cleared, which
     *   means the {@link Track.Priority} set by the publisher is now the effective priority.
     * @returns {this}
     * @throws {RangeError}
     */
    RemoteVideoTrack.prototype.setPriority = function (priority) {
        return _super.prototype.setPriority.call(this, priority);
    };
    return RemoteVideoTrack;
}(RemoteMediaVideoTrack));
function setupDocumentVisibilityTurnOff(removeVideoTrack) {
    function onVisibilityChanged() {
        maybeUpdateEnabledHint(removeVideoTrack);
    }
    documentVisibilityMonitor.onVisibilityChange(1, onVisibilityChanged);
    return function () {
        documentVisibilityMonitor.offVisibilityChange(1, onVisibilityChanged);
    };
}
function maybeUpdateEnabledHint(remoteVideoTrack) {
    if (remoteVideoTrack._clientTrackSwitchOffControl !== 'auto') {
        return;
    }
    var visibleElements = remoteVideoTrack._getAllAttachedElements().filter(function (el) { return !remoteVideoTrack._invisibleElements.has(el); });
    var pipWindows = remoteVideoTrack._getAllAttachedElements().filter(function (el) { return remoteVideoTrack._elToPipWindows.has(el); });
    // even when document is invisible we may have track playing in pip window.
    var enabled = pipWindows.length > 0 || (document.visibilityState === 'visible' && visibleElements.length > 0);
    if (enabled === true) {
        remoteVideoTrack._turnOffTimer.clear();
        remoteVideoTrack._setRenderHint({ enabled: true });
    }
    else if (!remoteVideoTrack._turnOffTimer.isSet) {
        // set the track to be turned off after some delay.
        remoteVideoTrack._turnOffTimer.start();
    }
}
function maybeUpdateDimensionHint(remoteVideoTrack) {
    if (remoteVideoTrack._contentPreferencesMode !== 'auto') {
        return;
    }
    var visibleElements = remoteVideoTrack._getAllAttachedElements().filter(function (el) { return !remoteVideoTrack._invisibleElements.has(el); });
    var pipElements = remoteVideoTrack._getAllAttachedElements().map(function (el) {
        var pipWindow = remoteVideoTrack._elToPipWindows.get(el);
        return pipWindow ? { clientHeight: pipWindow.height, clientWidth: pipWindow.width } : { clientHeight: 0, clientWidth: 0 };
    });
    var totalElements = visibleElements.concat(pipElements);
    if (totalElements.length > 0) {
        var _a = __read(totalElements.sort(function (el1, el2) {
            return el2.clientHeight + el2.clientWidth - el1.clientHeight - el1.clientWidth - 1;
        }), 1), _b = _a[0], clientHeight = _b.clientHeight, clientWidth = _b.clientWidth;
        var renderDimensions = { height: clientHeight, width: clientWidth };
        remoteVideoTrack._setRenderHint({ renderDimensions: renderDimensions });
    }
}
/**
 * @typedef {object} VideoContentPreferences
 * @property {VideoTrack.Dimensions} [renderDimensions] - Render Dimensions to request for the {@link RemoteVideoTrack}.
 */
/**
 * The {@link RemoteVideoTrack}'s dimensions changed.
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} whose
 *   dimensions changed
 * @event RemoteVideoTrack#dimensionsChanged
 */
/**
 * The {@link RemoteVideoTrack} was disabled, i.e. "paused".
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} that was
 *   disabled
 * @event RemoteVideoTrack#disabled
 */
/**
 * The {@link RemoteVideoTrack} was enabled, i.e. "resumed".
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} that was
 *   enabled
 * @event RemoteVideoTrack#enabled
 */
/**
 * The {@link RemoteVideoTrack} started. This means there is enough video data
 * to begin playback.
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} that started
 * @event RemoteVideoTrack#started
 */
/**
 * A {@link RemoteVideoTrack} was switched off.
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} that was
 *   switched off
 * @event RemoteVideoTrack#switchedOff
 */
/**
 * A {@link RemoteVideoTrack} was switched on.
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} that was
 *   switched on
 * @event RemoteVideoTrack#switchedOn
 */
module.exports = RemoteVideoTrack;

},{"../../util/documentvisibilitymonitor.js":129,"../../util/nullobserver.js":140,"../../util/timeout":147,"./remotemediatrack":36,"./videotrack":44}],39:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var RemoteTrackPublication = require('./remotetrackpublication');
/**
 * A {@link RemoteVideoTrackPublication} represents a {@link RemoteVideoTrack}
 * that has been published to a {@link Room}.
 * @property {Track.Kind} kind - "video"
 * @property {?RemoteVideoTrack} track - unless you have subscribed to the
 *   {@link RemoteVideoTrack}, this property is null
 * @emits RemoteVideoTrackPublication#subscribed
 * @emits RemoteVideoTrackPublication#subscriptionFailed
 * @emits RemoteVideoTrackPublication#trackDisabled
 * @emits RemoteVideoTrackPublication#trackEnabled
 * @emits RemoteVideoTrackPublication#unsubscribed
 */
var RemoteVideoTrackPublication = /** @class */ (function (_super) {
    __extends(RemoteVideoTrackPublication, _super);
    /**
     * Construct a {@link RemoteVideoTrackPublication}.
     * @param {RemoteTrackPublicationSignaling} signaling - {@link RemoteTrackPublication} signaling
     * @param {RemoteTrackPublicationOptions} options - {@link RemoteTrackPublication}
     *   options
     */
    function RemoteVideoTrackPublication(signaling, options) {
        return _super.call(this, signaling, options) || this;
    }
    RemoteVideoTrackPublication.prototype.toString = function () {
        return "[RemoteVideoTrackPublication #" + this._instanceId + ": " + this.trackSid + "]";
    };
    return RemoteVideoTrackPublication;
}(RemoteTrackPublication));
/**
 * Your {@link LocalParticipant} subscribed to the {@link RemoteVideoTrack}.
 * @param {RemoteVideoTrack} track - the {@link RemoteVideoTrack} that was subscribed to
 * @event RemoteVideoTrackPublication#subscribed
 */
/**
 * Your {@link LocalParticipant} failed to subscribe to the {@link RemoteVideoTrack}.
 * @param {TwilioError} error - the reason the {@link RemoteVideoTrack} could not be
 *   subscribed to
 * @event RemoteVideoTrackPublication#subscriptionFailed
 */
/**
 * The {@link RemoteVideoTrack} was disabled.
 * @event RemoteVideoTrackPublication#trackDisabled
 */
/**
 * The {@link RemoteVideoTrack} was enabled.
 * @event RemoteVideoTrackPublication#trackEnabled
 */
/**
 * Your {@link LocalParticipant} unsubscribed from the {@link RemoteVideoTrack}.
 * @param {RemoteVideoTrack} track - the {@link RemoteVideoTrack} that was unsubscribed from
 * @event RemoteVideoTrackPublication#unsubscribed
 */
module.exports = RemoteVideoTrackPublication;

},{"./remotetrackpublication":37}],40:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var MediaTrackTransceiver = require('./transceiver');
/**
 * A {@link MediaTrackSender} represents one or more local RTCRtpSenders.
 * @extends MediaTrackTransceiver
 * @emits MediaTrackSender#replaced
 */
var MediaTrackSender = /** @class */ (function (_super) {
    __extends(MediaTrackSender, _super);
    /**
     * Construct a {@link MediaTrackSender}.
     * @param {MediaStreamTrack} mediaStreamTrack
     */
    function MediaTrackSender(mediaStreamTrack) {
        var _this = _super.call(this, mediaStreamTrack.id, mediaStreamTrack) || this;
        Object.defineProperties(_this, {
            _clones: {
                value: new Set()
            },
            _eventsToReemitters: {
                value: new Map([
                    ['mute', function () { return _this.queue('muted'); }],
                    ['unmute', function () { return _this.queue('unmuted'); }]
                ])
            },
            _senders: {
                value: new Set()
            },
            _senderToPublisherHintCallbacks: {
                value: new Map()
            },
            isPublishing: {
                enumerable: true,
                get: function () {
                    return !!this._clones.size;
                }
            },
            muted: {
                enumerable: true,
                get: function () {
                    return this._track.muted;
                }
            }
        });
        _this._reemitMediaStreamTrackEvents();
        return _this;
    }
    /**
     * @private
     */
    MediaTrackSender.prototype._reemitMediaStreamTrackEvents = function (mediaStreamTrack) {
        if (mediaStreamTrack === void 0) { mediaStreamTrack = this._track; }
        var _a = this, eventsToReemitters = _a._eventsToReemitters, track = _a._track;
        eventsToReemitters.forEach(function (reemitter, event) { return mediaStreamTrack.addEventListener(event, reemitter); });
        if (track !== mediaStreamTrack) {
            eventsToReemitters.forEach(function (reemitter, event) { return track.removeEventListener(event, reemitter); });
            if (track.muted !== mediaStreamTrack.muted) {
                var reemitter = eventsToReemitters.get(mediaStreamTrack.muted ? 'mute' : 'unmute');
                reemitter();
            }
        }
    };
    /**
     * Return a new {@link MediaTrackSender} containing a clone of the underlying
     * MediaStreamTrack. No RTCRtpSenders are copied.
     * @returns {MediaTrackSender}
     */
    MediaTrackSender.prototype.clone = function () {
        var clone = new MediaTrackSender(this.track.clone());
        this._clones.add(clone);
        return clone;
    };
    /**
     * Remove a cloned {@link MediaTrackSender}.
     * @returns {void}
     */
    MediaTrackSender.prototype.removeClone = function (clone) {
        this._clones.delete(clone);
    };
    /**
     * Set the given MediaStreamTrack.
     * @param {MediaStreamTrack} mediaStreamTrack
     * @returns {Promise<void>}
     */
    MediaTrackSender.prototype.setMediaStreamTrack = function (mediaStreamTrack) {
        var _this = this;
        var clones = Array.from(this._clones);
        var senders = Array.from(this._senders);
        return Promise.all(clones.map(function (clone) {
            return clone.setMediaStreamTrack(mediaStreamTrack.clone());
        }).concat(senders.map(function (sender) {
            return _this._replaceTrack(sender, mediaStreamTrack);
        }))).finally(function () {
            _this._reemitMediaStreamTrackEvents(mediaStreamTrack);
            _this._track = mediaStreamTrack;
        });
    };
    /**
     * Add an RTCRtpSender.
     * @param {RTCRtpSender} sender
     * @param {?()=>Promise<string>} publisherHintCallback
     * @returns {this}
     */
    MediaTrackSender.prototype.addSender = function (sender, publisherHintCallback) {
        this._senders.add(sender);
        if (publisherHintCallback) {
            this._senderToPublisherHintCallbacks.set(sender, publisherHintCallback);
        }
        return this;
    };
    /**
     * Remove an RTCRtpSender.
     * @param {RTCRtpSender} sender
     * @returns {this}
     */
    MediaTrackSender.prototype.removeSender = function (sender) {
        this._senders.delete(sender);
        this._senderToPublisherHintCallbacks.delete(sender);
        return this;
    };
    /**
     * Applies given encodings, or resets encodings if none specified.
     * @param {Array<{enabled: boolean, layer_index: number}>|null} encodings
     * @returns {Promise<string>}
     */
    MediaTrackSender.prototype.setPublisherHint = function (encodings) {
        // Note(mpatwardhan): since publisher hint applies only to group rooms we only look at 1st call callback.
        var _a = __read(Array.from(this._senderToPublisherHintCallbacks.values()), 1), publisherHintCallback = _a[0];
        return publisherHintCallback ? publisherHintCallback(encodings) : Promise.resolve('COULD_NOT_APPLY_HINT');
    };
    MediaTrackSender.prototype._replaceTrack = function (sender, mediaStreamTrack) {
        var _this = this;
        return sender.replaceTrack(mediaStreamTrack).then(function (replaceTrackResult) {
            // clear any publisherHints and apply default encodings.
            _this.setPublisherHint(null).catch(function () { });
            _this.emit('replaced');
            return replaceTrackResult;
        });
    };
    return MediaTrackSender;
}(MediaTrackTransceiver));
/**
 * The {@link MediaTrackSender}'s underlying MediaStreamTrack was muted.
 * @event MediaTrackSender#muted
 */
/**
 * The {@link MediaTrackSender} replaced the underlying MediaStreamTrack.
 * @event MediaTrackSender#replaced
 */
/**
 * The {@link MediaTrackSender}'s underlying MediaStreamTrack was unmuted.
 * @event MediaTrackSender#unmuted
 */
module.exports = MediaTrackSender;

},{"./transceiver":42}],41:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var EventEmitter = require('../../eventemitter');
var _a = require('../../util'), buildLogLevels = _a.buildLogLevels, valueToJSON = _a.valueToJSON;
var DEFAULT_LOG_LEVEL = require('../../util/constants').DEFAULT_LOG_LEVEL;
var Log = require('../../util/log');
var nInstances = 0;
/**
 * A {@link TrackPublication} represents a {@link Track} that
 * has been published to a {@link Room}.
 * @property {string} trackName - the published {@link Track}'s name
 * @property {Track.SID} trackSid - SID assigned to the published {@link Track}
 * @emits TrackPublication#trackDisabled
 * @emits TrackPublication#trackEnabled
 */
var TrackPublication = /** @class */ (function (_super) {
    __extends(TrackPublication, _super);
    /**
     * Construct a {@link TrackPublication}.
     * @param {string} trackName - the published {@link Track}'s name
     * @param {Track.SID} trackSid - SID assigned to the {@link Track}
     * @param {TrackPublicationOptions} options - {@link TrackPublication} options
     */
    function TrackPublication(trackName, trackSid, options) {
        var _this = _super.call(this) || this;
        options = Object.assign({
            logLevel: DEFAULT_LOG_LEVEL
        }, options);
        var logLevels = buildLogLevels(options.logLevel);
        Object.defineProperties(_this, {
            _instanceId: {
                value: nInstances++
            },
            _log: {
                value: options.log ? options.log.createLog('default', _this) : new Log('default', _this, logLevels, options.loggerName)
            },
            trackName: {
                enumerable: true,
                value: trackName
            },
            trackSid: {
                enumerable: true,
                value: trackSid
            }
        });
        return _this;
    }
    TrackPublication.prototype.toJSON = function () {
        return valueToJSON(this);
    };
    TrackPublication.prototype.toString = function () {
        return "[TrackPublication #" + this._instanceId + ": " + this.trackSid + "]";
    };
    return TrackPublication;
}(EventEmitter));
/**
 * The published {@link Track} was disabled.
 * @event TrackPublication#trackDisabled
 */
/**
 * The published {@link Track} was enabled.
 * @event TrackPublication#trackEnabled
 */
/**
 * A {@link LocalAudioTrackPublication} or a {@link RemoteAudioTrackPublication}.
 * @typedef {LocalAudioTrackPublication|RemoteAudioTrackPublication} AudioTrackPublication
 */
/**
 * A {@link LocalDataTrackPublication} or a {@link RemoteDataTrackPublication}.
 * @typedef {LocalDataTrackPublication|RemoteDataTrackPublication} DataTrackPublication
 */
/**
 * A {@link LocalVideoTrackPublication} or a {@link RemoteVideoTrackPublication}.
 * @typedef {LocalVideoTrackPublication|RemoteVideoTrackPublication} VideoTrackPublication
 */
/**
 * {@link TrackPublication} options
 * @typedef {object} TrackPublicationOptions
 * @property {LogLevel|LogLevels} logLevel - Log level for 'media' modules
 */
module.exports = TrackPublication;

},{"../../eventemitter":10,"../../util":133,"../../util/constants":126,"../../util/log":137}],42:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var TrackTransceiver = require('../../transceiver');
/**
 * A {@link MediaTrackTransceiver} represents either one or more local
 * RTCRtpSenders, or a single RTCRtpReceiver.
 * @extends TrackTransceiver
 * @property {MediaStreamTrack} track
 */
var MediaTrackTransceiver = /** @class */ (function (_super) {
    __extends(MediaTrackTransceiver, _super);
    /**
     * Construct a {@link MediaTrackTransceiver}.
     * @param {Track.ID} id - The MediaStreamTrack ID signaled through RSP/SDP
     * @param {MediaStreamTrack} mediaStreamTrack
     */
    function MediaTrackTransceiver(id, mediaStreamTrack) {
        var _this = _super.call(this, id, mediaStreamTrack.kind) || this;
        Object.defineProperties(_this, {
            _track: {
                value: mediaStreamTrack,
                writable: true
            },
            enabled: {
                enumerable: true,
                get: function () {
                    return this._track.enabled;
                }
            },
            readyState: {
                enumerable: true,
                get: function () {
                    return this._track.readyState;
                }
            },
            track: {
                enumerable: true,
                get: function () {
                    return this._track;
                }
            }
        });
        return _this;
    }
    MediaTrackTransceiver.prototype.stop = function () {
        this.track.stop();
        _super.prototype.stop.call(this);
    };
    return MediaTrackTransceiver;
}(TrackTransceiver));
module.exports = MediaTrackTransceiver;

},{"../../transceiver":120}],43:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var EventEmitter = require('events').EventEmitter;
var DEFAULT_VIDEO_PROCESSOR_STATS_INTERVAL_MS = require('../../util/constants').DEFAULT_VIDEO_PROCESSOR_STATS_INTERVAL_MS;
/**
 * VideoProcessorEventObserver listens to {@link VideoProcessor} related events
 * and re-emits them as a generic event with some additional information.
 * @extends EventEmitter
 * @emits VideoProcessorEventObserver#event
 */
var VideoProcessorEventObserver = /** @class */ (function (_super) {
    __extends(VideoProcessorEventObserver, _super);
    /**
     * Constructor.
     * @param {Log} log
     */
    function VideoProcessorEventObserver(log) {
        var _this = _super.call(this) || this;
        Object.defineProperties(_this, {
            _lastStatsSaveTime: {
                value: null,
                writable: true
            },
            _lastStatsPublishTime: {
                value: null,
                writable: true
            },
            _log: {
                value: log
            },
            _processorInfo: {
                value: null,
                writable: true
            },
            _stats: {
                value: null,
                writable: true
            }
        });
        _this.on('add', function (info) {
            _this._lastStatsSaveTime = Date.now();
            _this._lastStatsPublishTime = Date.now();
            _this._processorInfo = info;
            _this._stats = [];
            _this._reemitEvent('add', _this._getEventData());
        });
        _this.on('remove', function () {
            var data = _this._getEventData();
            _this._lastStatsSaveTime = null;
            _this._lastStatsPublishTime = null;
            _this._processorInfo = null;
            _this._stats = null;
            _this._reemitEvent('remove', data);
        });
        _this.on('start', function () {
            _this._reemitEvent('start', _this._getEventData());
        });
        _this.on('stop', function (message) {
            _this._reemitEvent('stop', Object.assign({ message: message }, _this._getEventData()));
        });
        _this.on('stats', function () { return _this._maybeEmitStats(); });
        return _this;
    }
    /**
     * @private
     */
    VideoProcessorEventObserver.prototype._getEventData = function () {
        if (!this._processorInfo) {
            return {};
        }
        var _a = this._processorInfo, processor = _a.processor, captureHeight = _a.captureHeight, captureWidth = _a.captureWidth, inputFrameRate = _a.inputFrameRate, isRemoteVideoTrack = _a.isRemoteVideoTrack, inputFrameBufferType = _a.inputFrameBufferType, outputFrameBufferContextType = _a.outputFrameBufferContextType;
        var data = { captureHeight: captureHeight, captureWidth: captureWidth, inputFrameRate: inputFrameRate, isRemoteVideoTrack: isRemoteVideoTrack, inputFrameBufferType: inputFrameBufferType, outputFrameBufferContextType: outputFrameBufferContextType };
        data.name = processor._name || 'VideoProcessor';
        ['assetsPath', 'blurFilterRadius', 'debounce', 'fitType', 'isSimdEnabled', 'maskBlurRadius', 'pipeline', 'version'].forEach(function (prop) {
            var val = processor["_" + prop];
            if (typeof val !== 'undefined') {
                data[prop] = val;
            }
        });
        Object.keys(data).forEach(function (prop) {
            var val = data[prop];
            if (typeof val === 'boolean') {
                data[prop] = val ? 'true' : 'false';
            }
        });
        return data;
    };
    /**
     * Save stats every second. If a specific time interval has elapsed,
     * the stats event will be emitted
     * @private
     */
    VideoProcessorEventObserver.prototype._maybeEmitStats = function () {
        if (!this._stats || !this._processorInfo) {
            return;
        }
        var benchmark = this._processorInfo.processor._benchmark;
        if (!benchmark) {
            return;
        }
        var now = Date.now();
        if (now - this._lastStatsSaveTime < 1000) {
            return;
        }
        var entry = { outputFrameRate: benchmark.getRate('totalProcessingDelay') };
        ['captureFrameDelay', 'imageCompositionDelay', 'inputImageResizeDelay', 'processFrameDelay', 'segmentationDelay'].forEach(function (name) {
            entry[name] = benchmark.getAverageDelay(name);
        });
        this._lastStatsSaveTime = now;
        this._stats.push(entry);
        if (now - this._lastStatsPublishTime < DEFAULT_VIDEO_PROCESSOR_STATS_INTERVAL_MS) {
            return;
        }
        this._lastStatsPublishTime = now;
        var stats = this._stats.splice(0);
        var averages = stats.reduce(function (averages, current, n) {
            Object.keys(entry).forEach(function (name) {
                if (!averages[name]) {
                    averages[name] = 0;
                }
                averages[name] = ((averages[name] * n) + current[name]) / (n + 1);
            });
            return averages;
        }, {});
        Object.keys(averages).forEach(function (name) {
            averages[name] = parseFloat(averages[name].toFixed(2));
        });
        this._reemitEvent('stats', Object.assign({}, averages, this._getEventData()));
    };
    /**
     * @private
     */
    VideoProcessorEventObserver.prototype._reemitEvent = function (name, data) {
        this._log.debug("VideoProcessor:" + name, data);
        this.emit('event', { name: name, data: data });
    };
    return VideoProcessorEventObserver;
}(EventEmitter));
module.exports = VideoProcessorEventObserver;

},{"../../util/constants":126,"events":174}],44:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var MediaTrack = require('./mediatrack');
var captureVideoFrames = require('./capturevideoframes');
var VideoProcessorEventObserver = require('./videoprocessoreventobserver');
var guessBrowser = require('../../webrtc/util').guessBrowser;
var DEFAULT_FRAME_RATE = require('../../util/constants').DEFAULT_FRAME_RATE;
/**
 * A {@link VideoTrack} is a {@link Track} representing video.
 * @extends Track
 * @property {boolean} isStarted - Whether or not the {@link VideoTrack} has
 *   started; if the {@link VideoTrack} started, there is enough video data to
 *   begin playback
 * @property {boolean} isEnabled - Whether or not the {@link VideoTrack} is
 *   enabled; if the {@link VideoTrack} is not enabled, it is "paused"
 * @property {VideoTrack.Dimensions} dimensions - The {@link VideoTrack}'s
 *   {@link VideoTrack.Dimensions}
 * @property {Track.Kind} kind - "video"
 * @property {MediaStreamTrack} mediaStreamTrack - A video MediaStreamTrack
 * @property {?MediaStreamTrack} processedTrack - The source of processed video frames.
 * It is null if no VideoProcessor has been added.
 * @property {?VideoProcessor} processor - A {@link VideoProcessor} that is currently
 *   processing video frames. It is null if video frames are not being processed.
 * @emits VideoTrack#dimensionsChanged
 * @emits VideoTrack#disabled
 * @emits VideoTrack#enabled
 * @emits VideoTrack#started
 */
var VideoTrack = /** @class */ (function (_super) {
    __extends(VideoTrack, _super);
    /**
     * Construct a {@link VideoTrack}.
     * @param {MediaTrackTransceiver} mediaTrackTransceiver
     * @param {{log: Log}} options
     */
    function VideoTrack(mediaTrackTransceiver, options) {
        var _this = _super.call(this, mediaTrackTransceiver, options) || this;
        Object.defineProperties(_this, {
            _isCapturing: {
                value: false,
                writable: true
            },
            _inputFrame: {
                value: null,
                writable: true
            },
            _outputFrame: {
                value: null,
                writable: true
            },
            _processorEventObserver: {
                value: null,
                writable: true,
            },
            _processorOptions: {
                value: {},
                writable: true,
            },
            _stopCapture: {
                value: function () { },
                writable: true
            },
            _unmuteHandler: {
                value: null,
                writable: true
            },
            dimensions: {
                enumerable: true,
                value: {
                    width: null,
                    height: null
                }
            },
            processor: {
                enumerable: true,
                value: null,
                writable: true
            }
        });
        _this._processorEventObserver = new (options.VideoProcessorEventObserver || VideoProcessorEventObserver)(_this._log);
        return _this;
    }
    /**
     * @private
     */
    VideoTrack.prototype._checkIfCanCaptureFrames = function (isPublishing) {
        if (isPublishing === void 0) { isPublishing = false; }
        var canCaptureFrames = true;
        var message = '';
        var _a = this.mediaStreamTrack, enabled = _a.enabled, readyState = _a.readyState;
        if (!enabled) {
            canCaptureFrames = false;
            message = 'MediaStreamTrack is disabled';
        }
        if (readyState === 'ended') {
            canCaptureFrames = false;
            message = 'MediaStreamTrack is ended';
        }
        if (!this.processor) {
            canCaptureFrames = false;
            message = 'VideoProcessor not detected.';
        }
        if (!this._attachments.size && !isPublishing) {
            canCaptureFrames = false;
            message = 'VideoTrack is not publishing and there is no attached element.';
        }
        if (message) {
            this._log.debug(message);
        }
        return { canCaptureFrames: canCaptureFrames, message: message };
    };
    /**
     * @private
     */
    VideoTrack.prototype._captureFrames = function () {
        var _this = this;
        if (this._isCapturing) {
            this._log.debug('Ignoring captureFrames call. Capture is already in progress');
            return;
        }
        if (!this._checkIfCanCaptureFrames().canCaptureFrames) {
            this._isCapturing = false;
            this._log.debug('Cannot capture frames. Ignoring captureFrames call.');
            return;
        }
        this._isCapturing = true;
        this._processorEventObserver.emit('start');
        this._log.debug('Start capturing frames');
        var inputFrameBufferType = this._processorOptions.inputFrameBufferType;
        this._dummyEl.play().then(function () {
            var process = function (videoFrame) {
                var checkResult = _this._checkIfCanCaptureFrames();
                if (!checkResult.canCaptureFrames) {
                    if (videoFrame) {
                        videoFrame.close();
                    }
                    _this._isCapturing = false;
                    _this._stopCapture();
                    _this._processorEventObserver.emit('stop', checkResult.message);
                    _this._log.debug('Cannot capture frames. Stopping capturing frames.');
                    return Promise.resolve();
                }
                var _a = _this.mediaStreamTrack.getSettings(), _b = _a.width, width = _b === void 0 ? 0 : _b, _c = _a.height, height = _c === void 0 ? 0 : _c;
                // Setting the canvas' dimension triggers a redraw.
                // Only set it if it has changed.
                if (_this._outputFrame && _this._outputFrame.width !== width) {
                    _this._outputFrame.width = width;
                    _this._outputFrame.height = height;
                }
                if (_this._inputFrame) {
                    if (_this._inputFrame.width !== width) {
                        _this._inputFrame.width = width;
                        _this._inputFrame.height = height;
                    }
                    _this._inputFrame.getContext('2d').drawImage(_this._dummyEl, 0, 0, width, height);
                }
                var input = videoFrame || (['video', 'videoframe'].includes(inputFrameBufferType)
                    ? _this._dummyEl
                    : _this._inputFrame);
                var result = null;
                try {
                    result = _this.processor.processFrame(input, _this._outputFrame);
                }
                catch (ex) {
                    _this._log.debug('Exception detected after calling processFrame.', ex);
                }
                return ((result instanceof Promise) ? result : Promise.resolve(result))
                    .then(function () {
                    if (_this._outputFrame) {
                        if (typeof _this.processedTrack.requestFrame === 'function') {
                            _this.processedTrack.requestFrame();
                        }
                        _this._processorEventObserver.emit('stats');
                    }
                });
            };
            _this._stopCapture = captureVideoFrames(_this._dummyEl, process, inputFrameBufferType);
        }).catch(function (error) { return _this._log.error('Video element cannot be played', { error: error, track: _this }); });
    };
    /**
     * @private
     */
    VideoTrack.prototype._initialize = function () {
        var _this = this;
        _super.prototype._initialize.call(this);
        if (this._dummyEl) {
            this._dummyEl.onloadedmetadata = function () {
                if (dimensionsChanged(_this, _this._dummyEl)) {
                    _this.dimensions.width = _this._dummyEl.videoWidth;
                    _this.dimensions.height = _this._dummyEl.videoHeight;
                }
            };
            this._dummyEl.onresize = function () {
                if (dimensionsChanged(_this, _this._dummyEl)) {
                    _this.dimensions.width = _this._dummyEl.videoWidth;
                    _this.dimensions.height = _this._dummyEl.videoHeight;
                    if (_this.isStarted) {
                        _this._log.debug('Dimensions changed:', _this.dimensions);
                        _this.emit(VideoTrack.DIMENSIONS_CHANGED, _this);
                    }
                }
            };
        }
    };
    /**
     * @private
     */
    VideoTrack.prototype._restartProcessor = function () {
        var processor = this.processor;
        if (processor) {
            var processorOptions = Object.assign({}, this._processorOptions);
            this.removeProcessor(processor);
            this.addProcessor(processor, processorOptions);
        }
    };
    /**
     * @private
     */
    VideoTrack.prototype._start = function (dummyEl) {
        this.dimensions.width = dummyEl.videoWidth;
        this.dimensions.height = dummyEl.videoHeight;
        this._log.debug('Dimensions:', this.dimensions);
        this.emit(VideoTrack.DIMENSIONS_CHANGED, this);
        return _super.prototype._start.call(this, dummyEl);
    };
    /**
     * Add a {@link VideoProcessor} to allow for custom processing of video frames belonging to a VideoTrack.
     * @param {VideoProcessor} processor - The {@link VideoProcessor} to use.
     * @param {AddProcessorOptions} [options] - {@link AddProcessorOptions} to provide.
     * @returns {this}
     * @example
     * class GrayScaleProcessor {
     *   constructor(percentage) {
     *     this.percentage = percentage;
     *   }
     *   processFrame(inputFrameBuffer, outputFrameBuffer) {
     *     const context = outputFrameBuffer.getContext('2d');
     *     context.filter = `grayscale(${this.percentage}%)`;
     *     context.drawImage(inputFrameBuffer, 0, 0, inputFrameBuffer.width, inputFrameBuffer.height);
     *   }
     * }
     *
     * Video.createLocalVideoTrack().then(function(videoTrack) {
     *   videoTrack.addProcessor(new GrayScaleProcessor(100));
     * });
     */
    VideoTrack.prototype.addProcessor = function (processor, options) {
        var _this = this;
        if (!processor || typeof processor.processFrame !== 'function') {
            throw new Error('Received an invalid VideoProcessor from addProcessor.');
        }
        if (this.processor) {
            throw new Error('A VideoProcessor has already been added.');
        }
        if (!this._dummyEl) {
            throw new Error('VideoTrack has not been initialized.');
        }
        this._log.debug('Adding VideoProcessor to the VideoTrack', processor);
        if (!this._unmuteHandler) {
            this._unmuteHandler = function () {
                _this._log.debug('mediaStreamTrack unmuted');
                // NOTE(csantos): On certain scenarios where mediaStreamTrack is coming from muted to unmuted state,
                // the processedTrack doesn't unmutes automatically although enabled is already set to true.
                // This is a terminal state for the processedTrack and should be restarted. (VIDEO-4176)
                if (_this.processedTrack.muted) {
                    _this._log.debug('mediaStreamTrack is unmuted but processedTrack is muted. Restarting processor.');
                    _this._restartProcessor();
                }
            };
            this.mediaStreamTrack.addEventListener('unmute', this._unmuteHandler);
        }
        this._processorOptions = options || {};
        var _a = this._processorOptions, inputFrameBufferType = _a.inputFrameBufferType, outputFrameBufferContextType = _a.outputFrameBufferContextType;
        if (typeof OffscreenCanvas === 'undefined' && inputFrameBufferType === 'offscreencanvas') {
            throw new Error('OffscreenCanvas is not supported by this browser.');
        }
        if (inputFrameBufferType
            && inputFrameBufferType !== 'videoframe'
            && inputFrameBufferType !== 'video'
            && inputFrameBufferType !== 'canvas'
            && inputFrameBufferType !== 'offscreencanvas') {
            throw new Error("Invalid inputFrameBufferType of " + inputFrameBufferType);
        }
        if (!inputFrameBufferType) {
            inputFrameBufferType = typeof OffscreenCanvas === 'undefined' ? 'canvas' : 'offscreencanvas';
        }
        var _b = this.mediaStreamTrack.getSettings(), _c = _b.width, width = _c === void 0 ? 0 : _c, _d = _b.height, height = _d === void 0 ? 0 : _d, _e = _b.frameRate, frameRate = _e === void 0 ? DEFAULT_FRAME_RATE : _e;
        if (inputFrameBufferType === 'offscreencanvas') {
            this._inputFrame = new OffscreenCanvas(width, height);
        }
        if (inputFrameBufferType === 'canvas') {
            this._inputFrame = document.createElement('canvas');
        }
        if (this._inputFrame) {
            this._inputFrame.width = width;
            this._inputFrame.height = height;
        }
        this._outputFrame = document.createElement('canvas');
        this._outputFrame.width = width;
        this._outputFrame.height = height;
        // NOTE(csantos): Initialize the rendering context for future renders. This also ensures
        // that the correct type is used and on Firefox, it throws an exception if you try to capture
        // frames prior calling getContext https://bugzilla.mozilla.org/show_bug.cgi?id=1572422
        outputFrameBufferContextType = outputFrameBufferContextType || '2d';
        var ctx = this._outputFrame.getContext(outputFrameBufferContextType);
        if (!ctx) {
            throw new Error("Cannot get outputFrameBufferContextType: " + outputFrameBufferContextType + ".");
        }
        // NOTE(csantos): Zero FPS means we can control when to render the next frame by calling requestFrame.
        // Some browsers such as Firefox doesn't support requestFrame so we will use default, which is an undefined value.
        // This means, the browser will use the highest FPS available.
        var targetFps = typeof CanvasCaptureMediaStreamTrack !== 'undefined' && CanvasCaptureMediaStreamTrack.prototype &&
            // eslint-disable-next-line
            typeof CanvasCaptureMediaStreamTrack.prototype.requestFrame === 'function' ? 0 : undefined;
        this.processedTrack = this._outputFrame.captureStream(targetFps).getTracks()[0];
        this.processedTrack.enabled = this.mediaStreamTrack.enabled;
        this.processor = processor;
        this._processorEventObserver.emit('add', {
            processor: processor,
            captureHeight: height,
            captureWidth: width,
            inputFrameRate: frameRate,
            isRemoteVideoTrack: this.toString().includes('RemoteVideoTrack'),
            inputFrameBufferType: inputFrameBufferType,
            outputFrameBufferContextType: outputFrameBufferContextType
        });
        this._updateElementsMediaStreamTrack();
        this._captureFrames();
        return this;
    };
    /**
     * Create an HTMLVideoElement and attach the {@link VideoTrack} to it.
     *
     * The HTMLVideoElement's <code>srcObject</code> will be set to a new
     * MediaStream containing the {@link VideoTrack}'s MediaStreamTrack.
     *
     * @returns {HTMLVideoElement} videoElement
     * @example
     * const Video = require('twilio-video');
     *
     * Video.createLocalVideoTrack().then(function(videoTrack) {
     *   const videoElement = videoTrack.attach();
     *   document.body.appendChild(videoElement);
     * });
    */ /**
     * Attach the {@link VideoTrack} to an existing HTMLMediaElement. The
     * HTMLMediaElement could be an HTMLAudioElement or an HTMLVideoElement.
     *
     * If the HTMLMediaElement's <code>srcObject</code> is not set to a MediaStream,
     * this method sets it to a new MediaStream containing the {@link VideoTrack}'s
     * MediaStreamTrack; otherwise, it adds the {@link MediaTrack}'s
     * MediaStreamTrack to the existing MediaStream. Finally, if there are any other
     * MediaStreamTracks of the same kind on the MediaStream, this method removes
     * them.
     *
     * @param {HTMLMediaElement} mediaElement - The HTMLMediaElement to attach to
     * @returns {HTMLMediaElement} mediaElement
     * @example
     * const Video = require('twilio-video');
     *
     * const videoElement = document.createElement('video');
     * document.body.appendChild(videoElement);
     *
     * Video.createLocalVideoTrack().then(function(videoTrack) {
     *   videoTrack.attach(videoElement);
     * });
    */ /**
     * Attach the {@link VideoTrack} to an HTMLMediaElement selected by
     * <code>document.querySelector</code>. The HTMLMediaElement could be an
     * HTMLAudioElement or an HTMLVideoElement.
     *
     * If the HTMLMediaElement's <code>srcObject</code> is not set to a MediaStream,
     * this method sets it to a new MediaStream containing the {@link VideoTrack}'s
     * MediaStreamTrack; otherwise, it adds the {@link VideoTrack}'s
     * MediaStreamTrack to the existing MediaStream. Finally, if there are any other
     * MediaStreamTracks of the same kind on the MediaStream, this method removes
     * them.
     *
     * @param {string} selector - A query selector for the HTMLMediaElement to
     *   attach to
     * @returns {HTMLMediaElement} mediaElement
     * @example
     * const Video = require('twilio-video');
     *
     * const videoElement = document.createElement('video');
     * videoElement.id = 'my-video-element';
     * document.body.appendChild(videoElement);
     *
     * Video.createLocalVideoTrack().then(function(track) {
     *   track.attach('#my-video-element');
     * });
     */
    VideoTrack.prototype.attach = function () {
        var result = _super.prototype.attach.apply(this, arguments);
        if (this.processor) {
            this._captureFrames();
        }
        return result;
    };
    /**
     * Detach the {@link VideoTrack} from all previously attached HTMLMediaElements.
     * @returns {Array<HTMLMediaElement>} mediaElements
     * @example
     * const mediaElements = videoTrack.detach();
     * mediaElements.forEach(mediaElement => mediaElement.remove());
    */ /**
     * Detach the {@link VideoTrack} from a previously attached HTMLMediaElement.
     * @param {HTMLMediaElement} mediaElement - One of the HTMLMediaElements to
     *   which the {@link VideoTrack} is attached
     * @returns {HTMLMediaElement} mediaElement
     * @example
     * const videoElement = document.getElementById('my-video-element');
     * videoTrack.detach(videoElement).remove();
    */ /**
     * Detach the {@link VideoTrack} from a previously attached HTMLMediaElement
     *   specified by <code>document.querySelector</code>.
     * @param {string} selector - The query selector of HTMLMediaElement to which
     *    the {@link VideoTrack} is attached
     * @returns {HTMLMediaElement} mediaElement
     * @example
     * videoTrack.detach('#my-video-element').remove();
     */
    VideoTrack.prototype.detach = function () {
        return _super.prototype.detach.apply(this, arguments);
    };
    /**
     * Remove the previously added {@link VideoProcessor} using `addProcessor` API.
     * @param {VideoProcessor} processor - The {@link VideoProcessor} to remove.
     * @returns {this}
     * @example
     * class GrayScaleProcessor {
     *   constructor(percentage) {
     *     this.percentage = percentage;
     *   }
     *   processFrame(inputFrameBuffer, outputFrameBuffer) {
     *     const context = outputFrameBuffer.getContext('2d');
     *     context.filter = `grayscale(${this.percentage}%)`;
     *     context.drawImage(inputFrameBuffer, 0, 0, inputFrameBuffer.width, inputFrameBuffer.height);
     *   }
     * }
     *
     * Video.createLocalVideoTrack().then(function(videoTrack) {
     *   const grayScaleProcessor = new GrayScaleProcessor(100);
     *   videoTrack.addProcessor(grayScaleProcessor);
     *   document.getElementById('remove-button').onclick = () => videoTrack.removeProcessor(grayScaleProcessor);
     * });
     */
    VideoTrack.prototype.removeProcessor = function (processor) {
        if (!processor) {
            throw new Error('Received an invalid VideoProcessor from removeProcessor.');
        }
        if (!this.processor) {
            throw new Error('No existing VideoProcessor detected.');
        }
        if (processor !== this.processor) {
            throw new Error('The provided VideoProcessor is different than the existing one.');
        }
        this._processorEventObserver.emit('remove');
        this._log.debug('Removing VideoProcessor from the VideoTrack', processor);
        this._stopCapture();
        this._stopCapture = function () { };
        this.mediaStreamTrack.removeEventListener('unmute', this._unmuteHandler);
        this._processorOptions = {};
        this._unmuteHandler = null;
        this._isCapturing = false;
        this.processor = null;
        this.processedTrack = null;
        this._inputFrame = null;
        this._outputFrame = null;
        this._updateElementsMediaStreamTrack();
        return this;
    };
    return VideoTrack;
}(MediaTrack));
VideoTrack.DIMENSIONS_CHANGED = 'dimensionsChanged';
function dimensionsChanged(track, elem) {
    return track.dimensions.width !== elem.videoWidth
        || track.dimensions.height !== elem.videoHeight;
}
/**
 * A {@link VideoTrack}'s width and height.
 * @typedef {object} VideoTrack.Dimensions
 * @property {?number} width - The {@link VideoTrack}'s width or null if the
 *   {@link VideoTrack} has not yet started
 * @property {?number} height - The {@link VideoTrack}'s height or null if the
 *   {@link VideoTrack} has not yet started
 */
/**
 * A {@link VideoProcessor}, when added via {@link VideoTrack#addProcessor},
 * is used to process incoming video frames before
 * sending to the encoder or renderer.
 * @typedef {object} VideoProcessor
 * @property {function} processFrame - A callback to receive input and output frame buffers for processing.
 * The input frame buffer contains the original video frame which can be used for additional processing
 * such as applying filters to it. The output frame buffer is used to receive the processed video frame
 * before sending to the encoder or renderer.
 *
 * Any exception raised (either synchronously or asynchronously) in `processFrame` will result in the frame being dropped.
 * This callback has the following signature:<br/><br/>
 * <code>processFrame(</code><br/>
 * &nbsp;&nbsp;<code>inputFrameBuffer: OffscreenCanvas | HTMLCanvasElement | HTMLVideoElement | VideoFrame,</code><br/>
 * &nbsp;&nbsp;<code>outputFrameBuffer: HTMLCanvasElement</code><br/>
 * <code>): Promise&lt;void&gt; | void;</code>
 *
 * @example
 * class GrayScaleProcessor {
 *   constructor(percentage) {
 *     this.percentage = percentage;
 *   }
 *   processFrame(inputFrameBuffer, outputFrameBuffer) {
 *     const context = outputFrameBuffer.getContext('2d');
 *     context.filter = `grayscale(${this.percentage}%)`;
 *     context.drawImage(inputFrameBuffer, 0, 0, inputFrameBuffer.width, inputFrameBuffer.height);
 *   }
 * }
 */
/**
 * Possible options to provide to {@link LocalVideoTrack#addProcessor} and {@link RemoteVideoTrack#addProcessor}.
 * @typedef {object} AddProcessorOptions
 * @property {string} [inputFrameBufferType="offscreencanvas"] - This option allows you to specify what kind of input you want to receive in your
 * Video Processor. The default is `offscreencanvas` and will fallback to a regular `canvas` if the browser does not support it.
 * Possible values include the following.
 * <br/>
 * <br/>
 * `videoframe` - Your Video Processor will receive a [VideoFrame](https://developer.mozilla.org/en-US/docs/Web/API/VideoFrame).
 * On browsers that do not support `VideoFrame`, it will receive an [HTMLVideoElement](https://developer.mozilla.org/en-US/docs/Web/API/HTMLVideoElement) instead.
 * <br/>
 * <br/>
 * `offscreencanvas` - Your Video Processor will receive an [OffscreenCanvas](https://developer.mozilla.org/en-US/docs/Web/API/OffscreenCanvas)
 * which is good for canvas-related processing that can be rendered off screen.
 * <br/>
 * <br/>
 * `canvas` - Your Video Processor will receive an [HTMLCanvasElement](https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement).
 * This is recommended on browsers that doesn't support `OffscreenCanvas`, or if you need to render the frame on the screen.
 * <br/>
 * <br/>
 * `video` - Your Video Processor will receive an [HTMLVideoElement](https://developer.mozilla.org/en-US/docs/Web/API/HTMLVideoElement).
 * Use this option if you are processing the frame using WebGL or if you only need to [draw](https://developer.mozilla.org/en-US/docs/Web/API/CanvasRenderingContext2D/drawImage)
 * the frame directly to your output canvas.
 * @property {string} [outputFrameBufferContextType="2d"] - The SDK needs the [context type](https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/getContext)
 * that your Video Processor uses in order to properly generate the processed track. For example, if your Video Processor uses WebGL2 (`canvas.getContext('webgl2')`),
 * you should set `outputFrameBufferContextType` to `webgl2`. If you're using Canvas 2D processing (`canvas.getContext('2d')`),
 * you should set `outputFrameBufferContextType` to `2d`. If the output frame is an [ImageBitmap](https://developer.mozilla.org/en-US/docs/Web/API/ImageBitmap),
 * you should set `outputFrameBufferContextType` to `bitmaprenderer`.
 */
/**
 * The {@link VideoTrack}'s dimensions changed.
 * @param {VideoTrack} track - The {@link VideoTrack} whose dimensions changed
 * @event VideoTrack#dimensionsChanged
 */
/**
 * The {@link VideoTrack} was disabled, i.e. "paused".
 * @param {VideoTrack} track - The {@link VideoTrack} that was disabled
 * @event VideoTrack#disabled
 */
/**
 * The {@link VideoTrack} was enabled, i.e. "unpaused".
 * @param {VideoTrack} track - The {@link VideoTrack} that was enabled
 * @event VideoTrack#enabled
 */
/**
 * The {@link VideoTrack} started. This means there is enough video data to
 * begin playback.
 * @param {VideoTrack} track - The {@link VideoTrack} that started
 * @event VideoTrack#started
 */
module.exports = VideoTrack;

},{"../../util/constants":126,"../../webrtc/util":171,"./capturevideoframes":15,"./mediatrack":29,"./videoprocessoreventobserver":43}],45:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var EventEmitter = require('events').EventEmitter;
var _a = require('./util/constants'), DEFAULT_NQ_LEVEL_LOCAL = _a.DEFAULT_NQ_LEVEL_LOCAL, DEFAULT_NQ_LEVEL_REMOTE = _a.DEFAULT_NQ_LEVEL_REMOTE, MAX_NQ_LEVEL = _a.MAX_NQ_LEVEL;
var inRange = require('./util').inRange;
/**
 * {@link NetworkQualityConfigurationImpl} represents an object which notifies its
 * listeners of any changes in the values of its properties.
 * @extends EventEmitter
 * @implements NetworkQualityConfiguration
 * @property {?NetworkQualityVerbosity} local - Verbosity level for {@link LocalParticipant}
 * @property {?NetworkQualityVerbosity} remote - Verbosity level for {@link RemoteParticipant}s
 */
var NetworkQualityConfigurationImpl = /** @class */ (function (_super) {
    __extends(NetworkQualityConfigurationImpl, _super);
    /**
     * Construct an {@link NetworkQualityConfigurationImpl}.
     * @param {NetworkQualityConfiguration} networkQualityConfiguration - Initial {@link NetworkQualityConfiguration}
     */
    function NetworkQualityConfigurationImpl(networkQualityConfiguration) {
        var _this = _super.call(this) || this;
        networkQualityConfiguration = Object.assign({
            local: DEFAULT_NQ_LEVEL_LOCAL,
            remote: DEFAULT_NQ_LEVEL_REMOTE
        }, networkQualityConfiguration);
        Object.defineProperties(_this, {
            local: {
                value: inRange(networkQualityConfiguration.local, DEFAULT_NQ_LEVEL_LOCAL, MAX_NQ_LEVEL)
                    ? networkQualityConfiguration.local
                    : DEFAULT_NQ_LEVEL_LOCAL,
                writable: true
            },
            remote: {
                value: inRange(networkQualityConfiguration.remote, DEFAULT_NQ_LEVEL_REMOTE, MAX_NQ_LEVEL)
                    ? networkQualityConfiguration.remote
                    : DEFAULT_NQ_LEVEL_REMOTE,
                writable: true
            }
        });
        return _this;
    }
    /**
     * Update the verbosity levels for network quality information for
     * {@link LocalParticipant} and {@link RemoteParticipant} with those
     * in the given {@link NetworkQualityConfiguration}.
     * @param {NetworkQualityConfiguration} networkQualityConfiguration - The new {@link NetworkQualityConfiguration}
     */
    NetworkQualityConfigurationImpl.prototype.update = function (networkQualityConfiguration) {
        var _this = this;
        networkQualityConfiguration = Object.assign({
            local: this.local,
            remote: this.remote
        }, networkQualityConfiguration);
        [
            ['local', DEFAULT_NQ_LEVEL_LOCAL, 3],
            ['remote', DEFAULT_NQ_LEVEL_REMOTE, 3]
        ].forEach(function (_a) {
            var _b = __read(_a, 3), localOrRemote = _b[0], min = _b[1], max = _b[2];
            _this[localOrRemote] = typeof networkQualityConfiguration[localOrRemote] === 'number'
                && inRange(networkQualityConfiguration[localOrRemote], min, max)
                ? networkQualityConfiguration[localOrRemote]
                : min;
        });
    };
    return NetworkQualityConfigurationImpl;
}(EventEmitter));
module.exports = NetworkQualityConfigurationImpl;

},{"./util":133,"./util/constants":126,"events":174}],46:[function(require,module,exports){
'use strict';
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createNoiseCancellationAudioProcessor = void 0;
var dynamicImport = require('./util/dynamicimport');
var Log = require('./util/log');
var PLUGIN_CONFIG = {
    krisp: {
        supportedVersion: '1.0.0',
        pluginFile: 'krispsdk.mjs'
    },
    rnnoise: {
        supportedVersion: '0.6.0',
        pluginFile: 'rnnoise_sdk.mjs'
    }
};
var ensureVersionSupported = function (_a) {
    var supportedVersion = _a.supportedVersion, plugin = _a.plugin, log = _a.log;
    if (!plugin.getVersion || !plugin.isSupported) {
        throw new Error('Plugin does not export getVersion/isSupported api. Are you using old version of the plugin ?');
    }
    var pluginVersion = plugin.getVersion();
    log.debug("Plugin Version = " + pluginVersion);
    var supportedVersions = supportedVersion.split('.').map(function (version) { return Number(version); });
    var pluginVersions = pluginVersion.split('.').map(function (version) { return Number(version); });
    if (supportedVersions.length !== 3 || pluginVersions.length !== 3) {
        throw new Error("Unsupported Plugin version format: " + supportedVersion + ", " + pluginVersion);
    }
    if (supportedVersions[0] !== pluginVersions[0]) {
        throw new Error("Major version mismatch: [Plugin version " + pluginVersion + "],  [Supported Version " + supportedVersion + "]");
    }
    if (pluginVersions[1] < supportedVersions[1]) {
        throw new Error("Minor version mismatch: [Plugin version " + pluginVersion + "] < [Supported Version " + supportedVersion + "]");
    }
    var tempContext = new AudioContext();
    var isSupported = plugin.isSupported(tempContext);
    tempContext.close();
    if (!isSupported) {
        throw new Error('Noise Cancellation plugin is not supported on your browser');
    }
};
var audioProcessors = new Map();
function createNoiseCancellationAudioProcessor(noiseCancellationOptions, log) {
    return __awaiter(this, void 0, void 0, function () {
        var audioProcessor, pluginConfig, supportedVersion, pluginFile, rootDir, sdkFilePath, dynamicModule, plugin_1, er_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    audioProcessor = audioProcessors.get(noiseCancellationOptions.vendor);
                    if (!!audioProcessor) return [3 /*break*/, 6];
                    pluginConfig = PLUGIN_CONFIG[noiseCancellationOptions.vendor];
                    if (!pluginConfig) {
                        throw new Error("Unsupported NoiseCancellationOptions.vendor: " + noiseCancellationOptions.vendor);
                    }
                    supportedVersion = pluginConfig.supportedVersion, pluginFile = pluginConfig.pluginFile;
                    rootDir = noiseCancellationOptions.sdkAssetsPath;
                    sdkFilePath = rootDir + "/" + pluginFile;
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 5, , 6]);
                    log.debug('loading noise cancellation sdk: ', sdkFilePath);
                    return [4 /*yield*/, dynamicImport(sdkFilePath)];
                case 2:
                    dynamicModule = _a.sent();
                    log.debug('Loaded noise cancellation sdk:', dynamicModule);
                    plugin_1 = dynamicModule.default;
                    ensureVersionSupported({
                        supportedVersion: supportedVersion,
                        plugin: plugin_1,
                        log: log
                    });
                    if (!!plugin_1.isInitialized()) return [3 /*break*/, 4];
                    log.debug('initializing noise cancellation sdk: ', rootDir);
                    return [4 /*yield*/, plugin_1.init({ rootDir: rootDir })];
                case 3:
                    _a.sent();
                    log.debug('noise cancellation sdk initialized!');
                    _a.label = 4;
                case 4:
                    audioProcessor = {
                        vendor: noiseCancellationOptions.vendor,
                        isInitialized: function () { return plugin_1.isInitialized(); },
                        isConnected: function () { return plugin_1.isConnected(); },
                        isEnabled: function () { return plugin_1.isEnabled(); },
                        disconnect: function () { return plugin_1.disconnect(); },
                        enable: function () { return plugin_1.enable(); },
                        disable: function () { return plugin_1.disable(); },
                        destroy: function () { return plugin_1.destroy(); },
                        setLogging: function (enable) { return plugin_1.setLogging(enable); },
                        connect: function (sourceTrack) {
                            log.debug('connect: ', sourceTrack.id);
                            if (plugin_1.isConnected()) {
                                plugin_1.disconnect();
                            }
                            var mediaStream = plugin_1.connect(new MediaStream([sourceTrack]));
                            if (!mediaStream) {
                                throw new Error('Error connecting with noise cancellation sdk');
                            }
                            var cleanTrack = mediaStream.getAudioTracks()[0];
                            if (!cleanTrack) {
                                throw new Error('Error getting clean track from noise cancellation sdk');
                            }
                            plugin_1.enable();
                            return cleanTrack;
                        },
                    };
                    audioProcessors.set(noiseCancellationOptions.vendor, audioProcessor);
                    return [3 /*break*/, 6];
                case 5:
                    er_1 = _a.sent();
                    log.error("Error loading noise cancellation sdk:" + sdkFilePath, er_1);
                    throw er_1;
                case 6: return [2 /*return*/, audioProcessor];
            }
        });
    });
}
exports.createNoiseCancellationAudioProcessor = createNoiseCancellationAudioProcessor;

},{"./util/dynamicimport":130,"./util/log":137}],47:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var EventEmitter = require('./eventemitter');
var RemoteAudioTrack = require('./media/track/remoteaudiotrack');
var RemoteAudioTrackPublication = require('./media/track/remoteaudiotrackpublication');
var RemoteDataTrack = require('./media/track/remotedatatrack');
var RemoteDataTrackPublication = require('./media/track/remotedatatrackpublication');
var RemoteVideoTrack = require('./media/track/remotevideotrack');
var RemoteVideoTrackPublication = require('./media/track/remotevideotrackpublication');
var util = require('./util');
var nInstances = 0;
/**
 * {@link NetworkQualityLevel} is a value from 0–5, inclusive, representing the
 * quality of a network connection.
 * @typedef {number} NetworkQualityLevel
 */
/**
 * @extends EventEmitter
 * @property {Map<Track.SID, AudioTrackPublication>} audioTracks -
 *    The {@link Participant}'s {@link AudioTrackPublication}s
 * @property {Map<Track.SID, DataTrackPublication>} dataTracks -
 *    The {@link Participant}'s {@link DataTrackPublication}s.
 * @property {Participant.Identity} identity - The identity of the {@link Participant}
 * @property {?NetworkQualityLevel} networkQualityLevel - The
 *    {@link Participant}'s current {@link NetworkQualityLevel}, if any
 * @property {?NetworkQualityStats} networkQualityStats - The
 *    {@link Participant}'s current {@link NetworkQualityStats}, if any
 * @property {Participant.SID} sid - The {@link Participant}'s SID
 * @property {string} state - "connected", "disconnected" or "reconnecting"
 * @property {Map<Track.SID, TrackPublication>} tracks -
 *    The {@link Participant}'s {@link TrackPublication}s
 * @property {Map<Track.SID, VideoTrackPublication>} videoTracks -
 *    The {@link Participant}'s {@link VideoTrackPublication}s
 * @emits Participant#disconnected
 * @emits Participant#networkQualityLevelChanged
 * @emits Participant#reconnected
 * @emits Participant#reconnecting
 * @emits Participant#trackDimensionsChanged
 * @emits Participant#trackStarted
 */
var Participant = /** @class */ (function (_super) {
    __extends(Participant, _super);
    /**
     * Construct a {@link Participant}.
     * @param {ParticipantSignaling} signaling
     * @param {object} [options]
     */
    function Participant(signaling, options) {
        var _this = _super.call(this) || this;
        options = Object.assign({
            RemoteAudioTrack: RemoteAudioTrack,
            RemoteAudioTrackPublication: RemoteAudioTrackPublication,
            RemoteDataTrack: RemoteDataTrack,
            RemoteDataTrackPublication: RemoteDataTrackPublication,
            RemoteVideoTrack: RemoteVideoTrack,
            RemoteVideoTrackPublication: RemoteVideoTrackPublication,
            tracks: []
        }, options);
        var indexed = indexTracksById(options.tracks);
        var log = options.log.createLog('default', _this);
        var audioTracks = new Map(indexed.audioTracks);
        var dataTracks = new Map(indexed.dataTracks);
        var tracks = new Map(indexed.tracks);
        var videoTracks = new Map(indexed.videoTracks);
        Object.defineProperties(_this, {
            _RemoteAudioTrack: {
                value: options.RemoteAudioTrack
            },
            _RemoteAudioTrackPublication: {
                value: options.RemoteAudioTrackPublication
            },
            _RemoteDataTrack: {
                value: options.RemoteDataTrack
            },
            _RemoteDataTrackPublication: {
                value: options.RemoteDataTrackPublication
            },
            _RemoteVideoTrack: {
                value: options.RemoteVideoTrack
            },
            _RemoteVideoTrackPublication: {
                value: options.RemoteVideoTrackPublication
            },
            _audioTracks: {
                value: audioTracks
            },
            _dataTracks: {
                value: dataTracks
            },
            _instanceId: {
                value: ++nInstances
            },
            _clientTrackSwitchOffControl: {
                value: options.clientTrackSwitchOffControl,
            },
            _contentPreferencesMode: {
                value: options.contentPreferencesMode,
            },
            _log: {
                value: log
            },
            _signaling: {
                value: signaling
            },
            _tracks: {
                value: tracks
            },
            _trackEventReemitters: {
                value: new Map()
            },
            _trackPublicationEventReemitters: {
                value: new Map()
            },
            _trackSignalingUpdatedEventCallbacks: {
                value: new Map()
            },
            _videoTracks: {
                value: videoTracks
            },
            audioTracks: {
                enumerable: true,
                value: new Map()
            },
            dataTracks: {
                enumerable: true,
                value: new Map()
            },
            identity: {
                enumerable: true,
                get: function () {
                    return signaling.identity;
                }
            },
            networkQualityLevel: {
                enumerable: true,
                get: function () {
                    return signaling.networkQualityLevel;
                }
            },
            networkQualityStats: {
                enumerable: true,
                get: function () {
                    return signaling.networkQualityStats;
                }
            },
            sid: {
                enumerable: true,
                get: function () {
                    return signaling.sid;
                }
            },
            state: {
                enumerable: true,
                get: function () {
                    return signaling.state;
                }
            },
            tracks: {
                enumerable: true,
                value: new Map()
            },
            videoTracks: {
                enumerable: true,
                value: new Map()
            }
        });
        _this._tracks.forEach(reemitTrackEvents.bind(null, _this));
        signaling.on('networkQualityLevelChanged', function () {
            return _this.emit('networkQualityLevelChanged', _this.networkQualityLevel, _this.networkQualityStats &&
                (_this.networkQualityStats.audio || _this.networkQualityStats.video)
                ? _this.networkQualityStats
                : null);
        });
        reemitSignalingStateChangedEvents(_this, signaling);
        log.info("Created a new Participant" + (_this.identity ? ": " + _this.identity : ''));
        return _this;
    }
    /**
     * Get the {@link RemoteTrack} events to re-emit.
     * @private
     * @returns {Array<Array<string>>} events
     */
    Participant.prototype._getTrackEvents = function () {
        return [
            ['dimensionsChanged', 'trackDimensionsChanged'],
            ['message', 'trackMessage'],
            ['started', 'trackStarted']
        ];
    };
    /**
     * @private
     */
    Participant.prototype._getTrackPublicationEvents = function () {
        return [];
    };
    Participant.prototype.toString = function () {
        return "[Participant #" + this._instanceId + ": " + this.sid + "]";
    };
    /**
     * @private
     * @param {RemoteTrack} track
     * @param {Track.ID} id
     * @returns {?RemoteTrack}
     */
    Participant.prototype._addTrack = function (track, id) {
        var log = this._log;
        if (this._tracks.has(id)) {
            return null;
        }
        this._tracks.set(id, track);
        var tracksByKind = {
            audio: this._audioTracks,
            video: this._videoTracks,
            data: this._dataTracks
        }[track.kind];
        tracksByKind.set(id, track);
        reemitTrackEvents(this, track, id);
        log.info("Added a new " + util.trackClass(track) + ":", id);
        log.debug(util.trackClass(track) + ":", track);
        return track;
    };
    /**
     * @private
     * @param {RemoteTrackPublication} publication
     * @returns {?RemoteTrackPublication}
     */
    Participant.prototype._addTrackPublication = function (publication) {
        var log = this._log;
        if (this.tracks.has(publication.trackSid)) {
            return null;
        }
        this.tracks.set(publication.trackSid, publication);
        var trackPublicationsByKind = {
            audio: this.audioTracks,
            data: this.dataTracks,
            video: this.videoTracks
        }[publication.kind];
        trackPublicationsByKind.set(publication.trackSid, publication);
        reemitTrackPublicationEvents(this, publication);
        log.info("Added a new " + util.trackPublicationClass(publication) + ":", publication.trackSid);
        log.debug(util.trackPublicationClass(publication) + ":", publication);
        return publication;
    };
    /**
     * @private
     */
    Participant.prototype._handleTrackSignalingEvents = function () {
        var _a = this, log = _a._log, clientTrackSwitchOffControl = _a._clientTrackSwitchOffControl, contentPreferencesMode = _a._contentPreferencesMode;
        var self = this;
        if (this.state === 'disconnected') {
            return;
        }
        var RemoteAudioTrack = this._RemoteAudioTrack;
        var RemoteAudioTrackPublication = this._RemoteAudioTrackPublication;
        var RemoteVideoTrack = this._RemoteVideoTrack;
        var RemoteVideoTrackPublication = this._RemoteVideoTrackPublication;
        var RemoteDataTrack = this._RemoteDataTrack;
        var RemoteDataTrackPublication = this._RemoteDataTrackPublication;
        var participantSignaling = this._signaling;
        function trackSignalingAdded(signaling) {
            var RemoteTrackPublication = {
                audio: RemoteAudioTrackPublication,
                data: RemoteDataTrackPublication,
                video: RemoteVideoTrackPublication
            }[signaling.kind];
            var publication = new RemoteTrackPublication(signaling, { log: log });
            self._addTrackPublication(publication);
            var isSubscribed = signaling.isSubscribed;
            if (isSubscribed) {
                trackSignalingSubscribed(signaling);
            }
            self._trackSignalingUpdatedEventCallbacks.set(signaling.sid, function () {
                if (isSubscribed !== signaling.isSubscribed) {
                    isSubscribed = signaling.isSubscribed;
                    if (isSubscribed) {
                        trackSignalingSubscribed(signaling);
                        return;
                    }
                    trackSignalingUnsubscribed(signaling);
                }
            });
            signaling.on('updated', self._trackSignalingUpdatedEventCallbacks.get(signaling.sid));
        }
        function trackSignalingRemoved(signaling) {
            if (signaling.isSubscribed) {
                signaling.setTrackTransceiver(null);
            }
            var updated = self._trackSignalingUpdatedEventCallbacks.get(signaling.sid);
            if (updated) {
                signaling.removeListener('updated', updated);
                self._trackSignalingUpdatedEventCallbacks.delete(signaling.sid);
            }
            var publication = self.tracks.get(signaling.sid);
            if (publication) {
                self._removeTrackPublication(publication);
            }
        }
        function trackSignalingSubscribed(signaling) {
            var isEnabled = signaling.isEnabled, name = signaling.name, kind = signaling.kind, sid = signaling.sid, trackTransceiver = signaling.trackTransceiver, isSwitchedOff = signaling.isSwitchedOff;
            var RemoteTrack = {
                audio: RemoteAudioTrack,
                video: RemoteVideoTrack,
                data: RemoteDataTrack
            }[kind];
            var publication = self.tracks.get(sid);
            // NOTE(mroberts): It should never be the case that the TrackSignaling and
            // MediaStreamTrack or DataTrackReceiver kinds disagree; however, just in
            // case, we handle it here.
            if (!RemoteTrack || kind !== trackTransceiver.kind) {
                return;
            }
            var options = { log: log, name: name, clientTrackSwitchOffControl: clientTrackSwitchOffControl, contentPreferencesMode: contentPreferencesMode };
            var setPriority = function (newPriority) { return participantSignaling.updateSubscriberTrackPriority(sid, newPriority); };
            var setRenderHint = function (renderHint) {
                if (signaling.isSubscribed) {
                    participantSignaling.updateTrackRenderHint(sid, renderHint);
                }
            };
            var track = kind === 'data'
                ? new RemoteTrack(sid, trackTransceiver, options)
                : new RemoteTrack(sid, trackTransceiver, isEnabled, isSwitchedOff, setPriority, setRenderHint, options);
            self._addTrack(track, publication, trackTransceiver.id);
        }
        function trackSignalingUnsubscribed(signaling) {
            var _a = __read(Array.from(self._tracks.entries()).find(function (_a) {
                var _b = __read(_a, 2), track = _b[1];
                return track.sid === signaling.sid;
            }), 2), id = _a[0], track = _a[1];
            var publication = self.tracks.get(signaling.sid);
            if (track) {
                self._removeTrack(track, publication, id);
            }
        }
        participantSignaling.on('trackAdded', trackSignalingAdded);
        participantSignaling.on('trackRemoved', trackSignalingRemoved);
        participantSignaling.tracks.forEach(trackSignalingAdded);
        participantSignaling.on('stateChanged', function stateChanged(state) {
            if (state === 'disconnected') {
                log.debug('Removing event listeners');
                participantSignaling.removeListener('stateChanged', stateChanged);
                participantSignaling.removeListener('trackAdded', trackSignalingAdded);
                participantSignaling.removeListener('trackRemoved', trackSignalingRemoved);
            }
            else if (state === 'connected') {
                // NOTE(mmalavalli): Any transition to "connected" here is a result of
                // successful signaling reconnection, and not a first-time establishment
                // of the signaling connection.
                log.info('reconnected');
                // NOTE(mpatwardhan): `stateChanged` can get emitted with StateMachine locked.
                // Do not signal  public events synchronously with lock held.
                setTimeout(function () { return self.emit('reconnected'); }, 0);
            }
        });
    };
    /**
     * @private
     * @param {RemoteTrack} track
     * @param {Track.ID} id
     * @returns {?RemoteTrack}
     */
    Participant.prototype._removeTrack = function (track, id) {
        if (!this._tracks.has(id)) {
            return null;
        }
        this._tracks.delete(id);
        var tracksByKind = {
            audio: this._audioTracks,
            video: this._videoTracks,
            data: this._dataTracks
        }[track.kind];
        tracksByKind.delete(id);
        var reemitters = this._trackEventReemitters.get(id) || new Map();
        reemitters.forEach(function (reemitter, event) {
            track.removeListener(event, reemitter);
        });
        var log = this._log;
        log.info("Removed a " + util.trackClass(track) + ":", id);
        log.debug(util.trackClass(track) + ":", track);
        return track;
    };
    /**
     * @private
     * @param {RemoteTrackPublication} publication
     * @returns {?RemoteTrackPublication}
     */
    Participant.prototype._removeTrackPublication = function (publication) {
        publication = this.tracks.get(publication.trackSid);
        if (!publication) {
            return null;
        }
        this.tracks.delete(publication.trackSid);
        var trackPublicationsByKind = {
            audio: this.audioTracks,
            data: this.dataTracks,
            video: this.videoTracks
        }[publication.kind];
        trackPublicationsByKind.delete(publication.trackSid);
        var reemitters = this._trackPublicationEventReemitters.get(publication.trackSid) || new Map();
        reemitters.forEach(function (reemitter, event) {
            publication.removeListener(event, reemitter);
        });
        var log = this._log;
        log.info("Removed a " + util.trackPublicationClass(publication) + ":", publication.trackSid);
        log.debug(util.trackPublicationClass(publication) + ":", publication);
        return publication;
    };
    Participant.prototype.toJSON = function () {
        return util.valueToJSON(this);
    };
    return Participant;
}(EventEmitter));
/**
 * A {@link Participant.SID} is a 34-character string starting with "PA"
 * that uniquely identifies a {@link Participant}.
 * @type string
 * @typedef Participant.SID
 */
/**
 * A {@link Participant.Identity} is a string that identifies a
 * {@link Participant}. You can think of it like a name.
 * @typedef {string} Participant.Identity
 */
/**
 * The {@link Participant} has disconnected.
 * @param {Participant} participant - The {@link Participant} that disconnected.
 * @event Participant#disconnected
 */
/**
 * The {@link Participant}'s {@link NetworkQualityLevel} changed.
 * @param {NetworkQualityLevel} networkQualityLevel - The new
 *   {@link NetworkQualityLevel}
 * @param {?NetworkQualityStats} networkQualityStats - The {@link NetworkQualityStats}
 *   based on which {@link NetworkQualityLevel} is calculated, if any
 * @event Participant#networkQualityLevelChanged
 */
/**
 * The {@link Participant} has reconnected to the {@link Room} after a signaling connection disruption.
 * @event Participant#reconnected
 */
/**
 * The {@link Participant} is reconnecting to the {@link Room} after a signaling connection disruption.
 * @event Participant#reconnecting
 */
/**
 * One of the {@link Participant}'s {@link VideoTrack}'s dimensions changed.
 * @param {VideoTrack} track - The {@link VideoTrack} whose dimensions changed
 * @event Participant#trackDimensionsChanged
 */
/**
 * One of the {@link Participant}'s {@link Track}s started.
 * @param {Track} track - The {@link Track} that started
 * @event Participant#trackStarted
 */
/**
 * Indexed {@link Track}s by {@link Track.ID}.
 * @typedef {object} IndexedTracks
 * @property {Array<{0: Track.ID, 1: AudioTrack}>} audioTracks - Indexed
 *   {@link AudioTrack}s
 * @property {Array<{0: Track.ID, 1: DataTrack}>} dataTracks - Indexed
 *   {@link DataTrack}s
 * @property {Array<{0: Track.ID, 1: Track}>} tracks - Indexed {@link Track}s
 * @property {Array<{0: Track.ID, 1: VideoTrack}>} videoTracks - Indexed
 *   {@link VideoTrack}s
 * @private
 */
/**
 * Index tracks by {@link Track.ID}.
 * @param {Array<Track>} tracks
 * @returns {IndexedTracks}
 * @private
 */
function indexTracksById(tracks) {
    var indexedTracks = tracks.map(function (track) { return [track.id, track]; });
    var indexedAudioTracks = indexedTracks.filter(function (keyValue) { return keyValue[1].kind === 'audio'; });
    var indexedVideoTracks = indexedTracks.filter(function (keyValue) { return keyValue[1].kind === 'video'; });
    var indexedDataTracks = indexedTracks.filter(function (keyValue) { return keyValue[1].kind === 'data'; });
    return {
        audioTracks: indexedAudioTracks,
        dataTracks: indexedDataTracks,
        tracks: indexedTracks,
        videoTracks: indexedVideoTracks
    };
}
/**
 * Re-emit {@link ParticipantSignaling} 'stateChanged' events.
 * @param {Participant} participant
 * @param {ParticipantSignaling} signaling
 * @private
 */
function reemitSignalingStateChangedEvents(participant, signaling) {
    var log = participant._log;
    if (participant.state === 'disconnected') {
        return;
    }
    // Reemit state transition events from the ParticipantSignaling.
    signaling.on('stateChanged', function stateChanged(state) {
        log.debug('Transitioned to state:', state);
        participant.emit(state, participant);
        if (state === 'disconnected') {
            log.debug('Removing Track event reemitters');
            signaling.removeListener('stateChanged', stateChanged);
            participant._tracks.forEach(function (track) {
                var reemitters = participant._trackEventReemitters.get(track.id);
                if (track && reemitters) {
                    reemitters.forEach(function (reemitter, event) {
                        track.removeListener(event, reemitter);
                    });
                }
            });
            // eslint-disable-next-line no-warning-comments
            // TODO(joma): Removing this introduced unit test failures in the RemoteParticipant.
            // Investigate further before removing.
            signaling.tracks.forEach(function (trackSignaling) {
                var track = participant._tracks.get(trackSignaling.id);
                var reemitters = participant._trackEventReemitters.get(trackSignaling.id);
                if (track && reemitters) {
                    reemitters.forEach(function (reemitter, event) {
                        track.removeListener(event, reemitter);
                    });
                }
            });
            participant._trackEventReemitters.clear();
            participant.tracks.forEach(function (publication) {
                participant._trackPublicationEventReemitters.get(publication.trackSid)
                    .forEach(function (reemitter, event) {
                    publication.removeListener(event, reemitter);
                });
            });
            participant._trackPublicationEventReemitters.clear();
        }
    });
}
/**
 * Re-emit {@link Track} events.
 * @param {Participant} participant
 * @param {Track} track
 * @param {Track.ID} id
 * @private
 */
function reemitTrackEvents(participant, track, id) {
    var trackEventReemitters = new Map();
    if (participant.state === 'disconnected') {
        return;
    }
    participant._getTrackEvents().forEach(function (eventPair) {
        var trackEvent = eventPair[0];
        var participantEvent = eventPair[1];
        trackEventReemitters.set(trackEvent, function () {
            var args = [participantEvent].concat([].slice.call(arguments));
            return participant.emit.apply(participant, __spreadArray([], __read(args)));
        });
        track.on(trackEvent, trackEventReemitters.get(trackEvent));
    });
    participant._trackEventReemitters.set(id, trackEventReemitters);
}
/**
 * Re-emit {@link TrackPublication} events.
 * @private
 * @param {Participant} participant
 * @param {TrackPublication} publication
 */
function reemitTrackPublicationEvents(participant, publication) {
    var publicationEventReemitters = new Map();
    if (participant.state === 'disconnected') {
        return;
    }
    participant._getTrackPublicationEvents().forEach(function (_a) {
        var _b = __read(_a, 2), publicationEvent = _b[0], participantEvent = _b[1];
        publicationEventReemitters.set(publicationEvent, function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            participant.emit.apply(participant, __spreadArray(__spreadArray([participantEvent], __read(args)), [publication]));
        });
        publication.on(publicationEvent, publicationEventReemitters.get(publicationEvent));
    });
    participant._trackPublicationEventReemitters.set(publication.trackSid, publicationEventReemitters);
}
module.exports = Participant;

},{"./eventemitter":10,"./media/track/remoteaudiotrack":32,"./media/track/remoteaudiotrackpublication":33,"./media/track/remotedatatrack":34,"./media/track/remotedatatrackpublication":35,"./media/track/remotevideotrack":38,"./media/track/remotevideotrackpublication":39,"./util":133}],48:[function(require,module,exports){
"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCombinedConnectionStats = void 0;
function getStatValues(report, statName, kind, reportTypes) {
    var results = [];
    report.forEach(function (stat) {
        if ((reportTypes.length === 0 || reportTypes.includes(stat.type)) &&
            (kind.length === 0 || kind.includes(stat.kind)) &&
            typeof stat[statName] === 'number') {
            results.push(stat[statName]);
        }
    });
    return results;
}
function getCombinedConnectionStats(_a) {
    var publisher = _a.publisher, subscriber = _a.subscriber;
    return __awaiter(this, void 0, void 0, function () {
        var _b, publisherStats, subscriberStats, timestamps, timestamp, jitter, packets, packetsLost, trackRoundTripTime, currentRoundTripTime, roundTripTime, bytesSent, bytesReceived, selectedIceCandidatePairStats, iceCandidateStats;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0: return [4 /*yield*/, Promise.all([publisher, subscriber].map(function (pc) { return pc.getStats(); }))];
                case 1:
                    _b = __read.apply(void 0, [_c.sent(), 2]), publisherStats = _b[0], subscriberStats = _b[1];
                    timestamps = getStatValues(subscriberStats, 'timestamp', ['audio'], ['inbound-rtp']);
                    timestamp = timestamps.length > 0 ? timestamps[0] : 0;
                    jitter = getStatValues(subscriberStats, 'jitter', ['audio'], ['inbound-rtp']).reduce(function (a, b) { return Math.max(a, b); }, 0);
                    packets = getStatValues(subscriberStats, 'packetsReceived', ['audio', 'video'], ['inbound-rtp']).reduce(function (a, b) { return a + b; }, 0);
                    packetsLost = getStatValues(subscriberStats, 'packetsLost', ['audio', 'video'], ['inbound-rtp']).reduce(function (a, b) { return a + b; }, 0);
                    trackRoundTripTime = getStatValues(publisherStats, 'roundTripTime', ['audio', 'video'], ['remote-inbound-rtp']).reduce(function (a, b) { return Math.max(a, b); }, 0);
                    currentRoundTripTime = getStatValues(subscriberStats, 'currentRoundTripTime', [], ['candidate-pair']).reduce(function (a, b) { return Math.max(a, b); }, 0);
                    roundTripTime = (currentRoundTripTime || trackRoundTripTime) * 1000;
                    bytesSent = getStatValues(publisherStats, 'bytesSent', [], ['candidate-pair']).reduce(function (a, b) { return a + b; }, 0);
                    bytesReceived = getStatValues(subscriberStats, 'bytesReceived', [], ['candidate-pair']).reduce(function (a, b) { return a + b; }, 0);
                    selectedIceCandidatePairStats = extractSelectedActiveCandidatePair(subscriberStats);
                    iceCandidateStats = [];
                    subscriberStats.forEach(function (stat) {
                        if (stat.type === 'local-candidate' || stat.type === 'remote-candidate') {
                            iceCandidateStats.push(makeStandardCandidateStats(stat));
                        }
                    });
                    return [2 /*return*/, { timestamp: timestamp, jitter: jitter, packets: packets, packetsLost: packetsLost, roundTripTime: roundTripTime, bytesSent: bytesSent, bytesReceived: bytesReceived, selectedIceCandidatePairStats: selectedIceCandidatePairStats, iceCandidateStats: iceCandidateStats }];
            }
        });
    });
}
exports.getCombinedConnectionStats = getCombinedConnectionStats;
function makeStandardCandidateStats(input) {
    var standardizedCandidateStatsKeys = [
        { key: 'transportId', type: 'string' },
        { key: 'candidateType', type: 'string' },
        { key: 'port', altKeys: ['portNumber'], type: 'number' },
        { key: 'address', altKeys: ['ip', 'ipAddress'], type: 'string' },
        { key: 'priority', type: 'number' },
        { key: 'protocol', altKeys: ['transport'], type: 'string' },
        { key: 'url', type: 'string' },
        { key: 'relayProtocol', type: 'string' },
    ];
    return standardizedCandidateStatsKeys.reduce(function (report, keyInfo) {
        var keysToLookFor = [keyInfo.key];
        if (keyInfo.altKeys) {
            keysToLookFor = keysToLookFor.concat(keyInfo.altKeys);
        }
        var key = keysToLookFor.find(function (key) { return key in input; });
        if (key && typeof input[key] === keyInfo.type) {
            report[keyInfo.key] = input[key];
        }
        return report;
    }, {});
}
function extractSelectedActiveCandidatePair(stats) {
    var selectedCandidatePairId = null;
    var candidatePairs = [];
    stats.forEach(function (stat) {
        if (stat.type === 'transport' && stat.selectedCandidatePairId) {
            selectedCandidatePairId = stat.selectedCandidatePairId;
        }
        else if (stat.type === 'candidate-pair') {
            candidatePairs.push(stat);
        }
    });
    var activeCandidatePairStatsFound = candidatePairs.find(function (pair) {
        // Firefox
        return pair.selected ||
            // Spec-compliant way
            (selectedCandidatePairId && pair.id === selectedCandidatePairId);
    });
    if (!activeCandidatePairStatsFound) {
        return null;
    }
    var activeCandidatePairStats = activeCandidatePairStatsFound;
    var activeLocalCandidateStats = stats.get(activeCandidatePairStats.localCandidateId);
    var activeRemoteCandidateStats = stats.get(activeCandidatePairStats.remoteCandidateId);
    if (!activeLocalCandidateStats || !activeRemoteCandidateStats) {
        return null;
    }
    return {
        localCandidate: makeStandardCandidateStats(activeLocalCandidateStats),
        remoteCandidate: makeStandardCandidateStats(activeRemoteCandidateStats)
    };
}

},{}],49:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTurnCredentials = void 0;
/* eslint-disable camelcase */
var TwilioConnection = require('../twilioconnection.js');
var ICE_VERSION = require('../util/constants').ICE_VERSION;
var _a = require('../util/twilio-video-errors'), createTwilioError = _a.createTwilioError, SignalingConnectionError = _a.SignalingConnectionError;
var events_1 = require("events");
function getTurnCredentials(token, wsServer) {
    return new Promise(function (resolve, reject) {
        var eventObserver = new events_1.EventEmitter();
        var connectionOptions = {
            networkMonitor: null,
            eventObserver: eventObserver,
            helloBody: {
                edge: 'roaming',
                preflight: true,
                token: token,
                type: 'ice',
                version: ICE_VERSION
            },
        };
        var twilioConnection = new TwilioConnection(wsServer, connectionOptions);
        var done = false;
        twilioConnection.once('close', function () {
            if (!done) {
                done = true;
                reject(new SignalingConnectionError());
            }
        });
        twilioConnection.on('message', function (messageData) {
            var code = messageData.code, message = messageData.message, ice_servers = messageData.ice_servers, type = messageData.type;
            if ((type === 'iced' || type === 'error') && !done) {
                done = true;
                if (type === 'iced') {
                    resolve(ice_servers);
                }
                else {
                    reject(createTwilioError(code, message));
                }
                twilioConnection.close();
            }
        });
    });
}
exports.getTurnCredentials = getTurnCredentials;

},{"../twilioconnection.js":121,"../util/constants":126,"../util/twilio-video-errors":148,"events":174}],50:[function(require,module,exports){
"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeStat = void 0;
/**
 * Computes min, max, average for given array.
 * @param {Array<number>} values
 * @returns {{min: number, max: number: average: number}|null}
 */
function makeStat(values) {
    if (values && values.length) {
        var min = Math.min.apply(Math, __spreadArray([], __read(values)));
        var max = Math.max.apply(Math, __spreadArray([], __read(values)));
        var average = values.reduce(function (total, value) { return total + value; }, 0) / values.length;
        return { min: min, max: max, average: average };
    }
    return null;
}
exports.makeStat = makeStat;

},{}],51:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mosToScore = exports.calculateMOS = void 0;
var r0 = 94.768; // Constant used in computing "rFactor".
// copied from https://code.hq.twilio.com/client/sdk-frd/blob/master/voice/voice-mos-calculation.md
function calculateMOS(rtt, jitter, fractionLost) {
    // Compute the effective latency.
    var effectiveLatency = rtt + (jitter * 2) + 10;
    // Compute the initial "rFactor" from effective latency.
    var rFactor = 0;
    switch (true) {
        case effectiveLatency < 160:
            rFactor = r0 - (effectiveLatency / 40);
            break;
        case effectiveLatency < 1000:
            rFactor = r0 - ((effectiveLatency - 120) / 10);
            break;
    }
    // Adjust "rFactor" with the fraction of packets lost.
    switch (true) {
        case fractionLost <= (rFactor / 2.5):
            rFactor = Math.max(rFactor - fractionLost * 2.5, 6.52);
            break;
        default:
            rFactor = 0;
            break;
    }
    // Compute MOS from "rFactor".
    var mos = 1 +
        (0.035 * rFactor) +
        (0.000007 * rFactor) *
            (rFactor - 60) *
            (100 - rFactor);
    return mos;
}
exports.calculateMOS = calculateMOS;
function mosToScore(mosValue) {
    var score = 0;
    if (!mosValue) {
        score = 0;
    }
    else if (mosValue > 4.2) {
        score = 5;
    }
    else if (mosValue > 4.0) {
        score = 4;
    }
    else if (mosValue > 3.6) {
        score = 3;
    }
    else if (mosValue > 3) {
        score = 2;
    }
    else {
        score = 1;
    }
    return score;
}
exports.mosToScore = mosToScore;

},{}],52:[function(require,module,exports){
"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.runPreflight = exports.PreflightTest = void 0;
var constants_1 = require("../util/constants");
var timer_1 = require("./timer");
var mos_1 = require("./mos");
var getCombinedConnectionStats_1 = require("./getCombinedConnectionStats");
var getturncredentials_1 = require("./getturncredentials");
var makestat_1 = require("./makestat");
var syntheticaudio_1 = require("./syntheticaudio");
var syntheticvideo_1 = require("./syntheticvideo");
var index_1 = require("../util/index");
var WS_SERVER = require('../util/constants').WS_SERVER;
var Log = require('../util/log');
var EventEmitter = require('../eventemitter');
var MovingAverageDelta = require('../util/movingaveragedelta');
var EventObserver = require('../util/eventobserver');
var InsightsPublisher = require('../util/insightspublisher');
var _a = require('../util/sid'), createSID = _a.createSID, sessionSID = _a.sessionSID;
var _b = require('../util/twilio-video-errors'), SignalingConnectionTimeoutError = _b.SignalingConnectionTimeoutError, MediaConnectionError = _b.MediaConnectionError;
var SECOND = 1000;
var DEFAULT_TEST_DURATION = 10 * SECOND;
/**
 * progress values that are sent by {@link PreflightTest#event:progress}
 * @enum {string}
 */
var PreflightProgress = {
    /**
     * {@link PreflightTest} has successfully generated synthetic tracks
     */
    mediaAcquired: 'mediaAcquired',
    /**
     * {@link PreflightTest} has successfully connected to twilio server and obtained turn credentials
     */
    connected: 'connected',
    /**
     * SubscriberParticipant successfully subscribed to media tracks.
     */
    mediaSubscribed: 'mediaSubscribed',
    /**
     * Media flow was detected.
     */
    mediaStarted: 'mediaStarted',
    /**
     * Established DTLS connection. This is measured from RTCDtlsTransport `connecting` to `connected` state.
     * On Safari, Support for measuring this is missing, this event will be not be emitted on Safari.
     */
    dtlsConnected: 'dtlsConnected',
    /**
     * Established a PeerConnection, This is measured from PeerConnection `connecting` to `connected` state.
     * On Firefox, Support for measuring this is missing, this event will be not be emitted on Firefox.
     */
    peerConnectionConnected: 'peerConnectionConnected',
    /**
     * Established ICE connection. This is measured from ICE connection `checking` to `connected` state.
     */
    iceConnected: 'iceConnected'
};
function notEmpty(value) {
    return value !== null && typeof value !== 'undefined';
}
var nInstances = 0;
/**
 * A {@link PreflightTest} monitors progress of an ongoing preflight test.
 * <br><br>
 * Instance of {@link PreflightTest} is returned by calling {@link module:twilio-video.runPreflight}
 * @extends EventEmitter
 * @emits PreflightTest#completed
 * @emits PreflightTest#failed
 * @emits PreflightTest#progress
 */
var PreflightTest = /** @class */ (function (_super) {
    __extends(PreflightTest, _super);
    /**
     * Constructs {@link PreflightTest}.
     * @param {string} token
     * @param {?PreflightOptions} [options]
     */
    function PreflightTest(token, options) {
        var _this = _super.call(this) || this;
        _this._testTiming = new timer_1.Timer();
        _this._dtlsTiming = new timer_1.Timer();
        _this._iceTiming = new timer_1.Timer();
        _this._peerConnectionTiming = new timer_1.Timer();
        _this._mediaTiming = new timer_1.Timer();
        _this._connectTiming = new timer_1.Timer();
        _this._sentBytesMovingAverage = new MovingAverageDelta();
        _this._packetLossMovingAverage = new MovingAverageDelta();
        _this._progressEvents = [];
        _this._receivedBytesMovingAverage = new MovingAverageDelta();
        var internalOptions = options;
        var _a = internalOptions.environment, environment = _a === void 0 ? 'prod' : _a, _b = internalOptions.region, region = _b === void 0 ? 'gll' : _b, _c = internalOptions.duration, duration = _c === void 0 ? DEFAULT_TEST_DURATION : _c;
        // eslint-disable-next-line new-cap
        var wsServer = internalOptions.wsServer || WS_SERVER(environment, region);
        _this._log = new Log('default', _this, constants_1.DEFAULT_LOG_LEVEL, constants_1.DEFAULT_LOGGER_NAME);
        _this._testDuration = duration;
        _this._instanceId = nInstances++;
        _this._testTiming.start();
        _this._runPreflightTest(token, environment, wsServer);
        return _this;
    }
    PreflightTest.prototype.toString = function () {
        return "[Preflight #" + this._instanceId + "]";
    };
    /**
     * stops ongoing tests and emits error
     */
    PreflightTest.prototype.stop = function () {
        this._stopped = true;
    };
    PreflightTest.prototype._generatePreflightReport = function (collectedStats) {
        this._testTiming.stop();
        return {
            testTiming: this._testTiming.getTimeMeasurement(),
            networkTiming: {
                dtls: this._dtlsTiming.getTimeMeasurement(),
                ice: this._iceTiming.getTimeMeasurement(),
                peerConnection: this._peerConnectionTiming.getTimeMeasurement(),
                connect: this._connectTiming.getTimeMeasurement(),
                media: this._mediaTiming.getTimeMeasurement()
            },
            stats: {
                jitter: makestat_1.makeStat(collectedStats === null || collectedStats === void 0 ? void 0 : collectedStats.jitter),
                rtt: makestat_1.makeStat(collectedStats === null || collectedStats === void 0 ? void 0 : collectedStats.rtt),
                packetLoss: makestat_1.makeStat(collectedStats === null || collectedStats === void 0 ? void 0 : collectedStats.packetLoss),
            },
            selectedIceCandidatePairStats: collectedStats ? collectedStats.selectedIceCandidatePairStats : null,
            iceCandidateStats: collectedStats ? collectedStats.iceCandidateStats : [],
            progressEvents: this._progressEvents,
            // NOTE(mpatwardhan): internal properties.
            mos: makestat_1.makeStat(collectedStats === null || collectedStats === void 0 ? void 0 : collectedStats.mos),
        };
    };
    PreflightTest.prototype._executePreflightStep = function (stepName, step, timeoutError) {
        return __awaiter(this, void 0, void 0, function () {
            var MAX_STEP_DURATION, stepPromise, timer, timeoutPromise, result;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this._log.debug('Executing step: ', stepName);
                        MAX_STEP_DURATION = this._testDuration + 10 * SECOND;
                        if (this._stopped) {
                            throw new Error('stopped');
                        }
                        stepPromise = Promise.resolve().then(step);
                        timer = null;
                        timeoutPromise = new Promise(function (_resolve, reject) {
                            timer = setTimeout(function () {
                                reject(timeoutError || new Error(stepName + " timeout."));
                            }, MAX_STEP_DURATION);
                        });
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, , 3, 4]);
                        return [4 /*yield*/, Promise.race([timeoutPromise, stepPromise])];
                    case 2:
                        result = _a.sent();
                        return [2 /*return*/, result];
                    case 3:
                        if (timer !== null) {
                            clearTimeout(timer);
                        }
                        return [7 /*endfinally*/];
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    PreflightTest.prototype._collectNetworkTimings = function (pc) {
        var _this = this;
        return new Promise(function (resolve) {
            var dtlsTransport;
            pc.addEventListener('iceconnectionstatechange', function () {
                if (pc.iceConnectionState === 'checking') {
                    _this._iceTiming.start();
                }
                if (pc.iceConnectionState === 'connected') {
                    _this._iceTiming.stop();
                    _this._updateProgress(PreflightProgress.iceConnected);
                    if (!dtlsTransport || dtlsTransport && dtlsTransport.state === 'connected') {
                        resolve();
                    }
                }
            });
            // firefox does not support connectionstatechange.
            pc.addEventListener('connectionstatechange', function () {
                if (pc.connectionState === 'connecting') {
                    _this._peerConnectionTiming.start();
                }
                if (pc.connectionState === 'connected') {
                    _this._peerConnectionTiming.stop();
                    _this._updateProgress(PreflightProgress.peerConnectionConnected);
                }
            });
            // Safari does not expose sender.transport.
            var senders = pc.getSenders();
            var transport = senders.map(function (sender) { return sender.transport; }).find(notEmpty);
            if (typeof transport !== 'undefined') {
                dtlsTransport = transport;
                dtlsTransport.addEventListener('statechange', function () {
                    if (dtlsTransport.state === 'connecting') {
                        _this._dtlsTiming.start();
                    }
                    if (dtlsTransport.state === 'connected') {
                        _this._dtlsTiming.stop();
                        _this._updateProgress(PreflightProgress.dtlsConnected);
                        if (pc.iceConnectionState === 'connected') {
                            resolve();
                        }
                    }
                });
            }
        });
    };
    PreflightTest.prototype._setupInsights = function (_a) {
        var token = _a.token, _b = _a.environment, environment = _b === void 0 ? constants_1.DEFAULT_ENVIRONMENT : _b, _c = _a.realm, realm = _c === void 0 ? constants_1.DEFAULT_REALM : _c;
        var eventPublisherOptions = {};
        var eventPublisher = new InsightsPublisher(token, constants_1.SDK_NAME, constants_1.SDK_VERSION, environment, realm, eventPublisherOptions);
        // event publisher requires room sid/participant sid. supply fake ones.
        eventPublisher.connect('PREFLIGHT_ROOM_SID', 'PREFLIGHT_PARTICIPANT');
        var eventObserver = new EventObserver(eventPublisher, Date.now(), this._log);
        // eslint-disable-next-line no-undefined
        var undefinedValue = undefined;
        return {
            reportToInsights: function (_a) {
                var _b, _c;
                var report = _a.report;
                var jitterStats = report.stats.jitter || undefinedValue;
                var rttStats = report.stats.rtt || undefinedValue;
                var packetLossStats = report.stats.packetLoss || undefinedValue;
                var mosStats = report.mos || undefinedValue;
                // stringify important info from ice candidates.
                var candidateTypeToProtocols = new Map();
                report.iceCandidateStats.forEach(function (candidateStats) {
                    if (candidateStats.candidateType && candidateStats.protocol) {
                        var protocols = candidateTypeToProtocols.get(candidateStats.candidateType) || [];
                        if (protocols.indexOf(candidateStats.protocol) < 0) {
                            protocols.push(candidateStats.protocol);
                        }
                        candidateTypeToProtocols.set(candidateStats.candidateType, protocols);
                    }
                });
                var iceCandidateStats = JSON.stringify(Object.fromEntries(candidateTypeToProtocols));
                var insightsReport = {
                    name: 'report',
                    group: 'preflight',
                    level: report.error ? 'error' : 'info',
                    payload: {
                        sessionSID: sessionSID,
                        preflightSID: createSID('PF'),
                        progressEvents: JSON.stringify(report.progressEvents),
                        testTiming: report.testTiming,
                        dtlsTiming: report.networkTiming.dtls,
                        iceTiming: report.networkTiming.ice,
                        peerConnectionTiming: report.networkTiming.peerConnection,
                        connectTiming: report.networkTiming.connect,
                        mediaTiming: report.networkTiming.media,
                        selectedLocalCandidate: (_b = report.selectedIceCandidatePairStats) === null || _b === void 0 ? void 0 : _b.localCandidate,
                        selectedRemoteCandidate: (_c = report.selectedIceCandidatePairStats) === null || _c === void 0 ? void 0 : _c.remoteCandidate,
                        iceCandidateStats: iceCandidateStats,
                        jitterStats: jitterStats,
                        rttStats: rttStats,
                        packetLossStats: packetLossStats,
                        mosStats: mosStats,
                        error: report.error
                    }
                };
                eventObserver.emit('event', insightsReport);
                setTimeout(function () { return eventPublisher.disconnect(); }, 2000);
            }
        };
    };
    PreflightTest.prototype._runPreflightTest = function (token, environment, wsServer) {
        return __awaiter(this, void 0, void 0, function () {
            var localTracks, pcs, reportToInsights, elements_1, iceServers, senderPC_1, receiverPC_1, remoteTracks_1, collectedStats_1, report, error_1, preflightReport;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        localTracks = [];
                        pcs = [];
                        reportToInsights = this._setupInsights({ token: token, environment: environment }).reportToInsights;
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 8, 9, 10]);
                        elements_1 = [];
                        return [4 /*yield*/, this._executePreflightStep('Acquire media', function () { return [syntheticaudio_1.syntheticAudio(), syntheticvideo_1.syntheticVideo({ width: 640, height: 480 })]; })];
                    case 2:
                        localTracks = _a.sent();
                        this._updateProgress(PreflightProgress.mediaAcquired);
                        this.emit('debug', { localTracks: localTracks });
                        this._connectTiming.start();
                        return [4 /*yield*/, this._executePreflightStep('Get turn credentials', function () { return getturncredentials_1.getTurnCredentials(token, wsServer); }, new SignalingConnectionTimeoutError())];
                    case 3:
                        iceServers = _a.sent();
                        this._connectTiming.stop();
                        this._updateProgress(PreflightProgress.connected);
                        senderPC_1 = new RTCPeerConnection({ iceServers: iceServers, iceTransportPolicy: 'relay', bundlePolicy: 'max-bundle' });
                        receiverPC_1 = new RTCPeerConnection({ iceServers: iceServers, bundlePolicy: 'max-bundle' });
                        pcs.push(senderPC_1);
                        pcs.push(receiverPC_1);
                        this._mediaTiming.start();
                        return [4 /*yield*/, this._executePreflightStep('Setup Peer Connections', function () { return __awaiter(_this, void 0, void 0, function () {
                                var remoteTracksPromise, offer, updatedOffer, answer;
                                return __generator(this, function (_a) {
                                    switch (_a.label) {
                                        case 0:
                                            senderPC_1.addEventListener('icecandidate', function (event) { return event.candidate && receiverPC_1.addIceCandidate(event.candidate); });
                                            receiverPC_1.addEventListener('icecandidate', function (event) { return event.candidate && senderPC_1.addIceCandidate(event.candidate); });
                                            localTracks.forEach(function (track) { return senderPC_1.addTrack(track); });
                                            remoteTracksPromise = new Promise(function (resolve) {
                                                var remoteTracks = [];
                                                receiverPC_1.addEventListener('track', function (event) {
                                                    remoteTracks.push(event.track);
                                                    if (remoteTracks.length === localTracks.length) {
                                                        resolve(remoteTracks);
                                                    }
                                                });
                                            });
                                            return [4 /*yield*/, senderPC_1.createOffer()];
                                        case 1:
                                            offer = _a.sent();
                                            updatedOffer = offer;
                                            return [4 /*yield*/, senderPC_1.setLocalDescription(updatedOffer)];
                                        case 2:
                                            _a.sent();
                                            return [4 /*yield*/, receiverPC_1.setRemoteDescription(updatedOffer)];
                                        case 3:
                                            _a.sent();
                                            return [4 /*yield*/, receiverPC_1.createAnswer()];
                                        case 4:
                                            answer = _a.sent();
                                            return [4 /*yield*/, receiverPC_1.setLocalDescription(answer)];
                                        case 5:
                                            _a.sent();
                                            return [4 /*yield*/, senderPC_1.setRemoteDescription(answer)];
                                        case 6:
                                            _a.sent();
                                            return [4 /*yield*/, this._collectNetworkTimings(senderPC_1)];
                                        case 7:
                                            _a.sent();
                                            return [2 /*return*/, remoteTracksPromise];
                                    }
                                });
                            }); }, new MediaConnectionError())];
                    case 4:
                        remoteTracks_1 = _a.sent();
                        this.emit('debug', { remoteTracks: remoteTracks_1 });
                        remoteTracks_1.forEach(function (track) {
                            track.addEventListener('ended', function () { return _this._log.warn(track.kind + ':ended'); });
                            track.addEventListener('mute', function () { return _this._log.warn(track.kind + ':muted'); });
                            track.addEventListener('unmute', function () { return _this._log.warn(track.kind + ':unmuted'); });
                        });
                        this._updateProgress(PreflightProgress.mediaSubscribed);
                        return [4 /*yield*/, this._executePreflightStep('Wait for tracks to start', function () {
                                return new Promise(function (resolve) {
                                    var element = document.createElement('video');
                                    element.autoplay = true;
                                    element.playsInline = true;
                                    element.muted = true;
                                    element.srcObject = new MediaStream(remoteTracks_1);
                                    elements_1.push(element);
                                    _this.emit('debugElement', element);
                                    element.oncanplay = resolve;
                                });
                            }, new MediaConnectionError())];
                    case 5:
                        _a.sent();
                        this._mediaTiming.stop();
                        this._updateProgress(PreflightProgress.mediaStarted);
                        return [4 /*yield*/, this._executePreflightStep('Collect stats for duration', function () { return _this._collectRTCStatsForDuration(_this._testDuration, initCollectedStats(), senderPC_1, receiverPC_1); })];
                    case 6:
                        collectedStats_1 = _a.sent();
                        return [4 /*yield*/, this._executePreflightStep('Generate report', function () { return _this._generatePreflightReport(collectedStats_1); })];
                    case 7:
                        report = _a.sent();
                        reportToInsights({ report: report });
                        this.emit('completed', report);
                        return [3 /*break*/, 10];
                    case 8:
                        error_1 = _a.sent();
                        preflightReport = this._generatePreflightReport();
                        reportToInsights({ report: __assign(__assign({}, preflightReport), { error: error_1 === null || error_1 === void 0 ? void 0 : error_1.toString() }) });
                        this.emit('failed', error_1, preflightReport);
                        return [3 /*break*/, 10];
                    case 9:
                        pcs.forEach(function (pc) { return pc.close(); });
                        localTracks.forEach(function (track) { return track.stop(); });
                        return [7 /*endfinally*/];
                    case 10: return [2 /*return*/];
                }
            });
        });
    };
    PreflightTest.prototype._collectRTCStats = function (collectedStats, senderPC, receiverPC) {
        return __awaiter(this, void 0, void 0, function () {
            var combinedStats, timestamp, bytesSent, bytesReceived, packets, packetsLost, roundTripTime, jitter, selectedIceCandidatePairStats, iceCandidateStats, hasLastData, fractionPacketLost, percentPacketsLost, score;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, getCombinedConnectionStats_1.getCombinedConnectionStats({ publisher: senderPC, subscriber: receiverPC })];
                    case 1:
                        combinedStats = _a.sent();
                        timestamp = combinedStats.timestamp, bytesSent = combinedStats.bytesSent, bytesReceived = combinedStats.bytesReceived, packets = combinedStats.packets, packetsLost = combinedStats.packetsLost, roundTripTime = combinedStats.roundTripTime, jitter = combinedStats.jitter, selectedIceCandidatePairStats = combinedStats.selectedIceCandidatePairStats, iceCandidateStats = combinedStats.iceCandidateStats;
                        hasLastData = collectedStats.jitter.length > 0;
                        collectedStats.jitter.push(jitter);
                        collectedStats.rtt.push(roundTripTime);
                        this._sentBytesMovingAverage.putSample(bytesSent, timestamp);
                        this._receivedBytesMovingAverage.putSample(bytesReceived, timestamp);
                        this._packetLossMovingAverage.putSample(packetsLost, packets);
                        if (hasLastData) {
                            // convert BytesMovingAverage which is in bytes/millisecond to bits/second
                            collectedStats.outgoingBitrate.push(this._sentBytesMovingAverage.get() * 1000 * 8);
                            collectedStats.incomingBitrate.push(this._receivedBytesMovingAverage.get() * 1000 * 8);
                            fractionPacketLost = this._packetLossMovingAverage.get();
                            percentPacketsLost = Math.min(100, fractionPacketLost * 100);
                            collectedStats.packetLoss.push(percentPacketsLost);
                            score = mos_1.calculateMOS(roundTripTime, jitter, fractionPacketLost);
                            collectedStats.mos.push(score);
                        }
                        if (!collectedStats.selectedIceCandidatePairStats) {
                            collectedStats.selectedIceCandidatePairStats = selectedIceCandidatePairStats;
                        }
                        if (collectedStats.iceCandidateStats.length === 0) {
                            collectedStats.iceCandidateStats = iceCandidateStats;
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    PreflightTest.prototype._collectRTCStatsForDuration = function (duration, collectedStats, senderPC, receiverPC) {
        return __awaiter(this, void 0, void 0, function () {
            var startTime, STAT_INTERVAL, remainingDuration;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        startTime = Date.now();
                        STAT_INTERVAL = Math.min(1000, duration);
                        return [4 /*yield*/, index_1.waitForSometime(STAT_INTERVAL)];
                    case 1:
                        _a.sent();
                        return [4 /*yield*/, this._collectRTCStats(collectedStats, senderPC, receiverPC)];
                    case 2:
                        _a.sent();
                        remainingDuration = duration - (Date.now() - startTime);
                        if (!(remainingDuration > 0)) return [3 /*break*/, 4];
                        return [4 /*yield*/, this._collectRTCStatsForDuration(remainingDuration, collectedStats, senderPC, receiverPC)];
                    case 3:
                        collectedStats = _a.sent();
                        _a.label = 4;
                    case 4: return [2 /*return*/, collectedStats];
                }
            });
        });
    };
    PreflightTest.prototype._updateProgress = function (name) {
        var duration = Date.now() - this._testTiming.getTimeMeasurement().start;
        this._progressEvents.push({ duration: duration, name: name });
        this.emit('progress', name);
    };
    return PreflightTest;
}(EventEmitter));
exports.PreflightTest = PreflightTest;
function initCollectedStats() {
    return {
        mos: [],
        jitter: [],
        rtt: [],
        outgoingBitrate: [],
        incomingBitrate: [],
        packetLoss: [],
        selectedIceCandidatePairStats: null,
        iceCandidateStats: [],
    };
}
/**
 * Represents network timing measurements captured during preflight test
 * @typedef {object} NetworkTiming
 * @property {TimeMeasurement} [connect] - Time to establish signaling connection and acquire turn credentials
 * @property {TimeMeasurement} [media] - Time to start media. This is measured from calling connect to remote media getting started.
 * @property {TimeMeasurement} [dtls] - Time to establish dtls connection. This is measured from RTCDtlsTransport `connecting` to `connected` state. (Not available on Safari)
 * @property {TimeMeasurement} [ice] - Time to establish ice connectivity. This is measured from ICE connection `checking` to `connected` state.
 * @property {TimeMeasurement} [peerConnection] - Time to establish peer connectivity. This is measured from PeerConnection `connecting` to `connected` state. (Not available on Firefox)
 */
/**
 * Represents stats for a numerical metric.
 * @typedef {object} Stats
 * @property  {number} [average] - Average value observed.
 * @property  {number} [max] - Max value observed.
 * @property  {number} [min] - Min value observed.
 */
/**
 * Represents stats for a numerical metric.
 * @typedef {object} SelectedIceCandidatePairStats
 * @property  {RTCIceCandidateStats} [localCandidate] - Selected local ice candidate
 * @property  {RTCIceCandidateStats} [remoteCandidate] - Selected local ice candidate
 */
/**
 * Represents RTC related stats that were observed during preflight test
 * @typedef {object} PreflightReportStats
 * @property {Stats} [jitter] - Packet delay variation in seconds
 * @property {Stats} [rtt] - Round trip time, to the server back to the client in milliseconds.
 * @property {Stats} [packetLoss] - Packet loss as a percent of total packets sent.
*/
/**
 * A {@link PreflightProgress} event with timing information.
 * @typedef {object} ProgressEvent
 * @property {number} [duration] - The duration of the event, measured from the start of the test.
 * @property {string} [name] - The {@link PreflightProgress} event name.
 */
/**
 * Represents report generated by {@link PreflightTest}.
 * @typedef {object} PreflightTestReport
 * @property {TimeMeasurement} [testTiming] - Time measurements of test run time.
 * @property {NetworkTiming} [networkTiming] - Network related time measurements.
 * @property {PreflightReportStats} [stats] - RTC related stats captured during the test.
 * @property {Array<RTCIceCandidateStats>} [iceCandidateStats] - List of gathered ice candidates.
 * @property {SelectedIceCandidatePairStats} selectedIceCandidatePairStats - Stats for the ice candidates that were used for the connection.
 * @property {Array<ProgressEvent>} [progressEvents] - {@link ProgressEvent} events detected during the test.
 * Use this information to determine which steps were completed and which ones were not.
 */
/**
 * You may pass these options to {@link module:twilio-video.testPreflight} in order to override the
 * default behavior.
 * @typedef {object} PreflightOptions
 * @property {string} [region='gll'] - Preferred signaling region; By default, you will be connected to the
 *   nearest signaling server determined by latency based routing. Setting a value other
 *   than <code style="padding:0 0">gll</code> bypasses routing and guarantees that signaling traffic will be
 *   terminated in the region that you prefer. Please refer to this <a href="https://www.twilio.com/docs/video/ip-address-whitelisting#signaling-communication" target="_blank">table</a>
 *   for the list of supported signaling regions.
 * @property {number} [duration=10000] - number of milliseconds to run test for.
 *   once connected test will run for this duration before generating the stats report.
 */
/**
 * Preflight test has completed successfully.
 * @param {PreflightTestReport} report - Results of the test.
 * @event PreflightTest#completed
 */
/**
 * Preflight test has encountered a failure and is now stopped.
 * @param {TwilioError|Error} error - A TwilioError or a DOMException.
 * Possible TwilioErrors include Signaling and Media related errors which can be found
 * <a href="https://www.twilio.com/docs/video/build-js-video-application-recommendations-and-best-practices#connection-errors" target="_blank">here</a>.
 * @param {PreflightTestReport} report - Partial results gathered during the test. Use this information to help determine the cause of failure.
 * @event PreflightTest#failed
 */
/**
 * Emitted to indicate progress of the test
 * @param {PreflightProgress} progress - Indicates the status completed.
 * @event PreflightTest#progress
 */
/**
 * @method
 * @name runPreflight
 * @description Run a preflight test. This method will start a test to check the quality of network connection.
 * @memberof module:twilio-video
 * @param {string} token - The Access Token string
 * @param {PreflightOptions} options - Options for the test
 * @returns {PreflightTest} preflightTest - An instance to be used to monitor progress of the test.
 * @example
 * var { runPreflight } = require('twilio-video');
 * var preflight = runPreflight(token, preflightOptions);
 * preflightTest.on('progress', progress => {
 *   console.log('preflight progress:', progress);
 * });
 *
 * preflightTest.on('failed', (error, report) => {
 *   console.error('preflight error:', error, report);
 * });
 *
 * preflightTest.on('completed', report => {
 *   console.log('preflight completed:', report));
 * });
*/
function runPreflight(token, options) {
    if (options === void 0) { options = {}; }
    var preflight = new PreflightTest(token, options);
    return preflight;
}
exports.runPreflight = runPreflight;

},{"../eventemitter":10,"../util/constants":126,"../util/eventobserver":131,"../util/index":133,"../util/insightspublisher":134,"../util/log":137,"../util/movingaveragedelta":138,"../util/sid":145,"../util/twilio-video-errors":148,"./getCombinedConnectionStats":48,"./getturncredentials":49,"./makestat":50,"./mos":51,"./syntheticaudio":53,"./syntheticvideo":54,"./timer":55}],53:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.syntheticAudio = void 0;
function syntheticAudio() {
    // NOTE(mpatwardhan): We have to delay require-ing AudioContextFactory, because
    // it exports a default instance whose constructor calls Object.assign.
    var audioContextFactory = require('../webaudio/audiocontext');
    var holder = {};
    var audioContext = audioContextFactory.getOrCreate(holder);
    var oscillator = audioContext.createOscillator();
    var dst = oscillator.connect(audioContext.createMediaStreamDestination());
    oscillator.start();
    var track = dst.stream.getAudioTracks()[0];
    var originalStop = track.stop;
    track.stop = function () {
        originalStop.call(track);
        audioContextFactory.release(holder);
    };
    return track;
}
exports.syntheticAudio = syntheticAudio;

},{"../webaudio/audiocontext":154}],54:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.syntheticVideo = void 0;
function syntheticVideo(_a) {
    var _b = _a === void 0 ? {} : _a, _c = _b.width, width = _c === void 0 ? 640 : _c, _d = _b.height, height = _d === void 0 ? 480 : _d;
    var canvas = Object.assign(document.createElement('canvas'), { width: width, height: height });
    var ctx = canvas.getContext('2d');
    ctx.fillStyle = 'green';
    ctx.fillRect(0, 0, canvas.width, canvas.height);
    var stopped = false;
    requestAnimationFrame(function animate() {
        if (!stopped) {
            // draw random rect/circle.
            var r = Math.round(Math.random() * 255);
            var g = Math.round(Math.random() * 255);
            var b = Math.round(Math.random() * 255);
            var a = Math.round(Math.random() * 255);
            ctx.fillStyle = "rgba(" + r + ", " + g + ", " + b + ", " + a + ")";
            ctx.fillRect(Math.random() * width, Math.random() * height, 50, 50);
            requestAnimationFrame(animate);
        }
    });
    var stream = canvas.captureStream(30);
    var track = stream.getTracks()[0];
    var originalStop = track.stop;
    track.stop = function () {
        stopped = true;
        originalStop.call(track);
    };
    return track;
}
exports.syntheticVideo = syntheticVideo;

},{}],55:[function(require,module,exports){
"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Timer = void 0;
var Timer = /** @class */ (function () {
    function Timer() {
        // eslint-disable-next-line no-undefined
        this._end = undefined;
        this.start();
    }
    Timer.prototype.start = function () {
        this._start = Date.now();
        return this;
    };
    Timer.prototype.stop = function () {
        this._end = Date.now();
        return this;
    };
    Timer.prototype.getTimeMeasurement = function () {
        return {
            start: this._start,
            end: this._end,
            // eslint-disable-next-line no-undefined
            duration: this._end === undefined ? undefined : this._end - this._start
        };
    };
    return Timer;
}());
exports.Timer = Timer;

},{}],56:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var EventEmitter = require('events').EventEmitter;
/**
 * A {@link QueueingEventEmitter} can queue events until a listener has been
 * added.
 * @extends EventEmitter
 */
var QueueingEventEmitter = /** @class */ (function (_super) {
    __extends(QueueingEventEmitter, _super);
    /**
     * Construct a {@link QueueingEventEmitter}
     */
    function QueueingEventEmitter() {
        var _this = _super.call(this) || this;
        Object.defineProperties(_this, {
            _queuedEvents: {
                value: new Map()
            }
        });
        return _this;
    }
    /**
     * Emit any queued events.
     * @returns {boolean} true if every event had listeners, false otherwise
    */ /**
     * Emit any queued events matching the event name.
     * @param {string} event
     * @returns {boolean} true if every event had listeners, false otherwise
     */
    QueueingEventEmitter.prototype.dequeue = function (event) {
        var _this = this;
        var result = true;
        if (!event) {
            this._queuedEvents.forEach(function (_, queuedEvent) {
                result = this.dequeue(queuedEvent) && result;
            }, this);
            return result;
        }
        var queue = this._queuedEvents.get(event) || [];
        this._queuedEvents.delete(event);
        return queue.reduce(function (result, args) { return _this.emit.apply(_this, __spreadArray([], __read([event].concat(args)))) && result; }, result);
    };
    /**
     * If the event has listeners, emit the event; otherwise, queue the event.
     * @param {string} event
     * @param {...*} args
     * @returns {boolean} true if the event had listeners, false if the event was queued
     */
    QueueingEventEmitter.prototype.queue = function () {
        var args = [].slice.call(arguments);
        if (this.emit.apply(this, __spreadArray([], __read(args)))) {
            return true;
        }
        var event = args[0];
        if (!this._queuedEvents.has(event)) {
            this._queuedEvents.set(event, []);
        }
        this._queuedEvents.get(event).push(args.slice(1));
        return false;
    };
    return QueueingEventEmitter;
}(EventEmitter));
module.exports = QueueingEventEmitter;

},{"events":174}],57:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var Participant = require('./participant');
/**
 * A {@link RemoteParticipant} represents a remote {@link Participant} in a
 * {@link Room}.
 * @extends Participant
 * @property {Map<Track.SID, RemoteAudioTrackPublication>} audioTracks -
 *    The {@link Participant}'s {@link RemoteAudioTrackPublication}s
 * @property {Map<Track.SID, RemoteDataTrackPublication>} dataTracks -
 *    The {@link Participant}'s {@link RemoteDataTrackPublication}s
 * @property {Map<Track.SID, RemoteTrackPublication>} tracks -
 *    The {@link Participant}'s {@link RemoteTrackPublication}s
 * @property {Map<Track.SID, RemoteVideoTrackPublication>} videoTracks -
 *    The {@link Participant}'s {@link RemoteVideoTrackPublication}s
 * @emits RemoteParticipant#reconnected
 * @emits RemoteParticipant#reconnecting
 * @emits RemoteParticipant#trackDimensionsChanged
 * @emits RemoteParticipant#trackDisabled
 * @emits RemoteParticipant#trackEnabled
 * @emits RemoteParticipant#trackMessage
 * @emits RemoteParticipant#trackPublished
 * @emits RemoteParticipant#trackPublishPriorityChanged
 * @emits RemoteParticipant#trackStarted
 * @emits RemoteParticipant#trackSubscribed
 * @emits RemoteParticipant#trackSubscriptionFailed
 * @emits RemoteParticipant#trackSwitchedOff
 * @emits RemoteParticipant#trackSwitchedOn
 * @emits RemoteParticipant#trackUnpublished
 * @emits RemoteParticipant#trackUnsubscribed
 */
var RemoteParticipant = /** @class */ (function (_super) {
    __extends(RemoteParticipant, _super);
    /**
     * Construct a {@link RemoteParticipant}.
     * @param {ParticipantSignaling} signaling
     * @param {object} [options]
     */
    function RemoteParticipant(signaling, options) {
        var _this = _super.call(this, signaling, options) || this;
        _this._handleTrackSignalingEvents();
        _this.once('disconnected', _this._unsubscribeTracks.bind(_this));
        return _this;
    }
    RemoteParticipant.prototype.toString = function () {
        return "[RemoteParticipant #" + this._instanceId + (this.sid ? ": " + this.sid : '') + "]";
    };
    /**
     * @private
     * @param {RemoteTrack} remoteTrack
     * @param {RemoteTrackPublication} publication
     * @param {Track.ID} id
     * @returns {?RemoteTrack}
     */
    RemoteParticipant.prototype._addTrack = function (remoteTrack, publication, id) {
        if (!_super.prototype._addTrack.call(this, remoteTrack, id)) {
            return null;
        }
        publication._subscribed(remoteTrack);
        this.emit('trackSubscribed', remoteTrack, publication);
        return remoteTrack;
    };
    /**
     * @private
     * @param {RemoteTrackPublication} publication
     * @returns {?RemoteTrackPublication}
     */
    RemoteParticipant.prototype._addTrackPublication = function (publication) {
        var addedPublication = _super.prototype._addTrackPublication.call(this, publication);
        if (!addedPublication) {
            return null;
        }
        this.emit('trackPublished', addedPublication);
        return addedPublication;
    };
    /**
     * @private
     */
    RemoteParticipant.prototype._getTrackPublicationEvents = function () {
        return __spreadArray(__spreadArray([], __read(_super.prototype._getTrackPublicationEvents.call(this))), [
            ['subscriptionFailed', 'trackSubscriptionFailed'],
            ['trackDisabled', 'trackDisabled'],
            ['trackEnabled', 'trackEnabled'],
            ['publishPriorityChanged', 'trackPublishPriorityChanged'],
            ['trackSwitchedOff', 'trackSwitchedOff'],
            ['trackSwitchedOn', 'trackSwitchedOn']
        ]);
    };
    /**
     * @private
     */
    RemoteParticipant.prototype._unsubscribeTracks = function () {
        var _this = this;
        this.tracks.forEach(function (publication) {
            if (publication.isSubscribed) {
                var track = publication.track;
                publication._unsubscribe();
                _this.emit('trackUnsubscribed', track, publication);
            }
        });
    };
    /**
     * @private
     * @param {RemoteTrack} remoteTrack
     * @param {RemoteTrackPublication} publication
     * @param {Track.ID} id
     * @returns {?RemoteTrack}
     */
    RemoteParticipant.prototype._removeTrack = function (remoteTrack, publication, id) {
        var unsubscribedTrack = this._tracks.get(id);
        if (!unsubscribedTrack) {
            return null;
        }
        _super.prototype._removeTrack.call(this, unsubscribedTrack, id);
        publication._unsubscribe();
        this.emit('trackUnsubscribed', unsubscribedTrack, publication);
        return unsubscribedTrack;
    };
    /**
     * @private
     * @param {RemoteTrackPublication} publication
     * @returns {?RemoteTrackPublication}
     */
    RemoteParticipant.prototype._removeTrackPublication = function (publication) {
        this._signaling.clearTrackHint(publication.trackSid);
        var removedPublication = _super.prototype._removeTrackPublication.call(this, publication);
        if (!removedPublication) {
            return null;
        }
        this.emit('trackUnpublished', removedPublication);
        return removedPublication;
    };
    return RemoteParticipant;
}(Participant));
/**
 * The {@link RemoteParticipant} has reconnected to the {@link Room} after a signaling connection disruption.
 * @event RemoteParticipant#reconnected
 */
/**
 * The {@link RemoteParticipant} is reconnecting to the {@link Room} after a signaling connection disruption.
 * @event RemoteParticipant#reconnecting
 */
/**
 * One of the {@link RemoteParticipant}'s {@link RemoteVideoTrack}'s dimensions changed.
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} whose dimensions changed
 * @event RemoteParticipant#trackDimensionsChanged
 */
/**
 * A {@link RemoteTrack} was disabled by the {@link RemoteParticipant}.
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication} associated with the disabled {@link RemoteTrack}
 * @event RemoteParticipant#trackDisabled
 */
/**
 * A {@link RemoteTrack} was enabled by the {@link RemoteParticipant}.
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication} associated with the enabled {@link RemoteTrack}
 * @event RemoteParticipant#trackEnabled
 */
/**
 * A message was received over one of the {@link RemoteParticipant}'s
 * {@link RemoteDataTrack}s.
 * @event RemoteParticipant#trackMessage
 * @param {string|ArrayBuffer} data
 * @param {RemoteDataTrack} track - The {@link RemoteDataTrack} over which the
 *   message was received
 */
/**
 * A {@link RemoteTrack} was published by the {@link RemoteParticipant} after
 * connecting to the {@link Room}. This event is not emitted for
 * {@link RemoteTrack}s that were published while the {@link RemoteParticipant}
 * was connecting to the {@link Room}.
 * @event RemoteParticipant#trackPublished
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   which represents the published {@link RemoteTrack}
 * @example
 * function trackPublished(publication) {
 *   console.log(`Track ${publication.trackSid} was published`);
 * }
 *
 * room.on('participantConnected', participant => {
 *   // Handle RemoteTracks published while connecting to the Room.
 *   participant.trackPublications.forEach(trackPublished);
 *
 *   // Handle RemoteTracks published after connecting to the Room.
 *   participant.on('trackPublished', trackPublished);
 * });
 */
/**
 * One of the {@link RemoteParticipant}'s {@link RemoteTrack}s started.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that started
 * @event RemoteParticipant#trackStarted
 */
/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was subscribed to.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was subscribed to
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was subscribed to
 * @event RemoteParticipant#trackSubscribed
 */
/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} could not be subscribed to.
 * @param {TwilioError} error - The reason the {@link RemoteTrack} could not be
 *   subscribed to
 * @param {RemoteTrackPublication} publication - The
 *   {@link RemoteTrackPublication} for the {@link RemoteTrack} that could not
 *   be subscribed to
 * @event RemoteParticipant#trackSubscriptionFailed
 */
/**
 * The {@link RemoteTrackPublication}'s publish {@link Track.Priority} was changed by the
 * {@link RemoteParticipant}.
 * @param {Track.Priority} priority - the {@link RemoteTrack}'s new publish
 *   {@link Track.Priority};
 * @param {RemoteTrackPublication} publication - The
 *   {@link RemoteTrackPublication} for the {@link RemoteTrack} that changed priority
 * @event RemoteParticipant#trackPublishPriorityChanged
 */
/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was subscribed to.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was switched off
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was switched off
 * @event RemoteParticipant#trackSwitchedOff
 */
/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was switched on.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was switched on.
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was switched on
 * @event RemoteParticipant#trackSwitchedOn
 */
/**
 * A {@link RemoteTrack} was unpublished by the {@link RemoteParticipant}.
 * @event RemoteParticipant#trackUnpublished
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   which represents the unpublished {@link RemoteTrack}
 */
/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was unsubscribed from.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was unsubscribed from
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was unsubscribed from
 * @event RemoteParticipant#trackUnsubscribed
 */
module.exports = RemoteParticipant;

},{"./participant":47}],58:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var EventEmitter = require('./eventemitter');
var RemoteParticipant = require('./remoteparticipant');
var StatsReport = require('./stats/statsreport');
var _a = require('./util'), flatMap = _a.flatMap, valueToJSON = _a.valueToJSON;
var nInstances = 0;
/**
 * A {@link Room} represents communication between you and one or more
 * {@link RemoteParticipant}s sharing {@link AudioTrack}s and
 * {@link VideoTrack}s.
 * <br><br>
 * You can connect to a {@link Room} by calling {@link module:twilio-video.connect}.
 * @extends EventEmitter
 * @property {?RemoteParticipant} dominantSpeaker - The Dominant Speaker in the
 *   {@link Room}, if any
 * @property {boolean} isRecording - Whether or not the {@link Room} is being
 *   recorded
 * @property {LocalParticipant} localParticipant - Your {@link LocalParticipant}
 *   in the {@link Room}
 * @property {string} mediaRegion - String indicating geographical region
 *    where  media is processed for the {@link Room}.
 * @property {string} name - The {@link Room}'s name
 * @property {Map<Participant.SID, RemoteParticipant>} participants -
 *   The {@link RemoteParticipant}s participating in this {@link Room}
 * @property {Room.SID} sid - The {@link Room}'s SID
 * @property {string} state - "connected", "reconnecting", or "disconnected"
 * @throws {SignalingConnectionDisconnectedError}
 * @emits Room#disconnected
 * @emits Room#participantConnected
 * @emits Room#participantDisconnected
 * @emits Room#participantReconnected
 * @emits Room#participantReconnecting
 * @emits Room#reconnected
 * @emits Room#reconnecting
 * @emits Room#recordingStarted
 * @emits Room#recordingStopped
 * @emits Room#trackDimensionsChanged
 * @emits Room#trackDisabled
 * @emits Room#trackEnabled
 * @emits Room#trackMessage
 * @emits Room#trackPublished
 * @emits Room#trackPublishPriorityChanged
 * @emits Room#trackStarted
 * @emits Room#trackSubscribed
 * @emits Room#trackSwitchedOff
 * @emits Room#trackSwitchedOn
 * @emits Room#trackUnpublished
 * @emits Room#trackUnsubscribed
 * @emits Room#trackWarning
 * @emits Room#trackWarningsCleared
 */
var Room = /** @class */ (function (_super) {
    __extends(Room, _super);
    /**
     * Construct a {@link Room}.
     * @param {RoomSignaling} signaling
     * @param {?object} [options={}]
     */
    function Room(localParticipant, signaling, options) {
        var _this = _super.call(this) || this;
        var log = options.log.createLog('default', _this);
        var participants = new Map();
        /* istanbul ignore next */
        Object.defineProperties(_this, {
            _log: {
                value: log
            },
            _clientTrackSwitchOffControl: {
                value: options.clientTrackSwitchOffControl || 'disabled'
            },
            _contentPreferencesMode: {
                value: options.contentPreferencesMode || 'disabled'
            },
            _instanceId: {
                value: ++nInstances
            },
            _options: {
                value: options
            },
            _participants: {
                value: participants
            },
            _signaling: {
                value: signaling
            },
            dominantSpeaker: {
                enumerable: true,
                get: function () {
                    return this.participants.get(signaling.dominantSpeakerSid) || null;
                }
            },
            isRecording: {
                enumerable: true,
                get: function () {
                    return signaling.recording.isEnabled || false;
                }
            },
            localParticipant: {
                enumerable: true,
                value: localParticipant
            },
            name: {
                enumerable: true,
                value: signaling.name
            },
            participants: {
                enumerable: true,
                value: participants
            },
            sid: {
                enumerable: true,
                value: signaling.sid
            },
            state: {
                enumerable: true,
                get: function () {
                    return signaling.state;
                }
            },
            mediaRegion: {
                enumerable: true,
                value: signaling.mediaRegion
            }
        });
        handleLocalParticipantEvents(_this, localParticipant);
        handleRecordingEvents(_this, signaling.recording);
        handleSignalingEvents(_this, signaling);
        verifyNoiseCancellation(_this);
        log.info('Created a new Room:', _this.name);
        log.debug('Initial RemoteParticipants:', Array.from(_this._participants.values()));
        return _this;
    }
    Room.prototype.toString = function () {
        return "[Room #" + this._instanceId + ": " + this.sid + "]";
    };
    /**
     * Disconnect from the {@link Room}.
     * @returns {this}
     */
    Room.prototype.disconnect = function () {
        this._log.info('Disconnecting');
        this._signaling.disconnect();
        return this;
    };
    /**
     * Get the {@link Room}'s media statistics. This is not supported in Safari 12.0 or below
     * due to this bug : https://bugs.webkit.org/show_bug.cgi?id=192601
     *
     * @returns {Promise.<Array<StatsReport>>}
     */
    Room.prototype.getStats = function () {
        var _this = this;
        return this._signaling.getStats().then(function (responses) {
            return Array.from(responses).map(function (_a) {
                var _b = __read(_a, 2), id = _b[0], response = _b[1];
                return new StatsReport(id, Object.assign({}, response, {
                    localAudioTrackStats: rewriteLocalTrackIds(_this, response.localAudioTrackStats),
                    localVideoTrackStats: rewriteLocalTrackIds(_this, response.localVideoTrackStats)
                }));
            });
        });
    };
    /**
     * Restart the muted local media {@link Track}s and play inadvertently paused HTMLMediaElements
     * that are attached to local and remote media {@link Track}s. This method is useful mainly on
     * mobile browsers (Safari and Chrome on iOS), where there is a possibility that the muted local
     * media {@link Track}s are never unmuted and inadvertently paused HTMLMediaElements are never
     * played again, especially after handling an incoming phone call.
     * @returns {this}
     */
    Room.prototype.refreshInactiveMedia = function () {
        var localTrackPublications = this.localParticipant.tracks;
        var localMediaTracks = Array.from(localTrackPublications.values())
            .filter(function (_a) {
            var kind = _a.track.kind;
            return kind !== 'data';
        })
            .map(function (_a) {
            var track = _a.track;
            return track;
        });
        var remoteMediaTracks = flatMap(this.participants, function (participants) { return Array.from(participants.tracks.values()); })
            .filter(function (_a) {
            var track = _a.track;
            return track && track.kind !== 'data';
        })
            .map(function (_a) {
            var track = _a.track;
            return track;
        });
        var mediaTracks = localMediaTracks.concat(remoteMediaTracks);
        var unmuteEvent = new Event('unmute');
        localMediaTracks.forEach(function (_a) {
            var isMuted = _a.isMuted, mediaStreamTrack = _a.mediaStreamTrack;
            if (isMuted) {
                mediaStreamTrack.dispatchEvent(unmuteEvent);
            }
        });
        var pauseEvent = new Event('pause');
        mediaTracks.forEach(function (_a) {
            var attachments = _a._attachments, elShims = _a._elShims;
            return attachments.forEach(function (el) {
                var shim = elShims.get(el);
                var isInadvertentlyPaused = el.paused && shim && !shim.pausedIntentionally();
                if (isInadvertentlyPaused) {
                    el.dispatchEvent(pauseEvent);
                }
            });
        });
        return this;
    };
    Room.prototype.toJSON = function () {
        return valueToJSON(this);
    };
    return Room;
}(EventEmitter));
function verifyNoiseCancellation(room) {
    var allowedAudioProcessors = room.localParticipant._signaling.audioProcessors;
    room.localParticipant.audioTracks.forEach(function (_a) {
        var track = _a.track;
        var noiseCancellation = track.noiseCancellation;
        if (noiseCancellation && !allowedAudioProcessors.includes(noiseCancellation.vendor)) {
            room._log.warn(noiseCancellation.vendor + " is not supported in this room. disabling it permanently");
            noiseCancellation.disablePermanently();
        }
    });
}
function rewriteLocalTrackIds(room, trackStats) {
    var localParticipantSignaling = room.localParticipant._signaling;
    return trackStats.reduce(function (trackStats, trackStat) {
        var publication = localParticipantSignaling.tracks.get(trackStat.trackId);
        var trackSender = localParticipantSignaling.getSender(publication);
        return trackSender
            ? [Object.assign({}, trackStat, { trackId: trackSender.id })].concat(trackStats)
            : trackStats;
    }, []);
}
/**
 * A {@link Room.SID} is a 34-character string starting with "RM"
 * that uniquely identifies a {@link Room}.
 * @type string
 * @typedef Room.SID
 */
/**
 * The Dominant Speaker in the {@link Room} changed. Either the Dominant Speaker
 * is a new {@link RemoteParticipant} or the Dominant Speaker has been reset and
 * is now null.
 * @param {?RemoteParticipant} dominantSpeaker - The Dominant Speaker in the
 *   {@link Room}, if any
 * @event Room#dominantSpeakerChanged
 */
/**
 * Your {@link LocalParticipant} was disconnected from the {@link Room} and all
 * other {@link RemoteParticipant}s.
 * @param {Room} room - The {@link Room} your
 *   {@link LocalParticipant} was disconnected from
 * @param {?TwilioError} error - Present when the {@link LocalParticipant} got
 *   disconnected from the {@link Room} unexpectedly
 * @event Room#disconnected
 * @example
 * myRoom.on('disconnected', function(room, error) {
 *   if (error) {
 *     console.log('Unexpectedly disconnected:', error);
 *   }
 *   myRoom.localParticipant.tracks.forEach(function(track) {
 *     track.stop();
 *     track.detach();
 *   });
 * });
 */
/**
 * A {@link RemoteParticipant} joined the {@link Room}. In Large Group Rooms (Maximum
 * Participants greater than 50), this event is raised only when a {@link RemoteParticipant}
 * publishes at least one {@link LocalTrack}.
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} who joined
 * @event Room#participantConnected
 * @example
 * myRoom.on('participantConnected', function(participant) {
 *   console.log(participant.identity + ' joined the Room');
 * });
 */
/**
 * A {@link RemoteParticipant} left the {@link Room}. In Large Group Rooms (Maximum
 * Participants greater than 50), this event is raised only when a {@link RemoteParticipant}
 * unpublishes all its {@link LocalTrack}s.
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} who left
 * @event Room#participantDisconnected
 * @example
 * myRoom.on('participantDisconnected', function(participant) {
 *   console.log(participant.identity + ' left the Room');
 *   participant.tracks.forEach(function(track) {
 *     track.detach().forEach(function(mediaElement) {
 *       mediaElement.remove();
 *     });
 *   });
 * });
 */
/**
 * A {@link RemoteParticipant} has reconnected to the {@link Room} after a signaling connection disruption.
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} that has reconnected.
 * @event Room#participantReconnected
 * @example
 * myRoom.on('participantReconnected', participant => {
 *   console.log(participant.identity + ' reconnected to the Room');
 * });
 */
/**
 * A {@link RemoteParticipant} is reconnecting to the {@link Room} after a signaling connection disruption.
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} that is reconnecting.
 * @event Room#participantReconnecting
 * @example
 * myRoom.on('participantReconnecting', participant => {
 *   console.log(participant.identity + ' is reconnecting to the Room');
 * });
 */
/**
 * Your application successfully reconnected to the {@link Room}. When this
 * event is emitted, the {@link Room} is in state "connected".
 * @event Room#reconnected
 * @example
 * myRoom.on('reconnected', () => {
 *   console.log('Reconnected!');
 * });
 */
/**
 * Your application is reconnecting to the {@link Room}. This happens when there
 * is a disruption in your signaling connection and/or your media connection. When
 * this event is emitted, the {@link Room} is in state "reconnecting". If reconnecting
 * succeeds, the {@link Room} will emit a "reconnected" event.
 * @param {MediaConnectionError|SignalingConnectionDisconnectedError} error - A
 *   {@link MediaConnectionError} if your application is reconnecting due to a
 *   disruption in your media connection, or a {@link SignalingConnectionDisconnectedError}
 *   if your application is reconnecting due to a disruption in your signaling connection
 * @event Room#reconnecting
 * @example
 * myRoom.on('reconnecting', error => {
 *   if (error.code === 53001) {
 *     console.log('Reconnecting your signaling connection!', error.message);
 *   } else if (error.code === 53405) {
 *     console.log('Reconnecting your media connection!', error.message);
 *   }
 * });
 */
/**
 * The {@link Room} is now being recorded
 * @event Room#recordingStarted
 */
/**
 * The {@link Room} is no longer being recorded
 * @event Room#recordingStopped
 */
/**
 * One of the {@link RemoteParticipant}'s {@link VideoTrack}'s dimensions changed.
 * @param {RemoteVideoTrack} track - The {@link RemoteVideoTrack} whose dimensions changed
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteVideoTrack}'s dimensions changed
 * @event Room#trackDimensionsChanged
 */
/**
 * A {@link RemoteTrack} was disabled by a {@link RemoteParticipant} in the {@link Room}.
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication} that represents disabled {@link RemoteTrack}
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} who
 *   disabled the {@link RemoteTrack}
 * @event Room#trackDisabled
 */
/**
 * A {@link RemoteTrack} was enabled by a {@link RemoteParticipant} in the {@link Room}.
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication} that represents enabled {@link RemoteTrack}
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} who
 *   enabled the {@link RemoteTrack}
 * @event Room#trackEnabled
 */
/**
 * A message was received over one of the {@link RemoteParticipant}'s
 * {@link RemoteDataTrack}'s.
 * @param {string|ArrayBuffer} data
 * @param {RemoteDataTrack} track - The {@link RemoteDataTrack} over which the
 *   message was received
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteDataTrack} received the message
 * @event Room#trackMessage
 */
/**
 * A {@link RemoteTrack} was published by a {@link RemoteParticipant} after
 * connecting to the {@link Room}. This event is not emitted for
 * {@link RemoteTrack}s that were published while the {@link RemoteParticipant}
 * was connecting to the {@link Room}.
 * @event Room#trackPublished
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   which represents the published {@link RemoteTrack}
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} who
 *   published the {@link RemoteTrack}
 * @example
 * function trackPublished(publication, participant) {
 *   console.log(`RemoteParticipant ${participant.sid} published Track ${publication.trackSid}`);
 * }
 *
 * // Handle RemoteTracks published after connecting to the Room.
 * room.on('trackPublished', trackPublished);
 *
 * room.on('participantConnected', participant => {
 *   // Handle RemoteTracks published while connecting to the Room.
 *   participant.trackPublications.forEach(publication => trackPublished(publication, participant));
 * });
 */
/**
 * One of a {@link RemoteParticipant}'s {@link RemoteTrack}s in the {@link Room} started.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that started
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteTrack} started
 * @event Room#trackStarted
 */
/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was subscribed to.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was subscribed
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was subscribed to
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteTrack} was subscribed
 * @event Room#trackSubscribed
 * @example
 * room.on('trackSubscribed', function(track, publication, participant) {
 *   var participantView = document.getElementById('participant-view-' + participant.identity);
 *   participantView.appendChild(track.attach());
 * });
 */
/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was switched off.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was switched off
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was subscribed to
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteTrack} was switched off
 * @event Room#trackSwitchedOff
 */
/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was switched on.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was switched on
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was subscribed to
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteTrack} was switched on
 * @event Room#trackSwitchedOn
 */
/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} could not be subscribed to.
 * @param {TwilioError} error - The reason the {@link RemoteTrack} could not be
 *   subscribed to
 * @param {RemoteTrackPublication} publication - The
 *   {@link RemoteTrackPublication} for the {@link RemoteTrack} that could not
 *   be subscribed to
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteTrack} could not be subscribed to
 * @event Room#trackSubscriptionFailed
 */
/**
 * The {@link RemoteTrack}'s publish {@link Track.Priority} was changed by the
 * {@link RemoteParticipant}.
 * @param {Track.Priority} priority - the {@link RemoteTrack}'s new publish
 *   {@link Track.Priority};
 * @param {RemoteTrackPublication} publication - The
 *   {@link RemoteTrackPublication} for the {@link RemoteTrack} that changed priority
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteTrack} changed priority
 * @event Room#trackPublishPriorityChanged
 */
/**
 * A {@link RemoteTrack} was unpublished by a {@link RemoteParticipant} to the {@link Room}.
 * @event Room#trackUnpublished
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   which represents the unpublished {@link RemoteTrack}
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} who
 *   unpublished the {@link RemoteTrack}
 */
/**
 * A {@link RemoteParticipant}'s {@link RemoteTrack} was unsubscribed from.
 * @param {RemoteTrack} track - The {@link RemoteTrack} that was unsubscribed
 * @param {RemoteTrackPublication} publication - The {@link RemoteTrackPublication}
 *   for the {@link RemoteTrack} that was unsubscribed from
 * @param {RemoteParticipant} participant - The {@link RemoteParticipant} whose
 *   {@link RemoteTrack} was unsubscribed
 * @event Room#trackUnsubscribed
 * @example
 * room.on('trackUnsubscribed', function(track, publication, participant) {
 *   track.detach().forEach(function(mediaElement) {
 *     mediaElement.remove();
 *   });
 * });
 */
/**
 * One of the {@link LocalParticipant}'s {@link LocalTrackPublication}s in the {@link Room} encountered a warning.
 * This event is only raised if you enabled warnings using <code>notifyWarnings</code> in <code>ConnectOptions</code>.
 * @param {string} name - The warning that was raised.
 * @param {LocalTrackPublication} publication - The {@link LocalTrackPublication} that encountered the warning.
 * @param {LocalParticipant} participant - The {@link LocalParticipant}
 * @event Room#trackWarning
 * @example
 * room.on('trackWarning', (name, publication, participant) => {
 *   if (name === 'recording-media-lost') {
 *     log(`LocalTrack ${publication.track.name} is not recording media.`,
 *       name, publication, participant);
 *
 *     // Wait a reasonable amount of time to clear the warning.
 *     const timer = setTimeout(() => {
 *       // If the warning is not cleared, you can manually
 *       // reconnect to the room, or show a dialog to the user
 *     }, 5000);
 *
 *     room.once('trackWarningsCleared', (publication, participant) => {
 *       log('LocalTrack warnings have cleared!',
 *         publication, participant);
 *       clearTimeout(timer);
 *     });
 *   }
});
 */
/**
 * One of the {@link LocalParticipant}'s {@link LocalTrackPublication}s in the {@link Room} cleared all warnings.
 * This event is only raised if you enabled warnings using <code>notifyWarnings</code> in <code>ConnectOptions</code>.
 * @param {LocalTrackPublication} publication - The {@link LocalTrackPublication} that cleared all warnings.
 * @param {LocalParticipant} participant - The {@link LocalParticipant}
 * @event Room#trackWarningsCleared
 */
function connectParticipant(room, participantSignaling) {
    var log = room._log, clientTrackSwitchOffControl = room._clientTrackSwitchOffControl, contentPreferencesMode = room._contentPreferencesMode;
    var participant = new RemoteParticipant(participantSignaling, { log: log, clientTrackSwitchOffControl: clientTrackSwitchOffControl, contentPreferencesMode: contentPreferencesMode });
    log.info('A new RemoteParticipant connected:', participant);
    room._participants.set(participant.sid, participant);
    room.emit('participantConnected', participant);
    // Reemit Track and RemoteParticipant events.
    var eventListeners = [
        ['reconnected', 'participantReconnected'],
        ['reconnecting', 'participantReconnecting'],
        'trackDimensionsChanged',
        'trackDisabled',
        'trackEnabled',
        'trackMessage',
        'trackPublished',
        'trackPublishPriorityChanged',
        'trackStarted',
        'trackSubscribed',
        'trackSubscriptionFailed',
        'trackSwitchedOff',
        'trackSwitchedOn',
        'trackUnpublished',
        'trackUnsubscribed'
    ].map(function (eventOrPair) {
        var _a = __read(Array.isArray(eventOrPair)
            ? eventOrPair
            : [eventOrPair, eventOrPair], 2), event = _a[0], participantEvent = _a[1];
        function reemit() {
            var args = [].slice.call(arguments);
            args.unshift(participantEvent);
            args.push(participant);
            room.emit.apply(room, __spreadArray([], __read(args)));
        }
        participant.on(event, reemit);
        return [event, reemit];
    });
    participant.once('disconnected', function participantDisconnected() {
        var dominantSpeaker = room.dominantSpeaker;
        log.info('RemoteParticipant disconnected:', participant);
        room._participants.delete(participant.sid);
        eventListeners.forEach(function (args) {
            participant.removeListener(args[0], args[1]);
        });
        room.emit('participantDisconnected', participant);
        if (participant === dominantSpeaker) {
            room.emit('dominantSpeakerChanged', room.dominantSpeaker);
        }
    });
}
function handleLocalParticipantEvents(room, localParticipant) {
    var events = ['trackWarning', 'trackWarningsCleared'].map(function (event) { return ({
        eventName: event,
        handler: function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return room.emit.apply(room, __spreadArray([event], __read(__spreadArray(__spreadArray([], __read(args)), [localParticipant]))));
        },
    }); });
    events.forEach(function (_a) {
        var eventName = _a.eventName, handler = _a.handler;
        return localParticipant.on(eventName, handler);
    });
    room.once('disconnected', function () {
        return events.forEach(function (_a) {
            var eventName = _a.eventName, handler = _a.handler;
            return localParticipant.removeListener(eventName, handler);
        });
    });
}
function handleRecordingEvents(room, recording) {
    recording.on('updated', function updated() {
        var started = recording.isEnabled;
        room._log.info("Recording " + (started ? 'started' : 'stopped'));
        room.emit("recording" + (started ? 'Started' : 'Stopped'));
    });
}
function handleSignalingEvents(room, signaling) {
    var log = room._log;
    // Reemit RemoteParticipant events from the RoomSignaling.
    log.debug('Creating a new RemoteParticipant for each ParticipantSignaling '
        + 'in the RoomSignaling');
    signaling.participants.forEach(connectParticipant.bind(null, room));
    log.debug('Setting up RemoteParticipant creation for all subsequent '
        + 'ParticipantSignalings that connect to the RoomSignaling');
    signaling.on('participantConnected', connectParticipant.bind(null, room));
    signaling.on('dominantSpeakerChanged', function () { return room.emit('dominantSpeakerChanged', room.dominantSpeaker); });
    // Reemit state transition events from the RoomSignaling.
    signaling.on('stateChanged', function stateChanged(state, error) {
        log.info('Transitioned to state:', state);
        switch (state) {
            case 'disconnected':
                room.participants.forEach(function (participant) {
                    participant._unsubscribeTracks();
                });
                room.emit(state, room, error);
                room.localParticipant.tracks.forEach(function (publication) {
                    publication.unpublish();
                });
                signaling.removeListener('stateChanged', stateChanged);
                break;
            case 'reconnecting':
                // NOTE(mpatwardhan): `stateChanged` can get emitted with StateMachine locked.
                // Do not signal  public events synchronously with lock held.
                setTimeout(function () { return room.emit('reconnecting', error); }, 0);
                break;
            default:
                // NOTE(mpatwardhan): `stateChanged` can get emitted with StateMachine locked.
                // Do not signal  public events synchronously with lock held.
                setTimeout(function () { return room.emit('reconnected'); }, 0);
        }
    });
}
module.exports = Room;

},{"./eventemitter":10,"./remoteparticipant":57,"./stats/statsreport":117,"./util":133}],59:[function(require,module,exports){
/* eslint consistent-return:0 */
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ParticipantSignaling = require('./participant');
var RoomSignaling = require('./room');
var StateMachine = require('../statemachine');
/*
Signaling States
----------------

              +---------+
              |         |
              | opening |
         +--->|         |
         |    +---------+
    +--------+   |   |   +------+
    |        |<--+   +-->|      |
    | closed |<----------| open |
    |        |<--+   +-->|      |
    +--------+   |   |   +------+
              +---------+   |
              |         |<--+
              | closing |
              |         |
              +---------+

*/
var states = {
    closed: [
        'opening'
    ],
    opening: [
        'closed',
        'open'
    ],
    open: [
        'closed',
        'closing'
    ],
    closing: [
        'closed',
        'open'
    ]
};
/**
 * @extends StateMachine
 * @property {string} state - one of "closed", "opening", "open", or "closing"
 */
var Signaling = /** @class */ (function (_super) {
    __extends(Signaling, _super);
    /**
     * Construct {@link Signaling}.
     */
    function Signaling() {
        return _super.call(this, 'closed', states) || this;
    }
    /**
     * @private
     */
    // NOTE(mroberts): This is a dummy implementation suitable for testing.
    Signaling.prototype._close = function (key) {
        this.transition('closing', key);
        this.transition('closed', key);
        return Promise.resolve(this);
    };
    /**
     * @private
     */
    // NOTE(mroberts): This is a dummy implementation suitable for testing.
    Signaling.prototype._connect = function (localParticipant, token, encodingParameters, preferredCodecs, options) {
        localParticipant.connect('PA00000000000000000000000000000000', 'test');
        var sid = 'RM00000000000000000000000000000000';
        var promise = Promise.resolve(new RoomSignaling(localParticipant, sid, options));
        promise.cancel = function cancel() { };
        return promise;
    };
    /**
     * @private
     */
    // NOTE(mroberts): This is a dummy implementation suitable for testing.
    Signaling.prototype._open = function (key) {
        this.transition('opening', key);
        this.transition('open', key);
        return Promise.resolve(this);
    };
    /**
     * Close the {@link Signaling}.
     * @returns {Promise<this>}
     */
    Signaling.prototype.close = function () {
        var _this = this;
        return this.bracket('close', function (key) {
            switch (_this.state) {
                case 'closed':
                    return _this;
                case 'open':
                    return _this._close(key);
                default:
                    throw new Error("Unexpected Signaling state \"" + _this.state + "\"");
            }
        });
    };
    /**
     * Connect to a {@link RoomSignaling}.
     * @param {ParticipantSignaling} localParticipant
     * @param {string} token
     * @param {EncodingParametersImpl} encodingParameters
     * @param {PreferredCodecs} preferredCodecs
     * @param {object} options
     * @returns {Promise<function(): CancelablePromise<RoomSignaling>>}
     */
    Signaling.prototype.connect = function (localParticipant, token, encodingParameters, preferredCodecs, options) {
        var self = this;
        return this.bracket('connect', function transition(key) {
            switch (self.state) {
                case 'closed':
                    return self._open(key).then(transition.bind(null, key));
                case 'open':
                    // NOTE(mroberts): We don't need to hold the lock in _connect. Instead,
                    // we just need to ensure the Signaling remains open.
                    self.releaseLockCompletely(key);
                    return self._connect(localParticipant, token, encodingParameters, preferredCodecs, options);
                default:
                    throw new Error("Unexpected Signaling state \"" + self.state + "\"");
            }
        });
    };
    /**
     * Create a local {@link ParticipantSignaling}.
     * @returns {ParticipantSignaling}
     */
    Signaling.prototype.createLocalParticipantSignaling = function () {
        return new ParticipantSignaling();
    };
    /**
     * Open the {@link Signaling}.
     * @returns {Promise<this>}
     */
    Signaling.prototype.open = function () {
        var _this = this;
        return this.bracket('open', function (key) {
            switch (_this.state) {
                case 'closed':
                    return _this._open(key);
                case 'open':
                    return _this;
                default:
                    throw new Error("Unexpected Signaling state \"" + _this.state + "\"");
            }
        });
    };
    return Signaling;
}(StateMachine));
module.exports = Signaling;

},{"../statemachine":89,"./participant":62,"./room":66}],60:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ParticipantSignaling = require('./participant');
var LocalParticipantSignaling = /** @class */ (function (_super) {
    __extends(LocalParticipantSignaling, _super);
    function LocalParticipantSignaling() {
        var _this = _super.call(this) || this;
        Object.defineProperties(_this, {
            _publicationsToTrackSenders: {
                value: new Map()
            },
            _trackSendersToPublications: {
                value: new Map()
            }
        });
        return _this;
    }
    /**
     * @param {DataTrackSender|MediaTrackSender} trackSender
     * @param {string} name
     * @param {Track.Priority} priority
     * @param {?NoiseCancellationVendor} noiseCancellationVendor
     * @returns {LocalTrackPublicationSignaling} publication
     */
    LocalParticipantSignaling.prototype.addTrack = function (trackSender, name, priority, noiseCancellationVendor) {
        if (noiseCancellationVendor === void 0) { noiseCancellationVendor = null; }
        var publication = this._createLocalTrackPublicationSignaling(trackSender, name, priority, noiseCancellationVendor);
        this._trackSendersToPublications.set(trackSender, publication);
        this._publicationsToTrackSenders.set(publication, trackSender);
        _super.prototype.addTrack.call(this, publication);
        return this;
    };
    /**
     * @param {DataTrackSender|MediaTrackSender} trackSender
     * @returns {?LocalTrackPublicationSignaling}
     */
    LocalParticipantSignaling.prototype.getPublication = function (trackSender) {
        return this._trackSendersToPublications.get(trackSender) || null;
    };
    /**
     * @param {LocalTrackPublicationSignaling} trackPublication
     * @returns {?DataTrackSender|MediaTrackSender}
     */
    LocalParticipantSignaling.prototype.getSender = function (trackPublication) {
        return this._publicationsToTrackSenders.get(trackPublication) || null;
    };
    /**
     * @param {DataTrackSender|MediaTrackSender} trackSender
     * @returns {?LocalTrackPublicationSignaling}
     */
    LocalParticipantSignaling.prototype.removeTrack = function (trackSender) {
        var publication = this._trackSendersToPublications.get(trackSender);
        if (!publication) {
            return null;
        }
        this._trackSendersToPublications.delete(trackSender);
        this._publicationsToTrackSenders.delete(publication);
        var didDelete = _super.prototype.removeTrack.call(this, publication);
        if (didDelete) {
            publication.stop();
        }
        return publication;
    };
    return LocalParticipantSignaling;
}(ParticipantSignaling));
module.exports = LocalParticipantSignaling;

},{"./participant":62}],61:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var TrackSignaling = require('./track');
/**
 * A {@link LocalTrackPublication} implementation
 * @extends TrackSignaling
 * @property {Track.ID} id
 */
var LocalTrackPublicationSignaling = /** @class */ (function (_super) {
    __extends(LocalTrackPublicationSignaling, _super);
    /**
     * Construct a {@link LocalTrackPublicationSignaling}. {@link TrackSenders}
     * are always cloned.
     * @param {DataTrackSender|MediaTrackSender} trackSender - the {@link TrackSender}
     *   of the {@link LocalTrack} to be published
     * @param {string} name - the name of the {@link LocalTrack} to be published
     * @param {Track.Priority} priority - initial {@link Track.Priority}
     */
    function LocalTrackPublicationSignaling(trackSender, name, priority) {
        var _this = this;
        // NOTE(lrivas): Safely clone a media stream track while preserving the original
        // enabled state. This is needed because Safari 18 incorrectly enables tracks
        // during cloning. Bug report: https://bugs.webkit.org/show_bug.cgi?id=281758
        var clonedTrackSender = trackSender.clone();
        if (trackSender.kind !== 'data') {
            clonedTrackSender.track.enabled = trackSender.track.enabled;
        }
        trackSender = clonedTrackSender;
        var enabled = trackSender.kind === 'data' ? true : trackSender.track.enabled;
        _this = _super.call(this, name, trackSender.kind, enabled, priority) || this;
        _this.setTrackTransceiver(trackSender);
        Object.defineProperties(_this, {
            _updatedPriority: {
                value: priority,
                writable: true
            },
            id: {
                enumerable: true,
                value: trackSender.id
            }
        });
        return _this;
    }
    Object.defineProperty(LocalTrackPublicationSignaling.prototype, "updatedPriority", {
        /**
         * The updated {@link Track.Priority} of the {@link LocalTrack}.
         * @property {Track.priority}
         */
        get: function () {
            return this._updatedPriority;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Enable (or disable) the {@link LocalTrackPublicationSignaling} if it is not
     * already enabled (or disabled). This also updates the cloned
     * {@link MediaTrackSender}'s MediaStreamTracks `enabled` state.
     * @param {boolean} [enabled=true]
     * @return {this}
     */
    LocalTrackPublicationSignaling.prototype.enable = function (enabled) {
        enabled = typeof enabled === 'boolean' ? enabled : true;
        this.trackTransceiver.track.enabled = enabled;
        return _super.prototype.enable.call(this, enabled);
    };
    /**
     * Rejects the SID's deferred promise with the given Error.
     * @param {Error} error
     * @returns {this}
     */
    LocalTrackPublicationSignaling.prototype.publishFailed = function (error) {
        if (setError(this, error)) {
            this.emit('updated');
        }
        return this;
    };
    /**
     * Update the {@link Track.Priority} of the published {@link LocalTrack}.
     * @param {Track.priority} priority
     * @returns {this}
     */
    LocalTrackPublicationSignaling.prototype.setPriority = function (priority) {
        if (this._updatedPriority !== priority) {
            this._updatedPriority = priority;
            this.emit('updated');
        }
        return this;
    };
    /**
     * Set the published {@link LocalTrack}'s {@link Track.SID}.
     * @param {Track.SID} sid
     * @returns {this}
     */
    LocalTrackPublicationSignaling.prototype.setSid = function (sid) {
        if (this._error) {
            return this;
        }
        return _super.prototype.setSid.call(this, sid);
    };
    /**
     * Stop the cloned {@link TrackSender}.
     * @returns {void}
     */
    LocalTrackPublicationSignaling.prototype.stop = function () {
        this.trackTransceiver.stop();
    };
    return LocalTrackPublicationSignaling;
}(TrackSignaling));
/**
 * @param {LocalTrackPublication} publication
 * @param {Error} error
 * @returns {boolean} updated
 */
function setError(publication, error) {
    if (publication._sid !== null || publication._error) {
        return false;
    }
    publication._error = error;
    return true;
}
module.exports = LocalTrackPublicationSignaling;

},{"./track":67}],62:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var StateMachine = require('../statemachine');
var NetworkQualityStats = require('../stats/networkqualitystats');
/*
ParticipantSignaling States
----------------------

    +------------+     +-----------+     +--------------+
    |            |     |           |     |              |
    | connecting |---->| connected |---->| disconnected |
    |            |     |           |     |              |
    +------------+     +-----------+     +--------------+
                           | ^                    ^
                           | |  +--------------+  |
                           | |--|              |  |
                           |--->| reconnecting |--|
                                |              |
                                +--------------+
*/
var states = {
    connecting: [
        'connected'
    ],
    connected: [
        'disconnected',
        'reconnecting'
    ],
    reconnecting: [
        'connected',
        'disconnected'
    ],
    disconnected: []
};
/**
 * A {@link Participant} implementation
 * @extends StateMachine
 * @property {?string} identity
 * @property {?Participant.SID} sid
 * @property {string} state - "connecting", "connected", or "disconnected"
 * @property {Map<Track.ID | Track.SID, TrackSignaling>} tracks
 * @emits ParticipantSignaling#networkQualityLevelChanged
 * @emits ParticipantSignaling#trackAdded
 * @emits ParticipantSignaling#trackRemoved
 */
var ParticipantSignaling = /** @class */ (function (_super) {
    __extends(ParticipantSignaling, _super);
    /**
     * Construct a {@link ParticipantSignaling}.
     */
    function ParticipantSignaling() {
        var _this = _super.call(this, 'connecting', states) || this;
        Object.defineProperties(_this, {
            _identity: {
                writable: true,
                value: null
            },
            _networkQualityLevel: {
                value: null,
                writable: true
            },
            _networkQualityStats: {
                value: null,
                writable: true
            },
            _sid: {
                writable: true,
                value: null
            },
            identity: {
                enumerable: true,
                get: function () {
                    return this._identity;
                }
            },
            sid: {
                enumerable: true,
                get: function () {
                    return this._sid;
                }
            },
            tracks: {
                enumerable: true,
                value: new Map()
            }
        });
        return _this;
    }
    Object.defineProperty(ParticipantSignaling.prototype, "networkQualityLevel", {
        /**
         * Get the current {@link NetworkQualityLevel}, if any.
         * @returns {?NetworkQualityLevel} networkQualityLevel - initially null
         */
        get: function () {
            return this._networkQualityLevel;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ParticipantSignaling.prototype, "networkQualityStats", {
        /**
         * Get the current {@link NetworkQualityStats}
         * @returns {?NetworkQualityStats} networkQualityStats - initially null
         */
        get: function () {
            return this._networkQualityStats;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Add the {@link TrackSignaling}, MediaStreamTrack, or
     * {@link DataTrackSender} to the {@link ParticipantSignaling}.
     * @param {TrackSignaling|DataTrackSender|MediaTrackSender} track
     * @returns {this}
     * @fires ParticipantSignaling#trackAdded
     */
    ParticipantSignaling.prototype.addTrack = function (track) {
        this.tracks.set(track.id || track.sid, track);
        this.emit('trackAdded', track);
        return this;
    };
    /**
     * Disconnect the {@link ParticipantSignaling}.
     * @returns {boolean}
     */
    ParticipantSignaling.prototype.disconnect = function () {
        if (this.state !== 'disconnected') {
            this.preempt('disconnected');
            return true;
        }
        return false;
    };
    /**
     * Remove the {@link TrackSignaling}, MediaStreamTrack, or
     * {@link DataTrackSender} from the {@link ParticipantSignaling}.
     * @param {TrackSignaling|DataTrackSender|MediaTrackSender} track
     * @returns {?TrackSignaling}
     * @fires ParticipantSignaling#trackRemoved
     */
    ParticipantSignaling.prototype.removeTrack = function (track) {
        var signaling = this.tracks.get(track.id || track.sid);
        this.tracks.delete(track.id || track.sid);
        if (signaling) {
            this.emit('trackRemoved', track);
        }
        return signaling || null;
    };
    /**
     * @param {NetworkQualityLevel} networkQualityLevel
     * @param {?NetworkQualityLevels} [networkQualityLevels=null]
     * @returns {void}
     */
    ParticipantSignaling.prototype.setNetworkQualityLevel = function (networkQualityLevel, networkQualityLevels) {
        if (this._networkQualityLevel !== networkQualityLevel) {
            this._networkQualityLevel = networkQualityLevel;
            this._networkQualityStats = networkQualityLevels
                && (networkQualityLevels.audio || networkQualityLevels.video)
                ? new NetworkQualityStats(networkQualityLevels)
                : null;
            this.emit('networkQualityLevelChanged');
        }
    };
    /**
     * Connect the {@link ParticipantSignaling}.
     * @param {Participant.SID} sid
     * @param {string} identity
     * @returns {boolean}
     */
    ParticipantSignaling.prototype.connect = function (sid, identity) {
        if (this.state === 'connecting' || this.state === 'reconnecting') {
            if (!this._sid) {
                this._sid = sid;
            }
            if (!this._identity) {
                this._identity = identity;
            }
            this.preempt('connected');
            return true;
        }
        return false;
    };
    /**
     * Transition to "reconnecting" state.
     * @returns {boolean}
     */
    ParticipantSignaling.prototype.reconnecting = function () {
        if (this.state === 'connecting' || this.state === 'connected') {
            this.preempt('reconnecting');
            return true;
        }
        return false;
    };
    return ParticipantSignaling;
}(StateMachine));
/**
 * @event ParticipantSignaling#event:networkQualityLevelChanged
 */
/**
 * {@link TrackSignaling} was added to the {@link ParticipantSignaling}.
 * @event ParticipantSignaling#trackAdded
 * @param {TrackSignaling} track
 */
/**
 * {@link TrackSignaling} was removed from the {@link ParticipantSignaling}.
 * @event ParticipantSignaling#trackRemoved
 * @param {TrackSignaling} track
 */
module.exports = ParticipantSignaling;

},{"../statemachine":89,"../stats/networkqualitystats":104}],63:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var EventEmitter = require('events').EventEmitter;
/**
 * Represents recording state
 * @extends EventEmitter
 * @property {?boolean} isEnabled
 */
var RecordingSignaling = /** @class */ (function (_super) {
    __extends(RecordingSignaling, _super);
    /**
     * Construct a {@link RecordingSignaling}.
     */
    function RecordingSignaling() {
        var _this = _super.call(this) || this;
        Object.defineProperties(_this, {
            _isEnabled: {
                value: null,
                writable: true
            },
            isEnabled: {
                enumerable: true,
                get: function () {
                    return this._isEnabled;
                }
            }
        });
        return _this;
    }
    /**
     * Disable the {@link RecordingSignaling} if it is not already disabled.
     * @return {this}
     */
    RecordingSignaling.prototype.disable = function () {
        return this.enable(false);
    };
    /**
     * Enable (or disable) the {@link RecordingSignaling} if it is not already enabled
     * (or disabled).
     * @param {boolean} [enabled=true]
     * @return {this}
     */
    RecordingSignaling.prototype.enable = function (enabled) {
        enabled = typeof enabled === 'boolean' ? enabled : true;
        if (this.isEnabled !== enabled) {
            this._isEnabled = enabled;
            this.emit('updated');
        }
        return this;
    };
    return RecordingSignaling;
}(EventEmitter));
/**
 * Emitted whenever the {@link RecordingSignaling} is updated
 * @event RecordingSignaling#updated
 */
module.exports = RecordingSignaling;

},{"events":174}],64:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ParticipantSignaling = require('./participant');
/**
 * A {@link Participant} implementation
 * @extends ParticipantSignaling
 * @property {string} identity
 * @property {Participant.SID} sid
 */
var RemoteParticipantSignaling = /** @class */ (function (_super) {
    __extends(RemoteParticipantSignaling, _super);
    /**
     * Construct a {@link RemoteParticipantSignaling}.
     * @param {Participant.SID} sid
     * @param {string} identity
     */
    function RemoteParticipantSignaling(sid, identity) {
        var _this = _super.call(this) || this;
        _this.connect(sid, identity);
        return _this;
    }
    return RemoteParticipantSignaling;
}(ParticipantSignaling));
module.exports = RemoteParticipantSignaling;

},{"./participant":62}],65:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var TrackSignaling = require('./track');
/**
 * A {@link RemoteTrackPublication} implementation
 * @extends TrackSignaling
 */
var RemoteTrackPublicationSignaling = /** @class */ (function (_super) {
    __extends(RemoteTrackPublicationSignaling, _super);
    /**
     * Construct a {@link RemoteTrackPublicationSignaling}.
     * @param {Track.SID} sid
     * @param {string} name
     * @param {Track.Kind} kind
     * @param {boolean} isEnabled
     * @param {Track.Priority} priority
     * @param {boolean} isSwitchedOff
     */
    function RemoteTrackPublicationSignaling(sid, name, kind, isEnabled, priority, isSwitchedOff) {
        var _this = _super.call(this, name, kind, isEnabled, priority) || this;
        Object.defineProperties(_this, {
            _isSwitchedOff: {
                value: isSwitchedOff,
                writable: true
            },
        });
        _this.setSid(sid);
        return _this;
    }
    Object.defineProperty(RemoteTrackPublicationSignaling.prototype, "isSubscribed", {
        /**
         * Whether the {@link RemoteTrackPublicationSignaling} is subscribed to.
         * @property {boolean}
         */
        get: function () {
            return !!this.trackTransceiver;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(RemoteTrackPublicationSignaling.prototype, "isSwitchedOff", {
        /**
         * Whether the {@link RemoteTrackPublicationSignaling} is switched off.
         * @property {boolean}
         */
        get: function () {
            return this._isSwitchedOff;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * @param {Error} error
     * @returns {this}
     */
    RemoteTrackPublicationSignaling.prototype.subscribeFailed = function (error) {
        if (!this.error) {
            this._error = error;
            this.emit('updated');
        }
        return this;
    };
    /**
     * Update the publish {@link Track.Priority}.
     * @param {Track.Priority} priority
     * @returns {this}
     */
    RemoteTrackPublicationSignaling.prototype.setPriority = function (priority) {
        if (this._priority !== priority) {
            this._priority = priority;
            this.emit('updated');
        }
        return this;
    };
    /**
     * Updates track switch on/off state.
     * @param {boolean} isSwitchedOff
     * @returns {this}
     */
    RemoteTrackPublicationSignaling.prototype.setSwitchedOff = function (isSwitchedOff) {
        if (this._isSwitchedOff !== isSwitchedOff) {
            this._isSwitchedOff = isSwitchedOff;
            this.emit('updated');
        }
        return this;
    };
    return RemoteTrackPublicationSignaling;
}(TrackSignaling));
module.exports = RemoteTrackPublicationSignaling;

},{"./track":67}],66:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var DefaultRecordingSignaling = require('./recording');
var StateMachine = require('../statemachine');
var DefaultTimeout = require('../util/timeout');
var buildLogLevels = require('../util').buildLogLevels;
var DEFAULT_LOG_LEVEL = require('../util/constants').DEFAULT_LOG_LEVEL;
var Log = require('../util/log');
var _a = require('../util/twilio-video-errors'), MediaConnectionError = _a.MediaConnectionError, MediaDTLSTransportFailedError = _a.MediaDTLSTransportFailedError, SignalingConnectionDisconnectedError = _a.SignalingConnectionDisconnectedError;
var nInstances = 0;
/*
RoomSignaling States
-----------------------

    +-----------+     +--------------+
    |           |     |              |
    | connected |---->| disconnected |
    |           |     |              |
    +-----------+     +--------------+
          |  ^               ^
          |  |               |
          |  |   +--------------+
          |  +---|              |
          |      | reconnecting |
          +----->|              |
                 +--------------+

*/
var states = {
    connected: [
        'reconnecting',
        'disconnected'
    ],
    reconnecting: [
        'connected',
        'disconnected'
    ],
    disconnected: []
};
/**
 * A {@link Room} implementation
 * @extends StateMachine
 * @property {RTCPeerConnectionState} connectionState
 * @property {?Participant.SID} dominantSpeakerSid
 * @property {ParticipantSignaling} localParticipant
 * @property {RTCIceConnectionState} iceConnectionState
 * @property {string} name
 * @property {Map<string, RemoteParticipantSignaling>} participants
 * @property {RecordingSignaling} recording
 * @property {Room.SID} sid
 * @property {string} state - "connected", "reconnecting", or "disconnected"
 * @property {string} signalingConnectionState - "connected",
 *   "reconnecting", or "disconnected"
 * @emits RoomSignaling#connectionStateChanged
 * @emits RoomSignaling#dominantSpeakerChanged
 * @emits RoomSignaling#iceConnectionStateChanged
 * @emits RoomSignaling#signalingConnectionStateChanged
 */
var RoomSignaling = /** @class */ (function (_super) {
    __extends(RoomSignaling, _super);
    /**
     * Construct a {@link RoomSignaling}.
     * @param {ParticipantSignaling} localParticipant
     * @param {Room.SID} sid
     * @param {string} name
     * @param {object} options
     */
    function RoomSignaling(localParticipant, sid, name, options) {
        var _this = this;
        options = Object.assign({
            logLevel: DEFAULT_LOG_LEVEL,
            RecordingSignaling: DefaultRecordingSignaling,
            Timeout: DefaultTimeout
        }, options);
        var logLevels = buildLogLevels(options.logLevel);
        _this = _super.call(this, 'connected', states) || this;
        var RecordingSignaling = options.RecordingSignaling;
        var sessionTimeout = new options.Timeout(function () {
            _this._disconnect(_this._reconnectingError);
        }, options.sessionTimeout, false);
        Object.defineProperties(_this, {
            _instanceId: {
                value: nInstances++
            },
            _log: {
                value: options.log
                    ? options.log.createLog('default', _this)
                    : new Log('default', _this, logLevels, options.loggerName)
            },
            _mediaConnectionIsReconnecting: {
                writable: true,
                value: false
            },
            _options: {
                value: options
            },
            _reconnectingError: {
                value: null,
                writable: true
            },
            _sessionTimeout: {
                value: sessionTimeout
            },
            dominantSpeakerSid: {
                enumerable: true,
                value: null,
                writable: true
            },
            localParticipant: {
                enumerable: true,
                value: localParticipant
            },
            name: {
                enumerable: true,
                value: name
            },
            participants: {
                enumerable: true,
                value: new Map()
            },
            recording: {
                enumerable: true,
                value: new RecordingSignaling()
            },
            sid: {
                enumerable: true,
                value: sid
            }
        });
        _this.on('connectionStateChanged', function () {
            if (_this.connectionState === 'failed'
                && !['disconnected', 'failed'].includes(_this.iceConnectionState)) {
                _this._disconnect(new MediaDTLSTransportFailedError());
            }
        });
        _this.on('iceConnectionStateChanged', function () { return maybeUpdateState(_this); });
        _this.on('signalingConnectionStateChanged', function () { return maybeUpdateState(_this); });
        // NOTE(mmalavalli): In case "iceConnectionState" is already failed, update
        // the RoomSignaling state. setTimeout() ensures that the state is updated
        // after RoomV2's constructor is fully executed, thereby making "signalingConnectionState"
        // available here.
        setTimeout(function () { return maybeUpdateState(_this); });
        return _this;
    }
    /**
     * Disconnect, possibly with an Error.
     * @private
     * @param {Error} [error]
     * @returns {boolean}
     */
    RoomSignaling.prototype._disconnect = function (error) {
        if (this.state !== 'disconnected') {
            this.preempt('disconnected', null, [error]);
            return true;
        }
        return false;
    };
    RoomSignaling.prototype.toString = function () {
        return "[RoomSignaling #" + this._instanceId + ": " + (this.localParticipant ? this.localParticipant.sid : 'null') + "]";
    };
    /**
     * Connect {@link RemoteParticipantSignaling} to the {@link RoomSignaling}.
     * @param {RemoteParticipantSignaling} participant
     * @returns {boolean}
     */
    RoomSignaling.prototype.connectParticipant = function (participant) {
        var self = this;
        if (participant.state === 'disconnected') {
            return false;
        }
        if (this.participants.has(participant.sid)) {
            return false;
        }
        this.participants.set(participant.sid, participant);
        participant.on('stateChanged', function stateChanged(state) {
            if (state === 'disconnected') {
                participant.removeListener('stateChanged', stateChanged);
                self.participants.delete(participant.sid);
                self.emit('participantDisconnected', participant);
            }
        });
        this.emit('participantConnected', participant);
        return true;
    };
    /**
     * Disconnect.
     * @returns {boolean}
     */
    RoomSignaling.prototype.disconnect = function () {
        return this._disconnect();
    };
    /**
     * Set (or unset) the Dominant Speaker.
     * @param {?Participant.SID} dominantSpeakerSid
     * @returns {void}
     */
    RoomSignaling.prototype.setDominantSpeaker = function (dominantSpeakerSid) {
        this.dominantSpeakerSid = dominantSpeakerSid;
        this.emit('dominantSpeakerChanged');
    };
    return RoomSignaling;
}(StateMachine));
/**
 * @event RoomSignaling#event:connectionStateChanged
 */
/**
 * @event RoomSignaling#event:dominantSpeakerChanged
 */
/**
 * {@link RemoteParticipantSignaling} connected to the {@link RoomSignaling}.
 * @event RoomSignaling#event:participantConnected
 * @param {RemoteParticipantSignaling} participantSignaling
 */
/**
 * {@link RemoteParticipantSignaling} disconnected from the {@link RoomSignaling}.
 * @event RoomSignaling#event:participantDisconnected
 * @param {RemoteParticipantSignaling} participantSignaling
 */
/**
 * @event RoomSignaling#event:iceConnectionStateChanged
 */
/**
 * @event RoomSignaling#event:signalingConnectionStateChanged
 */
/**
 * Maybe update the {@link RoomSignaling} state.
 * @param {RoomSignaling} roomSignaling
 */
function maybeUpdateState(roomSignaling) {
    if (roomSignaling.state === 'disconnected' || roomSignaling.signalingConnectionState === 'disconnected') {
        roomSignaling._sessionTimeout.clear();
        return;
    }
    var newState;
    if (roomSignaling.signalingConnectionState === 'reconnecting') {
        newState = roomSignaling.signalingConnectionState;
    }
    else if (roomSignaling.iceConnectionState === 'failed') {
        roomSignaling._mediaConnectionIsReconnecting = true;
        newState = 'reconnecting';
    }
    else if (roomSignaling.iceConnectionState === 'new' || roomSignaling.iceConnectionState === 'checking') {
        newState = roomSignaling._mediaConnectionIsReconnecting ? 'reconnecting' : 'connected';
    }
    else {
        roomSignaling._mediaConnectionIsReconnecting = false;
        roomSignaling._reconnectingError = null;
        roomSignaling._sessionTimeout.clear();
        newState = 'connected';
    }
    if (newState === roomSignaling.state) {
        return;
    }
    if (newState === 'reconnecting') {
        roomSignaling._reconnectingError = roomSignaling.signalingConnectionState === 'reconnecting'
            ? new SignalingConnectionDisconnectedError()
            : new MediaConnectionError();
        roomSignaling._sessionTimeout.start();
        roomSignaling.preempt(newState, null, [roomSignaling._reconnectingError]);
    }
    else {
        roomSignaling.preempt(newState);
    }
}
module.exports = RoomSignaling;

},{"../statemachine":89,"../util":133,"../util/constants":126,"../util/log":137,"../util/timeout":147,"../util/twilio-video-errors":148,"./recording":63}],67:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var EventEmitter = require('events').EventEmitter;
/**
 * A {@link Track} implementation
 * @extends EventEmitter
 * @property {Track.Kind} kind
 * @property {string} name
 */
var TrackSignaling = /** @class */ (function (_super) {
    __extends(TrackSignaling, _super);
    /**
     * Construct a {@link TrackSignaling}.
     * @param {string} name
     * @param {Track.Kind} kind
     * @param {boolean} isEnabled
     * @param {Track.Priority} priority
     */
    function TrackSignaling(name, kind, isEnabled, priority) {
        var _this = _super.call(this) || this;
        var sid = null;
        Object.defineProperties(_this, {
            _error: {
                value: null,
                writable: true
            },
            _isEnabled: {
                value: isEnabled,
                writable: true
            },
            _priority: {
                value: priority,
                writable: true
            },
            _trackTransceiver: {
                value: null,
                writable: true
            },
            _sid: {
                get: function () {
                    return sid;
                },
                set: function (_sid) {
                    if (sid === null) {
                        sid = _sid;
                    }
                }
            },
            kind: {
                enumerable: true,
                value: kind
            },
            name: {
                enumerable: true,
                value: name
            }
        });
        return _this;
    }
    Object.defineProperty(TrackSignaling.prototype, "error", {
        /**
         * Non-null if publication or subscription failed.
         * @property {?Error} error
         */
        get: function () {
            return this._error;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TrackSignaling.prototype, "isEnabled", {
        /**
         * Whether the {@link TrackSignaling} is enabled.
         * @property {boolean}
         */
        get: function () {
            return this._isEnabled;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TrackSignaling.prototype, "priority", {
        /**
         * The {@link TrackSignaling}'s priority.
         * @property {Track.Priority}
         */
        get: function () {
            return this._priority;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TrackSignaling.prototype, "sid", {
        /**
         * The {@link TrackSignaling}'s {@link Track.SID}.
         * @property {Track.SID}
         */
        get: function () {
            return this._sid;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TrackSignaling.prototype, "trackTransceiver", {
        /**
         * The {@link TrackSignaling}'s {@link TrackTransceiver}.
         * @property {TrackTransceiver}
         */
        get: function () {
            return this._trackTransceiver;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Disable the {@link TrackSignaling} if it is not already disabled.
     * @return {this}
     */
    TrackSignaling.prototype.disable = function () {
        return this.enable(false);
    };
    /**
     * Enable (or disable) the {@link TrackSignaling} if it is not already enabled
     * (or disabled).
     * @param {boolean} [enabled=true]
     * @return {this}
     */
    TrackSignaling.prototype.enable = function (enabled) {
        enabled = typeof enabled === 'boolean' ? enabled : true;
        if (this.isEnabled !== enabled) {
            this._isEnabled = enabled;
            this.emit('updated');
        }
        return this;
    };
    /**
     * Set the {@link TrackTransceiver} on the {@link TrackSignaling}.
     * @param {TrackTransceiver} trackTransceiver
     * @returns {this}
     */
    TrackSignaling.prototype.setTrackTransceiver = function (trackTransceiver) {
        trackTransceiver = trackTransceiver || null;
        if (this.trackTransceiver !== trackTransceiver) {
            this._trackTransceiver = trackTransceiver;
            this.emit('updated');
        }
        return this;
    };
    /**
     * Set the SID on the {@link TrackSignaling} once.
     * @param {string} sid
     * @returns {this}
     */
    TrackSignaling.prototype.setSid = function (sid) {
        if (this.sid === null) {
            this._sid = sid;
            this.emit('updated');
        }
        return this;
    };
    return TrackSignaling;
}(EventEmitter));
/**
 * Emitted whenever the {@link TrackSignaling} is updated
 * @event TrackSignaling#updated
 */
module.exports = TrackSignaling;

},{"events":174}],68:[function(require,module,exports){
'use strict';
var CancelablePromise = require('../../util/cancelablepromise');
var DefaultPeerConnectionManager = require('./peerconnectionmanager');
var DefaultRoomV2 = require('./room');
var DefaultTransport = require('./twilioconnectiontransport');
var _a = require('../../util/twilio-video-errors'), SignalingConnectionDisconnectedError = _a.SignalingConnectionDisconnectedError, SignalingIncomingMessageInvalidError = _a.SignalingIncomingMessageInvalidError;
var _b = require('../../util'), flatMap = _b.flatMap, createRoomConnectEventPayload = _b.createRoomConnectEventPayload;
function createCancelableRoomSignalingPromise(token, wsServer, localParticipant, encodingParameters, preferredCodecs, options) {
    options = Object.assign({
        PeerConnectionManager: DefaultPeerConnectionManager,
        RoomV2: DefaultRoomV2,
        Transport: DefaultTransport
    }, options);
    var adaptiveSimulcast = preferredCodecs.video[0] && preferredCodecs.video[0].adaptiveSimulcast === true;
    var PeerConnectionManager = options.PeerConnectionManager, RoomV2 = options.RoomV2, Transport = options.Transport, iceServers = options.iceServers, log = options.log;
    var peerConnectionManager = new PeerConnectionManager(encodingParameters, preferredCodecs, options);
    var trackSenders = flatMap(localParticipant.tracks, function (trackV2) { return [trackV2.trackTransceiver]; });
    peerConnectionManager.setTrackSenders(trackSenders);
    var cancellationError = new Error('Canceled');
    var transport;
    var cancelablePromise = new CancelablePromise(function (resolve, reject, isCanceled) {
        var onIced = function (iceServers) {
            if (isCanceled()) {
                reject(cancellationError);
                return Promise.reject(cancellationError);
            }
            log.debug('Got ICE servers:', iceServers);
            options.iceServers = iceServers;
            peerConnectionManager.setConfiguration(options);
            return peerConnectionManager.createAndOffer().then(function () {
                if (isCanceled()) {
                    reject(cancellationError);
                    throw cancellationError;
                }
                log.debug('createAndOffer() succeeded.');
                // NOTE(mmalavalli): PeerConnectionManager#createAndOffer() queues the
                // initial offer in the event queue for the 'description' event. So,
                // we are dequeueing to prevent the spurious 'update' message sent by
                // the client after connecting to a room.
                peerConnectionManager.dequeue('description');
            }).catch(function (error) {
                log.error('createAndOffer() failed:', error);
                reject(error);
                throw error;
            });
        };
        var automaticSubscription = options.automaticSubscription, bandwidthProfile = options.bandwidthProfile, dominantSpeaker = options.dominantSpeaker, environment = options.environment, eventObserver = options.eventObserver, loggerName = options.loggerName, logLevel = options.logLevel, name = options.name, networkMonitor = options.networkMonitor, networkQuality = options.networkQuality, notifyWarnings = options.notifyWarnings, realm = options.realm, sdpSemantics = options.sdpSemantics;
        // decide which msp channels to request
        // dominantSpeaker, networkQuality
        var trackPriority = !!bandwidthProfile;
        var trackSwitchOff = !!bandwidthProfile;
        var renderHints = !!bandwidthProfile &&
            (options.clientTrackSwitchOffControl !== 'disabled' || options.contentPreferencesMode !== 'disabled');
        var transportOptions = Object.assign({
            adaptiveSimulcast: adaptiveSimulcast,
            automaticSubscription: automaticSubscription,
            dominantSpeaker: dominantSpeaker,
            environment: environment,
            eventObserver: eventObserver,
            loggerName: loggerName,
            logLevel: logLevel,
            networkMonitor: networkMonitor,
            networkQuality: networkQuality,
            notifyWarnings: notifyWarnings,
            iceServers: iceServers,
            onIced: onIced,
            realm: realm,
            renderHints: renderHints,
            sdpSemantics: sdpSemantics,
            trackPriority: trackPriority,
            trackSwitchOff: trackSwitchOff
        }, bandwidthProfile ? {
            bandwidthProfile: bandwidthProfile
        } : {});
        transport = new Transport(name, token, localParticipant, peerConnectionManager, wsServer, transportOptions);
        var connectEventPayload = createRoomConnectEventPayload(options);
        eventObserver.emit('event', connectEventPayload);
        transport.once('connected', function (initialState) {
            log.debug('Transport connected:', initialState);
            if (isCanceled()) {
                reject(cancellationError);
                return;
            }
            var localParticipantState = initialState.participant;
            if (!localParticipantState) {
                reject(new SignalingIncomingMessageInvalidError());
                return;
            }
            resolve(new RoomV2(localParticipant, initialState, transport, peerConnectionManager, options));
        });
        transport.once('stateChanged', function (state, error) {
            if (state === 'disconnected') {
                transport = null;
                reject(error || new SignalingConnectionDisconnectedError());
            }
            else {
                log.debug('Transport state changed:', state);
            }
        });
    }, function () {
        if (transport) {
            transport.disconnect();
            transport = null;
        }
    });
    cancelablePromise.catch(function () {
        if (transport) {
            transport.disconnect();
            transport = null;
        }
        peerConnectionManager.close();
    });
    return cancelablePromise;
}
module.exports = createCancelableRoomSignalingPromise;

},{"../../util":133,"../../util/cancelablepromise":125,"../../util/twilio-video-errors":148,"./peerconnectionmanager":79,"./room":85,"./twilioconnectiontransport":88}],69:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var MediaSignaling = require('./mediasignaling');
/**
 * @property {?Track.SID} loudestParticipantSid
 * @emits DominantSpeakerSignaling#updated
 */
var DominantSpeakerSignaling = /** @class */ (function (_super) {
    __extends(DominantSpeakerSignaling, _super);
    /**
     * Construct an {@link DominantSpeakerSignaling}.
     */
    function DominantSpeakerSignaling(getReceiver, options) {
        var _this = _super.call(this, getReceiver, 'active_speaker', options) || this;
        Object.defineProperties(_this, {
            _loudestParticipantSid: {
                value: null,
                writable: true
            },
        });
        _this.on('ready', function (transport) {
            transport.on('message', function (message) {
                switch (message.type) {
                    case 'active_speaker':
                        _this._setLoudestParticipantSid(message.participant);
                        break;
                    default:
                        break;
                }
            });
        });
        return _this;
    }
    Object.defineProperty(DominantSpeakerSignaling.prototype, "loudestParticipantSid", {
        /**
         * Get the loudest {@link Track.SID}, if known.
         * @returns {?Track.SID}
         */
        get: function () {
            return this._loudestParticipantSid;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * @private
     * @param {Track.SID} loudestParticipantSid
     * @returns {void}
     */
    DominantSpeakerSignaling.prototype._setLoudestParticipantSid = function (loudestParticipantSid) {
        if (this.loudestParticipantSid === loudestParticipantSid) {
            return;
        }
        this._loudestParticipantSid = loudestParticipantSid;
        this.emit('updated');
    };
    return DominantSpeakerSignaling;
}(MediaSignaling));
/**
 * @event DominantSpeakerSignaling#updated
 */
module.exports = DominantSpeakerSignaling;

},{"./mediasignaling":75}],70:[function(require,module,exports){
'use strict';
var Filter = require('../../util/filter');
/**
 * An {@link IceBox} stores trickled ICE candidates. Candidates added to the
 * {@link IceBox} via {@link IceBox#update} are compared against previously
 * trickled candidates and only new candidates will be returned (assuming they
 * match the current ICE username fragment set by {@link IceBox#setUfrag}).
 * @property {?string} ufrag
 */
var IceBox = /** @class */ (function () {
    /**
     * Construct an {@link IceBox}.
     */
    function IceBox() {
        Object.defineProperties(this, {
            _filter: {
                value: new Filter({
                    getKey: function getKey(iceState) {
                        return iceState.ufrag;
                    },
                    isLessThanOrEqualTo: function isLessThanOrEqualTo(a, b) {
                        return a.revision <= b.revision;
                    }
                })
            },
            _ufrag: {
                writable: true,
                value: null
            },
            ufrag: {
                enumerable: true,
                get: function () {
                    return this._ufrag;
                }
            }
        });
    }
    /**
     * Set the ICE username fragment on the {@link IceBox}. This method returns any
     * ICE candidates associated with the username fragment.
     * @param {string} ufrag
     * @returns {Array<RTCIceCandidateInit>}
     */
    IceBox.prototype.setUfrag = function (ufrag) {
        this._ufrag = ufrag;
        var ice = this._filter.toMap().get(ufrag);
        return ice ? ice.candidates : [];
    };
    /**
     * Update the {@link IceBox}. This method returns any new ICE candidates
     * associated with the current username fragment.
     * @param {object} iceState
     * @returns {Array<RTCIceCandidateInit>}
     */
    IceBox.prototype.update = function (iceState) {
        // NOTE(mroberts): The Server sometimes does not set the candidates property.
        iceState.candidates = iceState.candidates || [];
        var oldIceState = this._filter.toMap().get(iceState.ufrag);
        var oldCandidates = oldIceState ? oldIceState.candidates : [];
        return this._filter.update(iceState) && this._ufrag === iceState.ufrag
            ? iceState.candidates.slice(oldCandidates.length)
            : [];
    };
    return IceBox;
}());
module.exports = IceBox;

},{"../../util/filter":132}],71:[function(require,module,exports){
'use strict';
var _a = require('../../util/constants'), ICE_ACTIVITY_CHECK_PERIOD_MS = _a.ICE_ACTIVITY_CHECK_PERIOD_MS, ICE_INACTIVITY_THRESHOLD_MS = _a.ICE_INACTIVITY_THRESHOLD_MS;
/**
 * Monitors a {@link RTCPeerConnection}'s stats and notifies
 * caller when inactivity is detected.
 */
var IceConnectionMonitor = /** @class */ (function () {
    /**
     * Construct an {@link IceConnectionMonitor}.
     * @param {RTCPeerConnection} peerConnection
     * @param {object} [options]
     */
    function IceConnectionMonitor(peerConnection, options) {
        options = Object.assign({
            activityCheckPeriodMs: ICE_ACTIVITY_CHECK_PERIOD_MS,
            inactivityThresholdMs: ICE_INACTIVITY_THRESHOLD_MS,
        }, options);
        Object.defineProperties(this, {
            _activityCheckPeriodMs: {
                value: options.activityCheckPeriodMs
            },
            _inactivityThresholdMs: {
                value: options.inactivityThresholdMs
            },
            _lastActivity: {
                value: null,
                writable: true
            },
            _peerConnection: {
                value: peerConnection
            },
            _timer: {
                value: null,
                writable: true,
            },
            _onIceConnectionStateChanged: {
                value: null,
                writable: true
            }
        });
    }
    IceConnectionMonitor.prototype._getActivePairStat = function (stats) {
        var statsArray = Array.from(stats.values());
        var activePairStats = statsArray.find(function (stat) { return stat.type === 'candidate-pair' && stat.nominated; });
        // NOTE(mpatwardhan): sometimes (JSDK-2667) after getting disconnected while switching network
        // we may not find active pair. Treat this as 0 bytesReceived so that we count it towards inactivity.
        return activePairStats || {
            bytesReceived: 0,
            timestamp: Math.round((new Date()).getTime())
        };
    };
    /**
     * Get ICE connection stats, and extract received and send bytes.
     * @returns Promise<?RTCIceCandidatePairStats>
     */
    IceConnectionMonitor.prototype._getIceConnectionStats = function () {
        var _this = this;
        return this._peerConnection.getStats().then(function (stats) { return _this._getActivePairStat(stats); }).catch(function () {
            return null;
        });
    };
    /**
     * schedules/un-schedules inactivity callback.
     */
    IceConnectionMonitor.prototype._scheduleInactivityCallback = function (callback) {
        var _this = this;
        if (callback && this._onIceConnectionStateChanged === null) {
            // schedule callback
            this._onIceConnectionStateChanged = function () {
                if (_this._peerConnection.iceConnectionState === 'disconnected') {
                    // eslint-disable-next-line callback-return
                    callback();
                }
            };
            this._peerConnection.addEventListener('iceconnectionstatechange', this._onIceConnectionStateChanged);
        }
        else if (!callback && this._onIceConnectionStateChanged) {
            // unschedule callback
            this._peerConnection.removeEventListener('iceconnectionstatechange', this._onIceConnectionStateChanged);
            this._onIceConnectionStateChanged = null;
        }
    };
    /**
     * Start monitoring the ICE connection.
     * Monitors bytes received on active ice connection pair,
     * invokes onIceConnectionInactive when inactivity is detected.
     * @param {function} onIceConnectionInactive
     */
    IceConnectionMonitor.prototype.start = function (onIceConnectionInactive) {
        var _this = this;
        this.stop();
        this._timer = setInterval(function () {
            _this._getIceConnectionStats().then(function (iceStats) {
                if (!iceStats) {
                    return;
                }
                // NOTE(mpatwardhan): We look at bytesReceived on active candidate pair as an indication of active ice connection.
                // As per spec (https://w3c.github.io/webrtc-stats/#dom-rtcicecandidatepairstats-bytesreceived) this value
                // includes RTCP traffic and is +ve even when there are no tracks subscribed to.
                if (!_this._lastActivity || _this._lastActivity.bytesReceived !== iceStats.bytesReceived) {
                    _this._lastActivity = iceStats;
                    // detected activity, cancel scheduled callback if any.
                    _this._scheduleInactivityCallback(null);
                }
                if (iceStats.timestamp - _this._lastActivity.timestamp >= _this._inactivityThresholdMs) {
                    // detected inactivity.
                    if (_this._peerConnection.iceConnectionState === 'disconnected') {
                        onIceConnectionInactive();
                    }
                    else if (_this._onIceConnectionStateChanged === null) {
                        _this._scheduleInactivityCallback(onIceConnectionInactive);
                    }
                }
            });
        }, this._activityCheckPeriodMs);
    };
    /**
     * Stop monitoring the ICE connection state.
     * @returns {void}
     */
    IceConnectionMonitor.prototype.stop = function () {
        this._scheduleInactivityCallback(null);
        if (this._timer !== null) {
            clearInterval(this._timer);
            this._timer = null;
            this._lastActivity = null;
        }
    };
    return IceConnectionMonitor;
}());
module.exports = IceConnectionMonitor;

},{"../../util/constants":126}],72:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var defaultCreateCancelableRoomSignalingPromise = require('./cancelableroomsignalingpromise');
var LocalParticipantV2 = require('./localparticipant');
var Signaling = require('../');
/**
 * {@link SignalingV2} implements version 2 of our signaling protocol.
 * @extends Signaling
 */
var SignalingV2 = /** @class */ (function (_super) {
    __extends(SignalingV2, _super);
    /**
     * Construct {@link SignalingV2}.
     * @param {string} wsServer
     * @param {?object} [options={}]
     */
    function SignalingV2(wsServer, options) {
        var _this = this;
        /* eslint new-cap:0 */
        options = Object.assign({
            createCancelableRoomSignalingPromise: defaultCreateCancelableRoomSignalingPromise
        }, options);
        _this = _super.call(this) || this;
        Object.defineProperties(_this, {
            _createCancelableRoomSignalingPromise: {
                value: options.createCancelableRoomSignalingPromise
            },
            _options: {
                value: options
            },
            _wsServer: {
                value: wsServer
            }
        });
        return _this;
    }
    /**
     * @private
     */
    SignalingV2.prototype._connect = function (localParticipant, token, encodingParameters, preferredCodecs, options) {
        options = Object.assign({}, this._options, options);
        return this._createCancelableRoomSignalingPromise.bind(null, token, this._wsServer, localParticipant, encodingParameters, preferredCodecs, options);
    };
    SignalingV2.prototype.createLocalParticipantSignaling = function (encodingParameters, networkQualityConfiguration) {
        return new LocalParticipantV2(encodingParameters, networkQualityConfiguration);
    };
    return SignalingV2;
}(Signaling));
module.exports = SignalingV2;

},{"../":59,"./cancelableroomsignalingpromise":68,"./localparticipant":73}],73:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var LocalParticipantSignaling = require('../localparticipant');
var LocalTrackPublicationV2 = require('./localtrackpublication');
var DEFAULT_LOG_LEVEL = require('../../util/constants').DEFAULT_LOG_LEVEL;
var Log = require('../../util/log');
var _a = require('../../util'), buildLogLevels = _a.buildLogLevels, isDeepEqual = _a.isDeepEqual;
/**
 * @extends ParticipantSignaling
 * @property {BandwidthProfileOptions} bandwidthProfile
 * @property {NetworkQualityConfigurationImpl} networkQualityConfiguration
 * @property {number} revision
 * @emits LocalParticipantV2#updated
 */
var LocalParticipantV2 = /** @class */ (function (_super) {
    __extends(LocalParticipantV2, _super);
    /**
     * Construct a {@link LocalParticipantV2}.
     * @param {EncodingParametersImpl} encodingParameters
     * @param {NetworkQualityConfigurationImpl} networkQualityConfiguration
     * @param {object} [options]
     */
    function LocalParticipantV2(encodingParameters, networkQualityConfiguration, options) {
        var _this = this;
        options = Object.assign({
            logLevel: DEFAULT_LOG_LEVEL,
            LocalTrackPublicationV2: LocalTrackPublicationV2
        }, options);
        _this = _super.call(this) || this;
        var logLevels = buildLogLevels(options.logLevel);
        Object.defineProperties(_this, {
            _bandwidthProfile: {
                value: null,
                writable: true
            },
            _bandwidthProfileRevision: {
                value: 0,
                writable: true
            },
            _encodingParameters: {
                value: encodingParameters
            },
            _removeListeners: {
                value: new Map()
            },
            _LocalTrackPublicationV2: {
                value: options.LocalTrackPublicationV2
            },
            _log: {
                value: options.log
                    ? options.log.createLog('default', _this)
                    : new Log('default', _this, logLevels, options.loggerName)
            },
            _publishedRevision: {
                writable: true,
                value: 0
            },
            _revision: {
                writable: true,
                value: 1
            },
            _signalingRegion: {
                value: null,
                writable: true
            },
            audioProcessors: {
                value: [],
                writable: true
            },
            bandwidthProfile: {
                enumerable: true,
                get: function () {
                    return this._bandwidthProfile;
                }
            },
            bandwidthProfileRevision: {
                enumerable: true,
                get: function () {
                    return this._bandwidthProfileRevision;
                }
            },
            networkQualityConfiguration: {
                enumerable: true,
                value: networkQualityConfiguration
            },
            revision: {
                enumerable: true,
                get: function () {
                    return this._revision;
                }
            },
            signalingRegion: {
                enumerable: true,
                get: function () {
                    return this._signalingRegion;
                }
            }
        });
        return _this;
    }
    LocalParticipantV2.prototype.toString = function () {
        return "[LocalParticipantSignaling: " + this.sid + "]";
    };
    /**
     * Set the signalingRegion.
     * @param {string} signalingRegion.
     */
    LocalParticipantV2.prototype.setSignalingRegion = function (signalingRegion) {
        if (!this._signalingRegion) {
            this._signalingRegion = signalingRegion;
        }
    };
    /**
     * Update the {@link BandwidthProfileOptions}.
     * @param {BandwidthProfileOptions} bandwidthProfile
     */
    LocalParticipantV2.prototype.setBandwidthProfile = function (bandwidthProfile) {
        if (!isDeepEqual(this._bandwidthProfile, bandwidthProfile)) {
            // NOTE(mmalavalli): Object.assign() copies the values of only
            // the top level properties. In order to deep copy the object, we
            // stringify and parse the object.
            this._bandwidthProfile = JSON.parse(JSON.stringify(bandwidthProfile));
            this._bandwidthProfileRevision++;
            this.didUpdate();
        }
    };
    /**
     * Sets the AudioProcessors enabled for this room.
     * @param {string[]} audioProcessors
     */
    LocalParticipantV2.prototype.setAudioProcessors = function (audioProcessors) {
        this.audioProcessors = audioProcessors;
    };
    /**
     * returns current {@link EncodingParametersImpl}.
     * @returns {EncodingParametersImpl}
     */
    LocalParticipantV2.prototype.getParameters = function () {
        return this._encodingParameters;
    };
    /**
     * Set the {@link EncodingParameters}.
     * @param {?EncodingParameters} encodingParameters
     * @returns {this}
     */
    LocalParticipantV2.prototype.setParameters = function (encodingParameters) {
        this._encodingParameters.update(encodingParameters);
        return this;
    };
    /**
     * Update the {@link LocalParticipantV2} with the new state.
     * @param {Published} published
     * @returns {this}
     */
    LocalParticipantV2.prototype.update = function (published) {
        if (this._publishedRevision >= published.revision) {
            return this;
        }
        this._publishedRevision = published.revision;
        published.tracks.forEach(function (publicationState) {
            var localTrackPublicationV2 = this.tracks.get(publicationState.id);
            if (localTrackPublicationV2) {
                localTrackPublicationV2.update(publicationState);
            }
        }, this);
        return this;
    };
    LocalParticipantV2.prototype.updateMediaStates = function (mediaStates) {
        if (!mediaStates || !mediaStates.tracks) {
            return this;
        }
        Array.from(this.tracks.values()).forEach(function (publication) {
            var states = mediaStates.tracks[publication.sid];
            if (states) {
                publication.updateMediaStates(states);
            }
        });
        return this;
    };
    /**
     * @protected
     * @param {DataTrackSender|MediaTrackSender} trackSender
     * @param {string} name
     * @param {Track.Priority} priority
     * @param {?NoiseCancellationVendor} noiseCancellationVendor
     * @returns {LocalTrackPublicationV2}
     */
    LocalParticipantV2.prototype._createLocalTrackPublicationSignaling = function (trackSender, name, priority, noiseCancellationVendor) {
        return new this._LocalTrackPublicationV2(trackSender, name, priority, noiseCancellationVendor, { log: this._log });
    };
    /**
     * Add a {@link LocalTrackPublicationV2} for the given {@link DataTrackSender}
     * or {@link MediaTrackSender} to the {@link LocalParticipantV2}.
     * @param {DataTrackSender|MediaTrackSender} trackSender
     * @param {string} name
     * @param {Track.Priority} priority
     * @returns {this}
     */
    LocalParticipantV2.prototype.addTrack = function (trackSender, name, priority, noiseCancellationVendor) {
        var _this = this;
        _super.prototype.addTrack.call(this, trackSender, name, priority, noiseCancellationVendor);
        var publication = this.getPublication(trackSender);
        var isEnabled = publication.isEnabled, updatedPriority = publication.updatedPriority;
        var updated = function () {
            // NOTE(mmalavalli): The LocalParticipantV2's state is only published if
            // the "updated" event is emitted due to LocalTrackPublicationV2's
            // .isEnabled or .updatedPriority being changed. We do not publish if it is fired due to the
            // LocalTrackPublicationV2's .sid being set.
            if (isEnabled !== publication.isEnabled || updatedPriority !== publication.updatedPriority) {
                _this.didUpdate();
                isEnabled = publication.isEnabled;
                updatedPriority = publication.updatedPriority;
            }
        };
        publication.on('updated', updated);
        this._removeListener(publication);
        this._removeListeners.set(publication, function () { return publication.removeListener('updated', updated); });
        this.didUpdate();
        return this;
    };
    /**
     * @private
     * @param {LocalTrackPublicationV2} publication
     * @returns {void}
     */
    LocalParticipantV2.prototype._removeListener = function (publication) {
        var removeListener = this._removeListeners.get(publication);
        if (removeListener) {
            removeListener();
        }
    };
    /**
     * Get the current state of the {@link LocalParticipantV2}.
     * @returns {object}
     */
    LocalParticipantV2.prototype.getState = function () {
        return {
            revision: this.revision,
            tracks: Array.from(this.tracks.values()).map(function (track) { return track.getState(); })
        };
    };
    /**
     * Increment the revision for the {@link LocalParticipantV2}.
     * @private
     * @returns {void}
     */
    LocalParticipantV2.prototype.didUpdate = function () {
        this._revision++;
        this.emit('updated');
    };
    /**
     * Remove the {@link LocalTrackPublicationV2} for the given {@link DataTrackSender}
     * or {@link MediaTrackSender} from the {@link LocalParticipantV2}.
     * @param {DataTrackSender|MediaTrackSender} trackSender
     * @returns {?LocalTrackPublicationV2}
     */
    LocalParticipantV2.prototype.removeTrack = function (trackSender) {
        var publication = _super.prototype.removeTrack.call(this, trackSender);
        if (publication) {
            trackSender.removeClone(publication.trackTransceiver);
            this._removeListener(publication);
            this.didUpdate();
        }
        return publication;
    };
    /**
     * Updates the verbosity of network quality information.
     * @param {NetworkQualityConfiguration} networkQualityConfiguration
     * @returns {void}
     */
    LocalParticipantV2.prototype.setNetworkQualityConfiguration = function (networkQualityConfiguration) {
        this.networkQualityConfiguration.update(networkQualityConfiguration);
    };
    /**
     * updates encodings for simulcast layers.
     * @param {Track.SID} trackSid
     * @param {Array<{enabled: boolean, layer_index: number}>} encodings
     * @returns {Promise<string>} string indicating result of the operation. can be one of
     *  "OK", "INVALID_HINT", "COULD_NOT_APPLY_HINT", "UNKNOWN_TRACK"
     */
    LocalParticipantV2.prototype.setPublisherHint = function (trackSid, encodings) {
        var trackSignaling = Array.from(this.tracks.values()).find(function (trackPub) { return trackPub.sid === trackSid; });
        if (!trackSignaling) {
            this._log.warn("track:" + trackSid + " not found");
            return Promise.resolve('UNKNOWN_TRACK');
        }
        return trackSignaling.trackTransceiver.setPublisherHint(encodings);
    };
    return LocalParticipantV2;
}(LocalParticipantSignaling));
/**
 * @interface Published
 * @property {number} revision
 * @property {Array<PublishedTrack>} tracks
 */
/**
 * @typedef {CreatedTrack|ReadyTrack|FailedTrack} PublishedTrack
 */
/**
 * @interface CreatedTrack
 * @property {Track.ID} id
 * @property {string} state - "created"
 */
/**
 * @interface ReadyTrack
 * @property {Track.ID} id
 * @property {Track.SID} sid
 * @property {string} state - "ready"
 */
/**
 * @interface FailedTrack
 * @property {Track.ID} id
 * @property {TrackError} error
 * @property {string} state - "failed"
 */
/**
 * @interface TrackError
 * @property {number} code
 * @property {string} message
 */
/**
 * @event LocalParticipantV2#updated
 */
module.exports = LocalParticipantV2;

},{"../../util":133,"../../util/constants":126,"../../util/log":137,"../localparticipant":60,"./localtrackpublication":74}],74:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var LocalTrackPublicationSignaling = require('../localtrackpublication');
var TwilioWarning = require('../../util/twiliowarning');
var createTwilioError = require('../../util/twilio-video-errors').createTwilioError;
/**
 * @extends LocalTrackPublicationSignaling
 */
var LocalTrackPublicationV2 = /** @class */ (function (_super) {
    __extends(LocalTrackPublicationV2, _super);
    /**
     * Construct a {@link LocalTrackPublicationV2}.
     * @param {DataTrackSender|MediaTrackSender} trackSender
     * @param {string} name
     * @param {Track.Priority} priority
     * @param {?NoiseCancellationVendor} noiseCancellationVendor
     * @param {object} [options]
     */
    function LocalTrackPublicationV2(trackSender, name, priority, noiseCancellationVendor, options) {
        var _this = _super.call(this, trackSender, name, priority) || this;
        Object.defineProperties(_this, {
            _log: {
                value: options.log.createLog('default', _this)
            },
            _mediaStates: {
                value: { recordings: null },
                writable: true
            },
            _noiseCancellationVendor: {
                value: noiseCancellationVendor,
            }
        });
        return _this;
    }
    /**
     * Get the {@link LocalTrackPublicationV2#Representation} of a given {@link TrackSignaling}.
     * @returns {LocalTrackPublicationV2#Representation} - without the SID
     */
    LocalTrackPublicationV2.prototype.getState = function () {
        var state = {
            enabled: this.isEnabled,
            id: this.id,
            kind: this.kind,
            name: this.name,
            priority: this.updatedPriority,
        };
        if (this._noiseCancellationVendor) {
            // eslint-disable-next-line camelcase
            state.audio_processor = this._noiseCancellationVendor;
        }
        return state;
    };
    LocalTrackPublicationV2.prototype.toString = function () {
        return "[LocalTrackPublicationV2: " + this.sid + "]";
    };
    /**
     * Compare the {@link LocalTrackPublicationV2} to a {@link LocalTrackPublicationV2#Representation} of itself
     * and perform any updates necessary.
     * @param {PublishedTrack} track
     * @returns {this}
     * @fires TrackSignaling#updated
     */
    LocalTrackPublicationV2.prototype.update = function (track) {
        switch (track.state) {
            case 'ready':
                this.setSid(track.sid);
                break;
            case 'failed': {
                var error = track.error;
                this.publishFailed(createTwilioError(error.code, error.message));
                break;
            }
            default: // 'created'
                break;
        }
        return this;
    };
    LocalTrackPublicationV2.prototype.updateMediaStates = function (mediaStates) {
        if (!mediaStates || !mediaStates.recordings ||
            this._mediaStates.recordings === mediaStates.recordings) {
            return this;
        }
        this._mediaStates.recordings = mediaStates.recordings;
        switch (this._mediaStates.recordings) {
            case 'OK':
                this._log.info('Warnings have cleared.');
                this.emit('warningsCleared');
                break;
            case 'NO_MEDIA':
                this._log.warn('Recording media lost.');
                this.emit('warning', TwilioWarning.recordingMediaLost);
                break;
            default:
                this._log.warn("Unknown media state detected: " + this._mediaStates.recordings);
                break;
        }
        return this;
    };
    return LocalTrackPublicationV2;
}(LocalTrackPublicationSignaling));
/**
 * The Room Signaling Protocol (RSP) representation of a {@link LocalTrackPublicationV2}.
 * @typedef {object} LocalTrackPublicationV2#Representation
 * @property {boolean} enabled
 * @property {Track.ID} id
 * @property {Track.Kind} kind
 * @property {string} name
 * @priority {Track.Priority} priority
 * @property {Track.SID} sid
 */
module.exports = LocalTrackPublicationV2;

},{"../../util/twilio-video-errors":148,"../../util/twiliowarning":150,"../localtrackpublication":61}],75:[function(require,module,exports){
/* eslint callback-return:0 */
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var EventEmitter = require('events');
var nInstances = 0;
var MediaSignaling = /** @class */ (function (_super) {
    __extends(MediaSignaling, _super);
    /**
     * Construct a {@link MediaSignaling}.
     * @param {Promise<DataTrackReceiver>} getReceive
     * @param {string} channel
     */
    function MediaSignaling(getReceiver, channel, options) {
        var _this = _super.call(this) || this;
        Object.defineProperties(_this, {
            _instanceId: {
                value: nInstances++
            },
            channel: {
                value: channel,
            },
            _log: {
                value: options.log.createLog('default', _this)
            },
            _getReceiver: {
                value: getReceiver
            },
            _receiverPromise: {
                value: null,
                writable: true,
            },
            _transport: {
                value: null,
                writable: true
            }
        });
        return _this;
    }
    Object.defineProperty(MediaSignaling.prototype, "isSetup", {
        get: function () {
            return !!this._receiverPromise;
        },
        enumerable: false,
        configurable: true
    });
    MediaSignaling.prototype.toString = function () {
        return "[MediaSignaling #" + this._instanceId + ":" + this.channel + "]";
    };
    MediaSignaling.prototype.setup = function (id) {
        var _this = this;
        this._teardown();
        this._log.info('setting up msp transport for id:', id);
        var receiverPromise = this._getReceiver(id).then(function (receiver) {
            if (receiver.kind !== 'data') {
                _this._log.error('Expected a DataTrackReceiver');
            }
            if (_this._receiverPromise !== receiverPromise) {
                return;
            }
            try {
                _this._transport = receiver.toDataTransport();
                _this.emit('ready', _this._transport);
            }
            catch (ex) {
                _this._log.error("Failed to toDataTransport: " + ex.message);
            }
            receiver.once('close', function () { return _this._teardown(); });
        });
        this._receiverPromise = receiverPromise;
    };
    MediaSignaling.prototype._teardown = function () {
        if (this._transport) {
            this._log.info('Tearing down');
            this._transport = null;
            this._receiverPromise = null;
            this.emit('teardown');
        }
    };
    return MediaSignaling;
}(EventEmitter));
module.exports = MediaSignaling;

},{"events":174}],76:[function(require,module,exports){
/* eslint callback-return:0 */
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var EventEmitter = require('events');
var PeerConnectionReportFactory = require('../../stats/peerconnectionreportfactory');
/**
 * @emits NetworkQualityMonitor#updated
 */
var NetworkQualityMonitor = /** @class */ (function (_super) {
    __extends(NetworkQualityMonitor, _super);
    /**
     * Construct a {@link NetworkQualityMonitor}.
     * @param {PeerConnectionManager} manager
     * @param {NetworkQualitySignaling} signaling
     */
    function NetworkQualityMonitor(manager, signaling) {
        var _this = _super.call(this) || this;
        Object.defineProperties(_this, {
            _factories: {
                value: new WeakMap()
            },
            _manager: {
                value: manager
            },
            _signaling: {
                value: signaling
            }
        });
        signaling.on('updated', function () { return _this.emit('updated'); });
        return _this;
    }
    Object.defineProperty(NetworkQualityMonitor.prototype, "level", {
        /**
         * Get the current {@link NetworkQualityLevel}, if any.
         * @returns {?NetworkQualityLevel} level - initially null
         */
        get: function () {
            return this._signaling.level;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(NetworkQualityMonitor.prototype, "levels", {
        /**
         * Get the current {@link NetworkQualityLevels}, if any.
         * @returns {?NetworkQualityLevels} levels - initially null
         */
        get: function () {
            return this._signaling.levels;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(NetworkQualityMonitor.prototype, "remoteLevels", {
        /**
         * Get the current {@link NetworkQualityLevels} of remote participants, if any.
         * @returns {Map<String, NetworkQualityLevels>} remoteLevels
         */
        get: function () {
            return this._signaling.remoteLevels;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Start monitoring.
     * @returns {void}
     */
    NetworkQualityMonitor.prototype.start = function () {
        var _this = this;
        this.stop();
        var timeout = setTimeout(function () {
            if (_this._timeout !== timeout) {
                return;
            }
            next(_this).then(function (reports) {
                if (_this._timeout !== timeout) {
                    return;
                }
                if (reports.length) {
                    var _a = __read(reports, 1), report = _a[0];
                    _this._signaling.put(report);
                }
                _this.start();
            });
        }, 200);
        this._timeout = timeout;
    };
    /**
     * Stop monitoring.
     * @returns {void}
     */
    NetworkQualityMonitor.prototype.stop = function () {
        clearTimeout(this._timeout);
        this._timeout = null;
    };
    return NetworkQualityMonitor;
}(EventEmitter));
/**
 * @param {NetworkQualityMonitor}
 * @returns {Promise<NetworkQualityInputs>}
 */
function next(monitor) {
    var pcv2s = monitor._manager._peerConnections
        ? Array.from(monitor._manager._peerConnections.values())
        : [];
    var pcs = pcv2s
        .map(function (pcv2) { return pcv2._peerConnection; })
        .filter(function (pc) { return pc.signalingState !== 'closed'; });
    var factories = pcs.map(function (pc) {
        if (monitor._factories.has(pc)) {
            return monitor._factories.get(pc);
        }
        var factory = new PeerConnectionReportFactory(pc);
        monitor._factories.set(pc, factory);
        return factory;
    });
    var reportsOrNullPromises = factories.map(function (factory) { return factory.next().catch(function () { return null; }); });
    return Promise.all(reportsOrNullPromises).then(function (reportsOrNull) { return reportsOrNull
        .filter(function (reportOrNull) { return reportOrNull; })
        .map(function (report) { return report.summarize(); }); });
}
/**
 * The {@link NetworkQualityLevel} changed.
 * @event NetworkQualityMonitor#updated
 */
module.exports = NetworkQualityMonitor;

},{"../../stats/peerconnectionreportfactory":107,"events":174}],77:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var MediaSignaling = require('./mediasignaling');
var AsyncVar = require('../../util/asyncvar');
var Timeout = require('../../util/timeout');
var NETWORK_QUALITY_RESPONSE_TIME_MS = 5000;
/**
 * @interface MediaSignalingTransport
 * @property {function(object): boolean} send
 * @emits MediaSignalingTransport#message
 */
/**
 * The {@link MediaSignalingTransport} received a message.
 * @event MediaSignalingTransport#message
 * @param {object} message
 */
/**
 * @interface LatencyStats
 * @property {number} jitter
 * @property {number} rtt
 * @property {number} level
 */
/**
 * @interface FractionLostStats
 * @property {number} fractionLost
 * @property {number} level
 */
/**
 * @interface BandwidthStats
 * @property {number} actual
 * @property {number} available
 * @property {number} level
 */
/**
 * @interface SendOrRecvStats
 * @property {BandwidthStats} bandwidth
 * @property {FractionLostStats} fractionLost
 * @property {LatencyStats} latency
 */
/**
 * @interface MediaLevels
 * @property {number} send
 * @property {SendOrRecvStats} sendStats
 * @property {number} recv
 * @property {SendOrRecvStats} recvStats
 */
/**
 * @interface NetworkQualityLevels
 * @property {number} level
 * @property {MediaLevels} audio
 * @property {MediaLevels} video
 */
/**
 * @typedef {PeerConnectionSummary} NetworkQualityInputs
 */
/**
 * @classdesc The {@link NetworkQualitySignaling} class allows submitting
 *   {@link NetworkQualityInputs} for computing {@link NetworkQualityLevel}. It
 *   does so by sending and receiving messages over a
 *   {@link MediaSignalingTransport}. The exact transport used depends on the
 *   topology of the {@link Room} that {@link NetworkQualitySignaling} is being
 *   used within: for P2P Rooms, we re-use the {@link TransportV2}; and for
 *   Group Rooms, we use a {@link DataTransport}.
 * @emits NetworkQualitySignaling#updated
 */
var NetworkQualitySignaling = /** @class */ (function (_super) {
    __extends(NetworkQualitySignaling, _super);
    /**
     * Construct a {@link NetworkQualitySignaling}.
     * @param {Promise<DataTrackReceiver>} getReceiver
     * @param {NetworkQualityConfigurationImpl} networkQualityConfiguration
     */
    function NetworkQualitySignaling(getReceiver, networkQualityConfiguration, options) {
        var _this = _super.call(this, getReceiver, 'network_quality', options) || this;
        Object.defineProperties(_this, {
            _level: {
                value: null,
                writable: true
            },
            _levels: {
                value: null,
                writable: true
            },
            _remoteLevels: {
                value: new Map(),
                writable: true
            },
            _networkQualityInputs: {
                value: new AsyncVar()
            },
            _resendTimer: {
                value: new Timeout(function () {
                    // and schedule next timer at x1.5 the delay..
                    _this._resendTimer.setDelay(_this._resendTimer.delay * 1.5);
                    _this._sendNetworkQualityInputs();
                }, NETWORK_QUALITY_RESPONSE_TIME_MS, false),
            },
            _networkQualityReportLevels: {
                get: function () {
                    return {
                        reportLevel: networkQualityConfiguration.local,
                        remoteReportLevel: networkQualityConfiguration.remote
                    };
                }
            }
        });
        _this.on('ready', function (transport) {
            transport.on('message', function (message) {
                _this._log.debug('Incoming: ', message);
                switch (message.type) {
                    case 'network_quality':
                        _this._handleNetworkQualityMessage(message);
                        break;
                    default:
                        break;
                }
            });
        });
        _this._sendNetworkQualityInputs();
        return _this;
    }
    Object.defineProperty(NetworkQualitySignaling.prototype, "level", {
        /**
         * Get the current {@link NetworkQualityLevel}, if any.
         * @returns {?NetworkQualityLevel} level - initially null
         */
        get: function () {
            return this._level;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(NetworkQualitySignaling.prototype, "levels", {
        /**
         * Get the current {@link NetworkQualityLevels}, if any.
         * @returns {?NetworkQualityLevels} levels - initially null
         */
        get: function () {
            return this._levels;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(NetworkQualitySignaling.prototype, "remoteLevels", {
        /**
         * Get the current {@link NetworkQualityLevels} of remote participants, if any.
         * @returns {Map<String, NetworkQualityLevels>} remoteLevels
         */
        get: function () {
            return this._remoteLevels;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Check to see if the {@link NetworkQualityLevel} is new, and raise an
     * event if necessary.
     * @private
     * @param {object} message
     * @returns {void}
     */
    NetworkQualitySignaling.prototype._handleNetworkQualityMessage = function (message) {
        var _this = this;
        var updated = false;
        var level = null;
        var local = message ? message.local : null;
        if (typeof local === 'number') {
            // NOTE(mroberts): In prod, we plan to only send the level.
            level = local;
            this._levels = null;
        }
        else if (typeof local === 'object' && local) {
            // NOTE(mroberts): In dev, we plan to send the decomposed levels. An early
            // VMS version does not compute `level` for us, so we fallback to taking
            // the minimum ourselves.
            this._levels = local;
            level = typeof local.level === 'number'
                ? local.level
                : Math.min(local.audio.send, local.audio.recv, local.video.send, local.video.recv);
        }
        if (level !== null && this.level !== level) {
            this._level = level;
            updated = true;
        }
        this._remoteLevels = message && message.remotes
            ? message.remotes.reduce(function (levels, obj) {
                var oldObj = _this._remoteLevels.get(obj.sid) || {};
                if (oldObj.level !== obj.level) {
                    updated = true;
                }
                return levels.set(obj.sid, obj);
            }, new Map())
            : this._remoteLevels;
        if (updated) {
            this.emit('updated');
        }
        // score is received. so reset the timer to default timeout.
        this._resendTimer.setDelay(NETWORK_QUALITY_RESPONSE_TIME_MS);
        // timer is cleared only while we are sending inputs.
        // if we are already sending inputs do not send them again.
        if (this._resendTimer.isSet) {
            setTimeout(function () { return _this._sendNetworkQualityInputs(); }, 1000);
        }
    };
    /**
     * Start sending {@link NetworkQualityInputs}.
     * @private
     * @returns {Promise<void>}
     */
    NetworkQualitySignaling.prototype._sendNetworkQualityInputs = function () {
        var _this = this;
        this._resendTimer.clear();
        return this._networkQualityInputs.take().then(function (networkQualityInputs) {
            if (_this._transport) {
                _this._transport.publish(createNetworkQualityInputsMessage(networkQualityInputs, _this._networkQualityReportLevels));
            }
        }).finally(function () {
            _this._resendTimer.start();
        });
    };
    /**
     * Put {@link NetworkQualityInputs} to be used for computing
     * {@link NetworkQualityLevel}.
     * @param {NetworkQualityInputs} networkQualityInputs
     * @returns {void}
     */
    NetworkQualitySignaling.prototype.put = function (networkQualityInputs) {
        this._networkQualityInputs.put(networkQualityInputs);
    };
    return NetworkQualitySignaling;
}(MediaSignaling));
/**
 * The {@link NetworkQualityLevel} changed.
 * @event NetworkQualitySignaling#updated
 */
/**
 * @typedef {object} NetworkQualityReportLevels
 * @param {number} reportLevel
 * @param {number} remoteReportLevel
 */
/**
 * @param {NetworkQualityInputs} networkQualityInputs
 * @param {NetworkQualityReportLevels} networkQualityReportLevels
 * @returns {object} message
 */
function createNetworkQualityInputsMessage(networkQualityInputs, networkQualityReportLevels) {
    return Object.assign({ type: 'network_quality' }, networkQualityInputs, networkQualityReportLevels);
}
module.exports = NetworkQualitySignaling;

},{"../../util/asyncvar":122,"../../util/timeout":147,"./mediasignaling":75}],78:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var DefaultBackoff = require('../../util/backoff');
var _a = require('../../webrtc'), DefaultRTCIceCandidate = _a.RTCIceCandidate, DefaultRTCPeerConnection = _a.RTCPeerConnection, DefaultRTCSessionDescription = _a.RTCSessionDescription, getStatistics = _a.getStats;
var util = require('../../webrtc/util');
var _b = require('../../util/constants'), DEFAULT_ICE_GATHERING_TIMEOUT_MS = _b.DEFAULT_ICE_GATHERING_TIMEOUT_MS, DEFAULT_LOG_LEVEL = _b.DEFAULT_LOG_LEVEL, DEFAULT_SESSION_TIMEOUT_SEC = _b.DEFAULT_SESSION_TIMEOUT_SEC, iceRestartBackoffConfig = _b.iceRestartBackoffConfig;
var _c = require('../../util/sdp'), addOrRewriteNewTrackIds = _c.addOrRewriteNewTrackIds, addOrRewriteTrackIds = _c.addOrRewriteTrackIds, createCodecMapForMediaSection = _c.createCodecMapForMediaSection, disableRtx = _c.disableRtx, enableDtxForOpus = _c.enableDtxForOpus, filterLocalCodecs = _c.filterLocalCodecs, getMediaSections = _c.getMediaSections, removeSSRCAttributes = _c.removeSSRCAttributes, revertSimulcast = _c.revertSimulcast, setCodecPreferences = _c.setCodecPreferences, setSimulcast = _c.setSimulcast;
var DefaultTimeout = require('../../util/timeout');
var _d = require('../../util/twilio-video-errors'), MediaClientLocalDescFailedError = _d.MediaClientLocalDescFailedError, MediaClientRemoteDescFailedError = _d.MediaClientRemoteDescFailedError;
var _e = require('../../util'), buildLogLevels = _e.buildLogLevels, getPlatform = _e.getPlatform, isChromeScreenShareTrack = _e.isChromeScreenShareTrack, oncePerTick = _e.oncePerTick, defer = _e.defer;
var IceBox = require('./icebox');
var DefaultIceConnectionMonitor = require('./iceconnectionmonitor.js');
var DataTrackReceiver = require('../../data/receiver');
var MediaTrackReceiver = require('../../media/track/receiver');
var StateMachine = require('../../statemachine');
var Log = require('../../util/log');
var TrackMatcher = require('../../util/sdp/trackmatcher');
var workaroundIssue8329 = require('../../util/sdp/issue8329');
var guess = util.guessBrowser();
var platform = getPlatform();
var isAndroid = /android/.test(platform);
var isChrome = guess === 'chrome';
var isFirefox = guess === 'firefox';
var isSafari = guess === 'safari';
var nInstances = 0;
/*
PeerConnectionV2 States
-----------------------

    +------+    +--------+
    |      |    |        |
    | open |--->| closed |
    |      |    |        |
    +------+    +--------+
      |  ^          ^
      |  |          |
      |  |          |
      v  |          |
  +----------+      |
  |          |      |
  | updating |------+
  |          |
  +----------+

*/
var states = {
    open: [
        'closed',
        'updating'
    ],
    updating: [
        'closed',
        'open'
    ],
    closed: []
};
/**
 * @extends StateMachine
 * @property {id}
 * @emits PeerConnectionV2#connectionStateChanged
 * @emits PeerConnectionV2#iceConnectionStateChanged
 * @emits PeerConnectionV2#candidates
 * @emits PeerConnectionV2#description
 */
var PeerConnectionV2 = /** @class */ (function (_super) {
    __extends(PeerConnectionV2, _super);
    /**
     * Construct a {@link PeerConnectionV2}.
     * @param {string} id
     * @param {EncodingParametersImpl} encodingParameters
     * @param {PreferredCodecs} preferredCodecs
     * @param {object} [options]
     */
    function PeerConnectionV2(id, encodingParameters, preferredCodecs, options) {
        var _this = _super.call(this, 'open', states) || this;
        options = Object.assign({
            enableDscp: false,
            dummyAudioMediaStreamTrack: null,
            isChromeScreenShareTrack: isChromeScreenShareTrack,
            iceServers: [],
            logLevel: DEFAULT_LOG_LEVEL,
            offerOptions: {},
            revertSimulcast: revertSimulcast,
            sessionTimeout: DEFAULT_SESSION_TIMEOUT_SEC * 1000,
            setCodecPreferences: setCodecPreferences,
            setSimulcast: setSimulcast,
            Backoff: DefaultBackoff,
            IceConnectionMonitor: DefaultIceConnectionMonitor,
            RTCIceCandidate: DefaultRTCIceCandidate,
            RTCPeerConnection: DefaultRTCPeerConnection,
            RTCSessionDescription: DefaultRTCSessionDescription,
            Timeout: DefaultTimeout
        }, options);
        var configuration = getConfiguration(options);
        var logLevels = buildLogLevels(options.logLevel);
        var RTCPeerConnection = options.RTCPeerConnection;
        if (options.enableDscp === true) {
            options.chromeSpecificConstraints = options.chromeSpecificConstraints || {};
            options.chromeSpecificConstraints.optional = options.chromeSpecificConstraints.optional || [];
            options.chromeSpecificConstraints.optional.push({ googDscp: true });
        }
        var log = options.log ? options.log.createLog('webrtc', _this) : new Log('webrtc', _this, logLevels, options.loggerName);
        var peerConnection = new RTCPeerConnection(configuration, options.chromeSpecificConstraints);
        if (options.dummyAudioMediaStreamTrack) {
            peerConnection.addTrack(options.dummyAudioMediaStreamTrack);
        }
        Object.defineProperties(_this, {
            _appliedTrackIdsToAttributes: {
                value: new Map(),
                writable: true
            },
            _dataChannels: {
                value: new Map()
            },
            _dataTrackReceivers: {
                value: new Set()
            },
            _descriptionRevision: {
                writable: true,
                value: 0
            },
            _didGenerateLocalCandidates: {
                writable: true,
                value: false
            },
            _enableDscp: {
                value: options.enableDscp
            },
            _encodingParameters: {
                value: encodingParameters
            },
            _isChromeScreenShareTrack: {
                value: options.isChromeScreenShareTrack,
            },
            _iceGatheringFailed: {
                value: false,
                writable: true
            },
            _iceGatheringTimeout: {
                value: new options.Timeout(function () { return _this._handleIceGatheringTimeout(); }, DEFAULT_ICE_GATHERING_TIMEOUT_MS, false)
            },
            _iceRestartBackoff: {
                // eslint-disable-next-line new-cap
                value: new options.Backoff(iceRestartBackoffConfig)
            },
            _instanceId: {
                value: ++nInstances
            },
            _isIceConnectionInactive: {
                writable: true,
                value: false
            },
            _isIceLite: {
                writable: true,
                value: false
            },
            _isIceRestartBackoffInProgress: {
                writable: true,
                value: false
            },
            _isRestartingIce: {
                writable: true,
                value: false
            },
            _lastIceConnectionState: {
                writable: true,
                value: null
            },
            _lastStableDescriptionRevision: {
                writable: true,
                value: 0
            },
            _localCandidates: {
                writable: true,
                value: []
            },
            _localCodecs: {
                value: new Set()
            },
            _localCandidatesRevision: {
                writable: true,
                value: 1
            },
            _localDescriptionWithoutSimulcast: {
                writable: true,
                value: null
            },
            _localDescription: {
                writable: true,
                value: null
            },
            _localUfrag: {
                writable: true,
                value: null
            },
            _log: {
                value: log
            },
            _eventObserver: {
                value: options.eventObserver
            },
            _remoteCodecMaps: {
                value: new Map()
            },
            _rtpSenders: {
                value: new Map()
            },
            _rtpNewSenders: {
                value: new Set()
            },
            _iceConnectionMonitor: {
                value: new options.IceConnectionMonitor(peerConnection)
            },
            _mediaTrackReceivers: {
                value: new Set()
            },
            _needsAnswer: {
                writable: true,
                value: false
            },
            _negotiationRole: {
                writable: true,
                value: null
            },
            _offerOptions: {
                writable: true,
                value: options.offerOptions
            },
            _onEncodingParametersChanged: {
                value: oncePerTick(function () {
                    if (!_this._needsAnswer) {
                        updateEncodingParameters(_this);
                    }
                })
            },
            _peerConnection: {
                value: peerConnection
            },
            _preferredAudioCodecs: {
                value: preferredCodecs.audio
            },
            _preferredVideoCodecs: {
                value: preferredCodecs.video
            },
            _shouldApplyDtx: {
                value: preferredCodecs.audio.every(function (_a) {
                    var codec = _a.codec;
                    return codec !== 'opus';
                })
                    || preferredCodecs.audio.some(function (_a) {
                        var codec = _a.codec, dtx = _a.dtx;
                        return codec === 'opus' && dtx;
                    })
            },
            _queuedDescription: {
                writable: true,
                value: null
            },
            _iceReconnectTimeout: {
                value: new options.Timeout(function () {
                    log.debug('ICE reconnect timed out');
                    _this.close();
                }, options.sessionTimeout, false)
            },
            _recycledTransceivers: {
                value: {
                    audio: [],
                    video: []
                }
            },
            _replaceTrackPromises: {
                value: new Map()
            },
            _remoteCandidates: {
                writable: true,
                value: new IceBox()
            },
            _setCodecPreferences: {
                // NOTE(mmalavalli): Re-ordering payload types in order to make sure a non-H264
                // preferred codec is selected does not work on Android Firefox due to this behavior:
                // https://bugzilla.mozilla.org/show_bug.cgi?id=1683258. So, we work around this by
                // not applying any non-H264 preferred video codec.
                value: isFirefox && isAndroid && preferredCodecs.video[0] && preferredCodecs.video[0].codec.toLowerCase() !== 'h264'
                    ? function (sdp) { return sdp; }
                    : options.setCodecPreferences
            },
            _setSimulcast: {
                value: options.setSimulcast
            },
            _revertSimulcast: {
                value: options.revertSimulcast
            },
            _RTCIceCandidate: {
                value: options.RTCIceCandidate
            },
            _RTCPeerConnection: {
                value: options.RTCPeerConnection
            },
            _RTCSessionDescription: {
                value: options.RTCSessionDescription
            },
            _shouldOffer: {
                writable: true,
                value: false
            },
            _shouldRestartIce: {
                writable: true,
                value: false
            },
            _trackIdsToAttributes: {
                value: new Map(),
                writable: true
            },
            _trackMatcher: {
                writable: true,
                value: null
            },
            _mediaTrackSenderToPublisherHints: {
                value: new Map()
            },
            id: {
                enumerable: true,
                value: id
            }
        });
        encodingParameters.on('changed', _this._onEncodingParametersChanged);
        peerConnection.addEventListener('connectionstatechange', _this._handleConnectionStateChange.bind(_this));
        peerConnection.addEventListener('datachannel', _this._handleDataChannelEvent.bind(_this));
        peerConnection.addEventListener('icecandidate', _this._handleIceCandidateEvent.bind(_this));
        peerConnection.addEventListener('iceconnectionstatechange', _this._handleIceConnectionStateChange.bind(_this));
        peerConnection.addEventListener('icegatheringstatechange', _this._handleIceGatheringStateChange.bind(_this));
        peerConnection.addEventListener('signalingstatechange', _this._handleSignalingStateChange.bind(_this));
        peerConnection.addEventListener('track', _this._handleTrackEvent.bind(_this));
        var self = _this;
        _this.on('stateChanged', function stateChanged(state) {
            if (state !== 'closed') {
                return;
            }
            self.removeListener('stateChanged', stateChanged);
            self._dataChannels.forEach(function (dataChannel, dataTrackSender) {
                self.removeDataTrackSender(dataTrackSender);
            });
        });
        return _this;
    }
    PeerConnectionV2.prototype.toString = function () {
        return "[PeerConnectionV2 #" + this._instanceId + ": " + this.id + "]";
    };
    PeerConnectionV2.prototype.setEffectiveAdaptiveSimulcast = function (effectiveAdaptiveSimulcast) {
        this._log.debug('Setting setEffectiveAdaptiveSimulcast: ', effectiveAdaptiveSimulcast);
        // clear adaptive simulcast from codec preferences if it was set.
        this._preferredVideoCodecs.forEach(function (cs) {
            if ('adaptiveSimulcast' in cs) {
                cs.adaptiveSimulcast = effectiveAdaptiveSimulcast;
            }
        });
    };
    Object.defineProperty(PeerConnectionV2.prototype, "_shouldApplySimulcast", {
        get: function () {
            if (!isChrome && !isSafari) {
                return false;
            }
            // adaptiveSimulcast is set to false after connected message is received if other party does not support it.
            var simulcast = this._preferredVideoCodecs.some(function (cs) {
                return cs.codec.toLowerCase() === 'vp8' && cs.simulcast && cs.adaptiveSimulcast !== false;
            });
            return simulcast;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(PeerConnectionV2.prototype, "connectionState", {
        /**
         * The {@link PeerConnectionV2}'s underlying RTCPeerConnection's RTCPeerConnectionState
         * if supported by the browser, its RTCIceConnectionState otherwise.
         * @property {RTCPeerConnectionState}
         */
        get: function () {
            return this.iceConnectionState === 'failed'
                ? 'failed' : (this._peerConnection.connectionState || this.iceConnectionState);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(PeerConnectionV2.prototype, "iceConnectionState", {
        /**
         * The {@link PeerConnectionV2}'s underlying RTCPeerConnection's
         * RTCIceConnectionState.
         * @property {RTCIceConnectionState}
         */
        get: function () {
            return ((this._isIceConnectionInactive && this._peerConnection.iceConnectionState === 'disconnected') || this._iceGatheringFailed)
                ? 'failed' : this._peerConnection.iceConnectionState;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(PeerConnectionV2.prototype, "isApplicationSectionNegotiated", {
        /**
         * Whether the {@link PeerConnectionV2} has negotiated or is in the process
         * of negotiating the application m= section.
         * @returns {boolean}
         */
        get: function () {
            if (this._peerConnection.signalingState !== 'closed') {
                // accessing .localDescription in 'closed' state causes it throw exceptions.
                return this._peerConnection.localDescription
                    ? getMediaSections(this._peerConnection.localDescription.sdp, 'application').length > 0
                    : false;
            }
            return true;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(PeerConnectionV2.prototype, "_isAdaptiveSimulcastEnabled", {
        /**
         * Whether adaptive simulcast is enabled.
         * @returns {boolean}
         */
        get: function () {
            var adaptiveSimulcastEntry = this._preferredVideoCodecs.find(function (cs) { return 'adaptiveSimulcast' in cs; });
            return adaptiveSimulcastEntry && adaptiveSimulcastEntry.adaptiveSimulcast === true;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * @param {MediaStreamTrack} track
     * @param {Array<RTCRtpEncodingParameters>} encodings
     * @param {boolean} trackReplaced
     * @returns {boolean} true if encodings were updated.
     */
    PeerConnectionV2.prototype._maybeUpdateEncodings = function (track, encodings, trackReplaced) {
        if (trackReplaced === void 0) { trackReplaced = false; }
        if (track.kind !== 'video' || track.readyState === 'ended') {
            return false;
        }
        // NOTE(mmalavalli): There is no guarantee that CanvasCaptureMediaStreamTracks will always have "width" and "height"
        // in their settings. So, we don't update the encodings if they are not present.
        // Chromium bug: https://bugs.chromium.org/p/chromium/issues/detail?id=1367082
        var _a = track.getSettings(), height = _a.height, width = _a.width;
        if (typeof height !== 'number' || typeof width !== 'number') {
            return false;
        }
        // Note(mpatwardhan): always configure encodings for safari.
        // for chrome only when adaptive simulcast enabled.
        var browser = util.guessBrowser();
        if (browser === 'safari' || (browser === 'chrome' && this._isAdaptiveSimulcastEnabled)) {
            this._updateEncodings(track, encodings, trackReplaced);
            return true;
        }
        return false;
    };
    /**
     * Configures with default encodings depending on track type and resolution.
     * Default configuration sets some encodings to disabled, and for others set scaleResolutionDownBy
     * values. When trackReplaced is set to true, it will clear 'active' for any encodings that
     * needs to be enabled.
     * @param {MediaStreamTrack} track
     * @param {Array<RTCRtpEncodingParameters>} encodings
     * @param {boolean} trackReplaced
     */
    PeerConnectionV2.prototype._updateEncodings = function (track, encodings, trackReplaced) {
        if (this._isChromeScreenShareTrack(track)) {
            var screenShareActiveLayerConfig_1 = [
                { scaleResolutionDownBy: 1 },
                { scaleResolutionDownBy: 1 }
            ];
            encodings.forEach(function (encoding, i) {
                var activeLayerConfig = screenShareActiveLayerConfig_1[i];
                if (activeLayerConfig) {
                    encoding.scaleResolutionDownBy = activeLayerConfig.scaleResolutionDownBy;
                    if (trackReplaced) {
                        delete encoding.active;
                    }
                }
                else {
                    encoding.active = false;
                    delete encoding.scaleResolutionDownBy;
                }
            });
        }
        else {
            var _a = track.getSettings(), width = _a.width, height = _a.height;
            // NOTE(mpatwardhan): for non-screen share tracks
            // enable layers depending on track resolutions
            var pixelsToMaxActiveLayers = [
                { pixels: 960 * 540, maxActiveLayers: 3 },
                { pixels: 480 * 270, maxActiveLayers: 2 },
                { pixels: 0, maxActiveLayers: 1 }
            ];
            var trackPixels_1 = width * height;
            var activeLayersInfo = pixelsToMaxActiveLayers.find(function (layer) { return trackPixels_1 >= layer.pixels; });
            var activeLayers_1 = Math.min(encodings.length, activeLayersInfo.maxActiveLayers);
            encodings.forEach(function (encoding, i) {
                var enabled = i < activeLayers_1;
                if (enabled) {
                    encoding.scaleResolutionDownBy = 1 << (activeLayers_1 - i - 1);
                    if (trackReplaced) {
                        encoding.active = true;
                    }
                }
                else {
                    encoding.active = false;
                    delete encoding.scaleResolutionDownBy;
                }
            });
        }
        this._log.debug('_updateEncodings:', encodings.map(function (_a, i) {
            var active = _a.active, scaleResolutionDownBy = _a.scaleResolutionDownBy;
            return "[" + i + ": " + active + ", " + (scaleResolutionDownBy || 0) + "]";
        }).join(', '));
    };
    /**
     * Add an ICE candidate to the {@link PeerConnectionV2}.
     * @private
     * @param {object} candidate
     * @returns {Promise<void>}
     */
    PeerConnectionV2.prototype._addIceCandidate = function (candidate) {
        var _this = this;
        return Promise.resolve().then(function () {
            candidate = new _this._RTCIceCandidate(candidate);
            return _this._peerConnection.addIceCandidate(candidate);
        }).catch(function (error) {
            // NOTE(mmalavalli): Firefox 68+ now generates an RTCIceCandidate with an
            // empty candidate string to signal end-of-candidates, followed by a null
            // candidate. As of now, Chrome and Safari reject this RTCIceCandidate. Since
            // this does not affect the media connection between Firefox 68+ and Chrome/Safari
            // in Peer-to-Peer Rooms, we suppress the Error and log a warning message.
            //
            // Chrome bug: https://bugs.chromium.org/p/chromium/issues/detail?id=978582
            //
            _this._log.warn("Failed to add RTCIceCandidate " + (candidate ? "\"" + candidate.candidate + "\"" : 'null') + ": "
                + error.message);
        });
    };
    /**
     * Add ICE candidates to the {@link PeerConnectionV2}.
     * @private
     * @param {Array<object>} candidates
     * @returns {Promise<void>}
     */
    PeerConnectionV2.prototype._addIceCandidates = function (candidates) {
        return Promise.all(candidates.map(this._addIceCandidate, this)).then(function () { });
    };
    /**
     * Add a new RTCRtpTransceiver or update an existing RTCRtpTransceiver for the
     * given MediaStreamTrack.
     * @private
     * @param {MediaStreamTrack} track
     * @returns {RTCRtpTransceiver}
     */
    PeerConnectionV2.prototype._addOrUpdateTransceiver = function (track) {
        var _this = this;
        var transceiver = takeRecycledTransceiver(this, track.kind);
        if (transceiver && transceiver.sender) {
            var oldTrackId = transceiver.sender.track ? transceiver.sender.track.id : null;
            if (oldTrackId) {
                this._log.warn("Reusing transceiver: " + transceiver.mid + "] " + oldTrackId + " => " + track.id);
            }
            // NOTE(mpatwardhan):remember this transceiver while we replace track.
            // we recycle transceivers that are not in use after 'negotiationCompleted', but we want to prevent
            // this one from getting recycled while replaceTrack is pending.
            this._replaceTrackPromises.set(transceiver, transceiver.sender.replaceTrack(track).then(function () {
                transceiver.direction = 'sendrecv';
            }, function () {
                // Do nothing.
            }).finally(function () {
                _this._replaceTrackPromises.delete(transceiver);
            }));
            return transceiver;
        }
        return this._peerConnection.addTransceiver(track);
    };
    /**
     * Check the {@link IceBox}.
     * @private
     * @param {RTCSessionDescriptionInit} description
     * @returns {Promise<void>}
     */
    PeerConnectionV2.prototype._checkIceBox = function (description) {
        var ufrag = getUfrag(description);
        if (!ufrag) {
            return Promise.resolve();
        }
        var candidates = this._remoteCandidates.setUfrag(ufrag);
        return this._addIceCandidates(candidates);
    };
    /**
     * Create an answer and set it on the {@link PeerConnectionV2}.
     * @private
     * @param {RTCSessionDescriptionInit} offer
     * @returns {Promise<boolean>}
     */
    PeerConnectionV2.prototype._answer = function (offer) {
        var _this = this;
        return Promise.resolve().then(function () {
            if (!_this._negotiationRole) {
                _this._negotiationRole = 'answerer';
            }
            return _this._setRemoteDescription(offer);
        }).catch(function () {
            throw new MediaClientRemoteDescFailedError();
        }).then(function () {
            return _this._peerConnection.createAnswer();
        }).then(function (answer) {
            if (isFirefox) {
                // NOTE(mmalavalli): We work around Chromium bug 1106157 by disabling
                // RTX in Firefox 79+. For more details about the bug, please go here:
                // https://bugs.chromium.org/p/chromium/issues/detail?id=1106157
                answer = new _this._RTCSessionDescription({
                    sdp: disableRtx(answer.sdp),
                    type: answer.type
                });
            }
            else {
                answer = workaroundIssue8329(answer);
            }
            // NOTE(mpatwardhan): Upcoming chrome versions are going to remove ssrc attributes
            // mslabel and label. See this bug https://bugs.chromium.org/p/webrtc/issues/detail?id=7110
            // and PSA: https://groups.google.com/forum/#!searchin/discuss-webrtc/PSA%7Csort:date/discuss-webrtc/jcZO-Wj0Wus/k2XvPCvoAwAJ
            // We are not referencing those attributes, but this changes goes ahead and removes them to see if it works.
            // this also helps reduce bytes on wires
            var updatedSdp = removeSSRCAttributes(answer.sdp, ['mslabel', 'label']);
            if (_this._shouldApplySimulcast) {
                var sdpWithoutSimulcast = updatedSdp;
                updatedSdp = _this._setSimulcast(sdpWithoutSimulcast, _this._trackIdsToAttributes);
                // NOTE(syerrapragada): VMS does not support H264 simulcast. So,
                // unset simulcast for sections in local offer where corresponding
                // sections in answer doesn't have vp8 as preferred codec and reapply offer.
                updatedSdp = _this._revertSimulcast(updatedSdp, sdpWithoutSimulcast, offer.sdp);
            }
            // NOTE(mmalavalli): Work around Chromium bug 1074421.
            // https://bugs.chromium.org/p/chromium/issues/detail?id=1074421
            updatedSdp = updatedSdp.replace(/42e015/g, '42e01f');
            return _this._setLocalDescription({
                type: answer.type,
                sdp: updatedSdp
            });
        }).then(function () {
            return _this._checkIceBox(offer);
        }).then(function () {
            return _this._queuedDescription
                && _this._updateDescription(_this._queuedDescription);
        }).then(function () {
            _this._queuedDescription = null;
            return _this._maybeReoffer(_this._peerConnection.localDescription);
        }).catch(function (error) {
            var errorToThrow = error instanceof MediaClientRemoteDescFailedError ? error : new MediaClientLocalDescFailedError();
            _this._publishMediaWarning({
                message: 'Failed to _answer',
                code: errorToThrow.code,
                error: error
            });
            throw errorToThrow;
        });
    };
    /**
     * Close the underlying RTCPeerConnection. Returns false if the
     * RTCPeerConnection was already closed.
     * @private
     * @returns {boolean}
     */
    PeerConnectionV2.prototype._close = function () {
        this._iceConnectionMonitor.stop();
        if (this._peerConnection.signalingState !== 'closed') {
            this._peerConnection.close();
            this.preempt('closed');
            this._encodingParameters.removeListener('changed', this._onEncodingParametersChanged);
            return true;
        }
        return false;
    };
    /**
     * Handle a "connectionstatechange" event.
     * @private
     * @returns {void}
     */
    PeerConnectionV2.prototype._handleConnectionStateChange = function () {
        this.emit('connectionStateChanged');
    };
    /**
     * Handle a "datachannel" event.
     * @private
     * @param {RTCDataChannelEvent} event
     * @returns {void}
     */
    PeerConnectionV2.prototype._handleDataChannelEvent = function (event) {
        var _this = this;
        var dataChannel = event.channel;
        var dataTrackReceiver = new DataTrackReceiver(dataChannel);
        this._dataTrackReceivers.add(dataTrackReceiver);
        dataChannel.addEventListener('close', function () {
            _this._dataTrackReceivers.delete(dataTrackReceiver);
        });
        this.emit('trackAdded', dataTrackReceiver);
    };
    /**
     * Handle a glare scenario on the {@link PeerConnectionV2}.
     * @private
     * @param {RTCSessionDescriptionInit} offer
     * @returns {Promise<void>}
     */
    PeerConnectionV2.prototype._handleGlare = function (offer) {
        var _this = this;
        this._log.debug('Glare detected; rolling back');
        if (this._isRestartingIce) {
            this._log.debug('An ICE restart was in progress; we\'ll need to restart ICE again after rolling back');
            this._isRestartingIce = false;
            this._shouldRestartIce = true;
        }
        return Promise.resolve().then(function () {
            _this._trackIdsToAttributes = new Map(_this._appliedTrackIdsToAttributes);
            return _this._setLocalDescription({ type: 'rollback' });
        }).then(function () {
            _this._needsAnswer = false;
            return _this._answer(offer);
        }).then(function (didReoffer) {
            return didReoffer ? Promise.resolve() : _this._offer();
        });
    };
    PeerConnectionV2.prototype._publishMediaWarning = function (_a) {
        var message = _a.message, code = _a.code, error = _a.error, sdp = _a.sdp;
        this._eventObserver.emit('event', { level: 'warning', name: 'error', group: 'media', payload: {
                message: message,
                code: code,
                context: JSON.stringify({ error: error.message, sdp: sdp })
            } });
    };
    /**
     * Handle an ICE candidate event.
     * @private
     * @param {Event} event
     * @returns {void}
     */
    PeerConnectionV2.prototype._handleIceCandidateEvent = function (event) {
        if (event.candidate) {
            this._log.debug('Clearing ICE gathering timeout');
            this._didGenerateLocalCandidates = true;
            this._iceGatheringTimeout.clear();
            this._localCandidates.push(event.candidate);
        }
        var peerConnectionState = {
            ice: {
                candidates: this._isIceLite ? [] : this._localCandidates.slice(),
                ufrag: this._localUfrag
            },
            id: this.id
        };
        if (!event.candidate) {
            peerConnectionState.ice.complete = true;
        }
        if (!(this._isIceLite && event.candidate)) {
            peerConnectionState.ice.revision = this._localCandidatesRevision++;
            this.emit('candidates', peerConnectionState);
        }
    };
    /**
     * Handle an ICE connection state change event.
     * @private
     * @returns {void}
     */
    PeerConnectionV2.prototype._handleIceConnectionStateChange = function () {
        var _this = this;
        var iceConnectionState = this._peerConnection.iceConnectionState;
        var isIceConnectedOrComplete = ['connected', 'completed'].includes(iceConnectionState);
        var log = this._log;
        log.debug("ICE connection state is \"" + iceConnectionState + "\"");
        if (isIceConnectedOrComplete) {
            this._iceReconnectTimeout.clear();
            this._iceRestartBackoff.reset();
        }
        if (this._lastIceConnectionState !== 'failed' && iceConnectionState === 'failed' && !this._shouldRestartIce && !this._isRestartingIce) {
            // Case 1: Transition to "failed".
            log.warn('ICE failed');
            this._initiateIceRestartBackoff();
        }
        else if (['disconnected', 'failed'].includes(this._lastIceConnectionState) && isIceConnectedOrComplete) {
            // Case 2: Transition from "disconnected" or "failed".
            log.debug('ICE reconnected');
        }
        // start monitor media when connected, and continue to monitor while state is complete-disconnected-connected.
        if (iceConnectionState === 'connected') {
            this._isIceConnectionInactive = false;
            this._iceConnectionMonitor.start(function () {
                // note: iceConnection monitor waits for iceConnectionState=disconnected for
                // detecting inactivity. Its possible that it may know about disconnected before _handleIceConnectionStateChange
                _this._iceConnectionMonitor.stop();
                if (!_this._shouldRestartIce && !_this._isRestartingIce) {
                    log.warn('ICE Connection Monitor detected inactivity');
                    _this._isIceConnectionInactive = true;
                    _this._initiateIceRestartBackoff();
                    _this.emit('iceConnectionStateChanged');
                    _this.emit('connectionStateChanged');
                }
            });
        }
        else if (!['disconnected', 'completed'].includes(iceConnectionState)) { // don't stop monitoring for disconnected or completed.
            this._iceConnectionMonitor.stop();
            this._isIceConnectionInactive = false;
        }
        this._lastIceConnectionState = iceConnectionState;
        this.emit('iceConnectionStateChanged');
    };
    /**
     * Handle ICE gathering timeout.
     * @private
     * @returns {void}
     */
    PeerConnectionV2.prototype._handleIceGatheringTimeout = function () {
        this._log.warn('ICE failed to gather any local candidates');
        this._iceGatheringFailed = true;
        this._initiateIceRestartBackoff();
        this.emit('iceConnectionStateChanged');
        this.emit('connectionStateChanged');
    };
    /**
     * Handle an ICE gathering state change event.
     * @private
     * @returns {void}
     */
    PeerConnectionV2.prototype._handleIceGatheringStateChange = function () {
        var iceGatheringState = this._peerConnection.iceGatheringState;
        var log = this._log;
        log.debug("ICE gathering state is \"" + iceGatheringState + "\"");
        // NOTE(mmalavalli): Start the ICE gathering timeout only if the RTCPeerConnection
        // has started gathering candidates for the first time since the initial offer/answer
        // or an offer/answer with ICE restart.
        var _a = this._iceGatheringTimeout, delay = _a.delay, isSet = _a.isSet;
        if (iceGatheringState === 'gathering' && !this._didGenerateLocalCandidates && !isSet) {
            log.debug("Starting ICE gathering timeout: " + delay);
            this._iceGatheringFailed = false;
            this._iceGatheringTimeout.start();
        }
    };
    /**
     * Handle a signaling state change event.
     * @private
     * @returns {void}
     */
    PeerConnectionV2.prototype._handleSignalingStateChange = function () {
        if (this._peerConnection.signalingState === 'stable') {
            this._appliedTrackIdsToAttributes = new Map(this._trackIdsToAttributes);
        }
    };
    /**
     * Handle a track event.
     * @private
     * @param {RTCTrackEvent} event
     * @returns {void}
     */
    PeerConnectionV2.prototype._handleTrackEvent = function (event) {
        var _this = this;
        var sdp = this._peerConnection.remoteDescription
            ? this._peerConnection.remoteDescription.sdp
            : null;
        this._trackMatcher = this._trackMatcher || new TrackMatcher();
        this._trackMatcher.update(sdp);
        var mediaStreamTrack = event.track;
        var signaledTrackId = this._trackMatcher.match(event) || mediaStreamTrack.id;
        var mediaTrackReceiver = new MediaTrackReceiver(signaledTrackId, mediaStreamTrack);
        // NOTE(mmalavalli): "ended" is not fired on the remote MediaStreamTrack when
        // the remote peer removes a track. So, when this MediaStreamTrack is re-used
        // for a different track due to the remote peer calling RTCRtpSender.replaceTrack(),
        // we delete the previous MediaTrackReceiver that owned this MediaStreamTrack
        // before adding the new MediaTrackReceiver.
        this._mediaTrackReceivers.forEach(function (trackReceiver) {
            if (trackReceiver.track.id === mediaTrackReceiver.track.id) {
                _this._mediaTrackReceivers.delete(trackReceiver);
            }
        });
        this._mediaTrackReceivers.add(mediaTrackReceiver);
        mediaStreamTrack.addEventListener('ended', function () { return _this._mediaTrackReceivers.delete(mediaTrackReceiver); });
        this.emit('trackAdded', mediaTrackReceiver);
    };
    /**
     * Initiate ICE Restart.
     * @private
     * @returns {void}
     */
    PeerConnectionV2.prototype._initiateIceRestart = function () {
        if (this._peerConnection.signalingState === 'closed') {
            return;
        }
        var log = this._log;
        log.warn('Attempting to restart ICE');
        this._didGenerateLocalCandidates = false;
        this._isIceRestartBackoffInProgress = false;
        this._shouldRestartIce = true;
        var _a = this._iceReconnectTimeout, delay = _a.delay, isSet = _a.isSet;
        if (!isSet) {
            log.debug("Starting ICE reconnect timeout: " + delay);
            this._iceReconnectTimeout.start();
        }
        this.offer().catch(function (ex) {
            log.error("offer failed in _initiateIceRestart with: " + ex.message);
        });
    };
    /**
     * Schedule an ICE Restart.
     * @private
     * @returns {void}
     */
    PeerConnectionV2.prototype._initiateIceRestartBackoff = function () {
        var _this = this;
        if (this._peerConnection.signalingState === 'closed' || this._isIceRestartBackoffInProgress) {
            return;
        }
        this._log.warn('An ICE restart has been scheduled');
        this._isIceRestartBackoffInProgress = true;
        this._iceRestartBackoff.backoff(function () { return _this._initiateIceRestart(); });
    };
    /**
     * Conditionally re-offer.
     * @private
     * @param {?RTCSessionDescriptionInit} localDescription
     * @returns {Promise<boolean>}
     */
    PeerConnectionV2.prototype._maybeReoffer = function (localDescription) {
        var shouldReoffer = this._shouldOffer;
        if (localDescription && localDescription.sdp) {
            // NOTE(mmalavalli): If the local RTCSessionDescription has fewer audio and/or
            // video send* m= lines than the corresponding RTCRtpSenders with non-null
            // MediaStreamTracks, it means that the newly added RTCRtpSenders require
            // renegotiation.
            var senders_1 = this._peerConnection.getSenders().filter(function (sender) { return sender.track; });
            shouldReoffer = ['audio', 'video'].reduce(function (shouldOffer, kind) {
                var mediaSections = getMediaSections(localDescription.sdp, kind, '(sendrecv|sendonly)');
                var sendersOfKind = senders_1.filter(isSenderOfKind.bind(null, kind));
                return shouldOffer || (mediaSections.length < sendersOfKind.length);
            }, shouldReoffer);
            // NOTE(mroberts): We also need to re-offer if we have a DataTrack to share
            // but no m= application section.
            var hasDataTrack = this._dataChannels.size > 0;
            var hasApplicationMediaSection = getMediaSections(localDescription.sdp, 'application').length > 0;
            var needsApplicationMediaSection = hasDataTrack && !hasApplicationMediaSection;
            shouldReoffer = shouldReoffer || needsApplicationMediaSection;
        }
        var promise = shouldReoffer ? this._offer() : Promise.resolve();
        return promise.then(function () { return shouldReoffer; });
    };
    /**
     * Create an offer and set it on the {@link PeerConnectionV2}.
     * @private
     * @returns {Promise<void>}
     */
    PeerConnectionV2.prototype._offer = function () {
        var _this = this;
        var offerOptions = Object.assign({}, this._offerOptions);
        this._needsAnswer = true;
        if (this._shouldRestartIce) {
            this._shouldRestartIce = false;
            this._isRestartingIce = true;
            offerOptions.iceRestart = true;
        }
        return Promise.all(this._replaceTrackPromises.values()).then(function () {
            return _this._peerConnection.createOffer(offerOptions);
        }).catch(function (error) {
            var errorToThrow = new MediaClientLocalDescFailedError();
            _this._publishMediaWarning({
                message: 'Failed to create offer',
                code: errorToThrow.code,
                error: error
            });
            throw errorToThrow;
        }).then(function (offer) {
            if (isFirefox) {
                // NOTE(mmalavalli): We work around Chromium bug 1106157 by disabling
                // RTX in Firefox 79+. For more details about the bug, please go here:
                // https://bugs.chromium.org/p/chromium/issues/detail?id=1106157
                offer = new _this._RTCSessionDescription({
                    sdp: disableRtx(offer.sdp),
                    type: offer.type
                });
            }
            else {
                offer = workaroundIssue8329(offer);
            }
            // NOTE(mpatwardhan): upcoming chrome versions are going to remove ssrc attributes
            // mslabel and label. See this bug https://bugs.chromium.org/p/webrtc/issues/detail?id=7110
            // and PSA: https://groups.google.com/forum/#!searchin/discuss-webrtc/PSA%7Csort:date/discuss-webrtc/jcZO-Wj0Wus/k2XvPCvoAwAJ
            // Looks like we are not referencing those attributes, but this changes goes ahead and removes them to see if it works.
            // this also helps reduce bytes on wires
            var sdp = removeSSRCAttributes(offer.sdp, ['mslabel', 'label']);
            sdp = _this._peerConnection.remoteDescription
                ? filterLocalCodecs(sdp, _this._peerConnection.remoteDescription.sdp)
                : sdp;
            var updatedSdp = _this._setCodecPreferences(sdp, _this._preferredAudioCodecs, _this._preferredVideoCodecs);
            _this._shouldOffer = false;
            if (!_this._negotiationRole) {
                _this._negotiationRole = 'offerer';
            }
            if (_this._shouldApplySimulcast) {
                _this._localDescriptionWithoutSimulcast = {
                    type: 'offer',
                    sdp: updatedSdp
                };
                updatedSdp = _this._setSimulcast(updatedSdp, _this._trackIdsToAttributes);
            }
            return _this._setLocalDescription({
                type: 'offer',
                sdp: updatedSdp
            });
        });
    };
    /**
     * Get the MediaTrackSender ID of the given MediaStreamTrack ID.
     * Since a MediaTrackSender's underlying MediaStreamTrack can be
     * replaced, the corresponding IDs can mismatch.
     * @private
     * @param {Track.ID} id
     * @returns {Track.ID}
     */
    PeerConnectionV2.prototype._getMediaTrackSenderId = function (trackId) {
        var mediaTrackSender = Array.from(this._rtpSenders.keys()).find(function (_a) {
            var id = _a.track.id;
            return id === trackId;
        });
        return mediaTrackSender ? mediaTrackSender.id : trackId;
    };
    /**
     * Add or rewrite local MediaStreamTrack IDs in the given RTCSessionDescription.
     * @private
     * @param {RTCSessionDescription} description
     * @return {RTCSessionDescription}
     */
    PeerConnectionV2.prototype._addOrRewriteLocalTrackIds = function (description) {
        var _this = this;
        var transceivers = this._peerConnection.getTransceivers();
        var activeTransceivers = transceivers.filter(function (_a) {
            var sender = _a.sender, stopped = _a.stopped;
            return !stopped && sender && sender.track;
        });
        // NOTE(mmalavalli): There is no guarantee that MediaStreamTrack IDs will be present in
        // SDPs, and even if they are, there is no guarantee that they will be the same as the
        // actual MediaStreamTrack IDs. So, we add or re-write the actual MediaStreamTrack IDs
        // to the assigned m= sections here.
        var assignedTransceivers = activeTransceivers.filter(function (_a) {
            var mid = _a.mid;
            return mid;
        });
        var midsToTrackIds = new Map(assignedTransceivers.map(function (_a) {
            var mid = _a.mid, sender = _a.sender;
            return [mid, _this._getMediaTrackSenderId(sender.track.id)];
        }));
        var sdp1 = addOrRewriteTrackIds(description.sdp, midsToTrackIds);
        // NOTE(mmalavalli): Chrome and Safari do not apply the offer until they get an answer.
        // So, we add or re-write the actual MediaStreamTrack IDs to the unassigned m= sections here.
        var unassignedTransceivers = activeTransceivers.filter(function (_a) {
            var mid = _a.mid;
            return !mid;
        });
        var newTrackIdsByKind = new Map(['audio', 'video'].map(function (kind) { return [
            kind,
            unassignedTransceivers.filter(function (_a) {
                var sender = _a.sender;
                return sender.track.kind === kind;
            }).map(function (_a) {
                var sender = _a.sender;
                return _this._getMediaTrackSenderId(sender.track.id);
            })
        ]; }));
        var sdp2 = addOrRewriteNewTrackIds(sdp1, midsToTrackIds, newTrackIdsByKind);
        return new this._RTCSessionDescription({
            sdp: sdp2,
            type: description.type
        });
    };
    /**
     * Rollback and apply the given offer.
     * @private
     * @param {RTCSessionDescriptionInit} offer
     * @returns {Promise<void>}
     */
    PeerConnectionV2.prototype._rollbackAndApplyOffer = function (offer) {
        var _this = this;
        return this._setLocalDescription({ type: 'rollback' }).then(function () { return _this._setLocalDescription(offer); });
    };
    /**
     * Set a local description on the {@link PeerConnectionV2}.
     * @private
     * @param {RTCSessionDescription|RTCSessionDescriptionInit} description
     * @returns {Promise<void>}
     */
    PeerConnectionV2.prototype._setLocalDescription = function (description) {
        var _this = this;
        if (description.type !== 'rollback' && this._shouldApplyDtx) {
            description = new this._RTCSessionDescription({
                sdp: enableDtxForOpus(description.sdp),
                type: description.type
            });
        }
        return this._peerConnection.setLocalDescription(description).catch(function (error) {
            _this._log.warn("Calling setLocalDescription with an RTCSessionDescription of type \"" + description.type + "\" failed with the error \"" + error.message + "\".", error);
            var errorToThrow = new MediaClientLocalDescFailedError();
            var publishWarning = {
                message: "Calling setLocalDescription with an RTCSessionDescription of type \"" + description.type + "\" failed",
                code: errorToThrow.code,
                error: error
            };
            if (description.sdp) {
                _this._log.warn("The SDP was " + description.sdp);
                publishWarning.sdp = description.sdp;
            }
            _this._publishMediaWarning(publishWarning);
            throw errorToThrow;
        }).then(function () {
            if (description.type !== 'rollback') {
                _this._localDescription = _this._addOrRewriteLocalTrackIds(description);
                // NOTE(mmalavalli): In order for this feature to be backward compatible with older
                // SDK versions which to not support opus DTX, we append "usedtx=1" to the local SDP
                // only while applying it. We will not send it over the wire to prevent inadvertent
                // enabling of opus DTX in older SDKs. Newer SDKs will append "usedtx=1" by themselves
                // if the developer has requested opus DTX to be enabled. (JSDK-3063)
                if (_this._shouldApplyDtx) {
                    _this._localDescription = new _this._RTCSessionDescription({
                        sdp: enableDtxForOpus(_this._localDescription.sdp, []),
                        type: _this._localDescription.type
                    });
                }
                _this._localCandidates = [];
                if (description.type === 'offer') {
                    _this._descriptionRevision++;
                }
                else if (description.type === 'answer') {
                    _this._lastStableDescriptionRevision = _this._descriptionRevision;
                    negotiationCompleted(_this);
                }
                _this._localUfrag = getUfrag(description);
                _this.emit('description', _this.getState());
            }
        });
    };
    /**
     * Set a remote RTCSessionDescription on the {@link PeerConnectionV2}.
     * @private
     * @param {RTCSessionDescriptionInit} description
     * @returns {Promise<void>}
     */
    PeerConnectionV2.prototype._setRemoteDescription = function (description) {
        var _this = this;
        if (description.sdp) {
            description.sdp = this._setCodecPreferences(description.sdp, this._preferredAudioCodecs, this._preferredVideoCodecs);
            if (this._shouldApplyDtx) {
                description.sdp = enableDtxForOpus(description.sdp);
            }
            else {
                // NOTE(mmalavalli): Remove "usedtx=1" from opus's fmtp line if present
                // since DTX is disabled.
                description.sdp = enableDtxForOpus(description.sdp, []);
            }
            if (isFirefox) {
                // NOTE(mroberts): Do this to reduce our MediaStream count in Firefox. By
                // mapping MediaStream IDs in the SDP to "-", we ensure the "track" event
                // doesn't include any new MediaStreams in Firefox. Its `streams` member
                // will always be the empty Array.
                description.sdp = filterOutMediaStreamIds(description.sdp);
            }
            if (!this._peerConnection.remoteDescription) {
                this._isIceLite = /a=ice-lite/.test(description.sdp);
            }
        }
        description = new this._RTCSessionDescription(description);
        // eslint-disable-next-line consistent-return
        return Promise.resolve().then(function () {
            // NOTE(syerrapragada): VMS does not support H264 simulcast. So,
            // unset simulcast for sections in local offer where corresponding
            // sections in answer doesn't have vp8 as preferred codec and reapply offer.
            if (description.type === 'answer' && _this._localDescriptionWithoutSimulcast) {
                // NOTE(mpatwardhan):if we were using adaptive simulcast, and if its not supported by server
                // revert simulcast even for vp8.
                var adaptiveSimulcastEntry = _this._preferredVideoCodecs.find(function (cs) { return 'adaptiveSimulcast' in cs; });
                var revertForAll = !!adaptiveSimulcastEntry && adaptiveSimulcastEntry.adaptiveSimulcast === false;
                var sdpWithoutSimulcastForNonVP8MediaSections = _this._revertSimulcast(_this._localDescription.sdp, _this._localDescriptionWithoutSimulcast.sdp, description.sdp, revertForAll);
                _this._localDescriptionWithoutSimulcast = null;
                if (sdpWithoutSimulcastForNonVP8MediaSections !== _this._localDescription.sdp) {
                    return _this._rollbackAndApplyOffer({
                        type: _this._localDescription.type,
                        sdp: sdpWithoutSimulcastForNonVP8MediaSections
                    });
                }
            }
        }).then(function () { return _this._peerConnection.setRemoteDescription(description); }).then(function () {
            if (description.type === 'answer') {
                if (_this._isRestartingIce) {
                    _this._log.debug('An ICE restart was in-progress and is now completed');
                    _this._isRestartingIce = false;
                }
                negotiationCompleted(_this);
            }
        }, function (error) {
            _this._log.warn("Calling setRemoteDescription with an RTCSessionDescription of type \"" + description.type + "\" failed with the error \"" + error.message + "\".", error);
            if (description.sdp) {
                _this._log.warn("The SDP was " + description.sdp);
            }
            throw error;
        });
    };
    /**
     * Update the {@link PeerConnectionV2}'s description.
     * @private
     * @param {RTCSessionDescriptionInit} description
     * @returns {Promise<void>}
     */
    PeerConnectionV2.prototype._updateDescription = function (description) {
        var _this = this;
        switch (description.type) {
            case 'answer':
            case 'pranswer':
                if (description.revision !== this._descriptionRevision
                    || this._peerConnection.signalingState !== 'have-local-offer') {
                    return Promise.resolve();
                }
                this._descriptionRevision = description.revision;
                break;
            case 'close':
                return this._close();
            case 'create-offer':
                if (description.revision <= this._lastStableDescriptionRevision) {
                    return Promise.resolve();
                }
                else if (this._needsAnswer) {
                    this._queuedDescription = description;
                    return Promise.resolve();
                }
                this._descriptionRevision = description.revision;
                return this._offer();
            case 'offer':
                if (description.revision <= this._lastStableDescriptionRevision
                    || this._peerConnection.signalingState === 'closed') {
                    return Promise.resolve();
                }
                if (this._peerConnection.signalingState === 'have-local-offer') {
                    // NOTE(mpatwardhan): For a peer connection
                    // 1) createOffer always generate SDP with `setup:actpass`
                    // 2) when remote description is set `setup:active`  - the answer generated selects the dtls role of setup:passive
                    // 3) when remote description is set `setup:passive` - the answer generated selects the dtls role of setup:active
                    // 4) when remote description is set `setup:actpass` - the answer generated uses the previously negotiated role (if not negotiated previously setup:active is used)
                    // This test shows the  behavior: https://github.com/twilio/twilio-webrtc.js/blob/master/test/integration/spec/rtcpeerconnection.js#L936
                    // with glare handling (if dtls role was not negotiated before ) the generated answer will set setup:active.
                    // we do not want that. lets wait for "initial negotiation" before attempting glare handling.
                    if (this._needsAnswer && this._lastStableDescriptionRevision === 0) {
                        this._queuedDescription = description;
                        return Promise.resolve();
                    }
                    this._descriptionRevision = description.revision;
                    return this._handleGlare(description);
                }
                this._descriptionRevision = description.revision;
                return this._answer(description).then(function () { });
            default:
            // Do nothing.
        }
        // Handle answer or pranswer.
        var revision = description.revision;
        return Promise.resolve().then(function () {
            return _this._setRemoteDescription(description);
        }).catch(function (error) {
            var errorToThrow = new MediaClientRemoteDescFailedError();
            _this._publishMediaWarning({
                message: "Calling setRemoteDescription with an RTCSessionDescription of type \"" + description.type + "\" failed",
                code: errorToThrow.code,
                error: error,
                sdp: description.sdp
            });
            throw errorToThrow;
        }).then(function () {
            _this._lastStableDescriptionRevision = revision;
            _this._needsAnswer = false;
            return _this._checkIceBox(description);
        }).then(function () {
            return _this._queuedDescription
                && _this._updateDescription(_this._queuedDescription);
        }).then(function () {
            _this._queuedDescription = null;
            return _this._maybeReoffer(_this._peerConnection.localDescription).then(function () { });
        });
    };
    /**
     * Update the {@link PeerConnectionV2}'s ICE candidates.
     * @private
     * @param {object} iceState
     * @returns {Promise<void>}
     */
    PeerConnectionV2.prototype._updateIce = function (iceState) {
        var candidates = this._remoteCandidates.update(iceState);
        return this._addIceCandidates(candidates);
    };
    /**
     * Add a {@link DataTrackSender} to the {@link PeerConnectionV2}.
     * @param {DataTrackSender} dataTrackSender
     * @returns {void}
     */
    PeerConnectionV2.prototype.addDataTrackSender = function (dataTrackSender) {
        if (this._dataChannels.has(dataTrackSender)) {
            return;
        }
        try {
            var dataChannelDict = {
                ordered: dataTrackSender.ordered
            };
            if (dataTrackSender.maxPacketLifeTime !== null) {
                dataChannelDict.maxPacketLifeTime = dataTrackSender.maxPacketLifeTime;
            }
            if (dataTrackSender.maxRetransmits !== null) {
                dataChannelDict.maxRetransmits = dataTrackSender.maxRetransmits;
            }
            var dataChannel = this._peerConnection.createDataChannel(dataTrackSender.id, dataChannelDict);
            dataTrackSender.addDataChannel(dataChannel);
            this._dataChannels.set(dataTrackSender, dataChannel);
        }
        catch (error) {
            this._log.warn("Error creating an RTCDataChannel for DataTrack \"" + dataTrackSender.id + "\": " + error.message);
        }
    };
    PeerConnectionV2.prototype._handleQueuedPublisherHints = function () {
        var _this = this;
        if (this._peerConnection.signalingState === 'stable') {
            this._mediaTrackSenderToPublisherHints.forEach(function (_a, mediaTrackSender) {
                var deferred = _a.deferred, encodings = _a.encodings;
                _this._mediaTrackSenderToPublisherHints.delete(mediaTrackSender);
                _this._setPublisherHint(mediaTrackSender, encodings)
                    .then(function (result) { return deferred.resolve(result); })
                    .catch(function (error) { return deferred.reject(error); });
            });
        }
    };
    /**
     * updates encodings for simulcast layers of given sender.
     * @param {RTCRtpSender} sender
     * @param {Array<{enabled: boolean, layer_index: number}>|null} encodings
     * @returns {Promise<string>} string indicating result of the operation. can be one of
     *  "OK", "INVALID_HINT", "COULD_NOT_APPLY_HINT", "UNKNOWN_TRACK"
     */
    PeerConnectionV2.prototype._setPublisherHint = function (mediaTrackSender, encodings) {
        var _this = this;
        if (isFirefox) {
            return Promise.resolve('COULD_NOT_APPLY_HINT');
        }
        if (this._mediaTrackSenderToPublisherHints.has(mediaTrackSender)) {
            // skip any stale hint associated with the mediaTrackSender.
            var queuedHint = this._mediaTrackSenderToPublisherHints.get(mediaTrackSender);
            queuedHint.deferred.resolve('REQUEST_SKIPPED');
            this._mediaTrackSenderToPublisherHints.delete(mediaTrackSender);
        }
        var sender = this._rtpSenders.get(mediaTrackSender);
        if (!sender) {
            this._log.warn('Could not apply publisher hint because RTCRtpSender was not found');
            return Promise.resolve('UNKNOWN_TRACK');
        }
        if (this._peerConnection.signalingState === 'closed') {
            this._log.warn('Could not apply publisher hint because signalingState was "closed"');
            return Promise.resolve('COULD_NOT_APPLY_HINT');
        }
        if (this._peerConnection.signalingState !== 'stable') {
            // enqueue this hint to be applied when pc becomes stable.
            this._log.debug('Queuing up publisher hint because signalingState:', this._peerConnection.signalingState);
            var deferred = defer();
            this._mediaTrackSenderToPublisherHints.set(mediaTrackSender, { deferred: deferred, encodings: encodings });
            return deferred.promise;
        }
        var parameters = sender.getParameters();
        if (encodings !== null) {
            encodings.forEach(function (_a) {
                var enabled = _a.enabled, layerIndex = _a.layer_index;
                if (parameters.encodings.length > layerIndex) {
                    _this._log.debug("layer:" + layerIndex + ", active:" + parameters.encodings[layerIndex].active + " => " + enabled);
                    parameters.encodings[layerIndex].active = enabled;
                }
                else {
                    _this._log.warn("invalid layer:" + layerIndex + ", active:" + enabled);
                }
            });
        }
        // Note(mpatwardhan): after publisher hints are applied, overwrite with default encodings
        // to disable any encoding that shouldn't have been enabled by publisher_hints.
        // When encodings===null (that is we are asked to reset encodings for replaceTrack)
        // along with disabling encodings, clear active flag for encodings that should not be disabled
        this._maybeUpdateEncodings(sender.track, parameters.encodings, encodings === null /* trackReplaced */);
        return sender.setParameters(parameters).then(function () { return 'OK'; }).catch(function (error) {
            _this._log.error('Failed to apply publisher hints:', error);
            return 'COULD_NOT_APPLY_HINT';
        });
    };
    /**
     * Add the {@link MediaTrackSender} to the {@link PeerConnectionV2}.
     * @param {MediaTrackSender} mediaTrackSender
     * @returns {void}
     */
    PeerConnectionV2.prototype.addMediaTrackSender = function (mediaTrackSender) {
        var _this = this;
        if (this._peerConnection.signalingState === 'closed' || this._rtpSenders.has(mediaTrackSender)) {
            return;
        }
        var transceiver = this._addOrUpdateTransceiver(mediaTrackSender.track);
        var sender = transceiver.sender;
        mediaTrackSender.addSender(sender, function (encodings) { return _this._setPublisherHint(mediaTrackSender, encodings); });
        this._rtpNewSenders.add(sender);
        this._rtpSenders.set(mediaTrackSender, sender);
    };
    /**
     * Close the {@link PeerConnectionV2}.
     * @returns {void}
     */
    PeerConnectionV2.prototype.close = function () {
        if (this._close()) {
            this._descriptionRevision++;
            this._localDescription = { type: 'close' };
            this.emit('description', this.getState());
        }
    };
    /**
     * Get the {@link DataTrackReceiver}s and the {@link MediaTrackReceiver}s on the
     * {@link PeerConnectionV2}.
     * @returns {Array<DataTrackReceiver|MediaTrackReceiver>} trackReceivers
     */
    PeerConnectionV2.prototype.getTrackReceivers = function () {
        return Array.from(this._dataTrackReceivers).concat(Array.from(this._mediaTrackReceivers));
    };
    /**
     * Get the {@link PeerConnectionV2}'s state (specifically, its description).
     * @returns {?object}
     */
    PeerConnectionV2.prototype.getState = function () {
        if (!this._localDescription) {
            return null;
        }
        // NOTE(mpatwardhan): Return most recent localDescription. If the most recent local description is an
        // answer, and this method is called for sending a "sync" message while the next remote offer is being processed,
        // we need to send the most recent stable description revision instead of the current description revision,
        // which is supposed to be for the next local answer.
        var localDescriptionRevision = this._localDescription.type === 'answer' ? this._lastStableDescriptionRevision : this._descriptionRevision;
        var localDescription = {
            type: this._localDescription.type,
            revision: localDescriptionRevision
        };
        if (this._localDescription.sdp) {
            localDescription.sdp = this._localDescription.sdp;
        }
        return {
            description: localDescription,
            id: this.id
        };
    };
    /**
     * Create an offer and set it on the {@link PeerConnectionV2}.
     * @returns {Promise<void>}
     */
    PeerConnectionV2.prototype.offer = function () {
        var _this = this;
        if (this._needsAnswer || this._isRestartingIce) {
            this._shouldOffer = true;
            return Promise.resolve();
        }
        return this.bracket('offering', function (key) {
            _this.transition('updating', key);
            var promise = _this._needsAnswer || _this._isRestartingIce ? Promise.resolve() : _this._offer();
            return promise.then(function () {
                _this.tryTransition('open', key);
            }, function (error) {
                _this.tryTransition('open', key);
                throw error;
            });
        });
    };
    /**
     * Remove a {@link DataTrackSender} from the {@link PeerConnectionV2}.
     * @param {DataTrackSender} dataTrackSender
     * @returns {void}
     */
    PeerConnectionV2.prototype.removeDataTrackSender = function (dataTrackSender) {
        var dataChannel = this._dataChannels.get(dataTrackSender);
        if (dataChannel) {
            dataTrackSender.removeDataChannel(dataChannel);
            this._dataChannels.delete(dataTrackSender);
            dataChannel.close();
        }
    };
    /**
     * Remove the {@link MediaTrackSender} from the {@link PeerConnectionV2}.
     * @param {MediaTrackSender} mediaTrackSender
     * @returns {void}
     */
    PeerConnectionV2.prototype.removeMediaTrackSender = function (mediaTrackSender) {
        var sender = this._rtpSenders.get(mediaTrackSender);
        if (!sender) {
            return;
        }
        if (this._peerConnection.signalingState !== 'closed') {
            this._peerConnection.removeTrack(sender);
        }
        mediaTrackSender.removeSender(sender);
        // clean up any pending publisher hints associated with this mediaTrackSender.
        if (this._mediaTrackSenderToPublisherHints.has(mediaTrackSender)) {
            var queuedHint = this._mediaTrackSenderToPublisherHints.get(mediaTrackSender);
            queuedHint.deferred.resolve('UNKNOWN_TRACK');
            this._mediaTrackSenderToPublisherHints.delete(mediaTrackSender);
        }
        this._rtpNewSenders.delete(sender);
        this._rtpSenders.delete(mediaTrackSender);
    };
    /**
     * Set the RTCConfiguration on the underlying RTCPeerConnection.
     * @param {RTCConfiguration} configuration
     * @returns {void}
     */
    PeerConnectionV2.prototype.setConfiguration = function (configuration) {
        if (typeof this._peerConnection.setConfiguration === 'function') {
            this._peerConnection.setConfiguration(getConfiguration(configuration));
        }
    };
    /**
     * Set the ICE reconnect timeout period.
     * @param {number} period - Period in milliseconds.
     * @returns {this}
     */
    PeerConnectionV2.prototype.setIceReconnectTimeout = function (period) {
        this._iceReconnectTimeout.setDelay(period);
        this._log.debug('Updated ICE reconnection timeout period:', this._iceReconnectTimeout.delay);
        return this;
    };
    /**
     * Update the {@link PeerConnectionV2}.
     * @param {object} peerConnectionState
     * @returns {Promise<void>}
     */
    PeerConnectionV2.prototype.update = function (peerConnectionState) {
        var _this = this;
        return this.bracket('updating', function (key) {
            if (_this.state === 'closed') {
                return Promise.resolve();
            }
            _this.transition('updating', key);
            var updates = [];
            if (peerConnectionState.ice) {
                updates.push(_this._updateIce(peerConnectionState.ice));
            }
            if (peerConnectionState.description) {
                updates.push(_this._updateDescription(peerConnectionState.description));
            }
            return Promise.all(updates).then(function () {
                _this.tryTransition('open', key);
            }, function (error) {
                _this.tryTransition('open', key);
                throw error;
            });
        });
    };
    /**
     * Get the {@link PeerConnectionV2}'s media statistics.
     * @returns {Promise<StandardizedStatsResponse>}
     */
    PeerConnectionV2.prototype.getStats = function () {
        var _this = this;
        return getStatistics(this._peerConnection).then(function (response) { return rewriteTrackIds(_this, response); });
    };
    return PeerConnectionV2;
}(StateMachine));
function rewriteLocalTrackId(pcv2, stats) {
    var trackId = pcv2._getMediaTrackSenderId(stats.trackId);
    return Object.assign(stats, { trackId: trackId });
}
function rewriteTrackId(pcv2, stats) {
    var receiver = __spreadArray([], __read(pcv2._mediaTrackReceivers)).find(function (receiver) { return receiver.track.id === stats.trackId; });
    var trackId = receiver ? receiver.id : null;
    return Object.assign(stats, { trackId: trackId });
}
function rewriteTrackIds(pcv2, response) {
    return Object.assign(response, {
        remoteAudioTrackStats: response.remoteAudioTrackStats.map(function (stats) { return rewriteTrackId(pcv2, stats); }),
        remoteVideoTrackStats: response.remoteVideoTrackStats.map(function (stats) { return rewriteTrackId(pcv2, stats); }),
        localAudioTrackStats: response.localAudioTrackStats.map(function (stats) { return rewriteLocalTrackId(pcv2, stats); }),
        localVideoTrackStats: response.localVideoTrackStats.map(function (stats) { return rewriteLocalTrackId(pcv2, stats); }),
    });
}
/**
 * @event PeerConnectionV2#candidates
 * @param {object} candidates
 */
/**
 * @event PeerConnectionV2#connectionStateChanged
 */
/**
 * @event PeerConnectionV2#description
 * @param {object} description
 */
/**
 * @event PeerConnectionV2#iceConnectionStateChanged
 */
/**
 * @event PeerConnectionV2#trackAdded
 * @param {DataTrackReceiver|MediaTrackReceiver} trackReceiver
 */
function getUfrag(description) {
    if (description.sdp) {
        var match = description.sdp.match(/^a=ice-ufrag:([a-zA-Z0-9+/]+)/m);
        if (match) {
            return match[1];
        }
    }
    return null;
}
function getConfiguration(configuration) {
    return Object.assign({
        bundlePolicy: 'max-bundle',
        rtcpMuxPolicy: 'require'
    }, configuration);
}
/**
 * Whether the MediaStreamTrack of the given RTCRTPSender is a non-ended
 * MediaStreamTrack of a given kind.
 * @private
 * @param {string} kind
 * @param {RTCRtpSender} sender
 * @return {boolean}
 */
function isSenderOfKind(kind, sender) {
    var track = sender.track;
    return track && track.kind === kind && track.readyState !== 'ended';
}
/**
 * Preferred codecs.
 * @typedef {object} PreferredCodecs
 * @property {Array<AudioCodec>} audio
 * @property {Array<VideoCodec>} video
 */
function filterOutMediaStreamIds(sdp) {
    return sdp.replace(/a=msid:[^ ]+ /g, 'a=msid:- ');
}
/**
 * Whether an RTCRtpTransceiver can be recycled.
 * @param {RTCRtpTransceiver} transceiver
 * @returns {boolean}
 */
function shouldRecycleTransceiver(transceiver, pcv2) {
    return !transceiver.stopped
        && !pcv2._replaceTrackPromises.has(transceiver)
        && ['inactive', 'recvonly'].includes(transceiver.direction);
}
/**
 * Take a recycled RTCRtpTransceiver if available.
 * @param {PeerConnectionV2} pcv2
 * @param {Track.Kind} kind
 * @returns {?RTCRtpTransceiver}
 */
function takeRecycledTransceiver(pcv2, kind) {
    var preferredCodecs = {
        audio: pcv2._preferredAudioCodecs.map(function (_a) {
            var codec = _a.codec;
            return codec.toLowerCase();
        }),
        video: pcv2._preferredVideoCodecs.map(function (_a) {
            var codec = _a.codec;
            return codec.toLowerCase();
        })
    }[kind];
    var recycledTransceivers = pcv2._recycledTransceivers[kind];
    var localCodec = preferredCodecs.find(function (codec) { return pcv2._localCodecs.has(codec); });
    if (!localCodec) {
        return recycledTransceivers.shift();
    }
    var transceiver = recycledTransceivers.find(function (transceiver) {
        var remoteCodecMap = pcv2._remoteCodecMaps.get(transceiver.mid);
        return remoteCodecMap && remoteCodecMap.has(localCodec);
    });
    if (transceiver) {
        recycledTransceivers.splice(recycledTransceivers.indexOf(transceiver), 1);
    }
    return transceiver;
}
/**
 * Update the set of locally supported {@link Codec}s.
 * @param pcv2
 * @returns {void}
 */
function updateLocalCodecs(pcv2) {
    var description = pcv2._peerConnection.localDescription;
    if (!description || !description.sdp) {
        return;
    }
    getMediaSections(description.sdp).forEach(function (section) {
        var codecMap = createCodecMapForMediaSection(section);
        codecMap.forEach(function (pts, codec) { return pcv2._localCodecs.add(codec); });
    });
}
/**
 * Update the {@link Codec} maps for all m= sections in the remote {@link RTCSessionDescription}s.
 * @param {PeerConnectionV2} pcv2
 * @returns {void}
 */
function updateRemoteCodecMaps(pcv2) {
    var description = pcv2._peerConnection.remoteDescription;
    if (!description || !description.sdp) {
        return;
    }
    getMediaSections(description.sdp).forEach(function (section) {
        var matched = section.match(/^a=mid:(.+)$/m);
        if (!matched || !matched[1]) {
            return;
        }
        var mid = matched[1];
        var codecMap = createCodecMapForMediaSection(section);
        pcv2._remoteCodecMaps.set(mid, codecMap);
    });
}
/**
 * Update the list of recycled RTCRtpTransceivers.
 * @param {PeerConnectionV2} pcv2
 */
function updateRecycledTransceivers(pcv2) {
    pcv2._recycledTransceivers.audio = [];
    pcv2._recycledTransceivers.video = [];
    pcv2._peerConnection.getTransceivers().forEach(function (transceiver) {
        if (shouldRecycleTransceiver(transceiver, pcv2)) {
            var track = transceiver.receiver.track;
            pcv2._recycledTransceivers[track.kind].push(transceiver);
        }
    });
}
/**
 * Perform certain updates after an SDP negotiation is completed.
 * @param {PeerConnectionV2} pcv2
 * @returns {void}
 */
function negotiationCompleted(pcv2) {
    updateRecycledTransceivers(pcv2);
    updateLocalCodecs(pcv2);
    updateRemoteCodecMaps(pcv2);
    updateEncodingParameters(pcv2).then(function () {
        // if there any any publisher hints queued, apply them now.
        pcv2._handleQueuedPublisherHints();
    });
}
/**
 * Update the RTCRtpEncodingParameters of all active RTCRtpSenders.
 * @param {PeerConnectionV2} pcv2
 * @returns {void}
 */
function updateEncodingParameters(pcv2) {
    var _a = pcv2._encodingParameters, maxAudioBitrate = _a.maxAudioBitrate, maxVideoBitrate = _a.maxVideoBitrate;
    var maxBitrates = new Map([
        ['audio', maxAudioBitrate],
        ['video', maxVideoBitrate]
    ]);
    var promises = [];
    pcv2._peerConnection.getSenders().filter(function (sender) { return sender.track; }).forEach(function (sender) {
        var maxBitrate = maxBitrates.get(sender.track.kind);
        var params = sender.getParameters();
        if (maxBitrate === null || maxBitrate === 0) {
            removeMaxBitrate(params);
        }
        else if (pcv2._isChromeScreenShareTrack(sender.track)) {
            // NOTE(mpatwardhan): Sometimes (JSDK-2557) chrome does not send any bytes on screen track if MaxBitRate is set on it via setParameters,
            // To workaround this issue we will not apply maxBitrate if the track appears to be a screen share track created by chrome
            pcv2._log.warn("Not setting maxBitrate for " + sender.track.kind + " Track " + sender.track.id + " because it appears to be screen share track: " + sender.track.label);
        }
        else {
            setMaxBitrate(params, maxBitrate);
        }
        if (!isFirefox && params.encodings.length > 0) {
            if (sender.track.kind === 'audio') {
                // NOTE(mmalavalli): "priority" is a per-sender property and not
                // a per-encoding-layer property. So, we set the value only on the first
                // encoding layer. Any attempt to set the value on subsequent encoding
                // layers (in the case of simulcast) will result in the Promise returned
                // by RTCRtpSender.setParameters() being rejected. With this, audio encoding
                // is prioritized the most.
                params.encodings[0].priority = 'high';
            }
            else if (pcv2._isChromeScreenShareTrack(sender.track)) {
                // NOTE(mmalavalli): Screen share encodings are prioritized more than those
                // of the camera.
                params.encodings[0].priority = 'medium';
            }
            if (pcv2._enableDscp) {
                // NOTE(mmalavalli): "networkPriority" is a per-sender property and not
                // a per-encoding-layer property. So, we set the value only on the first
                // encoding layer. Any attempt to set the value on subsequent encoding
                // layers (in the case of simulcast) will result in the Promise returned
                // by RTCRtpSender.setParameters() being rejected.
                params.encodings[0].networkPriority = 'high';
            }
        }
        // when a sender is reused, delete any active encodings set by server.
        var trackReplaced = pcv2._rtpNewSenders.has(sender);
        pcv2._maybeUpdateEncodings(sender.track, params.encodings, trackReplaced);
        pcv2._rtpNewSenders.delete(sender);
        var promise = sender.setParameters(params).catch(function (error) {
            pcv2._log.warn("Error while setting encodings parameters for " + sender.track.kind + " Track " + sender.track.id + ": " + (error.message || error.name));
        });
        promises.push(promise);
    });
    return Promise.all(promises);
}
/**
 * Remove maxBitrate from the RTCRtpSendParameters' encodings.
 * @param {RTCRtpSendParameters} params
 * @returns {void}
 */
function removeMaxBitrate(params) {
    if (Array.isArray(params.encodings)) {
        params.encodings.forEach(function (encoding) { return delete encoding.maxBitrate; });
    }
}
/**
 * Set the given maxBitrate in the RTCRtpSendParameters' encodings.
 * @param {RTCRtpSendParameters} params
 * @param {number} maxBitrate
 * @returns {void}
 */
function setMaxBitrate(params, maxBitrate) {
    if (isFirefox) {
        params.encodings = [{ maxBitrate: maxBitrate }];
    }
    else {
        params.encodings.forEach(function (encoding) {
            encoding.maxBitrate = maxBitrate;
        });
    }
}
module.exports = PeerConnectionV2;

},{"../../data/receiver":5,"../../media/track/receiver":31,"../../statemachine":89,"../../util":133,"../../util/backoff":123,"../../util/constants":126,"../../util/log":137,"../../util/sdp":141,"../../util/sdp/issue8329":142,"../../util/sdp/trackmatcher":144,"../../util/timeout":147,"../../util/twilio-video-errors":148,"../../webrtc":159,"../../webrtc/util":171,"./icebox":70,"./iceconnectionmonitor.js":71}],79:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var guessBrowser = require('../../webrtc/util').guessBrowser;
var PeerConnectionV2 = require('./peerconnection');
var MediaTrackSender = require('../../media/track/sender');
var QueueingEventEmitter = require('../../queueingeventemitter');
var util = require('../../util');
var MediaConnectionError = require('../../util/twilio-video-errors').MediaConnectionError;
var isFirefox = guessBrowser() === 'firefox';
/**
 * {@link PeerConnectionManager} manages multiple {@link PeerConnectionV2}s.
 * @extends QueueingEventEmitter
 * @emits PeerConnectionManager#candidates
 * @emits PeerConnectionManager#connectionStateChanged
 * @emits PeerConnectionManager#description
 * @emits PeerConnectionManager#iceConnectionStateChanged
 * @emits PeerConnectionManager#trackAdded
 */
var PeerConnectionManager = /** @class */ (function (_super) {
    __extends(PeerConnectionManager, _super);
    /**
     * Construct {@link PeerConnectionManager}.
     * @param {EncodingParametersImpl} encodingParameters
     * @param {PreferredCodecs} preferredCodecs
     * @param {object} options
     */
    function PeerConnectionManager(encodingParameters, preferredCodecs, options) {
        var _this = _super.call(this) || this;
        options = Object.assign({
            audioContextFactory: isFirefox
                ? require('../../webaudio/audiocontext')
                : null,
            PeerConnectionV2: PeerConnectionV2
        }, options);
        var audioContext = options.audioContextFactory
            ? options.audioContextFactory.getOrCreate(_this)
            : null;
        // NOTE(mroberts): If we're using an AudioContext, we don't need to specify
        // `offerToReceiveAudio` in RTCOfferOptions.
        var offerOptions = audioContext
            ? { offerToReceiveVideo: true }
            : { offerToReceiveAudio: true, offerToReceiveVideo: true };
        Object.defineProperties(_this, {
            _audioContextFactory: {
                value: options.audioContextFactory
            },
            _closedPeerConnectionIds: {
                value: new Set()
            },
            _configuration: {
                writable: true,
                value: null
            },
            _configurationDeferred: {
                writable: true,
                value: util.defer()
            },
            _connectionState: {
                value: 'new',
                writable: true
            },
            _dummyAudioTrackSender: {
                value: audioContext
                    ? new MediaTrackSender(createDummyAudioMediaStreamTrack(audioContext))
                    : null
            },
            _encodingParameters: {
                value: encodingParameters
            },
            _iceConnectionState: {
                writable: true,
                value: 'new'
            },
            _dataTrackSenders: {
                writable: true,
                value: new Set()
            },
            _lastConnectionState: {
                value: 'new',
                writable: true
            },
            _lastIceConnectionState: {
                writable: true,
                value: 'new'
            },
            _mediaTrackSenders: {
                writable: true,
                value: new Set()
            },
            _offerOptions: {
                value: offerOptions
            },
            _peerConnections: {
                value: new Map()
            },
            _preferredCodecs: {
                value: preferredCodecs
            },
            _sessionTimeout: {
                value: null,
                writable: true
            },
            _PeerConnectionV2: {
                value: options.PeerConnectionV2
            }
        });
        return _this;
    }
    PeerConnectionManager.prototype.setEffectiveAdaptiveSimulcast = function (effectiveAdaptiveSimulcast) {
        this._peerConnections.forEach(function (pc) { return pc.setEffectiveAdaptiveSimulcast(effectiveAdaptiveSimulcast); });
        this._preferredCodecs.video.forEach(function (cs) {
            if ('adaptiveSimulcast' in cs) {
                cs.adaptiveSimulcast = effectiveAdaptiveSimulcast;
            }
        });
    };
    Object.defineProperty(PeerConnectionManager.prototype, "connectionState", {
        /**
         * A summarized RTCPeerConnectionState across all the
         * {@link PeerConnectionManager}'s underlying {@link PeerConnectionV2}s.
         * @property {RTCPeerConnectionState}
         */
        get: function () {
            return this._connectionState;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(PeerConnectionManager.prototype, "iceConnectionState", {
        /**
         * A summarized RTCIceConnectionState across all the
         * {@link PeerConnectionManager}'s underlying {@link PeerConnectionV2}s.
         * @property {RTCIceConnectionState}
         */
        get: function () {
            return this._iceConnectionState;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Close the {@link PeerConnectionV2}s which are no longer relevant.
     * @param {Array<object>} peerConnectionStates
     * @returns {this}
     */
    PeerConnectionManager.prototype._closeAbsentPeerConnections = function (peerConnectionStates) {
        var peerConnectionIds = new Set(peerConnectionStates.map(function (peerConnectionState) { return peerConnectionState.id; }));
        this._peerConnections.forEach(function (peerConnection) {
            if (!peerConnectionIds.has(peerConnection.id)) {
                peerConnection._close();
            }
        });
        return this;
    };
    /**
     * Get the {@link PeerConnectionManager}'s configuration.
     * @private
     * @returns {Promise<object>}
     */
    PeerConnectionManager.prototype._getConfiguration = function () {
        return this._configurationDeferred.promise;
    };
    /**
     * Get or create a {@link PeerConnectionV2}.
     * @private
     * @param {string} id
     * @param {object} [configuration]
     * @returns {PeerConnectionV2}
     */
    PeerConnectionManager.prototype._getOrCreate = function (id, configuration) {
        var _this = this;
        var self = this;
        var peerConnection = this._peerConnections.get(id);
        if (!peerConnection) {
            var PeerConnectionV2_1 = this._PeerConnectionV2;
            var options = Object.assign({
                dummyAudioMediaStreamTrack: this._dummyAudioTrackSender
                    ? this._dummyAudioTrackSender.track
                    : null,
                offerOptions: this._offerOptions
            }, this._sessionTimeout ? {
                sessionTimeout: this._sessionTimeout
            } : {}, configuration);
            try {
                peerConnection = new PeerConnectionV2_1(id, this._encodingParameters, this._preferredCodecs, options);
            }
            catch (e) {
                throw new MediaConnectionError();
            }
            this._peerConnections.set(peerConnection.id, peerConnection);
            peerConnection.on('candidates', this.queue.bind(this, 'candidates'));
            peerConnection.on('description', this.queue.bind(this, 'description'));
            peerConnection.on('trackAdded', this.queue.bind(this, 'trackAdded'));
            peerConnection.on('stateChanged', function stateChanged(state) {
                if (state === 'closed') {
                    peerConnection.removeListener('stateChanged', stateChanged);
                    self._dataTrackSenders.forEach(function (sender) { return peerConnection.removeDataTrackSender(sender); });
                    self._mediaTrackSenders.forEach(function (sender) { return peerConnection.removeMediaTrackSender(sender); });
                    self._peerConnections.delete(peerConnection.id);
                    self._closedPeerConnectionIds.add(peerConnection.id);
                    updateConnectionState(self);
                    updateIceConnectionState(self);
                }
            });
            peerConnection.on('connectionStateChanged', function () { return updateConnectionState(_this); });
            peerConnection.on('iceConnectionStateChanged', function () { return updateIceConnectionState(_this); });
            this._dataTrackSenders.forEach(peerConnection.addDataTrackSender, peerConnection);
            this._mediaTrackSenders.forEach(peerConnection.addMediaTrackSender, peerConnection);
            updateIceConnectionState(this);
        }
        return peerConnection;
    };
    /**
     * Close all the {@link PeerConnectionV2}s in this {@link PeerConnectionManager}.
     * @returns {this}
     */
    PeerConnectionManager.prototype.close = function () {
        this._peerConnections.forEach(function (peerConnection) {
            peerConnection.close();
        });
        if (this._dummyAudioTrackSender) {
            this._dummyAudioTrackSender.stop();
        }
        if (this._audioContextFactory) {
            this._audioContextFactory.release(this);
        }
        updateIceConnectionState(this);
        return this;
    };
    /**
     * Create a new {@link PeerConnectionV2} on this {@link PeerConnectionManager}.
     * Then, create a new offer with the newly-created {@link PeerConnectionV2}.
     * @return {Promise<this>}
     */
    PeerConnectionManager.prototype.createAndOffer = function () {
        var _this = this;
        return this._getConfiguration().then(function (configuration) {
            var id;
            do {
                id = util.makeUUID();
            } while (_this._peerConnections.has(id));
            return _this._getOrCreate(id, configuration);
        }).then(function (peerConnection) {
            return peerConnection.offer();
        }).then(function () {
            return _this;
        });
    };
    /**
     * Get the {@link DataTrackReceiver}s and {@link MediaTrackReceiver}s of all
     * the {@link PeerConnectionV2}s.
     * @returns {Array<DataTrackReceiver|MediaTrackReceiver>} trackReceivers
     */
    PeerConnectionManager.prototype.getTrackReceivers = function () {
        return util.flatMap(this._peerConnections, function (peerConnection) { return peerConnection.getTrackReceivers(); });
    };
    /**
     * Get the states of all {@link PeerConnectionV2}s.
     * @returns {Array<object>}
     */
    PeerConnectionManager.prototype.getStates = function () {
        var peerConnectionStates = [];
        this._peerConnections.forEach(function (peerConnection) {
            var peerConnectionState = peerConnection.getState();
            if (peerConnectionState) {
                peerConnectionStates.push(peerConnectionState);
            }
        });
        return peerConnectionStates;
    };
    /**
     * Set the {@link PeerConnectionManager}'s configuration.
     * @param {object} configuration
     * @returns {this}
     */
    PeerConnectionManager.prototype.setConfiguration = function (configuration) {
        if (this._configuration) {
            this._configurationDeferred = util.defer();
            this._peerConnections.forEach(function (peerConnection) {
                peerConnection.setConfiguration(configuration);
            });
        }
        this._configuration = configuration;
        this._configurationDeferred.resolve(configuration);
        return this;
    };
    /**
     * Set the ICE reconnect timeout period for all {@link PeerConnectionV2}s.
     * @param {number} period - Period in milliseconds.
     * @returns {this}
     */
    PeerConnectionManager.prototype.setIceReconnectTimeout = function (period) {
        if (this._sessionTimeout === null) {
            this._peerConnections.forEach(function (peerConnection) {
                peerConnection.setIceReconnectTimeout(period);
            });
            this._sessionTimeout = period;
        }
        return this;
    };
    /**
     * Set the {@link DataTrackSender}s and {@link MediaTrackSender}s on the
     * {@link PeerConnectionManager}'s underlying {@link PeerConnectionV2}s.
     * @param {Array<DataTrackSender|MediaTrackSender>} trackSenders
     * @returns {this}
     */
    PeerConnectionManager.prototype.setTrackSenders = function (trackSenders) {
        var dataTrackSenders = new Set(trackSenders.filter(function (trackSender) { return trackSender.kind === 'data'; }));
        var mediaTrackSenders = new Set(trackSenders
            .filter(function (trackSender) { return trackSender && (trackSender.kind === 'audio' || trackSender.kind === 'video'); }));
        var changes = getTrackSenderChanges(this, dataTrackSenders, mediaTrackSenders);
        this._dataTrackSenders = dataTrackSenders;
        this._mediaTrackSenders = mediaTrackSenders;
        applyTrackSenderChanges(this, changes);
        return this;
    };
    /**
     * Update the {@link PeerConnectionManager}.
     * @param {Array<object>} peerConnectionStates
     * @param {boolean} [synced=false]
     * @returns {Promise<this>}
     */
    PeerConnectionManager.prototype.update = function (peerConnectionStates, synced) {
        var _this = this;
        if (synced === void 0) { synced = false; }
        if (synced) {
            this._closeAbsentPeerConnections(peerConnectionStates);
        }
        return this._getConfiguration().then(function (configuration) {
            return Promise.all(peerConnectionStates.map(function (peerConnectionState) {
                if (_this._closedPeerConnectionIds.has(peerConnectionState.id)) {
                    return null;
                }
                var peerConnection = _this._getOrCreate(peerConnectionState.id, configuration);
                return peerConnection.update(peerConnectionState);
            }));
        }).then(function () {
            return _this;
        });
    };
    /**
     * Get the {@link PeerConnectionManager}'s media statistics.
     * @returns {Promise.<Map<PeerConnectionV2#id, StandardizedStatsResponse>>}
     */
    PeerConnectionManager.prototype.getStats = function () {
        var peerConnections = Array.from(this._peerConnections.values());
        return Promise.all(peerConnections.map(function (peerConnection) { return peerConnection.getStats().then(function (response) { return [
            peerConnection.id,
            response
        ]; }); })).then(function (responses) { return new Map(responses); });
    };
    return PeerConnectionManager;
}(QueueingEventEmitter));
/**
 * Create a dummy audio MediaStreamTrack with the given AudioContext.
 * @private
 * @param {AudioContext} audioContext
 * @return {MediaStreamTrack}
 */
function createDummyAudioMediaStreamTrack(audioContext) {
    var mediaStreamDestination = audioContext.createMediaStreamDestination();
    return mediaStreamDestination.stream.getAudioTracks()[0];
}
/**
 * @event {PeerConnectionManager#candidates}
 * @param {object} candidates
 */
/**
 * @event {PeerConnectionManager#connectionStateChanged}
 */
/**
 * @event {PeerConnectionManager#description}
 * @param {object} description
 */
/**
 * @event {PeerConnectionManager#iceConnectionStateChanged}
 */
/**
 * @event {PeerConnectionManager#trackAdded}
 * @param {MediaStreamTrack|DataTrackReceiver} mediaStreamTrackOrDataTrackReceiver
 */
/**
 * Apply {@link TrackSenderChanges}.
 * @param {PeerConnectionManager} peerConnectionManager
 * @param {TrackSenderChanges} changes
 * @returns {void}
 */
function applyTrackSenderChanges(peerConnectionManager, changes) {
    if (changes.data.add.size
        || changes.data.remove.size
        || changes.media.add.size
        || changes.media.remove.size) {
        peerConnectionManager._peerConnections.forEach(function (peerConnection) {
            changes.data.remove.forEach(peerConnection.removeDataTrackSender, peerConnection);
            changes.media.remove.forEach(peerConnection.removeMediaTrackSender, peerConnection);
            changes.data.add.forEach(peerConnection.addDataTrackSender, peerConnection);
            changes.media.add.forEach(peerConnection.addMediaTrackSender, peerConnection);
            if (changes.media.add.size
                || changes.media.remove.size
                || (changes.data.add.size && !peerConnection.isApplicationSectionNegotiated)) {
                peerConnection.offer();
            }
        });
    }
}
/**
 * @interface DataTrackSenderChanges
 * @property {Set<DataTrackSender>} add
 * @property {Set<DataTrackSender>} remove
 */
/**
 * Get the {@Link DataTrackSender} changes.
 * @param {PeerConnectionManager} peerConnectionManager
 * @param {Array<DataTrackSender>} dataTrackSenders
 * @returns {DataTrackSenderChanges} changes
 */
function getDataTrackSenderChanges(peerConnectionManager, dataTrackSenders) {
    var dataTrackSendersToAdd = util.difference(dataTrackSenders, peerConnectionManager._dataTrackSenders);
    var dataTrackSendersToRemove = util.difference(peerConnectionManager._dataTrackSenders, dataTrackSenders);
    return {
        add: dataTrackSendersToAdd,
        remove: dataTrackSendersToRemove
    };
}
/**
 * @interface TrackSenderChanges
 * @property {DataTrackSenderChanges} data
 * @property {MediaTrackSenderChanges} media
 */
/**
 * Get {@link DataTrackSender} and {@link MediaTrackSender} changes.
 * @param {PeerConnectionManager} peerConnectionManager
 * @param {Array<DataTrackSender>} dataTrackSenders
 * @param {Array<MediaTrackSender>} mediaTrackSenders
 * @returns {TrackSenderChanges} changes
 */
function getTrackSenderChanges(peerConnectionManager, dataTrackSenders, mediaTrackSenders) {
    return {
        data: getDataTrackSenderChanges(peerConnectionManager, dataTrackSenders),
        media: getMediaTrackSenderChanges(peerConnectionManager, mediaTrackSenders)
    };
}
/**
 * @interface MediaTrackSenderChanges
 * @property {Set<MediaTrackSender>} add
 * @property {Set<MediaTrackSender>} remove
 */
/**
 * Get the {@link MediaTrackSender} changes.
 * @param {PeerConnectionManager} peerConnectionManager
 * @param {Array<MediaTrackSender>} mediaTrackSenders
 * @returns {MediaTrackSenderChanges} changes
 */
function getMediaTrackSenderChanges(peerConnectionManager, mediaTrackSenders) {
    var mediaTrackSendersToAdd = util.difference(mediaTrackSenders, peerConnectionManager._mediaTrackSenders);
    var mediaTrackSendersToRemove = util.difference(peerConnectionManager._mediaTrackSenders, mediaTrackSenders);
    return {
        add: mediaTrackSendersToAdd,
        remove: mediaTrackSendersToRemove
    };
}
/**
 * This object maps RTCIceConnectionState and RTCPeerConnectionState values to a "rank".
 */
var toRank = {
    new: 0,
    checking: 1,
    connecting: 2,
    connected: 3,
    completed: 4,
    disconnected: -1,
    failed: -2,
    closed: -3
};
/**
 * This object maps "rank" back to RTCIceConnectionState or RTCPeerConnectionState values.
 */
var fromRank;
/**
 * `Object.keys` is not supported in older browsers, so we can't just
 * synchronously call it in this module; we need to defer invoking it until we
 * know we're in a modern environment (i.e., anything that supports WebRTC).
 * @returns {object} fromRank
 */
function createFromRank() {
    return Object.keys(toRank).reduce(function (fromRank, state) {
        var _a;
        return Object.assign(fromRank, (_a = {}, _a[toRank[state]] = state, _a));
    }, {});
}
/**
 * Summarize RTCIceConnectionStates or RTCPeerConnectionStates.
 * @param {Array<RTCIceConnectionState>|Array<RTCPeerConnectionState>} states
 * @returns {RTCIceConnectionState|RTCPeerConnectionState} summary
 */
function summarizeIceOrPeerConnectionStates(states) {
    if (!states.length) {
        return 'new';
    }
    fromRank = fromRank || createFromRank();
    return states.reduce(function (state1, state2) {
        return fromRank[Math.max(toRank[state1], toRank[state2])];
    });
}
/**
 * Update the {@link PeerConnectionManager}'s `iceConnectionState`, and emit an
 * "iceConnectionStateChanged" event, if necessary.
 * @param {PeerConnectionManager} pcm
 * @returns {void}
 */
function updateIceConnectionState(pcm) {
    pcm._lastIceConnectionState = pcm.iceConnectionState;
    pcm._iceConnectionState = summarizeIceOrPeerConnectionStates(__spreadArray([], __read(pcm._peerConnections.values())).map(function (pcv2) { return pcv2.iceConnectionState; }));
    if (pcm.iceConnectionState !== pcm._lastIceConnectionState) {
        pcm.emit('iceConnectionStateChanged');
    }
}
/**
 * Update the {@link PeerConnectionManager}'s `connectionState`, and emit a
 * "connectionStateChanged" event, if necessary.
 * @param {PeerConnectionManager} pcm
 * @returns {void}
 */
function updateConnectionState(pcm) {
    pcm._lastConnectionState = pcm.connectionState;
    pcm._connectionState = summarizeIceOrPeerConnectionStates(__spreadArray([], __read(pcm._peerConnections.values())).map(function (pcv2) { return pcv2.connectionState; }));
    if (pcm.connectionState !== pcm._lastConnectionState) {
        pcm.emit('connectionStateChanged');
    }
}
module.exports = PeerConnectionManager;

},{"../../media/track/sender":40,"../../queueingeventemitter":56,"../../util":133,"../../util/twilio-video-errors":148,"../../webaudio/audiocontext":154,"../../webrtc/util":171,"./peerconnection":78}],80:[function(require,module,exports){
/* eslint callback-return:0 */
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var MediaSignaling = require('./mediasignaling');
var messageId = 1;
var PublisherHintsSignaling = /** @class */ (function (_super) {
    __extends(PublisherHintsSignaling, _super);
    /**
     * Construct a {@link RenderHintsSignaling}.
     */
    function PublisherHintsSignaling(getReceiver, options) {
        var _this = _super.call(this, getReceiver, 'publisher_hints', options) || this;
        _this.on('ready', function (transport) {
            _this._log.debug('publisher_hints transport ready:', transport);
            transport.on('message', function (message) {
                _this._log.debug('Incoming: ', message);
                switch (message.type) {
                    case 'publisher_hints':
                        if (message.publisher && message.publisher.hints && message.publisher.id) {
                            _this._processPublisherHints(message.publisher.hints, message.publisher.id);
                        }
                        break;
                    default:
                        _this._log.warn('Unknown message type: ', message.type);
                        break;
                }
            });
        });
        return _this;
    }
    PublisherHintsSignaling.prototype.sendTrackReplaced = function (_a) {
        var trackSid = _a.trackSid;
        if (!this._transport) {
            return;
        }
        var payLoad = {
            type: 'client_reset',
            track: trackSid,
            id: messageId++
        };
        this._log.debug('Outgoing: ', payLoad);
        this._transport.publish(payLoad);
    };
    PublisherHintsSignaling.prototype.sendHintResponse = function (_a) {
        var id = _a.id, hints = _a.hints;
        if (!this._transport) {
            return;
        }
        var payLoad = {
            type: 'publisher_hints',
            id: id,
            hints: hints
        };
        this._log.debug('Outgoing: ', payLoad);
        this._transport.publish(payLoad);
    };
    /**
     * @private
     */
    PublisherHintsSignaling.prototype._processPublisherHints = function (hints, id) {
        try {
            this.emit('updated', hints, id);
        }
        catch (ex) {
            this._log.error('error processing hints:', ex);
        }
    };
    return PublisherHintsSignaling;
}(MediaSignaling));
module.exports = PublisherHintsSignaling;

},{"./mediasignaling":75}],81:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var RecordingSignaling = require('../recording');
/**
 * @extends RecordingSignaling
 */
var RecordingV2 = /** @class */ (function (_super) {
    __extends(RecordingV2, _super);
    /**
     * Construct a {@link RecordingV2}.
     */
    function RecordingV2() {
        var _this = _super.call(this) || this;
        Object.defineProperties(_this, {
            _revision: {
                value: 1,
                writable: true
            }
        });
        return _this;
    }
    /**
     * Compare the {@link RecordingV2} to a {@link RecordingV2#Representation}
     * of itself and perform any updates necessary.
     * @param {RecordingV2#Representation} recording
     * @returns {this}
     * @fires RecordingSignaling#updated
     */
    RecordingV2.prototype.update = function (recording) {
        if (recording.revision < this._revision) {
            return this;
        }
        this._revision = recording.revision;
        return this.enable(recording.is_recording);
    };
    return RecordingV2;
}(RecordingSignaling));
/**
 * The Room Signaling Protocol (RSP) representation of a {@link RecordingV2}
 * @typedef {object} RecordingV2#Representation
 * @property {boolean} enabled
 * @property {number} revision
 */
module.exports = RecordingV2;

},{"../recording":63}],82:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var RemoteParticipantSignaling = require('../remoteparticipant');
var RemoteTrackPublicationV2 = require('./remotetrackpublication');
/**
 * @extends RemoteParticipantSignaling
 * @property {?number} revision
 */
var RemoteParticipantV2 = /** @class */ (function (_super) {
    __extends(RemoteParticipantV2, _super);
    /**
     * Construct a {@link RemoteParticipantV2}.
     * @param {object} participantState
     * @param {function(Track.SID): boolean} getInitialTrackSwitchOffState
     * @param {function(Track.SID, Track.Priority): boolean} setPriority
     * @param {function(Track.SID, ClientRenderHint): Promise<void>} setRenderHint
     * @param {function(Track.SID): void} clearTrackHint
     * @param {object} [options]
     */
    function RemoteParticipantV2(participantState, getInitialTrackSwitchOffState, setPriority, setRenderHint, clearTrackHint, options) {
        var _this = _super.call(this, participantState.sid, participantState.identity) || this;
        options = Object.assign({
            RemoteTrackPublicationV2: RemoteTrackPublicationV2
        }, options);
        Object.defineProperties(_this, {
            _revision: {
                writable: true,
                value: null
            },
            _RemoteTrackPublicationV2: {
                value: options.RemoteTrackPublicationV2
            },
            _getInitialTrackSwitchOffState: {
                value: getInitialTrackSwitchOffState
            },
            updateSubscriberTrackPriority: {
                value: function (trackSid, priority) { return setPriority(trackSid, priority); }
            },
            updateTrackRenderHint: {
                value: function (trackSid, renderHint) { return setRenderHint(trackSid, renderHint); }
            },
            clearTrackHint: {
                value: function (trackSid) { return clearTrackHint(trackSid); }
            },
            revision: {
                enumerable: true,
                get: function () {
                    return this._revision;
                }
            }
        });
        return _this.update(participantState);
    }
    /**
     * @private
     */
    RemoteParticipantV2.prototype._getOrCreateTrack = function (trackState) {
        var RemoteTrackPublicationV2 = this._RemoteTrackPublicationV2;
        var track = this.tracks.get(trackState.sid);
        if (!track) {
            var isSwitchedOff = this._getInitialTrackSwitchOffState(trackState.sid);
            track = new RemoteTrackPublicationV2(trackState, isSwitchedOff);
            this.addTrack(track);
        }
        return track;
    };
    /**
     * Update the {@link RemoteParticipantV2} with the new state.
     * @param {object} participantState
     * @returns {this}
     */
    RemoteParticipantV2.prototype.update = function (participantState) {
        var _this = this;
        if (this.revision !== null && participantState.revision <= this.revision) {
            return this;
        }
        this._revision = participantState.revision;
        var tracksToKeep = new Set();
        participantState.tracks.forEach(function (trackState) {
            var track = _this._getOrCreateTrack(trackState);
            track.update(trackState);
            tracksToKeep.add(track);
        });
        this.tracks.forEach(function (track) {
            if (!tracksToKeep.has(track)) {
                _this.removeTrack(track);
            }
        });
        switch (participantState.state) {
            case 'disconnected':
                this.disconnect();
                break;
            case 'reconnecting':
                this.reconnecting();
                break;
            case 'connected':
                this.connect(this.sid, this.identity);
                break;
        }
        return this;
    };
    return RemoteParticipantV2;
}(RemoteParticipantSignaling));
module.exports = RemoteParticipantV2;

},{"../remoteparticipant":64,"./remotetrackpublication":83}],83:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var RemoteTrackPublicationSignaling = require('../remotetrackpublication');
/**
 * @extends RemoteTrackPublicationSignaling
 */
var RemoteTrackPublicationV2 = /** @class */ (function (_super) {
    __extends(RemoteTrackPublicationV2, _super);
    /**
     * Construct a {@link RemoteTrackPublicationV2}.
     * @param {RemoteTrackPublicationV2#Representation} track
     * @param {boolean} isSwitchedOff
     *
     */
    function RemoteTrackPublicationV2(track, isSwitchedOff) {
        return _super.call(this, track.sid, track.name, track.kind, track.enabled, track.priority, isSwitchedOff) || this;
    }
    /**
     * Compare the {@link RemoteTrackPublicationV2} to a
     * {@link RemoteTrackPublicationV2#Representation} of itself and perform any
     * updates necessary.
     * @param {RemoteTrackPublicationV2#Representation} track
     * @returns {this}
     * @fires TrackSignaling#updated
     */
    RemoteTrackPublicationV2.prototype.update = function (track) {
        this.enable(track.enabled);
        this.setPriority(track.priority);
        return this;
    };
    return RemoteTrackPublicationV2;
}(RemoteTrackPublicationSignaling));
/**
 * The Room Signaling Protocol (RSP) representation of a {@link RemoteTrackPublicationV2}.
 * @typedef {LocalTrackPublicationV2#Representation} RemoteTrackPublicationV2#Representation
 * @property {boolean} subscribed
 */
module.exports = RemoteTrackPublicationV2;

},{"../remotetrackpublication":65}],84:[function(require,module,exports){
/* eslint callback-return:0 */
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var MediaSignaling = require('./mediasignaling');
var Timeout = require('../../util/timeout');
var isDeepEqual = require('../../util').isDeepEqual;
var RENDER_HINT_RESPONSE_TIME_MS = 2000; // time to wait for server response (before resending all hints.)
var messageId = 1;
var RenderHintsSignaling = /** @class */ (function (_super) {
    __extends(RenderHintsSignaling, _super);
    /**
     * Construct a {@link RenderHintsSignaling}.
     */
    function RenderHintsSignaling(getReceiver, options) {
        var _this = _super.call(this, getReceiver, 'render_hints', options) || this;
        Object.defineProperties(_this, {
            _trackSidsToRenderHints: {
                value: new Map()
            },
            _responseTimer: {
                value: new Timeout(function () {
                    _this._sendAllHints();
                    // once timer fires, for next round double the delay.
                    _this._responseTimer.setDelay(_this._responseTimer.delay * 2);
                }, RENDER_HINT_RESPONSE_TIME_MS, false),
            }
        });
        _this.on('ready', function (transport) {
            transport.on('message', function (message) {
                _this._log.debug('Incoming: ', message);
                switch (message.type) {
                    case 'render_hints':
                        _this._processHintResults((message && message.subscriber && message.subscriber.hints) || []);
                        break;
                    default:
                        _this._log.warn('Unknown message type: ', message.type);
                        break;
                }
            });
            // NOTE(mpatwardhan): When transport is set (either 1st time of after vms failover)
            // resend all track states.
            _this._sendAllHints();
        });
        return _this;
    }
    RenderHintsSignaling.prototype._sendAllHints = function () {
        var _this = this;
        // to force sending all hints simply mark all tracks as dirty.
        Array.from(this._trackSidsToRenderHints.keys()).forEach(function (trackSid) {
            var trackState = _this._trackSidsToRenderHints.get(trackSid);
            if (trackState.renderDimensions) {
                trackState.isDimensionDirty = true;
            }
            if ('enabled' in trackState) {
                trackState.isEnabledDirty = true;
            }
        });
        this._sendHints();
    };
    RenderHintsSignaling.prototype._processHintResults = function (hintResults) {
        var _this = this;
        this._responseTimer.clear();
        this._responseTimer.setDelay(RENDER_HINT_RESPONSE_TIME_MS);
        hintResults.forEach(function (hintResult) {
            if (hintResult.result !== 'OK') {
                _this._log.debug('Server error processing hint:', hintResult);
            }
        });
        this._sendHints();
    };
    RenderHintsSignaling.prototype._sendHints = function () {
        var _this = this;
        if (!this._transport || this._responseTimer.isSet) {
            return;
        }
        var hints = [];
        Array.from(this._trackSidsToRenderHints.keys()).forEach(function (trackSid) {
            var trackState = _this._trackSidsToRenderHints.get(trackSid);
            if (trackState.isEnabledDirty || trackState.isDimensionDirty) {
                var mspHint = {
                    'track': trackSid,
                };
                if (trackState.isEnabledDirty) {
                    mspHint.enabled = trackState.enabled;
                    trackState.isEnabledDirty = false;
                }
                if (trackState.isDimensionDirty) {
                    // eslint-disable-next-line camelcase
                    mspHint.render_dimensions = trackState.renderDimensions;
                    trackState.isDimensionDirty = false;
                }
                hints.push(mspHint);
            }
        });
        if (hints.length > 0) {
            var payLoad = {
                type: 'render_hints',
                subscriber: {
                    id: messageId++,
                    hints: hints
                }
            };
            this._log.debug('Outgoing: ', payLoad);
            this._transport.publish(payLoad);
            this._responseTimer.start();
        }
    };
    /**
     * @param {Track.SID} trackSid
     * @param {ClientRenderHint} renderHint
     */
    RenderHintsSignaling.prototype.setTrackHint = function (trackSid, renderHint) {
        var trackState = this._trackSidsToRenderHints.get(trackSid) || { isEnabledDirty: false, isDimensionDirty: false };
        if ('enabled' in renderHint && trackState.enabled !== renderHint.enabled) {
            trackState.enabled = !!renderHint.enabled;
            trackState.isEnabledDirty = true;
        }
        if (renderHint.renderDimensions && !isDeepEqual(renderHint.renderDimensions, trackState.renderDimensions)) {
            // eslint-disable-next-line camelcase
            trackState.renderDimensions = renderHint.renderDimensions;
            trackState.isDimensionDirty = true;
        }
        this._trackSidsToRenderHints.set(trackSid, trackState);
        this._sendHints();
    };
    /**
     * must be called when track is unsubscribed.
     * @param {Track.SID} trackSid
     */
    RenderHintsSignaling.prototype.clearTrackHint = function (trackSid) {
        this._trackSidsToRenderHints.delete(trackSid);
    };
    return RenderHintsSignaling;
}(MediaSignaling));
module.exports = RenderHintsSignaling;

},{"../../util":133,"../../util/timeout":147,"./mediasignaling":75}],85:[function(require,module,exports){
/* eslint-disable no-console */
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var DominantSpeakerSignaling = require('./dominantspeakersignaling');
var NetworkQualityMonitor = require('./networkqualitymonitor');
var NetworkQualitySignaling = require('./networkqualitysignaling');
var RecordingV2 = require('./recording');
var RoomSignaling = require('../room');
var RemoteParticipantV2 = require('./remoteparticipant');
var StatsReport = require('../../stats/statsreport');
var TrackPrioritySignaling = require('./trackprioritysignaling');
var TrackSwitchOffSignaling = require('./trackswitchoffsignaling');
var RenderHintsSignaling = require('./renderhintssignaling');
var PublisherHintsSignaling = require('./publisherhintsignaling.js');
var _a = require('../../util'), DEFAULT_SESSION_TIMEOUT_SEC = _a.constants.DEFAULT_SESSION_TIMEOUT_SEC, createBandwidthProfilePayload = _a.createBandwidthProfilePayload, defer = _a.defer, difference = _a.difference, filterObject = _a.filterObject, flatMap = _a.flatMap, oncePerTick = _a.oncePerTick;
var MovingAverageDelta = require('../../util/movingaveragedelta');
var createTwilioError = require('../../util/twilio-video-errors').createTwilioError;
var STATS_PUBLISH_INTERVAL_MS = 10000;
/**
 * @extends RoomSignaling
 */
var RoomV2 = /** @class */ (function (_super) {
    __extends(RoomV2, _super);
    function RoomV2(localParticipant, initialState, transport, peerConnectionManager, options) {
        var _this = this;
        initialState.options = Object.assign({
            session_timeout: DEFAULT_SESSION_TIMEOUT_SEC
        }, initialState.options);
        options = Object.assign({
            DominantSpeakerSignaling: DominantSpeakerSignaling,
            NetworkQualityMonitor: NetworkQualityMonitor,
            NetworkQualitySignaling: NetworkQualitySignaling,
            RecordingSignaling: RecordingV2,
            RemoteParticipantV2: RemoteParticipantV2,
            TrackPrioritySignaling: TrackPrioritySignaling,
            TrackSwitchOffSignaling: TrackSwitchOffSignaling,
            bandwidthProfile: null,
            sessionTimeout: initialState.options.session_timeout * 1000,
            statsPublishIntervalMs: STATS_PUBLISH_INTERVAL_MS
        }, options);
        localParticipant.setBandwidthProfile(options.bandwidthProfile);
        var _a = initialState.options, signalingRegion = _a.signaling_region, _b = _a.audio_processors, audioProcessors = _b === void 0 ? [] : _b;
        localParticipant.setSignalingRegion(signalingRegion);
        if (audioProcessors.includes('krisp')) {
            // Note(mpatwardhan): we add rnnoise as allowed_processor to enable testing our pipeline e2e.
            audioProcessors.push('rnnoise');
        }
        localParticipant.setAudioProcessors(audioProcessors);
        peerConnectionManager.setIceReconnectTimeout(options.sessionTimeout);
        _this = _super.call(this, localParticipant, initialState.sid, initialState.name, options) || this;
        var getTrackReceiver = function (id) { return _this._getTrackReceiver(id); };
        var log = _this._log;
        Object.defineProperties(_this, {
            _disconnectedParticipantRevisions: {
                value: new Map()
            },
            _NetworkQualityMonitor: {
                value: options.NetworkQualityMonitor
            },
            _lastBandwidthProfileRevision: {
                value: localParticipant.bandwidthProfileRevision,
                writable: true
            },
            _mediaStatesWarningsRevision: {
                value: 0,
                writable: true
            },
            _networkQualityMonitor: {
                value: null,
                writable: true
            },
            _networkQualityConfiguration: {
                value: localParticipant.networkQualityConfiguration
            },
            _peerConnectionManager: {
                value: peerConnectionManager
            },
            _published: {
                value: new Map()
            },
            _publishedRevision: {
                value: 0,
                writable: true
            },
            _RemoteParticipantV2: {
                value: options.RemoteParticipantV2
            },
            _subscribed: {
                value: new Map()
            },
            _subscribedRevision: {
                value: 0,
                writable: true
            },
            _subscriptionFailures: {
                value: new Map()
            },
            _dominantSpeakerSignaling: {
                value: new options.DominantSpeakerSignaling(getTrackReceiver, { log: log })
            },
            _networkQualitySignaling: {
                value: new options.NetworkQualitySignaling(getTrackReceiver, localParticipant.networkQualityConfiguration, { log: log })
            },
            _renderHintsSignaling: {
                value: new RenderHintsSignaling(getTrackReceiver, { log: log }),
            },
            _publisherHintsSignaling: {
                value: new PublisherHintsSignaling(getTrackReceiver, { log: log }),
            },
            _trackPrioritySignaling: {
                value: new options.TrackPrioritySignaling(getTrackReceiver, { log: log }),
            },
            _trackSwitchOffSignaling: {
                value: new options.TrackSwitchOffSignaling(getTrackReceiver, { log: log }),
            },
            _pendingSwitchOffStates: {
                value: new Map()
            },
            _transport: {
                value: transport
            },
            _trackReceiverDeferreds: {
                value: new Map()
            },
            mediaRegion: {
                enumerable: true,
                value: initialState.options.media_region || null
            }
        });
        _this._initTrackSwitchOffSignaling();
        _this._initDominantSpeakerSignaling();
        _this._initNetworkQualityMonitorSignaling();
        _this._initPublisherHintSignaling();
        handleLocalParticipantEvents(_this, localParticipant);
        handlePeerConnectionEvents(_this, peerConnectionManager);
        handleTransportEvents(_this, transport);
        periodicallyPublishStats(_this, transport, options.statsPublishIntervalMs);
        _this._update(initialState);
        // NOTE(mpatwardhan) after initial state we know if publisher_hints are enabled or not
        // if they are not enabled. we need to undo simulcast that was enabled with initial offer.
        _this._peerConnectionManager.setEffectiveAdaptiveSimulcast(_this._publisherHintsSignaling.isSetup);
        return _this;
    }
    Object.defineProperty(RoomV2.prototype, "connectionState", {
        /**
         * The PeerConnection state.
         * @property {RTCPeerConnectionState}
         */
        get: function () {
            return this._peerConnectionManager.connectionState;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(RoomV2.prototype, "signalingConnectionState", {
        /**
         * The Signaling Connection State.
         * @property {string} - "connected", "reconnecting", "disconnected"
         */
        get: function () {
            return this._transport.state === 'syncing'
                ? 'reconnecting'
                : this._transport.state;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(RoomV2.prototype, "iceConnectionState", {
        /**
         * The Ice Connection State.
         * @property {RTCIceConnectionState}
         */
        get: function () {
            return this._peerConnectionManager.iceConnectionState;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * @private
     */
    RoomV2.prototype._deleteTrackReceiverDeferred = function (id) {
        return this._trackReceiverDeferreds.delete(id);
    };
    /**
     * @private
     */
    RoomV2.prototype._getOrCreateTrackReceiverDeferred = function (id) {
        var deferred = this._trackReceiverDeferreds.get(id) || defer();
        var trackReceivers = this._peerConnectionManager.getTrackReceivers();
        // NOTE(mmalavalli): In Firefox, there can be instances where a MediaStreamTrack
        // for the given Track ID already exists, for example, when a Track is removed
        // and added back. If that is the case, then we should resolve 'deferred'.
        var trackReceiver = trackReceivers.find(function (trackReceiver) { return trackReceiver.id === id && trackReceiver.readyState !== 'ended'; });
        if (trackReceiver) {
            deferred.resolve(trackReceiver);
        }
        else {
            // NOTE(mmalavalli): Only add the 'deferred' to the map if it's not
            // resolved. This will prevent old copies of the MediaStreamTrack from
            // being used when the remote peer removes and re-adds a MediaStreamTrack.
            this._trackReceiverDeferreds.set(id, deferred);
        }
        return deferred;
    };
    /**
     * @private
     */
    RoomV2.prototype._addTrackReceiver = function (trackReceiver) {
        var deferred = this._getOrCreateTrackReceiverDeferred(trackReceiver.id);
        deferred.resolve(trackReceiver);
        return this;
    };
    /**
     * @private
     */
    RoomV2.prototype._disconnect = function (error) {
        var didDisconnect = _super.prototype._disconnect.call(this, error);
        if (didDisconnect) {
            this._teardownNetworkQualityMonitor();
            this._transport.disconnect();
            this._peerConnectionManager.close();
        }
        this.localParticipant.tracks.forEach(function (track) {
            track.publishFailed(error || new Error('LocalParticipant disconnected'));
        });
        return didDisconnect;
    };
    /**
     * @private
     */
    RoomV2.prototype._getTrackReceiver = function (id) {
        var _this = this;
        return this._getOrCreateTrackReceiverDeferred(id).promise.then(function (trackReceiver) {
            _this._deleteTrackReceiverDeferred(id);
            return trackReceiver;
        });
    };
    /**
     * @private
     */
    RoomV2.prototype._getInitialTrackSwitchOffState = function (trackSid) {
        var initiallySwitchedOff = this._pendingSwitchOffStates.get(trackSid) || false;
        this._pendingSwitchOffStates.delete(trackSid);
        if (initiallySwitchedOff) {
            this._log.warn("[" + trackSid + "] was initially switched off! ");
        }
        return initiallySwitchedOff;
    };
    /**
     * @private
     */
    RoomV2.prototype._getTrackSidsToTrackSignalings = function () {
        var trackSidsToTrackSignalings = flatMap(this.participants, function (participant) { return Array.from(participant.tracks); });
        return new Map(trackSidsToTrackSignalings);
    };
    /**
     * @private
     */
    RoomV2.prototype._getOrCreateRemoteParticipant = function (participantState) {
        var _this = this;
        var RemoteParticipantV2 = this._RemoteParticipantV2;
        var participant = this.participants.get(participantState.sid);
        var self = this;
        if (!participant) {
            participant = new RemoteParticipantV2(participantState, function (trackSid) { return _this._getInitialTrackSwitchOffState(trackSid); }, function (trackSid, priority) { return _this._trackPrioritySignaling.sendTrackPriorityUpdate(trackSid, 'subscribe', priority); }, function (trackSid, hint) { return _this._renderHintsSignaling.setTrackHint(trackSid, hint); }, function (trackSid) { return _this._renderHintsSignaling.clearTrackHint(trackSid); });
            participant.on('stateChanged', function stateChanged(state) {
                if (state === 'disconnected') {
                    participant.removeListener('stateChanged', stateChanged);
                    self.participants.delete(participant.sid);
                    self._disconnectedParticipantRevisions.set(participant.sid, participant.revision);
                }
            });
            this.connectParticipant(participant);
        }
        return participant;
    };
    /**
     * @private
     */
    RoomV2.prototype._getState = function () {
        return {
            participant: this.localParticipant.getState()
        };
    };
    /**
     * @private
     */
    RoomV2.prototype._maybeAddBandwidthProfile = function (update) {
        var _a = this.localParticipant, bandwidthProfile = _a.bandwidthProfile, bandwidthProfileRevision = _a.bandwidthProfileRevision;
        if (bandwidthProfile && this._lastBandwidthProfileRevision < bandwidthProfileRevision) {
            this._lastBandwidthProfileRevision = bandwidthProfileRevision;
            return Object.assign({
                bandwidth_profile: createBandwidthProfilePayload(bandwidthProfile)
            }, update);
        }
        return update;
    };
    /**
     * @private
     */
    RoomV2.prototype._publishNewLocalParticipantState = function () {
        this._transport.publish(this._maybeAddBandwidthProfile(this._getState()));
    };
    /**
     * @private
     */
    RoomV2.prototype._publishPeerConnectionState = function (peerConnectionState) {
        /* eslint camelcase:0 */
        this._transport.publish(Object.assign({
            peer_connections: [peerConnectionState]
        }, this._getState()));
    };
    /**
     * @private
     */
    RoomV2.prototype._update = function (roomState) {
        var _this = this;
        if (roomState.subscribed && roomState.subscribed.revision > this._subscribedRevision) {
            this._subscribedRevision = roomState.subscribed.revision;
            roomState.subscribed.tracks.forEach(function (trackState) {
                if (trackState.id) {
                    _this._subscriptionFailures.delete(trackState.sid);
                    _this._subscribed.set(trackState.sid, trackState.id);
                }
                else if (trackState.error && !_this._subscriptionFailures.has(trackState.sid)) {
                    _this._subscriptionFailures.set(trackState.sid, trackState.error);
                }
            });
            var subscribedTrackSids_1 = new Set(roomState.subscribed.tracks
                .filter(function (trackState) { return !!trackState.id; })
                .map(function (trackState) { return trackState.sid; }));
            this._subscribed.forEach(function (trackId, trackSid) {
                if (!subscribedTrackSids_1.has(trackSid)) {
                    _this._subscribed.delete(trackSid);
                }
            });
        }
        var participantsToKeep = new Set();
        // eslint-disable-next-line no-warning-comments
        // TODO(mroberts): Remove me once the Server is fixed.
        (roomState.participants || []).forEach(function (participantState) {
            if (participantState.sid === _this.localParticipant.sid) {
                return;
            }
            // NOTE(mmalavalli): If the incoming revision for a disconnected Participant is less than or
            // equal to the revision when it was disconnected, then the state is old and can be ignored.
            // Otherwise, the Participant was most likely disconnected in a Large Group Room when it
            // stopped publishing media, and hence needs to be re-added.
            var disconnectedParticipantRevision = _this._disconnectedParticipantRevisions.get(participantState.sid);
            if (disconnectedParticipantRevision && participantState.revision <= disconnectedParticipantRevision) {
                return;
            }
            if (disconnectedParticipantRevision) {
                _this._disconnectedParticipantRevisions.delete(participantState.sid);
            }
            var participant = _this._getOrCreateRemoteParticipant(participantState);
            participant.update(participantState);
            participantsToKeep.add(participant);
        });
        if (roomState.type === 'synced') {
            this.participants.forEach(function (participant) {
                if (!participantsToKeep.has(participant)) {
                    participant.disconnect();
                }
            });
        }
        handleSubscriptions(this);
        // eslint-disable-next-line no-warning-comments
        // TODO(mroberts): Remove me once the Server is fixed.
        /* eslint camelcase:0 */
        if (roomState.peer_connections) {
            this._peerConnectionManager.update(roomState.peer_connections, roomState.type === 'synced');
        }
        if (roomState.recording) {
            this.recording.update(roomState.recording);
        }
        if (roomState.published && roomState.published.revision > this._publishedRevision) {
            this._publishedRevision = roomState.published.revision;
            roomState.published.tracks.forEach(function (track) {
                if (track.sid) {
                    _this._published.set(track.id, track.sid);
                }
            });
            this.localParticipant.update(roomState.published);
        }
        if (roomState.participant) {
            this.localParticipant.connect(roomState.participant.sid, roomState.participant.identity);
        }
        [
            this._dominantSpeakerSignaling,
            this._networkQualitySignaling,
            this._trackPrioritySignaling,
            this._trackSwitchOffSignaling,
            this._renderHintsSignaling,
            this._publisherHintsSignaling
        ].forEach(function (mediaSignaling) {
            var channel = mediaSignaling.channel;
            if (!mediaSignaling.isSetup
                && roomState.media_signaling
                && roomState.media_signaling[channel]
                && roomState.media_signaling[channel].transport
                && roomState.media_signaling[channel].transport.type === 'data-channel') {
                mediaSignaling.setup(roomState.media_signaling[channel].transport.label);
            }
        });
        if (roomState.type === 'warning' && roomState.states &&
            roomState.states.revision > this._mediaStatesWarningsRevision) {
            this._mediaStatesWarningsRevision = roomState.states.revision;
            this.localParticipant.updateMediaStates(roomState.states);
        }
        return this;
    };
    RoomV2.prototype._initPublisherHintSignaling = function () {
        var _this = this;
        this._publisherHintsSignaling.on('updated', function (hints, id) {
            Promise.all(hints.map(function (hint) {
                return _this.localParticipant.setPublisherHint(hint.track, hint.encodings).then(function (result) {
                    return { track: hint.track, result: result };
                });
            })).then(function (hintResponses) {
                _this._publisherHintsSignaling.sendHintResponse({ id: id, hints: hintResponses });
            });
        });
        var handleReplaced = function (track) {
            if (track.kind === 'video') {
                track.trackTransceiver.on('replaced', function () {
                    _this._publisherHintsSignaling.sendTrackReplaced({ trackSid: track.sid });
                });
            }
        };
        // hook up for any existing and new tracks getting replaced.
        Array.from(this.localParticipant.tracks.values()).forEach(function (track) { return handleReplaced(track); });
        this.localParticipant.on('trackAdded', function (track) { return handleReplaced(track); });
    };
    RoomV2.prototype._initTrackSwitchOffSignaling = function () {
        var _this = this;
        this._trackSwitchOffSignaling.on('updated', function (tracksOff, tracksOn) {
            try {
                _this._log.debug('received trackSwitch: ', { tracksOn: tracksOn, tracksOff: tracksOff });
                var trackUpdates_1 = new Map();
                tracksOn.forEach(function (trackSid) { return trackUpdates_1.set(trackSid, true); });
                tracksOff.forEach(function (trackSid) {
                    if (trackUpdates_1.get(trackSid)) {
                        // NOTE(mpatwardhan): This means that VIDEO-3762 has been reproduced.
                        _this._log.warn(trackSid + " is DUPLICATED in both tracksOff and tracksOn list");
                    }
                    trackUpdates_1.set(trackSid, false);
                });
                _this.participants.forEach(function (participant) {
                    participant.tracks.forEach(function (track) {
                        var isOn = trackUpdates_1.get(track.sid);
                        if (typeof isOn !== 'undefined') {
                            track.setSwitchedOff(!isOn);
                            trackUpdates_1.delete(track.sid);
                        }
                    });
                });
                // NOTE(mpatwardhan): Cache any notification about the tracks that we do not yet know about.
                trackUpdates_1.forEach(function (isOn, trackSid) { return _this._pendingSwitchOffStates.set(trackSid, !isOn); });
            }
            catch (ex) {
                _this._log.error('error processing track switch off:', ex);
            }
        });
    };
    RoomV2.prototype._initDominantSpeakerSignaling = function () {
        var _this = this;
        this._dominantSpeakerSignaling.on('updated', function () { return _this.setDominantSpeaker(_this._dominantSpeakerSignaling.loudestParticipantSid); });
    };
    RoomV2.prototype._initNetworkQualityMonitorSignaling = function () {
        var _this = this;
        this._networkQualitySignaling.on('ready', function () {
            var networkQualityMonitor = new _this._NetworkQualityMonitor(_this._peerConnectionManager, _this._networkQualitySignaling);
            _this._networkQualityMonitor = networkQualityMonitor;
            networkQualityMonitor.on('updated', function () {
                if (_this.iceConnectionState === 'failed') {
                    return;
                }
                _this.localParticipant.setNetworkQualityLevel(networkQualityMonitor.level, networkQualityMonitor.levels);
                _this.participants.forEach(function (participant) {
                    var levels = networkQualityMonitor.remoteLevels.get(participant.sid);
                    if (levels) {
                        participant.setNetworkQualityLevel(levels.level, levels);
                    }
                });
            });
            networkQualityMonitor.start();
        });
        this._networkQualitySignaling.on('teardown', function () { return _this._teardownNetworkQualityMonitor(); });
    };
    RoomV2.prototype._teardownNetworkQualityMonitor = function () {
        if (this._networkQualityMonitor) {
            this._networkQualityMonitor.stop();
            this._networkQualityMonitor = null;
        }
    };
    /**
     * Get the {@link RoomV2}'s media statistics.
     * @returns {Promise.<Map<PeerConnectionV2#id, StandardizedStatsResponse>>}
     */
    RoomV2.prototype.getStats = function () {
        var _this = this;
        return this._peerConnectionManager.getStats().then(function (responses) {
            return new Map(Array.from(responses).map(function (_a) {
                var _b = __read(_a, 2), id = _b[0], response = _b[1];
                return [id, Object.assign({}, response, {
                        localAudioTrackStats: filterAndAddLocalTrackSids(_this, response.localAudioTrackStats),
                        localVideoTrackStats: filterAndAddLocalTrackSids(_this, response.localVideoTrackStats),
                        remoteAudioTrackStats: filterAndAddRemoteTrackSids(_this, response.remoteAudioTrackStats),
                        remoteVideoTrackStats: filterAndAddRemoteTrackSids(_this, response.remoteVideoTrackStats)
                    })];
            }));
        });
    };
    return RoomV2;
}(RoomSignaling));
/**
 * Filter out {@link TrackStats} that aren't in the collection while also
 * stamping their Track SIDs.
 * @param {Map<ID, SID>} idToSid
 * @param {Array<TrackStats>} trackStats
 * @returns {Array<TrackStats>}
 */
function filterAndAddTrackSids(idToSid, trackStats) {
    return trackStats.reduce(function (trackStats, trackStat) {
        var trackSid = idToSid.get(trackStat.trackId);
        return trackSid
            ? [Object.assign({}, trackStat, { trackSid: trackSid })].concat(trackStats)
            : trackStats;
    }, []);
}
/**
 * Filter out {@link LocalTrackStats} that aren't currently published while also
 * stamping their Track SIDs.
 * @param {RoomV2} roomV2
 * @param {Array<LocalTrackStats>} localTrackStats
 * @returns {Array<LocalTrackStats>}
 */
function filterAndAddLocalTrackSids(roomV2, localTrackStats) {
    return filterAndAddTrackSids(roomV2._published, localTrackStats);
}
/**
 * Filter out {@link RemoteTrackStats} that aren't currently subscribed while
 * also stamping their Track SIDs.
 * @param {RoomV2} roomV2
 * @param {Array<RemoteTrackStats>} remoteTrackStats
 * @returns {Array<RemoteTrackStats>}
 */
function filterAndAddRemoteTrackSids(roomV2, remoteTrackStats) {
    var idToSid = new Map(Array.from(roomV2._subscribed.entries()).map(function (_a) {
        var _b = __read(_a, 2), sid = _b[0], id = _b[1];
        return [id, sid];
    }));
    return filterAndAddTrackSids(idToSid, remoteTrackStats);
}
/**
 * @typedef {object} RoomV2#Representation
 * @property {string} name
 * @property {LocalParticipantV2#Representation} participant
 * @property {?Array<RemoteParticipantV2#Representation>} participants
 * @property {?Array<PeerConnectionV2#Representation>} peer_connections
 * @property {?RecordingV2#Representation} recording
 * @property {string} sid
 */
function handleLocalParticipantEvents(roomV2, localParticipant) {
    var localParticipantUpdated = oncePerTick(function () {
        roomV2._publishNewLocalParticipantState();
    });
    var renegotiate = oncePerTick(function () {
        var trackSenders = flatMap(localParticipant.tracks, function (trackV2) { return trackV2.trackTransceiver; });
        roomV2._peerConnectionManager.setTrackSenders(trackSenders);
    });
    localParticipant.on('trackAdded', renegotiate);
    localParticipant.on('trackRemoved', renegotiate);
    localParticipant.on('updated', localParticipantUpdated);
    roomV2.on('stateChanged', function stateChanged(state) {
        if (state === 'disconnected') {
            localParticipant.removeListener('trackAdded', renegotiate);
            localParticipant.removeListener('trackRemoved', renegotiate);
            localParticipant.removeListener('updated', localParticipantUpdated);
            roomV2.removeListener('stateChanged', stateChanged);
            localParticipant.disconnect();
        }
    });
    roomV2.on('signalingConnectionStateChanged', function () {
        var localParticipant = roomV2.localParticipant, signalingConnectionState = roomV2.signalingConnectionState;
        var identity = localParticipant.identity, sid = localParticipant.sid;
        switch (signalingConnectionState) {
            case 'connected':
                localParticipant.connect(sid, identity);
                break;
            case 'reconnecting':
                localParticipant.reconnecting();
                break;
        }
    });
}
function handlePeerConnectionEvents(roomV2, peerConnectionManager) {
    peerConnectionManager.on('description', function onDescription(description) {
        roomV2._publishPeerConnectionState(description);
    });
    peerConnectionManager.dequeue('description');
    peerConnectionManager.on('candidates', function onCandidates(candidates) {
        roomV2._publishPeerConnectionState(candidates);
    });
    peerConnectionManager.dequeue('candidates');
    peerConnectionManager.on('trackAdded', roomV2._addTrackReceiver.bind(roomV2));
    peerConnectionManager.dequeue('trackAdded');
    peerConnectionManager.getTrackReceivers().forEach(roomV2._addTrackReceiver, roomV2);
    peerConnectionManager.on('connectionStateChanged', function () {
        roomV2.emit('connectionStateChanged');
    });
    peerConnectionManager.on('iceConnectionStateChanged', function () {
        roomV2.emit('iceConnectionStateChanged');
        if (roomV2.iceConnectionState === 'failed') {
            if (roomV2.localParticipant.networkQualityLevel !== null) {
                roomV2.localParticipant.setNetworkQualityLevel(0);
            }
            roomV2.participants.forEach(function (participant) {
                if (participant.networkQualityLevel !== null) {
                    participant.setNetworkQualityLevel(0);
                }
            });
        }
    });
}
function handleTransportEvents(roomV2, transport) {
    transport.on('message', roomV2._update.bind(roomV2));
    transport.on('stateChanged', function stateChanged(state, error) {
        if (state === 'disconnected') {
            if (roomV2.state !== 'disconnected') {
                roomV2._disconnect(error);
            }
            transport.removeListener('stateChanged', stateChanged);
        }
        roomV2.emit('signalingConnectionStateChanged');
    });
}
/**
 * Periodically publish {@link StatsReport}s.
 * @private
 * @param {RoomV2} roomV2
 * @param {Transport} transport
 * @param {Number} intervalMs
 */
function periodicallyPublishStats(roomV2, transport, intervalMs) {
    var movingAverageDeltas = new Map();
    var oddPublishCount = false;
    var interval = setInterval(function () {
        roomV2.getStats().then(function (stats) {
            oddPublishCount = !oddPublishCount;
            stats.forEach(function (response, id) {
                // NOTE(mmalavalli): A StatsReport is used to publish a "stats-report"
                // event instead of using StandardizedStatsResponse directly because
                // StatsReport will add zeros to properties that do not exist.
                var report = new StatsReport(id, response, true /* prepareForInsights */);
                // NOTE(mmalavalli): Since A/V sync metrics are not part of the StatsReport class,
                // we add them to the insights payload here.
                transport.publishEvent('quality', 'stats-report', 'info', {
                    audioTrackStats: report.remoteAudioTrackStats.map(function (trackStat, i) {
                        return addAVSyncMetricsToRemoteTrackStats(trackStat, response.remoteAudioTrackStats[i], movingAverageDeltas);
                    }),
                    localAudioTrackStats: report.localAudioTrackStats.map(function (trackStat, i) {
                        return addAVSyncMetricsToLocalTrackStats(trackStat, response.localAudioTrackStats[i], movingAverageDeltas);
                    }),
                    localVideoTrackStats: report.localVideoTrackStats.map(function (trackStat, i) {
                        return addAVSyncMetricsToLocalTrackStats(trackStat, response.localVideoTrackStats[i], movingAverageDeltas);
                    }),
                    peerConnectionId: report.peerConnectionId,
                    videoTrackStats: report.remoteVideoTrackStats.map(function (trackStat, i) {
                        return addAVSyncMetricsToRemoteTrackStats(trackStat, response.remoteVideoTrackStats[i], movingAverageDeltas);
                    }),
                });
                // NOTE(mmalavalli): Clean up entries for Tracks that are no longer published or subscribed to.
                var keys = flatMap([
                    'localAudioTrackStats',
                    'localVideoTrackStats',
                    'remoteAudioTrackStats',
                    'remoteVideoTrackStats'
                ], function (prop) { return report[prop].map(function (_a) {
                    var ssrc = _a.ssrc, trackSid = _a.trackSid;
                    return trackSid + "+" + ssrc;
                }); });
                var movingAverageDeltaKeysToBeRemoved = difference(Array.from(movingAverageDeltas.keys()), keys);
                movingAverageDeltaKeysToBeRemoved.forEach(function (key) { return movingAverageDeltas.delete(key); });
                if (oddPublishCount) {
                    // NOTE(mmalavalli): null properties of the "active-ice-candidate-pair"
                    // payload are assigned default values until the Insights gateway
                    // accepts null values.
                    var activeIceCandidatePair = replaceNullsWithDefaults(response.activeIceCandidatePair, report.peerConnectionId);
                    transport.publishEvent('quality', 'active-ice-candidate-pair', 'info', activeIceCandidatePair);
                }
            });
        }, function () {
            // Do nothing.
        });
    }, intervalMs);
    roomV2.on('stateChanged', function onStateChanged(state) {
        if (state === 'disconnected') {
            clearInterval(interval);
            roomV2.removeListener('stateChanged', onStateChanged);
        }
    });
}
function handleSubscriptions(room) {
    var trackSidsToTrackSignalings = room._getTrackSidsToTrackSignalings();
    room._subscriptionFailures.forEach(function (error, trackSid) {
        var trackSignaling = trackSidsToTrackSignalings.get(trackSid);
        if (trackSignaling) {
            room._subscriptionFailures.delete(trackSid);
            trackSignaling.subscribeFailed(createTwilioError(error.code, error.message));
        }
    });
    trackSidsToTrackSignalings.forEach(function (trackSignaling) {
        var trackId = room._subscribed.get(trackSignaling.sid);
        if (!trackId || (trackSignaling.isSubscribed && trackSignaling.trackTransceiver.id !== trackId)) {
            trackSignaling.setTrackTransceiver(null);
        }
        if (trackId) {
            room._getTrackReceiver(trackId).then(function (trackReceiver) { return trackSignaling.setTrackTransceiver(trackReceiver); });
        }
    });
}
/**
 * NOTE(mmalavalli): Since A/V sync metrics are not part of the public StatsReport class, we add them
 * only for reporting purposes.
 * @private
 */
function addAVSyncMetricsToLocalTrackStats(trackStats, trackResponse, movingAverageDeltas) {
    var framesEncoded = trackResponse.framesEncoded, packetsSent = trackResponse.packetsSent, totalEncodeTime = trackResponse.totalEncodeTime, totalPacketSendDelay = trackResponse.totalPacketSendDelay;
    var augmentedTrackStats = Object.assign({}, trackStats);
    var key = trackStats.trackSid + "+" + trackStats.ssrc;
    var trackMovingAverageDeltas = movingAverageDeltas.get(key) || new Map();
    if (typeof totalEncodeTime === 'number' && typeof framesEncoded === 'number') {
        var trackAvgEncodeDelayMovingAverageDelta = trackMovingAverageDeltas.get('avgEncodeDelay')
            || new MovingAverageDelta();
        trackAvgEncodeDelayMovingAverageDelta.putSample(totalEncodeTime * 1000, framesEncoded);
        augmentedTrackStats.avgEncodeDelay = Math.round(trackAvgEncodeDelayMovingAverageDelta.get());
        trackMovingAverageDeltas.set('avgEncodeDelay', trackAvgEncodeDelayMovingAverageDelta);
    }
    if (typeof totalPacketSendDelay === 'number' && typeof packetsSent === 'number') {
        var trackAvgPacketSendDelayMovingAverageDelta = trackMovingAverageDeltas.get('avgPacketSendDelay')
            || new MovingAverageDelta();
        trackAvgPacketSendDelayMovingAverageDelta.putSample(totalPacketSendDelay * 1000, packetsSent);
        augmentedTrackStats.avgPacketSendDelay = Math.round(trackAvgPacketSendDelayMovingAverageDelta.get());
        trackMovingAverageDeltas.set('avgPacketSendDelay', trackAvgPacketSendDelayMovingAverageDelta);
    }
    movingAverageDeltas.set(key, trackMovingAverageDeltas);
    return augmentedTrackStats;
}
/**
 * NOTE(mmalavalli): Since A/V sync metrics are not part of the public StatsReport class, we add them
 * only for reporting purposes.
 * @private
 */
function addAVSyncMetricsToRemoteTrackStats(trackStats, trackResponse, movingAverageDeltas) {
    var estimatedPlayoutTimestamp = trackResponse.estimatedPlayoutTimestamp, framesDecoded = trackResponse.framesDecoded, jitterBufferDelay = trackResponse.jitterBufferDelay, jitterBufferEmittedCount = trackResponse.jitterBufferEmittedCount, totalDecodeTime = trackResponse.totalDecodeTime;
    var augmentedTrackStats = Object.assign({}, trackStats);
    var key = trackStats.trackSid + "+" + trackStats.ssrc;
    var trackMovingAverageDeltas = movingAverageDeltas.get(key) || new Map();
    if (typeof estimatedPlayoutTimestamp === 'number') {
        augmentedTrackStats.estimatedPlayoutTimestamp = estimatedPlayoutTimestamp;
    }
    if (typeof framesDecoded === 'number' && typeof totalDecodeTime === 'number') {
        var trackAvgDecodeDelayMovingAverageDelta = trackMovingAverageDeltas.get('avgDecodeDelay')
            || new MovingAverageDelta();
        trackAvgDecodeDelayMovingAverageDelta.putSample(totalDecodeTime * 1000, framesDecoded);
        augmentedTrackStats.avgDecodeDelay = Math.round(trackAvgDecodeDelayMovingAverageDelta.get());
        trackMovingAverageDeltas.set('avgDecodeDelay', trackAvgDecodeDelayMovingAverageDelta);
    }
    if (typeof jitterBufferDelay === 'number' && typeof jitterBufferEmittedCount === 'number') {
        var trackAvgJitterBufferDelayMovingAverageDelta = trackMovingAverageDeltas.get('avgJitterBufferDelay')
            || new MovingAverageDelta();
        trackAvgJitterBufferDelayMovingAverageDelta.putSample(jitterBufferDelay * 1000, jitterBufferEmittedCount);
        augmentedTrackStats.avgJitterBufferDelay = Math.round(trackAvgJitterBufferDelayMovingAverageDelta.get());
        trackMovingAverageDeltas.set('avgJitterBufferDelay', trackAvgJitterBufferDelayMovingAverageDelta);
    }
    movingAverageDeltas.set(key, trackMovingAverageDeltas);
    return augmentedTrackStats;
}
function replaceNullsWithDefaults(activeIceCandidatePair, peerConnectionId) {
    activeIceCandidatePair = Object.assign({
        availableIncomingBitrate: 0,
        availableOutgoingBitrate: 0,
        bytesReceived: 0,
        bytesSent: 0,
        consentRequestsSent: 0,
        currentRoundTripTime: 0,
        lastPacketReceivedTimestamp: 0,
        lastPacketSentTimestamp: 0,
        nominated: false,
        peerConnectionId: peerConnectionId,
        priority: 0,
        readable: false,
        requestsReceived: 0,
        requestsSent: 0,
        responsesReceived: 0,
        responsesSent: 0,
        retransmissionsReceived: 0,
        retransmissionsSent: 0,
        state: 'failed',
        totalRoundTripTime: 0,
        transportId: '',
        writable: false
    }, filterObject(activeIceCandidatePair || {}, null));
    activeIceCandidatePair.localCandidate = Object.assign({
        candidateType: 'host',
        deleted: false,
        ip: '',
        port: 0,
        priority: 0,
        protocol: 'udp',
        url: ''
    }, filterObject(activeIceCandidatePair.localCandidate || {}, null));
    activeIceCandidatePair.remoteCandidate = Object.assign({
        candidateType: 'host',
        ip: '',
        port: 0,
        priority: 0,
        protocol: 'udp',
        url: ''
    }, filterObject(activeIceCandidatePair.remoteCandidate || {}, null));
    return activeIceCandidatePair;
}
module.exports = RoomV2;

},{"../../stats/statsreport":117,"../../util":133,"../../util/movingaveragedelta":138,"../../util/twilio-video-errors":148,"../room":66,"./dominantspeakersignaling":69,"./networkqualitymonitor":76,"./networkqualitysignaling":77,"./publisherhintsignaling.js":80,"./recording":81,"./remoteparticipant":82,"./renderhintssignaling":84,"./trackprioritysignaling":86,"./trackswitchoffsignaling":87}],86:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var MediaSignaling = require('./mediasignaling');
var TrackPrioritySignaling = /** @class */ (function (_super) {
    __extends(TrackPrioritySignaling, _super);
    /**
     * Construct a {@link TrackPrioritySignaling}.
     * @param {Promise<DataTrackReceiver>} getReceiver
     */
    function TrackPrioritySignaling(getReceiver, options) {
        var _this = _super.call(this, getReceiver, 'track_priority', options) || this;
        Object.defineProperties(_this, {
            _enqueuedPriorityUpdates: {
                value: new Map()
            },
        });
        _this.on('ready', function (transport) {
            Array.from(_this._enqueuedPriorityUpdates.keys()).forEach(function (trackSid) {
                transport.publish({
                    type: 'track_priority',
                    track: trackSid,
                    subscribe: _this._enqueuedPriorityUpdates.get(trackSid)
                });
                // NOTE(mpatwardhan)- we do not clear _enqueuedPriorityUpdates intentionally,
                // this cache will is used to re-send the priorities in case of VMS-FailOver.
            });
        });
        return _this;
    }
    /**
     * @param {Track.SID} trackSid
     * @param {'publish'|'subscribe'} publishOrSubscribe
     * @param {Track.Priority} priority
     */
    TrackPrioritySignaling.prototype.sendTrackPriorityUpdate = function (trackSid, publishOrSubscribe, priority) {
        if (publishOrSubscribe !== 'subscribe') {
            throw new Error('only subscribe priorities are supported, found: ' + publishOrSubscribe);
        }
        this._enqueuedPriorityUpdates.set(trackSid, priority);
        if (this._transport) {
            this._transport.publish({
                type: 'track_priority',
                track: trackSid,
                subscribe: priority
            });
        }
    };
    return TrackPrioritySignaling;
}(MediaSignaling));
module.exports = TrackPrioritySignaling;

},{"./mediasignaling":75}],87:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var MediaSignaling = require('./mediasignaling');
/**
 * @emits TrackSwitchOffSignalinging#updated
 */
var TrackSwitchOffSignaling = /** @class */ (function (_super) {
    __extends(TrackSwitchOffSignaling, _super);
    /**
     * Construct a {@link TrackSwitchOffSignaling}.
     * @param {Promise<DataTrackReceiver>} getReceiver
     */
    function TrackSwitchOffSignaling(getReceiver, options) {
        var _this = _super.call(this, getReceiver, 'track_switch_off', options) || this;
        _this.on('ready', function (transport) {
            transport.on('message', function (message) {
                switch (message.type) {
                    case 'track_switch_off':
                        _this._setTrackSwitchOffUpdates(message.off || [], message.on || []);
                        break;
                    default:
                        break;
                }
            });
        });
        return _this;
    }
    /**
     * @private
     * @param {[Track.SID]} tracksSwitchedOff
     * @param {[Track.SID]} tracksSwitchedOn
     * @returns {void}
     */
    TrackSwitchOffSignaling.prototype._setTrackSwitchOffUpdates = function (tracksSwitchedOff, tracksSwitchedOn) {
        this.emit('updated', tracksSwitchedOff, tracksSwitchedOn);
    };
    return TrackSwitchOffSignaling;
}(MediaSignaling));
/**
 * @event TrackSwitchOffSignaling#updated
 */
module.exports = TrackSwitchOffSignaling;

},{"./mediasignaling":75}],88:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var StateMachine = require('../../statemachine');
var TwilioConnection = require('../../twilioconnection');
var DefaultBackoff = require('../../util/backoff');
var reconnectBackoffConfig = require('../../util/constants').reconnectBackoffConfig;
var Timeout = require('../../util/timeout');
var _a = require('../../util/constants'), SDK_NAME = _a.SDK_NAME, SDK_VERSION = _a.SDK_VERSION, SDP_FORMAT = _a.SDP_FORMAT;
var _b = require('../../util'), createBandwidthProfilePayload = _b.createBandwidthProfilePayload, createMediaSignalingPayload = _b.createMediaSignalingPayload, createMediaWarningsPayload = _b.createMediaWarningsPayload, createSubscribePayload = _b.createSubscribePayload, getUserAgent = _b.getUserAgent, isNonArrayObject = _b.isNonArrayObject;
var _c = require('../../util/twilio-video-errors'), createTwilioError = _c.createTwilioError, RoomCompletedError = _c.RoomCompletedError, SignalingConnectionError = _c.SignalingConnectionError, SignalingServerBusyError = _c.SignalingServerBusyError;
var ICE_VERSION = 1;
var RSP_VERSION = 2;
/*
TwilioConnectionTransport States
----------------

                      +-----------+
                      |           |
                      |  syncing  |---------+
                      |           |         |
                      +-----------+         |
                         ^     |            |
                         |     |            |
                         |     v            v
    +------------+    +-----------+    +--------------+
    |            |    |           |    |              |
    | connecting |--->| connected |--->| disconnected |
    |            |    |           |    |              |
    +------------+    +-----------+    +--------------+
             |                              ^
             |                              |
             |                              |
             +------------------------------+

*/
var states = {
    connecting: [
        'connected',
        'disconnected'
    ],
    connected: [
        'disconnected',
        'syncing'
    ],
    syncing: [
        'connected',
        'disconnected'
    ],
    disconnected: []
};
/**
 * A {@link TwilioConnectionTransport} supports sending and receiving Room Signaling Protocol
 * (RSP) messages. It also supports RSP requests, such as Sync and Disconnect.
 * @extends StateMachine
 * @emits TwilioConnectionTransport#connected
 * @emits TwilioConnectionTransport#message
 */
var TwilioConnectionTransport = /** @class */ (function (_super) {
    __extends(TwilioConnectionTransport, _super);
    /**
     * Construct a {@link TwilioConnectionTransport}.
     * @param {?string} name
     * @param {string} accessToken
     * @param {ParticipantSignaling} localParticipant
     * @param {PeerConnectionManager} peerConnectionManager
     * @param {string} wsServer
     * @param {object} [options]
     */
    function TwilioConnectionTransport(name, accessToken, localParticipant, peerConnectionManager, wsServer, options) {
        var _this = this;
        options = Object.assign({
            Backoff: DefaultBackoff,
            TwilioConnection: TwilioConnection,
            iceServers: null,
            trackPriority: true,
            trackSwitchOff: true,
            renderHints: true,
            userAgent: getUserAgent()
        }, options);
        _this = _super.call(this, 'connecting', states) || this;
        Object.defineProperties(_this, {
            _accessToken: {
                value: accessToken
            },
            _automaticSubscription: {
                value: options.automaticSubscription
            },
            _bandwidthProfile: {
                value: options.bandwidthProfile
            },
            _dominantSpeaker: {
                value: options.dominantSpeaker
            },
            _adaptiveSimulcast: {
                value: options.adaptiveSimulcast
            },
            _eventObserver: {
                value: options.eventObserver,
                writable: false
            },
            _renderHints: {
                value: options.renderHints
            },
            _iceServersStatus: {
                value: Array.isArray(options.iceServers)
                    ? 'overrode'
                    : 'acquire'
            },
            _localParticipant: {
                value: localParticipant
            },
            _name: {
                value: name,
            },
            _networkQuality: {
                value: isNonArrayObject(options.networkQuality) || options.networkQuality
            },
            _notifyWarnings: {
                value: options.notifyWarnings
            },
            _options: {
                value: options
            },
            _peerConnectionManager: {
                value: peerConnectionManager
            },
            _sessionTimer: {
                value: null,
                writable: true
            },
            _sessionTimeoutMS: {
                value: 0,
                writable: true
            },
            _reconnectBackoff: {
                value: new options.Backoff(reconnectBackoffConfig)
            },
            _session: {
                value: null,
                writable: true
            },
            _trackPriority: {
                value: options.trackPriority
            },
            _trackSwitchOff: {
                value: options.trackSwitchOff
            },
            _twilioConnection: {
                value: null,
                writable: true
            },
            _updatesReceived: {
                value: []
            },
            _updatesToSend: {
                value: []
            },
            _userAgent: {
                value: options.userAgent
            },
            _wsServer: {
                value: wsServer
            }
        });
        setupTransport(_this);
        return _this;
    }
    /**
     * Create a Connect, Sync or Disconnect RSP message.
     * @private
     * @returns {?object}
     */
    TwilioConnectionTransport.prototype._createConnectOrSyncOrDisconnectMessage = function () {
        if (this.state === 'connected') {
            return null;
        }
        if (this.state === 'disconnected') {
            return {
                session: this._session,
                type: 'disconnect',
                version: RSP_VERSION
            };
        }
        var type = {
            connecting: 'connect',
            syncing: 'sync'
        }[this.state];
        var message = {
            name: this._name,
            participant: this._localParticipant.getState(),
            peer_connections: this._peerConnectionManager.getStates(),
            type: type,
            version: RSP_VERSION
        };
        if (message.type === 'connect') {
            message.ice_servers = this._iceServersStatus;
            message.publisher = {
                name: SDK_NAME,
                sdk_version: SDK_VERSION,
                user_agent: this._userAgent
            };
            if (this._bandwidthProfile) {
                message.bandwidth_profile = createBandwidthProfilePayload(this._bandwidthProfile);
            }
            if (this._notifyWarnings) {
                message.participant.media_warnings = createMediaWarningsPayload(this._notifyWarnings);
            }
            message.media_signaling = createMediaSignalingPayload(this._dominantSpeaker, this._networkQuality, this._trackPriority, this._trackSwitchOff, this._adaptiveSimulcast, this._renderHints);
            message.subscribe = createSubscribePayload(this._automaticSubscription);
            message.format = SDP_FORMAT;
            message.token = this._accessToken;
        }
        else if (message.type === 'sync') {
            message.session = this._session;
            message.token = this._accessToken;
        }
        else if (message.type === 'update') {
            message.session = this._session;
        }
        return message;
    };
    /**
     * Create an "ice" message.
     * @private
     */
    TwilioConnectionTransport.prototype._createIceMessage = function () {
        return {
            edge: 'roaming',
            token: this._accessToken,
            type: 'ice',
            version: ICE_VERSION
        };
    };
    /**
     * Send a Connect, Sync or Disconnect RSP message.
     * @private
     */
    TwilioConnectionTransport.prototype._sendConnectOrSyncOrDisconnectMessage = function () {
        var message = this._createConnectOrSyncOrDisconnectMessage();
        if (message) {
            this._twilioConnection.sendMessage(message);
        }
    };
    /**
     * Disconnect the {@link TwilioConnectionTransport}. Returns true if calling the method resulted
     * in disconnection.
     * @param {TwilioError} [error]
     * @returns {boolean}
     */
    TwilioConnectionTransport.prototype.disconnect = function (error) {
        if (this.state !== 'disconnected') {
            this.preempt('disconnected', null, [error]);
            this._sendConnectOrSyncOrDisconnectMessage();
            this._twilioConnection.close();
            return true;
        }
        return false;
    };
    /**
     * Publish an RSP Update. Returns true if calling the method resulted in
     * publishing (or eventually publishing) the update.
     * @param {object} update
     * @returns {boolean}
     */
    TwilioConnectionTransport.prototype.publish = function (update) {
        switch (this.state) {
            case 'connected':
                this._twilioConnection.sendMessage(Object.assign({
                    session: this._session,
                    type: 'update',
                    version: RSP_VERSION
                }, update));
                return true;
            case 'connecting':
            case 'syncing':
                this._updatesToSend.push(update);
                return true;
            case 'disconnected':
            default:
                return false;
        }
    };
    /**
     * Publish (or queue) an event to the Insights gateway.
     * @param {string} group - Event group name
     * @param {string} name - Event name
     * @param {string} level - Event level
     * @param {object} payload - Event payload
     * @returns {void}
     */
    TwilioConnectionTransport.prototype.publishEvent = function (group, name, level, payload) {
        this._eventObserver.emit('event', { group: group, name: name, level: level, payload: payload });
    };
    /**
     * Sync the {@link TwilioConnectionTransport}. Returns true if calling the method resulted in
     * syncing.
     * @returns {boolean}
     */
    TwilioConnectionTransport.prototype.sync = function () {
        if (this.state === 'connected') {
            this.preempt('syncing');
            this._sendConnectOrSyncOrDisconnectMessage();
            return true;
        }
        return false;
    };
    /**
     * @private
     * @returns {void}
     */
    TwilioConnectionTransport.prototype._setSession = function (session, sessionTimeout) {
        this._session = session;
        this._sessionTimeoutMS = sessionTimeout * 1000;
    };
    /**
     * Determines if we should attempt reconnect.
     * returns a Promise to wait on before attempting to
     * reconnect. returns null if its not okay to reconnect.
     * @private
     * @returns {Promise<void>}
     */
    TwilioConnectionTransport.prototype._getReconnectTimer = function () {
        var _this = this;
        if (this._sessionTimeoutMS === 0) {
            // this means either we have never connected.
            // or we timed out while trying to reconnect
            // In either case we do not want to reconnect.
            return null;
        }
        // start session timer
        if (!this._sessionTimer) {
            this._sessionTimer = new Timeout(function () {
                // ensure that _clearReconnectTimer wasn't
                // called while we were waiting.
                if (_this._sessionTimer) {
                    // do not allow any more reconnect attempts.
                    _this._sessionTimeoutMS = 0;
                }
            }, this._sessionTimeoutMS);
        }
        // return promise that waits with exponential backoff.
        return new Promise(function (resolve) {
            _this._reconnectBackoff.backoff(resolve);
        });
    };
    /**
     * clears the session reconnect timer.
     *
     * @private
     * @returns {void}
     */
    TwilioConnectionTransport.prototype._clearReconnectTimer = function () {
        this._reconnectBackoff.reset();
        if (this._sessionTimer) {
            this._sessionTimer.clear();
            this._sessionTimer = null;
        }
    };
    return TwilioConnectionTransport;
}(StateMachine));
/**
 * @event TwilioConnectionTransport#connected
 * @param {object} initialState
 */
/**
 * @event TwilioConnectionTransport#message
 * @param {object} peerConnections
 */
function reducePeerConnections(peerConnections) {
    return Array.from(peerConnections.reduce(function (peerConnectionsById, update) {
        var reduced = peerConnectionsById.get(update.id) || update;
        // First, reduce the top-level `description` property.
        if (!reduced.description && update.description) {
            reduced.description = update.description;
        }
        else if (reduced.description && update.description) {
            if (update.description.revision > reduced.description.revision) {
                reduced.description = update.description;
            }
        }
        // Then, reduce the top-level `ice` property.
        if (!reduced.ice && update.ice) {
            reduced.ice = update.ice;
        }
        else if (reduced.ice && update.ice) {
            if (update.ice.revision > reduced.ice.revision) {
                reduced.ice = update.ice;
            }
        }
        // Finally, update the map.
        peerConnectionsById.set(reduced.id, reduced);
        return peerConnectionsById;
    }, new Map()).values());
}
function reduceUpdates(updates) {
    return updates.reduce(function (reduced, update) {
        // First, reduce the top-level `participant` property.
        if (!reduced.participant && update.participant) {
            reduced.participant = update.participant;
        }
        else if (reduced.participant && update.participant) {
            if (update.participant.revision > reduced.participant.revision) {
                reduced.participant = update.participant;
            }
        }
        // Then, reduce the top-level `peer_connections` property.
        /* eslint camelcase:0 */
        if (!reduced.peer_connections && update.peer_connections) {
            reduced.peer_connections = reducePeerConnections(update.peer_connections);
        }
        else if (reduced.peer_connections && update.peer_connections) {
            reduced.peer_connections = reducePeerConnections(reduced.peer_connections.concat(update.peer_connections));
        }
        return reduced;
    }, {});
}
function setupTransport(transport) {
    function createOrResetTwilioConnection() {
        if (transport.state === 'disconnected') {
            return;
        }
        if (transport._twilioConnection) {
            transport._twilioConnection.removeListener('message', handleMessage);
        }
        var _iceServersStatus = transport._iceServersStatus, _options = transport._options, _wsServer = transport._wsServer, state = transport.state;
        var TwilioConnection = _options.TwilioConnection;
        var twilioConnection = new TwilioConnection(_wsServer, Object.assign({
            helloBody: state === 'connecting' && _iceServersStatus === 'acquire'
                ? transport._createIceMessage()
                : transport._createConnectOrSyncOrDisconnectMessage()
        }, _options));
        twilioConnection.once('close', function (reason) {
            if (reason === TwilioConnection.CloseReason.LOCAL) {
                disconnect();
            }
            else {
                disconnect(new Error(reason));
            }
        });
        twilioConnection.on('message', handleMessage);
        transport._twilioConnection = twilioConnection;
    }
    function disconnect(error) {
        if (transport.state === 'disconnected') {
            return;
        }
        if (!error) {
            transport.disconnect();
            return;
        }
        var reconnectTimer = transport._getReconnectTimer();
        if (!reconnectTimer) {
            var twilioError = error.message === TwilioConnection.CloseReason.BUSY
                ? new SignalingServerBusyError()
                : new SignalingConnectionError();
            transport.disconnect(twilioError);
            return;
        }
        if (transport.state === 'connected') {
            transport.preempt('syncing');
        }
        reconnectTimer.then(createOrResetTwilioConnection);
    }
    function handleMessage(message) {
        if (transport.state === 'disconnected') {
            return;
        }
        if (message.type === 'error') {
            transport.disconnect(createTwilioError(message.code, message.message));
            return;
        }
        switch (transport.state) {
            case 'connected':
                switch (message.type) {
                    case 'connected':
                    case 'synced':
                    case 'update':
                    case 'warning':
                        transport.emit('message', message);
                        return;
                    case 'disconnected':
                        transport.disconnect(message.status === 'completed'
                            ? new RoomCompletedError()
                            : null);
                        return;
                    default:
                        // Do nothing.
                        return;
                }
            case 'connecting':
                switch (message.type) {
                    case 'iced':
                        transport._options.onIced(message.ice_servers).then(function () {
                            transport._sendConnectOrSyncOrDisconnectMessage();
                        });
                        return;
                    case 'connected':
                        transport._setSession(message.session, message.options.session_timeout);
                        transport.emit('connected', message);
                        transport.preempt('connected');
                        return;
                    case 'synced':
                    case 'update':
                        transport._updatesReceived.push(message);
                        return;
                    case 'disconnected':
                        transport.disconnect(message.status === 'completed'
                            ? new RoomCompletedError()
                            : null);
                        return;
                    default:
                        // Do nothing.
                        return;
                }
            case 'syncing':
                switch (message.type) {
                    case 'connected':
                    case 'update':
                        transport._updatesReceived.push(message);
                        return;
                    case 'synced':
                        transport._clearReconnectTimer();
                        transport.emit('message', message);
                        transport.preempt('connected');
                        return;
                    case 'disconnected':
                        transport.disconnect(message.status === 'completed'
                            ? new RoomCompletedError()
                            : null);
                        return;
                    default:
                        // Do nothing.
                        return;
                }
            default:
                // Impossible
                return;
        }
    }
    transport.on('stateChanged', function stateChanged(state) {
        switch (state) {
            case 'connected': {
                var updates = transport._updatesToSend.splice(0);
                if (updates.length) {
                    transport.publish(reduceUpdates(updates));
                }
                transport._updatesReceived.splice(0).forEach(function (update) { return transport.emit('message', update); });
                return;
            }
            case 'disconnected':
                transport._twilioConnection.removeListener('message', handleMessage);
                transport.removeListener('stateChanged', stateChanged);
                return;
            case 'syncing':
                // Do nothing.
                return;
            default:
                // Impossible
                return;
        }
    });
    var _options = transport._options, _iceServersStatus = transport._iceServersStatus;
    var iceServers = _options.iceServers, onIced = _options.onIced;
    if (_iceServersStatus === 'overrode') {
        onIced(iceServers).then(createOrResetTwilioConnection);
    }
    else {
        createOrResetTwilioConnection();
    }
}
module.exports = TwilioConnectionTransport;

},{"../../statemachine":89,"../../twilioconnection":121,"../../util":133,"../../util/backoff":123,"../../util/constants":126,"../../util/timeout":147,"../../util/twilio-video-errors":148}],89:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var EventEmitter = require('events').EventEmitter;
var util = require('./util');
/**
 * {@link StateMachine} represents a state machine. The state machine supports a
 * reentrant locking mechanism to allow asynchronous state transitions to ensure
 * they have not been preempted. Calls to {@link StateMachine#takeLock} are
 * guaranteed to be resolved in FIFO order.
 * @extends EventEmitter
 * @property {boolean} isLocked - whether or not the {@link StateMachine} is
 *   locked performing asynchronous state transition
 * @property {string} state - the current state
 * @emits {@link StateMachine#stateChanged}
 */
var StateMachine = /** @class */ (function (_super) {
    __extends(StateMachine, _super);
    /**
     * Construct a {@link StateMachine}.
     * @param {string} initialState - the intiial state
     * @param {object} states
     */
    function StateMachine(initialState, states) {
        var _this = _super.call(this) || this;
        var lock = null;
        var state = initialState;
        states = transformStates(states);
        Object.defineProperties(_this, {
            _lock: {
                get: function () {
                    return lock;
                },
                set: function (_lock) {
                    lock = _lock;
                }
            },
            _reachableStates: {
                value: reachable(states)
            },
            _state: {
                get: function () {
                    return state;
                },
                set: function (_state) {
                    state = _state;
                }
            },
            _states: {
                value: states
            },
            _whenDeferreds: {
                value: new Set()
            },
            isLocked: {
                enumerable: true,
                get: function () {
                    return lock !== null;
                }
            },
            state: {
                enumerable: true,
                get: function () {
                    return state;
                }
            }
        });
        _this.on('stateChanged', function (state) {
            _this._whenDeferreds.forEach(function (deferred) {
                deferred.when(state, deferred.resolve, deferred.reject);
            });
        });
        return _this;
    }
    /**
     * Returns a promise whose executor function is called on each state change.
     * @param {function(state: string, resolve: function, reject: function): void} when
     * @returns {Promise.<*>}
     * @private
     */
    StateMachine.prototype._whenPromise = function (when) {
        var _this = this;
        if (typeof when !== 'function') {
            return Promise.reject(new Error('when() executor must be a function'));
        }
        var deferred = util.defer();
        deferred.when = when;
        this._whenDeferreds.add(deferred);
        return deferred.promise.then(function (payload) {
            _this._whenDeferreds.delete(deferred);
            return payload;
        }, function (error) {
            _this._whenDeferreds.delete(deferred);
            throw error;
        });
    };
    /**
     * This method takes a lock and passes the {@link StateMachine#Key} to your
     * transition function. You may perform zero or more state transitions in your
     * transition function, but you should check for preemption in each tick. You
     * may also reenter the lock. Once the Promise returned by your transition
     * function resolves or rejects, this method releases the lock it acquired for
     * you.
     * @param {string} name - a name for the lock
     * @param {function(StateMachine#Key): Promise} transitionFunction
     * @returns {Promise}
     */
    // NOTE(mroberts): This method is named after a Haskell function:
    // https://hackage.haskell.org/package/base-4.8.2.0/docs/Control-Exception.html#v:bracket
    StateMachine.prototype.bracket = function (name, transitionFunction) {
        var key;
        var self = this;
        function releaseLock(error) {
            if (self.hasLock(key)) {
                self.releaseLockCompletely(key);
            }
            if (error) {
                throw error;
            }
        }
        return this.takeLock(name).then(function gotKey(_key) {
            key = _key;
            return transitionFunction(key);
        }).then(function success(result) {
            releaseLock();
            return result;
        }, releaseLock);
    };
    /**
     * Check whether or not a {@link StateMachine#Key} matches the lock.
     * @param {StateMachine#Key} key
     * @returns {boolean}
     */
    StateMachine.prototype.hasLock = function (key) {
        return this._lock === key;
    };
    /**
     * Preempt any pending state transitions and immediately transition to the new
     * state. If a lock name is specified, take the lock and return the
     * {@link StateMachine#Key}.
     * @param {string} newState
     * @param {?string} [name=null] - a name for the lock
     * @param {Array<*>} [payload=[]]
     * @returns {?StateMachine#Key}
     */
    StateMachine.prototype.preempt = function (newState, name, payload) {
        // 1. Check that the new state is valid.
        if (!isValidTransition(this._states, this.state, newState)) {
            throw new Error("Cannot transition from \"" + this.state + "\" to \"" + newState + "\"");
        }
        // 2. Release the old lock, if any.
        var oldLock;
        if (this.isLocked) {
            oldLock = this._lock;
            this._lock = null;
        }
        // 3. Take the lock, if requested.
        var key = null;
        if (name) {
            key = this.takeLockSync(name);
        }
        // 4. If a lock wasn't requested, take a "preemption" lock in order to
        // maintain FIFO order of those taking locks.
        var preemptionKey = key ? null : this.takeLockSync('preemption');
        // 5. Transition.
        this.transition(newState, key || preemptionKey, payload);
        // 6. Preempt anyone blocked on the old lock.
        if (oldLock) {
            oldLock.resolve();
        }
        // 7. Release the "preemption" lock, if we took it.
        if (preemptionKey) {
            this.releaseLock(preemptionKey);
        }
        return key;
    };
    /**
     * Release a lock. This method succeeds only if the {@link StateMachine} is
     * still locked and has not been preempted.
     * @param {StateMachine#Key} key
     * @throws Error
     */
    StateMachine.prototype.releaseLock = function (key) {
        if (!this.isLocked) {
            throw new Error("Could not release the lock for " + key.name + " because the StateMachine is not locked");
        }
        else if (!this.hasLock(key)) {
            throw new Error("Could not release the lock for " + key.name + " because " + this._lock.name + " has the lock");
        }
        if (key.depth === 0) {
            this._lock = null;
            key.resolve();
        }
        else {
            key.depth--;
        }
    };
    /**
     * Release a lock completely, even if it has been reentered. This method
     * succeeds only if the {@link StateMachine} is still locked and has not been
     * preempted.
     * @param {StateMachine#Key} key
     * @throws Error
     */
    StateMachine.prototype.releaseLockCompletely = function (key) {
        if (!this.isLocked) {
            throw new Error("Could not release the lock for " + key.name + " because the StateMachine is not locked");
        }
        else if (!this.hasLock(key)) {
            throw new Error("Could not release the lock for " + key.name + " because " + this._lock.name + " has the lock");
        }
        key.depth = 0;
        this._lock = null;
        key.resolve();
    };
    /**
     * Take a lock, returning a Promise for the {@link StateMachine#Key}. You should
     * take a lock anytime you intend to perform asynchronous transitions. Calls to
     * this method are guaranteed to be resolved in FIFO order. You may reenter
     * a lock by passing its {@link StateMachine#Key}.
     * @param {string|StateMachine#Key} nameOrKey - a name for the lock or an
     * existing {@link StateMachine#Key}
     * @returns {Promise<object>}
     */
    StateMachine.prototype.takeLock = function (nameOrKey) {
        var _this = this;
        // Reentrant lock
        if (typeof nameOrKey === 'object') {
            var key_1 = nameOrKey;
            return new Promise(function (resolve) {
                resolve(_this.takeLockSync(key_1));
            });
        }
        // New lock
        var name = nameOrKey;
        if (this.isLocked) {
            var takeLock = this.takeLock.bind(this, name);
            return this._lock.promise.then(takeLock);
        }
        return Promise.resolve(this.takeLockSync(name));
    };
    /**
     * Take a lock, returning the {@Link StateMachine#Key}. This method throws if
     * the {@link StateMachine} is locked or the wrong {@link StateMachine#Key} is
     * provided. You may reenter a lock by passing its {@link StateMachine#Key}.
     * @param {string|StateMachine#Key} nameOrKey - a name for the lock or an
     * existing {@link StateMachine#Key}
     * @returns {object}
     * @throws Error
     */
    StateMachine.prototype.takeLockSync = function (nameOrKey) {
        var key = typeof nameOrKey === 'string' ? null : nameOrKey;
        var name = key ? key.name : nameOrKey;
        if (key && !this.hasLock(key) || !key && this.isLocked) {
            throw new Error("Could not take the lock for " + name + " because the lock for " + this._lock.name + " was not released");
        }
        // Reentrant lock
        if (key) {
            key.depth++;
            return key;
        }
        // New lock
        var lock = makeLock(name);
        this._lock = lock;
        return lock;
    };
    /**
     * Transition to a new state. If the {@link StateMachine} is locked, you must
     * provide the {@link StateMachine#Key}. An invalid state or the wrong
     * {@link StateMachine#Key} will throw an error.
     * @param {string} newState
     * @param {?StateMachine#Key} [key=null]
     * @param {Array<*>} [payload=[]]
     * @throws {Error}
     */
    StateMachine.prototype.transition = function (newState, key, payload) {
        payload = payload || [];
        // 1. If we're locked, required the key.
        if (this.isLocked) {
            if (!key) {
                throw new Error('You must provide the key in order to ' +
                    'transition');
            }
            else if (!this.hasLock(key)) {
                throw new Error("Could not transition using the key for " + key.name + " because " + this._lock.name + " has the lock");
            }
        }
        else if (key) {
            throw new Error("Key provided for " + key.name + ", but the StateMachine was not locked (possibly due to preemption)");
        }
        // 2. Check that the new state is valid.
        if (!isValidTransition(this._states, this.state, newState)) {
            throw new Error("Cannot transition from \"" + this.state + "\" to \"" + newState + "\"");
        }
        // 3. Update the state and emit an event.
        this._state = newState;
        this.emit.apply(this, __spreadArray([], __read(['stateChanged', newState].concat(payload))));
    };
    /**
     * Attempt to transition to a new state. Unlike {@link StateMachine#transition},
     * this method does not throw.
     * @param {string} newState
     * @param {?StateMachine#Key} [key=null]
     * @param {Array<*>} [payload=[]]
     * @returns {boolean}
     */
    StateMachine.prototype.tryTransition = function (newState, key, payload) {
        try {
            this.transition(newState, key, payload);
        }
        catch (error) {
            return false;
        }
        return true;
    };
    /**
     * Return a Promise that resolves when the {@link StateMachine} transitions to
     * the specified state. If the {@link StateMachine} transitions such that the
     * requested state becomes unreachable, the Promise rejects.
     * @param {string} state
     * @returns {Promise<this>}
     */
    StateMachine.prototype.when = function (state) {
        var _this = this;
        if (this.state === state) {
            return Promise.resolve(this);
        }
        else if (!isValidTransition(this._reachableStates, this.state, state)) {
            return Promise.reject(createUnreachableError(this.state, state));
        }
        return this._whenPromise(function (newState, resolve, reject) {
            if (newState === state) {
                resolve(_this);
            }
            else if (!isValidTransition(_this._reachableStates, newState, state)) {
                reject(createUnreachableError(newState, state));
            }
        });
    };
    return StateMachine;
}(EventEmitter));
/**
 * @event StateMachine#stateChanged
 * @param {string} newState
 */
/**
 * Check if a transition is valid.
 * @private
 * @param {Map<*, Set<*>>} graph
 * @param {*} from
 * @param {*} to
 * @returns {boolean}
 */
function isValidTransition(graph, from, to) {
    return graph.get(from).has(to);
}
/**
 * @typedef {object} StateMachine#Key
 */
function makeLock(name) {
    var lock = util.defer();
    lock.name = name;
    lock.depth = 0;
    return lock;
}
/**
 * Compute the transitive closure of a graph (i.e. what nodes are reachable from
 * where).
 * @private
 * @param {Map<*, Set<*>>} graph
 * @returns {Map<*, Set<*>>}
 */
function reachable(graph) {
    return Array.from(graph.keys()).reduce(function (newGraph, from) { return newGraph.set(from, reachableFrom(graph, from)); }, new Map());
}
/**
 * Compute the Set of node reachable from a particular node in the graph.
 * @private
 * @param {Map<*, Set<*>>} graph
 * @param {*} from
 * @param {Set<*>} [to]
 * @returns {Set<*>}
 */
function reachableFrom(graph, from, to) {
    to = to || new Set();
    graph.get(from).forEach(function (node) {
        if (!to.has(node)) {
            to.add(node);
            reachableFrom(graph, node, to).forEach(to.add, to);
        }
    });
    return to;
}
function transformStates(states) {
    var newStates = new Map();
    for (var key in states) {
        newStates.set(key, new Set(states[key]));
    }
    return newStates;
}
/**
 * Create an "unreachable state" Error.
 * @param {string} here
 * @param {string} there
 * @returns {Error}
 */
function createUnreachableError(here, there) {
    return new Error("\"" + there + "\" cannot be reached from \"" + here + "\"");
}
module.exports = StateMachine;

},{"./util":133,"events":174}],90:[function(require,module,exports){
/* eslint no-undefined:0 */
'use strict';
/**
 * @param {Array<number|undefined>} xs
 * @returns {number|undefined}
 */
function average(xs) {
    xs = xs.filter(function (x) { return typeof x === 'number'; });
    return xs.length < 1 ? undefined : xs.reduce(function (y, x) { return x + y; }) / xs.length;
}
module.exports = average;

},{}],91:[function(require,module,exports){
'use strict';
/**
 * @property {number} [availableSend] - bps (undefined in Firefox)
 * @property {number} recv - bps
 * @property {number} [rtt] - s (undefined in Firefox)
 * @property {number} send - bps
 */
var IceReport = /** @class */ (function () {
    /**
     * Construct an {@link IceReport}.
     * @param {number} send - bps
     * @param {number} recv - bps
     * @param {number} [rtt] - s
     * @param {number} [availableSend] - bps
     */
    function IceReport(send, recv, availableSend, rtt) {
        Object.defineProperties(this, {
            availableSend: {
                enumerable: true,
                value: availableSend
            },
            recv: {
                enumerable: true,
                value: recv
            },
            rtt: {
                enumerable: true,
                value: rtt
            },
            send: {
                enumerable: true,
                value: send
            }
        });
    }
    /**
     * @param {RTCStats} olderStats
     * @param {RTCStats} newerStats
     * @returns {IceReport}
     */
    IceReport.of = function (olderStats, newerStats) {
        var secondsElapsed = (newerStats.timestamp - olderStats.timestamp) / 1000;
        var deltaBytesSent = newerStats.bytesSent - olderStats.bytesSent;
        var deltaBytesReceived = newerStats.bytesReceived - olderStats.bytesReceived;
        var send = secondsElapsed > 0
            ? (deltaBytesSent / secondsElapsed) * 8
            : 0;
        var recv = secondsElapsed > 0
            ? (deltaBytesReceived / secondsElapsed) * 8
            : 0;
        var availableSend = newerStats.availableOutgoingBitrate, rtt = newerStats.currentRoundTripTime;
        return new IceReport(send, recv, availableSend, rtt);
    };
    return IceReport;
}());
module.exports = IceReport;

},{}],92:[function(require,module,exports){
'use strict';
var IceReport = require('./icereport');
/**
 * @property {IceReport} lastReport
 * @property {?RTCStats} lastStats
 */
var IceReportFactory = /** @class */ (function () {
    /**
     * Construct an {@link IceReportFactory}.
     */
    function IceReportFactory() {
        Object.defineProperties(this, {
            lastReport: {
                enumerable: true,
                value: new IceReport(0, 0),
                writable: true
            },
            lastStats: {
                enumerable: true,
                value: null,
                writable: true
            }
        });
    }
    /**
     * Create an {@link IceReport}.
     * @param {RTCStats} newerStats;
     * @returns {IceReport}
     */
    IceReportFactory.prototype.next = function (newerStats) {
        var olderStats = this.lastStats;
        this.lastStats = newerStats;
        if (olderStats) {
            var report = olderStats.id === newerStats.id
                ? IceReport.of(olderStats, newerStats)
                : new IceReport(0, 0);
            this.lastReport = report;
        }
        return this.lastReport;
    };
    return IceReportFactory;
}());
module.exports = IceReportFactory;

},{"./icereport":91}],93:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var LocalTrackStats = require('./localtrackstats');
/**
 * Statistics for a {@link LocalAudioTrack}.
 * @extends LocalTrackStats
 * @property {?AudioLevel} audioLevel - Input {@link AudioLevel}
 * @property {?number} jitter - Audio jitter in milliseconds
 */
var LocalAudioTrackStats = /** @class */ (function (_super) {
    __extends(LocalAudioTrackStats, _super);
    /**
     * @param {string} trackId - {@link LocalAudioTrack} ID
     * @param {StandardizedTrackStatsReport} statsReport
     * @param {boolean} prepareForInsights
     */
    function LocalAudioTrackStats(trackId, statsReport, prepareForInsights) {
        var _this = _super.call(this, trackId, statsReport, prepareForInsights) || this;
        Object.defineProperties(_this, {
            audioLevel: {
                value: typeof statsReport.audioInputLevel === 'number'
                    ? statsReport.audioInputLevel
                    : null,
                enumerable: true
            },
            jitter: {
                value: typeof statsReport.jitter === 'number'
                    ? statsReport.jitter
                    : null,
                enumerable: true
            }
        });
        return _this;
    }
    return LocalAudioTrackStats;
}(LocalTrackStats));
/**
 * The maximum absolute amplitude of a set of audio samples in the
 * range of 0 to 32767 inclusive.
 * @typedef {number} AudioLevel
 */
module.exports = LocalAudioTrackStats;

},{"./localtrackstats":94}],94:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var TrackStats = require('./trackstats');
/**
 * Statistics for a {@link LocalTrack}.
 * @extends TrackStats
 * @property {?number} bytesSent - Number of bytes sent
 * @property {?number} packetsSent - Number of packets sent
 * @property {?number} roundTripTime - Round trip time in milliseconds
 */
var LocalTrackStats = /** @class */ (function (_super) {
    __extends(LocalTrackStats, _super);
    /**
     * @param {string} trackId - {@link LocalTrack} ID
     * @param {StandardizedTrackStatsReport} statsReport
     * @param {boolean} prepareForInsights
     */
    function LocalTrackStats(trackId, statsReport, prepareForInsights) {
        var _this = _super.call(this, trackId, statsReport) || this;
        Object.defineProperties(_this, {
            bytesSent: {
                value: typeof statsReport.bytesSent === 'number'
                    ? statsReport.bytesSent
                    : prepareForInsights ? 0 : null,
                enumerable: true
            },
            packetsSent: {
                value: typeof statsReport.packetsSent === 'number'
                    ? statsReport.packetsSent
                    : prepareForInsights ? 0 : null,
                enumerable: true
            },
            roundTripTime: {
                value: typeof statsReport.roundTripTime === 'number'
                    ? statsReport.roundTripTime
                    : prepareForInsights ? 0 : null,
                enumerable: true
            }
        });
        return _this;
    }
    return LocalTrackStats;
}(TrackStats));
module.exports = LocalTrackStats;

},{"./trackstats":119}],95:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var LocalTrackStats = require('./localtrackstats');
/**
 * Statistics for a {@link LocalVideoTrack}.
 * @extends LocalTrackStats
 * @property {?VideoTrack#Dimensions} captureDimensions - Video capture resolution
 * @property {?VideoTrack#Dimensions} dimensions - Video encoding resolution
 * @property {?number} captureFrameRate - Video capture frame rate
 * @property {?number} frameRate - Video encoding frame rate
 */
var LocalVideoTrackStats = /** @class */ (function (_super) {
    __extends(LocalVideoTrackStats, _super);
    /**
     * @param {string} trackId - {@link LocalVideoTrack} ID
     * @param {StandardizedTrackStatsReport} statsReport
     * @param {boolean} prepareForInsights
     */
    function LocalVideoTrackStats(trackId, statsReport, prepareForInsights) {
        var _this = _super.call(this, trackId, statsReport, prepareForInsights) || this;
        var captureDimensions = null;
        if (typeof statsReport.frameWidthInput === 'number' &&
            typeof statsReport.frameHeightInput === 'number') {
            captureDimensions = {};
            Object.defineProperties(captureDimensions, {
                width: {
                    value: statsReport.frameWidthInput,
                    enumerable: true
                },
                height: {
                    value: statsReport.frameHeightInput,
                    enumerable: true
                }
            });
        }
        var dimensions = null;
        if (typeof statsReport.frameWidthSent === 'number' &&
            typeof statsReport.frameHeightSent === 'number') {
            dimensions = {};
            Object.defineProperties(dimensions, {
                width: {
                    value: statsReport.frameWidthSent,
                    enumerable: true
                },
                height: {
                    value: statsReport.frameHeightSent,
                    enumerable: true
                }
            });
        }
        Object.defineProperties(_this, {
            captureDimensions: {
                value: captureDimensions,
                enumerable: true
            },
            dimensions: {
                value: dimensions,
                enumerable: true
            },
            captureFrameRate: {
                value: typeof statsReport.frameRateInput === 'number'
                    ? statsReport.frameRateInput
                    : null,
                enumerable: true
            },
            frameRate: {
                value: typeof statsReport.frameRateSent === 'number'
                    ? statsReport.frameRateSent
                    : null,
                enumerable: true
            }
        });
        return _this;
    }
    return LocalVideoTrackStats;
}(LocalTrackStats));
module.exports = LocalVideoTrackStats;

},{"./localtrackstats":94}],96:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var NetworkQualityMediaStats = require('./networkqualitymediastats');
/**
 * {@link NetworkQualityMediaStats} for a {@link Participant}'s audio.
 */
var NetworkQualityAudioStats = /** @class */ (function (_super) {
    __extends(NetworkQualityAudioStats, _super);
    /**
     * Construct a {@link NetworkQualityAudioStats}.
     * @param {MediaLevels} mediaLevels
     */
    function NetworkQualityAudioStats(mediaLevels) {
        return _super.call(this, mediaLevels) || this;
    }
    return NetworkQualityAudioStats;
}(NetworkQualityMediaStats));
module.exports = NetworkQualityAudioStats;

},{"./networkqualitymediastats":100}],97:[function(require,module,exports){
'use strict';
/**
 * Bandwidth network quality statistics.
 * @property {?number} actual - the actual bandwidth used, in bits per second
 * @property {?number} available - an estimate of available useable bandwidth, in bits per second
 * @property {?NetworkQualityLevel} level - {@link NetworkQualityLevel} for bandwidth
 */
var NetworkQualityBandwidthStats = /** @class */ (function () {
    /**
     * Construct a {@link NetworkQualityBandwidthStats}.
     * @param {BandwidthStats} bandwidthStats
     */
    function NetworkQualityBandwidthStats(_a) {
        var _b = _a.actual, actual = _b === void 0 ? null : _b, _c = _a.available, available = _c === void 0 ? null : _c, _d = _a.level, level = _d === void 0 ? null : _d;
        Object.defineProperties(this, {
            actual: {
                value: actual,
                enumerable: true
            },
            available: {
                value: available,
                enumerable: true
            },
            level: {
                value: level,
                enumerable: true
            }
        });
    }
    return NetworkQualityBandwidthStats;
}());
module.exports = NetworkQualityBandwidthStats;

},{}],98:[function(require,module,exports){
'use strict';
/**
 * Fraction lost network quality statistics.
 * @property {?number} fractionLost - packets lost
 * @property {?NetworkQualityLevel} level - {@link NetworkQualityLevel} for fraction lost
 */
var NetworkQualityFractionLostStats = /** @class */ (function () {
    /**
     * Construct a {@link NetworkQualityFractionLostStats}.
     * @param {FractionLostStats} fractionLostStats
     */
    function NetworkQualityFractionLostStats(_a) {
        var _b = _a.fractionLost, fractionLost = _b === void 0 ? null : _b, _c = _a.level, level = _c === void 0 ? null : _c;
        Object.defineProperties(this, {
            fractionLost: {
                value: fractionLost,
                enumerable: true
            },
            level: {
                value: level,
                enumerable: true
            }
        });
    }
    return NetworkQualityFractionLostStats;
}());
module.exports = NetworkQualityFractionLostStats;

},{}],99:[function(require,module,exports){
'use strict';
/**
 * Latency network quality statistics.
 * @property {?number} jitter - media jitter in seconds
 * @property {?number} rtt - round trip time in seconds
 * @property {?NetworkQualityLevel} level - {@link NetworkQualityLevel} for latency
 */
var NetworkQualityLatencyStats = /** @class */ (function () {
    /**
     * Construct a {@link NetworkQualityLatencyStats}.
     * @param {LatencyStats} latencyStats
     */
    function NetworkQualityLatencyStats(_a) {
        var _b = _a.jitter, jitter = _b === void 0 ? null : _b, _c = _a.rtt, rtt = _c === void 0 ? null : _c, _d = _a.level, level = _d === void 0 ? null : _d;
        Object.defineProperties(this, {
            jitter: {
                value: jitter,
                enumerable: true
            },
            rtt: {
                value: rtt,
                enumerable: true
            },
            level: {
                value: level,
                enumerable: true
            }
        });
    }
    return NetworkQualityLatencyStats;
}());
module.exports = NetworkQualityLatencyStats;

},{}],100:[function(require,module,exports){
'use strict';
var NetworkQualitySendStats = require('./networkqualitysendstats');
var NetworkQualityRecvStats = require('./networkqualityrecvstats');
/**
 * Network quality statistics shared between a {@link Participant}'s audio or video.
 * @property {NetworkQualityLevel} send - {@link NetworkQualityLevel} of the
 *  {@link Participant}'s published audio or video
 * @property {number} recv - {@link NetworkQualityLevel} of the
 *  {@link Participant}'s subscribed audio or video
 * @property {?NetworkQualitySendOrRecvStats} sendStats - {@link NetworkQualitySendOrRecvStats}
 *   based on which {@link NetworkQualityMediaStats}<code style="padding:0 0">#send</code>
 *   is calculated
 * @property {?NetworkQualitySendOrRecvStats} recvStats - {@link NetworkQualitySendOrRecvStats}
 *   based on which {@link NetworkQualityMediaStats}<code style="padding:0 0">#recv</code>
 *   is calculated
 */
var NetworkQualityMediaStats = /** @class */ (function () {
    /**
     * Construct a {@link NetworkQualityMediaStats}.
     * @param {MediaLevels} mediaLevels
     */
    function NetworkQualityMediaStats(_a) {
        var send = _a.send, recv = _a.recv, _b = _a.sendStats, sendStats = _b === void 0 ? null : _b, _c = _a.recvStats, recvStats = _c === void 0 ? null : _c;
        Object.defineProperties(this, {
            send: {
                value: send,
                enumerable: true
            },
            recv: {
                value: recv,
                enumerable: true
            },
            sendStats: {
                value: sendStats ? new NetworkQualitySendStats(sendStats) : null,
                enumerable: true
            },
            recvStats: {
                value: recvStats ? new NetworkQualityRecvStats(recvStats) : null,
                enumerable: true
            }
        });
    }
    return NetworkQualityMediaStats;
}());
module.exports = NetworkQualityMediaStats;

},{"./networkqualityrecvstats":101,"./networkqualitysendstats":103}],101:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var NetworkQualitySendOrRecvStats = require('./networkqualitysendorrecvstats');
/**
 * {@link NetworkQualitySendOrRecvStats} based on which a {@link Participant}'s
 * {@link NetworkQualityMediaStats}<code style="padding:0 0">#recv</code> is calculated.
 */
var NetworkQualityRecvStats = /** @class */ (function (_super) {
    __extends(NetworkQualityRecvStats, _super);
    /**
     * Construct a {@link NetworkQualityRecvStats}.
     * @param {SendOrRecvStats} sendOrRecvStats
     */
    function NetworkQualityRecvStats(sendOrRecvStats) {
        return _super.call(this, sendOrRecvStats) || this;
    }
    return NetworkQualityRecvStats;
}(NetworkQualitySendOrRecvStats));
module.exports = NetworkQualityRecvStats;

},{"./networkqualitysendorrecvstats":102}],102:[function(require,module,exports){
'use strict';
var NetworkQualityBandwidthStats = require('./networkqualitybandwidthstats');
var NetworkQualityFractionLostStats = require('./networkqualityfractionloststats');
var NetworkQualityLatencyStats = require('./networkqualitylatencystats');
/**
 * Network quality statistics shared between {@link NetworkQualitySendStats} and
 * {@link NetworkQualityRecvStats} based on which a {@link Participant}'s
 * {@link NetworkQualityMediaStats}<code style="padding:0 0">#send</code> or
 * {@link NetworkQualityMediaStats}<code style="padding:0 0">#recv</code> is calculated.
 * @property {?NetworkQualityBandwidthStats} bandwidth - bandwidth statistics
 * @property {?NetworkQualityLatencyStats} latency - latency statistics
 * @property {?NetworkQualityFractionLostStats} fractionLost - fraction lost statistics
 */
var NetworkQualitySendOrRecvStats = /** @class */ (function () {
    /**
     * Construct a {@link NetworkQualitySendOrRecvStats}.
     * @param {SendOrRecvStats} sendOrRecvStats
     */
    function NetworkQualitySendOrRecvStats(_a) {
        var _b = _a.bandwidth, bandwidth = _b === void 0 ? null : _b, _c = _a.fractionLost, fractionLost = _c === void 0 ? null : _c, _d = _a.latency, latency = _d === void 0 ? null : _d;
        Object.defineProperties(this, {
            bandwidth: {
                value: bandwidth ? new NetworkQualityBandwidthStats(bandwidth) : null,
                enumerable: true
            },
            fractionLost: {
                value: fractionLost ? new NetworkQualityFractionLostStats(fractionLost) : null,
                enumerable: true
            },
            latency: {
                value: latency ? new NetworkQualityLatencyStats(latency) : null,
                enumerable: true
            }
        });
    }
    return NetworkQualitySendOrRecvStats;
}());
module.exports = NetworkQualitySendOrRecvStats;

},{"./networkqualitybandwidthstats":97,"./networkqualityfractionloststats":98,"./networkqualitylatencystats":99}],103:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var NetworkQualitySendOrRecvStats = require('./networkqualitysendorrecvstats');
/**
 * {@link NetworkQualitySendOrRecvStats} based on which a {@link Participant}'s
 * {@link NetworkQualityMediaStats}<code style="padding:0 0">#send</code> is calculated.
 */
var NetworkQualitySendStats = /** @class */ (function (_super) {
    __extends(NetworkQualitySendStats, _super);
    /**
     * Construct a {@link NetworkQualitySendStats}.
     * @param {SendOrRecvStats} sendOrRecvStats
     */
    function NetworkQualitySendStats(sendOrRecvStats) {
        return _super.call(this, sendOrRecvStats) || this;
    }
    return NetworkQualitySendStats;
}(NetworkQualitySendOrRecvStats));
module.exports = NetworkQualitySendStats;

},{"./networkqualitysendorrecvstats":102}],104:[function(require,module,exports){
'use strict';
var NetworkQualityAudioStats = require('./networkqualityaudiostats');
var NetworkQualityVideoStats = require('./networkqualityvideostats');
/**
 * Network quality statistics for a {@link Participant}.
 * @property {NetworkQualityLevel} level - {@link NetworkQualityLevel} of the {@link Participant}
 * @property {?NetworkQualityAudioStats} audio - {@link NetworkQualityMediaStats}
 *   for audio; <code>null</code> if {@link NetworkQualityVerbosity} is {@link NetworkQualityVerbosity}<code style="padding:0 0">#minimal</code>
 *   or below
 * @property {?NetworkQualityVideoStats} video - {@link NetworkQualityMediaStats}
 *   for video; <code>null</code> if {@link NetworkQualityVerbosity} is {@link NetworkQualityVerbosity}<code style="padding:0 0">#minimal</code>
 *   or below
 */
var NetworkQualityStats = /** @class */ (function () {
    /**
     * Construct a {@link NetworkQualityStats}.
     * @param {NetworkQualityLevels} networkQualityLevels
     */
    function NetworkQualityStats(_a) {
        var level = _a.level, audio = _a.audio, video = _a.video;
        Object.defineProperties(this, {
            level: {
                value: level,
                enumerable: true
            },
            audio: {
                value: audio ? new NetworkQualityAudioStats(audio) : null,
                enumerable: true
            },
            video: {
                value: video ? new NetworkQualityVideoStats(video) : null,
                enumerable: true
            }
        });
    }
    return NetworkQualityStats;
}());
module.exports = NetworkQualityStats;

},{"./networkqualityaudiostats":96,"./networkqualityvideostats":105}],105:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var NetworkQualityMediaStats = require('./networkqualitymediastats');
/**
 * {@link NetworkQualityMediaStats} for a {@link Participant}'s video.
 */
var NetworkQualityVideoStats = /** @class */ (function (_super) {
    __extends(NetworkQualityVideoStats, _super);
    /**
     * Construct a {@link NetworkQualityVideoStats}.
     * @param {MediaLevels} mediaLevels
     */
    function NetworkQualityVideoStats(mediaLevels) {
        return _super.call(this, mediaLevels) || this;
    }
    return NetworkQualityVideoStats;
}(NetworkQualityMediaStats));
module.exports = NetworkQualityVideoStats;

},{"./networkqualitymediastats":100}],106:[function(require,module,exports){
'use strict';
var ReceiverReport = require('./receiverreport');
var SenderReport = require('./senderreport');
/**
 * @interface SenderAndReceiverReports
 * @property {Array<SenderReport>} send
 * @property {Array<ReceiverReport>} recv
 */
/**
 * @interface SenderAndReceiverSummary
 * @property {SenderSummary} send
 * @property {ReceiverSummary} recv
 */
/**
 * @interface PeerConnectionSummary
 * @property {IceReport} ice
 * @property {SenderSummary} send
 * @property {ReceiverSummary} recv
 * @property {SenderAndReceiverSummary} audio
 * @property {SenderAndReceiverSummary} video
 */
/**
 * @property {IceReport} ice
 * @roperty {SenderAndReceiverReports} audio
 * @roperty {SenderAndReceiverReports} video
 */
var PeerConnectionReport = /** @class */ (function () {
    /**
     * Construct a {@link PeerConnectionReport}.
     * @param {IceReport} ice
     * @param {SenderAndReceiverReports} audio
     * @param {SenderAndReceiverReports} video
     */
    function PeerConnectionReport(ice, audio, video) {
        Object.defineProperties(this, {
            ice: {
                enumerable: true,
                value: ice
            },
            audio: {
                enumerable: true,
                value: audio
            },
            video: {
                enumerable: true,
                value: video
            }
        });
    }
    /**
     * Summarize the {@link PeerConnectionReport} by summarizing its
     * {@link SenderReport}s and {@link ReceiverReport}s.
     * @returns {PeerConnectionSummary}
     */
    PeerConnectionReport.prototype.summarize = function () {
        var senderReports = this.audio.send.concat(this.video.send);
        var send = SenderReport.summarize(senderReports);
        var receiverReports = this.audio.recv.concat(this.video.recv);
        var recv = ReceiverReport.summarize(receiverReports);
        return {
            ice: this.ice,
            send: send,
            recv: recv,
            audio: {
                send: SenderReport.summarize(this.audio.send),
                recv: ReceiverReport.summarize(this.audio.recv)
            },
            video: {
                send: SenderReport.summarize(this.video.send),
                recv: ReceiverReport.summarize(this.video.recv)
            }
        };
    };
    return PeerConnectionReport;
}());
module.exports = PeerConnectionReport;

},{"./receiverreport":108,"./senderreport":115}],107:[function(require,module,exports){
'use strict';
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var guessBrowser = require('../webrtc/util').guessBrowser;
var IceReportFactory = require('./icereportfactory');
var PeerConnectionReport = require('./peerconnectionreport');
var ReceiverReportFactory = require('./receiverreportfactory');
var SenderReportFactory = require('./senderreportfactory');
/**
 * @typedef {string} TrackId
 */
/**
 * @typedef {string} StatsId
 */
/**
 * @interface SenderReportFactoriesByMediaType
 * @property {Map<StatsId, SenderReportFactory>} audio
 * @property {Map<StatsId, SenderReportFactory>} video
 */
/**
 * @interface ReceiverReportFactoriesByMediaType
 * @property {Map<StatsId, ReceiverReportFactory>} audio
 * @property {Map<StatsId, ReceiverReportFactory>} video
 */
/**
 * @interface SenderAndReceiverReportFactories
 * @property {Map<StatsId, SenderReportFactories>} send
 * @property {Map<StatsId, ReceiverReportFactories>} recv
 */
/**
 * @interface {StatsIdsByMediaType}
 * @property {Set<StatsId>} audio
 * @property {Set<StatsId>} video
 */
/**
 * @property {RTCPeerConnection} pc
 * @property {IceReportFactory} iceReportFactory
 * @property {SenderAndReceiverReportFactories} audio
 * @property {SenderAndReceiverReportFactories} video
 * @property {?PeerConnectionReport} lastReport
 */
var PeerConnectionReportFactory = /** @class */ (function () {
    /**
     * Construct a {@link PeerConnectionReportFactory}.
     * @param {RTCPeerConnection} pc
     */
    function PeerConnectionReportFactory(pc) {
        Object.defineProperties(this, {
            pc: {
                enumerable: true,
                value: pc
            },
            ice: {
                enumerable: true,
                value: new IceReportFactory()
            },
            audio: {
                enumerable: true,
                value: {
                    send: new Map(),
                    recv: new Map()
                }
            },
            video: {
                enumerable: true,
                value: {
                    send: new Map(),
                    recv: new Map()
                }
            },
            lastReport: {
                enumerable: true,
                value: null,
                writable: true
            }
        });
    }
    /**
     * Create a {@link PeerConnectionReport}.
     * @returns {Promise<PeerConnectionReport>}
     */
    PeerConnectionReportFactory.prototype.next = function () {
        var _this = this;
        var updatePromise = guessBrowser() === 'firefox'
            ? updateFirefox(this)
            : updateChrome(this);
        return updatePromise.then(function () {
            var audioSenderReportFactories = __spreadArray([], __read(_this.audio.send.values()));
            var videoSenderReportFactories = __spreadArray([], __read(_this.video.send.values()));
            var audioReceiverReportFactories = __spreadArray([], __read(_this.audio.recv.values()));
            var videoReceiverReportFactories = __spreadArray([], __read(_this.video.recv.values()));
            var report = new PeerConnectionReport(_this.ice.lastReport, {
                send: audioSenderReportFactories.map(function (factory) { return factory.lastReport; }).filter(function (report) { return report; }),
                recv: audioReceiverReportFactories.map(function (factory) { return factory.lastReport; }).filter(function (report) { return report; })
            }, {
                send: videoSenderReportFactories.map(function (factory) { return factory.lastReport; }).filter(function (report) { return report; }),
                recv: videoReceiverReportFactories.map(function (factory) { return factory.lastReport; }).filter(function (report) { return report; })
            });
            _this.lastReport = report;
            return report;
        });
    };
    return PeerConnectionReportFactory;
}());
/**
 * Construct a Map from MediaStreamTrack Ids to RTCStatsReports.
 * @param {Array<RTCRtpSender>|Array<RTCRtpReceiver>} sendersOrReceivers - each
 *   RTCRtpSender should have a non-null track
 * @returns {Promise<Map<TrackId, RTCStats>>}
 */
function getSenderOrReceiverReports(sendersOrReceivers) {
    return Promise.all(sendersOrReceivers.map(function (senderOrReceiver) {
        var trackId = senderOrReceiver.track.id;
        return senderOrReceiver.getStats().then(function (report) {
            var e_1, _a;
            try {
                // NOTE(mroberts): We have to rewrite Ids due to this bug:
                //
                //   https://bugzilla.mozilla.org/show_bug.cgi?id=1463430
                //
                for (var _b = __values(report.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
                    var stats = _c.value;
                    if (stats.type === 'inbound-rtp') {
                        stats.id = trackId + "-" + stats.id;
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return [trackId, report];
        });
    })).then(function (pairs) { return new Map(pairs); });
}
/**
 * @param {SenderReportFactory.constructor} SenderReportFactory
 * @param {SenderReportFactoriesByMediaType} sendersByMediaType
 * @param {RTCStatsReport} report
 * @param {RTCStats} stats
 * @param {TrackId} [trackId]
 * @returns {?SenderReportFactory}
 */ /**
* @param {ReceiverReportFactory.constructor} ReceiverReportFactory
* @param {ReceiverReportFactoriesByMediaType} receiversByMediaType
* @param {RTCStatsReport} report
* @param {RTCStats} stats
* @param {TrackId} [trackId]
* @returns {?ReceiverReportFactory}
*/
function getOrCreateSenderOrReceiverReportFactory(SenderOrReceiverReportFactory, sendersOrReceiversByMediaType, report, stats, trackId) {
    var sendersOrReceivers = sendersOrReceiversByMediaType[stats.mediaType];
    if (!trackId) {
        var trackStats = report.get(stats.trackId);
        if (trackStats) {
            trackId = trackStats.trackIdentifier;
        }
    }
    if (sendersOrReceivers && trackId) {
        if (sendersOrReceivers.has(stats.id)) {
            return sendersOrReceivers.get(stats.id);
        }
        var senderOrReceiverFactory = new SenderOrReceiverReportFactory(trackId, stats);
        sendersOrReceivers.set(stats.id, senderOrReceiverFactory);
    }
    return null;
}
/**
 * @param {PeerConnectionReportFactory} factory
 * @returns {SenderReportFactoriesByMediaType}
 */
function getSenderReportFactoriesByMediaType(factory) {
    return { audio: factory.audio.send, video: factory.video.send };
}
/**
 * @param {PeerConnectionReportFactory} factory
 * @returns {ReceiverReportFactoriesByMediaType}
 */
function getReceiverReportFactoriesByMediaType(factory) {
    return { audio: factory.audio.recv, video: factory.video.recv };
}
/**
 * @param {PeerConnectionReportFactory} factory
 * @param {RTCStatsReport} report
 * @param {RTCStats} stats
 * @param {TrackId} [trackId]
 * @returns {?SenderReportFactory}
 */
function getOrCreateSenderReportFactory(factory, report, stats, trackId) {
    return getOrCreateSenderOrReceiverReportFactory(SenderReportFactory, getSenderReportFactoriesByMediaType(factory), report, stats, trackId);
}
/**
 * @param {PeerConnectionReportFactory} factory
 * @param {RTCStatsReport} report
 * @param {RTCStats} stats
 * @param {TrackId} [trackId]
 * @returns {?ReceiverReportFactory}
 */
function getOrCreateReceiverReportFactory(factory, report, stats, trackId) {
    return getOrCreateSenderOrReceiverReportFactory(ReceiverReportFactory, getReceiverReportFactoriesByMediaType(factory), report, stats, trackId);
}
/**
 * @param {PeerConnectionReportFactory} factory
 * @retuns {StatsIdsByMediaType}
 */
function getSenderReportFactoryIdsByMediaType(factory) {
    return {
        audio: new Set(factory.audio.send.keys()),
        video: new Set(factory.video.send.keys())
    };
}
/**
 * @param {PeerConnectionReportFactory} factory
 * @retuns {StatsIdsByMediaType}
 */
function getReceiverReportFactoryIdsByMediaType(factory) {
    return {
        audio: new Set(factory.audio.recv.keys()),
        video: new Set(factory.video.recv.keys())
    };
}
/**
 * @param {PeerConnectionReportFactory} factory
 * @param {RTCStatsReport} report
 * @param {StatsIdsByMediaType} senderReportFactoryIdsToDeleteByMediaType
 * @param {TrackId} [trackId]
 * @returns {void}
 */
function updateSenderReports(factory, report, senderReportFactoryIdsToDeleteByMediaType, trackId) {
    var e_2, _a;
    try {
        for (var _b = __values(report.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
            var stats = _c.value;
            if (stats.type === 'outbound-rtp' && !stats.isRemote) {
                if (guessBrowser() !== 'firefox' && !stats.trackId) {
                    continue;
                }
                var senderReportFactoryIdsToDelete = senderReportFactoryIdsToDeleteByMediaType[stats.mediaType];
                if (senderReportFactoryIdsToDelete) {
                    senderReportFactoryIdsToDelete.delete(stats.id);
                }
                var senderReportFactory = getOrCreateSenderReportFactory(factory, report, stats, trackId);
                if (senderReportFactory) {
                    var remoteInboundStats = report.get(stats.remoteId);
                    senderReportFactory.next(trackId || senderReportFactory.trackId, stats, remoteInboundStats);
                }
            }
        }
    }
    catch (e_2_1) { e_2 = { error: e_2_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_2) throw e_2.error; }
    }
}
/**
 * @param {PeerConnectionReportFactory} factory
 * @param {RTCStatsReport} report
 * @param {StatsIdsByMediaType} receiverReportFactoryIdsToDeleteByMediaType
 * @param {TrackId} [trackId]
 * @returns {void}
 */
function updateReceiverReports(factory, report, receiverReportFactoryIdsToDeleteByMediaType, trackId) {
    var e_3, _a;
    try {
        for (var _b = __values(report.values()), _c = _b.next(); !_c.done; _c = _b.next()) {
            var stats = _c.value;
            if (stats.type === 'inbound-rtp' && !stats.isRemote) {
                var receiverReportFactoryIdsToDelete = receiverReportFactoryIdsToDeleteByMediaType[stats.mediaType];
                if (receiverReportFactoryIdsToDelete) {
                    receiverReportFactoryIdsToDelete.delete(stats.id);
                }
                var receiverReportFactory = getOrCreateReceiverReportFactory(factory, report, stats, trackId);
                if (receiverReportFactory) {
                    receiverReportFactory.next(trackId || receiverReportFactory.trackId, stats);
                }
            }
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_3) throw e_3.error; }
    }
}
/**
 * @param {SenderReportFactoriesByMediaType|ReceiverReportFactoriesByMediaType} senderOrReceiverReportFactoriesByMediaType
 * @param {StatsIdsByMediaType} senderOrReceiverReportFactoryIdsByMediaType
 * @returns {void}
 */
function deleteSenderOrReceiverReportFactories(senderOrReceiverReportFactoriesByMediaType, senderOrReceiverReportFactoryIdsByMediaType) {
    var _loop_1 = function (mediaType) {
        var senderOrReceiverReportFactories = senderOrReceiverReportFactoriesByMediaType[mediaType];
        var senderOrReceiverReportFactoryIds = senderOrReceiverReportFactoryIdsByMediaType[mediaType];
        senderOrReceiverReportFactoryIds.forEach(function (senderOrReceiverReportFactoryId) { return senderOrReceiverReportFactories.delete(senderOrReceiverReportFactoryId); });
    };
    for (var mediaType in senderOrReceiverReportFactoryIdsByMediaType) {
        _loop_1(mediaType);
    }
}
/**
 * @param {IceReportFactory} ice
 * @param {RTCStatsReport} report
 * @returns {void}
 */
function updateIceReport(ice, report) {
    var e_4, _a, e_5, _b;
    var selectedCandidatePair;
    try {
        for (var _c = __values(report.values()), _d = _c.next(); !_d.done; _d = _c.next()) {
            var stats = _d.value;
            if (stats.type === 'transport') {
                selectedCandidatePair = report.get(stats.selectedCandidatePairId);
            }
        }
    }
    catch (e_4_1) { e_4 = { error: e_4_1 }; }
    finally {
        try {
            if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
        }
        finally { if (e_4) throw e_4.error; }
    }
    if (selectedCandidatePair) {
        ice.next(selectedCandidatePair);
        return;
    }
    try {
        for (var _e = __values(report.values()), _f = _e.next(); !_f.done; _f = _e.next()) {
            var stats = _f.value;
            if (stats.type === 'candidate-pair'
                && stats.nominated
                && ('selected' in stats ? stats.selected : true)) {
                ice.next(stats);
            }
        }
    }
    catch (e_5_1) { e_5 = { error: e_5_1 }; }
    finally {
        try {
            if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
        }
        finally { if (e_5) throw e_5.error; }
    }
}
/**
 * @param {PeerConnectionReportFactory} factory
 * @returns {Promise<PeerConnectionReport>}
 */
function updateFirefox(factory) {
    var senders = factory.pc.getTransceivers()
        .filter(function (transceiver) { return transceiver.currentDirection && transceiver.currentDirection.match(/send/) && transceiver.sender.track; })
        .map(function (transceiver) { return transceiver.sender; });
    var receivers = factory.pc.getTransceivers()
        .filter(function (transceiver) { return transceiver.currentDirection && transceiver.currentDirection.match(/recv/); })
        .map(function (transceiver) { return transceiver.receiver; });
    return Promise.all([
        getSenderOrReceiverReports(senders),
        getSenderOrReceiverReports(receivers),
        factory.pc.getStats()
    ]).then(function (_a) {
        var _b = __read(_a, 3), senderReports = _b[0], receiverReports = _b[1], pcReport = _b[2];
        var senderReportFactoriesByMediaType = getSenderReportFactoriesByMediaType(factory);
        var senderReportFactoryIdsToDeleteByMediaType = getSenderReportFactoryIdsByMediaType(factory);
        senderReports.forEach(function (report, trackId) { return updateSenderReports(factory, report, senderReportFactoryIdsToDeleteByMediaType, trackId); });
        deleteSenderOrReceiverReportFactories(senderReportFactoriesByMediaType, senderReportFactoryIdsToDeleteByMediaType);
        var receiverReportFactoriesByMediaType = getReceiverReportFactoriesByMediaType(factory);
        var receiverReportFactoryIdsToDeleteByMediaType = getReceiverReportFactoryIdsByMediaType(factory);
        receiverReports.forEach(function (report, trackId) { return updateReceiverReports(factory, report, receiverReportFactoryIdsToDeleteByMediaType, trackId); });
        deleteSenderOrReceiverReportFactories(receiverReportFactoriesByMediaType, receiverReportFactoryIdsToDeleteByMediaType);
        updateIceReport(factory.ice, pcReport);
    });
}
/**
 * @param {PeerConnectionReportFactory} factory
 * @returns {Promise<PeerConnectionReport>}
 */
function updateChrome(factory) {
    return factory.pc.getStats().then(function (report) {
        var senderReportFactoriesByMediaType = getSenderReportFactoriesByMediaType(factory);
        var senderReportFactoryIdsToDeleteByMediaType = getSenderReportFactoryIdsByMediaType(factory);
        updateSenderReports(factory, report, senderReportFactoryIdsToDeleteByMediaType);
        deleteSenderOrReceiverReportFactories(senderReportFactoriesByMediaType, senderReportFactoryIdsToDeleteByMediaType);
        var receiverReportFactoriesByMediaType = getReceiverReportFactoriesByMediaType(factory);
        var receiverReportFactoryIdsToDeleteByMediaType = getReceiverReportFactoryIdsByMediaType(factory);
        updateReceiverReports(factory, report, receiverReportFactoryIdsToDeleteByMediaType);
        deleteSenderOrReceiverReportFactories(receiverReportFactoriesByMediaType, receiverReportFactoryIdsToDeleteByMediaType);
        updateIceReport(factory.ice, report);
    });
}
module.exports = PeerConnectionReportFactory;

},{"../webrtc/util":171,"./icereportfactory":92,"./peerconnectionreport":106,"./receiverreportfactory":109,"./senderreportfactory":116}],108:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var average = require('./average');
var SenderOrReceiverReport = require('./senderorreceiverreport');
var sum = require('./sum');
/**
 * @interface ReceiverSummary
 * @property {number} bitrate
 * @property {number} fractionLost - 0–1
 * @property {number} [jitter] - s (undefined for video tracks in Chrome)
 */
/**
 * @extends SenderOrReceiverReport
 * @property {number} deltaPacketsLost
 * @property {number} deltaPacketsReceived
 * @property {number} [fractionLost] - 0–1 (undefined in Firefox)
 * @property {number} [jitter] - s (undefined for video tracks in Chrome)
 * @property {number} phonyPacketsLost - 0–1
 */
var ReceiverReport = /** @class */ (function (_super) {
    __extends(ReceiverReport, _super);
    /**
     * @param {StatsId} id
     * @param {TrackId} trackId
     * @param {number} bitrate - bps
     * @param {number} deltaPacketsLost
     * @param {number} deltaPacketsReceived
     * @param {number} [fractionLost] - 0–1 (undefined in Firefox)
     * @param {number} [jitter] - s (undefined for video tracks in Chrome)
     */
    function ReceiverReport(id, trackId, bitrate, deltaPacketsLost, deltaPacketsReceived, fractionLost, jitter) {
        var _this = _super.call(this, id, trackId, bitrate) || this;
        var phonyFractionLost = deltaPacketsReceived > 0
            ? deltaPacketsLost / deltaPacketsReceived
            : 0;
        Object.defineProperties(_this, {
            deltaPacketsLost: {
                enumerable: true,
                value: deltaPacketsLost
            },
            deltaPacketsReceived: {
                enumerable: true,
                value: deltaPacketsReceived
            },
            fractionLost: {
                enumerable: true,
                value: fractionLost
            },
            jitter: {
                enumerable: true,
                value: jitter
            },
            phonyFractionLost: {
                enumerable: true,
                value: phonyFractionLost
            }
        });
        return _this;
    }
    /**
     * Create a {@link ReceiverReport}.
     * @param {string} trackId
     * @param {RTCStats} olderStats
     * @param {RTCStats} newerStats
     * @returns {ReceiverReport}
     */
    ReceiverReport.of = function (trackId, olderStats, newerStats) {
        if (olderStats.id !== newerStats.id) {
            throw new Error('RTCStats IDs must match');
        }
        var secondsElapsed = (newerStats.timestamp - olderStats.timestamp) / 1000;
        var deltaBytesReceived = newerStats.bytesReceived - olderStats.bytesReceived;
        var bitrate = secondsElapsed > 0
            ? (deltaBytesReceived / secondsElapsed) * 8
            : 0;
        var deltaPacketsLost = Math.max(newerStats.packetsLost - olderStats.packetsLost, 0);
        var deltaPacketsReceived = newerStats.packetsReceived - olderStats.packetsReceived;
        var fractionLost = newerStats.fractionLost, jitter = newerStats.jitter;
        return new ReceiverReport(olderStats.id, trackId, bitrate, deltaPacketsLost, deltaPacketsReceived, fractionLost, jitter);
    };
    /**
     * Summarize {@link ReceiverReport}s by summing and averaging their values.
     * @param {Array<ReceiverReport>} reports
     * @returns {ReceiverSummary}
     */
    ReceiverReport.summarize = function (reports) {
        var summaries = reports.map(function (report) { return report.summarize(); });
        var bitrate = sum(summaries.map(function (summary) { return summary.bitrate; }));
        var fractionLost = average(summaries.map(function (summary) { return summary.fractionLost; }));
        var jitter = average(summaries.map(function (summary) { return summary.jitter; }));
        return {
            bitrate: bitrate,
            fractionLost: fractionLost,
            jitter: jitter
        };
    };
    /**
     * Summarize the {@link ReceiveReport}.
     * @returns {ReceiverSummary}
     */
    ReceiverReport.prototype.summarize = function () {
        return {
            bitrate: this.bitrate,
            fractionLost: typeof this.fractionLost === 'number' ? this.fractionLost : this.phonyFractionLost,
            jitter: this.jitter
        };
    };
    return ReceiverReport;
}(SenderOrReceiverReport));
module.exports = ReceiverReport;

},{"./average":90,"./senderorreceiverreport":113,"./sum":118}],109:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ReceiverReport = require('./receiverreport');
var SenderOrReceiverReportFactory = require('./senderorreceiverreportfactory');
/**
 * @extends SenderOrReceiverReportFactory
 * @param {?ReceiverReport} lastReport
 */
var ReceiverReportFactory = /** @class */ (function (_super) {
    __extends(ReceiverReportFactory, _super);
    /**
     * Construct a {@link ReceiverReportFactory}.
     * @param {TrackId} trackId
     * @param {RTCStats} initialStats
     */
    function ReceiverReportFactory(trackId, initialStats) {
        var _this = _super.call(this, initialStats.id, trackId, initialStats) || this;
        Object.defineProperties(_this, {
            lastReport: {
                enumerable: true,
                value: null,
                writable: true
            }
        });
        return _this;
    }
    /**
     * Create a {@link ReceiverReport}.
     * @param {TrackId} trackId
     * @param {RTCStats} newerStats
     * @returns {ReceiverReport}
     */
    ReceiverReportFactory.prototype.next = function (trackId, newerStats) {
        var olderStats = this.lastStats;
        this.lastStats = newerStats;
        this.trackId = trackId;
        var report = ReceiverReport.of(trackId, olderStats, newerStats);
        this.lastReport = report;
        return report;
    };
    return ReceiverReportFactory;
}(SenderOrReceiverReportFactory));
module.exports = ReceiverReportFactory;

},{"./receiverreport":108,"./senderorreceiverreportfactory":114}],110:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var RemoteTrackStats = require('./remotetrackstats');
/**
 * Statistics for an {@link AudioTrack}.
 * @extends RemoteTrackStats
 * @property {?AudioLevel} audioLevel - Output {@link AudioLevel}
 * @property {?number} jitter - Audio jitter in milliseconds
 */
var RemoteAudioTrackStats = /** @class */ (function (_super) {
    __extends(RemoteAudioTrackStats, _super);
    /**
     * @param {string} trackId - {@link AudioTrack} ID
     * @param {StandardizedTrackStatsReport} statsReport
     */
    function RemoteAudioTrackStats(trackId, statsReport) {
        var _this = _super.call(this, trackId, statsReport) || this;
        Object.defineProperties(_this, {
            audioLevel: {
                value: typeof statsReport.audioOutputLevel === 'number'
                    ? statsReport.audioOutputLevel
                    : null,
                enumerable: true
            },
            jitter: {
                value: typeof statsReport.jitter === 'number'
                    ? statsReport.jitter
                    : null,
                enumerable: true
            }
        });
        return _this;
    }
    return RemoteAudioTrackStats;
}(RemoteTrackStats));
module.exports = RemoteAudioTrackStats;

},{"./remotetrackstats":111}],111:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var TrackStats = require('./trackstats');
/**
 * Statistics for a remote {@link Track}.
 * @extends TrackStats
 * @property {?number} bytesReceived - Number of bytes received
 * @property {?number} packetsReceived - Number of packets received
 */
var RemoteTrackStats = /** @class */ (function (_super) {
    __extends(RemoteTrackStats, _super);
    /*
     * @param {string} trackId - {@link Track} ID
     * @param {StandardizedTrackStatsReport} statsReport
     */
    function RemoteTrackStats(trackId, statsReport) {
        var _this = _super.call(this, trackId, statsReport) || this;
        Object.defineProperties(_this, {
            bytesReceived: {
                value: typeof statsReport.bytesReceived === 'number'
                    ? statsReport.bytesReceived
                    : null,
                enumerable: true
            },
            packetsReceived: {
                value: typeof statsReport.packetsReceived === 'number'
                    ? statsReport.packetsReceived
                    : null,
                enumerable: true
            }
        });
        return _this;
    }
    return RemoteTrackStats;
}(TrackStats));
module.exports = RemoteTrackStats;

},{"./trackstats":119}],112:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var RemoteTrackStats = require('./remotetrackstats');
/**
 * Statistics for a {@link VideoTrack}.
 * @extends RemoteTrackStats
 * @property {?VideoTrack#Dimensions} dimensions - Received video resolution
 * @property {?number} frameRate - Received video frame rate
 */
var RemoteVideoTrackStats = /** @class */ (function (_super) {
    __extends(RemoteVideoTrackStats, _super);
    /**
     * @param {string} trackId - {@link VideoTrack} ID
     * @param {StandardizedTrackStatsReport} statsReport
     */
    function RemoteVideoTrackStats(trackId, statsReport) {
        var _this = _super.call(this, trackId, statsReport) || this;
        var dimensions = null;
        if (typeof statsReport.frameWidthReceived === 'number' &&
            typeof statsReport.frameHeightReceived === 'number') {
            dimensions = {};
            Object.defineProperties(dimensions, {
                width: {
                    value: statsReport.frameWidthReceived,
                    enumerable: true
                },
                height: {
                    value: statsReport.frameHeightReceived,
                    enumerable: true
                }
            });
        }
        Object.defineProperties(_this, {
            dimensions: {
                value: dimensions,
                enumerable: true
            },
            frameRate: {
                value: typeof statsReport.frameRateReceived === 'number'
                    ? statsReport.frameRateReceived
                    : null,
                enumerable: true
            }
        });
        return _this;
    }
    return RemoteVideoTrackStats;
}(RemoteTrackStats));
module.exports = RemoteVideoTrackStats;

},{"./remotetrackstats":111}],113:[function(require,module,exports){
'use strict';
/**
 * @property {StatsId} id
 * @property {TrackId} trackId
 * @property {number} bitrate - bps
 */
var SenderOrReceiverReport = /** @class */ (function () {
    /**
     * Construct a {@link SenderOrReceiverReport}.
     * @param {StatsId} id
     * @param {TrackId} trackId
     * @param {number} bitrate - bps
     */
    function SenderOrReceiverReport(id, trackId, bitrate) {
        Object.defineProperties(this, {
            id: {
                enumerable: true,
                value: id
            },
            trackId: {
                enumerable: true,
                value: trackId
            },
            bitrate: {
                enumerable: true,
                value: bitrate
            }
        });
    }
    return SenderOrReceiverReport;
}());
module.exports = SenderOrReceiverReport;

},{}],114:[function(require,module,exports){
'use strict';
/**
 * @property {StatsId} id
 * @property {TrackId} trackId
 * @property {RTCStats} lastStats
 */
var SenderOrReceiverReportFactory = /** @class */ (function () {
    /**
     * @param {StatsId} id
     * @param {TrackId} trackId
     * @param {RTCStats} initialStats
     */
    function SenderOrReceiverReportFactory(id, trackId, initialStats) {
        Object.defineProperties(this, {
            id: {
                enumerable: true,
                value: id,
                writable: true
            },
            trackId: {
                enumerable: true,
                value: trackId,
                writable: true
            },
            lastStats: {
                enumerable: true,
                value: initialStats,
                writable: true
            }
        });
    }
    return SenderOrReceiverReportFactory;
}());
module.exports = SenderOrReceiverReportFactory;

},{}],115:[function(require,module,exports){
/* eslint no-undefined:0 */
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var average = require('./average');
var SenderOrReceiverReport = require('./senderorreceiverreport');
var sum = require('./sum');
/**
 * @interface SenderSummary
 * @property {number} bitrate
 * @property {number} [rtt] - s (undefined in Chrome)
 */
/**
 * @extends SenderOrReceiverReport
 * @property {number} [rtt] - s (undefined in Chrome)
 */
var SenderReport = /** @class */ (function (_super) {
    __extends(SenderReport, _super);
    /**
     * Construct a {@link SenderReport}.
     * @param {StatsId} id
     * @param {TrackId} trackId
     * @param {number} bitrate - bps
     * @param {number} [rtt] - s
     */
    function SenderReport(id, trackId, bitrate, rtt) {
        var _this = _super.call(this, id, trackId, bitrate) || this;
        Object.defineProperties(_this, {
            rtt: {
                enumerable: true,
                value: rtt
            }
        });
        return _this;
    }
    /**
     * Create a {@link SenderReport}.
     * @param {string} trackId
     * @param {RTCStats} olderStats
     * @param {RTCStats} newerStats
     * @param {RTCRemoteInboundRtpStreamStats} [newerRemoteStats]
     * @returns {SenderReport}
     */
    SenderReport.of = function (trackId, olderStats, newerStats, newerRemoteStats) {
        if (olderStats.id !== newerStats.id) {
            throw new Error('RTCStats IDs must match');
        }
        var secondsElapsed = (newerStats.timestamp - olderStats.timestamp) / 1000;
        var deltaBytesSent = newerStats.bytesSent - olderStats.bytesSent;
        var bitrate = secondsElapsed > 0
            ? (deltaBytesSent / secondsElapsed) * 8
            : 0;
        var rtt = newerRemoteStats && typeof newerRemoteStats.roundTripTime === 'number'
            ? newerRemoteStats.roundTripTime / 1000
            : undefined;
        return new SenderReport(olderStats.id, trackId, bitrate, rtt);
    };
    /**
     * Summarize {@link SenderReport}s by summing and averaging their values.
     * @param {Array<SenderReport>} reports
     * @returns {SenderSummary}
     */
    SenderReport.summarize = function (reports) {
        var bitrate = sum(reports.map(function (report) { return report.bitrate; }));
        var rtt = average(reports.map(function (report) { return report.rtt; }));
        return {
            bitrate: bitrate,
            rtt: rtt
        };
    };
    return SenderReport;
}(SenderOrReceiverReport));
module.exports = SenderReport;

},{"./average":90,"./senderorreceiverreport":113,"./sum":118}],116:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var SenderOrReceiverReportFactory = require('./senderorreceiverreportfactory');
var SenderReport = require('./senderreport');
/**
 * @extends {SenderOrReceiverReportFactory}
 * @property {?SenderReport} lastReport
 */
var SenderReportFactory = /** @class */ (function (_super) {
    __extends(SenderReportFactory, _super);
    /**
     * Construct a {@link SenderReportFactory}.
     * @param {TrackId} trackId
     * @param {RTCStats} initialStats
     */
    function SenderReportFactory(trackId, initialStats) {
        var _this = _super.call(this, initialStats.id, trackId, initialStats) || this;
        Object.defineProperties(_this, {
            lastReport: {
                enumerable: true,
                value: null,
                writable: true
            }
        });
        return _this;
    }
    /**
     * @param {TrackId} trackId
     * @param {RTCStats} newerStats
     * @param {RTCRemoteInboundRtpStreamStats} [newerRemoteStats]
     * @returns {SenderReport}
     */
    SenderReportFactory.prototype.next = function (trackId, newerStats, newerRemoteStats) {
        var olderStats = this.lastStats;
        this.lastStats = newerStats;
        this.trackId = trackId;
        var report = SenderReport.of(trackId, olderStats, newerStats, newerRemoteStats);
        this.lastReport = report;
        return report;
    };
    return SenderReportFactory;
}(SenderOrReceiverReportFactory));
module.exports = SenderReportFactory;

},{"./senderorreceiverreportfactory":114,"./senderreport":115}],117:[function(require,module,exports){
'use strict';
var LocalAudioTrackStats = require('./localaudiotrackstats');
var LocalVideoTrackStats = require('./localvideotrackstats');
var RemoteAudioTrackStats = require('./remoteaudiotrackstats');
var RemoteVideoTrackStats = require('./remotevideotrackstats');
/**
 * Statistics report for an RTCPeerConnection.
 * @property {string} peerConnectionId - ID of the RTCPeerConnection
 * @property {Array<LocalAudioTrackStats>} localAudioTrackStats - List of {@link LocalAudioTrackStats}
 * @property {Array<LocalVideoTrackStats>} localVideoTrackStats - List of {@link LocalVideoTrackStats}
 * @property {Array<RemoteAudioTrackStats>} remoteAudioTrackStats - List of {@link RemoteAudioTrackStats}
 * @property {Array<RemoteVideoTrackStats>} remoteVideoTrackStats - List of {@link RemoteVideoTrackStats}
 */
var StatsReport = /** @class */ (function () {
    /**
     * @param {string} peerConnectionId - RTCPeerConnection ID
     * @param {StandardizedStatsResponse} statsResponse
     * @param {boolean} prepareForInsights - if report is being prepared to send to insights.
     */
    function StatsReport(peerConnectionId, statsResponse, prepareForInsights) {
        if (typeof peerConnectionId !== 'string') {
            throw new Error('RTCPeerConnection id must be a string');
        }
        Object.defineProperties(this, {
            peerConnectionId: {
                value: peerConnectionId,
                enumerable: true
            },
            localAudioTrackStats: {
                value: statsResponse.localAudioTrackStats.map(function (report) { return new LocalAudioTrackStats(report.trackId, report, prepareForInsights); }),
                enumerable: true
            },
            localVideoTrackStats: {
                value: statsResponse.localVideoTrackStats.map(function (report) { return new LocalVideoTrackStats(report.trackId, report, prepareForInsights); }),
                enumerable: true
            },
            remoteAudioTrackStats: {
                value: statsResponse.remoteAudioTrackStats.map(function (report) { return new RemoteAudioTrackStats(report.trackId, report); }),
                enumerable: true
            },
            remoteVideoTrackStats: {
                value: statsResponse.remoteVideoTrackStats.map(function (report) { return new RemoteVideoTrackStats(report.trackId, report); }),
                enumerable: true
            }
        });
    }
    return StatsReport;
}());
module.exports = StatsReport;

},{"./localaudiotrackstats":93,"./localvideotrackstats":95,"./remoteaudiotrackstats":110,"./remotevideotrackstats":112}],118:[function(require,module,exports){
'use strict';
/**
 * @param {Array<number|undefined>} xs
 * @returns {number}
 */
function sum(xs) {
    return xs.reduce(function (y, x) { return typeof x === 'number' ? x + y : y; }, 0);
}
module.exports = sum;

},{}],119:[function(require,module,exports){
'use strict';
/**
 * Statistics for a {@link Track}.
 * @property {Track.ID} trackId - The {@link Track} ID
 * @property {Track.SID} trackSid - The {@link Track}'s SID when published in
 *  in a {@link Room}
 * @property {number} timestamp - A Unix timestamp in milliseconds indicating
 *   when the {@link TrackStats} were gathered
 * @property {string} ssrc - The {@link Track}'s SSRC when transmitted over the
 *   RTCPeerConnection
 * @property {?number} packetsLost - The number of packets lost
 * @property {?string} codec - The name of the codec used to encode the
 *   {@link Track}'s media
 */
var TrackStats = /** @class */ (function () {
    /**
     * @param {string} trackId - {@link Track} ID
     * @param {StandardizedTrackStatsReport} statsReport
     */
    function TrackStats(trackId, statsReport) {
        if (typeof trackId !== 'string') {
            throw new Error('Track id must be a string');
        }
        Object.defineProperties(this, {
            trackId: {
                value: trackId,
                enumerable: true
            },
            trackSid: {
                value: statsReport.trackSid,
                enumerable: true
            },
            timestamp: {
                value: statsReport.timestamp,
                enumerable: true
            },
            ssrc: {
                value: statsReport.ssrc,
                enumerable: true
            },
            packetsLost: {
                value: typeof statsReport.packetsLost === 'number'
                    ? statsReport.packetsLost
                    : null,
                enumerable: true
            },
            codec: {
                value: typeof statsReport.codecName === 'string'
                    ? statsReport.codecName
                    : null,
                enumerable: true
            }
        });
    }
    return TrackStats;
}());
module.exports = TrackStats;

},{}],120:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var QueueingEventEmitter = require('./queueingeventemitter');
/**
 * A {@link TrackTransceiver} represents either one or more local RTCRtpSenders
 * or RTCDataChannels, or a single RTCRtpReceiver or remote RTCDataChannel.
 * @extends QueueingEventEmitter
 * @property {Track.ID} id
 * @property {Track.kind} kind
 */
var TrackTransceiver = /** @class */ (function (_super) {
    __extends(TrackTransceiver, _super);
    /**
     * Construct a {@link TrackTransceiver}.
     * @param {Track.ID} id
     * @param {Track.kind} kind
     */
    function TrackTransceiver(id, kind) {
        var _this = _super.call(this) || this;
        Object.defineProperties(_this, {
            id: {
                enumerable: true,
                value: id
            },
            kind: {
                enumerable: true,
                value: kind
            }
        });
        return _this;
    }
    /**
     * Stop the {@link TrackTransceiver}.
     * #emits TrackTransceiver#stopped
     * @returns {void}
     */
    TrackTransceiver.prototype.stop = function () {
        this.emit('stopped');
    };
    return TrackTransceiver;
}(QueueingEventEmitter));
/**
 * The {@link TrackTransceiver} was stopped.
 * @event TrackTransceiver#stopped
 */
module.exports = TrackTransceiver;

},{"./queueingeventemitter":56}],121:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var StateMachine = require('./statemachine');
var _a = require('./util'), buildLogLevels = _a.buildLogLevels, makeUUID = _a.makeUUID;
var Log = require('./util/log');
var NetworkMonitor = require('./util/networkmonitor');
var Timeout = require('./util/timeout');
var nInstances = 0;
/*
  TwilioConnection states
  -----------------------

       ------------------------------------------
       |                                        |
       |                                        v
  +---------+       +--------------+       +----------+
  |  early  | ----> |  connecting  | ----> |  closed  |
  +---------+       +--------------+       +----------+
    ^                     | ^ |                 ^ ^
    | --------------------- | |                 | |
    | | --------------------- |                 | |
    | | | --------------------|------------------ |
    | v | |                   v                   |
  +----------+           +--------+               |
  | waiting  | --------> |  open  | ---------------
  +----------+           +--------+
 */
var states = {
    closed: [],
    connecting: ['closed', 'open', 'waiting'],
    early: ['closed', 'connecting'],
    open: ['closed'],
    waiting: ['closed', 'connecting', 'early', 'open']
};
var events = {
    closed: 'close',
    open: 'open',
    waiting: 'waiting'
};
var TCMP_VERSION = 2;
var DEFAULT_MAX_CONSECUTIVE_MISSED_HEARTBEATS = 3;
var DEFAULT_MAX_CONSECUTIVE_FAILED_HELLOS = 3;
var DEFAULT_MAX_REQUESTED_HEARTBEAT_TIMEOUT = 5000;
var DEFAULT_OPEN_TIMEOUT = 15000;
var DEFAULT_WELCOME_TIMEOUT = 5000;
var OUTGOING_HEARTBEAT_OFFSET = 200;
var WS_CLOSE_NORMAL = 1000;
var WS_CLOSE_WELCOME_TIMEOUT = 3000;
var WS_CLOSE_HEARTBEATS_MISSED = 3001;
var WS_CLOSE_HELLO_FAILED = 3002;
var WS_CLOSE_SEND_FAILED = 3003;
var WS_CLOSE_NETWORK_CHANGED = 3004;
var WS_CLOSE_BUSY_WAIT = 3005;
var WS_CLOSE_SERVER_BUSY = 3006;
var WS_CLOSE_OPEN_TIMEOUT = 3007;
// NOTE(joma): If you want to use close code 3008, please increment
// the close code in test/integration/spec/docker/reconnection.js
// line number 492.
var toplevel = globalThis;
var WebSocket = toplevel.WebSocket ? toplevel.WebSocket : require('ws');
var CloseReason = {
    BUSY: 'busy',
    FAILED: 'failed',
    LOCAL: 'local',
    REMOTE: 'remote',
    TIMEOUT: 'timeout'
};
var wsCloseCodesToCloseReasons = new Map([
    [WS_CLOSE_WELCOME_TIMEOUT, CloseReason.TIMEOUT],
    [WS_CLOSE_HEARTBEATS_MISSED, CloseReason.TIMEOUT],
    [WS_CLOSE_HELLO_FAILED, CloseReason.FAILED],
    [WS_CLOSE_SEND_FAILED, CloseReason.FAILED],
    [WS_CLOSE_NETWORK_CHANGED, CloseReason.TIMEOUT],
    [WS_CLOSE_SERVER_BUSY, CloseReason.BUSY],
    [WS_CLOSE_OPEN_TIMEOUT, CloseReason.TIMEOUT]
]);
/**
 * A {@link TwilioConnection} represents a WebSocket connection
 * to a Twilio Connections Messaging Protocol (TCMP) server.
 * @fires TwilioConnection#close
 * @fires TwilioConnection#error
 * @fires TwilioConnection#message
 * @fires TwilioConnection#open
 * @fires TwilioConnection#waiting
 */
var TwilioConnection = /** @class */ (function (_super) {
    __extends(TwilioConnection, _super);
    /**
     * Construct a {@link TwilioConnection}.
     * @param {string} serverUrl - TCMP server url
     * @param {TwilioConnectionOptions} options - {@link TwilioConnection} options
     */
    function TwilioConnection(serverUrl, options) {
        var _this = _super.call(this, 'early', states) || this;
        options = Object.assign({
            helloBody: null,
            maxConsecutiveFailedHellos: DEFAULT_MAX_CONSECUTIVE_FAILED_HELLOS,
            maxConsecutiveMissedHeartbeats: DEFAULT_MAX_CONSECUTIVE_MISSED_HEARTBEATS,
            requestedHeartbeatTimeout: DEFAULT_MAX_REQUESTED_HEARTBEAT_TIMEOUT,
            openTimeout: DEFAULT_OPEN_TIMEOUT,
            welcomeTimeout: DEFAULT_WELCOME_TIMEOUT,
            Log: Log,
            WebSocket: WebSocket
        }, options);
        var logLevels = buildLogLevels(options.logLevel);
        var log = new options.Log('default', _this, logLevels, options.loggerName);
        var networkMonitor = options.networkMonitor ? new NetworkMonitor(function () {
            var type = networkMonitor.type;
            var reason = "Network changed" + (type ? " to " + type : '');
            log.debug(reason);
            _this._close({ code: WS_CLOSE_NETWORK_CHANGED, reason: reason });
        }) : null;
        Object.defineProperties(_this, {
            _busyWaitTimeout: {
                value: null,
                writable: true
            },
            _consecutiveHeartbeatsMissed: {
                value: 0,
                writable: true
            },
            _cookie: {
                value: null,
                writable: true
            },
            _eventObserver: {
                value: options.eventObserver
            },
            _heartbeatTimeout: {
                value: null,
                writable: true
            },
            _hellosLeft: {
                value: options.maxConsecutiveFailedHellos,
                writable: true
            },
            _instanceId: {
                value: ++nInstances
            },
            _log: {
                value: log
            },
            _messageQueue: {
                value: []
            },
            _networkMonitor: {
                value: networkMonitor
            },
            _options: {
                value: options
            },
            _openTimeout: {
                value: null,
                writable: true
            },
            _sendHeartbeatTimeout: {
                value: null,
                writable: true
            },
            _serverUrl: {
                value: serverUrl
            },
            _welcomeTimeout: {
                value: null,
                writable: true
            },
            _ws: {
                value: null,
                writable: true
            }
        });
        var eventsToLevels = {
            connecting: 'info',
            early: 'info',
            open: 'info',
            waiting: 'warning',
            closed: 'info'
        };
        _this.on('stateChanged', function (state) {
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            if (state in events) {
                _this.emit.apply(_this, __spreadArray([events[state]], __read(args)));
            }
            var event = { name: state, group: 'signaling', level: eventsToLevels[_this.state] };
            if (state === 'closed') {
                var _a = __read(args, 1), reason = _a[0];
                event.payload = { reason: reason };
                event.level = reason === CloseReason.LOCAL ? 'info' : 'error';
            }
            _this._eventObserver.emit('event', event);
        });
        _this._eventObserver.emit('event', { name: _this.state, group: 'signaling', level: eventsToLevels[_this.state] });
        _this._connect();
        return _this;
    }
    TwilioConnection.prototype.toString = function () {
        return "[TwilioConnection #" + this._instanceId + ": " + this._ws.url + "]";
    };
    /**
     * Close the {@link TwilioConnection}.
     * @param {{code: number, reason: string}} event
     * @private
     */
    TwilioConnection.prototype._close = function (_a) {
        var code = _a.code, reason = _a.reason;
        if (this.state === 'closed') {
            return;
        }
        if (this._openTimeout) {
            this._openTimeout.clear();
        }
        if (this._welcomeTimeout) {
            this._welcomeTimeout.clear();
        }
        if (this._heartbeatTimeout) {
            this._heartbeatTimeout.clear();
        }
        if (this._sendHeartbeatTimeout) {
            this._sendHeartbeatTimeout.clear();
        }
        if (this._networkMonitor) {
            this._networkMonitor.stop();
        }
        if (this._busyWaitTimeout && code !== WS_CLOSE_BUSY_WAIT) {
            this._busyWaitTimeout.clear();
        }
        this._messageQueue.splice(0);
        var log = this._log;
        if (code === WS_CLOSE_NORMAL) {
            log.debug('Closed');
            this.transition('closed', null, [CloseReason.LOCAL]);
        }
        else {
            log.warn("Closed: " + code + " - " + reason);
            if (code !== WS_CLOSE_BUSY_WAIT) {
                this.transition('closed', null, [
                    wsCloseCodesToCloseReasons.get(code) || CloseReason.REMOTE
                ]);
            }
        }
        var readyState = this._ws.readyState;
        var WebSocket = this._options.WebSocket;
        if (readyState !== WebSocket.CLOSING && readyState !== WebSocket.CLOSED) {
            this._ws.close(code, reason);
        }
    };
    /**
     * Connect to the TCMP server.
     * @private
     */
    TwilioConnection.prototype._connect = function () {
        var _this = this;
        var log = this._log;
        if (this.state === 'waiting') {
            this.transition('early');
        }
        else if (this.state !== 'early') {
            log.warn("Unexpected state \"" + this.state + "\" for connecting to the"
                + ' TCMP server.');
            return;
        }
        this._ws = new this._options.WebSocket(this._serverUrl);
        var ws = this._ws;
        log.debug('Created a new WebSocket:', ws);
        ws.addEventListener('close', function (event) { return _this._close(event); });
        var openTimeout = this._options.openTimeout;
        // Add a timeout for getting the onopen event on the WebSocket (15 sec). After that, attempt to reconnect only if this is not the first attempt.
        this._openTimeout = new Timeout(function () {
            var reason = "Failed to open in " + openTimeout + " ms";
            _this._close({ code: WS_CLOSE_OPEN_TIMEOUT, reason: reason });
        }, openTimeout);
        ws.addEventListener('open', function () {
            log.debug('WebSocket opened:', ws);
            _this._openTimeout.clear();
            _this._startHandshake();
            if (_this._networkMonitor) {
                _this._networkMonitor.start();
            }
        });
        ws.addEventListener('message', function (message) {
            log.debug("Incoming: " + message.data);
            try {
                message = JSON.parse(message.data);
            }
            catch (error) {
                _this.emit('error', error);
                return;
            }
            switch (message.type) {
                case 'bad':
                    _this._handleBad(message);
                    break;
                case 'busy':
                    _this._handleBusy(message);
                    break;
                case 'bye':
                    // Do nothing.
                    break;
                case 'msg':
                    _this._handleMessage(message);
                // NOTE(mpatwardhan): Each incoming message should be treated as an incoming
                // heartbeat intentionally falling through to 'heartbeat' case.
                // eslint-disable-next-line no-fallthrough
                case 'heartbeat':
                    _this._handleHeartbeat();
                    break;
                case 'welcome':
                    _this._handleWelcome(message);
                    break;
                default:
                    _this._log.debug("Unknown message type: " + message.type);
                    _this.emit('error', new Error("Unknown message type: " + message.type));
                    break;
            }
        });
    };
    /**
     * Handle an incoming "bad" message.
     * @param {{reason: string}} message
     * @private
     */
    TwilioConnection.prototype._handleBad = function (_a) {
        var reason = _a.reason;
        var log = this._log;
        if (!['connecting', 'open'].includes(this.state)) {
            log.warn("Unexpected state \"" + this.state + "\" for handling a \"bad\" message"
                + ' from the TCMP server.');
            return;
        }
        if (this.state === 'connecting') {
            log.warn("Closing: " + WS_CLOSE_HELLO_FAILED + " - " + reason);
            this._close({ code: WS_CLOSE_HELLO_FAILED, reason: reason });
            return;
        }
        log.debug("Error: " + reason);
        this.emit('error', new Error(reason));
    };
    /**
     * Handle an incoming "busy" message.
     * @param {{cookie: ?string, keepAlive: boolean, retryAfter: number}} message
     * @private
     */
    TwilioConnection.prototype._handleBusy = function (_a) {
        var _this = this;
        var cookie = _a.cookie, keepAlive = _a.keepAlive, retryAfter = _a.retryAfter;
        var log = this._log;
        if (!['connecting', 'waiting'].includes(this.state)) {
            log.warn("Unexpected state \"" + this.state + "\" for handling a \"busy\" message"
                + ' from the TCMP server.');
            return;
        }
        if (this._busyWaitTimeout) {
            this._busyWaitTimeout.clear();
        }
        if (this._welcomeTimeout) {
            this._welcomeTimeout.clear();
        }
        var reason = retryAfter < 0
            ? 'Received terminal "busy" message'
            : "Received \"busy\" message, retrying after " + retryAfter + " ms";
        if (retryAfter < 0) {
            log.warn("Closing: " + WS_CLOSE_SERVER_BUSY + " - " + reason);
            this._close({ code: WS_CLOSE_SERVER_BUSY, reason: reason });
            return;
        }
        var maxConsecutiveFailedHellos = this._options.maxConsecutiveFailedHellos;
        this._hellosLeft = maxConsecutiveFailedHellos;
        this._cookie = cookie || null;
        if (keepAlive) {
            log.warn(reason);
            this._busyWaitTimeout = new Timeout(function () { return _this._startHandshake(); }, retryAfter);
        }
        else {
            log.warn("Closing: " + WS_CLOSE_BUSY_WAIT + " - " + reason);
            this._close({ code: WS_CLOSE_BUSY_WAIT, reason: reason });
            this._busyWaitTimeout = new Timeout(function () { return _this._connect(); }, retryAfter);
        }
        this.transition('waiting', null, [keepAlive, retryAfter]);
    };
    /**
     * Handle an incoming "heartbeat" message.
     * @private
     */
    TwilioConnection.prototype._handleHeartbeat = function () {
        if (this.state !== 'open') {
            this._log.warn("Unexpected state \"" + this.state + "\" for handling a \"heartbeat\""
                + ' message from the TCMP server.');
            return;
        }
        this._heartbeatTimeout.reset();
    };
    /**
     * Handle a missed "heartbeat" message.
     * @private
     */
    TwilioConnection.prototype._handleHeartbeatTimeout = function () {
        if (this.state !== 'open') {
            return;
        }
        var log = this._log;
        var maxConsecutiveMissedHeartbeats = this._options.maxConsecutiveMissedHeartbeats;
        log.debug("Consecutive heartbeats missed: " + maxConsecutiveMissedHeartbeats);
        var reason = "Missed " + maxConsecutiveMissedHeartbeats + " \"heartbeat\" messages";
        log.warn("Closing: " + WS_CLOSE_HEARTBEATS_MISSED + " - " + reason);
        this._close({ code: WS_CLOSE_HEARTBEATS_MISSED, reason: reason });
    };
    /**
     * Handle an incoming "msg" message.
     * @param {{body: object}} message
     * @private
     */
    TwilioConnection.prototype._handleMessage = function (_a) {
        var body = _a.body;
        if (this.state !== 'open') {
            this._log.warn("Unexpected state \"" + this.state + "\" for handling a \"msg\" message"
                + ' from the TCMP server.');
            return;
        }
        this.emit('message', body);
    };
    /**
     * Handle an incoming "welcome" message.
     * @param {{ negotiatedTimeout: number }} message
     * @private
     */
    TwilioConnection.prototype._handleWelcome = function (_a) {
        var _this = this;
        var negotiatedTimeout = _a.negotiatedTimeout;
        var log = this._log;
        if (!['connecting', 'waiting'].includes(this.state)) {
            log.warn("Unexpected state \"" + this.state + "\" for handling a \"welcome\""
                + ' message from the TCMP server.');
            return;
        }
        if (this.state === 'waiting') {
            log.debug('Received "welcome" message, no need to retry connection.');
            this._busyWaitTimeout.clear();
        }
        var maxConsecutiveMissedHeartbeats = this._options.maxConsecutiveMissedHeartbeats;
        var heartbeatTimeout = negotiatedTimeout * maxConsecutiveMissedHeartbeats;
        var outgoingHeartbeatTimeout = negotiatedTimeout - OUTGOING_HEARTBEAT_OFFSET;
        this._welcomeTimeout.clear();
        this._heartbeatTimeout = new Timeout(function () { return _this._handleHeartbeatTimeout(); }, heartbeatTimeout);
        this._messageQueue.splice(0).forEach(function (message) { return _this._send(message); });
        this._sendHeartbeatTimeout = new Timeout(function () { return _this._sendHeartbeat(); }, outgoingHeartbeatTimeout);
        this.transition('open');
    };
    /**
     * Handle a missed "welcome" message.
     * @private
     */
    TwilioConnection.prototype._handleWelcomeTimeout = function () {
        if (this.state !== 'connecting') {
            return;
        }
        var log = this._log;
        if (this._hellosLeft <= 0) {
            var reason = 'All handshake attempts failed';
            log.warn("Closing: " + WS_CLOSE_WELCOME_TIMEOUT + " - " + reason);
            this._close({ code: WS_CLOSE_WELCOME_TIMEOUT, reason: reason });
            return;
        }
        var maxConsecutiveFailedHellos = this._options.maxConsecutiveFailedHellos;
        log.warn("Handshake attempt " + (maxConsecutiveFailedHellos - this._hellosLeft) + " failed");
        this._startHandshake();
    };
    /**
     * Send a message to the TCMP server.
     * @param {*} message
     * @private
     */
    TwilioConnection.prototype._send = function (message) {
        var readyState = this._ws.readyState;
        var WebSocket = this._options.WebSocket;
        if (readyState === WebSocket.OPEN) {
            var data = JSON.stringify(message);
            this._log.debug("Outgoing: " + data);
            try {
                this._ws.send(data);
                if (this._sendHeartbeatTimeout) {
                    // Each outgoing message is to be treated as an outgoing heartbeat.
                    this._sendHeartbeatTimeout.reset();
                }
            }
            catch (error) {
                var reason = 'Failed to send message';
                this._log.warn("Closing: " + WS_CLOSE_SEND_FAILED + " - " + reason);
                this._close({ code: WS_CLOSE_SEND_FAILED, reason: reason });
            }
        }
    };
    /**
     * Send a "heartbeat" message.
     * @private
     */
    TwilioConnection.prototype._sendHeartbeat = function () {
        if (this.state === 'closed') {
            return;
        }
        this._send({ type: 'heartbeat' });
    };
    /**
     * Send a "hello" message.
     * @private
     */
    TwilioConnection.prototype._sendHello = function () {
        var _a = this._options, helloBody = _a.helloBody, timeout = _a.requestedHeartbeatTimeout;
        var hello = {
            id: makeUUID(),
            timeout: timeout,
            type: 'hello',
            version: TCMP_VERSION
        };
        if (this._cookie) {
            hello.cookie = this._cookie;
        }
        if (helloBody) {
            hello.body = helloBody;
        }
        this._send(hello);
    };
    /**
     * Send or enqueue a message.
     * @param {*} message
     * @private
     */
    TwilioConnection.prototype._sendOrEnqueue = function (message) {
        var _this = this;
        if (this.state === 'closed') {
            return;
        }
        var sendOrEnqueue = this.state === 'open'
            ? function (message) { return _this._send(message); }
            : function (message) { return _this._messageQueue.push(message); };
        sendOrEnqueue(message);
    };
    /**
     * Start the TCMP handshake.
     * @private
     */
    TwilioConnection.prototype._startHandshake = function () {
        var _this = this;
        if (['early', 'waiting'].includes(this.state)) {
            this.transition('connecting');
        }
        if (this.state !== 'connecting') {
            return;
        }
        this._hellosLeft--;
        this._sendHello();
        var welcomeTimeout = this._options.welcomeTimeout;
        this._welcomeTimeout = new Timeout(function () { return _this._handleWelcomeTimeout(); }, welcomeTimeout);
    };
    /**
     * Close the {@link TwilioConnection}.
     * @returns {void}
     */
    TwilioConnection.prototype.close = function () {
        if (this.state === 'closed') {
            return;
        }
        this._sendOrEnqueue({ type: 'bye' });
        this._close({ code: WS_CLOSE_NORMAL, reason: 'Normal' });
    };
    /**
     * Send a "msg" message.
     * @param {*} body
     * @returns {void}
     */
    TwilioConnection.prototype.sendMessage = function (body) {
        this._sendOrEnqueue({ body: body, type: 'msg' });
    };
    return TwilioConnection;
}(StateMachine));
/**
 * A unique string depicting the reason for the {@link TwilioConnection} being closed.
 * @enum {string}
 */
TwilioConnection.CloseReason = CloseReason;
/**
 * A {@link TwilioConnection} was closed.
 * @event TwilioConnection#close
 * @param {CloseReason} reason - The reason for the {@link TwilioConnection} being closed
 */
/**
 * A {@link TwilioConnection} received an error from the TCMP server.
 * @event TwilioConnection#error
 * @param {Error} error - The TCMP server error
 */
/**
 * A {@link TwilioConnection} received a message from the TCMP server.
 * @event TwilioConnection#message
 * @param {*} body - Message body
 */
/**
 * A {@link TwilioConnection} completed a hello/welcome handshake with the TCMP server.
 * @event TwilioConnection#open
 */
/**
 * A {@link TwilioConnection} received a "busy" message from the TCMP server.
 * @event TwilioConnection#waiting
 * @param {boolean} keepAlive - true if the WebSocket connection is retained
 * @param {number} retryAfter - delay in milliseconds after which a retry is attempted
 */
/**
 * {@link TwilioConnection} options
 * @typedef {object} TwilioConnectionOptions
 * @property {EventObserver} [eventObserver] - Optional event observer
 * @property {*} [helloBody=null] - Optional body for "hello" message
 * @property {LogLevel} [logLevel=warn] - Log level of the {@link TwilioConnection}
 * @property {number} [maxConsecutiveFailedHellos=3] - Max. number of consecutive failed "hello"s
 * @property {number} [maxConsecutiveMissedHeartbeats=3] - Max. number of (effective) consecutive "heartbeat" messages that can be missed
 * @property {number} [requestedHeartbeatTimeout=5000] - "heartbeat" timeout (ms) requested by the {@link TwilioConnection}
 * @property {number} [welcomeTimeout=5000] - Time (ms) to wait for the "welcome" message after sending the "hello" message
 */
module.exports = TwilioConnection;

},{"./statemachine":89,"./util":133,"./util/log":137,"./util/networkmonitor":139,"./util/timeout":147,"ws":176}],122:[function(require,module,exports){
'use strict';
var defer = require('./').defer;
/**
 * An {@link AsyncVar} is an "asynchronous variable" which may or may not
 * contain a value of some type T. You can put a value into the {@link AsyncVar}
 * with {@link AsyncVar#put}. Callers can take a value out of the
 * {@link AsyncVar} by queueing up with {@link AsyncVar#take}. N calls to
 * {@link AsyncVar#take} require N calls to {@link AsyncVar#put} to resolve, and
 * they resolve in order.
 */
var AsyncVar = /** @class */ (function () {
    /**
     * Construct an {@link AsyncVar}.
     */
    function AsyncVar() {
        Object.defineProperties(this, {
            _deferreds: {
                value: []
            },
            _hasValue: {
                value: false,
                writable: true
            },
            _value: {
                value: null,
                writable: true
            }
        });
    }
    /**
     * Put a value into the {@link AsyncVar}.
     * @param {T} value
     * @returns {this}
     */
    AsyncVar.prototype.put = function (value) {
        this._hasValue = true;
        this._value = value;
        var deferred = this._deferreds.shift();
        if (deferred) {
            deferred.resolve(value);
        }
        return this;
    };
    /**
     * Take the value out of the {@link AsyncVar}.
     * @returns {Promise<T>}
     */
    AsyncVar.prototype.take = function () {
        var _this = this;
        if (this._hasValue && !this._deferreds.length) {
            this._hasValue = false;
            return Promise.resolve(this._value);
        }
        var deferred = defer();
        this._deferreds.push(deferred);
        return deferred.promise.then(function (value) {
            _this._hasValue = false;
            return value;
        });
    };
    return AsyncVar;
}());
module.exports = AsyncVar;

},{"./":133}],123:[function(require,module,exports){
/**
 * Expose `Backoff`.
 */
var Backoff = /** @class */ (function () {
    /**
     * Construct a {@link Backoff}.
     * @param {object} options
     * @property {number} min - Initial timeout in milliseconds [100]
     * @property {number} max - Max timeout [10000]
     * @property {boolean} jitter - Apply jitter [0]
     * @property {number} factor - Multiplication factor for Backoff operation [2]
     */
    function Backoff(options) {
        Object.defineProperties(this, {
            _min: {
                value: options.min || 100
            },
            _max: {
                value: options.max || 10000
            },
            _jitter: {
                value: options.jitter > 0 && options.jitter <= 1 ? options.jitter : 0
            },
            _factor: {
                value: options.factor || 2
            },
            _attempts: {
                value: 0,
                writable: true
            },
            _duration: {
                enumerable: false,
                get: function () {
                    var ms = this._min * Math.pow(this._factor, this._attempts);
                    if (this._jitter) {
                        var rand = Math.random();
                        var deviation = Math.floor(rand * this._jitter * ms);
                        ms = (Math.floor(rand * 10) & 1) === 0 ? ms - deviation : ms + deviation;
                    }
                    return Math.min(ms, this._max) | 0;
                }
            },
            _timeoutID: {
                value: null,
                writable: true
            }
        });
    }
    /**
    * Start the backoff operation.
    * @param {function} fn - Function to call
    * @return {void}
    * @api public
    */
    Backoff.prototype.backoff = function (fn) {
        var _this = this;
        var duration = this._duration;
        if (this._timeoutID) {
            clearTimeout(this._timeoutID);
            this._timeoutID = null;
        }
        this._timeoutID = setTimeout(function () {
            _this._attempts++;
            fn();
        }, duration);
    };
    /**
    * Reset the number of attempts and clear the timer.
    *
    * @return {void}
    * @api public
    */
    Backoff.prototype.reset = function () {
        this._attempts = 0;
        if (this._timeoutID) {
            clearTimeout(this._timeoutID);
            this._timeoutID = null;
        }
    };
    return Backoff;
}());
module.exports = Backoff;

},{}],124:[function(require,module,exports){
/* globals chrome, navigator */
'use strict';
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
/**
 * Check whether the current browser is an Android device.
 * @returns {boolean}
 */
function isAndroid() {
    return /Android/.test(navigator.userAgent);
}
/**
 * Detects whether or not a device is an Apple touch screen device.
 * @returns {boolean}
 */
function hasTouchScreen() {
    return !!(navigator && navigator.maxTouchPoints && navigator.maxTouchPoints > 2);
}
/**
 * Detects whether or not a device is an iPad.
 * @returns {boolean}
 */
function isIpad() {
    return hasTouchScreen() && window.screen.width >= 744 && (/Macintosh/i.test(navigator.userAgent)
        || /iPad/.test(navigator.userAgent)
        || /iPad/.test(navigator.platform));
}
/**
 * Detects whether or not a device is an iPhone.
 * @returns {boolean}
 */
function isIphone() {
    return hasTouchScreen() && window.screen.width <= 476 && (/Macintosh/i.test(navigator.userAgent)
        || /iPhone/.test(navigator.userAgent)
        || /iPhone/.test(navigator.platform));
}
/**
 * Check whether the current device is an iOS device.
 * @returns {boolean}
 */
function isIOS() {
    return isIpad() || isIphone();
}
/**
 * Check whether the current browser is a mobile browser
 * @returns {boolean}
 */
function isMobile() {
    return /Mobi/.test(navigator.userAgent);
}
/**
 * Check whether the current browser is non-Chromium Edge.
 * @param {string} browser
 * @returns {boolean}
 */
function isNonChromiumEdge(browser) {
    return browser === 'chrome' && /Edge/.test(navigator.userAgent) && (typeof chrome === 'undefined' || typeof chrome.runtime === 'undefined');
}
/**
 * Get the name of the rebranded Chromium browser, if any. Re-branded Chrome's user
 * agent has the following format:
 * <source>/<version> (<os>) <engine>/<version> (<engine_name>) Chrome/<version> [Mobile] Safari/<version>
 * @param browser
 * @returns {?string} Name of the rebranded Chrome browser, or null if the browser
 *   is either not Chrome or vanilla Chrome.
 */
function rebrandedChromeBrowser(browser) {
    // If the browser is not Chrome based, then it is not a rebranded Chrome browser.
    if (browser !== 'chrome') {
        return null;
    }
    // Latest desktop Brave browser has a "brave" property in navigator.
    if ('brave' in navigator) {
        return 'brave';
    }
    // Remove the "(.+)" entries from the user agent thereby retaining only the
    // <name>[/<version>] entries.
    var parenthesizedSubstrings = getParenthesizedSubstrings(navigator.userAgent);
    var nameAndVersions = parenthesizedSubstrings.reduce(function (userAgent, substring) { return userAgent.replace(substring, ''); }, navigator.userAgent);
    // Extract the potential browser <name>s by ignoring the first two names, which
    // point to <source> and <engine>.
    var matches = nameAndVersions.match(/[^\s]+/g) || [];
    var _a = __read(matches.map(function (nameAndVersion) {
        return nameAndVersion.split('/')[0].toLowerCase();
    })), browserNames = _a.slice(2);
    // Extract the <name> that is not expected to be present in the vanilla Chrome
    // browser, which indicates the rebranded name (ex: "edg[e]", "electron"). If null,
    // then this is a vanilla Chrome browser.
    return browserNames.find(function (name) {
        return !['chrome', 'mobile', 'safari'].includes(name);
    }) || null;
}
/**
 * Get the name of the mobile webkit based browser, if any.
 * @param browser
 * @returns {?string} Name of the mobile webkit based browser, or null if the browser
 *   is either not webkit based or mobile safari.
 */
function mobileWebKitBrowser(browser) {
    if (browser !== 'safari') {
        return null;
    }
    if ('brave' in navigator) {
        return 'brave';
    }
    return ['edge', 'edg'].find(function (name) {
        return navigator.userAgent.toLowerCase().includes(name);
    }) || null;
}
/**
 * Get the top level parenthesized substrings within a given string. Unmatched
 * parentheses are ignored.
 * Ex: "abc) (def) gh(ij) (kl (mn)o) (pqr" => ["(def)", "(ij)", "(kl (mn)o)"]
 * @param {string} string
 * @returns {string[]}
 */
function getParenthesizedSubstrings(string) {
    var openParenthesisPositions = [];
    var substrings = [];
    for (var i = 0; i < string.length; i++) {
        if (string[i] === '(') {
            openParenthesisPositions.push(i);
        }
        else if (string[i] === ')' && openParenthesisPositions.length > 0) {
            var openParenthesisPosition = openParenthesisPositions.pop();
            if (openParenthesisPositions.length === 0) {
                substrings.push(string.substring(openParenthesisPosition, i + 1));
            }
        }
    }
    return substrings;
}
module.exports = {
    isAndroid: isAndroid,
    isIOS: isIOS,
    isIpad: isIpad,
    isIphone: isIphone,
    isMobile: isMobile,
    isNonChromiumEdge: isNonChromiumEdge,
    mobileWebKitBrowser: mobileWebKitBrowser,
    rebrandedChromeBrowser: rebrandedChromeBrowser
};

},{}],125:[function(require,module,exports){
'use strict';
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
/**
 * A Promise that can be canceled with {@link CancelablePromise#cancel}.
 * @extends Promise
*/
var CancelablePromise = /** @class */ (function () {
    /**
     * Construct a new {@link CancelablePromise}.
     * @param {CancelablePromise.OnCreate} onCreate
     * @param {CancelablePromise.OnCancel} onCancel
    */ /**
     * A function to be called on {@link CancelablePromise} creation
     * @typedef {function} CancelablePromise.OnCreate
     * @param {function(*)} resolve
     * @param {function(*)} reject
     * @param {function(): boolean} isCanceled
    */ /**
     * A function to be called when {@link CancelablePromise#cancel} is called
     * @typedef {function} CancelablePromise.OnCancel
     */
    function CancelablePromise(onCreate, onCancel) {
        var _this = this;
        /* istanbul ignore next */
        Object.defineProperties(this, {
            _isCancelable: {
                writable: true,
                value: true
            },
            _isCanceled: {
                writable: true,
                value: false
            },
            _onCancel: {
                value: onCancel
            }
        });
        Object.defineProperty(this, '_promise', {
            value: new Promise(function (resolve, reject) {
                onCreate(function (value) {
                    _this._isCancelable = false;
                    resolve(value);
                }, function (reason) {
                    _this._isCancelable = false;
                    reject(reason);
                }, function () { return _this._isCanceled; });
            })
        });
    }
    /**
     * Create a synchronously-rejected {@link CancelablePromise}.
     * @param {*} reason
     * @returns {Promise<*>}
     */
    CancelablePromise.reject = function (reason) {
        return new CancelablePromise(function rejected(resolve, reject) {
            reject(reason);
        }, function onCancel() {
            // Do nothing.
        });
    };
    /**
     * Create a synchronously-resolved {@link CancelablePromise}.
     * @param {*|Promise<*>|Thenable<*>} result
     * @returns {CancelablePromise<*>}
     */
    CancelablePromise.resolve = function (result) {
        return new CancelablePromise(function resolved(resolve) {
            resolve(result);
        }, function onCancel() {
            // Do nothing.
        });
    };
    /**
     * Attempt to cancel the {@link CancelablePromise}.
     * @returns {this}
     */
    CancelablePromise.prototype.cancel = function () {
        if (this._isCancelable) {
            this._isCanceled = true;
            this._onCancel();
        }
        return this;
    };
    /**
     * @param {function} onRejected
     * @returns {CancelablePromise}
     */
    CancelablePromise.prototype.catch = function () {
        var args = [].slice.call(arguments);
        var promise = this._promise;
        return new CancelablePromise(function onCreate(resolve, reject) {
            promise.catch.apply(promise, __spreadArray([], __read(args))).then(resolve, reject);
        }, this._onCancel);
    };
    /**
     * @param {?function} onResolved
     * @param {function} [onRejected]
     * @returns {CancelablePromise}
     */
    CancelablePromise.prototype.then = function () {
        var args = [].slice.call(arguments);
        var promise = this._promise;
        return new CancelablePromise(function onCreate(resolve, reject) {
            promise.then.apply(promise, __spreadArray([], __read(args))).then(resolve, reject);
        }, this._onCancel);
    };
    /**
   * @param {?function} onFinally
   * @returns {CancelablePromise}
   */
    CancelablePromise.prototype.finally = function () {
        var args = [].slice.call(arguments);
        var promise = this._promise;
        return new CancelablePromise(function onCreate(resolve, reject) {
            promise.finally.apply(promise, __spreadArray([], __read(args))).then(resolve, reject);
        }, this._onCancel);
    };
    return CancelablePromise;
}());
module.exports = CancelablePromise;

},{}],126:[function(require,module,exports){
'use strict';
/* eslint-disable camelcase */
var packageInfo = require('../../package.json');
module.exports.SDK_NAME = packageInfo.name + ".js";
module.exports.SDK_VERSION = packageInfo.version;
module.exports.SDP_FORMAT = 'unified';
module.exports.hardwareDevicePublisheriPad = {
    hwDeviceManufacturer: 'Apple',
    hwDeviceModel: 'iPad',
    hwDeviceType: 'tablet',
    platformName: 'iOS'
};
module.exports.hardwareDevicePublisheriPhone = {
    hwDeviceManufacturer: 'Apple',
    hwDeviceModel: 'iPhone',
    hwDeviceType: 'mobile',
    platformName: 'iOS'
};
module.exports.DEFAULT_ENVIRONMENT = 'prod';
module.exports.DEFAULT_REALM = 'us1';
module.exports.DEFAULT_REGION = 'gll';
module.exports.DEFAULT_LOG_LEVEL = 'warn';
module.exports.DEFAULT_LOGGER_NAME = 'twilio-video';
module.exports.WS_SERVER = function (environment, region) {
    region = region === 'gll' ? 'global' : encodeURIComponent(region);
    return environment === 'prod'
        ? "wss://" + region + ".vss.twilio.com/signaling"
        : "wss://" + region + ".vss." + environment + ".twilio.com/signaling";
};
module.exports.PUBLISH_MAX_ATTEMPTS = 5;
module.exports.PUBLISH_BACKOFF_JITTER = 10;
module.exports.PUBLISH_BACKOFF_MS = 20;
/**
 * Returns the appropriate indefinite article ("a" | "an").
 * @param {string} word - The word which determines whether "a" | "an" is returned
 * @returns {string} "a" if word's first letter is a vowel, "an" otherwise
 */
function article(word) {
    // NOTE(mmalavalli): This will not be accurate for words like "hour",
    // which have consonants as their first character, but are pronounced like
    // vowels. We can address this issue if the need arises.
    return ['a', 'e', 'i', 'o', 'u'].includes(word.toLowerCase()[0]) ? 'an' : 'a';
}
module.exports.typeErrors = {
    ILLEGAL_INVOKE: function (name, context) {
        return new TypeError("Illegal call to " + name + ": " + context);
    },
    INVALID_TYPE: function (name, type) {
        return new TypeError(name + " must be " + article(type) + " " + type);
    },
    INVALID_VALUE: function (name, values) {
        return new RangeError(name + " must be one of " + values.join(', '));
    },
    REQUIRED_ARGUMENT: function (name) {
        return new TypeError(name + " must be specified");
    }
};
module.exports.DEFAULT_FRAME_RATE = 24;
module.exports.DEFAULT_VIDEO_PROCESSOR_STATS_INTERVAL_MS = 10000;
module.exports.DEFAULT_ICE_GATHERING_TIMEOUT_MS = 15000;
module.exports.DEFAULT_SESSION_TIMEOUT_SEC = 30;
module.exports.DEFAULT_NQ_LEVEL_LOCAL = 1;
module.exports.DEFAULT_NQ_LEVEL_REMOTE = 0;
module.exports.MAX_NQ_LEVEL = 3;
module.exports.ICE_ACTIVITY_CHECK_PERIOD_MS = 1000;
module.exports.ICE_INACTIVITY_THRESHOLD_MS = 3000;
module.exports.iceRestartBackoffConfig = {
    factor: 1.1,
    min: 1,
    max: module.exports.DEFAULT_SESSION_TIMEOUT_SEC * 1000,
    jitter: 1
};
module.exports.reconnectBackoffConfig = {
    factor: 1.5,
    min: 80,
    jitter: 1
};
module.exports.subscriptionMode = {
    MODE_COLLABORATION: 'collaboration',
    MODE_GRID: 'grid',
    MODE_PRESENTATION: 'presentation'
};
module.exports.trackSwitchOffMode = {
    MODE_DISABLED: 'disabled',
    MODE_DETECTED: 'detected',
    MODE_PREDICTED: 'predicted'
};
module.exports.trackPriority = {
    PRIORITY_HIGH: 'high',
    PRIORITY_LOW: 'low',
    PRIORITY_STANDARD: 'standard'
};
module.exports.clientTrackSwitchOffControl = {
    MODE_AUTO: 'auto',
    MODE_MANUAL: 'manual'
};
module.exports.videoContentPreferencesMode = {
    MODE_AUTO: 'auto',
    MODE_MANUAL: 'manual'
};

},{"../../package.json":175}],127:[function(require,module,exports){
'use strict';
var detectSilence = require('../webaudio/detectsilence');
var N_ATTEMPTS = 3;
var ATTEMPT_DURATION_MS = 250;
/**
 * Detect whether the audio stream rendered by the given HTMLVideoElement is silent.
 * @param {HTMLAudioElement} el
 * @returns {Promise<boolean>} true if silent, false if not.
 */
function detectSilentAudio(el) {
    // NOTE(mmalavalli): We have to delay require-ing AudioContextFactory, because
    // it exports a default instance whose constructor calls Object.assign.
    var AudioContextFactory = require('../webaudio/audiocontext');
    var holder = {};
    var audioContext = AudioContextFactory.getOrCreate(holder);
    var attemptsLeft = N_ATTEMPTS;
    function doCheckSilence() {
        attemptsLeft--;
        return detectSilence(audioContext, el.srcObject, ATTEMPT_DURATION_MS).then(function (isSilent) {
            if (!isSilent) {
                return false;
            }
            if (attemptsLeft > 0) {
                return doCheckSilence();
            }
            return true;
        }).catch(function () {
            // NOTE(mmalavalli): If an error is thrown while detect silence, the audio
            // stream is assumed to be silent.
            return true;
        });
    }
    // Resolve the returned Promise with true if 3 consecutive attempts
    // to detect silent audio are successful.
    return doCheckSilence().finally(function () {
        AudioContextFactory.release(holder);
    });
}
module.exports = detectSilentAudio;

},{"../webaudio/audiocontext":154,"../webaudio/detectsilence":155}],128:[function(require,module,exports){
'use strict';
// Cached copy of the <canvas> used to check silent video frames.
var canvas = null;
var N_SAMPLES = 3;
var SAMPLE_HEIGHT = 50;
var SAMPLE_INTERVAL_MS = 250;
var SAMPLE_WIDTH = 50;
/**
 * Check whether the current video frame is silent by selecting a 50x50
 * sample and calculating the max value of the pixel data. If it is 0, then
 * the frame is considered to be silent.
 * @private
 * @param {HTMLVideoElement} el
 * @returns {boolean} true if silent, false if not
 */
function checkSilence(el) {
    try {
        var context = canvas.getContext('2d');
        context.drawImage(el, 0, 0, SAMPLE_WIDTH, SAMPLE_HEIGHT);
        var frame = context.getImageData(0, 0, SAMPLE_WIDTH, SAMPLE_HEIGHT);
        var frameDataWithoutAlpha = frame.data.filter(function (item, i) { return (i + 1) % 4; });
        var max = Math.max.apply(Math, frameDataWithoutAlpha);
        return max === 0;
    }
    catch (ex) {
        // eslint-disable-next-line no-console
        console.log('Error checking silence: ', ex);
        return false;
    }
}
/**
 * Detect whether the video stream rendered by the given HTMLVideoElement is silent.
 * @param {HTMLVideoElement} el
 * @returns {Promise<boolean>} true if silent, false if not.
 */
function detectSilentVideo(el) {
    // Create the canvas when detectSilentVideo() is called for the
    // first time.
    canvas = canvas || document.createElement('canvas');
    // Resolve the returned Promise with true if 3 consecutive sample
    // frames from the video being played by the HTMLVideoElement are
    // silent.
    return new Promise(function (resolve) {
        var samplesLeft = N_SAMPLES;
        setTimeout(function doCheckSilence() {
            samplesLeft--;
            if (!checkSilence(el)) {
                return resolve(false);
            }
            if (samplesLeft > 0) {
                return setTimeout(doCheckSilence, SAMPLE_INTERVAL_MS);
            }
            return resolve(true);
        }, SAMPLE_INTERVAL_MS);
    });
}
module.exports = detectSilentVideo;

},{}],129:[function(require,module,exports){
'use strict';
/**
 * The {@link DocumentVisibilityMonitor} monitors the visibility state of the DOM
 * and executes the attached listeners in phase order when the DOM is visible.
 */
var DocumentVisibilityMonitor = /** @class */ (function () {
    /**
     * Constructor.
     * @param {number} [nPhases=1] - the number of phases
     */
    function DocumentVisibilityMonitor(nPhases) {
        var _this = this;
        if (nPhases === void 0) { nPhases = 1; }
        Object.defineProperties(this, {
            _listeners: {
                value: []
            },
            _onVisibilityChange: {
                value: function () {
                    _this._emitVisible(document.visibilityState === 'visible');
                }
            }
        });
        for (var i = 0; i < nPhases; i++) {
            this._listeners.push([]);
        }
    }
    /**
     * clears the state.
     */
    DocumentVisibilityMonitor.prototype.clear = function () {
        var nPhases = this._listeners.length;
        for (var i = 0; i < nPhases; i++) {
            this._listeners[i] = [];
        }
    };
    DocumentVisibilityMonitor.prototype._listenerCount = function () {
        return this._listeners.reduce(function (count, phaseListeners) { return count + phaseListeners.length; }, 0);
    };
    /**
     * Call all the listeners. Makes sure that all listeners for a given phase
     * are executed before calling the listeners of the next phase.
     * @private
     */
    DocumentVisibilityMonitor.prototype._emitVisible = function (isVisible) {
        var _this = this;
        var promise = Promise.resolve();
        var _loop_1 = function (phase) {
            promise = promise.then(function () { return _this._emitVisiblePhase(phase, isVisible); });
        };
        for (var phase = 1; phase <= this._listeners.length; phase++) {
            _loop_1(phase);
        }
        return promise;
    };
    /**
     * Call all the listeners for a given phase.
     * @private
     */
    DocumentVisibilityMonitor.prototype._emitVisiblePhase = function (phase, isVisible) {
        var phaseListeners = this._listeners[phase - 1];
        return Promise.all(phaseListeners.map(function (listener) {
            var ret = listener(isVisible);
            return ret instanceof Promise ? ret : Promise.resolve(ret);
        }));
    };
    /**
     * Start listening to the DOM visibility state change.
     * @private
     */
    DocumentVisibilityMonitor.prototype._start = function () {
        document.addEventListener('visibilitychange', this._onVisibilityChange);
    };
    /**
     * Stop listening to the DOM visibility state change.
     * @private
     */
    DocumentVisibilityMonitor.prototype._stop = function () {
        document.removeEventListener('visibilitychange', this._onVisibilityChange);
    };
    /**
     * Listen for the DOM visibility changes at the given phase.
     * @param {number} phase
     * @param {function} listener
     * @returns {this}
     */
    DocumentVisibilityMonitor.prototype.onVisibilityChange = function (phase, listener) {
        if (typeof phase !== 'number' || phase <= 0 || phase > this._listeners.length) {
            throw new Error('invalid phase: ', phase);
        }
        var phaseListeners = this._listeners[phase - 1];
        phaseListeners.push(listener);
        if (this._listenerCount() === 1) {
            this._start();
        }
        return this;
    };
    /**
     * Stop listening for the DOM visibility change at the given phase.
     * @param {number} phase
     * @param {function} listener
     * @returns {this}
     */
    DocumentVisibilityMonitor.prototype.offVisibilityChange = function (phase, listener) {
        if (typeof phase !== 'number' || phase <= 0 || phase > this._listeners.length) {
            throw new Error('invalid phase: ', phase);
        }
        var phaseListeners = this._listeners[phase - 1];
        var index = phaseListeners.indexOf(listener);
        if (index !== -1) {
            phaseListeners.splice(index, 1);
            if (this._listenerCount() === 0) {
                this._stop();
            }
        }
        return this;
    };
    return DocumentVisibilityMonitor;
}());
module.exports = new DocumentVisibilityMonitor(2);

},{}],130:[function(require,module,exports){
'use strict';
module.exports = (function (scope) {
    var location = scope.location, URL = scope.URL;
    if ([location, URL].some(function (api) { return !api; })) {
        return function dynamicImportNotSupported(module) {
            return Promise.reject(new Error("Failed to import: " + module + ": dynamicImport is not supported"));
        };
    }
    scope.__twilioVideoImportedModules = {
    // Imported module map.
    };
    return function dynamicImport(module) {
        if (module in scope.__twilioVideoImportedModules) {
            return Promise.resolve(scope.__twilioVideoImportedModules[module]);
        }
        // NOTE(mmalavalli): Calling import() directly can cause build issues in TypeScript and Webpack
        // (and probably other frameworks). So, we create a Function that calls import() in its body.
        // eslint-disable-next-line no-new-func
        return new Function('scope', "return import('" + new URL(module, location) + "').then(m => scope.__twilioVideoImportedModules['" + module + "'] = m);")(scope);
    };
}(globalThis));

},{}],131:[function(require,module,exports){
/* eslint-disable no-console */
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var EventEmitter = require('events').EventEmitter;
var VALID_GROUPS = [
    'signaling',
    'room',
    'media',
    'quality',
    'video-processor',
    'preflight'
];
var VALID_LEVELS = [
    'debug',
    'error',
    'info',
    'warning'
];
/**
 * EventObserver listens to SDK events and re-emits them on the
 * @link EventListener} with some additional information.
 * @extends EventEmitter
 * @emits EventObserver#event
 */
var EventObserver = /** @class */ (function (_super) {
    __extends(EventObserver, _super);
    /**
     * Constructor.
     * @param {InsightsPublisher} publisher
     * @param {number} connectTimestamp
     * @param {Log} log
     * @param {EventListener} [eventListener]
     */
    function EventObserver(publisher, connectTimestamp, log, eventListener) {
        if (eventListener === void 0) { eventListener = null; }
        var _this = _super.call(this) || this;
        _this.on('event', function (_a) {
            var name = _a.name, group = _a.group, level = _a.level, payload = _a.payload;
            if (typeof name !== 'string') {
                log.error('Unexpected name: ', name);
                throw new Error('Unexpected name: ', name);
            }
            if (!VALID_GROUPS.includes(group)) {
                log.error('Unexpected group: ', group);
                throw new Error('Unexpected group: ', group);
            }
            if (!VALID_LEVELS.includes(level)) {
                log.error('Unexpected level: ', level);
                throw new Error('Unexpected level: ', level);
            }
            var timestamp = Date.now();
            var elapsedTime = timestamp - connectTimestamp;
            var publisherPayload = Object.assign({ elapsedTime: elapsedTime, level: level }, payload ? payload : {});
            publisher.publish(group, name, publisherPayload);
            var event = Object.assign({
                elapsedTime: elapsedTime,
                group: group,
                level: level,
                name: name,
                timestamp: timestamp
            }, payload ? { payload: payload } : {});
            var logLevel = {
                debug: 'debug',
                error: 'error',
                info: 'info',
                warning: 'warn',
            }[level];
            log[logLevel]('event', event);
            if (eventListener && group === 'signaling') {
                eventListener.emit('event', event);
            }
        });
        return _this;
    }
    return EventObserver;
}(EventEmitter));
/**
 * An SDK event.
 * @event EventObserver#event
 * @param {{name: string, payload: *}} event
 */
module.exports = EventObserver;

},{"events":174}],132:[function(require,module,exports){
'use strict';
var Filter = /** @class */ (function () {
    function Filter(options) {
        options = Object.assign({
            getKey: function defaultGetKey(a) { return a; },
            getValue: function defaultGetValue(a) { return a; },
            isLessThanOrEqualTo: function defaultIsLessThanOrEqualTo(a, b) { return a <= b; }
        }, options);
        Object.defineProperties(this, {
            _getKey: {
                value: options.getKey
            },
            _getValue: {
                value: options.getValue
            },
            _isLessThanOrEqualTo: {
                value: options.isLessThanOrEqualTo
            },
            _map: {
                value: new Map()
            }
        });
    }
    Filter.prototype.toMap = function () {
        return new Map(this._map);
    };
    Filter.prototype.updateAndFilter = function (entries) {
        return entries.filter(this.update, this);
    };
    Filter.prototype.update = function (entry) {
        var key = this._getKey(entry);
        var value = this._getValue(entry);
        if (this._map.has(key) &&
            this._isLessThanOrEqualTo(value, this._map.get(key))) {
            return false;
        }
        this._map.set(key, value);
        return true;
    };
    return Filter;
}());
module.exports = Filter;

},{}],133:[function(require,module,exports){
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var constants = require('./constants');
var E = constants.typeErrors, trackPriority = constants.trackPriority;
var util = require('../webrtc/util');
var sessionSID = require('./sid').sessionSID;
var TwilioWarning = require('./twiliowarning');
/**
 * Return the given {@link LocalTrack} or a new {@link LocalTrack} for the
 * given MediaStreamTrack.
 * @param {LocalTrack|MediaStreamTrack} track
 * @param {object} options
 * @returns {LocalTrack}
 * @throws {TypeError}
 */
function asLocalTrack(track, options) {
    if (track instanceof options.LocalAudioTrack
        || track instanceof options.LocalVideoTrack
        || track instanceof options.LocalDataTrack) {
        return track;
    }
    if (track instanceof options.MediaStreamTrack) {
        return track.kind === 'audio'
            ? new options.LocalAudioTrack(track, options)
            : new options.LocalVideoTrack(track, options);
    }
    /* eslint new-cap:0 */
    throw E.INVALID_TYPE('track', 'LocalAudioTrack, LocalVideoTrack, LocalDataTrack, or MediaStreamTrack');
}
/**
 * Create a new {@link LocalTrackPublication} for the given {@link LocalTrack}.
 * @param {LocalTrack} track
 * @param {LocalTrackPublicationSignaling} signaling
 * @param {function(track: LocalTrackPublication): void} unpublish
 * @param {object} options
 */
function asLocalTrackPublication(track, signaling, unpublish, options) {
    var LocalTrackPublication = {
        audio: options.LocalAudioTrackPublication,
        video: options.LocalVideoTrackPublication,
        data: options.LocalDataTrackPublication
    }[track.kind];
    return new LocalTrackPublication(signaling, track, unpublish, options);
}
/**
 * Capitalize a word.
 * @param {string} word
 * @returns {string} capitalized
 */
function capitalize(word) {
    return word[0].toUpperCase() + word.slice(1);
}
/**
 * Log deprecation warnings for the given events of an EventEmitter.
 * @param {string} name
 * @param {EventEmitter} emitter
 * @param {Map<string, string>} events
 * @param {Log} log
 */
function deprecateEvents(name, emitter, events, log) {
    var warningsShown = new Set();
    emitter.on('newListener', function newListener(event) {
        if (events.has(event) && !warningsShown.has(event)) {
            log.deprecated(name + "#" + event + " has been deprecated and scheduled for removal in twilio-video.js@2.0.0." + (events.get(event)
                ? " Use " + name + "#" + events.get(event) + " instead."
                : ''));
            warningsShown.add(event);
        }
        if (warningsShown.size >= events.size) {
            emitter.removeListener('newListener', newListener);
        }
    });
}
/**
 * Finds the items in list1 that are not in list2.
 * @param {Array<*>|Map<*>|Set<*>} list1
 * @param {Array<*>|Map<*>|Set<*>} list2
 * @returns {Set}
 */
function difference(list1, list2) {
    list1 = Array.isArray(list1) ? new Set(list1) : new Set(list1.values());
    list2 = Array.isArray(list2) ? new Set(list2) : new Set(list2.values());
    var difference = new Set();
    list1.forEach(function (item) {
        if (!list2.has(item)) {
            difference.add(item);
        }
    });
    return difference;
}
/**
 * Filter out the keys in an object with a given value.
 * @param {object} object - Object to be filtered
 * @param {*} [filterValue] - Value to be filtered out; If not specified, then
 *   filters out all keys which have an explicit value of "undefined"
 * @returns {object} - Filtered object
 */
function filterObject(object, filterValue) {
    return Object.keys(object).reduce(function (filtered, key) {
        if (object[key] !== filterValue) {
            filtered[key] = object[key];
        }
        return filtered;
    }, {});
}
/**
 * Map a list to an array of arrays, and return the flattened result.
 * @param {Array<*>|Set<*>|Map<*>} list
 * @param {function(*): Array<*>} [mapFn]
 * @returns Array<*>
 */
function flatMap(list, mapFn) {
    var listArray = list instanceof Map || list instanceof Set
        ? Array.from(list.values())
        : list;
    mapFn = mapFn || function mapFn(item) {
        return item;
    };
    return listArray.reduce(function (flattened, item) {
        var mapped = mapFn(item);
        return flattened.concat(mapped);
    }, []);
}
/**
 * Get the user agent string, or return "Unknown".
 * @returns {string}
 */
function getUserAgent() {
    return typeof navigator !== 'undefined' && navigator.userAgent
        ? navigator.userAgent
        : 'Unknown';
}
/**
 * Get the platform component of the user agent string.
 * Example:
 *   Input - Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.82 Safari/537.36
 *   Output - macintosh
 * @returns {string}
 */
function getPlatform() {
    var userAgent = getUserAgent();
    var _a = __read(userAgent.match(/\(([^)]+)\)/) || [], 2), _b = _a[1], match = _b === void 0 ? 'unknown' : _b;
    var _c = __read(match.split(';').map(function (entry) { return entry.trim(); }), 1), platform = _c[0];
    return platform.toLowerCase();
}
/**
 * Create a unique identifier.
 * @returns {string}
 */
function makeUUID() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var r = Math.random() * 16 | 0;
        var v = c === 'x' ? r : (r & 0x3 | 0x8);
        return v.toString(16);
    });
}
/**
 * Ensure that the given function is called once per tick.
 * @param {function} fn - Function to be executed
 * @returns {function} - Schedules the given function to be called on the next tick
 */
function oncePerTick(fn) {
    var timeout = null;
    function nextTick() {
        timeout = null;
        fn();
    }
    return function scheduleNextTick() {
        if (timeout) {
            clearTimeout(timeout);
        }
        timeout = setTimeout(nextTick);
    };
}
function promiseFromEvents(operation, eventEmitter, successEvent, failureEvent) {
    return new Promise(function (resolve, reject) {
        function onSuccess() {
            var args = [].slice.call(arguments);
            if (failureEvent) {
                eventEmitter.removeListener(failureEvent, onFailure);
            }
            resolve.apply(void 0, __spreadArray([], __read(args)));
        }
        function onFailure() {
            var args = [].slice.call(arguments);
            eventEmitter.removeListener(successEvent, onSuccess);
            reject.apply(void 0, __spreadArray([], __read(args)));
        }
        eventEmitter.once(successEvent, onSuccess);
        if (failureEvent) {
            eventEmitter.once(failureEvent, onFailure);
        }
        operation();
    });
}
/**
 * Traverse down multiple nodes on an object and return null if
 * any link in the path is unavailable.
 * @param {Object} obj - Object to traverse
 * @param {String} path - Path to traverse. Period-separated.
 * @returns {Any|null}
 */
function getOrNull(obj, path) {
    return path.split('.').reduce(function (output, step) {
        if (!output) {
            return null;
        }
        return output[step];
    }, obj);
}
/**
 * @typedef {object} Deferred
 * @property {Promise} promise
 * @property {function} reject
 * @property {function} resolve
 */
/**
 * Create a {@link Deferred}.
 * @returns {Deferred}
 */
function defer() {
    var deferred = {};
    deferred.promise = new Promise(function (resolve, reject) {
        deferred.resolve = resolve;
        deferred.reject = reject;
    });
    return deferred;
}
/**
 * Copy a method from a `source` prototype onto a `wrapper` prototype. Invoking
 * the method on the `wrapper` prototype will invoke the corresponding method
 * on an instance accessed by `target`.
 * @param {object} source
 * @param {object} wrapper
 * @param {string} target
 * @param {string} methodName
 * @returns {undefined}
 */
function delegateMethod(source, wrapper, target, methodName) {
    if (methodName in wrapper) {
        // Skip any methods already set.
        return;
    }
    else if (methodName.match(/^on[a-z]+$/)) {
        // Skip EventHandlers (these are handled in the constructor).
        return;
    }
    var type;
    try {
        type = typeof source[methodName];
    }
    catch (error) {
        // NOTE(mroberts): Attempting to check the type of non-function members
        // on the prototype throws an error for some types.
    }
    if (type !== 'function') {
        // Skip non-function members.
        return;
    }
    /* eslint no-loop-func:0 */
    wrapper[methodName] = function () {
        var _a;
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        return (_a = this[target])[methodName].apply(_a, __spreadArray([], __read(args)));
    };
}
/**
 * Copy methods from a `source` prototype onto a `wrapper` prototype. Invoking
 * the methods on the `wrapper` prototype will invoke the corresponding method
 * on an instance accessed by `target`.
 * @param {object} source
 * @param {object} wrapper
 * @param {string} target
 * @returns {undefined}
 */
function delegateMethods(source, wrapper, target) {
    for (var methodName in source) {
        delegateMethod(source, wrapper, target, methodName);
    }
}
/**
 * Determine whether two values are deeply equal.
 * @param {*} val1
 * @param {*} val2
 * @returns {boolean}
 */
function isDeepEqual(val1, val2) {
    if (val1 === val2) {
        return true;
    }
    if (typeof val1 !== typeof val2) {
        return false;
    }
    if (val1 === null) {
        return val2 === null;
    }
    if (val2 === null) {
        return false;
    }
    if (Array.isArray(val1)) {
        return Array.isArray(val2)
            && val1.length === val2.length
            && val1.every(function (val, i) { return isDeepEqual(val, val2[i]); });
    }
    if (typeof val1 === 'object') {
        var val1Keys = Object.keys(val1).sort();
        var val2Keys = Object.keys(val2).sort();
        return !Array.isArray(val2)
            && isDeepEqual(val1Keys, val2Keys)
            && val1Keys.every(function (key) { return isDeepEqual(val1[key], val2[key]); });
    }
    return false;
}
/**
 * Whether the given argument is a non-array object.
 * @param {*} object
 * @return {boolean}
 */
function isNonArrayObject(object) {
    return typeof object === 'object' && !Array.isArray(object);
}
/**
 * For each property name on the `source` prototype, add getters and/or setters
 * to `wrapper` that proxy to `target`.
 * @param {object} source
 * @param {object} wrapper
 * @param {string} target
 * @returns {undefined}
 */
function proxyProperties(source, wrapper, target) {
    Object.getOwnPropertyNames(source).forEach(function (propertyName) {
        proxyProperty(source, wrapper, target, propertyName);
    });
}
/**
 * For the property name on the `source` prototype, add a getter and/or setter
 * to `wrapper` that proxies to `target`.
 * @param {object} source
 * @param {object} wrapper
 * @param {string} target
 * @param {string} propertyName
 * @returns {undefined}
 */
function proxyProperty(source, wrapper, target, propertyName) {
    if (propertyName in wrapper) {
        // Skip any properties already set.
        return;
    }
    else if (propertyName.match(/^on[a-z]+$/)) {
        Object.defineProperty(wrapper, propertyName, {
            value: null,
            writable: true
        });
        target.addEventListener(propertyName.slice(2), function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            wrapper.dispatchEvent.apply(wrapper, __spreadArray([], __read(args)));
        });
        return;
    }
    Object.defineProperty(wrapper, propertyName, {
        enumerable: true,
        get: function () {
            return target[propertyName];
        }
    });
}
/**
 * This is a function for turning a Promise into the kind referenced in the
 * Legacy Interface Extensions section of the WebRTC spec.
 * @param {Promise<*>} promise
 * @param {function<*>} onSuccess
 * @param {function<Error>} onFailure
 * @returns {Promise<undefined>}
 */
function legacyPromise(promise, onSuccess, onFailure) {
    if (onSuccess) {
        return promise.then(function (result) {
            onSuccess(result);
        }, function (error) {
            onFailure(error);
        });
    }
    return promise;
}
/**
 * Build the {@link LogLevels} object.
 * @param {String|LogLevel} logLevel - Log level name or object
 * @returns {LogLevels}
 */
function buildLogLevels(logLevel) {
    if (typeof logLevel === 'string') {
        return {
            default: logLevel,
            media: logLevel,
            signaling: logLevel,
            webrtc: logLevel
        };
    }
    return logLevel;
}
/**
 * Get the {@link Track}'s derived class name
 * @param {Track} track
 * @param {?boolean} [local=undefined]
 * @returns {string}
 */
function trackClass(track, local) {
    local = local ? 'Local' : '';
    return local + (track.kind || '').replace(/\w{1}/, function (m) { return m.toUpperCase(); }) + "Track";
}
/**
 * Get the {@link TrackPublication}'s derived class name
 * @param {TrackPublication} publication
 * @param {?boolean} [local=undefined]
 * @returns {string}
 */
function trackPublicationClass(publication, local) {
    local = local ? 'Local' : '';
    return local + (publication.kind || '').replace(/\w{1}/, function (m) { return m.toUpperCase(); }) + "TrackPublication";
}
/**
 * Sets all underscore-prefixed properties on `object` non-enumerable.
 * @param {Object} object
 * @returns {void}
 */
function hidePrivateProperties(object) {
    Object.getOwnPropertyNames(object).forEach(function (name) {
        if (name.startsWith('_')) {
            hideProperty(object, name);
        }
    });
}
/**
 * Creates a new subclass which, in the constructor, sets all underscore-prefixed
 * properties and the given public properties non-enumerable. This is useful for
 * patching up classes like EventEmitter which may set properties like `_events`
 * and `domain`.
 * @param {Function} klass
 * @param {Array<string>} props
 * @returns {Function} subclass
 */
function hidePrivateAndCertainPublicPropertiesInClass(klass, props) {
    // NOTE(mroberts): We do this to avoid giving the class a name.
    return /** @class */ (function (_super) {
        __extends(class_1, _super);
        function class_1() {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var _this = _super.apply(this, __spreadArray([], __read(args))) || this;
            hidePrivateProperties(_this);
            hidePublicProperties(_this, props);
            return _this;
        }
        return class_1;
    }(klass));
}
/**
 * Hide a property of an object.
 * @param {object} object
 * @param {string} name
 */
function hideProperty(object, name) {
    var descriptor = Object.getOwnPropertyDescriptor(object, name);
    descriptor.enumerable = false;
    Object.defineProperty(object, name, descriptor);
}
/**
 * Hide the given public properties of an object.
 * @param {object} object
 * @param {Array<string>} [props=[]]
 */
function hidePublicProperties(object, props) {
    if (props === void 0) { props = []; }
    props.forEach(function (name) {
        // eslint-disable-next-line no-prototype-builtins
        if (object.hasOwnProperty(name)) {
            hideProperty(object, name);
        }
    });
}
/**
 * Convert an Array of values to an Array of JSON values by calling
 * `valueToJSON` on each value.
 * @param {Array<*>} array
 * @returns {Array<*>}
 */
function arrayToJSON(array) {
    return array.map(valueToJSON);
}
/**
 * Convert a Set of values to an Array of JSON values by calling `valueToJSON`
 * on each value.
 * @param {Set<*>} set
 * @returns {Array<*>}
 */
function setToJSON(set) {
    return arrayToJSON(__spreadArray([], __read(set)));
}
/**
 * Convert a Map from strings to values to an object of JSON values by calling
 * `valueToJSON` on each value.
 * @param {Map<string, *>} map
 * @returns {object}
 */
function mapToJSON(map) {
    return __spreadArray([], __read(map.entries())).reduce(function (json, _a) {
        var _b;
        var _c = __read(_a, 2), key = _c[0], value = _c[1];
        return Object.assign((_b = {}, _b[key] = valueToJSON(value), _b), json);
    }, {});
}
/**
 * Convert an object to a JSON value by calling `valueToJSON` on its enumerable
 * keys.
 * @param {object} object
 * @returns {object}
 */
function objectToJSON(object) {
    return Object.entries(object).reduce(function (json, _a) {
        var _b;
        var _c = __read(_a, 2), key = _c[0], value = _c[1];
        return Object.assign((_b = {}, _b[key] = valueToJSON(value), _b), json);
    }, {});
}
/**
 * Convert a value into a JSON value.
 * @param {*} value
 * @returns {*}
 */
function valueToJSON(value) {
    if (Array.isArray(value)) {
        return arrayToJSON(value);
    }
    else if (value instanceof Set) {
        return setToJSON(value);
    }
    else if (value instanceof Map) {
        return mapToJSON(value);
    }
    else if (value && typeof value === 'object') {
        return objectToJSON(value);
    }
    return value;
}
function createRoomConnectEventPayload(connectOptions) {
    function boolToString(val) {
        return val ? 'true' : 'false';
    }
    var payload = {
        sessionSID: sessionSID,
        // arrays props converted to lengths.
        iceServers: (connectOptions.iceServers || []).length,
        audioTracks: (connectOptions.tracks || []).filter(function (track) { return track.kind === 'audio'; }).length,
        videoTracks: (connectOptions.tracks || []).filter(function (track) { return track.kind === 'video'; }).length,
        dataTracks: (connectOptions.tracks || []).filter(function (track) { return track.kind === 'data'; }).length,
    };
    // boolean properties.
    [['audio'], ['automaticSubscription'], ['enableDscp'], ['eventListener'], ['preflight'], ['video'], ['dominantSpeaker', 'enableDominantSpeaker']].forEach(function (_a) {
        var _b = __read(_a, 2), prop = _b[0], eventProp = _b[1];
        eventProp = eventProp || prop;
        payload[eventProp] = boolToString(!!connectOptions[prop]);
    });
    // numbers properties.
    [['maxVideoBitrate'], ['maxAudioBitrate']].forEach(function (_a) {
        var _b = __read(_a, 2), prop = _b[0], eventProp = _b[1];
        eventProp = eventProp || prop;
        if (typeof connectOptions[prop] === 'number') {
            payload[eventProp] = connectOptions[prop];
        }
        else if (!isNaN(Number(connectOptions[prop]))) {
            payload[eventProp] = Number(connectOptions[prop]);
        }
    });
    // string properties.
    [['iceTransportPolicy'], ['region'], ['name', 'roomName']].forEach(function (_a) {
        var _b = __read(_a, 2), prop = _b[0], eventProp = _b[1];
        eventProp = eventProp || prop;
        if (typeof connectOptions[prop] === 'string') {
            payload[eventProp] = connectOptions[prop];
        }
        else if (typeof connectOptions[prop] === 'number' && prop === 'name') {
            payload[eventProp] = connectOptions[prop].toString();
        }
    });
    // array props stringified.
    ['preferredAudioCodecs', 'preferredVideoCodecs'].forEach(function (prop) {
        if (prop in connectOptions) {
            payload[prop] = JSON.stringify(connectOptions[prop]);
        }
    });
    if ('networkQuality' in connectOptions) {
        payload.networkQualityConfiguration = {};
        if (isNonArrayObject(connectOptions.networkQuality)) {
            ['local', 'remote'].forEach(function (prop) {
                if (typeof connectOptions.networkQuality[prop] === 'number') {
                    payload.networkQualityConfiguration[prop] = connectOptions.networkQuality[prop];
                }
            });
        }
        else {
            payload.networkQualityConfiguration.remote = 0;
            payload.networkQualityConfiguration.local = connectOptions.networkQuality ? 1 : 0;
        }
    }
    if (connectOptions.bandwidthProfile && connectOptions.bandwidthProfile.video) {
        var videoBPOptions_1 = connectOptions.bandwidthProfile.video || {};
        payload.bandwidthProfileOptions = {};
        ['mode', 'maxTracks', 'trackSwitchOffMode', 'dominantSpeakerPriority', 'maxSubscriptionBitrate', 'renderDimensions', 'contentPreferencesMode', 'clientTrackSwitchOffControl'].forEach(function (prop) {
            if (typeof videoBPOptions_1[prop] === 'number' || typeof videoBPOptions_1[prop] === 'string') {
                payload.bandwidthProfileOptions[prop] = videoBPOptions_1[prop];
            }
            else if (typeof videoBPOptions_1[prop] === 'boolean') {
                payload.bandwidthProfileOptions[prop] = boolToString(videoBPOptions_1[prop]);
            }
            else if (typeof videoBPOptions_1[prop] === 'object') {
                payload.bandwidthProfileOptions[prop] = JSON.stringify(videoBPOptions_1[prop]);
            }
        });
    }
    return {
        group: 'room',
        name: 'connect',
        level: 'info',
        payload: payload
    };
}
/**
 * Create the bandwidth profile payload included in an RSP connect message.
 * @param {BandwidthProfileOptions} bandwidthProfile
 * @returns {object}
 */
function createBandwidthProfilePayload(bandwidthProfile) {
    return createRSPPayload(bandwidthProfile, [
        { prop: 'video', type: 'object', transform: createBandwidthProfileVideoPayload }
    ]);
}
/**
 * Create the bandwidth profile video payload included in an RSP connect message.
 * @param {VideoBandwidthProfileOptions} bandwidthProfileVideo
 * @returns {object}
 */
function createBandwidthProfileVideoPayload(bandwidthProfileVideo) {
    return createRSPPayload(bandwidthProfileVideo, [
        { prop: 'dominantSpeakerPriority', type: 'string', payloadProp: 'active_speaker_priority' },
        { prop: 'maxSubscriptionBitrate', type: 'number', payloadProp: 'max_subscription_bandwidth' },
        { prop: 'maxTracks', type: 'number', payloadProp: 'max_tracks' },
        { prop: 'mode', type: 'string' },
        { prop: 'renderDimensions', type: 'object', payloadProp: 'render_dimensions', transform: createRenderDimensionsPayload },
        { prop: 'trackSwitchOffMode', type: 'string', payloadProp: 'track_switch_off' }
    ]);
}
/**
 * Create the Media Signaling payload included in an RSP connect message.
 * @param {boolean} dominantSpeaker - whether to enable the Dominant Speaker
 *   protocol or not
 * @param {boolean} networkQuality - whether to enable the Network Quality
 *   protocol or not
 * @param {boolean} trackPriority - whether to enable the Track Priority
 *   protocol or not
 * @param {boolean} trackSwitchOff - whether to enable the Track Switch-Off
 *   protocol or not.
 * @param {boolean} renderHints - whether to enable the renderHints
 *   protocol or not.
 * @returns {object}
 */
function createMediaSignalingPayload(dominantSpeaker, networkQuality, trackPriority, trackSwitchOff, adaptiveSimulcast, renderHints) {
    var transports = { transports: [{ type: 'data-channel' }] };
    return Object.assign(dominantSpeaker
        // eslint-disable-next-line
        ? { active_speaker: transports }
        : {}, networkQuality
        // eslint-disable-next-line
        ? { network_quality: transports }
        : {}, renderHints
        // eslint-disable-next-line
        ? { render_hints: transports }
        : {}, adaptiveSimulcast
        // eslint-disable-next-line
        ? { publisher_hints: transports }
        : {}, trackPriority
        // eslint-disable-next-line
        ? { track_priority: transports }
        : {}, trackSwitchOff
        // eslint-disable-next-line
        ? { track_switch_off: transports }
        : {});
}
/**
 * Create {@link VideoTrack.Dimensions} RSP payload.
 * @param {VideoTrack.Dimensions} [dimensions]
 * @returns {object}
 */
function createDimensionsPayload(dimensions) {
    return createRSPPayload(dimensions, [
        { prop: 'height', type: 'number' },
        { prop: 'width', type: 'number' }
    ]);
}
/**
 * Create {@link VideoRenderDimensions} RSP payload.
 * @param renderDimensions
 * @returns {object}
 */
function createRenderDimensionsPayload(renderDimensions) {
    var PRIORITY_HIGH = trackPriority.PRIORITY_HIGH, PRIORITY_LOW = trackPriority.PRIORITY_LOW, PRIORITY_STANDARD = trackPriority.PRIORITY_STANDARD;
    return createRSPPayload(renderDimensions, [
        { prop: PRIORITY_HIGH, type: 'object', transform: createDimensionsPayload },
        { prop: PRIORITY_LOW, type: 'object', transform: createDimensionsPayload },
        { prop: PRIORITY_STANDARD, type: 'object', transform: createDimensionsPayload }
    ]);
}
/**
 * Create an RSP payload for the given object.
 * @param {object} object - object for which RSP payload is to be generated
 * @param {Array<object>} propConversions - conversion rules for object properties;
 *   they specify how object properties should be converted to their corresponding
 *   RSP payload properties
 * @returns {object}
 */
function createRSPPayload(object, propConversions) {
    return propConversions.reduce(function (payload, _a) {
        var _b;
        var prop = _a.prop, type = _a.type, _c = _a.payloadProp, payloadProp = _c === void 0 ? prop : _c, _d = _a.transform, transform = _d === void 0 ? function (x) { return x; } : _d;
        return typeof object[prop] === type
            ? Object.assign((_b = {}, _b[payloadProp] = transform(object[prop]), _b), payload)
            : payload;
    }, {});
}
/**
 * Create the subscribe payload included in an RSP connect/update message.
 * @param {boolean} automaticSubscription - whether to subscribe to all RemoteTracks
 * @returns {object}
 */
function createSubscribePayload(automaticSubscription) {
    return {
        rules: [{
                type: automaticSubscription ? 'include' : 'exclude',
                all: true
            }],
        revision: 1
    };
}
function createMediaWarningsPayload(notifyWarnings) {
    var _a;
    var mediaWarnings = (_a = {},
        _a[TwilioWarning.recordingMediaLost] = 'recordings',
        _a);
    return notifyWarnings
        .map(function (twilioWarningName) { return mediaWarnings[twilioWarningName]; })
        .filter(function (name) { return !!name; });
}
/**
 * Add random jitter to a given value in the range [-jitter, jitter].
 * @private
 * @param {number} value
 * @param {number} jitter
 * @returns {number} value + random(-jitter, +jitter)
 */
function withJitter(value, jitter) {
    var rand = Math.random();
    return value - jitter + Math.floor(2 * jitter * rand + 0.5);
}
/**
 * Checks if the a number is in the range [min, max].
 * @private
 * @param {num} num
 * @param {number} min
 * @param {number} max
 * @return {boolean}
 */
function inRange(num, min, max) {
    return min <= num && num <= max;
}
/**
 * returns true if given MediaStreamTrack is a screen share track
 * @private
 * @param {MediaStreamTrack} track
 * @returns {boolean}
 */
function isChromeScreenShareTrack(track) {
    // NOTE(mpatwardhan): Chrome creates screen share tracks with label like: "screen:69734272*"
    // we will check for label that starts with "screen:D" where D being a digit.
    return util.guessBrowser() === 'chrome' && track.kind === 'video' && 'displaySurface' in track.getSettings();
}
/**
 * Returns a promise that resolve after timeoutMS have passed.
 * @param {number} timeoutMS - time to wait in milliseconds.
 * @returns {Promise<void>}
 */
function waitForSometime(timeoutMS) {
    if (timeoutMS === void 0) { timeoutMS = 10; }
    return new Promise(function (resolve) { return setTimeout(resolve, timeoutMS); });
}
/**
 * Returns a promise that resolve after event is received
 * @returns {Promise<void>}
 */
function waitForEvent(eventTarget, event) {
    return new Promise(function (resolve) {
        eventTarget.addEventListener(event, function onevent(e) {
            eventTarget.removeEventListener(event, onevent);
            resolve(e);
        });
    });
}
exports.constants = constants;
exports.createBandwidthProfilePayload = createBandwidthProfilePayload;
exports.createMediaSignalingPayload = createMediaSignalingPayload;
exports.createMediaWarningsPayload = createMediaWarningsPayload;
exports.createRoomConnectEventPayload = createRoomConnectEventPayload;
exports.createSubscribePayload = createSubscribePayload;
exports.asLocalTrack = asLocalTrack;
exports.asLocalTrackPublication = asLocalTrackPublication;
exports.capitalize = capitalize;
exports.deprecateEvents = deprecateEvents;
exports.difference = difference;
exports.filterObject = filterObject;
exports.flatMap = flatMap;
exports.getPlatform = getPlatform;
exports.getUserAgent = getUserAgent;
exports.hidePrivateProperties = hidePrivateProperties;
exports.hidePrivateAndCertainPublicPropertiesInClass = hidePrivateAndCertainPublicPropertiesInClass;
exports.isDeepEqual = isDeepEqual;
exports.isNonArrayObject = isNonArrayObject;
exports.inRange = inRange;
exports.makeUUID = makeUUID;
exports.oncePerTick = oncePerTick;
exports.promiseFromEvents = promiseFromEvents;
exports.getOrNull = getOrNull;
exports.defer = defer;
exports.delegateMethods = delegateMethods;
exports.proxyProperties = proxyProperties;
exports.legacyPromise = legacyPromise;
exports.buildLogLevels = buildLogLevels;
exports.trackClass = trackClass;
exports.trackPublicationClass = trackPublicationClass;
exports.valueToJSON = valueToJSON;
exports.withJitter = withJitter;
exports.isChromeScreenShareTrack = isChromeScreenShareTrack;
exports.waitForSometime = waitForSometime;
exports.waitForEvent = waitForEvent;

},{"../webrtc/util":171,"./constants":126,"./sid":145,"./twiliowarning":150}],134:[function(require,module,exports){
/* eslint-disable camelcase */
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var EventEmitter = require('events').EventEmitter;
var getUserAgent = require('..').getUserAgent;
var MAX_RECONNECT_ATTEMPTS = 5;
var RECONNECT_INTERVAL_MS = 50;
var WS_CLOSE_NORMAL = 1000;
var toplevel = globalThis;
var WebSocket = toplevel.WebSocket ? toplevel.WebSocket : require('ws');
var _a = require('../constants'), hardwareDevicePublisheriPad = _a.hardwareDevicePublisheriPad, hardwareDevicePublisheriPhone = _a.hardwareDevicePublisheriPhone;
var util = require('../../util');
var browserdetection = require('../browserdetection');
/**
 * Publish events to the Insights gateway.
 * @extends EventEmitter
 * @emits InsightsPublisher#connected
 * @emits InsightsPublisher#disconnected
 * @emits InsightsPublisher#reconnecting
 */
var InsightsPublisher = /** @class */ (function (_super) {
    __extends(InsightsPublisher, _super);
    /**
     * @param {string} token - Insights gateway token
     * @param {string} sdkName - Name of the SDK using the {@link InsightsPublisher}
     * @param {string} sdkVersion - Version of the SDK using the {@link InsightsPublisher}
     * @param {string} environment - One of 'dev', 'stage' or 'prod'
     * @param {string} realm - Region identifier
     * @param {InsightsPublisherOptions} options - Override default behavior
     */
    function InsightsPublisher(token, sdkName, sdkVersion, environment, realm, options) {
        var _this = _super.call(this) || this;
        options = Object.assign({
            gateway: createGateway(environment, realm) + "/v1/VideoEvents",
            maxReconnectAttempts: MAX_RECONNECT_ATTEMPTS,
            reconnectIntervalMs: RECONNECT_INTERVAL_MS,
            userAgent: getUserAgent(),
            WebSocket: WebSocket,
        }, options);
        Object.defineProperties(_this, {
            _connectTimestamp: {
                value: 0,
                writable: true
            },
            _eventQueue: {
                value: []
            },
            _readyToConnect: {
                value: util.defer()
            },
            _reconnectAttemptsLeft: {
                value: options.maxReconnectAttempts,
                writable: true
            },
            _ws: {
                value: null,
                writable: true
            },
            _WebSocket: {
                value: options.WebSocket
            }
        });
        _this._readyToConnect.promise.then(function (_a) {
            var roomSid = _a.roomSid, participantSid = _a.participantSid;
            var self = _this;
            _this.on('disconnected', function maybeReconnect(error) {
                self._session = null;
                if (error && self._reconnectAttemptsLeft > 0) {
                    self.emit('reconnecting');
                    reconnect(self, token, sdkName, sdkVersion, roomSid, participantSid, options);
                    return;
                }
                self.removeListener('disconnected', maybeReconnect);
            });
            connect(_this, token, sdkName, sdkVersion, roomSid, participantSid, options);
        }).catch(function () {
            // ignore failures to connect
        });
        return _this;
    }
    /**
     * Start connecting to the Insights gateway.
     * @param {string} roomSid
     * @param {string} participantSid
     * @returns {void}
     */
    InsightsPublisher.prototype.connect = function (roomSid, participantSid) {
        this._readyToConnect.resolve({ roomSid: roomSid, participantSid: participantSid });
    };
    /**
     * Publish an event to the Insights gateway.
     * @private
     * @param {*} event
     */
    InsightsPublisher.prototype._publish = function (event) {
        event.session = this._session;
        this._ws.send(JSON.stringify(event));
    };
    /**
     * Disconnect from the Insights gateway.
     * @returns {boolean} true if called when connecting/open, false if not
     */
    InsightsPublisher.prototype.disconnect = function () {
        if (this._ws === null
            || this._ws.readyState === this._WebSocket.CLOSING
            || this._ws.readyState === this._WebSocket.CLOSED) {
            return false;
        }
        try {
            this._ws.close();
        }
        catch (error) {
            // Do nothing.
        }
        this.emit('disconnected');
        return true;
    };
    /**
     * Publish (or queue, if not connected) an event to the Insights gateway.
     * @param {string} groupName - Event group name
     * @param {string} eventName - Event name
     * @param {object} payload - Event payload
     * @returns {boolean} true if queued or published, false if disconnect() called
     */
    InsightsPublisher.prototype.publish = function (groupName, eventName, payload) {
        if (this._ws !== null
            && (this._ws.readyState === this._WebSocket.CLOSING
                || this._ws.readyState === this._WebSocket.CLOSED)) {
            return false;
        }
        var publishOrEnqueue = typeof this._session === 'string'
            ? this._publish.bind(this)
            : this._eventQueue.push.bind(this._eventQueue);
        publishOrEnqueue({
            group: groupName,
            name: eventName,
            payload: payload,
            timestamp: Date.now(),
            type: 'event',
            version: 1
        });
        return true;
    };
    return InsightsPublisher;
}(EventEmitter));
/**
 * Start connecting to the Insights gateway.
 * @private
 * @param {InsightsPublisher} publisher
 * @param {string} name
 * @param {string} token
 * @param {string} sdkName
 * @param {string} sdkVersion
 * @param {string} roomSid
 * @param {string} participantSid
 * @param {InsightsPublisherOptions} options
 */
function connect(publisher, token, sdkName, sdkVersion, roomSid, participantSid, options) {
    publisher._connectTimestamp = Date.now();
    publisher._reconnectAttemptsLeft--;
    publisher._ws = new options.WebSocket(options.gateway);
    var ws = publisher._ws;
    ws.addEventListener('close', function (event) {
        if (event.code === WS_CLOSE_NORMAL) {
            publisher.emit('disconnected');
            return;
        }
        publisher.emit('disconnected', new Error("WebSocket Error " + event.code + ": " + event.reason));
    });
    ws.addEventListener('message', function (message) {
        handleConnectResponse(publisher, JSON.parse(message.data), options);
    });
    ws.addEventListener('open', function () {
        var connectRequest = {
            type: 'connect',
            token: token,
            version: 1
        };
        connectRequest.publisher = {
            name: sdkName,
            sdkVersion: sdkVersion,
            userAgent: options.userAgent,
            participantSid: participantSid,
            roomSid: roomSid,
        };
        if (browserdetection.isIpad()) {
            connectRequest.publisher = __assign(__assign({}, connectRequest.publisher), hardwareDevicePublisheriPad);
        }
        else if (browserdetection.isIphone()) {
            connectRequest.publisher = __assign(__assign({}, connectRequest.publisher), hardwareDevicePublisheriPhone);
        }
        ws.send(JSON.stringify(connectRequest));
    });
}
/**
 * Create the Insights Websocket gateway URL.
 * @param {string} environment
 * @param {string} realm
 * @returns {string}
 */
function createGateway(environment, realm) {
    return environment === 'prod' ? "wss://sdkgw." + realm + ".twilio.com"
        : "wss://sdkgw." + environment + "-" + realm + ".twilio.com";
}
/**
 * Handle connect response from the Insights gateway.
 * @param {InsightsPublisher} publisher
 * @param {*} response
 * @param {InsightsPublisherOptions} options
 */
function handleConnectResponse(publisher, response, options) {
    switch (response.type) {
        case 'connected':
            publisher._session = response.session;
            publisher._reconnectAttemptsLeft = options.maxReconnectAttempts;
            publisher._eventQueue.splice(0).forEach(publisher._publish, publisher);
            publisher.emit('connected');
            break;
        case 'error':
            publisher._ws.close();
            publisher.emit('disconnected', new Error(response.message));
            break;
    }
}
/**
 * Start re-connecting to the Insights gateway with an appropriate delay based
 * on InsightsPublisherOptions#reconnectIntervalMs.
 * @private
 * @param {InsightsPublisher} publisher
 * @param {string} token
 * @param {string} sdkName
 * @param {string} sdkVersion
 * @param {string} roomSid
 * @param {string} participantSid
 * @param {InsightsPublisherOptions} options
 */
function reconnect(publisher, token, sdkName, sdkVersion, roomSid, participantSid, options) {
    var connectInterval = Date.now() - publisher._connectTimestamp;
    var timeToWait = options.reconnectIntervalMs - connectInterval;
    if (timeToWait > 0) {
        setTimeout(function () {
            connect(publisher, token, sdkName, sdkVersion, roomSid, participantSid, options);
        }, timeToWait);
        return;
    }
    connect(publisher, token, sdkName, sdkVersion, roomSid, participantSid, options);
}
/**
 * The {@link InsightsPublisher} is connected to the gateway.
 * @event InsightsPublisher#connected
 */
/**
 * The {@link InsightsPublisher} is disconnected from the gateway.
 * @event InsightsPublisher#disconnected
 * @param {Error} [error] - Optional error if disconnected unintentionally
 */
/**
 * The {@link InsightsPublisher} is re-connecting to the gateway.
 * @event InsightsPublisher#reconnecting
 */
/**
 * {@link InsightsPublisher} options.
 * @typedef {object} InsightsPublisherOptions
 * @property {string} [gateway=sdkgw.{environment}-{realm}.twilio.com] - Insights WebSocket gateway url
 * @property {number} [maxReconnectAttempts=5] - Max re-connect attempts
 * @property {number} [reconnectIntervalMs=50] - Re-connect interval in ms
 */
module.exports = InsightsPublisher;

},{"..":133,"../../util":133,"../browserdetection":124,"../constants":126,"events":174,"ws":176}],135:[function(require,module,exports){
// eslint-disable-next-line no-warning-comments
// TODO(mroberts): This should be described as implementing some
// InsightsPublisher interface.
'use strict';
/**
 * Null Insights publisher.
 */
var InsightsPublisher = /** @class */ (function () {
    function InsightsPublisher() {
        Object.defineProperties(this, {
            _connected: {
                writable: true,
                value: true
            }
        });
    }
    /**
     * Connect
     * @returns {void}
     */
    InsightsPublisher.prototype.connect = function () {
    };
    /**
     * Disconnect.
     * @returns {boolean}
     */
    InsightsPublisher.prototype.disconnect = function () {
        if (this._connected) {
            this._connected = false;
            return true;
        }
        return false;
    };
    /**
     * Publish.
     * @returns {boolean}
     */
    InsightsPublisher.prototype.publish = function () {
        return this._connected;
    };
    return InsightsPublisher;
}());
module.exports = InsightsPublisher;

},{}],136:[function(require,module,exports){
'use strict';
var defer = require('./').defer;
/**
 * This is a pair of Deferreds that are set whenever local media is muted and
 * resolved whenever local media is unmuted/ended and restarted if necessary.
 */
var LocalMediaRestartDeferreds = /** @class */ (function () {
    /**
     * Constructor.
     */
    function LocalMediaRestartDeferreds() {
        Object.defineProperties(this, {
            _audio: {
                value: defer(),
                writable: true
            },
            _video: {
                value: defer(),
                writable: true
            }
        });
        // Initially, resolve both the Deferreds.
        this._audio.resolve();
        this._video.resolve();
    }
    /**
     * Resolve the Deferred for audio or video.
     * @param {'audio'|'video'} kind
     */
    LocalMediaRestartDeferreds.prototype.resolveDeferred = function (kind) {
        if (kind === 'audio') {
            this._audio.resolve();
        }
        else {
            this._video.resolve();
        }
    };
    /**
     * Start the Deferred for audio or video.
     * @param {'audio' | 'video'} kind
     */
    LocalMediaRestartDeferreds.prototype.startDeferred = function (kind) {
        if (kind === 'audio') {
            this._audio = defer();
        }
        else {
            this._video = defer();
        }
    };
    /**
     * Wait until the Deferred for audio or video is resolved.
     * @param {'audio'|'video'} kind
     * @returns {Promise<void>}
     */
    LocalMediaRestartDeferreds.prototype.whenResolved = function (kind) {
        return kind === 'audio' ? this._audio.promise : this._video.promise;
    };
    return LocalMediaRestartDeferreds;
}());
module.exports = new LocalMediaRestartDeferreds();

},{"./":133}],137:[function(require,module,exports){
/* eslint new-cap:0 */
'use strict';
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var defaultGetLogger = require('../vendor/loglevel').getLogger;
var constants = require('./constants');
var DEFAULT_LOG_LEVEL = constants.DEFAULT_LOG_LEVEL, DEFAULT_LOGGER_NAME = constants.DEFAULT_LOGGER_NAME;
var E = require('./constants').typeErrors;
var deprecationWarningsByComponentConstructor;
function getDeprecationWarnings(componentConstructor) {
    deprecationWarningsByComponentConstructor = deprecationWarningsByComponentConstructor || new Map();
    if (deprecationWarningsByComponentConstructor.has(componentConstructor)) {
        return deprecationWarningsByComponentConstructor.get(componentConstructor);
    }
    var deprecationWarnings = new Set();
    deprecationWarningsByComponentConstructor.set(componentConstructor, deprecationWarnings);
    return deprecationWarnings;
}
/**
 * Selectively outputs messages to console based on specified minimum module
 * specific log levels.
 *
 * NOTE: The values in the logLevels object passed to the constructor is changed
 *       by subsequent calls to {@link Log#setLevels}.
 */
var Log = /** @class */ (function () {
    /**
     * Construct a new {@link Log} object.
     * @param {String} moduleName - Name of the logging module (webrtc/media/signaling)
     * @param {object} component - Component owning this instance of {@link Log}
     * @param {LogLevels} logLevels - Logging levels. See {@link LogLevels}
     * @param {String} loggerName - Name of the logger instance. Used when calling getLogger from loglevel module
     * @param {Function} [getLogger] - optional method used internally.
     */
    function Log(moduleName, component, logLevels, loggerName, getLogger) {
        if (typeof moduleName !== 'string') {
            throw E.INVALID_TYPE('moduleName', 'string');
        }
        if (!component) {
            throw E.REQUIRED_ARGUMENT('component');
        }
        if (typeof logLevels !== 'object') {
            logLevels = {};
        }
        getLogger = getLogger || defaultGetLogger;
        validateLogLevels(logLevels);
        /* istanbul ignore next */
        Object.defineProperties(this, {
            _component: {
                value: component
            },
            _logLevels: {
                value: logLevels
            },
            _warnings: {
                value: new Set()
            },
            _loggerName: {
                get: function get() {
                    var name = loggerName && typeof loggerName === 'string' ? loggerName : DEFAULT_LOGGER_NAME;
                    if (!this._logLevelsEqual) {
                        name = name + "-" + moduleName;
                    }
                    return name;
                }
            },
            _logger: {
                get: function get() {
                    var logger = getLogger(this._loggerName);
                    var level = this._logLevels[moduleName] || DEFAULT_LOG_LEVEL;
                    // There is no 'off' in the logger module. It uses 'silent' instead
                    level = level === 'off' ? 'silent' : level;
                    logger.setDefaultLevel(level);
                    return logger;
                }
            },
            _logLevelsEqual: {
                get: function get() {
                    // True if all levels are the same
                    return (new Set(Object.values(this._logLevels)).size) === 1;
                }
            },
            logLevel: {
                get: function get() {
                    return Log.getLevelByName(logLevels[moduleName] || DEFAULT_LOG_LEVEL);
                }
            },
            name: { get: component.toString.bind(component) }
        });
    }
    /**
     * Get the log level (number) by its name (string)
     * @param {String} name - Name of the log level
     * @returns {Number} Requested log level
     * @throws {TwilioError} INVALID_LOG_LEVEL (32056)
     * @public
     */
    Log.getLevelByName = function (name) {
        if (!isNaN(name)) {
            return parseInt(name, 10);
        }
        name = name.toUpperCase();
        validateLogLevel(name);
        return Log[name];
    };
    /**
     * Create a child {@link Log} instance with this._logLevels
     * @param moduleName - Name of the logging module
     * @param component - Component owning this instance of {@link Log}
     * @returns {Log} this
     */
    Log.prototype.createLog = function (moduleName, component) {
        var name = this._loggerName;
        // Grab the original logger name
        if (!this._logLevelsEqual) {
            name = name.substring(0, name.lastIndexOf('-'));
        }
        return new Log(moduleName, component, this._logLevels, name);
    };
    /**
     * Set new log levels.
     * This changes the levels for all its ancestors,
     * siblings, and children and descendants instances of {@link Log}.
     * @param {LogLevels} levels - New log levels
     * @throws {TwilioError} INVALID_ARGUMENT
     * @returns {Log} this
     */
    Log.prototype.setLevels = function (levels) {
        validateLogLevels(levels);
        Object.assign(this._logLevels, levels);
        return this;
    };
    /**
     * Log a message using the logger method appropriate for the specified logLevel
     * @param {Number} logLevel - Log level of the message being logged
     * @param {Array} messages - Message(s) to log
     * @returns {Log} This instance of {@link Log}
     * @public
     */
    Log.prototype.log = function (logLevel, messages) {
        var name = Log._levels[logLevel];
        // eslint-disable-next-line no-use-before-define
        if (!name) {
            throw E.INVALID_VALUE('logLevel', LOG_LEVEL_VALUES);
        }
        name = name.toLowerCase();
        var prefix = [new Date().toISOString(), name, this.name];
        (this._logger[name] || function noop() { }).apply(void 0, __spreadArray([], __read(prefix.concat(messages))));
        return this;
    };
    /**
     * Log a debug message
     * @param {...String} messages - Message(s) to pass to the logger
     * @returns {Log} This instance of {@link Log}
     * @public
     */
    Log.prototype.debug = function () {
        return this.log(Log.DEBUG, [].slice.call(arguments));
    };
    /**
     * Log a deprecation warning. Deprecation warnings are logged as warnings and
     * they are only ever logged once.
     * @param {String} deprecationWarning - The deprecation warning
     * @returns {Log} This instance of {@link Log}
     * @public
     */
    Log.prototype.deprecated = function (deprecationWarning) {
        var deprecationWarnings = getDeprecationWarnings(this._component.constructor);
        if (deprecationWarnings.has(deprecationWarning)) {
            return this;
        }
        deprecationWarnings.add(deprecationWarning);
        return this.warn(deprecationWarning);
    };
    /**
     * Log an info message
     * @param {...String} messages - Message(s) to pass to the logger
     * @returns {Log} This instance of {@link Log}
     * @public
     */
    Log.prototype.info = function () {
        return this.log(Log.INFO, [].slice.call(arguments));
    };
    /**
     * Log a warn message
     * @param {...String} messages - Message(s) to pass to the logger
     * @returns {Log} This instance of {@link Log}
     * @public
     */
    Log.prototype.warn = function () {
        return this.log(Log.WARN, [].slice.call(arguments));
    };
    /**
     * Log a warning once.
     * @param {String} warning
     * @returns {Log} This instance of {@link Log}
     * @public
     */
    Log.prototype.warnOnce = function (warning) {
        if (this._warnings.has(warning)) {
            return this;
        }
        this._warnings.add(warning);
        return this.warn(warning);
    };
    /**
     * Log an error message
     * @param {...String} messages - Message(s) to pass to the logger
     * @returns {Log} This instance of {@link Log}
     * @public
     */
    Log.prototype.error = function () {
        return this.log(Log.ERROR, [].slice.call(arguments));
    };
    /**
     * Log an error message and throw an exception
     * @param {TwilioError} error - Error to throw
     * @param {String} customMessage - Custom message for the error
     * @public
     */
    Log.prototype.throw = function (error, customMessage) {
        if (error.clone) {
            error = error.clone(customMessage);
        }
        this.log(Log.ERROR, error);
        throw error;
    };
    return Log;
}());
// Singleton Constants
/* eslint key-spacing:0 */
/* istanbul ignore next */
Object.defineProperties(Log, {
    DEBUG: { value: 0 },
    INFO: { value: 1 },
    WARN: { value: 2 },
    ERROR: { value: 3 },
    OFF: { value: 4 },
    _levels: {
        value: [
            'DEBUG',
            'INFO',
            'WARN',
            'ERROR',
            'OFF',
        ]
    }
});
var LOG_LEVELS_SET = {};
var LOG_LEVEL_VALUES = [];
var LOG_LEVEL_NAMES = Log._levels.map(function (level, i) {
    LOG_LEVELS_SET[level] = true;
    LOG_LEVEL_VALUES.push(i);
    return level;
});
function validateLogLevel(level) {
    if (!(level in LOG_LEVELS_SET)) {
        throw E.INVALID_VALUE('level', LOG_LEVEL_NAMES);
    }
}
function validateLogLevels(levels) {
    Object.keys(levels).forEach(function (moduleName) {
        validateLogLevel(levels[moduleName].toUpperCase());
    });
}
module.exports = Log;

},{"../vendor/loglevel":153,"./constants":126}],138:[function(require,module,exports){
'use strict';
/**
 * Calculates the moving average delta for the given pair ofsamples. A sample (S)
 * consists of a numerator (Sn) and a denominator (Sd).The moving average delta is
 * calculated as follows:
 *
 * MovingAvgDelta = (Sn[1] - Sn[0]) / (Sd[1] - Sd[0])
 */
var MovingAverageDelta = /** @class */ (function () {
    /**
     * Constructor.
     */
    function MovingAverageDelta() {
        Object.defineProperties(this, {
            _samples: {
                value: [
                    { denominator: 0, numerator: 0 },
                    { denominator: 0, numerator: 0 }
                ],
            }
        });
    }
    /**
     * Get the moving average delta.
     * @returns {number}
     */
    MovingAverageDelta.prototype.get = function () {
        var samples = this._samples;
        var denominatorDelta = (samples[1].denominator - samples[0].denominator) || Infinity;
        var numeratorDelta = samples[1].numerator - samples[0].numerator;
        return numeratorDelta / denominatorDelta;
    };
    /**
     * Put a sample and get rid of the older sample to maintain sample size of 2.
     * @param numerator
     * @param denominator
     */
    MovingAverageDelta.prototype.putSample = function (numerator, denominator) {
        var samples = this._samples;
        samples.shift();
        samples.push({ denominator: denominator, numerator: numerator });
    };
    return MovingAverageDelta;
}());
module.exports = MovingAverageDelta;

},{}],139:[function(require,module,exports){
'use strict';
/**
 * Monitor the network connection status to detect interruptions and handoffs.
 */
var NetworkMonitor = /** @class */ (function () {
    /**
     * Construct a {@link NetworkMonitor}.
     * @param {function} onNetworkChanged
     * @param {*} [options]
     */
    function NetworkMonitor(onNetworkChanged, options) {
        var _this = this;
        options = Object.assign({
            navigator: navigator,
            window: window,
        }, options);
        var nav = options.navigator;
        var connection = nav.connection || { type: null };
        var type = connection.type;
        var _a = connection.type ? {
            _events: {
                value: ['change', 'typechange']
            },
            _listener: {
                value: function () {
                    var networkChanged = type !== _this.type && _this.isOnline;
                    type = _this.type;
                    if (networkChanged) {
                        onNetworkChanged();
                    }
                }
            },
            _target: {
                value: connection
            }
        } : {
            _events: {
                value: ['online']
            },
            _listener: {
                value: onNetworkChanged
            },
            _target: {
                value: options.window
            }
        }, _events = _a._events, _listener = _a._listener, _target = _a._target;
        Object.defineProperties(this, {
            isOnline: {
                enumerable: true,
                get: function () {
                    return typeof nav.onLine === 'boolean'
                        ? nav.onLine
                        : true;
                }
            },
            type: {
                enumerable: true,
                get: function () {
                    return connection.type || null;
                }
            },
            _listener: _listener,
            _events: _events,
            _target: _target
        });
    }
    /**
     * Start the {@link NetworkMonitor}.
     */
    NetworkMonitor.prototype.start = function () {
        var _this = this;
        this._events.forEach(function (event) {
            _this._target.addEventListener(event, _this._listener);
        });
    };
    /**
     * Stop the {@link NetworkMonitor}.
     */
    NetworkMonitor.prototype.stop = function () {
        var _this = this;
        this._events.forEach(function (event) {
            _this._target.removeEventListener(event, _this._listener);
        });
    };
    return NetworkMonitor;
}());
module.exports = NetworkMonitor;

},{}],140:[function(require,module,exports){
/* eslint-disable no-console */
'use strict';
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var NullObserver = /** @class */ (function () {
    function NullObserver(callback) {
        Object.defineProperties(this, {
            _callback: {
                value: callback
            }
        });
    }
    NullObserver.prototype.observe = function () {
    };
    NullObserver.prototype.unobserve = function () {
    };
    NullObserver.prototype.makeVisible = function (videoEl) {
        var visibleEntry = this._makeFakeEntry(videoEl, true);
        this._callback([visibleEntry]);
    };
    NullObserver.prototype.makeInvisible = function (videoEl) {
        var invisibleEntry = this._makeFakeEntry(videoEl, false);
        this._callback([invisibleEntry]);
    };
    NullObserver.prototype._makeFakeEntry = function (videoElement, isIntersecting) {
        return { target: videoElement, isIntersecting: isIntersecting };
    };
    return NullObserver;
}());
var NullIntersectionObserver = /** @class */ (function (_super) {
    __extends(NullIntersectionObserver, _super);
    function NullIntersectionObserver() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return NullIntersectionObserver;
}(NullObserver));
var NullResizeObserver = /** @class */ (function (_super) {
    __extends(NullResizeObserver, _super);
    function NullResizeObserver() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    NullResizeObserver.prototype.resize = function (videoEl) {
        var entry = this._makeFakeEntry(videoEl, true);
        this._callback([entry]);
    };
    return NullResizeObserver;
}(NullObserver));
module.exports = { NullIntersectionObserver: NullIntersectionObserver, NullResizeObserver: NullResizeObserver, NullObserver: NullObserver };

},{}],141:[function(require,module,exports){
'use strict';
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var _a = require('../'), difference = _a.difference, flatMap = _a.flatMap;
var setSimulcastInMediaSection = require('./simulcast');
var ptToFixedBitrateAudioCodecName = {
    0: 'PCMU',
    8: 'PCMA'
};
/**
 * A payload type
 * @typedef {number} PT
 */
/**
 * An {@link AudioCodec} or {@link VideoCodec}
 * @typedef {AudioCodec|VideoCodec} Codec
 */
/**
 * Create a Codec Map for the given m= section.
 * @param {string} section - The given m= section
 * @returns {Map<Codec, Array<PT>>}
 */
function createCodecMapForMediaSection(section) {
    return Array.from(createPtToCodecName(secti