# Twix.js

[![MIT License][license-image]][license] [![Build Status][travis-image]][travis-url] [![Code Coverage][coveralls-image]][coveralls-url] [![Code Climate][code-climate-img]][code-climate-url] [![Dependencies][gemnasium-image]][gemnasium-url] [![Version][release-version-image]][release-url] [![NPM version][npm-version-image]][npm-url] ![Bower version][bower-version-image]

Twix is a comprehensive JS library for working with date ranges, and includes a customizable smart formatter. It's written in CoffeeScript and it depends on [Moment.js](http://momentjs.com/).

Some examples:

```js
var t = moment("1982-01-25T09:30").twix("1982-01-25T13:30");

t.format();  //=> Jan 25, 1982, 9:30 AM - 1:30 PM

t.isSame("day"); //=> true
t.humanizeLength(); //=> "4 hours"
t.count("days"); //=> 1
t.intersection(otherRange); //=> another range
```

See the [documentation][documentation-url] for more.

## Documentation

You can find comprehensive docs here:

**[Detailed documentation][documentation-url]**

**Breaking change in 0.9.0**: The `showDate` smart format option has been deprecated but also modified. It previously hid the date if the range spanned only one day, regardless of the day. I found that confusing, so you now have two options: a. hide the date with `hideDate: true` or b. use `implicitDate: true` to elide the date if it spans one day *and* that day is today. `showDate` has been aliased to `!implicitDate`, though that behavior is not consistent with the old behavior. If for some reason "hide the date if the range spans only one day" is a real use case for you that I just broke, please let me know.

## Building

If you want to build and test Twix for yourself, `make` wraps everything you need:

Command                | Function
-----------------------|---------
`make configure`       | Install dependencies (same as `npm install`)
`make` or `make build` | Compile `src/*.coffee` to `dist/*.js`
`make test`            | Run Mocha suite
`make lint`            | Linter
`make bench`           | Microbenchmarks

## Contributing

Patches are welcome!

 * Don't include your changes to the generated `.js` files in the patch; they're much harder to merge. I'll generate them when I cut the release.
 * Make sure you run the linter and the tests before submitting a PR. Use `make lint` and `make test`.
 * If you make a change that will need documentation, make the appropriate update to [docs](docs/docs.md). It will get published to the website on the next release.

## Changelog

[CHANGELOG][]

## Copyright and License

Copyright 2012-2015 Isaac Cambron and contributors. Distributed under the MIT License. See [LICENSE][] for details.

![Phasers to stun][phasers-image]

[documentation-url]: http://icambron.github.io/twix.js/docs.html

[license-image]: http://img.shields.io/badge/license-MIT-blue.svg?style=flat-square
[license]: LICENSE.md

[changelog]: CHANGELOG.md

[release-url]: https://github.com/icambron/twix.js/releases/latest
[release-version-image]: https://img.shields.io/github/release/icambron/twix.js.svg?style=flat-square
[npm-url]: https://npmjs.org/package/twix
[npm-version-image]: http://img.shields.io/npm/v/twix.svg?style=flat-square
[bower-version-image]: https://img.shields.io/bower/v/twix.svg?style=flat-square

[travis-url]: http://travis-ci.org/icambron/twix.js
[travis-image]: http://img.shields.io/travis/icambron/twix.js/master.svg?style=flat-square

[coveralls-url]: https://coveralls.io/github/icambron/twix.js
[coveralls-image]: https://img.shields.io/coveralls/icambron/twix.js/master.svg?style=flat-square

[code-climate-img]: https://img.shields.io/codeclimate/github/icambron/twix.js.svg?style=flat-square
[code-climate-url]: https://codeclimate.com/github/icambron/twix.js

[gemnasium-url]: https://gemnasium.com/icambron/twix.js
[gemnasium-image]: https://img.shields.io/gemnasium/icambron/twix.js.svg?style=flat-square

[phasers-image]: https://img.shields.io/badge/phasers-stun-brightgreen.svg?style=flat-square
