#!/usr/bin/env node
var minimist = require('minimist');
var extend = require('xtend');
var typings_1 = require('../typings');
var cli_1 = require('../utils/cli');
var config_1 = require('../utils/config');
var args = minimist(process.argv.slice(2), {
    boolean: ['verbose', 'help', 'upgrade'],
    alias: {
        verbose: ['v'],
        help: ['h'],
        upgrade: ['u']
    }
});
if (args.help) {
    console.log("\n" + config_1.PROJECT_NAME + " init\n\nOptions: [--upgrade]\n");
    process.exit(0);
}
var verbose = args.verbose;
var options = extend(args, { cwd: process.cwd() });
cli_1.loader(typings_1.init(options), { verbose: verbose });
//# sourceMappingURL=typings-init.js.map