#!/usr/bin/env node
var minimist = require('minimist');
var cli_1 = require('../utils/cli');
var config_1 = require('../utils/config');
var dependencies_1 = require('../lib/dependencies');
var args = minimist(process.argv.slice(2), {
    boolean: ['verbose', 'help', 'production'],
    alias: {
        verbose: ['v'],
        production: ['p'],
        help: ['h']
    }
});
if (args.help) {
    console.log("\n" + config_1.PROJECT_NAME + " ls [--ambient] [--production]\n\nAliases: la, ll, list\n");
    process.exit(0);
}
var cwd = process.cwd();
var verbose = args.verbose;
var dev = !args.production;
cli_1.loader(dependencies_1.resolveTypeDependencies({ cwd: cwd, ambient: true, dev: dev }), { verbose: verbose })
    .then(function (tree) {
    console.log(cli_1.archifyDependencyTree(tree));
});
//# sourceMappingURL=typings-list.js.map