#!/usr/bin/env node
var minimist = require('minimist');
var columnify = require('columnify');
var typings_1 = require('../typings');
var cli_1 = require('../utils/cli');
var config_1 = require('../utils/config');
var args = minimist(process.argv.slice(2), {
    boolean: ['verbose', 'help', 'ambient'],
    string: ['name', 'source'],
    alias: {
        name: ['n'],
        source: ['s'],
        offset: ['o'],
        limit: ['l'],
        verbose: ['v'],
        help: ['h'],
        ambient: ['A']
    }
});
if (args.help) {
    console.log("\n" + config_1.PROJECT_NAME + " search [query] [--ambient]\n\nOptions: [--name] [--source] [--offset] [--limit]\n");
    process.exit(0);
}
var verbose = args.verbose, name = args.name, source = args.source, limit = args.limit, offset = args.offset, ambient = args.ambient;
cli_1.loader(typings_1.search(args._[0], { name: name, source: source, limit: limit, offset: offset, ambient: ambient }), { verbose: verbose })
    .then(function (result) {
    var results = result.results, total = result.total;
    if (total === 0) {
        console.log("No results found searching " + (ambient ? 'ambient' : 'module') + " definitions");
        return;
    }
    if (results.length === total) {
        console.log("Showing " + total + " results...");
    }
    else {
        console.log("Showing " + results.length + " of " + total + " results...");
    }
    console.log();
    console.log(columnify(results));
});
//# sourceMappingURL=typings-search.js.map