#!/usr/bin/env node
var minimist = require('minimist');
var wordwrap = require('wordwrap');
var child_process_1 = require('child_process');
var path_1 = require('path');
var updateNotifier = require('update-notifier');
var typings_1 = require('../typings');
var config_1 = require('../utils/config');
var insight_1 = require('../utils/insight');
var pkg = require('../../package.json');
var ALIASES = {
    i: 'install',
    in: 'install',
    install: 'install',
    r: 'uninstall',
    rm: 'uninstall',
    remove: 'uninstall',
    uninstall: 'uninstall',
    init: 'init',
    ls: 'list',
    ll: 'list',
    la: 'list',
    list: 'list',
    bundle: 'bundle',
    search: 'search'
};
var args = minimist(process.argv.slice(2), {
    boolean: ['version', 'cache'],
    alias: {
        version: ['v'],
        cache: ['c']
    },
    stopEarly: true
});
updateNotifier({ pkg: pkg }).notify();
if (insight_1.default.optOut == null) {
    insight_1.default.track('downloaded');
    insight_1.default.askPermission(null, function () { return handle(args); });
}
else {
    handle(args);
}
function handle(args) {
    insight_1.default.track.apply(insight_1.default, ['cli'].concat(minimist(process.argv.slice(2))._.slice(0, 2)));
    if (args.version) {
        console.log(typings_1.VERSION);
        process.exit(0);
    }
    if (args.cache) {
        console.log(config_1.CACHE_DIR);
        process.exit(0);
    }
    var command = ALIASES[args._[0]];
    if (typeof command === 'string') {
        var bin = path_1.join(__dirname, "typings-" + command + ".js");
        var argv = [bin].concat(args._.slice(1));
        var proc = child_process_1.spawn(process.execPath, argv, { stdio: 'inherit' });
        proc.on('close', function (code) { return process.exit(code); });
        proc.on('error', function (err) {
            if (err.code === 'ENOENT') {
                console.error("\"" + bin + "\" does not exist, try --help");
            }
            else if (err.code == 'EACCES') {
                console.error("\"" + bin + "\" is not executable, try chmod or run with root");
            }
            process.exit(1);
        });
        return;
    }
    var wrap = wordwrap(4, 80);
    console.log("\nUsage: " + config_1.PROJECT_NAME + " <command>\n\nCommands:\n" + wrap(Object.keys(ALIASES).sort().join(', ')) + "\n\n" + config_1.PROJECT_NAME + " <command> -h            Get help for <command>\n" + config_1.PROJECT_NAME + " <command> --no-insight  Disable insights for <command>\n\n" + config_1.PROJECT_NAME + " --version               Print the CLI version\n" + config_1.PROJECT_NAME + " --cache                 Print the path to the cache directory\n\n" + config_1.PROJECT_NAME + "@" + typings_1.VERSION + " " + path_1.join(__dirname, '../..') + "\n");
}
//# sourceMappingURL=typings.js.map