export declare type DependencyString = string;
export interface Overrides {
    [dependency: string]: string;
}
export declare type Browser = string | Overrides;
export interface ConfigJson {
    main?: string;
    browser?: Browser;
    typings?: string;
    browserTypings?: string | Browser;
    name?: string;
    author?: string;
    description?: string;
    bugs?: string;
    homepage?: string;
    dependencies?: Dependencies;
    devDependencies?: Dependencies;
    ambientDependencies?: Dependencies;
    ambientDevDependencies?: Dependencies;
}
export interface Dependencies {
    [name: string]: DependencyString | DependencyString[];
}
export interface Dependency {
    type: string;
    raw: string;
    location: string;
    meta?: any;
}
export interface DependencyTree {
    name?: string;
    version?: string;
    main?: string;
    browser?: Browser;
    typings?: string;
    browserTypings?: Browser;
    parent?: DependencyTree;
    src: string;
    raw: string;
    dependencies: DependencyBranch;
    devDependencies: DependencyBranch;
    ambientDependencies: DependencyBranch;
    ambientDevDependencies: DependencyBranch;
}
export interface DependencyBranch {
    [name: string]: DependencyTree;
}
