var Promise = require('any-promise');
var querystring_1 = require('querystring');
var pick = require('object-pick');
var fs_1 = require('../utils/fs');
var REGISTRY_URL = 'https://api.typings.org';
exports.VALID_SOURCES = {
    dt: 'DefinitelyTyped',
    npm: 'NPM',
    github: 'GitHub',
    bower: 'Bower',
    ambient: 'Ambient',
    common: 'Common'
};
function search(options) {
    if (options.source && !isValidSource(options.source)) {
        return Promise.reject(new TypeError("Invalid registry source: " + options.source));
    }
    var query = pick(options, ['query', 'name', 'source', 'offset', 'limit', 'ambient']);
    return fs_1.readJsonFrom(REGISTRY_URL + "/search?" + querystring_1.stringify(query));
}
exports.search = search;
function getVersions(source, name, version) {
    if (!isValidSource(source)) {
        return Promise.reject(new TypeError("Invalid registry source: " + source));
    }
    var sourceParam = encodeURIComponent(source);
    var nameParam = encodeURIComponent(name);
    if (version == null) {
        return fs_1.readJsonFrom(REGISTRY_URL + "/versions/" + sourceParam + "/" + nameParam);
    }
    return fs_1.readJsonFrom(REGISTRY_URL + "/versions/" + sourceParam + "/" + nameParam + "/" + encodeURIComponent(version));
}
exports.getVersions = getVersions;
function isRegistryPath(path) {
    return path.indexOf(':') === -1;
}
exports.isRegistryPath = isRegistryPath;
function parseRegistryPath(dep) {
    var _a = dep.split('@'), name = _a[0], version = _a[1];
    return { name: name, version: version };
}
exports.parseRegistryPath = parseRegistryPath;
function isValidSource(source) {
    return exports.VALID_SOURCES.hasOwnProperty(source);
}
//# sourceMappingURL=registry.js.map