import Promise = require('any-promise');
import inquirer = require('inquirer');
import { BaseError } from 'make-error-cause';
import { DependencyTree } from '../interfaces/main';
export interface PrintOptions {
    verbose: boolean;
}
export declare function loader<T>(promise: T | Promise<T>, options: PrintOptions): Promise<T>;
export declare function logError(message: string, prefix?: string): string;
export declare function handleError(error: BaseError, options: PrintOptions): any;
export declare function inquire(questions: inquirer.Questions): Promise<{}>;
export interface ArchifyOptions {
    name?: string;
}
export declare function archifyDependencyTree(tree: DependencyTree, options?: ArchifyOptions): string;
