var logUpdate = require('log-update');
var spinner = require('elegant-spinner');
var chalk = require('chalk');
var Promise = require('any-promise');
var promise_finally_1 = require('promise-finally');
var inquirer = require('inquirer');
var archy = require('archy');
var os = require('os');
var config_1 = require('../utils/config');
var pkg = require('../../package.json');
function loader(promise, options) {
    var end = function () { return undefined; };
    if (process.stdout.isTTY) {
        var frame = spinner();
        var update = function () { return logUpdate.stderr(frame()); };
        var interval = setInterval(update, 50);
        end = function () {
            clearInterval(interval);
            logUpdate.stderr.clear();
            logUpdate.stderr.done();
        };
    }
    return promise_finally_1.default(Promise.resolve(promise), end)
        .catch(function (err) { return handleError(err, options); });
}
exports.loader = loader;
function logError(message, prefix) {
    var result = '';
    for (var _i = 0, _a = message.split(/\r?\n/g); _i < _a.length; _i++) {
        var line = _a[_i];
        result += chalk.bgBlack.white(config_1.PROJECT_NAME) + " " + chalk.bgBlack.red('ERR!') + " " + (prefix ? chalk.magenta(prefix + " ") : '') + line + "\n";
    }
    return result;
}
exports.logError = logError;
function handleError(error, options) {
    var message = '';
    var cause = error;
    message += logError(error.message, 'message');
    while (cause = cause.cause) {
        message += logError(cause.message, 'caused by');
    }
    if (options.verbose && error.stack) {
        message += '\n';
        message += logError(error.stack, 'stack');
    }
    message += '\n';
    message += logError(process.cwd(), 'cwd');
    message += logError(os.type() + " " + os.release(), 'system');
    message += logError(process.argv.map(JSON.stringify).join(' '), 'command');
    message += logError(process.version, 'node -v');
    message += logError(pkg.version, config_1.PROJECT_NAME + " -v");
    if (error.code) {
        message += logError(error.code, 'code');
    }
    message += '\n';
    message += logError('If you need help, you may report this error at:');
    message += logError("  <" + config_1.ISSUES_HOMEPAGE + ">");
    console.error(message);
    process.exit(1);
}
exports.handleError = handleError;
function inquire(questions) {
    return new Promise(function (resolve) {
        inquirer.prompt(questions, resolve);
    });
}
exports.inquire = inquire;
function archifyDependencyTree(tree, options) {
    if (options === void 0) { options = {}; }
    var result = {
        label: options.name,
        nodes: []
    };
    function traverse(result, tree) {
        var nodes = result.nodes;
        for (var _i = 0, _a = Object.keys(tree.dependencies).sort(); _i < _a.length; _i++) {
            var name_1 = _a[_i];
            nodes.push(traverse({
                label: name_1,
                nodes: []
            }, tree.dependencies[name_1]));
        }
        for (var _b = 0, _c = Object.keys(tree.devDependencies).sort(); _b < _c.length; _b++) {
            var name_2 = _c[_b];
            nodes.push(traverse({
                label: name_2 + " " + chalk.gray('(dev)'),
                nodes: []
            }, tree.devDependencies[name_2]));
        }
        for (var _d = 0, _e = Object.keys(tree.ambientDependencies).sort(); _d < _e.length; _d++) {
            var name_3 = _e[_d];
            nodes.push(traverse({
                label: name_3 + " " + chalk.gray('(ambient)'),
                nodes: []
            }, tree.ambientDependencies[name_3]));
        }
        for (var _f = 0, _g = Object.keys(tree.ambientDevDependencies).sort(); _f < _g.length; _f++) {
            var name_4 = _g[_f];
            nodes.push(traverse({
                label: name_4 + " " + chalk.gray('(ambient dev)'),
                nodes: []
            }, tree.ambientDevDependencies[name_4]));
        }
        return result;
    }
    var archyTree = traverse(result, tree);
    if (archyTree.nodes.length === 0) {
        archyTree.nodes.push(chalk.gray('(No dependencies)'));
    }
    return archy(archyTree);
}
exports.archifyDependencyTree = archifyDependencyTree;
//# sourceMappingURL=cli.js.map