import * as fs from 'graceful-fs';
import Promise = require('any-promise');
import lockfile = require('lockfile');
import tch = require('touch');
import { ConfigJson } from '../interfaces/main';
import { CompiledOutput } from '../lib/compile';
export declare type Stats = fs.Stats;
export declare const touch: (path: string, options?: tch.Options) => Promise<void>;
export declare const stat: (path: string) => Promise<Stats>;
export declare const readFile: (path: string, encoding: string) => Promise<string>;
export declare const writeFile: (path: string, contents: string | Buffer) => Promise<void>;
export declare const mkdirp: (path: string) => Promise<void>;
export declare const unlink: (path: string) => Promise<void>;
export declare const lock: (path: string, options?: lockfile.Options) => Promise<void>;
export declare const unlock: (path: string) => Promise<void>;
export declare const rimraf: (path: string) => Promise<void>;
export declare function isFile(path: string): Promise<boolean>;
export declare function readJson(path: string, allowEmpty?: boolean): Promise<any>;
export declare function writeJson(path: string, json: any, indent?: string | number, eol?: string): Promise<void>;
export declare function readConfig(path: string): Promise<ConfigJson>;
export declare function readConfigFrom(path: string): Promise<ConfigJson>;
export declare function parseConfig(config: ConfigJson, path: string): ConfigJson;
export declare function readHttp(url: string): Promise<string>;
export declare function readFileFrom(from: string): Promise<string>;
export declare function readJsonFrom(from: string, allowEmpty?: boolean): Promise<any>;
export declare function stringifyJson(json: any, indent?: number | string, eol?: string): string;
export declare function parseJson(contents: string, path: string, allowEmpty: boolean): any;
export declare function transformFile(path: string, transform: (contents: string) => string | Promise<string>): Promise<void>;
export declare function transformJson<T>(path: string, transform: (json: T) => T, allowEmpty?: boolean): Promise<void>;
export declare function transformConfig(cwd: string, transform: (config: ConfigJson) => ConfigJson): Promise<void>;
export declare function transformDtsFile(path: string, transform: (typings: string[]) => string[]): Promise<void>;
export interface DefinitionOptions {
    cwd: string;
    name: string;
    ambient: boolean;
}
export declare function writeDependency(output: CompiledOutput, options: DefinitionOptions): Promise<CompiledOutput>;
export declare function removeDependency(options: DefinitionOptions): Promise<any>;
export declare function getTypingsLocation(options: {
    cwd: string;
}): {
    typingsDir: string;
    mainDtsFile: string;
    browserDtsFile: string;
};
export declare function getDependencyLocation(options: DefinitionOptions): {
    mainFile: string;
    browserFile: string;
    mainPath: string;
    browserPath: string;
    mainDtsFile: string;
    browserDtsFile: string;
};
