var fs = require('graceful-fs');
var Promise = require('any-promise');
var thenify = require('thenify');
var stripBom = require('strip-bom');
var parse = require('parse-json');
var popsicle = require('popsicle');
var popsicleStatus = require('popsicle-status');
var detectIndent = require('detect-indent');
var sortKeys = require('sort-keys');
var mdp = require('mkdirp');
var uniq = require('array-uniq');
var lockfile = require('lockfile');
var rmrf = require('rimraf');
var popsicleProxy = require('popsicle-proxy-agent');
var promise_finally_1 = require('promise-finally');
var tch = require('touch');
var os_1 = require('os');
var path_1 = require('path');
var template = require('string-template');
var config_1 = require('./config');
var path_2 = require('./path');
var references_1 = require('./references');
var rc_1 = require('./rc');
var debug_1 = require('./debug');
var pkg = require('../../package.json');
var mainTypingsDir = path_1.join(config_1.TYPINGS_DIR, 'main/definitions');
var browserTypingsDir = path_1.join(config_1.TYPINGS_DIR, 'browser/definitions');
var ambientMainTypingsDir = path_1.join(config_1.TYPINGS_DIR, 'main/ambient');
var ambientBrowserTypingsDir = path_1.join(config_1.TYPINGS_DIR, 'browser/ambient');
exports.touch = thenify(tch);
exports.stat = thenify(fs.stat);
exports.readFile = thenify(fs.readFile);
exports.writeFile = thenify(fs.writeFile);
exports.mkdirp = thenify(mdp);
exports.unlink = thenify(fs.unlink);
exports.lock = thenify(lockfile.lock);
exports.unlock = thenify(lockfile.unlock);
exports.rimraf = thenify(rmrf);
function isFile(path) {
    return exports.stat(path).then(function (stat) { return stat.isFile(); }, function () { return false; });
}
exports.isFile = isFile;
function readJson(path, allowEmpty) {
    return exports.readFile(path, 'utf8')
        .then(stripBom)
        .then(function (contents) { return parseJson(contents, path, allowEmpty); });
}
exports.readJson = readJson;
function writeJson(path, json, indent, eol) {
    return exports.writeFile(path, stringifyJson(json, indent, eol));
}
exports.writeJson = writeJson;
function readConfig(path) {
    return readJson(path, true).then(function (data) { return parseConfig(data, path); });
}
exports.readConfig = readConfig;
function readConfigFrom(path) {
    return readJsonFrom(path, true).then(function (data) { return parseConfig(data, path); });
}
exports.readConfigFrom = readConfigFrom;
function parseConfig(config, path) {
    return config;
}
exports.parseConfig = parseConfig;
function readHttp(url) {
    var proxy = rc_1.default.proxy, httpProxy = rc_1.default.httpProxy, httpsProxy = rc_1.default.httpsProxy, noProxy = rc_1.default.noProxy, rejectUnauthorized = rc_1.default.rejectUnauthorized, ca = rc_1.default.ca, key = rc_1.default.key, cert = rc_1.default.cert, userAgent = rc_1.default.userAgent;
    return popsicle.get({
        url: url,
        headers: {
            'User-Agent': template(userAgent, {
                nodeVersion: process.version,
                platform: process.platform,
                arch: process.arch,
                typingsVersion: pkg.version
            })
        },
        options: {
            ca: ca,
            key: key,
            cert: cert,
            rejectUnauthorized: rejectUnauthorized
        },
        use: [
            popsicle.plugins.headers(),
            popsicle.plugins.unzip(),
            popsicle.plugins.concatStream('string')
        ]
    })
        .use(popsicleProxy({ proxy: proxy, httpProxy: httpProxy, httpsProxy: httpsProxy, noProxy: noProxy }))
        .use(popsicleStatus(200))
        .then(function (response) {
        debug_1.default('http response', response.toJSON());
        return response.body;
    });
}
exports.readHttp = readHttp;
function readFileFrom(from) {
    return path_2.isHttp(from) ? readHttp(from) : exports.readFile(from, 'utf8');
}
exports.readFileFrom = readFileFrom;
function readJsonFrom(from, allowEmpty) {
    return readFileFrom(from)
        .then(stripBom)
        .then(function (contents) { return parseJson(contents, from, allowEmpty); });
}
exports.readJsonFrom = readJsonFrom;
function stringifyJson(json, indent, eol) {
    if (eol === void 0) { eol = os_1.EOL; }
    return JSON.stringify(json, null, indent || 2).replace(/\n/g, eol) + eol;
}
exports.stringifyJson = stringifyJson;
function parseJson(contents, path, allowEmpty) {
    if (contents === '' && allowEmpty) {
        return {};
    }
    return parse(contents, null, path);
}
exports.parseJson = parseJson;
function transformFile(path, transform) {
    function handle(contents) {
        return Promise.resolve(transform(contents))
            .then(function (contents) { return exports.writeFile(path, contents); });
    }
    var lockfile = path + ".lock";
    var lockOptions = { wait: 250, retries: 25, stale: 60000 };
    var result = exports.lock(lockfile, lockOptions)
        .then(function () {
        return exports.readFile(path, 'utf8');
    })
        .then(function (contents) { return handle(contents); }, function () { return handle(undefined); });
    return promise_finally_1.default(result, function () { return exports.unlock(lockfile); });
}
exports.transformFile = transformFile;
function transformJson(path, transform, allowEmpty) {
    return transformFile(path, function (contents) {
        var indent = contents ? detectIndent(contents).indent : undefined;
        var json = contents ? parseJson(contents, path, allowEmpty) : undefined;
        var eol = contents ? detectEOL(contents) : undefined;
        return Promise.resolve(transform(json))
            .then(function (json) { return stringifyJson(json, indent, eol); });
    });
}
exports.transformJson = transformJson;
function transformConfig(cwd, transform) {
    var path = path_1.join(cwd, config_1.CONFIG_FILE);
    return transformJson(path, function (config) {
        if (config === void 0) { config = {}; }
        return Promise.resolve(transform(parseConfig(config, path)))
            .then(function (config) {
            if (config.dependencies) {
                config.dependencies = sortKeys(config.dependencies);
            }
            if (config.devDependencies) {
                config.devDependencies = sortKeys(config.devDependencies);
            }
            if (config.ambientDependencies) {
                config.ambientDependencies = sortKeys(config.ambientDependencies);
            }
            if (config.ambientDevDependencies) {
                config.ambientDevDependencies = sortKeys(config.ambientDevDependencies);
            }
            return config;
        });
    }, true);
}
exports.transformConfig = transformConfig;
function transformDtsFile(path, transform) {
    var cwd = path_1.dirname(path);
    return transformFile(path, function (contents) {
        var typings = references_1.parseReferences(contents, cwd);
        return Promise.resolve(transform(typings))
            .then(function (typings) { return references_1.stringifyReferences(uniq(typings).sort(), cwd); });
    });
}
exports.transformDtsFile = transformDtsFile;
function writeDependency(output, options) {
    var location = getDependencyLocation(options);
    function create(path, file, contents, dtsFile) {
        return exports.mkdirp(path)
            .then(function () { return exports.writeFile(file, contents); })
            .then(function () { return transformDtsFile(dtsFile, function (typings) { return typings.concat([file]); }); });
    }
    return Promise.all([
        create(location.mainPath, location.mainFile, output.main, location.mainDtsFile),
        create(location.browserPath, location.browserFile, output.browser, location.browserDtsFile)
    ]).then(function () { return output; });
}
exports.writeDependency = writeDependency;
function removeDependency(options) {
    var location = getDependencyLocation(options);
    function remove(path, file, dtsFile) {
        return promise_finally_1.default(exports.rimraf(path), function () {
            return transformDtsFile(dtsFile, function (typings) { return typings.filter(function (x) { return x !== file; }); });
        });
    }
    return Promise.all([
        remove(location.mainPath, location.mainFile, location.mainDtsFile),
        remove(location.browserPath, location.browserFile, location.browserDtsFile)
    ]).then(function () { return undefined; });
}
exports.removeDependency = removeDependency;
function getTypingsLocation(options) {
    var typingsDir = path_1.join(options.cwd, config_1.TYPINGS_DIR);
    var mainDtsFile = path_1.join(typingsDir, config_1.DTS_MAIN_FILE);
    var browserDtsFile = path_1.join(typingsDir, config_1.DTS_BROWSER_FILE);
    return { typingsDir: typingsDir, mainDtsFile: mainDtsFile, browserDtsFile: browserDtsFile };
}
exports.getTypingsLocation = getTypingsLocation;
function getDependencyLocation(options) {
    var mainDir = options.ambient ? ambientMainTypingsDir : mainTypingsDir;
    var browserDir = options.ambient ? ambientBrowserTypingsDir : browserTypingsDir;
    var _a = getTypingsLocation(options), typingsDir = _a.typingsDir, mainDtsFile = _a.mainDtsFile, browserDtsFile = _a.browserDtsFile;
    var mainPath = path_1.join(options.cwd, mainDir, options.name);
    var browserPath = path_1.join(options.cwd, browserDir, options.name);
    var mainFile = path_1.join(mainPath, path_2.toDefinition(options.name));
    var browserFile = path_1.join(browserPath, path_2.toDefinition(options.name));
    return {
        mainFile: mainFile,
        browserFile: browserFile,
        mainPath: mainPath,
        browserPath: browserPath,
        mainDtsFile: mainDtsFile,
        browserDtsFile: browserDtsFile
    };
}
exports.getDependencyLocation = getDependencyLocation;
function detectEOL(contents) {
    var match = contents.match(/\r\n|\r|\n/);
    return match ? match[0] : undefined;
}
//# sourceMappingURL=fs.js.map