var path_1 = require('path');
var url_1 = require('url');
var isAbsolute = require('is-absolute');
function isHttp(url) {
    return /^https?\:\/\//i.test(url);
}
exports.isHttp = isHttp;
function isDefinition(path) {
    return /\.d\.ts$/.test(path);
}
exports.isDefinition = isDefinition;
function isModuleName(value) {
    return !isHttp(value) && !isAbsolute(value) && value.charAt(0) !== '.';
}
exports.isModuleName = isModuleName;
function normalizeSlashes(path) {
    return path.replace(/\\/g, '/');
}
exports.normalizeSlashes = normalizeSlashes;
function inferDefinitionName(location) {
    if (isDefinition(location)) {
        var pathname = location;
        if (isHttp(location)) {
            pathname = url_1.parse(location).pathname;
        }
        return sanitizeDefinitionName(path_1.basename(pathname, '.d.ts'));
    }
}
exports.inferDefinitionName = inferDefinitionName;
function sanitizeDefinitionName(name) {
    if (name == null) {
        return name;
    }
    return name.replace(/^(?:typings|typed)\-|\-(?:typings|typed)$/, '');
}
exports.sanitizeDefinitionName = sanitizeDefinitionName;
function resolveFrom(from, to) {
    if (isHttp(to)) {
        return to;
    }
    return isHttp(from) ? url_1.resolve(from, to) : path_1.resolve(path_1.dirname(from), to);
}
exports.resolveFrom = resolveFrom;
function relativeTo(from, to) {
    if (isHttp(from)) {
        if (isHttp(to)) {
            var fromUrl = url_1.parse(from);
            var toUrl = url_1.parse(to);
            if (toUrl.auth !== fromUrl.auth || toUrl.host !== fromUrl.host) {
                return to;
            }
            var relativeUrl = relativeTo(fromUrl.pathname, toUrl.pathname);
            if (toUrl.search) {
                relativeUrl += toUrl.search;
            }
            if (toUrl.hash) {
                relativeUrl += toUrl.hash;
            }
            return relativeUrl;
        }
        return to;
    }
    return path_1.relative(path_1.dirname(from), to);
}
exports.relativeTo = relativeTo;
function toDefinition(name) {
    return name + ".d.ts";
}
exports.toDefinition = toDefinition;
function fromDefinition(name) {
    return name.replace(/\.d\.ts$/, '');
}
exports.fromDefinition = fromDefinition;
function normalizeToDefinition(path) {
    if (isDefinition(path)) {
        return path;
    }
    var ext = path_1.extname(path);
    return toDefinition(ext ? path.slice(0, -ext.length) : path);
}
exports.normalizeToDefinition = normalizeToDefinition;
//# sourceMappingURL=path.js.map