#!/usr/bin/env node
"use strict";
var minimist = require('minimist');
var extend = require('xtend');
var path_1 = require('path');
var typings_1 = require('../typings');
var cli_1 = require('../utils/cli');
var fs_1 = require('../utils/fs');
var config_1 = require('../utils/config');
var args = minimist(process.argv.slice(2), {
    boolean: ['verbose', 'browser', 'name', 'help'],
    string: ['out', 'source', 'name'],
    alias: {
        source: ['s'],
        name: ['n'],
        browser: ['b'],
        verbose: ['v'],
        out: ['o'],
        help: ['h']
    }
});
if (args.help) {
    console.log("\n" + config_1.PROJECT_NAME + " bundle --name [string]\n\nOptions: [--browser] [--out] [--source]\n");
    process.exit(0);
}
var cwd = process.cwd();
var verbose = args.verbose;
var options = extend({ source: cwd }, args);
cli_1.loader(typings_1.bundle(options), { verbose: verbose })
    .then(function (output) {
    var contents = options.browser ? output.browser : output.main;
    if (options.out) {
        return cli_1.loader(fs_1.writeFile(path_1.resolve(cwd, options.out), contents), options);
    }
    process.stdout.write(contents);
});
//# sourceMappingURL=typings-bundle.js.map