#!/usr/bin/env node
"use strict";
var minimist = require('minimist');
var typings_1 = require('../typings');
var cli_1 = require('../utils/cli');
var config_1 = require('../utils/config');
var args = minimist(process.argv.slice(2), {
    boolean: ['save', 'saveDev', 'ambient', 'verbose', 'help'],
    alias: {
        save: ['S'],
        saveDev: ['D', 'save-dev'],
        name: ['n'],
        ambient: ['A'],
        verbose: ['v'],
        help: ['h']
    }
});
if (args.help) {
    console.log("\n" + config_1.PROJECT_NAME + " uninstall <pkg> [--save|--save-dev] [--ambient]\n\nAliases: r, rm, remove, un\n");
    process.exit(0);
}
var cwd = process.cwd();
var save = args.save, saveDev = args.saveDev, ambient = args.ambient, verbose = args.verbose;
if (args._.length) {
    cli_1.loader(typings_1.uninstallDependency(args._[0], { cwd: cwd, save: save, saveDev: saveDev, ambient: ambient }), { verbose: verbose });
}
//# sourceMappingURL=typings-uninstall.js.map