"use strict";
var Promise = require('any-promise');
var dependencies_1 = require('./lib/dependencies');
var compile_1 = require('./lib/compile');
function bundle(options) {
    var cwd = options.source;
    return dependencies_1.resolveAllDependencies({ cwd: cwd, dev: false, ambient: false })
        .then(function (tree) {
        var name = options.name || tree.name;
        if (name == null) {
            return Promise.reject(new TypeError('Unable to infer typings name from project. Use the `--name` flag to specify it manually'));
        }
        return compile_1.default(tree, { cwd: cwd, name: name, ambient: false, meta: true });
    });
}
exports.bundle = bundle;
//# sourceMappingURL=bundle.js.map