"use strict";
var extend = require('xtend');
var Promise = require('any-promise');
var path_1 = require('path');
var dependencies_1 = require('./lib/dependencies');
var compile_1 = require('./lib/compile');
var find_1 = require('./utils/find');
var fs_1 = require('./utils/fs');
var parse_1 = require('./utils/parse');
function install(options) {
    return dependencies_1.resolveTypeDependencies({ cwd: options.cwd, dev: !options.production, ambient: true })
        .then(function (tree) {
        var cwd = path_1.dirname(tree.src);
        var queue = [];
        function addToQueue(deps, ambient) {
            for (var _i = 0, _a = Object.keys(deps); _i < _a.length; _i++) {
                var name_1 = _a[_i];
                var tree_1 = deps[name_1];
                queue.push(installDependencyTree(tree_1, { cwd: cwd, name: name_1, ambient: ambient, meta: true }));
            }
        }
        addToQueue(tree.dependencies, false);
        addToQueue(tree.devDependencies, false);
        addToQueue(tree.ambientDependencies, true);
        addToQueue(tree.ambientDevDependencies, true);
        return Promise.all(queue)
            .then(function (installed) {
            if (installed.length === 0) {
                var _a = fs_1.getTypingsLocation({ cwd: cwd }), typingsDir = _a.typingsDir, mainDtsFile_1 = _a.mainDtsFile, browserDtsFile_1 = _a.browserDtsFile;
                return fs_1.mkdirp(typingsDir)
                    .then(function () {
                    return Promise.all([
                        fs_1.touch(mainDtsFile_1, {}),
                        fs_1.touch(browserDtsFile_1, {})
                    ]);
                });
            }
        })
            .then(function () { return ({ tree: tree }); });
    });
}
exports.install = install;
function installDependency(dependency, options) {
    if (!options.name) {
        return Promise.reject(new TypeError('You must specify a name for the dependency'));
    }
    return find_1.findProject(options.cwd)
        .then(function (cwd) { return installTo(dependency, extend(options, { cwd: cwd })); }, function () { return installTo(dependency, options); });
}
exports.installDependency = installDependency;
function installTo(location, options) {
    var dependency = parse_1.parseDependency(location);
    return dependencies_1.resolveDependency(dependency, options)
        .then(function (tree) {
        return installDependencyTree(tree, {
            cwd: options.cwd,
            name: options.name,
            ambient: options.ambient,
            meta: true
        })
            .then(function (result) {
            return writeToConfig(dependency, options).then(function () { return result; });
        });
    });
}
function installDependencyTree(tree, options) {
    return compile_1.default(tree, options).then(function (result) { return fs_1.writeDependency(result, options); });
}
function writeToConfig(dependency, options) {
    if (options.save || options.saveDev) {
        var raw_1 = dependency.raw;
        return fs_1.transformConfig(options.cwd, function (config) {
            if (options.save) {
                if (options.ambient) {
                    config.ambientDependencies = extend(config.ambientDependencies, (_a = {}, _a[options.name] = raw_1, _a));
                }
                else {
                    config.dependencies = extend(config.dependencies, (_b = {}, _b[options.name] = raw_1, _b));
                }
            }
            else if (options.saveDev) {
                if (options.ambient) {
                    config.ambientDevDependencies = extend(config.ambientDevDependencies, (_c = {}, _c[options.name] = raw_1, _c));
                }
                else {
                    config.devDependencies = extend(config.devDependencies, (_d = {}, _d[options.name] = raw_1, _d));
                }
            }
            return config;
            var _a, _b, _c, _d;
        });
    }
    return Promise.resolve();
}
//# sourceMappingURL=install.js.map