import Promise = require('any-promise');
import { DependencyTree } from '../interfaces/main';
export interface Options {
    cwd: string;
    name: string;
    ambient: boolean;
    meta: boolean;
}
export interface ReferenceMap {
    [path: string]: Array<{
        name: string;
        main: boolean;
        browser: boolean;
    }>;
}
export interface CompiledOutput {
    tree: DependencyTree;
    main: string;
    browser: string;
    references: ReferenceMap;
}
export default function compile(tree: DependencyTree, options: Options): Promise<CompiledOutput>;
