import Promise = require('any-promise');
export declare const VALID_SOURCES: {
    [source: string]: string;
};
export interface SearchOptions {
    query?: string;
    name?: string;
    source?: string;
    offset?: string;
    limit?: string;
    ambient?: boolean;
}
export interface SearchResults {
    total: number;
    results: Array<{
        name: string;
        source: string;
        homepage: string;
        description: string;
    }>;
}
export declare function search(options: SearchOptions): Promise<SearchResults>;
export interface ProjectVersion {
    version: string;
    description: string;
    compiler: string;
    location: string;
}
export declare function getVersions(source: string, name: string, version?: string): Promise<{
    versions: ProjectVersion[];
}>;
export declare function isRegistryPath(path: string): boolean;
export declare function parseRegistryPath(dep: string): {
    name: string;
    version: string;
};
