"use strict";
var extend = require('xtend');
var fs_1 = require('./utils/fs');
var find_1 = require('./utils/find');
function uninstallDependency(name, options) {
    var ambient = options.ambient;
    function uninstall(options) {
        return fs_1.removeDependency(options).then(function () { return writeToConfig(name, options); });
    }
    return find_1.findProject(options.cwd)
        .then(function (cwd) { return uninstall(extend(options, { cwd: cwd, name: name, ambient: ambient })); }, function () { return uninstall(extend(options, { name: name, ambient: ambient })); });
}
exports.uninstallDependency = uninstallDependency;
function writeToConfig(name, options) {
    if (options.save || options.saveDev) {
        return fs_1.transformConfig(options.cwd, function (config) {
            if (options.save) {
                if (options.ambient) {
                    if (config.ambientDependencies) {
                        delete config.ambientDependencies[name];
                    }
                }
                else {
                    if (config.dependencies) {
                        delete config.dependencies[name];
                    }
                }
            }
            if (options.saveDev) {
                if (options.ambient) {
                    if (config.ambientDevDependencies) {
                        delete config.ambientDevDependencies[name];
                    }
                }
                else {
                    if (config.devDependencies) {
                        delete config.devDependencies[name];
                    }
                }
            }
            return config;
        });
    }
}
//# sourceMappingURL=uninstall.js.map